// Copyright © 2019 - 2022 Dell Inc. or its subsidiaries. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//      http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package goscaleio

// This file was generated from a properties file in the VxFlex OS code base.
// It is intended to be retired after VxFlexOS 3.0 (with no patch) no longer needs to be supported.
// This comment was at the top:
//#
//#
//# <b> THIS IS A GENERATED FILE - DO NOT EDIT MANUALLY ! </b><p/>
//#
//# Generated from file:   	src/mos/rc_gen/mos_rc.xml <br/>
//# Generated by template: 	src/mos/rc_gen/mos_rc_properties_gen.xsl
//#

// TranslateErrorCodeToErrorMessage translates an error code to error message
func TranslateErrorCodeToErrorMessage(code string) string {
	errorCodeTranslationMap := map[string]string{
		"ILLEGAL":                          "Illegal",
		"ERROR":                            "Error",
		"PENDING":                          "The operation will continue asynchronously",
		"NOT_FOUND":                        "Not found",
		"NOT_CONN":                         "Not connected",
		"CLOSED":                           "Internal Error #5",
		"NOT_READY":                        "Internal Error #6",
		"ALREADY_EXISTS":                   "Already exists",
		"ABORTED":                          "Internal Error #8",
		"NO_MORE_ELEMENTS":                 "Internal Error #9",
		"BUF_TOO_SMALL":                    "Internal Error #10",
		"INVALID":                          "Invalid",
		"IO_FAULT_NOT_PRI":                 "Internal Error #12",
		"IO_FAULT_NOT_SEC":                 "Internal Error #13",
		"IO_FAULT_BLOCKED":                 "Internal Error #14",
		"IO_FAULT_NO_VOL":                  "Internal Error #15",
		"IO_FAULT_NO_COMB":                 "Internal Error #16",
		"IO_FAULT_WRONG_VOL_GEN":           "Internal Error #17",
		"IO_FAULT_WRONG_COMB_GEN":          "Internal Error #18",
		"IO_FAULT_TEST_FAILED":             "Internal Error #19",
		"IO_HARD_ERROR":                    "Internal Error #20",
		"IO_ZERO_BUF":                      "Internal Error #21",
		"ZOMBIE":                           "Internal Error #22",
		"NO_MAPPINGS":                      "Internal Error #23",
		"NO_CHANGE":                        "Internal Error #24",
		"ID_UNKNOWN":                       "Internal Error #25",
		"INTERFACE_ERROR":                  "Interface error",
		"NOT_NEEDED":                       "Internal Error #27",
		"BUSY":                             "Internal Error #28",
		"IGNORE":                           "Internal Error #29",
		"WRONG_STATE_TRANS":                "Internal Error #30",
		"TGT_WRONG_GEN_NUM":                "Internal Error #31",
		"RETRY":                            "Retry",
		"DELAYED_RETRY":                    "Internal Error #33",
		"REMOTE_NOT_CONNECTED":             "Internal Error #34",
		"DEV_MOUNTED":                      "Internal Error #35",
		"OBJECT_DELETING":                  "Internal Error #36",
		"TGT_ADD_DEVICE_VALIDATION_FAILED": "Add SDS device validation error",
		"OLD_ACTOR_GENERATION":             "Voter actor-generation is newer than message actor-generation",
		"OLD_VOTE_ID":                      "Internal Error #39",
		"CLUSTER_DEGRADED":                 "Cannot accept vote as the sender is out of sync",
		"OLD_DEGRADED_GENERATION":          "Cannot accept vote as the message has older generation than the voter",
		"DEGRADED_INFO_MISMATCH":           "Internal Error #42",
		"ACTOR_HAS_LEASE":                  "MDM in use",
		"ACTOR_NO_LEASE":                   "Internal Error #44",
		"NO_DEVICES":                       "No devices specified for SDS",
		"UNKNOWN_MSG":                      "Unknown message. Please contact Customer Support",
		"MIGRATE_NOT_FOUND":                "Internal Error #47",
		"MIGRATE_COMPLETED":                "Internal Error #48",
		"TOO_MANY_OBJECTS":                 "There are too many objects of type",
		"NO_TEST":                          "Test not found",
		"IO_FAULT_OLD_SCSI_GEN":            "Internal Error #51",
		"IO_FAULT_NEW_SCSI_GEN":            "Internal Error #52",
		"IO_FAULT_RESERVATION_CONFLICT":    "Internal Error #53",
		"BAD_ITL":                          "Bad ITL",
		"WRONG_SEC_STATE":                  "The Slave MDM is in the wrong state. Please try again. If the problem persists, restart the Slave MDM.",
		"IO_FAULT_NO_SPACE":                "Internal Error #56",
		"IO_FAULT_QUIESCED":                "Internal Error #57",
		"NEED_WRITE_ACCESS":                "Write access is needed",
		"WRONG_TGT_ID":                     "Wrong SDS ID. The provided hostnames probably belong to other SDS's or the provided SDS ID format is illegal.",
		"WRONG_COMB_CMD_GEN":               "Internal Error #60",
		"NO_SPARES":                        "This operation violates spare policy",
		"WRONG_CMD_PARAMS":                 "Wrong command parameters. Check the help output for this command to see the correct parameters.",
		"INVALID_PERCENTAGE":               "The percentage value that you provided is invalid. Please use a value between 0 - 100.",
		"PARAMETER_OUT_OF_RANGE":           "Parameter out of range",
		"SUCCESS":                          "Success",
		"PASSWORD_ALREADY_USED":            "The password is similar to previous passwords, and can not be used.",
		"NO_RESOURCES":                     "Insufficient resources",
		"TIMEOUT":                          "A timeout occurred",
		"COMMUNICATION_ERROR":              "Communication error",
		"WRONG_RECONF_MODE":                "SDS is being configured. Please retry the command",
		"TGT_ADD_DEV_OPEN_ERROR":           "Could not open SDS device",
		"TGT_ADD_DEV_SIZE_PROBLEM":         "The SDS device size is out of the supported range",
		"TGT_ADD_DEV_IO_ERROR":             "Add SDS device IO error",
		"TGT_ACTIVE_ATTACH_TO_THIS_MDM":    "SDS is actively attached to this MDM. Probably the socket address used in the command belongs to other SDS",
		"TGT_ALREADY_ATTACH_TO_THIS_MDM":   "SDS is already attached to this MDM",
		"TGT_ACTIVE_ATTACH_TO_OTHER_MDM":   "SDS is actively attached to another MDM",
		"TGT_ALREADY_ATTACH_TO_OTHER_MDM":  "SDS is already attached to another MDM",
		"TGT_NOT_FOUND":                    "Could not find SDS",
		"VOL_NOT_FOUND":                    "Could not find the volume",
		"INI_NOT_FOUND":                    "Could not find the SDC",
		"VOL_ALREADY_MAPPED_TO_THIS_INI":   "The volume is already mapped to this SDC",
		"VOL_ALREADY_MAPPED_TO_ALL_INIS":   "The volume is already mapped to all SDCs",
		"VOL_ALREADY_MAPPED_TO_SCSI":       "The volume is already mapped to SCSI Initiator",
		"VOL_NOT_MAPPED_TO_INI":            "The volume is not mapped to SDC",
		"VOL_NOT_MAPPED_TO_SCSI":           "The volume has no SCSI reservations.",
		"VOL_MAPPED_TO_ALL_INIS":           "The volume is mapped to all SDCs",
		"TOO_MANY_MAPPINGS":                "There are too many mappings",
		"INVALID_VOL_ID":                   "Invalid volume ID. Please try again with a valid ID.",
		"INVALID_TGT_ID":                   "Invalid SDS ID. Please try again with a valid ID.",
		"INVALID_INI_ID":                   "Invalid SDC ID. Please try again with a valid ID.",
		"HOST_NOT_FOUND":                   "Could not find the host",
		"DUP_HOST_NAME":                    "Duplicate host name",
		"TGT_ADDR_AND_PORT_IN_USE":         "The SDS IP address and port already in use. Please try with different ones.",
		"TOO_MANY_TGTS_IN_FDOM":            "There are too many SDSs in Protection Domain",
		"TOO_MANY_TGTS":                    "There are too many SDSs",
		"TOO_MANY_VOLS_IN_SP":              "You have exceeded the maximum number of volumes allowed in a Storage Pool",
		"TOO_MANY_VOLS":                    "There are too many volumes",
		"TGT_NAME_IN_USE":                  "SDS name is already in use. Please use a different name.",
		"VOL_NAME_IN_USE":                  "Volume name already in use. Please use a different name.",
		"DUPLICATE_TGT_DEVICE_NAME":        "Duplicate SDS device name",
		"DUPLICATE_SDC_IP":                 "More than one SDC exists for the same IP address. Use name or ID instead, or remove the duplicate SDC",
		"TGT_NOT_UNDER_REMOVAL":            "SDS is not being removed",
		"TGT_BEING_REMOVED":                "SDS is being removed",
		"VOL_MAPPED":                       "Volume is mapped",
		"WRONG_CLUSTER_STATE":              "The MDM cluster state is incorrect",
		"TOO_MANY_VOTERS":                  "There are too many Tie-Breakers",
		"VOTER_NOT_CONFIG":                 "MDM is not configured. Please configure the MDM",
		"PRIMARY_MDM_ALREADY_CONFIG":       "The Master MDM is already configured",
		"ALREADY_IN_SINGLE_MODE":           "The MDM is already in single mode",
		"ALREADY_IN_CLUSTER_MODE":          "The MDM is already in cluster mode",
		"SECONDARY_MDM_NOT_CONFIG":         "The Slave MDM is not configured. Please configure it, and try again.",
		"SECONDARY_MDM_NOT_CONNECTED":      "The Slave MDM is not connected",
		"ERROR_CONFIG_SEC_MDM":             "Could not configure the Slave MDM",
		"UNABLE_TO_OPEN_VIRTUAL_INTF":      "Could not open virtual interface",
		"MISSING_VIRTUAL_IP":               "The virtual IP address is not configured",
		"VIRTUAL_IP_ALREADY_EXIST":         "The virtual IP address is already configured",
		"UNABLE_TO_REMOVE_VIRTUAL_INTF":    "Could not remove the virtual IP address",
		"UNABLE_TO_REMOVE_VIRTUAL_INTF_SEC_MDM_EXISTS": "The virtual IP address cannot be removed when Slave MDM is configured",
		"UNABLE_TO_REMOVE_VIRTUAL_INTF_VOTER_EXISTS":   "The virtual IP address cannot be removed when Tie-Breaker is configured",
		"BAD_HOSTNAME":                                             "An invalid IP or host-name specified",
		"WRONG_ACTOR_USE_VIRTUAL":                                  "This command is not supported on the Slave MDM. Please use the Master MDM IP to access the cluster",
		"CMD_ONLY_IN_CLUSTER":                                      "Command can only be used in cluster mode",
		"CMD_ONLY_IN_SINGLE":                                       "Command can only be used in single mode",
		"CMD_ERROR_CLUSTER_DEGRADED":                               "Command cannot be used when a cluster is degraded",
		"TOO_MANY_DEVICES":                                         "There are too many devices for SDS",
		"TGT_DEVICE_NOT_FOUND":                                     "Could not find the SDS device",
		"LICENSE_TOO_LONG":                                         "The license key is too long. Please check your key and enter it again.",
		"LICENSE_ERROR":                                            "The license key is invalid or does not match this version. Please contact Customer Support.",
		"LICENSE_UNKNOWN_VER":                                      "Unknown license version",
		"LICENSE_NOT_SET":                                          "License has not been set",
		"CONFIG_EXCEEDS_NEW_LICENSE":                               "The current system configuration exceeds the license entitlements.",
		"CAPACITY_LICENSE_EXCEEDED":                                "The operation could not be completed. The license capacity has been exceeded.",
		"VOL_DECREASE_NOT_SUPPORTED":                               "Volume capacity can only be increased",
		"SEC_IP_EQUAL_PRI_IP":                                      "The Slave IP is the same as the Master IP address. Please enter a different Slave IP address.",
		"TGT_DEV_BEING_REMOVED":                                    "The SDS device is being removed",
		"NOT_ENOUGH_TGT_DEV":                                       "This device cannot be removed; a SDS must have at least one device.",
		"DEV_NOT_UNDER_REMOVAL":                                    "The SDS device is not being removed",
		"TGT_ALREADY_ADDING_DEV":                                   "A device is being added to this SDS",
		"INVALID_DEV_ID":                                           "The device ID is invalid. Please use a valid device ID.",
		"TOO_MANY_FDS":                                             "There are too many Protection Domains",
		"FD_NAME_IN_USE":                                           "Protection Domain name already in use. Please try a different name.",
		"FD_NOT_FOUND":                                             "Could not find Protection Domain",
		"FD_HAS_TGTS":                                              "Protection Domain has SDSs",
		"NOT_ENOUGH_TGTS_IN_STORAGE_POOL":                          "Less than three devices from different SDSs are defined in this Storage Pool. Add devices to the Storage Pool from additional SDSs.",
		"REMOVE_IN_PROGRESS":                                       "Removal of the object is in progress. Please wait.",
		"ENCRYPTION_AT_REST_ALREADY_ENABLED":                       "Obfuscation is already enabled",
		"ENCRYPTION_AT_REST_ALREADY_DISABLED":                      "Obfuscation is already disabled",
		"NET_TEST_NOT_FOUND":                                       "Could not find network test results",
		"NET_TEST_IN_PROGRESS":                                     "Network test in progress",
		"TOO_MANY_SCSI_INTIATORS":                                  "There are too many SCSI Initiator",
		"SCSI_WITH_NAME_ALREADY_EXISTS":                            "A SCSI Initiator with the same name already exists. Please try a different name.",
		"ISCSI_WITH_IQN_ALRADY_EXISTS":                             "A SCSI Initiator with the same IQN already exists. Please try a different IQN.",
		"LUN_NUM_BUSY":                                             "The LUN number is already in use. Please try a different LUN number.",
		"NO_MORE_LUN_NUM_AVAILABLE":                                "No more LUN numbers are available",
		"SCSI_INITIATOR_NOT_FOUND":                                 "Could not find the SCSI Initiator",
		"SCSI_INITIATOR_IS_MAPPED":                                 "SCSI Initiator is mapped",
		"DRL_ALREADY_HARDENED":                                     "Data-region-logging is already hardened",
		"DRL_ALREADY_MEM_ONLY":                                     "Data-region-logging is already volatile",
		"LICENSE_TIME_EXCEEDED":                                    "The license has expired",
		"TGT_DEV_ALREADY_ACTIVE":                                   "The SDS device is already active",
		"TGT_DEV_WRONG_TEST_MODE":                                  "The SDS device is in incorrect test mode",
		"TGT_DEV_WRONG_TEST_STATE":                                 "The SDS device test is not complete",
		"TGT_DEV_TEST_IN_PROGRESS":                                 "The SDS device test is in progress",
		"VOL_ALLOC_ERROR_BUSY":                                     "The system is busy. Retry later",
		"CAPACITY_HIGHLY_UNBALANCED":                               "System capacity is unbalanced",
		"VOL_CREATE_FAIL":                                          "Could not create the volume",
		"INVALID_PASSWORD":                                         "Invalid password. Please try again.",
		"NO_PERMISSIONS":                                           "You do not have permission to perform this operation. Please contact your system administrator for assistance.",
		"TOO_MANY_STORAGE_POOLS_IN_PROTECTION_DOMAIN":              "There are too many Storage Pools in the Protection Domain",
		"STORAGE_POOL_ALREADY_EXISTS":                              "Storage Pool already exists",
		"STORAGE_POOL_NOT_FOUND":                                   "Could not find Storage Pool",
		"STORAGE_POOL_HAS_DEVS":                                    "The Storage Pool has SDS devices",
		"STORAGE_POOL_NAME_ALREADY_EXISTS":                         "Storage Pool name already exists",
		"INVALID_STORAGE_POOL_ID":                                  "The Storage Pool ID is not valid. Please use a valid ID",
		"DEFAULT_STORAGE_POOL_CAN_NOT_BE_REMOVED":                  "The last remaining Storage Pool in a Protection Domain cannot be removed",
		"FD_HAS_STORAGE_POOLS":                                     "Protection Domain has Storage Pools",
		"INSTALL_ID_MISMATCH":                                      "The license installation ID does not match the ID of this system",
		"CUSTOMER_ID_MISMATCH":                                     "License customer ID does not match this system",
		"LICENSE_UNSUPPORTED_VER":                                  "Unsupported license version",
		"INI_HAS_MAPPINGS":                                         "SDC has mapped volume(s)",
		"TOO_MANY_VOLS_IN_VTREE":                                   "There are too many volumes in the VTree",
		"TOO_MANY_SNAPS_IN_VTREE":                                  "There are too many snapshots in the VTree",
		"NOTHING_TO_DO":                                            "There are no volumes to delete",
		"TOO_MANY_DEVICES_IN_STORAGE_POOL":                         "There are too many devices in Storage Pool",
		"VOL_NOT_FOUND_FOR_SNAP_GROUP":                             "No volumes were found under the given consistency group or the consistency group ID is not valid",
		"TOO_MANY_IPS":                                             "There are too many IP addresses for SDS",
		"LAST_IP":                                                  "SDS must have at least one IP address",
		"NO_DEFAULT_STORAGE_POOL":                                  "There is no default Storage Pool. Storage Pool must be specified",
		"VTREE_SIZE_UNAVAILABLE":                                   "Cannot calculate Vtree size",
		"VOL_SIZE_TOO_LARGE":                                       "The volume size too large",
		"CAPACITY_TOO_LOW_FOR_SNAP":                                "The capacity of the Storage Pool is too small to create new snapshots",
		"IP_BELONGS_TO_OTHER_TGT":                                  "The specified IP address belongs to another SDS. Please use the correct IP address.",
		"TGT_IP_NOT_FOUND":                                         "The SDS IP address cannot be found.",
		"INVALID_PORT":                                             "The specified SDS port is not in the valid range. Please try again with a valid port number.",
		"BAD_THRESHOLD_VALUE":                                      "The threshold value is out of range. Please enter a valid percentage value.",
		"STORAGE_POOL_HAS_VOLS":                                    "The Storage Pool has volumes. Please remove all the volumes before removing the Storage Pool.",
		"FD_AND_SP_MISMATCH":                                       "The specified Storage Pool is not in the specified Protection Domain",
		"VTREE_ID_MISMATCH":                                        "To overwrite the content of a volume, the source and target volumes must be from the same V-Tree.",
		"TGT_MUST_HAVE_TGT_IP_ROLE":                                "SDS must have at least one IP for SDS communication.",
		"TGT_IP_ALREADY_EXISTS":                                    "The SDS IP already exists.",
		"ROLE_ALREADY_SET":                                         "The IP role for this SDS has already been configured.",
		"CLUSTER_ID_MISMATCH":                                      "The system ID that you provided does not match the actual system ID",
		"BAD_THROTTLING_VALUE":                                     "The throttling values are not valid. Please try again.",
		"IO_FAULT_VOL_NOT_THIN":                                    "Volume is not thin",
		"IO_FAULT_VOL_HAS_SNAPSHOTS":                               "Volume has snapshots",
		"DEV_NAME_ALREADY_EXISTS":                                  "A device with the given name already exists in the SDS",
		"DEV_SIZE_TOO_SMALL":                                       "The specified device size is too small.",
		"DEV_SIZE_TOO_LARGE":                                       "The specified device size is too large. Please specify a size smaller than the capacity of the specified device.",
		"NO_RESULTS_RETURNED":                                      "No results have been returned",
		"SECONDARY_MDM_ALREADY_EXISTS":                             "A Slave MDM already exists. ",
		"SECONDARY_MDM_COMMUNICATION_ERROR":                        "There is a Slave MDM communication error. Please check the Slave MDM, and fix the problem.",
		"VOL_REMOVE_IN_PROGRESS":                                   "A volume removal operation is currently in progress. ",
		"FD_NOT_ACTIVE":                                            "The Protection Domain is not active. ",
		"IO_FAULT_IS_QUIESCED":                                     "The TGT is quiesced",
		"NO_TGTS_IN_FD":                                            "The Protection Domain has no SDSs. Please add SDSs to it.",
		"FD_CAPACITY_NOT_PROTECTED":                                "Some of the Protection Domain's capacity is not fully protected. Please wait until all rebuilds are finished and no SDSs are in Maintenance Mode, or retry using 'force' flag.",
		"FD_NOT_SHUTDOWN":                                          "The Protection Domain is not deactivated. The Protection Domain may be in the process of deactivating, or is already active\\activating. ",
		"FD_STATE_CHANGE_IN_PROGRESS":                              "Protection Domain inactivation or activation is in progress. Please wait.",
		"TGT_NOT_HEALTHY":                                          "At least one SDS is not in normal operational state. Please check that all SDSs in the Protection Domain are up, and running normally.",
		"TGT_DEV_NOT_HEALTHY":                                      "At least one SDS device is in error state. Please identify and fix the storage device with the error.",
		"WRONG_QUIESCE_GEN":                                        "The quiesce generation number is wrong",
		"FD_ALREADY_EXISTS":                                        "This Protection Domain already exists. Please use this Protection Domain, or define a different one.",
		"INVALID_DRL":                                              "Invalid value in data-region-logging mode.",
		"VOTER_COMMUNICATION_ERROR":                                "There is an MDM communication error. Please check the MDM, and fix the problem.",
		"VOL_SIZE_ILLEGAL":                                         "The specified volume size is illegal. Volume size must be in 8 GB blocks",
		"LONG_NAME":                                                "The given name exceeds the allowed length of 31 characters.",
		"INVALID_NAME":                                             "The given name contains invalid characters. Use alphanumeric and punctuation characters only. Spaces are not allowed.",
		"INVALID_FD_ID":                                            "Invalid Protection Domain ID. Please try again with the correct ID.",
		"INVALID_SCSI_ID":                                          "Invalid SCSI ID. Please try again with the correct ID. ",
		"INVALID_VTREE_ID":                                         "Invalid VTree ID. Please try again with the correct ID. ",
		"INVALID_SNAP_ID":                                          "Invalid volume ID. Please try again with a valid ID.",
		"DEPRECATED_INVALID_TGT_DEV_ID":                            "Invalid device ID. Please try again with the correct ID.",
		"PASSWORD_TOO_SHORT":                                       "The password is too short. Please use a longer password.",
		"USER_NOT_FOUND":                                           "User not found. Please check that you have the correct user name.",
		"VOTER_ALREADY_CONFIGURED":                                 "The MDM is already configured to a different cluster",
		"WRONG_RECEIVE_GROUP":                                      "The command was sent to the wrong receive group due to component software mismatch.",
		"BAD_PRIMARY_MDM_IP":                                       "Master MDM IP address is incorrect",
		"SEC_IP_EQUAL_TB_IP":                                       "The Slave IP is the same as the Tie-Breaker IP",
		"TB_IP_EQUAL_SEC_IP":                                       "The Tie-Breaker IP is the same as the Slave IP",
		"TB_IP_EQUAL_PRIMARY_IP":                                   "The Tie-Breaker IP is the same as the Master IP",
		"ILLEGAL_CMD_FOR_TB":                                       "The command used for Tie-Breaker is not allowed",
		"BAD_SECONDARY_MDM_IP":                                     "The Slave MDM IP is incorrect. Please enter the correct address.",
		"TB_IS_MDM":                                                "MDM role is not a Tie-Breaker but a Slave",
		"TGT_DEVICE_NAME_CHANGED":                                  "The SDS detected that the device path has changed. Re-run the command using the device ID/Name, or update the device path. ",
		"MISMATCHING_SWID":                                         "The license contains a mismatch of the SWID number. Please contact Customer Support.",
		"INVALID_LICENSE_ISSUER":                                   "The issuer of the license you are attempting to add does not match that of the product.",
		"PERMISSION_DENIED":                                        "Permission denied. Please check that you are using the correct user name, password and authentication method, and that you have permission to perform this action.",
		"INVALID_SESSION":                                          "Invalid session. Please login and try again.",
		"PASSWORD_CHANGE_REQUIRED":                                 "Password change required. Please change your password.",
		"USER_ALREADY_EXIST":                                       "This user name already exists. Please use a different name.",
		"TOO_MANY_USERS":                                           "The maximum number of users is already defined in the system. Use an existing user name, or delete a user before you try to define a new one.",
		"TOO_MANY_SESSIONS":                                        "The maximum number of sessions is already open. Please close some other sessions, and then try again.",
		"OLD_PASSWORD_MISMATCH":                                    "The password that you entered does not match the one stored in the system. Please type it again.",
		"USER_CAN_NOT_MODIFY_HIMSELF":                              "You do not have permission to modify your own user credentials.",
		"PASSWORD_LACKS_DIVERSITY":                                 "This password lacks character diversity, and can not be used. Please use characters from at least three of these types: upper case letters, lower case letters, numbers, and punctuation (no spaces allowed).",
		"NUM_PARALLEL_MSG_TOO_LOW":                                 "The number of parallel messages is too low. Please use a number in the range 1 - 16.",
		"NUM_PARALLEL_MSG_TOO_HIGH":                                "The number of parallel messages is too high. Please use a number in the range 1 - 16.",
		"NETWORK_TEST_SIZE_TOO_HIGH":                               "The network test size is too high. Please use a test size less than 10.",
		"NETWORK_TEST_LENGTH_TOO_HIGH":                             "The network test length is too long. Please use a test length less than 43200 seconds.",
		"NETWORK_TEST_MUST_LIMIT_EITHER_TIME_OR_SIZE":              "The network test must limit either time or size.",
		"NOT_ENOUGH_TGTS_IN_FD_FOR_TEST":                           "To start the test, there must be at least 2 SDSs in the Protection Domain.",
		"NOT_ALLOWED_IN_SP_WITH_DEVS":                              "This operation is only allowed when there are no devices in the Storage Pool. Please remove all devices from the Storage Pool.",
		"TOO_MANY_FAULT_SETS":                                      "You have exceeded the maximum number of Fault Sets allowed in the Protection Domain",
		"FAULT_SET_ALREADY_EXISTS":                                 "This Fault Set already exists.",
		"FAULT_SET_NOT_FOUND":                                      "Could not find the Fault Set",
		"FAULT_SET_NAME_ALREADY_EXISTS":                            "This Fault Set name already exists. Please use a different name.",
		"DEPRECATED_INVALID_FAULT_SET_ID":                          "Invalid Fault Set ID. Please try again with the correct ID.",
		"FAULT_SET_HAS_TGTS":                                       "This Fault Set is not empty, and cannot be removed. Please remove all SDSs from the Fault Set, and then try again.",
		"FD_HAS_FAULT_SETS":                                        "The Protection Domain contains Fault Sets, and cannot be removed. Please remove all Fault Sets from the Protection Domain, and then try again.",
		"TOO_MANY_TGTS_IN_FS":                                      "You have exceeded the maximum number of SDSs allowed in a Fault Set",
		"INVALID_FS_ID":                                            "Invalid Fault Set ID. Please try again with the correct ID.",
		"FD_AND_FS_MISMATCH":                                       "The specified Fault Set is not in the specified Protection Domain",
		"TGT_ALREADY_IN_FS":                                        "The specified SDS is already in the Protection Domain.",
		"MISSING_PARAM_FOR_POLICY":                                 "Parameters are missing for the selected policy. Check the help output for the required parameters.",
		"TGT_MUST_HAVE_INI_IP_ROLE":                                "SDS must have at least one IP for SDC communication.",
		"INI_NAME_MISMATCH":                                        "SDC name mismatch. This SDC already has a different name.",
		"LIA_PACKAGE_ALREADY_INSTALLED":                            "The package is already installed",
		"LIA_PACKAGE_NOT_INSTALLED":                                "The package is not installed.",
		"LICENSE_CAPACITY_MISMATCH":                                "The license contains a mismatch of the capacity values for basic and advanced features. Please contact Customer Support.",
		"LIA_MULTIPLE_PACKAGES_INSTALLED":                          "More than one package is installed",
		"LIA_COMMAND_FAILED":                                       "The command was not successful",
		"LIA_INVALID_PASSWORD":                                     "Invalid LIA Password",
		"INVALID_DEVICE_PATH":                                      "The path to the device is invalid. Please ensure that you are using the correct path.",
		"INVALID_THROTTLE_INFO":                                    "Invalid throttle parameters. Check the help output for the valid range and use arguments that are within that range.",
		"EXCEED_SYSTEM_CAPACITY_LIMITATIONS":                       "The request exceeds system limitations",
		"TOO_MANY_VOLS_IN_FD":                                      "Too many volumes in Protection Domain",
		"NOT_ENOUGH_FSS_IN_STORAGE_POOL":                           "Storage Pools must contain devices from at least three Fault Sets or SDSs (that are not associated with a Fault Set).",
		"NOT_SUPPORTED":                                            "This command is not supported.",
		"ILLEGAL_NUM_IPS":                                          "Illegal number of IP addresses. The Master MDM, the Slave MDM, and the Tie-Breaker must each have the same number of IP addresses.",
		"OVERFLOW_IPS":                                             "Too many IP addresses for MDM. Do not configure more than four IP addresses.",
		"RMCACHE_WRONG_STATE":                                      "Wrong RAM Read Cache state",
		"RMCACHE_IS_FROZEN":                                        "RAM Read Cache is frozen",
		"RMCACHE_IS_DISABLED":                                      "RAM Read Cache is disabled",
		"INI_MAPPED_TO_TOO_MANY_VOLS":                              "The SDC is mapped to too many volumes. Please remove some mapping.",
		"LIA_OPERATION_NOT_PERMITTED":                              "The operation is not permitted by current configuration",
		"LIA_FILE_IS_TOO_LARGE":                                    "The file is too large to send it back to the user",
		"NOT_ALLOWED_MORE_THAN_ONE_MAPPING":                        "This volume is already mapped and may not be mapped to additional SDCs.",
		"INI_MUST_BE_DISCONNECTED":                                 "Cannot remove an SDC which is currently connected to the MDM.",
		"NUM_IO_BUFFS_ALREADY_SET":                                 "Number of IO buffers is already set to the requested value",
		"TOO_MUCH_THIN_CAPACITY":                                   "Requested volume size exceeds the volume allocation limit",
		"ALREADY_IN_START_STATE":                                   "Already started",
		"ALREADY_IN_STOPPED_STATE":                                 "Already stopped",
		"REMOTE_SYSLOG_IS_BUSY":                                    "Remote syslog is being configured",
		"SYSLOG_FACILITY_ILLEGAL_VALUE":                            "Facility value is out of range",
		"VOL_MAPPED_TO_SCSI_INITIATOR":                             "Volume is mapped to a SCSI Initiator",
		"NOT_ENOUGH_DEVICES_IN_STORAGE_POOL_FOR_REMOVAL":           "Not enough devices in Storage Pool",
		"INVALID_TGT_NETWORK_LIMITS":                               "Invalid limits provided. The overall limit must be higher than the rebuild, rebalance, and migration limits. Each limit must be more than 5 MB",
		"LIA_WRONG_ID":                                             "LIA installation ID verification failed",
		"AT_LEAST_ONE_TGT_FAILED":                                  "At least one SDS failed",
		"LIA_GET_FREE_DISK_SPACE_COMMAND_FAILED":                   "Get Free Disk Space was not successful",
		"ENTERPRISE_FEATURES_NOT_ENABLED":                          "Enterprise features are not enabled for this system.",
		"DISABLED":                                                 "Feature is disabled.",
		"INVALID_LUN_NUM":                                          "The LUN number is invalid. Please try a number between 0 and 255.",
		"THICK_VOL_RESERVATION_VIOLATION":                          "Allocating Thin volume violates Thick volume reservation",
		"VOL_ALREADY_MAPPED_TO_AN_INI":                             "The volume is already mapped to a SDC",
		"INVALID_SPARE_PERCENTAGE":                                 "The spare percentage value that you provided is invalid. Please use a value between 0 - 99.",
		"TGT_ALREADY_EXISTS_AND_BEING_REMOVED":                     "The SDS already exists and is being removed. Please wait for the operation to finish",
		"ONE_TGT_DEV_BEING_REMOVED":                                "This command cannot be completed; An SDS device is currently being removed",
		"ONE_TGT_DEV_ALREADY_ACTIVE":                               "This command cannot be completed; An SDS device is currently active",
		"ONE_TGT_DEV_WRONG_TEST_STATE":                             "This command cannot be completed; An SDS device is currently in incorrect test mode",
		"ONE_TGT_DEV_WRONG_TEST_MODE":                              "This command cannot be completed; An SDS device test is currently in progress",
		"INITIATOR_NOT_APPROVED":                                   "The SDC is not approved",
		"RMCACHE_SIZE_TOO_LARGE":                                   "The specified RAM Read Cache size is too large",
		"RMCACHE_SIZE_TOO_SMALL":                                   "The specified RAM Read Cache size is too small",
		"VOTER_ALREADY_EXISTS":                                     "A Tie-Breaker already exists. ",
		"TOO_MANY_REMOTE_SYSLOG_CLIENTS":                           "There are too many RSyslog clients configured. please remove some.",
		"REMOTE_SYSLOG_CLIENT_NOT_FOUND":                           "The requested remote syslog client was not found.",
		"IP_ALREADY_EXISTS":                                        "The IP already exists.",
		"MANAGER_ID_ALREADY_EXISTS":                                "Manger ID already exists. Use 'force' flag to override",
		"VOLUME_AND_SNAPSHOT_MATCH":                                "You cannot overwrite a volume with itself. Select a different volume in the V-Tree and try again.",
		"ZEROPAD_AND_SCANNER":                                      "Zero padding must be enabled in order to set scanner to Data Comparison mode",
		"INVALID_SCANNER_BW_LIMIT":                                 "The scanner bandwidth limit is invalid. Please use a value between 10KB - 10MB",
		"ADDRESS_BELONGS_TO_DIFFERENT_TGT":                         "The given address belongs to a different SDS. Please check the system configuration",
		"LICENSE_NOT_INITIAL":                                      "The license has already been set",
		"INITIAL_LICENSE_ALREADY_SET":                              "The initial license is already of this type.",
		"CLIENT_TOO_OLD":                                           "This client's version is too old to send commands.",
		"CAPACITY_TOO_LOW_FOR_THIN_VOL":                            "Storage Pool reached critical capacity utilization. Unable to create new thin volumes",
		"TOO_MANY_STORAGE_POOLS":                                   "There are too many Storage Pools in the system",
		"REMOTE_PERMISSION_DENIED":                                 "Permission denied. Remote read only limit state is enabled and blocking this operation from remote. Run this command from the Master MDM host",
		"TGT_ADD_DEV_IS_PARTITIONED":                               "Unable to add a device that was already partitioned",
		"TGT_ADD_DEV_IS_MOUNTED":                                   "Unable to add a device that was already mounted",
		"INVALID_DEVICE_HEADER_SIGNATURE":                          "Found an invalid device header signature",
		"TOO_MANY_VIRTUAL_IPS":                                     "There are too many Virtual IP addresses.",
		"DUPLICATE_VIRTUAL_IP":                                     "Duplicate Virtual IP addresses.",
		"DUPLICATE_VIRTUAL_IP_IFC":                                 "Duplicate Virtual IP interface.",
		"PORT_ALREADY_EXISTS":                                      "Port already in use",
		"GET_INFO_FAILED":                                          "Get Info script failed",
		"INVALID_GUID":                                             "The given GUID is invalid. Please specify GUID in the following format: xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx",
		"IO_FAULT_DEVICE_ERROR":                                    "Internal Error #362",
		"ADD_SRC_VOL_WILL_CAUSE_TOO_MANY_VOLS_IN_VTREE":            "Adding the source volume to the snapshot policy will cause there to be too many volumes in the VTree",
		"WRONG_CAP_CHANGE_GEN":                                     "Wrong Capacity Change Generation for the MultiHead",
		"DEV_IN_ERROR":                                             "Operation succeeded but some devices are in error",
		"NO_LOGICAL_RESOURCES":                                     "Insufficient SPEF metadata resources",
		"DEV_IN_REMOVAL":                                           "Operation succeeeded but devices is in removal",
		"ESRS_CREDENTIALS_INVALID":                                 "Invalid credentials",
		"ESRS_CALLBACK_IP_MALFORMED":                               "Esrs callback IP is malformed",
		"PRODUCT_NOT_REGISTERED_IN_ESRS":                           "Product in no registerred in ESRS",
		"INVALID_UPGRADE_ID":                                       "Invalid Upgrade Id. no Such Upgrade process which is running",
		"UPGRADE_ALREADY_RUNNING":                                  "Upgrade process is already running",
		"INVALID_UPGRADE_ERROR_ID_OR_TYPE":                         "Upgrade error is or type is invalid for operation",
		"AMS_REDISCOVERY_UNSUPPORTED":                              "Re-discovery is not currently supported",
		"AMS_EXTEND_PROCESS_ALREADY_RUNNING":                       "Active extend process is already running",
		"AMS_EXTEND_PROCESS_OUT_OF_SYNC":                           "Extend process is not synchronized between server and client",
		"AMS_AUTO_DISCOVERY_FAILED":                                "Auto-discovery process failed",
		"AMS_SINGLE_IM_PROCESS_IS_ALLOWED":                         "Only one single deployment or upgrade process is allowed at same time",
		"AMS_UNEXPECTED_CONFIGURATION":                             "Unexpected configuration",
		"AMS_ASSIGN_MGMT_IPS_FAILED":                               "Could not assign management IPs to the nodes",
		"AMS_FAILED_TO_CHANGE_CONFIGURATION":                       "Could not change persistent configuration",
		"AMS_ASYNC_PROCESS_RUNNING":                                "Async process is still running",
		"AMS_ASYNC_PROCESS_ALREADY_RUNNING":                        "Another async process is already running",
		"AMS_NODE_DOES_NOT_EXIST":                                  "Node does not exist",
		"AMS_MISSING_NODE_CREDS":                                   "Missing node credentials",
		"AMS_FAILED_TO_RETRIEVE_MDM_MODEL":                         "Cannot connect to MDM",
		"AMS_IM_ORCHESTRATION_FAILED":                              "Cannot perform orchestration of async process",
		"AMS_SVM_SSH_CONNECTION_FAILED":                            "Could not create SVM SSH connection",
		"AMS_INVALID_PARAMS":                                       "Invalid parameters received from client",
		"AMS_MDM_CONNECTION_FAILED":                                "Could not connect to MDM",
		"AMS_COULD_NOT_CREATE_PD":                                  "Could not create Protection Domain",
		"AMS_COULD_NOT_CREATE_SP":                                  "Could not create Storage Pool",
		"AMS_FAILED_TO_STORE_CONFIG":                               "Could not store AMS configuration in persistent location",
		"AMS_FAILED_TO_LOAD_CONFIG":                                "Could not load AMS configuration from persistent location",
		"AMS_ADC_CONNECTION_TEST_FAILED":                           "Connection test to ADC failed",
		"AMS_ILLEGAL_IP_POOLS_CONFIG":                              "Illegal configuration - new configuration does not contain IPs already in use",
		"AMS_ILLEGAL_VIRTUAL_IP_CONFIG":                            "Cannot change virtual IPs when VxFlex OS exists",
		"AMS_FAILED_TO_PERFORM_IPMI_POWER_CMD":                     "Could not perform node power operation using IPMI",
		"AMS_FAILED_TO_REMOVE_NODE":                                "Could not remove appliance node",
		"AMS_FAILED_OPERATE_LED":                                   "Could not turn on/off chassis led using IPMI",
		"AMS_NO_BMC_CONFIG":                                        "No BMC configuration found",
		"AMS_INVALID_CREDENTIALS":                                  "Invalid credentials",
		"AMS_VCENTER_CONNECTION_FAILED":                            "Could not connect to vCenter",
		"AMS_DATASTORE_UNMOUNT_FAILED":                             "Could not unmount datastore",
		"AMS_DETACH_LUN_FAILED":                                    "Could not detach LUN",
		"AMS_NOT_ENOUGH_NODES_FOR_CLUSTER":                         "Not enough nodes to create VxFlex OS cluster. At least 3 nodes are needed",
		"AMS_CANNOT_TERMINATE_IN_CURRENT_PHASE":                    "Cannot terminate process in current phase. Please try again later",
		"AMS_DEPLOY_RETRY_WITH_CHANGED_PARAMS_NOT_SUPPORTED":       "Retrying deployment process with changed parameters is not supported",
		"AMS_CANNOT_RUN_SET_MGMT_IP_WITHOUT_DISCOVERY":             "Cannot perform management networks configuration without performing discovery. Please close this wizard and rerun discovery process",
		"AMS_DISCOVERY_FOUND_NO_NODES":                             "No VxFlex OS Nodes were found in the discovery process",
		"AMS_CANNOT_REMOVE_CLUSTER_COMPONENT_NODE":                 "Cannot remove node that serves as cluster component",
		"AMS_REMOVE_SDC_FROM_MDM_FAILED":                           "Could not remove SDC object from MDM",
		"AMS_NODE_IS_FUTURE_CLUSTER_COMPONENT":                     "Node is already a future cluster component",
		"AMS_NODE_HAS_INVALID_SIO_ROLE_FOR_MOVE_CLUSTER_COMPONENT": "Node has invalid VxFlex OS role to start Move Cluster Component process",
		"AMS_NODE_IS_BEING_REMOVED":                                "Node is being removed",
		"AMS_FAILED_TO_ORCHESTRATE_MOVE_CLUSTER_COMPONENT":         "Could not orchestrate Move Cluster Component process",
		"AMS_NODES_WITH_UNFINISHED_MOVE_CLUSTER_COMPONENT_PROCESS_EXIST":     "Other nodes with unfinished Move Cluster Component process exist",
		"AMS_BATCH_DOES_NOT_EXIST":                                           "Process batch does not exist",
		"AMS_ASYNC_PROCESS_DOES_NOT_EXIST":                                   "Async process does not exist",
		"AMS_VIRTUAL_DISK_ALREADY_EXIST":                                     "The logical disk already exists for the physical drive. Delete it and retry the operation",
		"AMS_VIRTUAL_DISK_IN_USE":                                            "The logical disk is in use by VxFlex OS",
		"AMS_FAILED_DELETING_VIRTUAL_DISK":                                   "Failed deleting logical disk",
		"PROTOCOL_MISMATCH":                                                  "Message deserialization failed due to protocol mismatch",
		"CA_SIGNED_CERT_NOT_TRUSTED":                                         "The CA-signed certificate is not trusted",
		"CERTIFICATE_EXPIRED":                                                "The certificate is expired",
		"CERTIFICATE_NOT_YET_VALID":                                          "The certificate is not yet valid",
		"AMS_INVALID_UPGRADE_TAR":                                            "Upgrade tar is invalid",
		"AMS_FAILED_TO_PARSE_UPGRADE_SCENARIO":                               "Could not parse upgrade scenario file",
		"AMS_INVALID_UPGRADE_SCENARIO":                                       "Invalid upgrade scenario file",
		"AMS_CACHING_IN_PROCESS":                                             "A caching operation is already in process",
		"AMS_CACHED_WITH_CACHE_CADE":                                         "The Storage Pool is already cached by CacheCade",
		"AMS_CACHED_WITH_XTREM_CACHE":                                        "The Storage Pool is already cached by XtremCache",
		"AMS_FAILED_TGT_DEV_REMOVE":                                          "Failed to remove device from SDS",
		"AMS_MOVE_COMPONENT_TARGET_NODE_NOT_COMPLETED_DEPLOYMENT":            "Target node for move cluster component process has not successfully completed deployment process",
		"AMS_CANNOT_REMOVE_NODE_WITH_MAPPED_VOLUMES":                         "Selected node has mapped volumes and cannot be removed",
		"AMS_DEVICE_ALREADY_IN_USE":                                          "The device is already in use",
		"AMS_CACHED_WITH_RF_CACHE":                                           "The Storage Pool is already cached by RFCache",
		"AMS_MONITOR_USER_WRONG_PERMISSIONS":                                 "AMS must use a MDM user that has only the monitor permission",
		"AMS_MONITOR_USER_CHANGE_VALIDATION_PROBLEM":                         "Failed checking the given credentials validity",
		"AMS_MONITOR_AUTH_CHANGE_VALIDATION_PROBLEM":                         "Failed changing authenticatin mode - AMS configured user won't be able to connect to the MDM",
		"AMS_MONITOR_USER_WRONG_CREDENTIALS":                                 "Invalid username or password given for the monitoring user",
		"AMS_EXPORT_SSH_KEYS_FAILED_FILE_ALREADY_EXISTS":                     "Cannot export the ssh keys file as a file with the same name already exists",
		"AMS_EXPORT_SSH_KEYS_FAILED_CANNOT_WRITE_FILE":                       "Cannot export the ssh keys file, path may be wrong",
		"AMS_VCENTER_INVALID_CERTIFICATE":                                    "vCenter certificate is invalid",
		"AMS_FAILED_CREATING_CSR":                                            "Failed creating certificate request for AMS CA certificate",
		"AMS_CERTIFICATE_NOT_MATCHING_PRIVATE_KEY":                           "The given certificate has a public key which doesn't match the saved private key",
		"AMS_CERTIFICATE_BAD_FORMAT":                                         "Provided certificate should be in PEM encoding",
		"AMS_SECURE_COMMUNICATION_CANNOT_BE_ENABLED":                         "Can't move to secure communication mode as secure connection to at least one of the nodes isn't initialized",
		"AMS_RECOVERY_PASSWORD_MISSING":                                      "AMS recovery password isn't configured. Configure AMS recovery password and run the command again.",
		"AMS_ESX_VOLUME_BUSY":                                                "Volume failed to detach from ESX as it in use.",
		"AMS_VOL_ON_EXT_SDC_MAYBE_BUSY":                                      "AMS cannot detect if volume is free to unmount from external SDC. Use Force to unmount.",
		"AMS_RENEW_CERTIFICATE_RUNNING":                                      "Cannot replace AMS certificate while renew certificates process is running.",
		"AMS_FAILED_CLEARING_PHYSICAL_DISK_ERROR":                            "The command cannot be performed successfully. Check the AMS logs to identify possible problems in the Storage Controller",
		"AMS_FAILED_CLEARING_PHYSICAL_DISK_INVALID_STATE":                    "This command cannot be executed because the disk state is not 'unconfigured bad'",
		"AMS_SECURE_COMMUNICATION_CANNOT_BE_DISABLED_NO_MDM":                 "Can't disable secure communication before the MDM cluster is setup",
		"AMS_VIRTUAL_DISK_IN_USE_BY_DASCACHE":                                "Disk cannot be removed as it's used by DasCache",
		"AMS_DASCACHE_MUST_BE_ALL_AT_ONCE":                                   "DasCache devices can only be added/removed all-at-once.",
		"ESRS_CONNECTION_FAILED":                                             "Failed connection to ESRS gateway server",
		"AMS_ALL_SSD_CANT_BE_CACHED":                                         "SSD Storage Pool can not be accelerated by cache",
		"AMS_CERTIFICATE_EXPIRY_DATE_TOO_SOON":                               "Certificate expiration date is sooner than allowed",
		"AMS_SYSTEM_ALREADY_USES_2_NICS":                                     "System is already configured to use 2 data NICs",
		"AMS_SYSTEM_HAS_NODES_IN_DEPLOYMENT_PHASE":                           "The operation cannot be performed as the system has nodes that are currently in deployment phase",
		"AMS_REMOVE_NICS_WILL_CAUSE_SDS_COMM_FAIL":                           "Removing the NICs may cause some SDS to be disconnected",
		"AMS_SYSTEM_ALREADY_USES_4_NICS":                                     "System is already configured to use 4 data NICs",
		"AMS_SYSTEM_HYPER_CONVERGED_CANT_USE_FOUR_NICS":                      "Can't configure 4 VxFlex OS data NICs in an hyper-converged system",
		"AMS_NOT_ENOUGH_FREE_IPS_IN_POOL":                                    "IP pools doesn't have enough free IPs to be distributed to all nodes",
		"AMS_CHANGE_DATA_NICS_ALREADY_RUNNING":                               "Configuring data nics operation is already running",
		"AMS_UPGRADE_FAILED_TO_APPROVE_NODE_REBOOT":                          "The requested node is not waiting for reboot approval",
		"AMS_FAILED_TO_RUN_LOG_COLLECTION":                                   "Error while trying to execute log collection process",
		"AMS_FAILED_TO_ABORT_LOG_COLLECTION":                                 "Error while trying to abort log collection process",
		"AMS_FAILED_TO_GET_LOG_FILE_INFO":                                    "Error getting collected log file info",
		"AMS_RECOVERY_INVALID_SSH_KEYS_INPUT_FILE":                           "Error parsing ssh keys file for recovery process",
		"AMS_RECOVERY_INVALID_NODE_CREDENTIALS_INPUT_FILE":                   "Error parsing credentials file for recovery process",
		"AMS_RECOVERY_ALREADY_RUNNING":                                       "AMS recovery process is already running",
		"AMS_COMMAND_RUNNING_ON_DEVICE":                                      "Can't run multiple operations against the same physical device in parallel",
		"AMS_ENTITY_DOES_NOT_EXIST":                                          "Entity with the provided ID does not exist",
		"AMS_ENTITY_TYPE_DOES_NOT_EXIST":                                     "Entity from the provided type does not exist",
		"AMS_REPLACE_SVM_OVA_MISSING":                                        "Replace SVM template OVA file not found",
		"MAINT_VOL_UNMAP_BLOCKED":                                            "Maintenance volume is required by replac SVM process, and should not be unmapped.",
		"AMS_SYSTEM_TYPE_DATA_NETWORKS_MISMATCH":                             "There are too many data networks for requested system type",
		"AMS_SET_PASSWORD_INVALID_HOST_PASSWORD":                             "Set password given an invalid host password",
		"AMS_TAKE_OWNERSHIP_INVALID_NODE_CREDENTIALS_INPUT_FILE":             "Error parsing credentials file for Take Ownership process",
		"AMS_TAKE_OWNERSHIP_INVALID_PRIMARY_MDM_IP_CANDIDATES_INPUT":         "Error parsing list of possible MDM IPs for take ownership process",
		"AMS_TAKE_OWNERSHIP_ALREADY_RUNNING":                                 "AMS take ownership process is already running",
		"AMS_TAKE_OWNERSHIP_ALREADY_MANAGING_A_SYSTEM":                       "AMS is already managing a system",
		"AMS_TAKE_OWNERSHIP_MDM_CREDENTIALS_ERROR":                           "Invalid or missing MDM user name and/or password",
		"AMS_TAKE_OWNERSHIP_MISSING_WIZARD_INFO":                             "Some required info is missing. Please make sure you completed all steps of the initial wizard",
		"AMS_TAKE_OWNERSHIP_NOT_IN_PROGRESS":                                 "There is no take ownership process currently in progress",
		"AMS_TAKE_OWNERSHIP_NOT_READY_FOR_EXPORT":                            "The currently running Take Ownership process is not yet ready to export data",
		"AMS_TAKE_OWNERSHIP_ALREADY_EXPORTING":                               "Take Ownership process export phase has already started",
		"AMS_FAILED_TO_ADD_NODE":                                             "Could not add appliance node",
		"AMS_TAKE_OWNERSHIP_MISSING_MONITOR_CREDENTIALS":                     "The MDM requires LDAP authentication - please provide valid LDAP monitor user and password",
		"AMS_TAKE_OWNERSHIP_NON_LDAP_MONITOR_CREDENTIALS":                    "The provided Monitor user is not an LDAP user - but the MDM requires LDAP authentication",
		"AMS_MISSING_CONFIGURATION":                                          "Could not find the AMS configuration",
		"AMS_INCOMPLETE_CONFIGURATION":                                       "The AMS configuration is incomplete",
		"AMS_UNSUPPORTED_COMMAND":                                            "Command not supported by AMS, use the approved AMS command/flow as specified in VxFlex OS guidelines.",
		"AMS_MGMT_AND_DATA_IPS_ON_SAME_SUBNET":                               "Invalid network configuration - there is a data IP on the same subnet as a management IP",
		"AMS_DATA_NETWORK_ON_MULTIPLE_SUBNETS":                               "Invalid network configuration - there is a single data network on more than 1 subnet",
		"AMS_MULTIPLE_DATA_NETWORKS_ON_SAME_SUBNET":                          "Invalid network configuration - there are multiple data networks on a single subnet",
		"AMS_CANNOT_RESTRICT_SDC_MODE_UNAPPROVED_SDC":                        "Cannot set restricted SDC mode due to SDC being unapproved by MDM",
		"AMS_CANNOT_RESTRICT_SDC_MODE_SDC_HAS_UNAPPROVED_IPS":                "Cannot set restricted SDC mode due to SDC having an IP that is not approved by MDM",
		"AMS_DOWNLOAD_LOGS_ABORTED_INSUFFICIENT_SPACE":                       "Download logs to AMS aborted due to insufficient free disk space",
		"AMS_CLIENT_TOO_NEW":                                                 "The client version too new to work with the AMS",
		"AMS_FAILED_TO_CREATE_FILE_OR_DIR":                                   "AMS failed to create file or directory",
		"AMS_CANNOT_PERFORM_ACTION_IN_CURRENT_RESTRICTIVE_STATE":             "AMS cannot perform the action in its current restrictive state",
		"AMS_NVDIMM_REGION_HAS_NAMESPACE":                                    "The NVDIMM region already has a namespace configured",
		"AMS_NVDIMM_REGION_NOT_FOUND":                                        "The NVDIMM region was not found",
		"AMS_MISSING_IP_ADDRESS":                                             "No IP address was provided",
		"AMS_NOT_VALID_IP_ADDRESS":                                           "The provide value is not a valid IP address",
		"AMS_MISSING_CERTIFICATE":                                            "No certificate was provided",
		"AMS_NOT_CA_CERTIFICATE":                                             "The provided certificate is not a CA certificate",
		"AMS_UNMAP_ALL_SDC_NOT_SUPPORTED_ESX":                                "Unamp all SDCs from a volume not supported for multiple ESX nodes",
		"AMS_MISSING_PACKAGE":                                                "One or more required package is missing",
		"AMS_CERTIFICATE_NOT_FOUND":                                          "The certificate was not found in the AMS trust store",
		"AMS_CANNOT_REMOVE_NODE_WITH_SDS":                                    "Cannot remove node with a SDS on it",
		"AMS_ALERTS_LOG_FILE_IOEXCEPTION":                                    "Error reading alerts.log file",
		"AMS_FAILED_TO_FIND_ALERTS_LOG_FILE":                                 "Cannot find alerts.log file",
		"AMS_ARCHIVE_ALERT_INVALID_TIME_FILTER":                              "Invalid time values for the archived alert filter",
		"AMS_INVALID_DNS_IP":                                                 "Given an invalid DNS IP address",
		"AMS_CANNOT_EXTEND_DURING_UPGRADE":                                   "Cannot perform extend process actions when cluster is in the middle of an upgrade",
		"AMS_CANNOT_SERVE_REQ_REMOTE_NOT_CONN":                               "Cannot serve request - no connection to its remote destination",
		"AMS_INVALID_SECURITY_PATCHES_POLICY":                                "Invalid policy provided for enablement of Spectre and Meltdown security patches ",
		"AMS_MONITOR_USER_PWD_REQUIRES_CHANGE":                               "User provided for the AMS monitoring user requires password change",
		"AMS_REPLACE_SVM_ALREADY_RUNNING":                                    "Another Deploy OVA or Replace SVM process is already running",
		"PYTHON_NOT_INSTALLED":                                               "Python is not installed.",
		"LIA_VERSION_IS_NEWER_THAN_LIA":                                      "The version of the uploaded file is newer than LIA's version",
		"VERSION_TOO_NEW":                                                    "The version of the module sending the message is too high",
		"VERSION_TOO_OLD":                                                    "The version of the module sending the message is too low",
		"WRONG_UPGRADE_STATE":                                                "The command cannot be executed in the current upgrade state",
		"NOT_ALL_TGTS_UPGRADED":                                              "Not all the SDSs were upgraded to the new version",
		"UPGRADE_NOT_FINISHED":                                               "The command is not allowed until the upgrade process is complete",
		"CLUSTER_NOT_UPGRADED":                                               "The command is not allowed until the MDM cluster upgrade process is complete",
		"INVALID_PERFORMANCE_PARAMETER":                                      "Performance parameter value is out of range. Please refer to the events log for further details",
		"DIF_ATTACH_MISSING":                                                 "The SDC version indicate it supports DIF Generation but DIF is missing and isnt indicated",
		"TGT_TOO_OLD":                                                        "The version of the SDS is too old",
		"LOGICAL_BLOCK_CHECK_GUARD_FAILED":                                   "T10 DIF 'guard' failed a verification check",
		"LOGICAL_BLOCK_CHECK_APP_TAG_FAILED":                                 "T10 DIF 'AppTag' failed a verification check",
		"LOGICAL_BLOCK_CHECK_REF_TAG_FAILED":                                 "T10 DIF 'RefTag' failed a verification check",
		"FALSE":                                                              "boolean FALSE when error code can be returned",
		"TRUE":                                                               "boolean TRUE when error code can be returned",
		"UMT_NUM_UPDATE_IS_STUCK":                                            "Update of UMT num takes too long",
		"PEER_ID_MISMATCH":                                                   "The peer id mismatch to the previously discovered one",
		"CERT_VERIFY_FAILURE":                                                "The peer's certificate failed verification",
		"RFCACHE_INVALID_DRIVER_PATH":                                        "RFcache driver not installed",
		"RFCACHE_API_VERSION_MISMATCH":                                       "The RFcache API version mismatch the supported version",
		"TOO_MANY_RFCACHE_DEVICES":                                           "There are too many RFcache devices for SDS",
		"DEPRECATED_MSG":                                                     "Deprecated message. Please contact Customer Support.",
		"INVALID_RFCACHE_PAGESIZE":                                           "Invalid RFcache page size. Valid values are powers of 2 between 4KB and 64KB",
		"INVALID_RFCACHE_MAXIOSIZE":                                          "Invalid RFcache maximum IO size. Valid values are powers of 2 between 32KB and 256KB",
		"TGT_ALREADY_IN_MM":                                                  "The specified SDS is already in maintenance-mode.",
		"TGT_NOT_IN_MM":                                                      "The specified SDS is not in maintenance-mode.",
		"TGT_MM_CONFILICT":                                                   "The task failed since another SDS that shares a Storage Pool with this SDS and does not belong to the same Fault Set is in maintenance-mode.",
		"DEGRADED_OR_FAILED_DATA":                                            "The task failed since there is degraded or failed data in one of SDS's Storage Pools",
		"TGT_MM_INSUFFICIENT_FREE_CAP":                                       "The task failed since there is not enough free capacity in one of SDS's Storage Pools",
		"SIG_VERIFY_FAILURE":                                                 "The peer's digital signature failed verification",
		"NET_SECURITY_DISABLED_ON_SERVER":                                    "Network security is disabled on the server",
		"NO_MEMORY":                                                          "Out of memory",
		"SDC_IOCTL_ERROR":                                                    "SDC command failed",
		"INVALID_ARG":                                                        "Invalid argument",
		"MDM_IP_ALREADY_EXISTS":                                              "An MDM with the same IP address already exists.",
		"SDC_GUID_ALREADY_EXISTS":                                            "An SDC with the same GUID already exists.",
		"CLUSTER_FROZEN":                                                     "Cluster Frozen",
		"TOO_MANY_MDMS":                                                      "There are too many MDMs nodes defined",
		"ACTOR_ALREADY_CONFIGURED":                                           "The MDM is already configured to a different cluster",
		"MDM_NOT_CONNECTED":                                                  "The MDM is not connected",
		"ERROR_CONFIG_REMOTE_MDM":                                            "Could not configure the remote MDM",
		"MDM_IN_CLUSTER":                                                     "The MDM is part of the current cluster and cannot be removed",
		"MDM_DOES_NOT_EXIST":                                                 "The MDM could not be found",
		"CMD_ERROR_ID_NOT_IN_CLUSTER":                                        "The MDM ID passed is not a cluster member",
		"MDM_NAME_ALREADY_EXISTS":                                            "An MDM with the same name already exists.",
		"ALREADY_IN_THIS_CLUSTER_MODE":                                       "The MDM is already in this cluster mode.",
		"TOO_MANY_REPLACED_MDMS":                                             "Too many MDMs replaced for this cluster mode.",
		"WRONG_NUMBER_OF_MDMS":                                               "Wrong number of MDMs for this transition",
		"WRONG_MDM_ROLE":                                                     "Wrong MDM role",
		"MDM_NOT_IN_CLUSTER":                                                 "The MDMs are not in the cluster",
		"MDM_ALREADY_IN_CLUSTER":                                             "The MDMs are already in the cluster",
		"MDM_IS_TB":                                                          "MDM role is not a Slave but a Tie-Breaker",
		"ALREADY_MASTER":                                                     "MDM passed is already the Master",
		"CANNOT_REMOVE_MASTER":                                               "The MDM requested to be removed is the Master, not a slave MDM",
		"SDS_PERF_PARAM_CHANGE_FAILED":                                       "Could not configure the performance parameters to the SDS",
		"CLUSTER_VERSION_MISMATCH":                                           "The MDM cluster is currently running a different version",
		"CHECKSUM_ERROR":                                                     "SDC failed to validate checksum.",
		"INVALID_CHECKSUM_LENGTH":                                            "SDC failed to validate checksum. Unexpected checksum length",
		"IO_NET_ERROR":                                                       "IO failed due to a network related error",
		"TOO_MANY_RFCACHE_DEVS":                                              "You have exceeded the maximum number of RFcache Devices",
		"RFCACHE_DEV_ALREADY_EXISTS":                                         "This RFcache Device already exists",
		"RFCACHE_DEV_NOT_FOUND":                                              "Could not find RFcache Device",
		"INVALID_RFCACHE_DEV_ID":                                             "Invalid RFcache Device ID. Please try again with a valid ID.",
		"PASSWORD_VIA_SHELL":                                                 "The usage of --password to login was disabled",
		"MDM_TOO_OLD":                                                        "The version of the MDM is too old",
		"DYN_PARAM_DOES_NOT_EXIST":                                           "The dynamic parameter does not exist",
		"INI_NAME_IN_USE":                                                    "SDC name is already in use. Please use a different name.",
		"MDM_ACTIVE_ATTACH_TO_THIS_CLUSTER":                                  "MDM was previously part of this cluster and was not properly removed",
		"MDM_ALREADY_ATTACH_TO_THIS_CLUSTER":                                 "MDM was previously part of this cluster and was not properly removed",
		"MDM_ACTIVE_ATTACH_TO_OTHER_CLUSTER":                                 "MDM is part of another cluster or was not properly removed",
		"MDM_ALREADY_ATTACH_TO_OTHER_CLUSTER":                                "MDM is part of another cluster or was not properly removed",
		"VOTER_ACTIVE_ATTACH_TO_THIS_CLUSTER":                                "MDM was previously part of this cluster and was not properly removed",
		"VOTER_ALREADY_ATTACH_TO_THIS_CLUSTER":                               "MDM was previously part of this cluster and was not properly removed",
		"VOTER_ACTIVE_ATTACH_TO_OTHER_CLUSTER":                               "MDM is part of another cluster or was not properly removed",
		"VOTER_ALREADY_ATTACH_TO_OTHER_CLUSTER":                              "MDM is part of another cluster or was not properly removed",
		"RFCACHE_UUID_NOT_FOUND":                                             "UUID of RFcache Device was not found",
		"RFCACHE_MULTIPLE_PATHS_TO_DEVICE":                                   "Multiple paths for the same RFcache Device",
		"ERROR_LOADING_SECURITY":                                             "Failed loading the security module",
		"MANAGEMENT_CLIENT_SECURE_COMMUNICATION_ALREADY_ENABLED":             "Management clients secure communication is already enabled",
		"MANAGEMENT_CLIENT_SECURE_COMMUNICATION_ALREADY_DISABLED":            "Management clients secure communication is already disabled",
		"ILLEGAL_FOR_MASTER_MDM":                                             "Command is illegal for the Master MDM",
		"ILLEGAL_COMMAND_FOR_REMOTE_CLIENTS":                                 "This command can only be run from the local machine",
		"SECURITY_IS_DISABLED":                                               "This command cannot be used when secure communication is disabled",
		"ERROR_LOADING_OPENSSL":                                              "Failed loading the OpenSSL library",
		"ERROR_LOADING_SSL_KEY_PAIR":                                         "Failed loading the SSL/TLS key-pair",
		"ERROR_LOADING_SSL_TRUST":                                            "Failed loading the SSL/TLS trusted certificates",
		"INVALID_SSL_CIPHERS":                                                "Invalid SSL/TLS ciphers",
		"ERROR_LOADING_AUTH_KEY_PAIR":                                        "Failed loading the authentication key-pair",
		"ERROR_LOADING_AUTH_TRUST":                                           "Failed loading the authentication trusted certificates",
		"UNSECURE_CONNECTION_NOT_ALLOWED":                                    "Commands sent on an unsecure connection are not allowed.",
		"INVALID_AUTHENTICATION_METHOD":                                      "Invalid authentication method.",
		"LDAP_UNSUPPORTED_COMMAND":                                           "This command is not supported by system configured with LDAP authentication method.",
		"LDAP_SESSION_INITIALIZATION_FAIL":                                   "Could not establish the connection with LDAP service.",
		"LDAP_BIND_FAIL":                                                     "Could not connect to LDAP service. Please check username, password and LDAP service parameters.",
		"LDAP_USER_NOT_FOUND_IN_GROUP":                                       "The LDAP user was not found in the group.",
		"LDAP_SEARCH_FAIL":                                                   "An error occured during the LDAP search operation.",
		"LDAP_UNBIND_FAIL":                                                   "Could not unbind from LDAP service.",
		"LDAP_UNINITIALIZED":                                                 "LDAP library could not be loaded properly.",
		"AUTH_METHOD_ALREADY_SET":                                            "No change in authentication method. Current method equals to the newly set method.",
		"AUTH_NO_NATIVE_USERS_DEFINED":                                       "There are no users defined in the system.",
		"LDAP_UNSUPPORTED_DN_FORMAT":                                         "Could not parse DN parameter.",
		"LDAP_SERVICE_DOMAIN_ALREADY_EXISTS":                                 "LDAP service entry with the same domain already exist.",
		"TOO_MANY_LDAP_SERVICES":                                             "There are too many LDAP service entries.",
		"LDAP_SERVICE_NOT_FOUND":                                             "Could not find LDAP service.",
		"LDAP_GROUP_ALREADY_EXISTS":                                          "LDAP group entry already exist.",
		"TOO_MANY_LDAP_GROUPS":                                               "There are too many LDAP groups.",
		"LDAP_UNSUPPORTED_USERNAME_FORMAT":                                   "Could not parse Username parameter.",
		"LDAP_FROM_LDAP_TO_NATIVE_AUTH_ERROR":                                "Could not change authentication method from LDAP to Native.",
		"ERROR_LOADING_LDAP_IN_CLUSTER":                                      "One of the cluster nodes failed loading the LDAP library",
		"LDAP_AUTHENTICATION_FAIL":                                           "Could not locate user in any configured LDAP group",
		"IRRELEVANT_ADD_MDM_PARAMS":                                          "Parameters for adding nodes should not be specified when decreasing the number of MDMs",
		"IRRELEVANT_REMOVE_MDM_PARAMS":                                       "Parameters for removing nodes should not be specified when increasing the number of MDMs",
		"SDC_GUID_DOES_NOT_EXIST":                                            "The SDC does not have a GUID",
		"DEV_ALREADY_TAKEN_BY_ANOTHER":                                       "Device already added to another SDS. To override, add the specific sds device with force device takeover.",
		"TGT_EXIT_MAINTENANCE_IN_PROGRESS":                                   "The specified SDS is in a process of exiting maintenance-mode.",
		"TGT_EXIT_MM":                                                        "Exiting maintenance-mode.",
		"BAD_THRESHOLD_MATCH":                                                "The high threshold value must be lower than the critical threshold value.",
		"LDAP_USER_NOT_FOUND_IN_ANY_GROUP":                                   "The LDAP user was not found in any configured group.",
		"LDAP_SERVICE_NOT_CONFIGURED":                                        "LDAP services were not configured sufficiently. There must be at least one LDAP service with administrators group.",
		"TGT_MM_PD_FAIL":                                                     "The task failed since there is an SDS in the Protection Domain currently in maintenance-mode.",
		"TGT_MM_SDS_FAIL":                                                    "The task failed since this SDS is currently in maintenance-mode.",
		"SELF_SIGNED_CERT_NOT_TRUSTED":                                       "The self-signed certificate is not trusted",
		"ISSUER_CERT_NOT_TRUSTED":                                            "The issuer's certificate is not trusted",
		"LDAP_GROUP_FQDN_DIFFERS_FROM_SERVICE":                               "Domain path of group differs from the LDAP service domain",
		"LIA_SECURE_COMMUNICATION_ALREADY_ENABLED":                           "LIA secure communication is already enabled",
		"UPGRADE_WAS_NOT_STARTED":                                            "The system is not currently being upgraded",
		"MEMBERSHIP_CHANGE_LEAVING_FAILED_NODE":                              "The requested membership change leaves a failed node in the cluster",
		"MEMBERSHIP_CHANGE_ADDING_FAILED_NODE":                               "The entered command is trying to add a failed node to the cluster",
		"MEMBERSHIP_CHANGE_NO_MAJORY_IN_NEW":                                 "The entered command will lead to a failed MDM cluster",
		"TGT_CACHE_EXCEEDS_LIMIT":                                            "Requested cache size exceeds limit",
		"TGT_NOT_LISTENING_ON_PORT":                                          "The SDS is not listening on the specified port. Please check the SDS port configuration and try again",
		"INVALID_POLICY":                                                     "Invalid policy",
		"DYN_PARAM_IS_READ_ONLY":                                             "The dynamic parameter is read only. Can be change only via centralized management (i.e. cli).",
		"OPENSSL_VERSION_TOO_OLD":                                            "The OpenSSL version is too old",
		"CERTIFICATE_DOES_NOT_EXIST":                                         "The certificate file could not be found",
		"TGT_AUTHENTICATION_ALREADY_ENABLED":                                 "SDS authentication is already enabled",
		"TGT_AUTHENTICATION_ALREADY_DISABLED":                                "SDS authentication is already disabled",
		"TGT_AUTHENTICATION_ERROR":                                           "Error authenticating the SDS",
		"TGT_AUTHENTICATION_DISABLED":                                        "SDS authentication is disabled",
		"CERTIFICATE_ALREADY_BEING_GENERATED":                                "A certificate is already being generated",
		"ERROR_LOADING_AUTHENTICATION_IN_MDM":                                "Error loading the authentication library in the MDM",
		"USER_CAN_NOT_DELETE_HIMSELF":                                        "You can not delete your own LDAP service.",
		"LDAP_ROLE_ALREADY_ASSIGNED":                                         "The role is already assigned to a group, use --allow_overwrite to change the role's group.",
		"IPV6_NOT_ALLOWED_UNTIL_UPGRADED":                                    "IPv6 addresses are not allowed until the upgrade process is complete",
		"CHECKSUM_NOT_ALLOWED_UNTIL_UPGRADED":                                "Checksum is not allowed until the upgrade process is complete",
		"TAKEOVER_NOT_ALLOWED_UNTIL_UPGRADED":                                "Device Takeover is not allowed until the upgrade process is complete",
		"SECURED_COMMUNICATION_DISABLED":                                     "Secured communication with management clients is disabled.",
		"LDAP_USER_ALREADY_IN_ROLE":                                          "User already in current role",
		"SECURITY_NOT_SUPPORTED":                                             "Security features are not supported on this operating system",
		"ERROR_CREATING_SSL_KEY_PAIR":                                        "Failed creating the SSL/TLS key-pair",
		"ERROR_CREATING_AUTH_KEY_PAIR":                                       "Failed creating the authentication key-pair",
		"LDAP_SERVICE_NAME_ALREADY_EXISTS":                                   "LDAP service entry with the same name already exist.",
		"MDM_WRONG_CLUSTER":                                                  "The MDM belongs to a different cluster",
		"GET_INFO_CANNOT_CREATE_DIRECTORY":                                   "Get_info failed. Cannot create directory",
		"GET_INFO_MISSING_PARAMETERS":                                        "Get_info failed. Missing password/username/output path",
		"SECTOR_SIZE_NOT_SUPPORTED":                                          "One of the devices is using a sector size different than 512 bytes per sector. Currently, VxFlex OS only supports SDS devices with 512 bytes per sector.",
		"LIA_SCINI_IN_USE":                                                   "LIA can't remove SDC because scini module is in use",
		"TGT_ADD_RFCACHE_DEV_OPEN_ERROR":                                     "Could not open RFcache Device",
		"SDC_ALREADY_APPROVED":                                               "The SDC is already approved.",
		"LIA_LOW_DISK_SPACE":                                                 "Disk space is too low for LIA to operate",
		"DEV_PATH_ALREADY_EXISTS":                                            "A device with the given path already exists in the SDS",
		"CLUSTER_COMMANDS_BLOCKED_DURING_UPGRADE":                            "Cluster commands are blocked during the MDM cluster upgrade. Allow commands during the upgrade to perform this operation.",
		"DEVICE_ERROR_REPORTED":                                              "Device has an unhandled error that cannot yet be cleared",
		"TOO_MANY_OBJECTS_FOR_CONTAINER":                                     "There are too many objects of type for a single container",
		"LIA_UNINSTALL_COMMAND_FAILED":                                       "Uninstall command was not successful",
		"LIA_INSTALL_COMMAND_FAILED":                                         "Installation command was not successful",
		"LIA_GET_COMPONENTS_COMMAND_FAILED":                                  "Get Installed Components command was not successful",
		"LIA_GET_FLAVOUR_COMMAND_FAILED":                                     "Get Linux Flavour command was not successful",
		"REMOVE_COMMAND_FAILED":                                              "Remove command was not successful",
		"LIA_START_SERVICE_COMMAND_FAILED":                                   "Start service command was not successful",
		"LIA_STOP_SERVICE_COMMAND_FAILED":                                    "Stop service command was not successful",
		"LIA_GET_IP_ADDRESS_COMMAND_FAILED":                                  "Get IP address command was not successful",
		"PREPARE_DISK_COMMAND_FAILED":                                        "Prepare Disk command was not successful",
		"WHICH_COMMAND_FAILED":                                               "Which command was not successful",
		"RESTART_COMMAND_FAILED":                                             "Restart command was not successful",
		"RENAME_COMMAND_FAILED":                                              "Rename command was not successful",
		"LIA_INSTALLATION_FILE_NOT_EXIST":                                    "The installation file does not exist in the install path",
		"LDAP_GROUP_DOES_NOT_EXIST":                                          "The role to LDAP group assignment could not be found",
		"ADD_DEV_TOO_LONG":                                                   "Adding a device takes too long. This might indicate a problematic device",
		"INVALID_OSC_CNT_WIN_SIZE":                                           "The specified oscillating counter window size is not in the valid range. Please try again with a valid window size.",
		"LIA_DRV_CFG_FAILED":                                                 "drv_cfg command failed",
		"SDC_VERSION_MISMATCH_OLDER_THAN_2_0":                                "SDC version does not match drv_cfg version. SDC version is older than 2.0.",
		"TGT_ADD_RFCACHE_DEV_IO_ERROR":                                       "Add RFcache Device IO error",
		"TGT_ADD_DEV_IO_ERROR_DEBUG":                                         "Add SDS device IO error - device appears offline.",
		"NOT_ENOUGH_HEALTHY_TGTS_FOR_MM":                                     "Not enough healthy SDSs to enter Maintenance Mode. In order to enter Maintenance Mode on an SDS, at least 2 additional healthy SDSs are required.",
		"ERROR_UPDATING_SECURITY_CONF":                                       "Failed updating the security configuration",
		"DEV_ALREADY_TAKEN_BY_US_OR_ANOTHER":                                 "Device already added to another SDS. To override, add the specific sds device with force device takeover.",
		"MM_FAILED_REBUILD_DISABLED_ON_SP":                                   "Cannot enter Maintenance Mode - rebuild is disabled on one of the Storage Pools. Please enable rebuild and try again.",
		"CERT_CHANGED_RECENTLY":                                              "Changing the certificate twice in a short time is not allowed.",
		"LIA_REBOOT_REQUIRED":                                                "A reboot is required to complete the operation",
		"RFCACHE_DEV_IS_PARTITIONED":                                         "Unable to add a RFcache Device that was partitioned",
		"AMS_INVALID_VLAN_ID":                                                "Invalid VLAN ID. VLAN ID must be in range of 0 to 4094",
		"RETRY_BETTER_CANDIDATE":                                             "Retry due to currently better candidate",
		"OLD_ACTOR_GENERATION_CANDIDATE":                                     "Voter candidate actor-generation is newer than message actor-generation",
		"MDM_BUSY":                                                           "The system is busy. Retry later",
		"LDAP_TIMEOUT":                                                       "A timeout occurred while running LDAP command",
		"IO_FAULT_FAILED_TO_ALLOC_BUFFER":                                    "IO failed due to insufficient memory",
		"LIA_LED_CFG_ERROR":                                                  "The command was not successful since the device can't be configured with LED settings",
		"LIA_COMMAND_IS_PROHIBITED":                                          "The command is prohibited in this mode",
		"LIA_INVALID_SESSION":                                                "Invalid LIA session. A login is required",
		"FIND_FILE_COMMAND_FAILED":                                           "Find file command was not successful",
		"NUM_VIRT_IPS_NOT_MATCH_NUM_INTFS":                                   "The number of Virtual IPs must be equal or lower than the number of MDM Virtual IP interfaces",
		"MIX_OF_IPV4_AND_IPV6":                                               "Mix of IPv4 and IPv6 is not allowed",
		"LOGIN_BANNER_LARGER_THAN_MAX":                                       "The login banner to set is larger than maximum length allowed",
		"AMS_UPGRADE_ROLLBACK_IS_DISABLED":                                   "Upgrade rollback is disabled at this stage",
		"LOGIN_BANNER_NOT_READ":                                              "The login banner has not been read as required",
		"LOGIN_BANNER_CANNOT_PREEMPTIVE_APPROVE":                             "The login banner cannot be preemptively read",
		"VIRT_IP_INTF_NAME_NOT_EXIST":                                        "Virtual IP interface name does not exist on target machine",
		"VIRT_IP_INTF_NOT_ALLOWED_FOR_TB":                                    "Virtual IP interfaces are not allowed for Tie-Breaker",
		"MDM_STANDBY":                                                        "This command is not supported on the Standby MDM. Please use the Master MDM IP to access the cluster",
		"MDM_NOT_ATTACHED":                                                   "This MDM is not attached to a system.",
		"SUCCESSOR_OOS":                                                      "Cannot accept switchover as the successor is out of sync",
		"NO_MASTER":                                                          "Voter does not have an owner",
		"LIA_REBOOT_INITIATED":                                               "An automatic reboot will start in order to complete the operation",
		"STORAGE_POOL_USING_DAS_CACHE_CANNOT_SET_RFCACHE":                    "This Storage Pool already cached using DAS-Cache thus cannot be set to use RFcache",
		"TOO_MANY_DAS_CACHE_DEVICES":                                         "Too many devices selected. Only up to 2 SSD can be set as DAS Cache devices.",
		"ALERT_EXT_MANAGED_VOL":                                              "This volume is managed externally. If you still want to run this command, use the 'allow_on_externally_managed_volumes' flag.",
		"IO_DISCARD_REQ_MALFORMED":                                           "IO discard request is malformed",
		"IO_DISCARD_REQ_UNALIGNED":                                           "IO discard request is not properly aligned",
		"VVOL_WRONG_OS":                                                      "This is a protected VMWare volume. It can only be mapped to VMWare 6 and above client",
		"VIRT_IP_INTF_NAME_INVALID":                                          "Virtual IP interface name cannot be used",
		"VIRT_IP_INTF_NAME_TOO_LONG":                                         "Virtual IP interface name is too long",
		"LDAP_AUTHORIZER_BIND_FAIL":                                          "Authorizer bind failed",
		"ERROR_WITH_INFO":                                                    "Error information available",
		"AFS_DEV_IN_USE":                                                     "AFS Device in use by another process.",
		"AFS_DEV_OWNED":                                                      "AFS Device marked as owned by another process.",
		"AFS_DEV_HIGHER_VER":                                                 "AFS Device marked as owned by another process.",
		"AFS_DEV_UNKNOWN":                                                    "The device is a non VxFlex OS device.",
		"FD_HAS_ACC_POOLS":                                                   "Protection Domain has Acceleration Pools",
		"ACC_POOL_NOT_FOUND":                                                 "Could not find Acceleration Pool",
		"ACC_POOL_HAS_DEVS":                                                  "The Acceleration Pool Has SDS devices",
		"TOO_MANY_ACC_POOLS_IN_PROTECTION_DOMAIN":                            "There are too many Acceleration Pools in the Protection Domain",
		"FD_AND_ACC_POOL_MISMATCH":                                           "The specified Acceleration Pool is not in the specified Protection Domain",
		"TOO_MANY_ACC_POOLS":                                                 "There are too many Acceleration Pools in the system",
		"ACC_POOL_ALREADY_EXISTS":                                            "Acceleration Pool already exists",
		"INVALID_ACC_POOL_ID":                                                "The Acceleration Pool ID is not valid. Please use a valid ID",
		"ACC_POOL_NAME_ALREADY_EXISTS":                                       "Acceleration Pool name already exists",
		"DUPLICATE_TGT_DEVICE_PATH":                                          "Duplicate SDS device path",
		"INVALID_MIGRATE":                                                    "Invalid migration step",
		"PENDING_TASK_FOUND":                                                 "The outer task should handle pending tasksk after completing the curent step in the subtask",
		"VTREE_MIGRATION_ALREADY_EXISTS":                                     "The V-Tree is already undergoing migration to the same Storage Pool",
		"VTREE_MIGRATE_SAME_SP":                                              "The destination Storage Pool and the source Storage Pool are the same. Please use a destination Storage Pool that is different than the source Storage Pool.",
		"VTREE_MIGRATE_MULTIPLE_SP":                                          "The V-Tree is currently undergoing migration. You can either roll back the current migration or wait for it to complete before initiating another migration.",
		"VTREE_ID_NOT_FOUND":                                                 "The V-Tree with specified ID was not found. Please ensure that you typed the correct V-Tree ID.",
		"SP_STILL_HAS_DEVICES":                                               "Trying to remove an SP while it still contains one or more devices",
		"BAD_FLOW_CONTROL_VALUE":                                             "The provided value is out of range. Please enter a valid percentage value.",
		"TOO_MANY_DEVICES_IN_ACC_POOL":                                       "There are too many devices in Acceleration Pool",
		"ACC_DEV_INSTEAD_OF_TGT_DEV":                                         "An acceleration device is specified where a storage device is expected",
		"TGT_DEV_INSTEAD_OF_ACC_DEV":                                         "A storage device is specified where an acceleration device is expected",
		"TGT_AND_ACC_DEVS_MUST_BELONG_TO_SAME_TGT":                           "The storage device and acceleration device pair must belong to the same SDS",
		"SP_AND_ACC_POOL_MUST_BELONG_TO_SAME_FD":                             "The Storage Pool and Acceleration Pool must belong to the same Protection Domain",
		"INSUFFICIENT_ACC_CAPACITY":                                          "The required acceleration capacity exceeds the amount of available capacity on the acceleration device(s)",
		"DUPLICATE_TGT_DEVS":                                                 "The list of SDS devices contains duplications",
		"CHECKSUM_NOT_CONFIGURABLE":                                          "The checksum feature cannot be configured for the selected devices because they are still undergoing previous configuration changes",
		"CHECKSUM_NOT_ENABLED_ON_DEVICE":                                     "The checksum feature is not enabled on the selected device",
		"DISABLE_CHANGELOG_ACC_PARAMS_NOT_REQUIRED":                          "Changelog acceleration parameters can only be configured if disable_changelog is not specified",
		"CHECKSUM_NOT_ENABLED_ON_SP":                                         "The checksum feature is not enabled on the selected Storage Pool",
		"CHECKSUM_ALREADY_ENABLED_ON_SP":                                     "The checksum feature is already enabled on the selected Storage Pool",
		"CHECKSUM_MODE_IS_NOT_ON_ACC_DEVICE_IN_SP":                           "The checksum mode of the Storage Pool is not persistent_on_acceleration_device. To change the checksum mode please specify it explicitly",
		"CHECKSUM_MODE_IS_NOT_PERSISTENT_IN_SP":                              "The Storage Pool's checksum mode is not one of the persistent options. To change the checksum mode, specify it explicitly in the command",
		"TOO_MANY_ACC_DEVICES":                                               "There are too many acceleration devices for SDS in the given Acceleration Pool",
		"CHANGELOG_NOT_ENABLED_ON_SP":                                        "The changelog feature is not enabled on the selected Storage Pool",
		"CHANGELOG_NOT_CONFIGURABLE":                                         "The changelog feature cannot be configured for the selected devices because they are still undergoing previous configuration changes",
		"SP_AND_TGT_MUST_BELONG_TO_SAME_FD":                                  "The Storage Pool and SDS must belong to the same Protection Domain",
		"SP_AND_TGT_HAVE_NO_COMMON_DEVICES":                                  "The Storage Pool has no storage devices in the given SDS",
		"ACC_DEV_MUST_BELONG_TO_TGT":                                         "The acceleration device must belong to the given SDS",
		"TGT_AND_ACC_POOL_MUST_BELONG_TO_SAME_FD":                            "The SDS and Acceleration Pool must belong to the same Protection Domain",
		"ACC_POOL_MUST_BELONG_TO_GIVEN_FD":                                   "The Acceleration Pool must belong to the specified Protection Domain",
		"ONLY_ONE_ACC_POOL_FOR_RFCACHE_ALLOWED_PER_FD":                       "The Protection Domain already has an Acceleration Pool for RFcache. There cannot be more than one",
		"TGT_DEV_FILE_MIGRATION_IN_PROGRESS":                                 "The device is already during a migration",
		"TGT_DEV_OTHER_FILE_MIGRATION_IS_IN_PROGRESS":                        "Other migration is in progress",
		"FILE_MIGRATION_ABORTED":                                             "File migration was aborted",
		"SPSDS_NOT_FOUND":                                                    "The group of devices of the specified SDS and Storage Pool could not be found",
		"TOO_MANY_SPSDS":                                                     "Too many groups of devices that belong to the specified SDS and Storage Pool",
		"DUPLICATE_SPSDS":                                                    "Duplicated groups of devices that belong to the specified SDS and Storage Pool",
		"FAULT_STALE_DEL_GEN":                                                "Failed processing remote tooth list due to stale del gen",
		"IO_ERR_PERS_CHECKSUM_MISMATCH":                                      "Persistent checksum mismatch",
		"VTREE_MIGRATION_NOT_FOUND":                                          "The V-Tree is not currently being migrated.",
		"MDM_NOT_REACHABLE":                                                  "Wasn't able to reach MDM for notification",
		"COMB_NOT_FOUND":                                                     "Required comb not found",
		"VAE_NOT_FOUND":                                                      "Required VAE not found",
		"WRONG_VAE_GEN_NUM":                                                  "Wrong VAE migration generation number",
		"VTREE_MIGRATION_ALREADY_PAUSING":                                    "The V-Tree migration is already paused.",
		"ACC_DEV_IS_NOT_CLEAR":                                               "The specified acceleration device is currently used by the system for acceleration.",
		"ACC_DEV_ABORT_REMOVE_NOT_SUPPORTED":                                 "Aborting the removal of acceleration device is not supported",
		"USER_CONTENT_DETECTED":                                              "User Content is present on device",
		"NET_MSG_SIZE_LIMIT":                                                 "The sent net message has passed its size limit",
		"VOLUME_MUST_BE_SNAPSHOT_PARENT":                                     "Volume must be direct parent of the snapshot",
		"ACC_POOL_ALREADY_USED_FOR_RFCACHE":                                  "The Acceleration Pool specified can be used only for RFcache",
		"ACC_DEVICE_ALREADY_USED_FOR_RFCACHE":                                "The acceleration device specified can be used only for RFcache",
		"RFCACHE_ACC_POOL_NOT_EXISTS":                                        "RFcache Acceleration Pool must exist in the sds Protection Domain in order to add RFcache devices",
		"CHANGELOG_BAD_POOL_TYPE":                                            "The checksum changelog must reside on NVDIMM devices",
		"ACCELERATION_POOL_IS_NOT_FLASH":                                     "The SSD acceleration pool given is not of the correct type",
		"ACCELERATION_POOL_IS_NOT_NVDIMM":                                    "The NVDIMM acceleration pool given is not of the correct type",
		"ACC_FEATURE_MUST_BE_ENABLED_ON_SP":                                  "The selected feature can only be enabled if it's enabled on the Storage Pool ",
		"INVALID_CHECKSUM_CALCULATION_RATE":                                  "The calculation rate specified is not valid",
		"IO_TIMED_OUT":                                                       "The IO request timed-out",
		"ACC_DEVS_ARE_STILL_BEING_TESTED":                                    "This command cannot be completed; Acceleration devices in the SDS are still being tested",
		"BAD_DEVICE_QUEUE_DEPTH_VALUE":                                       "The provided value is out of range. Please enter a valid value.",
		"CHECKSUM_INSUFFICIENT_TOOTH_DEV_CAPACITY":                           "There is not enough free capacity in the selected device to store checksum",
		"ACC_DEV_MISSING_BACKING_DEV":                                        "The specified backing device for the acceleration device couldn't be found",
		"IO_FAULT_VAE_IS_QUIESCED":                                           "VAE is quiesced due to volume migration roll forward",
		"VTREE_MIGRATION_MUST_BE_PAUSED":                                     "V-Tree migration must be paused before it can be rolled back.",
		"STORAGE_POOL_ALREADY_REMOVED":                                       "The requested SP to be removed has already been removed",
		"BAD_PROVISIONING_VALUE":                                             "The provided value is out of range. Please enter a valid value.",
		"MISSING_MEDIA_TYPE":                                                 "The media type is not configured",
		"INVALID_EXTERNAL_ACCELERATION_TYPE":                                 "The external acceleration type is invalid",
		"MEDIA_TYPE_MISMATCH":                                                "The device media type is not compatible with the Storage Pool media type",
		"INVALID_MEDIA_TYPE":                                                 "The media type is invalid",
		"EXTERNAL_ACCELERATION_TYPE_MISMATCH":                                "The device external acceleration type is not compatible with the Storage Pool external acceleration type",
		"DEVICE_ALREADY_REMOVED_FROM_SP":                                     "The requested device has already been removed from this Storage Pool",
		"DEVICE_NOT_IN_SP":                                                   "The requested device does not belong to this Storage Pool",
		"INI_STILL_REFERENCED":                                               "The requested initiator to be removed is still referenced by an IO request or by Net",
		"NOT_ALL_SPS_HAVE_MEDIA_TYPE":                                        "Not all the Storage Pools have media type configured",
		"NVREF_SPLIT":                                                        "NVRef was split into 2 extents",
		"CHANGELOG_CANNOT_BE_CONFIGURED_IF_CHECKSUM_IS_STORED_ON_NVDIMM_DEV": "Changelog can only be configured if checksum is not stored on NVDIMM device",
		"CANNOT_RELOCATE_CHECKSUM_ON_NVDIMM":                                 "Checksum may not be relocated to NVDIMM devices without first disabling the changelog (because there is no point is checksum and changelog both residing on NVDIMM)",
		"INVALID_CHANGELOG_AMORTIZATION":                                     "The amortization specified is not valid",
		"CHECKSUM_ACC_PARAMS_NOT_REQUIRED":                                   "Checksum acceleration parameters can only be configured if the checksum mode is persistent_on_acceleration_device",
		"CHECKSUM_ACC_DEVS_REQUIRED":                                         "Acceleration devices must be specified with this checksum mode",
		"CHANGELOG_ACC_PARAMS_NOT_REQUIRED":                                  "Changelog can only be configured if the checksum mode is either persistent_on_device or persistent_on_acceleration_device",
		"CHECKSUM_SHOULD_BE_CONFIGURED_SEPARATELY":                           "The enable_checksum flag is DEPRECATED. Please use enable_checksum command",
		"FAILED_TO_ADD_DEV_TO_WBQ":                                           "Tried and failed to add a device to a write back queue",
		"CANNOT_CONFIG_DEVICE_WITH_ERRORS":                                   "Device can be configured only if it has no errors",
		"EXTERNAL_API_ERROR":                                                 "The third party interface returns error",
		"CHANGELOG_MUST_BE_ENABLED_ON_SP":                                    "Command can only be used if changelog is enabled on Storage Pool",
		"INSUFFICIENT_ACC_CHECKSUM_CAPACITY":                                 "The required acceleration capacity for checksum exceeds the amount of available capacity on the acceleration device(s)",
		"INSUFFICIENT_ACC_CHANGELOG_CAPACITY":                                "The required acceleration capacity for changelog exceeds the amount of available capacity on the acceleration device(s)",
		"CANNOT_RESUME_WITH_DEGRADED_CAPACITY":                               "You cannot resume V-Tree migration while there is degraded capacity in Protection Domain. Wait for the degraded capacity to be rebuilt before resuming V-Tree migration.",
		"CANNOT_RESUME_WITH_INACTIVE_PD":                                     "You cannot resume V-Tree migration while the Protection Domain is inactive. Activate the Protection Domain and then resume migration.",
		"ACC_POOL_IS_IN_USE_BY_SPS":                                          "The specified Acceleration Pool is in use by one or more Storage Pools",
		"TGT_DEV_MIGRATION_ID_IS_SMALLER_THAN_LAST_MIGRATION_ID":             "The device got a request for a migration, with an id that is smaller than the last migration id of this device",
		"CHECKSUM_WRONG_GENERATION":                                          "The device got a request for a checksum configuration with different than the known generation of this device",
		"NVDEV_NOT_NVDIMM_MEDIA":                                             "The device is not an NVDIMM drive.",
		"NVDEV_NOT_CONFIGURED":                                               "The NVDIMM drive is not configured.",
		"STORAGE_AND_ACC_DEVICE_COUNT_MISMATCH":                              "The number of storage devices doesn't match the number of acceleration devices",
		"SET_CHECKSUM_MODE_IS_DEPRECATED":                                    "set_checksum_mode command is DEPRECATED, please use enable_checksum/modify_checksum/disable_checksum commands",
		"COMMAND_NOT_SUPPORTED_FOR_RFCACHE_DEVICE":                           "Command is not supported for RFcache devices",
		"TGT_DEV_FILE_MIGRATION_IN_INVALID_STATE":                            "Trying to migrate a file in invalid migration state",
		"CHANGELOG_PARAMS_CANNOT_BE_CONFIGURED_IF_CHANGELOG_IS_ENABLED":      "Changelog parameters can only be configured if changelog is not enabled",
		"FAILOVER_FLAGS_CAN_ONLY_BE_USED_ON_SP_LEVEL":                        "Disabling Write Back Cache on missing capacity can only be used on Storage Pool level",
		"VOL_IS_NOT_RESERVED":                                                "The specified Volume is not reserved",
		"VOL_IS_NOT_RESERVED_BY_INI":                                         "The specified Volume is not reserved by the given SDC",
		"SRC_TOOTH_NOT_FOUND":                                                "The specified source tooth (VtoID, VtoTime) doesn't exist",
		"INVALID_SDC_RESTRICTION_MODE":                                       "Invalid SDC restriction mode",
		"UNAPPROVED_SDC_HAS_MAPPINGS":                                        "Approve the SDC or remove its mappings",
		"MEDIA_TYPE_SHOULD_NOT_BE_SPECIFIED_FOR_ACC_DEVS":                    "Media type should not be specified for acceleration devices",
		"MIGRATION_ERROR":                                                    "Migration Error between SDSs",
		"NO_SPACE_IN_DESTINATION_SP":                                         "No space in destination Storage Pool",
		"UNAVAILABLE_CAPACITY_IN_SOURCE_SP":                                  "Unavailable capacity in source Storage Pool",
		"TGT_COMPLEMENTED_ALLIGNED_DATA":                                     "The data buffer was complemented due to alignment",
		"MIGRATION_WRONG_GENERATION":                                         "The device got a request for a migration with an invalid(0) migration generation number",
		"INVALID_EVENT_TYPE":                                                 "Invalid type specified for custom event.",
		"MIGRATION_IN_PROGRESS":                                              "There is a VTree migration in progress in this Storage Pool. Cancel migrations or wait for them to finish and try again.",
		"NVDIMM_POOL_CANT_BE_USED_FOR_RFCACHE":                               "An Acceleration Pool of type NVDIMM can't be used for RFcache",
		"TOO_MANY_VOLS_IN_DESTINATION_FD":                                    "There are too many volumes in the destination Protection Domain. You can select another destination Protection Domain or remove some of the volumes at the destination.",
		"ACC_DEV_CONFIG_ALREADY_EXIST":                                       "The given acceleration configuration is already configured",
		"UPDATE_DEV_PATH_TOO_LONG":                                           "Updating device path takes too long. This might indicate a problematic device",
		"OBJECT_CHANGED":                                                     "Object changed",
		"REQUEST_QUEUING_TIMEOUT":                                            "A timeout occured before message was sent",
		"TEST_ONLY_CANNOT_BE_USED_FOR_ACC_DEV":                               "The test only mode can't be used for acceleration devices",
		"VTREE_MIGRATION_NOT_PAUSED":                                         "The V-Tree migration is not currently paused.",
		"CHANGELOG_WRONG_GENERATION":                                         "The device got a request for changelog operation with an invalid(0) changelog generation number",
		"SHM_DIFF_FROM_FILE":                                                 "This MDM's shared memory differs from the file.",
		"SLAVE_SHM_DIFF_FROM_MASTER":                                         "The Slave MDM's shared memory differs from the Master MDM.",
		"SPEF_CAN_ONLY_BE_USED_FOR_SSD_SP":                                   "Fine granularity can only be selected for Storage Pool with media type SSD",
		"COMPRESSION_METHOD_ONLY_RELEVANT_FOR_SPEF":                          "Compression may only be enabled on volumes with Fine Granularity layout",
		"SPEF_SP_CAN_ONLY_BE_SSD":                                            "Fine granularity Storage Pools can only have SSD media type",
		"SPEF_SP_CAN_ONLY_HAVE_SSD_DEVICES":                                  "Fine granularity Storage Pools can only be added devices with SSD media type",
		"VTREE_MAY_NOT_MIGRATED_TO_DIFFERENT_DATA_LAYOUT":                    "V-Trees with multiple volumes, or V-Trees that are included in a snapshot policy, may not be migrated between Storage Pools with different data layouts.",
		"SNAPSHOT_NOT_ALLOWED_DURING_MIGRATION_TO_DIFFERENT_DATA_LAYOUT":     "No Snapshots or auto snapshots may be taken during migration to a Storage Pool with a different data layout",
		"SPEF_ACC_POOL_ONLY_RELEVANT_FOR_SPEF":                               "Acceleration Pool is only relevant for fine granularity data layout",
		"INSUFFICIENT_ACC_SPEF_CAPACITY":                                     "The required acceleration capacity for fine granularity exceeds the amount of available capacity on the acceleration device(s)",
		"SPEF_ACC_POOL_MUST_BE_SPECIFIED":                                    "Acceleration Pool must be specified with fine granularity data layout",
		"SPEF_ACC_POOL_MUST_BE_NVDIMM":                                       "The Acceleration Pool used for fine granularity must have media type NVDIMM",
		"ZERO_PADDING_NOT_CONFIGURABLE_FOR_SPEF_SP":                          "Zero padding is not configurable for fine granularity Storage Pools",
		"OPERATION_NOT_SUPPORTED_FOR_SPEF_SP":                                "This operation is not supported for fine granularity Storage Pools",
		"RAM_CACHE_NOT_SUPPORTED_FOR_SPEF_SP":                                "RAM Read Cache is not supported for fine granularity Storage Pools",
		"RAM_CACHE_NOT_SUPPORTED_FOR_SPEF_VOL":                               "RAM Read Cache is not supported for fine granularity Volumes",
		"OBFUSCATION_NOT_SUPPORTED_FOR_MIGRATION":                            "V-Tree migration to Storage Pools with different data layouts is not supported with obfuscation.",
		"UNAPPROVED_SDC_IPS":                                                 "The current SDC IP must be in the set of IPs.",
		"CANCELLED_DUE_TO_CHANNEL_INCREASE":                                  "Command has been cancelled due to channel increase",
		"ACC_DEV_CONFIG_IN_PROGRESS":                                         "The given acceleration configuration is already in progress",
		"VTREE_NOT_FOUND":                                                    "The VTree was not found",
		"EXISTING_BAD_HOST_NAME":                                             "Command failed due to existing bad host names (should be removed to succeed)",
		"OSC_CNT_FAILURES_THRESHOLD_CANNOT_BE_ZERO":                          "The oscillating counter failures threshold cannot be zero. Please try again with a valid threshold.",
		"OLD_GEN":                                          "The Generation number is older than the current one",
		"NOT_ALLOWED_IN_SP_WITH_VOLS":                      "This operation is only allowed when there are no volumes in the Storage Pool.",
		"USE_FORCE_ONLY_WITH_ROLE_ALL":                     "The force flag may be used only with role 'all'.",
		"UPGRADE_POST_PROCESSING_IN_PROGRESS":              "The system is performing upgrade post processing. Please wait for the process to finish.",
		"SP_CAPACITY_LIMIT_REACHED":                        "The total capacity of volumes per Storage Pool was exceeded",
		"TOO_MUCH_THIN_CAPACITY_FOR_REMOVAL":               "Reducing the capacity of the Storage Pool would cause insufficient resources for the already allocated Volumes. Add capacity to the Storage Pool and retry this operation",
		"THICK_NOT_SUPPORTED_FOR_SPEF":                     "Cannot migrate a thick-provisioned V-Tree into a fine granularity Storage Pool. Set the conversion flag to thin-provisioned and try migrating again.",
		"VTREE_ALREADY_THIN":                               "The V-Tree is already thin-provisioned.",
		"VTREE_ALREADY_THICK":                              "The V-Tree is already thick-provisioned.",
		"VTREE_IS_NON_ZERO_PADDED":                         "The V-Tree is thick-provisioned and non-zero-padded, so the capacity reduction due to the migration will be minimal.",
		"REVERSED_MIGRATION_CANNOT_CHANGE_THICKNESS":       "The V-Tree cannot be converted to thick/thin provisioning when reversing migration direction.",
		"PMEM_API_NOT_AVAILABLE":                           "The PMEM API is not available.",
		"SNAP_POLICY_LEVELS_OUT_OF_RANGE":                  "The total number of snapshots for the policy exceeds the allowed maximum",
		"UNSOPPRTED_HARDWARE":                              "Operation is unsupported by hardware",
		"SNAP_POLICY_NAME_ALREADY_EXISTS":                  "Snapshot policy name already exists",
		"TOO_MANY_SNAP_POLICIES":                           "There are too many snapshot policies in the system",
		"TOO_MANY_SNAP_POLICY_LEVELS":                      "Too many snapshot policy levels",
		"INVALID_SNAP_POLICY_ID":                           "Invalid snapshot policy ID. Please try again with the correct ID.",
		"SNAP_POLICY_NOT_FOUND":                            "The snapshot policy was not found",
		"SOURCE_VOL_ALREADY_IN_SNAP_POLICY":                "The source volume is already associated with a Snapshot Policy",
		"SOURCE_VOL_CANT_BE_AUTO_SNAPSHOT":                 "The specified volume is an auto snapshot and can't be used as a source volume",
		"TWO_SNAP_POLICY_SRC_VOLS_OF_SAME_VTREE":           "A single VTree cannot contain more than one Snapshot Policy source-volume",
		"SNAP_POLICY_HAS_SOURCE_VOLUMES":                   "The operation cannot be completed because the Snapshot Policy has source volumes associated with it",
		"SOURCE_VOL_NOT_IN_SNAP_POLICY":                    "The source volume is not associated with the Snapshot Policy",
		"TOO_MANY_SRC_VOLS_IN_SNAP_POLICY":                 "Too many source volumes associated with the Snapshot Policy",
		"VOL_NOT_AUTO_SNAP":                                "The specified volume is not an auto-snapshot and hence cannot be locked",
		"AUTO_SNAP_ALREADY_LOCKED":                         "The auto-snapshot is already locked",
		"AUTO_SNAP_NOT_LOCKED":                             "The auto-snapshot is not locked",
		"DEVICE_ERROR_CANNOT_BE_CLEARED_TILL_EMPTY":        "This SDS device error cannot be cleared until all data is evacuated from it.",
		"COMPRESSION_ONLY_ALLOWED_MG_TO_SPEF":              "Cannot change V-Tree compression method unless migrating from a medium granularity Storage Pool to a fine granularity Storage Pool.",
		"AUTO_SNAP_IS_MAPPED":                              "The auto-snapshot cannot be unlocked while it is mapped",
		"UNLOCK_WILL_REMOVE_AUTO_SNAP":                     "The auto-snapshot will be removed by the Snapshot Policy following unlock. Please acknowledge this explicitly by specifying the auto-snapshot will be removed parameter",
		"VOL_IS_UNLOCKED_AUTO_SNAPSHOT":                    "The volume is an auto-snapshot and must be locked in order to perform this operation",
		"LOCKED_AUTO_SNAPSHOTS_EXIST":                      "The source volume has locked auto-snapshots that cannot be removed. Please unlock them, or use the option detach locked auto snapshots",
		"VOL_IS_SNAP_POLICY_SOURCE_VOL":                    "Volume is a source-volume of a Snapshot Policy",
		"SCG_WITH_AUTO_SNAPSHOTS_CANNOT_BE_REMOVED":        "The snapshot consistency group cannot be removed because it contains auto snapshots",
		"SNAP_POLICY_CADENCE_OUT_OF_RANGE":                 "The cadence value is out of range",
		"SNAP_POLICY_LEVEL_ONE_MEANINGLESS":                "The number of snapshots to retain at any level can't be one when additional levels are defined",
		"SPEF_COMMAND_NOT_SUPPORTED_ON_MG_SP":              "The command is only supported on fine granularity Storage Pools",
		"SPEF_COMMAND_NOT_SUPPORTED_ON_MG_DEV":             "The command is only supported on fine granularity devices",
		"IO_FAULT_LAYOUT_MISMATCH":                         "IO arrived to a SP with of the wrong type",
		"TGT_DEVICE_NOT_READY":                             "The SDS device is not ready",
		"SPEF_COMMAND_NOT_SUPPORTED_ON_MG_VTREE":           "The command is only supported on fine granularity VTrees",
		"SPEF_COMMAND_NOT_SUPPORTED_ON_MG_VOL":             "The command is only supported on fine granularity Volumes",
		"IO_FAULT_ALIGNMENT_MISMATCH":                      "an unaligned IO arrived to a SP",
		"IO_FAULT_NOT_T":                                   "a request to T comb arrived to a non T copy",
		"IO_SUSPENDED_TO_FILE":                             "The file is currently in suspended status",
		"INI_IS_REFERENCED":                                "The Initiator(SDC) object to be destroyed turned out to still be needed after all",
		"ILLEGAL_OFFSET_ALIGNMENT":                         "The given offset is not aligned with the device native sector size",
		"ILLEGAL_SIZE_ALIGNMENT":                           "The given size is not aligned with the device native sector size",
		"COMB_DATA_CORRUPT":                                "Comb data cannot be used to answer IOs",
		"INVALID_FGL_NVDIMM_WRITE_CACHE_SIZE":              "The requested fine granularity NVDIMM write cache size is invalid",
		"INVALID_FGL_METADATA_SIZE":                        "The requested fine granularity metadata size is invalid",
		"INVALID_FGL_EXTRA_CAPACITY":                       "The requested fine granularity extra capacity is invalid",
		"INVALID_FGL_OVER_PROVISIONING_FACTOR":             "The requested fine granularity over provisioning factor is invalid",
		"INVALID_FGL_WRITE_ATOMICITY_SIZE":                 "The requested fine granularity write atomicity size is invalid",
		"INVALID_FGL_PROFILE":                              "The requested fine granularity performance profile is invalid",
		"INVALID_FGL_NUM_CONCURRENT_WRITES":                "The requested fine granularity num concurrent writes is invalid",
		"INVALID_FGL_NVDIMM_METADATA_AMORTIZATION":         "The requested fine granularity NVDIMM metadata amortization is invalid",
		"INVALID_FGL_MAX_COMPRESSION_RATIO":                "The requested fine granularity maximum compression ratio is invalid",
		"AMS_ADD_DEVICE_REQUIRE_SVM_MEM_CHANGE":            "Add device requires the SVM memory to change",
		"FAILED_TO_CALCULATE_REQUIRED_SVM_MEMORY":          "Failed to calculate the required SVM memory",
		"FAILED_TO_RECONFIGURE_SVM_MEMORY":                 "Failed to reconfigure the SVM memory",
		"ERROR_WRITING_CERTIFICATE_FILE":                   "Error writing the certificate file",
		"ERROR_READING_CERTIFICATE_FILE":                   "Error reading the certificate file",
		"DATA_COMPARISON_MODE_NOT_SUPPORTED_FOR_SPEF_SP":   "Data comparison mode for background device scanner is not supported for fine granularity Storage Pools",
		"UNDER_RECONSTRUCT":                                "The acceleration file is being reconstructed and no operations are allowed on it.",
		"HW_AWARE_HYPERVISOR_DISABLED":                     "Running under hypervisor with no visible RAID controllers - disabling HW awareness.",
		"ACC_DEV_MUST_BELONG_TO_SAME_FGL_ACC_POOL":         "The acceleration device must belong to the same Acceleration Pool as currently configured for fine granularity",
		"AMS_REQUIRE_SVM_CFG_CHANGE":                       "The SVM configuration must be changed which may require an SVM reboot",
		"INSUFFICIENT_ELOCK_PROTECTION":                    "Elock coverage is insufficient need to expand",
		"VIRT_IP_INTF_BAD_ASSIGNMENT":                      "The virtual IP address should either share the physical subnet address of its interface or not share the subnet address of none of the interfaces",
		"LDAP_USER_FQDN_DIFFERS_FROM_SERVICE":              "Domain path of user differs from the LDAP service domain",
		"INVALID_FGL_CHANGELOG_CONFIGURATION":              "The requested fine granularity changelog configuration is invalid",
		"SYSTEM_NAME_IN_USE":                               "System name already in use. Please try a different name.",
		"COMB_DATA_CORRUPT_REMOTE":                         "Raid comb data cannot be used to answer IOs",
		"CHECKSUM_CONFIG_MISMATCH":                         "Checksum configuration mismatch between SDC and SDS",
		"DEVICE_DATA_CORRUPTED":                            "Device data cannot be used to answer IOs",
		"APPROVED_SDC_HAS_WRONG_IP":                        "Approve the IP addresses for the SDC or remove its mappings",
		"VTREE_MAY_NOT_MIGRATED_TO_DIFFERENT_ZERO_PADDING": "You cannot migrate a V-Tree between Storage Pools with different zero-padding settings.",
		"SYSTEM_CAPACITY_LIMIT_REACHED":                    "The total capacity of volumes per system was exceeded",
		"MUST_SPECIFY_MEDIA_TYPE":                          "The target Storage Pool is configured with the Transitional media type. The device media type should be provided explicitly when adding a device to the Storage Pool.",
		"NO_ACC_DEVICES":                                   "This operation cannot be completed because there are no acceleration devices in the SDS that belong to the required acceleration pool",
		"PARTIAL_SUCCESS":                                  "Partial success.",
		"UNIMPLEMENTED":                                    "Service is unimplemented.",
		"NOT_A_SPEF_DEVICE":                                "The device is not formatted for fine granularity",
		"ENTRY_NOT_FOUND":                                  "A SPEF user-data entry was not found in a Log.",
		"METADATA_INTEGRITY_ERROR":                         "Metadata integrity compromised.",
		"METADATA_CORRUPTED":                               "Metadata is corrupted; device must be formatted.",
		"VTREE_SNAPTIME_CHANGED":                           "VTree time has changed due to snapshot deletion or creation, may need to restart action for consistency.",
		"DELETION_TASK_DISCARDED":                          "A Deletion task (VTree/Snapshot/Octet) was discarded externally",
		"VOLUME_DELETION_CANCELED_DUE_TO_VTREE_DELETION":   "The Snapshot deletion was canceld due to the host V-Tree deletion",
		"MISSING_AFS_FILES":                                "Some Acceleration-Device Files required for the operation are missing",
		"FAILED_TO_CREATE_AFS_FILE":                        "Acceleration-Device Files required for the operation could not be created",
		"DEV_NOT_EMPTY":                                    "The device cannot be detached since it is not empty",
		"SPEF_LOGICAL_ADDRESS_MISMATCH":                    "The spef logical address saved for an entry doesn't match the one in the read request.",
		"THICK_VOLUME_CANNOT_BE_ADDED_TO_SPEF_SP":          "Thick volumes cannot be added to fine granularity Storage Pools",
		"RFCACHE_NOT_SUPPORTED_FOR_SPEF_SP":                "RFcache is not supported for fine granularity Storage Pools",
		"SPEF_ALLOWED_ONLY_AFTER_UPGRADE_COMPLETES":        "Fine granularity Storage Pools may not be defined before the upgrade process completes",
		"INCOMPLETE_DATA":                                  "The request cannot be satisfied due to incomplete data at the source",
		"SPEF_ACC_DEV_MUST_BE_NVDIMM":                      "The acceleration devices used for fine granularity must have media type NVDIMM",
		"SPEF_NOT_CONFIGURABLE":                            "The fine granularity settings cannot be configured for the selected devices because they are still undergoing previous configuration changes",
		"USER_CONTENT_POSSIBLE":                            "User content might be present on device.",
		"BLOCK_WAS_NOT_SHRINKED":                           "the block was not shrinked",
		"BLOCK_WAS_NOT_EXPANDED":                           "the block was not expanded",
		"INSUFFICIENT_DATA_TO_SYNC":                        "The sync buffer has insufficient data to finalize the sync",
		"SYNC_DST_ADDRESS_MISMATCH":                        "The destination address for sync mismatches the sync-buffer",
		"EXECUTION_LAUNCHED":                               "Execution launched successfully",
		"SPEF_UDSM_LOG_SWAP_NEEDED":                        "The udsm log needs to be swapped",
		"SPEF_NO_MORE_UD_LOGS":                             "An attempt was made to activate a UD log but none were found",
		"VTREE_STRUCTURE_DISCREPANCY_CANNOT_SYNC":          "VTree structure has changed, and the sync cannot be applied.",
		"SINGLE_DATA_ENTRY_CORRUPTED":                      "Persistent-checksum mismatch found for a single sepcific user-data entry",
		"MULTIPLE_DATA_ENTRIES_CORRUPTED":                  "Pereistent-checksum mismatch found for multiple user-data entries",
		"FAILED_UNSTABLE":                                  "unstable state of a component due to a request that terminated prematurely",
		"OP_CANCELED_DUE_TO_DESTRUCTION":                   "The op was canceled due to the module destruction",
		"TIME_QUOTA_EXPIRED":                               "The time-quota assigned for the operation has expired",
		"MOVED_TO_GC_VTREE":                                "The relevant address space (octet/comb) to operate on, was move to Garbage VTree",
		"VTREE_TIME_EARLIER_THAN_REQUEST_TIME":             "The target VTree's time is earlier than the request-time.",
		"BOUNDS_CHECK_FAILED":                              "The requested IO address failed inter-module bounds check",
		"NO_MORE_TRIES":                                    "Exceeded the number of retries for sending message from MDM to SDS",
		"INVALID_SP_SDS_ID":                                "The SP-SDS ID is not valid. Please use a valid ID",
		"VIRT_IP_IS_PHYSICAL":                              "Cannot use physical IP address for virtual IP",
		"INCOMPATIBLE_EXTENT_INTEGRITY_DESCS":              "Cannot compare incompatible Extent Integrity Descriptors",
		"LDAP_PASSWORD_MUST_CHANGE":                        "The password for this user should be changed, please change it before login",
		"SSD_ACC_POOLS_MUST_BE_RFCACHE":                    "The selected media type can only be used for RFcache Acceleration Pool",
		"SDC_COUNTERS_EXPECT_ALL_ADC_FLAG":                 "This failure_counter requires all_sdc flag to be specified",
		"RFCACHE_DEV_IS_MOUNTED":                           "Unable to add a RFcache Device that was already mounted",
		"STORAGE_POOL_WOULD_BECOME_CRITICAL":               "Removal operation would make the capacity usage of a Storage Pool critical. Use the 'force' flag to override.",
		"DEST_VOL_IS_LOCKED_AUTO_SNAPSHOT":                 "The destination volume is a locked auto snapshot. Please acknowledge this explicitly by specifying the overwrite locked auto snapshot parameter",
		"CANNOT_RESUME_IN_MAINT_MODE":                      "You cannot resume V-Tree migration while there is maintenance-mode in Protection Domain. Wait for the maintenance-mode to finish before resuming V-Tree migration.",
		"VOL_MAP_TIMEOUT":                                  "The volume map operation timed out.",
		"DEVICE_ERROR_CANNOT_BE_CLEARED":                   "This SDS device error cannot be cleared",
		"INTERFD_CONNECTIVITY_PROBLEM_FOR_MIG_ONE":         "One destination SDS is not connected to all source SDSs",
		"INTERFD_CONNECTIVITY_PROBLEM_FOR_MIG_SOME":        "Some destination SDSs are not connected to some source SDSs",
		"INTERFD_CONNECTIVITY_PROBLEM_FOR_MIG_ALL":         "ALL destination SDSs are not connected to all source SDSs",
		"MDM_REPOSITORY_CORRUPTED":                         "The MDM repository (either file or shared memory) is corrupted",
		"VTREE_MIGRATION_NOT_ALLOWED":                      "This V-Tree migration is not allowed",
		"MDM_TOO_NEW":                                      "The version of the MDM is too new",
		"SPEF_NEEDS_HIGH_PERF_PROFILE":                     "Fine granularity can only run on SDSs configured with high performance profile",
		"NET_OBJ_ID_MISMATCH":                              "The network ID of the remote cluster node is different from the ID on the Master",
		"AT_LEAST_ONE_TGT_DOWN":                            "This operation cannot be performed unless all SDSs are up and running",
		"TOO_MANY_VOLS_IN_CONSISTENCY_GROUP":               "There are too many volumes in the consistency group",
		"TOO_MANY_INIS":                                    "There are too many SDCs in the system",
		"TGT_IS_DOWN":                                      "This operation cannot be performed unless SDS is up and running",
		"TOO_MANY_VTREES_IN_FD":                            "There are too many VTrees in the Protection Domain",
		"TGT_CAPACITY_LIMIT_EXCEEDED":                      "The capacity of the devices in this SDS exceeds the maximum limit",
		"IP_BELONGS_TO_OTHER_SDC":                          "The specified IP address can not be used to identify SDC. Please check that IP address is correct and not duplicated or specify GUID instead.",
		"RETRY_LIMIT_EXCEEDED":                             "This action has been re-tried more times than is allowed.",
		"ERROR_ENABLING_FIPS":                              "Failed to enable FIPS mode",
		"DEV_HAS_USED_CAPACITY":                            "The device still has a V-Tree that was not deleted",
		"DEV_IS_NOT_IN_ERROR":                              "Device can be force removed only if it has error, or its SDS is disconnected",
		"PHOENIX_CREATE_FILE_SYSTEM_FAILED":                "File System Creation Failed",
		"PHOENIX_DELETE_FILE_SYSTEM_FAILED":                "File System Deletion Failed",
		"PHOENIX_FILE_SYSTEM_NAME_IN_USE":                  "File System name is already in use",
		"PHOENIX_VOL_HAS_EXISTING_FILE_SYSTEM":             "Volume already has an existing File System",
		"PHOENIX_FILE_SYSTEM_NOT_FOUND":                    "File System not found",
		"PHOENIX_FILE_SYSTEM_NOT_MAPPED":                   "File System not mapped to any host",
		"PHOENIX_ASYNC_PROCESS_ENTITIES_IN_USE":            "Another operation is already running on the requested entity",
		"PHOENIX_INVALID_IP_POOL":                          "IP range is invalid",
		"PHOENIX_INVALID_IP_POOL_DUP_NAME":                 "There is already an IP pool with the same name",
		"PHOENIX_INVALID_IP_POOL_DUP_IPS":                  "IP pool contains IPs that appear on other IP pools",
		"PHOENIX_IP_POOL_NOT_EXIST":                        "IP pool does not exist",
		"PHOENIX_IP_POOL_CONTAINED_IPS_IN_USE":             "IP that was contained in the pool already being used",
		"PHOENIX_IP_POOL_IN_USE":                           "IP pool is in use by an existing compute environment",
		"PHOENIX_NOT_ENOUGH_FREE_IPS_FOR_VMKERNEL":         "Not enough free IPs in the selected IP pool",
		"PHOENIX_ENVIRONMENT_NOT_FOUND":                    "Environment not found",
		"PHOENIX_INVALID_COMPUTE_ENV_SPEC":                 "Invalid or missing Compute Environment Spec",
		"PHOENIX_INVALID_NETWORK_ENV_SPEC":                 "Invalid or missing Network Environment Spec",
		"PHOENIX_INVALID_HYPERVISOR_MANAGER":               "Invalid or missing Hypervisor Manager",
		"PHOENIX_ENVIRONMENT_HAS_EXISTING_COMPUTE":         "Environment already has an existing compute component",
		"PHOENIX_CLUSTER_NAME_IN_USE":                      "Cluster name is already in use",
		"PHOENIX_HOST_NOT_FOUND":                           "Host not found",
		"PHOENIX_FAILED_DELETE_COMPUTE_ENV":                "Failed deleting compute environment",
		"PHOENIX_ENV_TOO_SMALL_FOR_WL":                     "Not enough compute resources in the environment to support the requested workload",
		"DELETE_WORKLOAD_WHEN_NOT_ALL_VMS_ARE_OFF":         "Cannot delete workload, some of the VMs are not powered off",
		"PHOENIX_NOT_READY":                                "Phoenix module is not ready for incoming request",
		"PHOENIX_EXTEND_WL_NO_TEMPLATE":                    "Extend workload failed to find the VM template to be used",
		"PHOENIX_WORKLOAD_DOES_NOT_EXIST":                  "Workload does not exist",
		"PHOENIX_FAILED_TO_DELETE_VIRTUAL_MACHINE":         "Failed to delete virtual machine",
		"PHOENIX_VM_TEMPLATE_MISSING_NETWORK":              "Virtual Machine Template is missing network adapters",
		"PHOENIX_VM_TEMPLATE_MISSING_VALID_TOOLS":          "Virtual Machine Template has invalid VMware Tools",
		"PHOENIX_INVALID_VM_TEMPLATE":                      "Invalid Virtual Machine template specified",
		"PHOENIX_INVALID_ENVIRNOMENT_NAME":                 "Invalid or missing Environment name",
		"PHOENIX_INVALID_STORAGE_POOL_ID":                  "Invalid or missing Storage Pool for the target Environment",
		"PHOENIX_VM_NETWORK_CONFIG_MISMATCH":               "Specified number of VM network configs does not match VM template",
		"PHOENIX_INVALID_VM_NETWORK_CONFIGURATION":         "Invalid VM network configuration specified",
		"PHOENIX_COMPUTE_ENVIRONMENT_CONTAINS_VMS":         "Compute Environment contains VMs",
		"PHOENIX_FILE_SYSTEM_CONTAINS_VMS":                 "File System contains VMs or Templates",
		"PHOENIX_ENTITY_TYPE_DOES_NOT_EXIST":               "Entity type not found",
		"PHOENIX_INSUFFICIENT_HOSTS_IN_CLUSTER":            "Unable to create Compute Cluster : Insufficient hosts specified",
		"PHOENIX_CANNOT_DELETE_DEFAULT_PROFILE":            "Deleting default profile is not allowed",
		"PHOENIX_INVALID_COMPUTE_OVERCOMMIT_VALUE":         "Invalid compute overcommit value. Must be greater than 1.00",
		"PHOENIX_HOST_NOT_CONNECTED_TO_VCENTER":            "Host is not connected to vCenter",
		"PHOENIX_IP_RANGES_OVERLAP":                        "Provided IP Pools overlap",
		"PHOENIX_INSUFFICIENT_IPS_PROVIDED":                "Insufficient IPs provided",
		"PHOENIX_PORT_GROUP_NAME_IN_USE":                   "Port Group name is already in use",
		"PHOENIX_INVALID_DATACENTER_ID":                    "Invalid Datacenter ID specified",
		"PHOENIX_INVALID_RAM_OVERCOMMIT_VALUE":             "Invalid RAM overcommit value. Valid range is 1.00 to 2.00",
		"PHOENIX_ENVIRONMENT_HAS_EXISTING_NETWORK":         "Environment already has an existing network component",
		"PHOENIX_ENVIRONMENT_HAS_EXISTING_STORAGE":         "Environment already has an existing storage component",
		"PHOENIX_ENVIRONMENT_CONTAINS_VMS":                 "Environment contains workload VMs",
		"PHOENIX_HOST_HAS_VMS_NO_DRS":                      "Target host has active VMs that must be manually moved before removing host",
		"PHOENIX_INSUFFICIENT_STORAGE_POOL_CAPACITY":       "The specified Storage Pools do not provide sufficient storage capacity",
		"PHOENIX_STORAGE_POOL_NOT_AVAILABLE":               "The specified Storage Pool is not available for volume creation and may be in a degraded state",
		"PHOENIX_CLUSTER_HOST_IN_MAINTENANCE_MODE":         "The specified cluster has a host in maintenance mode",
		"PHOENIX_BAD_ENVIRONMENT_CREATE_REQUEST":           "Bad create environment request",
		"PHOENIX_INVALID_WORKLOAD_NAME":                    "The given workload name contains invalid characters. Use only alphanumeric, spaces, hypen (-), and underscore (_) characters.",
		"PHOENIX_SDS_ENVIRONMENT_NOT_READY":                "The SDS environment is not currently in an ideal state for this operation.",
		"FAIL_TO_VERIFY_IPS":                               "Couldn't verify all of the IPs.Either some of the IPs are disconnected, or the IPs lead to different servers.",
		"PHOENIX_WORKLOAD_NAME_TOO_LONG":                   "The provided workload name is too long. Max size is 18 characters.",
		"GUI_OFFLINE_MODE_COMMANDS_NOT_SUPPORTED":          "Commands are not supported in Offline Mode",
	}

	return errorCodeTranslationMap[code]
}
