/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.code;

import sun.jvm.hotspot.debugger.Address;

public class CompressedStream {
    protected Address buffer;
    protected int position;
    public static final int LogBitsPerByte = 3;
    public static final int BitsPerByte = 8;
    public static final int lg_H = 6;
    public static final int H = 64;
    public static final int L = 192;
    public static final int MAX_i = 4;

    public CompressedStream(Address buffer) {
        this(buffer, 0);
    }

    public CompressedStream(Address buffer, int position) {
        this.buffer = buffer;
        this.position = position;
    }

    public Address getBuffer() {
        return this.buffer;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int encodeSign(int value) {
        return value << 1 ^ value >> 31;
    }

    public int decodeSign(int value) {
        return value >>> 1 ^ -(value & 1);
    }

    public int reverseInt(int i) {
        i = (i & 0x55555555) << 1 | i >>> 1 & 0x55555555;
        i = (i & 0x33333333) << 3 | i >>> 2 & 0x33333333;
        i = (i & 0xF0F0F0F) << 4 | i >>> 4 & 0xF0F0F0F;
        i = i << 24 | (i & 0xFF00) << 8 | i >>> 8 & 0xFF00 | i >>> 24;
        return i;
    }
}

