package trademark

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FillLogistics invokes the trademark.FillLogistics API synchronously
// api document: https://help.aliyun.com/api/trademark/filllogistics.html
func (client *Client) FillLogistics(request *FillLogisticsRequest) (response *FillLogisticsResponse, err error) {
	response = CreateFillLogisticsResponse()
	err = client.DoAction(request, response)
	return
}

// FillLogisticsWithChan invokes the trademark.FillLogistics API asynchronously
// api document: https://help.aliyun.com/api/trademark/filllogistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FillLogisticsWithChan(request *FillLogisticsRequest) (<-chan *FillLogisticsResponse, <-chan error) {
	responseChan := make(chan *FillLogisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FillLogistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FillLogisticsWithCallback invokes the trademark.FillLogistics API asynchronously
// api document: https://help.aliyun.com/api/trademark/filllogistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FillLogisticsWithCallback(request *FillLogisticsRequest, callback func(response *FillLogisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FillLogisticsResponse
		var err error
		defer close(result)
		response, err = client.FillLogistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FillLogisticsRequest is the request struct for api FillLogistics
type FillLogisticsRequest struct {
	*requests.RpcRequest
	BizId     string `position:"Query" name:"BizId"`
	Logistics string `position:"Query" name:"Logistics"`
}

// FillLogisticsResponse is the response struct for api FillLogistics
type FillLogisticsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateFillLogisticsRequest creates a request to invoke FillLogistics API
func CreateFillLogisticsRequest() (request *FillLogisticsRequest) {
	request = &FillLogisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Trademark", "2018-07-24", "FillLogistics", "trademark", "openAPI")
	return
}

// CreateFillLogisticsResponse creates a response to parse from FillLogistics response
func CreateFillLogisticsResponse() (response *FillLogisticsResponse) {
	response = &FillLogisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
