package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGatewayDNS invokes the sgw.DescribeGatewayDNS API synchronously
func (client *Client) DescribeGatewayDNS(request *DescribeGatewayDNSRequest) (response *DescribeGatewayDNSResponse, err error) {
	response = CreateDescribeGatewayDNSResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGatewayDNSWithChan invokes the sgw.DescribeGatewayDNS API asynchronously
func (client *Client) DescribeGatewayDNSWithChan(request *DescribeGatewayDNSRequest) (<-chan *DescribeGatewayDNSResponse, <-chan error) {
	responseChan := make(chan *DescribeGatewayDNSResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGatewayDNS(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGatewayDNSWithCallback invokes the sgw.DescribeGatewayDNS API asynchronously
func (client *Client) DescribeGatewayDNSWithCallback(request *DescribeGatewayDNSRequest, callback func(response *DescribeGatewayDNSResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGatewayDNSResponse
		var err error
		defer close(result)
		response, err = client.DescribeGatewayDNS(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGatewayDNSRequest is the request struct for api DescribeGatewayDNS
type DescribeGatewayDNSRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
	GatewayId     string `position:"Query" name:"GatewayId"`
}

// DescribeGatewayDNSResponse is the response struct for api DescribeGatewayDNS
type DescribeGatewayDNSResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	DnsServer string `json:"DnsServer" xml:"DnsServer"`
}

// CreateDescribeGatewayDNSRequest creates a request to invoke DescribeGatewayDNS API
func CreateDescribeGatewayDNSRequest() (request *DescribeGatewayDNSRequest) {
	request = &DescribeGatewayDNSRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeGatewayDNS", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGatewayDNSResponse creates a response to parse from DescribeGatewayDNS response
func CreateDescribeGatewayDNSResponse() (response *DescribeGatewayDNSResponse) {
	response = &DescribeGatewayDNSResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
