package ocr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizeTable invokes the ocr.RecognizeTable API synchronously
func (client *Client) RecognizeTable(request *RecognizeTableRequest) (response *RecognizeTableResponse, err error) {
	response = CreateRecognizeTableResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizeTableWithChan invokes the ocr.RecognizeTable API asynchronously
func (client *Client) RecognizeTableWithChan(request *RecognizeTableRequest) (<-chan *RecognizeTableResponse, <-chan error) {
	responseChan := make(chan *RecognizeTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizeTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizeTableWithCallback invokes the ocr.RecognizeTable API asynchronously
func (client *Client) RecognizeTableWithCallback(request *RecognizeTableRequest, callback func(response *RecognizeTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizeTableResponse
		var err error
		defer close(result)
		response, err = client.RecognizeTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizeTableRequest is the request struct for api RecognizeTable
type RecognizeTableRequest struct {
	*requests.RpcRequest
	ImageType       requests.Integer `position:"Body" name:"ImageType"`
	UseFinanceModel requests.Boolean `position:"Body" name:"UseFinanceModel"`
	SkipDetection   requests.Boolean `position:"Body" name:"SkipDetection"`
	ImageURL        string           `position:"Body" name:"ImageURL"`
	OutputFormat    string           `position:"Body" name:"OutputFormat"`
	AssureDirection requests.Boolean `position:"Body" name:"AssureDirection"`
	HasLine         requests.Boolean `position:"Body" name:"HasLine"`
}

// RecognizeTableResponse is the response struct for api RecognizeTable
type RecognizeTableResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRecognizeTableRequest creates a request to invoke RecognizeTable API
func CreateRecognizeTableRequest() (request *RecognizeTableRequest) {
	request = &RecognizeTableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ocr", "2019-12-30", "RecognizeTable", "ocr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRecognizeTableResponse creates a response to parse from RecognizeTable response
func CreateRecognizeTableResponse() (response *RecognizeTableResponse) {
	response = &RecognizeTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
