package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateInstance invokes the dms_enterprise.UpdateInstance API synchronously
func (client *Client) UpdateInstance(request *UpdateInstanceRequest) (response *UpdateInstanceResponse, err error) {
	response = CreateUpdateInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateInstanceWithChan invokes the dms_enterprise.UpdateInstance API asynchronously
func (client *Client) UpdateInstanceWithChan(request *UpdateInstanceRequest) (<-chan *UpdateInstanceResponse, <-chan error) {
	responseChan := make(chan *UpdateInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateInstanceWithCallback invokes the dms_enterprise.UpdateInstance API asynchronously
func (client *Client) UpdateInstanceWithCallback(request *UpdateInstanceRequest, callback func(response *UpdateInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateInstanceResponse
		var err error
		defer close(result)
		response, err = client.UpdateInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateInstanceRequest is the request struct for api UpdateInstance
type UpdateInstanceRequest struct {
	*requests.RpcRequest
	SafeRuleId       string           `position:"Query" name:"SafeRuleId"`
	EcsRegion        string           `position:"Query" name:"EcsRegion"`
	DdlOnline        requests.Integer `position:"Query" name:"DdlOnline"`
	UseDsql          requests.Integer `position:"Query" name:"UseDsql"`
	Tid              requests.Integer `position:"Query" name:"Tid"`
	Sid              string           `position:"Query" name:"Sid"`
	DbaId            string           `position:"Query" name:"DbaId"`
	DataLinkName     string           `position:"Query" name:"DataLinkName"`
	InstanceSource   string           `position:"Query" name:"InstanceSource"`
	EnvType          string           `position:"Query" name:"EnvType"`
	Host             string           `position:"Query" name:"Host"`
	InstanceType     string           `position:"Query" name:"InstanceType"`
	QueryTimeout     requests.Integer `position:"Query" name:"QueryTimeout"`
	EcsInstanceId    string           `position:"Query" name:"EcsInstanceId"`
	ExportTimeout    requests.Integer `position:"Query" name:"ExportTimeout"`
	DatabasePassword string           `position:"Query" name:"DatabasePassword"`
	InstanceAlias    string           `position:"Query" name:"InstanceAlias"`
	DatabaseUser     string           `position:"Query" name:"DatabaseUser"`
	InstanceId       string           `position:"Query" name:"InstanceId"`
	Port             requests.Integer `position:"Query" name:"Port"`
	VpcId            string           `position:"Query" name:"VpcId"`
	SkipTest         requests.Boolean `position:"Query" name:"SkipTest"`
}

// UpdateInstanceResponse is the response struct for api UpdateInstance
type UpdateInstanceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateUpdateInstanceRequest creates a request to invoke UpdateInstance API
func CreateUpdateInstanceRequest() (request *UpdateInstanceRequest) {
	request = &UpdateInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "UpdateInstance", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateInstanceResponse creates a response to parse from UpdateInstance response
func CreateUpdateInstanceResponse() (response *UpdateInstanceResponse) {
	response = &UpdateInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
