package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDevopsProjectTaskFlow invokes the devops_rdc.ListDevopsProjectTaskFlow API synchronously
func (client *Client) ListDevopsProjectTaskFlow(request *ListDevopsProjectTaskFlowRequest) (response *ListDevopsProjectTaskFlowResponse, err error) {
	response = CreateListDevopsProjectTaskFlowResponse()
	err = client.DoAction(request, response)
	return
}

// ListDevopsProjectTaskFlowWithChan invokes the devops_rdc.ListDevopsProjectTaskFlow API asynchronously
func (client *Client) ListDevopsProjectTaskFlowWithChan(request *ListDevopsProjectTaskFlowRequest) (<-chan *ListDevopsProjectTaskFlowResponse, <-chan error) {
	responseChan := make(chan *ListDevopsProjectTaskFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDevopsProjectTaskFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDevopsProjectTaskFlowWithCallback invokes the devops_rdc.ListDevopsProjectTaskFlow API asynchronously
func (client *Client) ListDevopsProjectTaskFlowWithCallback(request *ListDevopsProjectTaskFlowRequest, callback func(response *ListDevopsProjectTaskFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDevopsProjectTaskFlowResponse
		var err error
		defer close(result)
		response, err = client.ListDevopsProjectTaskFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDevopsProjectTaskFlowRequest is the request struct for api ListDevopsProjectTaskFlow
type ListDevopsProjectTaskFlowRequest struct {
	*requests.RpcRequest
	ProjectId string `position:"Body" name:"ProjectId"`
	OrgId     string `position:"Body" name:"OrgId"`
}

// ListDevopsProjectTaskFlowResponse is the response struct for api ListDevopsProjectTaskFlow
type ListDevopsProjectTaskFlowResponse struct {
	*responses.BaseResponse
	Successful bool       `json:"Successful" xml:"Successful"`
	ErrorCode  string     `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string     `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Object     []Taskflow `json:"Object" xml:"Object"`
}

// CreateListDevopsProjectTaskFlowRequest creates a request to invoke ListDevopsProjectTaskFlow API
func CreateListDevopsProjectTaskFlowRequest() (request *ListDevopsProjectTaskFlowRequest) {
	request = &ListDevopsProjectTaskFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "ListDevopsProjectTaskFlow", "", "")
	request.Method = requests.POST
	return
}

// CreateListDevopsProjectTaskFlowResponse creates a response to parse from ListDevopsProjectTaskFlow response
func CreateListDevopsProjectTaskFlowResponse() (response *ListDevopsProjectTaskFlowResponse) {
	response = &ListDevopsProjectTaskFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
