package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ShopShowList invokes the cloudwf.ShopShowList API synchronously
// api document: https://help.aliyun.com/api/cloudwf/shopshowlist.html
func (client *Client) ShopShowList(request *ShopShowListRequest) (response *ShopShowListResponse, err error) {
	response = CreateShopShowListResponse()
	err = client.DoAction(request, response)
	return
}

// ShopShowListWithChan invokes the cloudwf.ShopShowList API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopshowlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopShowListWithChan(request *ShopShowListRequest) (<-chan *ShopShowListResponse, <-chan error) {
	responseChan := make(chan *ShopShowListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ShopShowList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ShopShowListWithCallback invokes the cloudwf.ShopShowList API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopshowlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopShowListWithCallback(request *ShopShowListRequest, callback func(response *ShopShowListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ShopShowListResponse
		var err error
		defer close(result)
		response, err = client.ShopShowList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ShopShowListRequest is the request struct for api ShopShowList
type ShopShowListRequest struct {
	*requests.RpcRequest
	Gid        requests.Integer `position:"Query" name:"Gid"`
	Address    string           `position:"Query" name:"Address"`
	Name       string           `position:"Query" name:"Name"`
	Dirc       string           `position:"Query" name:"Dirc"`
	Page       requests.Integer `position:"Query" name:"Page"`
	Bid        requests.Integer `position:"Query" name:"Bid"`
	Per        requests.Integer `position:"Query" name:"Per"`
	ShopStatus requests.Integer `position:"Query" name:"ShopStatus"`
}

// ShopShowListResponse is the response struct for api ShopShowList
type ShopShowListResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateShopShowListRequest creates a request to invoke ShopShowList API
func CreateShopShowListRequest() (request *ShopShowListRequest) {
	request = &ShopShowListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ShopShowList", "cloudwf", "openAPI")
	return
}

// CreateShopShowListResponse creates a response to parse from ShopShowList response
func CreateShopShowListResponse() (response *ShopShowListResponse) {
	response = &ShopShowListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
