package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListStaOnoffLog invokes the cloudwf.ListStaOnoffLog API synchronously
// api document: https://help.aliyun.com/api/cloudwf/liststaonofflog.html
func (client *Client) ListStaOnoffLog(request *ListStaOnoffLogRequest) (response *ListStaOnoffLogResponse, err error) {
	response = CreateListStaOnoffLogResponse()
	err = client.DoAction(request, response)
	return
}

// ListStaOnoffLogWithChan invokes the cloudwf.ListStaOnoffLog API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/liststaonofflog.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListStaOnoffLogWithChan(request *ListStaOnoffLogRequest) (<-chan *ListStaOnoffLogResponse, <-chan error) {
	responseChan := make(chan *ListStaOnoffLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListStaOnoffLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListStaOnoffLogWithCallback invokes the cloudwf.ListStaOnoffLog API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/liststaonofflog.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListStaOnoffLogWithCallback(request *ListStaOnoffLogRequest, callback func(response *ListStaOnoffLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListStaOnoffLogResponse
		var err error
		defer close(result)
		response, err = client.ListStaOnoffLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListStaOnoffLogRequest is the request struct for api ListStaOnoffLog
type ListStaOnoffLogRequest struct {
	*requests.RpcRequest
	OrderCol       string           `position:"Query" name:"OrderCol"`
	SearchSsid     string           `position:"Query" name:"SearchSsid"`
	SearchApName   string           `position:"Query" name:"SearchApName"`
	Length         requests.Integer `position:"Query" name:"Length"`
	SearchUsername string           `position:"Query" name:"SearchUsername"`
	PageIndex      requests.Integer `position:"Query" name:"PageIndex"`
	Id             requests.Integer `position:"Query" name:"Id"`
	OrderDir       string           `position:"Query" name:"OrderDir"`
}

// ListStaOnoffLogResponse is the response struct for api ListStaOnoffLog
type ListStaOnoffLogResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateListStaOnoffLogRequest creates a request to invoke ListStaOnoffLog API
func CreateListStaOnoffLogRequest() (request *ListStaOnoffLogRequest) {
	request = &ListStaOnoffLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ListStaOnoffLog", "cloudwf", "openAPI")
	return
}

// CreateListStaOnoffLogResponse creates a response to parse from ListStaOnoffLog response
func CreateListStaOnoffLogResponse() (response *ListStaOnoffLogResponse) {
	response = &ListStaOnoffLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
