package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDnsGtmAvailableAlertGroup invokes the alidns.DescribeDnsGtmAvailableAlertGroup API synchronously
func (client *Client) DescribeDnsGtmAvailableAlertGroup(request *DescribeDnsGtmAvailableAlertGroupRequest) (response *DescribeDnsGtmAvailableAlertGroupResponse, err error) {
	response = CreateDescribeDnsGtmAvailableAlertGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDnsGtmAvailableAlertGroupWithChan invokes the alidns.DescribeDnsGtmAvailableAlertGroup API asynchronously
func (client *Client) DescribeDnsGtmAvailableAlertGroupWithChan(request *DescribeDnsGtmAvailableAlertGroupRequest) (<-chan *DescribeDnsGtmAvailableAlertGroupResponse, <-chan error) {
	responseChan := make(chan *DescribeDnsGtmAvailableAlertGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDnsGtmAvailableAlertGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDnsGtmAvailableAlertGroupWithCallback invokes the alidns.DescribeDnsGtmAvailableAlertGroup API asynchronously
func (client *Client) DescribeDnsGtmAvailableAlertGroupWithCallback(request *DescribeDnsGtmAvailableAlertGroupRequest, callback func(response *DescribeDnsGtmAvailableAlertGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDnsGtmAvailableAlertGroupResponse
		var err error
		defer close(result)
		response, err = client.DescribeDnsGtmAvailableAlertGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDnsGtmAvailableAlertGroupRequest is the request struct for api DescribeDnsGtmAvailableAlertGroup
type DescribeDnsGtmAvailableAlertGroupRequest struct {
	*requests.RpcRequest
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeDnsGtmAvailableAlertGroupResponse is the response struct for api DescribeDnsGtmAvailableAlertGroup
type DescribeDnsGtmAvailableAlertGroupResponse struct {
	*responses.BaseResponse
	RequestId           string `json:"RequestId" xml:"RequestId"`
	AvailableAlertGroup string `json:"AvailableAlertGroup" xml:"AvailableAlertGroup"`
}

// CreateDescribeDnsGtmAvailableAlertGroupRequest creates a request to invoke DescribeDnsGtmAvailableAlertGroup API
func CreateDescribeDnsGtmAvailableAlertGroupRequest() (request *DescribeDnsGtmAvailableAlertGroupRequest) {
	request = &DescribeDnsGtmAvailableAlertGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeDnsGtmAvailableAlertGroup", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDnsGtmAvailableAlertGroupResponse creates a response to parse from DescribeDnsGtmAvailableAlertGroup response
func CreateDescribeDnsGtmAvailableAlertGroupResponse() (response *DescribeDnsGtmAvailableAlertGroupResponse) {
	response = &DescribeDnsGtmAvailableAlertGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
