package resourcemover

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// MoveCollectionsClient is the a first party Azure service orchestrating the move of Azure resources from one Azure
// region to another or between zones within a region.
type MoveCollectionsClient struct {
	BaseClient
}

// NewMoveCollectionsClient creates an instance of the MoveCollectionsClient client.
func NewMoveCollectionsClient(subscriptionID string) MoveCollectionsClient {
	return NewMoveCollectionsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewMoveCollectionsClientWithBaseURI creates an instance of the MoveCollectionsClient client using a custom endpoint.
// Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewMoveCollectionsClientWithBaseURI(baseURI string, subscriptionID string) MoveCollectionsClient {
	return MoveCollectionsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// BulkRemove removes the set of move resources included in the request body from move collection. The orchestration is
// done by service. To aid the user to prerequisite the operation the client can call operation with validateOnly
// property set to true.
func (client MoveCollectionsClient) BulkRemove(ctx context.Context, resourceGroupName string, moveCollectionName string, body *BulkRemoveRequest) (result MoveCollectionsBulkRemoveFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MoveCollectionsClient.BulkRemove")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.BulkRemovePreparer(ctx, resourceGroupName, moveCollectionName, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "BulkRemove", nil, "Failure preparing request")
		return
	}

	result, err = client.BulkRemoveSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "BulkRemove", result.Response(), "Failure sending request")
		return
	}

	return
}

// BulkRemovePreparer prepares the BulkRemove request.
func (client MoveCollectionsClient) BulkRemovePreparer(ctx context.Context, resourceGroupName string, moveCollectionName string, body *BulkRemoveRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"moveCollectionName": autorest.Encode("path", moveCollectionName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}/bulkRemove", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if body != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(body))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// BulkRemoveSender sends the BulkRemove request. The method will close the
// http.Response Body if it receives an error.
func (client MoveCollectionsClient) BulkRemoveSender(req *http.Request) (future MoveCollectionsBulkRemoveFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// BulkRemoveResponder handles the response to the BulkRemove request. The method always
// closes the http.Response Body.
func (client MoveCollectionsClient) BulkRemoveResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Commit commits the set of resources included in the request body. The commit operation is triggered on the
// moveResources in the moveState 'CommitPending' or 'CommitFailed', on a successful completion the moveResource
// moveState do a transition to Committed. To aid the user to prerequisite the operation the client can call operation
// with validateOnly property set to true.
// Parameters:
// resourceGroupName - the Resource Group Name.
// moveCollectionName - the Move Collection Name.
func (client MoveCollectionsClient) Commit(ctx context.Context, resourceGroupName string, moveCollectionName string, body *CommitRequest) (result MoveCollectionsCommitFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MoveCollectionsClient.Commit")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: body,
			Constraints: []validation.Constraint{{Target: "body", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "body.MoveResources", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("resourcemover.MoveCollectionsClient", "Commit", err.Error())
	}

	req, err := client.CommitPreparer(ctx, resourceGroupName, moveCollectionName, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "Commit", nil, "Failure preparing request")
		return
	}

	result, err = client.CommitSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "Commit", result.Response(), "Failure sending request")
		return
	}

	return
}

// CommitPreparer prepares the Commit request.
func (client MoveCollectionsClient) CommitPreparer(ctx context.Context, resourceGroupName string, moveCollectionName string, body *CommitRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"moveCollectionName": autorest.Encode("path", moveCollectionName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}/commit", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if body != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(body))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CommitSender sends the Commit request. The method will close the
// http.Response Body if it receives an error.
func (client MoveCollectionsClient) CommitSender(req *http.Request) (future MoveCollectionsCommitFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CommitResponder handles the response to the Commit request. The method always
// closes the http.Response Body.
func (client MoveCollectionsClient) CommitResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Create creates or updates a move collection.
// Parameters:
// resourceGroupName - the Resource Group Name.
// moveCollectionName - the Move Collection Name.
func (client MoveCollectionsClient) Create(ctx context.Context, resourceGroupName string, moveCollectionName string, body *MoveCollection) (result MoveCollection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MoveCollectionsClient.Create")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: body,
			Constraints: []validation.Constraint{{Target: "body", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "body.Properties", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "body.Properties.SourceRegion", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "body.Properties.TargetRegion", Name: validation.Null, Rule: true, Chain: nil},
					}},
				}}}}}); err != nil {
		return result, validation.NewError("resourcemover.MoveCollectionsClient", "Create", err.Error())
	}

	req, err := client.CreatePreparer(ctx, resourceGroupName, moveCollectionName, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "Create", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "Create", resp, "Failure sending request")
		return
	}

	result, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "Create", resp, "Failure responding to request")
		return
	}

	return
}

// CreatePreparer prepares the Create request.
func (client MoveCollectionsClient) CreatePreparer(ctx context.Context, resourceGroupName string, moveCollectionName string, body *MoveCollection) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"moveCollectionName": autorest.Encode("path", moveCollectionName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	body.ID = nil
	body.Name = nil
	body.Type = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if body != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(body))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client MoveCollectionsClient) CreateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client MoveCollectionsClient) CreateResponder(resp *http.Response) (result MoveCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes a move collection.
// Parameters:
// resourceGroupName - the Resource Group Name.
// moveCollectionName - the Move Collection Name.
func (client MoveCollectionsClient) Delete(ctx context.Context, resourceGroupName string, moveCollectionName string) (result MoveCollectionsDeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MoveCollectionsClient.Delete")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, resourceGroupName, moveCollectionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "Delete", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client MoveCollectionsClient) DeletePreparer(ctx context.Context, resourceGroupName string, moveCollectionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"moveCollectionName": autorest.Encode("path", moveCollectionName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client MoveCollectionsClient) DeleteSender(req *http.Request) (future MoveCollectionsDeleteFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client MoveCollectionsClient) DeleteResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Discard discards the set of resources included in the request body. The discard operation is triggered on the
// moveResources in the moveState 'CommitPending' or 'DiscardFailed', on a successful completion the moveResource
// moveState do a transition to MovePending. To aid the user to prerequisite the operation the client can call
// operation with validateOnly property set to true.
// Parameters:
// resourceGroupName - the Resource Group Name.
// moveCollectionName - the Move Collection Name.
func (client MoveCollectionsClient) Discard(ctx context.Context, resourceGroupName string, moveCollectionName string, body *DiscardRequest) (result MoveCollectionsDiscardFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MoveCollectionsClient.Discard")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: body,
			Constraints: []validation.Constraint{{Target: "body", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "body.MoveResources", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("resourcemover.MoveCollectionsClient", "Discard", err.Error())
	}

	req, err := client.DiscardPreparer(ctx, resourceGroupName, moveCollectionName, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "Discard", nil, "Failure preparing request")
		return
	}

	result, err = client.DiscardSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "Discard", result.Response(), "Failure sending request")
		return
	}

	return
}

// DiscardPreparer prepares the Discard request.
func (client MoveCollectionsClient) DiscardPreparer(ctx context.Context, resourceGroupName string, moveCollectionName string, body *DiscardRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"moveCollectionName": autorest.Encode("path", moveCollectionName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}/discard", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if body != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(body))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DiscardSender sends the Discard request. The method will close the
// http.Response Body if it receives an error.
func (client MoveCollectionsClient) DiscardSender(req *http.Request) (future MoveCollectionsDiscardFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DiscardResponder handles the response to the Discard request. The method always
// closes the http.Response Body.
func (client MoveCollectionsClient) DiscardResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get gets the move collection.
// Parameters:
// resourceGroupName - the Resource Group Name.
// moveCollectionName - the Move Collection Name.
func (client MoveCollectionsClient) Get(ctx context.Context, resourceGroupName string, moveCollectionName string) (result MoveCollection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MoveCollectionsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, resourceGroupName, moveCollectionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client MoveCollectionsClient) GetPreparer(ctx context.Context, resourceGroupName string, moveCollectionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"moveCollectionName": autorest.Encode("path", moveCollectionName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client MoveCollectionsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client MoveCollectionsClient) GetResponder(resp *http.Response) (result MoveCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// InitiateMove moves the set of resources included in the request body. The move operation is triggered after the
// moveResources are in the moveState 'MovePending' or 'MoveFailed', on a successful completion the moveResource
// moveState do a transition to CommitPending. To aid the user to prerequisite the operation the client can call
// operation with validateOnly property set to true.
// Parameters:
// resourceGroupName - the Resource Group Name.
// moveCollectionName - the Move Collection Name.
func (client MoveCollectionsClient) InitiateMove(ctx context.Context, resourceGroupName string, moveCollectionName string, body *ResourceMoveRequestType) (result MoveCollectionsInitiateMoveFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MoveCollectionsClient.InitiateMove")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: body,
			Constraints: []validation.Constraint{{Target: "body", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "body.MoveResources", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("resourcemover.MoveCollectionsClient", "InitiateMove", err.Error())
	}

	req, err := client.InitiateMovePreparer(ctx, resourceGroupName, moveCollectionName, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "InitiateMove", nil, "Failure preparing request")
		return
	}

	result, err = client.InitiateMoveSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "InitiateMove", result.Response(), "Failure sending request")
		return
	}

	return
}

// InitiateMovePreparer prepares the InitiateMove request.
func (client MoveCollectionsClient) InitiateMovePreparer(ctx context.Context, resourceGroupName string, moveCollectionName string, body *ResourceMoveRequestType) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"moveCollectionName": autorest.Encode("path", moveCollectionName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}/initiateMove", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if body != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(body))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// InitiateMoveSender sends the InitiateMove request. The method will close the
// http.Response Body if it receives an error.
func (client MoveCollectionsClient) InitiateMoveSender(req *http.Request) (future MoveCollectionsInitiateMoveFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// InitiateMoveResponder handles the response to the InitiateMove request. The method always
// closes the http.Response Body.
func (client MoveCollectionsClient) InitiateMoveResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListMoveCollectionsByResourceGroup get all the Move Collections in the resource group.
// Parameters:
// resourceGroupName - the Resource Group Name.
func (client MoveCollectionsClient) ListMoveCollectionsByResourceGroup(ctx context.Context, resourceGroupName string) (result MoveCollectionResultListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MoveCollectionsClient.ListMoveCollectionsByResourceGroup")
		defer func() {
			sc := -1
			if result.mcrl.Response.Response != nil {
				sc = result.mcrl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listMoveCollectionsByResourceGroupNextResults
	req, err := client.ListMoveCollectionsByResourceGroupPreparer(ctx, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "ListMoveCollectionsByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMoveCollectionsByResourceGroupSender(req)
	if err != nil {
		result.mcrl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "ListMoveCollectionsByResourceGroup", resp, "Failure sending request")
		return
	}

	result.mcrl, err = client.ListMoveCollectionsByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "ListMoveCollectionsByResourceGroup", resp, "Failure responding to request")
		return
	}
	if result.mcrl.hasNextLink() && result.mcrl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListMoveCollectionsByResourceGroupPreparer prepares the ListMoveCollectionsByResourceGroup request.
func (client MoveCollectionsClient) ListMoveCollectionsByResourceGroupPreparer(ctx context.Context, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMoveCollectionsByResourceGroupSender sends the ListMoveCollectionsByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client MoveCollectionsClient) ListMoveCollectionsByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListMoveCollectionsByResourceGroupResponder handles the response to the ListMoveCollectionsByResourceGroup request. The method always
// closes the http.Response Body.
func (client MoveCollectionsClient) ListMoveCollectionsByResourceGroupResponder(resp *http.Response) (result MoveCollectionResultList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listMoveCollectionsByResourceGroupNextResults retrieves the next set of results, if any.
func (client MoveCollectionsClient) listMoveCollectionsByResourceGroupNextResults(ctx context.Context, lastResults MoveCollectionResultList) (result MoveCollectionResultList, err error) {
	req, err := lastResults.moveCollectionResultListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "listMoveCollectionsByResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListMoveCollectionsByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "listMoveCollectionsByResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListMoveCollectionsByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "listMoveCollectionsByResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListMoveCollectionsByResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client MoveCollectionsClient) ListMoveCollectionsByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result MoveCollectionResultListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MoveCollectionsClient.ListMoveCollectionsByResourceGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListMoveCollectionsByResourceGroup(ctx, resourceGroupName)
	return
}

// ListMoveCollectionsBySubscription get all the Move Collections in the subscription.
func (client MoveCollectionsClient) ListMoveCollectionsBySubscription(ctx context.Context) (result MoveCollectionResultListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MoveCollectionsClient.ListMoveCollectionsBySubscription")
		defer func() {
			sc := -1
			if result.mcrl.Response.Response != nil {
				sc = result.mcrl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listMoveCollectionsBySubscriptionNextResults
	req, err := client.ListMoveCollectionsBySubscriptionPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "ListMoveCollectionsBySubscription", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListMoveCollectionsBySubscriptionSender(req)
	if err != nil {
		result.mcrl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "ListMoveCollectionsBySubscription", resp, "Failure sending request")
		return
	}

	result.mcrl, err = client.ListMoveCollectionsBySubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "ListMoveCollectionsBySubscription", resp, "Failure responding to request")
		return
	}
	if result.mcrl.hasNextLink() && result.mcrl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListMoveCollectionsBySubscriptionPreparer prepares the ListMoveCollectionsBySubscription request.
func (client MoveCollectionsClient) ListMoveCollectionsBySubscriptionPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Migrate/moveCollections", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListMoveCollectionsBySubscriptionSender sends the ListMoveCollectionsBySubscription request. The method will close the
// http.Response Body if it receives an error.
func (client MoveCollectionsClient) ListMoveCollectionsBySubscriptionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListMoveCollectionsBySubscriptionResponder handles the response to the ListMoveCollectionsBySubscription request. The method always
// closes the http.Response Body.
func (client MoveCollectionsClient) ListMoveCollectionsBySubscriptionResponder(resp *http.Response) (result MoveCollectionResultList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listMoveCollectionsBySubscriptionNextResults retrieves the next set of results, if any.
func (client MoveCollectionsClient) listMoveCollectionsBySubscriptionNextResults(ctx context.Context, lastResults MoveCollectionResultList) (result MoveCollectionResultList, err error) {
	req, err := lastResults.moveCollectionResultListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "listMoveCollectionsBySubscriptionNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListMoveCollectionsBySubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "listMoveCollectionsBySubscriptionNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListMoveCollectionsBySubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "listMoveCollectionsBySubscriptionNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListMoveCollectionsBySubscriptionComplete enumerates all values, automatically crossing page boundaries as required.
func (client MoveCollectionsClient) ListMoveCollectionsBySubscriptionComplete(ctx context.Context) (result MoveCollectionResultListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MoveCollectionsClient.ListMoveCollectionsBySubscription")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListMoveCollectionsBySubscription(ctx)
	return
}

// Prepare initiates prepare for the set of resources included in the request body. The prepare operation is on the
// moveResources that are in the moveState 'PreparePending' or 'PrepareFailed', on a successful completion the
// moveResource moveState do a transition to MovePending. To aid the user to prerequisite the operation the client can
// call operation with validateOnly property set to true.
// Parameters:
// resourceGroupName - the Resource Group Name.
// moveCollectionName - the Move Collection Name.
func (client MoveCollectionsClient) Prepare(ctx context.Context, resourceGroupName string, moveCollectionName string, body *PrepareRequest) (result MoveCollectionsPrepareFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MoveCollectionsClient.Prepare")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: body,
			Constraints: []validation.Constraint{{Target: "body", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "body.MoveResources", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("resourcemover.MoveCollectionsClient", "Prepare", err.Error())
	}

	req, err := client.PreparePreparer(ctx, resourceGroupName, moveCollectionName, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "Prepare", nil, "Failure preparing request")
		return
	}

	result, err = client.PrepareSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "Prepare", result.Response(), "Failure sending request")
		return
	}

	return
}

// PreparePreparer prepares the Prepare request.
func (client MoveCollectionsClient) PreparePreparer(ctx context.Context, resourceGroupName string, moveCollectionName string, body *PrepareRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"moveCollectionName": autorest.Encode("path", moveCollectionName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}/prepare", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if body != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(body))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PrepareSender sends the Prepare request. The method will close the
// http.Response Body if it receives an error.
func (client MoveCollectionsClient) PrepareSender(req *http.Request) (future MoveCollectionsPrepareFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// PrepareResponder handles the response to the Prepare request. The method always
// closes the http.Response Body.
func (client MoveCollectionsClient) PrepareResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ResolveDependencies computes, resolves and validate the dependencies of the moveResources in the move collection.
// Parameters:
// resourceGroupName - the Resource Group Name.
// moveCollectionName - the Move Collection Name.
func (client MoveCollectionsClient) ResolveDependencies(ctx context.Context, resourceGroupName string, moveCollectionName string) (result MoveCollectionsResolveDependenciesFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MoveCollectionsClient.ResolveDependencies")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ResolveDependenciesPreparer(ctx, resourceGroupName, moveCollectionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "ResolveDependencies", nil, "Failure preparing request")
		return
	}

	result, err = client.ResolveDependenciesSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "ResolveDependencies", result.Response(), "Failure sending request")
		return
	}

	return
}

// ResolveDependenciesPreparer prepares the ResolveDependencies request.
func (client MoveCollectionsClient) ResolveDependenciesPreparer(ctx context.Context, resourceGroupName string, moveCollectionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"moveCollectionName": autorest.Encode("path", moveCollectionName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}/resolveDependencies", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ResolveDependenciesSender sends the ResolveDependencies request. The method will close the
// http.Response Body if it receives an error.
func (client MoveCollectionsClient) ResolveDependenciesSender(req *http.Request) (future MoveCollectionsResolveDependenciesFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// ResolveDependenciesResponder handles the response to the ResolveDependencies request. The method always
// closes the http.Response Body.
func (client MoveCollectionsClient) ResolveDependenciesResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Update updates a move collection.
// Parameters:
// resourceGroupName - the Resource Group Name.
// moveCollectionName - the Move Collection Name.
func (client MoveCollectionsClient) Update(ctx context.Context, resourceGroupName string, moveCollectionName string, body *UpdateMoveCollectionRequest) (result MoveCollection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MoveCollectionsClient.Update")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdatePreparer(ctx, resourceGroupName, moveCollectionName, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsClient", "Update", resp, "Failure responding to request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client MoveCollectionsClient) UpdatePreparer(ctx context.Context, resourceGroupName string, moveCollectionName string, body *UpdateMoveCollectionRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"moveCollectionName": autorest.Encode("path", moveCollectionName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if body != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(body))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client MoveCollectionsClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client MoveCollectionsClient) UpdateResponder(resp *http.Response) (result MoveCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
