/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.matcher;

import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.matcher.AbstractStringMatcher;
import org.apache.commons.text.matcher.StringMatcher;
import org.apache.commons.text.matcher.StringMatcherFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringSubstitutorGetSetTest {
    @Test
    public void testGetSetPrefix() {
        StringSubstitutor sub = new StringSubstitutor();
        Assertions.assertTrue((boolean)(sub.getVariablePrefixMatcher() instanceof AbstractStringMatcher.CharArrayMatcher));
        sub.setVariablePrefix('<');
        Assertions.assertTrue((boolean)(sub.getVariablePrefixMatcher() instanceof AbstractStringMatcher.CharMatcher));
        sub.setVariablePrefix("<<");
        Assertions.assertTrue((boolean)(sub.getVariablePrefixMatcher() instanceof AbstractStringMatcher.CharArrayMatcher));
        Assertions.assertThrows(IllegalArgumentException.class, () -> sub.setVariablePrefix((String)null));
        Assertions.assertTrue((boolean)(sub.getVariablePrefixMatcher() instanceof AbstractStringMatcher.CharArrayMatcher));
        StringMatcher matcher = StringMatcherFactory.INSTANCE.commaMatcher();
        sub.setVariablePrefixMatcher(matcher);
        Assertions.assertSame((Object)matcher, (Object)sub.getVariablePrefixMatcher());
        Assertions.assertThrows(IllegalArgumentException.class, () -> sub.setVariablePrefixMatcher((StringMatcher)null));
        Assertions.assertSame((Object)matcher, (Object)sub.getVariablePrefixMatcher());
    }

    @Test
    public void testGetSetSuffix() {
        StringSubstitutor sub = new StringSubstitutor();
        Assertions.assertTrue((boolean)(sub.getVariableSuffixMatcher() instanceof AbstractStringMatcher.CharMatcher));
        sub.setVariableSuffix('<');
        Assertions.assertTrue((boolean)(sub.getVariableSuffixMatcher() instanceof AbstractStringMatcher.CharMatcher));
        sub.setVariableSuffix("<<");
        Assertions.assertTrue((boolean)(sub.getVariableSuffixMatcher() instanceof AbstractStringMatcher.CharArrayMatcher));
        Assertions.assertThrows(IllegalArgumentException.class, () -> sub.setVariableSuffix((String)null));
        Assertions.assertTrue((boolean)(sub.getVariableSuffixMatcher() instanceof AbstractStringMatcher.CharArrayMatcher));
        StringMatcher matcher = StringMatcherFactory.INSTANCE.commaMatcher();
        sub.setVariableSuffixMatcher(matcher);
        Assertions.assertSame((Object)matcher, (Object)sub.getVariableSuffixMatcher());
        Assertions.assertThrows(IllegalArgumentException.class, () -> sub.setVariableSuffixMatcher((StringMatcher)null));
        Assertions.assertSame((Object)matcher, (Object)sub.getVariableSuffixMatcher());
    }

    @Test
    public void testGetSetValueDelimiter() {
        StringSubstitutor sub = new StringSubstitutor();
        Assertions.assertTrue((boolean)(sub.getValueDelimiterMatcher() instanceof AbstractStringMatcher.CharArrayMatcher));
        sub.setValueDelimiter(':');
        Assertions.assertTrue((boolean)(sub.getValueDelimiterMatcher() instanceof AbstractStringMatcher.CharMatcher));
        sub.setValueDelimiter("||");
        Assertions.assertTrue((boolean)(sub.getValueDelimiterMatcher() instanceof AbstractStringMatcher.CharArrayMatcher));
        sub.setValueDelimiter((String)null);
        Assertions.assertNull((Object)sub.getValueDelimiterMatcher());
        StringMatcher matcher = StringMatcherFactory.INSTANCE.commaMatcher();
        sub.setValueDelimiterMatcher(matcher);
        Assertions.assertSame((Object)matcher, (Object)sub.getValueDelimiterMatcher());
        sub.setValueDelimiterMatcher((StringMatcher)null);
        Assertions.assertNull((Object)sub.getValueDelimiterMatcher());
    }
}

