// Copyright (c) Meta Platforms, Inc. and affiliates.
//
// This source code is licensed under the MIT license found in the
// LICENSE file in the root directory of this source tree.

// Generated file. Do not modify.

#include <stdexcept>
#include "hbt/src/perf_event/json_events/generated/intel/JsonEvents.h"

namespace facebook::hbt::perf_event::generated {
namespace skylakex_uncore_experimental {

void addEvents(PmuDeviceManager& pmu_manager) {
/*
  Events from skylakex_uncore_experimental.json (3040 experimental events).

  Supported SKUs:
      - Arch: x86, Model: SKX id: 85 Steps: ['0', '1', '2', '3', '4']
*/
#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_COMP_BUF_INSERTS.PORT0",
      EventDef::Encoding{.code = 0xC2, .umask = 0x04, .msr_values = {0x00}},
      R"(PCIe Completion Buffer Inserts; Port 0)",
      R"(PCIe Completion Buffer Inserts; Port 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_COMP_BUF_INSERTS.PORT1",
      EventDef::Encoding{.code = 0xC2, .umask = 0x04, .msr_values = {0x00}},
      R"(PCIe Completion Buffer Inserts; Port 1)",
      R"(PCIe Completion Buffer Inserts; Port 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_COMP_BUF_INSERTS.PORT2",
      EventDef::Encoding{.code = 0xC2, .umask = 0x04, .msr_values = {0x00}},
      R"(PCIe Completion Buffer Inserts; Port 2)",
      R"(PCIe Completion Buffer Inserts; Port 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_COMP_BUF_INSERTS.PORT3",
      EventDef::Encoding{.code = 0xC2, .umask = 0x04, .msr_values = {0x00}},
      R"(PCIe Completion Buffer Inserts; Port 3)",
      R"(PCIe Completion Buffer Inserts; Port 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_LINK_NUM_CORR_ERR",
      EventDef::Encoding{.code = 0xF, .umask = 0x0, .msr_values = {0x00}},
      R"(Num Link  Correctable Errors)",
      R"(Num Link  Correctable Errors)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_LINK_NUM_RETRIES",
      EventDef::Encoding{.code = 0xE, .umask = 0x0, .msr_values = {0x00}},
      R"(Num Link Retries)",
      R"(Num Link Retries)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH",
      EventDef::Encoding{.code = 0x21, .umask = 0x0, .msr_values = {0x00}},
      R"(Number packets that passed the Mask/Match Filter)",
      R"(Number packets that passed the Mask/Match Filter)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_AND.BUS0",
      EventDef::Encoding{.code = 0x2, .umask = 0x1, .msr_values = {0x00}},
      R"(AND Mask/match for debug bus; Non-PCIE bus)",
      R"(Asserted if all bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_AND.BUS1",
      EventDef::Encoding{.code = 0x2, .umask = 0x2, .msr_values = {0x00}},
      R"(AND Mask/match for debug bus; PCIE bus)",
      R"(Asserted if all bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_AND.BUS0_NOT_BUS1",
      EventDef::Encoding{.code = 0x2, .umask = 0x4, .msr_values = {0x00}},
      R"(AND Mask/match for debug bus; Non-PCIE bus and !(PCIE bus))",
      R"(Asserted if all bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_AND.BUS0_BUS1",
      EventDef::Encoding{.code = 0x2, .umask = 0x8, .msr_values = {0x00}},
      R"(AND Mask/match for debug bus; Non-PCIE bus and PCIE bus)",
      R"(Asserted if all bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_AND.NOT_BUS0_BUS1",
      EventDef::Encoding{.code = 0x2, .umask = 0x10, .msr_values = {0x00}},
      R"(AND Mask/match for debug bus; !(Non-PCIE bus) and PCIE bus)",
      R"(Asserted if all bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_AND.NOT_BUS0_NOT_BUS1",
      EventDef::Encoding{.code = 0x2, .umask = 0x20, .msr_values = {0x00}},
      R"(AND Mask/match for debug bus)",
      R"(Asserted if all bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_OR.BUS0",
      EventDef::Encoding{.code = 0x3, .umask = 0x1, .msr_values = {0x00}},
      R"(OR Mask/match for debug bus; Non-PCIE bus)",
      R"(Asserted if any bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_OR.BUS1",
      EventDef::Encoding{.code = 0x3, .umask = 0x2, .msr_values = {0x00}},
      R"(OR Mask/match for debug bus; PCIE bus)",
      R"(Asserted if any bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_OR.BUS0_NOT_BUS1",
      EventDef::Encoding{.code = 0x3, .umask = 0x4, .msr_values = {0x00}},
      R"(OR Mask/match for debug bus; Non-PCIE bus and !(PCIE bus))",
      R"(Asserted if any bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_OR.BUS0_BUS1",
      EventDef::Encoding{.code = 0x3, .umask = 0x8, .msr_values = {0x00}},
      R"(OR Mask/match for debug bus; Non-PCIE bus and PCIE bus)",
      R"(Asserted if any bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_OR.NOT_BUS0_BUS1",
      EventDef::Encoding{.code = 0x3, .umask = 0x10, .msr_values = {0x00}},
      R"(OR Mask/match for debug bus; !(Non-PCIE bus) and PCIE bus)",
      R"(Asserted if any bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_MASK_MATCH_OR.NOT_BUS0_NOT_BUS1",
      EventDef::Encoding{.code = 0x3, .umask = 0x20, .msr_values = {0x00}},
      R"(OR Mask/match for debug bus; !(Non-PCIE bus) and !(PCIE bus))",
      R"(Asserted if any bits specified by mask match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_NOTHING",
      EventDef::Encoding{.code = 0x0, .umask = 0x0, .msr_values = {0x00}},
      R"(Counting disabled)",
      R"(Counting disabled)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_SYMBOL_TIMES",
      EventDef::Encoding{.code = 0x82, .umask = 0x0, .msr_values = {0x00}},
      R"(Symbol Times on Link)",
      R"(Gen1 - increment once every 4nS, Gen2 - increment once every 2nS, Gen3 - increment once every 1nS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_VTD_ACCESS.L4_PAGE_HIT",
      EventDef::Encoding{.code = 0x41, .umask = 0x1, .msr_values = {0x00}},
      R"(VTd Access; Vtd hit)",
      R"(VTd Access; Vtd hit)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_VTD_ACCESS.CTXT_MISS",
      EventDef::Encoding{.code = 0x41, .umask = 0x2, .msr_values = {0x00}},
      R"(VTd Access; context cache miss)",
      R"(VTd Access; context cache miss)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_VTD_ACCESS.L1_MISS",
      EventDef::Encoding{.code = 0x41, .umask = 0x4, .msr_values = {0x00}},
      R"(VTd Access; L1 miss)",
      R"(VTd Access; L1 miss)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_VTD_ACCESS.L2_MISS",
      EventDef::Encoding{.code = 0x41, .umask = 0x8, .msr_values = {0x00}},
      R"(VTd Access; L2 miss)",
      R"(VTd Access; L2 miss)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_VTD_ACCESS.L3_MISS",
      EventDef::Encoding{.code = 0x41, .umask = 0x10, .msr_values = {0x00}},
      R"(VTd Access; L3 miss)",
      R"(VTd Access; L3 miss)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_VTD_ACCESS.TLB_MISS",
      EventDef::Encoding{.code = 0x41, .umask = 0x20, .msr_values = {0x00}},
      R"(VTd Access; TLB miss)",
      R"(VTd Access; TLB miss)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_VTD_ACCESS.TLB_FULL",
      EventDef::Encoding{.code = 0x41, .umask = 0x40, .msr_values = {0x00}},
      R"(VTd Access; TLB is full)",
      R"(VTd Access; TLB is full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_VTD_ACCESS.TLB1_MISS",
      EventDef::Encoding{.code = 0x41, .umask = 0x80, .msr_values = {0x00}},
      R"(VTd Access; TLB miss)",
      R"(VTd Access; TLB miss)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_VTD_OCCUPANCY",
      EventDef::Encoding{.code = 0x40, .umask = 0x0, .msr_values = {0x00}},
      R"(VTd Occupancy)",
      R"(VTd Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_CACHE_TOTAL_OCCUPANCY.ANY",
      EventDef::Encoding{.code = 0xF, .umask = 0x1, .msr_values = {0x00}},
      R"(Total Write Cache Occupancy; Any Source)",
      R"(Accumulates the number of reads and writes that are outstanding in the uncore in each cycle.  This is effectively the sum of the READ_OCCUPANCY and WRITE_OCCUPANCY events.; Tracks all requests from any source port.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_CACHE_TOTAL_OCCUPANCY.IV_Q",
      EventDef::Encoding{.code = 0xF, .umask = 0x2, .msr_values = {0x00}},
      R"(Total Write Cache Occupancy; Snoops)",
      R"(Accumulates the number of reads and writes that are outstanding in the uncore in each cycle.  This is effectively the sum of the READ_OCCUPANCY and WRITE_OCCUPANCY events.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_CLOCKTICKS",
      EventDef::Encoding{.code = 0x1, .umask = 0x0, .msr_values = {0x00}},
      R"(IRP Clocks)",
      R"(IRP Clocks)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_COHERENT_OPS.PCIRDCUR",
      EventDef::Encoding{.code = 0x10, .umask = 0x1, .msr_values = {0x00}},
      R"(Coherent Ops; PCIRdCur)",
      R"(Counts the number of coherency related operations servied by the IRP)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_COHERENT_OPS.CRD",
      EventDef::Encoding{.code = 0x10, .umask = 0x2, .msr_values = {0x00}},
      R"(Coherent Ops; CRd)",
      R"(Counts the number of coherency related operations servied by the IRP)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_COHERENT_OPS.DRD",
      EventDef::Encoding{.code = 0x10, .umask = 0x4, .msr_values = {0x00}},
      R"(Coherent Ops; DRd)",
      R"(Counts the number of coherency related operations servied by the IRP)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_COHERENT_OPS.PCIDCAHINT",
      EventDef::Encoding{.code = 0x10, .umask = 0x20, .msr_values = {0x00}},
      R"(Coherent Ops; PCIDCAHin5t)",
      R"(Counts the number of coherency related operations servied by the IRP)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_COHERENT_OPS.WBMTOI",
      EventDef::Encoding{.code = 0x10, .umask = 0x40, .msr_values = {0x00}},
      R"(Coherent Ops; WbMtoI)",
      R"(Counts the number of coherency related operations servied by the IRP)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_COHERENT_OPS.CLFLUSH",
      EventDef::Encoding{.code = 0x10, .umask = 0x80, .msr_values = {0x00}},
      R"(Coherent Ops; CLFlush)",
      R"(Counts the number of coherency related operations servied by the IRP)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_FAF_FULL",
      EventDef::Encoding{.code = 0x17, .umask = 0x0, .msr_values = {0x00}},
      R"(FAF RF full)",
      R"(FAF RF full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_FAF_TRANSACTIONS",
      EventDef::Encoding{.code = 0x16, .umask = 0x0, .msr_values = {0x00}},
      R"(FAF allocation -- sent to ADQ)",
      R"(FAF allocation -- sent to ADQ)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_IRP_ALL.INBOUND_INSERTS",
      EventDef::Encoding{.code = 0x1E, .umask = 0x1, .msr_values = {0x00}},
      R"(All Inserts Inbound (p2p + faf + cset))",
      R"(All Inserts Inbound (p2p + faf + cset))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_IRP_ALL.OUTBOUND_INSERTS",
      EventDef::Encoding{.code = 0x1E, .umask = 0x2, .msr_values = {0x00}},
      R"(All Inserts Outbound (BL, AK, Snoops))",
      R"(All Inserts Outbound (BL, AK, Snoops))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.FAST_REQ",
      EventDef::Encoding{.code = 0x1C, .umask = 0x1, .msr_values = {0x00}},
      R"(Misc Events - Set 0; Fastpath Requests)",
      R"(Misc Events - Set 0; Fastpath Requests)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.FAST_REJ",
      EventDef::Encoding{.code = 0x1C, .umask = 0x2, .msr_values = {0x00}},
      R"(Misc Events - Set 0; Fastpath Rejects)",
      R"(Misc Events - Set 0; Fastpath Rejects)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.2ND_RD_INSERT",
      EventDef::Encoding{.code = 0x1C, .umask = 0x4, .msr_values = {0x00}},
      R"(Misc Events - Set 0; Cache Inserts of Read Transactions as Secondary)",
      R"(Misc Events - Set 0; Cache Inserts of Read Transactions as Secondary)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.2ND_WR_INSERT",
      EventDef::Encoding{.code = 0x1C, .umask = 0x8, .msr_values = {0x00}},
      R"(Misc Events - Set 0; Cache Inserts of Write Transactions as Secondary)",
      R"(Misc Events - Set 0; Cache Inserts of Write Transactions as Secondary)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.2ND_ATOMIC_INSERT",
      EventDef::Encoding{.code = 0x1C, .umask = 0x10, .msr_values = {0x00}},
      R"(Misc Events - Set 0; Cache Inserts of Atomic Transactions as Secondary)",
      R"(Misc Events - Set 0; Cache Inserts of Atomic Transactions as Secondary)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.FAST_XFER",
      EventDef::Encoding{.code = 0x1C, .umask = 0x20, .msr_values = {0x00}},
      R"(Misc Events - Set 0; Fastpath Transfers From Primary to Secondary)",
      R"(Misc Events - Set 0; Fastpath Transfers From Primary to Secondary)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.PF_ACK_HINT",
      EventDef::Encoding{.code = 0x1C, .umask = 0x40, .msr_values = {0x00}},
      R"(Misc Events - Set 0; Prefetch Ack Hints From Primary to Secondary)",
      R"(Misc Events - Set 0; Prefetch Ack Hints From Primary to Secondary)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC0.UNKNOWN",
      EventDef::Encoding{.code = 0x1C, .umask = 0x80, .msr_values = {0x00}},
      R"(Misc Events - Set 0)",
      R"(Misc Events - Set 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC1.SLOW_I",
      EventDef::Encoding{.code = 0x1D, .umask = 0x1, .msr_values = {0x00}},
      R"(Misc Events - Set 1; Slow Transfer of I Line)",
      R"(Snoop took cacheline ownership before write from data was committed.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC1.SLOW_S",
      EventDef::Encoding{.code = 0x1D, .umask = 0x2, .msr_values = {0x00}},
      R"(Misc Events - Set 1; Slow Transfer of S Line)",
      R"(Secondary received a transfer that did not have sufficient MESI state)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC1.SLOW_E",
      EventDef::Encoding{.code = 0x1D, .umask = 0x4, .msr_values = {0x00}},
      R"(Misc Events - Set 1; Slow Transfer of E Line)",
      R"(Secondary received a transfer that did have sufficient MESI state)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC1.SLOW_M",
      EventDef::Encoding{.code = 0x1D, .umask = 0x8, .msr_values = {0x00}},
      R"(Misc Events - Set 1; Slow Transfer of M Line)",
      R"(Snoop took cacheline ownership before write from data was committed.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC1.LOST_FWD",
      EventDef::Encoding{.code = 0x1D, .umask = 0x10, .msr_values = {0x00}},
      R"(Misc Events - Set 1; Lost Forward)",
      R"(Snoop pulled away ownership before a write was committed)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC1.SEC_RCVD_INVLD",
      EventDef::Encoding{.code = 0x1D, .umask = 0x20, .msr_values = {0x00}},
      R"(Misc Events - Set 1; Received Invalid)",
      R"(Secondary received a transfer that did not have sufficient MESI state)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_MISC1.SEC_RCVD_VLD",
      EventDef::Encoding{.code = 0x1D, .umask = 0x40, .msr_values = {0x00}},
      R"(Misc Events - Set 1; Received Valid)",
      R"(Secondary received a transfer that did have sufficient MESI state)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_INSERTS",
      EventDef::Encoding{.code = 0x14, .umask = 0x0, .msr_values = {0x00}},
      R"(P2P Requests)",
      R"(P2P requests from the ITC)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_OCCUPANCY",
      EventDef::Encoding{.code = 0x15, .umask = 0x0, .msr_values = {0x00}},
      R"(P2P Occupancy)",
      R"(P2P B & S Queue Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.RD",
      EventDef::Encoding{.code = 0x13, .umask = 0x1, .msr_values = {0x00}},
      R"(P2P Transactions; P2P reads)",
      R"(P2P Transactions; P2P reads)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.WR",
      EventDef::Encoding{.code = 0x13, .umask = 0x2, .msr_values = {0x00}},
      R"(P2P Transactions; P2P Writes)",
      R"(P2P Transactions; P2P Writes)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.MSG",
      EventDef::Encoding{.code = 0x13, .umask = 0x4, .msr_values = {0x00}},
      R"(P2P Transactions; P2P Message)",
      R"(P2P Transactions; P2P Message)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.CMPL",
      EventDef::Encoding{.code = 0x13, .umask = 0x8, .msr_values = {0x00}},
      R"(P2P Transactions; P2P completions)",
      R"(P2P Transactions; P2P completions)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.REM",
      EventDef::Encoding{.code = 0x13, .umask = 0x10, .msr_values = {0x00}},
      R"(P2P Transactions; Match if remote only)",
      R"(P2P Transactions; Match if remote only)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.REM_AND_TGT_MATCH",
      EventDef::Encoding{.code = 0x13, .umask = 0x20, .msr_values = {0x00}},
      R"(P2P Transactions; match if remote and target matches)",
      R"(P2P Transactions; match if remote and target matches)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.LOC",
      EventDef::Encoding{.code = 0x13, .umask = 0x40, .msr_values = {0x00}},
      R"(P2P Transactions; match if local only)",
      R"(P2P Transactions; match if local only)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_P2P_TRANSACTIONS.LOC_AND_TGT_MATCH",
      EventDef::Encoding{.code = 0x13, .umask = 0x80, .msr_values = {0x00}},
      R"(P2P Transactions; match if local and target matches)",
      R"(P2P Transactions; match if local and target matches)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_SNOOP_RESP.MISS",
      EventDef::Encoding{.code = 0x12, .umask = 0x1, .msr_values = {0x00}},
      R"(Snoop Responses; Miss)",
      R"(Snoop Responses; Miss)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_SNOOP_RESP.HIT_I",
      EventDef::Encoding{.code = 0x12, .umask = 0x2, .msr_values = {0x00}},
      R"(Snoop Responses; Hit I)",
      R"(Snoop Responses; Hit I)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_SNOOP_RESP.HIT_ES",
      EventDef::Encoding{.code = 0x12, .umask = 0x4, .msr_values = {0x00}},
      R"(Snoop Responses; Hit E or S)",
      R"(Snoop Responses; Hit E or S)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_SNOOP_RESP.HIT_M",
      EventDef::Encoding{.code = 0x12, .umask = 0x8, .msr_values = {0x00}},
      R"(Snoop Responses; Hit M)",
      R"(Snoop Responses; Hit M)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_SNOOP_RESP.SNPCODE",
      EventDef::Encoding{.code = 0x12, .umask = 0x10, .msr_values = {0x00}},
      R"(Snoop Responses; SnpCode)",
      R"(Snoop Responses; SnpCode)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_SNOOP_RESP.SNPDATA",
      EventDef::Encoding{.code = 0x12, .umask = 0x20, .msr_values = {0x00}},
      R"(Snoop Responses; SnpData)",
      R"(Snoop Responses; SnpData)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_SNOOP_RESP.SNPINV",
      EventDef::Encoding{.code = 0x12, .umask = 0x40, .msr_values = {0x00}},
      R"(Snoop Responses; SnpInv)",
      R"(Snoop Responses; SnpInv)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TRANSACTIONS.READS",
      EventDef::Encoding{.code = 0x11, .umask = 0x1, .msr_values = {0x00}},
      R"(Inbound Transaction Count; Reads)",
      R"(Counts the number of Inbound transactions from the IRP to the Uncore.  This can be filtered based on request type in addition to the source queue.  Note the special filtering equation.  We do OR-reduction on the request type.  If the SOURCE bit is set, then we also do AND qualification based on the source portID.; Tracks only read requests (not including read prefetches).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TRANSACTIONS.WRITES",
      EventDef::Encoding{.code = 0x11, .umask = 0x2, .msr_values = {0x00}},
      R"(Inbound Transaction Count; Writes)",
      R"(Counts the number of Inbound transactions from the IRP to the Uncore.  This can be filtered based on request type in addition to the source queue.  Note the special filtering equation.  We do OR-reduction on the request type.  If the SOURCE bit is set, then we also do AND qualification based on the source portID.; Trackes only write requests.  Each write request should have a prefetch, so there is no need to explicitly track these requests.  For writes that are tickled and have to retry, the counter will be incremented for each retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TRANSACTIONS.RD_PREF",
      EventDef::Encoding{.code = 0x11, .umask = 0x4, .msr_values = {0x00}},
      R"(Inbound Transaction Count; Read Prefetches)",
      R"(Counts the number of Inbound transactions from the IRP to the Uncore.  This can be filtered based on request type in addition to the source queue.  Note the special filtering equation.  We do OR-reduction on the request type.  If the SOURCE bit is set, then we also do AND qualification based on the source portID.; Tracks the number of read prefetches.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TRANSACTIONS.ATOMIC",
      EventDef::Encoding{.code = 0x11, .umask = 0x10, .msr_values = {0x00}},
      R"(Inbound Transaction Count; Atomic)",
      R"(Counts the number of Inbound transactions from the IRP to the Uncore.  This can be filtered based on request type in addition to the source queue.  Note the special filtering equation.  We do OR-reduction on the request type.  If the SOURCE bit is set, then we also do AND qualification based on the source portID.; Tracks the number of atomic transactions)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TRANSACTIONS.OTHER",
      EventDef::Encoding{.code = 0x11, .umask = 0x20, .msr_values = {0x00}},
      R"(Inbound Transaction Count; Other)",
      R"(Counts the number of Inbound transactions from the IRP to the Uncore.  This can be filtered based on request type in addition to the source queue.  Note the special filtering equation.  We do OR-reduction on the request type.  If the SOURCE bit is set, then we also do AND qualification based on the source portID.; Tracks the number of 'other' kinds of transactions.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TxR2_AD_STALL_CREDIT_CYCLES",
      EventDef::Encoding{.code = 0x1A, .umask = 0x0, .msr_values = {0x00}},
      R"(No AD Egress Credit Stalls)",
      R"(Counts the number times when it is not possible to issue a request to the R2PCIe because there are no AD Egress Credits available.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TxC_AK_INSERTS",
      EventDef::Encoding{.code = 0xB, .umask = 0x0, .msr_values = {0x00}},
      R"(AK Egress Allocations)",
      R"(AK Egress Allocations)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TxC_BL_DRS_CYCLES_FULL",
      EventDef::Encoding{.code = 0x5, .umask = 0x0, .msr_values = {0x00}},
      R"(BL DRS Egress Cycles Full)",
      R"(BL DRS Egress Cycles Full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TxC_BL_DRS_INSERTS",
      EventDef::Encoding{.code = 0x2, .umask = 0x0, .msr_values = {0x00}},
      R"(BL DRS Egress Inserts)",
      R"(BL DRS Egress Inserts)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TxC_BL_DRS_OCCUPANCY",
      EventDef::Encoding{.code = 0x8, .umask = 0x0, .msr_values = {0x00}},
      R"(BL DRS Egress Occupancy)",
      R"(BL DRS Egress Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TxC_BL_NCB_CYCLES_FULL",
      EventDef::Encoding{.code = 0x6, .umask = 0x0, .msr_values = {0x00}},
      R"(BL NCB Egress Cycles Full)",
      R"(BL NCB Egress Cycles Full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TxC_BL_NCB_INSERTS",
      EventDef::Encoding{.code = 0x3, .umask = 0x0, .msr_values = {0x00}},
      R"(BL NCB Egress Inserts)",
      R"(BL NCB Egress Inserts)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TxC_BL_NCB_OCCUPANCY",
      EventDef::Encoding{.code = 0x9, .umask = 0x0, .msr_values = {0x00}},
      R"(BL NCB Egress Occupancy)",
      R"(BL NCB Egress Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TxC_BL_NCS_CYCLES_FULL",
      EventDef::Encoding{.code = 0x7, .umask = 0x0, .msr_values = {0x00}},
      R"(BL NCS Egress Cycles Full)",
      R"(BL NCS Egress Cycles Full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TxC_BL_NCS_INSERTS",
      EventDef::Encoding{.code = 0x4, .umask = 0x0, .msr_values = {0x00}},
      R"(BL NCS Egress Inserts)",
      R"(BL NCS Egress Inserts)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TxC_BL_NCS_OCCUPANCY",
      EventDef::Encoding{.code = 0xA, .umask = 0x0, .msr_values = {0x00}},
      R"(BL NCS Egress Occupancy)",
      R"(BL NCS Egress Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TxR2_BL_STALL_CREDIT_CYCLES",
      EventDef::Encoding{.code = 0x1B, .umask = 0x0, .msr_values = {0x00}},
      R"(No BL Egress Credit Stalls)",
      R"(Counts the number times when it is not possible to issue data to the R2PCIe because there are no BL Egress Credits available.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TxS_DATA_INSERTS_NCB",
      EventDef::Encoding{.code = 0xD, .umask = 0x0, .msr_values = {0x00}},
      R"(Outbound Read Requests)",
      R"(Counts the number of requests issued to the switch (towards the devices).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TxS_DATA_INSERTS_NCS",
      EventDef::Encoding{.code = 0xE, .umask = 0x0, .msr_values = {0x00}},
      R"(Outbound Read Requests)",
      R"(Counts the number of requests issued to the switch (towards the devices).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_irp,
      "UNC_I_TxS_REQUEST_OCCUPANCY",
      EventDef::Encoding{.code = 0xC, .umask = 0x0, .msr_values = {0x00}},
      R"(Outbound Request Queue Occupancy)",
      R"(Accumulates the number of outstanding outbound requests from the IRP to the switch (towards the devices).  This can be used in conjunction with the allocations event in order to calculate average latency of outbound requests.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_FLOWQ_NO_VNA_CRD.AD_VNA_EQ0",
      EventDef::Encoding{.code = 0x18, .umask = 0x1, .msr_values = {0x00}},
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AD_VNA_EQ0)",
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AD_VNA_EQ0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_FLOWQ_NO_VNA_CRD.AD_VNA_EQ1",
      EventDef::Encoding{.code = 0x18, .umask = 0x02, .msr_values = {0x00}},
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AD_VNA_EQ1)",
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AD_VNA_EQ1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_FLOWQ_NO_VNA_CRD.AD_VNA_EQ2",
      EventDef::Encoding{.code = 0x18, .umask = 0x04, .msr_values = {0x00}},
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AD_VNA_EQ2)",
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AD_VNA_EQ2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_FLOWQ_NO_VNA_CRD.BL_VNA_EQ0",
      EventDef::Encoding{.code = 0x18, .umask = 0x8, .msr_values = {0x00}},
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.BL_VNA_EQ0)",
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.BL_VNA_EQ0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ0",
      EventDef::Encoding{.code = 0x18, .umask = 0x10, .msr_values = {0x00}},
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ0)",
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_BYP_BLOCKED.FLOWQ_AD_VNA_LE2",
      EventDef::Encoding{.code = 0x14, .umask = 0x1, .msr_values = {0x00}},
      R"(UNC_UPI_M3_BYP_BLOCKED.FLOWQ_AD_VNA_LE2)",
      R"(UNC_UPI_M3_BYP_BLOCKED.FLOWQ_AD_VNA_LE2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_BYP_BLOCKED.FLOWQ_BL_VNA_EQ0",
      EventDef::Encoding{.code = 0x14, .umask = 0x2, .msr_values = {0x00}},
      R"(UNC_UPI_M3_BYP_BLOCKED.FLOWQ_BL_VNA_EQ0)",
      R"(UNC_UPI_M3_BYP_BLOCKED.FLOWQ_BL_VNA_EQ0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_BYP_BLOCKED.FLOWQ_AK_VNA_LE3",
      EventDef::Encoding{.code = 0x14, .umask = 0x4, .msr_values = {0x00}},
      R"(UNC_UPI_M3_BYP_BLOCKED.FLOWQ_AK_VNA_LE3)",
      R"(UNC_UPI_M3_BYP_BLOCKED.FLOWQ_AK_VNA_LE3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_BYP_BLOCKED.BGF_CRD",
      EventDef::Encoding{.code = 0x14, .umask = 0x8, .msr_values = {0x00}},
      R"(UNC_UPI_M3_BYP_BLOCKED.BGF_CRD)",
      R"(UNC_UPI_M3_BYP_BLOCKED.BGF_CRD)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_BYP_BLOCKED.GV_BLOCK",
      EventDef::Encoding{.code = 0x14, .umask = 0x10, .msr_values = {0x00}},
      R"(UNC_UPI_M3_BYP_BLOCKED.GV_BLOCK)",
      R"(UNC_UPI_M3_BYP_BLOCKED.GV_BLOCK)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_CRD_RETURN_BLOCKED",
      EventDef::Encoding{.code = 0x16, .umask = 0x0, .msr_values = {0x00}},
      R"(UNC_UPI_M3_CRD_RETURN_BLOCKED)",
      R"(UNC_UPI_M3_CRD_RETURN_BLOCKED)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_AD_VNA_LE2",
      EventDef::Encoding{.code = 0x15, .umask = 0x1, .msr_values = {0x00}},
      R"(UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_AD_VNA_LE2)",
      R"(UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_AD_VNA_LE2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_AD_VNA_BTW_2_THRESH",
      EventDef::Encoding{.code = 0x15, .umask = 0x2, .msr_values = {0x00}},
      R"(UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_AD_VNA_BTW_2_THRESH)",
      R"(UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_AD_VNA_BTW_2_THRESH)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_BL_VNA_EQ0",
      EventDef::Encoding{.code = 0x15, .umask = 0x4, .msr_values = {0x00}},
      R"(UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_BL_VNA_EQ0)",
      R"(UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_BL_VNA_EQ0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_BL_VNA_BTW_0_THRESH",
      EventDef::Encoding{.code = 0x15, .umask = 0x8, .msr_values = {0x00}},
      R"(UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_BL_VNA_BTW_0_THRESH)",
      R"(UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_BL_VNA_BTW_0_THRESH)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_AK_VNA_LE3",
      EventDef::Encoding{.code = 0x15, .umask = 0x10, .msr_values = {0x00}},
      R"(UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_AK_VNA_LE3)",
      R"(UNC_UPI_M3_RXQ_BLOCKED.FLOWQ_AK_VNA_LE3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_RXQ_BLOCKED.BGF_CRD",
      EventDef::Encoding{.code = 0x15, .umask = 0x20, .msr_values = {0x00}},
      R"(UNC_UPI_M3_RXQ_BLOCKED.BGF_CRD)",
      R"(UNC_UPI_M3_RXQ_BLOCKED.BGF_CRD)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_M3_RXQ_BLOCKED.GV_BLOCK",
      EventDef::Encoding{.code = 0x15, .umask = 0x40, .msr_values = {0x00}},
      R"(UNC_UPI_M3_RXQ_BLOCKED.GV_BLOCK)",
      R"(UNC_UPI_M3_RXQ_BLOCKED.GV_BLOCK)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_PHY_INIT_CYCLES",
      EventDef::Encoding{.code = 0x20, .umask = 0x0, .msr_values = {0x00}},
      R"(Cycles where phy is not in L0, L0c, L0p, L1)",
      R"(Cycles where phy is not in L0, L0c, L0p, L1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_POWER_L1_NACK",
      EventDef::Encoding{.code = 0x23, .umask = 0x0, .msr_values = {0x00}},
      R"(L1 Req Nack)",
      R"(Counts the number of times a link sends/receives a LinkReqNAck.  When the UPI links would like to change power state, the Tx side initiates a request to the Rx side requesting to change states.  This requests can either be accepted or denied.  If the Rx side replies with an Ack, the power mode will change.  If it replies with NAck, no change will take place.  This can be filtered based on Rx and Tx.  An Rx LinkReqNAck refers to receiving an NAck (meaning this agent's Tx originally requested the power change).  A Tx LinkReqNAck refers to sending this command (meaning the peer agent's Tx originally requested the power change and this agent accepted it).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_POWER_L1_REQ",
      EventDef::Encoding{.code = 0x22, .umask = 0x0, .msr_values = {0x00}},
      R"(L1 Req (same as L1 Ack).)",
      R"(Counts the number of times a link sends/receives a LinkReqAck.  When the UPI links would like to change power state, the Tx side initiates a request to the Rx side requesting to change states.  This requests can either be accepted or denied.  If the Rx side replies with an Ack, the power mode will change.  If it replies with NAck, no change will take place.  This can be filtered based on Rx and Tx.  An Rx LinkReqAck refers to receiving an Ack (meaning this agent's Tx originally requested the power change).  A Tx LinkReqAck refers to sending this command (meaning the peer agent's Tx originally requested the power change and this agent accepted it).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_REQ_SLOT2_FROM_M3.VNA",
      EventDef::Encoding{.code = 0x46, .umask = 0x1, .msr_values = {0x00}},
      R"(UNC_UPI_REQ_SLOT2_FROM_M3.VNA)",
      R"(UNC_UPI_REQ_SLOT2_FROM_M3.VNA)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_REQ_SLOT2_FROM_M3.VN0",
      EventDef::Encoding{.code = 0x46, .umask = 0x2, .msr_values = {0x00}},
      R"(UNC_UPI_REQ_SLOT2_FROM_M3.VN0)",
      R"(UNC_UPI_REQ_SLOT2_FROM_M3.VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_REQ_SLOT2_FROM_M3.VN1",
      EventDef::Encoding{.code = 0x46, .umask = 0x4, .msr_values = {0x00}},
      R"(UNC_UPI_REQ_SLOT2_FROM_M3.VN1)",
      R"(UNC_UPI_REQ_SLOT2_FROM_M3.VN1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_REQ_SLOT2_FROM_M3.ACK",
      EventDef::Encoding{.code = 0x46, .umask = 0x8, .msr_values = {0x00}},
      R"(UNC_UPI_REQ_SLOT2_FROM_M3.ACK)",
      R"(UNC_UPI_REQ_SLOT2_FROM_M3.ACK)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL0_POWER_CYCLES",
      EventDef::Encoding{.code = 0x24, .umask = 0x0, .msr_values = {0x00}},
      R"(Cycles in L0. Receive side.)",
      R"(Number of UPI qfclk cycles spent in L0 power mode in the Link Layer.  L0 is the default mode which provides the highest performance with the most power.  Use edge detect to count the number of instances that the link entered L0.  Link power states are per link and per direction, so for example the Tx direction could be in one state while Rx was in another.  The phy layer  sometimes leaves L0 for training, which will not be captured by this event.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_CRC_ERRORS",
      EventDef::Encoding{.code = 0xB, .umask = 0x0, .msr_values = {0x00}},
      R"(CRC Errors Detected)",
      R"(Number of CRC errors detected in the UPI Agent.  Each UPI flit incorporates 8 bits of CRC for error detection.  This counts the number of flits where the CRC was able to detect an error.  After an error has been detected, the UPI agent will send a request to the transmitting socket to resend the flit (as well as any flits that came after it).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_CRC_LLR_REQ_TRANSMIT",
      EventDef::Encoding{.code = 0x8, .umask = 0x0, .msr_values = {0x00}},
      R"(LLR Requests Sent)",
      R"(Number of LLR Requests were transmitted.  This should generally be <= the number of CRC errors detected.  If multiple errors are detected before the Rx side receives a LLC_REQ_ACK from the Tx side, there is no need to send more LLR_REQ_NACKs.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_CREDITS_CONSUMED_VN0",
      EventDef::Encoding{.code = 0x39, .umask = 0x0, .msr_values = {0x00}},
      R"(VN0 Credit Consumed)",
      R"(Counts the number of times that an RxQ VN0 credit was consumed (i.e. message uses a VN0 credit for the Rx Buffer).  This includes packets that went through the RxQ and those that were bypasssed.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_CREDITS_CONSUMED_VN1",
      EventDef::Encoding{.code = 0x3A, .umask = 0x0, .msr_values = {0x00}},
      R"(VN1 Credit Consumed)",
      R"(Counts the number of times that an RxQ VN1 credit was consumed (i.e. message uses a VN1 credit for the Rx Buffer).  This includes packets that went through the RxQ and those that were bypasssed.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_CREDITS_CONSUMED_VNA",
      EventDef::Encoding{.code = 0x38, .umask = 0x0, .msr_values = {0x00}},
      R"(VNA Credit Consumed)",
      R"(Counts the number of times that an RxQ VNA credit was consumed (i.e. message uses a VNA credit for the Rx Buffer).  This includes packets that went through the RxQ and those that were bypasssed.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_FLITS.SLOT0",
      EventDef::Encoding{.code = 0x3, .umask = 0x1, .msr_values = {0x00}},
      R"(Valid Flits Received; Slot 0)",
      R"(Shows legal flit time (hides impact of L0p and L0c).; Count Slot 0 - Other mask bits determine types of headers to count.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_FLITS.SLOT1",
      EventDef::Encoding{.code = 0x3, .umask = 0x2, .msr_values = {0x00}},
      R"(Valid Flits Received; Slot 1)",
      R"(Shows legal flit time (hides impact of L0p and L0c).; Count Slot 1 - Other mask bits determine types of headers to count.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_FLITS.SLOT2",
      EventDef::Encoding{.code = 0x3, .umask = 0x4, .msr_values = {0x00}},
      R"(Valid Flits Received; Slot 2)",
      R"(Shows legal flit time (hides impact of L0p and L0c).; Count Slot 2 - Other mask bits determine types of headers to count.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_FLITS.DATA",
      EventDef::Encoding{.code = 0x3, .umask = 0x8, .msr_values = {0x00}},
      R"(Valid Flits Received; Data)",
      R"(Shows legal flit time (hides impact of L0p and L0c).; Count Data Flits (which consume all slots), but how much to count is based on Slot0-2 mask, so count can be 0-3 depending on which slots are enabled for counting..)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_FLITS.LLCRD",
      EventDef::Encoding{.code = 0x3, .umask = 0x10, .msr_values = {0x00}},
      R"(Valid Flits Received; LLCRD Not Empty)",
      R"(Shows legal flit time (hides impact of L0p and L0c).; Enables counting of LLCRD (with non-zero payload). This only applies to slot 2 since LLCRD is only allowed in slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_FLITS.LLCTRL",
      EventDef::Encoding{.code = 0x3, .umask = 0x40, .msr_values = {0x00}},
      R"(Valid Flits Received; LLCTRL)",
      R"(Shows legal flit time (hides impact of L0p and L0c).; Equivalent to an idle packet.  Enables counting of slot 0 LLCTRL messages.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_OCCUPANCY.SLOT0",
      EventDef::Encoding{.code = 0x32, .umask = 0x1, .msr_values = {0x00}},
      R"(RxQ Occupancy - All Packets; Slot 0)",
      R"(Accumulates the number of elements in the UPI RxQ in each cycle.  Generally, when data is transmitted across UPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Not Empty event to calculate average occupancy, or with the Flit Buffer Allocations event to track average lifetime.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_OCCUPANCY.SLOT1",
      EventDef::Encoding{.code = 0x32, .umask = 0x2, .msr_values = {0x00}},
      R"(RxQ Occupancy - All Packets; Slot 1)",
      R"(Accumulates the number of elements in the UPI RxQ in each cycle.  Generally, when data is transmitted across UPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Not Empty event to calculate average occupancy, or with the Flit Buffer Allocations event to track average lifetime.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_OCCUPANCY.SLOT2",
      EventDef::Encoding{.code = 0x32, .umask = 0x4, .msr_values = {0x00}},
      R"(RxQ Occupancy - All Packets; Slot 2)",
      R"(Accumulates the number of elements in the UPI RxQ in each cycle.  Generally, when data is transmitted across UPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Not Empty event to calculate average occupancy, or with the Flit Buffer Allocations event to track average lifetime.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_SLOT_BYPASS.S0_RXQ1",
      EventDef::Encoding{.code = 0x33, .umask = 0x1, .msr_values = {0x00}},
      R"(UNC_UPI_RxL_SLOT_BYPASS.S0_RXQ1)",
      R"(UNC_UPI_RxL_SLOT_BYPASS.S0_RXQ1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_SLOT_BYPASS.S0_RXQ2",
      EventDef::Encoding{.code = 0x33, .umask = 0x2, .msr_values = {0x00}},
      R"(UNC_UPI_RxL_SLOT_BYPASS.S0_RXQ2)",
      R"(UNC_UPI_RxL_SLOT_BYPASS.S0_RXQ2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_SLOT_BYPASS.S1_RXQ0",
      EventDef::Encoding{.code = 0x33, .umask = 0x4, .msr_values = {0x00}},
      R"(UNC_UPI_RxL_SLOT_BYPASS.S1_RXQ0)",
      R"(UNC_UPI_RxL_SLOT_BYPASS.S1_RXQ0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_SLOT_BYPASS.S1_RXQ2",
      EventDef::Encoding{.code = 0x33, .umask = 0x8, .msr_values = {0x00}},
      R"(UNC_UPI_RxL_SLOT_BYPASS.S1_RXQ2)",
      R"(UNC_UPI_RxL_SLOT_BYPASS.S1_RXQ2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_SLOT_BYPASS.S2_RXQ0",
      EventDef::Encoding{.code = 0x33, .umask = 0x10, .msr_values = {0x00}},
      R"(UNC_UPI_RxL_SLOT_BYPASS.S2_RXQ0)",
      R"(UNC_UPI_RxL_SLOT_BYPASS.S2_RXQ0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_SLOT_BYPASS.S2_RXQ1",
      EventDef::Encoding{.code = 0x33, .umask = 0x20, .msr_values = {0x00}},
      R"(UNC_UPI_RxL_SLOT_BYPASS.S2_RXQ1)",
      R"(UNC_UPI_RxL_SLOT_BYPASS.S2_RXQ1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL0P_CLK_ACTIVE.CFG_CTL",
      EventDef::Encoding{.code = 0x2A, .umask = 0x1, .msr_values = {0x00}},
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.CFG_CTL)",
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.CFG_CTL)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL0P_CLK_ACTIVE.RXQ",
      EventDef::Encoding{.code = 0x2A, .umask = 0x2, .msr_values = {0x00}},
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.RXQ)",
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.RXQ)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL0P_CLK_ACTIVE.RXQ_BYPASS",
      EventDef::Encoding{.code = 0x2A, .umask = 0x4, .msr_values = {0x00}},
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.RXQ_BYPASS)",
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.RXQ_BYPASS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL0P_CLK_ACTIVE.RXQ_CRED",
      EventDef::Encoding{.code = 0x2A, .umask = 0x8, .msr_values = {0x00}},
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.RXQ_CRED)",
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.RXQ_CRED)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL0P_CLK_ACTIVE.TXQ",
      EventDef::Encoding{.code = 0x2A, .umask = 0x10, .msr_values = {0x00}},
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.TXQ)",
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.TXQ)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL0P_CLK_ACTIVE.RETRY",
      EventDef::Encoding{.code = 0x2A, .umask = 0x20, .msr_values = {0x00}},
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.RETRY)",
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.RETRY)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL0P_CLK_ACTIVE.DFX",
      EventDef::Encoding{.code = 0x2A, .umask = 0x40, .msr_values = {0x00}},
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.DFX)",
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.DFX)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL0P_CLK_ACTIVE.SPARE",
      EventDef::Encoding{.code = 0x2A, .umask = 0x80, .msr_values = {0x00}},
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.SPARE)",
      R"(UNC_UPI_TxL0P_CLK_ACTIVE.SPARE)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL0P_POWER_CYCLES_LL_ENTER",
      EventDef::Encoding{.code = 0x28, .umask = 0x0, .msr_values = {0x00}},
      R"(UNC_UPI_TxL0P_POWER_CYCLES_LL_ENTER)",
      R"(UNC_UPI_TxL0P_POWER_CYCLES_LL_ENTER)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL0P_POWER_CYCLES_M3_EXIT",
      EventDef::Encoding{.code = 0x29, .umask = 0x0, .msr_values = {0x00}},
      R"(UNC_UPI_TxL0P_POWER_CYCLES_M3_EXIT)",
      R"(UNC_UPI_TxL0P_POWER_CYCLES_M3_EXIT)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL0_POWER_CYCLES",
      EventDef::Encoding{.code = 0x26, .umask = 0x0, .msr_values = {0x00}},
      R"(Cycles in L0. Transmit side.)",
      R"(Number of UPI qfclk cycles spent in L0 power mode in the Link Layer.  L0 is the default mode which provides the highest performance with the most power.  Use edge detect to count the number of instances that the link entered L0.  Link power states are per link and per direction, so for example the Tx direction could be in one state while Rx was in another.  The phy layer  sometimes leaves L0 for training, which will not be captured by this event.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_FLITS.SLOT0",
      EventDef::Encoding{.code = 0x2, .umask = 0x1, .msr_values = {0x00}},
      R"(Valid Flits Sent; Slot 0)",
      R"(Shows legal flit time (hides impact of L0p and L0c).; Count Slot 0 - Other mask bits determine types of headers to count.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_FLITS.SLOT1",
      EventDef::Encoding{.code = 0x2, .umask = 0x2, .msr_values = {0x00}},
      R"(Valid Flits Sent; Slot 1)",
      R"(Shows legal flit time (hides impact of L0p and L0c).; Count Slot 1 - Other mask bits determine types of headers to count.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_FLITS.SLOT2",
      EventDef::Encoding{.code = 0x2, .umask = 0x4, .msr_values = {0x00}},
      R"(Valid Flits Sent; Slot 2)",
      R"(Shows legal flit time (hides impact of L0p and L0c).; Count Slot 2 - Other mask bits determine types of headers to count.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_FLITS.LLCRD",
      EventDef::Encoding{.code = 0x2, .umask = 0x10, .msr_values = {0x00}},
      R"(Valid Flits Sent; LLCRD Not Empty)",
      R"(Shows legal flit time (hides impact of L0p and L0c).; Enables counting of LLCRD (with non-zero payload). This only applies to slot 2 since LLCRD is only allowed in slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_FLITS.LLCTRL",
      EventDef::Encoding{.code = 0x2, .umask = 0x40, .msr_values = {0x00}},
      R"(Valid Flits Sent; LLCTRL)",
      R"(Shows legal flit time (hides impact of L0p and L0c).; Equivalent to an idle packet.  Enables counting of slot 0 LLCTRL messages.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_INSERTS",
      EventDef::Encoding{.code = 0x40, .umask = 0x0, .msr_values = {0x00}},
      R"(Tx Flit Buffer Allocations)",
      R"(Number of allocations into the UPI Tx Flit Buffer.  Generally, when data is transmitted across UPI, it will bypass the TxQ and pass directly to the link.  However, the TxQ will be used with L0p and when LLR occurs, increasing latency to transfer out to the link.  This event can be used in conjunction with the Flit Buffer Occupancy event in order to calculate the average flit buffer lifetime.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_OCCUPANCY",
      EventDef::Encoding{.code = 0x42, .umask = 0x0, .msr_values = {0x00}},
      R"(Tx Flit Buffer Occupancy)",
      R"(Accumulates the number of flits in the TxQ.  Generally, when data is transmitted across UPI, it will bypass the TxQ and pass directly to the link.  However, the TxQ will be used with L0p and when LLR occurs, increasing latency to transfer out to the link. This can be used with the cycles not empty event to track average occupancy, or the allocations event to track average lifetime in the TxQ.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_VNA_CREDIT_RETURN_BLOCKED_VN01",
      EventDef::Encoding{.code = 0x45, .umask = 0x0, .msr_values = {0x00}},
      R"(UNC_UPI_VNA_CREDIT_RETURN_BLOCKED_VN01)",
      R"(UNC_UPI_VNA_CREDIT_RETURN_BLOCKED_VN01)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_VNA_CREDIT_RETURN_OCCUPANCY",
      EventDef::Encoding{.code = 0x44, .umask = 0x0, .msr_values = {0x00}},
      R"(VNA Credits Pending Return - Occupancy)",
      R"(Number of VNA credits in the Rx side that are waitng to be returned back across the link.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_BYPASS_M2M_Egress.TAKEN",
      EventDef::Encoding{.code = 0x22, .umask = 0x1, .msr_values = {0x00}},
      R"(M2M to iMC Bypass; Taken)",
      R"(M2M to iMC Bypass; Taken)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_CLOCKTICKS",
      EventDef::Encoding{.code = 0x0, .umask = 0x0, .msr_values = {0x00}},
      R"(Cycles - at UCLK)",
      R"(Cycles - at UCLK)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_HIT.DIRTY_I",
      EventDef::Encoding{.code = 0x2A, .umask = 0x1, .msr_values = {0x00}},
      R"(Directory Hit; On Dirty Line in I State)",
      R"(Directory Hit; On Dirty Line in I State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_HIT.DIRTY_S",
      EventDef::Encoding{.code = 0x2A, .umask = 0x2, .msr_values = {0x00}},
      R"(Directory Hit; On Dirty Line in S State)",
      R"(Directory Hit; On Dirty Line in S State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_HIT.DIRTY_P",
      EventDef::Encoding{.code = 0x2A, .umask = 0x4, .msr_values = {0x00}},
      R"(Directory Hit; On Dirty Line in L State)",
      R"(Directory Hit; On Dirty Line in L State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_HIT.DIRTY_A",
      EventDef::Encoding{.code = 0x2A, .umask = 0x8, .msr_values = {0x00}},
      R"(Directory Hit; On Dirty Line in A State)",
      R"(Directory Hit; On Dirty Line in A State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_HIT.CLEAN_I",
      EventDef::Encoding{.code = 0x2A, .umask = 0x10, .msr_values = {0x00}},
      R"(Directory Hit; On NonDirty Line in I State)",
      R"(Directory Hit; On NonDirty Line in I State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_HIT.CLEAN_S",
      EventDef::Encoding{.code = 0x2A, .umask = 0x20, .msr_values = {0x00}},
      R"(Directory Hit; On NonDirty Line in S State)",
      R"(Directory Hit; On NonDirty Line in S State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_HIT.CLEAN_P",
      EventDef::Encoding{.code = 0x2A, .umask = 0x40, .msr_values = {0x00}},
      R"(Directory Hit; On NonDirty Line in L State)",
      R"(Directory Hit; On NonDirty Line in L State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_HIT.CLEAN_A",
      EventDef::Encoding{.code = 0x2A, .umask = 0x80, .msr_values = {0x00}},
      R"(Directory Hit; On NonDirty Line in A State)",
      R"(Directory Hit; On NonDirty Line in A State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_MISS.DIRTY_I",
      EventDef::Encoding{.code = 0x2B, .umask = 0x1, .msr_values = {0x00}},
      R"(Directory Miss; On Dirty Line in I State)",
      R"(Directory Miss; On Dirty Line in I State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_MISS.DIRTY_S",
      EventDef::Encoding{.code = 0x2B, .umask = 0x2, .msr_values = {0x00}},
      R"(Directory Miss; On Dirty Line in S State)",
      R"(Directory Miss; On Dirty Line in S State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_MISS.DIRTY_P",
      EventDef::Encoding{.code = 0x2B, .umask = 0x4, .msr_values = {0x00}},
      R"(Directory Miss; On Dirty Line in L State)",
      R"(Directory Miss; On Dirty Line in L State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_MISS.DIRTY_A",
      EventDef::Encoding{.code = 0x2B, .umask = 0x8, .msr_values = {0x00}},
      R"(Directory Miss; On Dirty Line in A State)",
      R"(Directory Miss; On Dirty Line in A State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_MISS.CLEAN_I",
      EventDef::Encoding{.code = 0x2B, .umask = 0x10, .msr_values = {0x00}},
      R"(Directory Miss; On NonDirty Line in I State)",
      R"(Directory Miss; On NonDirty Line in I State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_MISS.CLEAN_S",
      EventDef::Encoding{.code = 0x2B, .umask = 0x20, .msr_values = {0x00}},
      R"(Directory Miss; On NonDirty Line in S State)",
      R"(Directory Miss; On NonDirty Line in S State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_MISS.CLEAN_P",
      EventDef::Encoding{.code = 0x2B, .umask = 0x40, .msr_values = {0x00}},
      R"(Directory Miss; On NonDirty Line in L State)",
      R"(Directory Miss; On NonDirty Line in L State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_DIRECTORY_MISS.CLEAN_A",
      EventDef::Encoding{.code = 0x2B, .umask = 0x80, .msr_values = {0x00}},
      R"(Directory Miss; On NonDirty Line in A State)",
      R"(Directory Miss; On NonDirty Line in A State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_READS.ISOCH",
      EventDef::Encoding{.code = 0x37, .umask = 0x2, .msr_values = {0x00}},
      R"(M2M Reads Issued to iMC; Critical Priority)",
      R"(M2M Reads Issued to iMC; Critical Priority)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_READS.FROM_TRANSGRESS",
      EventDef::Encoding{.code = 0x37, .umask = 0x10, .msr_values = {0x00}},
      R"(M2M Reads Issued to iMC; All, regardless of priority.)",
      R"(M2M Reads Issued to iMC; All, regardless of priority.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.FULL",
      EventDef::Encoding{.code = 0x38, .umask = 0x1, .msr_values = {0x00}},
      R"(M2M Writes Issued to iMC; Full Line Non-ISOCH)",
      R"(M2M Writes Issued to iMC; Full Line Non-ISOCH)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.FULL_ISOCH",
      EventDef::Encoding{.code = 0x38, .umask = 0x4, .msr_values = {0x00}},
      R"(M2M Writes Issued to iMC; ISOCH Full Line)",
      R"(M2M Writes Issued to iMC; ISOCH Full Line)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.PARTIAL_ISOCH",
      EventDef::Encoding{.code = 0x38, .umask = 0x8, .msr_values = {0x00}},
      R"(M2M Writes Issued to iMC; ISOCH Partial)",
      R"(M2M Writes Issued to iMC; ISOCH Partial)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_IMC_WRITES.FROM_TRANSGRESS",
      EventDef::Encoding{.code = 0x38, .umask = 0x40, .msr_values = {0x00}},
      R"(M2M Writes Issued to iMC; All, regardless of priority.)",
      R"(M2M Writes Issued to iMC; All, regardless of priority.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PKT_MATCH.MESH",
      EventDef::Encoding{.code = 0x4C, .umask = 0x1, .msr_values = {0x00}},
      R"(Number Packet Header Matches; Mesh Match)",
      R"(Number Packet Header Matches; Mesh Match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PKT_MATCH.MC",
      EventDef::Encoding{.code = 0x4C, .umask = 0x2, .msr_values = {0x00}},
      R"(Number Packet Header Matches; MC Match)",
      R"(Number Packet Header Matches; MC Match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_CYCLES_FULL",
      EventDef::Encoding{.code = 0x53, .umask = 0x0, .msr_values = {0x00}},
      R"(Prefetch CAM Cycles Full)",
      R"(Prefetch CAM Cycles Full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_CYCLES_NE",
      EventDef::Encoding{.code = 0x54, .umask = 0x0, .msr_values = {0x00}},
      R"(Prefetch CAM Cycles Not Empty)",
      R"(Prefetch CAM Cycles Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_PREFCAM_OCCUPANCY",
      EventDef::Encoding{.code = 0x55, .umask = 0x0, .msr_values = {0x00}},
      R"(Prefetch CAM Occupancy)",
      R"(Prefetch CAM Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TGR_AD_CREDITS",
      EventDef::Encoding{.code = 0x41, .umask = 0x0, .msr_values = {0x00}},
      R"(Number AD Ingress Credits)",
      R"(Number AD Ingress Credits)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TGR_BL_CREDITS",
      EventDef::Encoding{.code = 0x42, .umask = 0x0, .msr_values = {0x00}},
      R"(Number BL Ingress Credits)",
      R"(Number BL Ingress Credits)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_CYCLES_FULL.CH0",
      EventDef::Encoding{.code = 0x45, .umask = 0x1, .msr_values = {0x00}},
      R"(Tracker Cycles Full; Channel 0)",
      R"(Tracker Cycles Full; Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_CYCLES_FULL.CH1",
      EventDef::Encoding{.code = 0x45, .umask = 0x2, .msr_values = {0x00}},
      R"(Tracker Cycles Full; Channel 1)",
      R"(Tracker Cycles Full; Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_CYCLES_FULL.CH2",
      EventDef::Encoding{.code = 0x45, .umask = 0x4, .msr_values = {0x00}},
      R"(Tracker Cycles Full; Channel 2)",
      R"(Tracker Cycles Full; Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_CYCLES_NE.CH0",
      EventDef::Encoding{.code = 0x46, .umask = 0x1, .msr_values = {0x00}},
      R"(Tracker Cycles Not Empty; Channel 0)",
      R"(Tracker Cycles Not Empty; Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_CYCLES_NE.CH1",
      EventDef::Encoding{.code = 0x46, .umask = 0x2, .msr_values = {0x00}},
      R"(Tracker Cycles Not Empty; Channel 1)",
      R"(Tracker Cycles Not Empty; Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_CYCLES_NE.CH2",
      EventDef::Encoding{.code = 0x46, .umask = 0x4, .msr_values = {0x00}},
      R"(Tracker Cycles Not Empty; Channel 2)",
      R"(Tracker Cycles Not Empty; Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_INSERTS.CH0",
      EventDef::Encoding{.code = 0x49, .umask = 0x1, .msr_values = {0x00}},
      R"(Tracker Inserts; Channel 0)",
      R"(Tracker Inserts; Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_INSERTS.CH1",
      EventDef::Encoding{.code = 0x49, .umask = 0x2, .msr_values = {0x00}},
      R"(Tracker Inserts; Channel 1)",
      R"(Tracker Inserts; Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_INSERTS.CH2",
      EventDef::Encoding{.code = 0x49, .umask = 0x4, .msr_values = {0x00}},
      R"(Tracker Inserts; Channel 2)",
      R"(Tracker Inserts; Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_OCCUPANCY.CH0",
      EventDef::Encoding{.code = 0x47, .umask = 0x1, .msr_values = {0x00}},
      R"(Tracker Occupancy; Channel 0)",
      R"(Tracker Occupancy; Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_OCCUPANCY.CH1",
      EventDef::Encoding{.code = 0x47, .umask = 0x2, .msr_values = {0x00}},
      R"(Tracker Occupancy; Channel 1)",
      R"(Tracker Occupancy; Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_OCCUPANCY.CH2",
      EventDef::Encoding{.code = 0x47, .umask = 0x4, .msr_values = {0x00}},
      R"(Tracker Occupancy; Channel 2)",
      R"(Tracker Occupancy; Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TRACKER_PENDING_OCCUPANCY",
      EventDef::Encoding{.code = 0x48, .umask = 0x0, .msr_values = {0x00}},
      R"(Data Pending Occupancy)",
      R"(Data Pending Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WRITE_TRACKER_CYCLES_FULL.CH0",
      EventDef::Encoding{.code = 0x4A, .umask = 0x1, .msr_values = {0x00}},
      R"(Write Tracker Cycles Full; Channel 0)",
      R"(Write Tracker Cycles Full; Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WRITE_TRACKER_CYCLES_FULL.CH1",
      EventDef::Encoding{.code = 0x4A, .umask = 0x2, .msr_values = {0x00}},
      R"(Write Tracker Cycles Full; Channel 1)",
      R"(Write Tracker Cycles Full; Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WRITE_TRACKER_CYCLES_FULL.CH2",
      EventDef::Encoding{.code = 0x4A, .umask = 0x4, .msr_values = {0x00}},
      R"(Write Tracker Cycles Full; Channel 2)",
      R"(Write Tracker Cycles Full; Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WRITE_TRACKER_CYCLES_NE.CH0",
      EventDef::Encoding{.code = 0x4B, .umask = 0x1, .msr_values = {0x00}},
      R"(Write Tracker Cycles Not Empty; Channel 0)",
      R"(Write Tracker Cycles Not Empty; Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WRITE_TRACKER_CYCLES_NE.CH1",
      EventDef::Encoding{.code = 0x4B, .umask = 0x2, .msr_values = {0x00}},
      R"(Write Tracker Cycles Not Empty; Channel 1)",
      R"(Write Tracker Cycles Not Empty; Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WRITE_TRACKER_CYCLES_NE.CH2",
      EventDef::Encoding{.code = 0x4B, .umask = 0x4, .msr_values = {0x00}},
      R"(Write Tracker Cycles Not Empty; Channel 2)",
      R"(Write Tracker Cycles Not Empty; Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WRITE_TRACKER_INSERTS.CH0",
      EventDef::Encoding{.code = 0x61, .umask = 0x1, .msr_values = {0x00}},
      R"(Write Tracker Inserts; Channel 0)",
      R"(Write Tracker Inserts; Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WRITE_TRACKER_INSERTS.CH1",
      EventDef::Encoding{.code = 0x61, .umask = 0x2, .msr_values = {0x00}},
      R"(Write Tracker Inserts; Channel 1)",
      R"(Write Tracker Inserts; Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WRITE_TRACKER_INSERTS.CH2",
      EventDef::Encoding{.code = 0x61, .umask = 0x4, .msr_values = {0x00}},
      R"(Write Tracker Inserts; Channel 2)",
      R"(Write Tracker Inserts; Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WRITE_TRACKER_OCCUPANCY.CH0",
      EventDef::Encoding{.code = 0x60, .umask = 0x1, .msr_values = {0x00}},
      R"(Write Tracker Occupancy; Channel 0)",
      R"(Write Tracker Occupancy; Channel 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WRITE_TRACKER_OCCUPANCY.CH1",
      EventDef::Encoding{.code = 0x60, .umask = 0x2, .msr_values = {0x00}},
      R"(Write Tracker Occupancy; Channel 1)",
      R"(Write Tracker Occupancy; Channel 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_WRITE_TRACKER_OCCUPANCY.CH2",
      EventDef::Encoding{.code = 0x60, .umask = 0x4, .msr_values = {0x00}},
      R"(Write Tracker Occupancy; Channel 2)",
      R"(Write Tracker Occupancy; Channel 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_CLOCKTICKS",
      EventDef::Encoding{.code = 0x0, .umask = 0x0, .msr_values = {0x00}},
      R"(pclk Cycles)",
      R"(The PCU runs off a fixed 1 GHz clock.  This event counts the number of pclk cycles measured while the counter was enabled.  The pclk, like the Memory Controller's dclk, counts at a constant rate making it a good measure of actual wall time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_CORE_TRANSITION_CYCLES",
      EventDef::Encoding{.code = 0x60, .umask = 0x0, .msr_values = {0x00}},
      R"(UNC_P_CORE_TRANSITION_CYCLES)",
      R"(UNC_P_CORE_TRANSITION_CYCLES)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_DEMOTIONS",
      EventDef::Encoding{.code = 0x30, .umask = 0x0, .msr_values = {0x00}},
      R"(UNC_P_DEMOTIONS)",
      R"(UNC_P_DEMOTIONS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_FIVR_PS_PS0_CYCLES",
      EventDef::Encoding{.code = 0x75, .umask = 0x0, .msr_values = {0x00}},
      R"(Phase Shed 0 Cycles)",
      R"(Cycles spent in phase-shedding power state 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_FIVR_PS_PS1_CYCLES",
      EventDef::Encoding{.code = 0x76, .umask = 0x0, .msr_values = {0x00}},
      R"(Phase Shed 1 Cycles)",
      R"(Cycles spent in phase-shedding power state 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_FIVR_PS_PS2_CYCLES",
      EventDef::Encoding{.code = 0x77, .umask = 0x0, .msr_values = {0x00}},
      R"(Phase Shed 2 Cycles)",
      R"(Cycles spent in phase-shedding power state 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_FIVR_PS_PS3_CYCLES",
      EventDef::Encoding{.code = 0x78, .umask = 0x0, .msr_values = {0x00}},
      R"(Phase Shed 3 Cycles)",
      R"(Cycles spent in phase-shedding power state 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_FREQ_MAX_LIMIT_THERMAL_CYCLES",
      EventDef::Encoding{.code = 0x4, .umask = 0x0, .msr_values = {0x00}},
      R"(Thermal Strongest Upper Limit Cycles)",
      R"(Counts the number of cycles when thermal conditions are the upper limit on frequency.  This is related to the THERMAL_THROTTLE CYCLES_ABOVE_TEMP event, which always counts cycles when we are above the thermal temperature.  This event (STRONGEST_UPPER_LIMIT) is sampled at the output of the algorithm that determines the actual frequency, while THERMAL_THROTTLE looks at the input.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_FREQ_MAX_POWER_CYCLES",
      EventDef::Encoding{.code = 0x5, .umask = 0x0, .msr_values = {0x00}},
      R"(Power Strongest Upper Limit Cycles)",
      R"(Counts the number of cycles when power is the upper limit on frequency.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_FREQ_MIN_IO_P_CYCLES",
      EventDef::Encoding{.code = 0x73, .umask = 0x0, .msr_values = {0x00}},
      R"(IO P Limit Strongest Lower Limit Cycles)",
      R"(Counts the number of cycles when IO P Limit is preventing us from dropping the frequency lower.  This algorithm monitors the needs to the IO subsystem on both local and remote sockets and will maintain a frequency high enough to maintain good IO BW.  This is necessary for when all the IA cores on a socket are idle but a user still would like to maintain high IO Bandwidth.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_FREQ_TRANS_CYCLES",
      EventDef::Encoding{.code = 0x74, .umask = 0x0, .msr_values = {0x00}},
      R"(Cycles spent changing Frequency)",
      R"(Counts the number of cycles when the system is changing frequency.  This can not be filtered by thread ID.  One can also use it with the occupancy counter that monitors number of threads in C0 to estimate the performance impact that frequency transitions had on the system.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_MCP_PROCHOT_CYCLES",
      EventDef::Encoding{.code = 0x6, .umask = 0x0, .msr_values = {0x00}},
      R"(UNC_P_MCP_PROCHOT_CYCLES)",
      R"(UNC_P_MCP_PROCHOT_CYCLES)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_MEMORY_PHASE_SHEDDING_CYCLES",
      EventDef::Encoding{.code = 0x2F, .umask = 0x0, .msr_values = {0x00}},
      R"(Memory Phase Shedding Cycles)",
      R"(Counts the number of cycles that the PCU has triggered memory phase shedding.  This is a mode that can be run in the iMC physicals that saves power at the expense of additional latency.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_PKG_RESIDENCY_C0_CYCLES",
      EventDef::Encoding{.code = 0x2A, .umask = 0x0, .msr_values = {0x00}},
      R"(Package C State Residency - C0)",
      R"(Counts the number of cycles when the package was in C0.  This event can be used in conjunction with edge detect to count C0 entrances (or exits using invert).  Residency events do not include transition times.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_PKG_RESIDENCY_C2E_CYCLES",
      EventDef::Encoding{.code = 0x2B, .umask = 0x0, .msr_values = {0x00}},
      R"(Package C State Residency - C2E)",
      R"(Counts the number of cycles when the package was in C2E.  This event can be used in conjunction with edge detect to count C2E entrances (or exits using invert).  Residency events do not include transition times.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_PKG_RESIDENCY_C3_CYCLES",
      EventDef::Encoding{.code = 0x2C, .umask = 0x0, .msr_values = {0x00}},
      R"(Package C State Residency - C3)",
      R"(Counts the number of cycles when the package was in C3.  This event can be used in conjunction with edge detect to count C3 entrances (or exits using invert).  Residency events do not include transition times.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_PKG_RESIDENCY_C6_CYCLES",
      EventDef::Encoding{.code = 0x2D, .umask = 0x0, .msr_values = {0x00}},
      R"(Package C State Residency - C6)",
      R"(Counts the number of cycles when the package was in C6.  This event can be used in conjunction with edge detect to count C6 entrances (or exits using invert).  Residency events do not include transition times.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_PMAX_THROTTLED_CYCLES",
      EventDef::Encoding{.code = 0x7, .umask = 0x0, .msr_values = {0x00}},
      R"(UNC_P_PMAX_THROTTLED_CYCLES)",
      R"(UNC_P_PMAX_THROTTLED_CYCLES)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_POWER_STATE_OCCUPANCY.CORES_C0",
      EventDef::Encoding{.code = 0x80, .umask = 0x40, .msr_values = {0x00}},
      R"(Number of cores in C-State; C0 and C1)",
      R"(This is an occupancy event that tracks the number of cores that are in the chosen C-State.  It can be used by itself to get the average number of cores in that C-state with thresholding to generate histograms, or with other PCU events and occupancy triggering to capture other details.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_POWER_STATE_OCCUPANCY.CORES_C3",
      EventDef::Encoding{.code = 0x80, .umask = 0x80, .msr_values = {0x00}},
      R"(Number of cores in C-State; C3)",
      R"(This is an occupancy event that tracks the number of cores that are in the chosen C-State.  It can be used by itself to get the average number of cores in that C-state with thresholding to generate histograms, or with other PCU events and occupancy triggering to capture other details.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_POWER_STATE_OCCUPANCY.CORES_C6",
      EventDef::Encoding{.code = 0x80, .umask = 0xC0, .msr_values = {0x00}},
      R"(Number of cores in C-State; C6 and C7)",
      R"(This is an occupancy event that tracks the number of cores that are in the chosen C-State.  It can be used by itself to get the average number of cores in that C-state with thresholding to generate histograms, or with other PCU events and occupancy triggering to capture other details.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_PROCHOT_EXTERNAL_CYCLES",
      EventDef::Encoding{.code = 0xA, .umask = 0x0, .msr_values = {0x00}},
      R"(External Prochot)",
      R"(Counts the number of cycles that we are in external PROCHOT mode.  This mode is triggered when a sensor off the die determines that something off-die (like DRAM) is too hot and must throttle to avoid damaging the chip.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_PROCHOT_INTERNAL_CYCLES",
      EventDef::Encoding{.code = 0x9, .umask = 0x0, .msr_values = {0x00}},
      R"(Internal Prochot)",
      R"(Counts the number of cycles that we are in Internal PROCHOT mode.  This mode is triggered when a sensor on the die determines that we are too hot and must throttle to avoid damaging the chip.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_TOTAL_TRANSITION_CYCLES",
      EventDef::Encoding{.code = 0x72, .umask = 0x0, .msr_values = {0x00}},
      R"(Total Core C State Transition Cycles)",
      R"(Number of cycles spent performing core C state transitions across all cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_pcu,
      "UNC_P_VR_HOT_CYCLES",
      EventDef::Encoding{.code = 0x42, .umask = 0x0, .msr_values = {0x00}},
      R"(VR Hot)",
      R"(VR Hot)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_EVENT_MSG.VLW_RCVD",
      EventDef::Encoding{.code = 0x42, .umask = 0x1, .msr_values = {0x00}},
      R"(Message Received; VLW)",
      R"(Virtual Logical Wire (legacy) message were received from Uncore.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_EVENT_MSG.MSI_RCVD",
      EventDef::Encoding{.code = 0x42, .umask = 0x2, .msr_values = {0x00}},
      R"(Message Received; MSI)",
      R"(Virtual Logical Wire (legacy) message were received from Uncore.; Message Signaled Interrupts - interrupts sent by devices (including PCIe via IOxAPIC) (Socket Mode only))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_EVENT_MSG.IPI_RCVD",
      EventDef::Encoding{.code = 0x42, .umask = 0x4, .msr_values = {0x00}},
      R"(Message Received; IPI)",
      R"(Virtual Logical Wire (legacy) message were received from Uncore.; Inter Processor Interrupts)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_EVENT_MSG.DOORBELL_RCVD",
      EventDef::Encoding{.code = 0x42, .umask = 0x8, .msr_values = {0x00}},
      R"(Message Received)",
      R"(Virtual Logical Wire (legacy) message were received from Uncore.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_EVENT_MSG.INT_PRIO",
      EventDef::Encoding{.code = 0x42, .umask = 0x10, .msr_values = {0x00}},
      R"(Message Received)",
      R"(Virtual Logical Wire (legacy) message were received from Uncore.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_LOCK_CYCLES",
      EventDef::Encoding{.code = 0x44, .umask = 0x0, .msr_values = {0x00}},
      R"(IDI Lock/SplitLock Cycles)",
      R"(Number of times an IDI Lock/SplitLock sequence was started)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_PHOLD_CYCLES.ASSERT_TO_ACK",
      EventDef::Encoding{.code = 0x45, .umask = 0x1, .msr_values = {0x00}},
      R"(Cycles PHOLD Assert to Ack; Assert to ACK)",
      R"(PHOLD cycles.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_RACU_DRNG.RDRAND",
      EventDef::Encoding{.code = 0x4C, .umask = 0x1, .msr_values = {0x00}},
      R"(UNC_U_RACU_DRNG.RDRAND)",
      R"(UNC_U_RACU_DRNG.RDRAND)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_RACU_DRNG.RDSEED",
      EventDef::Encoding{.code = 0x4C, .umask = 0x2, .msr_values = {0x00}},
      R"(UNC_U_RACU_DRNG.RDSEED)",
      R"(UNC_U_RACU_DRNG.RDSEED)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_RACU_DRNG.PFTCH_BUF_EMPTY",
      EventDef::Encoding{.code = 0x4C, .umask = 0x4, .msr_values = {0x00}},
      R"(UNC_U_RACU_DRNG.PFTCH_BUF_EMPTY)",
      R"(UNC_U_RACU_DRNG.PFTCH_BUF_EMPTY)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_ubox,
      "UNC_U_RACU_REQUESTS",
      EventDef::Encoding{.code = 0x46, .umask = 0x0, .msr_values = {0x00}},
      R"(RACU Request)",
      R"(Number outstanding register requests within message channel tracker)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_ACT_COUNT.RD",
      EventDef::Encoding{.code = 0x1, .umask = 0x1, .msr_values = {0x00}},
      R"(DRAM Activate Count; Activate due to Read)",
      R"(Counts the number of DRAM Activate commands sent on this channel.  Activate commands are issued to open up a page on the DRAM devices so that it can be read or written to with a CAS.  One can calculate the number of Page Misses by subtracting the number of Page Miss precharges from the number of Activates.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_ACT_COUNT.BYP",
      EventDef::Encoding{.code = 0x1, .umask = 0x8, .msr_values = {0x00}},
      R"(DRAM Activate Count; Activate due to Bypass)",
      R"(Counts the number of DRAM Activate commands sent on this channel.  Activate commands are issued to open up a page on the DRAM devices so that it can be read or written to with a CAS.  One can calculate the number of Page Misses by subtracting the number of Page Miss precharges from the number of Activates.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_BYP_CMDS.ACT",
      EventDef::Encoding{.code = 0xA1, .umask = 0x1, .msr_values = {0x00}},
      R"(ACT command issued by 2 cycle bypass)",
      R"(ACT command issued by 2 cycle bypass)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_BYP_CMDS.CAS",
      EventDef::Encoding{.code = 0xA1, .umask = 0x2, .msr_values = {0x00}},
      R"(CAS command issued by 2 cycle bypass)",
      R"(CAS command issued by 2 cycle bypass)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_BYP_CMDS.PRE",
      EventDef::Encoding{.code = 0xA1, .umask = 0x4, .msr_values = {0x00}},
      R"(PRE command issued by 2 cycle bypass)",
      R"(PRE command issued by 2 cycle bypass)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_CAS_COUNT.WR_RMM",
      EventDef::Encoding{.code = 0x4, .umask = 0x8, .msr_values = {0x00}},
      R"(DRAM CAS (Column Address Strobe) Commands.; DRAM WR_CAS (w/ and w/out auto-pre) in Read Major Mode)",
      R"(Counts the total number of Opportunistic DRAM Write CAS commands issued on this channel while in Read-Major-Mode.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_CAS_COUNT.RD_WMM",
      EventDef::Encoding{.code = 0x4, .umask = 0x10, .msr_values = {0x00}},
      R"(DRAM CAS (Column Address Strobe) Commands.; Read CAS issued in WMM)",
      R"(DRAM CAS (Column Address Strobe) Commands.; Read CAS issued in WMM)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_CAS_COUNT.RD_RMM",
      EventDef::Encoding{.code = 0x4, .umask = 0x20, .msr_values = {0x00}},
      R"(DRAM CAS (Column Address Strobe) Commands.; Read CAS issued in RMM)",
      R"(DRAM CAS (Column Address Strobe) Commands.; Read CAS issued in RMM)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_CAS_COUNT.RD_ISOCH",
      EventDef::Encoding{.code = 0x4, .umask = 0x40, .msr_values = {0x00}},
      R"(DRAM CAS (Column Address Strobe) Commands.; Read CAS issued in Read ISOCH Mode)",
      R"(DRAM CAS (Column Address Strobe) Commands.; Read CAS issued in Read ISOCH Mode)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_CAS_COUNT.WR_ISOCH",
      EventDef::Encoding{.code = 0x4, .umask = 0x80, .msr_values = {0x00}},
      R"(DRAM CAS (Column Address Strobe) Commands.; Read CAS issued in Write ISOCH Mode)",
      R"(DRAM CAS (Column Address Strobe) Commands.; Read CAS issued in Write ISOCH Mode)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_DRAM_PRE_ALL",
      EventDef::Encoding{.code = 0x6, .umask = 0x0, .msr_values = {0x00}},
      R"(DRAM Precharge All Commands)",
      R"(Counts the number of times that the precharge all command was sent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_DRAM_REFRESH.PANIC",
      EventDef::Encoding{.code = 0x5, .umask = 0x2, .msr_values = {0x00}},
      R"(Number of DRAM Refreshes Issued)",
      R"(Counts the number of refreshes issued.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_DRAM_REFRESH.HIGH",
      EventDef::Encoding{.code = 0x5, .umask = 0x4, .msr_values = {0x00}},
      R"(Number of DRAM Refreshes Issued)",
      R"(Counts the number of refreshes issued.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_ECC_CORRECTABLE_ERRORS",
      EventDef::Encoding{.code = 0x9, .umask = 0x0, .msr_values = {0x00}},
      R"(ECC Correctable Errors)",
      R"(Counts the number of ECC errors detected and corrected by the iMC on this channel.  This counter is only useful with ECC DRAM devices.  This count will increment one time for each correction regardless of the number of bits corrected.  The iMC can correct up to 4 bit errors in independent channel mode and 8 bit errors in lockstep mode.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_MAJOR_MODES.READ",
      EventDef::Encoding{.code = 0x7, .umask = 0x1, .msr_values = {0x00}},
      R"(Cycles in a Major Mode; Read Major Mode)",
      R"(Counts the total number of cycles spent in a major mode (selected by a filter) on the given channel.   Major modea are channel-wide, and not a per-rank (or dimm or bank) mode.; Read Major Mode is the default mode for the iMC, as reads are generally more critical to forward progress than writes.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_MAJOR_MODES.WRITE",
      EventDef::Encoding{.code = 0x7, .umask = 0x2, .msr_values = {0x00}},
      R"(Cycles in a Major Mode; Write Major Mode)",
      R"(Counts the total number of cycles spent in a major mode (selected by a filter) on the given channel.   Major modea are channel-wide, and not a per-rank (or dimm or bank) mode.; This mode is triggered when the WPQ hits high occupancy and causes writes to be higher priority than reads.  This can cause blips in the available read bandwidth in the system and temporarily increase read latencies in order to achieve better bus utilizations and higher bandwidth.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_MAJOR_MODES.PARTIAL",
      EventDef::Encoding{.code = 0x7, .umask = 0x4, .msr_values = {0x00}},
      R"(Cycles in a Major Mode; Partial Major Mode)",
      R"(Counts the total number of cycles spent in a major mode (selected by a filter) on the given channel.   Major modea are channel-wide, and not a per-rank (or dimm or bank) mode.; This major mode is used to drain starved underfill reads.  Regular reads and writes are blocked and only underfill reads will be processed.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_MAJOR_MODES.ISOCH",
      EventDef::Encoding{.code = 0x7, .umask = 0x8, .msr_values = {0x00}},
      R"(Cycles in a Major Mode; Isoch Major Mode)",
      R"(Counts the total number of cycles spent in a major mode (selected by a filter) on the given channel.   Major modea are channel-wide, and not a per-rank (or dimm or bank) mode.; We group these two modes together so that we can use four counters to track each of the major modes at one time.  These major modes are used whenever there is an ISOCH txn in the memory controller.  In these mode, only ISOCH transactions are processed.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_CHANNEL_DLLOFF",
      EventDef::Encoding{.code = 0x84, .umask = 0x0, .msr_values = {0x00}},
      R"(Channel DLLOFF Cycles)",
      R"(Number of cycles when all the ranks in the channel are in CKE Slow (DLLOFF) mode.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_CKE_CYCLES.RANK0",
      EventDef::Encoding{.code = 0x83, .umask = 0x1, .msr_values = {0x00}},
      R"(CKE_ON_CYCLES by Rank; DIMM ID)",
      R"(Number of cycles spent in CKE ON mode.  The filter allows you to select a rank to monitor.  If multiple ranks are in CKE ON mode at one time, the counter will ONLY increment by one rather than doing accumulation.  Multiple counters will need to be used to track multiple ranks simultaneously.  There is no distinction between the different CKE modes (APD, PPDS, PPDF).  This can be determined based on the system programming.  These events should commonly be used with Invert to get the number of cycles in power saving mode.  Edge Detect is also useful here.  Make sure that you do NOT use Invert with Edge Detect (this just confuses the system and is not necessary).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_CKE_CYCLES.RANK1",
      EventDef::Encoding{.code = 0x83, .umask = 0x2, .msr_values = {0x00}},
      R"(CKE_ON_CYCLES by Rank; DIMM ID)",
      R"(Number of cycles spent in CKE ON mode.  The filter allows you to select a rank to monitor.  If multiple ranks are in CKE ON mode at one time, the counter will ONLY increment by one rather than doing accumulation.  Multiple counters will need to be used to track multiple ranks simultaneously.  There is no distinction between the different CKE modes (APD, PPDS, PPDF).  This can be determined based on the system programming.  These events should commonly be used with Invert to get the number of cycles in power saving mode.  Edge Detect is also useful here.  Make sure that you do NOT use Invert with Edge Detect (this just confuses the system and is not necessary).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_CKE_CYCLES.RANK2",
      EventDef::Encoding{.code = 0x83, .umask = 0x4, .msr_values = {0x00}},
      R"(CKE_ON_CYCLES by Rank; DIMM ID)",
      R"(Number of cycles spent in CKE ON mode.  The filter allows you to select a rank to monitor.  If multiple ranks are in CKE ON mode at one time, the counter will ONLY increment by one rather than doing accumulation.  Multiple counters will need to be used to track multiple ranks simultaneously.  There is no distinction between the different CKE modes (APD, PPDS, PPDF).  This can be determined based on the system programming.  These events should commonly be used with Invert to get the number of cycles in power saving mode.  Edge Detect is also useful here.  Make sure that you do NOT use Invert with Edge Detect (this just confuses the system and is not necessary).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_CKE_CYCLES.RANK3",
      EventDef::Encoding{.code = 0x83, .umask = 0x8, .msr_values = {0x00}},
      R"(CKE_ON_CYCLES by Rank; DIMM ID)",
      R"(Number of cycles spent in CKE ON mode.  The filter allows you to select a rank to monitor.  If multiple ranks are in CKE ON mode at one time, the counter will ONLY increment by one rather than doing accumulation.  Multiple counters will need to be used to track multiple ranks simultaneously.  There is no distinction between the different CKE modes (APD, PPDS, PPDF).  This can be determined based on the system programming.  These events should commonly be used with Invert to get the number of cycles in power saving mode.  Edge Detect is also useful here.  Make sure that you do NOT use Invert with Edge Detect (this just confuses the system and is not necessary).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_CKE_CYCLES.RANK4",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .msr_values = {0x00}},
      R"(CKE_ON_CYCLES by Rank; DIMM ID)",
      R"(Number of cycles spent in CKE ON mode.  The filter allows you to select a rank to monitor.  If multiple ranks are in CKE ON mode at one time, the counter will ONLY increment by one rather than doing accumulation.  Multiple counters will need to be used to track multiple ranks simultaneously.  There is no distinction between the different CKE modes (APD, PPDS, PPDF).  This can be determined based on the system programming.  These events should commonly be used with Invert to get the number of cycles in power saving mode.  Edge Detect is also useful here.  Make sure that you do NOT use Invert with Edge Detect (this just confuses the system and is not necessary).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_CKE_CYCLES.RANK5",
      EventDef::Encoding{.code = 0x83, .umask = 0x20, .msr_values = {0x00}},
      R"(CKE_ON_CYCLES by Rank; DIMM ID)",
      R"(Number of cycles spent in CKE ON mode.  The filter allows you to select a rank to monitor.  If multiple ranks are in CKE ON mode at one time, the counter will ONLY increment by one rather than doing accumulation.  Multiple counters will need to be used to track multiple ranks simultaneously.  There is no distinction between the different CKE modes (APD, PPDS, PPDF).  This can be determined based on the system programming.  These events should commonly be used with Invert to get the number of cycles in power saving mode.  Edge Detect is also useful here.  Make sure that you do NOT use Invert with Edge Detect (this just confuses the system and is not necessary).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_CKE_CYCLES.RANK6",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .msr_values = {0x00}},
      R"(CKE_ON_CYCLES by Rank; DIMM ID)",
      R"(Number of cycles spent in CKE ON mode.  The filter allows you to select a rank to monitor.  If multiple ranks are in CKE ON mode at one time, the counter will ONLY increment by one rather than doing accumulation.  Multiple counters will need to be used to track multiple ranks simultaneously.  There is no distinction between the different CKE modes (APD, PPDS, PPDF).  This can be determined based on the system programming.  These events should commonly be used with Invert to get the number of cycles in power saving mode.  Edge Detect is also useful here.  Make sure that you do NOT use Invert with Edge Detect (this just confuses the system and is not necessary).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_CKE_CYCLES.RANK7",
      EventDef::Encoding{.code = 0x83, .umask = 0x80, .msr_values = {0x00}},
      R"(CKE_ON_CYCLES by Rank; DIMM ID)",
      R"(Number of cycles spent in CKE ON mode.  The filter allows you to select a rank to monitor.  If multiple ranks are in CKE ON mode at one time, the counter will ONLY increment by one rather than doing accumulation.  Multiple counters will need to be used to track multiple ranks simultaneously.  There is no distinction between the different CKE modes (APD, PPDS, PPDF).  This can be determined based on the system programming.  These events should commonly be used with Invert to get the number of cycles in power saving mode.  Edge Detect is also useful here.  Make sure that you do NOT use Invert with Edge Detect (this just confuses the system and is not necessary).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_CRITICAL_THROTTLE_CYCLES",
      EventDef::Encoding{.code = 0x86, .umask = 0x0, .msr_values = {0x00}},
      R"(Critical Throttle Cycles)",
      R"(Counts the number of cycles when the iMC is in critical thermal throttling.  When this happens, all traffic is blocked.  This should be rare unless something bad is going on in the platform.  There is no filtering by rank for this event.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_PCU_THROTTLING",
      EventDef::Encoding{.code = 0x42, .umask = 0x0, .msr_values = {0x00}},
      R"(UNC_M_POWER_PCU_THROTTLING)",
      R"(UNC_M_POWER_PCU_THROTTLING)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_THROTTLE_CYCLES.RANK0",
      EventDef::Encoding{.code = 0x41, .umask = 0x1, .msr_values = {0x00}},
      R"(Throttle Cycles for Rank 0; DIMM ID)",
      R"(Counts the number of cycles while the iMC is being throttled by either thermal constraints or by the PCU throttling.  It is not possible to distinguish between the two.  This can be filtered by rank.  If multiple ranks are selected and are being throttled at the same time, the counter will only increment by 1.; Thermal throttling is performed per DIMM.  We support 3 DIMMs per channel.  This ID allows us to filter by ID.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_THROTTLE_CYCLES.RANK1",
      EventDef::Encoding{.code = 0x41, .umask = 0x2, .msr_values = {0x00}},
      R"(Throttle Cycles for Rank 0; DIMM ID)",
      R"(Counts the number of cycles while the iMC is being throttled by either thermal constraints or by the PCU throttling.  It is not possible to distinguish between the two.  This can be filtered by rank.  If multiple ranks are selected and are being throttled at the same time, the counter will only increment by 1.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_THROTTLE_CYCLES.RANK2",
      EventDef::Encoding{.code = 0x41, .umask = 0x4, .msr_values = {0x00}},
      R"(Throttle Cycles for Rank 0; DIMM ID)",
      R"(Counts the number of cycles while the iMC is being throttled by either thermal constraints or by the PCU throttling.  It is not possible to distinguish between the two.  This can be filtered by rank.  If multiple ranks are selected and are being throttled at the same time, the counter will only increment by 1.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_THROTTLE_CYCLES.RANK3",
      EventDef::Encoding{.code = 0x41, .umask = 0x8, .msr_values = {0x00}},
      R"(Throttle Cycles for Rank 0; DIMM ID)",
      R"(Counts the number of cycles while the iMC is being throttled by either thermal constraints or by the PCU throttling.  It is not possible to distinguish between the two.  This can be filtered by rank.  If multiple ranks are selected and are being throttled at the same time, the counter will only increment by 1.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_THROTTLE_CYCLES.RANK4",
      EventDef::Encoding{.code = 0x41, .umask = 0x10, .msr_values = {0x00}},
      R"(Throttle Cycles for Rank 0; DIMM ID)",
      R"(Counts the number of cycles while the iMC is being throttled by either thermal constraints or by the PCU throttling.  It is not possible to distinguish between the two.  This can be filtered by rank.  If multiple ranks are selected and are being throttled at the same time, the counter will only increment by 1.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_THROTTLE_CYCLES.RANK5",
      EventDef::Encoding{.code = 0x41, .umask = 0x20, .msr_values = {0x00}},
      R"(Throttle Cycles for Rank 0; DIMM ID)",
      R"(Counts the number of cycles while the iMC is being throttled by either thermal constraints or by the PCU throttling.  It is not possible to distinguish between the two.  This can be filtered by rank.  If multiple ranks are selected and are being throttled at the same time, the counter will only increment by 1.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_THROTTLE_CYCLES.RANK6",
      EventDef::Encoding{.code = 0x41, .umask = 0x40, .msr_values = {0x00}},
      R"(Throttle Cycles for Rank 0; DIMM ID)",
      R"(Counts the number of cycles while the iMC is being throttled by either thermal constraints or by the PCU throttling.  It is not possible to distinguish between the two.  This can be filtered by rank.  If multiple ranks are selected and are being throttled at the same time, the counter will only increment by 1.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_POWER_THROTTLE_CYCLES.RANK7",
      EventDef::Encoding{.code = 0x41, .umask = 0x80, .msr_values = {0x00}},
      R"(Throttle Cycles for Rank 0; DIMM ID)",
      R"(Counts the number of cycles while the iMC is being throttled by either thermal constraints or by the PCU throttling.  It is not possible to distinguish between the two.  This can be filtered by rank.  If multiple ranks are selected and are being throttled at the same time, the counter will only increment by 1.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_PREEMPTION.RD_PREEMPT_RD",
      EventDef::Encoding{.code = 0x8, .umask = 0x1, .msr_values = {0x00}},
      R"(Read Preemption Count; Read over Read Preemption)",
      R"(Counts the number of times a read in the iMC preempts another read or write.  Generally reads to an open page are issued ahead of requests to closed pages.  This improves the page hit rate of the system.  However, high priority requests can cause pages of active requests to be closed in order to get them out.  This will reduce the latency of the high-priority request at the expense of lower bandwidth and increased overall average latency.; Filter for when a read preempts another read.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_PREEMPTION.RD_PREEMPT_WR",
      EventDef::Encoding{.code = 0x8, .umask = 0x2, .msr_values = {0x00}},
      R"(Read Preemption Count; Read over Write Preemption)",
      R"(Counts the number of times a read in the iMC preempts another read or write.  Generally reads to an open page are issued ahead of requests to closed pages.  This improves the page hit rate of the system.  However, high priority requests can cause pages of active requests to be closed in order to get them out.  This will reduce the latency of the high-priority request at the expense of lower bandwidth and increased overall average latency.; Filter for when a read preempts a write.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_PRE_COUNT.PAGE_CLOSE",
      EventDef::Encoding{.code = 0x2, .umask = 0x2, .msr_values = {0x00}},
      R"(DRAM Precharge commands.; Precharge due to timer expiration)",
      R"(Counts the number of DRAM Precharge commands sent on this channel.; Counts the number of DRAM Precharge commands sent on this channel as a result of the page close counter expiring.  This does not include implicit precharge commands sent in auto-precharge mode.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_PRE_COUNT.WR",
      EventDef::Encoding{.code = 0x2, .umask = 0x8, .msr_values = {0x00}},
      R"(DRAM Precharge commands.; Precharge due to write)",
      R"(Counts the number of DRAM Precharge commands sent on this channel.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_PRE_COUNT.BYP",
      EventDef::Encoding{.code = 0x2, .umask = 0x10, .msr_values = {0x00}},
      R"(DRAM Precharge commands.; Precharge due to bypass)",
      R"(Counts the number of DRAM Precharge commands sent on this channel.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_PRIO.LOW",
      EventDef::Encoding{.code = 0xA0, .umask = 0x1, .msr_values = {0x00}},
      R"(Read CAS issued with LOW priority)",
      R"(Read CAS issued with LOW priority)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_PRIO.MED",
      EventDef::Encoding{.code = 0xA0, .umask = 0x2, .msr_values = {0x00}},
      R"(Read CAS issued with MEDIUM priority)",
      R"(Read CAS issued with MEDIUM priority)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_PRIO.HIGH",
      EventDef::Encoding{.code = 0xA0, .umask = 0x4, .msr_values = {0x00}},
      R"(Read CAS issued with HIGH priority)",
      R"(Read CAS issued with HIGH priority)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_PRIO.PANIC",
      EventDef::Encoding{.code = 0xA0, .umask = 0x8, .msr_values = {0x00}},
      R"(Read CAS issued with PANIC NON ISOCH priority (starved))",
      R"(Read CAS issued with PANIC NON ISOCH priority (starved))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK0.BANK0",
      EventDef::Encoding{.code = 0xB0, .umask = 0x0, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 0; Bank 0)",
      R"(RD_CAS Access to Rank 0; Bank 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK0.BANK1",
      EventDef::Encoding{.code = 0xB0, .umask = 0x1, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 0; Bank 1)",
      R"(RD_CAS Access to Rank 0; Bank 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK0.BANK2",
      EventDef::Encoding{.code = 0xB0, .umask = 0x2, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 0; Bank 2)",
      R"(RD_CAS Access to Rank 0; Bank 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK0.BANK3",
      EventDef::Encoding{.code = 0xB0, .umask = 0x3, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 0; Bank 3)",
      R"(RD_CAS Access to Rank 0; Bank 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK0.BANK4",
      EventDef::Encoding{.code = 0xB0, .umask = 0x4, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 0; Bank 4)",
      R"(RD_CAS Access to Rank 0; Bank 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK0.BANK5",
      EventDef::Encoding{.code = 0xB0, .umask = 0x5, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 0; Bank 5)",
      R"(RD_CAS Access to Rank 0; Bank 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK0.BANK6",
      EventDef::Encoding{.code = 0xB0, .umask = 0x6, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 0; Bank 6)",
      R"(RD_CAS Access to Rank 0; Bank 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK0.BANK7",
      EventDef::Encoding{.code = 0xB0, .umask = 0x7, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 0; Bank 7)",
      R"(RD_CAS Access to Rank 0; Bank 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK0.BANK8",
      EventDef::Encoding{.code = 0xB0, .umask = 0x8, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 0; Bank 8)",
      R"(RD_CAS Access to Rank 0; Bank 8)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK0.BANK9",
      EventDef::Encoding{.code = 0xB0, .umask = 0x9, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 0; Bank 9)",
      R"(RD_CAS Access to Rank 0; Bank 9)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK0.BANK10",
      EventDef::Encoding{.code = 0xB0, .umask = 0xA, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 0; Bank 10)",
      R"(RD_CAS Access to Rank 0; Bank 10)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK0.BANK11",
      EventDef::Encoding{.code = 0xB0, .umask = 0xB, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 0; Bank 11)",
      R"(RD_CAS Access to Rank 0; Bank 11)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK0.BANK12",
      EventDef::Encoding{.code = 0xB0, .umask = 0xC, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 0; Bank 12)",
      R"(RD_CAS Access to Rank 0; Bank 12)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK0.BANK13",
      EventDef::Encoding{.code = 0xB0, .umask = 0xD, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 0; Bank 13)",
      R"(RD_CAS Access to Rank 0; Bank 13)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK0.BANK14",
      EventDef::Encoding{.code = 0xB0, .umask = 0xE, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 0; Bank 14)",
      R"(RD_CAS Access to Rank 0; Bank 14)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK0.BANK15",
      EventDef::Encoding{.code = 0xB0, .umask = 0xF, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 0; Bank 15)",
      R"(RD_CAS Access to Rank 0; Bank 15)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK0.ALLBANKS",
      EventDef::Encoding{.code = 0xB0, .umask = 0x10, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 0; All Banks)",
      R"(RD_CAS Access to Rank 0; All Banks)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK0.BANKG0",
      EventDef::Encoding{.code = 0xB0, .umask = 0x11, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 0; Bank Group 0 (Banks 0-3))",
      R"(RD_CAS Access to Rank 0; Bank Group 0 (Banks 0-3))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK0.BANKG1",
      EventDef::Encoding{.code = 0xB0, .umask = 0x12, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 0; Bank Group 1 (Banks 4-7))",
      R"(RD_CAS Access to Rank 0; Bank Group 1 (Banks 4-7))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK0.BANKG2",
      EventDef::Encoding{.code = 0xB0, .umask = 0x13, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 0; Bank Group 2 (Banks 8-11))",
      R"(RD_CAS Access to Rank 0; Bank Group 2 (Banks 8-11))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK0.BANKG3",
      EventDef::Encoding{.code = 0xB0, .umask = 0x14, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 0; Bank Group 3 (Banks 12-15))",
      R"(RD_CAS Access to Rank 0; Bank Group 3 (Banks 12-15))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK1.BANK0",
      EventDef::Encoding{.code = 0xB1, .umask = 0x0, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 1; Bank 0)",
      R"(RD_CAS Access to Rank 1; Bank 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK1.BANK1",
      EventDef::Encoding{.code = 0xB1, .umask = 0x1, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 1; Bank 1)",
      R"(RD_CAS Access to Rank 1; Bank 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK1.BANK2",
      EventDef::Encoding{.code = 0xB1, .umask = 0x2, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 1; Bank 2)",
      R"(RD_CAS Access to Rank 1; Bank 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK1.BANK3",
      EventDef::Encoding{.code = 0xB1, .umask = 0x3, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 1; Bank 3)",
      R"(RD_CAS Access to Rank 1; Bank 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK1.BANK4",
      EventDef::Encoding{.code = 0xB1, .umask = 0x4, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 1; Bank 4)",
      R"(RD_CAS Access to Rank 1; Bank 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK1.BANK5",
      EventDef::Encoding{.code = 0xB1, .umask = 0x5, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 1; Bank 5)",
      R"(RD_CAS Access to Rank 1; Bank 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK1.BANK6",
      EventDef::Encoding{.code = 0xB1, .umask = 0x6, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 1; Bank 6)",
      R"(RD_CAS Access to Rank 1; Bank 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK1.BANK7",
      EventDef::Encoding{.code = 0xB1, .umask = 0x7, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 1; Bank 7)",
      R"(RD_CAS Access to Rank 1; Bank 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK1.BANK8",
      EventDef::Encoding{.code = 0xB1, .umask = 0x8, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 1; Bank 8)",
      R"(RD_CAS Access to Rank 1; Bank 8)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK1.BANK9",
      EventDef::Encoding{.code = 0xB1, .umask = 0x9, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 1; Bank 9)",
      R"(RD_CAS Access to Rank 1; Bank 9)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK1.BANK10",
      EventDef::Encoding{.code = 0xB1, .umask = 0xA, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 1; Bank 10)",
      R"(RD_CAS Access to Rank 1; Bank 10)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK1.BANK11",
      EventDef::Encoding{.code = 0xB1, .umask = 0xB, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 1; Bank 11)",
      R"(RD_CAS Access to Rank 1; Bank 11)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK1.BANK12",
      EventDef::Encoding{.code = 0xB1, .umask = 0xC, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 1; Bank 12)",
      R"(RD_CAS Access to Rank 1; Bank 12)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK1.BANK13",
      EventDef::Encoding{.code = 0xB1, .umask = 0xD, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 1; Bank 13)",
      R"(RD_CAS Access to Rank 1; Bank 13)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK1.BANK14",
      EventDef::Encoding{.code = 0xB1, .umask = 0xE, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 1; Bank 14)",
      R"(RD_CAS Access to Rank 1; Bank 14)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK1.BANK15",
      EventDef::Encoding{.code = 0xB1, .umask = 0xF, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 1; Bank 15)",
      R"(RD_CAS Access to Rank 1; Bank 15)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK1.ALLBANKS",
      EventDef::Encoding{.code = 0xB1, .umask = 0x10, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 1; All Banks)",
      R"(RD_CAS Access to Rank 1; All Banks)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK1.BANKG0",
      EventDef::Encoding{.code = 0xB1, .umask = 0x11, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 1; Bank Group 0 (Banks 0-3))",
      R"(RD_CAS Access to Rank 1; Bank Group 0 (Banks 0-3))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK1.BANKG1",
      EventDef::Encoding{.code = 0xB1, .umask = 0x12, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 1; Bank Group 1 (Banks 4-7))",
      R"(RD_CAS Access to Rank 1; Bank Group 1 (Banks 4-7))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK1.BANKG2",
      EventDef::Encoding{.code = 0xB1, .umask = 0x13, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 1; Bank Group 2 (Banks 8-11))",
      R"(RD_CAS Access to Rank 1; Bank Group 2 (Banks 8-11))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK1.BANKG3",
      EventDef::Encoding{.code = 0xB1, .umask = 0x14, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 1; Bank Group 3 (Banks 12-15))",
      R"(RD_CAS Access to Rank 1; Bank Group 3 (Banks 12-15))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK2.BANK0",
      EventDef::Encoding{.code = 0xB2, .umask = 0x0, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 2; Bank 0)",
      R"(RD_CAS Access to Rank 2; Bank 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK2.BANK1",
      EventDef::Encoding{.code = 0xB2, .umask = 0x1, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 2; Bank 1)",
      R"(RD_CAS Access to Rank 2; Bank 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK2.BANK2",
      EventDef::Encoding{.code = 0xB2, .umask = 0x2, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 2; Bank 2)",
      R"(RD_CAS Access to Rank 2; Bank 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK2.BANK3",
      EventDef::Encoding{.code = 0xB2, .umask = 0x3, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 2; Bank 3)",
      R"(RD_CAS Access to Rank 2; Bank 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK2.BANK4",
      EventDef::Encoding{.code = 0xB2, .umask = 0x4, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 2; Bank 4)",
      R"(RD_CAS Access to Rank 2; Bank 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK2.BANK5",
      EventDef::Encoding{.code = 0xB2, .umask = 0x5, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 2; Bank 5)",
      R"(RD_CAS Access to Rank 2; Bank 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK2.BANK6",
      EventDef::Encoding{.code = 0xB2, .umask = 0x6, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 2; Bank 6)",
      R"(RD_CAS Access to Rank 2; Bank 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK2.BANK7",
      EventDef::Encoding{.code = 0xB2, .umask = 0x7, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 2; Bank 7)",
      R"(RD_CAS Access to Rank 2; Bank 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK2.BANK8",
      EventDef::Encoding{.code = 0xB2, .umask = 0x8, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 2; Bank 8)",
      R"(RD_CAS Access to Rank 2; Bank 8)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK2.BANK9",
      EventDef::Encoding{.code = 0xB2, .umask = 0x9, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 2; Bank 9)",
      R"(RD_CAS Access to Rank 2; Bank 9)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK2.BANK10",
      EventDef::Encoding{.code = 0xB2, .umask = 0xA, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 2; Bank 10)",
      R"(RD_CAS Access to Rank 2; Bank 10)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK2.BANK11",
      EventDef::Encoding{.code = 0xB2, .umask = 0xB, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 2; Bank 11)",
      R"(RD_CAS Access to Rank 2; Bank 11)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK2.BANK12",
      EventDef::Encoding{.code = 0xB2, .umask = 0xC, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 2; Bank 12)",
      R"(RD_CAS Access to Rank 2; Bank 12)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK2.BANK13",
      EventDef::Encoding{.code = 0xB2, .umask = 0xD, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 2; Bank 13)",
      R"(RD_CAS Access to Rank 2; Bank 13)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK2.BANK14",
      EventDef::Encoding{.code = 0xB2, .umask = 0xE, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 2; Bank 14)",
      R"(RD_CAS Access to Rank 2; Bank 14)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK2.BANK15",
      EventDef::Encoding{.code = 0xB2, .umask = 0xF, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 2; Bank 15)",
      R"(RD_CAS Access to Rank 2; Bank 15)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK2.ALLBANKS",
      EventDef::Encoding{.code = 0xB2, .umask = 0x10, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 2; All Banks)",
      R"(RD_CAS Access to Rank 2; All Banks)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK2.BANKG0",
      EventDef::Encoding{.code = 0xB2, .umask = 0x11, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 2; Bank Group 0 (Banks 0-3))",
      R"(RD_CAS Access to Rank 2; Bank Group 0 (Banks 0-3))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK2.BANKG1",
      EventDef::Encoding{.code = 0xB2, .umask = 0x12, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 2; Bank Group 1 (Banks 4-7))",
      R"(RD_CAS Access to Rank 2; Bank Group 1 (Banks 4-7))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK2.BANKG2",
      EventDef::Encoding{.code = 0xB2, .umask = 0x13, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 2; Bank Group 2 (Banks 8-11))",
      R"(RD_CAS Access to Rank 2; Bank Group 2 (Banks 8-11))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK2.BANKG3",
      EventDef::Encoding{.code = 0xB2, .umask = 0x14, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 2; Bank Group 3 (Banks 12-15))",
      R"(RD_CAS Access to Rank 2; Bank Group 3 (Banks 12-15))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK3.BANK0",
      EventDef::Encoding{.code = 0xB3, .umask = 0x0, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 3; Bank 0)",
      R"(RD_CAS Access to Rank 3; Bank 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK3.BANK1",
      EventDef::Encoding{.code = 0xB3, .umask = 0x1, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 3; Bank 1)",
      R"(RD_CAS Access to Rank 3; Bank 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK3.BANK2",
      EventDef::Encoding{.code = 0xB3, .umask = 0x2, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 3; Bank 2)",
      R"(RD_CAS Access to Rank 3; Bank 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK3.BANK3",
      EventDef::Encoding{.code = 0xB3, .umask = 0x3, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 3; Bank 3)",
      R"(RD_CAS Access to Rank 3; Bank 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK3.BANK4",
      EventDef::Encoding{.code = 0xB3, .umask = 0x4, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 3; Bank 4)",
      R"(RD_CAS Access to Rank 3; Bank 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK3.BANK5",
      EventDef::Encoding{.code = 0xB3, .umask = 0x5, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 3; Bank 5)",
      R"(RD_CAS Access to Rank 3; Bank 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK3.BANK6",
      EventDef::Encoding{.code = 0xB3, .umask = 0x6, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 3; Bank 6)",
      R"(RD_CAS Access to Rank 3; Bank 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK3.BANK7",
      EventDef::Encoding{.code = 0xB3, .umask = 0x7, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 3; Bank 7)",
      R"(RD_CAS Access to Rank 3; Bank 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK3.BANK8",
      EventDef::Encoding{.code = 0xB3, .umask = 0x8, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 3; Bank 8)",
      R"(RD_CAS Access to Rank 3; Bank 8)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK3.BANK9",
      EventDef::Encoding{.code = 0xB3, .umask = 0x9, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 3; Bank 9)",
      R"(RD_CAS Access to Rank 3; Bank 9)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK3.BANK10",
      EventDef::Encoding{.code = 0xB3, .umask = 0xA, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 3; Bank 10)",
      R"(RD_CAS Access to Rank 3; Bank 10)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK3.BANK11",
      EventDef::Encoding{.code = 0xB3, .umask = 0xB, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 3; Bank 11)",
      R"(RD_CAS Access to Rank 3; Bank 11)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK3.BANK12",
      EventDef::Encoding{.code = 0xB3, .umask = 0xC, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 3; Bank 12)",
      R"(RD_CAS Access to Rank 3; Bank 12)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK3.BANK13",
      EventDef::Encoding{.code = 0xB3, .umask = 0xD, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 3; Bank 13)",
      R"(RD_CAS Access to Rank 3; Bank 13)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK3.BANK14",
      EventDef::Encoding{.code = 0xB3, .umask = 0xE, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 3; Bank 14)",
      R"(RD_CAS Access to Rank 3; Bank 14)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK3.BANK15",
      EventDef::Encoding{.code = 0xB3, .umask = 0xF, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 3; Bank 15)",
      R"(RD_CAS Access to Rank 3; Bank 15)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK3.ALLBANKS",
      EventDef::Encoding{.code = 0xB3, .umask = 0x10, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 3; All Banks)",
      R"(RD_CAS Access to Rank 3; All Banks)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK3.BANKG0",
      EventDef::Encoding{.code = 0xB3, .umask = 0x11, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 3; Bank Group 0 (Banks 0-3))",
      R"(RD_CAS Access to Rank 3; Bank Group 0 (Banks 0-3))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK3.BANKG1",
      EventDef::Encoding{.code = 0xB3, .umask = 0x12, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 3; Bank Group 1 (Banks 4-7))",
      R"(RD_CAS Access to Rank 3; Bank Group 1 (Banks 4-7))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK3.BANKG2",
      EventDef::Encoding{.code = 0xB3, .umask = 0x13, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 3; Bank Group 2 (Banks 8-11))",
      R"(RD_CAS Access to Rank 3; Bank Group 2 (Banks 8-11))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK3.BANKG3",
      EventDef::Encoding{.code = 0xB3, .umask = 0x14, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 3; Bank Group 3 (Banks 12-15))",
      R"(RD_CAS Access to Rank 3; Bank Group 3 (Banks 12-15))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK4.BANK0",
      EventDef::Encoding{.code = 0xB4, .umask = 0x0, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 4; Bank 0)",
      R"(RD_CAS Access to Rank 4; Bank 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK4.BANK1",
      EventDef::Encoding{.code = 0xB4, .umask = 0x1, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 4; Bank 1)",
      R"(RD_CAS Access to Rank 4; Bank 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK4.BANK2",
      EventDef::Encoding{.code = 0xB4, .umask = 0x2, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 4; Bank 2)",
      R"(RD_CAS Access to Rank 4; Bank 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK4.BANK3",
      EventDef::Encoding{.code = 0xB4, .umask = 0x3, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 4; Bank 3)",
      R"(RD_CAS Access to Rank 4; Bank 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK4.BANK4",
      EventDef::Encoding{.code = 0xB4, .umask = 0x4, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 4; Bank 4)",
      R"(RD_CAS Access to Rank 4; Bank 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK4.BANK5",
      EventDef::Encoding{.code = 0xB4, .umask = 0x5, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 4; Bank 5)",
      R"(RD_CAS Access to Rank 4; Bank 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK4.BANK6",
      EventDef::Encoding{.code = 0xB4, .umask = 0x6, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 4; Bank 6)",
      R"(RD_CAS Access to Rank 4; Bank 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK4.BANK7",
      EventDef::Encoding{.code = 0xB4, .umask = 0x7, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 4; Bank 7)",
      R"(RD_CAS Access to Rank 4; Bank 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK4.BANK8",
      EventDef::Encoding{.code = 0xB4, .umask = 0x8, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 4; Bank 8)",
      R"(RD_CAS Access to Rank 4; Bank 8)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK4.BANK9",
      EventDef::Encoding{.code = 0xB4, .umask = 0x9, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 4; Bank 9)",
      R"(RD_CAS Access to Rank 4; Bank 9)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK4.BANK10",
      EventDef::Encoding{.code = 0xB4, .umask = 0xA, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 4; Bank 10)",
      R"(RD_CAS Access to Rank 4; Bank 10)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK4.BANK11",
      EventDef::Encoding{.code = 0xB4, .umask = 0xB, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 4; Bank 11)",
      R"(RD_CAS Access to Rank 4; Bank 11)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK4.BANK12",
      EventDef::Encoding{.code = 0xB4, .umask = 0xC, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 4; Bank 12)",
      R"(RD_CAS Access to Rank 4; Bank 12)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK4.BANK13",
      EventDef::Encoding{.code = 0xB4, .umask = 0xD, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 4; Bank 13)",
      R"(RD_CAS Access to Rank 4; Bank 13)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK4.BANK14",
      EventDef::Encoding{.code = 0xB4, .umask = 0xE, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 4; Bank 14)",
      R"(RD_CAS Access to Rank 4; Bank 14)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK4.BANK15",
      EventDef::Encoding{.code = 0xB4, .umask = 0xF, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 4; Bank 15)",
      R"(RD_CAS Access to Rank 4; Bank 15)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK4.ALLBANKS",
      EventDef::Encoding{.code = 0xB4, .umask = 0x10, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 4; All Banks)",
      R"(RD_CAS Access to Rank 4; All Banks)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK4.BANKG0",
      EventDef::Encoding{.code = 0xB4, .umask = 0x11, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 4; Bank Group 0 (Banks 0-3))",
      R"(RD_CAS Access to Rank 4; Bank Group 0 (Banks 0-3))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK4.BANKG1",
      EventDef::Encoding{.code = 0xB4, .umask = 0x12, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 4; Bank Group 1 (Banks 4-7))",
      R"(RD_CAS Access to Rank 4; Bank Group 1 (Banks 4-7))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK4.BANKG2",
      EventDef::Encoding{.code = 0xB4, .umask = 0x13, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 4; Bank Group 2 (Banks 8-11))",
      R"(RD_CAS Access to Rank 4; Bank Group 2 (Banks 8-11))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK4.BANKG3",
      EventDef::Encoding{.code = 0xB4, .umask = 0x14, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 4; Bank Group 3 (Banks 12-15))",
      R"(RD_CAS Access to Rank 4; Bank Group 3 (Banks 12-15))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK5.BANK0",
      EventDef::Encoding{.code = 0xB5, .umask = 0x0, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 5; Bank 0)",
      R"(RD_CAS Access to Rank 5; Bank 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK5.BANK1",
      EventDef::Encoding{.code = 0xB5, .umask = 0x1, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 5; Bank 1)",
      R"(RD_CAS Access to Rank 5; Bank 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK5.BANK2",
      EventDef::Encoding{.code = 0xB5, .umask = 0x2, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 5; Bank 2)",
      R"(RD_CAS Access to Rank 5; Bank 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK5.BANK3",
      EventDef::Encoding{.code = 0xB5, .umask = 0x3, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 5; Bank 3)",
      R"(RD_CAS Access to Rank 5; Bank 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK5.BANK4",
      EventDef::Encoding{.code = 0xB5, .umask = 0x4, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 5; Bank 4)",
      R"(RD_CAS Access to Rank 5; Bank 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK5.BANK5",
      EventDef::Encoding{.code = 0xB5, .umask = 0x5, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 5; Bank 5)",
      R"(RD_CAS Access to Rank 5; Bank 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK5.BANK6",
      EventDef::Encoding{.code = 0xB5, .umask = 0x6, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 5; Bank 6)",
      R"(RD_CAS Access to Rank 5; Bank 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK5.BANK7",
      EventDef::Encoding{.code = 0xB5, .umask = 0x7, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 5; Bank 7)",
      R"(RD_CAS Access to Rank 5; Bank 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK5.BANK8",
      EventDef::Encoding{.code = 0xB5, .umask = 0x8, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 5; Bank 8)",
      R"(RD_CAS Access to Rank 5; Bank 8)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK5.BANK9",
      EventDef::Encoding{.code = 0xB5, .umask = 0x9, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 5; Bank 9)",
      R"(RD_CAS Access to Rank 5; Bank 9)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK5.BANK10",
      EventDef::Encoding{.code = 0xB5, .umask = 0xA, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 5; Bank 10)",
      R"(RD_CAS Access to Rank 5; Bank 10)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK5.BANK11",
      EventDef::Encoding{.code = 0xB5, .umask = 0xB, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 5; Bank 11)",
      R"(RD_CAS Access to Rank 5; Bank 11)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK5.BANK12",
      EventDef::Encoding{.code = 0xB5, .umask = 0xC, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 5; Bank 12)",
      R"(RD_CAS Access to Rank 5; Bank 12)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK5.BANK13",
      EventDef::Encoding{.code = 0xB5, .umask = 0xD, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 5; Bank 13)",
      R"(RD_CAS Access to Rank 5; Bank 13)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK5.BANK14",
      EventDef::Encoding{.code = 0xB5, .umask = 0xE, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 5; Bank 14)",
      R"(RD_CAS Access to Rank 5; Bank 14)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK5.BANK15",
      EventDef::Encoding{.code = 0xB5, .umask = 0xF, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 5; Bank 15)",
      R"(RD_CAS Access to Rank 5; Bank 15)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK5.ALLBANKS",
      EventDef::Encoding{.code = 0xB5, .umask = 0x10, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 5; All Banks)",
      R"(RD_CAS Access to Rank 5; All Banks)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK5.BANKG0",
      EventDef::Encoding{.code = 0xB5, .umask = 0x11, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 5; Bank Group 0 (Banks 0-3))",
      R"(RD_CAS Access to Rank 5; Bank Group 0 (Banks 0-3))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK5.BANKG1",
      EventDef::Encoding{.code = 0xB5, .umask = 0x12, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 5; Bank Group 1 (Banks 4-7))",
      R"(RD_CAS Access to Rank 5; Bank Group 1 (Banks 4-7))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK5.BANKG2",
      EventDef::Encoding{.code = 0xB5, .umask = 0x13, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 5; Bank Group 2 (Banks 8-11))",
      R"(RD_CAS Access to Rank 5; Bank Group 2 (Banks 8-11))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK5.BANKG3",
      EventDef::Encoding{.code = 0xB5, .umask = 0x14, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 5; Bank Group 3 (Banks 12-15))",
      R"(RD_CAS Access to Rank 5; Bank Group 3 (Banks 12-15))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK6.BANK0",
      EventDef::Encoding{.code = 0xB6, .umask = 0x0, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 6; Bank 0)",
      R"(RD_CAS Access to Rank 6; Bank 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK6.BANK1",
      EventDef::Encoding{.code = 0xB6, .umask = 0x1, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 6; Bank 1)",
      R"(RD_CAS Access to Rank 6; Bank 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK6.BANK2",
      EventDef::Encoding{.code = 0xB6, .umask = 0x2, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 6; Bank 2)",
      R"(RD_CAS Access to Rank 6; Bank 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK6.BANK3",
      EventDef::Encoding{.code = 0xB6, .umask = 0x3, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 6; Bank 3)",
      R"(RD_CAS Access to Rank 6; Bank 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK6.BANK4",
      EventDef::Encoding{.code = 0xB6, .umask = 0x4, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 6; Bank 4)",
      R"(RD_CAS Access to Rank 6; Bank 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK6.BANK5",
      EventDef::Encoding{.code = 0xB6, .umask = 0x5, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 6; Bank 5)",
      R"(RD_CAS Access to Rank 6; Bank 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK6.BANK6",
      EventDef::Encoding{.code = 0xB6, .umask = 0x6, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 6; Bank 6)",
      R"(RD_CAS Access to Rank 6; Bank 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK6.BANK7",
      EventDef::Encoding{.code = 0xB6, .umask = 0x7, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 6; Bank 7)",
      R"(RD_CAS Access to Rank 6; Bank 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK6.BANK8",
      EventDef::Encoding{.code = 0xB6, .umask = 0x8, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 6; Bank 8)",
      R"(RD_CAS Access to Rank 6; Bank 8)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK6.BANK9",
      EventDef::Encoding{.code = 0xB6, .umask = 0x9, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 6; Bank 9)",
      R"(RD_CAS Access to Rank 6; Bank 9)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK6.BANK10",
      EventDef::Encoding{.code = 0xB6, .umask = 0xA, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 6; Bank 10)",
      R"(RD_CAS Access to Rank 6; Bank 10)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK6.BANK11",
      EventDef::Encoding{.code = 0xB6, .umask = 0xB, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 6; Bank 11)",
      R"(RD_CAS Access to Rank 6; Bank 11)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK6.BANK12",
      EventDef::Encoding{.code = 0xB6, .umask = 0xC, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 6; Bank 12)",
      R"(RD_CAS Access to Rank 6; Bank 12)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK6.BANK13",
      EventDef::Encoding{.code = 0xB6, .umask = 0xD, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 6; Bank 13)",
      R"(RD_CAS Access to Rank 6; Bank 13)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK6.BANK14",
      EventDef::Encoding{.code = 0xB6, .umask = 0xE, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 6; Bank 14)",
      R"(RD_CAS Access to Rank 6; Bank 14)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK6.BANK15",
      EventDef::Encoding{.code = 0xB6, .umask = 0xF, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 6; Bank 15)",
      R"(RD_CAS Access to Rank 6; Bank 15)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK6.ALLBANKS",
      EventDef::Encoding{.code = 0xB6, .umask = 0x10, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 6; All Banks)",
      R"(RD_CAS Access to Rank 6; All Banks)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK6.BANKG0",
      EventDef::Encoding{.code = 0xB6, .umask = 0x11, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 6; Bank Group 0 (Banks 0-3))",
      R"(RD_CAS Access to Rank 6; Bank Group 0 (Banks 0-3))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK6.BANKG1",
      EventDef::Encoding{.code = 0xB6, .umask = 0x12, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 6; Bank Group 1 (Banks 4-7))",
      R"(RD_CAS Access to Rank 6; Bank Group 1 (Banks 4-7))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK6.BANKG2",
      EventDef::Encoding{.code = 0xB6, .umask = 0x13, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 6; Bank Group 2 (Banks 8-11))",
      R"(RD_CAS Access to Rank 6; Bank Group 2 (Banks 8-11))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK6.BANKG3",
      EventDef::Encoding{.code = 0xB6, .umask = 0x14, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 6; Bank Group 3 (Banks 12-15))",
      R"(RD_CAS Access to Rank 6; Bank Group 3 (Banks 12-15))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK7.BANK0",
      EventDef::Encoding{.code = 0xB7, .umask = 0x0, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 7; Bank 0)",
      R"(RD_CAS Access to Rank 7; Bank 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK7.BANK1",
      EventDef::Encoding{.code = 0xB7, .umask = 0x1, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 7; Bank 1)",
      R"(RD_CAS Access to Rank 7; Bank 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK7.BANK2",
      EventDef::Encoding{.code = 0xB7, .umask = 0x2, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 7; Bank 2)",
      R"(RD_CAS Access to Rank 7; Bank 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK7.BANK3",
      EventDef::Encoding{.code = 0xB7, .umask = 0x3, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 7; Bank 3)",
      R"(RD_CAS Access to Rank 7; Bank 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK7.BANK4",
      EventDef::Encoding{.code = 0xB7, .umask = 0x4, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 7; Bank 4)",
      R"(RD_CAS Access to Rank 7; Bank 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK7.BANK5",
      EventDef::Encoding{.code = 0xB7, .umask = 0x5, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 7; Bank 5)",
      R"(RD_CAS Access to Rank 7; Bank 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK7.BANK6",
      EventDef::Encoding{.code = 0xB7, .umask = 0x6, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 7; Bank 6)",
      R"(RD_CAS Access to Rank 7; Bank 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK7.BANK7",
      EventDef::Encoding{.code = 0xB7, .umask = 0x7, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 7; Bank 7)",
      R"(RD_CAS Access to Rank 7; Bank 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK7.BANK8",
      EventDef::Encoding{.code = 0xB7, .umask = 0x8, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 7; Bank 8)",
      R"(RD_CAS Access to Rank 7; Bank 8)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK7.BANK9",
      EventDef::Encoding{.code = 0xB7, .umask = 0x9, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 7; Bank 9)",
      R"(RD_CAS Access to Rank 7; Bank 9)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK7.BANK10",
      EventDef::Encoding{.code = 0xB7, .umask = 0xA, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 7; Bank 10)",
      R"(RD_CAS Access to Rank 7; Bank 10)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK7.BANK11",
      EventDef::Encoding{.code = 0xB7, .umask = 0xB, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 7; Bank 11)",
      R"(RD_CAS Access to Rank 7; Bank 11)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK7.BANK12",
      EventDef::Encoding{.code = 0xB7, .umask = 0xC, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 7; Bank 12)",
      R"(RD_CAS Access to Rank 7; Bank 12)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK7.BANK13",
      EventDef::Encoding{.code = 0xB7, .umask = 0xD, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 7; Bank 13)",
      R"(RD_CAS Access to Rank 7; Bank 13)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK7.BANK14",
      EventDef::Encoding{.code = 0xB7, .umask = 0xE, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 7; Bank 14)",
      R"(RD_CAS Access to Rank 7; Bank 14)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK7.BANK15",
      EventDef::Encoding{.code = 0xB7, .umask = 0xF, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 7; Bank 15)",
      R"(RD_CAS Access to Rank 7; Bank 15)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK7.ALLBANKS",
      EventDef::Encoding{.code = 0xB7, .umask = 0x10, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 7; All Banks)",
      R"(RD_CAS Access to Rank 7; All Banks)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK7.BANKG0",
      EventDef::Encoding{.code = 0xB7, .umask = 0x11, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 7; Bank Group 0 (Banks 0-3))",
      R"(RD_CAS Access to Rank 7; Bank Group 0 (Banks 0-3))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK7.BANKG1",
      EventDef::Encoding{.code = 0xB7, .umask = 0x12, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 7; Bank Group 1 (Banks 4-7))",
      R"(RD_CAS Access to Rank 7; Bank Group 1 (Banks 4-7))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK7.BANKG2",
      EventDef::Encoding{.code = 0xB7, .umask = 0x13, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 7; Bank Group 2 (Banks 8-11))",
      R"(RD_CAS Access to Rank 7; Bank Group 2 (Banks 8-11))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RD_CAS_RANK7.BANKG3",
      EventDef::Encoding{.code = 0xB7, .umask = 0x14, .msr_values = {0x00}},
      R"(RD_CAS Access to Rank 7; Bank Group 3 (Banks 12-15))",
      R"(RD_CAS Access to Rank 7; Bank Group 3 (Banks 12-15))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RPQ_CYCLES_FULL",
      EventDef::Encoding{.code = 0x12, .umask = 0x0, .msr_values = {0x00}},
      R"(Read Pending Queue Full Cycles)",
      R"(Counts the number of cycles when the Read Pending Queue is full.  When the RPQ is full, the HA will not be able to issue any additional read requests into the iMC.  This count should be similar count in the HA which tracks the number of cycles that the HA has no RPQ credits, just somewhat smaller to account for the credit return overhead.  We generally do not expect to see RPQ become full except for potentially during Write Major Mode or while running with slow DRAM.  This event only tracks non-ISOC queue entries.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_RPQ_CYCLES_NE",
      EventDef::Encoding{.code = 0x11, .umask = 0x0, .msr_values = {0x00}},
      R"(Read Pending Queue Not Empty)",
      R"(Counts the number of cycles that the Read Pending Queue is not empty.  This can then be used to calculate the average occupancy (in conjunction with the Read Pending Queue Occupancy count).  The RPQ is used to schedule reads out to the memory controller and to track the requests.  Requests allocate into the RPQ soon after they enter the memory controller, and need credits for an entry in this buffer before being sent from the HA to the iMC.  They deallocate after the CAS command has been issued to memory.  This filter is to be used in conjunction with the occupancy filter so that one can correctly track the average occupancies for schedulable entries and scheduled requests.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WMM_TO_RMM.LOW_THRESH",
      EventDef::Encoding{.code = 0xC0, .umask = 0x1, .msr_values = {0x00}},
      R"(Transition from WMM to RMM because of low threshold; Transition from WMM to RMM because of starve counter)",
      R"(Transition from WMM to RMM because of low threshold; Transition from WMM to RMM because of starve counter)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WMM_TO_RMM.STARVE",
      EventDef::Encoding{.code = 0xC0, .umask = 0x2, .msr_values = {0x00}},
      R"(Transition from WMM to RMM because of low threshold)",
      R"(Transition from WMM to RMM because of low threshold)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WMM_TO_RMM.VMSE_RETRY",
      EventDef::Encoding{.code = 0xC0, .umask = 0x4, .msr_values = {0x00}},
      R"(Transition from WMM to RMM because of low threshold)",
      R"(Transition from WMM to RMM because of low threshold)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WPQ_CYCLES_FULL",
      EventDef::Encoding{.code = 0x22, .umask = 0x0, .msr_values = {0x00}},
      R"(Write Pending Queue Full Cycles)",
      R"(Counts the number of cycles when the Write Pending Queue is full.  When the WPQ is full, the HA will not be able to issue any additional write requests into the iMC.  This count should be similar count in the CHA which tracks the number of cycles that the CHA has no WPQ credits, just somewhat smaller to account for the credit return overhead.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WPQ_CYCLES_NE",
      EventDef::Encoding{.code = 0x21, .umask = 0x0, .msr_values = {0x00}},
      R"(Write Pending Queue Not Empty)",
      R"(Counts the number of cycles that the Write Pending Queue is not empty.  This can then be used to calculate the average queue occupancy (in conjunction with the WPQ Occupancy Accumulation count).  The WPQ is used to schedule write out to the memory controller and to track the writes.  Requests allocate into the WPQ soon after they enter the memory controller, and need credits for an entry in this buffer before being sent from the CHA to the iMC.  They deallocate after being issued to DRAM.  Write requests themselves are able to complete (from the perspective of the rest of the system) as soon they have posted to the iMC.  This is not to be confused with actually performing the write to DRAM.  Therefore, the average latency for this queue is actually not useful for deconstruction intermediate write latencies.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WPQ_READ_HIT",
      EventDef::Encoding{.code = 0x23, .umask = 0x0, .msr_values = {0x00}},
      R"(Write Pending Queue CAM Match)",
      R"(Counts the number of times a request hits in the WPQ (write-pending queue).  The iMC allows writes and reads to pass up other writes to different addresses.  Before a read or a write is issued, it will first CAM the WPQ to see if there is a write pending to that address.  When reads hit, they are able to directly pull their data from the WPQ instead of going to memory.  Writes that hit will overwrite the existing data.  Partial writes that hit will not need to do underfill reads and will simply update their relevant sections.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WPQ_WRITE_HIT",
      EventDef::Encoding{.code = 0x24, .umask = 0x0, .msr_values = {0x00}},
      R"(Write Pending Queue CAM Match)",
      R"(Counts the number of times a request hits in the WPQ (write-pending queue).  The iMC allows writes and reads to pass up other writes to different addresses.  Before a read or a write is issued, it will first CAM the WPQ to see if there is a write pending to that address.  When reads hit, they are able to directly pull their data from the WPQ instead of going to memory.  Writes that hit will overwrite the existing data.  Partial writes that hit will not need to do underfill reads and will simply update their relevant sections.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WRONG_MM",
      EventDef::Encoding{.code = 0xC1, .umask = 0x0, .msr_values = {0x00}},
      R"(Not getting the requested Major Mode)",
      R"(Not getting the requested Major Mode)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK0.BANK0",
      EventDef::Encoding{.code = 0xB8, .umask = 0x0, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 0; Bank 0)",
      R"(WR_CAS Access to Rank 0; Bank 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK0.BANK1",
      EventDef::Encoding{.code = 0xB8, .umask = 0x1, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 0; Bank 1)",
      R"(WR_CAS Access to Rank 0; Bank 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK0.BANK2",
      EventDef::Encoding{.code = 0xB8, .umask = 0x2, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 0; Bank 2)",
      R"(WR_CAS Access to Rank 0; Bank 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK0.BANK3",
      EventDef::Encoding{.code = 0xB8, .umask = 0x3, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 0; Bank 3)",
      R"(WR_CAS Access to Rank 0; Bank 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK0.BANK4",
      EventDef::Encoding{.code = 0xB8, .umask = 0x4, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 0; Bank 4)",
      R"(WR_CAS Access to Rank 0; Bank 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK0.BANK5",
      EventDef::Encoding{.code = 0xB8, .umask = 0x5, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 0; Bank 5)",
      R"(WR_CAS Access to Rank 0; Bank 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK0.BANK6",
      EventDef::Encoding{.code = 0xB8, .umask = 0x6, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 0; Bank 6)",
      R"(WR_CAS Access to Rank 0; Bank 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK0.BANK7",
      EventDef::Encoding{.code = 0xB8, .umask = 0x7, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 0; Bank 7)",
      R"(WR_CAS Access to Rank 0; Bank 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK0.BANK8",
      EventDef::Encoding{.code = 0xB8, .umask = 0x8, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 0; Bank 8)",
      R"(WR_CAS Access to Rank 0; Bank 8)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK0.BANK9",
      EventDef::Encoding{.code = 0xB8, .umask = 0x9, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 0; Bank 9)",
      R"(WR_CAS Access to Rank 0; Bank 9)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK0.BANK10",
      EventDef::Encoding{.code = 0xB8, .umask = 0xA, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 0; Bank 10)",
      R"(WR_CAS Access to Rank 0; Bank 10)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK0.BANK11",
      EventDef::Encoding{.code = 0xB8, .umask = 0xB, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 0; Bank 11)",
      R"(WR_CAS Access to Rank 0; Bank 11)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK0.BANK12",
      EventDef::Encoding{.code = 0xB8, .umask = 0xC, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 0; Bank 12)",
      R"(WR_CAS Access to Rank 0; Bank 12)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK0.BANK13",
      EventDef::Encoding{.code = 0xB8, .umask = 0xD, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 0; Bank 13)",
      R"(WR_CAS Access to Rank 0; Bank 13)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK0.BANK14",
      EventDef::Encoding{.code = 0xB8, .umask = 0xE, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 0; Bank 14)",
      R"(WR_CAS Access to Rank 0; Bank 14)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK0.BANK15",
      EventDef::Encoding{.code = 0xB8, .umask = 0xF, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 0; Bank 15)",
      R"(WR_CAS Access to Rank 0; Bank 15)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK0.ALLBANKS",
      EventDef::Encoding{.code = 0xB8, .umask = 0x10, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 0; All Banks)",
      R"(WR_CAS Access to Rank 0; All Banks)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK0.BANKG0",
      EventDef::Encoding{.code = 0xB8, .umask = 0x11, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 0; Bank Group 0 (Banks 0-3))",
      R"(WR_CAS Access to Rank 0; Bank Group 0 (Banks 0-3))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK0.BANKG1",
      EventDef::Encoding{.code = 0xB8, .umask = 0x12, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 0; Bank Group 1 (Banks 4-7))",
      R"(WR_CAS Access to Rank 0; Bank Group 1 (Banks 4-7))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK0.BANKG2",
      EventDef::Encoding{.code = 0xB8, .umask = 0x13, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 0; Bank Group 2 (Banks 8-11))",
      R"(WR_CAS Access to Rank 0; Bank Group 2 (Banks 8-11))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK0.BANKG3",
      EventDef::Encoding{.code = 0xB8, .umask = 0x14, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 0; Bank Group 3 (Banks 12-15))",
      R"(WR_CAS Access to Rank 0; Bank Group 3 (Banks 12-15))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK1.BANK0",
      EventDef::Encoding{.code = 0xB9, .umask = 0x0, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 1; Bank 0)",
      R"(WR_CAS Access to Rank 1; Bank 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK1.BANK1",
      EventDef::Encoding{.code = 0xB9, .umask = 0x1, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 1; Bank 1)",
      R"(WR_CAS Access to Rank 1; Bank 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK1.BANK2",
      EventDef::Encoding{.code = 0xB9, .umask = 0x2, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 1; Bank 2)",
      R"(WR_CAS Access to Rank 1; Bank 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK1.BANK3",
      EventDef::Encoding{.code = 0xB9, .umask = 0x3, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 1; Bank 3)",
      R"(WR_CAS Access to Rank 1; Bank 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK1.BANK4",
      EventDef::Encoding{.code = 0xB9, .umask = 0x4, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 1; Bank 4)",
      R"(WR_CAS Access to Rank 1; Bank 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK1.BANK5",
      EventDef::Encoding{.code = 0xB9, .umask = 0x5, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 1; Bank 5)",
      R"(WR_CAS Access to Rank 1; Bank 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK1.BANK6",
      EventDef::Encoding{.code = 0xB9, .umask = 0x6, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 1; Bank 6)",
      R"(WR_CAS Access to Rank 1; Bank 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK1.BANK7",
      EventDef::Encoding{.code = 0xB9, .umask = 0x7, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 1; Bank 7)",
      R"(WR_CAS Access to Rank 1; Bank 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK1.BANK8",
      EventDef::Encoding{.code = 0xB9, .umask = 0x8, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 1; Bank 8)",
      R"(WR_CAS Access to Rank 1; Bank 8)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK1.BANK9",
      EventDef::Encoding{.code = 0xB9, .umask = 0x9, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 1; Bank 9)",
      R"(WR_CAS Access to Rank 1; Bank 9)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK1.BANK10",
      EventDef::Encoding{.code = 0xB9, .umask = 0xA, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 1; Bank 10)",
      R"(WR_CAS Access to Rank 1; Bank 10)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK1.BANK11",
      EventDef::Encoding{.code = 0xB9, .umask = 0xB, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 1; Bank 11)",
      R"(WR_CAS Access to Rank 1; Bank 11)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK1.BANK12",
      EventDef::Encoding{.code = 0xB9, .umask = 0xC, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 1; Bank 12)",
      R"(WR_CAS Access to Rank 1; Bank 12)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK1.BANK13",
      EventDef::Encoding{.code = 0xB9, .umask = 0xD, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 1; Bank 13)",
      R"(WR_CAS Access to Rank 1; Bank 13)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK1.BANK14",
      EventDef::Encoding{.code = 0xB9, .umask = 0xE, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 1; Bank 14)",
      R"(WR_CAS Access to Rank 1; Bank 14)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK1.BANK15",
      EventDef::Encoding{.code = 0xB9, .umask = 0xF, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 1; Bank 15)",
      R"(WR_CAS Access to Rank 1; Bank 15)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK1.ALLBANKS",
      EventDef::Encoding{.code = 0xB9, .umask = 0x10, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 1; All Banks)",
      R"(WR_CAS Access to Rank 1; All Banks)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK1.BANKG0",
      EventDef::Encoding{.code = 0xB9, .umask = 0x11, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 1; Bank Group 0 (Banks 0-3))",
      R"(WR_CAS Access to Rank 1; Bank Group 0 (Banks 0-3))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK1.BANKG1",
      EventDef::Encoding{.code = 0xB9, .umask = 0x12, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 1; Bank Group 1 (Banks 4-7))",
      R"(WR_CAS Access to Rank 1; Bank Group 1 (Banks 4-7))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK1.BANKG2",
      EventDef::Encoding{.code = 0xB9, .umask = 0x13, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 1; Bank Group 2 (Banks 8-11))",
      R"(WR_CAS Access to Rank 1; Bank Group 2 (Banks 8-11))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK1.BANKG3",
      EventDef::Encoding{.code = 0xB9, .umask = 0x14, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 1; Bank Group 3 (Banks 12-15))",
      R"(WR_CAS Access to Rank 1; Bank Group 3 (Banks 12-15))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK2.BANK0",
      EventDef::Encoding{.code = 0xBA, .umask = 0x0, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 2; Bank 0)",
      R"(WR_CAS Access to Rank 2; Bank 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK2.BANK1",
      EventDef::Encoding{.code = 0xBA, .umask = 0x1, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 2; Bank 1)",
      R"(WR_CAS Access to Rank 2; Bank 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK2.BANK2",
      EventDef::Encoding{.code = 0xBA, .umask = 0x2, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 2; Bank 2)",
      R"(WR_CAS Access to Rank 2; Bank 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK2.BANK3",
      EventDef::Encoding{.code = 0xBA, .umask = 0x3, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 2; Bank 3)",
      R"(WR_CAS Access to Rank 2; Bank 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK2.BANK4",
      EventDef::Encoding{.code = 0xBA, .umask = 0x4, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 2; Bank 4)",
      R"(WR_CAS Access to Rank 2; Bank 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK2.BANK5",
      EventDef::Encoding{.code = 0xBA, .umask = 0x5, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 2; Bank 5)",
      R"(WR_CAS Access to Rank 2; Bank 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK2.BANK6",
      EventDef::Encoding{.code = 0xBA, .umask = 0x6, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 2; Bank 6)",
      R"(WR_CAS Access to Rank 2; Bank 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK2.BANK7",
      EventDef::Encoding{.code = 0xBA, .umask = 0x7, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 2; Bank 7)",
      R"(WR_CAS Access to Rank 2; Bank 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK2.BANK8",
      EventDef::Encoding{.code = 0xBA, .umask = 0x8, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 2; Bank 8)",
      R"(WR_CAS Access to Rank 2; Bank 8)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK2.BANK9",
      EventDef::Encoding{.code = 0xBA, .umask = 0x9, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 2; Bank 9)",
      R"(WR_CAS Access to Rank 2; Bank 9)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK2.BANK10",
      EventDef::Encoding{.code = 0xBA, .umask = 0xA, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 2; Bank 10)",
      R"(WR_CAS Access to Rank 2; Bank 10)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK2.BANK11",
      EventDef::Encoding{.code = 0xBA, .umask = 0xB, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 2; Bank 11)",
      R"(WR_CAS Access to Rank 2; Bank 11)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK2.BANK12",
      EventDef::Encoding{.code = 0xBA, .umask = 0xC, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 2; Bank 12)",
      R"(WR_CAS Access to Rank 2; Bank 12)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK2.BANK13",
      EventDef::Encoding{.code = 0xBA, .umask = 0xD, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 2; Bank 13)",
      R"(WR_CAS Access to Rank 2; Bank 13)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK2.BANK14",
      EventDef::Encoding{.code = 0xBA, .umask = 0xE, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 2; Bank 14)",
      R"(WR_CAS Access to Rank 2; Bank 14)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK2.BANK15",
      EventDef::Encoding{.code = 0xBA, .umask = 0xF, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 2; Bank 15)",
      R"(WR_CAS Access to Rank 2; Bank 15)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK2.ALLBANKS",
      EventDef::Encoding{.code = 0xBA, .umask = 0x10, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 2; All Banks)",
      R"(WR_CAS Access to Rank 2; All Banks)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK2.BANKG0",
      EventDef::Encoding{.code = 0xBA, .umask = 0x11, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 2; Bank Group 0 (Banks 0-3))",
      R"(WR_CAS Access to Rank 2; Bank Group 0 (Banks 0-3))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK2.BANKG1",
      EventDef::Encoding{.code = 0xBA, .umask = 0x12, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 2; Bank Group 1 (Banks 4-7))",
      R"(WR_CAS Access to Rank 2; Bank Group 1 (Banks 4-7))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK2.BANKG2",
      EventDef::Encoding{.code = 0xBA, .umask = 0x13, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 2; Bank Group 2 (Banks 8-11))",
      R"(WR_CAS Access to Rank 2; Bank Group 2 (Banks 8-11))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK2.BANKG3",
      EventDef::Encoding{.code = 0xBA, .umask = 0x14, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 2; Bank Group 3 (Banks 12-15))",
      R"(WR_CAS Access to Rank 2; Bank Group 3 (Banks 12-15))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK3.BANK0",
      EventDef::Encoding{.code = 0xBB, .umask = 0x0, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 3; Bank 0)",
      R"(WR_CAS Access to Rank 3; Bank 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK3.BANK1",
      EventDef::Encoding{.code = 0xBB, .umask = 0x1, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 3; Bank 1)",
      R"(WR_CAS Access to Rank 3; Bank 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK3.BANK2",
      EventDef::Encoding{.code = 0xBB, .umask = 0x2, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 3; Bank 2)",
      R"(WR_CAS Access to Rank 3; Bank 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK3.BANK3",
      EventDef::Encoding{.code = 0xBB, .umask = 0x3, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 3; Bank 3)",
      R"(WR_CAS Access to Rank 3; Bank 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK3.BANK4",
      EventDef::Encoding{.code = 0xBB, .umask = 0x4, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 3; Bank 4)",
      R"(WR_CAS Access to Rank 3; Bank 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK3.BANK5",
      EventDef::Encoding{.code = 0xBB, .umask = 0x5, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 3; Bank 5)",
      R"(WR_CAS Access to Rank 3; Bank 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK3.BANK6",
      EventDef::Encoding{.code = 0xBB, .umask = 0x6, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 3; Bank 6)",
      R"(WR_CAS Access to Rank 3; Bank 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK3.BANK7",
      EventDef::Encoding{.code = 0xBB, .umask = 0x7, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 3; Bank 7)",
      R"(WR_CAS Access to Rank 3; Bank 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK3.BANK8",
      EventDef::Encoding{.code = 0xBB, .umask = 0x8, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 3; Bank 8)",
      R"(WR_CAS Access to Rank 3; Bank 8)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK3.BANK9",
      EventDef::Encoding{.code = 0xBB, .umask = 0x9, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 3; Bank 9)",
      R"(WR_CAS Access to Rank 3; Bank 9)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK3.BANK10",
      EventDef::Encoding{.code = 0xBB, .umask = 0xA, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 3; Bank 10)",
      R"(WR_CAS Access to Rank 3; Bank 10)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK3.BANK11",
      EventDef::Encoding{.code = 0xBB, .umask = 0xB, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 3; Bank 11)",
      R"(WR_CAS Access to Rank 3; Bank 11)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK3.BANK12",
      EventDef::Encoding{.code = 0xBB, .umask = 0xC, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 3; Bank 12)",
      R"(WR_CAS Access to Rank 3; Bank 12)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK3.BANK13",
      EventDef::Encoding{.code = 0xBB, .umask = 0xD, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 3; Bank 13)",
      R"(WR_CAS Access to Rank 3; Bank 13)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK3.BANK14",
      EventDef::Encoding{.code = 0xBB, .umask = 0xE, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 3; Bank 14)",
      R"(WR_CAS Access to Rank 3; Bank 14)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK3.BANK15",
      EventDef::Encoding{.code = 0xBB, .umask = 0xF, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 3; Bank 15)",
      R"(WR_CAS Access to Rank 3; Bank 15)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK3.ALLBANKS",
      EventDef::Encoding{.code = 0xBB, .umask = 0x10, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 3; All Banks)",
      R"(WR_CAS Access to Rank 3; All Banks)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK3.BANKG0",
      EventDef::Encoding{.code = 0xBB, .umask = 0x11, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 3; Bank Group 0 (Banks 0-3))",
      R"(WR_CAS Access to Rank 3; Bank Group 0 (Banks 0-3))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK3.BANKG1",
      EventDef::Encoding{.code = 0xBB, .umask = 0x12, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 3; Bank Group 1 (Banks 4-7))",
      R"(WR_CAS Access to Rank 3; Bank Group 1 (Banks 4-7))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK3.BANKG2",
      EventDef::Encoding{.code = 0xBB, .umask = 0x13, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 3; Bank Group 2 (Banks 8-11))",
      R"(WR_CAS Access to Rank 3; Bank Group 2 (Banks 8-11))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK3.BANKG3",
      EventDef::Encoding{.code = 0xBB, .umask = 0x14, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 3; Bank Group 3 (Banks 12-15))",
      R"(WR_CAS Access to Rank 3; Bank Group 3 (Banks 12-15))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK4.BANK0",
      EventDef::Encoding{.code = 0xBC, .umask = 0x0, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 4; Bank 0)",
      R"(WR_CAS Access to Rank 4; Bank 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK4.BANK1",
      EventDef::Encoding{.code = 0xBC, .umask = 0x1, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 4; Bank 1)",
      R"(WR_CAS Access to Rank 4; Bank 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK4.BANK2",
      EventDef::Encoding{.code = 0xBC, .umask = 0x2, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 4; Bank 2)",
      R"(WR_CAS Access to Rank 4; Bank 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK4.BANK3",
      EventDef::Encoding{.code = 0xBC, .umask = 0x3, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 4; Bank 3)",
      R"(WR_CAS Access to Rank 4; Bank 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK4.BANK4",
      EventDef::Encoding{.code = 0xBC, .umask = 0x4, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 4; Bank 4)",
      R"(WR_CAS Access to Rank 4; Bank 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK4.BANK5",
      EventDef::Encoding{.code = 0xBC, .umask = 0x5, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 4; Bank 5)",
      R"(WR_CAS Access to Rank 4; Bank 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK4.BANK6",
      EventDef::Encoding{.code = 0xBC, .umask = 0x6, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 4; Bank 6)",
      R"(WR_CAS Access to Rank 4; Bank 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK4.BANK7",
      EventDef::Encoding{.code = 0xBC, .umask = 0x7, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 4; Bank 7)",
      R"(WR_CAS Access to Rank 4; Bank 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK4.BANK8",
      EventDef::Encoding{.code = 0xBC, .umask = 0x8, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 4; Bank 8)",
      R"(WR_CAS Access to Rank 4; Bank 8)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK4.BANK9",
      EventDef::Encoding{.code = 0xBC, .umask = 0x9, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 4; Bank 9)",
      R"(WR_CAS Access to Rank 4; Bank 9)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK4.BANK10",
      EventDef::Encoding{.code = 0xBC, .umask = 0xA, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 4; Bank 10)",
      R"(WR_CAS Access to Rank 4; Bank 10)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK4.BANK11",
      EventDef::Encoding{.code = 0xBC, .umask = 0xB, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 4; Bank 11)",
      R"(WR_CAS Access to Rank 4; Bank 11)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK4.BANK12",
      EventDef::Encoding{.code = 0xBC, .umask = 0xC, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 4; Bank 12)",
      R"(WR_CAS Access to Rank 4; Bank 12)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK4.BANK13",
      EventDef::Encoding{.code = 0xBC, .umask = 0xD, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 4; Bank 13)",
      R"(WR_CAS Access to Rank 4; Bank 13)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK4.BANK14",
      EventDef::Encoding{.code = 0xBC, .umask = 0xE, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 4; Bank 14)",
      R"(WR_CAS Access to Rank 4; Bank 14)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK4.BANK15",
      EventDef::Encoding{.code = 0xBC, .umask = 0xF, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 4; Bank 15)",
      R"(WR_CAS Access to Rank 4; Bank 15)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK4.ALLBANKS",
      EventDef::Encoding{.code = 0xBC, .umask = 0x10, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 4; All Banks)",
      R"(WR_CAS Access to Rank 4; All Banks)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK4.BANKG0",
      EventDef::Encoding{.code = 0xBC, .umask = 0x11, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 4; Bank Group 0 (Banks 0-3))",
      R"(WR_CAS Access to Rank 4; Bank Group 0 (Banks 0-3))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK4.BANKG1",
      EventDef::Encoding{.code = 0xBC, .umask = 0x12, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 4; Bank Group 1 (Banks 4-7))",
      R"(WR_CAS Access to Rank 4; Bank Group 1 (Banks 4-7))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK4.BANKG2",
      EventDef::Encoding{.code = 0xBC, .umask = 0x13, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 4; Bank Group 2 (Banks 8-11))",
      R"(WR_CAS Access to Rank 4; Bank Group 2 (Banks 8-11))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK4.BANKG3",
      EventDef::Encoding{.code = 0xBC, .umask = 0x14, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 4; Bank Group 3 (Banks 12-15))",
      R"(WR_CAS Access to Rank 4; Bank Group 3 (Banks 12-15))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK5.BANK0",
      EventDef::Encoding{.code = 0xBD, .umask = 0x0, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 5; Bank 0)",
      R"(WR_CAS Access to Rank 5; Bank 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK5.BANK1",
      EventDef::Encoding{.code = 0xBD, .umask = 0x1, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 5; Bank 1)",
      R"(WR_CAS Access to Rank 5; Bank 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK5.BANK2",
      EventDef::Encoding{.code = 0xBD, .umask = 0x2, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 5; Bank 2)",
      R"(WR_CAS Access to Rank 5; Bank 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK5.BANK3",
      EventDef::Encoding{.code = 0xBD, .umask = 0x3, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 5; Bank 3)",
      R"(WR_CAS Access to Rank 5; Bank 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK5.BANK4",
      EventDef::Encoding{.code = 0xBD, .umask = 0x4, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 5; Bank 4)",
      R"(WR_CAS Access to Rank 5; Bank 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK5.BANK5",
      EventDef::Encoding{.code = 0xBD, .umask = 0x5, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 5; Bank 5)",
      R"(WR_CAS Access to Rank 5; Bank 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK5.BANK6",
      EventDef::Encoding{.code = 0xBD, .umask = 0x6, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 5; Bank 6)",
      R"(WR_CAS Access to Rank 5; Bank 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK5.BANK7",
      EventDef::Encoding{.code = 0xBD, .umask = 0x7, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 5; Bank 7)",
      R"(WR_CAS Access to Rank 5; Bank 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK5.BANK8",
      EventDef::Encoding{.code = 0xBD, .umask = 0x8, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 5; Bank 8)",
      R"(WR_CAS Access to Rank 5; Bank 8)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK5.BANK9",
      EventDef::Encoding{.code = 0xBD, .umask = 0x9, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 5; Bank 9)",
      R"(WR_CAS Access to Rank 5; Bank 9)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK5.BANK10",
      EventDef::Encoding{.code = 0xBD, .umask = 0xA, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 5; Bank 10)",
      R"(WR_CAS Access to Rank 5; Bank 10)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK5.BANK11",
      EventDef::Encoding{.code = 0xBD, .umask = 0xB, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 5; Bank 11)",
      R"(WR_CAS Access to Rank 5; Bank 11)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK5.BANK12",
      EventDef::Encoding{.code = 0xBD, .umask = 0xC, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 5; Bank 12)",
      R"(WR_CAS Access to Rank 5; Bank 12)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK5.BANK13",
      EventDef::Encoding{.code = 0xBD, .umask = 0xD, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 5; Bank 13)",
      R"(WR_CAS Access to Rank 5; Bank 13)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK5.BANK14",
      EventDef::Encoding{.code = 0xBD, .umask = 0xE, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 5; Bank 14)",
      R"(WR_CAS Access to Rank 5; Bank 14)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK5.BANK15",
      EventDef::Encoding{.code = 0xBD, .umask = 0xF, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 5; Bank 15)",
      R"(WR_CAS Access to Rank 5; Bank 15)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK5.ALLBANKS",
      EventDef::Encoding{.code = 0xBD, .umask = 0x10, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 5; All Banks)",
      R"(WR_CAS Access to Rank 5; All Banks)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK5.BANKG0",
      EventDef::Encoding{.code = 0xBD, .umask = 0x11, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 5; Bank Group 0 (Banks 0-3))",
      R"(WR_CAS Access to Rank 5; Bank Group 0 (Banks 0-3))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK5.BANKG1",
      EventDef::Encoding{.code = 0xBD, .umask = 0x12, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 5; Bank Group 1 (Banks 4-7))",
      R"(WR_CAS Access to Rank 5; Bank Group 1 (Banks 4-7))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK5.BANKG2",
      EventDef::Encoding{.code = 0xBD, .umask = 0x13, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 5; Bank Group 2 (Banks 8-11))",
      R"(WR_CAS Access to Rank 5; Bank Group 2 (Banks 8-11))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK5.BANKG3",
      EventDef::Encoding{.code = 0xBD, .umask = 0x14, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 5; Bank Group 3 (Banks 12-15))",
      R"(WR_CAS Access to Rank 5; Bank Group 3 (Banks 12-15))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK6.BANK0",
      EventDef::Encoding{.code = 0xBE, .umask = 0x0, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 6; Bank 0)",
      R"(WR_CAS Access to Rank 6; Bank 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK6.BANK1",
      EventDef::Encoding{.code = 0xBE, .umask = 0x1, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 6; Bank 1)",
      R"(WR_CAS Access to Rank 6; Bank 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK6.BANK2",
      EventDef::Encoding{.code = 0xBE, .umask = 0x2, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 6; Bank 2)",
      R"(WR_CAS Access to Rank 6; Bank 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK6.BANK3",
      EventDef::Encoding{.code = 0xBE, .umask = 0x3, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 6; Bank 3)",
      R"(WR_CAS Access to Rank 6; Bank 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK6.BANK4",
      EventDef::Encoding{.code = 0xBE, .umask = 0x4, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 6; Bank 4)",
      R"(WR_CAS Access to Rank 6; Bank 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK6.BANK5",
      EventDef::Encoding{.code = 0xBE, .umask = 0x5, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 6; Bank 5)",
      R"(WR_CAS Access to Rank 6; Bank 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK6.BANK6",
      EventDef::Encoding{.code = 0xBE, .umask = 0x6, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 6; Bank 6)",
      R"(WR_CAS Access to Rank 6; Bank 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK6.BANK7",
      EventDef::Encoding{.code = 0xBE, .umask = 0x7, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 6; Bank 7)",
      R"(WR_CAS Access to Rank 6; Bank 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK6.BANK8",
      EventDef::Encoding{.code = 0xBE, .umask = 0x8, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 6; Bank 8)",
      R"(WR_CAS Access to Rank 6; Bank 8)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK6.BANK9",
      EventDef::Encoding{.code = 0xBE, .umask = 0x9, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 6; Bank 9)",
      R"(WR_CAS Access to Rank 6; Bank 9)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK6.BANK10",
      EventDef::Encoding{.code = 0xBE, .umask = 0xA, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 6; Bank 10)",
      R"(WR_CAS Access to Rank 6; Bank 10)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK6.BANK11",
      EventDef::Encoding{.code = 0xBE, .umask = 0xB, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 6; Bank 11)",
      R"(WR_CAS Access to Rank 6; Bank 11)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK6.BANK12",
      EventDef::Encoding{.code = 0xBE, .umask = 0xC, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 6; Bank 12)",
      R"(WR_CAS Access to Rank 6; Bank 12)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK6.BANK13",
      EventDef::Encoding{.code = 0xBE, .umask = 0xD, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 6; Bank 13)",
      R"(WR_CAS Access to Rank 6; Bank 13)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK6.BANK14",
      EventDef::Encoding{.code = 0xBE, .umask = 0xE, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 6; Bank 14)",
      R"(WR_CAS Access to Rank 6; Bank 14)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK6.BANK15",
      EventDef::Encoding{.code = 0xBE, .umask = 0xF, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 6; Bank 15)",
      R"(WR_CAS Access to Rank 6; Bank 15)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK6.ALLBANKS",
      EventDef::Encoding{.code = 0xBE, .umask = 0x10, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 6; All Banks)",
      R"(WR_CAS Access to Rank 6; All Banks)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK6.BANKG0",
      EventDef::Encoding{.code = 0xBE, .umask = 0x11, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 6; Bank Group 0 (Banks 0-3))",
      R"(WR_CAS Access to Rank 6; Bank Group 0 (Banks 0-3))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK6.BANKG1",
      EventDef::Encoding{.code = 0xBE, .umask = 0x12, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 6; Bank Group 1 (Banks 4-7))",
      R"(WR_CAS Access to Rank 6; Bank Group 1 (Banks 4-7))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK6.BANKG2",
      EventDef::Encoding{.code = 0xBE, .umask = 0x13, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 6; Bank Group 2 (Banks 8-11))",
      R"(WR_CAS Access to Rank 6; Bank Group 2 (Banks 8-11))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK6.BANKG3",
      EventDef::Encoding{.code = 0xBE, .umask = 0x14, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 6; Bank Group 3 (Banks 12-15))",
      R"(WR_CAS Access to Rank 6; Bank Group 3 (Banks 12-15))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK7.BANK0",
      EventDef::Encoding{.code = 0xBF, .umask = 0x0, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 7; Bank 0)",
      R"(WR_CAS Access to Rank 7; Bank 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK7.BANK1",
      EventDef::Encoding{.code = 0xBF, .umask = 0x1, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 7; Bank 1)",
      R"(WR_CAS Access to Rank 7; Bank 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK7.BANK2",
      EventDef::Encoding{.code = 0xBF, .umask = 0x2, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 7; Bank 2)",
      R"(WR_CAS Access to Rank 7; Bank 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK7.BANK3",
      EventDef::Encoding{.code = 0xBF, .umask = 0x3, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 7; Bank 3)",
      R"(WR_CAS Access to Rank 7; Bank 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK7.BANK4",
      EventDef::Encoding{.code = 0xBF, .umask = 0x4, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 7; Bank 4)",
      R"(WR_CAS Access to Rank 7; Bank 4)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK7.BANK5",
      EventDef::Encoding{.code = 0xBF, .umask = 0x5, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 7; Bank 5)",
      R"(WR_CAS Access to Rank 7; Bank 5)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK7.BANK6",
      EventDef::Encoding{.code = 0xBF, .umask = 0x6, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 7; Bank 6)",
      R"(WR_CAS Access to Rank 7; Bank 6)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK7.BANK7",
      EventDef::Encoding{.code = 0xBF, .umask = 0x7, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 7; Bank 7)",
      R"(WR_CAS Access to Rank 7; Bank 7)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK7.BANK8",
      EventDef::Encoding{.code = 0xBF, .umask = 0x8, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 7; Bank 8)",
      R"(WR_CAS Access to Rank 7; Bank 8)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK7.BANK9",
      EventDef::Encoding{.code = 0xBF, .umask = 0x9, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 7; Bank 9)",
      R"(WR_CAS Access to Rank 7; Bank 9)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK7.BANK10",
      EventDef::Encoding{.code = 0xBF, .umask = 0xA, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 7; Bank 10)",
      R"(WR_CAS Access to Rank 7; Bank 10)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK7.BANK11",
      EventDef::Encoding{.code = 0xBF, .umask = 0xB, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 7; Bank 11)",
      R"(WR_CAS Access to Rank 7; Bank 11)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK7.BANK12",
      EventDef::Encoding{.code = 0xBF, .umask = 0xC, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 7; Bank 12)",
      R"(WR_CAS Access to Rank 7; Bank 12)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK7.BANK13",
      EventDef::Encoding{.code = 0xBF, .umask = 0xD, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 7; Bank 13)",
      R"(WR_CAS Access to Rank 7; Bank 13)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK7.BANK14",
      EventDef::Encoding{.code = 0xBF, .umask = 0xE, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 7; Bank 14)",
      R"(WR_CAS Access to Rank 7; Bank 14)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK7.BANK15",
      EventDef::Encoding{.code = 0xBF, .umask = 0xF, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 7; Bank 15)",
      R"(WR_CAS Access to Rank 7; Bank 15)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK7.ALLBANKS",
      EventDef::Encoding{.code = 0xBF, .umask = 0x10, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 7; All Banks)",
      R"(WR_CAS Access to Rank 7; All Banks)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK7.BANKG0",
      EventDef::Encoding{.code = 0xBF, .umask = 0x11, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 7; Bank Group 0 (Banks 0-3))",
      R"(WR_CAS Access to Rank 7; Bank Group 0 (Banks 0-3))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK7.BANKG1",
      EventDef::Encoding{.code = 0xBF, .umask = 0x12, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 7; Bank Group 1 (Banks 4-7))",
      R"(WR_CAS Access to Rank 7; Bank Group 1 (Banks 4-7))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK7.BANKG2",
      EventDef::Encoding{.code = 0xBF, .umask = 0x13, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 7; Bank Group 2 (Banks 8-11))",
      R"(WR_CAS Access to Rank 7; Bank Group 2 (Banks 8-11))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_imc,
      "UNC_M_WR_CAS_RANK7.BANKG3",
      EventDef::Encoding{.code = 0xBF, .umask = 0x14, .msr_values = {0x00}},
      R"(WR_CAS Access to Rank 7; Bank Group 3 (Banks 12-15))",
      R"(WR_CAS Access to Rank 7; Bank Group 3 (Banks 12-15))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ3",
      EventDef::Encoding{.code = 0x18, .umask = 0x80, .msr_values = {0x00}},
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ3)",
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_FLITS.PROTHDR",
      EventDef::Encoding{.code = 0x3, .umask = 0x80, .msr_values = {0x00}},
      R"(Valid Flits Received; Protocol Header)",
      R"(Shows legal flit time (hides impact of L0p and L0c).; Enables count of protocol headers in slot 0,1,2 (depending on slot uMask bits))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_TxL_FLITS.PROTHDR",
      EventDef::Encoding{.code = 0x2, .umask = 0x80, .msr_values = {0x00}},
      R"(Valid Flits Sent; Protocol Header)",
      R"(Shows legal flit time (hides impact of L0p and L0c).; Enables count of protocol headers in slot 0,1,2 (depending on slot uMask bits))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_ACQUIRED.TGR0",
      EventDef::Encoding{.code = 0x80, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Acquired; For Transgress 0)",
      R"(Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_ACQUIRED.TGR1",
      EventDef::Encoding{.code = 0x80, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Acquired; For Transgress 1)",
      R"(Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_ACQUIRED.TGR2",
      EventDef::Encoding{.code = 0x80, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Acquired; For Transgress 2)",
      R"(Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_ACQUIRED.TGR3",
      EventDef::Encoding{.code = 0x80, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Acquired; For Transgress 3)",
      R"(Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_ACQUIRED.TGR4",
      EventDef::Encoding{.code = 0x80, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Acquired; For Transgress 4)",
      R"(Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_ACQUIRED.TGR5",
      EventDef::Encoding{.code = 0x80, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Acquired; For Transgress 5)",
      R"(Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_OCCUPANCY.TGR0",
      EventDef::Encoding{.code = 0x82, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Occupancy; For Transgress 0)",
      R"(Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_OCCUPANCY.TGR1",
      EventDef::Encoding{.code = 0x82, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Occupancy; For Transgress 1)",
      R"(Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_OCCUPANCY.TGR2",
      EventDef::Encoding{.code = 0x82, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Occupancy; For Transgress 2)",
      R"(Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_OCCUPANCY.TGR3",
      EventDef::Encoding{.code = 0x82, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Occupancy; For Transgress 3)",
      R"(Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_OCCUPANCY.TGR4",
      EventDef::Encoding{.code = 0x82, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Occupancy; For Transgress 4)",
      R"(Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_AD_CRD_OCCUPANCY.TGR5",
      EventDef::Encoding{.code = 0x82, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Occupancy; For Transgress 5)",
      R"(Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_ACQUIRED.TGR0",
      EventDef::Encoding{.code = 0x88, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Acquired; For Transgress 0)",
      R"(Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_ACQUIRED.TGR1",
      EventDef::Encoding{.code = 0x88, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Acquired; For Transgress 1)",
      R"(Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_ACQUIRED.TGR2",
      EventDef::Encoding{.code = 0x88, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Acquired; For Transgress 2)",
      R"(Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_ACQUIRED.TGR3",
      EventDef::Encoding{.code = 0x88, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Acquired; For Transgress 3)",
      R"(Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_ACQUIRED.TGR4",
      EventDef::Encoding{.code = 0x88, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Acquired; For Transgress 4)",
      R"(Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_ACQUIRED.TGR5",
      EventDef::Encoding{.code = 0x88, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Acquired; For Transgress 5)",
      R"(Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_OCCUPANCY.TGR0",
      EventDef::Encoding{.code = 0x8A, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Occupancy; For Transgress 0)",
      R"(Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_OCCUPANCY.TGR1",
      EventDef::Encoding{.code = 0x8A, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Occupancy; For Transgress 1)",
      R"(Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_OCCUPANCY.TGR2",
      EventDef::Encoding{.code = 0x8A, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Occupancy; For Transgress 2)",
      R"(Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_OCCUPANCY.TGR3",
      EventDef::Encoding{.code = 0x8A, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Occupancy; For Transgress 3)",
      R"(Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_OCCUPANCY.TGR4",
      EventDef::Encoding{.code = 0x8A, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Occupancy; For Transgress 4)",
      R"(Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG0_BL_CRD_OCCUPANCY.TGR5",
      EventDef::Encoding{.code = 0x8A, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Occupancy; For Transgress 5)",
      R"(Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_ACQUIRED.TGR0",
      EventDef::Encoding{.code = 0x84, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Acquired; For Transgress 0)",
      R"(Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_ACQUIRED.TGR1",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Acquired; For Transgress 1)",
      R"(Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_ACQUIRED.TGR2",
      EventDef::Encoding{.code = 0x84, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Acquired; For Transgress 2)",
      R"(Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_ACQUIRED.TGR3",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Acquired; For Transgress 3)",
      R"(Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_ACQUIRED.TGR4",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Acquired; For Transgress 4)",
      R"(Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_ACQUIRED.TGR5",
      EventDef::Encoding{.code = 0x84, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Acquired; For Transgress 5)",
      R"(Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_OCCUPANCY.TGR0",
      EventDef::Encoding{.code = 0x86, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Occupancy; For Transgress 0)",
      R"(Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_OCCUPANCY.TGR1",
      EventDef::Encoding{.code = 0x86, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Occupancy; For Transgress 1)",
      R"(Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_OCCUPANCY.TGR2",
      EventDef::Encoding{.code = 0x86, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Occupancy; For Transgress 2)",
      R"(Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_OCCUPANCY.TGR3",
      EventDef::Encoding{.code = 0x86, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Occupancy; For Transgress 3)",
      R"(Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_OCCUPANCY.TGR4",
      EventDef::Encoding{.code = 0x86, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Occupancy; For Transgress 4)",
      R"(Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_AD_CRD_OCCUPANCY.TGR5",
      EventDef::Encoding{.code = 0x86, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Occupancy; For Transgress 5)",
      R"(Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_OCCUPANCY.TGR0",
      EventDef::Encoding{.code = 0x8E, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Occupancy; For Transgress 0)",
      R"(Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_OCCUPANCY.TGR1",
      EventDef::Encoding{.code = 0x8E, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Occupancy; For Transgress 1)",
      R"(Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_OCCUPANCY.TGR2",
      EventDef::Encoding{.code = 0x8E, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Occupancy; For Transgress 2)",
      R"(Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_OCCUPANCY.TGR3",
      EventDef::Encoding{.code = 0x8E, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Occupancy; For Transgress 3)",
      R"(Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_OCCUPANCY.TGR4",
      EventDef::Encoding{.code = 0x8E, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Occupancy; For Transgress 4)",
      R"(Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CRD_OCCUPANCY.TGR5",
      EventDef::Encoding{.code = 0x8E, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Occupancy; For Transgress 5)",
      R"(Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CREDITS_ACQUIRED.TGR0",
      EventDef::Encoding{.code = 0x8C, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Acquired; For Transgress 0)",
      R"(Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CREDITS_ACQUIRED.TGR1",
      EventDef::Encoding{.code = 0x8C, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Acquired; For Transgress 1)",
      R"(Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CREDITS_ACQUIRED.TGR2",
      EventDef::Encoding{.code = 0x8C, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Acquired; For Transgress 2)",
      R"(Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CREDITS_ACQUIRED.TGR3",
      EventDef::Encoding{.code = 0x8C, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Acquired; For Transgress 3)",
      R"(Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CREDITS_ACQUIRED.TGR4",
      EventDef::Encoding{.code = 0x8C, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Acquired; For Transgress 4)",
      R"(Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_AG1_BL_CREDITS_ACQUIRED.TGR5",
      EventDef::Encoding{.code = 0x8C, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Acquired; For Transgress 5)",
      R"(Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_EGRESS_ORDERING.IV_SNOOPGO_DN",
      EventDef::Encoding{.code = 0xAE, .umask = 0x04, .msr_values = {0x00}},
      R"(Egress Blocking due to Ordering requirements; Down)",
      R"(Counts number of cycles IV was blocked in the TGR Egress due to SNP/GO Ordering requirements)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_EGRESS_ORDERING.IV_SNOOPGO_UP",
      EventDef::Encoding{.code = 0xAE, .umask = 0x01, .msr_values = {0x00}},
      R"(Egress Blocking due to Ordering requirements; Up)",
      R"(Counts number of cycles IV was blocked in the TGR Egress due to SNP/GO Ordering requirements)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_AD_IN_USE.LEFT_EVEN",
      EventDef::Encoding{.code = 0xA7, .umask = 0x01, .msr_values = {0x00}},
      R"(Horizontal AD Ring In Use; Left and Even)",
      R"(Counts the number of cycles that the Horizontal AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_AD_IN_USE.LEFT_ODD",
      EventDef::Encoding{.code = 0xA7, .umask = 0x02, .msr_values = {0x00}},
      R"(Horizontal AD Ring In Use; Left and Odd)",
      R"(Counts the number of cycles that the Horizontal AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_AD_IN_USE.RIGHT_EVEN",
      EventDef::Encoding{.code = 0xA7, .umask = 0x04, .msr_values = {0x00}},
      R"(Horizontal AD Ring In Use; Right and Even)",
      R"(Counts the number of cycles that the Horizontal AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_AD_IN_USE.RIGHT_ODD",
      EventDef::Encoding{.code = 0xA7, .umask = 0x08, .msr_values = {0x00}},
      R"(Horizontal AD Ring In Use; Right and Odd)",
      R"(Counts the number of cycles that the Horizontal AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_AK_IN_USE.LEFT_EVEN",
      EventDef::Encoding{.code = 0xA9, .umask = 0x01, .msr_values = {0x00}},
      R"(Horizontal AK Ring In Use; Left and Even)",
      R"(Counts the number of cycles that the Horizontal AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_AK_IN_USE.LEFT_ODD",
      EventDef::Encoding{.code = 0xA9, .umask = 0x02, .msr_values = {0x00}},
      R"(Horizontal AK Ring In Use; Left and Odd)",
      R"(Counts the number of cycles that the Horizontal AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_AK_IN_USE.RIGHT_EVEN",
      EventDef::Encoding{.code = 0xA9, .umask = 0x04, .msr_values = {0x00}},
      R"(Horizontal AK Ring In Use; Right and Even)",
      R"(Counts the number of cycles that the Horizontal AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_AK_IN_USE.RIGHT_ODD",
      EventDef::Encoding{.code = 0xA9, .umask = 0x08, .msr_values = {0x00}},
      R"(Horizontal AK Ring In Use; Right and Odd)",
      R"(Counts the number of cycles that the Horizontal AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_BL_IN_USE.LEFT_EVEN",
      EventDef::Encoding{.code = 0xAB, .umask = 0x01, .msr_values = {0x00}},
      R"(Horizontal BL Ring in Use; Left and Even)",
      R"(Counts the number of cycles that the Horizontal BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_BL_IN_USE.LEFT_ODD",
      EventDef::Encoding{.code = 0xAB, .umask = 0x02, .msr_values = {0x00}},
      R"(Horizontal BL Ring in Use; Left and Odd)",
      R"(Counts the number of cycles that the Horizontal BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_BL_IN_USE.RIGHT_EVEN",
      EventDef::Encoding{.code = 0xAB, .umask = 0x04, .msr_values = {0x00}},
      R"(Horizontal BL Ring in Use; Right and Even)",
      R"(Counts the number of cycles that the Horizontal BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_BL_IN_USE.RIGHT_ODD",
      EventDef::Encoding{.code = 0xAB, .umask = 0x08, .msr_values = {0x00}},
      R"(Horizontal BL Ring in Use; Right and Odd)",
      R"(Counts the number of cycles that the Horizontal BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_IV_IN_USE.LEFT",
      EventDef::Encoding{.code = 0xAD, .umask = 0x01, .msr_values = {0x00}},
      R"(Horizontal IV Ring in Use; Left)",
      R"(Counts the number of cycles that the Horizontal IV ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  There is only 1 IV ring.  Therefore, if one wants to monitor the Even ring, they should select both UP_EVEN and DN_EVEN.  To monitor the Odd ring, they should select both UP_ODD and DN_ODD.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_HORZ_RING_IV_IN_USE.RIGHT",
      EventDef::Encoding{.code = 0xAD, .umask = 0x04, .msr_values = {0x00}},
      R"(Horizontal IV Ring in Use; Right)",
      R"(Counts the number of cycles that the Horizontal IV ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  There is only 1 IV ring.  Therefore, if one wants to monitor the Even ring, they should select both UP_EVEN and DN_EVEN.  To monitor the Odd ring, they should select both UP_ODD and DN_ODD.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_BOUNCES_HORZ.AD",
      EventDef::Encoding{.code = 0xA1, .umask = 0x01, .msr_values = {0x00}},
      R"(Messages that bounced on the Horizontal Ring.; AD)",
      R"(Number of cycles incoming messages from the Horizontal ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_BOUNCES_HORZ.AK",
      EventDef::Encoding{.code = 0xA1, .umask = 0x02, .msr_values = {0x00}},
      R"(Messages that bounced on the Horizontal Ring.; AK)",
      R"(Number of cycles incoming messages from the Horizontal ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_BOUNCES_HORZ.BL",
      EventDef::Encoding{.code = 0xA1, .umask = 0x04, .msr_values = {0x00}},
      R"(Messages that bounced on the Horizontal Ring.; BL)",
      R"(Number of cycles incoming messages from the Horizontal ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_BOUNCES_HORZ.IV",
      EventDef::Encoding{.code = 0xA1, .umask = 0x08, .msr_values = {0x00}},
      R"(Messages that bounced on the Horizontal Ring.; IV)",
      R"(Number of cycles incoming messages from the Horizontal ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_BOUNCES_VERT.AD",
      EventDef::Encoding{.code = 0xA0, .umask = 0x01, .msr_values = {0x00}},
      R"(Messages that bounced on the Vertical Ring.; AD)",
      R"(Number of cycles incoming messages from the Vertical ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_BOUNCES_VERT.AK",
      EventDef::Encoding{.code = 0xA0, .umask = 0x02, .msr_values = {0x00}},
      R"(Messages that bounced on the Vertical Ring.; Acknowledgements to core)",
      R"(Number of cycles incoming messages from the Vertical ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_BOUNCES_VERT.BL",
      EventDef::Encoding{.code = 0xA0, .umask = 0x04, .msr_values = {0x00}},
      R"(Messages that bounced on the Vertical Ring.; Data Responses to core)",
      R"(Number of cycles incoming messages from the Vertical ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_BOUNCES_VERT.IV",
      EventDef::Encoding{.code = 0xA0, .umask = 0x08, .msr_values = {0x00}},
      R"(Messages that bounced on the Vertical Ring.; Snoops of processor's cache.)",
      R"(Number of cycles incoming messages from the Vertical ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_SINK_STARVED_HORZ.AD",
      EventDef::Encoding{.code = 0xA3, .umask = 0x01, .msr_values = {0x00}},
      R"(Sink Starvation on Horizontal Ring; AD)",
      R"(Sink Starvation on Horizontal Ring; AD)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_SINK_STARVED_HORZ.AK",
      EventDef::Encoding{.code = 0xA3, .umask = 0x02, .msr_values = {0x00}},
      R"(Sink Starvation on Horizontal Ring; AK)",
      R"(Sink Starvation on Horizontal Ring; AK)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_SINK_STARVED_HORZ.AK_AG1",
      EventDef::Encoding{.code = 0xA3, .umask = 0x20, .msr_values = {0x00}},
      R"(Sink Starvation on Horizontal Ring; Acknowledgements to Agent 1)",
      R"(Sink Starvation on Horizontal Ring; Acknowledgements to Agent 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_SINK_STARVED_HORZ.BL",
      EventDef::Encoding{.code = 0xA3, .umask = 0x04, .msr_values = {0x00}},
      R"(Sink Starvation on Horizontal Ring; BL)",
      R"(Sink Starvation on Horizontal Ring; BL)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_SINK_STARVED_HORZ.IV",
      EventDef::Encoding{.code = 0xA3, .umask = 0x08, .msr_values = {0x00}},
      R"(Sink Starvation on Horizontal Ring; IV)",
      R"(Sink Starvation on Horizontal Ring; IV)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_SINK_STARVED_VERT.AD",
      EventDef::Encoding{.code = 0xA2, .umask = 0x01, .msr_values = {0x00}},
      R"(Sink Starvation on Vertical Ring; AD)",
      R"(Sink Starvation on Vertical Ring; AD)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_SINK_STARVED_VERT.AK",
      EventDef::Encoding{.code = 0xA2, .umask = 0x02, .msr_values = {0x00}},
      R"(Sink Starvation on Vertical Ring; Acknowledgements to core)",
      R"(Sink Starvation on Vertical Ring; Acknowledgements to core)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_SINK_STARVED_VERT.BL",
      EventDef::Encoding{.code = 0xA2, .umask = 0x04, .msr_values = {0x00}},
      R"(Sink Starvation on Vertical Ring; Data Responses to core)",
      R"(Sink Starvation on Vertical Ring; Data Responses to core)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_SINK_STARVED_VERT.IV",
      EventDef::Encoding{.code = 0xA2, .umask = 0x08, .msr_values = {0x00}},
      R"(Sink Starvation on Vertical Ring; Snoops of processor's cache.)",
      R"(Sink Starvation on Vertical Ring; Snoops of processor's cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RING_SRC_THRTL",
      EventDef::Encoding{.code = 0xA4, .umask = 0x00, .msr_values = {0x00}},
      R"(Source Throttle)",
      R"(Source Throttle)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxC_AD_CYCLES_FULL",
      EventDef::Encoding{.code = 0x4, .umask = 0x00, .msr_values = {0x00}},
      R"(AD Ingress (from CMS) Full)",
      R"(AD Ingress (from CMS) Full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxC_AD_CYCLES_NE",
      EventDef::Encoding{.code = 0x3, .umask = 0x00, .msr_values = {0x00}},
      R"(AD Ingress (from CMS) Not Empty)",
      R"(AD Ingress (from CMS) Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxC_BL_CYCLES_FULL",
      EventDef::Encoding{.code = 0x8, .umask = 0x00, .msr_values = {0x00}},
      R"(BL Ingress (from CMS) Full)",
      R"(BL Ingress (from CMS) Full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxC_BL_CYCLES_NE",
      EventDef::Encoding{.code = 0x7, .umask = 0x00, .msr_values = {0x00}},
      R"(BL Ingress (from CMS) Not Empty)",
      R"(BL Ingress (from CMS) Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BUSY_STARVED.AD_BNC",
      EventDef::Encoding{.code = 0xB4, .umask = 0x01, .msr_values = {0x00}},
      R"(Transgress Injection Starvation; AD - Bounce)",
      R"(Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, because a message from the other queue has higher priority)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BUSY_STARVED.AD_CRD",
      EventDef::Encoding{.code = 0xB4, .umask = 0x10, .msr_values = {0x00}},
      R"(Transgress Injection Starvation; AD - Credit)",
      R"(Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, because a message from the other queue has higher priority)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BUSY_STARVED.BL_BNC",
      EventDef::Encoding{.code = 0xB4, .umask = 0x04, .msr_values = {0x00}},
      R"(Transgress Injection Starvation; BL - Bounce)",
      R"(Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, because a message from the other queue has higher priority)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BUSY_STARVED.BL_CRD",
      EventDef::Encoding{.code = 0xB4, .umask = 0x40, .msr_values = {0x00}},
      R"(Transgress Injection Starvation; BL - Credit)",
      R"(Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, because a message from the other queue has higher priority)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BYPASS.AD_BNC",
      EventDef::Encoding{.code = 0xB2, .umask = 0x01, .msr_values = {0x00}},
      R"(Transgress Ingress Bypass; AD - Bounce)",
      R"(Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BYPASS.AD_CRD",
      EventDef::Encoding{.code = 0xB2, .umask = 0x10, .msr_values = {0x00}},
      R"(Transgress Ingress Bypass; AD - Credit)",
      R"(Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BYPASS.AK_BNC",
      EventDef::Encoding{.code = 0xB2, .umask = 0x02, .msr_values = {0x00}},
      R"(Transgress Ingress Bypass; AK - Bounce)",
      R"(Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BYPASS.BL_BNC",
      EventDef::Encoding{.code = 0xB2, .umask = 0x04, .msr_values = {0x00}},
      R"(Transgress Ingress Bypass; BL - Bounce)",
      R"(Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BYPASS.BL_CRD",
      EventDef::Encoding{.code = 0xB2, .umask = 0x40, .msr_values = {0x00}},
      R"(Transgress Ingress Bypass; BL - Credit)",
      R"(Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_BYPASS.IV_BNC",
      EventDef::Encoding{.code = 0xB2, .umask = 0x08, .msr_values = {0x00}},
      R"(Transgress Ingress Bypass; IV - Bounce)",
      R"(Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_CRD_STARVED.AD_BNC",
      EventDef::Encoding{.code = 0xB3, .umask = 0x01, .msr_values = {0x00}},
      R"(Transgress Injection Starvation; AD - Bounce)",
      R"(Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_CRD_STARVED.AD_CRD",
      EventDef::Encoding{.code = 0xB3, .umask = 0x10, .msr_values = {0x00}},
      R"(Transgress Injection Starvation; AD - Credit)",
      R"(Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_CRD_STARVED.AK_BNC",
      EventDef::Encoding{.code = 0xB3, .umask = 0x02, .msr_values = {0x00}},
      R"(Transgress Injection Starvation; AK - Bounce)",
      R"(Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_CRD_STARVED.BL_BNC",
      EventDef::Encoding{.code = 0xB3, .umask = 0x04, .msr_values = {0x00}},
      R"(Transgress Injection Starvation; BL - Bounce)",
      R"(Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_CRD_STARVED.BL_CRD",
      EventDef::Encoding{.code = 0xB3, .umask = 0x40, .msr_values = {0x00}},
      R"(Transgress Injection Starvation; BL - Credit)",
      R"(Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_CRD_STARVED.IFV",
      EventDef::Encoding{.code = 0xB3, .umask = 0x80, .msr_values = {0x00}},
      R"(Transgress Injection Starvation; IFV - Credit)",
      R"(Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_CRD_STARVED.IV_BNC",
      EventDef::Encoding{.code = 0xB3, .umask = 0x08, .msr_values = {0x00}},
      R"(Transgress Injection Starvation; IV - Bounce)",
      R"(Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_INSERTS.AD_BNC",
      EventDef::Encoding{.code = 0xB1, .umask = 0x01, .msr_values = {0x00}},
      R"(Transgress Ingress Allocations; AD - Bounce)",
      R"(Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_INSERTS.AD_CRD",
      EventDef::Encoding{.code = 0xB1, .umask = 0x10, .msr_values = {0x00}},
      R"(Transgress Ingress Allocations; AD - Credit)",
      R"(Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_INSERTS.AK_BNC",
      EventDef::Encoding{.code = 0xB1, .umask = 0x02, .msr_values = {0x00}},
      R"(Transgress Ingress Allocations; AK - Bounce)",
      R"(Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_INSERTS.BL_BNC",
      EventDef::Encoding{.code = 0xB1, .umask = 0x04, .msr_values = {0x00}},
      R"(Transgress Ingress Allocations; BL - Bounce)",
      R"(Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_INSERTS.BL_CRD",
      EventDef::Encoding{.code = 0xB1, .umask = 0x40, .msr_values = {0x00}},
      R"(Transgress Ingress Allocations; BL - Credit)",
      R"(Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_INSERTS.IV_BNC",
      EventDef::Encoding{.code = 0xB1, .umask = 0x08, .msr_values = {0x00}},
      R"(Transgress Ingress Allocations; IV - Bounce)",
      R"(Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_OCCUPANCY.AD_BNC",
      EventDef::Encoding{.code = 0xB0, .umask = 0x01, .msr_values = {0x00}},
      R"(Transgress Ingress Occupancy; AD - Bounce)",
      R"(Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_OCCUPANCY.AD_CRD",
      EventDef::Encoding{.code = 0xB0, .umask = 0x10, .msr_values = {0x00}},
      R"(Transgress Ingress Occupancy; AD - Credit)",
      R"(Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_OCCUPANCY.AK_BNC",
      EventDef::Encoding{.code = 0xB0, .umask = 0x02, .msr_values = {0x00}},
      R"(Transgress Ingress Occupancy; AK - Bounce)",
      R"(Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_OCCUPANCY.BL_BNC",
      EventDef::Encoding{.code = 0xB0, .umask = 0x04, .msr_values = {0x00}},
      R"(Transgress Ingress Occupancy; BL - Bounce)",
      R"(Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_OCCUPANCY.BL_CRD",
      EventDef::Encoding{.code = 0xB0, .umask = 0x40, .msr_values = {0x00}},
      R"(Transgress Ingress Occupancy; BL - Credit)",
      R"(Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_RxR_OCCUPANCY.IV_BNC",
      EventDef::Encoding{.code = 0xB0, .umask = 0x08, .msr_values = {0x00}},
      R"(Transgress Ingress Occupancy; IV - Bounce)",
      R"(Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_AD_AG0.TGR0",
      EventDef::Encoding{.code = 0xD0, .umask = 0x01, .msr_values = {0x00}},
      R"(Stall on No AD Agent0 Transgress Credits; For Transgress 0)",
      R"(Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_AD_AG0.TGR1",
      EventDef::Encoding{.code = 0xD0, .umask = 0x02, .msr_values = {0x00}},
      R"(Stall on No AD Agent0 Transgress Credits; For Transgress 1)",
      R"(Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_AD_AG0.TGR2",
      EventDef::Encoding{.code = 0xD0, .umask = 0x04, .msr_values = {0x00}},
      R"(Stall on No AD Agent0 Transgress Credits; For Transgress 2)",
      R"(Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_AD_AG0.TGR3",
      EventDef::Encoding{.code = 0xD0, .umask = 0x08, .msr_values = {0x00}},
      R"(Stall on No AD Agent0 Transgress Credits; For Transgress 3)",
      R"(Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_AD_AG0.TGR4",
      EventDef::Encoding{.code = 0xD0, .umask = 0x10, .msr_values = {0x00}},
      R"(Stall on No AD Agent0 Transgress Credits; For Transgress 4)",
      R"(Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_AD_AG0.TGR5",
      EventDef::Encoding{.code = 0xD0, .umask = 0x20, .msr_values = {0x00}},
      R"(Stall on No AD Agent0 Transgress Credits; For Transgress 5)",
      R"(Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_AD_AG1.TGR0",
      EventDef::Encoding{.code = 0xD2, .umask = 0x01, .msr_values = {0x00}},
      R"(Stall on No AD Agent1 Transgress Credits; For Transgress 0)",
      R"(Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_AD_AG1.TGR1",
      EventDef::Encoding{.code = 0xD2, .umask = 0x02, .msr_values = {0x00}},
      R"(Stall on No AD Agent1 Transgress Credits; For Transgress 1)",
      R"(Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_AD_AG1.TGR2",
      EventDef::Encoding{.code = 0xD2, .umask = 0x04, .msr_values = {0x00}},
      R"(Stall on No AD Agent1 Transgress Credits; For Transgress 2)",
      R"(Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_AD_AG1.TGR3",
      EventDef::Encoding{.code = 0xD2, .umask = 0x08, .msr_values = {0x00}},
      R"(Stall on No AD Agent1 Transgress Credits; For Transgress 3)",
      R"(Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_AD_AG1.TGR4",
      EventDef::Encoding{.code = 0xD2, .umask = 0x10, .msr_values = {0x00}},
      R"(Stall on No AD Agent1 Transgress Credits; For Transgress 4)",
      R"(Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_AD_AG1.TGR5",
      EventDef::Encoding{.code = 0xD2, .umask = 0x20, .msr_values = {0x00}},
      R"(Stall on No AD Agent1 Transgress Credits; For Transgress 5)",
      R"(Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_BL_AG0.TGR0",
      EventDef::Encoding{.code = 0xD4, .umask = 0x01, .msr_values = {0x00}},
      R"(Stall on No BL Agent0 Transgress Credits; For Transgress 0)",
      R"(Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_BL_AG0.TGR1",
      EventDef::Encoding{.code = 0xD4, .umask = 0x02, .msr_values = {0x00}},
      R"(Stall on No BL Agent0 Transgress Credits; For Transgress 1)",
      R"(Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_BL_AG0.TGR2",
      EventDef::Encoding{.code = 0xD4, .umask = 0x04, .msr_values = {0x00}},
      R"(Stall on No BL Agent0 Transgress Credits; For Transgress 2)",
      R"(Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_BL_AG0.TGR3",
      EventDef::Encoding{.code = 0xD4, .umask = 0x08, .msr_values = {0x00}},
      R"(Stall on No BL Agent0 Transgress Credits; For Transgress 3)",
      R"(Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_BL_AG0.TGR4",
      EventDef::Encoding{.code = 0xD4, .umask = 0x10, .msr_values = {0x00}},
      R"(Stall on No BL Agent0 Transgress Credits; For Transgress 4)",
      R"(Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_BL_AG0.TGR5",
      EventDef::Encoding{.code = 0xD4, .umask = 0x20, .msr_values = {0x00}},
      R"(Stall on No BL Agent0 Transgress Credits; For Transgress 5)",
      R"(Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_BL_AG1.TGR0",
      EventDef::Encoding{.code = 0xD6, .umask = 0x01, .msr_values = {0x00}},
      R"(Stall on No BL Agent1 Transgress Credits; For Transgress 0)",
      R"(Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_BL_AG1.TGR1",
      EventDef::Encoding{.code = 0xD6, .umask = 0x02, .msr_values = {0x00}},
      R"(Stall on No BL Agent1 Transgress Credits; For Transgress 1)",
      R"(Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_BL_AG1.TGR2",
      EventDef::Encoding{.code = 0xD6, .umask = 0x04, .msr_values = {0x00}},
      R"(Stall on No BL Agent1 Transgress Credits; For Transgress 2)",
      R"(Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_BL_AG1.TGR3",
      EventDef::Encoding{.code = 0xD6, .umask = 0x08, .msr_values = {0x00}},
      R"(Stall on No BL Agent1 Transgress Credits; For Transgress 3)",
      R"(Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_BL_AG1.TGR4",
      EventDef::Encoding{.code = 0xD6, .umask = 0x10, .msr_values = {0x00}},
      R"(Stall on No BL Agent1 Transgress Credits; For Transgress 4)",
      R"(Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_STALL_NO_TxR_HORZ_CRD_BL_AG1.TGR5",
      EventDef::Encoding{.code = 0xD6, .umask = 0x20, .msr_values = {0x00}},
      R"(Stall on No BL Agent1 Transgress Credits; For Transgress 5)",
      R"(Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AD_CREDIT_OCCUPANCY",
      EventDef::Encoding{.code = 0xE, .umask = 0x00, .msr_values = {0x00}},
      R"(AD Egress (to CMS) Credits Occupancy)",
      R"(AD Egress (to CMS) Credits Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AD_CREDITS_ACQUIRED",
      EventDef::Encoding{.code = 0xD, .umask = 0x00, .msr_values = {0x00}},
      R"(AD Egress (to CMS) Credit Acquired)",
      R"(AD Egress (to CMS) Credit Acquired)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AD_CYCLES_FULL",
      EventDef::Encoding{.code = 0xC, .umask = 0x00, .msr_values = {0x00}},
      R"(AD Egress (to CMS) Full)",
      R"(AD Egress (to CMS) Full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AD_CYCLES_NE",
      EventDef::Encoding{.code = 0xB, .umask = 0x00, .msr_values = {0x00}},
      R"(AD Egress (to CMS) Not Empty)",
      R"(AD Egress (to CMS) Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AD_NO_CREDIT_CYCLES",
      EventDef::Encoding{.code = 0xF, .umask = 0x00, .msr_values = {0x00}},
      R"(Cycles with No AD Egress (to CMS) Credits)",
      R"(Cycles with No AD Egress (to CMS) Credits)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AD_NO_CREDIT_STALLED",
      EventDef::Encoding{.code = 0x10, .umask = 0x00, .msr_values = {0x00}},
      R"(Cycles Stalled with No AD Egress (to CMS) Credits)",
      R"(Cycles Stalled with No AD Egress (to CMS) Credits)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK.CRD_CBO",
      EventDef::Encoding{.code = 0x39, .umask = 0x02, .msr_values = {0x00}},
      R"(Outbound Ring Transactions on AK; CRD Transactions to Cbo)",
      R"(Outbound Ring Transactions on AK; CRD Transactions to Cbo)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK.NDR",
      EventDef::Encoding{.code = 0x39, .umask = 0x01, .msr_values = {0x00}},
      R"(Outbound Ring Transactions on AK; NDR Transactions)",
      R"(Outbound Ring Transactions on AK; NDR Transactions)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CREDIT_OCCUPANCY.CMS0",
      EventDef::Encoding{.code = 0x1E, .umask = 0x01, .msr_values = {0x00}},
      R"(AK Egress (to CMS) Credits Occupancy; Common Mesh Stop - Near Side)",
      R"(AK Egress (to CMS) Credits Occupancy; Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CREDIT_OCCUPANCY.CMS1",
      EventDef::Encoding{.code = 0x1E, .umask = 0x02, .msr_values = {0x00}},
      R"(AK Egress (to CMS) Credits Occupancy; Common Mesh Stop - Far Side)",
      R"(AK Egress (to CMS) Credits Occupancy; Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CREDITS_ACQUIRED.CMS0",
      EventDef::Encoding{.code = 0x1D, .umask = 0x01, .msr_values = {0x00}},
      R"(AK Egress (to CMS) Credit Acquired; Common Mesh Stop - Near Side)",
      R"(AK Egress (to CMS) Credit Acquired; Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_CREDITS_ACQUIRED.CMS1",
      EventDef::Encoding{.code = 0x1D, .umask = 0x02, .msr_values = {0x00}},
      R"(AK Egress (to CMS) Credit Acquired; Common Mesh Stop - Far Side)",
      R"(AK Egress (to CMS) Credit Acquired; Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_NO_CREDIT_CYCLES.CMS0",
      EventDef::Encoding{.code = 0x1F, .umask = 0x01, .msr_values = {0x00}},
      R"(Cycles with No AK Egress (to CMS) Credits; Common Mesh Stop - Near Side)",
      R"(Cycles with No AK Egress (to CMS) Credits; Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_NO_CREDIT_CYCLES.CMS1",
      EventDef::Encoding{.code = 0x1F, .umask = 0x02, .msr_values = {0x00}},
      R"(Cycles with No AK Egress (to CMS) Credits; Common Mesh Stop - Far Side)",
      R"(Cycles with No AK Egress (to CMS) Credits; Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_NO_CREDIT_STALLED.CMS0",
      EventDef::Encoding{.code = 0x20, .umask = 0x01, .msr_values = {0x00}},
      R"(Cycles Stalled with No AK Egress (to CMS) Credits; Common Mesh Stop - Near Side)",
      R"(Cycles Stalled with No AK Egress (to CMS) Credits; Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_AK_NO_CREDIT_STALLED.CMS1",
      EventDef::Encoding{.code = 0x20, .umask = 0x02, .msr_values = {0x00}},
      R"(Cycles Stalled with No AK Egress (to CMS) Credits; Common Mesh Stop - Far Side)",
      R"(Cycles Stalled with No AK Egress (to CMS) Credits; Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL.DRS_CACHE",
      EventDef::Encoding{.code = 0x40, .umask = 0x01, .msr_values = {0x00}},
      R"(Outbound DRS Ring Transactions to Cache; Data to Cache)",
      R"(Outbound DRS Ring Transactions to Cache; Data to Cache)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL.DRS_CORE",
      EventDef::Encoding{.code = 0x40, .umask = 0x02, .msr_values = {0x00}},
      R"(Outbound DRS Ring Transactions to Cache; Data to Core)",
      R"(Outbound DRS Ring Transactions to Cache; Data to Core)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CREDIT_OCCUPANCY.CMS0",
      EventDef::Encoding{.code = 0x1A, .umask = 0x01, .msr_values = {0x00}},
      R"(BL Egress (to CMS) Credits Occupancy; Common Mesh Stop - Near Side)",
      R"(BL Egress (to CMS) Credits Occupancy; Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CREDIT_OCCUPANCY.CMS1",
      EventDef::Encoding{.code = 0x1A, .umask = 0x02, .msr_values = {0x00}},
      R"(BL Egress (to CMS) Credits Occupancy; Common Mesh Stop - Far Side)",
      R"(BL Egress (to CMS) Credits Occupancy; Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CREDITS_ACQUIRED.CMS0",
      EventDef::Encoding{.code = 0x19, .umask = 0x01, .msr_values = {0x00}},
      R"(BL Egress (to CMS) Credit Acquired; Common Mesh Stop - Near Side)",
      R"(BL Egress (to CMS) Credit Acquired; Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CREDITS_ACQUIRED.CMS1",
      EventDef::Encoding{.code = 0x19, .umask = 0x02, .msr_values = {0x00}},
      R"(BL Egress (to CMS) Credit Acquired; Common Mesh Stop - Far Side)",
      R"(BL Egress (to CMS) Credit Acquired; Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CYCLES_FULL.ALL",
      EventDef::Encoding{.code = 0x18, .umask = 0x03, .msr_values = {0x00}},
      R"(BL Egress (to CMS) Full; All)",
      R"(BL Egress (to CMS) Full; All)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CYCLES_FULL.CMS0",
      EventDef::Encoding{.code = 0x18, .umask = 0x01, .msr_values = {0x00}},
      R"(BL Egress (to CMS) Full; Common Mesh Stop - Near Side)",
      R"(BL Egress (to CMS) Full; Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CYCLES_FULL.CMS1",
      EventDef::Encoding{.code = 0x18, .umask = 0x02, .msr_values = {0x00}},
      R"(BL Egress (to CMS) Full; Common Mesh Stop - Far Side)",
      R"(BL Egress (to CMS) Full; Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CYCLES_NE.ALL",
      EventDef::Encoding{.code = 0x17, .umask = 0x03, .msr_values = {0x00}},
      R"(BL Egress (to CMS) Not Empty; All)",
      R"(BL Egress (to CMS) Not Empty; All)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CYCLES_NE.CMS0",
      EventDef::Encoding{.code = 0x17, .umask = 0x01, .msr_values = {0x00}},
      R"(BL Egress (to CMS) Not Empty; Common Mesh Stop - Near Side)",
      R"(BL Egress (to CMS) Not Empty; Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_CYCLES_NE.CMS1",
      EventDef::Encoding{.code = 0x17, .umask = 0x02, .msr_values = {0x00}},
      R"(BL Egress (to CMS) Not Empty; Common Mesh Stop - Far Side)",
      R"(BL Egress (to CMS) Not Empty; Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_INSERTS.CMS0",
      EventDef::Encoding{.code = 0x15, .umask = 0x01, .msr_values = {0x00}},
      R"(BL Egress (to CMS) Allocations; Common Mesh Stop - Near Side)",
      R"(BL Egress (to CMS) Allocations; Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_INSERTS.CMS1",
      EventDef::Encoding{.code = 0x15, .umask = 0x02, .msr_values = {0x00}},
      R"(BL Egress (to CMS) Allocations; Common Mesh Stop - Far Side)",
      R"(BL Egress (to CMS) Allocations; Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_NO_CREDIT_CYCLES.CMS0",
      EventDef::Encoding{.code = 0x1B, .umask = 0x01, .msr_values = {0x00}},
      R"(Cycles with No BL Egress (to CMS) Credits; Common Mesh Stop - Near Side)",
      R"(Cycles with No BL Egress (to CMS) Credits; Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_NO_CREDIT_CYCLES.CMS1",
      EventDef::Encoding{.code = 0x1B, .umask = 0x02, .msr_values = {0x00}},
      R"(Cycles with No BL Egress (to CMS) Credits; Common Mesh Stop - Far Side)",
      R"(Cycles with No BL Egress (to CMS) Credits; Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_NO_CREDIT_STALLED.CMS0",
      EventDef::Encoding{.code = 0x1C, .umask = 0x01, .msr_values = {0x00}},
      R"(Cycles Stalled with No BL Egress (to CMS) Credits; Common Mesh Stop - Near Side)",
      R"(Cycles Stalled with No BL Egress (to CMS) Credits; Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_NO_CREDIT_STALLED.CMS1",
      EventDef::Encoding{.code = 0x1C, .umask = 0x02, .msr_values = {0x00}},
      R"(Cycles Stalled with No BL Egress (to CMS) Credits; Common Mesh Stop - Far Side)",
      R"(Cycles Stalled with No BL Egress (to CMS) Credits; Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_OCCUPANCY.CMS0",
      EventDef::Encoding{.code = 0x16, .umask = 0x01, .msr_values = {0x00}},
      R"(BL Egress (to CMS) Occupancy; Common Mesh Stop - Near Side)",
      R"(BL Egress (to CMS) Occupancy; Common Mesh Stop - Near Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxC_BL_OCCUPANCY.CMS1",
      EventDef::Encoding{.code = 0x16, .umask = 0x02, .msr_values = {0x00}},
      R"(BL Egress (to CMS) Occupancy; Common Mesh Stop - Far Side)",
      R"(BL Egress (to CMS) Occupancy; Common Mesh Stop - Far Side)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_ADS_USED.AD_BNC",
      EventDef::Encoding{.code = 0x9D, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Horizontal ADS Used; AD - Bounce)",
      R"(Number of packets using the Horizontal Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_ADS_USED.AD_CRD",
      EventDef::Encoding{.code = 0x9D, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Horizontal ADS Used; AD - Credit)",
      R"(Number of packets using the Horizontal Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_ADS_USED.AK_BNC",
      EventDef::Encoding{.code = 0x9D, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Horizontal ADS Used; AK - Bounce)",
      R"(Number of packets using the Horizontal Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_ADS_USED.BL_BNC",
      EventDef::Encoding{.code = 0x9D, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Horizontal ADS Used; BL - Bounce)",
      R"(Number of packets using the Horizontal Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_ADS_USED.BL_CRD",
      EventDef::Encoding{.code = 0x9D, .umask = 0x40, .msr_values = {0x00}},
      R"(CMS Horizontal ADS Used; BL - Credit)",
      R"(Number of packets using the Horizontal Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_BYPASS.AD_BNC",
      EventDef::Encoding{.code = 0x9F, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Horizontal Bypass Used; AD - Bounce)",
      R"(Number of packets bypassing the Horizontal Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_BYPASS.AD_CRD",
      EventDef::Encoding{.code = 0x9F, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Horizontal Bypass Used; AD - Credit)",
      R"(Number of packets bypassing the Horizontal Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_BYPASS.AK_BNC",
      EventDef::Encoding{.code = 0x9F, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Horizontal Bypass Used; AK - Bounce)",
      R"(Number of packets bypassing the Horizontal Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_BYPASS.BL_BNC",
      EventDef::Encoding{.code = 0x9F, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Horizontal Bypass Used; BL - Bounce)",
      R"(Number of packets bypassing the Horizontal Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_BYPASS.BL_CRD",
      EventDef::Encoding{.code = 0x9F, .umask = 0x40, .msr_values = {0x00}},
      R"(CMS Horizontal Bypass Used; BL - Credit)",
      R"(Number of packets bypassing the Horizontal Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_BYPASS.IV_BNC",
      EventDef::Encoding{.code = 0x9F, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Horizontal Bypass Used; IV - Bounce)",
      R"(Number of packets bypassing the Horizontal Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_CYCLES_FULL.AD_BNC",
      EventDef::Encoding{.code = 0x96, .umask = 0x01, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Full; AD - Bounce)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Full.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_CYCLES_FULL.AD_CRD",
      EventDef::Encoding{.code = 0x96, .umask = 0x10, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Full; AD - Credit)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Full.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_CYCLES_FULL.AK_BNC",
      EventDef::Encoding{.code = 0x96, .umask = 0x02, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Full; AK - Bounce)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Full.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_CYCLES_FULL.BL_BNC",
      EventDef::Encoding{.code = 0x96, .umask = 0x04, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Full; BL - Bounce)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Full.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_CYCLES_FULL.BL_CRD",
      EventDef::Encoding{.code = 0x96, .umask = 0x40, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Full; BL - Credit)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Full.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_CYCLES_FULL.IV_BNC",
      EventDef::Encoding{.code = 0x96, .umask = 0x08, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Full; IV - Bounce)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Full.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_CYCLES_NE.AD_BNC",
      EventDef::Encoding{.code = 0x97, .umask = 0x01, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Not Empty; AD - Bounce)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Not-Empty.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_CYCLES_NE.AD_CRD",
      EventDef::Encoding{.code = 0x97, .umask = 0x10, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Not Empty; AD - Credit)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Not-Empty.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_CYCLES_NE.AK_BNC",
      EventDef::Encoding{.code = 0x97, .umask = 0x02, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Not Empty; AK - Bounce)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Not-Empty.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_CYCLES_NE.BL_BNC",
      EventDef::Encoding{.code = 0x97, .umask = 0x04, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Not Empty; BL - Bounce)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Not-Empty.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_CYCLES_NE.BL_CRD",
      EventDef::Encoding{.code = 0x97, .umask = 0x40, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Not Empty; BL - Credit)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Not-Empty.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_CYCLES_NE.IV_BNC",
      EventDef::Encoding{.code = 0x97, .umask = 0x08, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Not Empty; IV - Bounce)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Not-Empty.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_INSERTS.AD_BNC",
      EventDef::Encoding{.code = 0x95, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Inserts; AD - Bounce)",
      R"(Number of allocations into the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_INSERTS.AD_CRD",
      EventDef::Encoding{.code = 0x95, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Inserts; AD - Credit)",
      R"(Number of allocations into the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_INSERTS.AK_BNC",
      EventDef::Encoding{.code = 0x95, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Inserts; AK - Bounce)",
      R"(Number of allocations into the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_INSERTS.BL_BNC",
      EventDef::Encoding{.code = 0x95, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Inserts; BL - Bounce)",
      R"(Number of allocations into the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_INSERTS.BL_CRD",
      EventDef::Encoding{.code = 0x95, .umask = 0x40, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Inserts; BL - Credit)",
      R"(Number of allocations into the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_INSERTS.IV_BNC",
      EventDef::Encoding{.code = 0x95, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Inserts; IV - Bounce)",
      R"(Number of allocations into the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_NACK.AD_BNC",
      EventDef::Encoding{.code = 0x99, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Horizontal Egress NACKs; AD - Bounce)",
      R"(Counts number of Egress packets NACK'ed on to the Horizontal Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_NACK.AD_CRD",
      EventDef::Encoding{.code = 0x99, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Horizontal Egress NACKs; AD - Credit)",
      R"(Counts number of Egress packets NACK'ed on to the Horizontal Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_NACK.AK_BNC",
      EventDef::Encoding{.code = 0x99, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Horizontal Egress NACKs; AK - Bounce)",
      R"(Counts number of Egress packets NACK'ed on to the Horizontal Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_NACK.BL_BNC",
      EventDef::Encoding{.code = 0x99, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Horizontal Egress NACKs; BL - Bounce)",
      R"(Counts number of Egress packets NACK'ed on to the Horizontal Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_NACK.BL_CRD",
      EventDef::Encoding{.code = 0x99, .umask = 0x40, .msr_values = {0x00}},
      R"(CMS Horizontal Egress NACKs; BL - Credit)",
      R"(Counts number of Egress packets NACK'ed on to the Horizontal Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_NACK.IV_BNC",
      EventDef::Encoding{.code = 0x99, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Horizontal Egress NACKs; IV - Bounce)",
      R"(Counts number of Egress packets NACK'ed on to the Horizontal Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_OCCUPANCY.AD_BNC",
      EventDef::Encoding{.code = 0x94, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Occupancy; AD - Bounce)",
      R"(Occupancy event for the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_OCCUPANCY.AD_CRD",
      EventDef::Encoding{.code = 0x94, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Occupancy; AD - Credit)",
      R"(Occupancy event for the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_OCCUPANCY.AK_BNC",
      EventDef::Encoding{.code = 0x94, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Occupancy; AK - Bounce)",
      R"(Occupancy event for the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_OCCUPANCY.BL_BNC",
      EventDef::Encoding{.code = 0x94, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Occupancy; BL - Bounce)",
      R"(Occupancy event for the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_OCCUPANCY.BL_CRD",
      EventDef::Encoding{.code = 0x94, .umask = 0x40, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Occupancy; BL - Credit)",
      R"(Occupancy event for the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_OCCUPANCY.IV_BNC",
      EventDef::Encoding{.code = 0x94, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Occupancy; IV - Bounce)",
      R"(Occupancy event for the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_STARVED.AD_BNC",
      EventDef::Encoding{.code = 0x9B, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Injection Starvation; AD - Bounce)",
      R"(Counts injection starvation.  This starvation is triggered when the CMS Transgress buffer cannot send a transaction onto the Horizontal ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_STARVED.AK_BNC",
      EventDef::Encoding{.code = 0x9B, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Injection Starvation; AK - Bounce)",
      R"(Counts injection starvation.  This starvation is triggered when the CMS Transgress buffer cannot send a transaction onto the Horizontal ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_STARVED.BL_BNC",
      EventDef::Encoding{.code = 0x9B, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Injection Starvation; BL - Bounce)",
      R"(Counts injection starvation.  This starvation is triggered when the CMS Transgress buffer cannot send a transaction onto the Horizontal ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_HORZ_STARVED.IV_BNC",
      EventDef::Encoding{.code = 0x9B, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Injection Starvation; IV - Bounce)",
      R"(Counts injection starvation.  This starvation is triggered when the CMS Transgress buffer cannot send a transaction onto the Horizontal ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_ADS_USED.AD_AG0",
      EventDef::Encoding{.code = 0x9C, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; AD - Agent 0)",
      R"(Number of packets using the Vertical Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_ADS_USED.AD_AG1",
      EventDef::Encoding{.code = 0x9C, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; AD - Agent 1)",
      R"(Number of packets using the Vertical Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_ADS_USED.AK_AG0",
      EventDef::Encoding{.code = 0x9C, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; AK - Agent 0)",
      R"(Number of packets using the Vertical Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_ADS_USED.AK_AG1",
      EventDef::Encoding{.code = 0x9C, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; AK - Agent 1)",
      R"(Number of packets using the Vertical Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_ADS_USED.BL_AG0",
      EventDef::Encoding{.code = 0x9C, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; BL - Agent 0)",
      R"(Number of packets using the Vertical Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_ADS_USED.BL_AG1",
      EventDef::Encoding{.code = 0x9C, .umask = 0x40, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; BL - Agent 1)",
      R"(Number of packets using the Vertical Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_BYPASS.AD_AG0",
      EventDef::Encoding{.code = 0x9E, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; AD - Agent 0)",
      R"(Number of packets bypassing the Vertical Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_BYPASS.AD_AG1",
      EventDef::Encoding{.code = 0x9E, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; AD - Agent 1)",
      R"(Number of packets bypassing the Vertical Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_BYPASS.AK_AG0",
      EventDef::Encoding{.code = 0x9E, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; AK - Agent 0)",
      R"(Number of packets bypassing the Vertical Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_BYPASS.AK_AG1",
      EventDef::Encoding{.code = 0x9E, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; AK - Agent 1)",
      R"(Number of packets bypassing the Vertical Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_BYPASS.BL_AG0",
      EventDef::Encoding{.code = 0x9E, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; BL - Agent 0)",
      R"(Number of packets bypassing the Vertical Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_BYPASS.BL_AG1",
      EventDef::Encoding{.code = 0x9E, .umask = 0x40, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; BL - Agent 1)",
      R"(Number of packets bypassing the Vertical Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_BYPASS.IV",
      EventDef::Encoding{.code = 0x9E, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; IV)",
      R"(Number of packets bypassing the Vertical Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_CYCLES_FULL.AD_AG0",
      EventDef::Encoding{.code = 0x92, .umask = 0x01, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Full; AD - Agent 0)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Full.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the AD ring.  Some example include outbound requests, snoop requests, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_CYCLES_FULL.AD_AG1",
      EventDef::Encoding{.code = 0x92, .umask = 0x10, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Full; AD - Agent 1)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Full.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the AD ring.  This is commonly used for outbound requests.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_CYCLES_FULL.AK_AG0",
      EventDef::Encoding{.code = 0x92, .umask = 0x02, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Full; AK - Agent 0)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Full.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the AK ring.  This is commonly used for credit returns and GO responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_CYCLES_FULL.AK_AG1",
      EventDef::Encoding{.code = 0x92, .umask = 0x20, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Full; AK - Agent 1)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Full.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the AK ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_CYCLES_FULL.BL_AG0",
      EventDef::Encoding{.code = 0x92, .umask = 0x04, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Full; BL - Agent 0)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Full.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the BL ring.  This is commonly used to send data from the cache to various destinations.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_CYCLES_FULL.BL_AG1",
      EventDef::Encoding{.code = 0x92, .umask = 0x40, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Full; BL - Agent 1)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Full.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the BL ring.  This is commonly used for transferring writeback data to the cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_CYCLES_FULL.IV",
      EventDef::Encoding{.code = 0x92, .umask = 0x08, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Full; IV)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Full.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the IV ring.  This is commonly used for snoops to the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_CYCLES_NE.AD_AG0",
      EventDef::Encoding{.code = 0x93, .umask = 0x01, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Not Empty; AD - Agent 0)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Empty.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the AD ring.  Some example include outbound requests, snoop requests, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_CYCLES_NE.AD_AG1",
      EventDef::Encoding{.code = 0x93, .umask = 0x10, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Not Empty; AD - Agent 1)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Empty.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the AD ring.  This is commonly used for outbound requests.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_CYCLES_NE.AK_AG0",
      EventDef::Encoding{.code = 0x93, .umask = 0x02, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Not Empty; AK - Agent 0)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Empty.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the AK ring.  This is commonly used for credit returns and GO responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_CYCLES_NE.AK_AG1",
      EventDef::Encoding{.code = 0x93, .umask = 0x20, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Not Empty; AK - Agent 1)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Empty.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the AK ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_CYCLES_NE.BL_AG0",
      EventDef::Encoding{.code = 0x93, .umask = 0x04, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Not Empty; BL - Agent 0)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Empty.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the BL ring.  This is commonly used to send data from the cache to various destinations.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_CYCLES_NE.BL_AG1",
      EventDef::Encoding{.code = 0x93, .umask = 0x40, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Not Empty; BL - Agent 1)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Empty.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the BL ring.  This is commonly used for transferring writeback data to the cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_CYCLES_NE.IV",
      EventDef::Encoding{.code = 0x93, .umask = 0x08, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Not Empty; IV)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Empty.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the IV ring.  This is commonly used for snoops to the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_INSERTS.AD_AG0",
      EventDef::Encoding{.code = 0x91, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Vert Egress Allocations; AD - Agent 0)",
      R"(Number of allocations into the Common Mesh Stop Egress.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the AD ring.  Some example include outbound requests, snoop requests, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_INSERTS.AD_AG1",
      EventDef::Encoding{.code = 0x91, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Vert Egress Allocations; AD - Agent 1)",
      R"(Number of allocations into the Common Mesh Stop Egress.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the AD ring.  This is commonly used for outbound requests.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_INSERTS.AK_AG0",
      EventDef::Encoding{.code = 0x91, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Vert Egress Allocations; AK - Agent 0)",
      R"(Number of allocations into the Common Mesh Stop Egress.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the AK ring.  This is commonly used for credit returns and GO responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_INSERTS.AK_AG1",
      EventDef::Encoding{.code = 0x91, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Vert Egress Allocations; AK - Agent 1)",
      R"(Number of allocations into the Common Mesh Stop Egress.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the AK ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_INSERTS.BL_AG0",
      EventDef::Encoding{.code = 0x91, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Vert Egress Allocations; BL - Agent 0)",
      R"(Number of allocations into the Common Mesh Stop Egress.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the BL ring.  This is commonly used to send data from the cache to various destinations.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_INSERTS.BL_AG1",
      EventDef::Encoding{.code = 0x91, .umask = 0x40, .msr_values = {0x00}},
      R"(CMS Vert Egress Allocations; BL - Agent 1)",
      R"(Number of allocations into the Common Mesh Stop Egress.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the BL ring.  This is commonly used for transferring writeback data to the cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_INSERTS.IV",
      EventDef::Encoding{.code = 0x91, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Vert Egress Allocations; IV)",
      R"(Number of allocations into the Common Mesh Stop Egress.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the IV ring.  This is commonly used for snoops to the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_NACK.AD_AG0",
      EventDef::Encoding{.code = 0x98, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Vertical Egress NACKs; AD - Agent 0)",
      R"(Counts number of Egress packets NACK'ed on to the Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_NACK.AD_AG1",
      EventDef::Encoding{.code = 0x98, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Vertical Egress NACKs; AD - Agent 1)",
      R"(Counts number of Egress packets NACK'ed on to the Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_NACK.AK_AG0",
      EventDef::Encoding{.code = 0x98, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Vertical Egress NACKs; AK - Agent 0)",
      R"(Counts number of Egress packets NACK'ed on to the Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_NACK.AK_AG1",
      EventDef::Encoding{.code = 0x98, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Vertical Egress NACKs; AK - Agent 1)",
      R"(Counts number of Egress packets NACK'ed on to the Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_NACK.BL_AG0",
      EventDef::Encoding{.code = 0x98, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Vertical Egress NACKs; BL - Agent 0)",
      R"(Counts number of Egress packets NACK'ed on to the Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_NACK.BL_AG1",
      EventDef::Encoding{.code = 0x98, .umask = 0x40, .msr_values = {0x00}},
      R"(CMS Vertical Egress NACKs; BL - Agent 1)",
      R"(Counts number of Egress packets NACK'ed on to the Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_OCCUPANCY.AD_AG0",
      EventDef::Encoding{.code = 0x90, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Vert Egress Occupancy; AD - Agent 0)",
      R"(Occupancy event for the Egress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the AD ring.  Some example include outbound requests, snoop requests, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_OCCUPANCY.AD_AG1",
      EventDef::Encoding{.code = 0x90, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Vert Egress Occupancy; AD - Agent 1)",
      R"(Occupancy event for the Egress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the AD ring.  This is commonly used for outbound requests.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_OCCUPANCY.AK_AG0",
      EventDef::Encoding{.code = 0x90, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Vert Egress Occupancy; AK - Agent 0)",
      R"(Occupancy event for the Egress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the AK ring.  This is commonly used for credit returns and GO responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_OCCUPANCY.AK_AG1",
      EventDef::Encoding{.code = 0x90, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Vert Egress Occupancy; AK - Agent 1)",
      R"(Occupancy event for the Egress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the AK ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_OCCUPANCY.BL_AG0",
      EventDef::Encoding{.code = 0x90, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Vert Egress Occupancy; BL - Agent 0)",
      R"(Occupancy event for the Egress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the BL ring.  This is commonly used to send data from the cache to various destinations.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_OCCUPANCY.BL_AG1",
      EventDef::Encoding{.code = 0x90, .umask = 0x40, .msr_values = {0x00}},
      R"(CMS Vert Egress Occupancy; BL - Agent 1)",
      R"(Occupancy event for the Egress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the BL ring.  This is commonly used for transferring writeback data to the cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_OCCUPANCY.IV",
      EventDef::Encoding{.code = 0x90, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Vert Egress Occupancy; IV)",
      R"(Occupancy event for the Egress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the IV ring.  This is commonly used for snoops to the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_STARVED.AD_AG0",
      EventDef::Encoding{.code = 0x9A, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Vertical Egress Injection Starvation; AD - Agent 0)",
      R"(Counts injection starvation.  This starvation is triggered when the CMS Egress cannot send a transaction onto the Vertical ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_STARVED.AD_AG1",
      EventDef::Encoding{.code = 0x9A, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Vertical Egress Injection Starvation; AD - Agent 1)",
      R"(Counts injection starvation.  This starvation is triggered when the CMS Egress cannot send a transaction onto the Vertical ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_STARVED.AK_AG0",
      EventDef::Encoding{.code = 0x9A, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Vertical Egress Injection Starvation; AK - Agent 0)",
      R"(Counts injection starvation.  This starvation is triggered when the CMS Egress cannot send a transaction onto the Vertical ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_STARVED.AK_AG1",
      EventDef::Encoding{.code = 0x9A, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Vertical Egress Injection Starvation; AK - Agent 1)",
      R"(Counts injection starvation.  This starvation is triggered when the CMS Egress cannot send a transaction onto the Vertical ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_STARVED.BL_AG0",
      EventDef::Encoding{.code = 0x9A, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Vertical Egress Injection Starvation; BL - Agent 0)",
      R"(Counts injection starvation.  This starvation is triggered when the CMS Egress cannot send a transaction onto the Vertical ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_TxR_VERT_STARVED.BL_AG1",
      EventDef::Encoding{.code = 0x9A, .umask = 0x40, .msr_values = {0x00}},
      R"(CMS Vertical Egress Injection Starvation; BL - Agent 1)",
      R"(Counts injection starvation.  This starvation is triggered when the CMS Egress cannot send a transaction onto the Vertical ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_VERT_RING_AD_IN_USE.DN_EVEN",
      EventDef::Encoding{.code = 0xA6, .umask = 0x04, .msr_values = {0x00}},
      R"(Vertical AD Ring In Use; Down and Even)",
      R"(Counts the number of cycles that the Vertical AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings  -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_VERT_RING_AD_IN_USE.DN_ODD",
      EventDef::Encoding{.code = 0xA6, .umask = 0x08, .msr_values = {0x00}},
      R"(Vertical AD Ring In Use; Down and Odd)",
      R"(Counts the number of cycles that the Vertical AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings  -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_VERT_RING_AD_IN_USE.UP_EVEN",
      EventDef::Encoding{.code = 0xA6, .umask = 0x01, .msr_values = {0x00}},
      R"(Vertical AD Ring In Use; Up and Even)",
      R"(Counts the number of cycles that the Vertical AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings  -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_VERT_RING_AD_IN_USE.UP_ODD",
      EventDef::Encoding{.code = 0xA6, .umask = 0x02, .msr_values = {0x00}},
      R"(Vertical AD Ring In Use; Up and Odd)",
      R"(Counts the number of cycles that the Vertical AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings  -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_VERT_RING_AK_IN_USE.DN_EVEN",
      EventDef::Encoding{.code = 0xA8, .umask = 0x04, .msr_values = {0x00}},
      R"(Vertical AK Ring In Use; Down and Even)",
      R"(Counts the number of cycles that the Vertical AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_VERT_RING_AK_IN_USE.DN_ODD",
      EventDef::Encoding{.code = 0xA8, .umask = 0x08, .msr_values = {0x00}},
      R"(Vertical AK Ring In Use; Down and Odd)",
      R"(Counts the number of cycles that the Vertical AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_VERT_RING_AK_IN_USE.UP_EVEN",
      EventDef::Encoding{.code = 0xA8, .umask = 0x01, .msr_values = {0x00}},
      R"(Vertical AK Ring In Use; Up and Even)",
      R"(Counts the number of cycles that the Vertical AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_VERT_RING_AK_IN_USE.UP_ODD",
      EventDef::Encoding{.code = 0xA8, .umask = 0x02, .msr_values = {0x00}},
      R"(Vertical AK Ring In Use; Up and Odd)",
      R"(Counts the number of cycles that the Vertical AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_VERT_RING_BL_IN_USE.DN_EVEN",
      EventDef::Encoding{.code = 0xAA, .umask = 0x04, .msr_values = {0x00}},
      R"(Vertical BL Ring in Use; Down and Even)",
      R"(Counts the number of cycles that the Vertical BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_VERT_RING_BL_IN_USE.DN_ODD",
      EventDef::Encoding{.code = 0xAA, .umask = 0x08, .msr_values = {0x00}},
      R"(Vertical BL Ring in Use; Down and Odd)",
      R"(Counts the number of cycles that the Vertical BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_VERT_RING_BL_IN_USE.UP_EVEN",
      EventDef::Encoding{.code = 0xAA, .umask = 0x01, .msr_values = {0x00}},
      R"(Vertical BL Ring in Use; Up and Even)",
      R"(Counts the number of cycles that the Vertical BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_VERT_RING_BL_IN_USE.UP_ODD",
      EventDef::Encoding{.code = 0xAA, .umask = 0x02, .msr_values = {0x00}},
      R"(Vertical BL Ring in Use; Up and Odd)",
      R"(Counts the number of cycles that the Vertical BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_VERT_RING_IV_IN_USE.DN",
      EventDef::Encoding{.code = 0xAC, .umask = 0x04, .msr_values = {0x00}},
      R"(Vertical IV Ring in Use; Down)",
      R"(Counts the number of cycles that the Vertical IV ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  There is only 1 IV ring.  Therefore, if one wants to monitor the Even ring, they should select both UP_EVEN and DN_EVEN.  To monitor the Odd ring, they should select both UP_ODD and DN_ODD.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m2m,
      "UNC_M2M_VERT_RING_IV_IN_USE.UP",
      EventDef::Encoding{.code = 0xAC, .umask = 0x01, .msr_values = {0x00}},
      R"(Vertical IV Ring in Use; Up)",
      R"(Counts the number of cycles that the Vertical IV ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  There is only 1 IV ring.  Therefore, if one wants to monitor the Even ring, they should select both UP_EVEN and DN_EVEN.  To monitor the Odd ring, they should select both UP_ODD and DN_ODD.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ1",
      EventDef::Encoding{.code = 0x18, .umask = 0x20, .msr_values = {0x00}},
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ1)",
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ2",
      EventDef::Encoding{.code = 0x18, .umask = 0x40, .msr_values = {0x00}},
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ2)",
      R"(UNC_UPI_FLOWQ_NO_VNA_CRD.AK_VNA_EQ2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_upi,
      "UNC_UPI_RxL_FLITS.IDLE",
      EventDef::Encoding{.code = 0x3, .umask = 0x47, .msr_values = {0x00}},
      R"(Valid Flits Received; Idle)",
      R"(Shows legal flit time (hides impact of L0p and L0c).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.IO",
      EventDef::Encoding{.code = 0x35, .umask = 0x34, .msr_values = {0x00}},
      R"(TOR Inserts; All from Local IO)",
      R"(Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.; All locally generated IO traffic)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.ALL_IO_IA",
      EventDef::Encoding{.code = 0x35, .umask = 0x35, .msr_values = {0x00}},
      R"(TOR Inserts; All from Local iA and IO)",
      R"(Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.; All locally initiated requests)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.ALL_HIT",
      EventDef::Encoding{.code = 0x35, .umask = 0x15, .msr_values = {0x00}},
      R"(TOR Inserts; Hits from Local)",
      R"(Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.ALL_MISS",
      EventDef::Encoding{.code = 0x35, .umask = 0x25, .msr_values = {0x00}},
      R"(TOR Inserts; Misses from Local)",
      R"(Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.IO",
      EventDef::Encoding{.code = 0x36, .umask = 0x34, .msr_values = {0x00}},
      R"(TOR Occupancy; All from Local IO)",
      R"(For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.   T; All locally generated IO traffic)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.IO_HIT",
      EventDef::Encoding{.code = 0x36, .umask = 0x14, .msr_values = {0x00}},
      R"(TOR Occupancy; Hits from Local IO)",
      R"(For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.   T)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.IO_MISS",
      EventDef::Encoding{.code = 0x36, .umask = 0x24, .msr_values = {0x00}},
      R"(TOR Occupancy; Misses from Local IO)",
      R"(For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.   T)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.ALL_HIT",
      EventDef::Encoding{.code = 0x36, .umask = 0x17, .msr_values = {0x00}},
      R"(TOR Occupancy; Hits from Local)",
      R"(For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.   T)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.ALL_MISS",
      EventDef::Encoding{.code = 0x36, .umask = 0x27, .msr_values = {0x00}},
      R"(TOR Occupancy; Misses from Local)",
      R"(For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.   T)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_UPI_CREDITS_ACQUIRED.VNA",
      EventDef::Encoding{.code = 0x38, .umask = 0x01, .msr_values = {0x00}},
      R"(UPI Ingress Credit Allocations; VNA Credits)",
      R"(Counts the number of UPI credits acquired for either the AD or BL ring.  In order to send snoops, snoop responses, requests, data, etc to the UPI agent on the ring, it is necessary to first acquire a credit for the UPI ingress buffer.  This can be used with the Credit Occupancy event in order to calculate average credit lifetime.  This event supports filtering to cover the VNA/VN0 credits and the different message classes.  Note that you must select the link that you would like to monitor using the link select register, and you can only monitor 1 link at a time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_UPI_CREDITS_ACQUIRED.VN0",
      EventDef::Encoding{.code = 0x38, .umask = 0x02, .msr_values = {0x00}},
      R"(UPI Ingress Credit Allocations; VN0 Credits)",
      R"(Counts the number of UPI credits acquired for either the AD or BL ring.  In order to send snoops, snoop responses, requests, data, etc to the UPI agent on the ring, it is necessary to first acquire a credit for the UPI ingress buffer.  This can be used with the Credit Occupancy event in order to calculate average credit lifetime.  This event supports filtering to cover the VNA/VN0 credits and the different message classes.  Note that you must select the link that you would like to monitor using the link select register, and you can only monitor 1 link at a time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_UPI_CREDITS_ACQUIRED.AD_REQ",
      EventDef::Encoding{.code = 0x38, .umask = 0x04, .msr_values = {0x00}},
      R"(UPI Ingress Credit Allocations; AD REQ Credits)",
      R"(Counts the number of UPI credits acquired for either the AD or BL ring.  In order to send snoops, snoop responses, requests, data, etc to the UPI agent on the ring, it is necessary to first acquire a credit for the UPI ingress buffer.  This can be used with the Credit Occupancy event in order to calculate average credit lifetime.  This event supports filtering to cover the VNA/VN0 credits and the different message classes.  Note that you must select the link that you would like to monitor using the link select register, and you can only monitor 1 link at a time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_UPI_CREDITS_ACQUIRED.AD_RSP",
      EventDef::Encoding{.code = 0x38, .umask = 0x08, .msr_values = {0x00}},
      R"(UPI Ingress Credit Allocations; AD RSP VN0 Credits)",
      R"(Counts the number of UPI credits acquired for either the AD or BL ring.  In order to send snoops, snoop responses, requests, data, etc to the UPI agent on the ring, it is necessary to first acquire a credit for the UPI ingress buffer.  This can be used with the Credit Occupancy event in order to calculate average credit lifetime.  This event supports filtering to cover the VNA/VN0 credits and the different message classes.  Note that you must select the link that you would like to monitor using the link select register, and you can only monitor 1 link at a time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_UPI_CREDITS_ACQUIRED.BL_RSP",
      EventDef::Encoding{.code = 0x38, .umask = 0x10, .msr_values = {0x00}},
      R"(UPI Ingress Credit Allocations; BL RSP Credits)",
      R"(Counts the number of UPI credits acquired for either the AD or BL ring.  In order to send snoops, snoop responses, requests, data, etc to the UPI agent on the ring, it is necessary to first acquire a credit for the UPI ingress buffer.  This can be used with the Credit Occupancy event in order to calculate average credit lifetime.  This event supports filtering to cover the VNA/VN0 credits and the different message classes.  Note that you must select the link that you would like to monitor using the link select register, and you can only monitor 1 link at a time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_UPI_CREDITS_ACQUIRED.BL_WB",
      EventDef::Encoding{.code = 0x38, .umask = 0x20, .msr_values = {0x00}},
      R"(UPI Ingress Credit Allocations; BL DRS Credits)",
      R"(Counts the number of UPI credits acquired for either the AD or BL ring.  In order to send snoops, snoop responses, requests, data, etc to the UPI agent on the ring, it is necessary to first acquire a credit for the UPI ingress buffer.  This can be used with the Credit Occupancy event in order to calculate average credit lifetime.  This event supports filtering to cover the VNA/VN0 credits and the different message classes.  Note that you must select the link that you would like to monitor using the link select register, and you can only monitor 1 link at a time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_UPI_CREDITS_ACQUIRED.BL_NCB",
      EventDef::Encoding{.code = 0x38, .umask = 0x40, .msr_values = {0x00}},
      R"(UPI Ingress Credit Allocations; BL NCB Credits)",
      R"(Counts the number of UPI credits acquired for either the AD or BL ring.  In order to send snoops, snoop responses, requests, data, etc to the UPI agent on the ring, it is necessary to first acquire a credit for the UPI ingress buffer.  This can be used with the Credit Occupancy event in order to calculate average credit lifetime.  This event supports filtering to cover the VNA/VN0 credits and the different message classes.  Note that you must select the link that you would like to monitor using the link select register, and you can only monitor 1 link at a time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_UPI_CREDITS_ACQUIRED.BL_NCS",
      EventDef::Encoding{.code = 0x38, .umask = 0x80, .msr_values = {0x00}},
      R"(UPI Ingress Credit Allocations; BL NCS Credits)",
      R"(Counts the number of UPI credits acquired for either the AD or BL ring.  In order to send snoops, snoop responses, requests, data, etc to the UPI agent on the ring, it is necessary to first acquire a credit for the UPI ingress buffer.  This can be used with the Credit Occupancy event in order to calculate average credit lifetime.  This event supports filtering to cover the VNA/VN0 credits and the different message classes.  Note that you must select the link that you would like to monitor using the link select register, and you can only monitor 1 link at a time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_UPI_CREDIT_OCCUPANCY.VNA_AD",
      EventDef::Encoding{.code = 0x3B, .umask = 0x01, .msr_values = {0x00}},
      R"(UPI Ingress Credits In Use Cycles; AD VNA Credits)",
      R"(Accumulates the number of UPI credits available in each cycle for either the AD or BL ring.  In order to send snoops, snoop responses, requests, data, etc to the UPI agent on the ring, it is necessary to first acquire a credit for the UPI ingress buffer.  This stat increments by the number of credits that are available each cycle.  This can be used in conjunction with the Credit Acquired event in order to calculate average credit lifetime.  This event supports filtering for the different types of credits that are available.  Note that you must select the link that you would like to monitor using the link select register, and you can only monitor 1 link at a time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_UPI_CREDIT_OCCUPANCY.VNA_BL",
      EventDef::Encoding{.code = 0x3B, .umask = 0x02, .msr_values = {0x00}},
      R"(UPI Ingress Credits In Use Cycles; BL VNA Credits)",
      R"(Accumulates the number of UPI credits available in each cycle for either the AD or BL ring.  In order to send snoops, snoop responses, requests, data, etc to the UPI agent on the ring, it is necessary to first acquire a credit for the UPI ingress buffer.  This stat increments by the number of credits that are available each cycle.  This can be used in conjunction with the Credit Acquired event in order to calculate average credit lifetime.  This event supports filtering for the different types of credits that are available.  Note that you must select the link that you would like to monitor using the link select register, and you can only monitor 1 link at a time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_UPI_CREDIT_OCCUPANCY.VN0_AD_REQ",
      EventDef::Encoding{.code = 0x3B, .umask = 0x04, .msr_values = {0x00}},
      R"(UPI Ingress Credits In Use Cycles; AD REQ VN0 Credits)",
      R"(Accumulates the number of UPI credits available in each cycle for either the AD or BL ring.  In order to send snoops, snoop responses, requests, data, etc to the UPI agent on the ring, it is necessary to first acquire a credit for the UPI ingress buffer.  This stat increments by the number of credits that are available each cycle.  This can be used in conjunction with the Credit Acquired event in order to calculate average credit lifetime.  This event supports filtering for the different types of credits that are available.  Note that you must select the link that you would like to monitor using the link select register, and you can only monitor 1 link at a time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_UPI_CREDIT_OCCUPANCY.VN0_AD_RSP",
      EventDef::Encoding{.code = 0x3B, .umask = 0x08, .msr_values = {0x00}},
      R"(UPI Ingress Credits In Use Cycles; AD RSP VN0 Credits)",
      R"(Accumulates the number of UPI credits available in each cycle for either the AD or BL ring.  In order to send snoops, snoop responses, requests, data, etc to the UPI agent on the ring, it is necessary to first acquire a credit for the UPI ingress buffer.  This stat increments by the number of credits that are available each cycle.  This can be used in conjunction with the Credit Acquired event in order to calculate average credit lifetime.  This event supports filtering for the different types of credits that are available.  Note that you must select the link that you would like to monitor using the link select register, and you can only monitor 1 link at a time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_UPI_CREDIT_OCCUPANCY.VN0_BL_RSP",
      EventDef::Encoding{.code = 0x3B, .umask = 0x10, .msr_values = {0x00}},
      R"(UPI Ingress Credits In Use Cycles; BL RSP VN0 Credits)",
      R"(Accumulates the number of UPI credits available in each cycle for either the AD or BL ring.  In order to send snoops, snoop responses, requests, data, etc to the UPI agent on the ring, it is necessary to first acquire a credit for the UPI ingress buffer.  This stat increments by the number of credits that are available each cycle.  This can be used in conjunction with the Credit Acquired event in order to calculate average credit lifetime.  This event supports filtering for the different types of credits that are available.  Note that you must select the link that you would like to monitor using the link select register, and you can only monitor 1 link at a time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_UPI_CREDIT_OCCUPANCY.VN0_BL_WB",
      EventDef::Encoding{.code = 0x3B, .umask = 0x20, .msr_values = {0x00}},
      R"(UPI Ingress Credits In Use Cycles; BL DRS VN0 Credits)",
      R"(Accumulates the number of UPI credits available in each cycle for either the AD or BL ring.  In order to send snoops, snoop responses, requests, data, etc to the UPI agent on the ring, it is necessary to first acquire a credit for the UPI ingress buffer.  This stat increments by the number of credits that are available each cycle.  This can be used in conjunction with the Credit Acquired event in order to calculate average credit lifetime.  This event supports filtering for the different types of credits that are available.  Note that you must select the link that you would like to monitor using the link select register, and you can only monitor 1 link at a time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_UPI_CREDIT_OCCUPANCY.VN0_BL_NCB",
      EventDef::Encoding{.code = 0x3B, .umask = 0x40, .msr_values = {0x00}},
      R"(UPI Ingress Credits In Use Cycles; BL NCB VN0 Credits)",
      R"(Accumulates the number of UPI credits available in each cycle for either the AD or BL ring.  In order to send snoops, snoop responses, requests, data, etc to the UPI agent on the ring, it is necessary to first acquire a credit for the UPI ingress buffer.  This stat increments by the number of credits that are available each cycle.  This can be used in conjunction with the Credit Acquired event in order to calculate average credit lifetime.  This event supports filtering for the different types of credits that are available.  Note that you must select the link that you would like to monitor using the link select register, and you can only monitor 1 link at a time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_AD_CREDITS_EMPTY.VNA",
      EventDef::Encoding{.code = 0x20, .umask = 0x1, .msr_values = {0x00}},
      R"(UPI0 AD Credits Empty; VNA)",
      R"(No credits available to send to UPIs on the AD Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_AD_CREDITS_EMPTY.VN0_REQ",
      EventDef::Encoding{.code = 0x20, .umask = 0x2, .msr_values = {0x00}},
      R"(UPI0 AD Credits Empty; VN0 REQ Messages)",
      R"(No credits available to send to UPIs on the AD Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_AD_CREDITS_EMPTY.VN0_SNP",
      EventDef::Encoding{.code = 0x20, .umask = 0x4, .msr_values = {0x00}},
      R"(UPI0 AD Credits Empty; VN0 SNP Messages)",
      R"(No credits available to send to UPIs on the AD Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_AD_CREDITS_EMPTY.VN0_RSP",
      EventDef::Encoding{.code = 0x20, .umask = 0x8, .msr_values = {0x00}},
      R"(UPI0 AD Credits Empty; VN0 RSP Messages)",
      R"(No credits available to send to UPIs on the AD Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_AD_CREDITS_EMPTY.VN1_REQ",
      EventDef::Encoding{.code = 0x20, .umask = 0x10, .msr_values = {0x00}},
      R"(UPI0 AD Credits Empty; VN1 REQ Messages)",
      R"(No credits available to send to UPIs on the AD Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_AD_CREDITS_EMPTY.VN1_SNP",
      EventDef::Encoding{.code = 0x20, .umask = 0x20, .msr_values = {0x00}},
      R"(UPI0 AD Credits Empty; VN1 SNP Messages)",
      R"(No credits available to send to UPIs on the AD Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_AD_CREDITS_EMPTY.VN1_RSP",
      EventDef::Encoding{.code = 0x20, .umask = 0x40, .msr_values = {0x00}},
      R"(UPI0 AD Credits Empty; VN1 RSP Messages)",
      R"(No credits available to send to UPIs on the AD Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_BL_CREDITS_EMPTY.VN1_RSP",
      EventDef::Encoding{.code = 0x21, .umask = 0x10, .msr_values = {0x00}},
      R"(UPI0 BL Credits Empty; VN1 REQ Messages)",
      R"(No credits available to send to UPI on the BL Ring (diff between non-SMI and SMI mode))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_BL_CREDITS_EMPTY.VN1_NCS_NCB",
      EventDef::Encoding{.code = 0x21, .umask = 0x20, .msr_values = {0x00}},
      R"(UPI0 BL Credits Empty; VN1 RSP Messages)",
      R"(No credits available to send to UPI on the BL Ring (diff between non-SMI and SMI mode))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_UPI_PEER_BL_CREDITS_EMPTY.VN1_WB",
      EventDef::Encoding{.code = 0x21, .umask = 0x40, .msr_values = {0x00}},
      R"(UPI0 BL Credits Empty; VN1 SNP Messages)",
      R"(No credits available to send to UPI on the BL Ring (diff between non-SMI and SMI mode))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SNPF_GRP1_VN1.VN0_PEER_UPI0",
      EventDef::Encoding{.code = 0x3C, .umask = 0x1, .msr_values = {0x00}},
      R"(Number of Snoop Targets; Peer UPI0 on VN0)",
      R"(Number of snpfanout targets and non-idle cycles can be used to calculate average snpfanout latency; Number of VN0 Snpf to peer UPI0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SNPF_GRP1_VN1.VN0_PEER_UPI1",
      EventDef::Encoding{.code = 0x3C, .umask = 0x2, .msr_values = {0x00}},
      R"(Number of Snoop Targets; Peer UPI1 on VN0)",
      R"(Number of snpfanout targets and non-idle cycles can be used to calculate average snpfanout latency; Number of VN0 Snpf to peer UPI1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SNPF_GRP1_VN1.VN1_PEER_UPI0",
      EventDef::Encoding{.code = 0x3C, .umask = 0x8, .msr_values = {0x00}},
      R"(Number of Snoop Targets; Peer UPI0 on VN1)",
      R"(Number of snpfanout targets and non-idle cycles can be used to calculate average snpfanout latency; Number of VN1 Snpf to peer UPI0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SNPF_GRP1_VN1.VN1_PEER_UPI1",
      EventDef::Encoding{.code = 0x3C, .umask = 0x10, .msr_values = {0x00}},
      R"(Number of Snoop Targets; Peer UPI1 on VN1)",
      R"(Number of snpfanout targets and non-idle cycles can be used to calculate average snpfanout latency; Number of VN1 Snpf to peer UPI1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ0_REJECT.AK_NON_UPI",
      EventDef::Encoding{.code = 0x22, .umask = 0x40, .msr_values = {0x00}},
      R"(Ingress Probe Queue Rejects; Non UPI AK Request)",
      R"(Ingress Probe Queue Rejects; Non UPI AK Request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ0_REJECT.IV_NON_UPI",
      EventDef::Encoding{.code = 0x22, .umask = 0x80, .msr_values = {0x00}},
      R"(Ingress Probe Queue Rejects; Non UPI IV Request)",
      R"(Ingress Probe Queue Rejects; Non UPI IV Request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.AK_NON_UPI",
      EventDef::Encoding{.code = 0x18, .umask = 0x40, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; Non UPI AK Request)",
      R"(Ingress (from CMS) Request Queue Rejects; Non UPI AK Request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.IV_NON_UPI",
      EventDef::Encoding{.code = 0x18, .umask = 0x80, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; Non UPI IV Request)",
      R"(Ingress (from CMS) Request Queue Rejects; Non UPI IV Request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.AK_NON_UPI",
      EventDef::Encoding{.code = 0x24, .umask = 0x40, .msr_values = {0x00}},
      R"(ISMQ Rejects; Non UPI AK Request)",
      R"(Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.IV_NON_UPI",
      EventDef::Encoding{.code = 0x24, .umask = 0x80, .msr_values = {0x00}},
      R"(ISMQ Rejects; Non UPI IV Request)",
      R"(Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.AK_NON_UPI",
      EventDef::Encoding{.code = 0x2C, .umask = 0x40, .msr_values = {0x00}},
      R"(ISMQ Retries; Non UPI AK Request)",
      R"(Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.IV_NON_UPI",
      EventDef::Encoding{.code = 0x2C, .umask = 0x80, .msr_values = {0x00}},
      R"(ISMQ Retries; Non UPI IV Request)",
      R"(Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.AK_NON_UPI",
      EventDef::Encoding{.code = 0x2E, .umask = 0x40, .msr_values = {0x00}},
      R"(Other Retries; Non UPI AK Request)",
      R"(Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.IV_NON_UPI",
      EventDef::Encoding{.code = 0x2E, .umask = 0x80, .msr_values = {0x00}},
      R"(Other Retries; Non UPI IV Request)",
      R"(Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.AK_NON_UPI",
      EventDef::Encoding{.code = 0x20, .umask = 0x40, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; Non UPI AK Request)",
      R"(Ingress (from CMS) Request Queue Rejects; Non UPI AK Request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.IV_NON_UPI",
      EventDef::Encoding{.code = 0x20, .umask = 0x80, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; Non UPI IV Request)",
      R"(Ingress (from CMS) Request Queue Rejects; Non UPI IV Request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.AK_NON_UPI",
      EventDef::Encoding{.code = 0x2A, .umask = 0x40, .msr_values = {0x00}},
      R"(Request Queue Retries; Non UPI AK Request)",
      R"(REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.IV_NON_UPI",
      EventDef::Encoding{.code = 0x2A, .umask = 0x80, .msr_values = {0x00}},
      R"(Request Queue Retries; Non UPI IV Request)",
      R"(REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ0_REJECT.AK_NON_UPI",
      EventDef::Encoding{.code = 0x26, .umask = 0x40, .msr_values = {0x00}},
      R"(RRQ Rejects; Non UPI AK Request)",
      R"(Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ0_REJECT.IV_NON_UPI",
      EventDef::Encoding{.code = 0x26, .umask = 0x80, .msr_values = {0x00}},
      R"(RRQ Rejects; Non UPI IV Request)",
      R"(Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ0_REJECT.AK_NON_UPI",
      EventDef::Encoding{.code = 0x28, .umask = 0x40, .msr_values = {0x00}},
      R"(WBQ Rejects; Non UPI AK Request)",
      R"(Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ0_REJECT.IV_NON_UPI",
      EventDef::Encoding{.code = 0x28, .umask = 0x80, .msr_values = {0x00}},
      R"(WBQ Rejects; Non UPI IV Request)",
      R"(Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BUSY_STARVED.AD_BNC",
      EventDef::Encoding{.code = 0xB4, .umask = 0x01, .msr_values = {0x00}},
      R"(Transgress Injection Starvation; AD - Bounce)",
      R"(Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, because a message from the other queue has higher priority)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BUSY_STARVED.BL_BNC",
      EventDef::Encoding{.code = 0xB4, .umask = 0x04, .msr_values = {0x00}},
      R"(Transgress Injection Starvation; BL - Bounce)",
      R"(Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, because a message from the other queue has higher priority)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BUSY_STARVED.AD_CRD",
      EventDef::Encoding{.code = 0xB4, .umask = 0x10, .msr_values = {0x00}},
      R"(Transgress Injection Starvation; AD - Credit)",
      R"(Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, because a message from the other queue has higher priority)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BUSY_STARVED.BL_CRD",
      EventDef::Encoding{.code = 0xB4, .umask = 0x40, .msr_values = {0x00}},
      R"(Transgress Injection Starvation; BL - Credit)",
      R"(Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, because a message from the other queue has higher priority)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BYPASS.AD_BNC",
      EventDef::Encoding{.code = 0xB2, .umask = 0x01, .msr_values = {0x00}},
      R"(Transgress Ingress Bypass; AD - Bounce)",
      R"(Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BYPASS.AK_BNC",
      EventDef::Encoding{.code = 0xB2, .umask = 0x02, .msr_values = {0x00}},
      R"(Transgress Ingress Bypass; AK - Bounce)",
      R"(Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BYPASS.BL_BNC",
      EventDef::Encoding{.code = 0xB2, .umask = 0x04, .msr_values = {0x00}},
      R"(Transgress Ingress Bypass; BL - Bounce)",
      R"(Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BYPASS.IV_BNC",
      EventDef::Encoding{.code = 0xB2, .umask = 0x08, .msr_values = {0x00}},
      R"(Transgress Ingress Bypass; IV - Bounce)",
      R"(Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BYPASS.AD_CRD",
      EventDef::Encoding{.code = 0xB2, .umask = 0x10, .msr_values = {0x00}},
      R"(Transgress Ingress Bypass; AD - Credit)",
      R"(Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_BYPASS.BL_CRD",
      EventDef::Encoding{.code = 0xB2, .umask = 0x40, .msr_values = {0x00}},
      R"(Transgress Ingress Bypass; BL - Credit)",
      R"(Number of packets bypassing the CMS Ingress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_CRD_STARVED.AD_BNC",
      EventDef::Encoding{.code = 0xB3, .umask = 0x01, .msr_values = {0x00}},
      R"(Transgress Injection Starvation; AD - Bounce)",
      R"(Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_CRD_STARVED.AK_BNC",
      EventDef::Encoding{.code = 0xB3, .umask = 0x02, .msr_values = {0x00}},
      R"(Transgress Injection Starvation; AK - Bounce)",
      R"(Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_CRD_STARVED.BL_BNC",
      EventDef::Encoding{.code = 0xB3, .umask = 0x04, .msr_values = {0x00}},
      R"(Transgress Injection Starvation; BL - Bounce)",
      R"(Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_CRD_STARVED.IV_BNC",
      EventDef::Encoding{.code = 0xB3, .umask = 0x08, .msr_values = {0x00}},
      R"(Transgress Injection Starvation; IV - Bounce)",
      R"(Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_CRD_STARVED.AD_CRD",
      EventDef::Encoding{.code = 0xB3, .umask = 0x10, .msr_values = {0x00}},
      R"(Transgress Injection Starvation; AD - Credit)",
      R"(Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_CRD_STARVED.BL_CRD",
      EventDef::Encoding{.code = 0xB3, .umask = 0x40, .msr_values = {0x00}},
      R"(Transgress Injection Starvation; BL - Credit)",
      R"(Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_CRD_STARVED.IFV",
      EventDef::Encoding{.code = 0xB3, .umask = 0x80, .msr_values = {0x00}},
      R"(Transgress Injection Starvation; IFV - Credit)",
      R"(Counts cycles under injection starvation mode.  This starvation is triggered when the CMS Ingress cannot send a transaction onto the mesh for a long period of time.  In this case, the Ingress is unable to forward to the Egress due to a lack of credit.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_INSERTS.AD_BNC",
      EventDef::Encoding{.code = 0xB1, .umask = 0x01, .msr_values = {0x00}},
      R"(Transgress Ingress Allocations; AD - Bounce)",
      R"(Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_INSERTS.AK_BNC",
      EventDef::Encoding{.code = 0xB1, .umask = 0x02, .msr_values = {0x00}},
      R"(Transgress Ingress Allocations; AK - Bounce)",
      R"(Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_INSERTS.BL_BNC",
      EventDef::Encoding{.code = 0xB1, .umask = 0x04, .msr_values = {0x00}},
      R"(Transgress Ingress Allocations; BL - Bounce)",
      R"(Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_INSERTS.IV_BNC",
      EventDef::Encoding{.code = 0xB1, .umask = 0x08, .msr_values = {0x00}},
      R"(Transgress Ingress Allocations; IV - Bounce)",
      R"(Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_INSERTS.AD_CRD",
      EventDef::Encoding{.code = 0xB1, .umask = 0x10, .msr_values = {0x00}},
      R"(Transgress Ingress Allocations; AD - Credit)",
      R"(Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_INSERTS.BL_CRD",
      EventDef::Encoding{.code = 0xB1, .umask = 0x40, .msr_values = {0x00}},
      R"(Transgress Ingress Allocations; BL - Credit)",
      R"(Number of allocations into the CMS Ingress  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_OCCUPANCY.AD_BNC",
      EventDef::Encoding{.code = 0xB0, .umask = 0x01, .msr_values = {0x00}},
      R"(Transgress Ingress Occupancy; AD - Bounce)",
      R"(Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_OCCUPANCY.AK_BNC",
      EventDef::Encoding{.code = 0xB0, .umask = 0x02, .msr_values = {0x00}},
      R"(Transgress Ingress Occupancy; AK - Bounce)",
      R"(Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_OCCUPANCY.BL_BNC",
      EventDef::Encoding{.code = 0xB0, .umask = 0x04, .msr_values = {0x00}},
      R"(Transgress Ingress Occupancy; BL - Bounce)",
      R"(Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_OCCUPANCY.IV_BNC",
      EventDef::Encoding{.code = 0xB0, .umask = 0x08, .msr_values = {0x00}},
      R"(Transgress Ingress Occupancy; IV - Bounce)",
      R"(Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_OCCUPANCY.AD_CRD",
      EventDef::Encoding{.code = 0xB0, .umask = 0x10, .msr_values = {0x00}},
      R"(Transgress Ingress Occupancy; AD - Credit)",
      R"(Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxR_OCCUPANCY.BL_CRD",
      EventDef::Encoding{.code = 0xB0, .umask = 0x40, .msr_values = {0x00}},
      R"(Transgress Ingress Occupancy; BL - Credit)",
      R"(Occupancy event for the Ingress buffers in the CMS  The Ingress is used to queue up requests received from the mesh)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XSNP_RESP.EXT_RSP_HITFSE",
      EventDef::Encoding{.code = 0x32, .umask = 0x21, .msr_values = {0x00}},
      R"(Core Cross Snoop Responses; External RspHitFSE)",
      R"(Counts the number of core cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type. This event can be filtered based on who triggered the initial snoop(s):  from Evictions, Core  or External (i.e. from a remote node) Requests.  And the event can be filtered based on the responses:  RspX_Fwd/HitY where Y is the state prior to the snoop response and X is the state following.; External Request - Response any to Hit F/S/E)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XSNP_RESP.CORE_RSP_HITFSE",
      EventDef::Encoding{.code = 0x32, .umask = 0x41, .msr_values = {0x00}},
      R"(Core Cross Snoop Responses; Core RspHitFSE)",
      R"(Counts the number of core cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type. This event can be filtered based on who triggered the initial snoop(s):  from Evictions, Core  or External (i.e. from a remote node) Requests.  And the event can be filtered based on the responses:  RspX_Fwd/HitY where Y is the state prior to the snoop response and X is the state following.; Core Request - Response any to Hit F/S/E)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XSNP_RESP.EVICT_RSP_HITFSE",
      EventDef::Encoding{.code = 0x32, .umask = 0x81, .msr_values = {0x00}},
      R"(Core Cross Snoop Responses; Evict RspHitFSE)",
      R"(Counts the number of core cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type. This event can be filtered based on who triggered the initial snoop(s):  from Evictions, Core  or External (i.e. from a remote node) Requests.  And the event can be filtered based on the responses:  RspX_Fwd/HitY where Y is the state prior to the snoop response and X is the state following.; Eviction Request - Response any to Hit F/S/E)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XSNP_RESP.ANY_RSP_HITFSE",
      EventDef::Encoding{.code = 0x32, .umask = 0xE1, .msr_values = {0x00}},
      R"(Core Cross Snoop Responses; Any RspHitFSE)",
      R"(Counts the number of core cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type. This event can be filtered based on who triggered the initial snoop(s):  from Evictions, Core  or External (i.e. from a remote node) Requests.  And the event can be filtered based on the responses:  RspX_Fwd/HitY where Y is the state prior to the snoop response and X is the state following.; Any Request - Response any to Hit F/S/E)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XSNP_RESP.EXT_RSPS_FWDFE",
      EventDef::Encoding{.code = 0x32, .umask = 0x22, .msr_values = {0x00}},
      R"(Core Cross Snoop Responses; External RspSFwdFE)",
      R"(Counts the number of core cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type. This event can be filtered based on who triggered the initial snoop(s):  from Evictions, Core  or External (i.e. from a remote node) Requests.  And the event can be filtered based on the responses:  RspX_Fwd/HitY where Y is the state prior to the snoop response and X is the state following.; External Request - Response S to Fwd F/E)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XSNP_RESP.CORE_RSPS_FWDFE",
      EventDef::Encoding{.code = 0x32, .umask = 0x42, .msr_values = {0x00}},
      R"(Core Cross Snoop Responses; Core RspSFwdFE)",
      R"(Counts the number of core cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type. This event can be filtered based on who triggered the initial snoop(s):  from Evictions, Core  or External (i.e. from a remote node) Requests.  And the event can be filtered based on the responses:  RspX_Fwd/HitY where Y is the state prior to the snoop response and X is the state following.; Core Request - Response S to Fwd F/E)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XSNP_RESP.EVICT_RSPS_FWDFE",
      EventDef::Encoding{.code = 0x32, .umask = 0x82, .msr_values = {0x00}},
      R"(Core Cross Snoop Responses; Evict RspSFwdFE)",
      R"(Counts the number of core cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type. This event can be filtered based on who triggered the initial snoop(s):  from Evictions, Core  or External (i.e. from a remote node) Requests.  And the event can be filtered based on the responses:  RspX_Fwd/HitY where Y is the state prior to the snoop response and X is the state following.; Eviction Request - Response S to Fwd F/E)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XSNP_RESP.ANY_RSPS_FWDFE",
      EventDef::Encoding{.code = 0x32, .umask = 0xE2, .msr_values = {0x00}},
      R"(Core Cross Snoop Responses; Any RspSFwdFE)",
      R"(Counts the number of core cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type. This event can be filtered based on who triggered the initial snoop(s):  from Evictions, Core  or External (i.e. from a remote node) Requests.  And the event can be filtered based on the responses:  RspX_Fwd/HitY where Y is the state prior to the snoop response and X is the state following.; Any Request - Response S to Fwd F/E)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XSNP_RESP.EXT_RSPI_FWDFE",
      EventDef::Encoding{.code = 0x32, .umask = 0x24, .msr_values = {0x00}},
      R"(Core Cross Snoop Responses; External RspIFwdFE)",
      R"(Counts the number of core cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type. This event can be filtered based on who triggered the initial snoop(s):  from Evictions, Core  or External (i.e. from a remote node) Requests.  And the event can be filtered based on the responses:  RspX_Fwd/HitY where Y is the state prior to the snoop response and X is the state following.; External Request - Response I to Fwd F/E)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XSNP_RESP.CORE_RSPI_FWDFE",
      EventDef::Encoding{.code = 0x32, .umask = 0x44, .msr_values = {0x00}},
      R"(Core Cross Snoop Responses; Core RspIFwdFE)",
      R"(Counts the number of core cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type. This event can be filtered based on who triggered the initial snoop(s):  from Evictions, Core  or External (i.e. from a remote node) Requests.  And the event can be filtered based on the responses:  RspX_Fwd/HitY where Y is the state prior to the snoop response and X is the state following.; Core Request - Response I to Fwd F/E)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XSNP_RESP.EVICT_RSPI_FWDFE",
      EventDef::Encoding{.code = 0x32, .umask = 0x84, .msr_values = {0x00}},
      R"(Core Cross Snoop Responses; Evict RspIFwdFE)",
      R"(Counts the number of core cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type. This event can be filtered based on who triggered the initial snoop(s):  from Evictions, Core  or External (i.e. from a remote node) Requests.  And the event can be filtered based on the responses:  RspX_Fwd/HitY where Y is the state prior to the snoop response and X is the state following.; Eviction Request - Response I to Fwd F/E)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XSNP_RESP.ANY_RSPI_FWDFE",
      EventDef::Encoding{.code = 0x32, .umask = 0xE4, .msr_values = {0x00}},
      R"(Core Cross Snoop Responses; Any RspIFwdFE)",
      R"(Counts the number of core cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type. This event can be filtered based on who triggered the initial snoop(s):  from Evictions, Core  or External (i.e. from a remote node) Requests.  And the event can be filtered based on the responses:  RspX_Fwd/HitY where Y is the state prior to the snoop response and X is the state following.; Any Request - Response I to Fwd F/E)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XSNP_RESP.EXT_RSPS_FWDM",
      EventDef::Encoding{.code = 0x32, .umask = 0x28, .msr_values = {0x00}},
      R"(Core Cross Snoop Responses; External RspSFwdM)",
      R"(Counts the number of core cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type. This event can be filtered based on who triggered the initial snoop(s):  from Evictions, Core  or External (i.e. from a remote node) Requests.  And the event can be filtered based on the responses:  RspX_Fwd/HitY where Y is the state prior to the snoop response and X is the state following.; External Request - Response S to Fwd M)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XSNP_RESP.CORE_RSPS_FWDM",
      EventDef::Encoding{.code = 0x32, .umask = 0x48, .msr_values = {0x00}},
      R"(Core Cross Snoop Responses; Core RspSFwdM)",
      R"(Counts the number of core cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type. This event can be filtered based on who triggered the initial snoop(s):  from Evictions, Core  or External (i.e. from a remote node) Requests.  And the event can be filtered based on the responses:  RspX_Fwd/HitY where Y is the state prior to the snoop response and X is the state following.; Core Request - Response S to Fwd M)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XSNP_RESP.EVICT_RSPS_FWDM",
      EventDef::Encoding{.code = 0x32, .umask = 0x88, .msr_values = {0x00}},
      R"(Core Cross Snoop Responses; Evict RspSFwdM)",
      R"(Counts the number of core cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type. This event can be filtered based on who triggered the initial snoop(s):  from Evictions, Core  or External (i.e. from a remote node) Requests.  And the event can be filtered based on the responses:  RspX_Fwd/HitY where Y is the state prior to the snoop response and X is the state following.; Eviction Request - Response S to Fwd M)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XSNP_RESP.ANY_RSPS_FWDM",
      EventDef::Encoding{.code = 0x32, .umask = 0xE8, .msr_values = {0x00}},
      R"(Core Cross Snoop Responses; Any RspSFwdM)",
      R"(Counts the number of core cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type. This event can be filtered based on who triggered the initial snoop(s):  from Evictions, Core  or External (i.e. from a remote node) Requests.  And the event can be filtered based on the responses:  RspX_Fwd/HitY where Y is the state prior to the snoop response and X is the state following.; Any Request - Response S to Fwd M)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XSNP_RESP.EXT_RSPI_FWDM",
      EventDef::Encoding{.code = 0x32, .umask = 0x30, .msr_values = {0x00}},
      R"(Core Cross Snoop Responses; External RspIFwdM)",
      R"(Counts the number of core cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type. This event can be filtered based on who triggered the initial snoop(s):  from Evictions, Core  or External (i.e. from a remote node) Requests.  And the event can be filtered based on the responses:  RspX_Fwd/HitY where Y is the state prior to the snoop response and X is the state following.; External Request - Response I to Fwd M)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XSNP_RESP.CORE_RSPI_FWDM",
      EventDef::Encoding{.code = 0x32, .umask = 0x50, .msr_values = {0x00}},
      R"(Core Cross Snoop Responses; Core RspIFwdM)",
      R"(Counts the number of core cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type. This event can be filtered based on who triggered the initial snoop(s):  from Evictions, Core  or External (i.e. from a remote node) Requests.  And the event can be filtered based on the responses:  RspX_Fwd/HitY where Y is the state prior to the snoop response and X is the state following.; Core Request - Response I to Fwd M)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XSNP_RESP.EVICT_RSPI_FWDM",
      EventDef::Encoding{.code = 0x32, .umask = 0x90, .msr_values = {0x00}},
      R"(Core Cross Snoop Responses; Evict RspIFwdM)",
      R"(Counts the number of core cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type. This event can be filtered based on who triggered the initial snoop(s):  from Evictions, Core  or External (i.e. from a remote node) Requests.  And the event can be filtered based on the responses:  RspX_Fwd/HitY where Y is the state prior to the snoop response and X is the state following.; Eviction Request - Response I to Fwd M)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_XSNP_RESP.ANY_RSPI_FWDM",
      EventDef::Encoding{.code = 0x32, .umask = 0xF0, .msr_values = {0x00}},
      R"(Core Cross Snoop Responses)",
      R"(Counts the number of core cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type. This event can be filtered based on who triggered the initial snoop(s):  from Evictions, Core  or External (i.e. from a remote node) Requests.  And the event can be filtered based on the responses:  RspX_Fwd/HitY where Y is the state prior to the snoop response and X is the state following.; Any Request - Response I to Fwd M)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.ANY0",
      EventDef::Encoding{.code = 0x2B, .umask = 0x01, .msr_values = {0x00}},
      R"(Request Queue Retries; ANY0)",
      R"(REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.HA",
      EventDef::Encoding{.code = 0x2B, .umask = 0x02, .msr_values = {0x00}},
      R"(Request Queue Retries; HA)",
      R"(REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.LLC_VICTIM",
      EventDef::Encoding{.code = 0x2B, .umask = 0x04, .msr_values = {0x00}},
      R"(Request Queue Retries; LLC Victim)",
      R"(REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.SF_VICTIM",
      EventDef::Encoding{.code = 0x2B, .umask = 0x08, .msr_values = {0x00}},
      R"(Request Queue Retries; SF Victim)",
      R"(REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.VICTIM",
      EventDef::Encoding{.code = 0x2B, .umask = 0x10, .msr_values = {0x00}},
      R"(Request Queue Retries; Victim)",
      R"(REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.LLC_OR_SF_WAY",
      EventDef::Encoding{.code = 0x2B, .umask = 0x20, .msr_values = {0x00}},
      R"(Request Queue Retries; Merging these two together to make room for ANY_REJECT_*0)",
      R"(REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.ALLOW_SNP",
      EventDef::Encoding{.code = 0x2B, .umask = 0x40, .msr_values = {0x00}},
      R"(Request Queue Retries; Allow Snoop)",
      R"(REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q1_RETRY.PA_MATCH",
      EventDef::Encoding{.code = 0x2B, .umask = 0x80, .msr_values = {0x00}},
      R"(Request Queue Retries; PhyAddr Match)",
      R"(REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_HIT.SHARED_OWNREQ",
      EventDef::Encoding{.code = 0x5F, .umask = 0x04, .msr_values = {0x00}},
      R"(Counts Number of Hits in HitMe Cache; Shared hit and op is RdInvOwn, RdInv, Inv*)",
      R"(Counts Number of Hits in HitMe Cache; Shared hit and op is RdInvOwn, RdInv, Inv*)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_HIT.WBMTOE",
      EventDef::Encoding{.code = 0x5F, .umask = 0x08, .msr_values = {0x00}},
      R"(Counts Number of Hits in HitMe Cache; op is WbMtoE)",
      R"(Counts Number of Hits in HitMe Cache; op is WbMtoE)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_HIT.WBMTOI_OR_S",
      EventDef::Encoding{.code = 0x5F, .umask = 0x10, .msr_values = {0x00}},
      R"(Counts Number of Hits in HitMe Cache; op is WbMtoI, WbPushMtoI, WbFlush, or WbMtoS)",
      R"(Counts Number of Hits in HitMe Cache; op is WbMtoI, WbPushMtoI, WbFlush, or WbMtoS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_LOOKUP.READ",
      EventDef::Encoding{.code = 0x5E, .umask = 0x01, .msr_values = {0x00}},
      R"(Counts Number of times HitMe Cache is accessed; op is RdCode, RdData, RdDataMigratory, RdCur, RdInvOwn, RdInv, Inv*)",
      R"(Counts Number of times HitMe Cache is accessed; op is RdCode, RdData, RdDataMigratory, RdCur, RdInvOwn, RdInv, Inv*)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_LOOKUP.WRITE",
      EventDef::Encoding{.code = 0x5E, .umask = 0x02, .msr_values = {0x00}},
      R"(Counts Number of times HitMe Cache is accessed; op is WbMtoE, WbMtoI, WbPushMtoI, WbFlush, or WbMtoS)",
      R"(Counts Number of times HitMe Cache is accessed; op is WbMtoE, WbMtoI, WbPushMtoI, WbFlush, or WbMtoS)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_MISS.SHARED_RDINVOWN",
      EventDef::Encoding{.code = 0x60, .umask = 0x20, .msr_values = {0x00}},
      R"(Counts Number of Misses in HitMe Cache; SF/LLC HitS/F and op is RdInvOwn)",
      R"(Counts Number of Misses in HitMe Cache; SF/LLC HitS/F and op is RdInvOwn)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_MISS.NOTSHARED_RDINVOWN",
      EventDef::Encoding{.code = 0x60, .umask = 0x40, .msr_values = {0x00}},
      R"(Counts Number of Misses in HitMe Cache; No SF/LLC HitS/F and op is RdInvOwn)",
      R"(Counts Number of Misses in HitMe Cache; No SF/LLC HitS/F and op is RdInvOwn)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_MISS.READ_OR_INV",
      EventDef::Encoding{.code = 0x60, .umask = 0x80, .msr_values = {0x00}},
      R"(Counts Number of Misses in HitMe Cache; op is RdCode, RdData, RdDataMigratory, RdCur, RdInv, Inv*)",
      R"(Counts Number of Misses in HitMe Cache; op is RdCode, RdData, RdDataMigratory, RdCur, RdInv, Inv*)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_UPDATE.DEALLOCATE_RSPFWDI_LOC",
      EventDef::Encoding{.code = 0x61, .umask = 0x01, .msr_values = {0x00}},
      R"(Counts the number of Allocate/Update to HitMe Cache; op is RspIFwd or RspIFwdWb for a local request)",
      R"(Received RspFwdI* for a local request, but converted HitME$ to SF entry)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_UPDATE.RSPFWDI_REM",
      EventDef::Encoding{.code = 0x61, .umask = 0x02, .msr_values = {0x00}},
      R"(Counts the number of Allocate/Update to HitMe Cache; op is RspIFwd or RspIFwdWb for a remote request)",
      R"(Updated HitME$ on RspFwdI* or local HitM/E received for a remote request)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_UPDATE.SHARED",
      EventDef::Encoding{.code = 0x61, .umask = 0x04, .msr_values = {0x00}},
      R"(Counts the number of Allocate/Update to HitMe Cache; Update HitMe Cache to SHARed)",
      R"(Counts the number of Allocate/Update to HitMe Cache; Update HitMe Cache to SHARed)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_UPDATE.RDINVOWN",
      EventDef::Encoding{.code = 0x61, .umask = 0x08, .msr_values = {0x00}},
      R"(Counts the number of Allocate/Update to HitMe Cache; Update HitMe Cache on RdInvOwn even if not RspFwdI*)",
      R"(Counts the number of Allocate/Update to HitMe Cache; Update HitMe Cache on RdInvOwn even if not RspFwdI*)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HITME_UPDATE.DEALLOCATE",
      EventDef::Encoding{.code = 0x61, .umask = 0x10, .msr_values = {0x00}},
      R"(Counts the number of Allocate/Update to HitMe Cache; Deallocate HitME$ on Reads without RspFwdI*)",
      R"(Counts the number of Allocate/Update to HitMe Cache; Deallocate HitME$ on Reads without RspFwdI*)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOPS_SENT.ALL",
      EventDef::Encoding{.code = 0x51, .umask = 0x01, .msr_values = {0x00}},
      R"(Snoops Sent; All)",
      R"(Counts the number of snoops issued by the HA.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOPS_SENT.LOCAL",
      EventDef::Encoding{.code = 0x51, .umask = 0x04, .msr_values = {0x00}},
      R"(Snoops Sent; Broadcast or directed Snoops sent for Local Requests)",
      R"(Counts the number of snoops issued by the HA.; Counts the number of broadcast or directed snoops issued by the HA per request. This filter includes only requests coming from the local socket.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOPS_SENT.REMOTE",
      EventDef::Encoding{.code = 0x51, .umask = 0x08, .msr_values = {0x00}},
      R"(Snoops Sent; Broadcast or directed Snoops sent for Remote Requests)",
      R"(Counts the number of snoops issued by the HA.; Counts the number of broadcast or directed snoops issued by the HA per request. This filter includes only requests coming from the remote socket.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOPS_SENT.BCST_LOCAL",
      EventDef::Encoding{.code = 0x51, .umask = 0x10, .msr_values = {0x00}},
      R"(Snoops Sent; Broadcast snoop for Local Requests)",
      R"(Counts the number of snoops issued by the HA.; Counts the number of broadcast snoops issued by the HA. This filter includes only requests coming from local sockets.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOPS_SENT.BCST_REMOTE",
      EventDef::Encoding{.code = 0x51, .umask = 0x20, .msr_values = {0x00}},
      R"(Snoops Sent; Broadcast snoops for Remote Requests)",
      R"(Counts the number of snoops issued by the HA.; Counts the number of broadcast snoops issued by the HA.This filter includes only requests coming from remote sockets.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOPS_SENT.DIRECT_LOCAL",
      EventDef::Encoding{.code = 0x51, .umask = 0x40, .msr_values = {0x00}},
      R"(Snoops Sent; Directed snoops for Local Requests)",
      R"(Counts the number of snoops issued by the HA.; Counts the number of directed snoops issued by the HA. This filter includes only requests coming from local sockets.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOPS_SENT.DIRECT_REMOTE",
      EventDef::Encoding{.code = 0x51, .umask = 0x80, .msr_values = {0x00}},
      R"(Snoops Sent; Directed snoops for Remote Requests)",
      R"(Counts the number of snoops issued by the HA.; Counts the number of directed snoops issued by the HA. This filter includes only requests coming from remote sockets.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSPI",
      EventDef::Encoding{.code = 0x5D, .umask = 0x01, .msr_values = {0x00}},
      R"(Snoop Responses Received Local; RspI)",
      R"(Number of snoop responses received for a Local  request; Filters for snoops responses of RspI to local CA requests.  RspI is returned when the remote cache does not have the data, or when the remote cache silently evicts data (such as when an RFO hits non-modified data).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSPS",
      EventDef::Encoding{.code = 0x5D, .umask = 0x02, .msr_values = {0x00}},
      R"(Snoop Responses Received Local; RspS)",
      R"(Number of snoop responses received for a Local  request; Filters for snoop responses of RspS to local CA requests.  RspS is returned when a remote cache has data but is not forwarding it.  It is a way to let the requesting socket know that it cannot allocate the data in E state.  No data is sent with S RspS.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSPIFWD",
      EventDef::Encoding{.code = 0x5D, .umask = 0x04, .msr_values = {0x00}},
      R"(Snoop Responses Received Local; RspIFwd)",
      R"(Number of snoop responses received for a Local  request; Filters for snoop responses of RspIFwd to local CA requests.  This is returned when a remote caching agent forwards data and the requesting agent is able to acquire the data in E or M states.  This is commonly returned with RFO transactions.  It can be either a HitM or a HitFE.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSPSFWD",
      EventDef::Encoding{.code = 0x5D, .umask = 0x08, .msr_values = {0x00}},
      R"(Snoop Responses Received Local; RspSFwd)",
      R"(Number of snoop responses received for a Local  request; Filters for a snoop response of RspSFwd to local CA requests.  This is returned when a remote caching agent forwards data but holds on to its current copy.  This is common for data and code reads that hit in a remote socket in E or F state.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSP_WB",
      EventDef::Encoding{.code = 0x5D, .umask = 0x10, .msr_values = {0x00}},
      R"(Snoop Responses Received Local; Rsp*WB)",
      R"(Number of snoop responses received for a Local  request; Filters for a snoop response of RspIWB or RspSWB to local CA requests.  This is returned when a non-RFO request hits in M state.  Data and Code Reads can return either RspIWB or RspSWB depending on how the system has been configured.  InvItoE transactions will also return RspIWB because they must acquire ownership.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSP_FWD_WB",
      EventDef::Encoding{.code = 0x5D, .umask = 0x20, .msr_values = {0x00}},
      R"(Snoop Responses Received Local; Rsp*FWD*WB)",
      R"(Number of snoop responses received for a Local  request; Filters for a snoop response of Rsp*Fwd*WB to local CA requests.  This snoop response is only used in 4s systems.  It is used when a snoop HITM's in a remote caching agent and it directly forwards data to a requestor, and simultaneously returns data to the home to be written back to memory.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSPCNFLCT",
      EventDef::Encoding{.code = 0x5D, .umask = 0x40, .msr_values = {0x00}},
      R"(Snoop Responses Received Local; RspCnflct)",
      R"(Number of snoop responses received for a Local  request; Filters for snoops responses of RspConflict to local CA requests.  This is returned when a snoop finds an existing outstanding transaction in a remote caching agent when it CAMs that caching agent.  This triggers conflict resolution hardware.  This covers both RspCnflct and RspCnflctWbI.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP_LOCAL.RSPFWD",
      EventDef::Encoding{.code = 0x5D, .umask = 0x80, .msr_values = {0x00}},
      R"(Snoop Responses Received Local; RspFwd)",
      R"(Number of snoop responses received for a Local  request; Filters for a snoop response of RspFwd to local CA requests.  This snoop response is only possible for RdCur when a snoop HITM/E in a remote caching agent and it directly forwards data to a requestor without changing the requestor's cache line state.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_NACK.AD_AG0",
      EventDef::Encoding{.code = 0x98, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Vertical Egress NACKs; AD - Agent 0)",
      R"(Counts number of Egress packets NACK'ed on to the Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_NACK.AK_AG0",
      EventDef::Encoding{.code = 0x98, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Vertical Egress NACKs; AK - Agent 0)",
      R"(Counts number of Egress packets NACK'ed on to the Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_NACK.BL_AG0",
      EventDef::Encoding{.code = 0x98, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Vertical Egress NACKs; BL - Agent 0)",
      R"(Counts number of Egress packets NACK'ed on to the Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_NACK.IV",
      EventDef::Encoding{.code = 0x98, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Vertical Egress NACKs; IV)",
      R"(Counts number of Egress packets NACK'ed on to the Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_NACK.AD_AG1",
      EventDef::Encoding{.code = 0x98, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Vertical Egress NACKs; AD - Agent 1)",
      R"(Counts number of Egress packets NACK'ed on to the Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_NACK.AK_AG1",
      EventDef::Encoding{.code = 0x98, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Vertical Egress NACKs; AK - Agent 1)",
      R"(Counts number of Egress packets NACK'ed on to the Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_NACK.BL_AG1",
      EventDef::Encoding{.code = 0x98, .umask = 0x40, .msr_values = {0x00}},
      R"(CMS Vertical Egress NACKs; BL - Agent 1)",
      R"(Counts number of Egress packets NACK'ed on to the Vertical Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_STARVED.AD_AG0",
      EventDef::Encoding{.code = 0x9A, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Vertical Egress Injection Starvation; AD - Agent 0)",
      R"(Counts injection starvation.  This starvation is triggered when the CMS Egress cannot send a transaction onto the Vertical ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_STARVED.AK_AG0",
      EventDef::Encoding{.code = 0x9A, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Vertical Egress Injection Starvation; AK - Agent 0)",
      R"(Counts injection starvation.  This starvation is triggered when the CMS Egress cannot send a transaction onto the Vertical ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_STARVED.BL_AG0",
      EventDef::Encoding{.code = 0x9A, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Vertical Egress Injection Starvation; BL - Agent 0)",
      R"(Counts injection starvation.  This starvation is triggered when the CMS Egress cannot send a transaction onto the Vertical ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_STARVED.IV",
      EventDef::Encoding{.code = 0x9A, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Vertical Egress Injection Starvation; IV)",
      R"(Counts injection starvation.  This starvation is triggered when the CMS Egress cannot send a transaction onto the Vertical ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_STARVED.AD_AG1",
      EventDef::Encoding{.code = 0x9A, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Vertical Egress Injection Starvation; AD - Agent 1)",
      R"(Counts injection starvation.  This starvation is triggered when the CMS Egress cannot send a transaction onto the Vertical ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_STARVED.AK_AG1",
      EventDef::Encoding{.code = 0x9A, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Vertical Egress Injection Starvation; AK - Agent 1)",
      R"(Counts injection starvation.  This starvation is triggered when the CMS Egress cannot send a transaction onto the Vertical ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_STARVED.BL_AG1",
      EventDef::Encoding{.code = 0x9A, .umask = 0x40, .msr_values = {0x00}},
      R"(CMS Vertical Egress Injection Starvation; BL - Agent 1)",
      R"(Counts injection starvation.  This starvation is triggered when the CMS Egress cannot send a transaction onto the Vertical ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CMS_CLOCKTICKS",
      EventDef::Encoding{.code = 0xC0, .umask = 0x0, .msr_values = {0x00}},
      R"(CMS Clockticks)",
      R"(CMS Clockticks)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_BYPASS_CHA_IMC.TAKEN",
      EventDef::Encoding{.code = 0x57, .umask = 0x01, .msr_values = {0x00}},
      R"(CHA to iMC Bypass; Taken)",
      R"(Counts the number of times when the CHA was able to bypass HA pipe on the way to iMC.  This is a latency optimization for situations when there is light loadings on the memory subsystem.  This can be filtered by when the bypass was taken and when it was not.; Filter for transactions that succeeded in taking the full bypass.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_BYPASS_CHA_IMC.INTERMEDIATE",
      EventDef::Encoding{.code = 0x57, .umask = 0x02, .msr_values = {0x00}},
      R"(CHA to iMC Bypass; Intermediate bypass Taken)",
      R"(Counts the number of times when the CHA was able to bypass HA pipe on the way to iMC.  This is a latency optimization for situations when there is light loadings on the memory subsystem.  This can be filtered by when the bypass was taken and when it was not.; Filter for transactions that succeeded in taking the intermediate bypass.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_BYPASS_CHA_IMC.NOT_TAKEN",
      EventDef::Encoding{.code = 0x57, .umask = 0x04, .msr_values = {0x00}},
      R"(CHA to iMC Bypass; Not Taken)",
      R"(Counts the number of times when the CHA was able to bypass HA pipe on the way to iMC.  This is a latency optimization for situations when there is light loadings on the memory subsystem.  This can be filtered by when the bypass was taken and when it was not.; Filter for transactions that could not take the bypass, and issues a read to memory. Note that transactions that did not take the bypass but did not issue read to memory will not be counted.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.EXT_ONE",
      EventDef::Encoding{.code = 0x33, .umask = 0x21, .msr_values = {0x00}},
      R"(Core Cross Snoops Issued; Single External Snoops)",
      R"(Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.CORE_ONE",
      EventDef::Encoding{.code = 0x33, .umask = 0x41, .msr_values = {0x00}},
      R"(Core Cross Snoops Issued; Single Core Requests)",
      R"(Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.EVICT_ONE",
      EventDef::Encoding{.code = 0x33, .umask = 0x81, .msr_values = {0x00}},
      R"(Core Cross Snoops Issued; Single Eviction)",
      R"(Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.ANY_ONE",
      EventDef::Encoding{.code = 0x33, .umask = 0xE1, .msr_values = {0x00}},
      R"(Core Cross Snoops Issued; Any Single Snoop)",
      R"(Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.EXT_GTONE",
      EventDef::Encoding{.code = 0x33, .umask = 0x22, .msr_values = {0x00}},
      R"(Core Cross Snoops Issued; Multiple External Snoops)",
      R"(Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.ANY_GTONE",
      EventDef::Encoding{.code = 0x33, .umask = 0xE2, .msr_values = {0x00}},
      R"(Core Cross Snoops Issued; Any Cycle with Multiple Snoops)",
      R"(Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.EXT_REMOTE",
      EventDef::Encoding{.code = 0x33, .umask = 0x24, .msr_values = {0x00}},
      R"(Core Cross Snoops Issued; External Snoop to Remote Node)",
      R"(Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.CORE_REMOTE",
      EventDef::Encoding{.code = 0x33, .umask = 0x44, .msr_values = {0x00}},
      R"(Core Cross Snoops Issued; Core Request to Remote Node)",
      R"(Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.EVICT_REMOTE",
      EventDef::Encoding{.code = 0x33, .umask = 0x84, .msr_values = {0x00}},
      R"(Core Cross Snoops Issued; Eviction to Remote Node)",
      R"(Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_SNP.ANY_REMOTE",
      EventDef::Encoding{.code = 0x33, .umask = 0xE4, .msr_values = {0x00}},
      R"(Core Cross Snoops Issued; Any Snoop to Remote Node)",
      R"(Counts the number of transactions that trigger a configurable number of cross snoops.  Cores are snooped if the transaction looks up the cache and determines that it is necessary based on the operation type and what CoreValid bits are set.  For example, if 2 CV bits are set on a data read, the cores must have the data in S state so it is not necessary to snoop them.  However, if only 1 CV bit is set the core my have modified the data.  If the transaction was an RFO, it would need to invalidate the lines.  This event can be filtered based on who triggered the initial snoop(s).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_COUNTER0_OCCUPANCY",
      EventDef::Encoding{.code = 0x1F, .umask = 0x00, .msr_values = {0x00}},
      R"(Counter 0 Occupancy)",
      R"(Since occupancy counts can only be captured in the Cbo's 0 counter, this event allows a user to capture occupancy related information by filtering the Cb0 occupancy count captured in Counter 0.   The filtering available is found in the control register - threshold, invert and edge detect.   E.g. setting threshold to 1 can effectively monitor how many cycles the monitored queue has an entry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_IMC_READS_COUNT.PRIORITY",
      EventDef::Encoding{.code = 0x59, .umask = 0x02, .msr_values = {0x00}},
      R"(HA to iMC Reads Issued; ISOCH)",
      R"(Count of the number of reads issued to any of the memory controller channels.  This can be filtered by the priority of the reads.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_IMC_WRITES_COUNT.PARTIAL",
      EventDef::Encoding{.code = 0x5B, .umask = 0x02, .msr_values = {0x00}},
      R"(Writes Issued to the iMC by the HA; Partial Non-ISOCH)",
      R"(Counts the total number of writes issued from the HA into the memory controller.  This counts for all four channels.  It can be filtered by full/partial and ISOCH/non-ISOCH.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_IMC_WRITES_COUNT.FULL_PRIORITY",
      EventDef::Encoding{.code = 0x5B, .umask = 0x04, .msr_values = {0x00}},
      R"(Writes Issued to the iMC by the HA; ISOCH Full Line)",
      R"(Counts the total number of writes issued from the HA into the memory controller.  This counts for all four channels.  It can be filtered by full/partial and ISOCH/non-ISOCH.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_IMC_WRITES_COUNT.PARTIAL_PRIORITY",
      EventDef::Encoding{.code = 0x5B, .umask = 0x08, .msr_values = {0x00}},
      R"(Writes Issued to the iMC by the HA; ISOCH Partial)",
      R"(Counts the total number of writes issued from the HA into the memory controller.  This counts for all four channels.  It can be filtered by full/partial and ISOCH/non-ISOCH.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_IMC_WRITES_COUNT.FULL_MIG",
      EventDef::Encoding{.code = 0x5B, .umask = 0x10, .msr_values = {0x00}},
      R"(Writes Issued to the iMC by the HA; Full Line MIG)",
      R"(Counts the total number of writes issued from the HA into the memory controller.  This counts for all four channels.  It can be filtered by full/partial and ISOCH/non-ISOCH.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_IMC_WRITES_COUNT.PARTIAL_MIG",
      EventDef::Encoding{.code = 0x5B, .umask = 0x20, .msr_values = {0x00}},
      R"(Writes Issued to the iMC by the HA; Partial MIG)",
      R"(Counts the total number of writes issued from the HA into the memory controller.  This counts for all four channels.  It can be filtered by full/partial and ISOCH/non-ISOCH.; Filter for memory controller 5 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_IODC_ALLOC.INVITOM",
      EventDef::Encoding{.code = 0x62, .umask = 0x01, .msr_values = {0x00}},
      R"(Counts Number of times IODC entry allocation is attempted; Number of IODC allocations)",
      R"(Counts Number of times IODC entry allocation is attempted; Number of IODC allocations)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_IODC_ALLOC.IODCFULL",
      EventDef::Encoding{.code = 0x62, .umask = 0x02, .msr_values = {0x00}},
      R"(Counts Number of times IODC entry allocation is attempted; Number of IODC allocations dropped due to IODC Full)",
      R"(Counts Number of times IODC entry allocation is attempted; Number of IODC allocations dropped due to IODC Full)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_IODC_ALLOC.OSBGATED",
      EventDef::Encoding{.code = 0x62, .umask = 0x04, .msr_values = {0x00}},
      R"(Counts Number of times IODC entry allocation is attempted; Number of IDOC allocation dropped due to OSB gate)",
      R"(Counts Number of times IODC entry allocation is attempted; Number of IDOC allocation dropped due to OSB gate)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_IODC_DEALLOC.WBMTOE",
      EventDef::Encoding{.code = 0x63, .umask = 0x01, .msr_values = {0x00}},
      R"(Counts number of IODC deallocations; IODC deallocated due to WbMtoE)",
      R"(Counts number of IODC deallocations; IODC deallocated due to WbMtoE)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_IODC_DEALLOC.WBMTOI",
      EventDef::Encoding{.code = 0x63, .umask = 0x02, .msr_values = {0x00}},
      R"(Counts number of IODC deallocations; IODC deallocated due to WbMtoI)",
      R"(Counts number of IODC deallocations; IODC deallocated due to WbMtoI)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_IODC_DEALLOC.WBPUSHMTOI",
      EventDef::Encoding{.code = 0x63, .umask = 0x04, .msr_values = {0x00}},
      R"(Counts number of IODC deallocations; IODC deallocated due to WbPushMtoI)",
      R"(Moved to Cbo section)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_IODC_DEALLOC.SNPOUT",
      EventDef::Encoding{.code = 0x63, .umask = 0x08, .msr_values = {0x00}},
      R"(Counts number of IODC deallocations; IODC deallocated due to conflicting transaction)",
      R"(Counts number of IODC deallocations; IODC deallocated due to conflicting transaction)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_IODC_DEALLOC.ALL",
      EventDef::Encoding{.code = 0x63, .umask = 0x10, .msr_values = {0x00}},
      R"(Counts number of IODC deallocations; IODC deallocated due to any reason)",
      R"(Counts number of IODC deallocations; IODC deallocated due to any reason)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_MISC.RSPI_WAS_FSE",
      EventDef::Encoding{.code = 0x39, .umask = 0x01, .msr_values = {0x00}},
      R"(Cbo Misc; Silent Snoop Eviction)",
      R"(Miscellaneous events in the Cbo.; Counts the number of times when a Snoop hit in FSE states and triggered a silent eviction.  This is useful because this information is lost in the PRE encodings.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_MISC.WC_ALIASING",
      EventDef::Encoding{.code = 0x39, .umask = 0x02, .msr_values = {0x00}},
      R"(Cbo Misc; Write Combining Aliasing)",
      R"(Miscellaneous events in the Cbo.; Counts the number of times that a USWC write (WCIL(F)) transaction hit in the LLC in M state, triggering a WBMtoI followed by the USWC write.  This occurs when there is WC aliasing.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_MISC.CV0_PREF_VIC",
      EventDef::Encoding{.code = 0x39, .umask = 0x10, .msr_values = {0x00}},
      R"(Cbo Misc; CV0 Prefetch Victim)",
      R"(Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_MISC.CV0_PREF_MISS",
      EventDef::Encoding{.code = 0x39, .umask = 0x20, .msr_values = {0x00}},
      R"(Cbo Misc; CV0 Prefetch Miss)",
      R"(Miscellaneous events in the Cbo.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_OSB",
      EventDef::Encoding{.code = 0x55, .umask = 0x00, .msr_values = {0x00}},
      R"(OSB Snoop Broadcast)",
      R"(Count of OSB snoop broadcasts. Counts by 1 per request causing OSB snoops to be broadcast. Does not count all the snoops generated by OSB.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC0_SMI0",
      EventDef::Encoding{.code = 0x58, .umask = 0x01, .msr_values = {0x00}},
      R"(CHA iMC CHNx READ Credits Empty; MC0_SMI0)",
      R"(Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue.; Filter for memory controller 0 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.MC1_SMI1",
      EventDef::Encoding{.code = 0x58, .umask = 0x02, .msr_values = {0x00}},
      R"(CHA iMC CHNx READ Credits Empty; MC1_SMI1)",
      R"(Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue.; Filter for memory controller 1 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.EDC0_SMI2",
      EventDef::Encoding{.code = 0x58, .umask = 0x04, .msr_values = {0x00}},
      R"(CHA iMC CHNx READ Credits Empty; EDC0_SMI2)",
      R"(Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue.; Filter for memory controller 2 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.EDC1_SMI3",
      EventDef::Encoding{.code = 0x58, .umask = 0x08, .msr_values = {0x00}},
      R"(CHA iMC CHNx READ Credits Empty; EDC1_SMI3)",
      R"(Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue.; Filter for memory controller 3 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.EDC2_SMI4",
      EventDef::Encoding{.code = 0x58, .umask = 0x10, .msr_values = {0x00}},
      R"(CHA iMC CHNx READ Credits Empty; EDC2_SMI4)",
      R"(Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue.; Filter for memory controller 4 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_READ_NO_CREDITS.EDC3_SMI5",
      EventDef::Encoding{.code = 0x58, .umask = 0x20, .msr_values = {0x00}},
      R"(CHA iMC CHNx READ Credits Empty; EDC3_SMI5)",
      R"(Counts the number of times when there are no credits available for sending reads from the CHA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's AD Ingress queue.; Filter for memory controller 5 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_REQUESTS.WRITES_REMOTE",
      EventDef::Encoding{.code = 0x50, .umask = 0x08, .msr_values = {0x00}},
      R"(Read and Write Requests; Writes Remote)",
      R"(Counts the total number of read requests made into the Home Agent. Reads include all read opcodes (including RFO).  Writes include all writes (streaming, evictions, HitM, etc).)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP.RSPS",
      EventDef::Encoding{.code = 0x5C, .umask = 0x02, .msr_values = {0x00}},
      R"(Snoop Responses Received : RspS)",
      R"(Snoop Responses Received : RspS : Counts the total number of RspI snoop responses received.  Whenever a snoops are issued, one or more snoop responses will be returned depending on the topology of the system.   In systems larger than 2s, when multiple snoops are returned this will count all the snoops that are received.  For example, if 3 snoops were issued and returned RspI, RspS, and RspSFwd; then each of these sub-events would increment by 1. : Filters for snoop responses of RspS.  RspS is returned when a remote cache has data but is not forwarding it.  It is a way to let the requesting socket know that it cannot allocate the data in E state.  No data is sent with S RspS.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_SNOOP_RESP.RSPFWD",
      EventDef::Encoding{.code = 0x5C, .umask = 0x80, .msr_values = {0x00}},
      R"(Snoop Responses Received; RspFwd)",
      R"(Counts the total number of RspI snoop responses received.  Whenever a snoops are issued, one or more snoop responses will be returned depending on the topology of the system.   In systems larger than 2s, when multiple snoops are returned this will count all the snoops that are received.  For example, if 3 snoops were issued and returned RspI, RspS, and RspSFwd; then each of these sub-events would increment by 1.; Filters for a snoop response of RspFwd to a CA request.  This snoop response is only possible for RdCur when a snoop HITM/E in a remote caching agent and it directly forwards data to a requestor without changing the requestor's cache line state.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WB_PUSH_MTOI.LLC",
      EventDef::Encoding{.code = 0x56, .umask = 0x01, .msr_values = {0x00}},
      R"(WbPushMtoI; Pushed to LLC)",
      R"(Counts the number of times when the CHA was received WbPushMtoI; Counts the number of times when the CHA was able to push WbPushMToI to LLC)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WB_PUSH_MTOI.MEM",
      EventDef::Encoding{.code = 0x56, .umask = 0x02, .msr_values = {0x00}},
      R"(WbPushMtoI; Pushed to Memory)",
      R"(Counts the number of times when the CHA was received WbPushMtoI; Counts the number of times when the CHA was unable to push WbPushMToI to LLC (hence pushed it to MEM))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC0_SMI0",
      EventDef::Encoding{.code = 0x5A, .umask = 0x01, .msr_values = {0x00}},
      R"(CHA iMC CHNx WRITE Credits Empty; MC0_SMI0)",
      R"(Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue.; Filter for memory controller 0 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.MC1_SMI1",
      EventDef::Encoding{.code = 0x5A, .umask = 0x02, .msr_values = {0x00}},
      R"(CHA iMC CHNx WRITE Credits Empty; MC1_SMI1)",
      R"(Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue.; Filter for memory controller 1 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.EDC0_SMI2",
      EventDef::Encoding{.code = 0x5A, .umask = 0x04, .msr_values = {0x00}},
      R"(CHA iMC CHNx WRITE Credits Empty; EDC0_SMI2)",
      R"(Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue.; Filter for memory controller 2 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.EDC1_SMI3",
      EventDef::Encoding{.code = 0x5A, .umask = 0x08, .msr_values = {0x00}},
      R"(CHA iMC CHNx WRITE Credits Empty; EDC1_SMI3)",
      R"(Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue.; Filter for memory controller 3 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.EDC2_SMI4",
      EventDef::Encoding{.code = 0x5A, .umask = 0x10, .msr_values = {0x00}},
      R"(CHA iMC CHNx WRITE Credits Empty; EDC2_SMI4)",
      R"(Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue.; Filter for memory controller 4 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_WRITE_NO_CREDITS.EDC3_SMI5",
      EventDef::Encoding{.code = 0x5A, .umask = 0x20, .msr_values = {0x00}},
      R"(CHA iMC CHNx WRITE Credits Empty; EDC3_SMI5)",
      R"(Counts the number of times when there are no credits available for sending WRITEs from the CHA into the iMC.  In order to send WRITEs into the memory controller, the HA must first acquire a credit for the iMC's BL Ingress queue.; Filter for memory controller 5 only.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.DATA_READ",
      EventDef::Encoding{.code = 0x34, .umask = 0x03, .msr_values = {0x00}},
      R"(Cache and Snoop Filter Lookups; Data Read Request)",
      R"(Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS set umask bit 0 and select a state or states to match.  Otherwise, the event will count nothing.   CHAFilter0[24:21,17] bits correspond to [FMESI] state.; Read transactions)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.WRITE",
      EventDef::Encoding{.code = 0x34, .umask = 0x05, .msr_values = {0x00}},
      R"(Cache and Snoop Filter Lookups; Write Requests)",
      R"(Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS set umask bit 0 and select a state or states to match.  Otherwise, the event will count nothing.   CHAFilter0[24:21,17] bits correspond to [FMESI] state.; Writeback transactions from L2 to the LLC  This includes all write transactions -- both Cacheable and UC.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.REMOTE_SNOOP",
      EventDef::Encoding{.code = 0x34, .umask = 0x09, .msr_values = {0x00}},
      R"(Cache and Snoop Filter Lookups; External Snoop Request)",
      R"(Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS set umask bit 0 and select a state or states to match.  Otherwise, the event will count nothing.   CHAFilter0[24:21,17] bits correspond to [FMESI] state.; Filters for only snoop requests coming from the remote socket(s) through the IPQ.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.ANY",
      EventDef::Encoding{.code = 0x34, .umask = 0x11, .msr_values = {0x00}},
      R"(Cache and Snoop Filter Lookups; Any Request)",
      R"(Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS set umask bit 0 and select a state or states to match.  Otherwise, the event will count nothing.   CHAFilter0[24:21,17] bits correspond to [FMESI] state.; Filters for any transaction originating from the IPQ or IRQ.  This does not include lookups originating from the ISMQ.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.LOCAL",
      EventDef::Encoding{.code = 0x34, .umask = 0x31, .msr_values = {0x00}},
      R"(Cache and Snoop Filter Lookups; Local)",
      R"(Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS set umask bit 0 and select a state or states to match.  Otherwise, the event will count nothing.   CHAFilter0[24:21,17] bits correspond to [FMESI] state.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_LOOKUP.REMOTE",
      EventDef::Encoding{.code = 0x34, .umask = 0x91, .msr_values = {0x00}},
      R"(Cache and Snoop Filter Lookups; Remote)",
      R"(Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS set umask bit 0 and select a state or states to match.  Otherwise, the event will count nothing.   CHAFilter0[24:21,17] bits correspond to [FMESI] state.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_LLC_VICTIMS.LOCAL_ALL",
      EventDef::Encoding{.code = 0x37, .umask = 0x2F, .msr_values = {0x00}},
      R"(Lines Victimized; Local - All Lines)",
      R"(Counts the number of lines that were victimized on a fill.  This can be filtered by the state that the line was in.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.IRQ",
      EventDef::Encoding{.code = 0x35, .umask = 0x01, .msr_values = {0x00}},
      R"(TOR Inserts; IRQ)",
      R"(Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.EVICT",
      EventDef::Encoding{.code = 0x35, .umask = 0x02, .msr_values = {0x00}},
      R"(TOR Inserts; SF/LLC Evictions)",
      R"(Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.; TOR allocation occurred as a result of SF/LLC evictions (came from the ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.PRQ",
      EventDef::Encoding{.code = 0x35, .umask = 0x04, .msr_values = {0x00}},
      R"(TOR Inserts; PRQ)",
      R"(Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.IPQ",
      EventDef::Encoding{.code = 0x35, .umask = 0x08, .msr_values = {0x00}},
      R"(TOR Inserts; IPQ)",
      R"(Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.HIT",
      EventDef::Encoding{.code = 0x35, .umask = 0x10, .msr_values = {0x00}},
      R"(TOR Inserts; Hit (Not a Miss))",
      R"(Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.; HITs (hit is defined to be not a miss [see below], as a result for any request allocated into the TOR, one of either HIT or MISS must be true))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_INSERTS.MISS",
      EventDef::Encoding{.code = 0x35, .umask = 0x20, .msr_values = {0x00}},
      R"(TOR Inserts; Miss)",
      R"(Counts the number of entries successfully inserted into the TOR that match qualifications specified by the subevent.; Misses.  (a miss is defined to be any transaction from the IRQ, PRQ, RRQ, IPQ or (in the victim case) the ISMQ, that required the CHA to spawn a new UPI/SMI3 request on the UPI fabric (including UPI snoops and/or any RD/WR to a local memory controller, in the event that the CHA is the home node)).  Basically, if the LLC/SF/MLC complex were not able to service the request without involving another agent...it is a miss.  If only IDI snoops were required, it is not a miss (that means the SF/MLC com)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.IRQ",
      EventDef::Encoding{.code = 0x36, .umask = 0x01, .msr_values = {0x00}},
      R"(TOR Occupancy; IRQ)",
      R"(For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.   T)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.EVICT",
      EventDef::Encoding{.code = 0x36, .umask = 0x02, .msr_values = {0x00}},
      R"(TOR Occupancy; SF/LLC Evictions)",
      R"(For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.   T; TOR allocation occurred as a result of SF/LLC evictions (came from the ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.PRQ",
      EventDef::Encoding{.code = 0x36, .umask = 0x04, .msr_values = {0x00}},
      R"(TOR Occupancy; PRQ)",
      R"(For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.   T)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.IPQ",
      EventDef::Encoding{.code = 0x36, .umask = 0x08, .msr_values = {0x00}},
      R"(TOR Occupancy; IPQ)",
      R"(For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.   T)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.HIT",
      EventDef::Encoding{.code = 0x36, .umask = 0x10, .msr_values = {0x00}},
      R"(TOR Occupancy; Hit (Not a Miss))",
      R"(For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.   T; HITs (hit is defined to be not a miss [see below], as a result for any request allocated into the TOR, one of either HIT or MISS must be true))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TOR_OCCUPANCY.MISS",
      EventDef::Encoding{.code = 0x36, .umask = 0x20, .msr_values = {0x00}},
      R"(TOR Occupancy; Miss)",
      R"(For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.   T; Misses.  (a miss is defined to be any transaction from the IRQ, PRQ, RRQ, IPQ or (in the victim case) the ISMQ, that required the CHA to spawn a new UPI/SMI3 request on the UPI fabric (including UPI snoops and/or any RD/WR to a local memory controller, in the event that the CHA is the home node)).  Basically, if the LLC/SF/MLC complex were not able to service the request without involving another agent...it is a miss.  If only IDI snoops were required, it is not a miss (that means the SF/MLC com)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_PMA.C1_STATE",
      EventDef::Encoding{.code = 0x17, .umask = 0x01, .msr_values = {0x00}},
      R"(Core PMA Events; C1  State)",
      R"(Core PMA Events; C1  State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_PMA.C1_TRANSITION",
      EventDef::Encoding{.code = 0x17, .umask = 0x02, .msr_values = {0x00}},
      R"(Core PMA Events; C1 Transition)",
      R"(Core PMA Events; C1 Transition)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_PMA.C6_STATE",
      EventDef::Encoding{.code = 0x17, .umask = 0x04, .msr_values = {0x00}},
      R"(Core PMA Events; C6 State)",
      R"(Core PMA Events; C6 State)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_PMA.C6_TRANSITION",
      EventDef::Encoding{.code = 0x17, .umask = 0x08, .msr_values = {0x00}},
      R"(Core PMA Events; C6 Transition)",
      R"(Core PMA Events; C6 Transition)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_CORE_PMA.GV",
      EventDef::Encoding{.code = 0x17, .umask = 0x10, .msr_values = {0x00}},
      R"(Core PMA Events; GV)",
      R"(Core PMA Events; GV)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_ACQUIRED.TGR0",
      EventDef::Encoding{.code = 0x80, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Acquired; For Transgress 0)",
      R"(Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_ACQUIRED.TGR1",
      EventDef::Encoding{.code = 0x80, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Acquired; For Transgress 1)",
      R"(Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_ACQUIRED.TGR2",
      EventDef::Encoding{.code = 0x80, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Acquired; For Transgress 2)",
      R"(Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_ACQUIRED.TGR3",
      EventDef::Encoding{.code = 0x80, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Acquired; For Transgress 3)",
      R"(Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_ACQUIRED.TGR4",
      EventDef::Encoding{.code = 0x80, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Acquired; For Transgress 4)",
      R"(Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_ACQUIRED.TGR5",
      EventDef::Encoding{.code = 0x80, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Acquired; For Transgress 5)",
      R"(Number of CMS Agent 0 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_OCCUPANCY.TGR0",
      EventDef::Encoding{.code = 0x82, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Occupancy; For Transgress 0)",
      R"(Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_OCCUPANCY.TGR1",
      EventDef::Encoding{.code = 0x82, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Occupancy; For Transgress 1)",
      R"(Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_OCCUPANCY.TGR2",
      EventDef::Encoding{.code = 0x82, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Occupancy; For Transgress 2)",
      R"(Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_OCCUPANCY.TGR3",
      EventDef::Encoding{.code = 0x82, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Occupancy; For Transgress 3)",
      R"(Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_OCCUPANCY.TGR4",
      EventDef::Encoding{.code = 0x82, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Occupancy; For Transgress 4)",
      R"(Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_AD_CRD_OCCUPANCY.TGR5",
      EventDef::Encoding{.code = 0x82, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Agent0 AD Credits Occupancy; For Transgress 5)",
      R"(Number of CMS Agent 0 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_ACQUIRED.TGR0",
      EventDef::Encoding{.code = 0x88, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Acquired; For Transgress 0)",
      R"(Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_ACQUIRED.TGR1",
      EventDef::Encoding{.code = 0x88, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Acquired; For Transgress 1)",
      R"(Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_ACQUIRED.TGR2",
      EventDef::Encoding{.code = 0x88, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Acquired; For Transgress 2)",
      R"(Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_ACQUIRED.TGR3",
      EventDef::Encoding{.code = 0x88, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Acquired; For Transgress 3)",
      R"(Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_ACQUIRED.TGR4",
      EventDef::Encoding{.code = 0x88, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Acquired; For Transgress 4)",
      R"(Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_ACQUIRED.TGR5",
      EventDef::Encoding{.code = 0x88, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Acquired; For Transgress 5)",
      R"(Number of CMS Agent 0 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_OCCUPANCY.TGR0",
      EventDef::Encoding{.code = 0x8A, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Occupancy; For Transgress 0)",
      R"(Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_OCCUPANCY.TGR1",
      EventDef::Encoding{.code = 0x8A, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Occupancy; For Transgress 1)",
      R"(Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_OCCUPANCY.TGR2",
      EventDef::Encoding{.code = 0x8A, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Occupancy; For Transgress 2)",
      R"(Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_OCCUPANCY.TGR3",
      EventDef::Encoding{.code = 0x8A, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Occupancy; For Transgress 3)",
      R"(Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_OCCUPANCY.TGR4",
      EventDef::Encoding{.code = 0x8A, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Occupancy; For Transgress 4)",
      R"(Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG0_BL_CRD_OCCUPANCY.TGR5",
      EventDef::Encoding{.code = 0x8A, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Agent0 BL Credits Occupancy; For Transgress 5)",
      R"(Number of CMS Agent 0 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_ACQUIRED.TGR0",
      EventDef::Encoding{.code = 0x84, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Acquired; For Transgress 0)",
      R"(Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_ACQUIRED.TGR1",
      EventDef::Encoding{.code = 0x84, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Acquired; For Transgress 1)",
      R"(Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_ACQUIRED.TGR2",
      EventDef::Encoding{.code = 0x84, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Acquired; For Transgress 2)",
      R"(Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_ACQUIRED.TGR3",
      EventDef::Encoding{.code = 0x84, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Acquired; For Transgress 3)",
      R"(Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_ACQUIRED.TGR4",
      EventDef::Encoding{.code = 0x84, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Acquired; For Transgress 4)",
      R"(Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_ACQUIRED.TGR5",
      EventDef::Encoding{.code = 0x84, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Acquired; For Transgress 5)",
      R"(Number of CMS Agent 1 AD credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_OCCUPANCY.TGR0",
      EventDef::Encoding{.code = 0x86, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Occupancy; For Transgress 0)",
      R"(Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_OCCUPANCY.TGR1",
      EventDef::Encoding{.code = 0x86, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Occupancy; For Transgress 1)",
      R"(Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_OCCUPANCY.TGR2",
      EventDef::Encoding{.code = 0x86, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Occupancy; For Transgress 2)",
      R"(Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_OCCUPANCY.TGR3",
      EventDef::Encoding{.code = 0x86, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Occupancy; For Transgress 3)",
      R"(Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_OCCUPANCY.TGR4",
      EventDef::Encoding{.code = 0x86, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Occupancy; For Transgress 4)",
      R"(Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_AD_CRD_OCCUPANCY.TGR5",
      EventDef::Encoding{.code = 0x86, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Agent1 AD Credits Occupancy; For Transgress 5)",
      R"(Number of CMS Agent 1 AD credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CREDITS_ACQUIRED.TGR0",
      EventDef::Encoding{.code = 0x8C, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Acquired; For Transgress 0)",
      R"(Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CREDITS_ACQUIRED.TGR1",
      EventDef::Encoding{.code = 0x8C, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Acquired; For Transgress 1)",
      R"(Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CREDITS_ACQUIRED.TGR2",
      EventDef::Encoding{.code = 0x8C, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Acquired; For Transgress 2)",
      R"(Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CREDITS_ACQUIRED.TGR3",
      EventDef::Encoding{.code = 0x8C, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Acquired; For Transgress 3)",
      R"(Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CREDITS_ACQUIRED.TGR4",
      EventDef::Encoding{.code = 0x8C, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Acquired; For Transgress 4)",
      R"(Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CREDITS_ACQUIRED.TGR5",
      EventDef::Encoding{.code = 0x8C, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Acquired; For Transgress 5)",
      R"(Number of CMS Agent 1 BL credits acquired in a given cycle, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_EGRESS_ORDERING.IV_SNOOPGO_UP",
      EventDef::Encoding{.code = 0xAE, .umask = 0x01, .msr_values = {0x00}},
      R"(Egress Blocking due to Ordering requirements; Up)",
      R"(Counts number of cycles IV was blocked in the TGR Egress due to SNP/GO Ordering requirements)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_EGRESS_ORDERING.IV_SNOOPGO_DN",
      EventDef::Encoding{.code = 0xAE, .umask = 0x04, .msr_values = {0x00}},
      R"(Egress Blocking due to Ordering requirements; Down)",
      R"(Counts number of cycles IV was blocked in the TGR Egress due to SNP/GO Ordering requirements)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_AD_IN_USE.LEFT_EVEN",
      EventDef::Encoding{.code = 0xA7, .umask = 0x01, .msr_values = {0x00}},
      R"(Horizontal AD Ring In Use; Left and Even)",
      R"(Counts the number of cycles that the Horizontal AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_AD_IN_USE.LEFT_ODD",
      EventDef::Encoding{.code = 0xA7, .umask = 0x02, .msr_values = {0x00}},
      R"(Horizontal AD Ring In Use; Left and Odd)",
      R"(Counts the number of cycles that the Horizontal AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_AD_IN_USE.RIGHT_EVEN",
      EventDef::Encoding{.code = 0xA7, .umask = 0x04, .msr_values = {0x00}},
      R"(Horizontal AD Ring In Use; Right and Even)",
      R"(Counts the number of cycles that the Horizontal AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_AD_IN_USE.RIGHT_ODD",
      EventDef::Encoding{.code = 0xA7, .umask = 0x08, .msr_values = {0x00}},
      R"(Horizontal AD Ring In Use; Right and Odd)",
      R"(Counts the number of cycles that the Horizontal AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_AK_IN_USE.LEFT_EVEN",
      EventDef::Encoding{.code = 0xA9, .umask = 0x01, .msr_values = {0x00}},
      R"(Horizontal AK Ring In Use; Left and Even)",
      R"(Counts the number of cycles that the Horizontal AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_AK_IN_USE.LEFT_ODD",
      EventDef::Encoding{.code = 0xA9, .umask = 0x02, .msr_values = {0x00}},
      R"(Horizontal AK Ring In Use; Left and Odd)",
      R"(Counts the number of cycles that the Horizontal AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_AK_IN_USE.RIGHT_EVEN",
      EventDef::Encoding{.code = 0xA9, .umask = 0x04, .msr_values = {0x00}},
      R"(Horizontal AK Ring In Use; Right and Even)",
      R"(Counts the number of cycles that the Horizontal AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_AK_IN_USE.RIGHT_ODD",
      EventDef::Encoding{.code = 0xA9, .umask = 0x08, .msr_values = {0x00}},
      R"(Horizontal AK Ring In Use; Right and Odd)",
      R"(Counts the number of cycles that the Horizontal AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_BL_IN_USE.LEFT_EVEN",
      EventDef::Encoding{.code = 0xAB, .umask = 0x01, .msr_values = {0x00}},
      R"(Horizontal BL Ring in Use; Left and Even)",
      R"(Counts the number of cycles that the Horizontal BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_BL_IN_USE.LEFT_ODD",
      EventDef::Encoding{.code = 0xAB, .umask = 0x02, .msr_values = {0x00}},
      R"(Horizontal BL Ring in Use; Left and Odd)",
      R"(Counts the number of cycles that the Horizontal BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_BL_IN_USE.RIGHT_EVEN",
      EventDef::Encoding{.code = 0xAB, .umask = 0x04, .msr_values = {0x00}},
      R"(Horizontal BL Ring in Use; Right and Even)",
      R"(Counts the number of cycles that the Horizontal BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_BL_IN_USE.RIGHT_ODD",
      EventDef::Encoding{.code = 0xAB, .umask = 0x08, .msr_values = {0x00}},
      R"(Horizontal BL Ring in Use; Right and Odd)",
      R"(Counts the number of cycles that the Horizontal BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_IV_IN_USE.LEFT",
      EventDef::Encoding{.code = 0xAD, .umask = 0x01, .msr_values = {0x00}},
      R"(Horizontal IV Ring in Use; Left)",
      R"(Counts the number of cycles that the Horizontal IV ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  There is only 1 IV ring.  Therefore, if one wants to monitor the Even ring, they should select both UP_EVEN and DN_EVEN.  To monitor the Odd ring, they should select both UP_ODD and DN_ODD.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_HORZ_RING_IV_IN_USE.RIGHT",
      EventDef::Encoding{.code = 0xAD, .umask = 0x04, .msr_values = {0x00}},
      R"(Horizontal IV Ring in Use; Right)",
      R"(Counts the number of cycles that the Horizontal IV ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  There is only 1 IV ring.  Therefore, if one wants to monitor the Even ring, they should select both UP_EVEN and DN_EVEN.  To monitor the Odd ring, they should select both UP_ODD and DN_ODD.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_BOUNCES_HORZ.AD",
      EventDef::Encoding{.code = 0xA1, .umask = 0x01, .msr_values = {0x00}},
      R"(Messages that bounced on the Horizontal Ring.; AD)",
      R"(Number of cycles incoming messages from the Horizontal ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_BOUNCES_HORZ.AK",
      EventDef::Encoding{.code = 0xA1, .umask = 0x02, .msr_values = {0x00}},
      R"(Messages that bounced on the Horizontal Ring.; AK)",
      R"(Number of cycles incoming messages from the Horizontal ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_BOUNCES_HORZ.BL",
      EventDef::Encoding{.code = 0xA1, .umask = 0x04, .msr_values = {0x00}},
      R"(Messages that bounced on the Horizontal Ring.; BL)",
      R"(Number of cycles incoming messages from the Horizontal ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_BOUNCES_HORZ.IV",
      EventDef::Encoding{.code = 0xA1, .umask = 0x08, .msr_values = {0x00}},
      R"(Messages that bounced on the Horizontal Ring.; IV)",
      R"(Number of cycles incoming messages from the Horizontal ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_BOUNCES_VERT.AD",
      EventDef::Encoding{.code = 0xA0, .umask = 0x01, .msr_values = {0x00}},
      R"(Messages that bounced on the Vertical Ring.; AD)",
      R"(Number of cycles incoming messages from the Vertical ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_BOUNCES_VERT.AK",
      EventDef::Encoding{.code = 0xA0, .umask = 0x02, .msr_values = {0x00}},
      R"(Messages that bounced on the Vertical Ring.; Acknowledgements to core)",
      R"(Number of cycles incoming messages from the Vertical ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_BOUNCES_VERT.BL",
      EventDef::Encoding{.code = 0xA0, .umask = 0x04, .msr_values = {0x00}},
      R"(Messages that bounced on the Vertical Ring.; Data Responses to core)",
      R"(Number of cycles incoming messages from the Vertical ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_BOUNCES_VERT.IV",
      EventDef::Encoding{.code = 0xA0, .umask = 0x08, .msr_values = {0x00}},
      R"(Messages that bounced on the Vertical Ring.; Snoops of processor's cache.)",
      R"(Number of cycles incoming messages from the Vertical ring that were bounced, by ring type.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_SINK_STARVED_HORZ.AD",
      EventDef::Encoding{.code = 0xA3, .umask = 0x01, .msr_values = {0x00}},
      R"(Sink Starvation on Horizontal Ring; AD)",
      R"(Sink Starvation on Horizontal Ring; AD)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_SINK_STARVED_HORZ.AK",
      EventDef::Encoding{.code = 0xA3, .umask = 0x02, .msr_values = {0x00}},
      R"(Sink Starvation on Horizontal Ring; AK)",
      R"(Sink Starvation on Horizontal Ring; AK)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_SINK_STARVED_HORZ.BL",
      EventDef::Encoding{.code = 0xA3, .umask = 0x04, .msr_values = {0x00}},
      R"(Sink Starvation on Horizontal Ring; BL)",
      R"(Sink Starvation on Horizontal Ring; BL)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_SINK_STARVED_HORZ.IV",
      EventDef::Encoding{.code = 0xA3, .umask = 0x08, .msr_values = {0x00}},
      R"(Sink Starvation on Horizontal Ring; IV)",
      R"(Sink Starvation on Horizontal Ring; IV)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_SINK_STARVED_HORZ.AK_AG1",
      EventDef::Encoding{.code = 0xA3, .umask = 0x20, .msr_values = {0x00}},
      R"(Sink Starvation on Horizontal Ring; Acknowledgements to Agent 1)",
      R"(Sink Starvation on Horizontal Ring; Acknowledgements to Agent 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_SINK_STARVED_VERT.AD",
      EventDef::Encoding{.code = 0xA2, .umask = 0x01, .msr_values = {0x00}},
      R"(Sink Starvation on Vertical Ring; AD)",
      R"(Sink Starvation on Vertical Ring; AD)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_SINK_STARVED_VERT.AK",
      EventDef::Encoding{.code = 0xA2, .umask = 0x02, .msr_values = {0x00}},
      R"(Sink Starvation on Vertical Ring; Acknowledgements to core)",
      R"(Sink Starvation on Vertical Ring; Acknowledgements to core)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_SINK_STARVED_VERT.BL",
      EventDef::Encoding{.code = 0xA2, .umask = 0x04, .msr_values = {0x00}},
      R"(Sink Starvation on Vertical Ring; Data Responses to core)",
      R"(Sink Starvation on Vertical Ring; Data Responses to core)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_SINK_STARVED_VERT.IV",
      EventDef::Encoding{.code = 0xA2, .umask = 0x08, .msr_values = {0x00}},
      R"(Sink Starvation on Vertical Ring; Snoops of processor's cache.)",
      R"(Sink Starvation on Vertical Ring; Snoops of processor's cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RING_SRC_THRTL",
      EventDef::Encoding{.code = 0xA4, .umask = 0x00, .msr_values = {0x00}},
      R"(Source Throttle)",
      R"(Source Throttle)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_INSERTS.IRQ_REJ",
      EventDef::Encoding{.code = 0x13, .umask = 0x02, .msr_values = {0x00}},
      R"(Ingress (from CMS) Allocations; IRQ Rejected)",
      R"(Counts number of allocations per cycle into the specified Ingress queue.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_INSERTS.IPQ",
      EventDef::Encoding{.code = 0x13, .umask = 0x04, .msr_values = {0x00}},
      R"(Ingress (from CMS) Allocations; IPQ)",
      R"(Counts number of allocations per cycle into the specified Ingress queue.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_INSERTS.PRQ",
      EventDef::Encoding{.code = 0x13, .umask = 0x10, .msr_values = {0x00}},
      R"(Ingress (from CMS) Allocations; PRQ)",
      R"(Counts number of allocations per cycle into the specified Ingress queue.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_INSERTS.PRQ_REJ",
      EventDef::Encoding{.code = 0x13, .umask = 0x20, .msr_values = {0x00}},
      R"(Ingress (from CMS) Allocations; PRQ)",
      R"(Counts number of allocations per cycle into the specified Ingress queue.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_INSERTS.RRQ",
      EventDef::Encoding{.code = 0x13, .umask = 0x40, .msr_values = {0x00}},
      R"(Ingress (from CMS) Allocations; RRQ)",
      R"(Counts number of allocations per cycle into the specified Ingress queue.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_INSERTS.WBQ",
      EventDef::Encoding{.code = 0x13, .umask = 0x80, .msr_values = {0x00}},
      R"(Ingress (from CMS) Allocations; WBQ)",
      R"(Counts number of allocations per cycle into the specified Ingress queue.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ0_REJECT.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x22, .umask = 0x01, .msr_values = {0x00}},
      R"(Ingress Probe Queue Rejects; AD REQ on VN0)",
      R"(Ingress Probe Queue Rejects; AD REQ on VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ0_REJECT.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x22, .umask = 0x02, .msr_values = {0x00}},
      R"(Ingress Probe Queue Rejects; AD RSP on VN0)",
      R"(Ingress Probe Queue Rejects; AD RSP on VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ0_REJECT.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x22, .umask = 0x04, .msr_values = {0x00}},
      R"(Ingress Probe Queue Rejects; BL RSP on VN0)",
      R"(Ingress Probe Queue Rejects; BL RSP on VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ0_REJECT.BL_WB_VN0",
      EventDef::Encoding{.code = 0x22, .umask = 0x08, .msr_values = {0x00}},
      R"(Ingress Probe Queue Rejects; BL WB on VN0)",
      R"(Ingress Probe Queue Rejects; BL WB on VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ0_REJECT.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x22, .umask = 0x10, .msr_values = {0x00}},
      R"(Ingress Probe Queue Rejects; BL NCB on VN0)",
      R"(Ingress Probe Queue Rejects; BL NCB on VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ0_REJECT.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x22, .umask = 0x20, .msr_values = {0x00}},
      R"(Ingress Probe Queue Rejects; BL NCS on VN0)",
      R"(Ingress Probe Queue Rejects; BL NCS on VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ1_REJECT.ANY0",
      EventDef::Encoding{.code = 0x23, .umask = 0x1, .msr_values = {0x00}},
      R"(Ingress Probe Queue Rejects; ANY0)",
      R"(Ingress Probe Queue Rejects; ANY0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ1_REJECT.HA",
      EventDef::Encoding{.code = 0x23, .umask = 0x02, .msr_values = {0x00}},
      R"(Ingress Probe Queue Rejects; HA)",
      R"(Ingress Probe Queue Rejects; HA)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ1_REJECT.LLC_VICTIM",
      EventDef::Encoding{.code = 0x23, .umask = 0x04, .msr_values = {0x00}},
      R"(Ingress Probe Queue Rejects; LLC Victim)",
      R"(Ingress Probe Queue Rejects; LLC Victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ1_REJECT.SF_VICTIM",
      EventDef::Encoding{.code = 0x23, .umask = 0x08, .msr_values = {0x00}},
      R"(Ingress Probe Queue Rejects; SF Victim)",
      R"(Ingress Probe Queue Rejects; SF Victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ1_REJECT.VICTIM",
      EventDef::Encoding{.code = 0x23, .umask = 0x10, .msr_values = {0x00}},
      R"(Ingress Probe Queue Rejects; Victim)",
      R"(Ingress Probe Queue Rejects; Victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ1_REJECT.LLC_OR_SF_WAY",
      EventDef::Encoding{.code = 0x23, .umask = 0x20, .msr_values = {0x00}},
      R"(Ingress Probe Queue Rejects; Merging these two together to make room for ANY_REJECT_*0)",
      R"(Ingress Probe Queue Rejects; Merging these two together to make room for ANY_REJECT_*0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ1_REJECT.ALLOW_SNP",
      EventDef::Encoding{.code = 0x23, .umask = 0x40, .msr_values = {0x00}},
      R"(Ingress Probe Queue Rejects; Allow Snoop)",
      R"(Ingress Probe Queue Rejects; Allow Snoop)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IPQ1_REJECT.PA_MATCH",
      EventDef::Encoding{.code = 0x23, .umask = 0x80, .msr_values = {0x00}},
      R"(Ingress Probe Queue Rejects; PhyAddr Match)",
      R"(Ingress Probe Queue Rejects; PhyAddr Match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_OCCUPANCY.TGR0",
      EventDef::Encoding{.code = 0x8E, .umask = 0x1, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Occupancy; For Transgress 0)",
      R"(Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_OCCUPANCY.TGR1",
      EventDef::Encoding{.code = 0x8E, .umask = 0x2, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Occupancy; For Transgress 1)",
      R"(Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_OCCUPANCY.TGR2",
      EventDef::Encoding{.code = 0x8E, .umask = 0x4, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Occupancy; For Transgress 2)",
      R"(Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_OCCUPANCY.TGR3",
      EventDef::Encoding{.code = 0x8E, .umask = 0x8, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Occupancy; For Transgress 3)",
      R"(Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_OCCUPANCY.TGR4",
      EventDef::Encoding{.code = 0x8E, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Occupancy; For Transgress 4)",
      R"(Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_AG1_BL_CRD_OCCUPANCY.TGR5",
      EventDef::Encoding{.code = 0x8E, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Agent1 BL Credits Occupancy; For Transgress 5)",
      R"(Number of CMS Agent 1 BL credits in use in a given cycle, per transgress)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x18, .umask = 0x01, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; AD REQ on VN0)",
      R"(Ingress (from CMS) Request Queue Rejects; AD REQ on VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x18, .umask = 0x02, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; AD RSP on VN0)",
      R"(Ingress (from CMS) Request Queue Rejects; AD RSP on VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x18, .umask = 0x04, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; BL RSP on VN0)",
      R"(Ingress (from CMS) Request Queue Rejects; BL RSP on VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.BL_WB_VN0",
      EventDef::Encoding{.code = 0x18, .umask = 0x08, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; BL WB on VN0)",
      R"(Ingress (from CMS) Request Queue Rejects; BL WB on VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x18, .umask = 0x10, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; BL NCB on VN0)",
      R"(Ingress (from CMS) Request Queue Rejects; BL NCB on VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ0_REJECT.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x18, .umask = 0x20, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; BL NCS on VN0)",
      R"(Ingress (from CMS) Request Queue Rejects; BL NCS on VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ1_REJECT.ANY0",
      EventDef::Encoding{.code = 0x19, .umask = 0x1, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; ANY0)",
      R"(Ingress (from CMS) Request Queue Rejects; ANY0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ1_REJECT.HA",
      EventDef::Encoding{.code = 0x19, .umask = 0x02, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; HA)",
      R"(Ingress (from CMS) Request Queue Rejects; HA)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ1_REJECT.LLC_VICTIM",
      EventDef::Encoding{.code = 0x19, .umask = 0x04, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; LLC Victim)",
      R"(Ingress (from CMS) Request Queue Rejects; LLC Victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ1_REJECT.SF_VICTIM",
      EventDef::Encoding{.code = 0x19, .umask = 0x08, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; SF Victim)",
      R"(Ingress (from CMS) Request Queue Rejects; SF Victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ1_REJECT.VICTIM",
      EventDef::Encoding{.code = 0x19, .umask = 0x10, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; Victim)",
      R"(Ingress (from CMS) Request Queue Rejects; Victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ1_REJECT.LLC_OR_SF_WAY",
      EventDef::Encoding{.code = 0x19, .umask = 0x20, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; Merging these two together to make room for ANY_REJECT_*0)",
      R"(Ingress (from CMS) Request Queue Rejects; Merging these two together to make room for ANY_REJECT_*0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_IRQ1_REJECT.ALLOW_SNP",
      EventDef::Encoding{.code = 0x19, .umask = 0x40, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; Allow Snoop)",
      R"(Ingress (from CMS) Request Queue Rejects; Allow Snoop)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x24, .umask = 0x01, .msr_values = {0x00}},
      R"(ISMQ Rejects; AD REQ on VN0)",
      R"(Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x24, .umask = 0x02, .msr_values = {0x00}},
      R"(ISMQ Rejects; AD RSP on VN0)",
      R"(Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x24, .umask = 0x04, .msr_values = {0x00}},
      R"(ISMQ Rejects; BL RSP on VN0)",
      R"(Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.BL_WB_VN0",
      EventDef::Encoding{.code = 0x24, .umask = 0x08, .msr_values = {0x00}},
      R"(ISMQ Rejects; BL WB on VN0)",
      R"(Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x24, .umask = 0x10, .msr_values = {0x00}},
      R"(ISMQ Rejects; BL NCB on VN0)",
      R"(Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_REJECT.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x24, .umask = 0x20, .msr_values = {0x00}},
      R"(ISMQ Rejects; BL NCS on VN0)",
      R"(Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x2C, .umask = 0x01, .msr_values = {0x00}},
      R"(ISMQ Retries; AD REQ on VN0)",
      R"(Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x2C, .umask = 0x02, .msr_values = {0x00}},
      R"(ISMQ Retries; AD RSP on VN0)",
      R"(Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x2C, .umask = 0x04, .msr_values = {0x00}},
      R"(ISMQ Retries; BL RSP on VN0)",
      R"(Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.BL_WB_VN0",
      EventDef::Encoding{.code = 0x2C, .umask = 0x08, .msr_values = {0x00}},
      R"(ISMQ Retries; BL WB on VN0)",
      R"(Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x2C, .umask = 0x10, .msr_values = {0x00}},
      R"(ISMQ Retries; BL NCB on VN0)",
      R"(Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ0_RETRY.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x2C, .umask = 0x20, .msr_values = {0x00}},
      R"(ISMQ Retries; BL NCS on VN0)",
      R"(Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ1_REJECT.ANY0",
      EventDef::Encoding{.code = 0x25, .umask = 0x1, .msr_values = {0x00}},
      R"(ISMQ Rejects; ANY0)",
      R"(Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ1_REJECT.HA",
      EventDef::Encoding{.code = 0x25, .umask = 0x02, .msr_values = {0x00}},
      R"(ISMQ Rejects; HA)",
      R"(Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ1_RETRY.ANY0",
      EventDef::Encoding{.code = 0x2D, .umask = 0x1, .msr_values = {0x00}},
      R"(ISMQ Retries; ANY0)",
      R"(Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_ISMQ1_RETRY.HA",
      EventDef::Encoding{.code = 0x2D, .umask = 0x02, .msr_values = {0x00}},
      R"(ISMQ Retries; HA)",
      R"(Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OCCUPANCY.IPQ",
      EventDef::Encoding{.code = 0x11, .umask = 0x04, .msr_values = {0x00}},
      R"(Ingress (from CMS) Occupancy; IPQ)",
      R"(Counts number of entries in the specified Ingress queue in each cycle.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OCCUPANCY.RRQ",
      EventDef::Encoding{.code = 0x11, .umask = 0x40, .msr_values = {0x00}},
      R"(Ingress (from CMS) Occupancy; RRQ)",
      R"(Counts number of entries in the specified Ingress queue in each cycle.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OCCUPANCY.WBQ",
      EventDef::Encoding{.code = 0x11, .umask = 0x80, .msr_values = {0x00}},
      R"(Ingress (from CMS) Occupancy; WBQ)",
      R"(Counts number of entries in the specified Ingress queue in each cycle.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x2E, .umask = 0x01, .msr_values = {0x00}},
      R"(Other Retries; AD REQ on VN0)",
      R"(Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x2E, .umask = 0x02, .msr_values = {0x00}},
      R"(Other Retries; AD RSP on VN0)",
      R"(Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x2E, .umask = 0x04, .msr_values = {0x00}},
      R"(Other Retries; BL RSP on VN0)",
      R"(Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.BL_WB_VN0",
      EventDef::Encoding{.code = 0x2E, .umask = 0x08, .msr_values = {0x00}},
      R"(Other Retries; BL WB on VN0)",
      R"(Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x2E, .umask = 0x10, .msr_values = {0x00}},
      R"(Other Retries; BL NCB on VN0)",
      R"(Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER0_RETRY.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x2E, .umask = 0x20, .msr_values = {0x00}},
      R"(Other Retries; BL NCS on VN0)",
      R"(Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.ANY0",
      EventDef::Encoding{.code = 0x2F, .umask = 0x1, .msr_values = {0x00}},
      R"(Other Retries; ANY0)",
      R"(Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.HA",
      EventDef::Encoding{.code = 0x2F, .umask = 0x02, .msr_values = {0x00}},
      R"(Other Retries; HA)",
      R"(Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.LLC_VICTIM",
      EventDef::Encoding{.code = 0x2F, .umask = 0x04, .msr_values = {0x00}},
      R"(Other Retries; LLC Victim)",
      R"(Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.SF_VICTIM",
      EventDef::Encoding{.code = 0x2F, .umask = 0x08, .msr_values = {0x00}},
      R"(Other Retries; SF Victim)",
      R"(Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.VICTIM",
      EventDef::Encoding{.code = 0x2F, .umask = 0x10, .msr_values = {0x00}},
      R"(Other Retries; Victim)",
      R"(Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.LLC_OR_SF_WAY",
      EventDef::Encoding{.code = 0x2F, .umask = 0x20, .msr_values = {0x00}},
      R"(Other Retries; Merging these two together to make room for ANY_REJECT_*0)",
      R"(Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.ALLOW_SNP",
      EventDef::Encoding{.code = 0x2F, .umask = 0x40, .msr_values = {0x00}},
      R"(Other Retries; Allow Snoop)",
      R"(Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_OTHER1_RETRY.PA_MATCH",
      EventDef::Encoding{.code = 0x2F, .umask = 0x80, .msr_values = {0x00}},
      R"(Other Retries; PhyAddr Match)",
      R"(Retry Queue Inserts of Transactions that were already in another Retry Q (sub-events encode the reason for the next reject))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x20, .umask = 0x01, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; AD REQ on VN0)",
      R"(Ingress (from CMS) Request Queue Rejects; AD REQ on VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x20, .umask = 0x02, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; AD RSP on VN0)",
      R"(Ingress (from CMS) Request Queue Rejects; AD RSP on VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x20, .umask = 0x04, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; BL RSP on VN0)",
      R"(Ingress (from CMS) Request Queue Rejects; BL RSP on VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.BL_WB_VN0",
      EventDef::Encoding{.code = 0x20, .umask = 0x08, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; BL WB on VN0)",
      R"(Ingress (from CMS) Request Queue Rejects; BL WB on VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x20, .umask = 0x10, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; BL NCB on VN0)",
      R"(Ingress (from CMS) Request Queue Rejects; BL NCB on VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ0_REJECT.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x20, .umask = 0x20, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; BL NCS on VN0)",
      R"(Ingress (from CMS) Request Queue Rejects; BL NCS on VN0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.ANY0",
      EventDef::Encoding{.code = 0x21, .umask = 0x1, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; ANY0)",
      R"(Ingress (from CMS) Request Queue Rejects; ANY0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.HA",
      EventDef::Encoding{.code = 0x21, .umask = 0x02, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; HA)",
      R"(Ingress (from CMS) Request Queue Rejects; HA)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.LLC_VICTIM",
      EventDef::Encoding{.code = 0x21, .umask = 0x04, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; LLC Victim)",
      R"(Ingress (from CMS) Request Queue Rejects; LLC Victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.SF_VICTIM",
      EventDef::Encoding{.code = 0x21, .umask = 0x08, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; SF Victim)",
      R"(Ingress (from CMS) Request Queue Rejects; SF Victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.VICTIM",
      EventDef::Encoding{.code = 0x21, .umask = 0x10, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; Victim)",
      R"(Ingress (from CMS) Request Queue Rejects; Victim)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.LLC_OR_SF_WAY",
      EventDef::Encoding{.code = 0x21, .umask = 0x20, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; LLC OR SF Way)",
      R"(Ingress (from CMS) Request Queue Rejects; LLC OR SF Way)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.ALLOW_SNP",
      EventDef::Encoding{.code = 0x21, .umask = 0x40, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; Allow Snoop)",
      R"(Ingress (from CMS) Request Queue Rejects; Allow Snoop)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_PRQ1_REJECT.PA_MATCH",
      EventDef::Encoding{.code = 0x21, .umask = 0x80, .msr_values = {0x00}},
      R"(Ingress (from CMS) Request Queue Rejects; PhyAddr Match)",
      R"(Ingress (from CMS) Request Queue Rejects; PhyAddr Match)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x2A, .umask = 0x01, .msr_values = {0x00}},
      R"(Request Queue Retries; AD REQ on VN0)",
      R"(REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x2A, .umask = 0x02, .msr_values = {0x00}},
      R"(Request Queue Retries; AD RSP on VN0)",
      R"(REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x2A, .umask = 0x04, .msr_values = {0x00}},
      R"(Request Queue Retries; BL RSP on VN0)",
      R"(REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.BL_WB_VN0",
      EventDef::Encoding{.code = 0x2A, .umask = 0x08, .msr_values = {0x00}},
      R"(Request Queue Retries; BL WB on VN0)",
      R"(REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x2A, .umask = 0x10, .msr_values = {0x00}},
      R"(Request Queue Retries; BL NCB on VN0)",
      R"(REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_REQ_Q0_RETRY.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x2A, .umask = 0x20, .msr_values = {0x00}},
      R"(Request Queue Retries; BL NCS on VN0)",
      R"(REQUESTQ includes:  IRQ, PRQ, IPQ, RRQ, WBQ (everything except for ISMQ))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ0_REJECT.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x26, .umask = 0x01, .msr_values = {0x00}},
      R"(RRQ Rejects; AD REQ on VN0)",
      R"(Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ0_REJECT.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x26, .umask = 0x02, .msr_values = {0x00}},
      R"(RRQ Rejects; AD RSP on VN0)",
      R"(Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ0_REJECT.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x26, .umask = 0x04, .msr_values = {0x00}},
      R"(RRQ Rejects; BL RSP on VN0)",
      R"(Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ0_REJECT.BL_WB_VN0",
      EventDef::Encoding{.code = 0x26, .umask = 0x08, .msr_values = {0x00}},
      R"(RRQ Rejects; BL WB on VN0)",
      R"(Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ0_REJECT.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x26, .umask = 0x10, .msr_values = {0x00}},
      R"(RRQ Rejects; BL NCB on VN0)",
      R"(Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ0_REJECT.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x26, .umask = 0x20, .msr_values = {0x00}},
      R"(RRQ Rejects; BL NCS on VN0)",
      R"(Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ1_REJECT.ANY0",
      EventDef::Encoding{.code = 0x27, .umask = 0x1, .msr_values = {0x00}},
      R"(RRQ Rejects; ANY0)",
      R"(Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ1_REJECT.HA",
      EventDef::Encoding{.code = 0x27, .umask = 0x02, .msr_values = {0x00}},
      R"(RRQ Rejects; HA)",
      R"(Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ1_REJECT.LLC_VICTIM",
      EventDef::Encoding{.code = 0x27, .umask = 0x04, .msr_values = {0x00}},
      R"(RRQ Rejects; LLC Victim)",
      R"(Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ1_REJECT.SF_VICTIM",
      EventDef::Encoding{.code = 0x27, .umask = 0x08, .msr_values = {0x00}},
      R"(RRQ Rejects; SF Victim)",
      R"(Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ1_REJECT.VICTIM",
      EventDef::Encoding{.code = 0x27, .umask = 0x10, .msr_values = {0x00}},
      R"(RRQ Rejects; Victim)",
      R"(Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ1_REJECT.LLC_OR_SF_WAY",
      EventDef::Encoding{.code = 0x27, .umask = 0x20, .msr_values = {0x00}},
      R"(RRQ Rejects; Merging these two together to make room for ANY_REJECT_*0)",
      R"(Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ1_REJECT.ALLOW_SNP",
      EventDef::Encoding{.code = 0x27, .umask = 0x40, .msr_values = {0x00}},
      R"(RRQ Rejects; Allow Snoop)",
      R"(Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_RRQ1_REJECT.PA_MATCH",
      EventDef::Encoding{.code = 0x27, .umask = 0x80, .msr_values = {0x00}},
      R"(RRQ Rejects; PhyAddr Match)",
      R"(Number of times a transaction flowing through the RRQ (Remote Response Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ0_REJECT.AD_REQ_VN0",
      EventDef::Encoding{.code = 0x28, .umask = 0x01, .msr_values = {0x00}},
      R"(WBQ Rejects; AD REQ on VN0)",
      R"(Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ0_REJECT.AD_RSP_VN0",
      EventDef::Encoding{.code = 0x28, .umask = 0x02, .msr_values = {0x00}},
      R"(WBQ Rejects; AD RSP on VN0)",
      R"(Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ0_REJECT.BL_RSP_VN0",
      EventDef::Encoding{.code = 0x28, .umask = 0x04, .msr_values = {0x00}},
      R"(WBQ Rejects; BL RSP on VN0)",
      R"(Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ0_REJECT.BL_WB_VN0",
      EventDef::Encoding{.code = 0x28, .umask = 0x08, .msr_values = {0x00}},
      R"(WBQ Rejects; BL WB on VN0)",
      R"(Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ0_REJECT.BL_NCB_VN0",
      EventDef::Encoding{.code = 0x28, .umask = 0x10, .msr_values = {0x00}},
      R"(WBQ Rejects; BL NCB on VN0)",
      R"(Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ0_REJECT.BL_NCS_VN0",
      EventDef::Encoding{.code = 0x28, .umask = 0x20, .msr_values = {0x00}},
      R"(WBQ Rejects; BL NCS on VN0)",
      R"(Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ1_REJECT.ANY0",
      EventDef::Encoding{.code = 0x29, .umask = 0x1, .msr_values = {0x00}},
      R"(WBQ Rejects; ANY0)",
      R"(Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ1_REJECT.HA",
      EventDef::Encoding{.code = 0x29, .umask = 0x02, .msr_values = {0x00}},
      R"(WBQ Rejects; HA)",
      R"(Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ1_REJECT.LLC_VICTIM",
      EventDef::Encoding{.code = 0x29, .umask = 0x04, .msr_values = {0x00}},
      R"(WBQ Rejects; LLC Victim)",
      R"(Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ1_REJECT.SF_VICTIM",
      EventDef::Encoding{.code = 0x29, .umask = 0x08, .msr_values = {0x00}},
      R"(WBQ Rejects; SF Victim)",
      R"(Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ1_REJECT.VICTIM",
      EventDef::Encoding{.code = 0x29, .umask = 0x10, .msr_values = {0x00}},
      R"(WBQ Rejects; Victim)",
      R"(Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ1_REJECT.LLC_OR_SF_WAY",
      EventDef::Encoding{.code = 0x29, .umask = 0x20, .msr_values = {0x00}},
      R"(WBQ Rejects; Merging these two together to make room for ANY_REJECT_*0)",
      R"(Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ1_REJECT.ALLOW_SNP",
      EventDef::Encoding{.code = 0x29, .umask = 0x40, .msr_values = {0x00}},
      R"(WBQ Rejects; Allow Snoop)",
      R"(Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_RxC_WBQ1_REJECT.PA_MATCH",
      EventDef::Encoding{.code = 0x29, .umask = 0x80, .msr_values = {0x00}},
      R"(WBQ Rejects; PhyAddr Match)",
      R"(Number of times a transaction flowing through the WBQ (Writeback Queue) had to retry.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_AD_AG0.TGR0",
      EventDef::Encoding{.code = 0xD0, .umask = 0x01, .msr_values = {0x00}},
      R"(Stall on No AD Agent0 Transgress Credits; For Transgress 0)",
      R"(Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_AD_AG0.TGR1",
      EventDef::Encoding{.code = 0xD0, .umask = 0x02, .msr_values = {0x00}},
      R"(Stall on No AD Agent0 Transgress Credits; For Transgress 1)",
      R"(Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_AD_AG0.TGR2",
      EventDef::Encoding{.code = 0xD0, .umask = 0x04, .msr_values = {0x00}},
      R"(Stall on No AD Agent0 Transgress Credits; For Transgress 2)",
      R"(Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_AD_AG0.TGR3",
      EventDef::Encoding{.code = 0xD0, .umask = 0x08, .msr_values = {0x00}},
      R"(Stall on No AD Agent0 Transgress Credits; For Transgress 3)",
      R"(Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_AD_AG0.TGR4",
      EventDef::Encoding{.code = 0xD0, .umask = 0x10, .msr_values = {0x00}},
      R"(Stall on No AD Agent0 Transgress Credits; For Transgress 4)",
      R"(Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_AD_AG0.TGR5",
      EventDef::Encoding{.code = 0xD0, .umask = 0x20, .msr_values = {0x00}},
      R"(Stall on No AD Agent0 Transgress Credits; For Transgress 5)",
      R"(Number of cycles the AD Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_AD_AG1.TGR0",
      EventDef::Encoding{.code = 0xD2, .umask = 0x01, .msr_values = {0x00}},
      R"(Stall on No AD Agent1 Transgress Credits; For Transgress 0)",
      R"(Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_AD_AG1.TGR1",
      EventDef::Encoding{.code = 0xD2, .umask = 0x02, .msr_values = {0x00}},
      R"(Stall on No AD Agent1 Transgress Credits; For Transgress 1)",
      R"(Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_AD_AG1.TGR2",
      EventDef::Encoding{.code = 0xD2, .umask = 0x04, .msr_values = {0x00}},
      R"(Stall on No AD Agent1 Transgress Credits; For Transgress 2)",
      R"(Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_AD_AG1.TGR3",
      EventDef::Encoding{.code = 0xD2, .umask = 0x08, .msr_values = {0x00}},
      R"(Stall on No AD Agent1 Transgress Credits; For Transgress 3)",
      R"(Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_AD_AG1.TGR4",
      EventDef::Encoding{.code = 0xD2, .umask = 0x10, .msr_values = {0x00}},
      R"(Stall on No AD Agent1 Transgress Credits; For Transgress 4)",
      R"(Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_AD_AG1.TGR5",
      EventDef::Encoding{.code = 0xD2, .umask = 0x20, .msr_values = {0x00}},
      R"(Stall on No AD Agent1 Transgress Credits; For Transgress 5)",
      R"(Number of cycles the AD Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_BL_AG0.TGR0",
      EventDef::Encoding{.code = 0xD4, .umask = 0x01, .msr_values = {0x00}},
      R"(Stall on No BL Agent0 Transgress Credits; For Transgress 0)",
      R"(Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_BL_AG0.TGR1",
      EventDef::Encoding{.code = 0xD4, .umask = 0x02, .msr_values = {0x00}},
      R"(Stall on No BL Agent0 Transgress Credits; For Transgress 1)",
      R"(Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_BL_AG0.TGR2",
      EventDef::Encoding{.code = 0xD4, .umask = 0x04, .msr_values = {0x00}},
      R"(Stall on No BL Agent0 Transgress Credits; For Transgress 2)",
      R"(Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_BL_AG0.TGR3",
      EventDef::Encoding{.code = 0xD4, .umask = 0x08, .msr_values = {0x00}},
      R"(Stall on No BL Agent0 Transgress Credits; For Transgress 3)",
      R"(Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_BL_AG0.TGR4",
      EventDef::Encoding{.code = 0xD4, .umask = 0x10, .msr_values = {0x00}},
      R"(Stall on No BL Agent0 Transgress Credits; For Transgress 4)",
      R"(Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_BL_AG0.TGR5",
      EventDef::Encoding{.code = 0xD4, .umask = 0x20, .msr_values = {0x00}},
      R"(Stall on No BL Agent0 Transgress Credits; For Transgress 5)",
      R"(Number of cycles the BL Agent 0 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_BL_AG1.TGR0",
      EventDef::Encoding{.code = 0xD6, .umask = 0x01, .msr_values = {0x00}},
      R"(Stall on No BL Agent1 Transgress Credits; For Transgress 0)",
      R"(Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_BL_AG1.TGR1",
      EventDef::Encoding{.code = 0xD6, .umask = 0x02, .msr_values = {0x00}},
      R"(Stall on No BL Agent1 Transgress Credits; For Transgress 1)",
      R"(Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_BL_AG1.TGR2",
      EventDef::Encoding{.code = 0xD6, .umask = 0x04, .msr_values = {0x00}},
      R"(Stall on No BL Agent1 Transgress Credits; For Transgress 2)",
      R"(Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_BL_AG1.TGR3",
      EventDef::Encoding{.code = 0xD6, .umask = 0x08, .msr_values = {0x00}},
      R"(Stall on No BL Agent1 Transgress Credits; For Transgress 3)",
      R"(Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_BL_AG1.TGR4",
      EventDef::Encoding{.code = 0xD6, .umask = 0x10, .msr_values = {0x00}},
      R"(Stall on No BL Agent1 Transgress Credits; For Transgress 4)",
      R"(Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_STALL_NO_TxR_HORZ_CRD_BL_AG1.TGR5",
      EventDef::Encoding{.code = 0xD6, .umask = 0x20, .msr_values = {0x00}},
      R"(Stall on No BL Agent1 Transgress Credits; For Transgress 5)",
      R"(Number of cycles the BL Agent 1 Egress Buffer is stalled waiting for a TGR credit to become available, per transgress.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_ADS_USED.AD_BNC",
      EventDef::Encoding{.code = 0x9D, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Horizontal ADS Used; AD - Bounce)",
      R"(Number of packets using the Horizontal Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_ADS_USED.AK_BNC",
      EventDef::Encoding{.code = 0x9D, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Horizontal ADS Used; AK - Bounce)",
      R"(Number of packets using the Horizontal Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_ADS_USED.BL_BNC",
      EventDef::Encoding{.code = 0x9D, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Horizontal ADS Used; BL - Bounce)",
      R"(Number of packets using the Horizontal Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_ADS_USED.AD_CRD",
      EventDef::Encoding{.code = 0x9D, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Horizontal ADS Used; AD - Credit)",
      R"(Number of packets using the Horizontal Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_ADS_USED.BL_CRD",
      EventDef::Encoding{.code = 0x9D, .umask = 0x40, .msr_values = {0x00}},
      R"(CMS Horizontal ADS Used; BL - Credit)",
      R"(Number of packets using the Horizontal Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_BYPASS.AD_BNC",
      EventDef::Encoding{.code = 0x9F, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Horizontal Bypass Used; AD - Bounce)",
      R"(Number of packets bypassing the Horizontal Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_BYPASS.AK_BNC",
      EventDef::Encoding{.code = 0x9F, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Horizontal Bypass Used; AK - Bounce)",
      R"(Number of packets bypassing the Horizontal Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_BYPASS.BL_BNC",
      EventDef::Encoding{.code = 0x9F, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Horizontal Bypass Used; BL - Bounce)",
      R"(Number of packets bypassing the Horizontal Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_BYPASS.IV_BNC",
      EventDef::Encoding{.code = 0x9F, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Horizontal Bypass Used; IV - Bounce)",
      R"(Number of packets bypassing the Horizontal Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_BYPASS.AD_CRD",
      EventDef::Encoding{.code = 0x9F, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Horizontal Bypass Used; AD - Credit)",
      R"(Number of packets bypassing the Horizontal Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_BYPASS.BL_CRD",
      EventDef::Encoding{.code = 0x9F, .umask = 0x40, .msr_values = {0x00}},
      R"(CMS Horizontal Bypass Used; BL - Credit)",
      R"(Number of packets bypassing the Horizontal Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_FULL.AD_BNC",
      EventDef::Encoding{.code = 0x96, .umask = 0x01, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Full; AD - Bounce)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Full.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_FULL.AK_BNC",
      EventDef::Encoding{.code = 0x96, .umask = 0x02, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Full; AK - Bounce)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Full.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_FULL.BL_BNC",
      EventDef::Encoding{.code = 0x96, .umask = 0x04, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Full; BL - Bounce)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Full.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_FULL.IV_BNC",
      EventDef::Encoding{.code = 0x96, .umask = 0x08, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Full; IV - Bounce)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Full.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_FULL.AD_CRD",
      EventDef::Encoding{.code = 0x96, .umask = 0x10, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Full; AD - Credit)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Full.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_FULL.BL_CRD",
      EventDef::Encoding{.code = 0x96, .umask = 0x40, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Full; BL - Credit)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Full.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_NE.AD_BNC",
      EventDef::Encoding{.code = 0x97, .umask = 0x01, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Not Empty; AD - Bounce)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Not-Empty.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_NE.AK_BNC",
      EventDef::Encoding{.code = 0x97, .umask = 0x02, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Not Empty; AK - Bounce)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Not-Empty.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_NE.BL_BNC",
      EventDef::Encoding{.code = 0x97, .umask = 0x04, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Not Empty; BL - Bounce)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Not-Empty.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_NE.IV_BNC",
      EventDef::Encoding{.code = 0x97, .umask = 0x08, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Not Empty; IV - Bounce)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Not-Empty.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_NE.AD_CRD",
      EventDef::Encoding{.code = 0x97, .umask = 0x10, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Not Empty; AD - Credit)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Not-Empty.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_CYCLES_NE.BL_CRD",
      EventDef::Encoding{.code = 0x97, .umask = 0x40, .msr_values = {0x00}},
      R"(Cycles CMS Horizontal Egress Queue is Not Empty; BL - Credit)",
      R"(Cycles the Transgress buffers in the Common Mesh Stop are Not-Empty.  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_INSERTS.AD_BNC",
      EventDef::Encoding{.code = 0x95, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Inserts; AD - Bounce)",
      R"(Number of allocations into the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_INSERTS.AK_BNC",
      EventDef::Encoding{.code = 0x95, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Inserts; AK - Bounce)",
      R"(Number of allocations into the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_INSERTS.BL_BNC",
      EventDef::Encoding{.code = 0x95, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Inserts; BL - Bounce)",
      R"(Number of allocations into the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_INSERTS.IV_BNC",
      EventDef::Encoding{.code = 0x95, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Inserts; IV - Bounce)",
      R"(Number of allocations into the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_INSERTS.AD_CRD",
      EventDef::Encoding{.code = 0x95, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Inserts; AD - Credit)",
      R"(Number of allocations into the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_INSERTS.BL_CRD",
      EventDef::Encoding{.code = 0x95, .umask = 0x40, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Inserts; BL - Credit)",
      R"(Number of allocations into the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_NACK.AD_BNC",
      EventDef::Encoding{.code = 0x99, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Horizontal Egress NACKs; AD - Bounce)",
      R"(Counts number of Egress packets NACK'ed on to the Horizontal Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_NACK.AK_BNC",
      EventDef::Encoding{.code = 0x99, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Horizontal Egress NACKs; AK - Bounce)",
      R"(Counts number of Egress packets NACK'ed on to the Horizontal Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_NACK.BL_BNC",
      EventDef::Encoding{.code = 0x99, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Horizontal Egress NACKs; BL - Bounce)",
      R"(Counts number of Egress packets NACK'ed on to the Horizontal Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_NACK.IV_BNC",
      EventDef::Encoding{.code = 0x99, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Horizontal Egress NACKs; IV - Bounce)",
      R"(Counts number of Egress packets NACK'ed on to the Horizontal Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_NACK.AD_CRD",
      EventDef::Encoding{.code = 0x99, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Horizontal Egress NACKs; AD - Credit)",
      R"(Counts number of Egress packets NACK'ed on to the Horizontal Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_NACK.BL_CRD",
      EventDef::Encoding{.code = 0x99, .umask = 0x40, .msr_values = {0x00}},
      R"(CMS Horizontal Egress NACKs; BL - Credit)",
      R"(Counts number of Egress packets NACK'ed on to the Horizontal Ring)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_OCCUPANCY.AD_BNC",
      EventDef::Encoding{.code = 0x94, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Occupancy; AD - Bounce)",
      R"(Occupancy event for the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_OCCUPANCY.AK_BNC",
      EventDef::Encoding{.code = 0x94, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Occupancy; AK - Bounce)",
      R"(Occupancy event for the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_OCCUPANCY.BL_BNC",
      EventDef::Encoding{.code = 0x94, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Occupancy; BL - Bounce)",
      R"(Occupancy event for the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_OCCUPANCY.IV_BNC",
      EventDef::Encoding{.code = 0x94, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Occupancy; IV - Bounce)",
      R"(Occupancy event for the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_OCCUPANCY.AD_CRD",
      EventDef::Encoding{.code = 0x94, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Occupancy; AD - Credit)",
      R"(Occupancy event for the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_OCCUPANCY.BL_CRD",
      EventDef::Encoding{.code = 0x94, .umask = 0x40, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Occupancy; BL - Credit)",
      R"(Occupancy event for the Transgress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Horizontal Ring on the Mesh.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_STARVED.AD_BNC",
      EventDef::Encoding{.code = 0x9B, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Injection Starvation; AD - Bounce)",
      R"(Counts injection starvation.  This starvation is triggered when the CMS Transgress buffer cannot send a transaction onto the Horizontal ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_STARVED.AK_BNC",
      EventDef::Encoding{.code = 0x9B, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Injection Starvation; AK - Bounce)",
      R"(Counts injection starvation.  This starvation is triggered when the CMS Transgress buffer cannot send a transaction onto the Horizontal ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_STARVED.BL_BNC",
      EventDef::Encoding{.code = 0x9B, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Injection Starvation; BL - Bounce)",
      R"(Counts injection starvation.  This starvation is triggered when the CMS Transgress buffer cannot send a transaction onto the Horizontal ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_HORZ_STARVED.IV_BNC",
      EventDef::Encoding{.code = 0x9B, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Horizontal Egress Injection Starvation; IV - Bounce)",
      R"(Counts injection starvation.  This starvation is triggered when the CMS Transgress buffer cannot send a transaction onto the Horizontal ring for a long period of time.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_ADS_USED.AD_AG0",
      EventDef::Encoding{.code = 0x9C, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; AD - Agent 0)",
      R"(Number of packets using the Vertical Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_ADS_USED.AK_AG0",
      EventDef::Encoding{.code = 0x9C, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; AK - Agent 0)",
      R"(Number of packets using the Vertical Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_ADS_USED.BL_AG0",
      EventDef::Encoding{.code = 0x9C, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; BL - Agent 0)",
      R"(Number of packets using the Vertical Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_ADS_USED.AD_AG1",
      EventDef::Encoding{.code = 0x9C, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; AD - Agent 1)",
      R"(Number of packets using the Vertical Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_ADS_USED.AK_AG1",
      EventDef::Encoding{.code = 0x9C, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; AK - Agent 1)",
      R"(Number of packets using the Vertical Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_ADS_USED.BL_AG1",
      EventDef::Encoding{.code = 0x9C, .umask = 0x40, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; BL - Agent 1)",
      R"(Number of packets using the Vertical Anti-Deadlock Slot, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_BYPASS.AD_AG0",
      EventDef::Encoding{.code = 0x9E, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; AD - Agent 0)",
      R"(Number of packets bypassing the Vertical Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_BYPASS.AK_AG0",
      EventDef::Encoding{.code = 0x9E, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; AK - Agent 0)",
      R"(Number of packets bypassing the Vertical Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_BYPASS.BL_AG0",
      EventDef::Encoding{.code = 0x9E, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; BL - Agent 0)",
      R"(Number of packets bypassing the Vertical Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_BYPASS.IV",
      EventDef::Encoding{.code = 0x9E, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; IV)",
      R"(Number of packets bypassing the Vertical Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_BYPASS.AD_AG1",
      EventDef::Encoding{.code = 0x9E, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; AD - Agent 1)",
      R"(Number of packets bypassing the Vertical Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_BYPASS.AK_AG1",
      EventDef::Encoding{.code = 0x9E, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; AK - Agent 1)",
      R"(Number of packets bypassing the Vertical Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_BYPASS.BL_AG1",
      EventDef::Encoding{.code = 0x9E, .umask = 0x40, .msr_values = {0x00}},
      R"(CMS Vertical ADS Used; BL - Agent 1)",
      R"(Number of packets bypassing the Vertical Egress, broken down by ring type and CMS Agent.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_FULL.AD_AG0",
      EventDef::Encoding{.code = 0x92, .umask = 0x01, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Full; AD - Agent 0)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Full.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the AD ring.  Some example include outbound requests, snoop requests, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_FULL.AK_AG0",
      EventDef::Encoding{.code = 0x92, .umask = 0x02, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Full; AK - Agent 0)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Full.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the AK ring.  This is commonly used for credit returns and GO responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_FULL.BL_AG0",
      EventDef::Encoding{.code = 0x92, .umask = 0x04, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Full; BL - Agent 0)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Full.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the BL ring.  This is commonly used to send data from the cache to various destinations.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_FULL.IV",
      EventDef::Encoding{.code = 0x92, .umask = 0x08, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Full; IV)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Full.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the IV ring.  This is commonly used for snoops to the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_FULL.AD_AG1",
      EventDef::Encoding{.code = 0x92, .umask = 0x10, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Full; AD - Agent 1)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Full.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the AD ring.  This is commonly used for outbound requests.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_FULL.AK_AG1",
      EventDef::Encoding{.code = 0x92, .umask = 0x20, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Full; AK - Agent 1)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Full.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the AK ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_FULL.BL_AG1",
      EventDef::Encoding{.code = 0x92, .umask = 0x40, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Full; BL - Agent 1)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Full.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the BL ring.  This is commonly used for transferring writeback data to the cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_NE.AD_AG0",
      EventDef::Encoding{.code = 0x93, .umask = 0x01, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Not Empty; AD - Agent 0)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Empty.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the AD ring.  Some example include outbound requests, snoop requests, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_NE.AK_AG0",
      EventDef::Encoding{.code = 0x93, .umask = 0x02, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Not Empty; AK - Agent 0)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Empty.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the AK ring.  This is commonly used for credit returns and GO responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_NE.BL_AG0",
      EventDef::Encoding{.code = 0x93, .umask = 0x04, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Not Empty; BL - Agent 0)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Empty.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the BL ring.  This is commonly used to send data from the cache to various destinations.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_NE.IV",
      EventDef::Encoding{.code = 0x93, .umask = 0x08, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Not Empty; IV)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Empty.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the IV ring.  This is commonly used for snoops to the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_NE.AD_AG1",
      EventDef::Encoding{.code = 0x93, .umask = 0x10, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Not Empty; AD - Agent 1)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Empty.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the AD ring.  This is commonly used for outbound requests.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_NE.AK_AG1",
      EventDef::Encoding{.code = 0x93, .umask = 0x20, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Not Empty; AK - Agent 1)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Empty.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the AK ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_CYCLES_NE.BL_AG1",
      EventDef::Encoding{.code = 0x93, .umask = 0x40, .msr_values = {0x00}},
      R"(Cycles CMS Vertical Egress Queue Is Not Empty; BL - Agent 1)",
      R"(Number of cycles the Common Mesh Stop Egress was Not Empty.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the BL ring.  This is commonly used for transferring writeback data to the cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_INSERTS.AD_AG0",
      EventDef::Encoding{.code = 0x91, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Vert Egress Allocations; AD - Agent 0)",
      R"(Number of allocations into the Common Mesh Stop Egress.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the AD ring.  Some example include outbound requests, snoop requests, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_INSERTS.AK_AG0",
      EventDef::Encoding{.code = 0x91, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Vert Egress Allocations; AK - Agent 0)",
      R"(Number of allocations into the Common Mesh Stop Egress.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the AK ring.  This is commonly used for credit returns and GO responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_INSERTS.BL_AG0",
      EventDef::Encoding{.code = 0x91, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Vert Egress Allocations; BL - Agent 0)",
      R"(Number of allocations into the Common Mesh Stop Egress.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the BL ring.  This is commonly used to send data from the cache to various destinations.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_INSERTS.IV",
      EventDef::Encoding{.code = 0x91, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Vert Egress Allocations; IV)",
      R"(Number of allocations into the Common Mesh Stop Egress.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the IV ring.  This is commonly used for snoops to the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_INSERTS.AD_AG1",
      EventDef::Encoding{.code = 0x91, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Vert Egress Allocations; AD - Agent 1)",
      R"(Number of allocations into the Common Mesh Stop Egress.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the AD ring.  This is commonly used for outbound requests.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_INSERTS.AK_AG1",
      EventDef::Encoding{.code = 0x91, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Vert Egress Allocations; AK - Agent 1)",
      R"(Number of allocations into the Common Mesh Stop Egress.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the AK ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_INSERTS.BL_AG1",
      EventDef::Encoding{.code = 0x91, .umask = 0x40, .msr_values = {0x00}},
      R"(CMS Vert Egress Allocations; BL - Agent 1)",
      R"(Number of allocations into the Common Mesh Stop Egress.  The Egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the BL ring.  This is commonly used for transferring writeback data to the cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_OCCUPANCY.AD_AG0",
      EventDef::Encoding{.code = 0x90, .umask = 0x01, .msr_values = {0x00}},
      R"(CMS Vert Egress Occupancy; AD - Agent 0)",
      R"(Occupancy event for the Egress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the AD ring.  Some example include outbound requests, snoop requests, and snoop responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_OCCUPANCY.AK_AG0",
      EventDef::Encoding{.code = 0x90, .umask = 0x02, .msr_values = {0x00}},
      R"(CMS Vert Egress Occupancy; AK - Agent 0)",
      R"(Occupancy event for the Egress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the AK ring.  This is commonly used for credit returns and GO responses.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_OCCUPANCY.BL_AG0",
      EventDef::Encoding{.code = 0x90, .umask = 0x04, .msr_values = {0x00}},
      R"(CMS Vert Egress Occupancy; BL - Agent 0)",
      R"(Occupancy event for the Egress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the BL ring.  This is commonly used to send data from the cache to various destinations.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_OCCUPANCY.IV",
      EventDef::Encoding{.code = 0x90, .umask = 0x08, .msr_values = {0x00}},
      R"(CMS Vert Egress Occupancy; IV)",
      R"(Occupancy event for the Egress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 0 destined for the IV ring.  This is commonly used for snoops to the cores.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_OCCUPANCY.AD_AG1",
      EventDef::Encoding{.code = 0x90, .umask = 0x10, .msr_values = {0x00}},
      R"(CMS Vert Egress Occupancy; AD - Agent 1)",
      R"(Occupancy event for the Egress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the AD ring.  This is commonly used for outbound requests.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_OCCUPANCY.AK_AG1",
      EventDef::Encoding{.code = 0x90, .umask = 0x20, .msr_values = {0x00}},
      R"(CMS Vert Egress Occupancy; AK - Agent 1)",
      R"(Occupancy event for the Egress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the AK ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_TxR_VERT_OCCUPANCY.BL_AG1",
      EventDef::Encoding{.code = 0x90, .umask = 0x40, .msr_values = {0x00}},
      R"(CMS Vert Egress Occupancy; BL - Agent 1)",
      R"(Occupancy event for the Egress buffers in the Common Mesh Stop  The egress is used to queue up requests destined for the Vertical Ring on the Mesh.; Ring transactions from Agent 1 destined for the BL ring.  This is commonly used for transferring writeback data to the cache.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_AD_IN_USE.UP_EVEN",
      EventDef::Encoding{.code = 0xA6, .umask = 0x01, .msr_values = {0x00}},
      R"(Vertical AD Ring In Use; Up and Even)",
      R"(Counts the number of cycles that the Vertical AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings  -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_AD_IN_USE.UP_ODD",
      EventDef::Encoding{.code = 0xA6, .umask = 0x02, .msr_values = {0x00}},
      R"(Vertical AD Ring In Use; Up and Odd)",
      R"(Counts the number of cycles that the Vertical AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings  -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_AD_IN_USE.DN_EVEN",
      EventDef::Encoding{.code = 0xA6, .umask = 0x04, .msr_values = {0x00}},
      R"(Vertical AD Ring In Use; Down and Even)",
      R"(Counts the number of cycles that the Vertical AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings  -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_AD_IN_USE.DN_ODD",
      EventDef::Encoding{.code = 0xA6, .umask = 0x08, .msr_values = {0x00}},
      R"(Vertical AD Ring In Use; Down and Odd)",
      R"(Counts the number of cycles that the Vertical AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings  -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_AK_IN_USE.UP_EVEN",
      EventDef::Encoding{.code = 0xA8, .umask = 0x01, .msr_values = {0x00}},
      R"(Vertical AK Ring In Use; Up and Even)",
      R"(Counts the number of cycles that the Vertical AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_AK_IN_USE.UP_ODD",
      EventDef::Encoding{.code = 0xA8, .umask = 0x02, .msr_values = {0x00}},
      R"(Vertical AK Ring In Use; Up and Odd)",
      R"(Counts the number of cycles that the Vertical AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_AK_IN_USE.DN_EVEN",
      EventDef::Encoding{.code = 0xA8, .umask = 0x04, .msr_values = {0x00}},
      R"(Vertical AK Ring In Use; Down and Even)",
      R"(Counts the number of cycles that the Vertical AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_AK_IN_USE.DN_ODD",
      EventDef::Encoding{.code = 0xA8, .umask = 0x08, .msr_values = {0x00}},
      R"(Vertical AK Ring In Use; Down and Odd)",
      R"(Counts the number of cycles that the Vertical AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_BL_IN_USE.UP_EVEN",
      EventDef::Encoding{.code = 0xAA, .umask = 0x01, .msr_values = {0x00}},
      R"(Vertical BL Ring in Use; Up and Even)",
      R"(Counts the number of cycles that the Vertical BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_BL_IN_USE.UP_ODD",
      EventDef::Encoding{.code = 0xAA, .umask = 0x02, .msr_values = {0x00}},
      R"(Vertical BL Ring in Use; Up and Odd)",
      R"(Counts the number of cycles that the Vertical BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_BL_IN_USE.DN_EVEN",
      EventDef::Encoding{.code = 0xAA, .umask = 0x04, .msr_values = {0x00}},
      R"(Vertical BL Ring in Use; Down and Even)",
      R"(Counts the number of cycles that the Vertical BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_BL_IN_USE.DN_ODD",
      EventDef::Encoding{.code = 0xAA, .umask = 0x08, .msr_values = {0x00}},
      R"(Vertical BL Ring in Use; Down and Odd)",
      R"(Counts the number of cycles that the Vertical BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from  the ring stop.We really have two rings -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the UP direction is on the clockwise ring and DN is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_IV_IN_USE.UP",
      EventDef::Encoding{.code = 0xAC, .umask = 0x01, .msr_values = {0x00}},
      R"(Vertical IV Ring in Use; Up)",
      R"(Counts the number of cycles that the Vertical IV ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  There is only 1 IV ring.  Therefore, if one wants to monitor the Even ring, they should select both UP_EVEN and DN_EVEN.  To monitor the Odd ring, they should select both UP_ODD and DN_ODD.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_VERT_RING_IV_IN_USE.DN",
      EventDef::Encoding{.code = 0xAC, .umask = 0x04, .msr_values = {0x00}},
      R"(Vertical IV Ring in Use; Down)",
      R"(Counts the number of cycles that the Vertical IV ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  There is only 1 IV ring.  Therefore, if one wants to monitor the Even ring, they should select both UP_EVEN and DN_EVEN.  To monitor the Odd ring, they should select both UP_ODD and DN_ODD.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_cha,
      "UNC_CHA_FAST_ASSERTED.VERT",
      EventDef::Encoding{.code = 0xA5, .umask = 0x01, .msr_values = {0x00}},
      R"(FaST wire asserted; Vertical)",
      R"(Counts the number of cycles either the local or incoming distress signals are asserted.  Incoming distress includes up, dn and across.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.PART0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core writing to Card's PCICFG space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; x16 card plugged in to stack, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.PART1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core writing to Card's PCICFG space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.PART2",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core writing to Card's PCICFG space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.PART3",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core writing to Card's PCICFG space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.PART0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core writing to Card's IO space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; x16 card plugged in to stack, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.PART1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core writing to Card's IO space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.PART2",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core writing to Card's IO space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.PART3",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core writing to Card's IO space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.PART0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core reading from Card's PCICFG space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; x16 card plugged in to stack, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.PART1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core reading from Card's PCICFG space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.PART2",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core reading from Card's PCICFG space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.PART3",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core reading from Card's PCICFG space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.PART0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core reading from Card's IO space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; x16 card plugged in to stack, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.PART1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core reading from Card's IO space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.PART2",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core reading from Card's IO space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.PART3",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core reading from Card's IO space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.VTD0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core reading from Card's PCICFG space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; VTd - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_READ.VTD1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x40, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core reading from Card's PCICFG space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; VTd - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.VTD0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core writing to Card's PCICFG space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; VTd - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.CFG_WRITE.VTD1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x10, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core writing to Card's PCICFG space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; VTd - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.VTD0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core reading from Card's IO space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; VTd - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_READ.VTD1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x80, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core reading from Card's IO space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; VTd - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.VTD0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core writing to Card's IO space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; VTd - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.IO_WRITE.VTD1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x20, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core writing to Card's IO space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; VTd - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.MEM_READ.VTD0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x04, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core reading from Card's MMIO space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; VTd - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.MEM_READ.VTD1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x04, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core reading from Card's MMIO space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; VTd - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.MEM_WRITE.VTD0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x01, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core writing to Card's MMIO space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; VTd - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.MEM_WRITE.VTD1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x01, .msr_values = {0x00}},
      R"(Data requested by the CPU; Core writing to Card's MMIO space)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; VTd - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.VTD0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x08, .msr_values = {0x00}},
      R"(Data requested by the CPU; Another card (different IIO stack) reading from this card.)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; VTd - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_READ.VTD1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x08, .msr_values = {0x00}},
      R"(Data requested by the CPU; Another card (different IIO stack) reading from this card.)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; VTd - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.VTD0",
      EventDef::Encoding{.code = 0xC0, .umask = 0x02, .msr_values = {0x00}},
      R"(Data requested by the CPU; Another card (different IIO stack) writing to this card.)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; VTd - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_BY_CPU.PEER_WRITE.VTD1",
      EventDef::Encoding{.code = 0xC0, .umask = 0x02, .msr_values = {0x00}},
      R"(Data requested by the CPU; Another card (different IIO stack) writing to this card.)",
      R"(Number of double word (4 bytes) requests initiated by the main die to the attached device.; VTd - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.PART0",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .msr_values = {0x00}},
      R"(Data requested of the CPU; Atomic requests targeting DRAM)",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; x16 card plugged in to stack, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.PART1",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .msr_values = {0x00}},
      R"(Data requested of the CPU; Atomic requests targeting DRAM)",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.PART2",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .msr_values = {0x00}},
      R"(Data requested of the CPU; Atomic requests targeting DRAM)",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.PART3",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .msr_values = {0x00}},
      R"(Data requested of the CPU; Atomic requests targeting DRAM)",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMICCMP.PART0",
      EventDef::Encoding{.code = 0x83, .umask = 0x20, .msr_values = {0x00}},
      R"(Data requested of the CPU; Completion of atomic requests targeting DRAM)",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; x16 card plugged in to stack, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMICCMP.PART1",
      EventDef::Encoding{.code = 0x83, .umask = 0x20, .msr_values = {0x00}},
      R"(Data requested of the CPU; Completion of atomic requests targeting DRAM)",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMICCMP.PART2",
      EventDef::Encoding{.code = 0x83, .umask = 0x20, .msr_values = {0x00}},
      R"(Data requested of the CPU; Completion of atomic requests targeting DRAM)",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMICCMP.PART3",
      EventDef::Encoding{.code = 0x83, .umask = 0x20, .msr_values = {0x00}},
      R"(Data requested of the CPU; Completion of atomic requests targeting DRAM)",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.PART0",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .msr_values = {0x00}},
      R"(Data requested of the CPU; Messages)",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; x16 card plugged in to stack, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.PART1",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .msr_values = {0x00}},
      R"(Data requested of the CPU; Messages)",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.PART2",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .msr_values = {0x00}},
      R"(Data requested of the CPU; Messages)",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.PART3",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .msr_values = {0x00}},
      R"(Data requested of the CPU; Messages)",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.VTD0",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .msr_values = {0x00}},
      R"(Data requested of the CPU; Atomic requests targeting DRAM)",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; VTd - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.ATOMIC.VTD1",
      EventDef::Encoding{.code = 0x83, .umask = 0x10, .msr_values = {0x00}},
      R"(Data requested of the CPU; Atomic requests targeting DRAM)",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; VTd - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MEM_READ.VTD0",
      EventDef::Encoding{.code = 0x83, .umask = 0x04, .msr_values = {0x00}},
      R"(Data requested of the CPU; Card reading from DRAM)",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; VTd - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MEM_READ.VTD1",
      EventDef::Encoding{.code = 0x83, .umask = 0x04, .msr_values = {0x00}},
      R"(Data requested of the CPU; Card reading from DRAM)",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; VTd - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MEM_WRITE.VTD0",
      EventDef::Encoding{.code = 0x83, .umask = 0x01, .msr_values = {0x00}},
      R"(Data requested of the CPU; Card writing to DRAM)",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; VTd - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MEM_WRITE.VTD1",
      EventDef::Encoding{.code = 0x83, .umask = 0x01, .msr_values = {0x00}},
      R"(Data requested of the CPU; Card writing to DRAM)",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; VTd - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.VTD0",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .msr_values = {0x00}},
      R"(Data requested of the CPU; Messages)",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; VTd - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.MSG.VTD1",
      EventDef::Encoding{.code = 0x83, .umask = 0x40, .msr_values = {0x00}},
      R"(Data requested of the CPU; Messages)",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; VTd - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_READ.VTD0",
      EventDef::Encoding{.code = 0x83, .umask = 0x08, .msr_values = {0x00}},
      R"(Data requested of the CPU; Card reading from another Card (same or different stack))",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; VTd - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_READ.VTD1",
      EventDef::Encoding{.code = 0x83, .umask = 0x08, .msr_values = {0x00}},
      R"(Data requested of the CPU; Card reading from another Card (same or different stack))",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; VTd - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.VTD0",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .msr_values = {0x00}},
      R"(Data requested of the CPU; Card writing to another Card (same or different stack))",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; VTd - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_DATA_REQ_OF_CPU.PEER_WRITE.VTD1",
      EventDef::Encoding{.code = 0x83, .umask = 0x02, .msr_values = {0x00}},
      R"(Data requested of the CPU; Card writing to another Card (same or different stack))",
      R"(Number of double word (4 bytes) requests the attached device made of the main die.; VTd - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.PART0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core writing to Card's PCICFG space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; x16 card plugged in to stack, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.PART1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core writing to Card's PCICFG space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.PART2",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core writing to Card's PCICFG space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.PART3",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core writing to Card's PCICFG space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.PART0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core writing to Card's IO space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; x16 card plugged in to stack, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.PART1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core writing to Card's IO space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.PART2",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core writing to Card's IO space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.PART3",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core writing to Card's IO space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.PART0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core reading from Card's PCICFG space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; x16 card plugged in to stack, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.PART1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core reading from Card's PCICFG space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.PART2",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core reading from Card's PCICFG space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.PART3",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core reading from Card's PCICFG space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.PART0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core reading from Card's IO space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; x16 card plugged in to stack, Or x8 card plugged in to Lane 0/1, Or x4 card is plugged in to slot 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.PART1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core reading from Card's IO space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; x4 card is plugged in to slot 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.PART2",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core reading from Card's IO space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; x8 card plugged in to Lane 2/3, Or x4 card is plugged in to slot 2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.PART3",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core reading from Card's IO space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; x4 card is plugged in to slot 3)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.VTD0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core reading from Card's PCICFG space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; VTd - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_READ.VTD1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x40, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core reading from Card's PCICFG space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; VTd - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.VTD0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core writing to Card's PCICFG space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; VTd - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.VTD0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core reading from Card's IO space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; VTd - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_READ.VTD1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x80, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core reading from Card's IO space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; VTd - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.VTD0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core writing to Card's IO space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; VTd - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.IO_WRITE.VTD1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x20, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core writing to Card's IO space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; VTd - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.MEM_READ.VTD0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x04, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core reading from Card's MMIO space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; VTd - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.MEM_READ.VTD1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x04, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core reading from Card's MMIO space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; VTd - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.MEM_WRITE.VTD0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x01, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core writing to Card's MMIO space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; VTd - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.MEM_WRITE.VTD1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x01, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core writing to Card's MMIO space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; VTd - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_READ.VTD0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x08, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Another card (different IIO stack) reading from this card.)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; VTd - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_READ.VTD1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x08, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Another card (different IIO stack) reading from this card.)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; VTd - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_WRITE.VTD0",
      EventDef::Encoding{.code = 0xC1, .umask = 0x02, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Another card (different IIO stack) writing to this card.)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; VTd - Type 0)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.PEER_WRITE.VTD1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x02, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Another card (different IIO stack) writing to this card.)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; VTd - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_iio,
      "UNC_IIO_TXN_REQ_BY_CPU.CFG_WRITE.VTD1",
      EventDef::Encoding{.code = 0xC1, .umask = 0x10, .msr_values = {0x00}},
      R"(Number Transactions requested by the CPU; Core writing to Card's PCICFG space)",
      R"(Also known as Outbound.  Number of requests, to the attached device, initiated by the main die.; VTd - Type 1)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_CHA_AD_CREDITS_EMPTY.VNA",
      EventDef::Encoding{.code = 0x22, .umask = 0x01, .msr_values = {0x00}},
      R"(CBox AD Credits Empty; VNA Messages)",
      R"(No credits available to send to Cbox on the AD Ring (covers higher CBoxes))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_CHA_AD_CREDITS_EMPTY.WB",
      EventDef::Encoding{.code = 0x22, .umask = 0x02, .msr_values = {0x00}},
      R"(CBox AD Credits Empty; Writebacks)",
      R"(No credits available to send to Cbox on the AD Ring (covers higher CBoxes))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_CHA_AD_CREDITS_EMPTY.REQ",
      EventDef::Encoding{.code = 0x22, .umask = 0x04, .msr_values = {0x00}},
      R"(CBox AD Credits Empty; Requests)",
      R"(No credits available to send to Cbox on the AD Ring (covers higher CBoxes))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_CHA_AD_CREDITS_EMPTY.SNP",
      EventDef::Encoding{.code = 0x22, .umask = 0x08, .msr_values = {0x00}},
      R"(CBox AD Credits Empty; Snoops)",
      R"(No credits available to send to Cbox on the AD Ring (covers higher CBoxes))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_CLOCKTICKS",
      EventDef::Encoding{.code = 0x1, .umask = 0x00, .msr_values = {0x00}},
      R"(Number of uclks in domain)",
      R"(Counts the number of uclks in the M3 uclk domain.  This could be slightly different than the count in the Ubox because of enable/freeze delays.  However, because the M3 is close to the Ubox, they generally should not diverge by more than a handful of cycles.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_D2U_SENT",
      EventDef::Encoding{.code = 0x2A, .umask = 0x0, .msr_values = {0x00}},
      R"(D2U Sent)",
      R"(Cases where SMI3 sends D2U command)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_M2_BL_CREDITS_EMPTY.IIO0_IIO1_NCB",
      EventDef::Encoding{.code = 0x23, .umask = 0x01, .msr_values = {0x00}},
      R"(M2 BL Credits Empty; IIO0 and IIO1 share the same ring destination. (1 VN0 credit only))",
      R"(No vn0 and vna credits available to send to M2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_M2_BL_CREDITS_EMPTY.IIO2_NCB",
      EventDef::Encoding{.code = 0x23, .umask = 0x02, .msr_values = {0x00}},
      R"(M2 BL Credits Empty; IIO2)",
      R"(No vn0 and vna credits available to send to M2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_M2_BL_CREDITS_EMPTY.IIO3_NCB",
      EventDef::Encoding{.code = 0x23, .umask = 0x04, .msr_values = {0x00}},
      R"(M2 BL Credits Empty; IIO3)",
      R"(No vn0 and vna credits available to send to M2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_M2_BL_CREDITS_EMPTY.IIO4_NCB",
      EventDef::Encoding{.code = 0x23, .umask = 0x08, .msr_values = {0x00}},
      R"(M2 BL Credits Empty; IIO4)",
      R"(No vn0 and vna credits available to send to M2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_M2_BL_CREDITS_EMPTY.IIO5_NCB",
      EventDef::Encoding{.code = 0x23, .umask = 0x10, .msr_values = {0x00}},
      R"(M2 BL Credits Empty; IIO5)",
      R"(No vn0 and vna credits available to send to M2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_M2_BL_CREDITS_EMPTY.NCS",
      EventDef::Encoding{.code = 0x23, .umask = 0x20, .msr_values = {0x00}},
      R"(M2 BL Credits Empty; All IIO targets for NCS are in single mask. ORs them together)",
      R"(No vn0 and vna credits available to send to M2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_M2_BL_CREDITS_EMPTY.NCS_SEL",
      EventDef::Encoding{.code = 0x23, .umask = 0x40, .msr_values = {0x00}},
      R"(M2 BL Credits Empty; Selected M2p BL NCS credits)",
      R"(No vn0 and vna credits available to send to M2)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_MULTI_SLOT_RCVD.AD_SLOT0",
      EventDef::Encoding{.code = 0x3E, .umask = 0x01, .msr_values = {0x00}},
      R"(Multi Slot Flit Received; AD - Slot 0)",
      R"(Multi slot flit received - S0, S1 and/or S2 populated (can use AK S0/S1 masks for AK allocations))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_MULTI_SLOT_RCVD.AD_SLOT1",
      EventDef::Encoding{.code = 0x3E, .umask = 0x02, .msr_values = {0x00}},
      R"(Multi Slot Flit Received; AD - Slot 1)",
      R"(Multi slot flit received - S0, S1 and/or S2 populated (can use AK S0/S1 masks for AK allocations))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_MULTI_SLOT_RCVD.AD_SLOT2",
      EventDef::Encoding{.code = 0x3E, .umask = 0x04, .msr_values = {0x00}},
      R"(Multi Slot Flit Received; AD - Slot 2)",
      R"(Multi slot flit received - S0, S1 and/or S2 populated (can use AK S0/S1 masks for AK allocations))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_MULTI_SLOT_RCVD.BL_SLOT0",
      EventDef::Encoding{.code = 0x3E, .umask = 0x08, .msr_values = {0x00}},
      R"(Multi Slot Flit Received; BL - Slot 0)",
      R"(Multi slot flit received - S0, S1 and/or S2 populated (can use AK S0/S1 masks for AK allocations))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_MULTI_SLOT_RCVD.AK_SLOT0",
      EventDef::Encoding{.code = 0x3E, .umask = 0x10, .msr_values = {0x00}},
      R"(Multi Slot Flit Received; AK - Slot 0)",
      R"(Multi slot flit received - S0, S1 and/or S2 populated (can use AK S0/S1 masks for AK allocations))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_MULTI_SLOT_RCVD.AK_SLOT2",
      EventDef::Encoding{.code = 0x3E, .umask = 0x20, .msr_values = {0x00}},
      R"(Multi Slot Flit Received; AK - Slot 2)",
      R"(Multi slot flit received - S0, S1 and/or S2 populated (can use AK S0/S1 masks for AK allocations))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_ARB_FAIL.VN0_REQ",
      EventDef::Encoding{.code = 0x30, .umask = 0x01, .msr_values = {0x00}},
      R"(Failed ARB for AD; VN0 REQ Messages)",
      R"(AD arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_ARB_FAIL.VN0_SNP",
      EventDef::Encoding{.code = 0x30, .umask = 0x02, .msr_values = {0x00}},
      R"(Failed ARB for AD; VN0 SNP Messages)",
      R"(AD arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_ARB_FAIL.VN0_RSP",
      EventDef::Encoding{.code = 0x30, .umask = 0x04, .msr_values = {0x00}},
      R"(Failed ARB for AD; VN0 RSP Messages)",
      R"(AD arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_ARB_FAIL.VN0_WB",
      EventDef::Encoding{.code = 0x30, .umask = 0x08, .msr_values = {0x00}},
      R"(Failed ARB for AD; VN0 WB Messages)",
      R"(AD arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_ARB_FAIL.VN1_REQ",
      EventDef::Encoding{.code = 0x30, .umask = 0x10, .msr_values = {0x00}},
      R"(Failed ARB for AD; VN1 REQ Messages)",
      R"(AD arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_ARB_FAIL.VN1_SNP",
      EventDef::Encoding{.code = 0x30, .umask = 0x20, .msr_values = {0x00}},
      R"(Failed ARB for AD; VN1 SNP Messages)",
      R"(AD arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_ARB_FAIL.VN1_RSP",
      EventDef::Encoding{.code = 0x30, .umask = 0x40, .msr_values = {0x00}},
      R"(Failed ARB for AD; VN1 RSP Messages)",
      R"(AD arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_ARB_FAIL.VN1_WB",
      EventDef::Encoding{.code = 0x30, .umask = 0x80, .msr_values = {0x00}},
      R"(Failed ARB for AD; VN1 WB Messages)",
      R"(AD arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_BYPASS.AD_SLOT0",
      EventDef::Encoding{.code = 0x2C, .umask = 0x01, .msr_values = {0x00}},
      R"(AD FlowQ Bypass)",
      R"(Counts cases when the AD flowQ is bypassed (S0, S1 and S2 indicate which slot was bypassed with S0 having the highest priority and S2 the least))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_BYPASS.AD_SLOT1",
      EventDef::Encoding{.code = 0x2C, .umask = 0x02, .msr_values = {0x00}},
      R"(AD FlowQ Bypass)",
      R"(Counts cases when the AD flowQ is bypassed (S0, S1 and S2 indicate which slot was bypassed with S0 having the highest priority and S2 the least))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_BYPASS.AD_SLOT2",
      EventDef::Encoding{.code = 0x2C, .umask = 0x04, .msr_values = {0x00}},
      R"(AD FlowQ Bypass)",
      R"(Counts cases when the AD flowQ is bypassed (S0, S1 and S2 indicate which slot was bypassed with S0 having the highest priority and S2 the least))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_BYPASS.BL_EARLY_RSP",
      EventDef::Encoding{.code = 0x2C, .umask = 0x08, .msr_values = {0x00}},
      R"(AD FlowQ Bypass)",
      R"(Counts cases when the AD flowQ is bypassed (S0, S1 and S2 indicate which slot was bypassed with S0 having the highest priority and S2 the least))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_CYCLES_NE.VN0_REQ",
      EventDef::Encoding{.code = 0x27, .umask = 0x01, .msr_values = {0x00}},
      R"(AD Flow Q Not Empty; VN0 REQ Messages)",
      R"(Number of cycles the AD Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_CYCLES_NE.VN0_SNP",
      EventDef::Encoding{.code = 0x27, .umask = 0x02, .msr_values = {0x00}},
      R"(AD Flow Q Not Empty; VN0 SNP Messages)",
      R"(Number of cycles the AD Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_CYCLES_NE.VN0_RSP",
      EventDef::Encoding{.code = 0x27, .umask = 0x04, .msr_values = {0x00}},
      R"(AD Flow Q Not Empty; VN0 RSP Messages)",
      R"(Number of cycles the AD Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_CYCLES_NE.VN0_WB",
      EventDef::Encoding{.code = 0x27, .umask = 0x08, .msr_values = {0x00}},
      R"(AD Flow Q Not Empty; VN0 WB Messages)",
      R"(Number of cycles the AD Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_CYCLES_NE.VN1_REQ",
      EventDef::Encoding{.code = 0x27, .umask = 0x10, .msr_values = {0x00}},
      R"(AD Flow Q Not Empty; VN1 REQ Messages)",
      R"(Number of cycles the AD Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_CYCLES_NE.VN1_SNP",
      EventDef::Encoding{.code = 0x27, .umask = 0x20, .msr_values = {0x00}},
      R"(AD Flow Q Not Empty; VN1 SNP Messages)",
      R"(Number of cycles the AD Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_CYCLES_NE.VN1_RSP",
      EventDef::Encoding{.code = 0x27, .umask = 0x40, .msr_values = {0x00}},
      R"(AD Flow Q Not Empty; VN1 RSP Messages)",
      R"(Number of cycles the AD Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_CYCLES_NE.VN1_WB",
      EventDef::Encoding{.code = 0x27, .umask = 0x80, .msr_values = {0x00}},
      R"(AD Flow Q Not Empty; VN1 WB Messages)",
      R"(Number of cycles the AD Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_INSERTS.VN0_REQ",
      EventDef::Encoding{.code = 0x2D, .umask = 0x01, .msr_values = {0x00}},
      R"(AD Flow Q Inserts; VN0 REQ Messages)",
      R"(Counts the number of allocations into the QPI FlowQ. This can be used in conjunction with the QPI FlowQ Occupancy Accumulator event in order to calculate average queue latency.  Only a single FlowQ queue can be tracked at any given time.  It is not possible to filter based on direction or polarity.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_INSERTS.VN0_SNP",
      EventDef::Encoding{.code = 0x2D, .umask = 0x02, .msr_values = {0x00}},
      R"(AD Flow Q Inserts; VN0 SNP Messages)",
      R"(Counts the number of allocations into the QPI FlowQ. This can be used in conjunction with the QPI FlowQ Occupancy Accumulator event in order to calculate average queue latency.  Only a single FlowQ queue can be tracked at any given time.  It is not possible to filter based on direction or polarity.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_INSERTS.VN0_RSP",
      EventDef::Encoding{.code = 0x2D, .umask = 0x04, .msr_values = {0x00}},
      R"(AD Flow Q Inserts; VN0 RSP Messages)",
      R"(Counts the number of allocations into the QPI FlowQ. This can be used in conjunction with the QPI FlowQ Occupancy Accumulator event in order to calculate average queue latency.  Only a single FlowQ queue can be tracked at any given time.  It is not possible to filter based on direction or polarity.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_INSERTS.VN0_WB",
      EventDef::Encoding{.code = 0x2D, .umask = 0x08, .msr_values = {0x00}},
      R"(AD Flow Q Inserts; VN0 WB Messages)",
      R"(Counts the number of allocations into the QPI FlowQ. This can be used in conjunction with the QPI FlowQ Occupancy Accumulator event in order to calculate average queue latency.  Only a single FlowQ queue can be tracked at any given time.  It is not possible to filter based on direction or polarity.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_INSERTS.VN1_REQ",
      EventDef::Encoding{.code = 0x2D, .umask = 0x10, .msr_values = {0x00}},
      R"(AD Flow Q Inserts; VN1 REQ Messages)",
      R"(Counts the number of allocations into the QPI FlowQ. This can be used in conjunction with the QPI FlowQ Occupancy Accumulator event in order to calculate average queue latency.  Only a single FlowQ queue can be tracked at any given time.  It is not possible to filter based on direction or polarity.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_INSERTS.VN1_SNP",
      EventDef::Encoding{.code = 0x2D, .umask = 0x20, .msr_values = {0x00}},
      R"(AD Flow Q Inserts; VN1 SNP Messages)",
      R"(Counts the number of allocations into the QPI FlowQ. This can be used in conjunction with the QPI FlowQ Occupancy Accumulator event in order to calculate average queue latency.  Only a single FlowQ queue can be tracked at any given time.  It is not possible to filter based on direction or polarity.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_INSERTS.VN1_RSP",
      EventDef::Encoding{.code = 0x2D, .umask = 0x40, .msr_values = {0x00}},
      R"(AD Flow Q Inserts; VN1 RSP Messages)",
      R"(Counts the number of allocations into the QPI FlowQ. This can be used in conjunction with the QPI FlowQ Occupancy Accumulator event in order to calculate average queue latency.  Only a single FlowQ queue can be tracked at any given time.  It is not possible to filter based on direction or polarity.)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_OCCUPANCY.VN0_REQ",
      EventDef::Encoding{.code = 0x1C, .umask = 0x01, .msr_values = {0x00}},
      R"(AD Flow Q Occupancy; VN0 REQ Messages)",
      R"(AD Flow Q Occupancy; VN0 REQ Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_OCCUPANCY.VN0_SNP",
      EventDef::Encoding{.code = 0x1C, .umask = 0x02, .msr_values = {0x00}},
      R"(AD Flow Q Occupancy; VN0 SNP Messages)",
      R"(AD Flow Q Occupancy; VN0 SNP Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_OCCUPANCY.VN0_RSP",
      EventDef::Encoding{.code = 0x1C, .umask = 0x04, .msr_values = {0x00}},
      R"(AD Flow Q Occupancy; VN0 RSP Messages)",
      R"(AD Flow Q Occupancy; VN0 RSP Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_OCCUPANCY.VN0_WB",
      EventDef::Encoding{.code = 0x1C, .umask = 0x08, .msr_values = {0x00}},
      R"(AD Flow Q Occupancy; VN0 WB Messages)",
      R"(AD Flow Q Occupancy; VN0 WB Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_OCCUPANCY.VN1_REQ",
      EventDef::Encoding{.code = 0x1C, .umask = 0x10, .msr_values = {0x00}},
      R"(AD Flow Q Occupancy; VN1 REQ Messages)",
      R"(AD Flow Q Occupancy; VN1 REQ Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_OCCUPANCY.VN1_SNP",
      EventDef::Encoding{.code = 0x1C, .umask = 0x20, .msr_values = {0x00}},
      R"(AD Flow Q Occupancy; VN1 SNP Messages)",
      R"(AD Flow Q Occupancy; VN1 SNP Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_FLQ_OCCUPANCY.VN1_RSP",
      EventDef::Encoding{.code = 0x1C, .umask = 0x40, .msr_values = {0x00}},
      R"(AD Flow Q Occupancy; VN1 RSP Messages)",
      R"(AD Flow Q Occupancy; VN1 RSP Messages)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SPEC_ARB_CRD_AVAIL.VN0_REQ",
      EventDef::Encoding{.code = 0x34, .umask = 0x01, .msr_values = {0x00}},
      R"(Speculative ARB for AD  -  Credit Available; VN0 REQ Messages)",
      R"(AD speculative arb request with prior cycle credit check complete and credit avail)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SPEC_ARB_CRD_AVAIL.VN0_SNP",
      EventDef::Encoding{.code = 0x34, .umask = 0x02, .msr_values = {0x00}},
      R"(Speculative ARB for AD  -  Credit Available; VN0 SNP Messages)",
      R"(AD speculative arb request with prior cycle credit check complete and credit avail)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SPEC_ARB_CRD_AVAIL.VN0_WB",
      EventDef::Encoding{.code = 0x34, .umask = 0x08, .msr_values = {0x00}},
      R"(Speculative ARB for AD  -  Credit Available; VN0 WB Messages)",
      R"(AD speculative arb request with prior cycle credit check complete and credit avail)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SPEC_ARB_CRD_AVAIL.VN1_REQ",
      EventDef::Encoding{.code = 0x34, .umask = 0x10, .msr_values = {0x00}},
      R"(Speculative ARB for AD  -  Credit Available; VN1 REQ Messages)",
      R"(AD speculative arb request with prior cycle credit check complete and credit avail)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SPEC_ARB_CRD_AVAIL.VN1_SNP",
      EventDef::Encoding{.code = 0x34, .umask = 0x20, .msr_values = {0x00}},
      R"(Speculative ARB for AD  -  Credit Available; VN1 SNP Messages)",
      R"(AD speculative arb request with prior cycle credit check complete and credit avail)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SPEC_ARB_CRD_AVAIL.VN1_WB",
      EventDef::Encoding{.code = 0x34, .umask = 0x80, .msr_values = {0x00}},
      R"(Speculative ARB for AD  -  Credit Available; VN1 WB Messages)",
      R"(AD speculative arb request with prior cycle credit check complete and credit avail)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SPEC_ARB_NEW_MSG.VN0_REQ",
      EventDef::Encoding{.code = 0x33, .umask = 0x01, .msr_values = {0x00}},
      R"(Speculative ARB for AD  - New Message; VN0 REQ Messages)",
      R"(AD speculative arb request due to new message arriving on a specific channel (MC/VN))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SPEC_ARB_NEW_MSG.VN0_SNP",
      EventDef::Encoding{.code = 0x33, .umask = 0x02, .msr_values = {0x00}},
      R"(Speculative ARB for AD  - New Message; VN0 SNP Messages)",
      R"(AD speculative arb request due to new message arriving on a specific channel (MC/VN))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SPEC_ARB_NEW_MSG.VN0_WB",
      EventDef::Encoding{.code = 0x33, .umask = 0x08, .msr_values = {0x00}},
      R"(Speculative ARB for AD  - New Message; VN0 WB Messages)",
      R"(AD speculative arb request due to new message arriving on a specific channel (MC/VN))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SPEC_ARB_NEW_MSG.VN1_REQ",
      EventDef::Encoding{.code = 0x33, .umask = 0x10, .msr_values = {0x00}},
      R"(Speculative ARB for AD  - New Message; VN1 REQ Messages)",
      R"(AD speculative arb request due to new message arriving on a specific channel (MC/VN))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SPEC_ARB_NEW_MSG.VN1_SNP",
      EventDef::Encoding{.code = 0x33, .umask = 0x20, .msr_values = {0x00}},
      R"(Speculative ARB for AD  - New Message; VN1 SNP Messages)",
      R"(AD speculative arb request due to new message arriving on a specific channel (MC/VN))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SPEC_ARB_NEW_MSG.VN1_WB",
      EventDef::Encoding{.code = 0x33, .umask = 0x80, .msr_values = {0x00}},
      R"(Speculative ARB for AD  - New Message; VN1 WB Messages)",
      R"(AD speculative arb request due to new message arriving on a specific channel (MC/VN))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SPEC_ARB_NO_OTHER_PEND.VN0_REQ",
      EventDef::Encoding{.code = 0x32, .umask = 0x01, .msr_values = {0x00}},
      R"(Speculative ARB for AD  - No Credit; VN0 REQ Messages)",
      R"(AD speculative arb request asserted due to no other channel being active (have a valid entry but don't have credits to send))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SPEC_ARB_NO_OTHER_PEND.VN0_SNP",
      EventDef::Encoding{.code = 0x32, .umask = 0x02, .msr_values = {0x00}},
      R"(Speculative ARB for AD  - No Credit; VN0 SNP Messages)",
      R"(AD speculative arb request asserted due to no other channel being active (have a valid entry but don't have credits to send))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SPEC_ARB_NO_OTHER_PEND.VN0_RSP",
      EventDef::Encoding{.code = 0x32, .umask = 0x04, .msr_values = {0x00}},
      R"(Speculative ARB for AD  - No Credit; VN0 RSP Messages)",
      R"(AD speculative arb request asserted due to no other channel being active (have a valid entry but don't have credits to send))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SPEC_ARB_NO_OTHER_PEND.VN0_WB",
      EventDef::Encoding{.code = 0x32, .umask = 0x08, .msr_values = {0x00}},
      R"(Speculative ARB for AD  - No Credit; VN0 WB Messages)",
      R"(AD speculative arb request asserted due to no other channel being active (have a valid entry but don't have credits to send))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SPEC_ARB_NO_OTHER_PEND.VN1_REQ",
      EventDef::Encoding{.code = 0x32, .umask = 0x10, .msr_values = {0x00}},
      R"(Speculative ARB for AD  - No Credit; VN1 REQ Messages)",
      R"(AD speculative arb request asserted due to no other channel being active (have a valid entry but don't have credits to send))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SPEC_ARB_NO_OTHER_PEND.VN1_SNP",
      EventDef::Encoding{.code = 0x32, .umask = 0x20, .msr_values = {0x00}},
      R"(Speculative ARB for AD  - No Credit; VN1 SNP Messages)",
      R"(AD speculative arb request asserted due to no other channel being active (have a valid entry but don't have credits to send))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SPEC_ARB_NO_OTHER_PEND.VN1_RSP",
      EventDef::Encoding{.code = 0x32, .umask = 0x40, .msr_values = {0x00}},
      R"(Speculative ARB for AD  - No Credit; VN1 RSP Messages)",
      R"(AD speculative arb request asserted due to no other channel being active (have a valid entry but don't have credits to send))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AD_SPEC_ARB_NO_OTHER_PEND.VN1_WB",
      EventDef::Encoding{.code = 0x32, .umask = 0x80, .msr_values = {0x00}},
      R"(Speculative ARB for AD  - No Credit; VN1 WB Messages)",
      R"(AD speculative arb request asserted due to no other channel being active (have a valid entry but don't have credits to send))",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AK_FLQ_INSERTS",
      EventDef::Encoding{.code = 0x2F, .umask = 0x00, .msr_values = {0x00}},
      R"(AK Flow Q Inserts)",
      R"(AK Flow Q Inserts)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_AK_FLQ_OCCUPANCY",
      EventDef::Encoding{.code = 0x1E, .umask = 0x00, .msr_values = {0x00}},
      R"(AK Flow Q Occupancy)",
      R"(AK Flow Q Occupancy)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_ARB_FAIL.VN0_RSP",
      EventDef::Encoding{.code = 0x35, .umask = 0x01, .msr_values = {0x00}},
      R"(Failed ARB for BL; VN0 RSP Messages)",
      R"(BL arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_ARB_FAIL.VN0_WB",
      EventDef::Encoding{.code = 0x35, .umask = 0x02, .msr_values = {0x00}},
      R"(Failed ARB for BL; VN0 WB Messages)",
      R"(BL arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_ARB_FAIL.VN0_NCB",
      EventDef::Encoding{.code = 0x35, .umask = 0x04, .msr_values = {0x00}},
      R"(Failed ARB for BL; VN0 NCB Messages)",
      R"(BL arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_ARB_FAIL.VN0_NCS",
      EventDef::Encoding{.code = 0x35, .umask = 0x08, .msr_values = {0x00}},
      R"(Failed ARB for BL; VN0 NCS Messages)",
      R"(BL arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_ARB_FAIL.VN1_RSP",
      EventDef::Encoding{.code = 0x35, .umask = 0x10, .msr_values = {0x00}},
      R"(Failed ARB for BL; VN1 RSP Messages)",
      R"(BL arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_ARB_FAIL.VN1_WB",
      EventDef::Encoding{.code = 0x35, .umask = 0x20, .msr_values = {0x00}},
      R"(Failed ARB for BL; VN1 WB Messages)",
      R"(BL arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_ARB_FAIL.VN1_NCB",
      EventDef::Encoding{.code = 0x35, .umask = 0x40, .msr_values = {0x00}},
      R"(Failed ARB for BL; VN1 NCS Messages)",
      R"(BL arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_ARB_FAIL.VN1_NCS",
      EventDef::Encoding{.code = 0x35, .umask = 0x80, .msr_values = {0x00}},
      R"(Failed ARB for BL; VN1 NCB Messages)",
      R"(BL arb but no win; arb request asserted but not won)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_CYCLES_NE.VN0_REQ",
      EventDef::Encoding{.code = 0x28, .umask = 0x01, .msr_values = {0x00}},
      R"(BL Flow Q Not Empty; VN0 REQ Messages)",
      R"(Number of cycles the BL Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_CYCLES_NE.VN0_SNP",
      EventDef::Encoding{.code = 0x28, .umask = 0x02, .msr_values = {0x00}},
      R"(BL Flow Q Not Empty; VN0 SNP Messages)",
      R"(Number of cycles the BL Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_CYCLES_NE.VN0_RSP",
      EventDef::Encoding{.code = 0x28, .umask = 0x04, .msr_values = {0x00}},
      R"(BL Flow Q Not Empty; VN0 RSP Messages)",
      R"(Number of cycles the BL Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_CYCLES_NE.VN0_WB",
      EventDef::Encoding{.code = 0x28, .umask = 0x08, .msr_values = {0x00}},
      R"(BL Flow Q Not Empty; VN0 WB Messages)",
      R"(Number of cycles the BL Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_CYCLES_NE.VN1_REQ",
      EventDef::Encoding{.code = 0x28, .umask = 0x10, .msr_values = {0x00}},
      R"(BL Flow Q Not Empty; VN1 REQ Messages)",
      R"(Number of cycles the BL Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_CYCLES_NE.VN1_SNP",
      EventDef::Encoding{.code = 0x28, .umask = 0x20, .msr_values = {0x00}},
      R"(BL Flow Q Not Empty; VN1 SNP Messages)",
      R"(Number of cycles the BL Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_CYCLES_NE.VN1_RSP",
      EventDef::Encoding{.code = 0x28, .umask = 0x40, .msr_values = {0x00}},
      R"(BL Flow Q Not Empty; VN1 RSP Messages)",
      R"(Number of cycles the BL Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI_TxC_BL_FLQ_CYCLES_NE.VN1_WB",
      EventDef::Encoding{.code = 0x28, .umask = 0x80, .msr_values = {0x00}},
      R"(BL Flow Q Not Empty; VN1 WB Messages)",
      R"(Number of cycles the BL Egress queue is Not Empty)",
      std::nullopt,
      std::nullopt, // ScaleUnit
      EventDef::IntelFeatures{},
      std::nullopt // Errata
      ));
#endif // HBT_ADD_ALL_GENERATED_EVENTS

#ifdef HBT_ADD_ALL_GENERATED_EVENTS
  pmu_manager.addEvent(std::make_shared<EventDef>(
      PmuType::uncore_m3upi,
      "UNC_M3UPI