Set up prysk alias and example tests:

  $ . "$TESTDIR"/setup.sh

Test with Windows newlines:

  $ printf "  $ echo hi\r\n  hi\r\n" > windows-newlines.t
  $ prysk windows-newlines.t
  .
  # Ran 1 tests, 0 skipped, 0 failed.

  $ printf "  $ echo hi_from_windows\r\n  hi_from_windows\n" > windows-newlines-dos2unix.t
  $ printf "  $ echo hi_from_windows\r\n  hi_from_windows\r\n" > windows-newlines-dos2unix.t
  $ printf "  $ echo 'hi_from_windows\r'\n  hi_from_windows\n" > windows-newlines-dos2unix.t
  $ printf "  $ echo 'hi_from_windows\r'\n  hi_from_windows\r\n" > windows-newlines-dos2unix.t
  $ printf "  $ echo hi_from_unix\n  hi_from_unix\n" >> windows-newlines-dos2unix.t
  $ prysk windows-newlines-dos2unix.t --dos2unix
  .
  # Ran 1 tests, 0 skipped, 0 failed.

Test with Latin-1 encoding:

  $ cat > good-latin-1.t <<EOF
  >   $ printf "hola se\361or\n"
  >   hola se\xf1or (esc)
  > EOF

  $ cat > bad-latin-1.t <<EOF
  >   $ printf "hola se\361or\n"
  >   hey
  > EOF

  $ prysk good-latin-1.t bad-latin-1.t
  .!
  --- bad-latin-1.t
  +++ bad-latin-1.t.err
  @@ -1,2 +1,2 @@
     $ printf "hola se\361or\n"
  -  hey
  \+  hola se\\xf1or \(esc\) (re)
  
  # Ran 2 tests, 0 skipped, 1 failed.
  [1]

Test with UTF-8 encoding:

  $ cat > good-utf-8.t <<EOF
  >   $ printf "hola se\303\261or\n"
  >   hola señor
  >   $ printf "hola se\303\261or\n"
  >   hola se\xc3\xb1or (esc)
  > EOF

  $ cat > bad-utf-8.t <<EOF
  >   $ printf "hola se\303\261or\n"
  >   hey
  >   $ printf "hola \377 se\303\261or\n"
  >   hey
  > EOF

  $ prysk good-utf-8.t bad-utf-8.t
  .!
  --- bad-utf-8.t
  +++ bad-utf-8.t.err
  @@ -1,4 +1,4 @@
     $ printf "hola se\303\261or\n"
  -  hey
  \+  hola señor (re)
     $ printf "hola \377 se\303\261or\n"
  -  hey
  \+  hola \\xff señor \(esc\) (re)
  
  # Ran 2 tests, 0 skipped, 1 failed.
  [1]

  $ prysk --escape7bit good-utf-8.t bad-utf-8.t
  .!
  --- bad-utf-8.t
  +++ bad-utf-8.t.err
  @@ -1,4 +1,4 @@
     $ printf "hola se\303\261or\n"
  -  hey
  \+  hola se\\xc3\\xb1or \(esc\) (re)
     $ printf "hola \377 se\303\261or\n"
  -  hey
  \+  hola \\xff se\\xc3\\xb1or \(esc\) (re)
  
  # Ran 2 tests, 0 skipped, 1 failed.
  [1]

Test file missing trailing newline:

  $ printf '  $ true' > passing-with-no-newline.t
  $ prysk passing-with-no-newline.t
  .
  # Ran 1 tests, 0 skipped, 0 failed.

  $ printf '  $ false' > failing-with-no-newline.t
  $ prysk failing-with-no-newline.t
  !
  --- failing-with-no-newline.t
  +++ failing-with-no-newline.t.err
  @@ -1,1 +1,2 @@
     $ false
  +  [1]
  
  # Ran 1 tests, 0 skipped, 1 failed.
  [1]
