// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssmcontacts_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/ssmcontacts"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To accept a page during and engagement
// The following accept-page operation uses an accept code sent to the contact channel
// to accept a page.
func ExampleSSMContacts_AcceptPage_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.AcceptPageInput{
		AcceptCode: aws.String("425440"),
		AcceptType: aws.String("READ"),
		PageId:     aws.String("arn:aws:ssm-contacts:us-east-2:682428703967:page/akuam/94ea0c7b-56d9-46c3-b84a-a37c8b067ad3"),
	}

	result, err := svc.AcceptPage(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Activate a contact's contact channel
// The following activate-contact-channel example activates a contact channel and makes
// it usable as part of an incident.
func ExampleSSMContacts_ActivateContactChannel_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.ActivateContactChannelInput{
		ActivationCode:   aws.String("466136"),
		ContactChannelId: aws.String("arn:aws:ssm-contacts:us-east-2:111122223333:contact-channel/akuam/fc7405c4-46b2-48b7-87b2-93e2f225b90d"),
	}

	result, err := svc.ActivateContactChannel(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a contact
// The following create-contact example creates a contact in your environment with a
// blank plan. The plan can be updated after creating contact channels. Use the create-contact-channel
// operation with the output ARN of this command. After you have created contact channels
// for this contact use update-contact to update the plan.
func ExampleSSMContacts_CreateContact_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.CreateContactInput{
		Alias:       aws.String("akuam"),
		DisplayName: aws.String("Akua Mansa"),
		Plan:        &ssmcontacts.Plan{},
		Type:        aws.String("PERSONAL"),
	}

	result, err := svc.CreateContact(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeConflictException:
				fmt.Println(ssmcontacts.ErrCodeConflictException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeServiceQuotaExceededException:
				fmt.Println(ssmcontacts.ErrCodeServiceQuotaExceededException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			case ssmcontacts.ErrCodeDataEncryptionException:
				fmt.Println(ssmcontacts.ErrCodeDataEncryptionException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a contact channel
// Creates a contact channel of type SMS for the contact Akua Mansa. Contact channels
// can be created of type SMS, EMAIL, or VOICE.
func ExampleSSMContacts_CreateContactChannel_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.CreateContactChannelInput{
		ContactId: aws.String("arn:aws:ssm-contacts:us-east-1:111122223333:contact/akuam"),
		DeliveryAddress: &ssmcontacts.ContactChannelAddress{
			SimpleAddress: aws.String("+15005550199"),
		},
		Name: aws.String("akuas sms-test"),
		Type: aws.String("SMS"),
	}

	result, err := svc.CreateContactChannel(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeConflictException:
				fmt.Println(ssmcontacts.ErrCodeConflictException, aerr.Error())
			case ssmcontacts.ErrCodeDataEncryptionException:
				fmt.Println(ssmcontacts.ErrCodeDataEncryptionException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To deactivate a contact channel
// The following “deactivate-contact-channel“ example deactivates a contact channel.
// Deactivating a contact channel means the contact channel will no longer be paged
// during an incident. You can also reactivate a contact channel at any time using the
// activate-contact-channel operation.
func ExampleSSMContacts_DeactivateContactChannel_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.DeactivateContactChannelInput{
		ContactChannelId: aws.String("arn:aws:ssm-contacts:us-east-2:111122223333:contact-channel/akuam/fc7405c4-46b2-48b7-87b2-93e2f225b90d"),
	}

	result, err := svc.DeactivateContactChannel(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a contact
// The following delete-contact example deletes a contact. The contact will no longer
// be reachable from any escalation plan that refers to them.
func ExampleSSMContacts_DeleteContact_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.DeleteContactInput{
		ContactId: aws.String("arn:aws:ssm-contacts:us-east-1:111122223333:contact/alejr"),
	}

	result, err := svc.DeleteContact(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a contact channel
// The following delete-contact-channel example deletes a contact channel. Deleting
// a contact channel ensures the contact channel will not be paged during an incident.
func ExampleSSMContacts_DeleteContactChannel_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.DeleteContactChannelInput{
		ContactChannelId: aws.String("arn:aws:ssm-contacts:us-east-1:111122223333:contact-channel/akuam/13149bad-52ee-45ea-ae1e-45857f78f9b2"),
	}

	result, err := svc.DeleteContactChannel(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the details of an engagement
// The following describe-engagement example lists the details of an engagement to a
// contact or escalation plan. The subject and content are sent to the contact channels.
func ExampleSSMContacts_DescribeEngagement_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.DescribeEngagementInput{
		EngagementId: aws.String("arn:aws:ssm-contacts:us-east-2:111122223333:engagement/example_escalation/69e40ce1-8dbb-4d57-8962-5fbe7fc53356"),
	}

	result, err := svc.DescribeEngagement(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeDataEncryptionException:
				fmt.Println(ssmcontacts.ErrCodeDataEncryptionException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list the details of a page to a contact channel
// The following describe-page example lists details of a page to a contact channel.
// The page will include the subject and content provided.
func ExampleSSMContacts_DescribePage_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.DescribePageInput{
		PageId: aws.String("arn:aws:ssm-contacts:us-east-2:111122223333:page/akuam/ad0052bd-e606-498a-861b-25726292eb93"),
	}

	result, err := svc.DescribePage(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeDataEncryptionException:
				fmt.Println(ssmcontacts.ErrCodeDataEncryptionException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Example 1: To describe a contact plan
// The following get-contact example describes a contact.
func ExampleSSMContacts_GetContact_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.GetContactInput{
		ContactId: aws.String("arn:aws:ssm-contacts:us-east-2:111122223333:contact/akuam"),
	}

	result, err := svc.GetContact(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			case ssmcontacts.ErrCodeDataEncryptionException:
				fmt.Println(ssmcontacts.ErrCodeDataEncryptionException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Example 2: To describe an escalation plan
// The following get-contact example describes an escalation plan.
func ExampleSSMContacts_GetContact_shared01() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.GetContactInput{
		ContactId: aws.String("arn:aws:ssm-contacts:us-east-2:111122223333:contact/example_escalation"),
	}

	result, err := svc.GetContact(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			case ssmcontacts.ErrCodeDataEncryptionException:
				fmt.Println(ssmcontacts.ErrCodeDataEncryptionException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list the details of a contact channel
// The following get-contact-channel example lists the details of a contact channel.
func ExampleSSMContacts_GetContactChannel_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.GetContactChannelInput{
		ContactChannelId: aws.String("arn:aws:ssm-contacts:us-east-2:111122223333:contact-channel/akuam/fc7405c4-46b2-48b7-87b2-93e2f225b90d"),
	}

	result, err := svc.GetContactChannel(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeDataEncryptionException:
				fmt.Println(ssmcontacts.ErrCodeDataEncryptionException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list the resource policies of a contact
// The following get-contact-policy example lists the resource policies associated with
// the specified contact.
func ExampleSSMContacts_GetContactPolicy_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.GetContactPolicyInput{
		ContactArn: aws.String("arn:aws:ssm-contacts:us-east-1:111122223333:contact/akuam"),
	}

	result, err := svc.GetContactPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list the contact channels of a contact
// The following list-contact-channels example lists the available contact channels
// of the specified contact.
func ExampleSSMContacts_ListContactChannels_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.ListContactChannelsInput{
		ContactId: aws.String("arn:aws:ssm-contacts:us-east-2:111122223333:contact/akuam"),
	}

	result, err := svc.ListContactChannels(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeDataEncryptionException:
				fmt.Println(ssmcontacts.ErrCodeDataEncryptionException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list all escalation plans and contacts
// The following list-contacts example lists the contacts and escalation plans in your
// account.
func ExampleSSMContacts_ListContacts_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.ListContactsInput{}

	result, err := svc.ListContacts(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list all engagements
// The following list-engagements example lists engagements to escalation plans and
// contacts. You can also list engagements for a single incident.
func ExampleSSMContacts_ListEngagements_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.ListEngagementsInput{}

	result, err := svc.ListEngagements(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list page receipts
// The following command-name example lists whether a page was received or not by a
// contact.
func ExampleSSMContacts_ListPageReceipts_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.ListPageReceiptsInput{
		PageId: aws.String("arn:aws:ssm-contacts:us-east-2:111122223333:page/akuam/94ea0c7b-56d9-46c3-b84a-a37c8b067ad3"),
	}

	result, err := svc.ListPageReceipts(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list pages by contact
// The following list-pages-by-contact example lists all pages to the specified contact.
func ExampleSSMContacts_ListPagesByContact_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.ListPagesByContactInput{
		ContactId: aws.String("arn:aws:ssm-contacts:us-east-2:111122223333:contact/akuam"),
	}

	result, err := svc.ListPagesByContact(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list pages to contact channels started from an engagement.
// The following list-pages-by-engagement example lists the pages that occurred while
// engaging the defined engagement plan.
func ExampleSSMContacts_ListPagesByEngagement_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.ListPagesByEngagementInput{
		EngagementId: aws.String("arn:aws:ssm-contacts:us-east-2:111122223333:engagement/akuam/78a29753-3674-4ac5-9f83-0468563567f0"),
	}

	result, err := svc.ListPagesByEngagement(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list tags for a contact
// The following list-tags-for-resource example lists the tags of the specified contact.
func ExampleSSMContacts_ListTagsForResource_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.ListTagsForResourceInput{
		ResourceARN: aws.String("arn:aws:ssm-contacts:us-east-1:111122223333:contact/akuam"),
	}

	result, err := svc.ListTagsForResource(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To share a contact and engagements
// The following put-contact-policy example adds a resource policy to the contact Akua
// that shares the contact and related engagements with the principal.
func ExampleSSMContacts_PutContactPolicy_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.PutContactPolicyInput{
		ContactArn: aws.String("arn:aws:ssm-contacts:us-east-1:111122223333:contact/akuam"),
		Policy:     aws.String("{\"Version\":\"2012-10-17\",\"Statement\":[{\"Sid\":\"ExampleResourcePolicy\",\"Action\":[\"ssm-contacts:GetContact\",\"ssm-contacts:StartEngagement\",\"ssm-contacts:DescribeEngagement\",\"ssm-contacts:ListPagesByEngagement\",\"ssm-contacts:StopEngagement\"],\"Principal\":{\"AWS\":\"222233334444\"},\"Effect\":\"Allow\",\"Resource\":[\"arn:aws:ssm-contacts:*:111122223333:contact/akuam\",\"arn:aws:ssm-contacts:*:111122223333:engagement/akuam/*\"]}]}"),
	}

	result, err := svc.PutContactPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeConflictException:
				fmt.Println(ssmcontacts.ErrCodeConflictException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To send an activation code
// The following send-activation-code example sends an activation code and message to
// the specified contact channel.
func ExampleSSMContacts_SendActivationCode_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.SendActivationCodeInput{
		ContactChannelId: aws.String("arn:aws:ssm-contacts:us-east-1:111122223333:contact-channel/akuam/8ddae2d1-12c8-4e45-b852-c8587266c400"),
	}

	result, err := svc.SendActivationCode(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeDataEncryptionException:
				fmt.Println(ssmcontacts.ErrCodeDataEncryptionException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeServiceQuotaExceededException:
				fmt.Println(ssmcontacts.ErrCodeServiceQuotaExceededException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Example 1: To page a contact's contact channels
// The following start-engagement pages contact's contact channels. Sender, subject,
// public-subject, and public-content are all free from fields. Incident Manager sends
// the subject and content to the provided VOICE or EMAIL contact channels. Incident
// Manager sends the public-subject and public-content to the provided SMS contact channels.
// Sender is used to track who started the engagement.
func ExampleSSMContacts_StartEngagement_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.StartEngagementInput{
		ContactId:     aws.String("arn:aws:ssm-contacts:us-east-2:111122223333:contact/akuam"),
		Content:       aws.String("Testing engagements"),
		PublicContent: aws.String("Testing engagements"),
		PublicSubject: aws.String("test"),
		Sender:        aws.String("tester"),
		Subject:       aws.String("test"),
	}

	result, err := svc.StartEngagement(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeDataEncryptionException:
				fmt.Println(ssmcontacts.ErrCodeDataEncryptionException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Example 2: To page a contact in the provided escalation plan.
// The following start-engagement engages contact's through an escalation plan. Each
// contact is paged according to their engagement plan.
func ExampleSSMContacts_StartEngagement_shared01() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.StartEngagementInput{
		ContactId:     aws.String("arn:aws:ssm-contacts:us-east-2:111122223333:contact/example_escalation"),
		Content:       aws.String("Testing engagements"),
		PublicContent: aws.String("Testing engagements"),
		PublicSubject: aws.String("test"),
		Sender:        aws.String("tester"),
		Subject:       aws.String("test"),
	}

	result, err := svc.StartEngagement(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeDataEncryptionException:
				fmt.Println(ssmcontacts.ErrCodeDataEncryptionException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To stop an engagement
// The following stop-engagement example stops an engagement from paging further contacts
// and contact channels.
func ExampleSSMContacts_StopEngagement_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.StopEngagementInput{
		EngagementId: aws.String("arn:aws:ssm-contacts:us-east-2:111122223333:engagement/example_escalation/69e40ce1-8dbb-4d57-8962-5fbe7fc53356"),
	}

	result, err := svc.StopEngagement(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To tag a contact
// The following tag-resource example tags a specified contact with the provided tag
// key value pair.
func ExampleSSMContacts_TagResource_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.TagResourceInput{
		ResourceARN: aws.String("arn:aws:ssm-contacts:us-east-1:111122223333:contact/akuam"),
		Tags: []*ssmcontacts.Tag{
			{
				Key:   aws.String("group1"),
				Value: aws.String("1"),
			},
		},
	}

	result, err := svc.TagResource(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeServiceQuotaExceededException:
				fmt.Println(ssmcontacts.ErrCodeServiceQuotaExceededException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To remove tags from a contact
// The following untag-resource example removes the group1 tag from the specified contact.
func ExampleSSMContacts_UntagResource_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.UntagResourceInput{
		ResourceARN: aws.String("arn:aws:ssm-contacts:us-east-1:111122223333:contact/akuam"),
		TagKeys: []*string{
			aws.String("group1"),
		},
	}

	result, err := svc.UntagResource(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update the engagement plan of contact
// The following update-contact example updates the engagement plan of the contact Akua
// to include the three types of contacts channels. This is done after creating contact
// channels for Akua.
func ExampleSSMContacts_UpdateContact_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.UpdateContactInput{
		ContactId: aws.String("arn:aws:ssm-contacts:us-east-2:111122223333:contact/akuam"),
		Plan: &ssmcontacts.Plan{
			Stages: []*ssmcontacts.Stage{
				{
					DurationInMinutes: aws.Int64(5),
					Targets: []*ssmcontacts.Target{
						{
							ChannelTargetInfo: &ssmcontacts.ChannelTargetInfo{
								ContactChannelId:       aws.String("arn:aws:ssm-contacts:us-east-2:111122223333:contact-channel/akuam/beb25840-5ac8-4644-95cc-7a8de390fa65"),
								RetryIntervalInMinutes: aws.Int64(1),
							},
						},
					},
				},
				{
					DurationInMinutes: aws.Int64(5),
					Targets: []*ssmcontacts.Target{
						{
							ChannelTargetInfo: &ssmcontacts.ChannelTargetInfo{
								ContactChannelId:       aws.String("arn:aws:ssm-contacts:us-east-2:111122223333:contact-channel/akuam/49f3c24d-5f9f-4638-ae25-3f49e04229ad"),
								RetryIntervalInMinutes: aws.Int64(1),
							},
						},
					},
				},
				{
					DurationInMinutes: aws.Int64(5),
					Targets: []*ssmcontacts.Target{
						{
							ChannelTargetInfo: &ssmcontacts.ChannelTargetInfo{
								ContactChannelId:       aws.String("arn:aws:ssm-contacts:us-east-2:111122223333:contact-channel/akuam/77d4f447-f619-4954-afff-85551e369c2a"),
								RetryIntervalInMinutes: aws.Int64(1),
							},
						},
					},
				},
			},
		},
	}

	result, err := svc.UpdateContact(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeServiceQuotaExceededException:
				fmt.Println(ssmcontacts.ErrCodeServiceQuotaExceededException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			case ssmcontacts.ErrCodeDataEncryptionException:
				fmt.Println(ssmcontacts.ErrCodeDataEncryptionException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update a contact channel
// The following update-contact-channel example updates the name and delivery address
// of a contact channel.
func ExampleSSMContacts_UpdateContactChannel_shared00() {
	svc := ssmcontacts.New(session.New())
	input := &ssmcontacts.UpdateContactChannelInput{
		ContactChannelId: aws.String("arn:aws:ssm-contacts:us-east-2:111122223333:contact-channel/akuam/49f3c24d-5f9f-4638-ae25-3f49e04229ad"),
		DeliveryAddress: &ssmcontacts.ContactChannelAddress{
			SimpleAddress: aws.String("+15005550198"),
		},
		Name: aws.String("akuas voice channel"),
	}

	result, err := svc.UpdateContactChannel(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case ssmcontacts.ErrCodeAccessDeniedException:
				fmt.Println(ssmcontacts.ErrCodeAccessDeniedException, aerr.Error())
			case ssmcontacts.ErrCodeConflictException:
				fmt.Println(ssmcontacts.ErrCodeConflictException, aerr.Error())
			case ssmcontacts.ErrCodeDataEncryptionException:
				fmt.Println(ssmcontacts.ErrCodeDataEncryptionException, aerr.Error())
			case ssmcontacts.ErrCodeInternalServerException:
				fmt.Println(ssmcontacts.ErrCodeInternalServerException, aerr.Error())
			case ssmcontacts.ErrCodeResourceNotFoundException:
				fmt.Println(ssmcontacts.ErrCodeResourceNotFoundException, aerr.Error())
			case ssmcontacts.ErrCodeThrottlingException:
				fmt.Println(ssmcontacts.ErrCodeThrottlingException, aerr.Error())
			case ssmcontacts.ErrCodeValidationException:
				fmt.Println(ssmcontacts.ErrCodeValidationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
