include(Pj/DetectArch)
pj_detect_arch(arch)
pj_detect_arch_simd_ext(simd_inst simd_flags)

set(WEBRTC_ARCH "${arch}")
set(WEBRTC_ARCH_SIMD "${simd_inst}")
set(WEBRTC_COMPILE_OPTIONS ${simd_flags})
set(WEBRTC_COMPILE_DEFINITIONS WEBRTC_APM_DEBUG_DUMP=0)

# operating system definitions
if(IOS)
  list(APPEND WEBRTC_COMPILE_DEFINITIONS WEBRTC_IOS=1 WEBRTC_POSIX=1)
elseif(DARWIN)
  list(APPEND WEBRTC_COMPILE_DEFINITIONS WEBRTC_MAC=1 WEBRTC_POSIX=1)
elseif(ANDROID)
  list(APPEND WEBRTC_COMPILE_DEFINITIONS WEBRTC_ANDROID=1 WEBRTC_POSIX=1)
elseif(LINUX)
  list(APPEND WEBRTC_COMPILE_DEFINITIONS WEBRTC_LINUX=1 WEBRTC_POSIX=1)
elseif(WIN32)
  list(APPEND WEBRTC_COMPILE_DEFINITIONS WEBRTC_WIN=1)
endif()

if (MSVC)
  list(APPEND WEBRTC_COMPILE_DEFINITIONS NOMINMAX)
endif()

# architecture definitions
if(arch STREQUAL "arm64")
  list(APPEND WEBRTC_COMPILE_DEFINITIONS WEBRTC_ARCH_ARM64=1)
elseif(arch STREQUAL "mips")
  list(APPEND WEBRTC_COMPILE_DEFINITIONS MIPS_FPU_LE=1)
endif()

if(simd_inst STREQUAL "neon")
  list(APPEND WEBRTC_COMPILE_DEFINITIONS WEBRTC_HAS_NEON=1)
endif()
