#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 2260
#define LARGE_STATE_COUNT 95
#define SYMBOL_COUNT 244
#define ALIAS_COUNT 3
#define TOKEN_COUNT 106
#define EXTERNAL_TOKEN_COUNT 12
#define FIELD_COUNT 29
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 115

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_SEMI = 2,
  anon_sym_print = 3,
  anon_sym_COMMA = 4,
  anon_sym_GT_GT = 5,
  anon_sym_assert = 6,
  anon_sym_DOT = 7,
  anon_sym_eq = 8,
  anon_sym_ne = 9,
  anon_sym_contains = 10,
  anon_sym_fails = 11,
  anon_sym_assert_ = 12,
  anon_sym_assert_eq = 13,
  anon_sym_assert_ne = 14,
  anon_sym_assert_contains = 15,
  anon_sym_assert_fails = 16,
  anon_sym_COLON_EQ = 17,
  anon_sym_return = 18,
  anon_sym_del = 19,
  anon_sym_pass = 20,
  anon_sym_break = 21,
  anon_sym_continue = 22,
  anon_sym_if = 23,
  anon_sym_COLON = 24,
  anon_sym_elif = 25,
  anon_sym_else = 26,
  anon_sym_match = 27,
  anon_sym_case = 28,
  anon_sym_async = 29,
  anon_sym_for = 30,
  anon_sym_in = 31,
  anon_sym_while = 32,
  anon_sym_with = 33,
  anon_sym_LPAREN = 34,
  anon_sym_RPAREN = 35,
  anon_sym_def = 36,
  anon_sym_DASH_GT = 37,
  anon_sym_STAR = 38,
  anon_sym_STAR_STAR = 39,
  anon_sym_exec = 40,
  anon_sym_LBRACK = 41,
  anon_sym_RBRACK = 42,
  anon_sym_AT = 43,
  anon_sym_DASH = 44,
  anon_sym__ = 45,
  anon_sym_as = 46,
  anon_sym_PIPE = 47,
  anon_sym_LBRACE = 48,
  anon_sym_RBRACE = 49,
  anon_sym_EQ = 50,
  anon_sym_PLUS = 51,
  anon_sym_not = 52,
  anon_sym_and = 53,
  anon_sym_or = 54,
  anon_sym_SLASH = 55,
  anon_sym_PERCENT = 56,
  anon_sym_SLASH_SLASH = 57,
  anon_sym_AMP = 58,
  anon_sym_CARET = 59,
  anon_sym_LT_LT = 60,
  anon_sym_TILDE = 61,
  anon_sym_LT = 62,
  anon_sym_LT_EQ = 63,
  anon_sym_EQ_EQ = 64,
  anon_sym_BANG_EQ = 65,
  anon_sym_GT_EQ = 66,
  anon_sym_GT = 67,
  anon_sym_LT_GT = 68,
  anon_sym_lambda = 69,
  anon_sym_PLUS_EQ = 70,
  anon_sym_DASH_EQ = 71,
  anon_sym_STAR_EQ = 72,
  anon_sym_SLASH_EQ = 73,
  anon_sym_AT_EQ = 74,
  anon_sym_SLASH_SLASH_EQ = 75,
  anon_sym_PERCENT_EQ = 76,
  anon_sym_STAR_STAR_EQ = 77,
  anon_sym_GT_GT_EQ = 78,
  anon_sym_LT_LT_EQ = 79,
  anon_sym_AMP_EQ = 80,
  anon_sym_CARET_EQ = 81,
  anon_sym_PIPE_EQ = 82,
  sym_ellipsis = 83,
  sym_escape_sequence = 84,
  anon_sym_BSLASH = 85,
  aux_sym_format_specifier_token1 = 86,
  sym_type_conversion = 87,
  sym_integer = 88,
  sym_float = 89,
  anon_sym_await = 90,
  anon_sym_struct = 91,
  anon_sym_type = 92,
  sym_true = 93,
  sym_false = 94,
  sym_none = 95,
  sym_comment = 96,
  sym_line_continuation = 97,
  anon_sym_except = 98,
  sym__newline = 99,
  sym__indent = 100,
  sym__dedent = 101,
  sym_string_start = 102,
  sym__string_content = 103,
  sym_escape_interpolation = 104,
  sym_string_end = 105,
  sym_module = 106,
  sym__statement = 107,
  sym__simple_statements = 108,
  sym_print_statement = 109,
  sym_chevron = 110,
  sym_assert_statement = 111,
  sym_expression_statement = 112,
  sym_named_expression = 113,
  sym__named_expression_lhs = 114,
  sym_return_statement = 115,
  sym_delete_statement = 116,
  sym_pass_statement = 117,
  sym_break_statement = 118,
  sym_continue_statement = 119,
  sym_if_statement = 120,
  sym_elif_clause = 121,
  sym_else_clause = 122,
  sym_match_statement = 123,
  sym__match_block = 124,
  sym_case_clause = 125,
  sym_for_statement = 126,
  sym_while_statement = 127,
  sym_with_statement = 128,
  sym_with_clause = 129,
  sym_with_item = 130,
  sym_function_definition = 131,
  sym_parameters = 132,
  sym_lambda_parameters = 133,
  sym_list_splat = 134,
  sym_dictionary_splat = 135,
  sym_exec_statement = 136,
  sym_type_parameter = 137,
  sym_parenthesized_list_splat = 138,
  sym_argument_list = 139,
  sym_decorated_definition = 140,
  sym_decorator = 141,
  sym_block = 142,
  sym_expression_list = 143,
  sym_dotted_name = 144,
  sym_case_pattern = 145,
  sym__simple_pattern = 146,
  sym__as_pattern = 147,
  sym_union_pattern = 148,
  sym__list_pattern = 149,
  sym__tuple_pattern = 150,
  sym_dict_pattern = 151,
  sym__key_value_pattern = 152,
  sym_keyword_pattern = 153,
  sym_splat_pattern = 154,
  sym_class_pattern = 155,
  sym_complex_pattern = 156,
  sym__parameters = 157,
  sym__patterns = 158,
  sym_parameter = 159,
  sym_pattern = 160,
  sym_tuple_pattern = 161,
  sym_list_pattern = 162,
  sym_default_parameter = 163,
  sym_typed_default_parameter = 164,
  sym_list_splat_pattern = 165,
  sym_dictionary_splat_pattern = 166,
  sym_as_pattern = 167,
  sym__expression_within_for_in_clause = 168,
  sym_expression = 169,
  sym_primary_expression = 170,
  sym_not_operator = 171,
  sym_boolean_operator = 172,
  sym_binary_operator = 173,
  sym_unary_operator = 174,
  sym_comparison_operator = 175,
  sym_lambda = 176,
  sym_lambda_within_for_in_clause = 177,
  sym_assignment = 178,
  sym_augmented_assignment = 179,
  sym_pattern_list = 180,
  sym__right_hand_side = 181,
  sym_attribute = 182,
  sym_subscript = 183,
  sym_slice = 184,
  sym_call = 185,
  sym_typed_parameter = 186,
  sym_type = 187,
  sym_splat_type = 188,
  sym_generic_type = 189,
  sym_union_type = 190,
  sym_constrained_type = 191,
  sym_member_type = 192,
  sym_keyword_argument = 193,
  sym_list = 194,
  sym_set = 195,
  sym_tuple = 196,
  sym_dictionary = 197,
  sym_pair = 198,
  sym_list_comprehension = 199,
  sym_dictionary_comprehension = 200,
  sym_set_comprehension = 201,
  sym__comprehension_clauses = 202,
  sym_parenthesized_expression = 203,
  sym__collection_elements = 204,
  sym_for_in_clause = 205,
  sym_if_clause = 206,
  sym_conditional_expression = 207,
  sym_concatenated_string = 208,
  sym_string = 209,
  sym_string_content = 210,
  sym_interpolation = 211,
  sym__f_expression = 212,
  sym__not_escape_sequence = 213,
  sym_format_specifier = 214,
  sym_positional_separator = 215,
  sym_keyword_separator = 216,
  aux_sym_module_repeat1 = 217,
  aux_sym__simple_statements_repeat1 = 218,
  aux_sym_print_statement_repeat1 = 219,
  aux_sym_assert_statement_repeat1 = 220,
  aux_sym_if_statement_repeat1 = 221,
  aux_sym_match_statement_repeat1 = 222,
  aux_sym__match_block_repeat1 = 223,
  aux_sym_case_clause_repeat1 = 224,
  aux_sym_with_clause_repeat1 = 225,
  aux_sym_type_parameter_repeat1 = 226,
  aux_sym_argument_list_repeat1 = 227,
  aux_sym_decorated_definition_repeat1 = 228,
  aux_sym_dotted_name_repeat1 = 229,
  aux_sym_union_pattern_repeat1 = 230,
  aux_sym_dict_pattern_repeat1 = 231,
  aux_sym__parameters_repeat1 = 232,
  aux_sym__patterns_repeat1 = 233,
  aux_sym_comparison_operator_repeat1 = 234,
  aux_sym_subscript_repeat1 = 235,
  aux_sym_dictionary_repeat1 = 236,
  aux_sym__comprehension_clauses_repeat1 = 237,
  aux_sym__collection_elements_repeat1 = 238,
  aux_sym_for_in_clause_repeat1 = 239,
  aux_sym_concatenated_string_repeat1 = 240,
  aux_sym_string_repeat1 = 241,
  aux_sym_string_content_repeat1 = 242,
  aux_sym_format_specifier_repeat1 = 243,
  alias_sym_as_pattern_target = 244,
  alias_sym_format_expression = 245,
  anon_alias_sym_notin = 246,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_SEMI] = ";",
  [anon_sym_print] = "print",
  [anon_sym_COMMA] = ",",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_assert] = "assert_keyword",
  [anon_sym_DOT] = ".",
  [anon_sym_eq] = "assert_builtin",
  [anon_sym_ne] = "assert_builtin",
  [anon_sym_contains] = "assert_builtin",
  [anon_sym_fails] = "assert_builtin",
  [anon_sym_assert_] = "assert_keyword",
  [anon_sym_assert_eq] = "assert_keyword",
  [anon_sym_assert_ne] = "assert_keyword",
  [anon_sym_assert_contains] = "assert_keyword",
  [anon_sym_assert_fails] = "assert_keyword",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_return] = "return",
  [anon_sym_del] = "del",
  [anon_sym_pass] = "pass",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_if] = "if",
  [anon_sym_COLON] = ":",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_match] = "match",
  [anon_sym_case] = "case",
  [anon_sym_async] = "async",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [anon_sym_with] = "with",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_def] = "def",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_STAR] = "*",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_exec] = "exec",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_AT] = "@",
  [anon_sym_DASH] = "-",
  [anon_sym__] = "_",
  [anon_sym_as] = "as",
  [anon_sym_PIPE] = "|",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS] = "+",
  [anon_sym_not] = "not",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_SLASH_SLASH] = "//",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_TILDE] = "~",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_lambda] = "lambda",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_AT_EQ] = "@=",
  [anon_sym_SLASH_SLASH_EQ] = "//=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [sym_ellipsis] = "ellipsis",
  [sym_escape_sequence] = "escape_sequence",
  [anon_sym_BSLASH] = "\\",
  [aux_sym_format_specifier_token1] = "format_specifier_token1",
  [sym_type_conversion] = "type_conversion",
  [sym_integer] = "integer",
  [sym_float] = "float",
  [anon_sym_await] = "identifier",
  [anon_sym_struct] = "identifier",
  [anon_sym_type] = "identifier",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_none] = "none",
  [sym_comment] = "comment",
  [sym_line_continuation] = "line_continuation",
  [anon_sym_except] = "except",
  [sym__newline] = "_newline",
  [sym__indent] = "_indent",
  [sym__dedent] = "_dedent",
  [sym_string_start] = "string_start",
  [sym__string_content] = "_string_content",
  [sym_escape_interpolation] = "escape_interpolation",
  [sym_string_end] = "string_end",
  [sym_module] = "module",
  [sym__statement] = "_statement",
  [sym__simple_statements] = "_simple_statements",
  [sym_print_statement] = "print_statement",
  [sym_chevron] = "chevron",
  [sym_assert_statement] = "assert_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_named_expression] = "named_expression",
  [sym__named_expression_lhs] = "_named_expression_lhs",
  [sym_return_statement] = "return_statement",
  [sym_delete_statement] = "delete_statement",
  [sym_pass_statement] = "pass_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_if_statement] = "if_statement",
  [sym_elif_clause] = "elif_clause",
  [sym_else_clause] = "else_clause",
  [sym_match_statement] = "match_statement",
  [sym__match_block] = "block",
  [sym_case_clause] = "case_clause",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_with_statement] = "with_statement",
  [sym_with_clause] = "with_clause",
  [sym_with_item] = "with_item",
  [sym_function_definition] = "function_definition",
  [sym_parameters] = "parameters",
  [sym_lambda_parameters] = "lambda_parameters",
  [sym_list_splat] = "list_splat",
  [sym_dictionary_splat] = "dictionary_splat",
  [sym_exec_statement] = "exec_statement",
  [sym_type_parameter] = "type_parameter",
  [sym_parenthesized_list_splat] = "parenthesized_list_splat",
  [sym_argument_list] = "argument_list",
  [sym_decorated_definition] = "decorated_definition",
  [sym_decorator] = "decorator",
  [sym_block] = "block",
  [sym_expression_list] = "expression_list",
  [sym_dotted_name] = "dotted_name",
  [sym_case_pattern] = "case_pattern",
  [sym__simple_pattern] = "_simple_pattern",
  [sym__as_pattern] = "as_pattern",
  [sym_union_pattern] = "union_pattern",
  [sym__list_pattern] = "list_pattern",
  [sym__tuple_pattern] = "tuple_pattern",
  [sym_dict_pattern] = "dict_pattern",
  [sym__key_value_pattern] = "_key_value_pattern",
  [sym_keyword_pattern] = "keyword_pattern",
  [sym_splat_pattern] = "splat_pattern",
  [sym_class_pattern] = "class_pattern",
  [sym_complex_pattern] = "complex_pattern",
  [sym__parameters] = "_parameters",
  [sym__patterns] = "_patterns",
  [sym_parameter] = "parameter",
  [sym_pattern] = "pattern",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym_list_pattern] = "list_pattern",
  [sym_default_parameter] = "default_parameter",
  [sym_typed_default_parameter] = "typed_default_parameter",
  [sym_list_splat_pattern] = "list_splat_pattern",
  [sym_dictionary_splat_pattern] = "dictionary_splat_pattern",
  [sym_as_pattern] = "as_pattern",
  [sym__expression_within_for_in_clause] = "_expression_within_for_in_clause",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_not_operator] = "not_operator",
  [sym_boolean_operator] = "boolean_operator",
  [sym_binary_operator] = "binary_operator",
  [sym_unary_operator] = "unary_operator",
  [sym_comparison_operator] = "comparison_operator",
  [sym_lambda] = "lambda",
  [sym_lambda_within_for_in_clause] = "lambda",
  [sym_assignment] = "assignment",
  [sym_augmented_assignment] = "augmented_assignment",
  [sym_pattern_list] = "pattern_list",
  [sym__right_hand_side] = "_right_hand_side",
  [sym_attribute] = "attribute",
  [sym_subscript] = "subscript",
  [sym_slice] = "slice",
  [sym_call] = "call",
  [sym_typed_parameter] = "typed_parameter",
  [sym_type] = "type",
  [sym_splat_type] = "splat_type",
  [sym_generic_type] = "generic_type",
  [sym_union_type] = "union_type",
  [sym_constrained_type] = "constrained_type",
  [sym_member_type] = "member_type",
  [sym_keyword_argument] = "keyword_argument",
  [sym_list] = "list",
  [sym_set] = "set",
  [sym_tuple] = "tuple",
  [sym_dictionary] = "dictionary",
  [sym_pair] = "pair",
  [sym_list_comprehension] = "list_comprehension",
  [sym_dictionary_comprehension] = "dictionary_comprehension",
  [sym_set_comprehension] = "set_comprehension",
  [sym__comprehension_clauses] = "_comprehension_clauses",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym__collection_elements] = "_collection_elements",
  [sym_for_in_clause] = "for_in_clause",
  [sym_if_clause] = "if_clause",
  [sym_conditional_expression] = "conditional_expression",
  [sym_concatenated_string] = "concatenated_string",
  [sym_string] = "string",
  [sym_string_content] = "string_content",
  [sym_interpolation] = "interpolation",
  [sym__f_expression] = "_f_expression",
  [sym__not_escape_sequence] = "_not_escape_sequence",
  [sym_format_specifier] = "format_specifier",
  [sym_positional_separator] = "positional_separator",
  [sym_keyword_separator] = "keyword_separator",
  [aux_sym_module_repeat1] = "module_repeat1",
  [aux_sym__simple_statements_repeat1] = "_simple_statements_repeat1",
  [aux_sym_print_statement_repeat1] = "print_statement_repeat1",
  [aux_sym_assert_statement_repeat1] = "assert_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_match_statement_repeat1] = "match_statement_repeat1",
  [aux_sym__match_block_repeat1] = "_match_block_repeat1",
  [aux_sym_case_clause_repeat1] = "case_clause_repeat1",
  [aux_sym_with_clause_repeat1] = "with_clause_repeat1",
  [aux_sym_type_parameter_repeat1] = "type_parameter_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_decorated_definition_repeat1] = "decorated_definition_repeat1",
  [aux_sym_dotted_name_repeat1] = "dotted_name_repeat1",
  [aux_sym_union_pattern_repeat1] = "union_pattern_repeat1",
  [aux_sym_dict_pattern_repeat1] = "dict_pattern_repeat1",
  [aux_sym__parameters_repeat1] = "_parameters_repeat1",
  [aux_sym__patterns_repeat1] = "_patterns_repeat1",
  [aux_sym_comparison_operator_repeat1] = "comparison_operator_repeat1",
  [aux_sym_subscript_repeat1] = "subscript_repeat1",
  [aux_sym_dictionary_repeat1] = "dictionary_repeat1",
  [aux_sym__comprehension_clauses_repeat1] = "_comprehension_clauses_repeat1",
  [aux_sym__collection_elements_repeat1] = "_collection_elements_repeat1",
  [aux_sym_for_in_clause_repeat1] = "for_in_clause_repeat1",
  [aux_sym_concatenated_string_repeat1] = "concatenated_string_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_content_repeat1] = "string_content_repeat1",
  [aux_sym_format_specifier_repeat1] = "format_specifier_repeat1",
  [alias_sym_as_pattern_target] = "as_pattern_target",
  [alias_sym_format_expression] = "format_expression",
  [anon_alias_sym_notin] = "not in",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_print] = anon_sym_print,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_eq] = anon_sym_eq,
  [anon_sym_ne] = anon_sym_eq,
  [anon_sym_contains] = anon_sym_eq,
  [anon_sym_fails] = anon_sym_eq,
  [anon_sym_assert_] = anon_sym_assert,
  [anon_sym_assert_eq] = anon_sym_assert,
  [anon_sym_assert_ne] = anon_sym_assert,
  [anon_sym_assert_contains] = anon_sym_assert,
  [anon_sym_assert_fails] = anon_sym_assert,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_del] = anon_sym_del,
  [anon_sym_pass] = anon_sym_pass,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_elif] = anon_sym_elif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_match] = anon_sym_match,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_def] = anon_sym_def,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_exec] = anon_sym_exec,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym__] = anon_sym__,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_lambda] = anon_sym_lambda,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_AT_EQ] = anon_sym_AT_EQ,
  [anon_sym_SLASH_SLASH_EQ] = anon_sym_SLASH_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [sym_ellipsis] = sym_ellipsis,
  [sym_escape_sequence] = sym_escape_sequence,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [aux_sym_format_specifier_token1] = aux_sym_format_specifier_token1,
  [sym_type_conversion] = sym_type_conversion,
  [sym_integer] = sym_integer,
  [sym_float] = sym_float,
  [anon_sym_await] = sym_identifier,
  [anon_sym_struct] = sym_identifier,
  [anon_sym_type] = sym_identifier,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_none] = sym_none,
  [sym_comment] = sym_comment,
  [sym_line_continuation] = sym_line_continuation,
  [anon_sym_except] = anon_sym_except,
  [sym__newline] = sym__newline,
  [sym__indent] = sym__indent,
  [sym__dedent] = sym__dedent,
  [sym_string_start] = sym_string_start,
  [sym__string_content] = sym__string_content,
  [sym_escape_interpolation] = sym_escape_interpolation,
  [sym_string_end] = sym_string_end,
  [sym_module] = sym_module,
  [sym__statement] = sym__statement,
  [sym__simple_statements] = sym__simple_statements,
  [sym_print_statement] = sym_print_statement,
  [sym_chevron] = sym_chevron,
  [sym_assert_statement] = sym_assert_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_named_expression] = sym_named_expression,
  [sym__named_expression_lhs] = sym__named_expression_lhs,
  [sym_return_statement] = sym_return_statement,
  [sym_delete_statement] = sym_delete_statement,
  [sym_pass_statement] = sym_pass_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elif_clause] = sym_elif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_match_statement] = sym_match_statement,
  [sym__match_block] = sym_block,
  [sym_case_clause] = sym_case_clause,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_with_clause] = sym_with_clause,
  [sym_with_item] = sym_with_item,
  [sym_function_definition] = sym_function_definition,
  [sym_parameters] = sym_parameters,
  [sym_lambda_parameters] = sym_lambda_parameters,
  [sym_list_splat] = sym_list_splat,
  [sym_dictionary_splat] = sym_dictionary_splat,
  [sym_exec_statement] = sym_exec_statement,
  [sym_type_parameter] = sym_type_parameter,
  [sym_parenthesized_list_splat] = sym_parenthesized_list_splat,
  [sym_argument_list] = sym_argument_list,
  [sym_decorated_definition] = sym_decorated_definition,
  [sym_decorator] = sym_decorator,
  [sym_block] = sym_block,
  [sym_expression_list] = sym_expression_list,
  [sym_dotted_name] = sym_dotted_name,
  [sym_case_pattern] = sym_case_pattern,
  [sym__simple_pattern] = sym__simple_pattern,
  [sym__as_pattern] = sym_as_pattern,
  [sym_union_pattern] = sym_union_pattern,
  [sym__list_pattern] = sym_list_pattern,
  [sym__tuple_pattern] = sym_tuple_pattern,
  [sym_dict_pattern] = sym_dict_pattern,
  [sym__key_value_pattern] = sym__key_value_pattern,
  [sym_keyword_pattern] = sym_keyword_pattern,
  [sym_splat_pattern] = sym_splat_pattern,
  [sym_class_pattern] = sym_class_pattern,
  [sym_complex_pattern] = sym_complex_pattern,
  [sym__parameters] = sym__parameters,
  [sym__patterns] = sym__patterns,
  [sym_parameter] = sym_parameter,
  [sym_pattern] = sym_pattern,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym_list_pattern] = sym_list_pattern,
  [sym_default_parameter] = sym_default_parameter,
  [sym_typed_default_parameter] = sym_typed_default_parameter,
  [sym_list_splat_pattern] = sym_list_splat_pattern,
  [sym_dictionary_splat_pattern] = sym_dictionary_splat_pattern,
  [sym_as_pattern] = sym_as_pattern,
  [sym__expression_within_for_in_clause] = sym__expression_within_for_in_clause,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_not_operator] = sym_not_operator,
  [sym_boolean_operator] = sym_boolean_operator,
  [sym_binary_operator] = sym_binary_operator,
  [sym_unary_operator] = sym_unary_operator,
  [sym_comparison_operator] = sym_comparison_operator,
  [sym_lambda] = sym_lambda,
  [sym_lambda_within_for_in_clause] = sym_lambda,
  [sym_assignment] = sym_assignment,
  [sym_augmented_assignment] = sym_augmented_assignment,
  [sym_pattern_list] = sym_pattern_list,
  [sym__right_hand_side] = sym__right_hand_side,
  [sym_attribute] = sym_attribute,
  [sym_subscript] = sym_subscript,
  [sym_slice] = sym_slice,
  [sym_call] = sym_call,
  [sym_typed_parameter] = sym_typed_parameter,
  [sym_type] = sym_type,
  [sym_splat_type] = sym_splat_type,
  [sym_generic_type] = sym_generic_type,
  [sym_union_type] = sym_union_type,
  [sym_constrained_type] = sym_constrained_type,
  [sym_member_type] = sym_member_type,
  [sym_keyword_argument] = sym_keyword_argument,
  [sym_list] = sym_list,
  [sym_set] = sym_set,
  [sym_tuple] = sym_tuple,
  [sym_dictionary] = sym_dictionary,
  [sym_pair] = sym_pair,
  [sym_list_comprehension] = sym_list_comprehension,
  [sym_dictionary_comprehension] = sym_dictionary_comprehension,
  [sym_set_comprehension] = sym_set_comprehension,
  [sym__comprehension_clauses] = sym__comprehension_clauses,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym__collection_elements] = sym__collection_elements,
  [sym_for_in_clause] = sym_for_in_clause,
  [sym_if_clause] = sym_if_clause,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_concatenated_string] = sym_concatenated_string,
  [sym_string] = sym_string,
  [sym_string_content] = sym_string_content,
  [sym_interpolation] = sym_interpolation,
  [sym__f_expression] = sym__f_expression,
  [sym__not_escape_sequence] = sym__not_escape_sequence,
  [sym_format_specifier] = sym_format_specifier,
  [sym_positional_separator] = sym_positional_separator,
  [sym_keyword_separator] = sym_keyword_separator,
  [aux_sym_module_repeat1] = aux_sym_module_repeat1,
  [aux_sym__simple_statements_repeat1] = aux_sym__simple_statements_repeat1,
  [aux_sym_print_statement_repeat1] = aux_sym_print_statement_repeat1,
  [aux_sym_assert_statement_repeat1] = aux_sym_assert_statement_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_match_statement_repeat1] = aux_sym_match_statement_repeat1,
  [aux_sym__match_block_repeat1] = aux_sym__match_block_repeat1,
  [aux_sym_case_clause_repeat1] = aux_sym_case_clause_repeat1,
  [aux_sym_with_clause_repeat1] = aux_sym_with_clause_repeat1,
  [aux_sym_type_parameter_repeat1] = aux_sym_type_parameter_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_decorated_definition_repeat1] = aux_sym_decorated_definition_repeat1,
  [aux_sym_dotted_name_repeat1] = aux_sym_dotted_name_repeat1,
  [aux_sym_union_pattern_repeat1] = aux_sym_union_pattern_repeat1,
  [aux_sym_dict_pattern_repeat1] = aux_sym_dict_pattern_repeat1,
  [aux_sym__parameters_repeat1] = aux_sym__parameters_repeat1,
  [aux_sym__patterns_repeat1] = aux_sym__patterns_repeat1,
  [aux_sym_comparison_operator_repeat1] = aux_sym_comparison_operator_repeat1,
  [aux_sym_subscript_repeat1] = aux_sym_subscript_repeat1,
  [aux_sym_dictionary_repeat1] = aux_sym_dictionary_repeat1,
  [aux_sym__comprehension_clauses_repeat1] = aux_sym__comprehension_clauses_repeat1,
  [aux_sym__collection_elements_repeat1] = aux_sym__collection_elements_repeat1,
  [aux_sym_for_in_clause_repeat1] = aux_sym_for_in_clause_repeat1,
  [aux_sym_concatenated_string_repeat1] = aux_sym_concatenated_string_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_content_repeat1] = aux_sym_string_content_repeat1,
  [aux_sym_format_specifier_repeat1] = aux_sym_format_specifier_repeat1,
  [alias_sym_as_pattern_target] = alias_sym_as_pattern_target,
  [alias_sym_format_expression] = alias_sym_format_expression,
  [anon_alias_sym_notin] = anon_alias_sym_notin,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_print] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_eq] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ne] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_contains] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_fails] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_assert_] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_assert_eq] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_assert_ne] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_assert_contains] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_assert_fails] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_del] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pass] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lambda] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym_ellipsis] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_format_specifier_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_type_conversion] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_none] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_line_continuation] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_except] = {
    .visible = true,
    .named = false,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym_string_start] = {
    .visible = true,
    .named = true,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym_escape_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_string_end] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_statements] = {
    .visible = false,
    .named = true,
  },
  [sym_print_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_chevron] = {
    .visible = true,
    .named = true,
  },
  [sym_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_named_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__named_expression_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_pass_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_match_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__match_block] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_with_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_exec_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_list_splat] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_decorated_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_dotted_name] = {
    .visible = true,
    .named = true,
  },
  [sym_case_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym__as_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_union_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_dict_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__key_value_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_keyword_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_class_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_complex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__parameters] = {
    .visible = false,
    .named = true,
  },
  [sym__patterns] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_list_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_list_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_splat_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_as_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_within_for_in_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_not_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_within_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_augmented_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_list] = {
    .visible = true,
    .named = true,
  },
  [sym__right_hand_side] = {
    .visible = false,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_slice] = {
    .visible = true,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_splat_type] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_constrained_type] = {
    .visible = true,
    .named = true,
  },
  [sym_member_type] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_set] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_list_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_set_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym__comprehension_clauses] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__collection_elements] = {
    .visible = false,
    .named = true,
  },
  [sym_for_in_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenated_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string_content] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym__f_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__not_escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym_format_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_positional_separator] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_separator] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_module_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__simple_statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_print_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assert_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_match_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__match_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_with_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameter_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_decorated_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dotted_name_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dict_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__patterns_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_comparison_operator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subscript_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dictionary_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__comprehension_clauses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__collection_elements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_in_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenated_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_format_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_as_pattern_target] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_format_expression] = {
    .visible = true,
    .named = true,
  },
  [anon_alias_sym_notin] = {
    .visible = true,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_code = 7,
  field_condition = 8,
  field_consequence = 9,
  field_definition = 10,
  field_expression = 11,
  field_format_specifier = 12,
  field_function = 13,
  field_guard = 14,
  field_key = 15,
  field_left = 16,
  field_name = 17,
  field_object = 18,
  field_operator = 19,
  field_operators = 20,
  field_parameters = 21,
  field_return_type = 22,
  field_right = 23,
  field_subject = 24,
  field_subscript = 25,
  field_type = 26,
  field_type_conversion = 27,
  field_type_parameters = 28,
  field_value = 29,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_code] = "code",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_definition] = "definition",
  [field_expression] = "expression",
  [field_format_specifier] = "format_specifier",
  [field_function] = "function",
  [field_guard] = "guard",
  [field_key] = "key",
  [field_left] = "left",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_operators] = "operators",
  [field_parameters] = "parameters",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_subject] = "subject",
  [field_subscript] = "subscript",
  [field_type] = "type",
  [field_type_conversion] = "type_conversion",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [3] = {.index = 0, .length = 1},
  [4] = {.index = 1, .length = 1},
  [6] = {.index = 2, .length = 1},
  [7] = {.index = 3, .length = 2},
  [8] = {.index = 5, .length = 2},
  [9] = {.index = 7, .length = 1},
  [10] = {.index = 8, .length = 1},
  [11] = {.index = 9, .length = 1},
  [12] = {.index = 10, .length = 2},
  [13] = {.index = 12, .length = 1},
  [14] = {.index = 13, .length = 2},
  [15] = {.index = 15, .length = 2},
  [16] = {.index = 17, .length = 2},
  [17] = {.index = 19, .length = 3},
  [18] = {.index = 22, .length = 1},
  [19] = {.index = 23, .length = 2},
  [20] = {.index = 25, .length = 1},
  [21] = {.index = 26, .length = 2},
  [22] = {.index = 28, .length = 1},
  [23] = {.index = 29, .length = 2},
  [24] = {.index = 31, .length = 2},
  [25] = {.index = 33, .length = 1},
  [26] = {.index = 34, .length = 3},
  [27] = {.index = 37, .length = 2},
  [28] = {.index = 39, .length = 2},
  [29] = {.index = 41, .length = 1},
  [31] = {.index = 42, .length = 1},
  [32] = {.index = 43, .length = 2},
  [33] = {.index = 45, .length = 1},
  [34] = {.index = 46, .length = 2},
  [35] = {.index = 48, .length = 2},
  [36] = {.index = 50, .length = 2},
  [38] = {.index = 52, .length = 2},
  [39] = {.index = 54, .length = 2},
  [40] = {.index = 56, .length = 1},
  [41] = {.index = 57, .length = 3},
  [42] = {.index = 60, .length = 3},
  [43] = {.index = 63, .length = 3},
  [44] = {.index = 66, .length = 3},
  [45] = {.index = 69, .length = 4},
  [46] = {.index = 73, .length = 1},
  [47] = {.index = 74, .length = 3},
  [48] = {.index = 77, .length = 3},
  [49] = {.index = 80, .length = 2},
  [50] = {.index = 82, .length = 3},
  [51] = {.index = 85, .length = 3},
  [52] = {.index = 13, .length = 2},
  [53] = {.index = 88, .length = 1},
  [54] = {.index = 89, .length = 3},
  [55] = {.index = 92, .length = 2},
  [56] = {.index = 94, .length = 2},
  [57] = {.index = 96, .length = 2},
  [58] = {.index = 98, .length = 3},
  [59] = {.index = 101, .length = 4},
  [60] = {.index = 105, .length = 2},
  [61] = {.index = 107, .length = 4},
  [62] = {.index = 111, .length = 4},
  [63] = {.index = 115, .length = 1},
  [64] = {.index = 116, .length = 4},
  [65] = {.index = 120, .length = 2},
  [66] = {.index = 122, .length = 3},
  [67] = {.index = 125, .length = 3},
  [68] = {.index = 128, .length = 4},
  [69] = {.index = 132, .length = 4},
  [70] = {.index = 136, .length = 4},
  [71] = {.index = 140, .length = 2},
  [72] = {.index = 142, .length = 3},
  [73] = {.index = 145, .length = 3},
  [74] = {.index = 12, .length = 1},
  [75] = {.index = 148, .length = 5},
  [76] = {.index = 153, .length = 3},
  [77] = {.index = 156, .length = 4},
  [78] = {.index = 160, .length = 4},
  [79] = {.index = 164, .length = 4},
  [80] = {.index = 168, .length = 4},
  [81] = {.index = 172, .length = 4},
  [82] = {.index = 176, .length = 5},
  [83] = {.index = 181, .length = 2},
  [84] = {.index = 183, .length = 3},
  [85] = {.index = 186, .length = 2},
  [86] = {.index = 188, .length = 2},
  [87] = {.index = 190, .length = 1},
  [88] = {.index = 191, .length = 4},
  [89] = {.index = 195, .length = 4},
  [90] = {.index = 199, .length = 4},
  [91] = {.index = 203, .length = 5},
  [92] = {.index = 208, .length = 5},
  [93] = {.index = 213, .length = 5},
  [94] = {.index = 218, .length = 5},
  [95] = {.index = 223, .length = 3},
  [96] = {.index = 226, .length = 4},
  [97] = {.index = 230, .length = 4},
  [98] = {.index = 234, .length = 2},
  [99] = {.index = 236, .length = 1},
  [100] = {.index = 237, .length = 2},
  [101] = {.index = 239, .length = 2},
  [102] = {.index = 241, .length = 5},
  [103] = {.index = 246, .length = 5},
  [104] = {.index = 251, .length = 5},
  [105] = {.index = 256, .length = 6},
  [106] = {.index = 262, .length = 2},
  [107] = {.index = 264, .length = 2},
  [108] = {.index = 266, .length = 3},
  [109] = {.index = 269, .length = 1},
  [110] = {.index = 270, .length = 6},
  [111] = {.index = 276, .length = 3},
  [112] = {.index = 279, .length = 2},
  [113] = {.index = 281, .length = 2},
  [114] = {.index = 283, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_argument, 1},
  [1] =
    {field_value, 0},
  [2] =
    {field_code, 1},
  [3] =
    {field_argument, 1},
    {field_operator, 0},
  [5] =
    {field_arguments, 1},
    {field_function, 0},
  [7] =
    {field_operators, 1, .inherited = true},
  [8] =
    {field_definition, 1},
  [9] =
    {field_argument, 2, .inherited = true},
  [10] =
    {field_argument, 1},
    {field_argument, 2, .inherited = true},
  [12] =
    {field_body, 2},
  [13] =
    {field_name, 0},
    {field_value, 2},
  [15] =
    {field_left, 0},
    {field_type, 2},
  [17] =
    {field_left, 0},
    {field_right, 2},
  [19] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [22] =
    {field_alias, 2},
  [23] =
    {field_attribute, 2},
    {field_object, 0},
  [25] =
    {field_operators, 0},
  [26] =
    {field_operators, 0, .inherited = true},
    {field_operators, 1, .inherited = true},
  [28] =
    {field_expression, 1},
  [29] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [31] =
    {field_condition, 1},
    {field_consequence, 3},
  [33] =
    {field_subject, 1},
  [34] =
    {field_alternative, 3, .inherited = true},
    {field_body, 3},
    {field_subject, 1},
  [37] =
    {field_subject, 0, .inherited = true},
    {field_subject, 1, .inherited = true},
  [39] =
    {field_body, 3},
    {field_condition, 1},
  [41] =
    {field_body, 3},
  [42] =
    {field_body, 1},
  [43] =
    {field_key, 0},
    {field_value, 2},
  [45] =
    {field_type, 2},
  [46] =
    {field_body, 3},
    {field_parameters, 1},
  [48] =
    {field_subscript, 2},
    {field_value, 0},
  [50] =
    {field_operators, 0},
    {field_operators, 1},
  [52] =
    {field_expression, 1},
    {field_type_conversion, 2},
  [54] =
    {field_expression, 1},
    {field_format_specifier, 2},
  [56] =
    {field_alternative, 0},
  [57] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 3},
  [60] =
    {field_alternative, 4, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
  [63] =
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [66] =
    {field_alternative, 4, .inherited = true},
    {field_body, 4},
    {field_subject, 1},
  [69] =
    {field_alternative, 4, .inherited = true},
    {field_body, 4},
    {field_subject, 1},
    {field_subject, 2, .inherited = true},
  [73] =
    {field_body, 4},
  [74] =
    {field_alternative, 4},
    {field_body, 3},
    {field_condition, 1},
  [77] =
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [80] =
    {field_body, 3},
    {field_body, 4},
  [82] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
  [85] =
    {field_left, 0},
    {field_right, 4},
    {field_type, 2},
  [88] =
    {field_subscript, 1},
  [89] =
    {field_subscript, 2},
    {field_subscript, 3, .inherited = true},
    {field_value, 0},
  [92] =
    {field_subscript, 0, .inherited = true},
    {field_subscript, 1, .inherited = true},
  [94] =
    {field_expression, 1},
    {field_type_conversion, 3},
  [96] =
    {field_expression, 1},
    {field_format_specifier, 3},
  [98] =
    {field_expression, 1},
    {field_format_specifier, 3},
    {field_type_conversion, 2},
  [101] =
    {field_alternative, 4, .inherited = true},
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
  [105] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [107] =
    {field_alternative, 5},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [111] =
    {field_alternative, 5, .inherited = true},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [115] =
    {field_alternative, 1, .inherited = true},
  [116] =
    {field_alternative, 5, .inherited = true},
    {field_body, 5},
    {field_subject, 1},
    {field_subject, 2, .inherited = true},
  [120] =
    {field_body, 4},
    {field_body, 5},
  [122] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
  [125] =
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [128] =
    {field_alternative, 5},
    {field_body, 3},
    {field_body, 4},
    {field_condition, 1},
  [132] =
    {field_body, 4},
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 2},
  [136] =
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [140] =
    {field_left, 1},
    {field_right, 3},
  [142] =
    {field_name, 0},
    {field_type, 2},
    {field_value, 4},
  [145] =
    {field_expression, 1},
    {field_format_specifier, 4},
    {field_type_conversion, 3},
  [148] =
    {field_alternative, 5, .inherited = true},
    {field_alternative, 6},
    {field_condition, 1},
    {field_consequence, 3},
    {field_consequence, 4},
  [153] =
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [156] =
    {field_body, 5},
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 3},
  [160] =
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [164] =
    {field_alternative, 6},
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [168] =
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [172] =
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [176] =
    {field_body, 5},
    {field_body, 6},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [181] =
    {field_left, 2},
    {field_right, 4},
  [183] =
    {field_left, 1},
    {field_right, 3},
    {field_right, 4},
  [186] =
    {field_body, 2},
    {field_body, 3},
  [188] =
    {field_key, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [190] =
    {field_consequence, 3},
  [191] =
    {field_alternative, 7},
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [195] =
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
  [199] =
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [203] =
    {field_body, 6},
    {field_body, 7},
    {field_name, 2},
    {field_parameters, 4},
    {field_type_parameters, 3},
  [208] =
    {field_alternative, 7},
    {field_body, 5},
    {field_body, 6},
    {field_left, 1},
    {field_right, 3},
  [213] =
    {field_body, 6},
    {field_body, 7},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 4},
  [218] =
    {field_body, 7},
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 5},
    {field_type_parameters, 2},
  [223] =
    {field_left, 2},
    {field_right, 4},
    {field_right, 5},
  [226] =
    {field_key, 1, .inherited = true},
    {field_key, 2, .inherited = true},
    {field_value, 1, .inherited = true},
    {field_value, 2, .inherited = true},
  [230] =
    {field_key, 0, .inherited = true},
    {field_key, 1, .inherited = true},
    {field_value, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [234] =
    {field_key, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [236] =
    {field_consequence, 4},
  [237] =
    {field_consequence, 3},
    {field_consequence, 4},
  [239] =
    {field_consequence, 4},
    {field_guard, 2},
  [241] =
    {field_alternative, 8},
    {field_body, 6},
    {field_body, 7},
    {field_left, 2},
    {field_right, 4},
  [246] =
    {field_body, 7},
    {field_body, 8},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 5},
  [251] =
    {field_body, 8},
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 6},
    {field_type_parameters, 3},
  [256] =
    {field_body, 7},
    {field_body, 8},
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 5},
    {field_type_parameters, 2},
  [262] =
    {field_consequence, 4},
    {field_consequence, 5},
  [264] =
    {field_consequence, 5},
    {field_guard, 3},
  [266] =
    {field_consequence, 4},
    {field_consequence, 5},
    {field_guard, 2},
  [269] =
    {field_consequence, 5},
  [270] =
    {field_body, 8},
    {field_body, 9},
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 6},
    {field_type_parameters, 3},
  [276] =
    {field_consequence, 5},
    {field_consequence, 6},
    {field_guard, 3},
  [279] =
    {field_consequence, 5},
    {field_consequence, 6},
  [281] =
    {field_consequence, 6},
    {field_guard, 4},
  [283] =
    {field_consequence, 6},
    {field_consequence, 7},
    {field_guard, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [2] = {
    [0] = sym_list_splat,
  },
  [5] = {
    [1] = sym_identifier,
  },
  [18] = {
    [2] = alias_sym_as_pattern_target,
  },
  [24] = {
    [3] = sym_block,
  },
  [28] = {
    [3] = sym_block,
  },
  [29] = {
    [3] = sym_block,
  },
  [30] = {
    [1] = sym_parenthesized_expression,
  },
  [36] = {
    [0] = anon_alias_sym_notin,
    [1] = anon_alias_sym_notin,
  },
  [37] = {
    [0] = alias_sym_format_expression,
  },
  [41] = {
    [3] = sym_block,
  },
  [42] = {
    [3] = sym_block,
  },
  [46] = {
    [4] = sym_block,
  },
  [47] = {
    [3] = sym_block,
  },
  [50] = {
    [4] = sym_block,
  },
  [52] = {
    [0] = sym_identifier,
  },
  [59] = {
    [3] = sym_block,
  },
  [66] = {
    [5] = sym_block,
  },
  [67] = {
    [5] = sym_block,
  },
  [70] = {
    [5] = sym_block,
  },
  [74] = {
    [2] = sym_block,
  },
  [76] = {
    [6] = sym_block,
  },
  [78] = {
    [6] = sym_block,
  },
  [79] = {
    [5] = sym_block,
  },
  [81] = {
    [6] = sym_block,
  },
  [87] = {
    [3] = sym_block,
  },
  [88] = {
    [6] = sym_block,
  },
  [90] = {
    [7] = sym_block,
  },
  [94] = {
    [7] = sym_block,
  },
  [99] = {
    [4] = sym_block,
  },
  [101] = {
    [4] = sym_block,
  },
  [104] = {
    [8] = sym_block,
  },
  [107] = {
    [5] = sym_block,
  },
  [109] = {
    [5] = sym_block,
  },
  [113] = {
    [6] = sym_block,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__simple_statements, 2,
    sym__simple_statements,
    sym_block,
  sym_parenthesized_list_splat, 2,
    sym_parenthesized_list_splat,
    sym_parenthesized_expression,
  sym_list_splat_pattern, 2,
    sym_list_splat_pattern,
    sym_list_splat,
  sym_expression, 2,
    sym_expression,
    alias_sym_as_pattern_target,
  sym_interpolation, 2,
    sym_interpolation,
    alias_sym_format_expression,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 2,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 4,
  [24] = 5,
  [25] = 6,
  [26] = 7,
  [27] = 8,
  [28] = 9,
  [29] = 10,
  [30] = 11,
  [31] = 12,
  [32] = 13,
  [33] = 15,
  [34] = 34,
  [35] = 19,
  [36] = 34,
  [37] = 18,
  [38] = 3,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 40,
  [43] = 43,
  [44] = 41,
  [45] = 41,
  [46] = 46,
  [47] = 46,
  [48] = 48,
  [49] = 48,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 50,
  [54] = 51,
  [55] = 52,
  [56] = 56,
  [57] = 56,
  [58] = 58,
  [59] = 59,
  [60] = 58,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 59,
  [67] = 67,
  [68] = 68,
  [69] = 67,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 61,
  [74] = 74,
  [75] = 72,
  [76] = 68,
  [77] = 77,
  [78] = 65,
  [79] = 74,
  [80] = 80,
  [81] = 81,
  [82] = 80,
  [83] = 70,
  [84] = 81,
  [85] = 77,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 88,
  [90] = 90,
  [91] = 90,
  [92] = 88,
  [93] = 90,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 98,
  [103] = 99,
  [104] = 101,
  [105] = 105,
  [106] = 105,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 97,
  [111] = 98,
  [112] = 99,
  [113] = 97,
  [114] = 105,
  [115] = 108,
  [116] = 97,
  [117] = 98,
  [118] = 99,
  [119] = 105,
  [120] = 108,
  [121] = 97,
  [122] = 98,
  [123] = 99,
  [124] = 97,
  [125] = 98,
  [126] = 99,
  [127] = 97,
  [128] = 98,
  [129] = 99,
  [130] = 97,
  [131] = 98,
  [132] = 97,
  [133] = 98,
  [134] = 98,
  [135] = 98,
  [136] = 108,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 140,
  [142] = 96,
  [143] = 143,
  [144] = 137,
  [145] = 145,
  [146] = 146,
  [147] = 95,
  [148] = 148,
  [149] = 149,
  [150] = 137,
  [151] = 151,
  [152] = 137,
  [153] = 139,
  [154] = 140,
  [155] = 151,
  [156] = 156,
  [157] = 139,
  [158] = 140,
  [159] = 137,
  [160] = 137,
  [161] = 137,
  [162] = 139,
  [163] = 138,
  [164] = 138,
  [165] = 138,
  [166] = 156,
  [167] = 143,
  [168] = 149,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 170,
  [175] = 171,
  [176] = 170,
  [177] = 171,
  [178] = 172,
  [179] = 173,
  [180] = 170,
  [181] = 171,
  [182] = 172,
  [183] = 172,
  [184] = 173,
  [185] = 170,
  [186] = 171,
  [187] = 173,
  [188] = 172,
  [189] = 173,
  [190] = 170,
  [191] = 171,
  [192] = 171,
  [193] = 172,
  [194] = 194,
  [195] = 194,
  [196] = 173,
  [197] = 172,
  [198] = 173,
  [199] = 170,
  [200] = 200,
  [201] = 201,
  [202] = 200,
  [203] = 203,
  [204] = 204,
  [205] = 203,
  [206] = 206,
  [207] = 201,
  [208] = 204,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 210,
  [215] = 210,
  [216] = 211,
  [217] = 213,
  [218] = 218,
  [219] = 219,
  [220] = 212,
  [221] = 210,
  [222] = 211,
  [223] = 213,
  [224] = 219,
  [225] = 210,
  [226] = 211,
  [227] = 212,
  [228] = 219,
  [229] = 212,
  [230] = 219,
  [231] = 211,
  [232] = 232,
  [233] = 210,
  [234] = 211,
  [235] = 219,
  [236] = 212,
  [237] = 210,
  [238] = 211,
  [239] = 213,
  [240] = 219,
  [241] = 212,
  [242] = 212,
  [243] = 219,
  [244] = 213,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 248,
  [250] = 245,
  [251] = 248,
  [252] = 247,
  [253] = 253,
  [254] = 245,
  [255] = 255,
  [256] = 247,
  [257] = 245,
  [258] = 248,
  [259] = 248,
  [260] = 247,
  [261] = 245,
  [262] = 262,
  [263] = 247,
  [264] = 248,
  [265] = 245,
  [266] = 266,
  [267] = 266,
  [268] = 247,
  [269] = 248,
  [270] = 245,
  [271] = 255,
  [272] = 248,
  [273] = 245,
  [274] = 245,
  [275] = 266,
  [276] = 247,
  [277] = 247,
  [278] = 278,
  [279] = 247,
  [280] = 248,
  [281] = 255,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 294,
  [295] = 282,
  [296] = 291,
  [297] = 297,
  [298] = 287,
  [299] = 218,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 300,
  [304] = 304,
  [305] = 283,
  [306] = 285,
  [307] = 307,
  [308] = 294,
  [309] = 297,
  [310] = 282,
  [311] = 311,
  [312] = 282,
  [313] = 302,
  [314] = 282,
  [315] = 315,
  [316] = 282,
  [317] = 282,
  [318] = 282,
  [319] = 282,
  [320] = 320,
  [321] = 321,
  [322] = 315,
  [323] = 286,
  [324] = 324,
  [325] = 232,
  [326] = 302,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 328,
  [331] = 331,
  [332] = 232,
  [333] = 333,
  [334] = 334,
  [335] = 334,
  [336] = 331,
  [337] = 337,
  [338] = 338,
  [339] = 338,
  [340] = 337,
  [341] = 218,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 353,
  [354] = 351,
  [355] = 353,
  [356] = 343,
  [357] = 344,
  [358] = 345,
  [359] = 346,
  [360] = 347,
  [361] = 348,
  [362] = 351,
  [363] = 353,
  [364] = 343,
  [365] = 344,
  [366] = 345,
  [367] = 347,
  [368] = 348,
  [369] = 348,
  [370] = 351,
  [371] = 353,
  [372] = 343,
  [373] = 344,
  [374] = 345,
  [375] = 347,
  [376] = 348,
  [377] = 351,
  [378] = 353,
  [379] = 343,
  [380] = 344,
  [381] = 345,
  [382] = 347,
  [383] = 348,
  [384] = 351,
  [385] = 353,
  [386] = 343,
  [387] = 344,
  [388] = 345,
  [389] = 347,
  [390] = 353,
  [391] = 391,
  [392] = 392,
  [393] = 349,
  [394] = 394,
  [395] = 395,
  [396] = 343,
  [397] = 350,
  [398] = 344,
  [399] = 345,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 352,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 407,
  [409] = 409,
  [410] = 349,
  [411] = 346,
  [412] = 395,
  [413] = 352,
  [414] = 414,
  [415] = 342,
  [416] = 349,
  [417] = 395,
  [418] = 418,
  [419] = 419,
  [420] = 349,
  [421] = 395,
  [422] = 422,
  [423] = 423,
  [424] = 402,
  [425] = 403,
  [426] = 347,
  [427] = 349,
  [428] = 395,
  [429] = 349,
  [430] = 394,
  [431] = 394,
  [432] = 394,
  [433] = 394,
  [434] = 394,
  [435] = 394,
  [436] = 406,
  [437] = 401,
  [438] = 351,
  [439] = 348,
  [440] = 440,
  [441] = 441,
  [442] = 440,
  [443] = 443,
  [444] = 441,
  [445] = 445,
  [446] = 446,
  [447] = 446,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 451,
  [454] = 454,
  [455] = 448,
  [456] = 454,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 463,
  [465] = 465,
  [466] = 459,
  [467] = 467,
  [468] = 468,
  [469] = 457,
  [470] = 445,
  [471] = 471,
  [472] = 472,
  [473] = 472,
  [474] = 96,
  [475] = 95,
  [476] = 476,
  [477] = 477,
  [478] = 478,
  [479] = 476,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 481,
  [485] = 485,
  [486] = 486,
  [487] = 483,
  [488] = 485,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 486,
  [493] = 493,
  [494] = 477,
  [495] = 490,
  [496] = 478,
  [497] = 489,
  [498] = 498,
  [499] = 480,
  [500] = 491,
  [501] = 482,
  [502] = 498,
  [503] = 493,
  [504] = 504,
  [505] = 504,
  [506] = 506,
  [507] = 507,
  [508] = 508,
  [509] = 509,
  [510] = 510,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 506,
  [516] = 516,
  [517] = 517,
  [518] = 95,
  [519] = 519,
  [520] = 520,
  [521] = 521,
  [522] = 522,
  [523] = 523,
  [524] = 524,
  [525] = 525,
  [526] = 526,
  [527] = 527,
  [528] = 507,
  [529] = 529,
  [530] = 530,
  [531] = 96,
  [532] = 532,
  [533] = 533,
  [534] = 534,
  [535] = 509,
  [536] = 536,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 540,
  [541] = 541,
  [542] = 512,
  [543] = 513,
  [544] = 514,
  [545] = 545,
  [546] = 546,
  [547] = 547,
  [548] = 548,
  [549] = 522,
  [550] = 550,
  [551] = 551,
  [552] = 552,
  [553] = 553,
  [554] = 554,
  [555] = 555,
  [556] = 556,
  [557] = 545,
  [558] = 511,
  [559] = 559,
  [560] = 553,
  [561] = 529,
  [562] = 530,
  [563] = 517,
  [564] = 532,
  [565] = 533,
  [566] = 519,
  [567] = 567,
  [568] = 568,
  [569] = 536,
  [570] = 550,
  [571] = 568,
  [572] = 508,
  [573] = 523,
  [574] = 510,
  [575] = 537,
  [576] = 516,
  [577] = 520,
  [578] = 538,
  [579] = 541,
  [580] = 524,
  [581] = 540,
  [582] = 548,
  [583] = 559,
  [584] = 567,
  [585] = 585,
  [586] = 546,
  [587] = 585,
  [588] = 527,
  [589] = 547,
  [590] = 526,
  [591] = 551,
  [592] = 554,
  [593] = 552,
  [594] = 521,
  [595] = 555,
  [596] = 556,
  [597] = 534,
  [598] = 539,
  [599] = 525,
  [600] = 600,
  [601] = 600,
  [602] = 600,
  [603] = 600,
  [604] = 600,
  [605] = 600,
  [606] = 606,
  [607] = 606,
  [608] = 608,
  [609] = 609,
  [610] = 610,
  [611] = 611,
  [612] = 612,
  [613] = 613,
  [614] = 614,
  [615] = 615,
  [616] = 616,
  [617] = 617,
  [618] = 616,
  [619] = 615,
  [620] = 609,
  [621] = 610,
  [622] = 611,
  [623] = 612,
  [624] = 613,
  [625] = 614,
  [626] = 626,
  [627] = 617,
  [628] = 616,
  [629] = 615,
  [630] = 609,
  [631] = 610,
  [632] = 611,
  [633] = 612,
  [634] = 613,
  [635] = 614,
  [636] = 609,
  [637] = 610,
  [638] = 617,
  [639] = 616,
  [640] = 615,
  [641] = 609,
  [642] = 610,
  [643] = 611,
  [644] = 612,
  [645] = 613,
  [646] = 614,
  [647] = 611,
  [648] = 612,
  [649] = 649,
  [650] = 650,
  [651] = 608,
  [652] = 613,
  [653] = 626,
  [654] = 649,
  [655] = 617,
  [656] = 616,
  [657] = 615,
  [658] = 609,
  [659] = 610,
  [660] = 611,
  [661] = 612,
  [662] = 613,
  [663] = 650,
  [664] = 650,
  [665] = 617,
  [666] = 608,
  [667] = 616,
  [668] = 615,
  [669] = 609,
  [670] = 610,
  [671] = 611,
  [672] = 612,
  [673] = 613,
  [674] = 649,
  [675] = 650,
  [676] = 608,
  [677] = 649,
  [678] = 608,
  [679] = 650,
  [680] = 614,
  [681] = 614,
  [682] = 650,
  [683] = 608,
  [684] = 649,
  [685] = 650,
  [686] = 608,
  [687] = 650,
  [688] = 650,
  [689] = 614,
  [690] = 617,
  [691] = 616,
  [692] = 650,
  [693] = 650,
  [694] = 617,
  [695] = 615,
  [696] = 461,
  [697] = 452,
  [698] = 467,
  [699] = 468,
  [700] = 458,
  [701] = 449,
  [702] = 450,
  [703] = 703,
  [704] = 703,
  [705] = 703,
  [706] = 706,
  [707] = 707,
  [708] = 708,
  [709] = 709,
  [710] = 709,
  [711] = 711,
  [712] = 706,
  [713] = 713,
  [714] = 711,
  [715] = 715,
  [716] = 716,
  [717] = 717,
  [718] = 718,
  [719] = 719,
  [720] = 720,
  [721] = 719,
  [722] = 720,
  [723] = 723,
  [724] = 715,
  [725] = 725,
  [726] = 726,
  [727] = 723,
  [728] = 728,
  [729] = 729,
  [730] = 728,
  [731] = 725,
  [732] = 708,
  [733] = 706,
  [734] = 443,
  [735] = 441,
  [736] = 440,
  [737] = 726,
  [738] = 723,
  [739] = 703,
  [740] = 703,
  [741] = 726,
  [742] = 728,
  [743] = 729,
  [744] = 707,
  [745] = 729,
  [746] = 708,
  [747] = 713,
  [748] = 709,
  [749] = 711,
  [750] = 703,
  [751] = 703,
  [752] = 715,
  [753] = 713,
  [754] = 719,
  [755] = 720,
  [756] = 707,
  [757] = 719,
  [758] = 452,
  [759] = 449,
  [760] = 450,
  [761] = 713,
  [762] = 762,
  [763] = 763,
  [764] = 764,
  [765] = 765,
  [766] = 766,
  [767] = 767,
  [768] = 768,
  [769] = 713,
  [770] = 770,
  [771] = 771,
  [772] = 772,
  [773] = 773,
  [774] = 774,
  [775] = 775,
  [776] = 776,
  [777] = 777,
  [778] = 463,
  [779] = 779,
  [780] = 780,
  [781] = 781,
  [782] = 459,
  [783] = 783,
  [784] = 784,
  [785] = 785,
  [786] = 715,
  [787] = 787,
  [788] = 720,
  [789] = 771,
  [790] = 457,
  [791] = 460,
  [792] = 465,
  [793] = 445,
  [794] = 794,
  [795] = 795,
  [796] = 796,
  [797] = 797,
  [798] = 461,
  [799] = 452,
  [800] = 467,
  [801] = 468,
  [802] = 458,
  [803] = 449,
  [804] = 450,
  [805] = 462,
  [806] = 460,
  [807] = 465,
  [808] = 463,
  [809] = 459,
  [810] = 457,
  [811] = 445,
  [812] = 812,
  [813] = 772,
  [814] = 462,
  [815] = 725,
  [816] = 776,
  [817] = 794,
  [818] = 726,
  [819] = 777,
  [820] = 461,
  [821] = 773,
  [822] = 723,
  [823] = 443,
  [824] = 441,
  [825] = 440,
  [826] = 762,
  [827] = 787,
  [828] = 763,
  [829] = 706,
  [830] = 467,
  [831] = 764,
  [832] = 762,
  [833] = 783,
  [834] = 468,
  [835] = 779,
  [836] = 763,
  [837] = 458,
  [838] = 780,
  [839] = 796,
  [840] = 781,
  [841] = 797,
  [842] = 765,
  [843] = 766,
  [844] = 728,
  [845] = 718,
  [846] = 768,
  [847] = 716,
  [848] = 726,
  [849] = 770,
  [850] = 723,
  [851] = 728,
  [852] = 796,
  [853] = 797,
  [854] = 729,
  [855] = 774,
  [856] = 729,
  [857] = 707,
  [858] = 708,
  [859] = 775,
  [860] = 772,
  [861] = 773,
  [862] = 787,
  [863] = 774,
  [864] = 775,
  [865] = 707,
  [866] = 725,
  [867] = 708,
  [868] = 784,
  [869] = 785,
  [870] = 726,
  [871] = 723,
  [872] = 728,
  [873] = 764,
  [874] = 729,
  [875] = 765,
  [876] = 707,
  [877] = 717,
  [878] = 776,
  [879] = 708,
  [880] = 777,
  [881] = 709,
  [882] = 711,
  [883] = 709,
  [884] = 766,
  [885] = 767,
  [886] = 711,
  [887] = 795,
  [888] = 768,
  [889] = 709,
  [890] = 713,
  [891] = 779,
  [892] = 780,
  [893] = 781,
  [894] = 784,
  [895] = 785,
  [896] = 771,
  [897] = 770,
  [898] = 711,
  [899] = 715,
  [900] = 783,
  [901] = 719,
  [902] = 720,
  [903] = 903,
  [904] = 904,
  [905] = 703,
  [906] = 462,
  [907] = 706,
  [908] = 715,
  [909] = 719,
  [910] = 720,
  [911] = 460,
  [912] = 462,
  [913] = 794,
  [914] = 465,
  [915] = 812,
  [916] = 795,
  [917] = 706,
  [918] = 812,
  [919] = 767,
  [920] = 781,
  [921] = 796,
  [922] = 779,
  [923] = 764,
  [924] = 780,
  [925] = 771,
  [926] = 706,
  [927] = 776,
  [928] = 766,
  [929] = 783,
  [930] = 767,
  [931] = 768,
  [932] = 797,
  [933] = 762,
  [934] = 764,
  [935] = 765,
  [936] = 460,
  [937] = 462,
  [938] = 465,
  [939] = 777,
  [940] = 796,
  [941] = 797,
  [942] = 794,
  [943] = 795,
  [944] = 766,
  [945] = 812,
  [946] = 471,
  [947] = 787,
  [948] = 452,
  [949] = 777,
  [950] = 462,
  [951] = 779,
  [952] = 796,
  [953] = 785,
  [954] = 776,
  [955] = 772,
  [956] = 780,
  [957] = 770,
  [958] = 767,
  [959] = 784,
  [960] = 461,
  [961] = 726,
  [962] = 781,
  [963] = 461,
  [964] = 723,
  [965] = 770,
  [966] = 762,
  [967] = 763,
  [968] = 728,
  [969] = 729,
  [970] = 707,
  [971] = 708,
  [972] = 709,
  [973] = 711,
  [974] = 764,
  [975] = 765,
  [976] = 766,
  [977] = 768,
  [978] = 767,
  [979] = 768,
  [980] = 467,
  [981] = 713,
  [982] = 763,
  [983] = 461,
  [984] = 770,
  [985] = 797,
  [986] = 468,
  [987] = 458,
  [988] = 784,
  [989] = 460,
  [990] = 785,
  [991] = 465,
  [992] = 452,
  [993] = 772,
  [994] = 773,
  [995] = 774,
  [996] = 775,
  [997] = 471,
  [998] = 776,
  [999] = 777,
  [1000] = 449,
  [1001] = 452,
  [1002] = 462,
  [1003] = 779,
  [1004] = 780,
  [1005] = 781,
  [1006] = 467,
  [1007] = 468,
  [1008] = 458,
  [1009] = 784,
  [1010] = 785,
  [1011] = 449,
  [1012] = 467,
  [1013] = 450,
  [1014] = 468,
  [1015] = 771,
  [1016] = 458,
  [1017] = 449,
  [1018] = 463,
  [1019] = 450,
  [1020] = 1020,
  [1021] = 1021,
  [1022] = 1022,
  [1023] = 459,
  [1024] = 783,
  [1025] = 703,
  [1026] = 772,
  [1027] = 773,
  [1028] = 774,
  [1029] = 787,
  [1030] = 457,
  [1031] = 460,
  [1032] = 703,
  [1033] = 773,
  [1034] = 445,
  [1035] = 794,
  [1036] = 771,
  [1037] = 795,
  [1038] = 715,
  [1039] = 812,
  [1040] = 465,
  [1041] = 783,
  [1042] = 462,
  [1043] = 762,
  [1044] = 774,
  [1045] = 719,
  [1046] = 787,
  [1047] = 720,
  [1048] = 794,
  [1049] = 775,
  [1050] = 450,
  [1051] = 795,
  [1052] = 812,
  [1053] = 775,
  [1054] = 763,
  [1055] = 765,
  [1056] = 449,
  [1057] = 766,
  [1058] = 767,
  [1059] = 768,
  [1060] = 461,
  [1061] = 452,
  [1062] = 903,
  [1063] = 467,
  [1064] = 716,
  [1065] = 468,
  [1066] = 717,
  [1067] = 718,
  [1068] = 471,
  [1069] = 458,
  [1070] = 904,
  [1071] = 449,
  [1072] = 450,
  [1073] = 465,
  [1074] = 770,
  [1075] = 716,
  [1076] = 461,
  [1077] = 445,
  [1078] = 794,
  [1079] = 452,
  [1080] = 717,
  [1081] = 795,
  [1082] = 467,
  [1083] = 772,
  [1084] = 762,
  [1085] = 773,
  [1086] = 774,
  [1087] = 468,
  [1088] = 458,
  [1089] = 763,
  [1090] = 718,
  [1091] = 471,
  [1092] = 771,
  [1093] = 463,
  [1094] = 775,
  [1095] = 460,
  [1096] = 460,
  [1097] = 462,
  [1098] = 812,
  [1099] = 787,
  [1100] = 465,
  [1101] = 776,
  [1102] = 459,
  [1103] = 777,
  [1104] = 783,
  [1105] = 716,
  [1106] = 764,
  [1107] = 717,
  [1108] = 779,
  [1109] = 443,
  [1110] = 718,
  [1111] = 441,
  [1112] = 797,
  [1113] = 440,
  [1114] = 780,
  [1115] = 781,
  [1116] = 796,
  [1117] = 765,
  [1118] = 784,
  [1119] = 462,
  [1120] = 785,
  [1121] = 457,
  [1122] = 450,
  [1123] = 462,
  [1124] = 445,
  [1125] = 457,
  [1126] = 459,
  [1127] = 462,
  [1128] = 462,
  [1129] = 1129,
  [1130] = 463,
  [1131] = 1131,
  [1132] = 1132,
  [1133] = 1132,
  [1134] = 1134,
  [1135] = 1135,
  [1136] = 1134,
  [1137] = 1137,
  [1138] = 1138,
  [1139] = 1134,
  [1140] = 1140,
  [1141] = 1141,
  [1142] = 1142,
  [1143] = 1135,
  [1144] = 1144,
  [1145] = 1137,
  [1146] = 1135,
  [1147] = 1140,
  [1148] = 1141,
  [1149] = 1142,
  [1150] = 1140,
  [1151] = 1141,
  [1152] = 1141,
  [1153] = 1142,
  [1154] = 1132,
  [1155] = 1144,
  [1156] = 1138,
  [1157] = 1132,
  [1158] = 1140,
  [1159] = 1144,
  [1160] = 1134,
  [1161] = 1138,
  [1162] = 1142,
  [1163] = 1138,
  [1164] = 1135,
  [1165] = 1137,
  [1166] = 1144,
  [1167] = 1137,
  [1168] = 1168,
  [1169] = 1169,
  [1170] = 1169,
  [1171] = 1169,
  [1172] = 1172,
  [1173] = 1173,
  [1174] = 1173,
  [1175] = 1175,
  [1176] = 1176,
  [1177] = 1177,
  [1178] = 1178,
  [1179] = 1177,
  [1180] = 1173,
  [1181] = 1178,
  [1182] = 1175,
  [1183] = 1176,
  [1184] = 1178,
  [1185] = 1177,
  [1186] = 1173,
  [1187] = 1175,
  [1188] = 1176,
  [1189] = 1177,
  [1190] = 1178,
  [1191] = 1176,
  [1192] = 1175,
  [1193] = 1193,
  [1194] = 1194,
  [1195] = 1195,
  [1196] = 1194,
  [1197] = 1195,
  [1198] = 1194,
  [1199] = 1195,
  [1200] = 1194,
  [1201] = 1195,
  [1202] = 904,
  [1203] = 463,
  [1204] = 459,
  [1205] = 457,
  [1206] = 445,
  [1207] = 903,
  [1208] = 1208,
  [1209] = 1209,
  [1210] = 1208,
  [1211] = 1209,
  [1212] = 1209,
  [1213] = 1208,
  [1214] = 1214,
  [1215] = 1209,
  [1216] = 1208,
  [1217] = 1217,
  [1218] = 1218,
  [1219] = 1219,
  [1220] = 1208,
  [1221] = 1209,
  [1222] = 1208,
  [1223] = 1209,
  [1224] = 1224,
  [1225] = 462,
  [1226] = 460,
  [1227] = 465,
  [1228] = 903,
  [1229] = 445,
  [1230] = 1230,
  [1231] = 457,
  [1232] = 462,
  [1233] = 463,
  [1234] = 459,
  [1235] = 457,
  [1236] = 445,
  [1237] = 1237,
  [1238] = 1238,
  [1239] = 1208,
  [1240] = 1217,
  [1241] = 1218,
  [1242] = 1219,
  [1243] = 904,
  [1244] = 903,
  [1245] = 1209,
  [1246] = 904,
  [1247] = 460,
  [1248] = 465,
  [1249] = 1249,
  [1250] = 463,
  [1251] = 459,
  [1252] = 463,
  [1253] = 459,
  [1254] = 457,
  [1255] = 903,
  [1256] = 445,
  [1257] = 904,
  [1258] = 1258,
  [1259] = 1258,
  [1260] = 1249,
  [1261] = 1261,
  [1262] = 1262,
  [1263] = 1214,
  [1264] = 1264,
  [1265] = 1238,
  [1266] = 1261,
  [1267] = 1261,
  [1268] = 1258,
  [1269] = 1269,
  [1270] = 1230,
  [1271] = 1261,
  [1272] = 1224,
  [1273] = 1261,
  [1274] = 1261,
  [1275] = 1261,
  [1276] = 1258,
  [1277] = 1264,
  [1278] = 1258,
  [1279] = 1258,
  [1280] = 1258,
  [1281] = 1269,
  [1282] = 1258,
  [1283] = 1258,
  [1284] = 1237,
  [1285] = 1285,
  [1286] = 1286,
  [1287] = 1287,
  [1288] = 1288,
  [1289] = 1287,
  [1290] = 1288,
  [1291] = 1291,
  [1292] = 1291,
  [1293] = 1293,
  [1294] = 1293,
  [1295] = 1293,
  [1296] = 1293,
  [1297] = 1293,
  [1298] = 1293,
  [1299] = 1293,
  [1300] = 1300,
  [1301] = 1301,
  [1302] = 1302,
  [1303] = 1303,
  [1304] = 1304,
  [1305] = 1305,
  [1306] = 1306,
  [1307] = 1304,
  [1308] = 1308,
  [1309] = 1305,
  [1310] = 1304,
  [1311] = 1305,
  [1312] = 1312,
  [1313] = 1313,
  [1314] = 1314,
  [1315] = 1304,
  [1316] = 1305,
  [1317] = 1304,
  [1318] = 1305,
  [1319] = 1304,
  [1320] = 1305,
  [1321] = 1304,
  [1322] = 1305,
  [1323] = 1304,
  [1324] = 1305,
  [1325] = 1312,
  [1326] = 1326,
  [1327] = 1304,
  [1328] = 1328,
  [1329] = 1329,
  [1330] = 1312,
  [1331] = 1305,
  [1332] = 1312,
  [1333] = 1304,
  [1334] = 1312,
  [1335] = 1304,
  [1336] = 1312,
  [1337] = 1305,
  [1338] = 1312,
  [1339] = 1305,
  [1340] = 1303,
  [1341] = 1341,
  [1342] = 1341,
  [1343] = 1301,
  [1344] = 1302,
  [1345] = 1329,
  [1346] = 1301,
  [1347] = 1302,
  [1348] = 1303,
  [1349] = 1328,
  [1350] = 1306,
  [1351] = 1314,
  [1352] = 1308,
  [1353] = 1314,
  [1354] = 1306,
  [1355] = 1308,
  [1356] = 1356,
  [1357] = 1329,
  [1358] = 1328,
  [1359] = 1326,
  [1360] = 1326,
  [1361] = 1303,
  [1362] = 1362,
  [1363] = 1326,
  [1364] = 1329,
  [1365] = 1326,
  [1366] = 1328,
  [1367] = 1302,
  [1368] = 1328,
  [1369] = 1314,
  [1370] = 1314,
  [1371] = 1302,
  [1372] = 1301,
  [1373] = 1341,
  [1374] = 1306,
  [1375] = 1308,
  [1376] = 1306,
  [1377] = 1306,
  [1378] = 1314,
  [1379] = 1302,
  [1380] = 1329,
  [1381] = 1308,
  [1382] = 1329,
  [1383] = 1301,
  [1384] = 1303,
  [1385] = 1301,
  [1386] = 1386,
  [1387] = 1308,
  [1388] = 1341,
  [1389] = 1326,
  [1390] = 1303,
  [1391] = 1328,
  [1392] = 1328,
  [1393] = 1393,
  [1394] = 1386,
  [1395] = 1395,
  [1396] = 1396,
  [1397] = 1397,
  [1398] = 1398,
  [1399] = 1329,
  [1400] = 1400,
  [1401] = 1326,
  [1402] = 1402,
  [1403] = 1403,
  [1404] = 1404,
  [1405] = 1395,
  [1406] = 1406,
  [1407] = 1301,
  [1408] = 1302,
  [1409] = 1303,
  [1410] = 1410,
  [1411] = 1411,
  [1412] = 1306,
  [1413] = 1397,
  [1414] = 1414,
  [1415] = 1314,
  [1416] = 1416,
  [1417] = 1404,
  [1418] = 1418,
  [1419] = 1419,
  [1420] = 1420,
  [1421] = 1308,
  [1422] = 1386,
  [1423] = 1404,
  [1424] = 1424,
  [1425] = 1425,
  [1426] = 1410,
  [1427] = 1404,
  [1428] = 1428,
  [1429] = 1404,
  [1430] = 1430,
  [1431] = 1404,
  [1432] = 1404,
  [1433] = 1386,
  [1434] = 1404,
  [1435] = 1404,
  [1436] = 1406,
  [1437] = 1437,
  [1438] = 1438,
  [1439] = 1418,
  [1440] = 1419,
  [1441] = 1424,
  [1442] = 1442,
  [1443] = 1443,
  [1444] = 1444,
  [1445] = 1445,
  [1446] = 1444,
  [1447] = 1447,
  [1448] = 1402,
  [1449] = 1396,
  [1450] = 1450,
  [1451] = 1443,
  [1452] = 1443,
  [1453] = 1445,
  [1454] = 1447,
  [1455] = 1362,
  [1456] = 1456,
  [1457] = 1457,
  [1458] = 1443,
  [1459] = 1445,
  [1460] = 1460,
  [1461] = 1447,
  [1462] = 1462,
  [1463] = 1443,
  [1464] = 1464,
  [1465] = 1445,
  [1466] = 1447,
  [1467] = 1447,
  [1468] = 1468,
  [1469] = 1443,
  [1470] = 1445,
  [1471] = 1447,
  [1472] = 1472,
  [1473] = 1418,
  [1474] = 1419,
  [1475] = 1443,
  [1476] = 1445,
  [1477] = 1447,
  [1478] = 1478,
  [1479] = 1462,
  [1480] = 1480,
  [1481] = 1406,
  [1482] = 1468,
  [1483] = 1424,
  [1484] = 1438,
  [1485] = 1480,
  [1486] = 1418,
  [1487] = 1402,
  [1488] = 1419,
  [1489] = 1396,
  [1490] = 1424,
  [1491] = 1491,
  [1492] = 1445,
  [1493] = 1457,
  [1494] = 1494,
  [1495] = 1402,
  [1496] = 1494,
  [1497] = 1396,
  [1498] = 1406,
  [1499] = 1499,
  [1500] = 1224,
  [1501] = 783,
  [1502] = 1502,
  [1503] = 1503,
  [1504] = 1504,
  [1505] = 1505,
  [1506] = 1506,
  [1507] = 1507,
  [1508] = 1508,
  [1509] = 1509,
  [1510] = 1510,
  [1511] = 1511,
  [1512] = 1450,
  [1513] = 1513,
  [1514] = 1514,
  [1515] = 1515,
  [1516] = 1506,
  [1517] = 1517,
  [1518] = 1518,
  [1519] = 1502,
  [1520] = 1520,
  [1521] = 1507,
  [1522] = 1522,
  [1523] = 763,
  [1524] = 1503,
  [1525] = 1525,
  [1526] = 1526,
  [1527] = 1510,
  [1528] = 1518,
  [1529] = 1529,
  [1530] = 1530,
  [1531] = 1510,
  [1532] = 1532,
  [1533] = 1533,
  [1534] = 1534,
  [1535] = 1535,
  [1536] = 1536,
  [1537] = 1537,
  [1538] = 1450,
  [1539] = 1362,
  [1540] = 1460,
  [1541] = 1541,
  [1542] = 1508,
  [1543] = 1543,
  [1544] = 1505,
  [1545] = 1545,
  [1546] = 1546,
  [1547] = 1547,
  [1548] = 1548,
  [1549] = 1541,
  [1550] = 1550,
  [1551] = 1537,
  [1552] = 1552,
  [1553] = 1553,
  [1554] = 1508,
  [1555] = 1460,
  [1556] = 1556,
  [1557] = 1552,
  [1558] = 1558,
  [1559] = 1553,
  [1560] = 1560,
  [1561] = 1529,
  [1562] = 1491,
  [1563] = 1511,
  [1564] = 1537,
  [1565] = 1518,
  [1566] = 1510,
  [1567] = 1450,
  [1568] = 1513,
  [1569] = 1400,
  [1570] = 1570,
  [1571] = 1571,
  [1572] = 1214,
  [1573] = 1541,
  [1574] = 1491,
  [1575] = 1460,
  [1576] = 1576,
  [1577] = 1577,
  [1578] = 1578,
  [1579] = 1579,
  [1580] = 1525,
  [1581] = 1533,
  [1582] = 1579,
  [1583] = 1583,
  [1584] = 1584,
  [1585] = 1546,
  [1586] = 1525,
  [1587] = 1491,
  [1588] = 1534,
  [1589] = 1571,
  [1590] = 1520,
  [1591] = 1591,
  [1592] = 1592,
  [1593] = 1593,
  [1594] = 1594,
  [1595] = 1595,
  [1596] = 1596,
  [1597] = 1597,
  [1598] = 1598,
  [1599] = 1599,
  [1600] = 1600,
  [1601] = 1601,
  [1602] = 1602,
  [1603] = 1602,
  [1604] = 763,
  [1605] = 1605,
  [1606] = 1605,
  [1607] = 763,
  [1608] = 1596,
  [1609] = 1609,
  [1610] = 1610,
  [1611] = 1576,
  [1612] = 1605,
  [1613] = 1502,
  [1614] = 763,
  [1615] = 1503,
  [1616] = 1616,
  [1617] = 1617,
  [1618] = 1578,
  [1619] = 1619,
  [1620] = 1620,
  [1621] = 1621,
  [1622] = 1622,
  [1623] = 1249,
  [1624] = 1624,
  [1625] = 1525,
  [1626] = 1605,
  [1627] = 1547,
  [1628] = 1628,
  [1629] = 1494,
  [1630] = 1529,
  [1631] = 1533,
  [1632] = 1534,
  [1633] = 1621,
  [1634] = 1634,
  [1635] = 1635,
  [1636] = 1636,
  [1637] = 1621,
  [1638] = 1533,
  [1639] = 1639,
  [1640] = 1640,
  [1641] = 1583,
  [1642] = 1576,
  [1643] = 1643,
  [1644] = 1605,
  [1645] = 783,
  [1646] = 1584,
  [1647] = 1508,
  [1648] = 1238,
  [1649] = 1649,
  [1650] = 1543,
  [1651] = 1529,
  [1652] = 1505,
  [1653] = 1592,
  [1654] = 783,
  [1655] = 1655,
  [1656] = 1597,
  [1657] = 1657,
  [1658] = 1505,
  [1659] = 1659,
  [1660] = 1660,
  [1661] = 1570,
  [1662] = 1662,
  [1663] = 1663,
  [1664] = 1591,
  [1665] = 1547,
  [1666] = 1502,
  [1667] = 1503,
  [1668] = 1576,
  [1669] = 1657,
  [1670] = 1583,
  [1671] = 1543,
  [1672] = 1584,
  [1673] = 1578,
  [1674] = 1674,
  [1675] = 1643,
  [1676] = 1541,
  [1677] = 1543,
  [1678] = 1534,
  [1679] = 1679,
  [1680] = 1680,
  [1681] = 1681,
  [1682] = 1605,
  [1683] = 1683,
  [1684] = 1662,
  [1685] = 1237,
  [1686] = 1230,
  [1687] = 1547,
  [1688] = 783,
  [1689] = 1605,
  [1690] = 1621,
  [1691] = 1583,
  [1692] = 1584,
  [1693] = 1693,
  [1694] = 1578,
  [1695] = 1695,
  [1696] = 1636,
  [1697] = 1649,
  [1698] = 1681,
  [1699] = 1593,
  [1700] = 1700,
  [1701] = 1619,
  [1702] = 1702,
  [1703] = 1622,
  [1704] = 1704,
  [1705] = 1705,
  [1706] = 1706,
  [1707] = 1659,
  [1708] = 1660,
  [1709] = 1609,
  [1710] = 1624,
  [1711] = 1635,
  [1712] = 1628,
  [1713] = 1713,
  [1714] = 1714,
  [1715] = 1601,
  [1716] = 1639,
  [1717] = 1717,
  [1718] = 1683,
  [1719] = 1705,
  [1720] = 1595,
  [1721] = 1600,
  [1722] = 1674,
  [1723] = 1680,
  [1724] = 1683,
  [1725] = 1620,
  [1726] = 1726,
  [1727] = 1695,
  [1728] = 1728,
  [1729] = 1729,
  [1730] = 1713,
  [1731] = 1714,
  [1732] = 1594,
  [1733] = 1695,
  [1734] = 1548,
  [1735] = 1735,
  [1736] = 1736,
  [1737] = 1598,
  [1738] = 1713,
  [1739] = 1617,
  [1740] = 1714,
  [1741] = 1741,
  [1742] = 1713,
  [1743] = 1714,
  [1744] = 1636,
  [1745] = 1695,
  [1746] = 1649,
  [1747] = 1681,
  [1748] = 1593,
  [1749] = 1749,
  [1750] = 1619,
  [1751] = 1680,
  [1752] = 1622,
  [1753] = 1753,
  [1754] = 1620,
  [1755] = 1702,
  [1756] = 1756,
  [1757] = 1757,
  [1758] = 1758,
  [1759] = 1659,
  [1760] = 1515,
  [1761] = 1660,
  [1762] = 1609,
  [1763] = 1624,
  [1764] = 1635,
  [1765] = 1765,
  [1766] = 1700,
  [1767] = 1628,
  [1768] = 1601,
  [1769] = 1639,
  [1770] = 1595,
  [1771] = 1600,
  [1772] = 1772,
  [1773] = 1773,
  [1774] = 1594,
  [1775] = 1596,
  [1776] = 1598,
  [1777] = 1674,
  [1778] = 1617,
  [1779] = 1680,
  [1780] = 1780,
  [1781] = 1683,
  [1782] = 1620,
  [1783] = 1594,
  [1784] = 1596,
  [1785] = 1598,
  [1786] = 1617,
  [1787] = 1636,
  [1788] = 1649,
  [1789] = 1681,
  [1790] = 1593,
  [1791] = 1619,
  [1792] = 1622,
  [1793] = 1756,
  [1794] = 1772,
  [1795] = 1659,
  [1796] = 1660,
  [1797] = 1609,
  [1798] = 1624,
  [1799] = 1635,
  [1800] = 1628,
  [1801] = 1601,
  [1802] = 1639,
  [1803] = 1595,
  [1804] = 1600,
  [1805] = 1674,
  [1806] = 1663,
  [1807] = 1726,
  [1808] = 1808,
  [1809] = 1809,
  [1810] = 1810,
  [1811] = 1811,
  [1812] = 1812,
  [1813] = 1813,
  [1814] = 1814,
  [1815] = 1815,
  [1816] = 1816,
  [1817] = 1817,
  [1818] = 1818,
  [1819] = 1819,
  [1820] = 1820,
  [1821] = 1821,
  [1822] = 1706,
  [1823] = 1823,
  [1824] = 1824,
  [1825] = 1812,
  [1826] = 1826,
  [1827] = 1827,
  [1828] = 1828,
  [1829] = 1829,
  [1830] = 1830,
  [1831] = 1831,
  [1832] = 1832,
  [1833] = 1826,
  [1834] = 1834,
  [1835] = 1830,
  [1836] = 1836,
  [1837] = 1827,
  [1838] = 1838,
  [1839] = 1839,
  [1840] = 1828,
  [1841] = 1841,
  [1842] = 1842,
  [1843] = 1843,
  [1844] = 1809,
  [1845] = 1820,
  [1846] = 1846,
  [1847] = 1530,
  [1848] = 1848,
  [1849] = 1536,
  [1850] = 1550,
  [1851] = 1811,
  [1852] = 1852,
  [1853] = 1818,
  [1854] = 1831,
  [1855] = 1809,
  [1856] = 1856,
  [1857] = 1843,
  [1858] = 1815,
  [1859] = 1859,
  [1860] = 1818,
  [1861] = 1819,
  [1862] = 1848,
  [1863] = 1821,
  [1864] = 1864,
  [1865] = 1865,
  [1866] = 1866,
  [1867] = 1812,
  [1868] = 1838,
  [1869] = 1826,
  [1870] = 1515,
  [1871] = 1827,
  [1872] = 1828,
  [1873] = 1831,
  [1874] = 1874,
  [1875] = 1816,
  [1876] = 1831,
  [1877] = 1838,
  [1878] = 1839,
  [1879] = 1841,
  [1880] = 1842,
  [1881] = 1843,
  [1882] = 1818,
  [1883] = 1820,
  [1884] = 1884,
  [1885] = 1848,
  [1886] = 1813,
  [1887] = 1887,
  [1888] = 1824,
  [1889] = 1889,
  [1890] = 1814,
  [1891] = 1214,
  [1892] = 1892,
  [1893] = 1832,
  [1894] = 1809,
  [1895] = 1526,
  [1896] = 1535,
  [1897] = 1548,
  [1898] = 1815,
  [1899] = 1499,
  [1900] = 1818,
  [1901] = 1819,
  [1902] = 1902,
  [1903] = 1821,
  [1904] = 1819,
  [1905] = 1819,
  [1906] = 1812,
  [1907] = 1826,
  [1908] = 1827,
  [1909] = 1828,
  [1910] = 1558,
  [1911] = 1911,
  [1912] = 1821,
  [1913] = 1913,
  [1914] = 1214,
  [1915] = 1706,
  [1916] = 1809,
  [1917] = 1917,
  [1918] = 1821,
  [1919] = 1919,
  [1920] = 1815,
  [1921] = 1818,
  [1922] = 1819,
  [1923] = 1923,
  [1924] = 1749,
  [1925] = 1821,
  [1926] = 1926,
  [1927] = 1812,
  [1928] = 1826,
  [1929] = 1827,
  [1930] = 1828,
  [1931] = 1812,
  [1932] = 1815,
  [1933] = 1933,
  [1934] = 1934,
  [1935] = 1859,
  [1936] = 1936,
  [1937] = 1838,
  [1938] = 1826,
  [1939] = 1919,
  [1940] = 1809,
  [1941] = 1815,
  [1942] = 1214,
  [1943] = 1818,
  [1944] = 1819,
  [1945] = 1821,
  [1946] = 1522,
  [1947] = 1926,
  [1948] = 1812,
  [1949] = 1816,
  [1950] = 1826,
  [1951] = 1827,
  [1952] = 1828,
  [1953] = 1953,
  [1954] = 1237,
  [1955] = 1955,
  [1956] = 1956,
  [1957] = 1841,
  [1958] = 1834,
  [1959] = 1821,
  [1960] = 1827,
  [1961] = 1828,
  [1962] = 1827,
  [1963] = 1841,
  [1964] = 1964,
  [1965] = 1828,
  [1966] = 1842,
  [1967] = 1706,
  [1968] = 1821,
  [1969] = 1827,
  [1970] = 1828,
  [1971] = 1971,
  [1972] = 1843,
  [1973] = 1973,
  [1974] = 1953,
  [1975] = 1842,
  [1976] = 1820,
  [1977] = 1964,
  [1978] = 1808,
  [1979] = 1979,
  [1980] = 1913,
  [1981] = 1865,
  [1982] = 1874,
  [1983] = 1983,
  [1984] = 1829,
  [1985] = 1846,
  [1986] = 1911,
  [1987] = 1809,
  [1988] = 1830,
  [1989] = 1887,
  [1990] = 1811,
  [1991] = 1224,
  [1992] = 1864,
  [1993] = 1993,
  [1994] = 1933,
  [1995] = 1936,
  [1996] = 1993,
  [1997] = 1813,
  [1998] = 1814,
  [1999] = 1848,
  [2000] = 1735,
  [2001] = 1726,
  [2002] = 1729,
  [2003] = 1973,
  [2004] = 1815,
  [2005] = 1735,
  [2006] = 1979,
  [2007] = 1726,
  [2008] = 1729,
  [2009] = 1983,
  [2010] = 2010,
  [2011] = 1964,
  [2012] = 1810,
  [2013] = 1808,
  [2014] = 2014,
  [2015] = 2015,
  [2016] = 2016,
  [2017] = 2017,
  [2018] = 2018,
  [2019] = 2019,
  [2020] = 2020,
  [2021] = 2021,
  [2022] = 2022,
  [2023] = 2023,
  [2024] = 2024,
  [2025] = 2021,
  [2026] = 2018,
  [2027] = 2027,
  [2028] = 2028,
  [2029] = 2029,
  [2030] = 2030,
  [2031] = 2031,
  [2032] = 485,
  [2033] = 2019,
  [2034] = 2021,
  [2035] = 2035,
  [2036] = 2036,
  [2037] = 2037,
  [2038] = 481,
  [2039] = 2036,
  [2040] = 2040,
  [2041] = 2041,
  [2042] = 2036,
  [2043] = 1249,
  [2044] = 2019,
  [2045] = 1237,
  [2046] = 2021,
  [2047] = 2047,
  [2048] = 2048,
  [2049] = 2049,
  [2050] = 490,
  [2051] = 2036,
  [2052] = 476,
  [2053] = 1238,
  [2054] = 2054,
  [2055] = 2055,
  [2056] = 2056,
  [2057] = 2056,
  [2058] = 2056,
  [2059] = 2023,
  [2060] = 2060,
  [2061] = 2061,
  [2062] = 2062,
  [2063] = 2056,
  [2064] = 2064,
  [2065] = 2065,
  [2066] = 2066,
  [2067] = 2067,
  [2068] = 2068,
  [2069] = 2024,
  [2070] = 2070,
  [2071] = 2055,
  [2072] = 2064,
  [2073] = 2073,
  [2074] = 2035,
  [2075] = 489,
  [2076] = 2076,
  [2077] = 2077,
  [2078] = 1230,
  [2079] = 2079,
  [2080] = 1230,
  [2081] = 2070,
  [2082] = 2082,
  [2083] = 2079,
  [2084] = 2084,
  [2085] = 2085,
  [2086] = 2086,
  [2087] = 2065,
  [2088] = 1892,
  [2089] = 2089,
  [2090] = 2077,
  [2091] = 2019,
  [2092] = 2092,
  [2093] = 2093,
  [2094] = 2085,
  [2095] = 2023,
  [2096] = 2029,
  [2097] = 2076,
  [2098] = 2024,
  [2099] = 2018,
  [2100] = 2100,
  [2101] = 1249,
  [2102] = 1238,
  [2103] = 2103,
  [2104] = 2104,
  [2105] = 2105,
  [2106] = 2106,
  [2107] = 2107,
  [2108] = 2108,
  [2109] = 2109,
  [2110] = 2110,
  [2111] = 2111,
  [2112] = 2112,
  [2113] = 2105,
  [2114] = 2110,
  [2115] = 2115,
  [2116] = 2116,
  [2117] = 2106,
  [2118] = 2118,
  [2119] = 2106,
  [2120] = 2120,
  [2121] = 2112,
  [2122] = 2122,
  [2123] = 2122,
  [2124] = 2124,
  [2125] = 2125,
  [2126] = 2107,
  [2127] = 2127,
  [2128] = 2128,
  [2129] = 2129,
  [2130] = 2130,
  [2131] = 2131,
  [2132] = 2125,
  [2133] = 2133,
  [2134] = 2134,
  [2135] = 2135,
  [2136] = 2125,
  [2137] = 2137,
  [2138] = 2107,
  [2139] = 2110,
  [2140] = 2106,
  [2141] = 2134,
  [2142] = 2122,
  [2143] = 2107,
  [2144] = 2134,
  [2145] = 2110,
  [2146] = 2134,
  [2147] = 2134,
  [2148] = 2111,
  [2149] = 2104,
  [2150] = 2103,
  [2151] = 2105,
  [2152] = 2104,
  [2153] = 2153,
  [2154] = 2105,
  [2155] = 2108,
  [2156] = 2103,
  [2157] = 2109,
  [2158] = 2133,
  [2159] = 2122,
  [2160] = 2134,
  [2161] = 2112,
  [2162] = 2111,
  [2163] = 2163,
  [2164] = 2112,
  [2165] = 2165,
  [2166] = 2109,
  [2167] = 2129,
  [2168] = 2124,
  [2169] = 2108,
  [2170] = 2109,
  [2171] = 2171,
  [2172] = 2172,
  [2173] = 2115,
  [2174] = 2174,
  [2175] = 2174,
  [2176] = 2176,
  [2177] = 2116,
  [2178] = 2178,
  [2179] = 2125,
  [2180] = 2127,
  [2181] = 2135,
  [2182] = 2120,
  [2183] = 2131,
  [2184] = 2184,
  [2185] = 2111,
  [2186] = 2134,
  [2187] = 2108,
  [2188] = 2128,
  [2189] = 2124,
  [2190] = 2124,
  [2191] = 2111,
  [2192] = 2133,
  [2193] = 2193,
  [2194] = 2194,
  [2195] = 2125,
  [2196] = 2103,
  [2197] = 2133,
  [2198] = 2137,
  [2199] = 2109,
  [2200] = 2174,
  [2201] = 2174,
  [2202] = 2193,
  [2203] = 2107,
  [2204] = 2163,
  [2205] = 2137,
  [2206] = 2110,
  [2207] = 2137,
  [2208] = 2163,
  [2209] = 2112,
  [2210] = 2104,
  [2211] = 2134,
  [2212] = 2212,
  [2213] = 2133,
  [2214] = 2108,
  [2215] = 2104,
  [2216] = 2216,
  [2217] = 2194,
  [2218] = 2105,
  [2219] = 2111,
  [2220] = 2104,
  [2221] = 2124,
  [2222] = 2112,
  [2223] = 2216,
  [2224] = 2125,
  [2225] = 2103,
  [2226] = 2105,
  [2227] = 2133,
  [2228] = 2137,
  [2229] = 2184,
  [2230] = 2109,
  [2231] = 2231,
  [2232] = 2107,
  [2233] = 2233,
  [2234] = 2110,
  [2235] = 2134,
  [2236] = 2236,
  [2237] = 2125,
  [2238] = 2137,
  [2239] = 2133,
  [2240] = 2104,
  [2241] = 2163,
  [2242] = 2105,
  [2243] = 2137,
  [2244] = 2244,
  [2245] = 2245,
  [2246] = 2108,
  [2247] = 2111,
  [2248] = 2112,
  [2249] = 2118,
  [2250] = 2176,
  [2251] = 2108,
  [2252] = 2233,
  [2253] = 2253,
  [2254] = 2109,
  [2255] = 2245,
  [2256] = 2236,
  [2257] = 2107,
  [2258] = 2110,
  [2259] = 2253,
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xba, 0xba}, {0xc0, 0xd6}, {0xd8, 0xf6},
  {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x370, 0x374}, {0x376, 0x377}, {0x37b, 0x37d},
  {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481}, {0x48a, 0x52f},
  {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x620, 0x64a}, {0x66e, 0x66f}, {0x671, 0x6d3},
  {0x6d5, 0x6d5}, {0x6e5, 0x6e6}, {0x6ee, 0x6ef}, {0x6fa, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x710}, {0x712, 0x72f}, {0x74d, 0x7a5},
  {0x7b1, 0x7b1}, {0x7ca, 0x7ea}, {0x7f4, 0x7f5}, {0x7fa, 0x7fa}, {0x800, 0x815}, {0x81a, 0x81a}, {0x824, 0x824}, {0x828, 0x828},
  {0x840, 0x858}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x8a0, 0x8c9}, {0x904, 0x939}, {0x93d, 0x93d}, {0x950, 0x950},
  {0x958, 0x961}, {0x971, 0x980}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9},
  {0x9bd, 0x9bd}, {0x9ce, 0x9ce}, {0x9dc, 0x9dd}, {0x9df, 0x9e1}, {0x9f0, 0x9f1}, {0x9fc, 0x9fc}, {0xa05, 0xa0a}, {0xa0f, 0xa10},
  {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa72, 0xa74},
  {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabd, 0xabd}, {0xad0, 0xad0},
  {0xae0, 0xae1}, {0xaf9, 0xaf9}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39},
  {0xb3d, 0xb3d}, {0xb5c, 0xb5d}, {0xb5f, 0xb61}, {0xb71, 0xb71}, {0xb83, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90}, {0xb92, 0xb95},
  {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbd0, 0xbd0}, {0xc05, 0xc0c},
  {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3d, 0xc3d}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc61}, {0xc80, 0xc80},
  {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbd, 0xcbd}, {0xcdd, 0xcde}, {0xce0, 0xce1},
  {0xcf1, 0xcf2}, {0xd04, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd3a}, {0xd3d, 0xd3d}, {0xd4e, 0xd4e}, {0xd54, 0xd56}, {0xd5f, 0xd61},
  {0xd7a, 0xd7f}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xe01, 0xe30}, {0xe32, 0xe32},
  {0xe40, 0xe46}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xeb0}, {0xeb2, 0xeb2},
  {0xebd, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf40, 0xf47}, {0xf49, 0xf6c}, {0xf88, 0xf8c},
  {0x1000, 0x102a}, {0x103f, 0x103f}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1061, 0x1061}, {0x1065, 0x1066}, {0x106e, 0x1070}, {0x1075, 0x1081},
  {0x108e, 0x108e}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256},
  {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0},
  {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd},
  {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1711}, {0x171f, 0x1731}, {0x1740, 0x1751},
  {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dc}, {0x1820, 0x1878}, {0x1880, 0x18a8}, {0x18aa, 0x18aa},
  {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x1a00, 0x1a16}, {0x1a20, 0x1a54},
  {0x1aa7, 0x1aa7}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, {0x1bba, 0x1be5}, {0x1c00, 0x1c23}, {0x1c4d, 0x1c4f},
  {0x1c5a, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf6}, {0x1cfa, 0x1cfa},
  {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b},
  {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3},
  {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2071, 0x2071}, {0x207f, 0x207f}, {0x2090, 0x209c}, {0x2102, 0x2102},
  {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139},
  {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25},
  {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6},
  {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x3005, 0x3007}, {0x3021, 0x3029}, {0x3031, 0x3035},
  {0x3038, 0x303c}, {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf},
  {0x31f0, 0x31ff}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa61f}, {0xa62a, 0xa62b}, {0xa640, 0xa66e},
  {0xa67f, 0xa69d}, {0xa6a0, 0xa6ef}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9},
  {0xa7f2, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, {0xa840, 0xa873}, {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, {0xa8fb, 0xa8fb},
  {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2}, {0xa9cf, 0xa9cf}, {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef},
  {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa76}, {0xaa7a, 0xaa7a}, {0xaa7e, 0xaaaf}, {0xaab1, 0xaab1},
  {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaac0, 0xaac0}, {0xaac2, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaea}, {0xaaf2, 0xaaf4}, {0xab01, 0xab06},
  {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabe2}, {0xac00, 0xd7a3},
  {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb1d}, {0xfb1f, 0xfb28},
  {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d},
  {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b},
  {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xff9d}, {0xffa0, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf},
  {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d},
  {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x10375}, {0x10380, 0x1039d},
  {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563},
  {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc},
  {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808},
  {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5},
  {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a00}, {0x10a10, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35},
  {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91},
  {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d23}, {0x10e80, 0x10ea9}, {0x10eb0, 0x10eb1}, {0x10f00, 0x10f1c}, {0x10f27, 0x10f27},
  {0x10f30, 0x10f45}, {0x10f70, 0x10f81}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11003, 0x11037}, {0x11071, 0x11072}, {0x11075, 0x11075}, {0x11083, 0x110af},
  {0x110d0, 0x110e8}, {0x11103, 0x11126}, {0x11144, 0x11144}, {0x11147, 0x11147}, {0x11150, 0x11172}, {0x11176, 0x11176}, {0x11183, 0x111b2}, {0x111c1, 0x111c4},
  {0x111da, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x1122b}, {0x1123f, 0x11240}, {0x11280, 0x11286}, {0x11288, 0x11288}, {0x1128a, 0x1128d},
  {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333},
  {0x11335, 0x11339}, {0x1133d, 0x1133d}, {0x11350, 0x11350}, {0x1135d, 0x11361}, {0x11400, 0x11434}, {0x11447, 0x1144a}, {0x1145f, 0x11461}, {0x11480, 0x114af},
  {0x114c4, 0x114c5}, {0x114c7, 0x114c7}, {0x11580, 0x115ae}, {0x115d8, 0x115db}, {0x11600, 0x1162f}, {0x11644, 0x11644}, {0x11680, 0x116aa}, {0x116b8, 0x116b8},
  {0x11700, 0x1171a}, {0x11740, 0x11746}, {0x11800, 0x1182b}, {0x118a0, 0x118df}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916},
  {0x11918, 0x1192f}, {0x1193f, 0x1193f}, {0x11941, 0x11941}, {0x119a0, 0x119a7}, {0x119aa, 0x119d0}, {0x119e1, 0x119e1}, {0x119e3, 0x119e3}, {0x11a00, 0x11a00},
  {0x11a0b, 0x11a32}, {0x11a3a, 0x11a3a}, {0x11a50, 0x11a50}, {0x11a5c, 0x11a89}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c2e},
  {0x11c40, 0x11c40}, {0x11c72, 0x11c8f}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d46, 0x11d46}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68},
  {0x11d6a, 0x11d89}, {0x11d98, 0x11d98}, {0x11ee0, 0x11ef2}, {0x11f02, 0x11f02}, {0x11f04, 0x11f10}, {0x11f12, 0x11f33}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399},
  {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, {0x13441, 0x13446}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e},
  {0x16a70, 0x16abe}, {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b40, 0x16b43}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a},
  {0x16f50, 0x16f50}, {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe3}, {0x17000, 0x187f7}, {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3},
  {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152}, {0x1b155, 0x1b155}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb},
  {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2},
  {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514},
  {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0},
  {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8},
  {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e030, 0x1e06d}, {0x1e100, 0x1e12c}, {0x1e137, 0x1e13d}, {0x1e14e, 0x1e14e},
  {0x1e290, 0x1e2ad}, {0x1e2c0, 0x1e2eb}, {0x1e4d0, 0x1e4eb}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4},
  {0x1e900, 0x1e943}, {0x1e94b, 0x1e94b}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32},
  {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f},
  {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62},
  {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b},
  {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x20000, 0x2a6df}, {0x2a700, 0x2b739}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0},
  {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'0', '9'}, {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xb7, 0xb7}, {0xba, 0xba},
  {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x300, 0x374},
  {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481},
  {0x483, 0x487}, {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x591, 0x5bd}, {0x5bf, 0x5bf}, {0x5c1, 0x5c2},
  {0x5c4, 0x5c5}, {0x5c7, 0x5c7}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x610, 0x61a}, {0x620, 0x669}, {0x66e, 0x6d3}, {0x6d5, 0x6dc},
  {0x6df, 0x6e8}, {0x6ea, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x74a}, {0x74d, 0x7b1}, {0x7c0, 0x7f5}, {0x7fa, 0x7fa}, {0x7fd, 0x7fd},
  {0x800, 0x82d}, {0x840, 0x85b}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x898, 0x8e1}, {0x8e3, 0x963}, {0x966, 0x96f},
  {0x971, 0x983}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9}, {0x9bc, 0x9c4},
  {0x9c7, 0x9c8}, {0x9cb, 0x9ce}, {0x9d7, 0x9d7}, {0x9dc, 0x9dd}, {0x9df, 0x9e3}, {0x9e6, 0x9f1}, {0x9fc, 0x9fc}, {0x9fe, 0x9fe},
  {0xa01, 0xa03}, {0xa05, 0xa0a}, {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39},
  {0xa3c, 0xa3c}, {0xa3e, 0xa42}, {0xa47, 0xa48}, {0xa4b, 0xa4d}, {0xa51, 0xa51}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa66, 0xa75},
  {0xa81, 0xa83}, {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabc, 0xac5},
  {0xac7, 0xac9}, {0xacb, 0xacd}, {0xad0, 0xad0}, {0xae0, 0xae3}, {0xae6, 0xaef}, {0xaf9, 0xaff}, {0xb01, 0xb03}, {0xb05, 0xb0c},
  {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39}, {0xb3c, 0xb44}, {0xb47, 0xb48}, {0xb4b, 0xb4d},
  {0xb55, 0xb57}, {0xb5c, 0xb5d}, {0xb5f, 0xb63}, {0xb66, 0xb6f}, {0xb71, 0xb71}, {0xb82, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90},
  {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbbe, 0xbc2},
  {0xbc6, 0xbc8}, {0xbca, 0xbcd}, {0xbd0, 0xbd0}, {0xbd7, 0xbd7}, {0xbe6, 0xbef}, {0xc00, 0xc0c}, {0xc0e, 0xc10}, {0xc12, 0xc28},
  {0xc2a, 0xc39}, {0xc3c, 0xc44}, {0xc46, 0xc48}, {0xc4a, 0xc4d}, {0xc55, 0xc56}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc63},
  {0xc66, 0xc6f}, {0xc80, 0xc83}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbc, 0xcc4},
  {0xcc6, 0xcc8}, {0xcca, 0xccd}, {0xcd5, 0xcd6}, {0xcdd, 0xcde}, {0xce0, 0xce3}, {0xce6, 0xcef}, {0xcf1, 0xcf3}, {0xd00, 0xd0c},
  {0xd0e, 0xd10}, {0xd12, 0xd44}, {0xd46, 0xd48}, {0xd4a, 0xd4e}, {0xd54, 0xd57}, {0xd5f, 0xd63}, {0xd66, 0xd6f}, {0xd7a, 0xd7f},
  {0xd81, 0xd83}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xdca, 0xdca}, {0xdcf, 0xdd4},
  {0xdd6, 0xdd6}, {0xdd8, 0xddf}, {0xde6, 0xdef}, {0xdf2, 0xdf3}, {0xe01, 0xe3a}, {0xe40, 0xe4e}, {0xe50, 0xe59}, {0xe81, 0xe82},
  {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xec8, 0xece},
  {0xed0, 0xed9}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf18, 0xf19}, {0xf20, 0xf29}, {0xf35, 0xf35}, {0xf37, 0xf37}, {0xf39, 0xf39},
  {0xf3e, 0xf47}, {0xf49, 0xf6c}, {0xf71, 0xf84}, {0xf86, 0xf97}, {0xf99, 0xfbc}, {0xfc6, 0xfc6}, {0x1000, 0x1049}, {0x1050, 0x109d},
  {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x1258, 0x1258},
  {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0}, {0x12c2, 0x12c5},
  {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x135f}, {0x1369, 0x1371}, {0x1380, 0x138f}, {0x13a0, 0x13f5},
  {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1715}, {0x171f, 0x1734},
  {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, {0x1780, 0x17d3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dd}, {0x17e0, 0x17e9},
  {0x180b, 0x180d}, {0x180f, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1920, 0x192b}, {0x1930, 0x193b},
  {0x1946, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x1a00, 0x1a1b}, {0x1a20, 0x1a5e}, {0x1a60, 0x1a7c},
  {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, {0x1aa7, 0x1aa7}, {0x1ab0, 0x1abd}, {0x1abf, 0x1ace}, {0x1b00, 0x1b4c}, {0x1b50, 0x1b59}, {0x1b6b, 0x1b73},
  {0x1b80, 0x1bf3}, {0x1c00, 0x1c37}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1cd0, 0x1cd2},
  {0x1cd4, 0x1cfa}, {0x1d00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b},
  {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3},
  {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x200c, 0x200d}, {0x203f, 0x2040}, {0x2054, 0x2054}, {0x2071, 0x2071},
  {0x207f, 0x207f}, {0x2090, 0x209c}, {0x20d0, 0x20dc}, {0x20e1, 0x20e1}, {0x20e5, 0x20f0}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113},
  {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149},
  {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67},
  {0x2d6f, 0x2d6f}, {0x2d7f, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce},
  {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, {0x3005, 0x3007}, {0x3021, 0x302f}, {0x3031, 0x3035}, {0x3038, 0x303c}, {0x3041, 0x3096},
  {0x3099, 0x309a}, {0x309d, 0x309f}, {0x30a1, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, {0x3400, 0x4dbf},
  {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa62b}, {0xa640, 0xa66f}, {0xa674, 0xa67d}, {0xa67f, 0xa6f1}, {0xa717, 0xa71f},
  {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f2, 0xa827}, {0xa82c, 0xa82c}, {0xa840, 0xa873},
  {0xa880, 0xa8c5}, {0xa8d0, 0xa8d9}, {0xa8e0, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa92d}, {0xa930, 0xa953}, {0xa960, 0xa97c}, {0xa980, 0xa9c0},
  {0xa9cf, 0xa9d9}, {0xa9e0, 0xa9fe}, {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa60, 0xaa76}, {0xaa7a, 0xaac2}, {0xaadb, 0xaadd},
  {0xaae0, 0xaaef}, {0xaaf2, 0xaaf6}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a},
  {0xab5c, 0xab69}, {0xab70, 0xabea}, {0xabec, 0xabed}, {0xabf0, 0xabf9}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d},
  {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41},
  {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe00, 0xfe0f},
  {0xfe20, 0xfe2f}, {0xfe33, 0xfe34}, {0xfe4d, 0xfe4f}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b},
  {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff10, 0xff19}, {0xff21, 0xff3a}, {0xff3f, 0xff3f}, {0xff41, 0xff5a}, {0xff65, 0xffbe}, {0xffc2, 0xffc7},
  {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d},
  {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x101fd, 0x101fd}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x102e0, 0x102e0}, {0x10300, 0x1031f},
  {0x1032d, 0x1034a}, {0x10350, 0x1037a}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104a0, 0x104a9},
  {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595},
  {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785},
  {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855},
  {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf},
  {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a38, 0x10a3a}, {0x10a3f, 0x10a3f}, {0x10a60, 0x10a7c},
  {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae6}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48},
  {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d27}, {0x10d30, 0x10d39}, {0x10e80, 0x10ea9}, {0x10eab, 0x10eac}, {0x10eb0, 0x10eb1}, {0x10efd, 0x10f1c},
  {0x10f27, 0x10f27}, {0x10f30, 0x10f50}, {0x10f70, 0x10f85}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11000, 0x11046}, {0x11066, 0x11075}, {0x1107f, 0x110ba},
  {0x110c2, 0x110c2}, {0x110d0, 0x110e8}, {0x110f0, 0x110f9}, {0x11100, 0x11134}, {0x11136, 0x1113f}, {0x11144, 0x11147}, {0x11150, 0x11173}, {0x11176, 0x11176},
  {0x11180, 0x111c4}, {0x111c9, 0x111cc}, {0x111ce, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x11237}, {0x1123e, 0x11241}, {0x11280, 0x11286},
  {0x11288, 0x11288}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112ea}, {0x112f0, 0x112f9}, {0x11300, 0x11303}, {0x11305, 0x1130c},
  {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133b, 0x11344}, {0x11347, 0x11348}, {0x1134b, 0x1134d},
  {0x11350, 0x11350}, {0x11357, 0x11357}, {0x1135d, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11400, 0x1144a}, {0x11450, 0x11459}, {0x1145e, 0x11461},
  {0x11480, 0x114c5}, {0x114c7, 0x114c7}, {0x114d0, 0x114d9}, {0x11580, 0x115b5}, {0x115b8, 0x115c0}, {0x115d8, 0x115dd}, {0x11600, 0x11640}, {0x11644, 0x11644},
  {0x11650, 0x11659}, {0x11680, 0x116b8}, {0x116c0, 0x116c9}, {0x11700, 0x1171a}, {0x1171d, 0x1172b}, {0x11730, 0x11739}, {0x11740, 0x11746}, {0x11800, 0x1183a},
  {0x118a0, 0x118e9}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x11935}, {0x11937, 0x11938}, {0x1193b, 0x11943},
  {0x11950, 0x11959}, {0x119a0, 0x119a7}, {0x119aa, 0x119d7}, {0x119da, 0x119e1}, {0x119e3, 0x119e4}, {0x11a00, 0x11a3e}, {0x11a47, 0x11a47}, {0x11a50, 0x11a99},
  {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, {0x11c38, 0x11c40}, {0x11c50, 0x11c59}, {0x11c72, 0x11c8f}, {0x11c92, 0x11ca7},
  {0x11ca9, 0x11cb6}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3a, 0x11d3a}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d47}, {0x11d50, 0x11d59},
  {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9}, {0x11ee0, 0x11ef6}, {0x11f00, 0x11f10},
  {0x11f12, 0x11f3a}, {0x11f3e, 0x11f42}, {0x11f50, 0x11f59}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0},
  {0x13000, 0x1342f}, {0x13440, 0x13455}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16a70, 0x16abe}, {0x16ac0, 0x16ac9},
  {0x16ad0, 0x16aed}, {0x16af0, 0x16af4}, {0x16b00, 0x16b36}, {0x16b40, 0x16b43}, {0x16b50, 0x16b59}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f},
  {0x16f00, 0x16f4a}, {0x16f4f, 0x16f87}, {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe4}, {0x16ff0, 0x16ff1}, {0x17000, 0x187f7}, {0x18800, 0x18cd5},
  {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152}, {0x1b155, 0x1b155},
  {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1bc9d, 0x1bc9e}, {0x1cf00, 0x1cf2d},
  {0x1cf30, 0x1cf46}, {0x1d165, 0x1d169}, {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244}, {0x1d400, 0x1d454},
  {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3},
  {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546},
  {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e},
  {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1d7ce, 0x1d7ff}, {0x1da00, 0x1da36}, {0x1da3b, 0x1da6c},
  {0x1da75, 0x1da75}, {0x1da84, 0x1da84}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e000, 0x1e006}, {0x1e008, 0x1e018},
  {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, {0x1e030, 0x1e06d}, {0x1e08f, 0x1e08f}, {0x1e100, 0x1e12c}, {0x1e130, 0x1e13d}, {0x1e140, 0x1e149},
  {0x1e14e, 0x1e14e}, {0x1e290, 0x1e2ae}, {0x1e2c0, 0x1e2f9}, {0x1e4d0, 0x1e4f9}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe},
  {0x1e800, 0x1e8c4}, {0x1e8d0, 0x1e8d6}, {0x1e900, 0x1e94b}, {0x1e950, 0x1e959}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24},
  {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49},
  {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d},
  {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62}, {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e},
  {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1fbf0, 0x1fbf9}, {0x20000, 0x2a6df}, {0x2a700, 0x2b739},
  {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af}, {0xe0100, 0xe01ef},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(49);
      if (lookahead == '\r') SKIP(47);
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '#') ADVANCE(142);
      if (lookahead == '%') ADVANCE(86);
      if (lookahead == '&') ADVANCE(90);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(63);
      if (lookahead == '+') ADVANCE(82);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(74);
      if (lookahead == '.') ADVANCE(55);
      if (lookahead == '/') ADVANCE(83);
      if (lookahead == '0') ADVANCE(130);
      if (lookahead == ':') ADVANCE(58);
      if (lookahead == ';') ADVANCE(50);
      if (lookahead == '<') ADVANCE(96);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(104);
      if (lookahead == '@') ADVANCE(71);
      if (lookahead == '[') ADVANCE(68);
      if (lookahead == '\\') ADVANCE(124);
      if (lookahead == ']') ADVANCE(69);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '~') ADVANCE(95);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(47);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(131);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(141);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(143);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(121);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(3);
      if (lookahead == '\r') ADVANCE(126);
      if (lookahead == '#') ADVANCE(127);
      if (lookahead == '\\') ADVANCE(125);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '}') ADVANCE(78);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) ADVANCE(126);
      if (lookahead != 0) ADVANCE(127);
      END_STATE();
    case 4:
      if (lookahead == '\r') SKIP(4);
      if (lookahead == '!') ADVANCE(15);
      if (lookahead == '#') ADVANCE(142);
      if (lookahead == '%') ADVANCE(86);
      if (lookahead == '&') ADVANCE(90);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(63);
      if (lookahead == '+') ADVANCE(82);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(73);
      if (lookahead == '.') ADVANCE(55);
      if (lookahead == '/') ADVANCE(83);
      if (lookahead == '0') ADVANCE(130);
      if (lookahead == ':') ADVANCE(58);
      if (lookahead == ';') ADVANCE(50);
      if (lookahead == '<') ADVANCE(96);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(104);
      if (lookahead == '@') ADVANCE(71);
      if (lookahead == '[') ADVANCE(68);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '~') ADVANCE(95);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(4);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(131);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(141);
      END_STATE();
    case 5:
      if (lookahead == '\r') SKIP(5);
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '#') ADVANCE(142);
      if (lookahead == '%') ADVANCE(85);
      if (lookahead == '&') ADVANCE(89);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(64);
      if (lookahead == '+') ADVANCE(81);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(72);
      if (lookahead == '.') ADVANCE(55);
      if (lookahead == '/') ADVANCE(84);
      if (lookahead == '0') ADVANCE(130);
      if (lookahead == ':') ADVANCE(57);
      if (lookahead == ';') ADVANCE(50);
      if (lookahead == '<') ADVANCE(97);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(105);
      if (lookahead == '@') ADVANCE(70);
      if (lookahead == '[') ADVANCE(68);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(69);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '~') ADVANCE(95);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(5);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(131);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(141);
      END_STATE();
    case 6:
      if (lookahead == '\r') SKIP(6);
      if (lookahead == '#') ADVANCE(142);
      if (lookahead == '%') ADVANCE(17);
      if (lookahead == '&') ADVANCE(18);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(65);
      if (lookahead == '+') ADVANCE(82);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(73);
      if (lookahead == '.') ADVANCE(11);
      if (lookahead == '/') ADVANCE(13);
      if (lookahead == '0') ADVANCE(130);
      if (lookahead == ':') ADVANCE(57);
      if (lookahead == ';') ADVANCE(50);
      if (lookahead == '<') ADVANCE(14);
      if (lookahead == '=') ADVANCE(79);
      if (lookahead == '>') ADVANCE(27);
      if (lookahead == '@') ADVANCE(19);
      if (lookahead == '[') ADVANCE(68);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '^') ADVANCE(20);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(21);
      if (lookahead == '~') ADVANCE(95);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(6);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(131);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(141);
      END_STATE();
    case 7:
      if (lookahead == '\r') SKIP(7);
      if (lookahead == '!') ADVANCE(15);
      if (lookahead == '#') ADVANCE(142);
      if (lookahead == '%') ADVANCE(86);
      if (lookahead == '&') ADVANCE(90);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == '*') ADVANCE(63);
      if (lookahead == '+') ADVANCE(82);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(73);
      if (lookahead == '.') ADVANCE(54);
      if (lookahead == '/') ADVANCE(83);
      if (lookahead == ':') ADVANCE(57);
      if (lookahead == ';') ADVANCE(50);
      if (lookahead == '<') ADVANCE(96);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(104);
      if (lookahead == '@') ADVANCE(71);
      if (lookahead == '[') ADVANCE(68);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '|') ADVANCE(76);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(7);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(141);
      END_STATE();
    case 8:
      if (lookahead == '\r') SKIP(8);
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '#') ADVANCE(142);
      if (lookahead == '%') ADVANCE(85);
      if (lookahead == '&') ADVANCE(89);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(64);
      if (lookahead == '+') ADVANCE(81);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(72);
      if (lookahead == '.') ADVANCE(54);
      if (lookahead == '/') ADVANCE(84);
      if (lookahead == ':') ADVANCE(58);
      if (lookahead == ';') ADVANCE(50);
      if (lookahead == '<') ADVANCE(97);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(105);
      if (lookahead == '@') ADVANCE(70);
      if (lookahead == '[') ADVANCE(68);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(69);
      if (lookahead == '^') ADVANCE(91);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '}') ADVANCE(78);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(8);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(141);
      END_STATE();
    case 9:
      if (lookahead == '\r') SKIP(9);
      if (lookahead == '#') ADVANCE(142);
      if (lookahead == '-') ADVANCE(26);
      if (lookahead == ':') ADVANCE(57);
      if (lookahead == '\\') ADVANCE(10);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(9);
      END_STATE();
    case 10:
      if (lookahead == '\r') ADVANCE(1);
      if ((!eof && lookahead == 00) ||
          lookahead == '\n') ADVANCE(143);
      END_STATE();
    case 11:
      if (lookahead == '.') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(137);
      END_STATE();
    case 12:
      if (lookahead == '.') ADVANCE(120);
      END_STATE();
    case 13:
      if (lookahead == '/') ADVANCE(23);
      if (lookahead == '=') ADVANCE(110);
      END_STATE();
    case 14:
      if (lookahead == '<') ADVANCE(24);
      END_STATE();
    case 15:
      if (lookahead == '=') ADVANCE(101);
      END_STATE();
    case 16:
      if (lookahead == '=') ADVANCE(101);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(128);
      END_STATE();
    case 17:
      if (lookahead == '=') ADVANCE(113);
      END_STATE();
    case 18:
      if (lookahead == '=') ADVANCE(117);
      END_STATE();
    case 19:
      if (lookahead == '=') ADVANCE(111);
      END_STATE();
    case 20:
      if (lookahead == '=') ADVANCE(118);
      END_STATE();
    case 21:
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 22:
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 23:
      if (lookahead == '=') ADVANCE(112);
      END_STATE();
    case 24:
      if (lookahead == '=') ADVANCE(116);
      END_STATE();
    case 25:
      if (lookahead == '=') ADVANCE(115);
      END_STATE();
    case 26:
      if (lookahead == '>') ADVANCE(61);
      END_STATE();
    case 27:
      if (lookahead == '>') ADVANCE(25);
      END_STATE();
    case 28:
      if (lookahead == '_') ADVANCE(34);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(133);
      END_STATE();
    case 29:
      if (lookahead == '_') ADVANCE(35);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(134);
      END_STATE();
    case 30:
      if (lookahead == '_') ADVANCE(38);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(135);
      END_STATE();
    case 31:
      if (lookahead == '{') ADVANCE(46);
      END_STATE();
    case 32:
      if (lookahead == '}') ADVANCE(121);
      if (lookahead != 0) ADVANCE(32);
      END_STATE();
    case 33:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(36);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(138);
      END_STATE();
    case 34:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(133);
      END_STATE();
    case 35:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(134);
      END_STATE();
    case 36:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(138);
      END_STATE();
    case 37:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(121);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(135);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(37);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(39);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(40);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(41);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(42);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 46:
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(32);
      END_STATE();
    case 47:
      if (eof) ADVANCE(49);
      if (lookahead == '\r') SKIP(47);
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '#') ADVANCE(142);
      if (lookahead == '%') ADVANCE(86);
      if (lookahead == '&') ADVANCE(90);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(63);
      if (lookahead == '+') ADVANCE(82);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(74);
      if (lookahead == '.') ADVANCE(55);
      if (lookahead == '/') ADVANCE(83);
      if (lookahead == '0') ADVANCE(130);
      if (lookahead == ':') ADVANCE(58);
      if (lookahead == ';') ADVANCE(50);
      if (lookahead == '<') ADVANCE(96);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(104);
      if (lookahead == '@') ADVANCE(71);
      if (lookahead == '[') ADVANCE(68);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(69);
      if (lookahead == '^') ADVANCE(92);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(76);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '~') ADVANCE(95);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(47);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(131);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(141);
      END_STATE();
    case 48:
      if (eof) ADVANCE(49);
      if (lookahead == '\r') SKIP(48);
      if (lookahead == '!') ADVANCE(16);
      if (lookahead == '#') ADVANCE(142);
      if (lookahead == '(') ADVANCE(59);
      if (lookahead == ')') ADVANCE(60);
      if (lookahead == '*') ADVANCE(62);
      if (lookahead == '+') ADVANCE(81);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(72);
      if (lookahead == '.') ADVANCE(55);
      if (lookahead == '0') ADVANCE(130);
      if (lookahead == ':') ADVANCE(57);
      if (lookahead == ';') ADVANCE(50);
      if (lookahead == '<') ADVANCE(98);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(103);
      if (lookahead == '@') ADVANCE(70);
      if (lookahead == '[') ADVANCE(68);
      if (lookahead == '\\') ADVANCE(10);
      if (lookahead == ']') ADVANCE(69);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(75);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '~') ADVANCE(95);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(48);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(131);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(141);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(115);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(137);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(56);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(67);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(66);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(22);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '=') ADVANCE(111);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(108);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(108);
      if (lookahead == '>') ADVANCE(61);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(100);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(107);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(88);
      if (lookahead == '=') ADVANCE(110);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(87);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(113);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead == '=') ADVANCE(112);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '=') ADVANCE(117);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(118);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(116);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(94);
      if (lookahead == '=') ADVANCE(99);
      if (lookahead == '>') ADVANCE(106);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(93);
      if (lookahead == '=') ADVANCE(99);
      if (lookahead == '>') ADVANCE(106);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(99);
      if (lookahead == '>') ADVANCE(106);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(102);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(102);
      if (lookahead == '>') ADVANCE(53);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(102);
      if (lookahead == '>') ADVANCE(52);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_AT_EQ);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH_EQ);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_ellipsis);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(121);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(122);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      ADVANCE_MAP(
        0, 143,
        '\n', 121,
        '\r', 2,
        'N', 31,
        'U', 45,
        'u', 41,
        'x', 39,
        '"', 121,
        '\'', 121,
        '\\', 121,
        'a', 121,
        'b', 121,
        'f', 121,
        'n', 121,
        'r', 121,
        't', 121,
        'v', 121,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(123);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if ((!eof && lookahead == 00)) ADVANCE(127);
      if (lookahead == '\r') ADVANCE(127);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(127);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      ADVANCE_MAP(
        '\r', 126,
        '#', 127,
        '\\', 125,
        '\t', 126,
        0x0b, 126,
        '\f', 126,
        ' ', 126,
        0x200b, 126,
        0x2060, 126,
        0xfeff, 126,
      );
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(127);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(aux_sym_format_specifier_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(127);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_type_conversion);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_integer);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_integer);
      ADVANCE_MAP(
        '.', 139,
        '_', 132,
        'B', 28,
        'b', 28,
        'E', 33,
        'e', 33,
        'O', 29,
        'o', 29,
        'X', 30,
        'x', 30,
        'J', 129,
        'L', 129,
        'j', 129,
        'l', 129,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(131);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_integer);
      ADVANCE_MAP(
        '.', 139,
        '_', 132,
        'E', 33,
        'e', 33,
        'J', 129,
        'L', 129,
        'j', 129,
        'l', 129,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(131);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(139);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(33);
      if (lookahead == 'J' ||
          lookahead == 'L' ||
          lookahead == 'j' ||
          lookahead == 'l') ADVANCE(129);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(131);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(34);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(129);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(133);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(35);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(129);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(134);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(38);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(129);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(135);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_float);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(139);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(33);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(136);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(137);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(140);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(136);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(138);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(33);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(136);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(137);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'J' ||
          lookahead == 'j') ADVANCE(136);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(138);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_identifier);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(141);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(142);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_line_continuation);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\r') SKIP(0);
      if (lookahead == 'F') ADVANCE(1);
      if (lookahead == 'N') ADVANCE(2);
      if (lookahead == 'T') ADVANCE(3);
      if (lookahead == '_') ADVANCE(4);
      if (lookahead == 'a') ADVANCE(5);
      if (lookahead == 'b') ADVANCE(6);
      if (lookahead == 'c') ADVANCE(7);
      if (lookahead == 'd') ADVANCE(8);
      if (lookahead == 'e') ADVANCE(9);
      if (lookahead == 'f') ADVANCE(10);
      if (lookahead == 'i') ADVANCE(11);
      if (lookahead == 'l') ADVANCE(12);
      if (lookahead == 'm') ADVANCE(13);
      if (lookahead == 'n') ADVANCE(14);
      if (lookahead == 'o') ADVANCE(15);
      if (lookahead == 'p') ADVANCE(16);
      if (lookahead == 'r') ADVANCE(17);
      if (lookahead == 's') ADVANCE(18);
      if (lookahead == 't') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'a') ADVANCE(21);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(22);
      END_STATE();
    case 3:
      if (lookahead == 'r') ADVANCE(23);
      END_STATE();
    case 4:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 5:
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead == 's') ADVANCE(25);
      if (lookahead == 'w') ADVANCE(26);
      END_STATE();
    case 6:
      if (lookahead == 'r') ADVANCE(27);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(28);
      if (lookahead == 'o') ADVANCE(29);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(30);
      END_STATE();
    case 9:
      if (lookahead == 'l') ADVANCE(31);
      if (lookahead == 'q') ADVANCE(32);
      if (lookahead == 'x') ADVANCE(33);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(34);
      if (lookahead == 'o') ADVANCE(35);
      END_STATE();
    case 11:
      if (lookahead == 'f') ADVANCE(36);
      if (lookahead == 'n') ADVANCE(37);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(38);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(39);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(40);
      if (lookahead == 'o') ADVANCE(41);
      END_STATE();
    case 15:
      if (lookahead == 'r') ADVANCE(42);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(43);
      if (lookahead == 'r') ADVANCE(44);
      END_STATE();
    case 17:
      if (lookahead == 'e') ADVANCE(45);
      END_STATE();
    case 18:
      if (lookahead == 't') ADVANCE(46);
      END_STATE();
    case 19:
      if (lookahead == 'y') ADVANCE(47);
      END_STATE();
    case 20:
      if (lookahead == 'h') ADVANCE(48);
      if (lookahead == 'i') ADVANCE(49);
      END_STATE();
    case 21:
      if (lookahead == 'l') ADVANCE(50);
      END_STATE();
    case 22:
      if (lookahead == 'n') ADVANCE(51);
      END_STATE();
    case 23:
      if (lookahead == 'u') ADVANCE(52);
      END_STATE();
    case 24:
      if (lookahead == 'd') ADVANCE(53);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(54);
      if (lookahead == 'y') ADVANCE(55);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(56);
      END_STATE();
    case 27:
      if (lookahead == 'e') ADVANCE(57);
      END_STATE();
    case 28:
      if (lookahead == 's') ADVANCE(58);
      END_STATE();
    case 29:
      if (lookahead == 'n') ADVANCE(59);
      END_STATE();
    case 30:
      if (lookahead == 'f') ADVANCE(60);
      if (lookahead == 'l') ADVANCE(61);
      END_STATE();
    case 31:
      if (lookahead == 'i') ADVANCE(62);
      if (lookahead == 's') ADVANCE(63);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_eq);
      END_STATE();
    case 33:
      if (lookahead == 'c') ADVANCE(64);
      if (lookahead == 'e') ADVANCE(65);
      END_STATE();
    case 34:
      if (lookahead == 'i') ADVANCE(66);
      END_STATE();
    case 35:
      if (lookahead == 'r') ADVANCE(67);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 38:
      if (lookahead == 'm') ADVANCE(68);
      END_STATE();
    case 39:
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_ne);
      END_STATE();
    case 41:
      if (lookahead == 't') ADVANCE(70);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 43:
      if (lookahead == 's') ADVANCE(71);
      END_STATE();
    case 44:
      if (lookahead == 'i') ADVANCE(72);
      END_STATE();
    case 45:
      if (lookahead == 't') ADVANCE(73);
      END_STATE();
    case 46:
      if (lookahead == 'r') ADVANCE(74);
      END_STATE();
    case 47:
      if (lookahead == 'p') ADVANCE(75);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(76);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(77);
      END_STATE();
    case 50:
      if (lookahead == 's') ADVANCE(78);
      END_STATE();
    case 51:
      if (lookahead == 'e') ADVANCE(79);
      END_STATE();
    case 52:
      if (lookahead == 'e') ADVANCE(80);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 54:
      if (lookahead == 'e') ADVANCE(81);
      END_STATE();
    case 55:
      if (lookahead == 'n') ADVANCE(82);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(83);
      END_STATE();
    case 57:
      if (lookahead == 'a') ADVANCE(84);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(85);
      END_STATE();
    case 59:
      if (lookahead == 't') ADVANCE(86);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_def);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_del);
      END_STATE();
    case 62:
      if (lookahead == 'f') ADVANCE(87);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(88);
      END_STATE();
    case 64:
      if (lookahead == 'e') ADVANCE(89);
      END_STATE();
    case 65:
      if (lookahead == 'c') ADVANCE(90);
      END_STATE();
    case 66:
      if (lookahead == 'l') ADVANCE(91);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 68:
      if (lookahead == 'b') ADVANCE(92);
      END_STATE();
    case 69:
      if (lookahead == 'c') ADVANCE(93);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 71:
      if (lookahead == 's') ADVANCE(94);
      END_STATE();
    case 72:
      if (lookahead == 'n') ADVANCE(95);
      END_STATE();
    case 73:
      if (lookahead == 'u') ADVANCE(96);
      END_STATE();
    case 74:
      if (lookahead == 'u') ADVANCE(97);
      END_STATE();
    case 75:
      if (lookahead == 'e') ADVANCE(98);
      END_STATE();
    case 76:
      if (lookahead == 'l') ADVANCE(99);
      END_STATE();
    case 77:
      if (lookahead == 'h') ADVANCE(100);
      END_STATE();
    case 78:
      if (lookahead == 'e') ADVANCE(101);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_none);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 81:
      if (lookahead == 'r') ADVANCE(102);
      END_STATE();
    case 82:
      if (lookahead == 'c') ADVANCE(103);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(104);
      END_STATE();
    case 84:
      if (lookahead == 'k') ADVANCE(105);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 86:
      if (lookahead == 'a') ADVANCE(106);
      if (lookahead == 'i') ADVANCE(107);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 89:
      if (lookahead == 'p') ADVANCE(108);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_exec);
      END_STATE();
    case 91:
      if (lookahead == 's') ADVANCE(109);
      END_STATE();
    case 92:
      if (lookahead == 'd') ADVANCE(110);
      END_STATE();
    case 93:
      if (lookahead == 'h') ADVANCE(111);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_pass);
      END_STATE();
    case 95:
      if (lookahead == 't') ADVANCE(112);
      END_STATE();
    case 96:
      if (lookahead == 'r') ADVANCE(113);
      END_STATE();
    case 97:
      if (lookahead == 'c') ADVANCE(114);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 99:
      if (lookahead == 'e') ADVANCE(115);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 102:
      if (lookahead == 't') ADVANCE(116);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 106:
      if (lookahead == 'i') ADVANCE(117);
      END_STATE();
    case 107:
      if (lookahead == 'n') ADVANCE(118);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(119);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_fails);
      END_STATE();
    case 110:
      if (lookahead == 'a') ADVANCE(120);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_print);
      END_STATE();
    case 113:
      if (lookahead == 'n') ADVANCE(121);
      END_STATE();
    case 114:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_assert);
      if (lookahead == '_') ADVANCE(123);
      END_STATE();
    case 117:
      if (lookahead == 'n') ADVANCE(124);
      END_STATE();
    case 118:
      if (lookahead == 'u') ADVANCE(125);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_except);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_lambda);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_assert_);
      if (lookahead == 'c') ADVANCE(126);
      if (lookahead == 'e') ADVANCE(127);
      if (lookahead == 'f') ADVANCE(128);
      if (lookahead == 'n') ADVANCE(129);
      END_STATE();
    case 124:
      if (lookahead == 's') ADVANCE(130);
      END_STATE();
    case 125:
      if (lookahead == 'e') ADVANCE(131);
      END_STATE();
    case 126:
      if (lookahead == 'o') ADVANCE(132);
      END_STATE();
    case 127:
      if (lookahead == 'q') ADVANCE(133);
      END_STATE();
    case 128:
      if (lookahead == 'a') ADVANCE(134);
      END_STATE();
    case 129:
      if (lookahead == 'e') ADVANCE(135);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_contains);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 132:
      if (lookahead == 'n') ADVANCE(136);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_assert_eq);
      END_STATE();
    case 134:
      if (lookahead == 'i') ADVANCE(137);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_assert_ne);
      END_STATE();
    case 136:
      if (lookahead == 't') ADVANCE(138);
      END_STATE();
    case 137:
      if (lookahead == 'l') ADVANCE(139);
      END_STATE();
    case 138:
      if (lookahead == 'a') ADVANCE(140);
      END_STATE();
    case 139:
      if (lookahead == 's') ADVANCE(141);
      END_STATE();
    case 140:
      if (lookahead == 'i') ADVANCE(142);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_assert_fails);
      END_STATE();
    case 142:
      if (lookahead == 'n') ADVANCE(143);
      END_STATE();
    case 143:
      if (lookahead == 's') ADVANCE(144);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_assert_contains);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 48, .external_lex_state = 2},
  [2] = {.lex_state = 48, .external_lex_state = 3},
  [3] = {.lex_state = 48, .external_lex_state = 3},
  [4] = {.lex_state = 48, .external_lex_state = 3},
  [5] = {.lex_state = 48, .external_lex_state = 3},
  [6] = {.lex_state = 48, .external_lex_state = 3},
  [7] = {.lex_state = 48, .external_lex_state = 3},
  [8] = {.lex_state = 48, .external_lex_state = 3},
  [9] = {.lex_state = 48, .external_lex_state = 3},
  [10] = {.lex_state = 48, .external_lex_state = 3},
  [11] = {.lex_state = 48, .external_lex_state = 3},
  [12] = {.lex_state = 48, .external_lex_state = 3},
  [13] = {.lex_state = 48, .external_lex_state = 3},
  [14] = {.lex_state = 48, .external_lex_state = 3},
  [15] = {.lex_state = 48, .external_lex_state = 3},
  [16] = {.lex_state = 48, .external_lex_state = 3},
  [17] = {.lex_state = 48, .external_lex_state = 3},
  [18] = {.lex_state = 48, .external_lex_state = 3},
  [19] = {.lex_state = 48, .external_lex_state = 3},
  [20] = {.lex_state = 48, .external_lex_state = 3},
  [21] = {.lex_state = 48, .external_lex_state = 3},
  [22] = {.lex_state = 48, .external_lex_state = 3},
  [23] = {.lex_state = 48, .external_lex_state = 3},
  [24] = {.lex_state = 48, .external_lex_state = 3},
  [25] = {.lex_state = 48, .external_lex_state = 3},
  [26] = {.lex_state = 48, .external_lex_state = 3},
  [27] = {.lex_state = 48, .external_lex_state = 3},
  [28] = {.lex_state = 48, .external_lex_state = 3},
  [29] = {.lex_state = 48, .external_lex_state = 3},
  [30] = {.lex_state = 48, .external_lex_state = 3},
  [31] = {.lex_state = 48, .external_lex_state = 3},
  [32] = {.lex_state = 48, .external_lex_state = 3},
  [33] = {.lex_state = 48, .external_lex_state = 3},
  [34] = {.lex_state = 48, .external_lex_state = 3},
  [35] = {.lex_state = 48, .external_lex_state = 3},
  [36] = {.lex_state = 48, .external_lex_state = 3},
  [37] = {.lex_state = 48, .external_lex_state = 3},
  [38] = {.lex_state = 48, .external_lex_state = 3},
  [39] = {.lex_state = 48, .external_lex_state = 3},
  [40] = {.lex_state = 48, .external_lex_state = 2},
  [41] = {.lex_state = 48, .external_lex_state = 3},
  [42] = {.lex_state = 48, .external_lex_state = 3},
  [43] = {.lex_state = 48, .external_lex_state = 2},
  [44] = {.lex_state = 48, .external_lex_state = 3},
  [45] = {.lex_state = 48, .external_lex_state = 3},
  [46] = {.lex_state = 4, .external_lex_state = 4},
  [47] = {.lex_state = 4, .external_lex_state = 4},
  [48] = {.lex_state = 4, .external_lex_state = 4},
  [49] = {.lex_state = 4, .external_lex_state = 4},
  [50] = {.lex_state = 5, .external_lex_state = 5},
  [51] = {.lex_state = 5, .external_lex_state = 5},
  [52] = {.lex_state = 5, .external_lex_state = 5},
  [53] = {.lex_state = 5, .external_lex_state = 5},
  [54] = {.lex_state = 5, .external_lex_state = 5},
  [55] = {.lex_state = 5, .external_lex_state = 5},
  [56] = {.lex_state = 5, .external_lex_state = 5},
  [57] = {.lex_state = 5, .external_lex_state = 5},
  [58] = {.lex_state = 48, .external_lex_state = 5},
  [59] = {.lex_state = 48, .external_lex_state = 5},
  [60] = {.lex_state = 48, .external_lex_state = 5},
  [61] = {.lex_state = 48, .external_lex_state = 5},
  [62] = {.lex_state = 48, .external_lex_state = 5},
  [63] = {.lex_state = 48, .external_lex_state = 5},
  [64] = {.lex_state = 48, .external_lex_state = 5},
  [65] = {.lex_state = 48, .external_lex_state = 5},
  [66] = {.lex_state = 48, .external_lex_state = 5},
  [67] = {.lex_state = 48, .external_lex_state = 5},
  [68] = {.lex_state = 48, .external_lex_state = 5},
  [69] = {.lex_state = 48, .external_lex_state = 5},
  [70] = {.lex_state = 48, .external_lex_state = 5},
  [71] = {.lex_state = 48, .external_lex_state = 5},
  [72] = {.lex_state = 48, .external_lex_state = 5},
  [73] = {.lex_state = 48, .external_lex_state = 5},
  [74] = {.lex_state = 48, .external_lex_state = 5},
  [75] = {.lex_state = 48, .external_lex_state = 5},
  [76] = {.lex_state = 48, .external_lex_state = 5},
  [77] = {.lex_state = 48, .external_lex_state = 5},
  [78] = {.lex_state = 48, .external_lex_state = 5},
  [79] = {.lex_state = 48, .external_lex_state = 5},
  [80] = {.lex_state = 48, .external_lex_state = 5},
  [81] = {.lex_state = 48, .external_lex_state = 5},
  [82] = {.lex_state = 48, .external_lex_state = 5},
  [83] = {.lex_state = 48, .external_lex_state = 5},
  [84] = {.lex_state = 48, .external_lex_state = 5},
  [85] = {.lex_state = 48, .external_lex_state = 5},
  [86] = {.lex_state = 48, .external_lex_state = 5},
  [87] = {.lex_state = 48, .external_lex_state = 5},
  [88] = {.lex_state = 48, .external_lex_state = 4},
  [89] = {.lex_state = 48, .external_lex_state = 4},
  [90] = {.lex_state = 48, .external_lex_state = 4},
  [91] = {.lex_state = 48, .external_lex_state = 4},
  [92] = {.lex_state = 48, .external_lex_state = 4},
  [93] = {.lex_state = 48, .external_lex_state = 4},
  [94] = {.lex_state = 48, .external_lex_state = 2},
  [95] = {.lex_state = 6, .external_lex_state = 4},
  [96] = {.lex_state = 6, .external_lex_state = 4},
  [97] = {.lex_state = 48, .external_lex_state = 6},
  [98] = {.lex_state = 48, .external_lex_state = 7},
  [99] = {.lex_state = 5, .external_lex_state = 8},
  [100] = {.lex_state = 48, .external_lex_state = 2},
  [101] = {.lex_state = 48, .external_lex_state = 6},
  [102] = {.lex_state = 48, .external_lex_state = 7},
  [103] = {.lex_state = 5, .external_lex_state = 8},
  [104] = {.lex_state = 48, .external_lex_state = 6},
  [105] = {.lex_state = 5, .external_lex_state = 7},
  [106] = {.lex_state = 5, .external_lex_state = 7},
  [107] = {.lex_state = 48, .external_lex_state = 2},
  [108] = {.lex_state = 5, .external_lex_state = 7},
  [109] = {.lex_state = 48, .external_lex_state = 2},
  [110] = {.lex_state = 48, .external_lex_state = 6},
  [111] = {.lex_state = 48, .external_lex_state = 7},
  [112] = {.lex_state = 5, .external_lex_state = 8},
  [113] = {.lex_state = 48, .external_lex_state = 6},
  [114] = {.lex_state = 5, .external_lex_state = 7},
  [115] = {.lex_state = 5, .external_lex_state = 7},
  [116] = {.lex_state = 48, .external_lex_state = 6},
  [117] = {.lex_state = 48, .external_lex_state = 7},
  [118] = {.lex_state = 5, .external_lex_state = 8},
  [119] = {.lex_state = 5, .external_lex_state = 7},
  [120] = {.lex_state = 5, .external_lex_state = 7},
  [121] = {.lex_state = 48, .external_lex_state = 6},
  [122] = {.lex_state = 48, .external_lex_state = 7},
  [123] = {.lex_state = 5, .external_lex_state = 8},
  [124] = {.lex_state = 48, .external_lex_state = 6},
  [125] = {.lex_state = 48, .external_lex_state = 7},
  [126] = {.lex_state = 5, .external_lex_state = 8},
  [127] = {.lex_state = 48, .external_lex_state = 6},
  [128] = {.lex_state = 48, .external_lex_state = 7},
  [129] = {.lex_state = 5, .external_lex_state = 8},
  [130] = {.lex_state = 48, .external_lex_state = 6},
  [131] = {.lex_state = 48, .external_lex_state = 7},
  [132] = {.lex_state = 48, .external_lex_state = 6},
  [133] = {.lex_state = 48, .external_lex_state = 7},
  [134] = {.lex_state = 48, .external_lex_state = 7},
  [135] = {.lex_state = 48, .external_lex_state = 7},
  [136] = {.lex_state = 5, .external_lex_state = 7},
  [137] = {.lex_state = 5, .external_lex_state = 6},
  [138] = {.lex_state = 5, .external_lex_state = 2},
  [139] = {.lex_state = 5, .external_lex_state = 2},
  [140] = {.lex_state = 5, .external_lex_state = 2},
  [141] = {.lex_state = 5, .external_lex_state = 2},
  [142] = {.lex_state = 6, .external_lex_state = 2},
  [143] = {.lex_state = 5, .external_lex_state = 2},
  [144] = {.lex_state = 5, .external_lex_state = 6},
  [145] = {.lex_state = 5, .external_lex_state = 2},
  [146] = {.lex_state = 5, .external_lex_state = 2},
  [147] = {.lex_state = 6, .external_lex_state = 2},
  [148] = {.lex_state = 5, .external_lex_state = 2},
  [149] = {.lex_state = 5, .external_lex_state = 2},
  [150] = {.lex_state = 5, .external_lex_state = 6},
  [151] = {.lex_state = 5, .external_lex_state = 2},
  [152] = {.lex_state = 5, .external_lex_state = 6},
  [153] = {.lex_state = 5, .external_lex_state = 2},
  [154] = {.lex_state = 5, .external_lex_state = 2},
  [155] = {.lex_state = 5, .external_lex_state = 2},
  [156] = {.lex_state = 5, .external_lex_state = 2},
  [157] = {.lex_state = 5, .external_lex_state = 2},
  [158] = {.lex_state = 5, .external_lex_state = 2},
  [159] = {.lex_state = 5, .external_lex_state = 6},
  [160] = {.lex_state = 5, .external_lex_state = 6},
  [161] = {.lex_state = 5, .external_lex_state = 6},
  [162] = {.lex_state = 5, .external_lex_state = 2},
  [163] = {.lex_state = 5, .external_lex_state = 2},
  [164] = {.lex_state = 5, .external_lex_state = 2},
  [165] = {.lex_state = 5, .external_lex_state = 2},
  [166] = {.lex_state = 5, .external_lex_state = 2},
  [167] = {.lex_state = 5, .external_lex_state = 2},
  [168] = {.lex_state = 5, .external_lex_state = 2},
  [169] = {.lex_state = 5, .external_lex_state = 2},
  [170] = {.lex_state = 5, .external_lex_state = 6},
  [171] = {.lex_state = 5, .external_lex_state = 6},
  [172] = {.lex_state = 5, .external_lex_state = 6},
  [173] = {.lex_state = 5, .external_lex_state = 6},
  [174] = {.lex_state = 5, .external_lex_state = 6},
  [175] = {.lex_state = 5, .external_lex_state = 6},
  [176] = {.lex_state = 5, .external_lex_state = 6},
  [177] = {.lex_state = 5, .external_lex_state = 6},
  [178] = {.lex_state = 5, .external_lex_state = 6},
  [179] = {.lex_state = 5, .external_lex_state = 6},
  [180] = {.lex_state = 5, .external_lex_state = 6},
  [181] = {.lex_state = 5, .external_lex_state = 6},
  [182] = {.lex_state = 5, .external_lex_state = 6},
  [183] = {.lex_state = 5, .external_lex_state = 6},
  [184] = {.lex_state = 5, .external_lex_state = 6},
  [185] = {.lex_state = 5, .external_lex_state = 6},
  [186] = {.lex_state = 5, .external_lex_state = 6},
  [187] = {.lex_state = 5, .external_lex_state = 6},
  [188] = {.lex_state = 5, .external_lex_state = 6},
  [189] = {.lex_state = 5, .external_lex_state = 6},
  [190] = {.lex_state = 5, .external_lex_state = 6},
  [191] = {.lex_state = 5, .external_lex_state = 6},
  [192] = {.lex_state = 5, .external_lex_state = 6},
  [193] = {.lex_state = 5, .external_lex_state = 6},
  [194] = {.lex_state = 48, .external_lex_state = 2},
  [195] = {.lex_state = 48, .external_lex_state = 2},
  [196] = {.lex_state = 5, .external_lex_state = 6},
  [197] = {.lex_state = 5, .external_lex_state = 6},
  [198] = {.lex_state = 5, .external_lex_state = 6},
  [199] = {.lex_state = 5, .external_lex_state = 6},
  [200] = {.lex_state = 48, .external_lex_state = 8},
  [201] = {.lex_state = 48, .external_lex_state = 7},
  [202] = {.lex_state = 48, .external_lex_state = 7},
  [203] = {.lex_state = 48, .external_lex_state = 8},
  [204] = {.lex_state = 48, .external_lex_state = 7},
  [205] = {.lex_state = 48, .external_lex_state = 7},
  [206] = {.lex_state = 5, .external_lex_state = 2},
  [207] = {.lex_state = 48, .external_lex_state = 8},
  [208] = {.lex_state = 48, .external_lex_state = 8},
  [209] = {.lex_state = 48, .external_lex_state = 6},
  [210] = {.lex_state = 48, .external_lex_state = 6},
  [211] = {.lex_state = 48, .external_lex_state = 7},
  [212] = {.lex_state = 5, .external_lex_state = 8},
  [213] = {.lex_state = 48, .external_lex_state = 6},
  [214] = {.lex_state = 48, .external_lex_state = 6},
  [215] = {.lex_state = 48, .external_lex_state = 6},
  [216] = {.lex_state = 48, .external_lex_state = 7},
  [217] = {.lex_state = 48, .external_lex_state = 6},
  [218] = {.lex_state = 48, .external_lex_state = 8},
  [219] = {.lex_state = 5, .external_lex_state = 8},
  [220] = {.lex_state = 5, .external_lex_state = 8},
  [221] = {.lex_state = 48, .external_lex_state = 6},
  [222] = {.lex_state = 48, .external_lex_state = 7},
  [223] = {.lex_state = 48, .external_lex_state = 6},
  [224] = {.lex_state = 5, .external_lex_state = 8},
  [225] = {.lex_state = 48, .external_lex_state = 6},
  [226] = {.lex_state = 48, .external_lex_state = 7},
  [227] = {.lex_state = 5, .external_lex_state = 8},
  [228] = {.lex_state = 5, .external_lex_state = 8},
  [229] = {.lex_state = 5, .external_lex_state = 8},
  [230] = {.lex_state = 5, .external_lex_state = 8},
  [231] = {.lex_state = 48, .external_lex_state = 7},
  [232] = {.lex_state = 48, .external_lex_state = 8},
  [233] = {.lex_state = 48, .external_lex_state = 6},
  [234] = {.lex_state = 48, .external_lex_state = 7},
  [235] = {.lex_state = 5, .external_lex_state = 8},
  [236] = {.lex_state = 5, .external_lex_state = 8},
  [237] = {.lex_state = 48, .external_lex_state = 6},
  [238] = {.lex_state = 48, .external_lex_state = 7},
  [239] = {.lex_state = 48, .external_lex_state = 6},
  [240] = {.lex_state = 5, .external_lex_state = 8},
  [241] = {.lex_state = 5, .external_lex_state = 8},
  [242] = {.lex_state = 5, .external_lex_state = 8},
  [243] = {.lex_state = 5, .external_lex_state = 8},
  [244] = {.lex_state = 48, .external_lex_state = 6},
  [245] = {.lex_state = 48, .external_lex_state = 7},
  [246] = {.lex_state = 48, .external_lex_state = 4},
  [247] = {.lex_state = 48, .external_lex_state = 7},
  [248] = {.lex_state = 48, .external_lex_state = 7},
  [249] = {.lex_state = 48, .external_lex_state = 7},
  [250] = {.lex_state = 48, .external_lex_state = 7},
  [251] = {.lex_state = 48, .external_lex_state = 7},
  [252] = {.lex_state = 48, .external_lex_state = 7},
  [253] = {.lex_state = 5, .external_lex_state = 2},
  [254] = {.lex_state = 48, .external_lex_state = 7},
  [255] = {.lex_state = 48, .external_lex_state = 7},
  [256] = {.lex_state = 48, .external_lex_state = 7},
  [257] = {.lex_state = 48, .external_lex_state = 7},
  [258] = {.lex_state = 48, .external_lex_state = 7},
  [259] = {.lex_state = 48, .external_lex_state = 7},
  [260] = {.lex_state = 48, .external_lex_state = 7},
  [261] = {.lex_state = 48, .external_lex_state = 7},
  [262] = {.lex_state = 48, .external_lex_state = 7},
  [263] = {.lex_state = 48, .external_lex_state = 7},
  [264] = {.lex_state = 48, .external_lex_state = 7},
  [265] = {.lex_state = 48, .external_lex_state = 7},
  [266] = {.lex_state = 48, .external_lex_state = 7},
  [267] = {.lex_state = 48, .external_lex_state = 8},
  [268] = {.lex_state = 48, .external_lex_state = 7},
  [269] = {.lex_state = 48, .external_lex_state = 7},
  [270] = {.lex_state = 48, .external_lex_state = 7},
  [271] = {.lex_state = 48, .external_lex_state = 8},
  [272] = {.lex_state = 48, .external_lex_state = 7},
  [273] = {.lex_state = 48, .external_lex_state = 7},
  [274] = {.lex_state = 48, .external_lex_state = 7},
  [275] = {.lex_state = 48, .external_lex_state = 6},
  [276] = {.lex_state = 48, .external_lex_state = 7},
  [277] = {.lex_state = 48, .external_lex_state = 7},
  [278] = {.lex_state = 48, .external_lex_state = 7},
  [279] = {.lex_state = 48, .external_lex_state = 7},
  [280] = {.lex_state = 48, .external_lex_state = 7},
  [281] = {.lex_state = 48, .external_lex_state = 6},
  [282] = {.lex_state = 48, .external_lex_state = 2},
  [283] = {.lex_state = 4, .external_lex_state = 9},
  [284] = {.lex_state = 48, .external_lex_state = 7},
  [285] = {.lex_state = 48, .external_lex_state = 2},
  [286] = {.lex_state = 48, .external_lex_state = 2},
  [287] = {.lex_state = 48, .external_lex_state = 2},
  [288] = {.lex_state = 48, .external_lex_state = 4},
  [289] = {.lex_state = 48, .external_lex_state = 7},
  [290] = {.lex_state = 48, .external_lex_state = 6},
  [291] = {.lex_state = 48, .external_lex_state = 2},
  [292] = {.lex_state = 48, .external_lex_state = 4},
  [293] = {.lex_state = 48, .external_lex_state = 6},
  [294] = {.lex_state = 48, .external_lex_state = 2},
  [295] = {.lex_state = 48, .external_lex_state = 2},
  [296] = {.lex_state = 48, .external_lex_state = 2},
  [297] = {.lex_state = 48, .external_lex_state = 2},
  [298] = {.lex_state = 48, .external_lex_state = 2},
  [299] = {.lex_state = 48, .external_lex_state = 4},
  [300] = {.lex_state = 4, .external_lex_state = 4},
  [301] = {.lex_state = 48, .external_lex_state = 2},
  [302] = {.lex_state = 48, .external_lex_state = 2},
  [303] = {.lex_state = 4, .external_lex_state = 4},
  [304] = {.lex_state = 48, .external_lex_state = 4},
  [305] = {.lex_state = 4, .external_lex_state = 9},
  [306] = {.lex_state = 48, .external_lex_state = 2},
  [307] = {.lex_state = 48, .external_lex_state = 2},
  [308] = {.lex_state = 48, .external_lex_state = 2},
  [309] = {.lex_state = 48, .external_lex_state = 2},
  [310] = {.lex_state = 48, .external_lex_state = 2},
  [311] = {.lex_state = 48, .external_lex_state = 4},
  [312] = {.lex_state = 48, .external_lex_state = 2},
  [313] = {.lex_state = 48, .external_lex_state = 2},
  [314] = {.lex_state = 48, .external_lex_state = 2},
  [315] = {.lex_state = 48, .external_lex_state = 2},
  [316] = {.lex_state = 48, .external_lex_state = 2},
  [317] = {.lex_state = 48, .external_lex_state = 2},
  [318] = {.lex_state = 48, .external_lex_state = 2},
  [319] = {.lex_state = 48, .external_lex_state = 2},
  [320] = {.lex_state = 48, .external_lex_state = 4},
  [321] = {.lex_state = 48, .external_lex_state = 7},
  [322] = {.lex_state = 48, .external_lex_state = 2},
  [323] = {.lex_state = 48, .external_lex_state = 2},
  [324] = {.lex_state = 48, .external_lex_state = 4},
  [325] = {.lex_state = 48, .external_lex_state = 4},
  [326] = {.lex_state = 48, .external_lex_state = 2},
  [327] = {.lex_state = 48, .external_lex_state = 2},
  [328] = {.lex_state = 48, .external_lex_state = 2},
  [329] = {.lex_state = 48, .external_lex_state = 2},
  [330] = {.lex_state = 48, .external_lex_state = 2},
  [331] = {.lex_state = 48, .external_lex_state = 2},
  [332] = {.lex_state = 48, .external_lex_state = 2},
  [333] = {.lex_state = 48, .external_lex_state = 2},
  [334] = {.lex_state = 48, .external_lex_state = 2},
  [335] = {.lex_state = 48, .external_lex_state = 2},
  [336] = {.lex_state = 48, .external_lex_state = 2},
  [337] = {.lex_state = 48, .external_lex_state = 2},
  [338] = {.lex_state = 48, .external_lex_state = 2},
  [339] = {.lex_state = 48, .external_lex_state = 2},
  [340] = {.lex_state = 48, .external_lex_state = 2},
  [341] = {.lex_state = 48, .external_lex_state = 2},
  [342] = {.lex_state = 48, .external_lex_state = 2},
  [343] = {.lex_state = 48, .external_lex_state = 2},
  [344] = {.lex_state = 48, .external_lex_state = 2},
  [345] = {.lex_state = 48, .external_lex_state = 2},
  [346] = {.lex_state = 48, .external_lex_state = 2},
  [347] = {.lex_state = 48, .external_lex_state = 2},
  [348] = {.lex_state = 48, .external_lex_state = 2},
  [349] = {.lex_state = 48, .external_lex_state = 2},
  [350] = {.lex_state = 48, .external_lex_state = 2},
  [351] = {.lex_state = 48, .external_lex_state = 2},
  [352] = {.lex_state = 48, .external_lex_state = 2},
  [353] = {.lex_state = 48, .external_lex_state = 2},
  [354] = {.lex_state = 48, .external_lex_state = 2},
  [355] = {.lex_state = 48, .external_lex_state = 2},
  [356] = {.lex_state = 48, .external_lex_state = 2},
  [357] = {.lex_state = 48, .external_lex_state = 2},
  [358] = {.lex_state = 48, .external_lex_state = 2},
  [359] = {.lex_state = 48, .external_lex_state = 2},
  [360] = {.lex_state = 48, .external_lex_state = 2},
  [361] = {.lex_state = 48, .external_lex_state = 2},
  [362] = {.lex_state = 48, .external_lex_state = 2},
  [363] = {.lex_state = 48, .external_lex_state = 2},
  [364] = {.lex_state = 48, .external_lex_state = 2},
  [365] = {.lex_state = 48, .external_lex_state = 2},
  [366] = {.lex_state = 48, .external_lex_state = 2},
  [367] = {.lex_state = 48, .external_lex_state = 2},
  [368] = {.lex_state = 48, .external_lex_state = 2},
  [369] = {.lex_state = 48, .external_lex_state = 2},
  [370] = {.lex_state = 48, .external_lex_state = 2},
  [371] = {.lex_state = 48, .external_lex_state = 2},
  [372] = {.lex_state = 48, .external_lex_state = 2},
  [373] = {.lex_state = 48, .external_lex_state = 2},
  [374] = {.lex_state = 48, .external_lex_state = 2},
  [375] = {.lex_state = 48, .external_lex_state = 2},
  [376] = {.lex_state = 48, .external_lex_state = 2},
  [377] = {.lex_state = 48, .external_lex_state = 2},
  [378] = {.lex_state = 48, .external_lex_state = 2},
  [379] = {.lex_state = 48, .external_lex_state = 2},
  [380] = {.lex_state = 48, .external_lex_state = 2},
  [381] = {.lex_state = 48, .external_lex_state = 2},
  [382] = {.lex_state = 48, .external_lex_state = 2},
  [383] = {.lex_state = 48, .external_lex_state = 2},
  [384] = {.lex_state = 48, .external_lex_state = 2},
  [385] = {.lex_state = 48, .external_lex_state = 2},
  [386] = {.lex_state = 48, .external_lex_state = 2},
  [387] = {.lex_state = 48, .external_lex_state = 2},
  [388] = {.lex_state = 48, .external_lex_state = 2},
  [389] = {.lex_state = 48, .external_lex_state = 2},
  [390] = {.lex_state = 48, .external_lex_state = 2},
  [391] = {.lex_state = 48, .external_lex_state = 2},
  [392] = {.lex_state = 48, .external_lex_state = 2},
  [393] = {.lex_state = 48, .external_lex_state = 2},
  [394] = {.lex_state = 48, .external_lex_state = 2},
  [395] = {.lex_state = 48, .external_lex_state = 2},
  [396] = {.lex_state = 48, .external_lex_state = 2},
  [397] = {.lex_state = 48, .external_lex_state = 2},
  [398] = {.lex_state = 48, .external_lex_state = 2},
  [399] = {.lex_state = 48, .external_lex_state = 2},
  [400] = {.lex_state = 48, .external_lex_state = 2},
  [401] = {.lex_state = 48, .external_lex_state = 2},
  [402] = {.lex_state = 48, .external_lex_state = 2},
  [403] = {.lex_state = 48, .external_lex_state = 2},
  [404] = {.lex_state = 48, .external_lex_state = 2},
  [405] = {.lex_state = 48, .external_lex_state = 2},
  [406] = {.lex_state = 48, .external_lex_state = 2},
  [407] = {.lex_state = 48, .external_lex_state = 2},
  [408] = {.lex_state = 48, .external_lex_state = 2},
  [409] = {.lex_state = 48, .external_lex_state = 2},
  [410] = {.lex_state = 48, .external_lex_state = 2},
  [411] = {.lex_state = 48, .external_lex_state = 2},
  [412] = {.lex_state = 48, .external_lex_state = 2},
  [413] = {.lex_state = 48, .external_lex_state = 2},
  [414] = {.lex_state = 48, .external_lex_state = 2},
  [415] = {.lex_state = 48, .external_lex_state = 2},
  [416] = {.lex_state = 48, .external_lex_state = 2},
  [417] = {.lex_state = 48, .external_lex_state = 2},
  [418] = {.lex_state = 48, .external_lex_state = 2},
  [419] = {.lex_state = 48, .external_lex_state = 2},
  [420] = {.lex_state = 48, .external_lex_state = 2},
  [421] = {.lex_state = 48, .external_lex_state = 2},
  [422] = {.lex_state = 48, .external_lex_state = 2},
  [423] = {.lex_state = 4, .external_lex_state = 9},
  [424] = {.lex_state = 48, .external_lex_state = 2},
  [425] = {.lex_state = 48, .external_lex_state = 2},
  [426] = {.lex_state = 48, .external_lex_state = 2},
  [427] = {.lex_state = 48, .external_lex_state = 2},
  [428] = {.lex_state = 48, .external_lex_state = 2},
  [429] = {.lex_state = 48, .external_lex_state = 2},
  [430] = {.lex_state = 48, .external_lex_state = 2},
  [431] = {.lex_state = 48, .external_lex_state = 2},
  [432] = {.lex_state = 48, .external_lex_state = 2},
  [433] = {.lex_state = 48, .external_lex_state = 2},
  [434] = {.lex_state = 48, .external_lex_state = 2},
  [435] = {.lex_state = 48, .external_lex_state = 2},
  [436] = {.lex_state = 48, .external_lex_state = 2},
  [437] = {.lex_state = 48, .external_lex_state = 2},
  [438] = {.lex_state = 48, .external_lex_state = 2},
  [439] = {.lex_state = 48, .external_lex_state = 2},
  [440] = {.lex_state = 4, .external_lex_state = 9},
  [441] = {.lex_state = 4, .external_lex_state = 9},
  [442] = {.lex_state = 4, .external_lex_state = 9},
  [443] = {.lex_state = 4, .external_lex_state = 9},
  [444] = {.lex_state = 4, .external_lex_state = 9},
  [445] = {.lex_state = 7, .external_lex_state = 9},
  [446] = {.lex_state = 48, .external_lex_state = 2},
  [447] = {.lex_state = 48, .external_lex_state = 3},
  [448] = {.lex_state = 48, .external_lex_state = 3},
  [449] = {.lex_state = 7, .external_lex_state = 9},
  [450] = {.lex_state = 7, .external_lex_state = 9},
  [451] = {.lex_state = 48, .external_lex_state = 2},
  [452] = {.lex_state = 7, .external_lex_state = 9},
  [453] = {.lex_state = 48, .external_lex_state = 3},
  [454] = {.lex_state = 48, .external_lex_state = 2},
  [455] = {.lex_state = 48, .external_lex_state = 2},
  [456] = {.lex_state = 48, .external_lex_state = 3},
  [457] = {.lex_state = 7, .external_lex_state = 9},
  [458] = {.lex_state = 7, .external_lex_state = 9},
  [459] = {.lex_state = 7, .external_lex_state = 9},
  [460] = {.lex_state = 7, .external_lex_state = 9},
  [461] = {.lex_state = 7, .external_lex_state = 9},
  [462] = {.lex_state = 7, .external_lex_state = 9},
  [463] = {.lex_state = 7, .external_lex_state = 9},
  [464] = {.lex_state = 7, .external_lex_state = 9},
  [465] = {.lex_state = 7, .external_lex_state = 9},
  [466] = {.lex_state = 7, .external_lex_state = 9},
  [467] = {.lex_state = 7, .external_lex_state = 9},
  [468] = {.lex_state = 7, .external_lex_state = 9},
  [469] = {.lex_state = 7, .external_lex_state = 9},
  [470] = {.lex_state = 7, .external_lex_state = 9},
  [471] = {.lex_state = 7, .external_lex_state = 9},
  [472] = {.lex_state = 48, .external_lex_state = 3},
  [473] = {.lex_state = 48, .external_lex_state = 2},
  [474] = {.lex_state = 48, .external_lex_state = 8},
  [475] = {.lex_state = 48, .external_lex_state = 8},
  [476] = {.lex_state = 48, .external_lex_state = 3},
  [477] = {.lex_state = 48, .external_lex_state = 3},
  [478] = {.lex_state = 48, .external_lex_state = 3},
  [479] = {.lex_state = 48, .external_lex_state = 2},
  [480] = {.lex_state = 48, .external_lex_state = 3},
  [481] = {.lex_state = 48, .external_lex_state = 3},
  [482] = {.lex_state = 48, .external_lex_state = 3},
  [483] = {.lex_state = 48, .external_lex_state = 2},
  [484] = {.lex_state = 48, .external_lex_state = 2},
  [485] = {.lex_state = 48, .external_lex_state = 3},
  [486] = {.lex_state = 48, .external_lex_state = 2},
  [487] = {.lex_state = 48, .external_lex_state = 3},
  [488] = {.lex_state = 48, .external_lex_state = 2},
  [489] = {.lex_state = 48, .external_lex_state = 3},
  [490] = {.lex_state = 48, .external_lex_state = 2},
  [491] = {.lex_state = 48, .external_lex_state = 2},
  [492] = {.lex_state = 48, .external_lex_state = 3},
  [493] = {.lex_state = 48, .external_lex_state = 2},
  [494] = {.lex_state = 48, .external_lex_state = 2},
  [495] = {.lex_state = 48, .external_lex_state = 3},
  [496] = {.lex_state = 48, .external_lex_state = 2},
  [497] = {.lex_state = 48, .external_lex_state = 2},
  [498] = {.lex_state = 48, .external_lex_state = 2},
  [499] = {.lex_state = 48, .external_lex_state = 2},
  [500] = {.lex_state = 48, .external_lex_state = 3},
  [501] = {.lex_state = 48, .external_lex_state = 2},
  [502] = {.lex_state = 48, .external_lex_state = 3},
  [503] = {.lex_state = 48, .external_lex_state = 3},
  [504] = {.lex_state = 48, .external_lex_state = 6},
  [505] = {.lex_state = 48, .external_lex_state = 6},
  [506] = {.lex_state = 48, .external_lex_state = 6},
  [507] = {.lex_state = 48, .external_lex_state = 2},
  [508] = {.lex_state = 48, .external_lex_state = 3},
  [509] = {.lex_state = 48, .external_lex_state = 2},
  [510] = {.lex_state = 48, .external_lex_state = 3},
  [511] = {.lex_state = 48, .external_lex_state = 2},
  [512] = {.lex_state = 48, .external_lex_state = 2},
  [513] = {.lex_state = 48, .external_lex_state = 2},
  [514] = {.lex_state = 48, .external_lex_state = 2},
  [515] = {.lex_state = 48, .external_lex_state = 7},
  [516] = {.lex_state = 48, .external_lex_state = 3},
  [517] = {.lex_state = 48, .external_lex_state = 3},
  [518] = {.lex_state = 48, .external_lex_state = 2},
  [519] = {.lex_state = 48, .external_lex_state = 3},
  [520] = {.lex_state = 48, .external_lex_state = 3},
  [521] = {.lex_state = 48, .external_lex_state = 2},
  [522] = {.lex_state = 48, .external_lex_state = 2},
  [523] = {.lex_state = 48, .external_lex_state = 3},
  [524] = {.lex_state = 48, .external_lex_state = 3},
  [525] = {.lex_state = 48, .external_lex_state = 2},
  [526] = {.lex_state = 48, .external_lex_state = 3},
  [527] = {.lex_state = 48, .external_lex_state = 3},
  [528] = {.lex_state = 48, .external_lex_state = 3},
  [529] = {.lex_state = 48, .external_lex_state = 2},
  [530] = {.lex_state = 48, .external_lex_state = 2},
  [531] = {.lex_state = 48, .external_lex_state = 2},
  [532] = {.lex_state = 48, .external_lex_state = 2},
  [533] = {.lex_state = 48, .external_lex_state = 2},
  [534] = {.lex_state = 48, .external_lex_state = 2},
  [535] = {.lex_state = 48, .external_lex_state = 3},
  [536] = {.lex_state = 48, .external_lex_state = 3},
  [537] = {.lex_state = 48, .external_lex_state = 2},
  [538] = {.lex_state = 48, .external_lex_state = 2},
  [539] = {.lex_state = 48, .external_lex_state = 2},
  [540] = {.lex_state = 48, .external_lex_state = 3},
  [541] = {.lex_state = 48, .external_lex_state = 2},
  [542] = {.lex_state = 48, .external_lex_state = 3},
  [543] = {.lex_state = 48, .external_lex_state = 3},
  [544] = {.lex_state = 48, .external_lex_state = 3},
  [545] = {.lex_state = 48, .external_lex_state = 3},
  [546] = {.lex_state = 48, .external_lex_state = 2},
  [547] = {.lex_state = 48, .external_lex_state = 2},
  [548] = {.lex_state = 48, .external_lex_state = 3},
  [549] = {.lex_state = 48, .external_lex_state = 3},
  [550] = {.lex_state = 48, .external_lex_state = 3},
  [551] = {.lex_state = 48, .external_lex_state = 2},
  [552] = {.lex_state = 48, .external_lex_state = 2},
  [553] = {.lex_state = 48, .external_lex_state = 3},
  [554] = {.lex_state = 48, .external_lex_state = 2},
  [555] = {.lex_state = 48, .external_lex_state = 2},
  [556] = {.lex_state = 48, .external_lex_state = 6},
  [557] = {.lex_state = 48, .external_lex_state = 2},
  [558] = {.lex_state = 48, .external_lex_state = 3},
  [559] = {.lex_state = 48, .external_lex_state = 3},
  [560] = {.lex_state = 48, .external_lex_state = 2},
  [561] = {.lex_state = 48, .external_lex_state = 3},
  [562] = {.lex_state = 48, .external_lex_state = 3},
  [563] = {.lex_state = 48, .external_lex_state = 2},
  [564] = {.lex_state = 48, .external_lex_state = 3},
  [565] = {.lex_state = 48, .external_lex_state = 3},
  [566] = {.lex_state = 48, .external_lex_state = 2},
  [567] = {.lex_state = 48, .external_lex_state = 3},
  [568] = {.lex_state = 48, .external_lex_state = 3},
  [569] = {.lex_state = 48, .external_lex_state = 2},
  [570] = {.lex_state = 48, .external_lex_state = 2},
  [571] = {.lex_state = 48, .external_lex_state = 2},
  [572] = {.lex_state = 48, .external_lex_state = 2},
  [573] = {.lex_state = 48, .external_lex_state = 2},
  [574] = {.lex_state = 48, .external_lex_state = 2},
  [575] = {.lex_state = 48, .external_lex_state = 3},
  [576] = {.lex_state = 48, .external_lex_state = 2},
  [577] = {.lex_state = 48, .external_lex_state = 2},
  [578] = {.lex_state = 48, .external_lex_state = 3},
  [579] = {.lex_state = 48, .external_lex_state = 3},
  [580] = {.lex_state = 48, .external_lex_state = 2},
  [581] = {.lex_state = 48, .external_lex_state = 2},
  [582] = {.lex_state = 48, .external_lex_state = 2},
  [583] = {.lex_state = 48, .external_lex_state = 2},
  [584] = {.lex_state = 48, .external_lex_state = 2},
  [585] = {.lex_state = 48, .external_lex_state = 3},
  [586] = {.lex_state = 48, .external_lex_state = 3},
  [587] = {.lex_state = 48, .external_lex_state = 2},
  [588] = {.lex_state = 48, .external_lex_state = 2},
  [589] = {.lex_state = 48, .external_lex_state = 3},
  [590] = {.lex_state = 48, .external_lex_state = 2},
  [591] = {.lex_state = 48, .external_lex_state = 3},
  [592] = {.lex_state = 48, .external_lex_state = 3},
  [593] = {.lex_state = 48, .external_lex_state = 2},
  [594] = {.lex_state = 48, .external_lex_state = 2},
  [595] = {.lex_state = 48, .external_lex_state = 3},
  [596] = {.lex_state = 48, .external_lex_state = 7},
  [597] = {.lex_state = 48, .external_lex_state = 2},
  [598] = {.lex_state = 48, .external_lex_state = 2},
  [599] = {.lex_state = 48, .external_lex_state = 3},
  [600] = {.lex_state = 48, .external_lex_state = 2},
  [601] = {.lex_state = 48, .external_lex_state = 2},
  [602] = {.lex_state = 48, .external_lex_state = 2},
  [603] = {.lex_state = 48, .external_lex_state = 2},
  [604] = {.lex_state = 48, .external_lex_state = 2},
  [605] = {.lex_state = 48, .external_lex_state = 2},
  [606] = {.lex_state = 48, .external_lex_state = 2},
  [607] = {.lex_state = 48, .external_lex_state = 6},
  [608] = {.lex_state = 48, .external_lex_state = 2},
  [609] = {.lex_state = 48, .external_lex_state = 2},
  [610] = {.lex_state = 48, .external_lex_state = 2},
  [611] = {.lex_state = 48, .external_lex_state = 2},
  [612] = {.lex_state = 48, .external_lex_state = 2},
  [613] = {.lex_state = 48, .external_lex_state = 2},
  [614] = {.lex_state = 48, .external_lex_state = 2},
  [615] = {.lex_state = 48, .external_lex_state = 2},
  [616] = {.lex_state = 48, .external_lex_state = 2},
  [617] = {.lex_state = 48, .external_lex_state = 2},
  [618] = {.lex_state = 48, .external_lex_state = 2},
  [619] = {.lex_state = 48, .external_lex_state = 2},
  [620] = {.lex_state = 48, .external_lex_state = 2},
  [621] = {.lex_state = 48, .external_lex_state = 2},
  [622] = {.lex_state = 48, .external_lex_state = 2},
  [623] = {.lex_state = 48, .external_lex_state = 2},
  [624] = {.lex_state = 48, .external_lex_state = 2},
  [625] = {.lex_state = 48, .external_lex_state = 2},
  [626] = {.lex_state = 48, .external_lex_state = 2},
  [627] = {.lex_state = 48, .external_lex_state = 2},
  [628] = {.lex_state = 48, .external_lex_state = 2},
  [629] = {.lex_state = 48, .external_lex_state = 2},
  [630] = {.lex_state = 48, .external_lex_state = 2},
  [631] = {.lex_state = 48, .external_lex_state = 2},
  [632] = {.lex_state = 48, .external_lex_state = 2},
  [633] = {.lex_state = 48, .external_lex_state = 2},
  [634] = {.lex_state = 48, .external_lex_state = 2},
  [635] = {.lex_state = 48, .external_lex_state = 2},
  [636] = {.lex_state = 48, .external_lex_state = 2},
  [637] = {.lex_state = 48, .external_lex_state = 2},
  [638] = {.lex_state = 48, .external_lex_state = 2},
  [639] = {.lex_state = 48, .external_lex_state = 2},
  [640] = {.lex_state = 48, .external_lex_state = 2},
  [641] = {.lex_state = 48, .external_lex_state = 2},
  [642] = {.lex_state = 48, .external_lex_state = 2},
  [643] = {.lex_state = 48, .external_lex_state = 2},
  [644] = {.lex_state = 48, .external_lex_state = 2},
  [645] = {.lex_state = 48, .external_lex_state = 2},
  [646] = {.lex_state = 48, .external_lex_state = 2},
  [647] = {.lex_state = 48, .external_lex_state = 2},
  [648] = {.lex_state = 48, .external_lex_state = 2},
  [649] = {.lex_state = 48, .external_lex_state = 2},
  [650] = {.lex_state = 48, .external_lex_state = 2},
  [651] = {.lex_state = 48, .external_lex_state = 2},
  [652] = {.lex_state = 48, .external_lex_state = 2},
  [653] = {.lex_state = 48, .external_lex_state = 2},
  [654] = {.lex_state = 48, .external_lex_state = 2},
  [655] = {.lex_state = 48, .external_lex_state = 2},
  [656] = {.lex_state = 48, .external_lex_state = 2},
  [657] = {.lex_state = 48, .external_lex_state = 2},
  [658] = {.lex_state = 48, .external_lex_state = 2},
  [659] = {.lex_state = 48, .external_lex_state = 2},
  [660] = {.lex_state = 48, .external_lex_state = 2},
  [661] = {.lex_state = 48, .external_lex_state = 2},
  [662] = {.lex_state = 48, .external_lex_state = 2},
  [663] = {.lex_state = 48, .external_lex_state = 2},
  [664] = {.lex_state = 48, .external_lex_state = 2},
  [665] = {.lex_state = 48, .external_lex_state = 2},
  [666] = {.lex_state = 48, .external_lex_state = 2},
  [667] = {.lex_state = 48, .external_lex_state = 2},
  [668] = {.lex_state = 48, .external_lex_state = 2},
  [669] = {.lex_state = 48, .external_lex_state = 2},
  [670] = {.lex_state = 48, .external_lex_state = 2},
  [671] = {.lex_state = 48, .external_lex_state = 2},
  [672] = {.lex_state = 48, .external_lex_state = 2},
  [673] = {.lex_state = 48, .external_lex_state = 2},
  [674] = {.lex_state = 48, .external_lex_state = 2},
  [675] = {.lex_state = 48, .external_lex_state = 2},
  [676] = {.lex_state = 48, .external_lex_state = 2},
  [677] = {.lex_state = 48, .external_lex_state = 2},
  [678] = {.lex_state = 48, .external_lex_state = 2},
  [679] = {.lex_state = 48, .external_lex_state = 2},
  [680] = {.lex_state = 48, .external_lex_state = 2},
  [681] = {.lex_state = 48, .external_lex_state = 2},
  [682] = {.lex_state = 48, .external_lex_state = 2},
  [683] = {.lex_state = 48, .external_lex_state = 2},
  [684] = {.lex_state = 48, .external_lex_state = 2},
  [685] = {.lex_state = 48, .external_lex_state = 2},
  [686] = {.lex_state = 48, .external_lex_state = 2},
  [687] = {.lex_state = 48, .external_lex_state = 2},
  [688] = {.lex_state = 48, .external_lex_state = 2},
  [689] = {.lex_state = 48, .external_lex_state = 2},
  [690] = {.lex_state = 48, .external_lex_state = 2},
  [691] = {.lex_state = 48, .external_lex_state = 2},
  [692] = {.lex_state = 48, .external_lex_state = 2},
  [693] = {.lex_state = 48, .external_lex_state = 2},
  [694] = {.lex_state = 48, .external_lex_state = 2},
  [695] = {.lex_state = 48, .external_lex_state = 2},
  [696] = {.lex_state = 5, .external_lex_state = 10},
  [697] = {.lex_state = 5, .external_lex_state = 10},
  [698] = {.lex_state = 5, .external_lex_state = 10},
  [699] = {.lex_state = 5, .external_lex_state = 10},
  [700] = {.lex_state = 5, .external_lex_state = 10},
  [701] = {.lex_state = 5, .external_lex_state = 10},
  [702] = {.lex_state = 5, .external_lex_state = 10},
  [703] = {.lex_state = 5, .external_lex_state = 10},
  [704] = {.lex_state = 5, .external_lex_state = 10},
  [705] = {.lex_state = 5, .external_lex_state = 9},
  [706] = {.lex_state = 5, .external_lex_state = 10},
  [707] = {.lex_state = 5, .external_lex_state = 10},
  [708] = {.lex_state = 5, .external_lex_state = 10},
  [709] = {.lex_state = 5, .external_lex_state = 10},
  [710] = {.lex_state = 5, .external_lex_state = 10},
  [711] = {.lex_state = 5, .external_lex_state = 10},
  [712] = {.lex_state = 5, .external_lex_state = 9},
  [713] = {.lex_state = 5, .external_lex_state = 10},
  [714] = {.lex_state = 5, .external_lex_state = 10},
  [715] = {.lex_state = 8, .external_lex_state = 10},
  [716] = {.lex_state = 8, .external_lex_state = 10},
  [717] = {.lex_state = 8, .external_lex_state = 10},
  [718] = {.lex_state = 8, .external_lex_state = 10},
  [719] = {.lex_state = 8, .external_lex_state = 9},
  [720] = {.lex_state = 8, .external_lex_state = 9},
  [721] = {.lex_state = 8, .external_lex_state = 10},
  [722] = {.lex_state = 8, .external_lex_state = 10},
  [723] = {.lex_state = 5, .external_lex_state = 10},
  [724] = {.lex_state = 8, .external_lex_state = 9},
  [725] = {.lex_state = 8, .external_lex_state = 11},
  [726] = {.lex_state = 5, .external_lex_state = 10},
  [727] = {.lex_state = 5, .external_lex_state = 10},
  [728] = {.lex_state = 5, .external_lex_state = 10},
  [729] = {.lex_state = 5, .external_lex_state = 10},
  [730] = {.lex_state = 5, .external_lex_state = 10},
  [731] = {.lex_state = 8, .external_lex_state = 9},
  [732] = {.lex_state = 5, .external_lex_state = 10},
  [733] = {.lex_state = 5, .external_lex_state = 10},
  [734] = {.lex_state = 8, .external_lex_state = 10},
  [735] = {.lex_state = 8, .external_lex_state = 10},
  [736] = {.lex_state = 8, .external_lex_state = 10},
  [737] = {.lex_state = 5, .external_lex_state = 9},
  [738] = {.lex_state = 5, .external_lex_state = 9},
  [739] = {.lex_state = 5, .external_lex_state = 12},
  [740] = {.lex_state = 5, .external_lex_state = 9},
  [741] = {.lex_state = 5, .external_lex_state = 10},
  [742] = {.lex_state = 5, .external_lex_state = 9},
  [743] = {.lex_state = 5, .external_lex_state = 9},
  [744] = {.lex_state = 5, .external_lex_state = 9},
  [745] = {.lex_state = 5, .external_lex_state = 10},
  [746] = {.lex_state = 5, .external_lex_state = 9},
  [747] = {.lex_state = 5, .external_lex_state = 9},
  [748] = {.lex_state = 5, .external_lex_state = 9},
  [749] = {.lex_state = 5, .external_lex_state = 9},
  [750] = {.lex_state = 5, .external_lex_state = 13},
  [751] = {.lex_state = 5, .external_lex_state = 11},
  [752] = {.lex_state = 8, .external_lex_state = 10},
  [753] = {.lex_state = 5, .external_lex_state = 10},
  [754] = {.lex_state = 8, .external_lex_state = 10},
  [755] = {.lex_state = 8, .external_lex_state = 10},
  [756] = {.lex_state = 5, .external_lex_state = 10},
  [757] = {.lex_state = 8, .external_lex_state = 12},
  [758] = {.lex_state = 5, .external_lex_state = 9},
  [759] = {.lex_state = 5, .external_lex_state = 9},
  [760] = {.lex_state = 5, .external_lex_state = 9},
  [761] = {.lex_state = 5, .external_lex_state = 12},
  [762] = {.lex_state = 5, .external_lex_state = 10},
  [763] = {.lex_state = 5, .external_lex_state = 10},
  [764] = {.lex_state = 5, .external_lex_state = 10},
  [765] = {.lex_state = 5, .external_lex_state = 10},
  [766] = {.lex_state = 5, .external_lex_state = 10},
  [767] = {.lex_state = 5, .external_lex_state = 10},
  [768] = {.lex_state = 5, .external_lex_state = 10},
  [769] = {.lex_state = 5, .external_lex_state = 13},
  [770] = {.lex_state = 5, .external_lex_state = 10},
  [771] = {.lex_state = 5, .external_lex_state = 10},
  [772] = {.lex_state = 5, .external_lex_state = 10},
  [773] = {.lex_state = 5, .external_lex_state = 10},
  [774] = {.lex_state = 5, .external_lex_state = 10},
  [775] = {.lex_state = 5, .external_lex_state = 10},
  [776] = {.lex_state = 5, .external_lex_state = 10},
  [777] = {.lex_state = 5, .external_lex_state = 10},
  [778] = {.lex_state = 5, .external_lex_state = 10},
  [779] = {.lex_state = 5, .external_lex_state = 10},
  [780] = {.lex_state = 5, .external_lex_state = 10},
  [781] = {.lex_state = 5, .external_lex_state = 10},
  [782] = {.lex_state = 5, .external_lex_state = 10},
  [783] = {.lex_state = 5, .external_lex_state = 10},
  [784] = {.lex_state = 5, .external_lex_state = 10},
  [785] = {.lex_state = 5, .external_lex_state = 10},
  [786] = {.lex_state = 8, .external_lex_state = 12},
  [787] = {.lex_state = 5, .external_lex_state = 10},
  [788] = {.lex_state = 8, .external_lex_state = 12},
  [789] = {.lex_state = 5, .external_lex_state = 9},
  [790] = {.lex_state = 5, .external_lex_state = 10},
  [791] = {.lex_state = 5, .external_lex_state = 10},
  [792] = {.lex_state = 5, .external_lex_state = 10},
  [793] = {.lex_state = 5, .external_lex_state = 10},
  [794] = {.lex_state = 5, .external_lex_state = 10},
  [795] = {.lex_state = 5, .external_lex_state = 10},
  [796] = {.lex_state = 5, .external_lex_state = 10},
  [797] = {.lex_state = 5, .external_lex_state = 10},
  [798] = {.lex_state = 5, .external_lex_state = 10},
  [799] = {.lex_state = 5, .external_lex_state = 10},
  [800] = {.lex_state = 5, .external_lex_state = 10},
  [801] = {.lex_state = 5, .external_lex_state = 10},
  [802] = {.lex_state = 5, .external_lex_state = 10},
  [803] = {.lex_state = 5, .external_lex_state = 10},
  [804] = {.lex_state = 5, .external_lex_state = 10},
  [805] = {.lex_state = 5, .external_lex_state = 10},
  [806] = {.lex_state = 5, .external_lex_state = 10},
  [807] = {.lex_state = 5, .external_lex_state = 10},
  [808] = {.lex_state = 7, .external_lex_state = 9},
  [809] = {.lex_state = 7, .external_lex_state = 9},
  [810] = {.lex_state = 7, .external_lex_state = 9},
  [811] = {.lex_state = 7, .external_lex_state = 9},
  [812] = {.lex_state = 5, .external_lex_state = 10},
  [813] = {.lex_state = 5, .external_lex_state = 9},
  [814] = {.lex_state = 5, .external_lex_state = 10},
  [815] = {.lex_state = 8, .external_lex_state = 12},
  [816] = {.lex_state = 5, .external_lex_state = 9},
  [817] = {.lex_state = 5, .external_lex_state = 9},
  [818] = {.lex_state = 5, .external_lex_state = 13},
  [819] = {.lex_state = 5, .external_lex_state = 9},
  [820] = {.lex_state = 5, .external_lex_state = 9},
  [821] = {.lex_state = 5, .external_lex_state = 9},
  [822] = {.lex_state = 5, .external_lex_state = 13},
  [823] = {.lex_state = 8, .external_lex_state = 12},
  [824] = {.lex_state = 8, .external_lex_state = 12},
  [825] = {.lex_state = 8, .external_lex_state = 12},
  [826] = {.lex_state = 5, .external_lex_state = 10},
  [827] = {.lex_state = 5, .external_lex_state = 10},
  [828] = {.lex_state = 5, .external_lex_state = 10},
  [829] = {.lex_state = 5, .external_lex_state = 11},
  [830] = {.lex_state = 5, .external_lex_state = 9},
  [831] = {.lex_state = 5, .external_lex_state = 10},
  [832] = {.lex_state = 5, .external_lex_state = 9},
  [833] = {.lex_state = 5, .external_lex_state = 9},
  [834] = {.lex_state = 5, .external_lex_state = 9},
  [835] = {.lex_state = 5, .external_lex_state = 9},
  [836] = {.lex_state = 5, .external_lex_state = 9},
  [837] = {.lex_state = 5, .external_lex_state = 9},
  [838] = {.lex_state = 5, .external_lex_state = 9},
  [839] = {.lex_state = 5, .external_lex_state = 9},
  [840] = {.lex_state = 5, .external_lex_state = 9},
  [841] = {.lex_state = 5, .external_lex_state = 9},
  [842] = {.lex_state = 5, .external_lex_state = 10},
  [843] = {.lex_state = 5, .external_lex_state = 10},
  [844] = {.lex_state = 5, .external_lex_state = 13},
  [845] = {.lex_state = 8, .external_lex_state = 12},
  [846] = {.lex_state = 5, .external_lex_state = 10},
  [847] = {.lex_state = 8, .external_lex_state = 12},
  [848] = {.lex_state = 5, .external_lex_state = 12},
  [849] = {.lex_state = 5, .external_lex_state = 10},
  [850] = {.lex_state = 5, .external_lex_state = 12},
  [851] = {.lex_state = 5, .external_lex_state = 12},
  [852] = {.lex_state = 5, .external_lex_state = 10},
  [853] = {.lex_state = 5, .external_lex_state = 10},
  [854] = {.lex_state = 5, .external_lex_state = 13},
  [855] = {.lex_state = 5, .external_lex_state = 9},
  [856] = {.lex_state = 5, .external_lex_state = 12},
  [857] = {.lex_state = 5, .external_lex_state = 12},
  [858] = {.lex_state = 5, .external_lex_state = 12},
  [859] = {.lex_state = 5, .external_lex_state = 9},
  [860] = {.lex_state = 5, .external_lex_state = 10},
  [861] = {.lex_state = 5, .external_lex_state = 10},
  [862] = {.lex_state = 5, .external_lex_state = 9},
  [863] = {.lex_state = 5, .external_lex_state = 10},
  [864] = {.lex_state = 5, .external_lex_state = 10},
  [865] = {.lex_state = 5, .external_lex_state = 13},
  [866] = {.lex_state = 8, .external_lex_state = 13},
  [867] = {.lex_state = 5, .external_lex_state = 13},
  [868] = {.lex_state = 5, .external_lex_state = 9},
  [869] = {.lex_state = 5, .external_lex_state = 9},
  [870] = {.lex_state = 5, .external_lex_state = 11},
  [871] = {.lex_state = 5, .external_lex_state = 11},
  [872] = {.lex_state = 5, .external_lex_state = 11},
  [873] = {.lex_state = 5, .external_lex_state = 9},
  [874] = {.lex_state = 5, .external_lex_state = 11},
  [875] = {.lex_state = 5, .external_lex_state = 9},
  [876] = {.lex_state = 5, .external_lex_state = 11},
  [877] = {.lex_state = 8, .external_lex_state = 12},
  [878] = {.lex_state = 5, .external_lex_state = 10},
  [879] = {.lex_state = 5, .external_lex_state = 11},
  [880] = {.lex_state = 5, .external_lex_state = 10},
  [881] = {.lex_state = 5, .external_lex_state = 11},
  [882] = {.lex_state = 5, .external_lex_state = 11},
  [883] = {.lex_state = 5, .external_lex_state = 13},
  [884] = {.lex_state = 5, .external_lex_state = 9},
  [885] = {.lex_state = 5, .external_lex_state = 9},
  [886] = {.lex_state = 5, .external_lex_state = 13},
  [887] = {.lex_state = 5, .external_lex_state = 9},
  [888] = {.lex_state = 5, .external_lex_state = 9},
  [889] = {.lex_state = 5, .external_lex_state = 12},
  [890] = {.lex_state = 5, .external_lex_state = 11},
  [891] = {.lex_state = 5, .external_lex_state = 10},
  [892] = {.lex_state = 5, .external_lex_state = 10},
  [893] = {.lex_state = 5, .external_lex_state = 10},
  [894] = {.lex_state = 5, .external_lex_state = 10},
  [895] = {.lex_state = 5, .external_lex_state = 10},
  [896] = {.lex_state = 5, .external_lex_state = 10},
  [897] = {.lex_state = 5, .external_lex_state = 9},
  [898] = {.lex_state = 5, .external_lex_state = 12},
  [899] = {.lex_state = 8, .external_lex_state = 11},
  [900] = {.lex_state = 5, .external_lex_state = 10},
  [901] = {.lex_state = 8, .external_lex_state = 11},
  [902] = {.lex_state = 8, .external_lex_state = 11},
  [903] = {.lex_state = 7, .external_lex_state = 9},
  [904] = {.lex_state = 7, .external_lex_state = 9},
  [905] = {.lex_state = 5, .external_lex_state = 12},
  [906] = {.lex_state = 5, .external_lex_state = 10},
  [907] = {.lex_state = 5, .external_lex_state = 12},
  [908] = {.lex_state = 8, .external_lex_state = 13},
  [909] = {.lex_state = 8, .external_lex_state = 13},
  [910] = {.lex_state = 8, .external_lex_state = 13},
  [911] = {.lex_state = 5, .external_lex_state = 9},
  [912] = {.lex_state = 5, .external_lex_state = 9},
  [913] = {.lex_state = 5, .external_lex_state = 10},
  [914] = {.lex_state = 5, .external_lex_state = 9},
  [915] = {.lex_state = 5, .external_lex_state = 9},
  [916] = {.lex_state = 5, .external_lex_state = 10},
  [917] = {.lex_state = 5, .external_lex_state = 13},
  [918] = {.lex_state = 5, .external_lex_state = 10},
  [919] = {.lex_state = 5, .external_lex_state = 10},
  [920] = {.lex_state = 5, .external_lex_state = 13},
  [921] = {.lex_state = 5, .external_lex_state = 13},
  [922] = {.lex_state = 5, .external_lex_state = 13},
  [923] = {.lex_state = 5, .external_lex_state = 12},
  [924] = {.lex_state = 5, .external_lex_state = 13},
  [925] = {.lex_state = 5, .external_lex_state = 11},
  [926] = {.lex_state = 5, .external_lex_state = 12},
  [927] = {.lex_state = 5, .external_lex_state = 13},
  [928] = {.lex_state = 5, .external_lex_state = 12},
  [929] = {.lex_state = 5, .external_lex_state = 11},
  [930] = {.lex_state = 5, .external_lex_state = 12},
  [931] = {.lex_state = 5, .external_lex_state = 12},
  [932] = {.lex_state = 5, .external_lex_state = 13},
  [933] = {.lex_state = 5, .external_lex_state = 12},
  [934] = {.lex_state = 5, .external_lex_state = 13},
  [935] = {.lex_state = 5, .external_lex_state = 13},
  [936] = {.lex_state = 5, .external_lex_state = 13},
  [937] = {.lex_state = 5, .external_lex_state = 13},
  [938] = {.lex_state = 5, .external_lex_state = 13},
  [939] = {.lex_state = 5, .external_lex_state = 12},
  [940] = {.lex_state = 5, .external_lex_state = 12},
  [941] = {.lex_state = 5, .external_lex_state = 12},
  [942] = {.lex_state = 5, .external_lex_state = 11},
  [943] = {.lex_state = 5, .external_lex_state = 11},
  [944] = {.lex_state = 5, .external_lex_state = 13},
  [945] = {.lex_state = 5, .external_lex_state = 11},
  [946] = {.lex_state = 5, .external_lex_state = 11},
  [947] = {.lex_state = 5, .external_lex_state = 12},
  [948] = {.lex_state = 5, .external_lex_state = 11},
  [949] = {.lex_state = 5, .external_lex_state = 13},
  [950] = {.lex_state = 5, .external_lex_state = 12},
  [951] = {.lex_state = 5, .external_lex_state = 12},
  [952] = {.lex_state = 5, .external_lex_state = 11},
  [953] = {.lex_state = 5, .external_lex_state = 13},
  [954] = {.lex_state = 5, .external_lex_state = 12},
  [955] = {.lex_state = 5, .external_lex_state = 13},
  [956] = {.lex_state = 5, .external_lex_state = 12},
  [957] = {.lex_state = 5, .external_lex_state = 13},
  [958] = {.lex_state = 5, .external_lex_state = 13},
  [959] = {.lex_state = 5, .external_lex_state = 13},
  [960] = {.lex_state = 5, .external_lex_state = 12},
  [961] = {.lex_state = 5, .external_lex_state = 12},
  [962] = {.lex_state = 5, .external_lex_state = 12},
  [963] = {.lex_state = 5, .external_lex_state = 11},
  [964] = {.lex_state = 5, .external_lex_state = 12},
  [965] = {.lex_state = 5, .external_lex_state = 12},
  [966] = {.lex_state = 5, .external_lex_state = 11},
  [967] = {.lex_state = 5, .external_lex_state = 11},
  [968] = {.lex_state = 5, .external_lex_state = 12},
  [969] = {.lex_state = 5, .external_lex_state = 12},
  [970] = {.lex_state = 5, .external_lex_state = 12},
  [971] = {.lex_state = 5, .external_lex_state = 12},
  [972] = {.lex_state = 5, .external_lex_state = 12},
  [973] = {.lex_state = 5, .external_lex_state = 12},
  [974] = {.lex_state = 5, .external_lex_state = 11},
  [975] = {.lex_state = 5, .external_lex_state = 11},
  [976] = {.lex_state = 5, .external_lex_state = 11},
  [977] = {.lex_state = 5, .external_lex_state = 13},
  [978] = {.lex_state = 5, .external_lex_state = 11},
  [979] = {.lex_state = 5, .external_lex_state = 11},
  [980] = {.lex_state = 5, .external_lex_state = 11},
  [981] = {.lex_state = 5, .external_lex_state = 12},
  [982] = {.lex_state = 5, .external_lex_state = 12},
  [983] = {.lex_state = 5, .external_lex_state = 13},
  [984] = {.lex_state = 5, .external_lex_state = 11},
  [985] = {.lex_state = 5, .external_lex_state = 11},
  [986] = {.lex_state = 5, .external_lex_state = 11},
  [987] = {.lex_state = 5, .external_lex_state = 11},
  [988] = {.lex_state = 5, .external_lex_state = 12},
  [989] = {.lex_state = 5, .external_lex_state = 12},
  [990] = {.lex_state = 5, .external_lex_state = 12},
  [991] = {.lex_state = 5, .external_lex_state = 12},
  [992] = {.lex_state = 5, .external_lex_state = 12},
  [993] = {.lex_state = 5, .external_lex_state = 11},
  [994] = {.lex_state = 5, .external_lex_state = 11},
  [995] = {.lex_state = 5, .external_lex_state = 11},
  [996] = {.lex_state = 5, .external_lex_state = 11},
  [997] = {.lex_state = 5, .external_lex_state = 9},
  [998] = {.lex_state = 5, .external_lex_state = 11},
  [999] = {.lex_state = 5, .external_lex_state = 11},
  [1000] = {.lex_state = 5, .external_lex_state = 11},
  [1001] = {.lex_state = 5, .external_lex_state = 13},
  [1002] = {.lex_state = 5, .external_lex_state = 11},
  [1003] = {.lex_state = 5, .external_lex_state = 11},
  [1004] = {.lex_state = 5, .external_lex_state = 11},
  [1005] = {.lex_state = 5, .external_lex_state = 11},
  [1006] = {.lex_state = 5, .external_lex_state = 13},
  [1007] = {.lex_state = 5, .external_lex_state = 13},
  [1008] = {.lex_state = 5, .external_lex_state = 13},
  [1009] = {.lex_state = 5, .external_lex_state = 11},
  [1010] = {.lex_state = 5, .external_lex_state = 11},
  [1011] = {.lex_state = 5, .external_lex_state = 13},
  [1012] = {.lex_state = 5, .external_lex_state = 12},
  [1013] = {.lex_state = 5, .external_lex_state = 13},
  [1014] = {.lex_state = 5, .external_lex_state = 12},
  [1015] = {.lex_state = 5, .external_lex_state = 12},
  [1016] = {.lex_state = 5, .external_lex_state = 12},
  [1017] = {.lex_state = 5, .external_lex_state = 12},
  [1018] = {.lex_state = 5, .external_lex_state = 12},
  [1019] = {.lex_state = 5, .external_lex_state = 12},
  [1020] = {.lex_state = 8, .external_lex_state = 11},
  [1021] = {.lex_state = 8, .external_lex_state = 11},
  [1022] = {.lex_state = 8, .external_lex_state = 11},
  [1023] = {.lex_state = 5, .external_lex_state = 12},
  [1024] = {.lex_state = 5, .external_lex_state = 12},
  [1025] = {.lex_state = 5, .external_lex_state = 12},
  [1026] = {.lex_state = 5, .external_lex_state = 12},
  [1027] = {.lex_state = 5, .external_lex_state = 12},
  [1028] = {.lex_state = 5, .external_lex_state = 12},
  [1029] = {.lex_state = 5, .external_lex_state = 11},
  [1030] = {.lex_state = 5, .external_lex_state = 12},
  [1031] = {.lex_state = 5, .external_lex_state = 11},
  [1032] = {.lex_state = 5, .external_lex_state = 10},
  [1033] = {.lex_state = 5, .external_lex_state = 13},
  [1034] = {.lex_state = 5, .external_lex_state = 12},
  [1035] = {.lex_state = 5, .external_lex_state = 12},
  [1036] = {.lex_state = 5, .external_lex_state = 13},
  [1037] = {.lex_state = 5, .external_lex_state = 12},
  [1038] = {.lex_state = 8, .external_lex_state = 12},
  [1039] = {.lex_state = 5, .external_lex_state = 12},
  [1040] = {.lex_state = 5, .external_lex_state = 11},
  [1041] = {.lex_state = 5, .external_lex_state = 13},
  [1042] = {.lex_state = 5, .external_lex_state = 12},
  [1043] = {.lex_state = 5, .external_lex_state = 13},
  [1044] = {.lex_state = 5, .external_lex_state = 13},
  [1045] = {.lex_state = 8, .external_lex_state = 12},
  [1046] = {.lex_state = 5, .external_lex_state = 13},
  [1047] = {.lex_state = 8, .external_lex_state = 12},
  [1048] = {.lex_state = 5, .external_lex_state = 13},
  [1049] = {.lex_state = 5, .external_lex_state = 13},
  [1050] = {.lex_state = 5, .external_lex_state = 11},
  [1051] = {.lex_state = 5, .external_lex_state = 13},
  [1052] = {.lex_state = 5, .external_lex_state = 13},
  [1053] = {.lex_state = 5, .external_lex_state = 12},
  [1054] = {.lex_state = 5, .external_lex_state = 13},
  [1055] = {.lex_state = 5, .external_lex_state = 12},
  [1056] = {.lex_state = 5, .external_lex_state = 12},
  [1057] = {.lex_state = 5, .external_lex_state = 12},
  [1058] = {.lex_state = 5, .external_lex_state = 12},
  [1059] = {.lex_state = 5, .external_lex_state = 12},
  [1060] = {.lex_state = 7, .external_lex_state = 13},
  [1061] = {.lex_state = 7, .external_lex_state = 13},
  [1062] = {.lex_state = 7, .external_lex_state = 13},
  [1063] = {.lex_state = 7, .external_lex_state = 13},
  [1064] = {.lex_state = 8, .external_lex_state = 10},
  [1065] = {.lex_state = 7, .external_lex_state = 13},
  [1066] = {.lex_state = 8, .external_lex_state = 10},
  [1067] = {.lex_state = 8, .external_lex_state = 10},
  [1068] = {.lex_state = 5, .external_lex_state = 13},
  [1069] = {.lex_state = 7, .external_lex_state = 13},
  [1070] = {.lex_state = 7, .external_lex_state = 13},
  [1071] = {.lex_state = 7, .external_lex_state = 13},
  [1072] = {.lex_state = 7, .external_lex_state = 13},
  [1073] = {.lex_state = 5, .external_lex_state = 12},
  [1074] = {.lex_state = 5, .external_lex_state = 12},
  [1075] = {.lex_state = 8, .external_lex_state = 12},
  [1076] = {.lex_state = 5, .external_lex_state = 12},
  [1077] = {.lex_state = 7, .external_lex_state = 13},
  [1078] = {.lex_state = 5, .external_lex_state = 12},
  [1079] = {.lex_state = 5, .external_lex_state = 12},
  [1080] = {.lex_state = 8, .external_lex_state = 12},
  [1081] = {.lex_state = 5, .external_lex_state = 12},
  [1082] = {.lex_state = 5, .external_lex_state = 12},
  [1083] = {.lex_state = 5, .external_lex_state = 12},
  [1084] = {.lex_state = 5, .external_lex_state = 12},
  [1085] = {.lex_state = 5, .external_lex_state = 12},
  [1086] = {.lex_state = 5, .external_lex_state = 12},
  [1087] = {.lex_state = 5, .external_lex_state = 12},
  [1088] = {.lex_state = 5, .external_lex_state = 12},
  [1089] = {.lex_state = 5, .external_lex_state = 12},
  [1090] = {.lex_state = 8, .external_lex_state = 12},
  [1091] = {.lex_state = 5, .external_lex_state = 12},
  [1092] = {.lex_state = 5, .external_lex_state = 12},
  [1093] = {.lex_state = 7, .external_lex_state = 13},
  [1094] = {.lex_state = 5, .external_lex_state = 12},
  [1095] = {.lex_state = 7, .external_lex_state = 13},
  [1096] = {.lex_state = 5, .external_lex_state = 12},
  [1097] = {.lex_state = 5, .external_lex_state = 12},
  [1098] = {.lex_state = 5, .external_lex_state = 12},
  [1099] = {.lex_state = 5, .external_lex_state = 12},
  [1100] = {.lex_state = 7, .external_lex_state = 13},
  [1101] = {.lex_state = 5, .external_lex_state = 12},
  [1102] = {.lex_state = 7, .external_lex_state = 13},
  [1103] = {.lex_state = 5, .external_lex_state = 12},
  [1104] = {.lex_state = 5, .external_lex_state = 12},
  [1105] = {.lex_state = 8, .external_lex_state = 11},
  [1106] = {.lex_state = 5, .external_lex_state = 12},
  [1107] = {.lex_state = 8, .external_lex_state = 11},
  [1108] = {.lex_state = 5, .external_lex_state = 12},
  [1109] = {.lex_state = 8, .external_lex_state = 11},
  [1110] = {.lex_state = 8, .external_lex_state = 11},
  [1111] = {.lex_state = 8, .external_lex_state = 11},
  [1112] = {.lex_state = 5, .external_lex_state = 12},
  [1113] = {.lex_state = 8, .external_lex_state = 11},
  [1114] = {.lex_state = 5, .external_lex_state = 12},
  [1115] = {.lex_state = 5, .external_lex_state = 12},
  [1116] = {.lex_state = 5, .external_lex_state = 12},
  [1117] = {.lex_state = 5, .external_lex_state = 12},
  [1118] = {.lex_state = 5, .external_lex_state = 12},
  [1119] = {.lex_state = 7, .external_lex_state = 13},
  [1120] = {.lex_state = 5, .external_lex_state = 12},
  [1121] = {.lex_state = 7, .external_lex_state = 13},
  [1122] = {.lex_state = 5, .external_lex_state = 12},
  [1123] = {.lex_state = 5, .external_lex_state = 11},
  [1124] = {.lex_state = 5, .external_lex_state = 11},
  [1125] = {.lex_state = 5, .external_lex_state = 11},
  [1126] = {.lex_state = 5, .external_lex_state = 11},
  [1127] = {.lex_state = 5, .external_lex_state = 12},
  [1128] = {.lex_state = 5, .external_lex_state = 10},
  [1129] = {.lex_state = 5, .external_lex_state = 2},
  [1130] = {.lex_state = 5, .external_lex_state = 11},
  [1131] = {.lex_state = 5, .external_lex_state = 2},
  [1132] = {.lex_state = 5, .external_lex_state = 6},
  [1133] = {.lex_state = 5, .external_lex_state = 6},
  [1134] = {.lex_state = 5, .external_lex_state = 7},
  [1135] = {.lex_state = 5, .external_lex_state = 6},
  [1136] = {.lex_state = 5, .external_lex_state = 7},
  [1137] = {.lex_state = 5, .external_lex_state = 7},
  [1138] = {.lex_state = 5, .external_lex_state = 6},
  [1139] = {.lex_state = 5, .external_lex_state = 7},
  [1140] = {.lex_state = 5, .external_lex_state = 6},
  [1141] = {.lex_state = 5, .external_lex_state = 7},
  [1142] = {.lex_state = 5, .external_lex_state = 6},
  [1143] = {.lex_state = 5, .external_lex_state = 6},
  [1144] = {.lex_state = 5, .external_lex_state = 6},
  [1145] = {.lex_state = 5, .external_lex_state = 7},
  [1146] = {.lex_state = 5, .external_lex_state = 6},
  [1147] = {.lex_state = 5, .external_lex_state = 6},
  [1148] = {.lex_state = 5, .external_lex_state = 7},
  [1149] = {.lex_state = 5, .external_lex_state = 6},
  [1150] = {.lex_state = 5, .external_lex_state = 6},
  [1151] = {.lex_state = 5, .external_lex_state = 7},
  [1152] = {.lex_state = 5, .external_lex_state = 7},
  [1153] = {.lex_state = 5, .external_lex_state = 6},
  [1154] = {.lex_state = 5, .external_lex_state = 6},
  [1155] = {.lex_state = 5, .external_lex_state = 6},
  [1156] = {.lex_state = 5, .external_lex_state = 6},
  [1157] = {.lex_state = 5, .external_lex_state = 6},
  [1158] = {.lex_state = 5, .external_lex_state = 6},
  [1159] = {.lex_state = 5, .external_lex_state = 6},
  [1160] = {.lex_state = 5, .external_lex_state = 7},
  [1161] = {.lex_state = 5, .external_lex_state = 6},
  [1162] = {.lex_state = 5, .external_lex_state = 6},
  [1163] = {.lex_state = 5, .external_lex_state = 6},
  [1164] = {.lex_state = 5, .external_lex_state = 6},
  [1165] = {.lex_state = 5, .external_lex_state = 7},
  [1166] = {.lex_state = 5, .external_lex_state = 6},
  [1167] = {.lex_state = 5, .external_lex_state = 7},
  [1168] = {.lex_state = 5, .external_lex_state = 2},
  [1169] = {.lex_state = 5, .external_lex_state = 2},
  [1170] = {.lex_state = 5, .external_lex_state = 2},
  [1171] = {.lex_state = 5, .external_lex_state = 2},
  [1172] = {.lex_state = 5, .external_lex_state = 2},
  [1173] = {.lex_state = 5, .external_lex_state = 8},
  [1174] = {.lex_state = 5, .external_lex_state = 8},
  [1175] = {.lex_state = 5, .external_lex_state = 8},
  [1176] = {.lex_state = 5, .external_lex_state = 8},
  [1177] = {.lex_state = 5, .external_lex_state = 8},
  [1178] = {.lex_state = 5, .external_lex_state = 8},
  [1179] = {.lex_state = 5, .external_lex_state = 8},
  [1180] = {.lex_state = 5, .external_lex_state = 8},
  [1181] = {.lex_state = 5, .external_lex_state = 8},
  [1182] = {.lex_state = 5, .external_lex_state = 8},
  [1183] = {.lex_state = 5, .external_lex_state = 8},
  [1184] = {.lex_state = 5, .external_lex_state = 8},
  [1185] = {.lex_state = 5, .external_lex_state = 8},
  [1186] = {.lex_state = 5, .external_lex_state = 8},
  [1187] = {.lex_state = 5, .external_lex_state = 8},
  [1188] = {.lex_state = 5, .external_lex_state = 8},
  [1189] = {.lex_state = 5, .external_lex_state = 8},
  [1190] = {.lex_state = 5, .external_lex_state = 8},
  [1191] = {.lex_state = 5, .external_lex_state = 8},
  [1192] = {.lex_state = 5, .external_lex_state = 8},
  [1193] = {.lex_state = 5, .external_lex_state = 2},
  [1194] = {.lex_state = 5, .external_lex_state = 2},
  [1195] = {.lex_state = 5, .external_lex_state = 2},
  [1196] = {.lex_state = 5, .external_lex_state = 2},
  [1197] = {.lex_state = 5, .external_lex_state = 2},
  [1198] = {.lex_state = 5, .external_lex_state = 2},
  [1199] = {.lex_state = 5, .external_lex_state = 2},
  [1200] = {.lex_state = 5, .external_lex_state = 2},
  [1201] = {.lex_state = 5, .external_lex_state = 2},
  [1202] = {.lex_state = 5, .external_lex_state = 10},
  [1203] = {.lex_state = 5, .external_lex_state = 10},
  [1204] = {.lex_state = 5, .external_lex_state = 10},
  [1205] = {.lex_state = 5, .external_lex_state = 10},
  [1206] = {.lex_state = 5, .external_lex_state = 10},
  [1207] = {.lex_state = 5, .external_lex_state = 10},
  [1208] = {.lex_state = 48, .external_lex_state = 9},
  [1209] = {.lex_state = 48, .external_lex_state = 9},
  [1210] = {.lex_state = 48, .external_lex_state = 13},
  [1211] = {.lex_state = 48, .external_lex_state = 13},
  [1212] = {.lex_state = 48, .external_lex_state = 11},
  [1213] = {.lex_state = 48, .external_lex_state = 11},
  [1214] = {.lex_state = 6, .external_lex_state = 9},
  [1215] = {.lex_state = 48, .external_lex_state = 10},
  [1216] = {.lex_state = 48, .external_lex_state = 10},
  [1217] = {.lex_state = 5, .external_lex_state = 11},
  [1218] = {.lex_state = 5, .external_lex_state = 11},
  [1219] = {.lex_state = 5, .external_lex_state = 11},
  [1220] = {.lex_state = 48, .external_lex_state = 10},
  [1221] = {.lex_state = 48, .external_lex_state = 10},
  [1222] = {.lex_state = 48, .external_lex_state = 12},
  [1223] = {.lex_state = 48, .external_lex_state = 12},
  [1224] = {.lex_state = 6, .external_lex_state = 9},
  [1225] = {.lex_state = 5, .external_lex_state = 11},
  [1226] = {.lex_state = 5, .external_lex_state = 11},
  [1227] = {.lex_state = 5, .external_lex_state = 11},
  [1228] = {.lex_state = 5, .external_lex_state = 11},
  [1229] = {.lex_state = 5, .external_lex_state = 13},
  [1230] = {.lex_state = 6, .external_lex_state = 9},
  [1231] = {.lex_state = 5, .external_lex_state = 13},
  [1232] = {.lex_state = 5, .external_lex_state = 13},
  [1233] = {.lex_state = 5, .external_lex_state = 12},
  [1234] = {.lex_state = 5, .external_lex_state = 12},
  [1235] = {.lex_state = 5, .external_lex_state = 12},
  [1236] = {.lex_state = 5, .external_lex_state = 12},
  [1237] = {.lex_state = 6, .external_lex_state = 9},
  [1238] = {.lex_state = 6, .external_lex_state = 9},
  [1239] = {.lex_state = 48, .external_lex_state = 12},
  [1240] = {.lex_state = 5, .external_lex_state = 13},
  [1241] = {.lex_state = 5, .external_lex_state = 13},
  [1242] = {.lex_state = 5, .external_lex_state = 13},
  [1243] = {.lex_state = 5, .external_lex_state = 13},
  [1244] = {.lex_state = 5, .external_lex_state = 12},
  [1245] = {.lex_state = 48, .external_lex_state = 12},
  [1246] = {.lex_state = 5, .external_lex_state = 12},
  [1247] = {.lex_state = 5, .external_lex_state = 13},
  [1248] = {.lex_state = 5, .external_lex_state = 13},
  [1249] = {.lex_state = 6, .external_lex_state = 9},
  [1250] = {.lex_state = 5, .external_lex_state = 11},
  [1251] = {.lex_state = 5, .external_lex_state = 11},
  [1252] = {.lex_state = 5, .external_lex_state = 13},
  [1253] = {.lex_state = 5, .external_lex_state = 13},
  [1254] = {.lex_state = 5, .external_lex_state = 11},
  [1255] = {.lex_state = 5, .external_lex_state = 13},
  [1256] = {.lex_state = 5, .external_lex_state = 11},
  [1257] = {.lex_state = 5, .external_lex_state = 11},
  [1258] = {.lex_state = 5, .external_lex_state = 13},
  [1259] = {.lex_state = 5, .external_lex_state = 13},
  [1260] = {.lex_state = 6, .external_lex_state = 13},
  [1261] = {.lex_state = 5, .external_lex_state = 13},
  [1262] = {.lex_state = 6, .external_lex_state = 9},
  [1263] = {.lex_state = 6, .external_lex_state = 13},
  [1264] = {.lex_state = 5, .external_lex_state = 13},
  [1265] = {.lex_state = 6, .external_lex_state = 13},
  [1266] = {.lex_state = 5, .external_lex_state = 13},
  [1267] = {.lex_state = 5, .external_lex_state = 13},
  [1268] = {.lex_state = 5, .external_lex_state = 13},
  [1269] = {.lex_state = 6, .external_lex_state = 13},
  [1270] = {.lex_state = 6, .external_lex_state = 13},
  [1271] = {.lex_state = 5, .external_lex_state = 13},
  [1272] = {.lex_state = 6, .external_lex_state = 13},
  [1273] = {.lex_state = 5, .external_lex_state = 13},
  [1274] = {.lex_state = 5, .external_lex_state = 13},
  [1275] = {.lex_state = 5, .external_lex_state = 13},
  [1276] = {.lex_state = 5, .external_lex_state = 13},
  [1277] = {.lex_state = 5, .external_lex_state = 13},
  [1278] = {.lex_state = 5, .external_lex_state = 13},
  [1279] = {.lex_state = 5, .external_lex_state = 13},
  [1280] = {.lex_state = 5, .external_lex_state = 13},
  [1281] = {.lex_state = 6, .external_lex_state = 13},
  [1282] = {.lex_state = 5, .external_lex_state = 13},
  [1283] = {.lex_state = 5, .external_lex_state = 13},
  [1284] = {.lex_state = 6, .external_lex_state = 13},
  [1285] = {.lex_state = 5, .external_lex_state = 11},
  [1286] = {.lex_state = 6, .external_lex_state = 13},
  [1287] = {.lex_state = 5, .external_lex_state = 13},
  [1288] = {.lex_state = 5, .external_lex_state = 13},
  [1289] = {.lex_state = 5, .external_lex_state = 11},
  [1290] = {.lex_state = 5, .external_lex_state = 11},
  [1291] = {.lex_state = 5, .external_lex_state = 13},
  [1292] = {.lex_state = 5, .external_lex_state = 13},
  [1293] = {.lex_state = 48, .external_lex_state = 10},
  [1294] = {.lex_state = 48, .external_lex_state = 10},
  [1295] = {.lex_state = 48, .external_lex_state = 10},
  [1296] = {.lex_state = 48, .external_lex_state = 10},
  [1297] = {.lex_state = 48, .external_lex_state = 10},
  [1298] = {.lex_state = 48, .external_lex_state = 10},
  [1299] = {.lex_state = 48, .external_lex_state = 10},
  [1300] = {.lex_state = 0, .external_lex_state = 14},
  [1301] = {.lex_state = 48, .external_lex_state = 9},
  [1302] = {.lex_state = 48, .external_lex_state = 9},
  [1303] = {.lex_state = 48, .external_lex_state = 9},
  [1304] = {.lex_state = 0, .external_lex_state = 14},
  [1305] = {.lex_state = 0, .external_lex_state = 14},
  [1306] = {.lex_state = 48, .external_lex_state = 9},
  [1307] = {.lex_state = 0, .external_lex_state = 14},
  [1308] = {.lex_state = 48, .external_lex_state = 9},
  [1309] = {.lex_state = 0, .external_lex_state = 14},
  [1310] = {.lex_state = 0, .external_lex_state = 14},
  [1311] = {.lex_state = 0, .external_lex_state = 14},
  [1312] = {.lex_state = 48, .external_lex_state = 12},
  [1313] = {.lex_state = 48, .external_lex_state = 9},
  [1314] = {.lex_state = 48, .external_lex_state = 9},
  [1315] = {.lex_state = 0, .external_lex_state = 14},
  [1316] = {.lex_state = 0, .external_lex_state = 14},
  [1317] = {.lex_state = 0, .external_lex_state = 14},
  [1318] = {.lex_state = 0, .external_lex_state = 14},
  [1319] = {.lex_state = 0, .external_lex_state = 14},
  [1320] = {.lex_state = 0, .external_lex_state = 14},
  [1321] = {.lex_state = 0, .external_lex_state = 14},
  [1322] = {.lex_state = 0, .external_lex_state = 14},
  [1323] = {.lex_state = 0, .external_lex_state = 14},
  [1324] = {.lex_state = 0, .external_lex_state = 14},
  [1325] = {.lex_state = 48, .external_lex_state = 12},
  [1326] = {.lex_state = 48, .external_lex_state = 9},
  [1327] = {.lex_state = 0, .external_lex_state = 14},
  [1328] = {.lex_state = 48, .external_lex_state = 9},
  [1329] = {.lex_state = 48, .external_lex_state = 9},
  [1330] = {.lex_state = 48, .external_lex_state = 12},
  [1331] = {.lex_state = 0, .external_lex_state = 14},
  [1332] = {.lex_state = 48, .external_lex_state = 12},
  [1333] = {.lex_state = 0, .external_lex_state = 14},
  [1334] = {.lex_state = 48, .external_lex_state = 12},
  [1335] = {.lex_state = 0, .external_lex_state = 14},
  [1336] = {.lex_state = 48, .external_lex_state = 12},
  [1337] = {.lex_state = 0, .external_lex_state = 14},
  [1338] = {.lex_state = 48, .external_lex_state = 12},
  [1339] = {.lex_state = 0, .external_lex_state = 14},
  [1340] = {.lex_state = 48, .external_lex_state = 11},
  [1341] = {.lex_state = 48, .external_lex_state = 11},
  [1342] = {.lex_state = 48, .external_lex_state = 9},
  [1343] = {.lex_state = 48, .external_lex_state = 11},
  [1344] = {.lex_state = 48, .external_lex_state = 11},
  [1345] = {.lex_state = 48, .external_lex_state = 13},
  [1346] = {.lex_state = 48, .external_lex_state = 13},
  [1347] = {.lex_state = 48, .external_lex_state = 13},
  [1348] = {.lex_state = 48, .external_lex_state = 13},
  [1349] = {.lex_state = 48, .external_lex_state = 11},
  [1350] = {.lex_state = 48, .external_lex_state = 13},
  [1351] = {.lex_state = 48, .external_lex_state = 11},
  [1352] = {.lex_state = 48, .external_lex_state = 11},
  [1353] = {.lex_state = 48, .external_lex_state = 13},
  [1354] = {.lex_state = 48, .external_lex_state = 11},
  [1355] = {.lex_state = 48, .external_lex_state = 13},
  [1356] = {.lex_state = 48, .external_lex_state = 10},
  [1357] = {.lex_state = 48, .external_lex_state = 11},
  [1358] = {.lex_state = 48, .external_lex_state = 13},
  [1359] = {.lex_state = 48, .external_lex_state = 11},
  [1360] = {.lex_state = 48, .external_lex_state = 13},
  [1361] = {.lex_state = 48, .external_lex_state = 10},
  [1362] = {.lex_state = 48, .external_lex_state = 10},
  [1363] = {.lex_state = 48, .external_lex_state = 10},
  [1364] = {.lex_state = 48, .external_lex_state = 12},
  [1365] = {.lex_state = 48, .external_lex_state = 10},
  [1366] = {.lex_state = 48, .external_lex_state = 10},
  [1367] = {.lex_state = 48, .external_lex_state = 10},
  [1368] = {.lex_state = 48, .external_lex_state = 10},
  [1369] = {.lex_state = 48, .external_lex_state = 10},
  [1370] = {.lex_state = 48, .external_lex_state = 12},
  [1371] = {.lex_state = 48, .external_lex_state = 10},
  [1372] = {.lex_state = 48, .external_lex_state = 12},
  [1373] = {.lex_state = 48, .external_lex_state = 12},
  [1374] = {.lex_state = 48, .external_lex_state = 12},
  [1375] = {.lex_state = 48, .external_lex_state = 12},
  [1376] = {.lex_state = 48, .external_lex_state = 10},
  [1377] = {.lex_state = 48, .external_lex_state = 10},
  [1378] = {.lex_state = 48, .external_lex_state = 10},
  [1379] = {.lex_state = 48, .external_lex_state = 12},
  [1380] = {.lex_state = 48, .external_lex_state = 10},
  [1381] = {.lex_state = 48, .external_lex_state = 10},
  [1382] = {.lex_state = 48, .external_lex_state = 10},
  [1383] = {.lex_state = 48, .external_lex_state = 10},
  [1384] = {.lex_state = 48, .external_lex_state = 10},
  [1385] = {.lex_state = 48, .external_lex_state = 10},
  [1386] = {.lex_state = 48, .external_lex_state = 13},
  [1387] = {.lex_state = 48, .external_lex_state = 10},
  [1388] = {.lex_state = 48, .external_lex_state = 13},
  [1389] = {.lex_state = 48, .external_lex_state = 12},
  [1390] = {.lex_state = 48, .external_lex_state = 12},
  [1391] = {.lex_state = 48, .external_lex_state = 12},
  [1392] = {.lex_state = 48, .external_lex_state = 12},
  [1393] = {.lex_state = 48, .external_lex_state = 9},
  [1394] = {.lex_state = 48, .external_lex_state = 11},
  [1395] = {.lex_state = 48, .external_lex_state = 12},
  [1396] = {.lex_state = 48, .external_lex_state = 2},
  [1397] = {.lex_state = 48, .external_lex_state = 10},
  [1398] = {.lex_state = 0, .external_lex_state = 14},
  [1399] = {.lex_state = 48, .external_lex_state = 12},
  [1400] = {.lex_state = 48, .external_lex_state = 10},
  [1401] = {.lex_state = 48, .external_lex_state = 12},
  [1402] = {.lex_state = 48, .external_lex_state = 13},
  [1403] = {.lex_state = 48, .external_lex_state = 9},
  [1404] = {.lex_state = 48, .external_lex_state = 12},
  [1405] = {.lex_state = 48, .external_lex_state = 10},
  [1406] = {.lex_state = 48, .external_lex_state = 2},
  [1407] = {.lex_state = 48, .external_lex_state = 12},
  [1408] = {.lex_state = 48, .external_lex_state = 12},
  [1409] = {.lex_state = 48, .external_lex_state = 12},
  [1410] = {.lex_state = 48, .external_lex_state = 10},
  [1411] = {.lex_state = 48, .external_lex_state = 9},
  [1412] = {.lex_state = 48, .external_lex_state = 12},
  [1413] = {.lex_state = 48, .external_lex_state = 12},
  [1414] = {.lex_state = 48, .external_lex_state = 9},
  [1415] = {.lex_state = 48, .external_lex_state = 12},
  [1416] = {.lex_state = 48, .external_lex_state = 9},
  [1417] = {.lex_state = 48, .external_lex_state = 12},
  [1418] = {.lex_state = 48, .external_lex_state = 13},
  [1419] = {.lex_state = 48, .external_lex_state = 13},
  [1420] = {.lex_state = 48, .external_lex_state = 9},
  [1421] = {.lex_state = 48, .external_lex_state = 12},
  [1422] = {.lex_state = 48, .external_lex_state = 10},
  [1423] = {.lex_state = 48, .external_lex_state = 12},
  [1424] = {.lex_state = 48, .external_lex_state = 2},
  [1425] = {.lex_state = 48, .external_lex_state = 9},
  [1426] = {.lex_state = 48, .external_lex_state = 12},
  [1427] = {.lex_state = 48, .external_lex_state = 12},
  [1428] = {.lex_state = 48, .external_lex_state = 9},
  [1429] = {.lex_state = 48, .external_lex_state = 12},
  [1430] = {.lex_state = 0, .external_lex_state = 14},
  [1431] = {.lex_state = 48, .external_lex_state = 12},
  [1432] = {.lex_state = 48, .external_lex_state = 12},
  [1433] = {.lex_state = 48, .external_lex_state = 12},
  [1434] = {.lex_state = 48, .external_lex_state = 12},
  [1435] = {.lex_state = 48, .external_lex_state = 12},
  [1436] = {.lex_state = 48, .external_lex_state = 6},
  [1437] = {.lex_state = 48, .external_lex_state = 12},
  [1438] = {.lex_state = 48, .external_lex_state = 13},
  [1439] = {.lex_state = 48, .external_lex_state = 11},
  [1440] = {.lex_state = 48, .external_lex_state = 11},
  [1441] = {.lex_state = 48, .external_lex_state = 6},
  [1442] = {.lex_state = 48, .external_lex_state = 9},
  [1443] = {.lex_state = 48, .external_lex_state = 11},
  [1444] = {.lex_state = 48, .external_lex_state = 10},
  [1445] = {.lex_state = 48, .external_lex_state = 10},
  [1446] = {.lex_state = 48, .external_lex_state = 12},
  [1447] = {.lex_state = 48, .external_lex_state = 11},
  [1448] = {.lex_state = 48, .external_lex_state = 11},
  [1449] = {.lex_state = 48, .external_lex_state = 6},
  [1450] = {.lex_state = 48, .external_lex_state = 13},
  [1451] = {.lex_state = 48, .external_lex_state = 11},
  [1452] = {.lex_state = 48, .external_lex_state = 11},
  [1453] = {.lex_state = 48, .external_lex_state = 10},
  [1454] = {.lex_state = 48, .external_lex_state = 11},
  [1455] = {.lex_state = 48, .external_lex_state = 9},
  [1456] = {.lex_state = 48, .external_lex_state = 12},
  [1457] = {.lex_state = 48, .external_lex_state = 10},
  [1458] = {.lex_state = 48, .external_lex_state = 11},
  [1459] = {.lex_state = 48, .external_lex_state = 10},
  [1460] = {.lex_state = 48, .external_lex_state = 13},
  [1461] = {.lex_state = 48, .external_lex_state = 11},
  [1462] = {.lex_state = 48, .external_lex_state = 12},
  [1463] = {.lex_state = 48, .external_lex_state = 11},
  [1464] = {.lex_state = 48, .external_lex_state = 12},
  [1465] = {.lex_state = 48, .external_lex_state = 10},
  [1466] = {.lex_state = 48, .external_lex_state = 11},
  [1467] = {.lex_state = 48, .external_lex_state = 11},
  [1468] = {.lex_state = 48, .external_lex_state = 13},
  [1469] = {.lex_state = 48, .external_lex_state = 11},
  [1470] = {.lex_state = 48, .external_lex_state = 10},
  [1471] = {.lex_state = 48, .external_lex_state = 11},
  [1472] = {.lex_state = 48, .external_lex_state = 11},
  [1473] = {.lex_state = 48, .external_lex_state = 10},
  [1474] = {.lex_state = 48, .external_lex_state = 10},
  [1475] = {.lex_state = 48, .external_lex_state = 11},
  [1476] = {.lex_state = 48, .external_lex_state = 10},
  [1477] = {.lex_state = 48, .external_lex_state = 11},
  [1478] = {.lex_state = 48, .external_lex_state = 9},
  [1479] = {.lex_state = 48, .external_lex_state = 10},
  [1480] = {.lex_state = 48, .external_lex_state = 13},
  [1481] = {.lex_state = 48, .external_lex_state = 7},
  [1482] = {.lex_state = 48, .external_lex_state = 13},
  [1483] = {.lex_state = 48, .external_lex_state = 8},
  [1484] = {.lex_state = 48, .external_lex_state = 13},
  [1485] = {.lex_state = 48, .external_lex_state = 13},
  [1486] = {.lex_state = 48, .external_lex_state = 12},
  [1487] = {.lex_state = 48, .external_lex_state = 10},
  [1488] = {.lex_state = 48, .external_lex_state = 12},
  [1489] = {.lex_state = 48, .external_lex_state = 8},
  [1490] = {.lex_state = 48, .external_lex_state = 7},
  [1491] = {.lex_state = 48, .external_lex_state = 13},
  [1492] = {.lex_state = 48, .external_lex_state = 10},
  [1493] = {.lex_state = 48, .external_lex_state = 12},
  [1494] = {.lex_state = 48, .external_lex_state = 12},
  [1495] = {.lex_state = 48, .external_lex_state = 12},
  [1496] = {.lex_state = 48, .external_lex_state = 10},
  [1497] = {.lex_state = 48, .external_lex_state = 7},
  [1498] = {.lex_state = 48, .external_lex_state = 8},
  [1499] = {.lex_state = 0, .external_lex_state = 14},
  [1500] = {.lex_state = 48, .external_lex_state = 10},
  [1501] = {.lex_state = 48, .external_lex_state = 2},
  [1502] = {.lex_state = 48, .external_lex_state = 9},
  [1503] = {.lex_state = 48, .external_lex_state = 9},
  [1504] = {.lex_state = 48, .external_lex_state = 9},
  [1505] = {.lex_state = 48, .external_lex_state = 9},
  [1506] = {.lex_state = 48, .external_lex_state = 13},
  [1507] = {.lex_state = 48, .external_lex_state = 10},
  [1508] = {.lex_state = 48, .external_lex_state = 13},
  [1509] = {.lex_state = 48, .external_lex_state = 11},
  [1510] = {.lex_state = 48, .external_lex_state = 12},
  [1511] = {.lex_state = 48, .external_lex_state = 12},
  [1512] = {.lex_state = 48, .external_lex_state = 11},
  [1513] = {.lex_state = 48, .external_lex_state = 13},
  [1514] = {.lex_state = 48, .external_lex_state = 13},
  [1515] = {.lex_state = 48, .external_lex_state = 10},
  [1516] = {.lex_state = 48, .external_lex_state = 13},
  [1517] = {.lex_state = 48, .external_lex_state = 12},
  [1518] = {.lex_state = 48, .external_lex_state = 12},
  [1519] = {.lex_state = 48, .external_lex_state = 11},
  [1520] = {.lex_state = 48, .external_lex_state = 13},
  [1521] = {.lex_state = 48, .external_lex_state = 11},
  [1522] = {.lex_state = 0, .external_lex_state = 14},
  [1523] = {.lex_state = 48, .external_lex_state = 2},
  [1524] = {.lex_state = 48, .external_lex_state = 11},
  [1525] = {.lex_state = 48, .external_lex_state = 11},
  [1526] = {.lex_state = 0, .external_lex_state = 14},
  [1527] = {.lex_state = 48, .external_lex_state = 12},
  [1528] = {.lex_state = 48, .external_lex_state = 10},
  [1529] = {.lex_state = 48, .external_lex_state = 11},
  [1530] = {.lex_state = 0, .external_lex_state = 14},
  [1531] = {.lex_state = 48, .external_lex_state = 12},
  [1532] = {.lex_state = 48, .external_lex_state = 11},
  [1533] = {.lex_state = 48, .external_lex_state = 11},
  [1534] = {.lex_state = 48, .external_lex_state = 11},
  [1535] = {.lex_state = 0, .external_lex_state = 14},
  [1536] = {.lex_state = 0, .external_lex_state = 14},
  [1537] = {.lex_state = 48, .external_lex_state = 11},
  [1538] = {.lex_state = 48, .external_lex_state = 10},
  [1539] = {.lex_state = 48, .external_lex_state = 13},
  [1540] = {.lex_state = 48, .external_lex_state = 11},
  [1541] = {.lex_state = 48, .external_lex_state = 9},
  [1542] = {.lex_state = 48, .external_lex_state = 11},
  [1543] = {.lex_state = 48, .external_lex_state = 13},
  [1544] = {.lex_state = 48, .external_lex_state = 11},
  [1545] = {.lex_state = 48, .external_lex_state = 11},
  [1546] = {.lex_state = 48, .external_lex_state = 12},
  [1547] = {.lex_state = 48, .external_lex_state = 13},
  [1548] = {.lex_state = 48, .external_lex_state = 10},
  [1549] = {.lex_state = 48, .external_lex_state = 13},
  [1550] = {.lex_state = 0, .external_lex_state = 14},
  [1551] = {.lex_state = 48, .external_lex_state = 10},
  [1552] = {.lex_state = 48, .external_lex_state = 10},
  [1553] = {.lex_state = 48, .external_lex_state = 10},
  [1554] = {.lex_state = 48, .external_lex_state = 9},
  [1555] = {.lex_state = 48, .external_lex_state = 10},
  [1556] = {.lex_state = 48, .external_lex_state = 12},
  [1557] = {.lex_state = 48, .external_lex_state = 12},
  [1558] = {.lex_state = 0, .external_lex_state = 14},
  [1559] = {.lex_state = 48, .external_lex_state = 12},
  [1560] = {.lex_state = 48, .external_lex_state = 12},
  [1561] = {.lex_state = 48, .external_lex_state = 9},
  [1562] = {.lex_state = 48, .external_lex_state = 11},
  [1563] = {.lex_state = 48, .external_lex_state = 10},
  [1564] = {.lex_state = 48, .external_lex_state = 12},
  [1565] = {.lex_state = 48, .external_lex_state = 11},
  [1566] = {.lex_state = 48, .external_lex_state = 12},
  [1567] = {.lex_state = 48, .external_lex_state = 12},
  [1568] = {.lex_state = 48, .external_lex_state = 11},
  [1569] = {.lex_state = 48, .external_lex_state = 10},
  [1570] = {.lex_state = 48, .external_lex_state = 11},
  [1571] = {.lex_state = 48, .external_lex_state = 11},
  [1572] = {.lex_state = 48, .external_lex_state = 10},
  [1573] = {.lex_state = 48, .external_lex_state = 11},
  [1574] = {.lex_state = 48, .external_lex_state = 10},
  [1575] = {.lex_state = 48, .external_lex_state = 12},
  [1576] = {.lex_state = 48, .external_lex_state = 13},
  [1577] = {.lex_state = 48, .external_lex_state = 13},
  [1578] = {.lex_state = 48, .external_lex_state = 13},
  [1579] = {.lex_state = 48, .external_lex_state = 10},
  [1580] = {.lex_state = 48, .external_lex_state = 13},
  [1581] = {.lex_state = 48, .external_lex_state = 9},
  [1582] = {.lex_state = 48, .external_lex_state = 12},
  [1583] = {.lex_state = 48, .external_lex_state = 13},
  [1584] = {.lex_state = 48, .external_lex_state = 13},
  [1585] = {.lex_state = 48, .external_lex_state = 10},
  [1586] = {.lex_state = 48, .external_lex_state = 9},
  [1587] = {.lex_state = 48, .external_lex_state = 12},
  [1588] = {.lex_state = 48, .external_lex_state = 9},
  [1589] = {.lex_state = 48, .external_lex_state = 13},
  [1590] = {.lex_state = 48, .external_lex_state = 11},
  [1591] = {.lex_state = 48, .external_lex_state = 10},
  [1592] = {.lex_state = 48, .external_lex_state = 13},
  [1593] = {.lex_state = 48, .external_lex_state = 13},
  [1594] = {.lex_state = 48, .external_lex_state = 13},
  [1595] = {.lex_state = 48, .external_lex_state = 13},
  [1596] = {.lex_state = 48, .external_lex_state = 13},
  [1597] = {.lex_state = 48, .external_lex_state = 13},
  [1598] = {.lex_state = 48, .external_lex_state = 13},
  [1599] = {.lex_state = 3, .external_lex_state = 10},
  [1600] = {.lex_state = 48, .external_lex_state = 13},
  [1601] = {.lex_state = 48, .external_lex_state = 13},
  [1602] = {.lex_state = 48, .external_lex_state = 10},
  [1603] = {.lex_state = 48, .external_lex_state = 10},
  [1604] = {.lex_state = 48, .external_lex_state = 6},
  [1605] = {.lex_state = 48, .external_lex_state = 13},
  [1606] = {.lex_state = 48, .external_lex_state = 13},
  [1607] = {.lex_state = 48, .external_lex_state = 8},
  [1608] = {.lex_state = 48, .external_lex_state = 10},
  [1609] = {.lex_state = 48, .external_lex_state = 13},
  [1610] = {.lex_state = 48, .external_lex_state = 9},
  [1611] = {.lex_state = 48, .external_lex_state = 11},
  [1612] = {.lex_state = 48, .external_lex_state = 13},
  [1613] = {.lex_state = 48, .external_lex_state = 13},
  [1614] = {.lex_state = 48, .external_lex_state = 7},
  [1615] = {.lex_state = 48, .external_lex_state = 13},
  [1616] = {.lex_state = 3, .external_lex_state = 10},
  [1617] = {.lex_state = 48, .external_lex_state = 13},
  [1618] = {.lex_state = 48, .external_lex_state = 11},
  [1619] = {.lex_state = 48, .external_lex_state = 13},
  [1620] = {.lex_state = 48, .external_lex_state = 13},
  [1621] = {.lex_state = 48, .external_lex_state = 10},
  [1622] = {.lex_state = 48, .external_lex_state = 13},
  [1623] = {.lex_state = 48, .external_lex_state = 10},
  [1624] = {.lex_state = 48, .external_lex_state = 13},
  [1625] = {.lex_state = 48, .external_lex_state = 12},
  [1626] = {.lex_state = 48, .external_lex_state = 13},
  [1627] = {.lex_state = 48, .external_lex_state = 11},
  [1628] = {.lex_state = 48, .external_lex_state = 13},
  [1629] = {.lex_state = 48, .external_lex_state = 13},
  [1630] = {.lex_state = 48, .external_lex_state = 13},
  [1631] = {.lex_state = 48, .external_lex_state = 13},
  [1632] = {.lex_state = 48, .external_lex_state = 13},
  [1633] = {.lex_state = 48, .external_lex_state = 10},
  [1634] = {.lex_state = 48, .external_lex_state = 13},
  [1635] = {.lex_state = 48, .external_lex_state = 13},
  [1636] = {.lex_state = 48, .external_lex_state = 13},
  [1637] = {.lex_state = 48, .external_lex_state = 10},
  [1638] = {.lex_state = 48, .external_lex_state = 12},
  [1639] = {.lex_state = 48, .external_lex_state = 13},
  [1640] = {.lex_state = 48, .external_lex_state = 12},
  [1641] = {.lex_state = 48, .external_lex_state = 11},
  [1642] = {.lex_state = 48, .external_lex_state = 12},
  [1643] = {.lex_state = 48, .external_lex_state = 12},
  [1644] = {.lex_state = 48, .external_lex_state = 13},
  [1645] = {.lex_state = 48, .external_lex_state = 7},
  [1646] = {.lex_state = 48, .external_lex_state = 11},
  [1647] = {.lex_state = 48, .external_lex_state = 12},
  [1648] = {.lex_state = 48, .external_lex_state = 10},
  [1649] = {.lex_state = 48, .external_lex_state = 13},
  [1650] = {.lex_state = 48, .external_lex_state = 10},
  [1651] = {.lex_state = 48, .external_lex_state = 12},
  [1652] = {.lex_state = 48, .external_lex_state = 12},
  [1653] = {.lex_state = 48, .external_lex_state = 13},
  [1654] = {.lex_state = 48, .external_lex_state = 8},
  [1655] = {.lex_state = 48, .external_lex_state = 13},
  [1656] = {.lex_state = 48, .external_lex_state = 13},
  [1657] = {.lex_state = 48, .external_lex_state = 12},
  [1658] = {.lex_state = 48, .external_lex_state = 13},
  [1659] = {.lex_state = 48, .external_lex_state = 13},
  [1660] = {.lex_state = 48, .external_lex_state = 13},
  [1661] = {.lex_state = 48, .external_lex_state = 13},
  [1662] = {.lex_state = 48, .external_lex_state = 13},
  [1663] = {.lex_state = 48, .external_lex_state = 11},
  [1664] = {.lex_state = 48, .external_lex_state = 12},
  [1665] = {.lex_state = 48, .external_lex_state = 10},
  [1666] = {.lex_state = 48, .external_lex_state = 12},
  [1667] = {.lex_state = 48, .external_lex_state = 12},
  [1668] = {.lex_state = 48, .external_lex_state = 10},
  [1669] = {.lex_state = 48, .external_lex_state = 10},
  [1670] = {.lex_state = 48, .external_lex_state = 10},
  [1671] = {.lex_state = 48, .external_lex_state = 12},
  [1672] = {.lex_state = 48, .external_lex_state = 10},
  [1673] = {.lex_state = 48, .external_lex_state = 10},
  [1674] = {.lex_state = 48, .external_lex_state = 13},
  [1675] = {.lex_state = 48, .external_lex_state = 10},
  [1676] = {.lex_state = 48, .external_lex_state = 12},
  [1677] = {.lex_state = 48, .external_lex_state = 11},
  [1678] = {.lex_state = 48, .external_lex_state = 12},
  [1679] = {.lex_state = 3, .external_lex_state = 10},
  [1680] = {.lex_state = 48, .external_lex_state = 13},
  [1681] = {.lex_state = 48, .external_lex_state = 13},
  [1682] = {.lex_state = 48, .external_lex_state = 13},
  [1683] = {.lex_state = 48, .external_lex_state = 13},
  [1684] = {.lex_state = 48, .external_lex_state = 13},
  [1685] = {.lex_state = 48, .external_lex_state = 10},
  [1686] = {.lex_state = 48, .external_lex_state = 10},
  [1687] = {.lex_state = 48, .external_lex_state = 12},
  [1688] = {.lex_state = 48, .external_lex_state = 6},
  [1689] = {.lex_state = 48, .external_lex_state = 13},
  [1690] = {.lex_state = 48, .external_lex_state = 10},
  [1691] = {.lex_state = 48, .external_lex_state = 12},
  [1692] = {.lex_state = 48, .external_lex_state = 12},
  [1693] = {.lex_state = 48, .external_lex_state = 13},
  [1694] = {.lex_state = 48, .external_lex_state = 12},
  [1695] = {.lex_state = 48, .external_lex_state = 11},
  [1696] = {.lex_state = 48, .external_lex_state = 11},
  [1697] = {.lex_state = 48, .external_lex_state = 11},
  [1698] = {.lex_state = 48, .external_lex_state = 11},
  [1699] = {.lex_state = 48, .external_lex_state = 11},
  [1700] = {.lex_state = 48, .external_lex_state = 10},
  [1701] = {.lex_state = 48, .external_lex_state = 11},
  [1702] = {.lex_state = 48, .external_lex_state = 15},
  [1703] = {.lex_state = 48, .external_lex_state = 11},
  [1704] = {.lex_state = 48, .external_lex_state = 9},
  [1705] = {.lex_state = 48, .external_lex_state = 15},
  [1706] = {.lex_state = 48, .external_lex_state = 13},
  [1707] = {.lex_state = 48, .external_lex_state = 11},
  [1708] = {.lex_state = 48, .external_lex_state = 11},
  [1709] = {.lex_state = 48, .external_lex_state = 11},
  [1710] = {.lex_state = 48, .external_lex_state = 11},
  [1711] = {.lex_state = 48, .external_lex_state = 11},
  [1712] = {.lex_state = 48, .external_lex_state = 11},
  [1713] = {.lex_state = 48, .external_lex_state = 11},
  [1714] = {.lex_state = 48, .external_lex_state = 12},
  [1715] = {.lex_state = 48, .external_lex_state = 11},
  [1716] = {.lex_state = 48, .external_lex_state = 11},
  [1717] = {.lex_state = 48, .external_lex_state = 15},
  [1718] = {.lex_state = 48, .external_lex_state = 12},
  [1719] = {.lex_state = 48, .external_lex_state = 15},
  [1720] = {.lex_state = 48, .external_lex_state = 11},
  [1721] = {.lex_state = 48, .external_lex_state = 11},
  [1722] = {.lex_state = 48, .external_lex_state = 11},
  [1723] = {.lex_state = 48, .external_lex_state = 11},
  [1724] = {.lex_state = 48, .external_lex_state = 11},
  [1725] = {.lex_state = 48, .external_lex_state = 11},
  [1726] = {.lex_state = 48, .external_lex_state = 13},
  [1727] = {.lex_state = 48, .external_lex_state = 11},
  [1728] = {.lex_state = 48, .external_lex_state = 10},
  [1729] = {.lex_state = 48, .external_lex_state = 13},
  [1730] = {.lex_state = 48, .external_lex_state = 11},
  [1731] = {.lex_state = 48, .external_lex_state = 12},
  [1732] = {.lex_state = 48, .external_lex_state = 10},
  [1733] = {.lex_state = 48, .external_lex_state = 11},
  [1734] = {.lex_state = 48, .external_lex_state = 9},
  [1735] = {.lex_state = 48, .external_lex_state = 13},
  [1736] = {.lex_state = 48, .external_lex_state = 13},
  [1737] = {.lex_state = 48, .external_lex_state = 10},
  [1738] = {.lex_state = 48, .external_lex_state = 11},
  [1739] = {.lex_state = 48, .external_lex_state = 10},
  [1740] = {.lex_state = 48, .external_lex_state = 12},
  [1741] = {.lex_state = 48, .external_lex_state = 9},
  [1742] = {.lex_state = 48, .external_lex_state = 11},
  [1743] = {.lex_state = 48, .external_lex_state = 12},
  [1744] = {.lex_state = 48, .external_lex_state = 10},
  [1745] = {.lex_state = 48, .external_lex_state = 11},
  [1746] = {.lex_state = 48, .external_lex_state = 10},
  [1747] = {.lex_state = 48, .external_lex_state = 10},
  [1748] = {.lex_state = 48, .external_lex_state = 10},
  [1749] = {.lex_state = 48, .external_lex_state = 11},
  [1750] = {.lex_state = 48, .external_lex_state = 10},
  [1751] = {.lex_state = 48, .external_lex_state = 12},
  [1752] = {.lex_state = 48, .external_lex_state = 10},
  [1753] = {.lex_state = 48, .external_lex_state = 9},
  [1754] = {.lex_state = 48, .external_lex_state = 12},
  [1755] = {.lex_state = 48, .external_lex_state = 15},
  [1756] = {.lex_state = 48, .external_lex_state = 13},
  [1757] = {.lex_state = 48, .external_lex_state = 9},
  [1758] = {.lex_state = 48, .external_lex_state = 9},
  [1759] = {.lex_state = 48, .external_lex_state = 10},
  [1760] = {.lex_state = 48, .external_lex_state = 9},
  [1761] = {.lex_state = 48, .external_lex_state = 10},
  [1762] = {.lex_state = 48, .external_lex_state = 10},
  [1763] = {.lex_state = 48, .external_lex_state = 10},
  [1764] = {.lex_state = 48, .external_lex_state = 10},
  [1765] = {.lex_state = 48, .external_lex_state = 9},
  [1766] = {.lex_state = 48, .external_lex_state = 10},
  [1767] = {.lex_state = 48, .external_lex_state = 10},
  [1768] = {.lex_state = 48, .external_lex_state = 10},
  [1769] = {.lex_state = 48, .external_lex_state = 10},
  [1770] = {.lex_state = 48, .external_lex_state = 10},
  [1771] = {.lex_state = 48, .external_lex_state = 10},
  [1772] = {.lex_state = 48, .external_lex_state = 13},
  [1773] = {.lex_state = 48, .external_lex_state = 9},
  [1774] = {.lex_state = 48, .external_lex_state = 11},
  [1775] = {.lex_state = 48, .external_lex_state = 11},
  [1776] = {.lex_state = 48, .external_lex_state = 11},
  [1777] = {.lex_state = 48, .external_lex_state = 10},
  [1778] = {.lex_state = 48, .external_lex_state = 11},
  [1779] = {.lex_state = 48, .external_lex_state = 10},
  [1780] = {.lex_state = 48, .external_lex_state = 9},
  [1781] = {.lex_state = 48, .external_lex_state = 10},
  [1782] = {.lex_state = 48, .external_lex_state = 10},
  [1783] = {.lex_state = 48, .external_lex_state = 12},
  [1784] = {.lex_state = 48, .external_lex_state = 12},
  [1785] = {.lex_state = 48, .external_lex_state = 12},
  [1786] = {.lex_state = 48, .external_lex_state = 12},
  [1787] = {.lex_state = 48, .external_lex_state = 12},
  [1788] = {.lex_state = 48, .external_lex_state = 12},
  [1789] = {.lex_state = 48, .external_lex_state = 12},
  [1790] = {.lex_state = 48, .external_lex_state = 12},
  [1791] = {.lex_state = 48, .external_lex_state = 12},
  [1792] = {.lex_state = 48, .external_lex_state = 12},
  [1793] = {.lex_state = 48, .external_lex_state = 13},
  [1794] = {.lex_state = 48, .external_lex_state = 13},
  [1795] = {.lex_state = 48, .external_lex_state = 12},
  [1796] = {.lex_state = 48, .external_lex_state = 12},
  [1797] = {.lex_state = 48, .external_lex_state = 12},
  [1798] = {.lex_state = 48, .external_lex_state = 12},
  [1799] = {.lex_state = 48, .external_lex_state = 12},
  [1800] = {.lex_state = 48, .external_lex_state = 12},
  [1801] = {.lex_state = 48, .external_lex_state = 12},
  [1802] = {.lex_state = 48, .external_lex_state = 12},
  [1803] = {.lex_state = 48, .external_lex_state = 12},
  [1804] = {.lex_state = 48, .external_lex_state = 12},
  [1805] = {.lex_state = 48, .external_lex_state = 12},
  [1806] = {.lex_state = 48, .external_lex_state = 13},
  [1807] = {.lex_state = 48, .external_lex_state = 10},
  [1808] = {.lex_state = 48, .external_lex_state = 12},
  [1809] = {.lex_state = 48, .external_lex_state = 10},
  [1810] = {.lex_state = 48, .external_lex_state = 13},
  [1811] = {.lex_state = 48, .external_lex_state = 9},
  [1812] = {.lex_state = 48, .external_lex_state = 11},
  [1813] = {.lex_state = 48, .external_lex_state = 11},
  [1814] = {.lex_state = 48, .external_lex_state = 11},
  [1815] = {.lex_state = 48, .external_lex_state = 10},
  [1816] = {.lex_state = 48, .external_lex_state = 11},
  [1817] = {.lex_state = 48, .external_lex_state = 10},
  [1818] = {.lex_state = 48, .external_lex_state = 11},
  [1819] = {.lex_state = 48, .external_lex_state = 11},
  [1820] = {.lex_state = 48, .external_lex_state = 10},
  [1821] = {.lex_state = 48, .external_lex_state = 12},
  [1822] = {.lex_state = 48, .external_lex_state = 10},
  [1823] = {.lex_state = 48, .external_lex_state = 12},
  [1824] = {.lex_state = 48, .external_lex_state = 13},
  [1825] = {.lex_state = 48, .external_lex_state = 11},
  [1826] = {.lex_state = 48, .external_lex_state = 11},
  [1827] = {.lex_state = 48, .external_lex_state = 12},
  [1828] = {.lex_state = 48, .external_lex_state = 12},
  [1829] = {.lex_state = 48, .external_lex_state = 13},
  [1830] = {.lex_state = 48, .external_lex_state = 10},
  [1831] = {.lex_state = 48, .external_lex_state = 12},
  [1832] = {.lex_state = 48, .external_lex_state = 11},
  [1833] = {.lex_state = 48, .external_lex_state = 11},
  [1834] = {.lex_state = 48, .external_lex_state = 11},
  [1835] = {.lex_state = 48, .external_lex_state = 12},
  [1836] = {.lex_state = 48, .external_lex_state = 10},
  [1837] = {.lex_state = 48, .external_lex_state = 12},
  [1838] = {.lex_state = 48, .external_lex_state = 10},
  [1839] = {.lex_state = 48, .external_lex_state = 12},
  [1840] = {.lex_state = 48, .external_lex_state = 12},
  [1841] = {.lex_state = 48, .external_lex_state = 11},
  [1842] = {.lex_state = 48, .external_lex_state = 12},
  [1843] = {.lex_state = 48, .external_lex_state = 10},
  [1844] = {.lex_state = 48, .external_lex_state = 10},
  [1845] = {.lex_state = 48, .external_lex_state = 10},
  [1846] = {.lex_state = 48, .external_lex_state = 10},
  [1847] = {.lex_state = 3, .external_lex_state = 10},
  [1848] = {.lex_state = 48, .external_lex_state = 11},
  [1849] = {.lex_state = 3, .external_lex_state = 10},
  [1850] = {.lex_state = 3, .external_lex_state = 10},
  [1851] = {.lex_state = 48, .external_lex_state = 9},
  [1852] = {.lex_state = 48, .external_lex_state = 10},
  [1853] = {.lex_state = 48, .external_lex_state = 11},
  [1854] = {.lex_state = 48, .external_lex_state = 12},
  [1855] = {.lex_state = 48, .external_lex_state = 10},
  [1856] = {.lex_state = 48, .external_lex_state = 11},
  [1857] = {.lex_state = 48, .external_lex_state = 10},
  [1858] = {.lex_state = 48, .external_lex_state = 10},
  [1859] = {.lex_state = 48, .external_lex_state = 16},
  [1860] = {.lex_state = 48, .external_lex_state = 11},
  [1861] = {.lex_state = 48, .external_lex_state = 11},
  [1862] = {.lex_state = 48, .external_lex_state = 11},
  [1863] = {.lex_state = 48, .external_lex_state = 12},
  [1864] = {.lex_state = 48, .external_lex_state = 16},
  [1865] = {.lex_state = 48, .external_lex_state = 13},
  [1866] = {.lex_state = 48, .external_lex_state = 13},
  [1867] = {.lex_state = 48, .external_lex_state = 11},
  [1868] = {.lex_state = 48, .external_lex_state = 10},
  [1869] = {.lex_state = 48, .external_lex_state = 11},
  [1870] = {.lex_state = 48, .external_lex_state = 13},
  [1871] = {.lex_state = 48, .external_lex_state = 12},
  [1872] = {.lex_state = 48, .external_lex_state = 12},
  [1873] = {.lex_state = 48, .external_lex_state = 12},
  [1874] = {.lex_state = 48, .external_lex_state = 13},
  [1875] = {.lex_state = 48, .external_lex_state = 10},
  [1876] = {.lex_state = 48, .external_lex_state = 12},
  [1877] = {.lex_state = 48, .external_lex_state = 10},
  [1878] = {.lex_state = 48, .external_lex_state = 11},
  [1879] = {.lex_state = 48, .external_lex_state = 11},
  [1880] = {.lex_state = 48, .external_lex_state = 12},
  [1881] = {.lex_state = 48, .external_lex_state = 10},
  [1882] = {.lex_state = 48, .external_lex_state = 11},
  [1883] = {.lex_state = 48, .external_lex_state = 10},
  [1884] = {.lex_state = 48, .external_lex_state = 13},
  [1885] = {.lex_state = 48, .external_lex_state = 11},
  [1886] = {.lex_state = 48, .external_lex_state = 11},
  [1887] = {.lex_state = 48, .external_lex_state = 11},
  [1888] = {.lex_state = 48, .external_lex_state = 11},
  [1889] = {.lex_state = 48, .external_lex_state = 13},
  [1890] = {.lex_state = 48, .external_lex_state = 11},
  [1891] = {.lex_state = 48, .external_lex_state = 12},
  [1892] = {.lex_state = 48, .external_lex_state = 11},
  [1893] = {.lex_state = 48, .external_lex_state = 13},
  [1894] = {.lex_state = 48, .external_lex_state = 10},
  [1895] = {.lex_state = 3, .external_lex_state = 10},
  [1896] = {.lex_state = 3, .external_lex_state = 10},
  [1897] = {.lex_state = 48, .external_lex_state = 13},
  [1898] = {.lex_state = 48, .external_lex_state = 10},
  [1899] = {.lex_state = 3, .external_lex_state = 10},
  [1900] = {.lex_state = 48, .external_lex_state = 11},
  [1901] = {.lex_state = 48, .external_lex_state = 11},
  [1902] = {.lex_state = 48, .external_lex_state = 11},
  [1903] = {.lex_state = 48, .external_lex_state = 12},
  [1904] = {.lex_state = 48, .external_lex_state = 11},
  [1905] = {.lex_state = 48, .external_lex_state = 11},
  [1906] = {.lex_state = 48, .external_lex_state = 11},
  [1907] = {.lex_state = 48, .external_lex_state = 11},
  [1908] = {.lex_state = 48, .external_lex_state = 12},
  [1909] = {.lex_state = 48, .external_lex_state = 12},
  [1910] = {.lex_state = 3, .external_lex_state = 10},
  [1911] = {.lex_state = 48, .external_lex_state = 13},
  [1912] = {.lex_state = 48, .external_lex_state = 12},
  [1913] = {.lex_state = 48, .external_lex_state = 13},
  [1914] = {.lex_state = 48, .external_lex_state = 11},
  [1915] = {.lex_state = 48, .external_lex_state = 11},
  [1916] = {.lex_state = 48, .external_lex_state = 10},
  [1917] = {.lex_state = 48, .external_lex_state = 13},
  [1918] = {.lex_state = 48, .external_lex_state = 12},
  [1919] = {.lex_state = 48, .external_lex_state = 13},
  [1920] = {.lex_state = 48, .external_lex_state = 10},
  [1921] = {.lex_state = 48, .external_lex_state = 11},
  [1922] = {.lex_state = 48, .external_lex_state = 11},
  [1923] = {.lex_state = 48, .external_lex_state = 9},
  [1924] = {.lex_state = 48, .external_lex_state = 13},
  [1925] = {.lex_state = 48, .external_lex_state = 12},
  [1926] = {.lex_state = 48, .external_lex_state = 10},
  [1927] = {.lex_state = 48, .external_lex_state = 11},
  [1928] = {.lex_state = 48, .external_lex_state = 11},
  [1929] = {.lex_state = 48, .external_lex_state = 12},
  [1930] = {.lex_state = 48, .external_lex_state = 12},
  [1931] = {.lex_state = 48, .external_lex_state = 11},
  [1932] = {.lex_state = 48, .external_lex_state = 10},
  [1933] = {.lex_state = 48, .external_lex_state = 16},
  [1934] = {.lex_state = 48, .external_lex_state = 11},
  [1935] = {.lex_state = 48, .external_lex_state = 16},
  [1936] = {.lex_state = 48, .external_lex_state = 13},
  [1937] = {.lex_state = 48, .external_lex_state = 10},
  [1938] = {.lex_state = 48, .external_lex_state = 11},
  [1939] = {.lex_state = 48, .external_lex_state = 13},
  [1940] = {.lex_state = 48, .external_lex_state = 10},
  [1941] = {.lex_state = 48, .external_lex_state = 10},
  [1942] = {.lex_state = 48, .external_lex_state = 13},
  [1943] = {.lex_state = 48, .external_lex_state = 11},
  [1944] = {.lex_state = 48, .external_lex_state = 11},
  [1945] = {.lex_state = 48, .external_lex_state = 12},
  [1946] = {.lex_state = 3, .external_lex_state = 10},
  [1947] = {.lex_state = 48, .external_lex_state = 10},
  [1948] = {.lex_state = 48, .external_lex_state = 11},
  [1949] = {.lex_state = 48, .external_lex_state = 12},
  [1950] = {.lex_state = 48, .external_lex_state = 11},
  [1951] = {.lex_state = 48, .external_lex_state = 12},
  [1952] = {.lex_state = 48, .external_lex_state = 12},
  [1953] = {.lex_state = 48, .external_lex_state = 13},
  [1954] = {.lex_state = 48, .external_lex_state = 11},
  [1955] = {.lex_state = 48, .external_lex_state = 12},
  [1956] = {.lex_state = 48, .external_lex_state = 9},
  [1957] = {.lex_state = 48, .external_lex_state = 11},
  [1958] = {.lex_state = 48, .external_lex_state = 12},
  [1959] = {.lex_state = 48, .external_lex_state = 12},
  [1960] = {.lex_state = 48, .external_lex_state = 12},
  [1961] = {.lex_state = 48, .external_lex_state = 12},
  [1962] = {.lex_state = 48, .external_lex_state = 12},
  [1963] = {.lex_state = 48, .external_lex_state = 11},
  [1964] = {.lex_state = 48, .external_lex_state = 9},
  [1965] = {.lex_state = 48, .external_lex_state = 12},
  [1966] = {.lex_state = 48, .external_lex_state = 12},
  [1967] = {.lex_state = 48, .external_lex_state = 12},
  [1968] = {.lex_state = 48, .external_lex_state = 12},
  [1969] = {.lex_state = 48, .external_lex_state = 12},
  [1970] = {.lex_state = 48, .external_lex_state = 12},
  [1971] = {.lex_state = 3, .external_lex_state = 10},
  [1972] = {.lex_state = 48, .external_lex_state = 10},
  [1973] = {.lex_state = 48, .external_lex_state = 16},
  [1974] = {.lex_state = 48, .external_lex_state = 11},
  [1975] = {.lex_state = 48, .external_lex_state = 12},
  [1976] = {.lex_state = 48, .external_lex_state = 10},
  [1977] = {.lex_state = 48, .external_lex_state = 9},
  [1978] = {.lex_state = 48, .external_lex_state = 11},
  [1979] = {.lex_state = 48, .external_lex_state = 11},
  [1980] = {.lex_state = 48, .external_lex_state = 13},
  [1981] = {.lex_state = 48, .external_lex_state = 13},
  [1982] = {.lex_state = 48, .external_lex_state = 13},
  [1983] = {.lex_state = 48, .external_lex_state = 13},
  [1984] = {.lex_state = 48, .external_lex_state = 13},
  [1985] = {.lex_state = 48, .external_lex_state = 10},
  [1986] = {.lex_state = 48, .external_lex_state = 13},
  [1987] = {.lex_state = 48, .external_lex_state = 10},
  [1988] = {.lex_state = 48, .external_lex_state = 11},
  [1989] = {.lex_state = 48, .external_lex_state = 13},
  [1990] = {.lex_state = 48, .external_lex_state = 9},
  [1991] = {.lex_state = 48, .external_lex_state = 13},
  [1992] = {.lex_state = 48, .external_lex_state = 16},
  [1993] = {.lex_state = 48, .external_lex_state = 11},
  [1994] = {.lex_state = 48, .external_lex_state = 16},
  [1995] = {.lex_state = 48, .external_lex_state = 13},
  [1996] = {.lex_state = 48, .external_lex_state = 13},
  [1997] = {.lex_state = 48, .external_lex_state = 11},
  [1998] = {.lex_state = 48, .external_lex_state = 11},
  [1999] = {.lex_state = 48, .external_lex_state = 11},
  [2000] = {.lex_state = 48, .external_lex_state = 12},
  [2001] = {.lex_state = 48, .external_lex_state = 12},
  [2002] = {.lex_state = 48, .external_lex_state = 12},
  [2003] = {.lex_state = 48, .external_lex_state = 16},
  [2004] = {.lex_state = 48, .external_lex_state = 10},
  [2005] = {.lex_state = 48, .external_lex_state = 11},
  [2006] = {.lex_state = 48, .external_lex_state = 13},
  [2007] = {.lex_state = 48, .external_lex_state = 11},
  [2008] = {.lex_state = 48, .external_lex_state = 11},
  [2009] = {.lex_state = 48, .external_lex_state = 13},
  [2010] = {.lex_state = 48, .external_lex_state = 13},
  [2011] = {.lex_state = 48, .external_lex_state = 9},
  [2012] = {.lex_state = 48, .external_lex_state = 13},
  [2013] = {.lex_state = 48, .external_lex_state = 10},
  [2014] = {.lex_state = 48, .external_lex_state = 15},
  [2015] = {.lex_state = 48, .external_lex_state = 9},
  [2016] = {.lex_state = 9, .external_lex_state = 13},
  [2017] = {.lex_state = 48, .external_lex_state = 9},
  [2018] = {.lex_state = 48, .external_lex_state = 11},
  [2019] = {.lex_state = 48, .external_lex_state = 13},
  [2020] = {.lex_state = 48, .external_lex_state = 15},
  [2021] = {.lex_state = 48, .external_lex_state = 13},
  [2022] = {.lex_state = 48, .external_lex_state = 15},
  [2023] = {.lex_state = 48, .external_lex_state = 10},
  [2024] = {.lex_state = 48, .external_lex_state = 10},
  [2025] = {.lex_state = 48, .external_lex_state = 13},
  [2026] = {.lex_state = 48, .external_lex_state = 10},
  [2027] = {.lex_state = 48, .external_lex_state = 9},
  [2028] = {.lex_state = 48, .external_lex_state = 11},
  [2029] = {.lex_state = 48, .external_lex_state = 13},
  [2030] = {.lex_state = 48, .external_lex_state = 11},
  [2031] = {.lex_state = 48, .external_lex_state = 15},
  [2032] = {.lex_state = 48, .external_lex_state = 15},
  [2033] = {.lex_state = 48, .external_lex_state = 13},
  [2034] = {.lex_state = 48, .external_lex_state = 13},
  [2035] = {.lex_state = 9, .external_lex_state = 13},
  [2036] = {.lex_state = 48, .external_lex_state = 13},
  [2037] = {.lex_state = 48, .external_lex_state = 9},
  [2038] = {.lex_state = 48, .external_lex_state = 15},
  [2039] = {.lex_state = 48, .external_lex_state = 13},
  [2040] = {.lex_state = 48, .external_lex_state = 12},
  [2041] = {.lex_state = 48, .external_lex_state = 15},
  [2042] = {.lex_state = 48, .external_lex_state = 13},
  [2043] = {.lex_state = 48, .external_lex_state = 12},
  [2044] = {.lex_state = 48, .external_lex_state = 13},
  [2045] = {.lex_state = 48, .external_lex_state = 12},
  [2046] = {.lex_state = 48, .external_lex_state = 13},
  [2047] = {.lex_state = 48, .external_lex_state = 15},
  [2048] = {.lex_state = 48, .external_lex_state = 13},
  [2049] = {.lex_state = 48, .external_lex_state = 10},
  [2050] = {.lex_state = 48, .external_lex_state = 15},
  [2051] = {.lex_state = 48, .external_lex_state = 13},
  [2052] = {.lex_state = 48, .external_lex_state = 15},
  [2053] = {.lex_state = 48, .external_lex_state = 12},
  [2054] = {.lex_state = 48, .external_lex_state = 9},
  [2055] = {.lex_state = 9, .external_lex_state = 13},
  [2056] = {.lex_state = 48, .external_lex_state = 13},
  [2057] = {.lex_state = 48, .external_lex_state = 13},
  [2058] = {.lex_state = 48, .external_lex_state = 13},
  [2059] = {.lex_state = 48, .external_lex_state = 11},
  [2060] = {.lex_state = 48, .external_lex_state = 15},
  [2061] = {.lex_state = 48, .external_lex_state = 9},
  [2062] = {.lex_state = 48, .external_lex_state = 9},
  [2063] = {.lex_state = 48, .external_lex_state = 13},
  [2064] = {.lex_state = 9, .external_lex_state = 13},
  [2065] = {.lex_state = 48, .external_lex_state = 13},
  [2066] = {.lex_state = 48, .external_lex_state = 9},
  [2067] = {.lex_state = 48, .external_lex_state = 9},
  [2068] = {.lex_state = 48, .external_lex_state = 15},
  [2069] = {.lex_state = 48, .external_lex_state = 11},
  [2070] = {.lex_state = 9, .external_lex_state = 13},
  [2071] = {.lex_state = 9, .external_lex_state = 13},
  [2072] = {.lex_state = 9, .external_lex_state = 13},
  [2073] = {.lex_state = 48, .external_lex_state = 9},
  [2074] = {.lex_state = 9, .external_lex_state = 13},
  [2075] = {.lex_state = 48, .external_lex_state = 15},
  [2076] = {.lex_state = 48, .external_lex_state = 13},
  [2077] = {.lex_state = 48, .external_lex_state = 11},
  [2078] = {.lex_state = 48, .external_lex_state = 12},
  [2079] = {.lex_state = 48, .external_lex_state = 13},
  [2080] = {.lex_state = 48, .external_lex_state = 11},
  [2081] = {.lex_state = 9, .external_lex_state = 13},
  [2082] = {.lex_state = 48, .external_lex_state = 15},
  [2083] = {.lex_state = 48, .external_lex_state = 11},
  [2084] = {.lex_state = 48, .external_lex_state = 15},
  [2085] = {.lex_state = 48, .external_lex_state = 13},
  [2086] = {.lex_state = 48, .external_lex_state = 15},
  [2087] = {.lex_state = 48, .external_lex_state = 11},
  [2088] = {.lex_state = 48, .external_lex_state = 13},
  [2089] = {.lex_state = 9, .external_lex_state = 13},
  [2090] = {.lex_state = 48, .external_lex_state = 13},
  [2091] = {.lex_state = 48, .external_lex_state = 13},
  [2092] = {.lex_state = 48, .external_lex_state = 10},
  [2093] = {.lex_state = 48, .external_lex_state = 15},
  [2094] = {.lex_state = 48, .external_lex_state = 13},
  [2095] = {.lex_state = 48, .external_lex_state = 12},
  [2096] = {.lex_state = 48, .external_lex_state = 13},
  [2097] = {.lex_state = 48, .external_lex_state = 11},
  [2098] = {.lex_state = 48, .external_lex_state = 12},
  [2099] = {.lex_state = 48, .external_lex_state = 12},
  [2100] = {.lex_state = 48, .external_lex_state = 15},
  [2101] = {.lex_state = 48, .external_lex_state = 11},
  [2102] = {.lex_state = 48, .external_lex_state = 11},
  [2103] = {.lex_state = 48, .external_lex_state = 12},
  [2104] = {.lex_state = 48, .external_lex_state = 13},
  [2105] = {.lex_state = 48, .external_lex_state = 12},
  [2106] = {.lex_state = 48, .external_lex_state = 13},
  [2107] = {.lex_state = 48, .external_lex_state = 10},
  [2108] = {.lex_state = 48, .external_lex_state = 10},
  [2109] = {.lex_state = 48, .external_lex_state = 10},
  [2110] = {.lex_state = 48, .external_lex_state = 13},
  [2111] = {.lex_state = 48, .external_lex_state = 11},
  [2112] = {.lex_state = 4, .external_lex_state = 13},
  [2113] = {.lex_state = 48, .external_lex_state = 12},
  [2114] = {.lex_state = 48, .external_lex_state = 13},
  [2115] = {.lex_state = 48, .external_lex_state = 13},
  [2116] = {.lex_state = 48, .external_lex_state = 13},
  [2117] = {.lex_state = 48, .external_lex_state = 13},
  [2118] = {.lex_state = 48, .external_lex_state = 13},
  [2119] = {.lex_state = 48, .external_lex_state = 13},
  [2120] = {.lex_state = 48, .external_lex_state = 13},
  [2121] = {.lex_state = 4, .external_lex_state = 13},
  [2122] = {.lex_state = 48, .external_lex_state = 13},
  [2123] = {.lex_state = 48, .external_lex_state = 13},
  [2124] = {.lex_state = 48, .external_lex_state = 11},
  [2125] = {.lex_state = 48, .external_lex_state = 11},
  [2126] = {.lex_state = 48, .external_lex_state = 10},
  [2127] = {.lex_state = 48, .external_lex_state = 10},
  [2128] = {.lex_state = 48, .external_lex_state = 13},
  [2129] = {.lex_state = 48, .external_lex_state = 13},
  [2130] = {.lex_state = 48, .external_lex_state = 13},
  [2131] = {.lex_state = 48, .external_lex_state = 13},
  [2132] = {.lex_state = 48, .external_lex_state = 11},
  [2133] = {.lex_state = 48, .external_lex_state = 12},
  [2134] = {.lex_state = 48, .external_lex_state = 13},
  [2135] = {.lex_state = 48, .external_lex_state = 13},
  [2136] = {.lex_state = 48, .external_lex_state = 11},
  [2137] = {.lex_state = 48, .external_lex_state = 10},
  [2138] = {.lex_state = 48, .external_lex_state = 10},
  [2139] = {.lex_state = 48, .external_lex_state = 13},
  [2140] = {.lex_state = 48, .external_lex_state = 13},
  [2141] = {.lex_state = 48, .external_lex_state = 13},
  [2142] = {.lex_state = 48, .external_lex_state = 13},
  [2143] = {.lex_state = 48, .external_lex_state = 10},
  [2144] = {.lex_state = 48, .external_lex_state = 13},
  [2145] = {.lex_state = 48, .external_lex_state = 13},
  [2146] = {.lex_state = 48, .external_lex_state = 13},
  [2147] = {.lex_state = 48, .external_lex_state = 13},
  [2148] = {.lex_state = 48, .external_lex_state = 11},
  [2149] = {.lex_state = 48, .external_lex_state = 13},
  [2150] = {.lex_state = 48, .external_lex_state = 12},
  [2151] = {.lex_state = 48, .external_lex_state = 12},
  [2152] = {.lex_state = 48, .external_lex_state = 13},
  [2153] = {.lex_state = 48, .external_lex_state = 13},
  [2154] = {.lex_state = 48, .external_lex_state = 12},
  [2155] = {.lex_state = 48, .external_lex_state = 10},
  [2156] = {.lex_state = 48, .external_lex_state = 12},
  [2157] = {.lex_state = 48, .external_lex_state = 10},
  [2158] = {.lex_state = 48, .external_lex_state = 12},
  [2159] = {.lex_state = 48, .external_lex_state = 13},
  [2160] = {.lex_state = 48, .external_lex_state = 13},
  [2161] = {.lex_state = 4, .external_lex_state = 13},
  [2162] = {.lex_state = 48, .external_lex_state = 11},
  [2163] = {.lex_state = 48, .external_lex_state = 13},
  [2164] = {.lex_state = 4, .external_lex_state = 13},
  [2165] = {.lex_state = 48, .external_lex_state = 13},
  [2166] = {.lex_state = 48, .external_lex_state = 10},
  [2167] = {.lex_state = 48, .external_lex_state = 13},
  [2168] = {.lex_state = 48, .external_lex_state = 11},
  [2169] = {.lex_state = 48, .external_lex_state = 10},
  [2170] = {.lex_state = 48, .external_lex_state = 10},
  [2171] = {.lex_state = 48, .external_lex_state = 13},
  [2172] = {.lex_state = 48, .external_lex_state = 13},
  [2173] = {.lex_state = 48, .external_lex_state = 13},
  [2174] = {.lex_state = 48, .external_lex_state = 13},
  [2175] = {.lex_state = 48, .external_lex_state = 13},
  [2176] = {.lex_state = 48, .external_lex_state = 13},
  [2177] = {.lex_state = 48, .external_lex_state = 13},
  [2178] = {.lex_state = 48, .external_lex_state = 13},
  [2179] = {.lex_state = 48, .external_lex_state = 11},
  [2180] = {.lex_state = 48, .external_lex_state = 10},
  [2181] = {.lex_state = 48, .external_lex_state = 13},
  [2182] = {.lex_state = 48, .external_lex_state = 13},
  [2183] = {.lex_state = 48, .external_lex_state = 13},
  [2184] = {.lex_state = 48, .external_lex_state = 10},
  [2185] = {.lex_state = 48, .external_lex_state = 11},
  [2186] = {.lex_state = 48, .external_lex_state = 13},
  [2187] = {.lex_state = 48, .external_lex_state = 10},
  [2188] = {.lex_state = 48, .external_lex_state = 13},
  [2189] = {.lex_state = 48, .external_lex_state = 11},
  [2190] = {.lex_state = 48, .external_lex_state = 11},
  [2191] = {.lex_state = 48, .external_lex_state = 11},
  [2192] = {.lex_state = 48, .external_lex_state = 12},
  [2193] = {.lex_state = 48, .external_lex_state = 10},
  [2194] = {.lex_state = 48, .external_lex_state = 13},
  [2195] = {.lex_state = 48, .external_lex_state = 11},
  [2196] = {.lex_state = 48, .external_lex_state = 12},
  [2197] = {.lex_state = 48, .external_lex_state = 12},
  [2198] = {.lex_state = 48, .external_lex_state = 10},
  [2199] = {.lex_state = 48, .external_lex_state = 10},
  [2200] = {.lex_state = 48, .external_lex_state = 13},
  [2201] = {.lex_state = 48, .external_lex_state = 13},
  [2202] = {.lex_state = 48, .external_lex_state = 10},
  [2203] = {.lex_state = 48, .external_lex_state = 10},
  [2204] = {.lex_state = 48, .external_lex_state = 13},
  [2205] = {.lex_state = 48, .external_lex_state = 10},
  [2206] = {.lex_state = 48, .external_lex_state = 13},
  [2207] = {.lex_state = 48, .external_lex_state = 10},
  [2208] = {.lex_state = 48, .external_lex_state = 13},
  [2209] = {.lex_state = 4, .external_lex_state = 13},
  [2210] = {.lex_state = 48, .external_lex_state = 13},
  [2211] = {.lex_state = 48, .external_lex_state = 13},
  [2212] = {.lex_state = 48, .external_lex_state = 11},
  [2213] = {.lex_state = 48, .external_lex_state = 12},
  [2214] = {.lex_state = 48, .external_lex_state = 10},
  [2215] = {.lex_state = 48, .external_lex_state = 13},
  [2216] = {.lex_state = 48, .external_lex_state = 10},
  [2217] = {.lex_state = 48, .external_lex_state = 13},
  [2218] = {.lex_state = 48, .external_lex_state = 12},
  [2219] = {.lex_state = 48, .external_lex_state = 11},
  [2220] = {.lex_state = 48, .external_lex_state = 13},
  [2221] = {.lex_state = 48, .external_lex_state = 11},
  [2222] = {.lex_state = 4, .external_lex_state = 13},
  [2223] = {.lex_state = 48, .external_lex_state = 10},
  [2224] = {.lex_state = 48, .external_lex_state = 11},
  [2225] = {.lex_state = 48, .external_lex_state = 12},
  [2226] = {.lex_state = 48, .external_lex_state = 12},
  [2227] = {.lex_state = 48, .external_lex_state = 12},
  [2228] = {.lex_state = 48, .external_lex_state = 10},
  [2229] = {.lex_state = 48, .external_lex_state = 10},
  [2230] = {.lex_state = 48, .external_lex_state = 10},
  [2231] = {.lex_state = 48, .external_lex_state = 13},
  [2232] = {.lex_state = 48, .external_lex_state = 10},
  [2233] = {.lex_state = 48, .external_lex_state = 13},
  [2234] = {.lex_state = 48, .external_lex_state = 13},
  [2235] = {.lex_state = 48, .external_lex_state = 13},
  [2236] = {.lex_state = 48, .external_lex_state = 13},
  [2237] = {.lex_state = 48, .external_lex_state = 11},
  [2238] = {.lex_state = 48, .external_lex_state = 10},
  [2239] = {.lex_state = 48, .external_lex_state = 12},
  [2240] = {.lex_state = 48, .external_lex_state = 13},
  [2241] = {.lex_state = 48, .external_lex_state = 13},
  [2242] = {.lex_state = 48, .external_lex_state = 12},
  [2243] = {.lex_state = 48, .external_lex_state = 10},
  [2244] = {.lex_state = 48, .external_lex_state = 13},
  [2245] = {.lex_state = 48, .external_lex_state = 13},
  [2246] = {.lex_state = 48, .external_lex_state = 10},
  [2247] = {.lex_state = 48, .external_lex_state = 11},
  [2248] = {.lex_state = 4, .external_lex_state = 13},
  [2249] = {.lex_state = 48, .external_lex_state = 13},
  [2250] = {.lex_state = 48, .external_lex_state = 13},
  [2251] = {.lex_state = 48, .external_lex_state = 10},
  [2252] = {.lex_state = 48, .external_lex_state = 13},
  [2253] = {.lex_state = 48, .external_lex_state = 13},
  [2254] = {.lex_state = 48, .external_lex_state = 10},
  [2255] = {.lex_state = 48, .external_lex_state = 13},
  [2256] = {.lex_state = 48, .external_lex_state = 13},
  [2257] = {.lex_state = 48, .external_lex_state = 10},
  [2258] = {.lex_state = 48, .external_lex_state = 13},
  [2259] = {.lex_state = 48, .external_lex_state = 13},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_print] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_eq] = ACTIONS(1),
    [anon_sym_ne] = ACTIONS(1),
    [anon_sym_contains] = ACTIONS(1),
    [anon_sym_fails] = ACTIONS(1),
    [anon_sym_assert_] = ACTIONS(1),
    [anon_sym_assert_eq] = ACTIONS(1),
    [anon_sym_assert_ne] = ACTIONS(1),
    [anon_sym_assert_contains] = ACTIONS(1),
    [anon_sym_assert_fails] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_del] = ACTIONS(1),
    [anon_sym_pass] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_def] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_exec] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_lambda] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_AT_EQ] = ACTIONS(1),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [sym_ellipsis] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [sym_type_conversion] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_none] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(5),
    [anon_sym_except] = ACTIONS(1),
    [sym__newline] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym_string_start] = ACTIONS(1),
    [sym__string_content] = ACTIONS(1),
    [sym_escape_interpolation] = ACTIONS(1),
    [sym_string_end] = ACTIONS(1),
  },
  [1] = {
    [sym_module] = STATE(2231),
    [sym__statement] = STATE(43),
    [sym__simple_statements] = STATE(43),
    [sym_print_statement] = STATE(1964),
    [sym_assert_statement] = STATE(1964),
    [sym_expression_statement] = STATE(1964),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1964),
    [sym_delete_statement] = STATE(1964),
    [sym_pass_statement] = STATE(1964),
    [sym_break_statement] = STATE(1964),
    [sym_continue_statement] = STATE(1964),
    [sym_if_statement] = STATE(43),
    [sym_match_statement] = STATE(43),
    [sym_for_statement] = STATE(43),
    [sym_while_statement] = STATE(43),
    [sym_with_statement] = STATE(43),
    [sym_function_definition] = STATE(43),
    [sym_exec_statement] = STATE(1964),
    [sym_decorated_definition] = STATE(43),
    [sym_decorator] = STATE(1506),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(43),
    [aux_sym_decorated_definition_repeat1] = STATE(1506),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_match] = ACTIONS(29),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_while] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(41),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(67),
  },
  [2] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(45),
    [sym_match_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(567),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(83),
    [sym_string_start] = ACTIONS(67),
  },
  [3] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(44),
    [sym_match_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(512),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(85),
    [sym_string_start] = ACTIONS(67),
  },
  [4] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(44),
    [sym_match_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(532),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(85),
    [sym_string_start] = ACTIONS(67),
  },
  [5] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(44),
    [sym_match_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(538),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(85),
    [sym_string_start] = ACTIONS(67),
  },
  [6] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(44),
    [sym_match_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(551),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(85),
    [sym_string_start] = ACTIONS(67),
  },
  [7] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(44),
    [sym_match_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(494),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(85),
    [sym_string_start] = ACTIONS(67),
  },
  [8] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(44),
    [sym_match_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(560),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(85),
    [sym_string_start] = ACTIONS(67),
  },
  [9] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(44),
    [sym_match_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(566),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(85),
    [sym_string_start] = ACTIONS(67),
  },
  [10] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(44),
    [sym_match_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(499),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(85),
    [sym_string_start] = ACTIONS(67),
  },
  [11] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(44),
    [sym_match_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(572),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(85),
    [sym_string_start] = ACTIONS(67),
  },
  [12] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(44),
    [sym_match_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(576),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(85),
    [sym_string_start] = ACTIONS(67),
  },
  [13] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(44),
    [sym_match_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(501),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(85),
    [sym_string_start] = ACTIONS(67),
  },
  [14] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(41),
    [sym_match_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(2020),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(87),
    [sym_string_start] = ACTIONS(67),
  },
  [15] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(44),
    [sym_match_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(582),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(85),
    [sym_string_start] = ACTIONS(67),
  },
  [16] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(44),
    [sym_match_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(584),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(85),
    [sym_string_start] = ACTIONS(67),
  },
  [17] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(41),
    [sym_match_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(2014),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(87),
    [sym_string_start] = ACTIONS(67),
  },
  [18] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(44),
    [sym_match_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(486),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(85),
    [sym_string_start] = ACTIONS(67),
  },
  [19] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(44),
    [sym_match_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(587),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(85),
    [sym_string_start] = ACTIONS(67),
  },
  [20] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(41),
    [sym_match_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(2047),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(87),
    [sym_string_start] = ACTIONS(67),
  },
  [21] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(41),
    [sym_match_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(2068),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(87),
    [sym_string_start] = ACTIONS(67),
  },
  [22] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(41),
    [sym_match_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(2100),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(87),
    [sym_string_start] = ACTIONS(67),
  },
  [23] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(45),
    [sym_match_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(564),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(83),
    [sym_string_start] = ACTIONS(67),
  },
  [24] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(45),
    [sym_match_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(578),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(83),
    [sym_string_start] = ACTIONS(67),
  },
  [25] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(45),
    [sym_match_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(591),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(83),
    [sym_string_start] = ACTIONS(67),
  },
  [26] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(45),
    [sym_match_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(477),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(83),
    [sym_string_start] = ACTIONS(67),
  },
  [27] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(45),
    [sym_match_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(553),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(83),
    [sym_string_start] = ACTIONS(67),
  },
  [28] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(45),
    [sym_match_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(519),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(83),
    [sym_string_start] = ACTIONS(67),
  },
  [29] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(45),
    [sym_match_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(480),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(83),
    [sym_string_start] = ACTIONS(67),
  },
  [30] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(45),
    [sym_match_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(508),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(83),
    [sym_string_start] = ACTIONS(67),
  },
  [31] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(45),
    [sym_match_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(516),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(83),
    [sym_string_start] = ACTIONS(67),
  },
  [32] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(45),
    [sym_match_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(482),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(83),
    [sym_string_start] = ACTIONS(67),
  },
  [33] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(45),
    [sym_match_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(548),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(83),
    [sym_string_start] = ACTIONS(67),
  },
  [34] = {
    [sym__statement] = STATE(44),
    [sym__simple_statements] = STATE(44),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(44),
    [sym_match_statement] = STATE(44),
    [sym_for_statement] = STATE(44),
    [sym_while_statement] = STATE(44),
    [sym_with_statement] = STATE(44),
    [sym_function_definition] = STATE(44),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(44),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(446),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(44),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(85),
    [sym_string_start] = ACTIONS(67),
  },
  [35] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(45),
    [sym_match_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(585),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(83),
    [sym_string_start] = ACTIONS(67),
  },
  [36] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(45),
    [sym_match_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(447),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(83),
    [sym_string_start] = ACTIONS(67),
  },
  [37] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(45),
    [sym_match_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(492),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(83),
    [sym_string_start] = ACTIONS(67),
  },
  [38] = {
    [sym__statement] = STATE(45),
    [sym__simple_statements] = STATE(45),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(45),
    [sym_match_statement] = STATE(45),
    [sym_for_statement] = STATE(45),
    [sym_while_statement] = STATE(45),
    [sym_with_statement] = STATE(45),
    [sym_function_definition] = STATE(45),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(45),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(542),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(45),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(83),
    [sym_string_start] = ACTIONS(67),
  },
  [39] = {
    [sym__statement] = STATE(41),
    [sym__simple_statements] = STATE(41),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(41),
    [sym_match_statement] = STATE(41),
    [sym_for_statement] = STATE(41),
    [sym_while_statement] = STATE(41),
    [sym_with_statement] = STATE(41),
    [sym_function_definition] = STATE(41),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(41),
    [sym_decorator] = STATE(1516),
    [sym_block] = STATE(2084),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(41),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(87),
    [sym_string_start] = ACTIONS(67),
  },
  [40] = {
    [sym__statement] = STATE(40),
    [sym__simple_statements] = STATE(40),
    [sym_print_statement] = STATE(1964),
    [sym_assert_statement] = STATE(1964),
    [sym_expression_statement] = STATE(1964),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1964),
    [sym_delete_statement] = STATE(1964),
    [sym_pass_statement] = STATE(1964),
    [sym_break_statement] = STATE(1964),
    [sym_continue_statement] = STATE(1964),
    [sym_if_statement] = STATE(40),
    [sym_match_statement] = STATE(40),
    [sym_for_statement] = STATE(40),
    [sym_while_statement] = STATE(40),
    [sym_with_statement] = STATE(40),
    [sym_function_definition] = STATE(40),
    [sym_exec_statement] = STATE(1964),
    [sym_decorated_definition] = STATE(40),
    [sym_decorator] = STATE(1506),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(40),
    [aux_sym_decorated_definition_repeat1] = STATE(1506),
    [ts_builtin_sym_end] = ACTIONS(89),
    [sym_identifier] = ACTIONS(91),
    [anon_sym_print] = ACTIONS(94),
    [anon_sym_assert] = ACTIONS(97),
    [anon_sym_assert_] = ACTIONS(100),
    [anon_sym_assert_eq] = ACTIONS(100),
    [anon_sym_assert_ne] = ACTIONS(100),
    [anon_sym_assert_contains] = ACTIONS(100),
    [anon_sym_assert_fails] = ACTIONS(100),
    [anon_sym_return] = ACTIONS(103),
    [anon_sym_del] = ACTIONS(106),
    [anon_sym_pass] = ACTIONS(109),
    [anon_sym_break] = ACTIONS(112),
    [anon_sym_continue] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(118),
    [anon_sym_match] = ACTIONS(121),
    [anon_sym_async] = ACTIONS(124),
    [anon_sym_for] = ACTIONS(127),
    [anon_sym_while] = ACTIONS(130),
    [anon_sym_with] = ACTIONS(133),
    [anon_sym_LPAREN] = ACTIONS(136),
    [anon_sym_def] = ACTIONS(139),
    [anon_sym_STAR] = ACTIONS(142),
    [anon_sym_exec] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(148),
    [anon_sym_AT] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(154),
    [anon_sym_LBRACE] = ACTIONS(157),
    [anon_sym_PLUS] = ACTIONS(154),
    [anon_sym_not] = ACTIONS(160),
    [anon_sym_TILDE] = ACTIONS(154),
    [anon_sym_lambda] = ACTIONS(163),
    [sym_ellipsis] = ACTIONS(166),
    [sym_integer] = ACTIONS(169),
    [sym_float] = ACTIONS(166),
    [anon_sym_await] = ACTIONS(172),
    [anon_sym_struct] = ACTIONS(172),
    [anon_sym_type] = ACTIONS(175),
    [sym_true] = ACTIONS(169),
    [sym_false] = ACTIONS(169),
    [sym_none] = ACTIONS(169),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(178),
  },
  [41] = {
    [sym__statement] = STATE(42),
    [sym__simple_statements] = STATE(42),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(42),
    [sym_match_statement] = STATE(42),
    [sym_for_statement] = STATE(42),
    [sym_while_statement] = STATE(42),
    [sym_with_statement] = STATE(42),
    [sym_function_definition] = STATE(42),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(42),
    [sym_decorator] = STATE(1516),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(42),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(181),
    [sym_string_start] = ACTIONS(67),
  },
  [42] = {
    [sym__statement] = STATE(42),
    [sym__simple_statements] = STATE(42),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(42),
    [sym_match_statement] = STATE(42),
    [sym_for_statement] = STATE(42),
    [sym_while_statement] = STATE(42),
    [sym_with_statement] = STATE(42),
    [sym_function_definition] = STATE(42),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(42),
    [sym_decorator] = STATE(1516),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(42),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(91),
    [anon_sym_print] = ACTIONS(94),
    [anon_sym_assert] = ACTIONS(97),
    [anon_sym_assert_] = ACTIONS(100),
    [anon_sym_assert_eq] = ACTIONS(100),
    [anon_sym_assert_ne] = ACTIONS(100),
    [anon_sym_assert_contains] = ACTIONS(100),
    [anon_sym_assert_fails] = ACTIONS(100),
    [anon_sym_return] = ACTIONS(103),
    [anon_sym_del] = ACTIONS(106),
    [anon_sym_pass] = ACTIONS(109),
    [anon_sym_break] = ACTIONS(112),
    [anon_sym_continue] = ACTIONS(115),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_match] = ACTIONS(186),
    [anon_sym_async] = ACTIONS(189),
    [anon_sym_for] = ACTIONS(192),
    [anon_sym_while] = ACTIONS(195),
    [anon_sym_with] = ACTIONS(198),
    [anon_sym_LPAREN] = ACTIONS(136),
    [anon_sym_def] = ACTIONS(201),
    [anon_sym_STAR] = ACTIONS(142),
    [anon_sym_exec] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(148),
    [anon_sym_AT] = ACTIONS(151),
    [anon_sym_DASH] = ACTIONS(154),
    [anon_sym_LBRACE] = ACTIONS(157),
    [anon_sym_PLUS] = ACTIONS(154),
    [anon_sym_not] = ACTIONS(160),
    [anon_sym_TILDE] = ACTIONS(154),
    [anon_sym_lambda] = ACTIONS(163),
    [sym_ellipsis] = ACTIONS(166),
    [sym_integer] = ACTIONS(169),
    [sym_float] = ACTIONS(166),
    [anon_sym_await] = ACTIONS(172),
    [anon_sym_struct] = ACTIONS(172),
    [anon_sym_type] = ACTIONS(175),
    [sym_true] = ACTIONS(169),
    [sym_false] = ACTIONS(169),
    [sym_none] = ACTIONS(169),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(89),
    [sym_string_start] = ACTIONS(178),
  },
  [43] = {
    [sym__statement] = STATE(40),
    [sym__simple_statements] = STATE(40),
    [sym_print_statement] = STATE(1964),
    [sym_assert_statement] = STATE(1964),
    [sym_expression_statement] = STATE(1964),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1964),
    [sym_delete_statement] = STATE(1964),
    [sym_pass_statement] = STATE(1964),
    [sym_break_statement] = STATE(1964),
    [sym_continue_statement] = STATE(1964),
    [sym_if_statement] = STATE(40),
    [sym_match_statement] = STATE(40),
    [sym_for_statement] = STATE(40),
    [sym_while_statement] = STATE(40),
    [sym_with_statement] = STATE(40),
    [sym_function_definition] = STATE(40),
    [sym_exec_statement] = STATE(1964),
    [sym_decorated_definition] = STATE(40),
    [sym_decorator] = STATE(1506),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(40),
    [aux_sym_decorated_definition_repeat1] = STATE(1506),
    [ts_builtin_sym_end] = ACTIONS(204),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_match] = ACTIONS(29),
    [anon_sym_async] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_while] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(41),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(67),
  },
  [44] = {
    [sym__statement] = STATE(42),
    [sym__simple_statements] = STATE(42),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(42),
    [sym_match_statement] = STATE(42),
    [sym_for_statement] = STATE(42),
    [sym_while_statement] = STATE(42),
    [sym_with_statement] = STATE(42),
    [sym_function_definition] = STATE(42),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(42),
    [sym_decorator] = STATE(1516),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(42),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(206),
    [sym_string_start] = ACTIONS(67),
  },
  [45] = {
    [sym__statement] = STATE(42),
    [sym__simple_statements] = STATE(42),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_if_statement] = STATE(42),
    [sym_match_statement] = STATE(42),
    [sym_for_statement] = STATE(42),
    [sym_while_statement] = STATE(42),
    [sym_with_statement] = STATE(42),
    [sym_function_definition] = STATE(42),
    [sym_exec_statement] = STATE(1977),
    [sym_decorated_definition] = STATE(42),
    [sym_decorator] = STATE(1516),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [aux_sym_module_repeat1] = STATE(42),
    [aux_sym_decorated_definition_repeat1] = STATE(1516),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(69),
    [anon_sym_match] = ACTIONS(71),
    [anon_sym_async] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_with] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_def] = ACTIONS(81),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__dedent] = ACTIONS(208),
    [sym_string_start] = ACTIONS(67),
  },
  [46] = {
    [sym_chevron] = STATE(1765),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_list_splat_pattern] = STATE(862),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1403),
    [sym_primary_expression] = STATE(705),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_attribute] = STATE(789),
    [sym_subscript] = STATE(789),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(210),
    [anon_sym_SEMI] = ACTIONS(212),
    [anon_sym_print] = ACTIONS(214),
    [anon_sym_COMMA] = ACTIONS(216),
    [anon_sym_GT_GT] = ACTIONS(219),
    [anon_sym_DOT] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(223),
    [anon_sym_if] = ACTIONS(221),
    [anon_sym_COLON] = ACTIONS(225),
    [anon_sym_match] = ACTIONS(214),
    [anon_sym_async] = ACTIONS(214),
    [anon_sym_in] = ACTIONS(221),
    [anon_sym_LPAREN] = ACTIONS(228),
    [anon_sym_STAR] = ACTIONS(231),
    [anon_sym_STAR_STAR] = ACTIONS(221),
    [anon_sym_exec] = ACTIONS(214),
    [anon_sym_LBRACK] = ACTIONS(234),
    [anon_sym_AT] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(237),
    [anon_sym_as] = ACTIONS(221),
    [anon_sym_PIPE] = ACTIONS(221),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_EQ] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(237),
    [anon_sym_not] = ACTIONS(242),
    [anon_sym_and] = ACTIONS(221),
    [anon_sym_or] = ACTIONS(221),
    [anon_sym_SLASH] = ACTIONS(221),
    [anon_sym_PERCENT] = ACTIONS(221),
    [anon_sym_SLASH_SLASH] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [anon_sym_CARET] = ACTIONS(221),
    [anon_sym_LT_LT] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(221),
    [anon_sym_LT_EQ] = ACTIONS(212),
    [anon_sym_EQ_EQ] = ACTIONS(212),
    [anon_sym_BANG_EQ] = ACTIONS(212),
    [anon_sym_GT_EQ] = ACTIONS(212),
    [anon_sym_GT] = ACTIONS(221),
    [anon_sym_LT_GT] = ACTIONS(212),
    [anon_sym_lambda] = ACTIONS(57),
    [anon_sym_PLUS_EQ] = ACTIONS(245),
    [anon_sym_DASH_EQ] = ACTIONS(245),
    [anon_sym_STAR_EQ] = ACTIONS(245),
    [anon_sym_SLASH_EQ] = ACTIONS(245),
    [anon_sym_AT_EQ] = ACTIONS(245),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(245),
    [anon_sym_PERCENT_EQ] = ACTIONS(245),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(245),
    [anon_sym_GT_GT_EQ] = ACTIONS(245),
    [anon_sym_LT_LT_EQ] = ACTIONS(245),
    [anon_sym_AMP_EQ] = ACTIONS(245),
    [anon_sym_CARET_EQ] = ACTIONS(245),
    [anon_sym_PIPE_EQ] = ACTIONS(245),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(214),
    [anon_sym_struct] = ACTIONS(214),
    [anon_sym_type] = ACTIONS(247),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(212),
    [sym_string_start] = ACTIONS(67),
  },
  [47] = {
    [sym_chevron] = STATE(1765),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_list_splat_pattern] = STATE(862),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1403),
    [sym_primary_expression] = STATE(705),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_attribute] = STATE(789),
    [sym_subscript] = STATE(789),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(210),
    [anon_sym_SEMI] = ACTIONS(212),
    [anon_sym_print] = ACTIONS(214),
    [anon_sym_COMMA] = ACTIONS(216),
    [anon_sym_GT_GT] = ACTIONS(219),
    [anon_sym_DOT] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(223),
    [anon_sym_if] = ACTIONS(221),
    [anon_sym_COLON] = ACTIONS(240),
    [anon_sym_match] = ACTIONS(214),
    [anon_sym_async] = ACTIONS(214),
    [anon_sym_in] = ACTIONS(221),
    [anon_sym_LPAREN] = ACTIONS(228),
    [anon_sym_STAR] = ACTIONS(231),
    [anon_sym_STAR_STAR] = ACTIONS(221),
    [anon_sym_exec] = ACTIONS(214),
    [anon_sym_LBRACK] = ACTIONS(234),
    [anon_sym_AT] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(237),
    [anon_sym_as] = ACTIONS(221),
    [anon_sym_PIPE] = ACTIONS(221),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_EQ] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(237),
    [anon_sym_not] = ACTIONS(242),
    [anon_sym_and] = ACTIONS(221),
    [anon_sym_or] = ACTIONS(221),
    [anon_sym_SLASH] = ACTIONS(221),
    [anon_sym_PERCENT] = ACTIONS(221),
    [anon_sym_SLASH_SLASH] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [anon_sym_CARET] = ACTIONS(221),
    [anon_sym_LT_LT] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(221),
    [anon_sym_LT_EQ] = ACTIONS(212),
    [anon_sym_EQ_EQ] = ACTIONS(212),
    [anon_sym_BANG_EQ] = ACTIONS(212),
    [anon_sym_GT_EQ] = ACTIONS(212),
    [anon_sym_GT] = ACTIONS(221),
    [anon_sym_LT_GT] = ACTIONS(212),
    [anon_sym_lambda] = ACTIONS(57),
    [anon_sym_PLUS_EQ] = ACTIONS(245),
    [anon_sym_DASH_EQ] = ACTIONS(245),
    [anon_sym_STAR_EQ] = ACTIONS(245),
    [anon_sym_SLASH_EQ] = ACTIONS(245),
    [anon_sym_AT_EQ] = ACTIONS(245),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(245),
    [anon_sym_PERCENT_EQ] = ACTIONS(245),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(245),
    [anon_sym_GT_GT_EQ] = ACTIONS(245),
    [anon_sym_LT_LT_EQ] = ACTIONS(245),
    [anon_sym_AMP_EQ] = ACTIONS(245),
    [anon_sym_CARET_EQ] = ACTIONS(245),
    [anon_sym_PIPE_EQ] = ACTIONS(245),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(214),
    [anon_sym_struct] = ACTIONS(214),
    [anon_sym_type] = ACTIONS(247),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(212),
    [sym_string_start] = ACTIONS(67),
  },
  [48] = {
    [sym_named_expression] = STATE(1358),
    [sym__named_expression_lhs] = STATE(2164),
    [sym_list_splat_pattern] = STATE(1046),
    [sym_as_pattern] = STATE(1358),
    [sym_expression] = STATE(1468),
    [sym_primary_expression] = STATE(750),
    [sym_not_operator] = STATE(1358),
    [sym_boolean_operator] = STATE(1358),
    [sym_binary_operator] = STATE(1036),
    [sym_unary_operator] = STATE(1036),
    [sym_comparison_operator] = STATE(1358),
    [sym_lambda] = STATE(1358),
    [sym_attribute] = STATE(1036),
    [sym_subscript] = STATE(1036),
    [sym_call] = STATE(1036),
    [sym_list] = STATE(1036),
    [sym_set] = STATE(1036),
    [sym_tuple] = STATE(1036),
    [sym_dictionary] = STATE(1036),
    [sym_list_comprehension] = STATE(1036),
    [sym_dictionary_comprehension] = STATE(1036),
    [sym_set_comprehension] = STATE(1036),
    [sym_parenthesized_expression] = STATE(1036),
    [sym_conditional_expression] = STATE(1358),
    [sym_string] = STATE(1036),
    [sym_identifier] = ACTIONS(249),
    [anon_sym_SEMI] = ACTIONS(212),
    [anon_sym_print] = ACTIONS(251),
    [anon_sym_COMMA] = ACTIONS(216),
    [anon_sym_GT_GT] = ACTIONS(221),
    [anon_sym_DOT] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(223),
    [anon_sym_if] = ACTIONS(221),
    [anon_sym_COLON] = ACTIONS(240),
    [anon_sym_match] = ACTIONS(251),
    [anon_sym_async] = ACTIONS(251),
    [anon_sym_in] = ACTIONS(221),
    [anon_sym_LPAREN] = ACTIONS(253),
    [anon_sym_STAR] = ACTIONS(255),
    [anon_sym_STAR_STAR] = ACTIONS(221),
    [anon_sym_exec] = ACTIONS(251),
    [anon_sym_LBRACK] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(259),
    [anon_sym_as] = ACTIONS(221),
    [anon_sym_PIPE] = ACTIONS(221),
    [anon_sym_LBRACE] = ACTIONS(261),
    [anon_sym_EQ] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(259),
    [anon_sym_not] = ACTIONS(263),
    [anon_sym_and] = ACTIONS(221),
    [anon_sym_or] = ACTIONS(221),
    [anon_sym_SLASH] = ACTIONS(221),
    [anon_sym_PERCENT] = ACTIONS(221),
    [anon_sym_SLASH_SLASH] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [anon_sym_CARET] = ACTIONS(221),
    [anon_sym_LT_LT] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(265),
    [anon_sym_LT] = ACTIONS(221),
    [anon_sym_LT_EQ] = ACTIONS(212),
    [anon_sym_EQ_EQ] = ACTIONS(212),
    [anon_sym_BANG_EQ] = ACTIONS(212),
    [anon_sym_GT_EQ] = ACTIONS(212),
    [anon_sym_GT] = ACTIONS(221),
    [anon_sym_LT_GT] = ACTIONS(212),
    [anon_sym_lambda] = ACTIONS(267),
    [anon_sym_PLUS_EQ] = ACTIONS(245),
    [anon_sym_DASH_EQ] = ACTIONS(245),
    [anon_sym_STAR_EQ] = ACTIONS(245),
    [anon_sym_SLASH_EQ] = ACTIONS(245),
    [anon_sym_AT_EQ] = ACTIONS(245),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(245),
    [anon_sym_PERCENT_EQ] = ACTIONS(245),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(245),
    [anon_sym_GT_GT_EQ] = ACTIONS(245),
    [anon_sym_LT_LT_EQ] = ACTIONS(245),
    [anon_sym_AMP_EQ] = ACTIONS(245),
    [anon_sym_CARET_EQ] = ACTIONS(245),
    [anon_sym_PIPE_EQ] = ACTIONS(245),
    [sym_ellipsis] = ACTIONS(269),
    [sym_integer] = ACTIONS(271),
    [sym_float] = ACTIONS(269),
    [anon_sym_await] = ACTIONS(251),
    [anon_sym_struct] = ACTIONS(251),
    [anon_sym_type] = ACTIONS(273),
    [sym_true] = ACTIONS(271),
    [sym_false] = ACTIONS(271),
    [sym_none] = ACTIONS(271),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(212),
    [sym_string_start] = ACTIONS(275),
  },
  [49] = {
    [sym_named_expression] = STATE(1358),
    [sym__named_expression_lhs] = STATE(2164),
    [sym_list_splat_pattern] = STATE(1046),
    [sym_as_pattern] = STATE(1358),
    [sym_expression] = STATE(1482),
    [sym_primary_expression] = STATE(750),
    [sym_not_operator] = STATE(1358),
    [sym_boolean_operator] = STATE(1358),
    [sym_binary_operator] = STATE(1036),
    [sym_unary_operator] = STATE(1036),
    [sym_comparison_operator] = STATE(1358),
    [sym_lambda] = STATE(1358),
    [sym_attribute] = STATE(1036),
    [sym_subscript] = STATE(1036),
    [sym_call] = STATE(1036),
    [sym_list] = STATE(1036),
    [sym_set] = STATE(1036),
    [sym_tuple] = STATE(1036),
    [sym_dictionary] = STATE(1036),
    [sym_list_comprehension] = STATE(1036),
    [sym_dictionary_comprehension] = STATE(1036),
    [sym_set_comprehension] = STATE(1036),
    [sym_parenthesized_expression] = STATE(1036),
    [sym_conditional_expression] = STATE(1358),
    [sym_string] = STATE(1036),
    [sym_identifier] = ACTIONS(249),
    [anon_sym_SEMI] = ACTIONS(212),
    [anon_sym_print] = ACTIONS(251),
    [anon_sym_COMMA] = ACTIONS(216),
    [anon_sym_GT_GT] = ACTIONS(221),
    [anon_sym_DOT] = ACTIONS(221),
    [anon_sym_COLON_EQ] = ACTIONS(223),
    [anon_sym_if] = ACTIONS(221),
    [anon_sym_COLON] = ACTIONS(240),
    [anon_sym_match] = ACTIONS(251),
    [anon_sym_async] = ACTIONS(251),
    [anon_sym_in] = ACTIONS(221),
    [anon_sym_LPAREN] = ACTIONS(253),
    [anon_sym_STAR] = ACTIONS(255),
    [anon_sym_STAR_STAR] = ACTIONS(221),
    [anon_sym_exec] = ACTIONS(251),
    [anon_sym_LBRACK] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(221),
    [anon_sym_DASH] = ACTIONS(259),
    [anon_sym_as] = ACTIONS(221),
    [anon_sym_PIPE] = ACTIONS(221),
    [anon_sym_LBRACE] = ACTIONS(261),
    [anon_sym_EQ] = ACTIONS(240),
    [anon_sym_PLUS] = ACTIONS(259),
    [anon_sym_not] = ACTIONS(263),
    [anon_sym_and] = ACTIONS(221),
    [anon_sym_or] = ACTIONS(221),
    [anon_sym_SLASH] = ACTIONS(221),
    [anon_sym_PERCENT] = ACTIONS(221),
    [anon_sym_SLASH_SLASH] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(221),
    [anon_sym_CARET] = ACTIONS(221),
    [anon_sym_LT_LT] = ACTIONS(221),
    [anon_sym_TILDE] = ACTIONS(265),
    [anon_sym_LT] = ACTIONS(221),
    [anon_sym_LT_EQ] = ACTIONS(212),
    [anon_sym_EQ_EQ] = ACTIONS(212),
    [anon_sym_BANG_EQ] = ACTIONS(212),
    [anon_sym_GT_EQ] = ACTIONS(212),
    [anon_sym_GT] = ACTIONS(221),
    [anon_sym_LT_GT] = ACTIONS(212),
    [anon_sym_lambda] = ACTIONS(267),
    [anon_sym_PLUS_EQ] = ACTIONS(245),
    [anon_sym_DASH_EQ] = ACTIONS(245),
    [anon_sym_STAR_EQ] = ACTIONS(245),
    [anon_sym_SLASH_EQ] = ACTIONS(245),
    [anon_sym_AT_EQ] = ACTIONS(245),
    [anon_sym_SLASH_SLASH_EQ] = ACTIONS(245),
    [anon_sym_PERCENT_EQ] = ACTIONS(245),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(245),
    [anon_sym_GT_GT_EQ] = ACTIONS(245),
    [anon_sym_LT_LT_EQ] = ACTIONS(245),
    [anon_sym_AMP_EQ] = ACTIONS(245),
    [anon_sym_CARET_EQ] = ACTIONS(245),
    [anon_sym_PIPE_EQ] = ACTIONS(245),
    [sym_ellipsis] = ACTIONS(269),
    [sym_integer] = ACTIONS(271),
    [sym_float] = ACTIONS(269),
    [anon_sym_await] = ACTIONS(251),
    [anon_sym_struct] = ACTIONS(251),
    [anon_sym_type] = ACTIONS(273),
    [sym_true] = ACTIONS(271),
    [sym_false] = ACTIONS(271),
    [sym_none] = ACTIONS(271),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(212),
    [sym_string_start] = ACTIONS(275),
  },
  [50] = {
    [sym__simple_statements] = STATE(557),
    [sym_print_statement] = STATE(1964),
    [sym_assert_statement] = STATE(1964),
    [sym_expression_statement] = STATE(1964),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1964),
    [sym_delete_statement] = STATE(1964),
    [sym_pass_statement] = STATE(1964),
    [sym_break_statement] = STATE(1964),
    [sym_continue_statement] = STATE(1964),
    [sym_exec_statement] = STATE(1964),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(464),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1313),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(466),
    [sym_subscript] = STATE(466),
    [sym_call] = STATE(789),
    [sym_type] = STATE(1631),
    [sym_splat_type] = STATE(1658),
    [sym_generic_type] = STATE(1658),
    [sym_union_type] = STATE(1658),
    [sym_constrained_type] = STATE(1658),
    [sym_member_type] = STATE(1658),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(277),
    [anon_sym_print] = ACTIONS(279),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(281),
    [anon_sym_async] = ACTIONS(281),
    [anon_sym_LPAREN] = ACTIONS(283),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_STAR_STAR] = ACTIONS(287),
    [anon_sym_exec] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(281),
    [anon_sym_struct] = ACTIONS(281),
    [anon_sym_type] = ACTIONS(293),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(295),
    [sym__indent] = ACTIONS(297),
    [sym_string_start] = ACTIONS(67),
  },
  [51] = {
    [sym__simple_statements] = STATE(571),
    [sym_print_statement] = STATE(1964),
    [sym_assert_statement] = STATE(1964),
    [sym_expression_statement] = STATE(1964),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1964),
    [sym_delete_statement] = STATE(1964),
    [sym_pass_statement] = STATE(1964),
    [sym_break_statement] = STATE(1964),
    [sym_continue_statement] = STATE(1964),
    [sym_exec_statement] = STATE(1964),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(464),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1313),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(466),
    [sym_subscript] = STATE(466),
    [sym_call] = STATE(789),
    [sym_type] = STATE(1631),
    [sym_splat_type] = STATE(1658),
    [sym_generic_type] = STATE(1658),
    [sym_union_type] = STATE(1658),
    [sym_constrained_type] = STATE(1658),
    [sym_member_type] = STATE(1658),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(277),
    [anon_sym_print] = ACTIONS(279),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(281),
    [anon_sym_async] = ACTIONS(281),
    [anon_sym_LPAREN] = ACTIONS(283),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_STAR_STAR] = ACTIONS(287),
    [anon_sym_exec] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(281),
    [anon_sym_struct] = ACTIONS(281),
    [anon_sym_type] = ACTIONS(293),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(299),
    [sym__indent] = ACTIONS(301),
    [sym_string_start] = ACTIONS(67),
  },
  [52] = {
    [sym__simple_statements] = STATE(577),
    [sym_print_statement] = STATE(1964),
    [sym_assert_statement] = STATE(1964),
    [sym_expression_statement] = STATE(1964),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1964),
    [sym_delete_statement] = STATE(1964),
    [sym_pass_statement] = STATE(1964),
    [sym_break_statement] = STATE(1964),
    [sym_continue_statement] = STATE(1964),
    [sym_exec_statement] = STATE(1964),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(464),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1313),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(466),
    [sym_subscript] = STATE(466),
    [sym_call] = STATE(789),
    [sym_type] = STATE(1631),
    [sym_splat_type] = STATE(1658),
    [sym_generic_type] = STATE(1658),
    [sym_union_type] = STATE(1658),
    [sym_constrained_type] = STATE(1658),
    [sym_member_type] = STATE(1658),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(277),
    [anon_sym_print] = ACTIONS(279),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(281),
    [anon_sym_async] = ACTIONS(281),
    [anon_sym_LPAREN] = ACTIONS(283),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_STAR_STAR] = ACTIONS(287),
    [anon_sym_exec] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(281),
    [anon_sym_struct] = ACTIONS(281),
    [anon_sym_type] = ACTIONS(293),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(303),
    [sym__indent] = ACTIONS(305),
    [sym_string_start] = ACTIONS(67),
  },
  [53] = {
    [sym__simple_statements] = STATE(545),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_exec_statement] = STATE(1977),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(464),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1313),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(466),
    [sym_subscript] = STATE(466),
    [sym_call] = STATE(789),
    [sym_type] = STATE(1631),
    [sym_splat_type] = STATE(1658),
    [sym_generic_type] = STATE(1658),
    [sym_union_type] = STATE(1658),
    [sym_constrained_type] = STATE(1658),
    [sym_member_type] = STATE(1658),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(277),
    [anon_sym_print] = ACTIONS(279),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(281),
    [anon_sym_async] = ACTIONS(281),
    [anon_sym_LPAREN] = ACTIONS(283),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_STAR_STAR] = ACTIONS(287),
    [anon_sym_exec] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(281),
    [anon_sym_struct] = ACTIONS(281),
    [anon_sym_type] = ACTIONS(293),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(307),
    [sym__indent] = ACTIONS(309),
    [sym_string_start] = ACTIONS(67),
  },
  [54] = {
    [sym__simple_statements] = STATE(568),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_exec_statement] = STATE(1977),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(464),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1313),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(466),
    [sym_subscript] = STATE(466),
    [sym_call] = STATE(789),
    [sym_type] = STATE(1631),
    [sym_splat_type] = STATE(1658),
    [sym_generic_type] = STATE(1658),
    [sym_union_type] = STATE(1658),
    [sym_constrained_type] = STATE(1658),
    [sym_member_type] = STATE(1658),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(277),
    [anon_sym_print] = ACTIONS(279),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(281),
    [anon_sym_async] = ACTIONS(281),
    [anon_sym_LPAREN] = ACTIONS(283),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_STAR_STAR] = ACTIONS(287),
    [anon_sym_exec] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(281),
    [anon_sym_struct] = ACTIONS(281),
    [anon_sym_type] = ACTIONS(293),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(311),
    [sym__indent] = ACTIONS(313),
    [sym_string_start] = ACTIONS(67),
  },
  [55] = {
    [sym__simple_statements] = STATE(520),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_exec_statement] = STATE(1977),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(464),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1313),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(466),
    [sym_subscript] = STATE(466),
    [sym_call] = STATE(789),
    [sym_type] = STATE(1631),
    [sym_splat_type] = STATE(1658),
    [sym_generic_type] = STATE(1658),
    [sym_union_type] = STATE(1658),
    [sym_constrained_type] = STATE(1658),
    [sym_member_type] = STATE(1658),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(277),
    [anon_sym_print] = ACTIONS(279),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(281),
    [anon_sym_async] = ACTIONS(281),
    [anon_sym_LPAREN] = ACTIONS(283),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_STAR_STAR] = ACTIONS(287),
    [anon_sym_exec] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(281),
    [anon_sym_struct] = ACTIONS(281),
    [anon_sym_type] = ACTIONS(293),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(315),
    [sym__indent] = ACTIONS(317),
    [sym_string_start] = ACTIONS(67),
  },
  [56] = {
    [sym__simple_statements] = STATE(559),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_exec_statement] = STATE(1977),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(464),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1313),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(466),
    [sym_subscript] = STATE(466),
    [sym_call] = STATE(789),
    [sym_type] = STATE(1631),
    [sym_splat_type] = STATE(1658),
    [sym_generic_type] = STATE(1658),
    [sym_union_type] = STATE(1658),
    [sym_constrained_type] = STATE(1658),
    [sym_member_type] = STATE(1658),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(277),
    [anon_sym_print] = ACTIONS(279),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(281),
    [anon_sym_async] = ACTIONS(281),
    [anon_sym_LPAREN] = ACTIONS(283),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_STAR_STAR] = ACTIONS(287),
    [anon_sym_exec] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(281),
    [anon_sym_struct] = ACTIONS(281),
    [anon_sym_type] = ACTIONS(293),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(319),
    [sym__indent] = ACTIONS(321),
    [sym_string_start] = ACTIONS(67),
  },
  [57] = {
    [sym__simple_statements] = STATE(583),
    [sym_print_statement] = STATE(1964),
    [sym_assert_statement] = STATE(1964),
    [sym_expression_statement] = STATE(1964),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1964),
    [sym_delete_statement] = STATE(1964),
    [sym_pass_statement] = STATE(1964),
    [sym_break_statement] = STATE(1964),
    [sym_continue_statement] = STATE(1964),
    [sym_exec_statement] = STATE(1964),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(464),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1313),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(466),
    [sym_subscript] = STATE(466),
    [sym_call] = STATE(789),
    [sym_type] = STATE(1631),
    [sym_splat_type] = STATE(1658),
    [sym_generic_type] = STATE(1658),
    [sym_union_type] = STATE(1658),
    [sym_constrained_type] = STATE(1658),
    [sym_member_type] = STATE(1658),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(277),
    [anon_sym_print] = ACTIONS(279),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(281),
    [anon_sym_async] = ACTIONS(281),
    [anon_sym_LPAREN] = ACTIONS(283),
    [anon_sym_STAR] = ACTIONS(285),
    [anon_sym_STAR_STAR] = ACTIONS(287),
    [anon_sym_exec] = ACTIONS(289),
    [anon_sym_LBRACK] = ACTIONS(291),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(281),
    [anon_sym_struct] = ACTIONS(281),
    [anon_sym_type] = ACTIONS(293),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(323),
    [sym__indent] = ACTIONS(325),
    [sym_string_start] = ACTIONS(67),
  },
  [58] = {
    [sym__simple_statements] = STATE(527),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_exec_statement] = STATE(1977),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(327),
    [sym__indent] = ACTIONS(329),
    [sym_string_start] = ACTIONS(67),
  },
  [59] = {
    [sym__simple_statements] = STATE(454),
    [sym_print_statement] = STATE(1964),
    [sym_assert_statement] = STATE(1964),
    [sym_expression_statement] = STATE(1964),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1964),
    [sym_delete_statement] = STATE(1964),
    [sym_pass_statement] = STATE(1964),
    [sym_break_statement] = STATE(1964),
    [sym_continue_statement] = STATE(1964),
    [sym_exec_statement] = STATE(1964),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(331),
    [sym__indent] = ACTIONS(333),
    [sym_string_start] = ACTIONS(67),
  },
  [60] = {
    [sym__simple_statements] = STATE(588),
    [sym_print_statement] = STATE(1964),
    [sym_assert_statement] = STATE(1964),
    [sym_expression_statement] = STATE(1964),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1964),
    [sym_delete_statement] = STATE(1964),
    [sym_pass_statement] = STATE(1964),
    [sym_break_statement] = STATE(1964),
    [sym_continue_statement] = STATE(1964),
    [sym_exec_statement] = STATE(1964),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(335),
    [sym__indent] = ACTIONS(337),
    [sym_string_start] = ACTIONS(67),
  },
  [61] = {
    [sym__simple_statements] = STATE(513),
    [sym_print_statement] = STATE(1964),
    [sym_assert_statement] = STATE(1964),
    [sym_expression_statement] = STATE(1964),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1964),
    [sym_delete_statement] = STATE(1964),
    [sym_pass_statement] = STATE(1964),
    [sym_break_statement] = STATE(1964),
    [sym_continue_statement] = STATE(1964),
    [sym_exec_statement] = STATE(1964),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(339),
    [sym__indent] = ACTIONS(341),
    [sym_string_start] = ACTIONS(67),
  },
  [62] = {
    [sym__simple_statements] = STATE(2082),
    [sym_print_statement] = STATE(2011),
    [sym_assert_statement] = STATE(2011),
    [sym_expression_statement] = STATE(2011),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(2011),
    [sym_delete_statement] = STATE(2011),
    [sym_pass_statement] = STATE(2011),
    [sym_break_statement] = STATE(2011),
    [sym_continue_statement] = STATE(2011),
    [sym_exec_statement] = STATE(2011),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(343),
    [sym__indent] = ACTIONS(345),
    [sym_string_start] = ACTIONS(67),
  },
  [63] = {
    [sym__simple_statements] = STATE(2086),
    [sym_print_statement] = STATE(2011),
    [sym_assert_statement] = STATE(2011),
    [sym_expression_statement] = STATE(2011),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(2011),
    [sym_delete_statement] = STATE(2011),
    [sym_pass_statement] = STATE(2011),
    [sym_break_statement] = STATE(2011),
    [sym_continue_statement] = STATE(2011),
    [sym_exec_statement] = STATE(2011),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(347),
    [sym__indent] = ACTIONS(349),
    [sym_string_start] = ACTIONS(67),
  },
  [64] = {
    [sym__simple_statements] = STATE(2041),
    [sym_print_statement] = STATE(2011),
    [sym_assert_statement] = STATE(2011),
    [sym_expression_statement] = STATE(2011),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(2011),
    [sym_delete_statement] = STATE(2011),
    [sym_pass_statement] = STATE(2011),
    [sym_break_statement] = STATE(2011),
    [sym_continue_statement] = STATE(2011),
    [sym_exec_statement] = STATE(2011),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(351),
    [sym__indent] = ACTIONS(353),
    [sym_string_start] = ACTIONS(67),
  },
  [65] = {
    [sym__simple_statements] = STATE(546),
    [sym_print_statement] = STATE(1964),
    [sym_assert_statement] = STATE(1964),
    [sym_expression_statement] = STATE(1964),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1964),
    [sym_delete_statement] = STATE(1964),
    [sym_pass_statement] = STATE(1964),
    [sym_break_statement] = STATE(1964),
    [sym_continue_statement] = STATE(1964),
    [sym_exec_statement] = STATE(1964),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(355),
    [sym__indent] = ACTIONS(357),
    [sym_string_start] = ACTIONS(67),
  },
  [66] = {
    [sym__simple_statements] = STATE(456),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_exec_statement] = STATE(1977),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(359),
    [sym__indent] = ACTIONS(361),
    [sym_string_start] = ACTIONS(67),
  },
  [67] = {
    [sym__simple_statements] = STATE(502),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_exec_statement] = STATE(1977),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(363),
    [sym__indent] = ACTIONS(365),
    [sym_string_start] = ACTIONS(67),
  },
  [68] = {
    [sym__simple_statements] = STATE(491),
    [sym_print_statement] = STATE(1964),
    [sym_assert_statement] = STATE(1964),
    [sym_expression_statement] = STATE(1964),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1964),
    [sym_delete_statement] = STATE(1964),
    [sym_pass_statement] = STATE(1964),
    [sym_break_statement] = STATE(1964),
    [sym_continue_statement] = STATE(1964),
    [sym_exec_statement] = STATE(1964),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(367),
    [sym__indent] = ACTIONS(369),
    [sym_string_start] = ACTIONS(67),
  },
  [69] = {
    [sym__simple_statements] = STATE(498),
    [sym_print_statement] = STATE(1964),
    [sym_assert_statement] = STATE(1964),
    [sym_expression_statement] = STATE(1964),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1964),
    [sym_delete_statement] = STATE(1964),
    [sym_pass_statement] = STATE(1964),
    [sym_break_statement] = STATE(1964),
    [sym_continue_statement] = STATE(1964),
    [sym_exec_statement] = STATE(1964),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(371),
    [sym__indent] = ACTIONS(373),
    [sym_string_start] = ACTIONS(67),
  },
  [70] = {
    [sym__simple_statements] = STATE(528),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_exec_statement] = STATE(1977),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(375),
    [sym__indent] = ACTIONS(377),
    [sym_string_start] = ACTIONS(67),
  },
  [71] = {
    [sym__simple_statements] = STATE(2022),
    [sym_print_statement] = STATE(2011),
    [sym_assert_statement] = STATE(2011),
    [sym_expression_statement] = STATE(2011),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(2011),
    [sym_delete_statement] = STATE(2011),
    [sym_pass_statement] = STATE(2011),
    [sym_break_statement] = STATE(2011),
    [sym_continue_statement] = STATE(2011),
    [sym_exec_statement] = STATE(2011),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(379),
    [sym__indent] = ACTIONS(381),
    [sym_string_start] = ACTIONS(67),
  },
  [72] = {
    [sym__simple_statements] = STATE(533),
    [sym_print_statement] = STATE(1964),
    [sym_assert_statement] = STATE(1964),
    [sym_expression_statement] = STATE(1964),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1964),
    [sym_delete_statement] = STATE(1964),
    [sym_pass_statement] = STATE(1964),
    [sym_break_statement] = STATE(1964),
    [sym_continue_statement] = STATE(1964),
    [sym_exec_statement] = STATE(1964),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(383),
    [sym__indent] = ACTIONS(385),
    [sym_string_start] = ACTIONS(67),
  },
  [73] = {
    [sym__simple_statements] = STATE(543),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_exec_statement] = STATE(1977),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(387),
    [sym__indent] = ACTIONS(389),
    [sym_string_start] = ACTIONS(67),
  },
  [74] = {
    [sym__simple_statements] = STATE(493),
    [sym_print_statement] = STATE(1964),
    [sym_assert_statement] = STATE(1964),
    [sym_expression_statement] = STATE(1964),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1964),
    [sym_delete_statement] = STATE(1964),
    [sym_pass_statement] = STATE(1964),
    [sym_break_statement] = STATE(1964),
    [sym_continue_statement] = STATE(1964),
    [sym_exec_statement] = STATE(1964),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(391),
    [sym__indent] = ACTIONS(393),
    [sym_string_start] = ACTIONS(67),
  },
  [75] = {
    [sym__simple_statements] = STATE(565),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_exec_statement] = STATE(1977),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(395),
    [sym__indent] = ACTIONS(397),
    [sym_string_start] = ACTIONS(67),
  },
  [76] = {
    [sym__simple_statements] = STATE(500),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_exec_statement] = STATE(1977),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(399),
    [sym__indent] = ACTIONS(401),
    [sym_string_start] = ACTIONS(67),
  },
  [77] = {
    [sym__simple_statements] = STATE(579),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_exec_statement] = STATE(1977),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(403),
    [sym__indent] = ACTIONS(405),
    [sym_string_start] = ACTIONS(67),
  },
  [78] = {
    [sym__simple_statements] = STATE(586),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_exec_statement] = STATE(1977),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(407),
    [sym__indent] = ACTIONS(409),
    [sym_string_start] = ACTIONS(67),
  },
  [79] = {
    [sym__simple_statements] = STATE(503),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_exec_statement] = STATE(1977),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(411),
    [sym__indent] = ACTIONS(413),
    [sym_string_start] = ACTIONS(67),
  },
  [80] = {
    [sym__simple_statements] = STATE(592),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_exec_statement] = STATE(1977),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(415),
    [sym__indent] = ACTIONS(417),
    [sym_string_start] = ACTIONS(67),
  },
  [81] = {
    [sym__simple_statements] = STATE(478),
    [sym_print_statement] = STATE(1977),
    [sym_assert_statement] = STATE(1977),
    [sym_expression_statement] = STATE(1977),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1977),
    [sym_delete_statement] = STATE(1977),
    [sym_pass_statement] = STATE(1977),
    [sym_break_statement] = STATE(1977),
    [sym_continue_statement] = STATE(1977),
    [sym_exec_statement] = STATE(1977),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(419),
    [sym__indent] = ACTIONS(421),
    [sym_string_start] = ACTIONS(67),
  },
  [82] = {
    [sym__simple_statements] = STATE(554),
    [sym_print_statement] = STATE(1964),
    [sym_assert_statement] = STATE(1964),
    [sym_expression_statement] = STATE(1964),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1964),
    [sym_delete_statement] = STATE(1964),
    [sym_pass_statement] = STATE(1964),
    [sym_break_statement] = STATE(1964),
    [sym_continue_statement] = STATE(1964),
    [sym_exec_statement] = STATE(1964),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(423),
    [sym__indent] = ACTIONS(425),
    [sym_string_start] = ACTIONS(67),
  },
  [83] = {
    [sym__simple_statements] = STATE(507),
    [sym_print_statement] = STATE(1964),
    [sym_assert_statement] = STATE(1964),
    [sym_expression_statement] = STATE(1964),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1964),
    [sym_delete_statement] = STATE(1964),
    [sym_pass_statement] = STATE(1964),
    [sym_break_statement] = STATE(1964),
    [sym_continue_statement] = STATE(1964),
    [sym_exec_statement] = STATE(1964),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(427),
    [sym__indent] = ACTIONS(429),
    [sym_string_start] = ACTIONS(67),
  },
  [84] = {
    [sym__simple_statements] = STATE(496),
    [sym_print_statement] = STATE(1964),
    [sym_assert_statement] = STATE(1964),
    [sym_expression_statement] = STATE(1964),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1964),
    [sym_delete_statement] = STATE(1964),
    [sym_pass_statement] = STATE(1964),
    [sym_break_statement] = STATE(1964),
    [sym_continue_statement] = STATE(1964),
    [sym_exec_statement] = STATE(1964),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(431),
    [sym__indent] = ACTIONS(433),
    [sym_string_start] = ACTIONS(67),
  },
  [85] = {
    [sym__simple_statements] = STATE(541),
    [sym_print_statement] = STATE(1964),
    [sym_assert_statement] = STATE(1964),
    [sym_expression_statement] = STATE(1964),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(1964),
    [sym_delete_statement] = STATE(1964),
    [sym_pass_statement] = STATE(1964),
    [sym_break_statement] = STATE(1964),
    [sym_continue_statement] = STATE(1964),
    [sym_exec_statement] = STATE(1964),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(435),
    [sym__indent] = ACTIONS(437),
    [sym_string_start] = ACTIONS(67),
  },
  [86] = {
    [sym__simple_statements] = STATE(2031),
    [sym_print_statement] = STATE(2011),
    [sym_assert_statement] = STATE(2011),
    [sym_expression_statement] = STATE(2011),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(2011),
    [sym_delete_statement] = STATE(2011),
    [sym_pass_statement] = STATE(2011),
    [sym_break_statement] = STATE(2011),
    [sym_continue_statement] = STATE(2011),
    [sym_exec_statement] = STATE(2011),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(439),
    [sym__indent] = ACTIONS(441),
    [sym_string_start] = ACTIONS(67),
  },
  [87] = {
    [sym__simple_statements] = STATE(2093),
    [sym_print_statement] = STATE(2011),
    [sym_assert_statement] = STATE(2011),
    [sym_expression_statement] = STATE(2011),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(2011),
    [sym_delete_statement] = STATE(2011),
    [sym_pass_statement] = STATE(2011),
    [sym_break_statement] = STATE(2011),
    [sym_continue_statement] = STATE(2011),
    [sym_exec_statement] = STATE(2011),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(443),
    [sym__indent] = ACTIONS(445),
    [sym_string_start] = ACTIONS(67),
  },
  [88] = {
    [sym_print_statement] = STATE(2037),
    [sym_assert_statement] = STATE(2037),
    [sym_expression_statement] = STATE(2037),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(2037),
    [sym_delete_statement] = STATE(2037),
    [sym_pass_statement] = STATE(2037),
    [sym_break_statement] = STATE(2037),
    [sym_continue_statement] = STATE(2037),
    [sym_exec_statement] = STATE(2037),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(447),
    [sym_string_start] = ACTIONS(67),
  },
  [89] = {
    [sym_print_statement] = STATE(2037),
    [sym_assert_statement] = STATE(2037),
    [sym_expression_statement] = STATE(2037),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(2037),
    [sym_delete_statement] = STATE(2037),
    [sym_pass_statement] = STATE(2037),
    [sym_break_statement] = STATE(2037),
    [sym_continue_statement] = STATE(2037),
    [sym_exec_statement] = STATE(2037),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(449),
    [sym_string_start] = ACTIONS(67),
  },
  [90] = {
    [sym_print_statement] = STATE(2037),
    [sym_assert_statement] = STATE(2037),
    [sym_expression_statement] = STATE(2037),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(2037),
    [sym_delete_statement] = STATE(2037),
    [sym_pass_statement] = STATE(2037),
    [sym_break_statement] = STATE(2037),
    [sym_continue_statement] = STATE(2037),
    [sym_exec_statement] = STATE(2037),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(451),
    [sym_string_start] = ACTIONS(67),
  },
  [91] = {
    [sym_print_statement] = STATE(2037),
    [sym_assert_statement] = STATE(2037),
    [sym_expression_statement] = STATE(2037),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(2037),
    [sym_delete_statement] = STATE(2037),
    [sym_pass_statement] = STATE(2037),
    [sym_break_statement] = STATE(2037),
    [sym_continue_statement] = STATE(2037),
    [sym_exec_statement] = STATE(2037),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(453),
    [sym_string_start] = ACTIONS(67),
  },
  [92] = {
    [sym_print_statement] = STATE(2037),
    [sym_assert_statement] = STATE(2037),
    [sym_expression_statement] = STATE(2037),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(2037),
    [sym_delete_statement] = STATE(2037),
    [sym_pass_statement] = STATE(2037),
    [sym_break_statement] = STATE(2037),
    [sym_continue_statement] = STATE(2037),
    [sym_exec_statement] = STATE(2037),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(455),
    [sym_string_start] = ACTIONS(67),
  },
  [93] = {
    [sym_print_statement] = STATE(2037),
    [sym_assert_statement] = STATE(2037),
    [sym_expression_statement] = STATE(2037),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(2037),
    [sym_delete_statement] = STATE(2037),
    [sym_pass_statement] = STATE(2037),
    [sym_break_statement] = STATE(2037),
    [sym_continue_statement] = STATE(2037),
    [sym_exec_statement] = STATE(2037),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym__newline] = ACTIONS(457),
    [sym_string_start] = ACTIONS(67),
  },
  [94] = {
    [sym_print_statement] = STATE(2037),
    [sym_assert_statement] = STATE(2037),
    [sym_expression_statement] = STATE(2037),
    [sym_named_expression] = STATE(1328),
    [sym__named_expression_lhs] = STATE(2112),
    [sym_return_statement] = STATE(2037),
    [sym_delete_statement] = STATE(2037),
    [sym_pass_statement] = STATE(2037),
    [sym_break_statement] = STATE(2037),
    [sym_continue_statement] = STATE(2037),
    [sym_exec_statement] = STATE(2037),
    [sym_pattern] = STATE(1281),
    [sym_tuple_pattern] = STATE(1260),
    [sym_list_pattern] = STATE(1260),
    [sym_list_splat_pattern] = STATE(463),
    [sym_as_pattern] = STATE(1328),
    [sym_expression] = STATE(1428),
    [sym_primary_expression] = STATE(740),
    [sym_not_operator] = STATE(1328),
    [sym_boolean_operator] = STATE(1328),
    [sym_binary_operator] = STATE(789),
    [sym_unary_operator] = STATE(789),
    [sym_comparison_operator] = STATE(1328),
    [sym_lambda] = STATE(1328),
    [sym_assignment] = STATE(2067),
    [sym_augmented_assignment] = STATE(2067),
    [sym_pattern_list] = STATE(1286),
    [sym_attribute] = STATE(459),
    [sym_subscript] = STATE(459),
    [sym_call] = STATE(789),
    [sym_list] = STATE(789),
    [sym_set] = STATE(789),
    [sym_tuple] = STATE(789),
    [sym_dictionary] = STATE(789),
    [sym_list_comprehension] = STATE(789),
    [sym_dictionary_comprehension] = STATE(789),
    [sym_set_comprehension] = STATE(789),
    [sym_parenthesized_expression] = STATE(789),
    [sym_conditional_expression] = STATE(1328),
    [sym_string] = STATE(789),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_print] = ACTIONS(11),
    [anon_sym_assert] = ACTIONS(13),
    [anon_sym_assert_] = ACTIONS(15),
    [anon_sym_assert_eq] = ACTIONS(15),
    [anon_sym_assert_ne] = ACTIONS(15),
    [anon_sym_assert_contains] = ACTIONS(15),
    [anon_sym_assert_fails] = ACTIONS(15),
    [anon_sym_return] = ACTIONS(17),
    [anon_sym_del] = ACTIONS(19),
    [anon_sym_pass] = ACTIONS(21),
    [anon_sym_break] = ACTIONS(23),
    [anon_sym_continue] = ACTIONS(25),
    [anon_sym_match] = ACTIONS(63),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(39),
    [anon_sym_STAR] = ACTIONS(43),
    [anon_sym_exec] = ACTIONS(45),
    [anon_sym_LBRACK] = ACTIONS(47),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_LBRACE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_not] = ACTIONS(55),
    [anon_sym_TILDE] = ACTIONS(51),
    [anon_sym_lambda] = ACTIONS(57),
    [sym_ellipsis] = ACTIONS(59),
    [sym_integer] = ACTIONS(61),
    [sym_float] = ACTIONS(59),
    [anon_sym_await] = ACTIONS(63),
    [anon_sym_struct] = ACTIONS(63),
    [anon_sym_type] = ACTIONS(65),
    [sym_true] = ACTIONS(61),
    [sym_false] = ACTIONS(61),
    [sym_none] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_string_start] = ACTIONS(67),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 20,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(265), 1,
      anon_sym_TILDE,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(459), 1,
      sym_identifier,
    ACTIONS(465), 1,
      anon_sym_LPAREN,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(469), 1,
      anon_sym_LBRACK,
    ACTIONS(471), 1,
      anon_sym_type,
    STATE(808), 1,
      sym_list_splat_pattern,
    STATE(1230), 1,
      sym_pattern,
    STATE(1276), 1,
      sym_primary_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(259), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    STATE(809), 2,
      sym_attribute,
      sym_subscript,
    STATE(1249), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(463), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1036), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
    ACTIONS(461), 17,
      sym__newline,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [101] = 20,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(265), 1,
      anon_sym_TILDE,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(459), 1,
      sym_identifier,
    ACTIONS(465), 1,
      anon_sym_LPAREN,
    ACTIONS(467), 1,
      anon_sym_STAR,
    ACTIONS(469), 1,
      anon_sym_LBRACK,
    ACTIONS(471), 1,
      anon_sym_type,
    STATE(808), 1,
      sym_list_splat_pattern,
    STATE(1230), 1,
      sym_pattern,
    STATE(1276), 1,
      sym_primary_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(259), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    STATE(809), 2,
      sym_attribute,
      sym_subscript,
    STATE(1249), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(463), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1036), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
    ACTIONS(473), 17,
      sym__newline,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [202] = 27,
    ACTIONS(475), 1,
      sym_identifier,
    ACTIONS(479), 1,
      anon_sym_LPAREN,
    ACTIONS(481), 1,
      anon_sym_RPAREN,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(485), 1,
      anon_sym_LBRACK,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(499), 1,
      anon_sym_type,
    ACTIONS(501), 1,
      sym_string_start,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1130), 1,
      sym_list_splat_pattern,
    STATE(1443), 1,
      sym_expression,
    STATE(1878), 1,
      sym_pattern,
    STATE(2168), 1,
      sym__patterns,
    STATE(2195), 1,
      sym__collection_elements,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    STATE(1126), 2,
      sym_attribute,
      sym_subscript,
    STATE(1988), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    STATE(2101), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(477), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [316] = 27,
    ACTIONS(503), 1,
      sym_identifier,
    ACTIONS(507), 1,
      anon_sym_LPAREN,
    ACTIONS(509), 1,
      anon_sym_STAR,
    ACTIONS(511), 1,
      anon_sym_LBRACK,
    ACTIONS(513), 1,
      anon_sym_RBRACK,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(521), 1,
      anon_sym_lambda,
    ACTIONS(527), 1,
      anon_sym_type,
    ACTIONS(529), 1,
      sym_string_start,
    STATE(739), 1,
      sym_primary_expression,
    STATE(1018), 1,
      sym_list_splat_pattern,
    STATE(1312), 1,
      sym_expression,
    STATE(1839), 1,
      sym_pattern,
    STATE(2150), 1,
      sym__patterns,
    STATE(2158), 1,
      sym__collection_elements,
    STATE(2161), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1023), 2,
      sym_attribute,
      sym_subscript,
    STATE(1835), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    STATE(2043), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(505), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [430] = 27,
    ACTIONS(531), 1,
      sym_identifier,
    ACTIONS(535), 1,
      anon_sym_COMMA,
    ACTIONS(537), 1,
      anon_sym_LPAREN,
    ACTIONS(539), 1,
      anon_sym_STAR,
    ACTIONS(541), 1,
      anon_sym_STAR_STAR,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_LBRACE,
    ACTIONS(549), 1,
      anon_sym_RBRACE,
    ACTIONS(551), 1,
      anon_sym_not,
    ACTIONS(553), 1,
      anon_sym_lambda,
    ACTIONS(559), 1,
      anon_sym_type,
    ACTIONS(561), 1,
      sym_string_start,
    STATE(704), 1,
      sym_primary_expression,
    STATE(827), 1,
      sym_list_splat_pattern,
    STATE(1295), 1,
      sym_expression,
    STATE(1492), 1,
      sym_pair,
    STATE(1844), 1,
      sym_dictionary_splat,
    STATE(2138), 1,
      sym__collection_elements,
    STATE(2209), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(555), 2,
      sym_ellipsis,
      sym_float,
    STATE(1830), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(545), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(557), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(533), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1366), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(771), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [544] = 25,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_STAR,
    ACTIONS(47), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(57), 1,
      anon_sym_lambda,
    ACTIONS(65), 1,
      anon_sym_type,
    ACTIONS(67), 1,
      sym_string_start,
    STATE(463), 1,
      sym_list_splat_pattern,
    STATE(740), 1,
      sym_primary_expression,
    STATE(1262), 1,
      sym_pattern_list,
    STATE(1269), 1,
      sym_pattern,
    STATE(1411), 1,
      sym_expression,
    STATE(2112), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(59), 2,
      sym_ellipsis,
      sym_float,
    STATE(459), 2,
      sym_attribute,
      sym_subscript,
    STATE(1260), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(51), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(61), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(2017), 4,
      sym_expression_list,
      sym_assignment,
      sym_augmented_assignment,
      sym__right_hand_side,
    ACTIONS(63), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1328), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(789), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [654] = 28,
    ACTIONS(475), 1,
      sym_identifier,
    ACTIONS(479), 1,
      anon_sym_LPAREN,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(485), 1,
      anon_sym_LBRACK,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(499), 1,
      anon_sym_type,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(563), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1130), 1,
      sym_list_splat_pattern,
    STATE(1452), 1,
      sym_expression,
    STATE(1878), 1,
      sym_pattern,
    STATE(1886), 1,
      sym_list_splat,
    STATE(1890), 1,
      sym_parenthesized_list_splat,
    STATE(2136), 1,
      sym__collection_elements,
    STATE(2189), 1,
      sym__patterns,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    STATE(1126), 2,
      sym_attribute,
      sym_subscript,
    STATE(2101), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(477), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [770] = 27,
    ACTIONS(503), 1,
      sym_identifier,
    ACTIONS(507), 1,
      anon_sym_LPAREN,
    ACTIONS(509), 1,
      anon_sym_STAR,
    ACTIONS(511), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(521), 1,
      anon_sym_lambda,
    ACTIONS(527), 1,
      anon_sym_type,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(565), 1,
      anon_sym_RBRACK,
    STATE(739), 1,
      sym_primary_expression,
    STATE(1018), 1,
      sym_list_splat_pattern,
    STATE(1325), 1,
      sym_expression,
    STATE(1839), 1,
      sym_pattern,
    STATE(2150), 1,
      sym__patterns,
    STATE(2161), 1,
      sym__named_expression_lhs,
    STATE(2197), 1,
      sym__collection_elements,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1023), 2,
      sym_attribute,
      sym_subscript,
    STATE(1835), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    STATE(2043), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(505), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [884] = 27,
    ACTIONS(531), 1,
      sym_identifier,
    ACTIONS(537), 1,
      anon_sym_LPAREN,
    ACTIONS(539), 1,
      anon_sym_STAR,
    ACTIONS(541), 1,
      anon_sym_STAR_STAR,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_LBRACE,
    ACTIONS(551), 1,
      anon_sym_not,
    ACTIONS(553), 1,
      anon_sym_lambda,
    ACTIONS(559), 1,
      anon_sym_type,
    ACTIONS(561), 1,
      sym_string_start,
    ACTIONS(567), 1,
      anon_sym_COMMA,
    ACTIONS(569), 1,
      anon_sym_RBRACE,
    STATE(704), 1,
      sym_primary_expression,
    STATE(827), 1,
      sym_list_splat_pattern,
    STATE(1296), 1,
      sym_expression,
    STATE(1445), 1,
      sym_pair,
    STATE(1987), 1,
      sym_dictionary_splat,
    STATE(2203), 1,
      sym__collection_elements,
    STATE(2209), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(555), 2,
      sym_ellipsis,
      sym_float,
    STATE(1830), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(545), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(557), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(533), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1366), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(771), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [998] = 28,
    ACTIONS(475), 1,
      sym_identifier,
    ACTIONS(479), 1,
      anon_sym_LPAREN,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(485), 1,
      anon_sym_LBRACK,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(499), 1,
      anon_sym_type,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(571), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1130), 1,
      sym_list_splat_pattern,
    STATE(1458), 1,
      sym_expression,
    STATE(1878), 1,
      sym_pattern,
    STATE(1997), 1,
      sym_list_splat,
    STATE(1998), 1,
      sym_parenthesized_list_splat,
    STATE(2179), 1,
      sym__collection_elements,
    STATE(2190), 1,
      sym__patterns,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    STATE(1126), 2,
      sym_attribute,
      sym_subscript,
    STATE(2101), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(477), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [1114] = 24,
    ACTIONS(573), 1,
      sym_identifier,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(579), 1,
      anon_sym_STAR,
    ACTIONS(581), 1,
      anon_sym_STAR_STAR,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(585), 1,
      anon_sym_RBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1373), 1,
      sym_expression,
    STATE(1640), 1,
      sym_type,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1652), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [1222] = 24,
    ACTIONS(573), 1,
      sym_identifier,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(579), 1,
      anon_sym_STAR,
    ACTIONS(581), 1,
      anon_sym_STAR_STAR,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(603), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1373), 1,
      sym_expression,
    STATE(1640), 1,
      sym_type,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1652), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [1330] = 25,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_STAR,
    ACTIONS(47), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(57), 1,
      anon_sym_lambda,
    ACTIONS(65), 1,
      anon_sym_type,
    ACTIONS(67), 1,
      sym_string_start,
    STATE(463), 1,
      sym_list_splat_pattern,
    STATE(740), 1,
      sym_primary_expression,
    STATE(1262), 1,
      sym_pattern_list,
    STATE(1269), 1,
      sym_pattern,
    STATE(1411), 1,
      sym_expression,
    STATE(2112), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(59), 2,
      sym_ellipsis,
      sym_float,
    STATE(459), 2,
      sym_attribute,
      sym_subscript,
    STATE(1260), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(51), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(61), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(2061), 4,
      sym_expression_list,
      sym_assignment,
      sym_augmented_assignment,
      sym__right_hand_side,
    ACTIONS(63), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1328), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(789), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [1440] = 24,
    ACTIONS(573), 1,
      sym_identifier,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(579), 1,
      anon_sym_STAR,
    ACTIONS(581), 1,
      anon_sym_STAR_STAR,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(605), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1373), 1,
      sym_expression,
    STATE(1640), 1,
      sym_type,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1652), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [1548] = 25,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_STAR,
    ACTIONS(47), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(57), 1,
      anon_sym_lambda,
    ACTIONS(65), 1,
      anon_sym_type,
    ACTIONS(67), 1,
      sym_string_start,
    STATE(463), 1,
      sym_list_splat_pattern,
    STATE(740), 1,
      sym_primary_expression,
    STATE(1262), 1,
      sym_pattern_list,
    STATE(1269), 1,
      sym_pattern,
    STATE(1411), 1,
      sym_expression,
    STATE(2112), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(59), 2,
      sym_ellipsis,
      sym_float,
    STATE(459), 2,
      sym_attribute,
      sym_subscript,
    STATE(1260), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(51), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(61), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(2073), 4,
      sym_expression_list,
      sym_assignment,
      sym_augmented_assignment,
      sym__right_hand_side,
    ACTIONS(63), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1328), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(789), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [1658] = 27,
    ACTIONS(475), 1,
      sym_identifier,
    ACTIONS(479), 1,
      anon_sym_LPAREN,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(485), 1,
      anon_sym_LBRACK,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(499), 1,
      anon_sym_type,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(607), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1130), 1,
      sym_list_splat_pattern,
    STATE(1469), 1,
      sym_expression,
    STATE(1878), 1,
      sym_pattern,
    STATE(2132), 1,
      sym__collection_elements,
    STATE(2168), 1,
      sym__patterns,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    STATE(1126), 2,
      sym_attribute,
      sym_subscript,
    STATE(1988), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    STATE(2101), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(477), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [1772] = 27,
    ACTIONS(503), 1,
      sym_identifier,
    ACTIONS(507), 1,
      anon_sym_LPAREN,
    ACTIONS(509), 1,
      anon_sym_STAR,
    ACTIONS(511), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(521), 1,
      anon_sym_lambda,
    ACTIONS(527), 1,
      anon_sym_type,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(609), 1,
      anon_sym_RBRACK,
    STATE(739), 1,
      sym_primary_expression,
    STATE(1018), 1,
      sym_list_splat_pattern,
    STATE(1330), 1,
      sym_expression,
    STATE(1839), 1,
      sym_pattern,
    STATE(2161), 1,
      sym__named_expression_lhs,
    STATE(2196), 1,
      sym__patterns,
    STATE(2213), 1,
      sym__collection_elements,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1023), 2,
      sym_attribute,
      sym_subscript,
    STATE(1835), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    STATE(2043), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(505), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [1886] = 27,
    ACTIONS(531), 1,
      sym_identifier,
    ACTIONS(537), 1,
      anon_sym_LPAREN,
    ACTIONS(539), 1,
      anon_sym_STAR,
    ACTIONS(541), 1,
      anon_sym_STAR_STAR,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_LBRACE,
    ACTIONS(551), 1,
      anon_sym_not,
    ACTIONS(553), 1,
      anon_sym_lambda,
    ACTIONS(559), 1,
      anon_sym_type,
    ACTIONS(561), 1,
      sym_string_start,
    ACTIONS(611), 1,
      anon_sym_COMMA,
    ACTIONS(613), 1,
      anon_sym_RBRACE,
    STATE(704), 1,
      sym_primary_expression,
    STATE(827), 1,
      sym_list_splat_pattern,
    STATE(1298), 1,
      sym_expression,
    STATE(1453), 1,
      sym_pair,
    STATE(1809), 1,
      sym_dictionary_splat,
    STATE(2107), 1,
      sym__collection_elements,
    STATE(2209), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(555), 2,
      sym_ellipsis,
      sym_float,
    STATE(1830), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(545), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(557), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(533), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1366), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(771), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [2000] = 27,
    ACTIONS(475), 1,
      sym_identifier,
    ACTIONS(479), 1,
      anon_sym_LPAREN,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(485), 1,
      anon_sym_LBRACK,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(499), 1,
      anon_sym_type,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(615), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1130), 1,
      sym_list_splat_pattern,
    STATE(1451), 1,
      sym_expression,
    STATE(1878), 1,
      sym_pattern,
    STATE(2125), 1,
      sym__collection_elements,
    STATE(2168), 1,
      sym__patterns,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    STATE(1126), 2,
      sym_attribute,
      sym_subscript,
    STATE(1988), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    STATE(2101), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(477), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [2114] = 24,
    ACTIONS(573), 1,
      sym_identifier,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(579), 1,
      anon_sym_STAR,
    ACTIONS(581), 1,
      anon_sym_STAR_STAR,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(617), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1373), 1,
      sym_expression,
    STATE(1640), 1,
      sym_type,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1652), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [2222] = 24,
    ACTIONS(573), 1,
      sym_identifier,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(579), 1,
      anon_sym_STAR,
    ACTIONS(581), 1,
      anon_sym_STAR_STAR,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(619), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1373), 1,
      sym_expression,
    STATE(1640), 1,
      sym_type,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1652), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [2330] = 27,
    ACTIONS(475), 1,
      sym_identifier,
    ACTIONS(479), 1,
      anon_sym_LPAREN,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(485), 1,
      anon_sym_LBRACK,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(499), 1,
      anon_sym_type,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(621), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1130), 1,
      sym_list_splat_pattern,
    STATE(1443), 1,
      sym_expression,
    STATE(1878), 1,
      sym_pattern,
    STATE(2189), 1,
      sym__patterns,
    STATE(2195), 1,
      sym__collection_elements,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    STATE(1126), 2,
      sym_attribute,
      sym_subscript,
    STATE(1988), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    STATE(2101), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(477), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [2444] = 27,
    ACTIONS(503), 1,
      sym_identifier,
    ACTIONS(507), 1,
      anon_sym_LPAREN,
    ACTIONS(509), 1,
      anon_sym_STAR,
    ACTIONS(511), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(521), 1,
      anon_sym_lambda,
    ACTIONS(527), 1,
      anon_sym_type,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(623), 1,
      anon_sym_RBRACK,
    STATE(739), 1,
      sym_primary_expression,
    STATE(1018), 1,
      sym_list_splat_pattern,
    STATE(1332), 1,
      sym_expression,
    STATE(1839), 1,
      sym_pattern,
    STATE(2156), 1,
      sym__patterns,
    STATE(2161), 1,
      sym__named_expression_lhs,
    STATE(2192), 1,
      sym__collection_elements,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1023), 2,
      sym_attribute,
      sym_subscript,
    STATE(1835), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    STATE(2043), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(505), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [2558] = 27,
    ACTIONS(531), 1,
      sym_identifier,
    ACTIONS(537), 1,
      anon_sym_LPAREN,
    ACTIONS(539), 1,
      anon_sym_STAR,
    ACTIONS(541), 1,
      anon_sym_STAR_STAR,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_LBRACE,
    ACTIONS(551), 1,
      anon_sym_not,
    ACTIONS(553), 1,
      anon_sym_lambda,
    ACTIONS(559), 1,
      anon_sym_type,
    ACTIONS(561), 1,
      sym_string_start,
    ACTIONS(625), 1,
      anon_sym_COMMA,
    ACTIONS(627), 1,
      anon_sym_RBRACE,
    STATE(704), 1,
      sym_primary_expression,
    STATE(827), 1,
      sym_list_splat_pattern,
    STATE(1299), 1,
      sym_expression,
    STATE(1459), 1,
      sym_pair,
    STATE(1855), 1,
      sym_dictionary_splat,
    STATE(2126), 1,
      sym__collection_elements,
    STATE(2209), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(555), 2,
      sym_ellipsis,
      sym_float,
    STATE(1830), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(545), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(557), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(533), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1366), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(771), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [2672] = 24,
    ACTIONS(573), 1,
      sym_identifier,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(579), 1,
      anon_sym_STAR,
    ACTIONS(581), 1,
      anon_sym_STAR_STAR,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(629), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1373), 1,
      sym_expression,
    STATE(1640), 1,
      sym_type,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1652), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [2780] = 24,
    ACTIONS(573), 1,
      sym_identifier,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(579), 1,
      anon_sym_STAR,
    ACTIONS(581), 1,
      anon_sym_STAR_STAR,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(631), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1373), 1,
      sym_expression,
    STATE(1640), 1,
      sym_type,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1652), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [2888] = 27,
    ACTIONS(475), 1,
      sym_identifier,
    ACTIONS(479), 1,
      anon_sym_LPAREN,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(485), 1,
      anon_sym_LBRACK,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(499), 1,
      anon_sym_type,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(633), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1130), 1,
      sym_list_splat_pattern,
    STATE(1443), 1,
      sym_expression,
    STATE(1878), 1,
      sym_pattern,
    STATE(2168), 1,
      sym__patterns,
    STATE(2195), 1,
      sym__collection_elements,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    STATE(1126), 2,
      sym_attribute,
      sym_subscript,
    STATE(1988), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    STATE(2101), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(477), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [3002] = 27,
    ACTIONS(503), 1,
      sym_identifier,
    ACTIONS(507), 1,
      anon_sym_LPAREN,
    ACTIONS(509), 1,
      anon_sym_STAR,
    ACTIONS(511), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(521), 1,
      anon_sym_lambda,
    ACTIONS(527), 1,
      anon_sym_type,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(635), 1,
      anon_sym_RBRACK,
    STATE(739), 1,
      sym_primary_expression,
    STATE(1018), 1,
      sym_list_splat_pattern,
    STATE(1336), 1,
      sym_expression,
    STATE(1839), 1,
      sym_pattern,
    STATE(2133), 1,
      sym__collection_elements,
    STATE(2150), 1,
      sym__patterns,
    STATE(2161), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1023), 2,
      sym_attribute,
      sym_subscript,
    STATE(1835), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    STATE(2043), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(505), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [3116] = 27,
    ACTIONS(531), 1,
      sym_identifier,
    ACTIONS(537), 1,
      anon_sym_LPAREN,
    ACTIONS(539), 1,
      anon_sym_STAR,
    ACTIONS(541), 1,
      anon_sym_STAR_STAR,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_LBRACE,
    ACTIONS(551), 1,
      anon_sym_not,
    ACTIONS(553), 1,
      anon_sym_lambda,
    ACTIONS(559), 1,
      anon_sym_type,
    ACTIONS(561), 1,
      sym_string_start,
    ACTIONS(637), 1,
      anon_sym_COMMA,
    ACTIONS(639), 1,
      anon_sym_RBRACE,
    STATE(704), 1,
      sym_primary_expression,
    STATE(827), 1,
      sym_list_splat_pattern,
    STATE(1293), 1,
      sym_expression,
    STATE(1465), 1,
      sym_pair,
    STATE(1894), 1,
      sym_dictionary_splat,
    STATE(2209), 1,
      sym__named_expression_lhs,
    STATE(2232), 1,
      sym__collection_elements,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(555), 2,
      sym_ellipsis,
      sym_float,
    STATE(1830), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(545), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(557), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(533), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1366), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(771), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [3230] = 27,
    ACTIONS(475), 1,
      sym_identifier,
    ACTIONS(479), 1,
      anon_sym_LPAREN,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(485), 1,
      anon_sym_LBRACK,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(499), 1,
      anon_sym_type,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(641), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1130), 1,
      sym_list_splat_pattern,
    STATE(1443), 1,
      sym_expression,
    STATE(1878), 1,
      sym_pattern,
    STATE(2190), 1,
      sym__patterns,
    STATE(2195), 1,
      sym__collection_elements,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    STATE(1126), 2,
      sym_attribute,
      sym_subscript,
    STATE(1988), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    STATE(2101), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(477), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [3344] = 27,
    ACTIONS(503), 1,
      sym_identifier,
    ACTIONS(507), 1,
      anon_sym_LPAREN,
    ACTIONS(509), 1,
      anon_sym_STAR,
    ACTIONS(511), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(521), 1,
      anon_sym_lambda,
    ACTIONS(527), 1,
      anon_sym_type,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(643), 1,
      anon_sym_RBRACK,
    STATE(739), 1,
      sym_primary_expression,
    STATE(1018), 1,
      sym_list_splat_pattern,
    STATE(1325), 1,
      sym_expression,
    STATE(1839), 1,
      sym_pattern,
    STATE(2161), 1,
      sym__named_expression_lhs,
    STATE(2196), 1,
      sym__patterns,
    STATE(2197), 1,
      sym__collection_elements,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1023), 2,
      sym_attribute,
      sym_subscript,
    STATE(1835), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    STATE(2043), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(505), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [3458] = 27,
    ACTIONS(531), 1,
      sym_identifier,
    ACTIONS(537), 1,
      anon_sym_LPAREN,
    ACTIONS(539), 1,
      anon_sym_STAR,
    ACTIONS(541), 1,
      anon_sym_STAR_STAR,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_LBRACE,
    ACTIONS(551), 1,
      anon_sym_not,
    ACTIONS(553), 1,
      anon_sym_lambda,
    ACTIONS(559), 1,
      anon_sym_type,
    ACTIONS(561), 1,
      sym_string_start,
    ACTIONS(645), 1,
      anon_sym_COMMA,
    ACTIONS(647), 1,
      anon_sym_RBRACE,
    STATE(704), 1,
      sym_primary_expression,
    STATE(827), 1,
      sym_list_splat_pattern,
    STATE(1294), 1,
      sym_expression,
    STATE(1470), 1,
      sym_pair,
    STATE(1916), 1,
      sym_dictionary_splat,
    STATE(2143), 1,
      sym__collection_elements,
    STATE(2209), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(555), 2,
      sym_ellipsis,
      sym_float,
    STATE(1830), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(545), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(557), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(533), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1366), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(771), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [3572] = 27,
    ACTIONS(475), 1,
      sym_identifier,
    ACTIONS(479), 1,
      anon_sym_LPAREN,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(485), 1,
      anon_sym_LBRACK,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(499), 1,
      anon_sym_type,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(649), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1130), 1,
      sym_list_splat_pattern,
    STATE(1443), 1,
      sym_expression,
    STATE(1878), 1,
      sym_pattern,
    STATE(2124), 1,
      sym__patterns,
    STATE(2195), 1,
      sym__collection_elements,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    STATE(1126), 2,
      sym_attribute,
      sym_subscript,
    STATE(1988), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    STATE(2101), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(477), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [3686] = 27,
    ACTIONS(503), 1,
      sym_identifier,
    ACTIONS(507), 1,
      anon_sym_LPAREN,
    ACTIONS(509), 1,
      anon_sym_STAR,
    ACTIONS(511), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(521), 1,
      anon_sym_lambda,
    ACTIONS(527), 1,
      anon_sym_type,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(651), 1,
      anon_sym_RBRACK,
    STATE(739), 1,
      sym_primary_expression,
    STATE(1018), 1,
      sym_list_splat_pattern,
    STATE(1325), 1,
      sym_expression,
    STATE(1839), 1,
      sym_pattern,
    STATE(2150), 1,
      sym__patterns,
    STATE(2161), 1,
      sym__named_expression_lhs,
    STATE(2197), 1,
      sym__collection_elements,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1023), 2,
      sym_attribute,
      sym_subscript,
    STATE(1835), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    STATE(2043), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(505), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [3800] = 27,
    ACTIONS(531), 1,
      sym_identifier,
    ACTIONS(537), 1,
      anon_sym_LPAREN,
    ACTIONS(539), 1,
      anon_sym_STAR,
    ACTIONS(541), 1,
      anon_sym_STAR_STAR,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_LBRACE,
    ACTIONS(551), 1,
      anon_sym_not,
    ACTIONS(553), 1,
      anon_sym_lambda,
    ACTIONS(559), 1,
      anon_sym_type,
    ACTIONS(561), 1,
      sym_string_start,
    ACTIONS(653), 1,
      anon_sym_COMMA,
    ACTIONS(655), 1,
      anon_sym_RBRACE,
    STATE(704), 1,
      sym_primary_expression,
    STATE(827), 1,
      sym_list_splat_pattern,
    STATE(1297), 1,
      sym_expression,
    STATE(1476), 1,
      sym_pair,
    STATE(1940), 1,
      sym_dictionary_splat,
    STATE(2209), 1,
      sym__named_expression_lhs,
    STATE(2257), 1,
      sym__collection_elements,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(555), 2,
      sym_ellipsis,
      sym_float,
    STATE(1830), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(545), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(557), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(533), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1366), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(771), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [3914] = 27,
    ACTIONS(475), 1,
      sym_identifier,
    ACTIONS(479), 1,
      anon_sym_LPAREN,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(485), 1,
      anon_sym_LBRACK,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(499), 1,
      anon_sym_type,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(657), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1130), 1,
      sym_list_splat_pattern,
    STATE(1443), 1,
      sym_expression,
    STATE(1878), 1,
      sym_pattern,
    STATE(2195), 1,
      sym__collection_elements,
    STATE(2221), 1,
      sym__patterns,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    STATE(1126), 2,
      sym_attribute,
      sym_subscript,
    STATE(1988), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    STATE(2101), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(477), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [4028] = 27,
    ACTIONS(503), 1,
      sym_identifier,
    ACTIONS(507), 1,
      anon_sym_LPAREN,
    ACTIONS(509), 1,
      anon_sym_STAR,
    ACTIONS(511), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(521), 1,
      anon_sym_lambda,
    ACTIONS(527), 1,
      anon_sym_type,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(659), 1,
      anon_sym_RBRACK,
    STATE(739), 1,
      sym_primary_expression,
    STATE(1018), 1,
      sym_list_splat_pattern,
    STATE(1325), 1,
      sym_expression,
    STATE(1839), 1,
      sym_pattern,
    STATE(2156), 1,
      sym__patterns,
    STATE(2161), 1,
      sym__named_expression_lhs,
    STATE(2197), 1,
      sym__collection_elements,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1023), 2,
      sym_attribute,
      sym_subscript,
    STATE(1835), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    STATE(2043), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(505), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [4142] = 27,
    ACTIONS(475), 1,
      sym_identifier,
    ACTIONS(479), 1,
      anon_sym_LPAREN,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(485), 1,
      anon_sym_LBRACK,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(499), 1,
      anon_sym_type,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(661), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1130), 1,
      sym_list_splat_pattern,
    STATE(1451), 1,
      sym_expression,
    STATE(1878), 1,
      sym_pattern,
    STATE(2125), 1,
      sym__collection_elements,
    STATE(2168), 1,
      sym__patterns,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    STATE(1126), 2,
      sym_attribute,
      sym_subscript,
    STATE(1988), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    STATE(2101), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(477), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [4256] = 27,
    ACTIONS(503), 1,
      sym_identifier,
    ACTIONS(507), 1,
      anon_sym_LPAREN,
    ACTIONS(509), 1,
      anon_sym_STAR,
    ACTIONS(511), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(521), 1,
      anon_sym_lambda,
    ACTIONS(527), 1,
      anon_sym_type,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(663), 1,
      anon_sym_RBRACK,
    STATE(739), 1,
      sym_primary_expression,
    STATE(1018), 1,
      sym_list_splat_pattern,
    STATE(1325), 1,
      sym_expression,
    STATE(1839), 1,
      sym_pattern,
    STATE(2103), 1,
      sym__patterns,
    STATE(2161), 1,
      sym__named_expression_lhs,
    STATE(2197), 1,
      sym__collection_elements,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1023), 2,
      sym_attribute,
      sym_subscript,
    STATE(1835), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    STATE(2043), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(505), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [4370] = 27,
    ACTIONS(503), 1,
      sym_identifier,
    ACTIONS(507), 1,
      anon_sym_LPAREN,
    ACTIONS(509), 1,
      anon_sym_STAR,
    ACTIONS(511), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(521), 1,
      anon_sym_lambda,
    ACTIONS(527), 1,
      anon_sym_type,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(665), 1,
      anon_sym_RBRACK,
    STATE(739), 1,
      sym_primary_expression,
    STATE(1018), 1,
      sym_list_splat_pattern,
    STATE(1325), 1,
      sym_expression,
    STATE(1839), 1,
      sym_pattern,
    STATE(2161), 1,
      sym__named_expression_lhs,
    STATE(2197), 1,
      sym__collection_elements,
    STATE(2225), 1,
      sym__patterns,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1023), 2,
      sym_attribute,
      sym_subscript,
    STATE(1835), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    STATE(2043), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(505), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [4484] = 27,
    ACTIONS(503), 1,
      sym_identifier,
    ACTIONS(507), 1,
      anon_sym_LPAREN,
    ACTIONS(509), 1,
      anon_sym_STAR,
    ACTIONS(511), 1,
      anon_sym_LBRACK,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(521), 1,
      anon_sym_lambda,
    ACTIONS(527), 1,
      anon_sym_type,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(667), 1,
      anon_sym_RBRACK,
    STATE(739), 1,
      sym_primary_expression,
    STATE(1018), 1,
      sym_list_splat_pattern,
    STATE(1312), 1,
      sym_expression,
    STATE(1839), 1,
      sym_pattern,
    STATE(2150), 1,
      sym__patterns,
    STATE(2158), 1,
      sym__collection_elements,
    STATE(2161), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1023), 2,
      sym_attribute,
      sym_subscript,
    STATE(1835), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    STATE(2043), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(505), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [4598] = 24,
    ACTIONS(573), 1,
      sym_identifier,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(579), 1,
      anon_sym_STAR,
    ACTIONS(581), 1,
      anon_sym_STAR_STAR,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(669), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1373), 1,
      sym_expression,
    STATE(1640), 1,
      sym_type,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1652), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [4706] = 25,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(675), 1,
      anon_sym_COMMA,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(679), 1,
      anon_sym_RPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1461), 1,
      sym_expression,
    STATE(1861), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(1860), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [4815] = 23,
    ACTIONS(573), 1,
      sym_identifier,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(579), 1,
      anon_sym_STAR,
    ACTIONS(581), 1,
      anon_sym_STAR_STAR,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1373), 1,
      sym_expression,
    STATE(1531), 1,
      sym_type,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1652), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [4920] = 23,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(689), 1,
      sym_identifier,
    ACTIONS(693), 1,
      anon_sym_LPAREN,
    ACTIONS(695), 1,
      anon_sym_STAR,
    ACTIONS(697), 1,
      anon_sym_STAR_STAR,
    ACTIONS(699), 1,
      anon_sym_type,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1341), 1,
      sym_expression,
    STATE(1533), 1,
      sym_type,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1544), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(691), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [5025] = 23,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(689), 1,
      sym_identifier,
    ACTIONS(693), 1,
      anon_sym_LPAREN,
    ACTIONS(695), 1,
      anon_sym_STAR,
    ACTIONS(697), 1,
      anon_sym_STAR_STAR,
    ACTIONS(699), 1,
      anon_sym_type,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1341), 1,
      sym_expression,
    STATE(1534), 1,
      sym_type,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1544), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(691), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [5130] = 23,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(287), 1,
      anon_sym_STAR_STAR,
    ACTIONS(701), 1,
      sym_identifier,
    ACTIONS(703), 1,
      anon_sym_STAR,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1388), 1,
      sym_expression,
    STATE(1632), 1,
      sym_type,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1658), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [5235] = 20,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(265), 1,
      anon_sym_TILDE,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(705), 1,
      sym_identifier,
    ACTIONS(709), 1,
      anon_sym_LPAREN,
    ACTIONS(711), 1,
      anon_sym_STAR,
    ACTIONS(713), 1,
      anon_sym_LBRACK,
    ACTIONS(715), 1,
      anon_sym_type,
    STATE(1093), 1,
      sym_list_splat_pattern,
    STATE(1270), 1,
      sym_pattern,
    STATE(1280), 1,
      sym_primary_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(259), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    STATE(1102), 2,
      sym_attribute,
      sym_subscript,
    STATE(1260), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(707), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1036), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
    ACTIONS(473), 15,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5334] = 23,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(287), 1,
      anon_sym_STAR_STAR,
    ACTIONS(701), 1,
      sym_identifier,
    ACTIONS(703), 1,
      anon_sym_STAR,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1388), 1,
      sym_expression,
    STATE(2009), 1,
      sym_type,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1658), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [5439] = 25,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(717), 1,
      anon_sym_COMMA,
    ACTIONS(719), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1447), 1,
      sym_expression,
    STATE(1904), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(1853), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [5548] = 23,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(689), 1,
      sym_identifier,
    ACTIONS(693), 1,
      anon_sym_LPAREN,
    ACTIONS(695), 1,
      anon_sym_STAR,
    ACTIONS(697), 1,
      anon_sym_STAR_STAR,
    ACTIONS(699), 1,
      anon_sym_type,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1341), 1,
      sym_expression,
    STATE(1570), 1,
      sym_type,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1544), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(691), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [5653] = 23,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(689), 1,
      sym_identifier,
    ACTIONS(693), 1,
      anon_sym_LPAREN,
    ACTIONS(695), 1,
      anon_sym_STAR,
    ACTIONS(697), 1,
      anon_sym_STAR_STAR,
    ACTIONS(699), 1,
      anon_sym_type,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1341), 1,
      sym_expression,
    STATE(1663), 1,
      sym_type,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1544), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(691), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [5758] = 20,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(265), 1,
      anon_sym_TILDE,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(705), 1,
      sym_identifier,
    ACTIONS(709), 1,
      anon_sym_LPAREN,
    ACTIONS(711), 1,
      anon_sym_STAR,
    ACTIONS(713), 1,
      anon_sym_LBRACK,
    ACTIONS(715), 1,
      anon_sym_type,
    STATE(1093), 1,
      sym_list_splat_pattern,
    STATE(1270), 1,
      sym_pattern,
    STATE(1280), 1,
      sym_primary_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(259), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    STATE(1102), 2,
      sym_attribute,
      sym_subscript,
    STATE(1260), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(707), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1036), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
    ACTIONS(461), 15,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5857] = 23,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(57), 1,
      anon_sym_lambda,
    ACTIONS(67), 1,
      sym_string_start,
    ACTIONS(247), 1,
      anon_sym_type,
    ACTIONS(721), 1,
      sym_identifier,
    ACTIONS(723), 1,
      anon_sym_LPAREN,
    ACTIONS(725), 1,
      anon_sym_STAR,
    ACTIONS(727), 1,
      anon_sym_STAR_STAR,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    STATE(705), 1,
      sym_primary_expression,
    STATE(862), 1,
      sym_list_splat_pattern,
    STATE(1342), 1,
      sym_expression,
    STATE(1504), 1,
      sym_type,
    STATE(2112), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(59), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(51), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(61), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1505), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(214), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1328), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(789), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [5962] = 23,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(287), 1,
      anon_sym_STAR_STAR,
    ACTIONS(701), 1,
      sym_identifier,
    ACTIONS(703), 1,
      anon_sym_STAR,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1388), 1,
      sym_expression,
    STATE(1829), 1,
      sym_type,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1658), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [6067] = 25,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(731), 1,
      anon_sym_COMMA,
    ACTIONS(733), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1467), 1,
      sym_expression,
    STATE(1905), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(1882), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [6176] = 23,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(287), 1,
      anon_sym_STAR_STAR,
    ACTIONS(701), 1,
      sym_identifier,
    ACTIONS(703), 1,
      anon_sym_STAR,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1388), 1,
      sym_expression,
    STATE(1911), 1,
      sym_type,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1658), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [6281] = 25,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(735), 1,
      anon_sym_COMMA,
    ACTIONS(737), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1454), 1,
      sym_expression,
    STATE(1819), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(1818), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [6390] = 23,
    ACTIONS(573), 1,
      sym_identifier,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(579), 1,
      anon_sym_STAR,
    ACTIONS(581), 1,
      anon_sym_STAR_STAR,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1373), 1,
      sym_expression,
    STATE(1638), 1,
      sym_type,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1652), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [6495] = 23,
    ACTIONS(573), 1,
      sym_identifier,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(579), 1,
      anon_sym_STAR,
    ACTIONS(581), 1,
      anon_sym_STAR_STAR,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1373), 1,
      sym_expression,
    STATE(1678), 1,
      sym_type,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1652), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [6600] = 23,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(287), 1,
      anon_sym_STAR_STAR,
    ACTIONS(701), 1,
      sym_identifier,
    ACTIONS(703), 1,
      anon_sym_STAR,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1388), 1,
      sym_expression,
    STATE(1986), 1,
      sym_type,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1658), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [6705] = 23,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(287), 1,
      anon_sym_STAR_STAR,
    ACTIONS(701), 1,
      sym_identifier,
    ACTIONS(703), 1,
      anon_sym_STAR,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1388), 1,
      sym_expression,
    STATE(1865), 1,
      sym_type,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1658), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [6810] = 23,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(57), 1,
      anon_sym_lambda,
    ACTIONS(67), 1,
      sym_string_start,
    ACTIONS(247), 1,
      anon_sym_type,
    ACTIONS(721), 1,
      sym_identifier,
    ACTIONS(723), 1,
      anon_sym_LPAREN,
    ACTIONS(725), 1,
      anon_sym_STAR,
    ACTIONS(727), 1,
      anon_sym_STAR_STAR,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    STATE(705), 1,
      sym_primary_expression,
    STATE(862), 1,
      sym_list_splat_pattern,
    STATE(1342), 1,
      sym_expression,
    STATE(1581), 1,
      sym_type,
    STATE(2112), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(59), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(51), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(61), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1505), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(214), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1328), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(789), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [6915] = 23,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(57), 1,
      anon_sym_lambda,
    ACTIONS(67), 1,
      sym_string_start,
    ACTIONS(247), 1,
      anon_sym_type,
    ACTIONS(721), 1,
      sym_identifier,
    ACTIONS(723), 1,
      anon_sym_LPAREN,
    ACTIONS(725), 1,
      anon_sym_STAR,
    ACTIONS(727), 1,
      anon_sym_STAR_STAR,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    STATE(705), 1,
      sym_primary_expression,
    STATE(862), 1,
      sym_list_splat_pattern,
    STATE(1342), 1,
      sym_expression,
    STATE(1588), 1,
      sym_type,
    STATE(2112), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(59), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(51), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(61), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1505), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(214), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1328), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(789), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [7020] = 25,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(739), 1,
      anon_sym_COMMA,
    ACTIONS(741), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1466), 1,
      sym_expression,
    STATE(1901), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(1900), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [7129] = 25,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(743), 1,
      anon_sym_COMMA,
    ACTIONS(745), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1471), 1,
      sym_expression,
    STATE(1922), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(1921), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [7238] = 25,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(747), 1,
      anon_sym_COMMA,
    ACTIONS(749), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1477), 1,
      sym_expression,
    STATE(1944), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(1943), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [7347] = 23,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(287), 1,
      anon_sym_STAR_STAR,
    ACTIONS(701), 1,
      sym_identifier,
    ACTIONS(703), 1,
      anon_sym_STAR,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1388), 1,
      sym_expression,
    STATE(1631), 1,
      sym_type,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1658), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [7452] = 23,
    ACTIONS(573), 1,
      sym_identifier,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(579), 1,
      anon_sym_STAR,
    ACTIONS(581), 1,
      anon_sym_STAR_STAR,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1373), 1,
      sym_expression,
    STATE(1566), 1,
      sym_type,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1652), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [7557] = 23,
    ACTIONS(573), 1,
      sym_identifier,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(579), 1,
      anon_sym_STAR,
    ACTIONS(581), 1,
      anon_sym_STAR_STAR,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1373), 1,
      sym_expression,
    STATE(1510), 1,
      sym_type,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1652), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [7662] = 23,
    ACTIONS(573), 1,
      sym_identifier,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(579), 1,
      anon_sym_STAR,
    ACTIONS(581), 1,
      anon_sym_STAR_STAR,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1373), 1,
      sym_expression,
    STATE(1527), 1,
      sym_type,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1652), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [7767] = 23,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(287), 1,
      anon_sym_STAR_STAR,
    ACTIONS(701), 1,
      sym_identifier,
    ACTIONS(703), 1,
      anon_sym_STAR,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1388), 1,
      sym_expression,
    STATE(1981), 1,
      sym_type,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1658), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [7872] = 23,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(287), 1,
      anon_sym_STAR_STAR,
    ACTIONS(701), 1,
      sym_identifier,
    ACTIONS(703), 1,
      anon_sym_STAR,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1388), 1,
      sym_expression,
    STATE(1983), 1,
      sym_type,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1658), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [7977] = 23,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(287), 1,
      anon_sym_STAR_STAR,
    ACTIONS(701), 1,
      sym_identifier,
    ACTIONS(703), 1,
      anon_sym_STAR,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1388), 1,
      sym_expression,
    STATE(1984), 1,
      sym_type,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1658), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [8082] = 23,
    ACTIONS(573), 1,
      sym_identifier,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(579), 1,
      anon_sym_STAR,
    ACTIONS(581), 1,
      anon_sym_STAR_STAR,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1373), 1,
      sym_expression,
    STATE(1640), 1,
      sym_type,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    STATE(1652), 5,
      sym_splat_type,
      sym_generic_type,
      sym_union_type,
      sym_constrained_type,
      sym_member_type,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [8187] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(751), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [8293] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(753), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [8399] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(755), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [8505] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(757), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [8611] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(759), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [8717] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(761), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [8823] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(763), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [8929] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(765), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [9035] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(767), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [9141] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(769), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [9247] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(771), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [9353] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(773), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [9459] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(775), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [9565] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(777), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [9671] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(779), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [9777] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(781), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [9883] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(783), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [9989] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(785), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [10095] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(787), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [10201] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(789), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [10307] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(791), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [10413] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(793), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [10519] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(795), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [10625] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(797), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [10731] = 24,
    ACTIONS(799), 1,
      sym_identifier,
    ACTIONS(803), 1,
      anon_sym_LPAREN,
    ACTIONS(805), 1,
      anon_sym_STAR,
    ACTIONS(807), 1,
      anon_sym_LBRACK,
    ACTIONS(811), 1,
      anon_sym_LBRACE,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_lambda,
    ACTIONS(821), 1,
      anon_sym_type,
    ACTIONS(823), 1,
      sym_string_start,
    STATE(703), 1,
      sym_primary_expression,
    STATE(778), 1,
      sym_list_splat_pattern,
    STATE(1356), 1,
      sym_expression,
    STATE(2048), 1,
      sym_pattern,
    STATE(2121), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(817), 2,
      sym_ellipsis,
      sym_float,
    STATE(782), 2,
      sym_attribute,
      sym_subscript,
    STATE(1260), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(809), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(1602), 3,
      sym_expression_list,
      sym_pattern_list,
      sym__f_expression,
    ACTIONS(819), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(801), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1368), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(896), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [10837] = 24,
    ACTIONS(799), 1,
      sym_identifier,
    ACTIONS(803), 1,
      anon_sym_LPAREN,
    ACTIONS(805), 1,
      anon_sym_STAR,
    ACTIONS(807), 1,
      anon_sym_LBRACK,
    ACTIONS(811), 1,
      anon_sym_LBRACE,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_lambda,
    ACTIONS(821), 1,
      anon_sym_type,
    ACTIONS(823), 1,
      sym_string_start,
    STATE(703), 1,
      sym_primary_expression,
    STATE(778), 1,
      sym_list_splat_pattern,
    STATE(1356), 1,
      sym_expression,
    STATE(2048), 1,
      sym_pattern,
    STATE(2121), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(817), 2,
      sym_ellipsis,
      sym_float,
    STATE(782), 2,
      sym_attribute,
      sym_subscript,
    STATE(1260), 2,
      sym_tuple_pattern,
      sym_list_pattern,
    ACTIONS(809), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(1603), 3,
      sym_expression_list,
      sym_pattern_list,
      sym__f_expression,
    ACTIONS(819), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(801), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1368), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(896), 12,
      sym_binary_operator,
      sym_unary_operator,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [10943] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(825), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [11049] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(827), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [11155] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(829), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [11261] = 24,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    ACTIONS(831), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [11367] = 23,
    ACTIONS(531), 1,
      sym_identifier,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_LBRACE,
    ACTIONS(551), 1,
      anon_sym_not,
    ACTIONS(559), 1,
      anon_sym_type,
    ACTIONS(561), 1,
      sym_string_start,
    ACTIONS(835), 1,
      anon_sym_LPAREN,
    ACTIONS(837), 1,
      anon_sym_STAR,
    ACTIONS(839), 1,
      anon_sym_RBRACE,
    ACTIONS(841), 1,
      anon_sym_lambda,
    STATE(704), 1,
      sym_primary_expression,
    STATE(827), 1,
      sym_list_splat_pattern,
    STATE(1397), 1,
      sym_expression,
    STATE(2209), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(555), 2,
      sym_ellipsis,
      sym_float,
    STATE(1591), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(545), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(833), 3,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
    ACTIONS(557), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(533), 5,
      anon_sym_print,
      anon_sym_match,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1366), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(771), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [11470] = 23,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(843), 1,
      sym_identifier,
    ACTIONS(849), 1,
      anon_sym_LPAREN,
    ACTIONS(851), 1,
      anon_sym_STAR,
    ACTIONS(853), 1,
      anon_sym_LBRACK,
    ACTIONS(855), 1,
      anon_sym_RBRACK,
    ACTIONS(857), 1,
      anon_sym_lambda,
    ACTIONS(859), 1,
      anon_sym_type,
    STATE(739), 1,
      sym_primary_expression,
    STATE(947), 1,
      sym_list_splat_pattern,
    STATE(1413), 1,
      sym_expression,
    STATE(2161), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1664), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(847), 3,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(845), 5,
      anon_sym_print,
      anon_sym_match,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [11573] = 23,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(839), 1,
      anon_sym_RBRACK,
    ACTIONS(843), 1,
      sym_identifier,
    ACTIONS(849), 1,
      anon_sym_LPAREN,
    ACTIONS(851), 1,
      anon_sym_STAR,
    ACTIONS(853), 1,
      anon_sym_LBRACK,
    ACTIONS(857), 1,
      anon_sym_lambda,
    ACTIONS(859), 1,
      anon_sym_type,
    STATE(739), 1,
      sym_primary_expression,
    STATE(947), 1,
      sym_list_splat_pattern,
    STATE(1413), 1,
      sym_expression,
    STATE(2161), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1664), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(833), 3,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(845), 5,
      anon_sym_print,
      anon_sym_match,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [11676] = 23,
    ACTIONS(531), 1,
      sym_identifier,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_LBRACE,
    ACTIONS(551), 1,
      anon_sym_not,
    ACTIONS(559), 1,
      anon_sym_type,
    ACTIONS(561), 1,
      sym_string_start,
    ACTIONS(835), 1,
      anon_sym_LPAREN,
    ACTIONS(837), 1,
      anon_sym_STAR,
    ACTIONS(841), 1,
      anon_sym_lambda,
    ACTIONS(863), 1,
      anon_sym_RBRACE,
    STATE(704), 1,
      sym_primary_expression,
    STATE(827), 1,
      sym_list_splat_pattern,
    STATE(1397), 1,
      sym_expression,
    STATE(2209), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(555), 2,
      sym_ellipsis,
      sym_float,
    STATE(1591), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(545), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(861), 3,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
    ACTIONS(557), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(533), 5,
      anon_sym_print,
      anon_sym_match,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1366), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(771), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [11779] = 23,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(843), 1,
      sym_identifier,
    ACTIONS(849), 1,
      anon_sym_LPAREN,
    ACTIONS(851), 1,
      anon_sym_STAR,
    ACTIONS(853), 1,
      anon_sym_LBRACK,
    ACTIONS(857), 1,
      anon_sym_lambda,
    ACTIONS(859), 1,
      anon_sym_type,
    ACTIONS(867), 1,
      anon_sym_RBRACK,
    STATE(739), 1,
      sym_primary_expression,
    STATE(947), 1,
      sym_list_splat_pattern,
    STATE(1413), 1,
      sym_expression,
    STATE(2161), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1664), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(865), 3,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(845), 5,
      anon_sym_print,
      anon_sym_match,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [11882] = 23,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(843), 1,
      sym_identifier,
    ACTIONS(849), 1,
      anon_sym_LPAREN,
    ACTIONS(851), 1,
      anon_sym_STAR,
    ACTIONS(853), 1,
      anon_sym_LBRACK,
    ACTIONS(857), 1,
      anon_sym_lambda,
    ACTIONS(859), 1,
      anon_sym_type,
    ACTIONS(863), 1,
      anon_sym_RBRACK,
    STATE(739), 1,
      sym_primary_expression,
    STATE(947), 1,
      sym_list_splat_pattern,
    STATE(1413), 1,
      sym_expression,
    STATE(2161), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1664), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(861), 3,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(845), 5,
      anon_sym_print,
      anon_sym_match,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [11985] = 23,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(671), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(681), 1,
      anon_sym_STAR,
    ACTIONS(683), 1,
      anon_sym_STAR_STAR,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_type,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1545), 1,
      sym_expression,
    STATE(2030), 1,
      sym_parenthesized_list_splat,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    STATE(2028), 3,
      sym_list_splat,
      sym_dictionary_splat,
      sym_keyword_argument,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(673), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [12088] = 23,
    ACTIONS(531), 1,
      sym_identifier,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_LBRACE,
    ACTIONS(551), 1,
      anon_sym_not,
    ACTIONS(559), 1,
      anon_sym_type,
    ACTIONS(561), 1,
      sym_string_start,
    ACTIONS(835), 1,
      anon_sym_LPAREN,
    ACTIONS(837), 1,
      anon_sym_STAR,
    ACTIONS(841), 1,
      anon_sym_lambda,
    ACTIONS(855), 1,
      anon_sym_RBRACE,
    STATE(704), 1,
      sym_primary_expression,
    STATE(827), 1,
      sym_list_splat_pattern,
    STATE(1397), 1,
      sym_expression,
    STATE(2209), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(555), 2,
      sym_ellipsis,
      sym_float,
    STATE(1591), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(545), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(847), 3,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
    ACTIONS(557), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(533), 5,
      anon_sym_print,
      anon_sym_match,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1366), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(771), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [12191] = 23,
    ACTIONS(531), 1,
      sym_identifier,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_LBRACE,
    ACTIONS(551), 1,
      anon_sym_not,
    ACTIONS(559), 1,
      anon_sym_type,
    ACTIONS(561), 1,
      sym_string_start,
    ACTIONS(835), 1,
      anon_sym_LPAREN,
    ACTIONS(837), 1,
      anon_sym_STAR,
    ACTIONS(841), 1,
      anon_sym_lambda,
    ACTIONS(867), 1,
      anon_sym_RBRACE,
    STATE(704), 1,
      sym_primary_expression,
    STATE(827), 1,
      sym_list_splat_pattern,
    STATE(1397), 1,
      sym_expression,
    STATE(2209), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(555), 2,
      sym_ellipsis,
      sym_float,
    STATE(1591), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(545), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(865), 3,
      anon_sym_if,
      anon_sym_async,
      anon_sym_for,
    ACTIONS(557), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(533), 5,
      anon_sym_print,
      anon_sym_match,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1366), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(771), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [12294] = 24,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_type,
    ACTIONS(869), 1,
      sym_identifier,
    ACTIONS(871), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1472), 1,
      sym_expression,
    STATE(1856), 1,
      sym_with_item,
    STATE(2195), 1,
      sym__collection_elements,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    STATE(1988), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(691), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [12399] = 23,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_type,
    ACTIONS(869), 1,
      sym_identifier,
    ACTIONS(871), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1443), 1,
      sym_expression,
    STATE(2195), 1,
      sym__collection_elements,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    STATE(1988), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(691), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [12501] = 23,
    ACTIONS(509), 1,
      anon_sym_STAR,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(521), 1,
      anon_sym_lambda,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(843), 1,
      sym_identifier,
    ACTIONS(853), 1,
      anon_sym_LBRACK,
    ACTIONS(859), 1,
      anon_sym_type,
    ACTIONS(873), 1,
      anon_sym_LPAREN,
    ACTIONS(875), 1,
      anon_sym_RBRACK,
    STATE(739), 1,
      sym_primary_expression,
    STATE(947), 1,
      sym_list_splat_pattern,
    STATE(1312), 1,
      sym_expression,
    STATE(2158), 1,
      sym__collection_elements,
    STATE(2161), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1835), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(845), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [12603] = 23,
    ACTIONS(249), 1,
      sym_identifier,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(255), 1,
      anon_sym_STAR,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(541), 1,
      anon_sym_STAR_STAR,
    ACTIONS(877), 1,
      anon_sym_RBRACE,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1693), 1,
      sym_expression,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    STATE(2049), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [12705] = 24,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_type,
    ACTIONS(869), 1,
      sym_identifier,
    ACTIONS(879), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1452), 1,
      sym_expression,
    STATE(1886), 1,
      sym_list_splat,
    STATE(1890), 1,
      sym_parenthesized_list_splat,
    STATE(2136), 1,
      sym__collection_elements,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(691), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [12809] = 23,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_type,
    ACTIONS(869), 1,
      sym_identifier,
    ACTIONS(881), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1451), 1,
      sym_expression,
    STATE(2125), 1,
      sym__collection_elements,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    STATE(1988), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(691), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [12911] = 23,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_type,
    ACTIONS(869), 1,
      sym_identifier,
    ACTIONS(883), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1458), 1,
      sym_expression,
    STATE(2179), 1,
      sym__collection_elements,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    STATE(1988), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(691), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [13013] = 23,
    ACTIONS(509), 1,
      anon_sym_STAR,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(521), 1,
      anon_sym_lambda,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(843), 1,
      sym_identifier,
    ACTIONS(853), 1,
      anon_sym_LBRACK,
    ACTIONS(859), 1,
      anon_sym_type,
    ACTIONS(873), 1,
      anon_sym_LPAREN,
    ACTIONS(885), 1,
      anon_sym_RBRACK,
    STATE(739), 1,
      sym_primary_expression,
    STATE(947), 1,
      sym_list_splat_pattern,
    STATE(1332), 1,
      sym_expression,
    STATE(2161), 1,
      sym__named_expression_lhs,
    STATE(2192), 1,
      sym__collection_elements,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1835), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(845), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [13115] = 24,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_type,
    ACTIONS(869), 1,
      sym_identifier,
    ACTIONS(887), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1469), 1,
      sym_expression,
    STATE(1813), 1,
      sym_list_splat,
    STATE(1814), 1,
      sym_parenthesized_list_splat,
    STATE(2132), 1,
      sym__collection_elements,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(691), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [13219] = 21,
    ACTIONS(805), 1,
      anon_sym_STAR,
    ACTIONS(811), 1,
      anon_sym_LBRACE,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_lambda,
    ACTIONS(823), 1,
      sym_string_start,
    ACTIONS(889), 1,
      sym_identifier,
    ACTIONS(895), 1,
      anon_sym_LPAREN,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    ACTIONS(899), 1,
      anon_sym_type,
    STATE(703), 1,
      sym_primary_expression,
    STATE(787), 1,
      sym_list_splat_pattern,
    STATE(1362), 1,
      sym_expression,
    STATE(2121), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(817), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(809), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(819), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(893), 4,
      anon_sym_COLON,
      anon_sym_RBRACE,
      anon_sym_EQ,
      sym_type_conversion,
    ACTIONS(891), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1368), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(896), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [13317] = 23,
    ACTIONS(249), 1,
      sym_identifier,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(255), 1,
      anon_sym_STAR,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(541), 1,
      anon_sym_STAR_STAR,
    ACTIONS(901), 1,
      anon_sym_RBRACE,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1693), 1,
      sym_expression,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    STATE(2049), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [13419] = 23,
    ACTIONS(249), 1,
      sym_identifier,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(255), 1,
      anon_sym_STAR,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(541), 1,
      anon_sym_STAR_STAR,
    ACTIONS(903), 1,
      anon_sym_RBRACE,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1693), 1,
      sym_expression,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    STATE(2049), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [13521] = 23,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_type,
    ACTIONS(869), 1,
      sym_identifier,
    ACTIONS(879), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1452), 1,
      sym_expression,
    STATE(2136), 1,
      sym__collection_elements,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    STATE(1988), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(691), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [13623] = 23,
    ACTIONS(509), 1,
      anon_sym_STAR,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(521), 1,
      anon_sym_lambda,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(843), 1,
      sym_identifier,
    ACTIONS(853), 1,
      anon_sym_LBRACK,
    ACTIONS(859), 1,
      anon_sym_type,
    ACTIONS(873), 1,
      anon_sym_LPAREN,
    ACTIONS(905), 1,
      anon_sym_RBRACK,
    STATE(739), 1,
      sym_primary_expression,
    STATE(947), 1,
      sym_list_splat_pattern,
    STATE(1334), 1,
      sym_expression,
    STATE(2161), 1,
      sym__named_expression_lhs,
    STATE(2227), 1,
      sym__collection_elements,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1835), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(845), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [13725] = 24,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_type,
    ACTIONS(869), 1,
      sym_identifier,
    ACTIONS(883), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1458), 1,
      sym_expression,
    STATE(1997), 1,
      sym_list_splat,
    STATE(1998), 1,
      sym_parenthesized_list_splat,
    STATE(2179), 1,
      sym__collection_elements,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(691), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [13829] = 23,
    ACTIONS(249), 1,
      sym_identifier,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(255), 1,
      anon_sym_STAR,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(541), 1,
      anon_sym_STAR_STAR,
    ACTIONS(907), 1,
      anon_sym_RBRACE,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1693), 1,
      sym_expression,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    STATE(2049), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [13931] = 23,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_type,
    ACTIONS(869), 1,
      sym_identifier,
    ACTIONS(887), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1469), 1,
      sym_expression,
    STATE(2132), 1,
      sym__collection_elements,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    STATE(1988), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(691), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [14033] = 23,
    ACTIONS(509), 1,
      anon_sym_STAR,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(521), 1,
      anon_sym_lambda,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(843), 1,
      sym_identifier,
    ACTIONS(853), 1,
      anon_sym_LBRACK,
    ACTIONS(859), 1,
      anon_sym_type,
    ACTIONS(873), 1,
      anon_sym_LPAREN,
    ACTIONS(909), 1,
      anon_sym_RBRACK,
    STATE(739), 1,
      sym_primary_expression,
    STATE(947), 1,
      sym_list_splat_pattern,
    STATE(1338), 1,
      sym_expression,
    STATE(2161), 1,
      sym__named_expression_lhs,
    STATE(2239), 1,
      sym__collection_elements,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1835), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(845), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [14135] = 23,
    ACTIONS(249), 1,
      sym_identifier,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(255), 1,
      anon_sym_STAR,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(541), 1,
      anon_sym_STAR_STAR,
    ACTIONS(911), 1,
      anon_sym_RBRACE,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1693), 1,
      sym_expression,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    STATE(2049), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [14237] = 23,
    ACTIONS(249), 1,
      sym_identifier,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(255), 1,
      anon_sym_STAR,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(541), 1,
      anon_sym_STAR_STAR,
    ACTIONS(913), 1,
      anon_sym_RBRACE,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1693), 1,
      sym_expression,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    STATE(2049), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [14339] = 23,
    ACTIONS(249), 1,
      sym_identifier,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(255), 1,
      anon_sym_STAR,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(541), 1,
      anon_sym_STAR_STAR,
    ACTIONS(915), 1,
      anon_sym_RBRACE,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1693), 1,
      sym_expression,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    STATE(2049), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [14441] = 23,
    ACTIONS(249), 1,
      sym_identifier,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(255), 1,
      anon_sym_STAR,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(541), 1,
      anon_sym_STAR_STAR,
    ACTIONS(917), 1,
      anon_sym_RBRACE,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1693), 1,
      sym_expression,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    STATE(2049), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [14543] = 23,
    ACTIONS(509), 1,
      anon_sym_STAR,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(521), 1,
      anon_sym_lambda,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(843), 1,
      sym_identifier,
    ACTIONS(853), 1,
      anon_sym_LBRACK,
    ACTIONS(859), 1,
      anon_sym_type,
    ACTIONS(873), 1,
      anon_sym_LPAREN,
    ACTIONS(919), 1,
      anon_sym_RBRACK,
    STATE(739), 1,
      sym_primary_expression,
    STATE(947), 1,
      sym_list_splat_pattern,
    STATE(1325), 1,
      sym_expression,
    STATE(2161), 1,
      sym__named_expression_lhs,
    STATE(2197), 1,
      sym__collection_elements,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1835), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(845), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [14645] = 21,
    ACTIONS(805), 1,
      anon_sym_STAR,
    ACTIONS(811), 1,
      anon_sym_LBRACE,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_lambda,
    ACTIONS(823), 1,
      sym_string_start,
    ACTIONS(889), 1,
      sym_identifier,
    ACTIONS(895), 1,
      anon_sym_LPAREN,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    ACTIONS(899), 1,
      anon_sym_type,
    STATE(703), 1,
      sym_primary_expression,
    STATE(787), 1,
      sym_list_splat_pattern,
    STATE(1362), 1,
      sym_expression,
    STATE(2121), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(817), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(809), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(819), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(921), 4,
      anon_sym_COLON,
      anon_sym_RBRACE,
      anon_sym_EQ,
      sym_type_conversion,
    ACTIONS(891), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1368), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(896), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [14743] = 23,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_type,
    ACTIONS(869), 1,
      sym_identifier,
    ACTIONS(923), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1463), 1,
      sym_expression,
    STATE(2224), 1,
      sym__collection_elements,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    STATE(1988), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(691), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [14845] = 23,
    ACTIONS(509), 1,
      anon_sym_STAR,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(521), 1,
      anon_sym_lambda,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(843), 1,
      sym_identifier,
    ACTIONS(853), 1,
      anon_sym_LBRACK,
    ACTIONS(859), 1,
      anon_sym_type,
    ACTIONS(873), 1,
      anon_sym_LPAREN,
    ACTIONS(925), 1,
      anon_sym_RBRACK,
    STATE(739), 1,
      sym_primary_expression,
    STATE(947), 1,
      sym_list_splat_pattern,
    STATE(1336), 1,
      sym_expression,
    STATE(2133), 1,
      sym__collection_elements,
    STATE(2161), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1835), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(845), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [14947] = 23,
    ACTIONS(249), 1,
      sym_identifier,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(255), 1,
      anon_sym_STAR,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(541), 1,
      anon_sym_STAR_STAR,
    ACTIONS(927), 1,
      anon_sym_RBRACE,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1693), 1,
      sym_expression,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    STATE(2049), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [15049] = 23,
    ACTIONS(249), 1,
      sym_identifier,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(255), 1,
      anon_sym_STAR,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(541), 1,
      anon_sym_STAR_STAR,
    ACTIONS(929), 1,
      anon_sym_RBRACE,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1693), 1,
      sym_expression,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    STATE(2049), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [15151] = 23,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_type,
    ACTIONS(869), 1,
      sym_identifier,
    ACTIONS(931), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1475), 1,
      sym_expression,
    STATE(2237), 1,
      sym__collection_elements,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    STATE(1988), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(691), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [15253] = 23,
    ACTIONS(509), 1,
      anon_sym_STAR,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(521), 1,
      anon_sym_lambda,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(843), 1,
      sym_identifier,
    ACTIONS(853), 1,
      anon_sym_LBRACK,
    ACTIONS(859), 1,
      anon_sym_type,
    ACTIONS(873), 1,
      anon_sym_LPAREN,
    ACTIONS(933), 1,
      anon_sym_RBRACK,
    STATE(739), 1,
      sym_primary_expression,
    STATE(947), 1,
      sym_list_splat_pattern,
    STATE(1330), 1,
      sym_expression,
    STATE(2161), 1,
      sym__named_expression_lhs,
    STATE(2213), 1,
      sym__collection_elements,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1835), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(845), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [15355] = 24,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_type,
    ACTIONS(869), 1,
      sym_identifier,
    ACTIONS(931), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1475), 1,
      sym_expression,
    STATE(1997), 1,
      sym_list_splat,
    STATE(1998), 1,
      sym_parenthesized_list_splat,
    STATE(2237), 1,
      sym__collection_elements,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(691), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [15459] = 23,
    ACTIONS(249), 1,
      sym_identifier,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(255), 1,
      anon_sym_STAR,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(541), 1,
      anon_sym_STAR_STAR,
    ACTIONS(935), 1,
      anon_sym_RBRACE,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1693), 1,
      sym_expression,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    STATE(2049), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [15561] = 23,
    ACTIONS(249), 1,
      sym_identifier,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(255), 1,
      anon_sym_STAR,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(541), 1,
      anon_sym_STAR_STAR,
    ACTIONS(937), 1,
      anon_sym_RBRACE,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1693), 1,
      sym_expression,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    STATE(2049), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [15663] = 23,
    ACTIONS(249), 1,
      sym_identifier,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(255), 1,
      anon_sym_STAR,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(541), 1,
      anon_sym_STAR_STAR,
    ACTIONS(939), 1,
      anon_sym_RBRACE,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1693), 1,
      sym_expression,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    STATE(2049), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [15765] = 23,
    ACTIONS(249), 1,
      sym_identifier,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(255), 1,
      anon_sym_STAR,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(541), 1,
      anon_sym_STAR_STAR,
    ACTIONS(941), 1,
      anon_sym_RBRACE,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1693), 1,
      sym_expression,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    STATE(2049), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [15867] = 24,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_type,
    ACTIONS(869), 1,
      sym_identifier,
    ACTIONS(923), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1463), 1,
      sym_expression,
    STATE(1813), 1,
      sym_list_splat,
    STATE(1814), 1,
      sym_parenthesized_list_splat,
    STATE(2224), 1,
      sym__collection_elements,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(691), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [15971] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(949), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [16072] = 22,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(57), 1,
      anon_sym_lambda,
    ACTIONS(67), 1,
      sym_string_start,
    ACTIONS(210), 1,
      sym_identifier,
    ACTIONS(247), 1,
      anon_sym_type,
    ACTIONS(723), 1,
      anon_sym_LPAREN,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(953), 1,
      anon_sym_STAR,
    STATE(705), 1,
      sym_primary_expression,
    STATE(862), 1,
      sym_list_splat_pattern,
    STATE(1420), 1,
      sym_expression,
    STATE(2015), 1,
      sym_expression_list,
    STATE(2112), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(59), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(951), 2,
      sym__newline,
      anon_sym_SEMI,
    ACTIONS(51), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(61), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(214), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1328), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(789), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [16171] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(955), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [16272] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(957), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [16373] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(959), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [16474] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(961), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [16575] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(963), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [16676] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(965), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [16777] = 22,
    ACTIONS(249), 1,
      sym_identifier,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(255), 1,
      anon_sym_STAR,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(541), 1,
      anon_sym_STAR_STAR,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1693), 1,
      sym_expression,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    STATE(2049), 2,
      sym_dictionary_splat,
      sym_pair,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [16876] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(967), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [16977] = 22,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(969), 1,
      anon_sym_LPAREN,
    ACTIONS(971), 1,
      anon_sym_STAR,
    ACTIONS(973), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1564), 1,
      sym_expression,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    STATE(2099), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [17076] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(975), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [17177] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(977), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [17278] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(979), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [17379] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(981), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [17480] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(983), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [17581] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(985), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [17682] = 22,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(989), 1,
      anon_sym_COLON,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1437), 1,
      sym_expression,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(987), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [17781] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(991), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [17882] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(993), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [17983] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(995), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [18084] = 22,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(969), 1,
      anon_sym_LPAREN,
    ACTIONS(971), 1,
      anon_sym_STAR,
    ACTIONS(997), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1564), 1,
      sym_expression,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    STATE(2099), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [18183] = 22,
    ACTIONS(811), 1,
      anon_sym_LBRACE,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_lambda,
    ACTIONS(823), 1,
      sym_string_start,
    ACTIONS(889), 1,
      sym_identifier,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    ACTIONS(899), 1,
      anon_sym_type,
    ACTIONS(997), 1,
      anon_sym_RBRACE,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1001), 1,
      anon_sym_STAR,
    STATE(703), 1,
      sym_primary_expression,
    STATE(787), 1,
      sym_list_splat_pattern,
    STATE(1551), 1,
      sym_expression,
    STATE(2121), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(817), 2,
      sym_ellipsis,
      sym_float,
    STATE(2026), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(809), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(819), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(891), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1368), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(896), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [18282] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(1003), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [18383] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(1005), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [18484] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(1007), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [18585] = 22,
    ACTIONS(811), 1,
      anon_sym_LBRACE,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_lambda,
    ACTIONS(823), 1,
      sym_string_start,
    ACTIONS(889), 1,
      sym_identifier,
    ACTIONS(897), 1,
      anon_sym_LBRACK,
    ACTIONS(899), 1,
      anon_sym_type,
    ACTIONS(973), 1,
      anon_sym_RBRACE,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1001), 1,
      anon_sym_STAR,
    STATE(703), 1,
      sym_primary_expression,
    STATE(787), 1,
      sym_list_splat_pattern,
    STATE(1551), 1,
      sym_expression,
    STATE(2121), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(817), 2,
      sym_ellipsis,
      sym_float,
    STATE(2026), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(809), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(819), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(891), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1368), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(896), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [18684] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(1009), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [18785] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(1011), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [18886] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(1013), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [18987] = 22,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_type,
    ACTIONS(869), 1,
      sym_identifier,
    ACTIONS(997), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1537), 1,
      sym_expression,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    STATE(2018), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(691), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [19086] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(1015), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [19187] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(1017), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [19288] = 22,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(1021), 1,
      anon_sym_COLON,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1456), 1,
      sym_expression,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(1019), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [19387] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(1023), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [19488] = 23,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    ACTIONS(1025), 1,
      anon_sym_RBRACK,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1464), 1,
      sym_expression,
    STATE(2040), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [19589] = 22,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_type,
    ACTIONS(869), 1,
      sym_identifier,
    ACTIONS(973), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1537), 1,
      sym_expression,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    STATE(2018), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(691), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [19688] = 22,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1432), 1,
      sym_expression,
    STATE(1959), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [19786] = 10,
    ACTIONS(216), 1,
      anon_sym_COMMA,
    ACTIONS(223), 1,
      anon_sym_COLON_EQ,
    ACTIONS(1027), 1,
      anon_sym_for,
    ACTIONS(1029), 1,
      anon_sym_with,
    ACTIONS(1031), 1,
      anon_sym_def,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(240), 2,
      anon_sym_COLON,
      anon_sym_EQ,
    ACTIONS(245), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
    ACTIONS(221), 15,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_DASH,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(212), 16,
      sym__newline,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_as,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
  [19860] = 21,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(947), 1,
      anon_sym_STAR,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1517), 1,
      sym_expression,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(1033), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [19956] = 21,
    ACTIONS(531), 1,
      sym_identifier,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_LBRACE,
    ACTIONS(551), 1,
      anon_sym_not,
    ACTIONS(559), 1,
      anon_sym_type,
    ACTIONS(561), 1,
      sym_string_start,
    ACTIONS(835), 1,
      anon_sym_LPAREN,
    ACTIONS(837), 1,
      anon_sym_STAR,
    ACTIONS(841), 1,
      anon_sym_lambda,
    STATE(704), 1,
      sym_primary_expression,
    STATE(827), 1,
      sym_list_splat_pattern,
    STATE(1397), 1,
      sym_expression,
    STATE(2209), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(555), 2,
      sym_ellipsis,
      sym_float,
    STATE(1563), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(545), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(557), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(533), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1366), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(771), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [20052] = 22,
    ACTIONS(249), 1,
      sym_identifier,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(1035), 1,
      anon_sym_LPAREN,
    ACTIONS(1037), 1,
      anon_sym_STAR,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1520), 1,
      sym_expression,
    STATE(2010), 1,
      sym_with_item,
    STATE(2115), 1,
      sym_with_clause,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [20150] = 21,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(843), 1,
      sym_identifier,
    ACTIONS(849), 1,
      anon_sym_LPAREN,
    ACTIONS(851), 1,
      anon_sym_STAR,
    ACTIONS(853), 1,
      anon_sym_LBRACK,
    ACTIONS(857), 1,
      anon_sym_lambda,
    ACTIONS(859), 1,
      anon_sym_type,
    STATE(739), 1,
      sym_primary_expression,
    STATE(947), 1,
      sym_list_splat_pattern,
    STATE(1413), 1,
      sym_expression,
    STATE(2161), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1664), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(845), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [20246] = 21,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(57), 1,
      anon_sym_lambda,
    ACTIONS(67), 1,
      sym_string_start,
    ACTIONS(210), 1,
      sym_identifier,
    ACTIONS(247), 1,
      anon_sym_type,
    ACTIONS(723), 1,
      anon_sym_LPAREN,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(953), 1,
      anon_sym_STAR,
    STATE(705), 1,
      sym_primary_expression,
    STATE(862), 1,
      sym_list_splat_pattern,
    STATE(1478), 1,
      sym_expression,
    STATE(2112), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(59), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(1039), 2,
      sym__newline,
      anon_sym_SEMI,
    ACTIONS(51), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(61), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(214), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1328), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(789), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [20342] = 21,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(947), 1,
      anon_sym_STAR,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1556), 1,
      sym_expression,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(987), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [20438] = 22,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(693), 1,
      anon_sym_LPAREN,
    ACTIONS(699), 1,
      anon_sym_type,
    ACTIONS(869), 1,
      sym_identifier,
    ACTIONS(1041), 1,
      anon_sym_RPAREN,
    ACTIONS(1043), 1,
      anon_sym_STAR,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1590), 1,
      sym_expression,
    STATE(2087), 1,
      sym_with_item,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(691), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [20536] = 21,
    ACTIONS(531), 1,
      sym_identifier,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_LBRACE,
    ACTIONS(551), 1,
      anon_sym_not,
    ACTIONS(559), 1,
      anon_sym_type,
    ACTIONS(561), 1,
      sym_string_start,
    ACTIONS(835), 1,
      anon_sym_LPAREN,
    ACTIONS(837), 1,
      anon_sym_STAR,
    ACTIONS(841), 1,
      anon_sym_lambda,
    STATE(704), 1,
      sym_primary_expression,
    STATE(827), 1,
      sym_list_splat_pattern,
    STATE(1397), 1,
      sym_expression,
    STATE(2209), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(555), 2,
      sym_ellipsis,
      sym_float,
    STATE(1552), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(545), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(557), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(533), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1366), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(771), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [20632] = 21,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(57), 1,
      anon_sym_lambda,
    ACTIONS(67), 1,
      sym_string_start,
    ACTIONS(210), 1,
      sym_identifier,
    ACTIONS(247), 1,
      anon_sym_type,
    ACTIONS(723), 1,
      anon_sym_LPAREN,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(953), 1,
      anon_sym_STAR,
    STATE(705), 1,
      sym_primary_expression,
    STATE(862), 1,
      sym_list_splat_pattern,
    STATE(1455), 1,
      sym_expression,
    STATE(2112), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(59), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(1045), 2,
      sym__newline,
      anon_sym_SEMI,
    ACTIONS(51), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(61), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(214), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1328), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(789), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [20728] = 22,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(693), 1,
      anon_sym_LPAREN,
    ACTIONS(699), 1,
      anon_sym_type,
    ACTIONS(869), 1,
      sym_identifier,
    ACTIONS(1043), 1,
      anon_sym_STAR,
    ACTIONS(1047), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1590), 1,
      sym_expression,
    STATE(2087), 1,
      sym_with_item,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(691), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [20826] = 21,
    ACTIONS(531), 1,
      sym_identifier,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_LBRACE,
    ACTIONS(551), 1,
      anon_sym_not,
    ACTIONS(559), 1,
      anon_sym_type,
    ACTIONS(561), 1,
      sym_string_start,
    ACTIONS(835), 1,
      anon_sym_LPAREN,
    ACTIONS(837), 1,
      anon_sym_STAR,
    ACTIONS(841), 1,
      anon_sym_lambda,
    STATE(704), 1,
      sym_primary_expression,
    STATE(827), 1,
      sym_list_splat_pattern,
    STATE(1405), 1,
      sym_expression,
    STATE(2209), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(555), 2,
      sym_ellipsis,
      sym_float,
    STATE(1675), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(545), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(557), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(533), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1366), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(771), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [20922] = 22,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
    ACTIONS(589), 1,
      anon_sym_LBRACE,
    ACTIONS(591), 1,
      anon_sym_not,
    ACTIONS(593), 1,
      anon_sym_lambda,
    ACTIONS(599), 1,
      anon_sym_type,
    ACTIONS(601), 1,
      sym_string_start,
    ACTIONS(943), 1,
      sym_identifier,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(947), 1,
      anon_sym_STAR,
    STATE(905), 1,
      sym_primary_expression,
    STATE(1099), 1,
      sym_list_splat_pattern,
    STATE(1427), 1,
      sym_expression,
    STATE(1912), 1,
      sym_slice,
    STATE(2222), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(595), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(587), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(597), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(575), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1391), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1092), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [21020] = 21,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(843), 1,
      sym_identifier,
    ACTIONS(849), 1,
      anon_sym_LPAREN,
    ACTIONS(851), 1,
      anon_sym_STAR,
    ACTIONS(853), 1,
      anon_sym_LBRACK,
    ACTIONS(857), 1,
      anon_sym_lambda,
    ACTIONS(859), 1,
      anon_sym_type,
    STATE(739), 1,
      sym_primary_expression,
    STATE(947), 1,
      sym_list_splat_pattern,
    STATE(1413), 1,
      sym_expression,
    STATE(2161), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1557), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(845), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [21116] = 21,
    ACTIONS(531), 1,
      sym_identifier,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_LBRACE,
    ACTIONS(551), 1,
      anon_sym_not,
    ACTIONS(559), 1,
      anon_sym_type,
    ACTIONS(561), 1,
      sym_string_start,
    ACTIONS(835), 1,
      anon_sym_LPAREN,
    ACTIONS(837), 1,
      anon_sym_STAR,
    ACTIONS(841), 1,
      anon_sym_lambda,
    STATE(704), 1,
      sym_primary_expression,
    STATE(827), 1,
      sym_list_splat_pattern,
    STATE(1410), 1,
      sym_expression,
    STATE(2209), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(555), 2,
      sym_ellipsis,
      sym_float,
    STATE(1669), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(545), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(557), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(533), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1366), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(771), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [21212] = 21,
    ACTIONS(531), 1,
      sym_identifier,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(547), 1,
      anon_sym_LBRACE,
    ACTIONS(551), 1,
      anon_sym_not,
    ACTIONS(559), 1,
      anon_sym_type,
    ACTIONS(561), 1,
      sym_string_start,
    ACTIONS(835), 1,
      anon_sym_LPAREN,
    ACTIONS(837), 1,
      anon_sym_STAR,
    ACTIONS(841), 1,
      anon_sym_lambda,
    STATE(704), 1,
      sym_primary_expression,
    STATE(827), 1,
      sym_list_splat_pattern,
    STATE(1397), 1,
      sym_expression,
    STATE(2209), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(555), 2,
      sym_ellipsis,
      sym_float,
    STATE(1591), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(545), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(557), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(533), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1366), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(771), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [21308] = 21,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(57), 1,
      anon_sym_lambda,
    ACTIONS(67), 1,
      sym_string_start,
    ACTIONS(210), 1,
      sym_identifier,
    ACTIONS(247), 1,
      anon_sym_type,
    ACTIONS(723), 1,
      anon_sym_LPAREN,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(953), 1,
      anon_sym_STAR,
    STATE(705), 1,
      sym_primary_expression,
    STATE(862), 1,
      sym_list_splat_pattern,
    STATE(1455), 1,
      sym_expression,
    STATE(2112), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(59), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(893), 2,
      sym__newline,
      anon_sym_SEMI,
    ACTIONS(51), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(61), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(214), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1328), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(789), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [21404] = 11,
    ACTIONS(67), 1,
      sym_string_start,
    ACTIONS(216), 1,
      anon_sym_COMMA,
    ACTIONS(223), 1,
      anon_sym_COLON_EQ,
    ACTIONS(225), 1,
      anon_sym_COLON,
    ACTIONS(240), 1,
      anon_sym_EQ,
    ACTIONS(1049), 1,
      sym_identifier,
    STATE(1923), 1,
      sym_string,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(212), 10,
      sym__newline,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
    ACTIONS(245), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
    ACTIONS(221), 21,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_DASH,
      anon_sym_as,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
  [21480] = 22,
    ACTIONS(249), 1,
      sym_identifier,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(1037), 1,
      anon_sym_STAR,
    ACTIONS(1051), 1,
      anon_sym_COLON,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1520), 1,
      sym_expression,
    STATE(2065), 1,
      sym_with_item,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [21578] = 21,
    ACTIONS(483), 1,
      anon_sym_STAR,
    ACTIONS(489), 1,
      anon_sym_LBRACE,
    ACTIONS(491), 1,
      anon_sym_not,
    ACTIONS(493), 1,
      anon_sym_lambda,
    ACTIONS(501), 1,
      sym_string_start,
    ACTIONS(677), 1,
      anon_sym_LPAREN,
    ACTIONS(685), 1,
      anon_sym_LBRACK,
    ACTIONS(699), 1,
      anon_sym_type,
    ACTIONS(869), 1,
      sym_identifier,
    STATE(751), 1,
      sym_primary_expression,
    STATE(1029), 1,
      sym_list_splat_pattern,
    STATE(1537), 1,
      sym_expression,
    STATE(2248), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(495), 2,
      sym_ellipsis,
      sym_float,
    STATE(2018), 2,
      sym_list_splat,
      sym_parenthesized_list_splat,
    ACTIONS(487), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(497), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(691), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1349), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(925), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [21674] = 10,
    ACTIONS(67), 1,
      sym_string_start,
    ACTIONS(216), 1,
      anon_sym_COMMA,
    ACTIONS(223), 1,
      anon_sym_COLON_EQ,
    ACTIONS(1049), 1,
      sym_identifier,
    STATE(1923), 1,
      sym_string,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(240), 2,
      anon_sym_COLON,
      anon_sym_EQ,
    ACTIONS(212), 10,
      sym__newline,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
    ACTIONS(245), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
    ACTIONS(221), 21,
      anon_sym_GT_GT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_DASH,
      anon_sym_as,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
  [21748] = 21,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(55), 1,
      anon_sym_not,
    ACTIONS(57), 1,
      anon_sym_lambda,
    ACTIONS(67), 1,
      sym_string_start,
    ACTIONS(210), 1,
      sym_identifier,
    ACTIONS(247), 1,
      anon_sym_type,
    ACTIONS(723), 1,
      anon_sym_LPAREN,
    ACTIONS(729), 1,
      anon_sym_LBRACK,
    ACTIONS(953), 1,
      anon_sym_STAR,
    STATE(705), 1,
      sym_primary_expression,
    STATE(862), 1,
      sym_list_splat_pattern,
    STATE(1455), 1,
      sym_expression,
    STATE(2112), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(59), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(1053), 2,
      sym__newline,
      anon_sym_SEMI,
    ACTIONS(51), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(61), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(214), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1328), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(789), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [21844] = 10,
    ACTIONS(216), 1,
      anon_sym_COMMA,
    ACTIONS(223), 1,
      anon_sym_COLON_EQ,
    ACTIONS(1055), 1,
      anon_sym_for,
    ACTIONS(1057), 1,
      anon_sym_with,
    ACTIONS(1059), 1,
      anon_sym_def,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(240), 2,
      anon_sym_COLON,
      anon_sym_EQ,
    ACTIONS(245), 13,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_AT_EQ,
      anon_sym_SLASH_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
    ACTIONS(221), 15,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_AT,
      anon_sym_DASH,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_SLASH_SLASH,
      anon_sym_AMP,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(212), 16,
      sym__newline,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_as,
      anon_sym_not,
      anon_sym_and,
      anon_sym_or,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_GT,
  [21918] = 21,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(843), 1,
      sym_identifier,
    ACTIONS(849), 1,
      anon_sym_LPAREN,
    ACTIONS(851), 1,
      anon_sym_STAR,
    ACTIONS(853), 1,
      anon_sym_LBRACK,
    ACTIONS(857), 1,
      anon_sym_lambda,
    ACTIONS(859), 1,
      anon_sym_type,
    STATE(739), 1,
      sym_primary_expression,
    STATE(947), 1,
      sym_list_splat_pattern,
    STATE(1413), 1,
      sym_expression,
    STATE(2161), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1511), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(845), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [22014] = 22,
    ACTIONS(249), 1,
      sym_identifier,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_LBRACE,
    ACTIONS(263), 1,
      anon_sym_not,
    ACTIONS(267), 1,
      anon_sym_lambda,
    ACTIONS(273), 1,
      anon_sym_type,
    ACTIONS(275), 1,
      sym_string_start,
    ACTIONS(1037), 1,
      anon_sym_STAR,
    ACTIONS(1061), 1,
      anon_sym_COLON,
    STATE(750), 1,
      sym_primary_expression,
    STATE(1046), 1,
      sym_list_splat_pattern,
    STATE(1520), 1,
      sym_expression,
    STATE(2065), 1,
      sym_with_item,
    STATE(2164), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(269), 2,
      sym_ellipsis,
      sym_float,
    ACTIONS(265), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(271), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(251), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1358), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1036), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [22112] = 21,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(843), 1,
      sym_identifier,
    ACTIONS(849), 1,
      anon_sym_LPAREN,
    ACTIONS(851), 1,
      anon_sym_STAR,
    ACTIONS(853), 1,
      anon_sym_LBRACK,
    ACTIONS(857), 1,
      anon_sym_lambda,
    ACTIONS(859), 1,
      anon_sym_type,
    STATE(739), 1,
      sym_primary_expression,
    STATE(947), 1,
      sym_list_splat_pattern,
    STATE(1395), 1,
      sym_expression,
    STATE(2161), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1643), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(845), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [22208] = 21,
    ACTIONS(517), 1,
      anon_sym_LBRACE,
    ACTIONS(519), 1,
      anon_sym_not,
    ACTIONS(529), 1,
      sym_string_start,
    ACTIONS(843), 1,
      sym_identifier,
    ACTIONS(849), 1,
      anon_sym_LPAREN,
    ACTIONS(851), 1,
      anon_sym_STAR,
    ACTIONS(853), 1,
      anon_sym_LBRACK,
    ACTIONS(857), 1,
      anon_sym_lambda,
    ACTIONS(859), 1,
      anon_sym_type,
    STATE(739), 1,
      sym_primary_expression,
    STATE(947), 1,
      sym_list_splat_pattern,
    STATE(1426), 1,
      sym_expression,
    STATE(2161), 1,
      sym__named_expression_lhs,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(523), 2,
      sym_ellipsis,
      sym_float,
    STATE(1657), 2,
      sym__expression_within_for_in_clause,
      sym_lambda_within_for_in_clause,
    ACTIONS(515), 3,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(525), 4,
      sym_integer,
      sym_true,
      sym_false,
      sym_none,
    ACTIONS(845), 6,
      anon_sym_print,
      anon_sym_match,
      anon_sym_async,
      anon_sym_exec,
      anon_sym_await,
      anon_sym_struct,
    STATE(1392), 7,
      sym_named_expression,
      sym_as_pattern,
      sym_not_operator,
      sym_boolean_operator,
      sym_comparison_operator,
      sym_lambda,
      sym_conditional_expression,
    STATE(1015), 14,
      sym_binary_operator,
      sym_unary_operator,
      sym_attribute,
      sym_subscript,
      sym_call,
      sym_list,
      sym_set,
      sym_tuple,
      sym_dictionary,
      sym_list_comprehension,
      sym_dictionary_comprehension,
      sym_set_comprehension,
      sym_parenthesized_expression,
      sym_string,
  [22304] = 22,
    ACTIONS(577), 1,
      anon_sym_LPAREN,
    ACTIONS(583), 1,
      anon_sym_LBRACK,
   