/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import sun.nio.ch.DefaultAsynchronousChannelProvider;

public abstract class AsynchronousChannelProvider {
    protected AsynchronousChannelProvider() {
    }

    public static AsynchronousChannelProvider provider() {
        return null;
    }

    public abstract AsynchronousChannelGroup openAsynchronousChannelGroup(int var1, ThreadFactory var2) throws IOException;

    public abstract AsynchronousChannelGroup openAsynchronousChannelGroup(ExecutorService var1, int var2) throws IOException;

    public abstract AsynchronousServerSocketChannel openAsynchronousServerSocketChannel(AsynchronousChannelGroup var1) throws IOException;

    public abstract AsynchronousSocketChannel openAsynchronousSocketChannel(AsynchronousChannelGroup var1) throws IOException;

    private static class ProviderHolder {
        static final AsynchronousChannelProvider provider = ProviderHolder.load();

        private ProviderHolder() {
        }

        private static AsynchronousChannelProvider load() {
            return AccessController.doPrivileged(new PrivilegedAction<AsynchronousChannelProvider>(){

                @Override
                public AsynchronousChannelProvider run() {
                    AsynchronousChannelProvider p = ProviderHolder.loadProviderFromProperty();
                    if (p != null) {
                        return p;
                    }
                    p = ProviderHolder.loadProviderAsService();
                    if (p != null) {
                        return p;
                    }
                    return DefaultAsynchronousChannelProvider.create();
                }
            });
        }

        private static AsynchronousChannelProvider loadProviderFromProperty() {
            String cn = System.getProperty("java.nio.channels.spi.AsynchronousChannelProvider");
            if (cn == null) {
                return null;
            }
            try {
                Object tmp = Class.forName(cn, true, ClassLoader.getSystemClassLoader()).newInstance();
                return (AsynchronousChannelProvider)tmp;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SecurityException x) {
                throw new ServiceConfigurationError(null, x);
            }
        }

        private static AsynchronousChannelProvider loadProviderAsService() {
            ServiceLoader<AsynchronousChannelProvider> sl = ServiceLoader.load(AsynchronousChannelProvider.class, ClassLoader.getSystemClassLoader());
            Iterator<AsynchronousChannelProvider> i = sl.iterator();
            while (true) {
                try {
                    return i.hasNext() ? i.next() : null;
                }
                catch (ServiceConfigurationError sce) {
                    if (sce.getCause() instanceof SecurityException) continue;
                    throw sce;
                }
                break;
            }
        }
    }
}

