/*
 * cg-scan.c
 *
 * Description of this file:
 *    CG-Scan functions definition of the xavs2 library
 *
 * --------------------------------------------------------------------------
 *
 *    xavs2 - video encoder of AVS2/IEEE1857.4 video coding standard
 *    Copyright (C) 2018~ VCL, NELVT, Peking University
 *
 *    Authors: Falei LUO <falei.luo@gmail.com>
 *             etc.
 *
 *    Homepage1: http://vcl.idm.pku.edu.cn/xavs2
 *    Homepage2: https://github.com/pkuvcl/xavs2
 *    Homepage3: https://gitee.com/pkuvcl/xavs2
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02111, USA.
 *
 *    This program is also available under a commercial proprietary license.
 *    For more information, contact us at sswang @ pku.edu.cn.
 */


#include "common.h"
#include "primitives.h"
#include "block_info.h"
#include "cpu.h"

/**
 * ===========================================================================
 * global variables (const tables)
 * ===========================================================================
 */

/* ---------------------------------------------------------------------------
 */
ALIGN32(const int16_t tab_scan_2x2[4][2]) = {
    { 0, 0 }, { 1, 0 }, { 0, 1 }, { 1, 1 }
};

/* ---------------------------------------------------------------------------
 */
ALIGN32(const int16_t tab_scan_4x4[16][2]) = {
    { 0, 0 }, { 1, 0 }, { 0, 1 }, { 0, 2 },
    { 1, 1 }, { 2, 0 }, { 3, 0 }, { 2, 1 },
    { 1, 2 }, { 0, 3 }, { 1, 3 }, { 2, 2 },
    { 3, 1 }, { 3, 2 }, { 2, 3 }, { 3, 3 }
};

/* ---------------------------------------------------------------------------
 */
ALIGN32(const int16_t tab_scan_4x4_yx[16][2]) = {
    { 0, 0 }, { 0, 1 }, { 1, 0 }, { 2, 0 },
    { 1, 1 }, { 0, 2 }, { 0, 3 }, { 1, 2 },
    { 2, 1 }, { 3, 0 }, { 3, 1 }, { 2, 2 },
    { 1, 3 }, { 2, 3 }, { 3, 2 }, { 3, 3 }
};

/* ---------------------------------------------------------------------------
 */
ALIGN32(const int16_t tab_scan_8x8[64][2]) = {
    { 0, 0 }, { 1, 0 }, { 0, 1 }, { 0, 2 }, { 1, 1 }, { 2, 0 }, { 3, 0 }, { 2, 1 },
    { 1, 2 }, { 0, 3 }, { 0, 4 }, { 1, 3 }, { 2, 2 }, { 3, 1 }, { 4, 0 }, { 5, 0 },
    { 4, 1 }, { 3, 2 }, { 2, 3 }, { 1, 4 }, { 0, 5 }, { 0, 6 }, { 1, 5 }, { 2, 4 },
    { 3, 3 }, { 4, 2 }, { 5, 1 }, { 6, 0 }, { 7, 0 }, { 6, 1 }, { 5, 2 }, { 4, 3 },
    { 3, 4 }, { 2, 5 }, { 1, 6 }, { 0, 7 }, { 1, 7 }, { 2, 6 }, { 3, 5 }, { 4, 4 },
    { 5, 3 }, { 6, 2 }, { 7, 1 }, { 7, 2 }, { 6, 3 }, { 5, 4 }, { 4, 5 }, { 3, 6 },
    { 2, 7 }, { 3, 7 }, { 4, 6 }, { 5, 5 }, { 6, 4 }, { 7, 3 }, { 7, 4 }, { 6, 5 },
    { 5, 6 }, { 4, 7 }, { 5, 7 }, { 6, 6 }, { 7, 5 }, { 7, 6 }, { 6, 7 }, { 7, 7 }
};

/* ---------------------------------------------------------------------------
 */
const int16_t tab_scan_2x8[16][2] = {
    { 0, 0 }, { 1, 0 }, { 0, 1 }, { 1, 1 }, { 2, 0 }, { 3, 0 }, { 2, 1 }, { 3, 1 },
    { 4, 0 }, { 5, 0 }, { 4, 1 }, { 5, 1 }, { 6, 0 }, { 7, 0 }, { 6, 1 }, { 7, 1 }
};

/* ---------------------------------------------------------------------------
 */
const int16_t tab_scan_1x4[4][2] = {
    { 0, 0 }, { 1, 0 }, { 2, 0 }, { 3, 0 },
};

/* ---------------------------------------------------------------------------
 */
const int16_t tab_scan_8x2[16][2] = {
    { 0, 0 }, { 1, 0 },
    { 0, 1 }, { 0, 2 },
    { 1, 1 }, { 1, 2 },
    { 0, 3 }, { 0, 4 },
    { 1, 3 }, { 1, 4 },
    { 0, 5 }, { 0, 6 },
    { 1, 5 }, { 1, 6 },
    { 0, 7 }, { 1, 7 }
};

/* ---------------------------------------------------------------------------
 */
const int16_t tab_scan_4x1[4][2] = {
    { 0, 0 }, { 0, 1 }, { 0, 2 }, { 0, 3 },
};

/* ---------------------------------------------------------------------------
 */
const int16_t tab_coef_scan_4x16[64][2] = {
    {  0,  0}, {  1,  0}, {  0,  1}, {  0,  2},
    {  1,  1}, {  2,  0}, {  3,  0}, {  2,  1},
    {  1,  2}, {  0,  3}, {  1,  3}, {  2,  2},
    {  3,  1}, {  3,  2}, {  2,  3}, {  3,  3},
    {  4,  0}, {  5,  0}, {  4,  1}, {  4,  2},
    {  5,  1}, {  6,  0}, {  7,  0}, {  6,  1},
    {  5,  2}, {  4,  3}, {  5,  3}, {  6,  2},
    {  7,  1}, {  7,  2}, {  6,  3}, {  7,  3},
    {  8,  0}, {  9,  0}, {  8,  1}, {  8,  2},
    {  9,  1}, { 10,  0}, { 11,  0}, { 10,  1},
    {  9,  2}, {  8,  3}, {  9,  3}, { 10,  2},
    { 11,  1}, { 11,  2}, { 10,  3}, { 11,  3},
    { 12,  0}, { 13,  0}, { 12,  1}, { 12,  2},
    { 13,  1}, { 14,  0}, { 15,  0}, { 14,  1},
    { 13,  2}, { 12,  3}, { 13,  3}, { 14,  2},
    { 15,  1}, { 15,  2}, { 14,  3}, { 15,  3}
};

/* ---------------------------------------------------------------------------
 */
const int16_t tab_coef_scan_16x4[64][2] = {
    {  0,  0}, {  1,  0}, {  0,  1}, {  0,  2},
    {  1,  1}, {  2,  0}, {  3,  0}, {  2,  1},
    {  1,  2}, {  0,  3}, {  1,  3}, {  2,  2},
    {  3,  1}, {  3,  2}, {  2,  3}, {  3,  3},
    {  0,  4}, {  1,  4}, {  0,  5}, {  0,  6},
    {  1,  5}, {  2,  4}, {  3,  4}, {  2,  5},
    {  1,  6}, {  0,  7}, {  1,  7}, {  2,  6},
    {  3,  5}, {  3,  6}, {  2,  7}, {  3,  7},
    {  0,  8}, {  1,  8}, {  0,  9}, {  0, 10},
    {  1,  9}, {  2,  8}, {  3,  8}, {  2,  9},
    {  1, 10}, {  0, 11}, {  1, 11}, {  2, 10},
    {  3,  9}, {  3, 10}, {  2, 11}, {  3, 11},
    {  0, 12}, {  1, 12}, {  0, 13}, {  0, 14},
    {  1, 13}, {  2, 12}, {  3, 12}, {  2, 13},
    {  1, 14}, {  0, 15}, {  1, 15}, {  2, 14},
    {  3, 13}, {  3, 14}, {  2, 15}, {  3, 15}
};

/* ---------------------------------------------------------------------------
 */
const int16_t tab_coef_scan_8x32[256][2] = {
    {  0,  0}, {  1,  0}, {  0,  1}, {  0,  2}, {  1,  1}, {  2,  0}, {  3,  0}, {  2,  1},
    {  1,  2}, {  0,  3}, {  1,  3}, {  2,  2}, {  3,  1}, {  3,  2}, {  2,  3}, {  3,  3},
    {  4,  0}, {  5,  0}, {  4,  1}, {  4,  2}, {  5,  1}, {  6,  0}, {  7,  0}, {  6,  1},
    {  5,  2}, {  4,  3}, {  5,  3}, {  6,  2}, {  7,  1}, {  7,  2}, {  6,  3}, {  7,  3},
    {  0,  4}, {  1,  4}, {  0,  5}, {  0,  6}, {  1,  5}, {  2,  4}, {  3,  4}, {  2,  5},
    {  1,  6}, {  0,  7}, {  1,  7}, {  2,  6}, {  3,  5}, {  3,  6}, {  2,  7}, {  3,  7},
    {  4,  4}, {  5,  4}, {  4,  5}, {  4,  6}, {  5,  5}, {  6,  4}, {  7,  4}, {  6,  5},
    {  5,  6}, {  4,  7}, {  5,  7}, {  6,  6}, {  7,  5}, {  7,  6}, {  6,  7}, {  7,  7},
    {  8,  0}, {  9,  0}, {  8,  1}, {  8,  2}, {  9,  1}, { 10,  0}, { 11,  0}, { 10,  1},
    {  9,  2}, {  8,  3}, {  9,  3}, { 10,  2}, { 11,  1}, { 11,  2}, { 10,  3}, { 11,  3},
    { 12,  0}, { 13,  0}, { 12,  1}, { 12,  2}, { 13,  1}, { 14,  0}, { 15,  0}, { 14,  1},
    { 13,  2}, { 12,  3}, { 13,  3}, { 14,  2}, { 15,  1}, { 15,  2}, { 14,  3}, { 15,  3},
    {  8,  4}, {  9,  4}, {  8,  5}, {  8,  6}, {  9,  5}, { 10,  4}, { 11,  4}, { 10,  5},
    {  9,  6}, {  8,  7}, {  9,  7}, { 10,  6}, { 11,  5}, { 11,  6}, { 10,  7}, { 11,  7},
    { 12,  4}, { 13,  4}, { 12,  5}, { 12,  6}, { 13,  5}, { 14,  4}, { 15,  4}, { 14,  5},
    { 13,  6}, { 12,  7}, { 13,  7}, { 14,  6}, { 15,  5}, { 15,  6}, { 14,  7}, { 15,  7},
    { 16,  0}, { 17,  0}, { 16,  1}, { 16,  2}, { 17,  1}, { 18,  0}, { 19,  0}, { 18,  1},
    { 17,  2}, { 16,  3}, { 17,  3}, { 18,  2}, { 19,  1}, { 19,  2}, { 18,  3}, { 19,  3},
    { 20,  0}, { 21,  0}, { 20,  1}, { 20,  2}, { 21,  1}, { 22,  0}, { 23,  0}, { 22,  1},
    { 21,  2}, { 20,  3}, { 21,  3}, { 22,  2}, { 23,  1}, { 23,  2}, { 22,  3}, { 23,  3},
    { 16,  4}, { 17,  4}, { 16,  5}, { 16,  6}, { 17,  5}, { 18,  4}, { 19,  4}, { 18,  5},
    { 17,  6}, { 16,  7}, { 17,  7}, { 18,  6}, { 19,  5}, { 19,  6}, { 18,  7}, { 19,  7},
    { 20,  4}, { 21,  4}, { 20,  5}, { 20,  6}, { 21,  5}, { 22,  4}, { 23,  4}, { 22,  5},
    { 21,  6}, { 20,  7}, { 21,  7}, { 22,  6}, { 23,  5}, { 23,  6}, { 22,  7}, { 23,  7},
    { 24,  0}, { 25,  0}, { 24,  1}, { 24,  2}, { 25,  1}, { 26,  0}, { 27,  0}, { 26,  1},
    { 25,  2}, { 24,  3}, { 25,  3}, { 26,  2}, { 27,  1}, { 27,  2}, { 26,  3}, { 27,  3},
    { 28,  0}, { 29,  0}, { 28,  1}, { 28,  2}, { 29,  1}, { 30,  0}, { 31,  0}, { 30,  1},
    { 29,  2}, { 28,  3}, { 29,  3}, { 30,  2}, { 31,  1}, { 31,  2}, { 30,  3}, { 31,  3},
    { 24,  4}, { 25,  4}, { 24,  5}, { 24,  6}, { 25,  5}, { 26,  4}, { 27,  4}, { 26,  5},
    { 25,  6}, { 24,  7}, { 25,  7}, { 26,  6}, { 27,  5}, { 27,  6}, { 26,  7}, { 27,  7},
    { 28,  4}, { 29,  4}, { 28,  5}, { 28,  6}, { 29,  5}, { 30,  4}, { 31,  4}, { 30,  5},
    { 29,  6}, { 28,  7}, { 29,  7}, { 30,  6}, { 31,  5}, { 31,  6}, { 30,  7}, { 31,  7}
};

/* ---------------------------------------------------------------------------
 */
const int16_t tab_coef_scan_32x8[256][2] = {
    {  0,  0}, {  1,  0}, {  0,  1}, {  0,  2}, {  1,  1}, {  2,  0}, {  3,  0}, {  2,  1},
    {  1,  2}, {  0,  3}, {  1,  3}, {  2,  2}, {  3,  1}, {  3,  2}, {  2,  3}, {  3,  3},
    {  4,  0}, {  5,  0}, {  4,  1}, {  4,  2}, {  5,  1}, {  6,  0}, {  7,  0}, {  6,  1},
    {  5,  2}, {  4,  3}, {  5,  3}, {  6,  2}, {  7,  1}, {  7,  2}, {  6,  3}, {  7,  3},
    {  0,  4}, {  1,  4}, {  0,  5}, {  0,  6}, {  1,  5}, {  2,  4}, {  3,  4}, {  2,  5},
    {  1,  6}, {  0,  7}, {  1,  7}, {  2,  6}, {  3,  5}, {  3,  6}, {  2,  7}, {  3,  7},
    {  0,  8}, {  1,  8}, {  0,  9}, {  0, 10}, {  1,  9}, {  2,  8}, {  3,  8}, {  2,  9},
    {  1, 10}, {  0, 11}, {  1, 11}, {  2, 10}, {  3,  9}, {  3, 10}, {  2, 11}, {  3, 11},
    {  4,  4}, {  5,  4}, {  4,  5}, {  4,  6}, {  5,  5}, {  6,  4}, {  7,  4}, {  6,  5},
    {  5,  6}, {  4,  7}, {  5,  7}, {  6,  6}, {  7,  5}, {  7,  6}, {  6,  7}, {  7,  7},
    {  4,  8}, {  5,  8}, {  4,  9}, {  4, 10}, {  5,  9}, {  6,  8}, {  7,  8}, {  6,  9},
    {  5, 10}, {  4, 11}, {  5, 11}, {  6, 10}, {  7,  9}, {  7, 10}, {  6, 11}, {  7, 11},
    {  0, 12}, {  1, 12}, {  0, 13}, {  0, 14}, {  1, 13}, {  2, 12}, {  3, 12}, {  2, 13},
    {  1, 14}, {  0, 15}, {  1, 15}, {  2, 14}, {  3, 13}, {  3, 14}, {  2, 15}, {  3, 15},
    {  0, 16}, {  1, 16}, {  0, 17}, {  0, 18}, {  1, 17}, {  2, 16}, {  3, 16}, {  2, 17},
    {  1, 18}, {  0, 19}, {  1, 19}, {  2, 18}, {  3, 17}, {  3, 18}, {  2, 19}, {  3, 19},
    {  4, 12}, {  5, 12}, {  4, 13}, {  4, 14}, {  5, 13}, {  6, 12}, {  7, 12}, {  6, 13},
    {  5, 14}, {  4, 15}, {  5, 15}, {  6, 14}, {  7, 13}, {  7, 14}, {  6, 15}, {  7, 15},
    {  4, 16}, {  5, 16}, {  4, 17}, {  4, 18}, {  5, 17}, {  6, 16}, {  7, 16}, {  6, 17},
    {  5, 18}, {  4, 19}, {  5, 19}, {  6, 18}, {  7, 17}, {  7, 18}, {  6, 19}, {  7, 19},
    {  0, 20}, {  1, 20}, {  0, 21}, {  0, 22}, {  1, 21}, {  2, 20}, {  3, 20}, {  2, 21},
    {  1, 22}, {  0, 23}, {  1, 23}, {  2, 22}, {  3, 21}, {  3, 22}, {  2, 23}, {  3, 23},
    {  0, 24}, {  1, 24}, {  0, 25}, {  0, 26}, {  1, 25}, {  2, 24}, {  3, 24}, {  2, 25},
    {  1, 26}, {  0, 27}, {  1, 27}, {  2, 26}, {  3, 25}, {  3, 26}, {  2, 27}, {  3, 27},
    {  4, 20}, {  5, 20}, {  4, 21}, {  4, 22}, {  5, 21}, {  6, 20}, {  7, 20}, {  6, 21},
    {  5, 22}, {  4, 23}, {  5, 23}, {  6, 22}, {  7, 21}, {  7, 22}, {  6, 23}, {  7, 23},
    {  4, 24}, {  5, 24}, {  4, 25}, {  4, 26}, {  5, 25}, {  6, 24}, {  7, 24}, {  6, 25},
    {  5, 26}, {  4, 27}, {  5, 27}, {  6, 26}, {  7, 25}, {  7, 26}, {  6, 27}, {  7, 27},
    {  0, 28}, {  1, 28}, {  0, 29}, {  0, 30}, {  1, 29}, {  2, 28}, {  3, 28}, {  2, 29},
    {  1, 30}, {  0, 31}, {  1, 31}, {  2, 30}, {  3, 29}, {  3, 30}, {  2, 31}, {  3, 31},
    {  4, 28}, {  5, 28}, {  4, 29}, {  4, 30}, {  5, 29}, {  6, 28}, {  7, 28}, {  6, 29},
    {  5, 30}, {  4, 31}, {  5, 31}, {  6, 30}, {  7, 29}, {  7, 30}, {  6, 31}, {  7, 31}
};

/* ---------------------------------------------------------------------------
 */
const int16_t tab_coef_scan_8x8[64][2] = {
    { 0, 0 }, { 1, 0 }, { 0, 1 }, { 0, 2 }, { 1, 1 }, { 2, 0 }, { 3, 0 }, { 2, 1 },
    { 1, 2 }, { 0, 3 }, { 1, 3 }, { 2, 2 }, { 3, 1 }, { 3, 2 }, { 2, 3 }, { 3, 3 },
    { 4, 0 }, { 5, 0 }, { 4, 1 }, { 4, 2 }, { 5, 1 }, { 6, 0 }, { 7, 0 }, { 6, 1 },
    { 5, 2 }, { 4, 3 }, { 5, 3 }, { 6, 2 }, { 7, 1 }, { 7, 2 }, { 6, 3 }, { 7, 3 },
    { 0, 4 }, { 1, 4 }, { 0, 5 }, { 0, 6 }, { 1, 5 }, { 2, 4 }, { 3, 4 }, { 2, 5 },
    { 1, 6 }, { 0, 7 }, { 1, 7 }, { 2, 6 }, { 3, 5 }, { 3, 6 }, { 2, 7 }, { 3, 7 },
    { 4, 4 }, { 5, 4 }, { 4, 5 }, { 4, 6 }, { 5, 5 }, { 6, 4 }, { 7, 4 }, { 6, 5 },
    { 5, 6 }, { 4, 7 }, { 5, 7 }, { 6, 6 }, { 7, 5 }, { 7, 6 }, { 6, 7 }, { 7, 7 }
};

/* ---------------------------------------------------------------------------
 */
const int16_t tab_coef_scan_16x16[256][2] = {
    {  0,  0}, {  1,  0}, {  0,  1}, {  0,  2}, {  1,  1}, {  2,  0}, {  3,  0}, {  2,  1},
    {  1,  2}, {  0,  3}, {  1,  3}, {  2,  2}, {  3,  1}, {  3,  2}, {  2,  3}, {  3,  3},
    {  4,  0}, {  5,  0}, {  4,  1}, {  4,  2}, {  5,  1}, {  6,  0}, {  7,  0}, {  6,  1},
    {  5,  2}, {  4,  3}, {  5,  3}, {  6,  2}, {  7,  1}, {  7,  2}, {  6,  3}, {  7,  3},
    {  0,  4}, {  1,  4}, {  0,  5}, {  0,  6}, {  1,  5}, {  2,  4}, {  3,  4}, {  2,  5},
    {  1,  6}, {  0,  7}, {  1,  7}, {  2,  6}, {  3,  5}, {  3,  6}, {  2,  7}, {  3,  7},
    {  0,  8}, {  1,  8}, {  0,  9}, {  0, 10}, {  1,  9}, {  2,  8}, {  3,  8}, {  2,  9},
    {  1, 10}, {  0, 11}, {  1, 11}, {  2, 10}, {  3,  9}, {  3, 10}, {  2, 11}, {  3, 11},
    {  4,  4}, {  5,  4}, {  4,  5}, {  4,  6}, {  5,  5}, {  6,  4}, {  7,  4}, {  6,  5},
    {  5,  6}, {  4,  7}, {  5,  7}, {  6,  6}, {  7,  5}, {  7,  6}, {  6,  7}, {  7,  7},
    {  8,  0}, {  9,  0}, {  8,  1}, {  8,  2}, {  9,  1}, { 10,  0}, { 11,  0}, { 10,  1},
    {  9,  2}, {  8,  3}, {  9,  3}, { 10,  2}, { 11,  1}, { 11,  2}, { 10,  3}, { 11,  3},
    { 12,  0}, { 13,  0}, { 12,  1}, { 12,  2}, { 13,  1}, { 14,  0}, { 15,  0}, { 14,  1},
    { 13,  2}, { 12,  3}, { 13,  3}, { 14,  2}, { 15,  1}, { 15,  2}, { 14,  3}, { 15,  3},
    {  8,  4}, {  9,  4}, {  8,  5}, {  8,  6}, {  9,  5}, { 10,  4}, { 11,  4}, { 10,  5},
    {  9,  6}, {  8,  7}, {  9,  7}, { 10,  6}, { 11,  5}, { 11,  6}, { 10,  7}, { 11,  7},
    {  4,  8}, {  5,  8}, {  4,  9}, {  4, 10}, {  5,  9}, {  6,  8}, {  7,  8}, {  6,  9},
    {  5, 10}, {  4, 11}, {  5, 11}, {  6, 10}, {  7,  9}, {  7, 10}, {  6, 11}, {  7, 11},
    {  0, 12}, {  1, 12}, {  0, 13}, {  0, 14}, {  1, 13}, {  2, 12}, {  3, 12}, {  2, 13},
    {  1, 14}, {  0, 15}, {  1, 15}, {  2, 14}, {  3, 13}, {  3, 14}, {  2, 15}, {  3, 15},
    {  4, 12}, {  5, 12}, {  4, 13}, {  4, 14}, {  5, 13}, {  6, 12}, {  7, 12}, {  6, 13},
    {  5, 14}, {  4, 15}, {  5, 15}, {  6, 14}, {  7, 13}, {  7, 14}, {  6, 15}, {  7, 15},
    {  8,  8}, {  9,  8}, {  8,  9}, {  8, 10}, {  9,  9}, { 10,  8}, { 11,  8}, { 10,  9},
    {  9, 10}, {  8, 11}, {  9, 11}, { 10, 10}, { 11,  9}, { 11, 10}, { 10, 11}, { 11, 11},
    { 12,  4}, { 13,  4}, { 12,  5}, { 12,  6}, { 13,  5}, { 14,  4}, { 15,  4}, { 14,  5},
    { 13,  6}, { 12,  7}, { 13,  7}, { 14,  6}, { 15,  5}, { 15,  6}, { 14,  7}, { 15,  7},
    { 12,  8}, { 13,  8}, { 12,  9}, { 12, 10}, { 13,  9}, { 14,  8}, { 15,  8}, { 14,  9},
    { 13, 10}, { 12, 11}, { 13, 11}, { 14, 10}, { 15,  9}, { 15, 10}, { 14, 11}, { 15, 11},
    {  8, 12}, {  9, 12}, {  8, 13}, {  8, 14}, {  9, 13}, { 10, 12}, { 11, 12}, { 10, 13},
    {  9, 14}, {  8, 15}, {  9, 15}, { 10, 14}, { 11, 13}, { 11, 14}, { 10, 15}, { 11, 15},
    { 12, 12}, { 13, 12}, { 12, 13}, { 12, 14}, { 13, 13}, { 14, 12}, { 15, 12}, { 14, 13},
    { 13, 14}, { 12, 15}, { 13, 15}, { 14, 14}, { 15, 13}, { 15, 14}, { 14, 15}, { 15, 15}
};

/* ---------------------------------------------------------------------------
 */
const int16_t tab_coef_scan_32x32[1024][2] = {
    {  0,  0}, {  1,  0}, {  0,  1}, {  0,  2}, {  1,  1}, {  2,  0}, {  3,  0}, {  2,  1},
    {  1,  2}, {  0,  3}, {  1,  3}, {  2,  2}, {  3,  1}, {  3,  2}, {  2,  3}, {  3,  3},
    {  4,  0}, {  5,  0}, {  4,  1}, {  4,  2}, {  5,  1}, {  6,  0}, {  7,  0}, {  6,  1},
    {  5,  2}, {  4,  3}, {  5,  3}, {  6,  2}, {  7,  1}, {  7,  2}, {  6,  3}, {  7,  3},
    {  0,  4}, {  1,  4}, {  0,  5}, {  0,  6}, {  1,  5}, {  2,  4}, {  3,  4}, {  2,  5},
    {  1,  6}, {  0,  7}, {  1,  7}, {  2,  6}, {  3,  5}, {  3,  6}, {  2,  7}, {  3,  7},
    {  0,  8}, {  1,  8}, {  0,  9}, {  0, 10}, {  1,  9}, {  2,  8}, {  3,  8}, {  2,  9},
    {  1, 10}, {  0, 11}, {  1, 11}, {  2, 10}, {  3,  9}, {  3, 10}, {  2, 11}, {  3, 11},
    {  4,  4}, {  5,  4}, {  4,  5}, {  4,  6}, {  5,  5}, {  6,  4}, {  7,  4}, {  6,  5},
    {  5,  6}, {  4,  7}, {  5,  7}, {  6,  6}, {  7,  5}, {  7,  6}, {  6,  7}, {  7,  7},
    {  8,  0}, {  9,  0}, {  8,  1}, {  8,  2}, {  9,  1}, { 10,  0}, { 11,  0}, { 10,  1},
    {  9,  2}, {  8,  3}, {  9,  3}, { 10,  2}, { 11,  1}, { 11,  2}, { 10,  3}, { 11,  3},
    { 12,  0}, { 13,  0}, { 12,  1}, { 12,  2}, { 13,  1}, { 14,  0}, { 15,  0}, { 14,  1},
    { 13,  2}, { 12,  3}, { 13,  3}, { 14,  2}, { 15,  1}, { 15,  2}, { 14,  3}, { 15,  3},
    {  8,  4}, {  9,  4}, {  8,  5}, {  8,  6}, {  9,  5}, { 10,  4}, { 11,  4}, { 10,  5},
    {  9,  6}, {  8,  7}, {  9,  7}, { 10,  6}, { 11,  5}, { 11,  6}, { 10,  7}, { 11,  7},
    {  4,  8}, {  5,  8}, {  4,  9}, {  4, 10}, {  5,  9}, {  6,  8}, {  7,  8}, {  6,  9},
    {  5, 10}, {  4, 11}, {  5, 11}, {  6, 10}, {  7,  9}, {  7, 10}, {  6, 11}, {  7, 11},
    {  0, 12}, {  1, 12}, {  0, 13}, {  0, 14}, {  1, 13}, {  2, 12}, {  3, 12}, {  2, 13},
    {  1, 14}, {  0, 15}, {  1, 15}, {  2, 14}, {  3, 13}, {  3, 14}, {  2, 15}, {  3, 15},
    {  0, 16}, {  1, 16}, {  0, 17}, {  0, 18}, {  1, 17}, {  2, 16}, {  3, 16}, {  2, 17},
    {  1, 18}, {  0, 19}, {  1, 19}, {  2, 18}, {  3, 17}, {  3, 18}, {  2, 19}, {  3, 19},
    {  4, 12}, {  5, 12}, {  4, 13}, {  4, 14}, {  5, 13}, {  6, 12}, {  7, 12}, {  6, 13},
    {  5, 14}, {  4, 15}, {  5, 15}, {  6, 14}, {  7, 13}, {  7, 14}, {  6, 15}, {  7, 15},
    {  8,  8}, {  9,  8}, {  8,  9}, {  8, 10}, {  9,  9}, { 10,  8}, { 11,  8}, { 10,  9},
    {  9, 10}, {  8, 11}, {  9, 11}, { 10, 10}, { 11,  9}, { 11, 10}, { 10, 11}, { 11, 11},
    { 12,  4}, { 13,  4}, { 12,  5}, { 12,  6}, { 13,  5}, { 14,  4}, { 15,  4}, { 14,  5},
    { 13,  6}, { 12,  7}, { 13,  7}, { 14,  6}, { 15,  5}, { 15,  6}, { 14,  7}, { 15,  7},
    { 16,  0}, { 17,  0}, { 16,  1}, { 16,  2}, { 17,  1}, { 18,  0}, { 19,  0}, { 18,  1},
    { 17,  2}, { 16,  3}, { 17,  3}, { 18,  2}, { 19,  1}, { 19,  2}, { 18,  3}, { 19,  3},
    { 20,  0}, { 21,  0}, { 20,  1}, { 20,  2}, { 21,  1}, { 22,  0}, { 23,  0}, { 22,  1},
    { 21,  2}, { 20,  3}, { 21,  3}, { 22,  2}, { 23,  1}, { 23,  2}, { 22,  3}, { 23,  3},
    { 16,  4}, { 17,  4}, { 16,  5}, { 16,  6}, { 17,  5}, { 18,  4}, { 19,  4}, { 18,  5},
    { 17,  6}, { 16,  7}, { 17,  7}, { 18,  6}, { 19,  5}, { 19,  6}, { 18,  7}, { 19,  7},
    { 12,  8}, { 13,  8}, { 12,  9}, { 12, 10}, { 13,  9}, { 14,  8}, { 15,  8}, { 14,  9},
    { 13, 10}, { 12, 11}, { 13, 11}, { 14, 10}, { 15,  9}, { 15, 10}, { 14, 11}, { 15, 11},
    {  8, 12}, {  9, 12}, {  8, 13}, {  8, 14}, {  9, 13}, { 10, 12}, { 11, 12}, { 10, 13},
    {  9, 14}, {  8, 15}, {  9, 15}, { 10, 14}, { 11, 13}, { 11, 14}, { 10, 15}, { 11, 15},
    {  4, 16}, {  5, 16}, {  4, 17}, {  4, 18}, {  5, 17}, {  6, 16}, {  7, 16}, {  6, 17},
    {  5, 18}, {  4, 19}, {  5, 19}, {  6, 18}, {  7, 17}, {  7, 18}, {  6, 19}, {  7, 19},
    {  0, 20}, {  1, 20}, {  0, 21}, {  0, 22}, {  1, 21}, {  2, 20}, {  3, 20}, {  2, 21},
    {  1, 22}, {  0, 23}, {  1, 23}, {  2, 22}, {  3, 21}, {  3, 22}, {  2, 23}, {  3, 23},
    {  0, 24}, {  1, 24}, {  0, 25}, {  0, 26}, {  1, 25}, {  2, 24}, {  3, 24}, {  2, 25},
    {  1, 26}, {  0, 27}, {  1, 27}, {  2, 26}, {  3, 25}, {  3, 26}, {  2, 27}, {  3, 27},
    {  4, 20}, {  5, 20}, {  4, 21}, {  4, 22}, {  5, 21}, {  6, 20}, {  7, 20}, {  6, 21},
    {  5, 22}, {  4, 23}, {  5, 23}, {  6, 22}, {  7, 21}, {  7, 22}, {  6, 23}, {  7, 23},
    {  8, 16}, {  9, 16}, {  8, 17}, {  8, 18}, {  9, 17}, { 10, 16}, { 11, 16}, { 10, 17},
    {  9, 18}, {  8, 19}, {  9, 19}, { 10, 18}, { 11, 17}, { 11, 18}, { 10, 19}, { 11, 19},
    { 12, 12}, { 13, 12}, { 12, 13}, { 12, 14}, { 13, 13}, { 14, 12}, { 15, 12}, { 14, 13},
    { 13, 14}, { 12, 15}, { 13, 15}, { 14, 14}, { 15, 13}, { 15, 14}, { 14, 15}, { 15, 15},
    { 16,  8}, { 17,  8}, { 16,  9}, { 16, 10}, { 17,  9}, { 18,  8}, { 19,  8}, { 18,  9},
    { 17, 10}, { 16, 11}, { 17, 11}, { 18, 10}, { 19,  9}, { 19, 10}, { 18, 11}, { 19, 11},
    { 20,  4}, { 21,  4}, { 20,  5}, { 20,  6}, { 21,  5}, { 22,  4}, { 23,  4}, { 22,  5},
    { 21,  6}, { 20,  7}, { 21,  7}, { 22,  6}, { 23,  5}, { 23,  6}, { 22,  7}, { 23,  7},
    { 24,  0}, { 25,  0}, { 24,  1}, { 24,  2}, { 25,  1}, { 26,  0}, { 27,  0}, { 26,  1},
    { 25,  2}, { 24,  3}, { 25,  3}, { 26,  2}, { 27,  1}, { 27,  2}, { 26,  3}, { 27,  3},
    { 28,  0}, { 29,  0}, { 28,  1}, { 28,  2}, { 29,  1}, { 30,  0}, { 31,  0}, { 30,  1},
    { 29,  2}, { 28,  3}, { 29,  3}, { 30,  2}, { 31,  1}, { 31,  2}, { 30,  3}, { 31,  3},
    { 24,  4}, { 25,  4}, { 24,  5}, { 24,  6}, { 25,  5}, { 26,  4}, { 27,  4}, { 26,  5},
    { 25,  6}, { 24,  7}, { 25,  7}, { 26,  6}, { 27,  5}, { 27,  6}, { 26,  7}, { 27,  7},
    { 20,  8}, { 21,  8}, { 20,  9}, { 20, 10}, { 21,  9}, { 22,  8}, { 23,  8}, { 22,  9},
    { 21, 10}, { 20, 11}, { 21, 11}, { 22, 10}, { 23,  9}, { 23, 10}, { 22, 11}, { 23, 11},
    { 16, 12}, { 17, 12}, { 16, 13}, { 16, 14}, { 17, 13}, { 18, 12}, { 19, 12}, { 18, 13},
    { 17, 14}, { 16, 15}, { 17, 15}, { 18, 14}, { 19, 13}, { 19, 14}, { 18, 15}, { 19, 15},
    { 12, 16}, { 13, 16}, { 12, 17}, { 12, 18}, { 13, 17}, { 14, 16}, { 15, 16}, { 14, 17},
    { 13, 18}, { 12, 19}, { 13, 19}, { 14, 18}, { 15, 17}, { 15, 18}, { 14, 19}, { 15, 19},
    {  8, 20}, {  9, 20}, {  8, 21}, {  8, 22}, {  9, 21}, { 10, 20}, { 11, 20}, { 10, 21},
    {  9, 22}, {  8, 23}, {  9, 23}, { 10, 22}, { 11, 21}, { 11, 22}, { 10, 23}, { 11, 23},
    {  4, 24}, {  5, 24}, {  4, 25}, {  4, 26}, {  5, 25}, {  6, 24}, {  7, 24}, {  6, 25},
    {  5, 26}, {  4, 27}, {  5, 27}, {  6, 26}, {  7, 25}, {  7, 26}, {  6, 27}, {  7, 27},
    {  0, 28}, {  1, 28}, {  0, 29}, {  0, 30}, {  1, 29}, {  2, 28}, {  3, 28}, {  2, 29},
    {  1, 30}, {  0, 31}, {  1, 31}, {  2, 30}, {  3, 29}, {  3, 30}, {  2, 31}, {  3, 31},
    {  4, 28}, {  5, 28}, {  4, 29}, {  4, 30}, {  5, 29}, {  6, 28}, {  7, 28}, {  6, 29},
    {  5, 30}, {  4, 31}, {  5, 31}, {  6, 30}, {  7, 29}, {  7, 30}, {  6, 31}, {  7, 31},
    {  8, 24}, {  9, 24}, {  8, 25}, {  8, 26}, {  9, 25}, { 10, 24}, { 11, 24}, { 10, 25},
    {  9, 26}, {  8, 27}, {  9, 27}, { 10, 26}, { 11, 25}, { 11, 26}, { 10, 27}, { 11, 27},
    { 12, 20}, { 13, 20}, { 12, 21}, { 12, 22}, { 13, 21}, { 14, 20}, { 15, 20}, { 14, 21},
    { 13, 22}, { 12, 23}, { 13, 23}, { 14, 22}, { 15, 21}, { 15, 22}, { 14, 23}, { 15, 23},
    { 16, 16}, { 17, 16}, { 16, 17}, { 16, 18}, { 17, 17}, { 18, 16}, { 19, 16}, { 18, 17},
    { 17, 18}, { 16, 19}, { 17, 19}, { 18, 18}, { 19, 17}, { 19, 18}, { 18, 19}, { 19, 19},
    { 20, 12}, { 21, 12}, { 20, 13}, { 20, 14}, { 21, 13}, { 22, 12}, { 23, 12}, { 22, 13},
    { 21, 14}, { 20, 15}, { 21, 15}, { 22, 14}, { 23, 13}, { 23, 14}, { 22, 15}, { 23, 15},
    { 24,  8}, { 25,  8}, { 24,  9}, { 24, 10}, { 25,  9}, { 26,  8}, { 27,  8}, { 26,  9},
    { 25, 10}, { 24, 11}, { 25, 11}, { 26, 10}, { 27,  9}, { 27, 10}, { 26, 11}, { 27, 11},
    { 28,  4}, { 29,  4}, { 28,  5}, { 28,  6}, { 29,  5}, { 30,  4}, { 31,  4}, { 30,  5},
    { 29,  6}, { 28,  7}, { 29,  7}, { 30,  6}, { 31,  5}, { 31,  6}, { 30,  7}, { 31,  7},
    { 28,  8}, { 29,  8}, { 28,  9}, { 28, 10}, { 29,  9}, { 30,  8}, { 31,  8}, { 30,  9},
    { 29, 10}, { 28, 11}, { 29, 11}, { 30, 10}, { 31,  9}, { 31, 10}, { 30, 11}, { 31, 11},
    { 24, 12}, { 25, 12}, { 24, 13}, { 24, 14}, { 25, 13}, { 26, 12}, { 27, 12}, { 26, 13},
    { 25, 14}, { 24, 15}, { 25, 15}, { 26, 14}, { 27, 13}, { 27, 14}, { 26, 15}, { 27, 15},
    { 20, 16}, { 21, 16}, { 20, 17}, { 20, 18}, { 21, 17}, { 22, 16}, { 23, 16}, { 22, 17},
    { 21, 18}, { 20, 19}, { 21, 19}, { 22, 18}, { 23, 17}, { 23, 18}, { 22, 19}, { 23, 19},
    { 16, 20}, { 17, 20}, { 16, 21}, { 16, 22}, { 17, 21}, { 18, 20}, { 19, 20}, { 18, 21},
    { 17, 22}, { 16, 23}, { 17, 23}, { 18, 22}, { 19, 21}, { 19, 22}, { 18, 23}, { 19, 23},
    { 12, 24}, { 13, 24}, { 12, 25}, { 12, 26}, { 13, 25}, { 14, 24}, { 15, 24}, { 14, 25},
    { 13, 26}, { 12, 27}, { 13, 27}, { 14, 26}, { 15, 25}, { 15, 26}, { 14, 27}, { 15, 27},
    {  8, 28}, {  9, 28}, {  8, 29}, {  8, 30}, {  9, 29}, { 10, 28}, { 11, 28}, { 10, 29},
    {  9, 30}, {  8, 31}, {  9, 31}, { 10, 30}, { 11, 29}, { 11, 30}, { 10, 31}, { 11, 31},
    { 12, 28}, { 13, 28}, { 12, 29}, { 12, 30}, { 13, 29}, { 14, 28}, { 15, 28}, { 14, 29},
    { 13, 30}, { 12, 31}, { 13, 31}, { 14, 30}, { 15, 29}, { 15, 30}, { 14, 31}, { 15, 31},
    { 16, 24}, { 17, 24}, { 16, 25}, { 16, 26}, { 17, 25}, { 18, 24}, { 19, 24}, { 18, 25},
    { 17, 26}, { 16, 27}, { 17, 27}, { 18, 26}, { 19, 25}, { 19, 26}, { 18, 27}, { 19, 27},
    { 20, 20}, { 21, 20}, { 20, 21}, { 20, 22}, { 21, 21}, { 22, 20}, { 23, 20}, { 22, 21},
    { 21, 22}, { 20, 23}, { 21, 23}, { 22, 22}, { 23, 21}, { 23, 22}, { 22, 23}, { 23, 23},
    { 24, 16}, { 25, 16}, { 24, 17}, { 24, 18}, { 25, 17}, { 26, 16}, { 27, 16}, { 26, 17},
    { 25, 18}, { 24, 19}, { 25, 19}, { 26, 18}, { 27, 17}, { 27, 18}, { 26, 19}, { 27, 19},
    { 28, 12}, { 29, 12}, { 28, 13}, { 28, 14}, { 29, 13}, { 30, 12}, { 31, 12}, { 30, 13},
    { 29, 14}, { 28, 15}, { 29, 15}, { 30, 14}, { 31, 13}, { 31, 14}, { 30, 15}, { 31, 15},
    { 28, 16}, { 29, 16}, { 28, 17}, { 28, 18}, { 29, 17}, { 30, 16}, { 31, 16}, { 30, 17},
    { 29, 18}, { 28, 19}, { 29, 19}, { 30, 18}, { 31, 17}, { 31, 18}, { 30, 19}, { 31, 19},
    { 24, 20}, { 25, 20}, { 24, 21}, { 24, 22}, { 25, 21}, { 26, 20}, { 27, 20}, { 26, 21},
    { 25, 22}, { 24, 23}, { 25, 23}, { 26, 22}, { 27, 21}, { 27, 22}, { 26, 23}, { 27, 23},
    { 20, 24}, { 21, 24}, { 20, 25}, { 20, 26}, { 21, 25}, { 22, 24}, { 23, 24}, { 22, 25},
    { 21, 26}, { 20, 27}, { 21, 27}, { 22, 26}, { 23, 25}, { 23, 26}, { 22, 27}, { 23, 27},
    { 16, 28}, { 17, 28}, { 16, 29}, { 16, 30}, { 17, 29}, { 18, 28}, { 19, 28}, { 18, 29},
    { 17, 30}, { 16, 31}, { 17, 31}, { 18, 30}, { 19, 29}, { 19, 30}, { 18, 31}, { 19, 31},
    { 20, 28}, { 21, 28}, { 20, 29}, { 20, 30}, { 21, 29}, { 22, 28}, { 23, 28}, { 22, 29},
    { 21, 30}, { 20, 31}, { 21, 31}, { 22, 30}, { 23, 29}, { 23, 30}, { 22, 31}, { 23, 31},
    { 24, 24}, { 25, 24}, { 24, 25}, { 24, 26}, { 25, 25}, { 26, 24}, { 27, 24}, { 26, 25},
    { 25, 26}, { 24, 27}, { 25, 27}, { 26, 26}, { 27, 25}, { 27, 26}, { 26, 27}, { 27, 27},
    { 28, 20}, { 29, 20}, { 28, 21}, { 28, 22}, { 29, 21}, { 30, 20}, { 31, 20}, { 30, 21},
    { 29, 22}, { 28, 23}, { 29, 23}, { 30, 22}, { 31, 21}, { 31, 22}, { 30, 23}, { 31, 23},
    { 28, 24}, { 29, 24}, { 28, 25}, { 28, 26}, { 29, 25}, { 30, 24}, { 31, 24}, { 30, 25},
    { 29, 26}, { 28, 27}, { 29, 27}, { 30, 26}, { 31, 25}, { 31, 26}, { 30, 27}, { 31, 27},
    { 24, 28}, { 25, 28}, { 24, 29}, { 24, 30}, { 25, 29}, { 26, 28}, { 27, 28}, { 26, 29},
    { 25, 30}, { 24, 31}, { 25, 31}, { 26, 30}, { 27, 29}, { 27, 30}, { 26, 31}, { 27, 31},
    { 28, 28}, { 29, 28}, { 28, 29}, { 28, 30}, { 29, 29}, { 30, 28}, { 31, 28}, { 30, 29},
    { 29, 30}, { 28, 31}, { 29, 31}, { 30, 30}, { 31, 29}, { 31, 30}, { 30, 31}, { 31, 31}
};

/* ---------------------------------------------------------------------------
 */
const int16_t(*tab_coef_scan_list[4])[2] = {
    tab_scan_4x4,
    tab_coef_scan_8x8,
    tab_coef_scan_16x16,
    tab_coef_scan_32x32
};

/* ---------------------------------------------------------------------------
 */
const int16_t(*tab_coef_scan_list_hor[3])[2] = {
    NULL,
    tab_coef_scan_4x16,
    tab_coef_scan_8x32
};

/* ---------------------------------------------------------------------------
 */
const int16_t(*tab_coef_scan_list_ver[3])[2] = {
    NULL,
    tab_coef_scan_16x4,
    tab_coef_scan_32x8
};

/* ---------------------------------------------------------------------------
 */
const int16_t(*tab_cg_scan_list_nxn[])[2] = {
    tab_scan_2x2, // 4x4
    tab_scan_2x2, // 8x8
    tab_scan_4x4, // 16x16
    tab_scan_8x8  // 32x32
};

const int16_t(*tab_cg_scan_list_hor[3])[2] = {
    NULL,
    tab_scan_1x4,
    tab_scan_2x8,
};

const int16_t(*tab_cg_scan_list_ver[3])[2] = {
    NULL,
    tab_scan_4x1,
    tab_scan_8x2,
};

/* ---------------------------------------------------------------------------
 * һάɨ˳
 */
ALIGN32(const int16_t tab_1d_scan_4x4[16]) = {
     0,  1,  4,  8, 
     5,  2,  3,  6, 
     9, 12, 13, 10, 
     7, 11, 14, 15
 };

ALIGN32(const int16_t tab_1d_scan_8x8[64]) = {
     0,  1,  8, 16,  9,  2,  3, 10, 
    17, 24, 25, 18, 11, 19, 26, 27, 
     4,  5, 12, 20, 13,  6,  7, 14, 
    21, 28, 29, 22, 15, 23, 30, 31, 
    32, 33, 40, 48, 41, 34, 35, 42, 
    49, 56, 57, 50, 43, 51, 58, 59, 
    36, 37, 44, 52, 45, 38, 39, 46, 
    53, 60, 61, 54, 47, 55, 62, 63
};

ALIGN32(const int16_t tab_1d_scan_16x16[256]) = {
      0,   1,  16,  32,  17,   2,   3,  18,  33,  48,  49,  34,  19,  35,  50,  51, 
      4,   5,  20,  36,  21,   6,   7,  22,  37,  52,  53,  38,  23,  39,  54,  55, 
     64,  65,  80,  96,  81,  66,  67,  82,  97, 112, 113,  98,  83,  99, 114, 115, 
    128, 129, 144, 160, 145, 130, 131, 146, 161, 176, 177, 162, 147, 163, 178, 179, 
     68,  69,  84, 100,  85,  70,  71,  86, 101, 116, 117, 102,  87, 103, 118, 119, 
      8,   9,  24,  40,  25,  10,  11,  26,  41,  56,  57,  42,  27,  43,  58,  59, 
     12,  13,  28,  44,  29,  14,  15,  30,  45,  60,  61,  46,  31,  47,  62,  63, 
     72,  73,  88, 104,  89,  74,  75,  90, 105, 120, 121, 106,  91, 107, 122, 123, 
    132, 133, 148, 164, 149, 134, 135, 150, 165, 180, 181, 166, 151, 167, 182, 183, 
    192, 193, 208, 224, 209, 194, 195, 210, 225, 240, 241, 226, 211, 227, 242, 243, 
    196, 197, 212, 228, 213, 198, 199, 214, 229, 244, 245, 230, 215, 231, 246, 247, 
    136, 137, 152, 168, 153, 138, 139, 154, 169, 184, 185, 170, 155, 171, 186, 187, 
     76,  77,  92, 108,  93,  78,  79,  94, 109, 124, 125, 110,  95, 111, 126, 127, 
    140, 141, 156, 172, 157, 142, 143, 158, 173, 188, 189, 174, 159, 175, 190, 191, 
    200, 201, 216, 232, 217, 202, 203, 218, 233, 248, 249, 234, 219, 235, 250, 251, 
    204, 205, 220, 236, 221, 206, 207, 222, 237, 252, 253, 238, 223, 239, 254, 255
};

ALIGN32(const int16_t tab_1d_scan_32x32[1024]) = {
       0,    1,   32,   64,   33,    2,    3,   34,   65,   96,   97,   66,   35,   67,   98,   99,    4,    5,   36,   68,   37,    6,    7,   38,   69,  100,  101,   70,   39,   71,  102,  103, 
     128,  129,  160,  192,  161,  130,  131,  162,  193,  224,  225,  194,  163,  195,  226,  227,  256,  257,  288,  320,  289,  258,  259,  290,  321,  352,  353,  322,  291,  323,  354,  355, 
     132,  133,  164,  196,  165,  134,  135,  166,  197,  228,  229,  198,  167,  199,  230,  231,    8,    9,   40,   72,   41,   10,   11,   42,   73,  104,  105,   74,   43,   75,  106,  107, 
      12,   13,   44,   76,   45,   14,   15,   46,   77,  108,  109,   78,   47,   79,  110,  111,  136,  137,  168,  200,  169,  138,  139,  170,  201,  232,  233,  202,  171,  203,  234,  235, 
     260,  261,  292,  324,  293,  262,  263,  294,  325,  356,  357,  326,  295,  327,  358,  359,  384,  385,  416,  448,  417,  386,  387,  418,  449,  480,  481,  450,  419,  451,  482,  483, 
     512,  513,  544,  576,  545,  514,  515,  546,  577,  608,  609,  578,  547,  579,  610,  611,  388,  389,  420,  452,  421,  390,  391,  422,  453,  484,  485,  454,  423,  455,  486,  487, 
     264,  265,  296,  328,  297,  266,  267,  298,  329,  360,  361,  330,  299,  331,  362,  363,  140,  141,  172,  204,  173,  142,  143,  174,  205,  236,  237,  206,  175,  207,  238,  239, 
      16,   17,   48,   80,   49,   18,   19,   50,   81,  112,  113,   82,   51,   83,  114,  115,   20,   21,   52,   84,   53,   22,   23,   54,   85,  116,  117,   86,   55,   87,  118,  119, 
     144,  145,  176,  208,  177,  146,  147,  178,  209,  240,  241,  210,  179,  211,  242,  243,  268,  269,  300,  332,  301,  270,  271,  302,  333,  364,  365,  334,  303,  335,  366,  367, 
     392,  393,  424,  456,  425,  394,  395,  426,  457,  488,  489,  458,  427,  459,  490,  491,  516,  517,  548,  580,  549,  518,  519,  550,  581,  612,  613,  582,  551,  583,  614,  615, 
     640,  641,  672,  704,  673,  642,  643,  674,  705,  736,  737,  706,  675,  707,  738,  739,  768,  769,  800,  832,  801,  770,  771,  802,  833,  864,  865,  834,  803,  835,  866,  867, 
     644,  645,  676,  708,  677,  646,  647,  678,  709,  740,  741,  710,  679,  711,  742,  743,  520,  521,  552,  584,  553,  522,  523,  554,  585,  616,  617,  586,  555,  587,  618,  619, 
     396,  397,  428,  460,  429,  398,  399,  430,  461,  492,  493,  462,  431,  463,  494,  495,  272,  273,  304,  336,  305,  274,  275,  306,  337,  368,  369,  338,  307,  339,  370,  371, 
     148,  149,  180,  212,  181,  150,  151,  182,  213,  244,  245,  214,  183,  215,  246,  247,   24,   25,   56,   88,   57,   26,   27,   58,   89,  120,  121,   90,   59,   91,  122,  123, 
      28,   29,   60,   92,   61,   30,   31,   62,   93,  124,  125,   94,   63,   95,  126,  127,  152,  153,  184,  216,  185,  154,  155,  186,  217,  248,  249,  218,  187,  219,  250,  251, 
     276,  277,  308,  340,  309,  278,  279,  310,  341,  372,  373,  342,  311,  343,  374,  375,  400,  401,  432,  464,  433,  402,  403,  434,  465,  496,  497,  466,  435,  467,  498,  499, 
     524,  525,  556,  588,  557,  526,  527,  558,  589,  620,  621,  590,  559,  591,  622,  623,  648,  649,  680,  712,  681,  650,  651,  682,  713,  744,  745,  714,  683,  715,  746,  747, 
     772,  773,  804,  836,  805,  774,  775,  806,  837,  868,  869,  838,  807,  839,  870,  871,  896,  897,  928,  960,  929,  898,  899,  930,  961,  992,  993,  962,  931,  963,  994,  995, 
     900,  901,  932,  964,  933,  902,  903,  934,  965,  996,  997,  966,  935,  967,  998,  999,  776,  777,  808,  840,  809,  778,  779,  810,  841,  872,  873,  842,  811,  843,  874,  875, 
     652,  653,  684,  716,  685,  654,  655,  686,  717,  748,  749,  718,  687,  719,  750,  751,  528,  529,  560,  592,  561,  530,  531,  562,  593,  624,  625,  594,  563,  595,  626,  627, 
     404,  405,  436,  468,  437,  406,  407,  438,  469,  500,  501,  470,  439,  471,  502,  503,  280,  281,  312,  344,  313,  282,  283,  314,  345,  376,  377,  346,  315,  347,  378,  379, 
     156,  157,  188,  220,  189,  158,  159,  190,  221,  252,  253,  222,  191,  223,  254,  255,  284,  285,  316,  348,  317,  286,  287,  318,  349,  380,  381,  350,  319,  351,  382,  383, 
     408,  409,  440,  472,  441,  410,  411,  442,  473,  504,  505,  474,  443,  475,  506,  507,  532,  533,  564,  596,  565,  534,  535,  566,  597,  628,  629,  598,  567,  599,  630,  631, 
     656,  657,  688,  720,  689,  658,  659,  690,  721,  752,  753,  722,  691,  723,  754,  755,  780,  781,  812,  844,  813,  782,  783,  814,  845,  876,  877,  846,  815,  847,  878,  879, 
     904,  905,  936,  968,  937,  906,  907,  938,  969, 1000, 1001,  970,  939,  971, 1002, 1003,  908,  909,  940,  972,  941,  910,  911,  942,  973, 1004, 1005,  974,  943,  975, 1006, 1007, 
     784,  785,  816,  848,  817,  786,  787,  818,  849,  880,  881,  850,  819,  851,  882,  883,  660,  661,  692,  724,  693,  662,  663,  694,  725,  756,  757,  726,  695,  727,  758,  759, 
     536,  537,  568,  600,  569,  538,  539,  570,  601,  632,  633,  602,  571,  603,  634,  635,  412,  413,  444,  476,  445,  414,  415,  446,  477,  508,  509,  478,  447,  479,  510,  511, 
     540,  541,  572,  604,  573,  542,  543,  574,  605,  636,  637,  606,  575,  607,  638,  639,  664,  665,  696,  728,  697,  666,  667,  698,  729,  760,  761,  730,  699,  731,  762,  763, 
     788,  789,  820,  852,  821,  790,  791,  822,  853,  884,  885,  854,  823,  855,  886,  887,  912,  913,  944,  976,  945,  914,  915,  946,  977, 1008, 1009,  978,  947,  979, 1010, 1011, 
     916,  917,  948,  980,  949,  918,  919,  950,  981, 1012, 1013,  982,  951,  983, 1014, 1015,  792,  793,  824,  856,  825,  794,  795,  826,  857,  888,  889,  858,  827,  859,  890,  891, 
     668,  669,  700,  732,  701,  670,  671,  702,  733,  764,  765,  734,  703,  735,  766,  767,  796,  797,  828,  860,  829,  798,  799,  830,  861,  892,  893,  862,  831,  863,  894,  895, 
     920,  921,  952,  984,  953,  922,  923,  954,  985, 1016, 1017,  986,  955,  987, 1018, 1019,  924,  925,  956,  988,  957,  926,  927,  958,  989, 1020, 1021,  990,  959,  991, 1022, 1023
};

ALIGN32(const int16_t tab_1d_scan_2x8[16]) = {
       0,    1,    8,    9,    2,    3,   10,   11, 
       4,    5,   12,   13,    6,    7,   14,   15
 };

ALIGN32(const int16_t tab_1d_scan_4x16[64]) = {
       0,    1,   16,   32,   17,    2,    3,   18,   33,   48,   49,   34,   19,   35,   50,   51, 
       4,    5,   20,   36,   21,    6,    7,   22,   37,   52,   53,   38,   23,   39,   54,   55, 
       8,    9,   24,   40,   25,   10,   11,   26,   41,   56,   57,   42,   27,   43,   58,   59, 
      12,   13,   28,   44,   29,   14,   15,   30,   45,   60,   61,   46,   31,   47,   62,   63
 };

ALIGN32(const int16_t tab_1d_scan_8x32[256]) = {
      0,   1,  32,  64,  33,   2,   3,  34,  65,  96,  97,  66,  35,  67,  98,  99,   4,   5,  36,  68,  37,   6,   7,  38,  69, 100, 101,  70,  39,  71, 102, 103, 
    128, 129, 160, 192, 161, 130, 131, 162, 193, 224, 225, 194, 163, 195, 226, 227, 132, 133, 164, 196, 165, 134, 135, 166, 197, 228, 229, 198, 167, 199, 230, 231, 
      8,   9,  40,  72,  41,  10,  11,  42,  73, 104, 105,  74,  43,  75, 106, 107,  12,  13,  44,  76,  45,  14,  15,  46,  77, 108, 109,  78,  47,  79, 110, 111, 
    136, 137, 168, 200, 169, 138, 139, 170, 201, 232, 233, 202, 171, 203, 234, 235, 140, 141, 172, 204, 173, 142, 143, 174, 205, 236, 237, 206, 175, 207, 238, 239, 
     16,  17,  48,  80,  49,  18,  19,  50,  81, 112, 113,  82,  51,  83, 114, 115,  20,  21,  52,  84,  53,  22,  23,  54,  85, 116, 117,  86,  55,  87, 118, 119, 
    144, 145, 176, 208, 177, 146, 147, 178, 209, 240, 241, 210, 179, 211, 242, 243, 148, 149, 180, 212, 181, 150, 151, 182, 213, 244, 245, 214, 183, 215, 246, 247, 
     24,  25,  56,  88,  57,  26,  27,  58,  89, 120, 121,  90,  59,  91, 122, 123,  28,  29,  60,  92,  61,  30,  31,  62,  93, 124, 125,  94,  63,  95, 126, 127, 
    152, 153, 184, 216, 185, 154, 155, 186, 217, 248, 249, 218, 187, 219, 250, 251, 156, 157, 188, 220, 189, 158, 159, 190, 221, 252, 253, 222, 191, 223, 254, 255
};

ALIGN32(const int16_t tab_1d_scan_8x2[16]) = {
     0,  1, 
     2,  4, 
     3,  5, 
     6,  8, 
     7,  9, 
    10, 12, 
    11, 13, 
    14, 15
};

ALIGN32(const int16_t tab_1d_scan_16x4[64]) = {
     0,  1,  4,  8, 
     5,  2,  3,  6, 
     9, 12, 13, 10, 
     7, 11, 14, 15, 
    16, 17, 20, 24, 
    21, 18, 19, 22, 
    25, 28, 29, 26, 
    23, 27, 30, 31, 
    32, 33, 36, 40, 
    37, 34, 35, 38, 
    41, 44, 45, 42, 
    39, 43, 46, 47, 
    48, 49, 52, 56, 
    53, 50, 51, 54, 
    57, 60, 61, 58, 
    55, 59, 62, 63
};

ALIGN32(const int16_t tab_1d_scan_32x8[256]) = {
      0,   1,   8,  16,   9,   2,   3,  10, 
     17,  24,  25,  18,  11,  19,  26,  27, 
      4,   5,  12,  20,  13,   6,   7,  14, 
     21,  28,  29,  22,  15,  23,  30,  31, 
     32,  33,  40,  48,  41,  34,  35,  42, 
     49,  56,  57,  50,  43,  51,  58,  59, 
     64,  65,  72,  80,  73,  66,  67,  74, 
     81,  88,  89,  82,  75,  83,  90,  91, 
     36,  37,  44,  52,  45,  38,  39,  46, 
     53,  60,  61,  54,  47,  55,  62,  63, 
     68,  69,  76,  84,  77,  70,  71,  78, 
     85,  92,  93,  86,  79,  87,  94,  95, 
     96,  97, 104, 112, 105,  98,  99, 106, 
    113, 120, 121, 114, 107, 115, 122, 123, 
    128, 129, 136, 144, 137, 130, 131, 138, 
    145, 152, 153, 146, 139, 147, 154, 155, 
    100, 101, 108, 116, 109, 102, 103, 110, 
    117, 124, 125, 118, 111, 119, 126, 127, 
    132, 133, 140, 148, 141, 134, 135, 142, 
    149, 156, 157, 150, 143, 151, 158, 159, 
    160, 161, 168, 176, 169, 162, 163, 170, 
    177, 184, 185, 178, 171, 179, 186, 187, 
    192, 193, 200, 208, 201, 194, 195, 202, 
    209, 216, 217, 210, 203, 211, 218, 219, 
    164, 165, 172, 180, 173, 166, 167, 174, 
    181, 188, 189, 182, 175, 183, 190, 191, 
    196, 197, 204, 212, 205, 198, 199, 206, 
    213, 220, 221, 214, 207, 215, 222, 223, 
    224, 225, 232, 240, 233, 226, 227, 234, 
    241, 248, 249, 242, 235, 243, 250, 251, 
    228, 229, 236, 244, 237, 230, 231, 238, 
    245, 252, 253, 246, 239, 247, 254, 255, 
};

ALIGN32(const int16_t tab_1d_scan_swap_4x4[16]) = {
       0,    4,    1,    2, 
       5,    8,   12,    9, 
       6,    3,    7,   10, 
      13,   14,   11,   15
};

ALIGN32(const int16_t tab_1d_scan_swap_8x8[64]) = {
       0,    8,    1,    2,    9,   16,   24,   17, 
      10,    3,   11,   18,   25,   26,   19,   27, 
      32,   40,   33,   34,   41,   48,   56,   49, 
      42,   35,   43,   50,   57,   58,   51,   59, 
       4,   12,    5,    6,   13,   20,   28,   21, 
      14,    7,   15,   22,   29,   30,   23,   31, 
      36,   44,   37,   38,   45,   52,   60,   53, 
      46,   39,   47,   54,   61,   62,   55,   63
};

ALIGN32(const int16_t tab_1d_scan_swap_16x16[256]) = {
       0,   16,    1,    2,   17,   32,   48,   33,   18,    3,   19,   34,   49,   50,   35,   51, 
      64,   80,   65,   66,   81,   96,  112,   97,   82,   67,   83,   98,  113,  114,   99,  115, 
       4,   20,    5,    6,   21,   36,   52,   37,   22,    7,   23,   38,   53,   54,   39,   55, 
       8,   24,    9,   10,   25,   40,   56,   41,   26,   11,   27,   42,   57,   58,   43,   59, 
      68,   84,   69,   70,   85,  100,  116,  101,   86,   71,   87,  102,  117,  118,  103,  119, 
     128,  144,  129,  130,  145,  160,  176,  161,  146,  131,  147,  162,  177,  178,  163,  179, 
     192,  208,  193,  194,  209,  224,  240,  225,  210,  195,  211,  226,  241,  242,  227,  243, 
     132,  148,  133,  134,  149,  164,  180,  165,  150,  135,  151,  166,  181,  182,  167,  183, 
      72,   88,   73,   74,   89,  104,  120,  105,   90,   75,   91,  106,  121,  122,  107,  123, 
      12,   28,   13,   14,   29,   44,   60,   45,   30,   15,   31,   46,   61,   62,   47,   63, 
      76,   92,   77,   78,   93,  108,  124,  109,   94,   79,   95,  110,  125,  126,  111,  127, 
     136,  152,  137,  138,  153,  168,  184,  169,  154,  139,  155,  170,  185,  186,  171,  187, 
     196,  212,  197,  198,  213,  228,  244,  229,  214,  199,  215,  230,  245,  246,  231,  247, 
     200,  216,  201,  202,  217,  232,  248,  233,  218,  203,  219,  234,  249,  250,  235,  251, 
     140,  156,  141,  142,  157,  172,  188,  173,  158,  143,  159,  174,  189,  190,  175,  191, 
     204,  220,  205,  206,  221,  236,  252,  237,  222,  207,  223,  238,  253,  254,  239,  255
};

ALIGN32(const int16_t tab_1d_scan_swap_32x32[1024]) = {
       0,   32,    1,    2,   33,   64,   96,   65,   34,    3,   35,   66,   97,   98,   67,   99,  128,  160,  129,  130,  161,  192,  224,  193,  162,  131,  163,  194,  225,  226,  195,  227, 
       4,   36,    5,    6,   37,   68,  100,   69,   38,    7,   39,   70,  101,  102,   71,  103,    8,   40,    9,   10,   41,   72,  104,   73,   42,   11,   43,   74,  105,  106,   75,  107, 
     132,  164,  133,  134,  165,  196,  228,  197,  166,  135,  167,  198,  229,  230,  199,  231,  256,  288,  257,  258,  289,  320,  352,  321,  290,  259,  291,  322,  353,  354,  323,  355, 
     384,  416,  385,  386,  417,  448,  480,  449,  418,  387,  419,  450,  481,  482,  451,  483,  260,  292,  261,  262,  293,  324,  356,  325,  294,  263,  295,  326,  357,  358,  327,  359, 
     136,  168,  137,  138,  169,  200,  232,  201,  170,  139,  171,  202,  233,  234,  203,  235,   12,   44,   13,   14,   45,   76,  108,   77,   46,   15,   47,   78,  109,  110,   79,  111, 
      16,   48,   17,   18,   49,   80,  112,   81,   50,   19,   51,   82,  113,  114,   83,  115,  140,  172,  141,  142,  173,  204,  236,  205,  174,  143,  175,  206,  237,  238,  207,  239, 
     264,  296,  265,  266,  297,  328,  360,  329,  298,  267,  299,  330,  361,  362,  331,  363,  388,  420,  389,  390,  421,  452,  484,  453,  422,  391,  423,  454,  485,  486,  455,  487, 
     512,  544,  513,  514,  545,  576,  608,  577,  546,  515,  547,  578,  609,  610,  579,  611,  640,  672,  641,  642,  673,  704,  736,  705,  674,  643,  675,  706,  737,  738,  707,  739, 
     516,  548,  517,  518,  549,  580,  612,  581,  550,  519,  551,  582,  613,  614,  583,  615,  392,  424,  393,  394,  425,  456,  488,  457,  426,  395,  427,  458,  489,  490,  459,  491, 
     268,  300,  269,  270,  301,  332,  364,  333,  302,  271,  303,  334,  365,  366,  335,  367,  144,  176,  145,  146,  177,  208,  240,  209,  178,  147,  179,  210,  241,  242,  211,  243, 
      20,   52,   21,   22,   53,   84,  116,   85,   54,   23,   55,   86,  117,  118,   87,  119,   24,   56,   25,   26,   57,   88,  120,   89,   58,   27,   59,   90,  121,  122,   91,  123, 
     148,  180,  149,  150,  181,  212,  244,  213,  182,  151,  183,  214,  245,  246,  215,  247,  272,  304,  273,  274,  305,  336,  368,  337,  306,  275,  307,  338,  369,  370,  339,  371, 
     396,  428,  397,  398,  429,  460,  492,  461,  430,  399,  431,  462,  493,  494,  463,  495,  520,  552,  521,  522,  553,  584,  616,  585,  554,  523,  555,  586,  617,  618,  587,  619, 
     644,  676,  645,  646,  677,  708,  740,  709,  678,  647,  679,  710,  741,  742,  711,  743,  768,  800,  769,  770,  801,  832,  864,  833,  802,  771,  803,  834,  865,  866,  835,  867, 
     896,  928,  897,  898,  929,  960,  992,  961,  930,  899,  931,  962,  993,  994,  963,  995,  772,  804,  773,  774,  805,  836,  868,  837,  806,  775,  807,  838,  869,  870,  839,  871, 
     648,  680,  649,  650,  681,  712,  744,  713,  682,  651,  683,  714,  745,  746,  715,  747,  524,  556,  525,  526,  557,  588,  620,  589,  558,  527,  559,  590,  621,  622,  591,  623, 
     400,  432,  401,  402,  433,  464,  496,  465,  434,  403,  435,  466,  497,  498,  467,  499,  276,  308,  277,  278,  309,  340,  372,  341,  310,  279,  311,  342,  373,  374,  343,  375, 
     152,  184,  153,  154,  185,  216,  248,  217,  186,  155,  187,  218,  249,  250,  219,  251,   28,   60,   29,   30,   61,   92,  124,   93,   62,   31,   63,   94,  125,  126,   95,  127, 
     156,  188,  157,  158,  189,  220,  252,  221,  190,  159,  191,  222,  253,  254,  223,  255,  280,  312,  281,  282,  313,  344,  376,  345,  314,  283,  315,  346,  377,  378,  347,  379, 
     404,  436,  405,  406,  437,  468,  500,  469,  438,  407,  439,  470,  501,  502,  471,  503,  528,  560,  529,  530,  561,  592,  624,  593,  562,  531,  563,  594,  625,  626,  595,  627, 
     652,  684,  653,  654,  685,  716,  748,  717,  686,  655,  687,  718,  749,  750,  719,  751,  776,  808,  777,  778,  809,  840,  872,  841,  810,  779,  811,  842,  873,  874,  843,  875, 
     900,  932,  901,  902,  933,  964,  996,  965,  934,  903,  935,  966,  997,  998,  967,  999,  904,  936,  905,  906,  937,  968, 1000,  969,  938,  907,  939,  970, 1001, 1002,  971, 1003, 
     780,  812,  781,  782,  813,  844,  876,  845,  814,  783,  815,  846,  877,  878,  847,  879,  656,  688,  657,  658,  689,  720,  752,  721,  690,  659,  691,  722,  753,  754,  723,  755, 
     532,  564,  533,  534,  565,  596,  628,  597,  566,  535,  567,  598,  629,  630,  599,  631,  408,  440,  409,  410,  441,  472,  504,  473,  442,  411,  443,  474,  505,  506,  475,  507, 
     284,  316,  285,  286,  317,  348,  380,  349,  318,  287,  319,  350,  381,  382,  351,  383,  412,  444,  413,  414,  445,  476,  508,  477,  446,  415,  447,  478,  509,  510,  479,  511, 
     536,  568,  537,  538,  569,  600,  632,  601,  570,  539,  571,  602,  633,  634,  603,  635,  660,  692,  661,  662,  693,  724,  756,  725,  694,  663,  695,  726,  757,  758,  727,  759, 
     784,  816,  785,  786,  817,  848,  880,  849,  818,  787,  819,  850,  881,  882,  851,  883,  908,  940,  909,  910,  941,  972, 1004,  973,  942,  911,  943,  974, 1005, 1006,  975, 1007, 
     912,  944,  913,  914,  945,  976, 1008,  977,  946,  915,  947,  978, 1009, 1010,  979, 1011,  788,  820,  789,  790,  821,  852,  884,  853,  822,  791,  823,  854,  885,  886,  855,  887, 
     664,  696,  665,  666,  697,  728,  760,  729,  698,  667,  699,  730,  761,  762,  731,  763,  540,  572,  541,  542,  573,  604,  636,  605,  574,  543,  575,  606,  637,  638,  607,  639, 
     668,  700,  669,  670,  701,  732,  764,  733,  702,  671,  703,  734,  765,  766,  735,  767,  792,  824,  793,  794,  825,  856,  888,  857,  826,  795,  827,  858,  889,  890,  859,  891, 
     916,  948,  917,  918,  949,  980, 1012,  981,  950,  919,  951,  982, 1013, 1014,  983, 1015,  920,  952,  921,  922,  953,  984, 1016,  985,  954,  923,  955,  986, 1017, 1018,  987, 1019, 
     796,  828,  797,  798,  829,  860,  892,  861,  830,  799,  831,  862,  893,  894,  863,  895,  924,  956,  925,  926,  957,  988, 1020,  989,  958,  927,  959,  990, 1021, 1022,  991, 1023
};


const int16_t   *tab_coef_scan1_list_nxn[2][4] = {
    {
        tab_1d_scan_4x4,
        tab_1d_scan_8x8,
        tab_1d_scan_16x16,
        tab_1d_scan_32x32
    },
    {
        tab_1d_scan_swap_4x4,
        tab_1d_scan_swap_8x8,
        tab_1d_scan_swap_16x16,
        tab_1d_scan_swap_32x32
    }
};

const int16_t   *tab_coef_scan1_list_hor[3] = {
    tab_1d_scan_2x8,
    tab_1d_scan_4x16,
    tab_1d_scan_8x32
};

const int16_t   *tab_coef_scan1_list_ver[3] = {
    tab_1d_scan_8x2,
    tab_1d_scan_16x4,
    tab_1d_scan_32x8
};

/**
 * ===========================================================================
 * function definition
 * ===========================================================================
 */

/* ---------------------------------------------------------------------------
 * CGϵɨ˳ϵתã
 */
static
void coeff_scan_4x4_xy_c(coeff_t *dst, const coeff_t *src, int i_src_shift)
{
    int i;
    int j = 0;

    for (i = 0; i < 16; i++) {
        int xx = tab_scan_4x4[i][0];
        int yy = tab_scan_4x4[i][1];
        coeff_t level = src[(yy << i_src_shift) + xx];

        dst[j] = level;
        j++;
    }
}


/* ---------------------------------------------------------------------------
 * CGϵɨ˳ϵתã
 */
static
void coeff_scan_4x4_yx_c(coeff_t *dst, const coeff_t *src, int i_src_shift)
{
    int i;
    int j = 0;

    for (i = 0; i < 16; i++) {
        int xx = tab_scan_4x4[i][1];
        int yy = tab_scan_4x4[i][0];
        coeff_t level = src[(yy << i_src_shift) + xx];

        dst[j] = level;
        j++;
    }
}


/* ---------------------------------------------------------------------------
 */
void coeff_scan4_xy_c(coeff_t *dst, uint64_t r1, uint64_t r2, uint64_t r3, uint64_t r4)
{
    uint64_t src[16];
    src[0] = r1;
    src[1] = r2;
    src[2] = r3;
    src[3] = r4;
    g_funcs.transpose_coeff_scan[LUMA_4x4][0](dst, (coeff_t *)src, 2);
}

/* ---------------------------------------------------------------------------
 */
void coeff_scan4_yx_c(coeff_t *dst, uint64_t r1, uint64_t r2, uint64_t r3, uint64_t r4)
{
    uint64_t src[16];
    src[0] = r1;
    src[1] = r2;
    src[2] = r3;
    src[3] = r4;
    g_funcs.transpose_coeff_scan[LUMA_4x4][1](dst, (coeff_t *)src, 2);
}

/* ---------------------------------------------------------------------------
 */
static
void coeff_scan_8x8_xy_c(coeff_t *dst, const coeff_t *src, int i_src_shift)
{
    const int num_cg = 4;
    int i_cg;

    for (i_cg = num_cg - 1; i_cg >= 0; i_cg--) {
        int cg_x = tab_scan_2x2[i_cg][0] << 2;
        int cg_y = tab_scan_2x2[i_cg][1] << 2;
        g_funcs.transpose_coeff_scan[LUMA_4x4][0](dst, src + (cg_y << i_src_shift) + cg_x, i_src_shift);
        dst += 16;
    }
}

/* ---------------------------------------------------------------------------
 */
static
void coeff_scan_8x8_yx_c(coeff_t *dst, const coeff_t *src, int i_src_shift)
{
    const int num_cg = 4;
    int i_cg;

    for (i_cg = num_cg - 1; i_cg >= 0; i_cg--) {
        int cg_x = tab_scan_2x2[i_cg][1] << 2;
        int cg_y = tab_scan_2x2[i_cg][0] << 2;
        g_funcs.transpose_coeff_scan[LUMA_4x4][1](dst, src + (cg_y << i_src_shift) + cg_x, i_src_shift);
        dst += 16;
    }
}

/* ---------------------------------------------------------------------------
 */
static
void coeff_scan_16x16_xy_c(coeff_t *dst, const coeff_t *src, int i_src_shift)
{
    const int num_cg = 16;
    int i_cg;

    for (i_cg = num_cg - 1; i_cg >= 0; i_cg--) {
        int cg_x = tab_scan_4x4[i_cg][0] << 2;
        int cg_y = tab_scan_4x4[i_cg][1] << 2;
        g_funcs.transpose_coeff_scan[LUMA_4x4][0](dst, src + (cg_y << i_src_shift) + cg_x, i_src_shift);
        dst += 16;
    }
}

/* ---------------------------------------------------------------------------
 */
static
void coeff_scan_16x16_yx_c(coeff_t *dst, const coeff_t *src, int i_src_shift)
{
    const int num_cg = 16;
    int i_cg;

    for (i_cg = num_cg - 1; i_cg >= 0; i_cg--) {
        int cg_x = tab_scan_4x4[i_cg][1] << 2;
        int cg_y = tab_scan_4x4[i_cg][0] << 2;
        g_funcs.transpose_coeff_scan[LUMA_4x4][1](dst, src + (cg_y << i_src_shift) + cg_x, i_src_shift);
        dst += 16;
    }
}

/* ---------------------------------------------------------------------------
 */
static
void coeff_scan_32x32_xy_c(coeff_t *dst, const coeff_t *src, int i_src_shift)
{
    const int num_cg = 64;
    int i_cg;

    for (i_cg = num_cg - 1; i_cg >= 0; i_cg--) {
        int cg_x = tab_scan_8x8[i_cg][0] << 2;
        int cg_y = tab_scan_8x8[i_cg][1] << 2;
        g_funcs.transpose_coeff_scan[LUMA_4x4][0](dst, src + (cg_y << i_src_shift) + cg_x, i_src_shift);
        dst += 16;
    }
}

/* ---------------------------------------------------------------------------
 */
static
void coeff_scan_32x32_yx_c(coeff_t *dst, const coeff_t *src, int i_src_shift)
{
    const int num_cg = 64;
    int i_cg;

    for (i_cg = num_cg - 1; i_cg >= 0; i_cg--) {
        int cg_x = tab_scan_8x8[i_cg][1] << 2;
        int cg_y = tab_scan_8x8[i_cg][0] << 2;
        g_funcs.transpose_coeff_scan[LUMA_4x4][1](dst, src + (cg_y << i_src_shift) + cg_x, i_src_shift);
        dst += 16;
    }
}


/* ---------------------------------------------------------------------------
 */
static
void coeff_scan_4x16_xy_c(coeff_t *dst, const coeff_t *src, int i_src_shift)
{
    const int num_cg = 4;
    int i_cg;

    for (i_cg = num_cg - 1; i_cg >= 0; i_cg--) {
        int cg_x = tab_scan_1x4[i_cg][0] << 2;
        int cg_y = tab_scan_1x4[i_cg][1] << 2;
        g_funcs.transpose_coeff_scan[LUMA_4x4][0](dst, src + (cg_y << i_src_shift) + cg_x, i_src_shift);
        dst += 16;
    }
}

/* ---------------------------------------------------------------------------
 */
static
void coeff_scan_16x4_xy_c(coeff_t *dst, const coeff_t *src, int i_src_shift)
{
    const int num_cg = 4;
    int i_cg;

    for (i_cg = num_cg - 1; i_cg >= 0; i_cg--) {
        int cg_x = tab_scan_4x1[i_cg][0] << 2;
        int cg_y = tab_scan_4x1[i_cg][1] << 2;
        g_funcs.transpose_coeff_scan[LUMA_4x4][0](dst, src + (cg_y << i_src_shift) + cg_x, i_src_shift);
        dst += 16;
    }
}

/* ---------------------------------------------------------------------------
 */
static
void coeff_scan_8x32_xy_c(coeff_t *dst, const coeff_t *src, int i_src_shift)
{
    const int num_cg = 16;
    int i_cg;

    for (i_cg = num_cg - 1; i_cg >= 0; i_cg--) {
        int cg_x = tab_scan_2x8[i_cg][0] << 2;
        int cg_y = tab_scan_2x8[i_cg][1] << 2;
        g_funcs.transpose_coeff_scan[LUMA_4x4][0](dst, src + (cg_y << i_src_shift) + cg_x, i_src_shift);
        dst += 16;
    }
}

/* ---------------------------------------------------------------------------
 */
static
void coeff_scan_32x8_xy_c(coeff_t *dst, const coeff_t *src, int i_src_shift)
{
    const int num_cg = 16;
    int i_cg;

    for (i_cg = num_cg - 1; i_cg >= 0; i_cg--) {
        int cg_x = tab_scan_8x2[i_cg][0] << 2;
        int cg_y = tab_scan_8x2[i_cg][1] << 2;
        g_funcs.transpose_coeff_scan[LUMA_4x4][0](dst, src + (cg_y << i_src_shift) + cg_x, i_src_shift);
        dst += 16;
    }
}



/* ---------------------------------------------------------------------------
 */
void xavs2_cg_scan_init(uint32_t cpuid, intrinsic_func_t *pf)
{
    pf->transpose_coeff_scan[LUMA_4x4  ][0] = coeff_scan_4x4_xy_c;
    pf->transpose_coeff_scan[LUMA_4x4  ][1] = coeff_scan_4x4_yx_c;
    pf->transpose_coeff_scan[LUMA_8x8  ][0] = coeff_scan_8x8_xy_c;
    pf->transpose_coeff_scan[LUMA_8x8  ][1] = coeff_scan_8x8_yx_c;
    pf->transpose_coeff_scan[LUMA_16x16][0] = coeff_scan_16x16_xy_c;
    pf->transpose_coeff_scan[LUMA_16x16][1] = coeff_scan_16x16_yx_c;
    pf->transpose_coeff_scan[LUMA_32x32][0] = coeff_scan_32x32_xy_c;
    pf->transpose_coeff_scan[LUMA_32x32][1] = coeff_scan_32x32_yx_c;

    pf->transpose_coeff_scan[LUMA_4x16 ][0] = coeff_scan_4x16_xy_c;
    pf->transpose_coeff_scan[LUMA_16x4 ][0] = coeff_scan_16x4_xy_c;
    pf->transpose_coeff_scan[LUMA_8x32 ][0] = coeff_scan_8x32_xy_c;
    pf->transpose_coeff_scan[LUMA_32x8 ][0] = coeff_scan_32x8_xy_c;

    pf->transpose_coeff_4x4[0] = coeff_scan4_xy_c;
    pf->transpose_coeff_4x4[1] = coeff_scan4_yx_c;

#if HAVE_MMX
    /* SSE 128bit */
    if (cpuid & XAVS2_CPU_SSE42) {
        pf->transpose_coeff_scan[LUMA_4x4][0] = coeff_scan_4x4_xy_sse128;
        pf->transpose_coeff_scan[LUMA_4x4][1] = coeff_scan_4x4_yx_sse128;
#if ARCH_X86_64
        pf->transpose_coeff_4x4[0]            = coeff_scan4_xy_sse128;
        pf->transpose_coeff_4x4[1]            = coeff_scan4_yx_sse128;
#endif
    }

    /* AVX 256bit */
    if (cpuid & XAVS2_CPU_AVX2) {
#if ARCH_X86_64
        /* avxsse45%ңĬϹر */
        // pf->transpose_coeff_4x4[0] = coeff_scan4_xy_avx;
        // pf->transpose_coeff_4x4[1] = coeff_scan4_yx_avx;
#endif
    }
#else
    UNUSED_PARAMETER(cpuid);
#endif
}
