// ============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2014 - Scilab Enterprises - Antoine ELIAS
//
//  This file is distributed under the same license as the Scilab package.
// ============================================================================

// <-- CLI SHELL MODE -->

s = %s;
empty = [];
r = 2;
R = [1,2;3,4];
R3(:,:,1) = R;
R3(:,:,2) = R';
c = 1 + 2*%i;
C = [1+2*%i,2+4*%i;3+6*%i,4+8*%i];
C3(:,:,1) = C;
C3(:,:,2) = C';
e = eye();
ec = (5+%i) * eye();
p = 1 + %s - %s**2;
pc = 1 + %s - %s**2 + ( 2 - 3 * %s + 4 * %s**2 ) * %i;
P = [2*p, -3*p;4*p,-5*p];
PC = [2*pc, -3*pc;4*pc,-5*pc];
SP = sparse([1,2;4,5;3,10],[1,2,3]);
SPC = sparse([1,2;4,5;3,10],[1,2,3]) * ( 1 + 4*%i);

i8 = int8(-8);
ui8 = uint8(8);
I8 = int8([-8 -16 ; -24 -32]);
UI8 = uint8([8 16 ; 24 32]);

I16 = int16([-16 -32 ; -48 -64]);
UI16 = uint16([16 32 ; 48 64]);
i16 = int16(-16);
ui16 = uint16(16);

i32 = int32(-32);
ui32 = uint32(32);
I32 = int32([-32 -64 ; -96 -128]);
UI32 = uint32([32 64 ; 96 128]);

assert_checkequal(empty .* empty, []);
assert_checkequal(empty .* r, []);
assert_checkequal(empty .* c, []);
assert_checkequal(empty .* R, []);
assert_checkequal(empty .* C, []);
assert_checkequal(empty .* e, []);
assert_checkequal(empty .* ec, []);
assert_checkequal(empty .* p, []);
assert_checkequal(empty .* pc, []);
assert_checkequal(empty .* P, []);
assert_checkequal(empty .* PC, []);
assert_checkequal(empty .* SP, []);
assert_checkequal(empty .* SPC, []);

assert_checkequal(r .* empty, []);
assert_checkequal(r .* r, 4);
assert_checkequal(r .* c,  2+%i*4);
assert_checkequal(r .* R, [2,4;6,8]);
assert_checkequal(r .* C, [ 2+%i*4, 4+%i*8; 6+%i*12, 8+%i*16]);
assert_checkequal(r .* e, (2)*eye());
assert_checkequal(r .* ec, ( 10+%i*2)*eye());
assert_checkequal(r .* p, 2+2*s-2*s^2);
assert_checkequal(r .* pc, 2+%i*4+(2-%i*6)*s+(-2+%i*8)*s^2);
assert_checkequal(r .* P, [4+4*s-4*s^2,-6-6*s+6*s^2;8+8*s-8*s^2,-10-10*s+10*s^2]);
assert_checkequal(r .* PC, [4+%i*8+(4-%i*12)*s+(-4+%i*16)*s^2,-6-%i*12+(-6+%i*18)*s+(6-%i*24)*s^2;8+%i*16+(8-%i*24)*s+(-8+%i*32)*s^2,-10-%i*20+(-10+%i*30)*s+(10-%i*40)*s^2]);
assert_checkequal(r .* SP, sparse([1,2;3,10;4,5],[2;6;4],[4,10]));
assert_checkequal(r .* SPC, sparse([1,2;3,10;4,5],[ 2+%i*8; 6+%i*24; 4+%i*16],[4,10]));
assert_checkequal(r .* i8, int8(-16));
assert_checkequal(r .* I8, int8([-16,-32;-48,-64]));
assert_checkequal(r .* ui8, uint8(16));
assert_checkequal(r .* UI8, uint8([16,32;48,64]));
assert_checkequal(r .* i16, int16(-32));
assert_checkequal(r .* I16, int16([-32,-64;-96,-128]));
assert_checkequal(r .* ui16, uint16(32));
assert_checkequal(r .* UI16, uint16([32,64;96,128]));
assert_checkequal(r .* i32, int32(-64));
assert_checkequal(r .* I32, int32([-64,-128;-192,-256]));
assert_checkequal(r .* ui32, uint32(64));
assert_checkequal(r .* UI32, uint32([64,128;192,256]));

assert_checkequal(c .* empty, []);
assert_checkequal(c .* r,  2+%i*4);
assert_checkequal(c .* c, -3+%i*4);
assert_checkequal(c .* R, [ 1+%i*2, 2+%i*4; 3+%i*6, 4+%i*8]);
assert_checkequal(c .* C, [-3+%i*4,-6+%i*8;-9+%i*12,-12+%i*16]);
assert_checkequal(c .* e, ( 1+%i*2)*eye());
assert_checkequal(c .* ec, ( 3+%i*11)*eye());
assert_checkequal(c .* p, 1+%i*2+(1+%i*2)*s+(-1-%i*2)*s^2);
assert_checkequal(c .* pc, -3+%i*4+(7-%i)*s+(-9+%i*2)*s^2);
assert_checkequal(c .* P, [2+%i*4+(2+%i*4)*s+(-2-%i*4)*s^2,-3-%i*6+(-3-%i*6)*s+(3+%i*6)*s^2;4+%i*8+(4+%i*8)*s+(-4-%i*8)*s^2,-5-%i*10+(-5-%i*10)*s+(5+%i*10)*s^2]);
assert_checkequal(c .* PC, [-6+%i*8+(14-%i*2)*s+(-18+%i*4)*s^2,9-%i*12+(-21+%i*3)*s+(27-%i*6)*s^2;-12+%i*16+(28-%i*4)*s+(-36+%i*8)*s^2,15-%i*20+(-35+%i*5)*s+(45-%i*10)*s^2]);
assert_checkequal(c .* SP, sparse([1,2;3,10;4,5],[ 1+%i*2; 3+%i*6; 2+%i*4],[4,10]));
assert_checkequal(c .* SPC, sparse([1,2;3,10;4,5],[-7+%i*6;-21+%i*18;-14+%i*12],[4,10]));

assert_checkequal(R .* empty, []);
assert_checkequal(R .* r, [2,4;6,8]);
assert_checkequal(R .* c, [ 1+%i*2, 2+%i*4; 3+%i*6, 4+%i*8]);
assert_checkequal(R .* R, [1,4;9,16]);
assert_checkequal(R .* C, [ 1+%i*2, 4+%i*8; 9+%i*18, 16+%i*32]);
assert_checkequal(R .* p, [1+s-s^2,2+2*s-2*s^2;3+3*s-3*s^2,4+4*s-4*s^2]);
assert_checkequal(R .* pc, [1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2,2+%i*4+(2-%i*6)*s+(-2+%i*8)*s^2;3+%i*6+(3-%i*9)*s+(-3+%i*12)*s^2,4+%i*8+(4-%i*12)*s+(-4+%i*16)*s^2]);
assert_checkequal(R .* P, [2+2*s-2*s^2,-6-6*s+6*s^2;12+12*s-12*s^2,-20-20*s+20*s^2]);
assert_checkequal(R .* PC, [2+%i*4+(2-%i*6)*s+(-2+%i*8)*s^2,-6-%i*12+(-6+%i*18)*s+(6-%i*24)*s^2;12+%i*24+(12-%i*36)*s+(-12+%i*48)*s^2,-20-%i*40+(-20+%i*60)*s+(20-%i*80)*s^2]);
assert_checkequal(R .* i8, int8([-8,-16;-24,-32]));
assert_checkequal(R .* I8, int8([-8,-32;-72,-128]));
assert_checkequal(R .* ui8, uint8([8,16;24,32]));
assert_checkequal(R .* UI8, uint8([8,32;72,128]));
assert_checkequal(R .* i16, int16([-16,-32;-48,-64]));
assert_checkequal(R .* I16, int16([-16,-64;-144,-256]));
assert_checkequal(R .* ui16, uint16([16,32;48,64]));
assert_checkequal(R .* UI16, uint16([16,64;144,256]));
assert_checkequal(R .* i32, int32([-32,-64;-96,-128]));
assert_checkequal(R .* I32, int32([-32,-128;-288,-512]));
assert_checkequal(R .* ui32, uint32([32,64;96,128]));
assert_checkequal(R .* UI32, uint32([32,128;288,512]));

assert_checkequal(C .* empty, []);
assert_checkequal(C .* r, [ 2+%i*4, 4+%i*8; 6+%i*12, 8+%i*16]);
assert_checkequal(C .* c, [-3+%i*4,-6+%i*8;-9+%i*12,-12+%i*16]);
assert_checkequal(C .* R, [ 1+%i*2, 4+%i*8; 9+%i*18, 16+%i*32]);
assert_checkequal(C .* C, [-3+%i*4,-12+%i*16;-27+%i*36,-48+%i*64]);
assert_checkequal(C .* p, [1+%i*2+(1+%i*2)*s+(-1-%i*2)*s^2,2+%i*4+(2+%i*4)*s+(-2-%i*4)*s^2;3+%i*6+(3+%i*6)*s+(-3-%i*6)*s^2,4+%i*8+(4+%i*8)*s+(-4-%i*8)*s^2]);
assert_checkequal(C .* pc, [-3+%i*4+(7-%i)*s+(-9+%i*2)*s^2,-6+%i*8+(14-%i*2)*s+(-18+%i*4)*s^2;-9+%i*12+(21-%i*3)*s+(-27+%i*6)*s^2,-12+%i*16+(28-%i*4)*s+(-36+%i*8)*s^2]);
assert_checkequal(C .* P, [2+%i*4+(2+%i*4)*s+(-2-%i*4)*s^2,-6-%i*12+(-6-%i*12)*s+(6+%i*12)*s^2;12+%i*24+(12+%i*24)*s+(-12-%i*24)*s^2,-20-%i*40+(-20-%i*40)*s+(20+%i*40)*s^2]);
assert_checkequal(C .* PC, [-6+%i*8+(14-%i*2)*s+(-18+%i*4)*s^2,18-%i*24+(-42+%i*6)*s+(54-%i*12)*s^2;-36+%i*48+(84-%i*12)*s+(-108+%i*24)*s^2,60-%i*80+(-140+%i*20)*s+(180-%i*40)*s^2]);

assert_checkequal(e .* empty, []);
assert_checkequal(e .* r, (2)*eye());
assert_checkequal(e .* c, ( 1+%i*2)*eye());
assert_checkequal(e .* e, eye());
assert_checkequal(e .* ec, ( 5+%i)*eye());
assert_checkequal(e .* p, (1+s-s^2)*eye());
assert_checkequal(e .* pc, (1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2)*eye());
assert_checkequal(e .* i8, int8((-8)*eye()));
assert_checkequal(e .* ui8, uint8((8)*eye()));
assert_checkequal(e .* i16, int16((-16)*eye()));
assert_checkequal(e .* ui16, uint16((16)*eye()));
assert_checkequal(e .* i32, int32((-32)*eye()));
assert_checkequal(e .* ui32, uint32((32)*eye()));

assert_checkequal(ec .* empty, []);
assert_checkequal(ec .* r, ( 10+%i*2)*eye());
assert_checkequal(ec .* c, ( 3+%i*11)*eye());
assert_checkequal(ec .* e, ( 5+%i)*eye());
assert_checkequal(ec .* ec, ( 24+%i*10)*eye());
assert_checkequal(ec .* p, (5+%i+(5+%i)*s+(-5-%i)*s^2)*eye());
assert_checkequal(ec .* pc, (3+%i*11+(8-%i*14)*s+(-9+%i*19)*s^2)*eye());

assert_checkequal(p .* empty, []);
assert_checkequal(p .* r, 2+2*s-2*s^2);
assert_checkequal(p .* c, 1+%i*2+(1+%i*2)*s+(-1-%i*2)*s^2);
assert_checkequal(p .* R, [1+s-s^2,2+2*s-2*s^2;3+3*s-3*s^2,4+4*s-4*s^2]);
assert_checkequal(p .* C, [1+%i*2+(1+%i*2)*s+(-1-%i*2)*s^2,2+%i*4+(2+%i*4)*s+(-2-%i*4)*s^2;3+%i*6+(3+%i*6)*s+(-3-%i*6)*s^2,4+%i*8+(4+%i*8)*s+(-4-%i*8)*s^2]);
assert_checkequal(p .* e, (1+s-s^2)*eye());
assert_checkequal(p .* ec, (5+%i+(5+%i)*s+(-5-%i)*s^2)*eye());
assert_checkequal(p .* p, 1+2*s-s^2-2*s^3+s^4);
assert_checkequal(p .* pc, 1+%i*2+(2-%i)*s+(-1-%i)*s^2+(-2+%i*7)*s^3+(1-%i*4)*s^4);
assert_checkequal(p .* P, [2+4*s-2*s^2-4*s^3+2*s^4,-3-6*s+3*s^2+6*s^3-3*s^4;4+8*s-4*s^2-8*s^3+4*s^4,-5-10*s+5*s^2+10*s^3-5*s^4]);
assert_checkequal(p .* PC, [2+%i*4+(4-%i*2)*s+(-2-%i*2)*s^2+(-4+%i*14)*s^3+(2-%i*8)*s^4,-3-%i*6+(-6+%i*3)*s+(3+%i*3)*s^2+(6-%i*21)*s^3+(-3+%i*12)*s^4;4+%i*8+(8-%i*4)*s+(-4-%i*4)*s^2+(-8+%i*28)*s^3+(4-%i*16)*s^4,-5-%i*10+(-10+%i*5)*s+(5+%i*5)*s^2+(10-%i*35)*s^3+(-5+%i*20)*s^4]);

assert_checkequal(pc .* empty, []);
assert_checkequal(pc .* r, 2+%i*4+(2-%i*6)*s+(-2+%i*8)*s^2);
assert_checkequal(pc .* c, -3+%i*4+(7-%i)*s+(-9+%i*2)*s^2);
assert_checkequal(pc .* R, [1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2,2+%i*4+(2-%i*6)*s+(-2+%i*8)*s^2;3+%i*6+(3-%i*9)*s+(-3+%i*12)*s^2,4+%i*8+(4-%i*12)*s+(-4+%i*16)*s^2]);
assert_checkequal(pc .* C, [-3+%i*4+(7-%i)*s+(-9+%i*2)*s^2,-6+%i*8+(14-%i*2)*s+(-18+%i*4)*s^2;-9+%i*12+(21-%i*3)*s+(-27+%i*6)*s^2,-12+%i*16+(28-%i*4)*s+(-36+%i*8)*s^2]);
assert_checkequal(pc .* e, (1+%i*2+(1-%i*3)*s+(-1+%i*4)*s^2)*eye());
assert_checkequal(pc .* ec, (3+%i*11+(8-%i*14)*s+(-9+%i*19)*s^2)*eye());
assert_checkequal(pc .* p, 1+%i*2+(2-%i)*s+(-1-%i)*s^2+(-2+%i*7)*s^3+(1-%i*4)*s^4);
assert_checkequal(pc .* pc, -3+%i*4+(14-%i*2)*s+(-26-%i*2)*s^2+(22+%i*14)*s^3+(-15-%i*8)*s^4);
assert_checkequal(pc .* P, [2+%i*4+(4-%i*2)*s+(-2-%i*2)*s^2+(-4+%i*14)*s^3+(2-%i*8)*s^4,-3-%i*6+(-6+%i*3)*s+(3+%i*3)*s^2+(6-%i*21)*s^3+(-3+%i*12)*s^4;4+%i*8+(8-%i*4)*s+(-4-%i*4)*s^2+(-8+%i*28)*s^3+(4-%i*16)*s^4,-5-%i*10+(-10+%i*5)*s+(5+%i*5)*s^2+(10-%i*35)*s^3+(-5+%i*20)*s^4]);
assert_checkequal(pc .* PC, [-6+%i*8+(28-%i*4)*s+(-52-%i*4)*s^2+(44+%i*28)*s^3+(-30-%i*16)*s^4,9-%i*12+(-42+%i*6)*s+(78+%i*6)*s^2+(-66-%i*42)*s^3+(45+%i*24)*s^4;-12+%i*16+(56-%i*8)*s+(-104-%i*8)*s^2+(88+%i*56)*s^3+(-60-%i*32)*s^4,15-%i*20+(-70+%i*10)*s+(130+%i*10)*s^2+(-110-%i*70)*s^3+(75+%i*40)*s^4]);

assert_checkequal(P .* empty, []);
assert_checkequal(P .* r, [4+4*s-4*s^2,-6-6*s+6*s^2;8+8*s-8*s^2,-10-10*s+10*s^2]);
assert_checkequal(P .* c, [2+%i*4+(2+%i*4)*s+(-2-%i*4)*s^2,-3-%i*6+(-3-%i*6)*s+(3+%i*6)*s^2;4+%i*8+(4+%i*8)*s+(-4-%i*8)*s^2,-5-%i*10+(-5-%i*10)*s+(5+%i*10)*s^2]);
assert_checkequal(P .* R, [2+2*s-2*s^2,-6-6*s+6*s^2;12+12*s-12*s^2,-20-20*s+20*s^2]);
assert_checkequal(P .* C, [2+%i*4+(2+%i*4)*s+(-2-%i*4)*s^2,-6-%i*12+(-6-%i*12)*s+(6+%i*12)*s^2;12+%i*24+(12+%i*24)*s+(-12-%i*24)*s^2,-20-%i*40+(-20-%i*40)*s+(20+%i*40)*s^2]);
assert_checkequal(P .* p, [2+4*s-2*s^2-4*s^3+2*s^4,-3-6*s+3*s^2+6*s^3-3*s^4;4+8*s-4*s^2-8*s^3+4*s^4,-5-10*s+5*s^2+10*s^3-5*s^4]);
assert_checkequal(P .* pc, [2+%i*4+(4-%i*2)*s+(-2-%i*2)*s^2+(-4+%i*14)*s^3+(2-%i*8)*s^4,-3-%i*6+(-6+%i*3)*s+(3+%i*3)*s^2+(6-%i*21)*s^3+(-3+%i*12)*s^4;4+%i*8+(8-%i*4)*s+(-4-%i*4)*s^2+(-8+%i*28)*s^3+(4-%i*16)*s^4,-5-%i*10+(-10+%i*5)*s+(5+%i*5)*s^2+(10-%i*35)*s^3+(-5+%i*20)*s^4]);
assert_checkequal(P .* P, [4+8*s-4*s^2-8*s^3+4*s^4,9+18*s-9*s^2-18*s^3+9*s^4;16+32*s-16*s^2-32*s^3+16*s^4,25+50*s-25*s^2-50*s^3+25*s^4]);
assert_checkequal(P .* PC, [4+%i*8+(8-%i*4)*s+(-4-%i*4)*s^2+(-8+%i*28)*s^3+(4-%i*16)*s^4,9+%i*18+(18-%i*9)*s+(-9-%i*9)*s^2+(-18+%i*63)*s^3+(9-%i*36)*s^4;16+%i*32+(32-%i*16)*s+(-16-%i*16)*s^2+(-32+%i*112)*s^3+(16-%i*64)*s^4,25+%i*50+(50-%i*25)*s+(-25-%i*25)*s^2+(-50+%i*175)*s^3+(25-%i*100)*s^4]);

assert_checkequal(PC .* empty, []);
assert_checkequal(PC .* r, [4+%i*8+(4-%i*12)*s+(-4+%i*16)*s^2,-6-%i*12+(-6+%i*18)*s+(6-%i*24)*s^2;8+%i*16+(8-%i*24)*s+(-8+%i*32)*s^2,-10-%i*20+(-10+%i*30)*s+(10-%i*40)*s^2]);
assert_checkequal(PC .* c, [-6+%i*8+(14-%i*2)*s+(-18+%i*4)*s^2,9-%i*12+(-21+%i*3)*s+(27-%i*6)*s^2;-12+%i*16+(28-%i*4)*s+(-36+%i*8)*s^2,15-%i*20+(-35+%i*5)*s+(45-%i*10)*s^2]);
assert_checkequal(PC .* R, [2+%i*4+(2-%i*6)*s+(-2+%i*8)*s^2,-6-%i*12+(-6+%i*18)*s+(6-%i*24)*s^2;12+%i*24+(12-%i*36)*s+(-12+%i*48)*s^2,-20-%i*40+(-20+%i*60)*s+(20-%i*80)*s^2]);
assert_checkequal(PC .* C, [-6+%i*8+(14-%i*2)*s+(-18+%i*4)*s^2,18-%i*24+(-42+%i*6)*s+(54-%i*12)*s^2;-36+%i*48+(84-%i*12)*s+(-108+%i*24)*s^2,60-%i*80+(-140+%i*20)*s+(180-%i*40)*s^2]);
assert_checkequal(PC .* p, [2+%i*4+(4-%i*2)*s+(-2-%i*2)*s^2+(-4+%i*14)*s^3+(2-%i*8)*s^4,-3-%i*6+(-6+%i*3)*s+(3+%i*3)*s^2+(6-%i*21)*s^3+(-3+%i*12)*s^4;4+%i*8+(8-%i*4)*s+(-4-%i*4)*s^2+(-8+%i*28)*s^3+(4-%i*16)*s^4,-5-%i*10+(-10+%i*5)*s+(5+%i*5)*s^2+(10-%i*35)*s^3+(-5+%i*20)*s^4]);
assert_checkequal(PC .* pc, [-6+%i*8+(28-%i*4)*s+(-52-%i*4)*s^2+(44+%i*28)*s^3+(-30-%i*16)*s^4,9-%i*12+(-42+%i*6)*s+(78+%i*6)*s^2+(-66-%i*42)*s^3+(45+%i*24)*s^4;-12+%i*16+(56-%i*8)*s+(-104-%i*8)*s^2+(88+%i*56)*s^3+(-60-%i*32)*s^4,15-%i*20+(-70+%i*10)*s+(130+%i*10)*s^2+(-110-%i*70)*s^3+(75+%i*40)*s^4]);
assert_checkequal(PC .* P, [4+%i*8+(8-%i*4)*s+(-4-%i*4)*s^2+(-8+%i*28)*s^3+(4-%i*16)*s^4,9+%i*18+(18-%i*9)*s+(-9-%i*9)*s^2+(-18+%i*63)*s^3+(9-%i*36)*s^4;16+%i*32+(32-%i*16)*s+(-16-%i*16)*s^2+(-32+%i*112)*s^3+(16-%i*64)*s^4,25+%i*50+(50-%i*25)*s+(-25-%i*25)*s^2+(-50+%i*175)*s^3+(25-%i*100)*s^4]);
assert_checkequal(PC .* PC, [-12+%i*16+(56-%i*8)*s+(-104-%i*8)*s^2+(88+%i*56)*s^3+(-60-%i*32)*s^4,-27+%i*36+(126-%i*18)*s+(-234-%i*18)*s^2+(198+%i*126)*s^3+(-135-%i*72)*s^4;-48+%i*64+(224-%i*32)*s+(-416-%i*32)*s^2+(352+%i*224)*s^3+(-240-%i*128)*s^4,-75+%i*100+(350-%i*50)*s+(-650-%i*50)*s^2+(550+%i*350)*s^3+(-375-%i*200)*s^4]);

assert_checkequal(SP .* empty, []);
assert_checkequal(SP .* r, sparse([1,2;3,10;4,5],[2;6;4],[4,10]));
assert_checkequal(SP .* c, sparse([1,2;3,10;4,5],[ 1+%i*2; 3+%i*6; 2+%i*4],[4,10]));
assert_checkequal(SP .* SP, sparse([1,2;3,10;4,5],[1;9;4],[4,10]));
assert_checkequal(SP .* SPC, sparse([1,2;3,10;4,5],[ 1+%i*4; 9+%i*36; 4+%i*16],[4,10]));

assert_checkequal(SPC .* empty, []);
assert_checkequal(SPC .* r, sparse([1,2;3,10;4,5],[ 2+%i*8; 6+%i*24; 4+%i*16],[4,10]));
assert_checkequal(SPC .* c, sparse([1,2;3,10;4,5],[-7+%i*6;-21+%i*18;-14+%i*12],[4,10]));
assert_checkequal(SPC .* SP, sparse([1,2;3,10;4,5],[ 1+%i*4; 9+%i*36; 4+%i*16],[4,10]));
assert_checkequal(SPC .* SPC, sparse([1,2;3,10;4,5],[-15+%i*8;-135+%i*72;-60+%i*32],[4,10]));

assert_checkequal(i8 .* r, int8(-16));
assert_checkequal(i8 .* R, int8([-8,-16;-24,-32]));
assert_checkequal(i8 .* i8, int8(64));
assert_checkequal(i8 .* I8, int8([64,-128;-64,0]));
assert_checkequal(i8 .* ui8, uint8(192));
assert_checkequal(i8 .* UI8, uint8([192,128;64,0]));
assert_checkequal(i8 .* i16, int16(128));
assert_checkequal(i8 .* I16, int16([128,256;384,512]));
assert_checkequal(i8 .* ui16, uint16(65408));
assert_checkequal(i8 .* UI16, uint16([65408,65280;65152,65024]));
assert_checkequal(i8 .* i32, int32(256));
assert_checkequal(i8 .* I32, int32([256,512;768,1024]));
assert_checkequal(i8 .* ui32, uint32(4294967040));
assert_checkequal(i8 .* UI32, uint32([4294967040,4294966784;4294966528,4294966272]));

assert_checkequal(I8 .* r, int8([-16,-32;-48,-64]));
assert_checkequal(I8 .* R, int8([-8,-32;-72,-128]));
assert_checkequal(I8 .* i8, int8([64,-128;-64,0]));
assert_checkequal(I8 .* I8, int8([64,0;64,0]));
assert_checkequal(I8 .* ui8, uint8([192,128;64,0]));
assert_checkequal(I8 .* UI8, uint8([192,0;192,0]));
assert_checkequal(I8 .* i16, int16([128,256;384,512]));
assert_checkequal(I8 .* I16, int16([128,512;1152,2048]));
assert_checkequal(I8 .* ui16, uint16([65408,65280;65152,65024]));
assert_checkequal(I8 .* UI16, uint16([65408,65024;64384,63488]));
assert_checkequal(I8 .* i32, int32([256,512;768,1024]));
assert_checkequal(I8 .* I32, int32([256,1024;2304,4096]));
assert_checkequal(I8 .* ui32, uint32([4294967040,4294966784;4294966528,4294966272]));
assert_checkequal(I8 .* UI32, uint32([4294967040,4294966272;4294964992,4294963200]));

assert_checkequal(ui8 .* r, uint8(16));
assert_checkequal(ui8 .* R, uint8([8,16;24,32]));
assert_checkequal(ui8 .* i8, uint8(192));
assert_checkequal(ui8 .* I8, uint8([192,128;64,0]));
assert_checkequal(ui8 .* ui8, uint8(64));
assert_checkequal(ui8 .* UI8, uint8([64,128;192,0]));
assert_checkequal(ui8 .* i16, uint16(65408));
assert_checkequal(ui8 .* I16, uint16([65408,65280;65152,65024]));
assert_checkequal(ui8 .* ui16, uint16(128));
assert_checkequal(ui8 .* UI16, uint16([128,256;384,512]));
assert_checkequal(ui8 .* i32, uint32(4294967040));
assert_checkequal(ui8 .* I32, uint32([4294967040,4294966784;4294966528,4294966272]));
assert_checkequal(ui8 .* ui32, uint32(256));
assert_checkequal(ui8 .* UI32, uint32([256,512;768,1024]));

assert_checkequal(UI8 .* r, uint8([16,32;48,64]));
assert_checkequal(UI8 .* R, uint8([8,32;72,128]));
assert_checkequal(UI8 .* i8, uint8([192,128;64,0]));
assert_checkequal(UI8 .* I8, uint8([192,0;192,0]));
assert_checkequal(UI8 .* ui8, uint8([64,128;192,0]));
assert_checkequal(UI8 .* UI8, uint8([64,0;64,0]));
assert_checkequal(UI8 .* i16, uint16([65408,65280;65152,65024]));
assert_checkequal(UI8 .* I16, uint16([65408,65024;64384,63488]));
assert_checkequal(UI8 .* ui16, uint16([128,256;384,512]));
assert_checkequal(UI8 .* UI16, uint16([128,512;1152,2048]));
assert_checkequal(UI8 .* i32, uint32([4294967040,4294966784;4294966528,4294966272]));
assert_checkequal(UI8 .* I32, uint32([4294967040,4294966272;4294964992,4294963200]));
assert_checkequal(UI8 .* ui32, uint32([256,512;768,1024]));
assert_checkequal(UI8 .* UI32, uint32([256,1024;2304,4096]));

assert_checkequal(i16 .* r, int16(-32));
assert_checkequal(i16 .* R, int16([-16,-32;-48,-64]));
assert_checkequal(i16 .* i8, int16(128));
assert_checkequal(i16 .* I8, int16([128,256;384,512]));
assert_checkequal(i16 .* ui8, uint16(65408));
assert_checkequal(i16 .* UI8, uint16([65408,65280;65152,65024]));
assert_checkequal(i16 .* i16, int16(256));
assert_checkequal(i16 .* I16, int16([256,512;768,1024]));
assert_checkequal(i16 .* ui16, uint16(65280));
assert_checkequal(i16 .* UI16, uint16([65280,65024;64768,64512]));
assert_checkequal(i16 .* i32, int32(512));
assert_checkequal(i16 .* I32, int32([512,1024;1536,2048]));
assert_checkequal(i16 .* ui32, uint32(4294966784));
assert_checkequal(i16 .* UI32, uint32([4294966784,4294966272;4294965760,4294965248]));

assert_checkequal(I16 .* r, int16([-32,-64;-96,-128]));
assert_checkequal(I16 .* R, int16([-16,-64;-144,-256]));
assert_checkequal(I16 .* i8, int16([128,256;384,512]));
assert_checkequal(I16 .* I8, int16([128,512;1152,2048]));
assert_checkequal(I16 .* ui8, uint16([65408,65280;65152,65024]));
assert_checkequal(I16 .* UI8, uint16([65408,65024;64384,63488]));
assert_checkequal(I16 .* i16, int16([256,512;768,1024]));
assert_checkequal(I16 .* I16, int16([256,1024;2304,4096]));
assert_checkequal(I16 .* ui16, uint16([65280,65024;64768,64512]));
assert_checkequal(I16 .* UI16, uint16([65280,64512;63232,61440]));
assert_checkequal(I16 .* i32, int32([512,1024;1536,2048]));
assert_checkequal(I16 .* I32, int32([512,2048;4608,8192]));
assert_checkequal(I16 .* ui32, uint32([4294966784,4294966272;4294965760,4294965248]));
assert_checkequal(I16 .* UI32, uint32([4294966784,4294965248;4294962688,4294959104]));

assert_checkequal(ui16 .* r, uint16(32));
assert_checkequal(ui16 .* R, uint16([16,32;48,64]));
assert_checkequal(ui16 .* i8, uint16(65408));
assert_checkequal(ui16 .* I8, uint16([65408,65280;65152,65024]));
assert_checkequal(ui16 .* ui8, uint16(128));
assert_checkequal(ui16 .* UI8, uint16([128,256;384,512]));
assert_checkequal(ui16 .* i16, uint16(65280));
assert_checkequal(ui16 .* I16, uint16([65280,65024;64768,64512]));
assert_checkequal(ui16 .* ui16, uint16(256));
assert_checkequal(ui16 .* UI16, uint16([256,512;768,1024]));
assert_checkequal(ui16 .* i32, uint32(4294966784));
assert_checkequal(ui16 .* I32, uint32([4294966784,4294966272;4294965760,4294965248]));
assert_checkequal(ui16 .* ui32, uint32(512));
assert_checkequal(ui16 .* UI32, uint32([512,1024;1536,2048]));

assert_checkequal(UI16 .* r, uint16([32,64;96,128]));
assert_checkequal(UI16 .* R, uint16([16,64;144,256]));
assert_checkequal(UI16 .* i8, uint16([65408,65280;65152,65024]));
assert_checkequal(UI16 .* I8, uint16([65408,65024;64384,63488]));
assert_checkequal(UI16 .* ui8, uint16([128,256;384,512]));
assert_checkequal(UI16 .* UI8, uint16([128,512;1152,2048]));
assert_checkequal(UI16 .* i16, uint16([65280,65024;64768,64512]));
assert_checkequal(UI16 .* I16, uint16([65280,64512;63232,61440]));
assert_checkequal(UI16 .* ui16, uint16([256,512;768,1024]));
assert_checkequal(UI16 .* UI16, uint16([256,1024;2304,4096]));
assert_checkequal(UI16 .* i32, uint32([4294966784,4294966272;4294965760,4294965248]));
assert_checkequal(UI16 .* I32, uint32([4294966784,4294965248;4294962688,4294959104]));
assert_checkequal(UI16 .* ui32, uint32([512,1024;1536,2048]));
assert_checkequal(UI16 .* UI32, uint32([512,2048;4608,8192]));

assert_checkequal(i32 .* r, int32(-64));
assert_checkequal(i32 .* R, int32([-32,-64;-96,-128]));
assert_checkequal(i32 .* i8, int32(256));
assert_checkequal(i32 .* I8, int32([256,512;768,1024]));
assert_checkequal(i32 .* ui8, uint32(4294967040));
assert_checkequal(i32 .* UI8, uint32([4294967040,4294966784;4294966528,4294966272]));
assert_checkequal(i32 .* i16, int32(512));
assert_checkequal(i32 .* I16, int32([512,1024;1536,2048]));
assert_checkequal(i32 .* ui16, uint32(4294966784));
assert_checkequal(i32 .* UI16, uint32([4294966784,4294966272;4294965760,4294965248]));
assert_checkequal(i32 .* i32, int32(1024));
assert_checkequal(i32 .* I32, int32([1024,2048;3072,4096]));
assert_checkequal(i32 .* ui32, uint32(4294966272));
assert_checkequal(i32 .* UI32, uint32([4294966272,4294965248;4294964224,4294963200]));

assert_checkequal(I32 .* r, int32([-64,-128;-192,-256]));
assert_checkequal(I32 .* R, int32([-32,-128;-288,-512]));
assert_checkequal(I32 .* i8, int32([256,512;768,1024]));
assert_checkequal(I32 .* I8, int32([256,1024;2304,4096]));
assert_checkequal(I32 .* ui8, uint32([4294967040,4294966784;4294966528,4294966272]));
assert_checkequal(I32 .* UI8, uint32([4294967040,4294966272;4294964992,4294963200]));
assert_checkequal(I32 .* i16, int32([512,1024;1536,2048]));
assert_checkequal(I32 .* I16, int32([512,2048;4608,8192]));
assert_checkequal(I32 .* ui16, uint32([4294966784,4294966272;4294965760,4294965248]));
assert_checkequal(I32 .* UI16, uint32([4294966784,4294965248;4294962688,4294959104]));
assert_checkequal(I32 .* i32, int32([1024,2048;3072,4096]));
assert_checkequal(I32 .* I32, int32([1024,4096;9216,16384]));
assert_checkequal(I32 .* ui32, uint32([4294966272,4294965248;4294964224,4294963200]));
assert_checkequal(I32 .* UI32, uint32([4294966272,4294963200;4294958080,4294950912]));

assert_checkequal(ui32 .* r, uint32(64));
assert_checkequal(ui32 .* R, uint32([32,64;96,128]));
assert_checkequal(ui32 .* i8, uint32(4294967040));
assert_checkequal(ui32 .* I8, uint32([4294967040,4294966784;4294966528,4294966272]));
assert_checkequal(ui32 .* ui8, uint32(256));
assert_checkequal(ui32 .* UI8, uint32([256,512;768,1024]));
assert_checkequal(ui32 .* i16, uint32(4294966784));
assert_checkequal(ui32 .* I16, uint32([4294966784,4294966272;4294965760,4294965248]));
assert_checkequal(ui32 .* ui16, uint32(512));
assert_checkequal(ui32 .* UI16, uint32([512,1024;1536,2048]));
assert_checkequal(ui32 .* i32, uint32(4294966272));
assert_checkequal(ui32 .* I32, uint32([4294966272,4294965248;4294964224,4294963200]));
assert_checkequal(ui32 .* ui32, uint32(1024));
assert_checkequal(ui32 .* UI32, uint32([1024,2048;3072,4096]));

assert_checkequal(UI32 .* r, uint32([64,128;192,256]));
assert_checkequal(UI32 .* R, uint32([32,128;288,512]));
assert_checkequal(UI32 .* i8, uint32([4294967040,4294966784;4294966528,4294966272]));
assert_checkequal(UI32 .* I8, uint32([4294967040,4294966272;4294964992,4294963200]));
assert_checkequal(UI32 .* ui8, uint32([256,512;768,1024]));
assert_checkequal(UI32 .* UI8, uint32([256,1024;2304,4096]));
assert_checkequal(UI32 .* i16, uint32([4294966784,4294966272;4294965760,4294965248]));
assert_checkequal(UI32 .* I16, uint32([4294966784,4294965248;4294962688,4294959104]));
assert_checkequal(UI32 .* ui16, uint32([512,1024;1536,2048]));
assert_checkequal(UI32 .* UI16, uint32([512,2048;4608,8192]));
assert_checkequal(UI32 .* i32, uint32([4294966272,4294965248;4294964224,4294963200]));
assert_checkequal(UI32 .* I32, uint32([4294966272,4294963200;4294958080,4294950912]));
assert_checkequal(UI32 .* ui32, uint32([1024,2048;3072,4096]));
assert_checkequal(UI32 .* UI32, uint32([1024,4096;9216,16384]));
