/*
 * Copyright (C) 2017 ~ 2018 Deepin Technology Co., Ltd.
 *
 * Author:     kirigaya <kirigaya@mkacg.com>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef VIDEOWIDGET_H
#define VIDEOWIDGET_H

#include "moduleinterface.h"
//#include "../dvideowidget.h"
#include "../widgets/coverphoto.h"

#include <QBitmap>
#include <QGraphicsOpacityEffect>
#include <QHBoxLayout>
#include <QIcon>
#include <QLocale>
#include <QPainter>
#include <QPushButton>
#include <QResizeEvent>
#include <QTimer>

#include <DClipEffectWidget>
#include <DLabel>
#include <DWidget>
#include <QPropertyAnimation>
#include <player_widget.h>
#include <player_engine.h>
#include <DSysInfo>
#include <QPainterPath>

#include <player_engine.h>
#include <compositing_manager.h>
#include <dimagebutton.h>

DWIDGET_USE_NAMESPACE
DCORE_USE_NAMESPACE

class QGraphicsOpacityEffect;

//播放视频类
class VideoWidget : public ModuleInterface
{
    Q_OBJECT
public:
    explicit VideoWidget(QUrl file, QWidget *parent = nullptr);
    void startPlay();
    void pause();
    void setFile(QUrl file);
    void setMute(bool b);

    //更新第一次启动背景图
    void updateBigIcon() Q_DECL_OVERRIDE;
    //更新日常的背景图
    void updateSmallIcon() Q_DECL_OVERRIDE;
    void updateSelectBtnPos() Q_DECL_OVERRIDE;
    void keyPressEvent(QKeyEvent *) Q_DECL_OVERRIDE;

protected:
    void showEvent(QShowEvent *event) override;

signals:
    void showMore();
    void finishedShow();

private slots:
    void slotShowMore();

private:
    //视频
    dmr::PlayerWidget *m_video;
};

#endif
