#ifndef _XFIREWORKS_Disp_h_INCLUDED_
#define _XFIREWORKS_Disp_h_INCLUDED_

typedef struct _Disp * Disp; /* Disp 饹 */

#include <X11/Xlib.h>

Display * Disp_GetDisplay(Disp disp);
Window Disp_GetWindow(Disp disp);
Colormap Disp_GetColormap(Disp disp);
int Disp_GetWidth( Disp disp);
int Disp_GetHeight(Disp disp);

/*===========================================================================*/
/* μ                                                                  */
/*===========================================================================*/

unsigned long Disp_GetPixel(Disp disp, char * color_name);

/*===========================================================================*/
/* GC κȲ                                                           */
/*===========================================================================*/

GC Disp_CreateGC(Disp disp);
int Disp_DestroyGC(Disp disp, GC gc);

/*===========================================================================*/
/* ֥ȤȺ                                                  */
/*===========================================================================*/

/*---------------------------------------------------------------------------*/
/* ֥Ȥ                                                        */
/*---------------------------------------------------------------------------*/

Disp Disp_Create(char * display_name, int direct_draw);

/*---------------------------------------------------------------------------*/
/* ֥Ȥκ                                                        */
/*---------------------------------------------------------------------------*/

Disp Disp_Destroy(Disp disp);

/*---------------------------------------------------------------------------*/
/* եå                                                                */
/*---------------------------------------------------------------------------*/

int Disp_Flush(Disp disp);

/*---------------------------------------------------------------------------*/
/* X ФȤ Sync(٥ȥ塼Ѵ)                             */
/*---------------------------------------------------------------------------*/

int Disp_Sync(Disp disp);

/*---------------------------------------------------------------------------*/
/* ԥåޥåפΥꥢ                                                    */
/*---------------------------------------------------------------------------*/

int Disp_ClearPixmap(Disp disp, GC gc);

/*---------------------------------------------------------------------------*/
/* ǥץ쥤Υꥢ                                                      */
/*---------------------------------------------------------------------------*/

int Disp_ClearDisplay(Disp disp, unsigned long pixel);

/*---------------------------------------------------------------------------*/
/* ߤ                                                                  */
/*---------------------------------------------------------------------------*/

int Disp_DrawFilledCircle(Disp disp, GC gc, int x, int y, int r);
int Disp_DrawFilledCircles(Disp disp, GC gc, XArc * arcs, int n);

/*****************************************************************************/
/* ޤ                                                                  */
/*****************************************************************************/

#endif /* _XFIREWORKS_Disp_h_INCLUDED_ */

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
