
#------------------------------------------------------------------------
function(setupCoreAudioSupport)
    if(SMTG_MAC AND XCODE)
        set(SMTG_IOS_DEVELOPMENT_TEAM "" CACHE STRING "Needed for building the InterAppAudio and AUv3 examples for iOS")
        if("${SMTG_COREAUDIO_SDK_PATH}" STREQUAL "")
            # Check if the CoreAudio SDK is next to the vst3sdk folder:
            set(COREAUDIO_SDK_PATH ${CMAKE_CURRENT_FUNCTION_LIST_DIR}/../../../CoreAudio)
            if(NOT EXISTS "${COREAUDIO_SDK_PATH}/AudioUnits/AUPublic/AUBase/AUBase.cpp")
                # Check if the CoreAudio SDK is in the vst3sdk folder:
                set(COREAUDIO_SDK_PATH ${CMAKE_CURRENT_FUNCTION_LIST_DIR}/../../external.apple.coreaudio)
                if(NOT EXISTS "${COREAUDIO_SDK_PATH}/AudioUnits/AUPublic/AUBase/AUBase.cpp")
                    set(COREAUDIO_SDK_PATH "")
                endif()
            endif()
            if(NOT "${COREAUDIO_SDK_PATH}" STREQUAL "")
                get_filename_component(COREAUDIO_SDK_PATH "${COREAUDIO_SDK_PATH}" ABSOLUTE)
            endif()
            set(SMTG_COREAUDIO_SDK_PATH "${COREAUDIO_SDK_PATH}" CACHE PATH "Here you can define where to find the COREAUDIO SDK" FORCE)
        else()
            set(COREAUDIO_SDK_PATH "${SMTG_COREAUDIO_SDK_PATH}")
            if(NOT IS_ABSOLUTE ${COREAUDIO_SDK_PATH})
                get_filename_component(COREAUDIO_SDK_PATH "${CMAKE_CURRENT_FUNCTION_LIST_DIR}/../../${COREAUDIO_SDK_PATH}" ABSOLUTE)
            endif()
            if(NOT EXISTS "${COREAUDIO_SDK_PATH}/AudioUnits/AUPublic/AUBase/AUBase.cpp")
                message(FATAL_ERROR "[SMTG] SMTG_COREAUDIO_SDK_PATH is set but does not point to an expected location!")
            else()
                set(SMTG_COREAUDIO_SDK_PATH "${COREAUDIO_SDK_PATH}" CACHE PATH "Here you can define where to find the COREAUDIO SDK" FORCE)
            endif()
        endif()
        if(EXISTS "${SMTG_COREAUDIO_SDK_PATH}")
            message(STATUS "[SMTG] SMTG_COREAUDIO_SDK_PATH is set to: " ${SMTG_COREAUDIO_SDK_PATH})
        else()
            message(STATUS "[SMTG] SMTG_COREAUDIO_SDK_PATH is not set. If you need it, please download the COREAUDIO SDK!")
        endif()
    endif()
endfunction(setupCoreAudioSupport)
