// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UADDL_4S_TRACE_AARCH64_H_
#define VIXL_SIM_UADDL_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_uaddl_4S[] = {
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000000fd, 0x000033b2, 0x00008888, 0x0000d552,
  0x000033b1, 0x000055d4, 0x0000b330, 0x0000d553,
  0x000055d3, 0x0000807c, 0x0000b331, 0x0000d554,
  0x0000807b, 0x0000807d, 0x0000b332, 0x00005555,
  0x0000807c, 0x0000807e, 0x00003333, 0x00005556,
  0x0000807d, 0x0000007f, 0x00003334, 0x00005557,
  0x0000007e, 0x00000080, 0x00003335, 0x00005565,
  0x0000007f, 0x00000081, 0x00003343, 0x000055d2,
  0x00000080, 0x0000008f, 0x000033b0, 0x000055d3,
  0x0000008e, 0x000000fc, 0x000033b1, 0x000055d4,
  0x000000fb, 0x000000fd, 0x000033b2, 0x00008888,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000000fd, 0x000033b2, 0x00008888, 0x0000d552,
  0x000033b1, 0x000055d4, 0x0000b330, 0x0000d553,
  0x000055d3, 0x0000807c, 0x0000b331, 0x0000d554,
  0x0000807b, 0x0000807d, 0x0000b332, 0x0000d555,
  0x0000807c, 0x0000807e, 0x0000b333, 0x0000d556,
  0x0000807d, 0x0000807f, 0x0000b334, 0x0000ffff,
  0x0000807e, 0x00008080, 0x0000dddd, 0x00012221,
  0x0000807f, 0x0000ab29, 0x0000ffff, 0x000154d5,
  0x0000ab28, 0x0000cd4b, 0x000132b3, 0x000154d6,
  0x0000cd4a, 0x0000ffff, 0x000132b4, 0x000154d7,
  0x0000fffe, 0x00010000, 0x000132b5, 0x000154d8,
  0x00010000, 0x000132b5, 0x000154d8, 0x00017fed,
  0x00010001, 0x000132b6, 0x00015545, 0x00017ffa,
  0x00010002, 0x00013323, 0x00015552, 0x00017ffb,
  0x0001006f, 0x00013330, 0x00015553, 0x00017ffc,
  0x0001007c, 0x00013331, 0x00015554, 0x00007ffd,
  0x0001007d, 0x00013332, 0x00005555, 0x00007ffe,
  0x0001007e, 0x00003333, 0x00005556, 0x00007fff,
  0x0000007f, 0x00003334, 0x00005557, 0x0000800d,
  0x00000080, 0x00003335, 0x00005565, 0x0000807a,
  0x00000081, 0x00003343, 0x000055d2, 0x0000807b,
  0x0000008f, 0x000033b0, 0x000055d3, 0x0000807c,
  0x000000fc, 0x000033b1, 0x000055d4, 0x0000b330,
  0x000000fd, 0x000033b2, 0x00008888, 0x0000d552,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000033b2, 0x00008888, 0x0000d552, 0x0000fffb,
  0x000055d4, 0x0000b330, 0x0000d553, 0x0000fffc,
  0x0000807c, 0x0000b331, 0x0000d554, 0x0000fffd,
  0x0000807d, 0x0000b332, 0x0000d555, 0x0000fffe,
  0x0000807e, 0x0000b333, 0x0000d556, 0x00012aa7,
  0x0000807f, 0x0000b334, 0x0000ffff, 0x00014cc9,
  0x00008080, 0x0000dddd, 0x00012221, 0x00017f7d,
  0x0000ab29, 0x0000ffff, 0x000154d5, 0x00017f7e,
  0x0000cd4b, 0x000132b3, 0x000154d6, 0x00017f7f,
  0x0000ffff, 0x000132b4, 0x000154d7, 0x00017f80,
  0x000132b4, 0x000154d7, 0x00017f80, 0x00017fee,
  0x000132b5, 0x000154d8, 0x00017fed, 0x00017ffb,
  0x000132b6, 0x00015545, 0x00017ffa, 0x00017ffc,
  0x00013323, 0x00015552, 0x00017ffb, 0x00017ffd,
  0x00013330, 0x00015553, 0x00017ffc, 0x00007ffe,
  0x00013331, 0x00015554, 0x00007ffd, 0x00007fff,
  0x00013332, 0x00005555, 0x00007ffe, 0x00008000,
  0x00003333, 0x00005556, 0x00007fff, 0x0000800e,
  0x00003334, 0x00005557, 0x0000800d, 0x0000807b,
  0x00003335, 0x00005565, 0x0000807a, 0x0000807c,
  0x00003343, 0x000055d2, 0x0000807b, 0x0000807d,
  0x000033b0, 0x000055d3, 0x0000807c, 0x0000b331,
  0x000033b1, 0x000055d4, 0x0000b330, 0x0000d553,
  0x000033b2, 0x00008888, 0x0000d552, 0x0000fffb,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x00008888, 0x0000d552, 0x0000fffb, 0x0000fffd,
  0x0000b330, 0x0000d553, 0x0000fffc, 0x0000fffe,
  0x0000b331, 0x0000d554, 0x0000fffd, 0x0000ffff,
  0x0000b332, 0x0000d555, 0x0000fffe, 0x00012aa8,
  0x0000b333, 0x0000d556, 0x00012aa7, 0x00014cca,
  0x0000b334, 0x0000ffff, 0x00014cc9, 0x00017f7e,
  0x0000dddd, 0x00012221, 0x00017f7d, 0x00017f7f,
  0x0000ffff, 0x000154d5, 0x00017f7e, 0x00017f80,
  0x000132b3, 0x000154d6, 0x00017f7f, 0x00017f81,
  0x000154d6, 0x00017f7f, 0x00017f81, 0x00017fef,
  0x000154d7, 0x00017f80, 0x00017fee, 0x00017ffc,
  0x000154d8, 0x00017fed, 0x00017ffb, 0x00017ffd,
  0x00015545, 0x00017ffa, 0x00017ffc, 0x00017ffe,
  0x00015552, 0x00017ffb, 0x00017ffd, 0x00007fff,
  0x00015553, 0x00017ffc, 0x00007ffe, 0x00008000,
  0x00015554, 0x00007ffd, 0x00007fff, 0x00008001,
  0x00005555, 0x00007ffe, 0x00008000, 0x0000800f,
  0x00005556, 0x00007fff, 0x0000800e, 0x0000807c,
  0x00005557, 0x0000800d, 0x0000807b, 0x0000807d,
  0x00005565, 0x0000807a, 0x0000807c, 0x0000807e,
  0x000055d2, 0x0000807b, 0x0000807d, 0x0000b332,
  0x000055d3, 0x0000807c, 0x0000b331, 0x0000d554,
  0x000055d4, 0x0000b330, 0x0000d553, 0x0000fffc,
  0x00008888, 0x0000d552, 0x0000fffb, 0x0000fffd,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x0000d552, 0x0000fffb, 0x0000fffd, 0x0000ffff,
  0x0000d553, 0x0000fffc, 0x0000fffe, 0x00010000,
  0x0000d554, 0x0000fffd, 0x0000ffff, 0x00012aa9,
  0x0000d555, 0x0000fffe, 0x00012aa8, 0x00014ccb,
  0x0000d556, 0x00012aa7, 0x00014cca, 0x00017f7f,
  0x0000ffff, 0x00014cc9, 0x00017f7e, 0x00017f80,
  0x00012221, 0x00017f7d, 0x00017f7f, 0x00017f81,
  0x000154d5, 0x00017f7e, 0x00017f80, 0x00017f82,
  0x00017f7e, 0x00017f80, 0x00017f82, 0x0000fff0,
  0x00017f7f, 0x00017f81, 0x00017fef, 0x0000fffd,
  0x00017f80, 0x00017fee, 0x00017ffc, 0x0000fffe,
  0x00017fed, 0x00017ffb, 0x00017ffd, 0x0000ffff,
  0x00017ffa, 0x00017ffc, 0x00017ffe, 0x00000000,
  0x00017ffb, 0x00017ffd, 0x00007fff, 0x00000001,
  0x00017ffc, 0x00007ffe, 0x00008000, 0x00000002,
  0x00007ffd, 0x00007fff, 0x00008001, 0x00000010,
  0x00007ffe, 0x00008000, 0x0000800f, 0x0000007d,
  0x00007fff, 0x0000800e, 0x0000807c, 0x0000007e,
  0x0000800d, 0x0000807b, 0x0000807d, 0x0000007f,
  0x0000807a, 0x0000807c, 0x0000807e, 0x00003333,
  0x0000807b, 0x0000807d, 0x0000b332, 0x00005555,
  0x0000807c, 0x0000b331, 0x0000d554, 0x00007ffd,
  0x0000b330, 0x0000d553, 0x0000fffc, 0x00007ffe,
  0x0000d552, 0x0000fffb, 0x0000fffd, 0x00007fff,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0x00008000,
  0x0000fffb, 0x0000fffd, 0x0000ffff, 0x00008001,
  0x0000fffc, 0x0000fffe, 0x00010000, 0x0000aaaa,
  0x0000fffd, 0x0000ffff, 0x00012aa9, 0x0000cccc,
  0x0000fffe, 0x00012aa8, 0x00014ccb, 0x0000ff80,
  0x00012aa7, 0x00014cca, 0x00017f7f, 0x0000ff81,
  0x00014cc9, 0x00017f7e, 0x00017f80, 0x0000ff82,
  0x00017f7d, 0x00017f7f, 0x00017f81, 0x0000ff83,
  0x00017f7f, 0x00017f81, 0x0000ff83, 0x0000fff1,
  0x00017f80, 0x00017f82, 0x0000fff0, 0x0000fffe,
  0x00017f81, 0x00017fef, 0x0000fffd, 0x0000ffff,
  0x00017fee, 0x00017ffc, 0x0000fffe, 0x00010000,
  0x00017ffb, 0x00017ffd, 0x0000ffff, 0x00000001,
  0x00017ffc, 0x00017ffe, 0x00000000, 0x00000002,
  0x00017ffd, 0x00007fff, 0x00000001, 0x00000003,
  0x00007ffe, 0x00008000, 0x00000002, 0x00000011,
  0x00007fff, 0x00008001, 0x00000010, 0x0000007e,
  0x00008000, 0x0000800f, 0x0000007d, 0x0000007f,
  0x0000800e, 0x0000807c, 0x0000007e, 0x00000080,
  0x0000807b, 0x0000807d, 0x0000007f, 0x00003334,
  0x0000807c, 0x0000807e, 0x00003333, 0x00005556,
  0x0000807d, 0x0000b332, 0x00005555, 0x00007ffe,
  0x0000b331, 0x0000d554, 0x00007ffd, 0x00007fff,
  0x0000d553, 0x0000fffc, 0x00007ffe, 0x00008000,
  0x0000fffb, 0x0000fffd, 0x00007fff, 0x00008001,
  0x0000fffc, 0x0000fffe, 0x00008000, 0x00008002,
  0x0000fffd, 0x0000ffff, 0x00008001, 0x0000aaab,
  0x0000fffe, 0x00010000, 0x0000aaaa, 0x0000cccd,
  0x0000ffff, 0x00012aa9, 0x0000cccc, 0x0000ff81,
  0x00012aa8, 0x00014ccb, 0x0000ff80, 0x0000ff82,
  0x00014cca, 0x00017f7f, 0x0000ff81, 0x0000ff83,
  0x00017f7e, 0x00017f80, 0x0000ff82, 0x0000ff84,
  0x00017f80, 0x0000ff82, 0x0000ff84, 0x0000fff2,
  0x00017f81, 0x0000ff83, 0x0000fff1, 0x0000ffff,
  0x00017f82, 0x0000fff0, 0x0000fffe, 0x00010000,
  0x00017fef, 0x0000fffd, 0x0000ffff, 0x00010001,
  0x00017ffc, 0x0000fffe, 0x00010000, 0x00000002,
  0x00017ffd, 0x0000ffff, 0x00000001, 0x00000003,
  0x00017ffe, 0x00000000, 0x00000002, 0x00000004,
  0x00007fff, 0x00000001, 0x00000003, 0x00000012,
  0x00008000, 0x00000002, 0x00000011, 0x0000007f,
  0x00008001, 0x00000010, 0x0000007e, 0x00000080,
  0x0000800f, 0x0000007d, 0x0000007f, 0x00000081,
  0x0000807c, 0x0000007e, 0x00000080, 0x00003335,
  0x0000807d, 0x0000007f, 0x00003334, 0x00005557,
  0x0000807e, 0x00003333, 0x00005556, 0x00007fff,
  0x0000b332, 0x00005555, 0x00007ffe, 0x00008000,
  0x0000d554, 0x00007ffd, 0x00007fff, 0x00008001,
  0x0000fffc, 0x00007ffe, 0x00008000, 0x00008002,
  0x0000fffd, 0x00007fff, 0x00008001, 0x00008003,
  0x0000fffe, 0x00008000, 0x00008002, 0x0000aaac,
  0x0000ffff, 0x00008001, 0x0000aaab, 0x0000ccce,
  0x00010000, 0x0000aaaa, 0x0000cccd, 0x0000ff82,
  0x00012aa9, 0x0000cccc, 0x0000ff81, 0x0000ff83,
  0x00014ccb, 0x0000ff80, 0x0000ff82, 0x0000ff84,
  0x00017f7f, 0x0000ff81, 0x0000ff83, 0x0000ff85,
  0x0000ff81, 0x0000ff83, 0x0000ff85, 0x00010000,
  0x0000ff82, 0x0000ff84, 0x0000fff2, 0x0001000d,
  0x0000ff83, 0x0000fff1, 0x0000ffff, 0x0001000e,
  0x0000fff0, 0x0000fffe, 0x00010000, 0x0001000f,
  0x0000fffd, 0x0000ffff, 0x00010001, 0x00000010,
  0x0000fffe, 0x00010000, 0x00000002, 0x00000011,
  0x0000ffff, 0x00000001, 0x00000003, 0x00000012,
  0x00000000, 0x00000002, 0x00000004, 0x00000020,
  0x00000001, 0x00000003, 0x00000012, 0x0000008d,
  0x00000002, 0x00000011, 0x0000007f, 0x0000008e,
  0x00000010, 0x0000007e, 0x00000080, 0x0000008f,
  0x0000007d, 0x0000007f, 0x00000081, 0x00003343,
  0x0000007e, 0x00000080, 0x00003335, 0x00005565,
  0x0000007f, 0x00003334, 0x00005557, 0x0000800d,
  0x00003333, 0x00005556, 0x00007fff, 0x0000800e,
  0x00005555, 0x00007ffe, 0x00008000, 0x0000800f,
  0x00007ffd, 0x00007fff, 0x00008001, 0x00008010,
  0x00007ffe, 0x00008000, 0x00008002, 0x00008011,
  0x00007fff, 0x00008001, 0x00008003, 0x0000aaba,
  0x00008000, 0x00008002, 0x0000aaac, 0x0000ccdc,
  0x00008001, 0x0000aaab, 0x0000ccce, 0x0000ff90,
  0x0000aaaa, 0x0000cccd, 0x0000ff82, 0x0000ff91,
  0x0000cccc, 0x0000ff81, 0x0000ff83, 0x0000ff92,
  0x0000ff80, 0x0000ff82, 0x0000ff84, 0x0000ff93,
  0x0000ff82, 0x0000ff84, 0x0000ff93, 0x0001006d,
  0x0000ff83, 0x0000ff85, 0x00010000, 0x0001007a,
  0x0000ff84, 0x0000fff2, 0x0001000d, 0x0001007b,
  0x0000fff1, 0x0000ffff, 0x0001000e, 0x0001007c,
  0x0000fffe, 0x00010000, 0x0001000f, 0x0000007d,
  0x0000ffff, 0x00010001, 0x00000010, 0x0000007e,
  0x00010000, 0x00000002, 0x00000011, 0x0000007f,
  0x00000001, 0x00000003, 0x00000012, 0x0000008d,
  0x00000002, 0x00000004, 0x00000020, 0x000000fa,
  0x00000003, 0x00000012, 0x0000008d, 0x000000fb,
  0x00000011, 0x0000007f, 0x0000008e, 0x000000fc,
  0x0000007e, 0x00000080, 0x0000008f, 0x000033b0,
  0x0000007f, 0x00000081, 0x00003343, 0x000055d2,
  0x00000080, 0x00003335, 0x00005565, 0x0000807a,
  0x00003334, 0x00005557, 0x0000800d, 0x0000807b,
  0x00005556, 0x00007fff, 0x0000800e, 0x0000807c,
  0x00007ffe, 0x00008000, 0x0000800f, 0x0000807d,
  0x00007fff, 0x00008001, 0x00008010, 0x0000807e,
  0x00008000, 0x00008002, 0x00008011, 0x0000ab27,
  0x00008001, 0x00008003, 0x0000aaba, 0x0000cd49,
  0x00008002, 0x0000aaac, 0x0000ccdc, 0x0000fffd,
  0x0000aaab, 0x0000ccce, 0x0000ff90, 0x0000fffe,
  0x0000cccd, 0x0000ff82, 0x0000ff91, 0x0000ffff,
  0x0000ff81, 0x0000ff83, 0x0000ff92, 0x00010000,
  0x0000ff83, 0x0000ff92, 0x00010000, 0x0001006e,
  0x0000ff84, 0x0000ff93, 0x0001006d, 0x0001007b,
  0x0000ff85, 0x00010000, 0x0001007a, 0x0001007c,
  0x0000fff2, 0x0001000d, 0x0001007b, 0x0001007d,
  0x0000ffff, 0x0001000e, 0x0001007c, 0x0000007e,
  0x00010000, 0x0001000f, 0x0000007d, 0x0000007f,
  0x00010001, 0x00000010, 0x0000007e, 0x00000080,
  0x00000002, 0x00000011, 0x0000007f, 0x0000008e,
  0x00000003, 0x00000012, 0x0000008d, 0x000000fb,
  0x00000004, 0x00000020, 0x000000fa, 0x000000fc,
  0x00000012, 0x0000008d, 0x000000fb, 0x000000fd,
  0x0000007f, 0x0000008e, 0x000000fc, 0x000033b1,
  0x00000080, 0x0000008f, 0x000033b0, 0x000055d3,
  0x00000081, 0x00003343, 0x000055d2, 0x0000807b,
  0x00003335, 0x00005565, 0x0000807a, 0x0000807c,
  0x00005557, 0x0000800d, 0x0000807b, 0x0000807d,
  0x00007fff, 0x0000800e, 0x0000807c, 0x0000807e,
  0x00008000, 0x0000800f, 0x0000807d, 0x0000807f,
  0x00008001, 0x00008010, 0x0000807e, 0x0000ab28,
  0x00008002, 0x00008011, 0x0000ab27, 0x0000cd4a,
  0x00008003, 0x0000aaba, 0x0000cd49, 0x0000fffe,
  0x0000aaac, 0x0000ccdc, 0x0000fffd, 0x0000ffff,
  0x0000ccce, 0x0000ff90, 0x0000fffe, 0x00010000,
  0x0000ff82, 0x0000ff91, 0x0000ffff, 0x00010001,
  0x0000ff91, 0x0000ffff, 0x00010001, 0x0001006f,
  0x0000ff92, 0x00010000, 0x0001006e, 0x0001007c,
  0x0000ff93, 0x0001006d, 0x0001007b, 0x0001007d,
  0x00010000, 0x0001007a, 0x0001007c, 0x0001007e,
  0x0001000d, 0x0001007b, 0x0001007d, 0x0000007f,
  0x0001000e, 0x0001007c, 0x0000007e, 0x00000080,
  0x0001000f, 0x0000007d, 0x0000007f, 0x00000081,
  0x00000010, 0x0000007e, 0x00000080, 0x0000008f,
  0x00000011, 0x0000007f, 0x0000008e, 0x000000fc,
  0x00000012, 0x0000008d, 0x000000fb, 0x000000fd,
  0x00000020, 0x000000fa, 0x000000fc, 0x000000fe,
  0x0000008d, 0x000000fb, 0x000000fd, 0x000033b2,
  0x0000008e, 0x000000fc, 0x000033b1, 0x000055d4,
  0x0000008f, 0x000033b0, 0x000055d3, 0x0000807c,
  0x00003343, 0x000055d2, 0x0000807b, 0x0000807d,
  0x00005565, 0x0000807a, 0x0000807c, 0x0000807e,
  0x0000800d, 0x0000807b, 0x0000807d, 0x0000807f,
  0x0000800e, 0x0000807c, 0x0000807e, 0x00008080,
  0x0000800f, 0x0000807d, 0x0000807f, 0x0000ab29,
  0x00008010, 0x0000807e, 0x0000ab28, 0x0000cd4b,
  0x00008011, 0x0000ab27, 0x0000cd4a, 0x0000ffff,
  0x0000aaba, 0x0000cd49, 0x0000fffe, 0x00010000,
  0x0000ccdc, 0x0000fffd, 0x0000ffff, 0x00010001,
  0x0000ff90, 0x0000fffe, 0x00010000, 0x00010002,
  0x0000fffe, 0x00010000, 0x00010002, 0x00013323,
  0x0000ffff, 0x00010001, 0x0001006f, 0x00013330,
  0x00010000, 0x0001006e, 0x0001007c, 0x00013331,
  0x0001006d, 0x0001007b, 0x0001007d, 0x00013332,
  0x0001007a, 0x0001007c, 0x0001007e, 0x00003333,
  0x0001007b, 0x0001007d, 0x0000007f, 0x00003334,
  0x0001007c, 0x0000007e, 0x00000080, 0x00003335,
  0x0000007d, 0x0000007f, 0x00000081, 0x00003343,
  0x0000007e, 0x00000080, 0x0000008f, 0x000033b0,
  0x0000007f, 0x0000008e, 0x000000fc, 0x000033b1,
  0x0000008d, 0x000000fb, 0x000000fd, 0x000033b2,
  0x000000fa, 0x000000fc, 0x000000fe, 0x00006666,
  0x000000fb, 0x000000fd, 0x000033b2, 0x00008888,
  0x000000fc, 0x000033b1, 0x000055d4, 0x0000b330,
  0x000033b0, 0x000055d3, 0x0000807c, 0x0000b331,
  0x000055d2, 0x0000807b, 0x0000807d, 0x0000b332,
  0x0000807a, 0x0000807c, 0x0000807e, 0x0000b333,
  0x0000807b, 0x0000807d, 0x0000807f, 0x0000b334,
  0x0000807c, 0x0000807e, 0x00008080, 0x0000dddd,
  0x0000807d, 0x0000807f, 0x0000ab29, 0x0000ffff,
  0x0000807e, 0x0000ab28, 0x0000cd4b, 0x000132b3,
  0x0000ab27, 0x0000cd4a, 0x0000ffff, 0x000132b4,
  0x0000cd49, 0x0000fffe, 0x00010000, 0x000132b5,
  0x0000fffd, 0x0000ffff, 0x00010001, 0x000132b6,
  0x0000ffff, 0x00010001, 0x000132b6, 0x00015545,
  0x00010000, 0x00010002, 0x00013323, 0x00015552,
  0x00010001, 0x0001006f, 0x00013330, 0x00015553,
  0x0001006e, 0x0001007c, 0x00013331, 0x00015554,
  0x0001007b, 0x0001007d, 0x00013332, 0x00005555,
  0x0001007c, 0x0001007e, 0x00003333, 0x00005556,
  0x0001007d, 0x0000007f, 0x00003334, 0x00005557,
  0x0000007e, 0x00000080, 0x00003335, 0x00005565,
  0x0000007f, 0x00000081, 0x00003343, 0x000055d2,
  0x00000080, 0x0000008f, 0x000033b0, 0x000055d3,
  0x0000008e, 0x000000fc, 0x000033b1, 0x000055d4,
  0x000000fb, 0x000000fd, 0x000033b2, 0x00008888,
  0x000000fc, 0x000000fe, 0x00006666, 0x0000aaaa,
  0x000000fd, 0x000033b2, 0x00008888, 0x0000d552,
  0x000033b1, 0x000055d4, 0x0000b330, 0x0000d553,
  0x000055d3, 0x0000807c, 0x0000b331, 0x0000d554,
  0x0000807b, 0x0000807d, 0x0000b332, 0x0000d555,
  0x0000807c, 0x0000807e, 0x0000b333, 0x0000d556,
  0x0000807d, 0x0000807f, 0x0000b334, 0x0000ffff,
  0x0000807e, 0x00008080, 0x0000dddd, 0x00012221,
  0x0000807f, 0x0000ab29, 0x0000ffff, 0x000154d5,
  0x0000ab28, 0x0000cd4b, 0x000132b3, 0x000154d6,
  0x0000cd4a, 0x0000ffff, 0x000132b4, 0x000154d7,
  0x0000fffe, 0x00010000, 0x000132b5, 0x000154d8,
  0x00010000, 0x000132b5, 0x000154d8, 0x00017fed,
  0x00010001, 0x000132b6, 0x00015545, 0x00017ffa,
  0x00010002, 0x00013323, 0x00015552, 0x00017ffb,
  0x0001006f, 0x00013330, 0x00015553, 0x00017ffc,
  0x0001007c, 0x00013331, 0x00015554, 0x00007ffd,
  0x0001007d, 0x00013332, 0x00005555, 0x00007ffe,
  0x0001007e, 0x00003333, 0x00005556, 0x00007fff,
  0x0000007f, 0x00003334, 0x00005557, 0x0000800d,
  0x00000080, 0x00003335, 0x00005565, 0x0000807a,
  0x00000081, 0x00003343, 0x000055d2, 0x0000807b,
  0x0000008f, 0x000033b0, 0x000055d3, 0x0000807c,
  0x000000fc, 0x000033b1, 0x000055d4, 0x0000b330,
  0x000000fd, 0x000033b2, 0x00008888, 0x0000d552,
  0x000000fe, 0x00006666, 0x0000aaaa, 0x0000fffa,
  0x000033b2, 0x00008888, 0x0000d552, 0x0000fffb,
  0x000055d4, 0x0000b330, 0x0000d553, 0x0000fffc,
  0x0000807c, 0x0000b331, 0x0000d554, 0x0000fffd,
  0x0000807d, 0x0000b332, 0x0000d555, 0x0000fffe,
  0x0000807e, 0x0000b333, 0x0000d556, 0x00012aa7,
  0x0000807f, 0x0000b334, 0x0000ffff, 0x00014cc9,
  0x00008080, 0x0000dddd, 0x00012221, 0x00017f7d,
  0x0000ab29, 0x0000ffff, 0x000154d5, 0x00017f7e,
  0x0000cd4b, 0x000132b3, 0x000154d6, 0x00017f7f,
  0x0000ffff, 0x000132b4, 0x000154d7, 0x00017f80,
  0x000132b4, 0x000154d7, 0x00017f80, 0x00017fee,
  0x000132b5, 0x000154d8, 0x00017fed, 0x00017ffb,
  0x000132b6, 0x00015545, 0x00017ffa, 0x00017ffc,
  0x00013323, 0x00015552, 0x00017ffb, 0x00017ffd,
  0x00013330, 0x00015553, 0x00017ffc, 0x00007ffe,
  0x00013331, 0x00015554, 0x00007ffd, 0x00007fff,
  0x00013332, 0x00005555, 0x00007ffe, 0x00008000,
  0x00003333, 0x00005556, 0x00007fff, 0x0000800e,
  0x00003334, 0x00005557, 0x0000800d, 0x0000807b,
  0x00003335, 0x00005565, 0x0000807a, 0x0000807c,
  0x00003343, 0x000055d2, 0x0000807b, 0x0000807d,
  0x000033b0, 0x000055d3, 0x0000807c, 0x0000b331,
  0x000033b1, 0x000055d4, 0x0000b330, 0x0000d553,
  0x000033b2, 0x00008888, 0x0000d552, 0x0000fffb,
  0x00006666, 0x0000aaaa, 0x0000fffa, 0x0000fffc,
  0x00008888, 0x0000d552, 0x0000fffb, 0x0000fffd,
  0x0000b330, 0x0000d553, 0x0000fffc, 0x0000fffe,
  0x0000b331, 0x0000d554, 0x0000fffd, 0x0000ffff,
  0x0000b332, 0x0000d555, 0x0000fffe, 0x00012aa8,
  0x0000b333, 0x0000d556, 0x00012aa7, 0x00014cca,
  0x0000b334, 0x0000ffff, 0x00014cc9, 0x00017f7e,
  0x0000dddd, 0x00012221, 0x00017f7d, 0x00017f7f,
  0x0000ffff, 0x000154d5, 0x00017f7e, 0x00017f80,
  0x000132b3, 0x000154d6, 0x00017f7f, 0x00017f81,
  0x000154d6, 0x00017f7f, 0x00017f81, 0x00017fef,
  0x000154d7, 0x00017f80, 0x00017fee, 0x00017ffc,
  0x000154d8, 0x00017fed, 0x00017ffb, 0x00017ffd,
  0x00015545, 0x00017ffa, 0x00017ffc, 0x00017ffe,
  0x00015552, 0x00017ffb, 0x00017ffd, 0x00007fff,
  0x00015553, 0x00017ffc, 0x00007ffe, 0x00008000,
  0x00015554, 0x00007ffd, 0x00007fff, 0x00008001,
  0x00005555, 0x00007ffe, 0x00008000, 0x0000800f,
  0x00005556, 0x00007fff, 0x0000800e, 0x0000807c,
  0x00005557, 0x0000800d, 0x0000807b, 0x0000807d,
  0x00005565, 0x0000807a, 0x0000807c, 0x0000807e,
  0x000055d2, 0x0000807b, 0x0000807d, 0x0000b332,
  0x000055d3, 0x0000807c, 0x0000b331, 0x0000d554,
  0x000055d4, 0x0000b330, 0x0000d553, 0x0000fffc,
  0x00008888, 0x0000d552, 0x0000fffb, 0x0000fffd,
  0x0000aaaa, 0x0000fffa, 0x0000fffc, 0x0000fffe,
  0x0000d552, 0x0000fffb, 0x0000fffd, 0x0000ffff,
  0x0000d553, 0x0000fffc, 0x0000fffe, 0x00010000,
  0x0000d554, 0x0000fffd, 0x0000ffff, 0x00012aa9,
  0x0000d555, 0x0000fffe, 0x00012aa8, 0x00014ccb,
  0x0000d556, 0x00012aa7, 0x00014cca, 0x00017f7f,
  0x0000ffff, 0x00014cc9, 0x00017f7e, 0x00017f80,
  0x00012221, 0x00017f7d, 0x00017f7f, 0x00017f81,
  0x000154d5, 0x00017f7e, 0x00017f80, 0x00017f82,
  0x00017f7e, 0x00017f80, 0x00017f82, 0x00017ff0,
  0x00017f7f, 0x00017f81, 0x00017fef, 0x00017ffd,
  0x00017f80, 0x00017fee, 0x00017ffc, 0x00017ffe,
  0x00017fed, 0x00017ffb, 0x00017ffd, 0x00017fff,
  0x00017ffa, 0x00017ffc, 0x00017ffe, 0x00008000,
  0x00017ffb, 0x00017ffd, 0x00007fff, 0x00008001,
  0x00017ffc, 0x00007ffe, 0x00008000, 0x00008002,
  0x00007ffd, 0x00007fff, 0x00008001, 0x00008010,
  0x00007ffe, 0x00008000, 0x0000800f, 0x0000807d,
  0x00007fff, 0x0000800e, 0x0000807c, 0x0000807e,
  0x0000800d, 0x0000807b, 0x0000807d, 0x0000807f,
  0x0000807a, 0x0000807c, 0x0000807e, 0x0000b333,
  0x0000807b, 0x0000807d, 0x0000b332, 0x0000d555,
  0x0000807c, 0x0000b331, 0x0000d554, 0x0000fffd,
  0x0000b330, 0x0000d553, 0x0000fffc, 0x0000fffe,
  0x0000d552, 0x0000fffb, 0x0000fffd, 0x0000ffff,
  0x0000fffa, 0x0000fffc, 0x0000fffe, 0x00010000,
  0x0000fffb, 0x0000fffd, 0x0000ffff, 0x00010001,
  0x0000fffc, 0x0000fffe, 0x00010000, 0x00012aaa,
  0x0000fffd, 0x0000ffff, 0x00012aa9, 0x00014ccc,
  0x0000fffe, 0x00012aa8, 0x00014ccb, 0x00017f80,
  0x00012aa7, 0x00014cca, 0x00017f7f, 0x00017f81,
  0x00014cc9, 0x00017f7e, 0x00017f80, 0x00017f82,
  0x00017f7d, 0x00017f7f, 0x00017f81, 0x00017f83,
  0x00017f7f, 0x00017f81, 0x00017f83, 0x00017ff1,
  0x00017f80, 0x00017f82, 0x00017ff0, 0x00017ffe,
  0x00017f81, 0x00017fef, 0x00017ffd, 0x00017fff,
  0x00017fee, 0x00017ffc, 0x00017ffe, 0x00018000,
  0x00017ffb, 0x00017ffd, 0x00017fff, 0x00008001,
  0x00017ffc, 0x00017ffe, 0x00008000, 0x00008002,
  0x00017ffd, 0x00007fff, 0x00008001, 0x00008003,
  0x00007ffe, 0x00008000, 0x00008002, 0x00008011,
  0x00007fff, 0x00008001, 0x00008010, 0x0000807e,
  0x00008000, 0x0000800f, 0x0000807d, 0x0000807f,
  0x0000800e, 0x0000807c, 0x0000807e, 0x00008080,
  0x0000807b, 0x0000807d, 0x0000807f, 0x0000b334,
  0x0000807c, 0x0000807e, 0x0000b333, 0x0000d556,
  0x0000807d, 0x0000b332, 0x0000d555, 0x0000fffe,
  0x0000b331, 0x0000d554, 0x0000fffd, 0x0000ffff,
  0x0000d553, 0x0000fffc, 0x0000fffe, 0x00010000,
  0x0000fffb, 0x0000fffd, 0x0000ffff, 0x00010001,
  0x0000fffc, 0x0000fffe, 0x00010000, 0x00010002,
  0x0000fffd, 0x0000ffff, 0x00010001, 0x00012aab,
  0x0000fffe, 0x00010000, 0x00012aaa, 0x00014ccd,
  0x0000ffff, 0x00012aa9, 0x00014ccc, 0x00017f81,
  0x00012aa8, 0x00014ccb, 0x00017f80, 0x00017f82,
  0x00014cca, 0x00017f7f, 0x00017f81, 0x00017f83,
  0x00017f7e, 0x00017f80, 0x00017f82, 0x00017f84,
  0x00017f80, 0x00017f82, 0x00017f84, 0x0001aa9a,
  0x00017f81, 0x00017f83, 0x00017ff1, 0x0001aaa7,
  0x00017f82, 0x00017ff0, 0x00017ffe, 0x0001aaa8,
  0x00017fef, 0x00017ffd, 0x00017fff, 0x0001aaa9,
  0x00017ffc, 0x00017ffe, 0x00018000, 0x0000aaaa,
  0x00017ffd, 0x00017fff, 0x00008001, 0x0000aaab,
  0x00017ffe, 0x00008000, 0x00008002, 0x0000aaac,
  0x00007fff, 0x00008001, 0x00008003, 0x0000aaba,
  0x00008000, 0x00008002, 0x00008011, 0x0000ab27,
  0x00008001, 0x00008010, 0x0000807e, 0x0000ab28,
  0x0000800f, 0x0000807d, 0x0000807f, 0x0000ab29,
  0x0000807c, 0x0000807e, 0x00008080, 0x0000dddd,
  0x0000807d, 0x0000807f, 0x0000b334, 0x0000ffff,
  0x0000807e, 0x0000b333, 0x0000d556, 0x00012aa7,
  0x0000b332, 0x0000d555, 0x0000fffe, 0x00012aa8,
  0x0000d554, 0x0000fffd, 0x0000ffff, 0x00012aa9,
  0x0000fffc, 0x0000fffe, 0x00010000, 0x00012aaa,
  0x0000fffd, 0x0000ffff, 0x00010001, 0x00012aab,
  0x0000fffe, 0x00010000, 0x00010002, 0x00015554,
  0x0000ffff, 0x00010001, 0x00012aab, 0x00017776,
  0x00010000, 0x00012aaa, 0x00014ccd, 0x0001aa2a,
  0x00012aa9, 0x00014ccc, 0x00017f81, 0x0001aa2b,
  0x00014ccb, 0x00017f80, 0x00017f82, 0x0001aa2c,
  0x00017f7f, 0x00017f81, 0x00017f83, 0x0001aa2d,
  0x00017f81, 0x00017f83, 0x0001aa2d, 0x0001ccbc,
  0x00017f82, 0x00017f84, 0x0001aa9a, 0x0001ccc9,
  0x00017f83, 0x00017ff1, 0x0001aaa7, 0x0001ccca,
  0x00017ff0, 0x00017ffe, 0x0001aaa8, 0x0001cccb,
  0x00017ffd, 0x00017fff, 0x0001aaa9, 0x0000cccc,
  0x00017ffe, 0x00018000, 0x0000aaaa, 0x0000cccd,
  0x00017fff, 0x00008001, 0x0000aaab, 0x0000ccce,
  0x00008000, 0x00008002, 0x0000aaac, 0x0000ccdc,
  0x00008001, 0x00008003, 0x0000aaba, 0x0000cd49,
  0x00008002, 0x00008011, 0x0000ab27, 0x0000cd4a,
  0x00008010, 0x0000807e, 0x0000ab28, 0x0000cd4b,
  0x0000807d, 0x0000807f, 0x0000ab29, 0x0000ffff,
  0x0000807e, 0x00008080, 0x0000dddd, 0x00012221,
  0x0000807f, 0x0000b334, 0x0000ffff, 0x00014cc9,
  0x0000b333, 0x0000d556, 0x00012aa7, 0x00014cca,
  0x0000d555, 0x0000fffe, 0x00012aa8, 0x00014ccb,
  0x0000fffd, 0x0000ffff, 0x00012aa9, 0x00014ccc,
  0x0000fffe, 0x00010000, 0x00012aaa, 0x00014ccd,
  0x0000ffff, 0x00010001, 0x00012aab, 0x00017776,
  0x00010000, 0x00010002, 0x00015554, 0x00019998,
  0x00010001, 0x00012aab, 0x00017776, 0x0001cc4c,
  0x00012aaa, 0x00014ccd, 0x0001aa2a, 0x0001cc4d,
  0x00014ccc, 0x00017f81, 0x0001aa2b, 0x0001cc4e,
  0x00017f80, 0x00017f82, 0x0001aa2c, 0x0001cc4f,
  0x00017f82, 0x0001aa2c, 0x0001cc4f, 0x0001ff70,
  0x00017f83, 0x0001aa2d, 0x0001ccbc, 0x0001ff7d,
  0x00017f84, 0x0001aa9a, 0x0001ccc9, 0x0001ff7e,
  0x00017ff1, 0x0001aaa7, 0x0001ccca, 0x0001ff7f,
  0x00017ffe, 0x0001aaa8, 0x0001cccb, 0x0000ff80,
  0x00017fff, 0x0001aaa9, 0x0000cccc, 0x0000ff81,
  0x00018000, 0x0000aaaa, 0x0000cccd, 0x0000ff82,
  0x00008001, 0x0000aaab, 0x0000ccce, 0x0000ff90,
  0x00008002, 0x0000aaac, 0x0000ccdc, 0x0000fffd,
  0x00008003, 0x0000aaba, 0x0000cd49, 0x0000fffe,
  0x00008011, 0x0000ab27, 0x0000cd4a, 0x0000ffff,
  0x0000807e, 0x0000ab28, 0x0000cd4b, 0x000132b3,
  0x0000807f, 0x0000ab29, 0x0000ffff, 0x000154d5,
  0x00008080, 0x0000dddd, 0x00012221, 0x00017f7d,
  0x0000b334, 0x0000ffff, 0x00014cc9, 0x00017f7e,
  0x0000d556, 0x00012aa7, 0x00014cca, 0x00017f7f,
  0x0000fffe, 0x00012aa8, 0x00014ccb, 0x00017f80,
  0x0000ffff, 0x00012aa9, 0x00014ccc, 0x00017f81,
  0x00010000, 0x00012aaa, 0x00014ccd, 0x0001aa2a,
  0x00010001, 0x00012aab, 0x00017776, 0x0001cc4c,
  0x00010002, 0x00015554, 0x00019998, 0x0001ff00,
  0x00012aab, 0x00017776, 0x0001cc4c, 0x0001ff01,
  0x00014ccd, 0x0001aa2a, 0x0001cc4d, 0x0001ff02,
  0x00017f81, 0x0001aa2b, 0x0001cc4e, 0x0001ff03,
  0x0001aa2b, 0x0001cc4e, 0x0001ff03, 0x0001ff71,
  0x0001aa2c, 0x0001cc4f, 0x0001ff70, 0x0001ff7e,
  0x0001aa2d, 0x0001ccbc, 0x0001ff7d, 0x0001ff7f,
  0x0001aa9a, 0x0001ccc9, 0x0001ff7e, 0x0001ff80,
  0x0001aaa7, 0x0001ccca, 0x0001ff7f, 0x0000ff81,
  0x0001aaa8, 0x0001cccb, 0x0000ff80, 0x0000ff82,
  0x0001aaa9, 0x0000cccc, 0x0000ff81, 0x0000ff83,
  0x0000aaaa, 0x0000cccd, 0x0000ff82, 0x0000ff91,
  0x0000aaab, 0x0000ccce, 0x0000ff90, 0x0000fffe,
  0x0000aaac, 0x0000ccdc, 0x0000fffd, 0x0000ffff,
  0x0000aaba, 0x0000cd49, 0x0000fffe, 0x00010000,
  0x0000ab27, 0x0000cd4a, 0x0000ffff, 0x000132b4,
  0x0000ab28, 0x0000cd4b, 0x000132b3, 0x000154d6,
  0x0000ab29, 0x0000ffff, 0x000154d5, 0x00017f7e,
  0x0000dddd, 0x00012221, 0x00017f7d, 0x00017f7f,
  0x0000ffff, 0x00014cc9, 0x00017f7e, 0x00017f80,
  0x00012aa7, 0x00014cca, 0x00017f7f, 0x00017f81,
  0x00012aa8, 0x00014ccb, 0x00017f80, 0x00017f82,
  0x00012aa9, 0x00014ccc, 0x00017f81, 0x0001aa2b,
  0x00012aaa, 0x00014ccd, 0x0001aa2a, 0x0001cc4d,
  0x00012aab, 0x00017776, 0x0001cc4c, 0x0001ff01,
  0x00015554, 0x00019998, 0x0001ff00, 0x0001ff02,
  0x00017776, 0x0001cc4c, 0x0001ff01, 0x0001ff03,
  0x0001aa2a, 0x0001cc4d, 0x0001ff02, 0x0001ff04,
  0x0001cc4d, 0x0001ff02, 0x0001ff04, 0x0001ff72,
  0x0001cc4e, 0x0001ff03, 0x0001ff71, 0x0001ff7f,
  0x0001cc4f, 0x0001ff70, 0x0001ff7e, 0x0001ff80,
  0x0001ccbc, 0x0001ff7d, 0x0001ff7f, 0x0001ff81,
  0x0001ccc9, 0x0001ff7e, 0x0001ff80, 0x0000ff82,
  0x0001ccca, 0x0001ff7f, 0x0000ff81, 0x0000ff83,
  0x0001cccb, 0x0000ff80, 0x0000ff82, 0x0000ff84,
  0x0000cccc, 0x0000ff81, 0x0000ff83, 0x0000ff92,
  0x0000cccd, 0x0000ff82, 0x0000ff91, 0x0000ffff,
  0x0000ccce, 0x0000ff90, 0x0000fffe, 0x00010000,
  0x0000ccdc, 0x0000fffd, 0x0000ffff, 0x00010001,
  0x0000cd49, 0x0000fffe, 0x00010000, 0x000132b5,
  0x0000cd4a, 0x0000ffff, 0x000132b4, 0x000154d7,
  0x0000cd4b, 0x000132b3, 0x000154d6, 0x00017f7f,
  0x0000ffff, 0x000154d5, 0x00017f7e, 0x00017f80,
  0x00012221, 0x00017f7d, 0x00017f7f, 0x00017f81,
  0x00014cc9, 0x00017f7e, 0x00017f80, 0x00017f82,
  0x00014cca, 0x00017f7f, 0x00017f81, 0x00017f83,
  0x00014ccb, 0x00017f80, 0x00017f82, 0x0001aa2c,
  0x00014ccc, 0x00017f81, 0x0001aa2b, 0x0001cc4e,
  0x00014ccd, 0x0001aa2a, 0x0001cc4d, 0x0001ff02,
  0x00017776, 0x0001cc4c, 0x0001ff01, 0x0001ff03,
  0x00019998, 0x0001ff00, 0x0001ff02, 0x0001ff04,
  0x0001cc4c, 0x0001ff01, 0x0001ff03, 0x0001ff05,
  0x0001ff01, 0x0001ff03, 0x0001ff05, 0x0001ff73,
  0x0001ff02, 0x0001ff04, 0x0001ff72, 0x0001ff80,
  0x0001ff03, 0x0001ff71, 0x0001ff7f, 0x0001ff81,
  0x0001ff70, 0x0001ff7e, 0x0001ff80, 0x0001ff82,
  0x0001ff7d, 0x0001ff7f, 0x0001ff81, 0x0000ff83,
  0x0001ff7e, 0x0001ff80, 0x0000ff82, 0x0000ff84,
  0x0001ff7f, 0x0000ff81, 0x0000ff83, 0x0000ff85,
  0x0000ff80, 0x0000ff82, 0x0000ff84, 0x0000ff93,
  0x0000ff81, 0x0000ff83, 0x0000ff92, 0x00010000,
  0x0000ff82, 0x0000ff91, 0x0000ffff, 0x00010001,
  0x0000ff90, 0x0000fffe, 0x00010000, 0x00010002,
  0x0000fffd, 0x0000ffff, 0x00010001, 0x000132b6,
  0x0000fffe, 0x00010000, 0x000132b5, 0x000154d8,
  0x0000ffff, 0x000132b4, 0x000154d7, 0x00017f80,
  0x000132b3, 0x000154d6, 0x00017f7f, 0x00017f81,
  0x000154d5, 0x00017f7e, 0x00017f80, 0x00017f82,
  0x00017f7d, 0x00017f7f, 0x00017f81, 0x00017f83,
  0x00017f7e, 0x00017f80, 0x00017f82, 0x00017f84,
  0x00017f7f, 0x00017f81, 0x00017f83, 0x0001aa2d,
  0x00017f80, 0x00017f82, 0x0001aa2c, 0x0001cc4f,
  0x00017f81, 0x0001aa2b, 0x0001cc4e, 0x0001ff03,
  0x0001aa2a, 0x0001cc4d, 0x0001ff02, 0x0001ff04,
  0x0001cc4c, 0x0001ff01, 0x0001ff03, 0x0001ff05,
  0x0001ff00, 0x0001ff02, 0x0001ff04, 0x0001ff06,
};
const unsigned kExpectedCount_NEON_uaddl_4S = 576;

#endif  // VIXL_SIM_UADDL_4S_TRACE_AARCH64_H_
