Please read the README file in this directory first.
.ex
.Id $Id: procmailrc.man,v 1.75.2.4 2000/08/22 04:23:47 guenther Exp $
.TH PROCMAILRC 5 \*(Dt BuGless
.na
.SH NAME
procmailrc \- procmail rcfile
.SH SYNOPSIS
.B @PROCMAILRC@
.ad
.SH DESCRIPTION
For a quick start, see
.B NOTES
at the end of the
.BR procmail (1)
man page.
.PP
The rcfile can contain a mixture of environment variable assignments (some
of which have special meanings to procmail), and recipes.  In their most
simple appearance, the recipes are simply one line regular expressions
that are searched for in the header of the arriving mail.  The first recipe
that matches is used to determine where the mail has to go (usually a file).
If processing falls off the end of the rcfile, procmail will deliver the mail
to
.BR $DEFAULT .
.PP
There are two kinds of recipes: delivering and non-delivering recipes.
If a
.I delivering recipe
is found to match, procmail considers the mail (you guessed it) delivered and
will
.I cease processing
the rcfile after having successfully executed the action line of the recipe.
If a
.I non-delivering recipe
is found to match, processing of the rcfile will
.I continue
after the action line of this recipe has been executed.
.PP
Delivering recipes are those that cause header and/or body of the mail to
be: written into a file, absorbed by a program or forwarded to a mailaddress.
.PP
Non-delivering recipes are: those that cause the output of a program or
filter to be captured back by procmail or those that start a nesting block.
.PP
You can tell procmail to treat a
.I delivering recipe
as if it were a non-delivering recipe by specifying the `@CONTINUE@' flag on
such a recipe.  This will make procmail generate a
.I carbon copy
of the mail by delivering it to this recipe, yet continue processing the
rcfile.
.PP
By using any number of recipes you can presort your mail extremely
straightforward into several mailfolders.  Bear in mind though that the mail
can arrive concurrently in these mailfolders (if several procmail programs
happen to run at the same time, not unlikely if a lot of mail arrives).  To
make sure this does not result in a mess, proper use of lockfiles is highly
recommended.
.PP
The environment variable
.B assignments
and
.B recipes
can be freely intermixed in the rcfile. If any environment variable has
a special meaning to procmail, it will be used appropriately the moment
it is parsed (i.e. you can change the current directory whenever you
want by specifying a new
.BR MAILDIR ,
switch lockfiles by specifying a new
.BR LOCKFILE ,
change the umask at any time, etc., the possibilities are endless :\-).
.PP
The assignments and substitutions of these environment variables are handled
exactly like in
.BR sh (1)
(that includes all possible quotes and escapes),
with the added bonus that blanks around the '=' sign are ignored and that,
if an environment variable appears without a trailing '=', it will be
removed from the environment.  Any program in backquotes started by procmail
will have the entire mail at its stdin.
.PP
.SS Comments
A word beginning with # and all the following characters up to a NEWLINE
are ignored.  This does not apply to condition lines, which cannot be
commented.
.SS Recipes
.PP
A line starting with ':' marks the beginning of a recipe.  It has the
following format:
.Sx 3
:0 [\fIflags\fP] [ : [\fIlocallockfile\fP] ]
<zero or more conditions (one per line)>
<exactly one action line>
.Ex
Conditions start with a leading `*', everything after that character
is passed on to the internal egrep
.BR literally ,
except for leading and trailing whitespace.
These regular expressions are
.B completely
compatible to the normal
.BR egrep (1)
extended regular expressions.  See also
.BR "Extended regular expressions" .
.PP
Conditions are anded; if there are no conditions the result will be true
by default.
.PP
.I Flags
can be any of the following:
.TP 0.5i
.B @HEAD_GREP@
Egrep the header (default).
.TP
.B @BODY_GREP@
Egrep the body.
.TP
.B @DISTINGUISH_CASE@
Tell the internal egrep to distinguish between upper and lower case (contrary
to the default which is to ignore case).
.TP
.B @ALSO_NEXT_RECIPE@
This recipe will not be executed unless the conditions on the last preceding
recipe (on the current block-nesting level) without the `@ALSO_NEXT_RECIPE@' or
`@ALSO_N_IF_SUCC@' flag matched as well.  This allows you to chain actions
that depend on a common condition.
.TP
.B @ALSO_N_IF_SUCC@
Has the same meaning as the `@ALSO_NEXT_RECIPE@' flag, with the additional
condition that the immediately preceding recipe must have been
.I successfully
completed before this recipe is executed.
.TP
.B @ELSE_DO@
This recipe only executes if the immediately preceding recipe was not
executed.  Execution of this recipe also disables any immediately
following recipes with the '@ELSE_DO@' flag.  This allows you to specify
`else if' actions.
.TP
.B @ERROR_DO@
This recipe only executes if the immediately preceding recipe
.IR failed
(i.e. the action line was attempted, but resulted in an error).
.TP
.B @PASS_HEAD@
Feed the header to the pipe, file or mail destination (default).
.TP
.B @PASS_BODY@
Feed the body to the pipe, file or mail destination (default).
.TP
.B @FILTER@
Consider the pipe as a filter.
.TP
.B @CONTINUE@
Generate a
.B carbon copy
of this mail.  This only makes sense on
.I delivering
recipes.  The only non-delivering recipe this flag has an effect on is
on a nesting block, in order to generate a carbon copy this will
.B clone
the running procmail process (lockfiles will not be inherited), whereby
the clone will proceed as usual and the parent will jump across the block.
.TP
.B @WAIT_EXIT@
Wait for the filter or program to finish and check its exitcode (normally
ignored); if the filter is unsuccessful, then the text will not have been
filtered.
.TP
.B @WAIT_EXIT_QUIET@
Has the same meaning as the `@WAIT_EXIT@' flag, but will suppress any
`Program failure' message.
.TP
.B @IGNORE_WRITERR@
Ignore any write errors on this recipe (i.e. usually due to an early closed
pipe).
.TP
.B @RAW_NONL@
Raw mode, do not try to ensure the mail ends with an empty line, write
it out as is.
.PP
There are some special conditions you can use that are not straight regular
expressions.  To select them, the condition must start with:
.TP 0.5i
.B !
Invert the condition.
.TP
.B $
Evaluate the remainder of this condition according to
.BR sh (1)
substitution rules inside double quotes, skip leading whitespace,
then reparse it.
.TP
.B ?
Use the exitcode of the specified program.
.TP
.B <
Check if the total length of the mail is shorter than the specified (in
decimal) number of bytes.
.TP
.B >
Analogous to '<'.
.TP
.B "variablename \fI??\fP"
Match the remainder of this condition against the value of this environment
variable (which cannot be a pseudo variable).  A special case is if
variablename is equal to `B', `H', `HB' or `BH'; this merely overrides the
default header/body search area defined by the initial flags on this recipe.
.TP
.B \e
To quote any of the above at the start of the line.
.SS "Local lockfile"
.PP
If you put a second (trailing) ':' on the first recipe line, then procmail
will use a
.I locallockfile
(for this recipe only).  You can optionally specify the locallockfile
to use; if you don't however, procmail will use the destination filename
(or the filename following the first '>>') and will append $LOCKEXT to it.
.SS "Recipe action line"
.PP
The action line can start with the following characters:
.TP
.B !
Forwards to all the specified mail addresses.
.TP
.B |
Starts the specified program, possibly in $SHELL if any
of the characters $SHELLMETAS are spotted.  You can optionally prepend this
pipe symbol with
.IR variable= ,
which will cause stdout of the program to be captured in the environment
.I variable
(procmail will
.B not
terminate processing the rcfile at this point).
If you specify just this pipe symbol, without any program, then procmail will
pipe the mail to stdout.
.TP
.B {
Followed by at least one space, tab or newline will mark the start of a
nesting block.  Everything up till the next closing brace will depend on
the conditions specified for this recipe.  Unlimited nesting is permitted.
The closing brace exists merely to delimit the block, it will
.I not
cause procmail to terminate in any way.  If the end of a block is reached
processing will continue as usual after the block.
On a nesting block, the flags `@HEAD_GREP@' and `@BODY_GREP@' only affect
the conditions leading up to the block, the flags `@PASS_HEAD@' and
`@PASS_BODY@' have no effect whatsoever.
.PP
Anything else will be taken as a mailbox name (either a filename or a
directory, absolute or relative to the current directory (see MAILDIR)).
If it is a (possibly yet nonexistent) filename, the mail will be appended to
it.
.PP
If it is a directory, the mail will be delivered to a newly created,
guaranteed to be unique file named $MSGPREFIX* in the specified directory.
If the mailbox name ends in "@MCDIRSEP@@chCURDIR@", then this directory is
presumed to be an MH folder; i.e., procmail will use the next number it
finds available.  If the mailbox name ends in "@MCDIRSEP@", then this
directory is presumed to be a maildir folder; i.e., procmail will deliver
the message to a file in a subdirectory named "tmp" and rename it to be
inside a subdirectory named "new".  If the mailbox is specified to be an MH
folder or maildir folder, procmail will create the necessary directories if
they don't exist, rather than treat the mailbox as a non-existent
filename.  When procmail is delivering to directories, you can specify
multiple directories to deliver to (procmail will do so utilising
hardlinks).
.SS "Environment variable defaults"
.TP 2.2i
.B "LOGNAME, HOME and SHELL"
Your (the recipient's) defaults
.TP
.B PATH \&@DEFpath@
.br
(Except during the processing of an @ETCRC@ file, when it will be set
to `\&@DEFspath@'.)
.TP
.B SHELLMETAS
\&@DEFshellmetas@
.TP
.B SHELLFLAGS
\&@DEFshellflags@
.TP
.BR ORGMAIL
\&@MAILSPOOLDIR@$LOGNAME
.br
(Unless
.B \-@MAILFILTOPT@
has been specified, in which case it is unset)
.TP
.B MAILDIR
\&@DEFmaildir@
.br
(Unless the name of the first successfully opened rcfile starts with
`@chCURDIR@@MCDIRSEP@' or if
.B \-@MAILFILTOPT@
has been specified, in which case it defaults to `@chCURDIR@')
.TP
.B DEFAULT
\&@DEFdefault@
.TP
.B MSGPREFIX
\&@DEFmsgprefix@
.TP
.B SENDMAIL
\&@DEFsendmail@
.TP
.B SENDMAILFLAGS
\&@DEFflagsendmail@
.TP
.B HOST
The current hostname
.TP
.B COMSAT
\&@DEFcomsat@
.br
(If an rcfile is specified on the command line)
.TP
.B PROCMAIL_VERSION
\&@PM_VERSION@
.TP
.B LOCKEXT
\&@DEFlockext@@PRESTENV@@LD_ENV_FIX@
.SS Environment
.PP
Before you get lost in the multitude of environment variables, keep in mind
that all of them have reasonable defaults.
.TP 1.2i
.B MAILDIR
Current directory while procmail is executing (that means that all paths
are relative to $MAILDIR).
.TP
.B DEFAULT
Default
.B mailbox
file (if not told otherwise, procmail will dump mail in this mailbox).
Procmail will automatically use $DEFAULT$LOCKEXT as lockfile prior to writing
to this mailbox.  You do not need to set this variable, since it already
points to the standard system mailbox.
.TP
.B LOGFILE
This file will also contain any error or diagnostic messages from procmail
(normally none :\-) or any other programs started by procmail.  If this file
is not specified, any diagnostics or error messages will
@pconsole@@console@@aconsole@
See also
.BR LOGABSTRACT .
.TP
.B VERBOSE
You can turn on
.I extended diagnostics
by setting this variable to `yes' or `on', to turn it off again set it to `no'
or `off'.
.TP
.B LOGABSTRACT
Just before procmail exits it logs an abstract of the delivered message in
$LOGFILE showing the `@FROM@' and `Subject:' fields of the header, what folder
it finally went to and how long (in bytes) the message was.  By setting this
variable to `no', generation of this abstract is suppressed.  If you set
it to `all', procmail will log an abstract for every successful
.I delivering recipe
it processes.
.TP
.B LOG
Anything assigned to this variable will be appended to $LOGFILE.
.TP
.B ORGMAIL
Usually the system mailbox (\fBOR\fPi\fBG\fPinal \fBMAIL\fPbox).  If, for
some obscure reason (like `\fBfilesystem full\fP') the mail could not be
delivered, then this mailbox will be the last resort.  If procmail
fails to save the mail in here (deep, deep trouble :\-), then the mail
will bounce back to the sender.
.TP
.B LOCKFILE
Global semaphore file.  If this file already exists, procmail
will wait until it has gone before proceeding, and will create it itself
(cleaning it up when ready, of course).  If more than one
.I lockfile
are specified, then the previous one will be removed before trying to create
the new one.  The use of a global lockfile is discouraged, whenever possible
use locallockfiles (on a per recipe basis) instead.
.TP
.B LOCKEXT
Default extension that is appended to a destination file to determine
what local
.I lockfile
to use (only if turned on, on a per-recipe basis).
.TP
.B LOCKSLEEP
Number of seconds procmail will sleep before retrying on a
.I lockfile
(if it already existed); if not specified, it defaults to @DEFlocksleep@
seconds.
.TP
.B LOCKTIMEOUT
Number of seconds that have to have passed since a
.I lockfile
was last modified/created before procmail decides that this must be an
erroneously leftover lockfile that can be removed by force now.  If zero,
then no timeout will be used and procmail will wait forever until the
lockfile is removed; if not specified, it defaults to @DEFlocktimeout@ seconds.
This variable is useful to prevent indefinite hangups of
.BR sendmail /procmail.
Procmail is immune to clock skew across machines.
.TP
.B TIMEOUT
Number of seconds that have to have passed before procmail decides that
some child it started must be hanging.  The offending program will receive
a TERMINATE signal from procmail, and processing of the rcfile will continue.
If zero, then no timeout will be used and procmail will wait forever until the
child has terminated; if not specified, it defaults to @DEFtimeout@ seconds.
.TP
.B MSGPREFIX
Filename prefix that is used when delivering to a directory (not used when
delivering to a maildir or an MH directory).
.TP
.B HOST
If this is not the
.I hostname
of the machine, processing of the current
.I rcfile
will immediately cease. If other rcfiles were specified on the
command line, processing will continue with the next one.  If all rcfiles
are exhausted, the program will terminate, but will not generate an error
(i.e. to the mailer it will seem that the mail has been delivered).
.TP
.B UMASK
The name says it all (if it doesn't, then forget about this one :\-).
Anything assigned to UMASK is taken as an
.B octal
number.  If not specified, the umask defaults to @INIT_UMASK@.  If the umask
permits o+x, all the mailboxes procmail delivers to directly will receive
an o+x mode change.  This can be used to check if new mail arrived.
.TP
.B SHELLMETAS
If any of the characters in SHELLMETAS appears in the line specifying
a filter or program, the line will be fed to $SHELL
instead of being executed directly.
.TP
.B SHELLFLAGS
Any invocation of $SHELL will be like:
.br
"$SHELL" "$SHELLFLAGS" "$*";
.TP
.B SENDMAIL
If you're not using the
.I forwarding
facility don't worry about this one.  It specifies the program being
called to forward any mail.
.br
It gets invoked as: "$SENDMAIL" $SENDMAILFLAGS "$@";
.TP
.B NORESRETRY
Number of retries that are to be made if any `\fBprocess table full\fP',
`\fBfile table full\fP', `\fBout of memory\fP' or
`\fBout of swap space\fP' error should occur.  If this number is negative,
then procmail will retry indefinitely; if not specified, it defaults to
@DEFnoresretry@ times.  The retries occur with a $SUSPEND second interval.  The
idea behind this is, that if e.g. the
.I swap
.I space
has been exhausted or the
.I process
.I table
is full, usually several other programs will either detect this as well
and abort or crash 8-), thereby freeing valuable
.I resources
for procmail.
.TP
.B SUSPEND
Number of seconds that procmail will pause if it has to wait for something
that is currently unavailable (memory, fork, etc.); if not specified, it will
default to @DEFsuspend@ seconds.  See also:
.BR LOCKSLEEP .
.TP
.B LINEBUF
Length of the internal line buffers, cannot be set smaller than @MINlinebuf@.
All lines read from the
.I rcfile
should not exceed $LINEBUF characters before and after expansion.  If not
specified, it defaults to @DEFlinebuf@.  This limit, of course, does
.I not
apply to the mail itself, which can have arbitrary line lengths, or could
be a binary file for that matter.  See also PROCMAIL_OVERFLOW.
.TP
.B DELIVERED
If set to `yes' procmail will pretend (to the mail agent) the mail
has been delivered.  If mail cannot be delivered after having met this
assignment (set to `yes'), the mail will be lost (i.e. it will not bounce).
.TP
.B TRAP
When procmail terminates it will execute the contents of this variable.
A copy of the mail can be read from stdin.  Any output produced by this
command will be appended to $LOGFILE.  Possible uses for TRAP are: removal
of temporary files, logging customised abstracts, etc.  See also
.B EXITCODE
and
.BR LOGABSTRACT .
.TP
.B EXITCODE
When procmail terminates and this variable has been set to a positive numeric
value, procmail will use this as the exitcode.  If this variable is set but
empty, procmail will set the exitcode to whatever the
.B TRAP
program returns.
If this variable has not been set, procmail will set it shortly before calling
up the
.B TRAP
program.
.TP
.B LASTFOLDER
This variable is assigned to by procmail whenever it is delivering
to a folder or program.  It always contains the name of the last file
(or program) procmail delivered to.  If the last delivery was to
several directory folders together then $LASTFOLDER will contain
the hardlinked filenames as a space separated list.
.TP
.B @MATCHVAR@
This variable is assigned to by procmail whenever it is told to extract
text from a matching regular expression.  It will contain all text
matching the regular expression past the `\fB\e/\fP' token.
.TP
.B SHIFT
Assigning a positive value to this variable has the same effect as
the `shift' command in
.BR sh (1).
This command is most useful to extract extra arguments passed to procmail
when acting as a generic mailfilter.
.TP
.B INCLUDERC
Names an rcfile (relative to the current directory) which will be
included here as if it were part of the current rcfile.  Nesting is
permitted and only limited by systems resources (memory and file
descriptors).  As no checking is done on the permissions or ownership
of the rcfile, users of
.B INCLUDERC
should make sure that only trusted users have write access to the included
rcfile or the directory it is in.
.TP
.B SWITCHRC
Names an rcfile (relative to the current directory) to which processing
will be switched.  If the named rcfile doesn't exist or is not a normal
file or /dev/null then an error will be logged and processing will
continue in the current rcfile.  Otherwise, processing of the current
rcfile will be aborted and the named rcfile started.  Unsetting
.B SWITCHRC
aborts processing of the current rcfile as if it had ended at the
assignment.  As with
.BR INCLUDERC ,
no checking is done on the permissions or ownership of the rcfile.
.TP
.B PROCMAIL_VERSION
The version number of the running procmail binary.
.TP
.B PROCMAIL_OVERFLOW
This variable will be set to a non-empty value if procmail detects a
buffer overflow.  See the
.B BUGS
section below for other details of operation when overflow occurs.
.TP
.B COMSAT
.BR Comsat (8)/ biff (1)
notification is on by default, it can be turned off by setting this variable
to `no'.  Alternatively the biff-service can be customised by setting it to
either `service@SERV_ADDRsep@', `@SERV_ADDRsep@hostname', or
`service@SERV_ADDRsep@hostname'.  When not specified it defaults
to @COMSATservice@@SERV_ADDRsep@@COMSAThost@.@DROPPRIVS@
.SS "Extended regular expressions"
The following tokens are known to both the procmail internal egrep and the
standard
.BR egrep (1)
(beware that some egrep implementations include other non-standard extensions):
.TP 1.0i
.B ^
Start of a line.
.TP
.B $
End of a line.
.TP
.B .
Any character except a newline.
.TP
.B a*
Any sequence of zero or more a's.
.TP
.B a+
Any sequence of one or more a's.
.TP
.B a?
Either zero or one a.
.TP
.B [^-a-d]
Any character which is
.B not
either a dash, a, b, c, d or newline.
.TP
.B de|abc
Either the sequence `de' or `abc'.
.TP
.B (abc)*
Zero or more times the sequence `abc'.
.TP
.B \e.
Matches a single dot; use \e to quote any of the magic characters to get
rid of their special meaning.  See also $\e variable substitution.
.PP
These were only samples, of course, any more complex combination is valid
as well.
.PP
The following token meanings are special procmail extensions:
.TP 1.0i
\fB^\fP or \fB$\fP
Match a newline (for multiline matches).
.TP
.B ^^
Anchor the expression at the very start of the search area, or if encountered
at the end of the expression, anchor it at the very end of the search area.
.TP
\fB\e<\fP or \fB\e>\fP
Match the character before or after a word.  They are merely a shorthand
for `[^a-zA-Z0-9_]', but can also match newlines.
Since they match actual characters, they are only suitable to delimit
words, not to delimit inter-word space.
.TP
.B \e/
Splits the expression in two parts.  Everything matching the right part
will be assigned to the @MATCHVAR@ environment variable.
.SH EXAMPLES
Look in the
.BR procmailex (5)
man page.
.SH CAVEATS
Continued lines in an action line that specifies a program always have to end
in a backslash, even if the underlying shell would not need or want the
backslash to indicate continuation.  This is due to the two pass parsing
process needed (first procmail, then the shell (or not, depending on
.BR SHELLMETAS )).
.PP
Don't put comments on the regular expression condition lines in a
recipe, these lines are fed to the internal egrep
.I literally
(except for continuation backslashes at the end of a line).
.PP
Leading whitespace on continued regular expression condition lines
is usually ignored (so that they can be indented), but
.B not
on continued condition lines that are evaluated according to the
.BR sh (1)
substitution rules inside double quotes.
.PP
Watch out for deadlocks when doing unhealthy things like forwarding mail
to your own account.  Deadlocks can be broken by proper use of
.BR LOCKTIMEOUT .
.PP
Any default values that procmail has for some environment variables will
.B always
override the ones that were already defined.  If you really want to
override the defaults, you either have to put them in the
.B rcfile
or on the command line as arguments.
.PP
The @ETCRC@ file cannot change the PATH setting seen by user rcfiles
as the value is reset when procmail finishes the @ETCRC@ file.  While
future enhancements are expected in this area, recompiling procmail
with the desired value is currently the only correct solution.
.PP
Environment variables set
.B inside
the shell-interpreted-`|' action part of a recipe will
.B not
retain their value after the recipe has finished since they are set in a
subshell of procmail.  To make sure the value of an environment variable is
retained you have to put the assignment to the variable before the leading `|'
of a recipe, so that it can capture stdout of the program.
.PP
If you specify only a `@PASS_HEAD@' or a `@PASS_BODY@' flag on a delivering
recipe, and the recipe matches, then, unless the `@CONTINUE@' flag is
present as well, the body respectively the header of the mail will be silently
lost.
.SH "SEE ALSO"
.na
.nh
.BR procmail (1),
.BR procmailsc (5),
.BR procmailex (5),
.BR sh (1),
.BR csh (1),
.BR mail (1),
.BR mailx (1),
.BR binmail (1),
.BR uucp (1),
.BR aliases (5),
.BR sendmail (8),
.BR egrep (1),
.BR regexp (5),
.BR grep (1),
.BR biff (1),
.BR comsat (8),
.BR lockfile (1),
.BR formail (1)
.hy
.ad
.SH BUGS
The only substitutions of environment variables that can be handled by
procmail itself are of the type $name, ${name}, ${name:-text}, ${name:+text},
${name-text}, ${name+text}, $\ename, $#, $n, $$, $?, $_, $\- and $=;
whereby $\ename will be substituted by the
all-magic-regular-expression-characters-disarmed
equivalent of $name, $_ by the name of the current rcfile, $\- by
$LASTFOLDER and $= will contain the score of the last recipe.
Furthermore, the result of $\ename substituion will never be split on
whitespace.  When the
.B \-@ARGUMENTOPT@
or
.B \-@MAILFILTOPT@
options are used, "$@" will expand to respectively the specified argument
(list); but only when passed as in the argument list to a program, and
then only one such occurence will be expanded.
.PP
Unquoted variable expansions performed by procmail are always split on
space, tab, and newline characters; the IFS variable is not used internally.
.PP
Procmail does not support the expansion of `~'.
.PP
A line buffer of length $LINEBUF is used when processing the
.IR rcfile ,
any expansions that don't fit within this limit will be truncated and
PROCMAIL_OVERFLOW will be set.  If the overflowing line is a condition
or an action line, then it will be considered failed and procmail will
continue processing.  If it is a variable assignment or recipe start
line then procmail will abort the entire rcfile.
.PP
If the global lockfile has a
.I relative
path, and the current directory
is not the same as when the global lockfile was created, then the global
lockfile will not be removed if procmail exits at that point (remedy:
use
.I absolute
paths to specify global lockfiles).
.PP
If an rcfile has a
.I relative
path and when the rcfile is first opened
.B MAILDIR
contains a relative path, and if at one point procmail is instructed to
clone itself and the current directory has changed since the rcfile was
opened, then procmail will not be able to clone itself (remedy: use an
.I absolute
path to reference the rcfile or make sure MAILDIR contains an absolute
path as the rcfile is opened).
.PP
A locallockfile on the recipe that marks the start of a non-forking nested
block does not work as expected.
.PP
When capturing stdout from a recipe into an environment variable, exactly
one trailing newline will be stripped.
.PP
Some non-optimal and non-obvious regexps set MATCH to an incorrect
value.  The regexp can be made to work by removing one or more unneeded
'*', '+', or '?' operator on the left-hand side of the \e/ token.
.SH MISCELLANEOUS
If the regular expression contains `\fB@TO_key@\fP' it will be substituted by
.na
.nh
`\fB@TO_substitute@\fP',
which should catch all destination specifications containing a specific
.IR address .
.hy
.ad
.PP
If the regular expression contains `\fB@TOkey@\fP' it will be substituted by
.na
.nh
`\fB@TOsubstitute@\fP',
which should catch all destination specifications containing a specific
.IR word .
.hy
.ad
.PP
If the regular expression contains `\fB@FROMDkey@\fP' it will be
substituted by
.na
.nh
`\fB@FROMDsubstitute@\fP',
which should catch mails coming from most daemons (how's that for a regular
expression :\-).
.hy
.ad
.PP
If the regular expression contains `\fB@FROMMkey@\fP' it will be
substituted by
.na
.nh
`\fB@FROMMsubstitute@\fP'
(a stripped down version of `\fB@FROMDkey@\fP'),
which should catch mails coming from most mailer-daemons.
.hy
.ad
.PP
When assigning boolean values to variables like VERBOSE, DELIVERED or COMSAT,
procmail accepts as true every string starting with: a non-zero value, `on',
`y', `t' or `e'.  False is every string starting with: a zero value, `off',
`n', `f' or `d'.
.PP
If the action line of a recipe specifies a program, a sole backslash-newline
pair in it on an otherwise empty line will be converted into a newline.
.PP
The regular expression engine built into procmail does not support named
character classes.
.SH NOTES
Since unquoted leading whitespace is generally ignored in the rcfile you can
indent everything to taste.
.PP
The leading `|' on the action line to specify a program or filter is stripped
before checking for $SHELLMETAS.
.PP
Files included with the INCLUDERC directive containing only environment
variable assignments can be shared with sh.
.PP
The current behavior of assignments on the command line to
.B INCLUDERC
and
.B SWITCHRC
is not guaranteed and may be changed or removed in future releases.
.PP
For
.I really
complicated processing you can even consider calling
.B procmail
recursively.
.PP
In the old days, the `:0' that marks the beginning of a recipe, had to
be changed to `:n', whereby `n' denotes the number of conditions that
follow.
