% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string.R
\name{split_source}
\alias{split_source}
\title{Split source lines into complete expressions}
\usage{
split_source(x, merge_comments = FALSE, line_number = FALSE)
}
\arguments{
\item{x}{A character vector of R source code.}

\item{merge_comments}{Whether to merge consecutive lines of comments as a
single expression to be combined with the next non-comment expression (if
any).}

\item{line_number}{Whether to store the line numbers of each expression in
the returned value.}
}
\value{
A list of character vectors, and each vector contains a complete R
expression, with an attribute \code{lines} indicating the starting and ending
line numbers of the expression if the argument \code{line_number = TRUE}.
}
\description{
Parse the lines of code one by one to find complete expressions in the code,
and put them in a list.
}
\examples{
code = c("# comment 1", "# comment 2", "if (TRUE) {", "1 + 1", "}", "print(1:5)")
xfun::split_source(code)
xfun::split_source(code, merge_comments = TRUE)
}
