% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rounding.R
\name{pretty_signif}
\alias{pretty_signif}
\title{Round a value to a defined number of significant digits printing out trailing
zeros, if applicable}
\usage{
pretty_signif(x, digits = 6, sci_range = 6, sci_sep = "e")
}
\arguments{
\item{x}{The number to round.}

\item{digits}{integer indicating the number of significant digits.}

\item{sci_range}{integer (or \code{Inf}) indicating when to switch to
scientific notation instead of floating point. Zero indicates always use
scientific; \code{Inf} indicates to never use scientific notation;
otherwise, scientific notation is used when \code{abs(log10(x)) > sci_range}.}

\item{sci_sep}{The separator to use for scientific notation strings
(typically this will be either "e" or "x10^" for computer- or
human-readable output).}
}
\value{
A string with the value.
}
\description{
Round a value to a defined number of significant digits printing out trailing
zeros, if applicable
}
\details{
Values that are not standard numbers like \code{Inf}, \code{NA}, and
\code{NaN} are returned as \code{"Inf"}, \code{"NA"}, and \code{NaN}.
}
\seealso{
\code{\link[=signif]{signif()}}, \code{\link[=pretty_round]{pretty_round()}}.
}
