% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round.R
\name{round_hms}
\alias{round_hms}
\alias{trunc_hms}
\title{Round or truncate to a multiple of seconds}
\usage{
round_hms(x, secs = NULL, digits = NULL)

trunc_hms(x, secs = NULL, digits = NULL)
}
\arguments{
\item{x}{A vector of class \link{hms}}

\item{secs}{Multiple of seconds, a positive numeric. Values less than one
are supported}

\item{digits}{Number of digits, a whole number.
Negative numbers are supported.}
}
\value{
The input, rounded or truncated to the nearest multiple of \code{secs}
(or number of \code{digits})
}
\description{
Convenience functions to round or truncate to a multiple of seconds.
}
\examples{
round_hms(as_hms("12:34:56"), 5)
round_hms(as_hms("12:34:56"), 60)
round_hms(as_hms("12:34:56.78"), 0.25)
round_hms(as_hms("12:34:56.78"), digits = 1)
round_hms(as_hms("12:34:56.78"), digits = -2)
trunc_hms(as_hms("12:34:56"), 60)
}
