\name{evd-internal}

\alias{abvalog}
\alias{abvaneglog}
\alias{abvhr}
\alias{abvlog}
\alias{abvneglog}
\alias{abvbilog}
\alias{abvnegbilog}
\alias{abvct}
\alias{abvamix}

\alias{hbvalog}
\alias{hbvaneglog}
\alias{hbvhr}
\alias{hbvlog}
\alias{hbvneglog}
\alias{hbvbilog}
\alias{hbvnegbilog}
\alias{hbvct}
\alias{hbvamix}

\alias{rbvlog}
\alias{rbvalog}
\alias{rbvhr}
\alias{rbvneglog}
\alias{rbvaneglog}
\alias{rbvbilog}
\alias{rbvnegbilog}
\alias{rbvct}
\alias{rbvamix}

\alias{dbvlog}
\alias{dbvalog}
\alias{dbvhr}
\alias{dbvneglog}
\alias{dbvaneglog}
\alias{dbvbilog}
\alias{dbvnegbilog}
\alias{dbvct}
\alias{dbvamix}

\alias{pbvlog}
\alias{pbvalog}
\alias{pbvhr}
\alias{pbvneglog}
\alias{pbvaneglog}
\alias{pbvbilog}
\alias{pbvnegbilog}
\alias{pbvct}
\alias{pbvamix}

\alias{amvalog}
\alias{amvlog}
\alias{rmvlog}
\alias{rmvalog}
\alias{pmvlog}
\alias{pmvalog}
\alias{dmvlog}
\alias{dmvalog}

\alias{tvdepfn}
\alias{mvalog.check}
\alias{subsets}

\alias{fgev.quantile}
\alias{fgev.norm}
\alias{fpot.quantile}
\alias{fpot.norm}

\alias{fbvlog}
\alias{fbvalog}
\alias{fbvhr}
\alias{fbvneglog}
\alias{fbvaneglog}
\alias{fbvbilog}
\alias{fbvnegbilog}
\alias{fbvct}
\alias{fbvamix}

\alias{fbvcpot}
\alias{fbvclog}
\alias{fbvcalog}
\alias{fbvcaneglog}
\alias{fbvcbilog}
\alias{fbvcct}
\alias{fbvcnegbilog}
\alias{fbvcneglog}
\alias{fbvchr}
\alias{fbvcamix}

\alias{fbvppot}
\alias{fbvplog}
\alias{fbvpbilog}
\alias{fbvpct}
\alias{fbvpnegbilog}
\alias{fbvpneglog}
\alias{fbvphr}

\alias{bvpost.optim}
\alias{bvstart.vals}
\alias{sep.bvdata}

\alias{dens}
\alias{pp}
\alias{qq}
\alias{rl}
\alias{dens.gev}
\alias{pp.gev}
\alias{qq.gev}
\alias{rl.gev}
\alias{dens.pot}
\alias{pp.pot}
\alias{qq.pot}
\alias{rl.pot}
\alias{dens.gumbelx}
\alias{pp.gumbelx}
\alias{qq.gumbelx}
\alias{rl.gumbelx}

\alias{bvcpp}
\alias{bvdens}
\alias{bvdp}
\alias{bvqc}
\alias{bvh}
\alias{bvcpp.bvevd}
\alias{bvdens.bvevd}
\alias{bvdp.bvevd}
\alias{bvqc.bvevd}
\alias{bvh.bvevd}
\alias{bvdens.bvpot}
\alias{bvdp.bvpot}
\alias{bvqc.bvpot}
\alias{bvh.bvpot}

\title{Internal Functions}

\description{
  The evd package contains many internal functions that are not
  designed to be called by the user.

  Plotting: The generic functions \code{dens}, \code{pp}, \code{qq}
  and \code{rl} create the diagnostic plots generated by
  \code{plot.uvevd}. Similarly, \code{bvdens}, \code{bvcpp},
  \code{bvdp}, \code{bvqc} and \code{bvh} create the diagnostic
  plots generated by \code{plot.bvevd} and \code{plot.bvpot}.

  Distribution: There are internal, simulation, distribution,
  density, dependence and spectral density functions for separate
  bivariate and multivariate parametric models, which are called from
  functions such as \code{abvevd} and \code{pmvevd}.
  Additionally, the three functions \code{mvalog.check} (checks and
  transforms asymmetry parameters), \code{subsets} (generates all
  subsets of a set) and \code{tvdepfn} (plots trivariate dependence
  functions) are called from functions associated with multivariate
  distributions.
  
  Univariate Fitting: The fitting function \code{fgev} calls the
  internal functions \code{fgev.quantile} and \code{fgev.norm} for
  fits under different parameterizations. The fitting function
  \code{fpot} calls the internal functions \code{fpot.norm} and
  \code{fpot.quantile}.

  Bivariate Fitting: For fitting bivariate distributions, internal
  functions exist for each model. For fitting bivariate threshold
  models, internal functions exist for the censored and
  (undocumented) point process likelihoods, and each of these calls
  a further internal function corresponding to the specified model.
  The functions \code{bvpost.optim} (post-optimisation processing),
  \code{bvstart.vals} (starting values) and \code{sep.bvdata}
  (separation of data) are additionally used in the fitting of
  bivariate distributions and bivariate threshold models.
}

\keyword{internal}
