% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_n_node_clones.R
\name{add_n_node_clones}
\alias{add_n_node_clones}
\title{Add one or several clones of an existing node to the graph}
\usage{
add_n_node_clones(graph, n, node, label = NULL)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{n}{The number of node clones to add to the graph.}

\item{node}{A node ID corresponding to the graph node to be cloned.}

\item{label}{An optional vector of node label values. The vector length
should correspond to the value set for \code{n}.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Add \code{n} new nodes to a graph object of class \code{dgr_graph} which are clones of
a node already in the graph. All node attributes are preserved except for the
node \code{label} attribute (to maintain the uniqueness of non-\code{NA} node label
values). A vector of node \code{label} can be provided to bind new labels to the
cloned nodes.
}
\examples{
# Create a graph with a path of
# nodes; supply `label`, `type`,
# and `value` node attributes
graph <-
  create_graph() \%>\%
  add_path(
    n = 3,
    label = c("d", "g", "r"),
    type = c("a", "b", "c"))

# Display the graph's internal
# node data frame
graph \%>\% get_node_df()

# Create 3 clones of node `1`
# but assign new node label
# values (leaving `label` as
# NULL yields NA values)
graph <-
  graph \%>\%
  add_n_node_clones(
    n = 3,
    node = 1,
    label = c("x", "y", "z"))

# Display the graph's internal
# node data frame: nodes `4`,
# `5`, and `6` are clones of `1`
graph \%>\% get_node_df()

}
\seealso{
Other node creation and removal: 
\code{\link{add_n_nodes}()},
\code{\link{add_n_nodes_ws}()},
\code{\link{add_node}()},
\code{\link{add_node_clones_ws}()},
\code{\link{add_node_df}()},
\code{\link{add_nodes_from_df_cols}()},
\code{\link{add_nodes_from_table}()},
\code{\link{colorize_node_attrs}()},
\code{\link{copy_node_attrs}()},
\code{\link{create_node_df}()},
\code{\link{delete_node}()},
\code{\link{delete_nodes_ws}()},
\code{\link{drop_node_attrs}()},
\code{\link{join_node_attrs}()},
\code{\link{layout_nodes_w_string}()},
\code{\link{mutate_node_attrs}()},
\code{\link{mutate_node_attrs_ws}()},
\code{\link{node_data}()},
\code{\link{recode_node_attrs}()},
\code{\link{rename_node_attrs}()},
\code{\link{rescale_node_attrs}()},
\code{\link{set_node_attr_to_display}()},
\code{\link{set_node_attr_w_fcn}()},
\code{\link{set_node_attrs}()},
\code{\link{set_node_attrs_ws}()},
\code{\link{set_node_position}()}
}
\concept{node creation and removal}
