% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube_helix.r
\name{cube_helix}
\alias{cube_helix}
\alias{scale_colour_cube_helix}
\alias{scale_color_cube_helix}
\alias{scale_fill_cube_helix}
\title{Sequential color palette using the cube helix system}
\usage{
cube_helix(
  n = 6,
  start = 0,
  r = 0.4,
  hue = 0.8,
  gamma = 1,
  light = 0.85,
  dark = 0.15,
  reverse = FALSE
)

scale_colour_cube_helix(
  ...,
  start = 0,
  r = 0.4,
  hue = 0.8,
  gamma = 1,
  light = 0.85,
  dark = 0.15,
  reverse = FALSE,
  discrete = TRUE,
  guide = if (discrete) "legend" else "colourbar"
)

scale_color_cube_helix(
  ...,
  start = 0,
  r = 0.4,
  hue = 0.8,
  gamma = 1,
  light = 0.85,
  dark = 0.15,
  reverse = FALSE,
  discrete = TRUE,
  guide = if (discrete) "legend" else "colourbar"
)

scale_fill_cube_helix(
  ...,
  start = 0,
  r = 0.4,
  hue = 0.8,
  gamma = 1,
  light = 0.85,
  dark = 0.15,
  reverse = FALSE,
  discrete = TRUE,
  guide = if (discrete) "legend" else "colourbar"
)
}
\arguments{
\item{n}{Number of colors to return (default: 6)}

\item{start}{Hue to start helix at (\eqn{\textrm{start} \in [0,3]}, default: 0)}

\item{r}{Number of rotations of the helix. Can be negative. (default: 0.4)}

\item{hue}{Saturation. 0 means greyscale, 1 fully saturated colors (default: 0.8)}

\item{gamma}{Emphasize darker (gamma < 1) or lighter (gamma > 1) colors (default: 1)}

\item{light}{Lightest lightness (default: 0.85)}

\item{dark}{Darkest lightness (default: 0.15)}

\item{reverse}{logical. If TRUE, reverse lightness (default: FALSE)}

\item{...}{parameters passed to \code{\link[ggplot2]{discrete_scale}} or \code{\link[ggplot2]{continuous_scale}}}

\item{discrete}{If TRUE, return a discrete scale, if FALSE a continuous one (default: TRUE)}

\item{guide}{Type of scale guide to use. See \code{\link[ggplot2]{guides}}}
}
\value{
A \code{character} vector of hex colors with length \code{n}
}
\description{
Creates a perceptually monotonously decreasing (or increasing) lightness color palette with different tones.
This was necessary in pre-viridis times, by now you can probably just use \code{\link[grDevices]{hcl.colors}}
}
\examples{
palette(cube_helix())
image(matrix(1:6), col = 1:6, pch = 19, axes = FALSE)

cr <- scales::colour_ramp(cube_helix(12, r = 3))
r <- runif(100)
plot(1:100, r, col = cr(r), type = 'b', pch = 20)

}
