% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ReadSparseHardcalls}
\alias{ReadSparseHardcalls}
\title{If HasSparseHardcalls() is true, returns a sparse representation for the
(variant, allele) pair.  If HasSparseHardcalls() is false, the function
fails.}
\usage{
ReadSparseHardcalls(pgen, variant_num, allele_num = 2L, return_ints = FALSE)
}
\arguments{
\item{pgen}{Object returned by NewPgen().}

\item{variant_num}{Variant index (1-based).}

\item{allele_num}{Allele index; 1 corresponds to REF, 2 to the first ALT
allele, 3 to the second ALT allele if it exists, etc.  Optional, defaults
to 2.}

\item{return_ints}{Whether to make the "counts" component of the return
value an IntegerVector instead of a NumericVector; defaults to false.}
}
\value{
Either an empty list, in which case buf is filled in the same
mannerObject where "sample_ids" is an increasing sequence of positive
integers listing which samples have the allele, and "counts" is a vector
listing the allele counts for those samples.
}
\description{
If HasSparseHardcalls() is true, returns a sparse representation for the
(variant, allele) pair.  If HasSparseHardcalls() is false, the function
fails.
}
