/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2013 Zoltan Bartko, Aaron Madlon-Kay
               2015 Aaron Madlon-Kay
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.gui.dialogs;

import java.awt.Dimension;
import java.awt.event.KeyEvent;

import javax.swing.JTable;

import org.omegat.gui.editor.chartable.CharTableModel;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;

/**
 *
 * @author bartkoz
 * @author Aaron Madlon-Kay
 */
@SuppressWarnings("serial")
public class CharTableAutoCompleterOptionsDialog extends javax.swing.JDialog {

    CharTableModel allCharModel = new CharTableModel(null);
    
    CharTableModel selCharModel = new CharTableModel("");
    
    StringBuilder builder = new StringBuilder();
    
    /**
     * Creates new form CharTableAutoCompleterDialog
     */
    public CharTableAutoCompleterOptionsDialog(java.awt.Frame parent) {
        super(parent, true);
        initComponents();
        
        StaticUIUtils.setEscapeClosable(this);
        getRootPane().setDefaultButton(okButton);
        
        allCharTable.setModel(allCharModel);
        selCharTable.setModel(selCharModel);
        
        selectedCharsCheckBox.setSelected(
                Preferences.isPreference(Preferences.AC_CHARTABLE_USE_CUSTOM_CHARS));
        uniqueCheckBox.setSelected(Preferences.isPreference(
                Preferences.AC_CHARTABLE_UNIQUE_CUSTOM_CHARS));
        selCharModel.setData(Preferences.getPreference(
                Preferences.AC_CHARTABLE_CUSTOM_CHAR_STRING));
        
        panelSetEnabled(selectedCharsCheckBox.isSelected());
        
        setPreferredSize(new Dimension(400, 500));
        pack();
        DockingUI.displayCentered(this);
    }
    
    private void panelSetEnabled(boolean enabled) {
        customPanel.setEnabled(enabled);
        descriptionTextArea.setEnabled(enabled);
        allCharLabel.setEnabled(enabled);
        allCharTable.setEnabled(enabled);
        if (!enabled) {
            allCharTable.clearSelection();
        }
        selCharLabel.setEnabled(enabled);
        selCharTable.setEnabled(enabled);
        uniqueCheckBox.setEnabled(enabled);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel3 = new javax.swing.JPanel();
        selectedCharsCheckBox = new javax.swing.JCheckBox();
        customPanel = new javax.swing.JPanel();
        jPanel8 = new javax.swing.JPanel();
        descriptionTextArea = new javax.swing.JTextArea();
        jPanel7 = new javax.swing.JPanel();
        jPanel6 = new javax.swing.JPanel();
        allCharLabel = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        allCharTable = new javax.swing.JTable();
        jPanel5 = new javax.swing.JPanel();
        selCharLabel = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        selCharTable = new javax.swing.JTable();
        jPanel4 = new javax.swing.JPanel();
        clearButton = new javax.swing.JButton();
        uniqueCheckBox = new javax.swing.JCheckBox();
        jPanel1 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(OStrings.getString("AC_CHARTABLE_DIALOG_TITLE")); // NOI18N

        jPanel3.setBorder(javax.swing.BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel3.setLayout(new java.awt.BorderLayout());

        selectedCharsCheckBox.setText(OStrings.getString("AC_CHARTABLE_CUSTOM")); // NOI18N
        selectedCharsCheckBox.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                selectedCharsCheckBoxStateChanged(evt);
            }
        });
        jPanel3.add(selectedCharsCheckBox, java.awt.BorderLayout.NORTH);

        customPanel.setBorder(javax.swing.BorderFactory.createCompoundBorder(javax.swing.BorderFactory.createEmptyBorder(5, 0, 0, 0), javax.swing.BorderFactory.createEtchedBorder()));
        customPanel.setLayout(new java.awt.BorderLayout());

        jPanel8.setBorder(javax.swing.BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel8.setLayout(new java.awt.BorderLayout());

        descriptionTextArea.setEditable(false);
        descriptionTextArea.setFont(getFont());
        descriptionTextArea.setLineWrap(true);
        descriptionTextArea.setText(OStrings.getString("AC_CHARTABLE_EXPLANATION")); // NOI18N
        descriptionTextArea.setWrapStyleWord(true);
        descriptionTextArea.setOpaque(false);
        jPanel8.add(descriptionTextArea, java.awt.BorderLayout.NORTH);

        customPanel.add(jPanel8, java.awt.BorderLayout.NORTH);

        jPanel7.setLayout(new javax.swing.BoxLayout(jPanel7, javax.swing.BoxLayout.Y_AXIS));

        jPanel6.setBorder(javax.swing.BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel6.setLayout(new java.awt.BorderLayout());

        allCharLabel.setText(OStrings.getString("AC_CHARTABLE_ALL_LABEL")); // NOI18N
        jPanel6.add(allCharLabel, java.awt.BorderLayout.NORTH);

        allCharTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {

            }
        ));
        allCharTable.setCellSelectionEnabled(true);
        allCharTable.setFillsViewportHeight(true);
        allCharTable.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        allCharTable.setTableHeader(null);
        allCharTable.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                allCharTableMouseClicked(evt);
            }
        });
        allCharTable.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                allCharTableKeyReleased(evt);
            }
        });
        jScrollPane1.setViewportView(allCharTable);

        jPanel6.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        jPanel7.add(jPanel6);

        jPanel5.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 5, 5, 5));
        jPanel5.setLayout(new java.awt.BorderLayout());

        selCharLabel.setText(OStrings.getString("AC_CHARTABLE_CUSTOM_LABEL")); // NOI18N
        jPanel5.add(selCharLabel, java.awt.BorderLayout.NORTH);

        selCharTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {

            }
        ));
        selCharTable.setCellSelectionEnabled(true);
        selCharTable.setFillsViewportHeight(true);
        selCharTable.setTableHeader(null);
        selCharTable.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                selCharTableKeyReleased(evt);
            }
        });
        jScrollPane2.setViewportView(selCharTable);

        jPanel5.add(jScrollPane2, java.awt.BorderLayout.CENTER);

        jPanel7.add(jPanel5);

        customPanel.add(jPanel7, java.awt.BorderLayout.CENTER);

        jPanel4.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 5, 5, 5));
        jPanel4.setLayout(new java.awt.BorderLayout());

        clearButton.setText(OStrings.getString("AC_CHARTABLE_CLEAR_BUTTON")); // NOI18N
        clearButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearButtonActionPerformed(evt);
            }
        });
        jPanel4.add(clearButton, java.awt.BorderLayout.EAST);

        uniqueCheckBox.setText(OStrings.getString("AC_CHARTABLE_CUSTOM_UNIQUE")); // NOI18N
        uniqueCheckBox.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                uniqueCheckBoxStateChanged(evt);
            }
        });
        jPanel4.add(uniqueCheckBox, java.awt.BorderLayout.WEST);

        customPanel.add(jPanel4, java.awt.BorderLayout.SOUTH);

        jPanel3.add(customPanel, java.awt.BorderLayout.CENTER);

        getContentPane().add(jPanel3, java.awt.BorderLayout.CENTER);

        jPanel1.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 10, 10, 10));
        jPanel1.setLayout(new java.awt.BorderLayout());

        jPanel2.setLayout(new javax.swing.BoxLayout(jPanel2, javax.swing.BoxLayout.LINE_AXIS));

        org.openide.awt.Mnemonics.setLocalizedText(okButton, OStrings.getString("BUTTON_OK")); // NOI18N
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });
        jPanel2.add(okButton);

        org.openide.awt.Mnemonics.setLocalizedText(cancelButton, OStrings.getString("BUTTON_CANCEL")); // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        jPanel2.add(cancelButton);

        jPanel1.add(jPanel2, java.awt.BorderLayout.EAST);

        getContentPane().add(jPanel1, java.awt.BorderLayout.SOUTH);
    }// </editor-fold>//GEN-END:initComponents

    private void allCharTableKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_allCharTableKeyReleased
        if (evt.getKeyCode() == KeyEvent.VK_INSERT) {
            int col = allCharTable.getSelectedColumn();
            int row = allCharTable.getSelectedRow();
            selCharModel.appendChar((Character) allCharModel.getValueAt(row, col),
                    uniqueCheckBox.isSelected());
        }
    }//GEN-LAST:event_allCharTableKeyReleased

    private void selCharTableKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_selCharTableKeyReleased
        if (evt.getKeyCode() == KeyEvent.VK_DELETE || 
                evt.getKeyCode() == KeyEvent.VK_BACK_SPACE) {
            if (selCharTable.getSelectedColumnCount() < 1) 
                return;
            
            int row1 = selCharTable.getSelectedRow();
            int col1 = selCharTable.getSelectedColumn();
            int row2 = selCharTable.getSelectedRowCount()+row1-1;
            int col2 = selCharTable.getSelectedColumnCount()+col1-1;
            
            selCharModel.removeSelection(row1, col1, row2, col2);
        }
    }//GEN-LAST:event_selCharTableKeyReleased

    private void uniqueCheckBoxStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_uniqueCheckBoxStateChanged
        if (uniqueCheckBox.isSelected()) {
            selCharModel.allowOnlyUnique();
        }
    }//GEN-LAST:event_uniqueCheckBoxStateChanged

    private void selectedCharsCheckBoxStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_selectedCharsCheckBoxStateChanged
        panelSetEnabled(selectedCharsCheckBox.isSelected());
    }//GEN-LAST:event_selectedCharsCheckBoxStateChanged

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        Preferences.setPreference(Preferences.AC_CHARTABLE_USE_CUSTOM_CHARS,
                selectedCharsCheckBox.isSelected());
        String customCharString = selCharModel.getData();
        Preferences.setPreference(Preferences.AC_CHARTABLE_CUSTOM_CHAR_STRING, 
            customCharString);
        if (customCharString.isEmpty()) {
            Preferences.setPreference(Preferences.AC_CHARTABLE_USE_CUSTOM_CHARS,
                    false);
        }
        Preferences.setPreference(Preferences.AC_CHARTABLE_UNIQUE_CUSTOM_CHARS,
                uniqueCheckBox.isSelected());
        doClose();
    }//GEN-LAST:event_okButtonActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        doClose();
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void allCharTableMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_allCharTableMouseClicked
        if (allCharTable.isEnabled() && evt.getClickCount() == 2) {
            JTable target = (JTable) evt.getSource();
            int row = target.getSelectedRow();
            int col = target.getSelectedColumn();
            selCharModel.appendChar((Character) allCharModel.getValueAt(row, col),
                    uniqueCheckBox.isSelected());
        }
    }//GEN-LAST:event_allCharTableMouseClicked

    private void clearButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearButtonActionPerformed
        selCharModel.setData("");
    }//GEN-LAST:event_clearButtonActionPerformed

    private void doClose() {
        setVisible(false);
        dispose();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel allCharLabel;
    private javax.swing.JTable allCharTable;
    private javax.swing.JButton cancelButton;
    private javax.swing.JButton clearButton;
    private javax.swing.JPanel customPanel;
    private javax.swing.JTextArea descriptionTextArea;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JButton okButton;
    private javax.swing.JLabel selCharLabel;
    private javax.swing.JTable selCharTable;
    private javax.swing.JCheckBox selectedCharsCheckBox;
    private javax.swing.JCheckBox uniqueCheckBox;
    // End of variables declaration//GEN-END:variables
}
