/**
* @license Apache-2.0
*
* Copyright (c) 2020 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

// MODULES //

var bench = require( '@stdlib/bench' );
var uniform = require( '@stdlib/random/iter/uniform' );
var isnan = require( './../../../../base/assert/is-nan' );
var isIteratorLike = require( '@stdlib/assert/is-iterator-like' );
var clamp = require( './../../../../base/special/clamp' );
var pkg = require( './../package.json' ).name;
var iterMap3 = require( './../lib' );


// MAIN //

bench( pkg, function benchmark( b ) {
	var rand1;
	var rand2;
	var rand3;
	var iter;
	var i;

	rand1 = uniform( 0.0, 10.0 );
	rand2 = uniform( 1.0, 2.0 );
	rand3 = uniform( 9.0, 10.0 );

	b.tic();
	for ( i = 0; i < b.iterations; i++ ) {
		iter = iterMap3( rand1, rand2, rand3, clamp );
		if ( typeof iter !== 'object' ) {
			b.fail( 'should return an object' );
		}
	}
	b.toc();
	if ( !isIteratorLike( iter ) ) {
		b.fail( 'should return an iterator protocol-compliant object' );
	}
	b.pass( 'benchmark finished' );
	b.end();
});

bench( pkg+'::iteration', function benchmark( b ) {
	var rand1;
	var rand2;
	var rand3;
	var iter;
	var opts;
	var z;
	var i;

	opts = {
		'iter': b.iterations
	};
	rand1 = uniform( 0.0, 10.0, opts );
	rand2 = uniform( 1.0, 2.0, opts );
	rand3 = uniform( 9.0, 10.0, opts );

	iter = iterMap3( rand1, rand2, rand3, clamp );

	b.tic();
	for ( i = 0; i < b.iterations; i++ ) {
		z = iter.next().value;
		if ( isnan( z ) ) {
			b.fail( 'should not return NaN' );
		}
	}
	b.toc();
	if ( isnan( z ) ) {
		b.fail( 'should not return NaN' );
	}
	b.pass( 'benchmark finished' );
	b.end();
});
