/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.internal.html.docbook.editor;

import org.dbdoclet.tag.docbook.Book;
import org.dbdoclet.tag.docbook.Chapter;
import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.docbook.Entry;
import org.dbdoclet.tag.docbook.Para;
import org.dbdoclet.tag.docbook.Part;
import org.dbdoclet.tag.docbook.Refentry;
import org.dbdoclet.tag.docbook.Refnamediv;
import org.dbdoclet.tag.docbook.Refsection;
import org.dbdoclet.tag.docbook.Reference;
import org.dbdoclet.tag.docbook.SectionElement;
import org.dbdoclet.tag.html.P;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.xiphias.dom.ElementImpl;
import org.dbdoclet.xiphias.dom.NodeImpl;
import org.dbdoclet.xiphias.dom.TextImpl;

public class PEditor extends DocBookEditor {

	@Override
	public EditorInstruction edit(EditorInstruction values)
			throws EditorException {

		setValues(super.edit(values));
		DocBookTagFactory dbfactory = getTagFactory();

		P p = (P) getHtmlElement();

		NodeImpl parent = getParent();
		Para candidate = dbfactory.createPara();
		copyCommonAttributes(p, candidate);
		candidate.setParentNode(parent);

		if (parent instanceof Entry) {
			candidate.setFormatType(ElementImpl.FORMAT_INLINE);
		}

		if (parent instanceof Para == false && candidate.isValidParent(script.getTransformPosition(), parent)) {

			setCurrent(candidate);
			parent.appendChild(getCurrent());

		} else {

			setCurrent(parent);

			if (parent instanceof Para &&  parent.getParentNode() != null) {
				parent.appendChild(new TextImpl(" "));
				setParent((NodeImpl) parent.getParentNode());
			}

			if (isSection(parent)) {

				if (parent instanceof Book || parent instanceof Part) {

					Chapter chapter = dbfactory
							.createChapter("Automatically inserted chapter");
					parent.appendChild(chapter);
					setCurrent(candidate);
					chapter.appendChild(getCurrent());

				} else if (parent instanceof Reference) {

					setCurrent(candidate);

					Refentry refEntry = dbfactory.createRefentry();
					parent.appendChild(refEntry);

					Refnamediv refNameDiv = dbfactory.createRefnamediv();
					refNameDiv.appendChild(dbfactory
							.createRefname(AUTOMATICALLY_INSERTED));
					refNameDiv.appendChild(dbfactory.createRefpurpose());
					refEntry.appendChild(refNameDiv);

					Refsection refSection = dbfactory.createRefsection();
					refEntry.appendChild(refSection);

					refSection.appendChild(getCurrent());
					// TODO Auto-generated method stub

				} else {

					SectionElement sect = (SectionElement) parent;
					SectionElement firstSectionChild = sect
							.getFirstSectionChild();

					if (firstSectionChild != null) {
						setCurrent(candidate);
						parent.insertBefore(getCurrent(), firstSectionChild);
					}
				}
			}
		}

		traverse(true);

		return finalizeValues();
	}
}
