// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

//	Lists Amazon SageMaker Catalogs based on given filters and orders. The maximum
//
// number of ResourceCatalog s viewable is 1000.
func (c *Client) ListResourceCatalogs(ctx context.Context, params *ListResourceCatalogsInput, optFns ...func(*Options)) (*ListResourceCatalogsOutput, error) {
	if params == nil {
		params = &ListResourceCatalogsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListResourceCatalogs", params, optFns, c.addOperationListResourceCatalogsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListResourceCatalogsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListResourceCatalogsInput struct {

	//  Use this parameter to search for ResourceCatalog s created after a specific
	// date and time.
	CreationTimeAfter *time.Time

	//  Use this parameter to search for ResourceCatalog s created before a specific
	// date and time.
	CreationTimeBefore *time.Time

	//  The maximum number of results returned by ListResourceCatalogs .
	MaxResults *int32

	//  A string that partially matches one or more ResourceCatalog s names. Filters
	// ResourceCatalog by name.
	NameContains *string

	//  A token to resume pagination of ListResourceCatalogs results.
	NextToken *string

	//  The value on which the resource catalog list is sorted.
	SortBy types.ResourceCatalogSortBy

	//  The order in which the resource catalogs are listed.
	SortOrder types.ResourceCatalogSortOrder

	noSmithyDocumentSerde
}

type ListResourceCatalogsOutput struct {

	//  A token to resume pagination of ListResourceCatalogs results.
	NextToken *string

	//  A list of the requested ResourceCatalog s.
	ResourceCatalogs []types.ResourceCatalog

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListResourceCatalogsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListResourceCatalogs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListResourceCatalogs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListResourceCatalogs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListResourceCatalogs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListResourceCatalogsAPIClient is a client that implements the
// ListResourceCatalogs operation.
type ListResourceCatalogsAPIClient interface {
	ListResourceCatalogs(context.Context, *ListResourceCatalogsInput, ...func(*Options)) (*ListResourceCatalogsOutput, error)
}

var _ ListResourceCatalogsAPIClient = (*Client)(nil)

// ListResourceCatalogsPaginatorOptions is the paginator options for
// ListResourceCatalogs
type ListResourceCatalogsPaginatorOptions struct {
	//  The maximum number of results returned by ListResourceCatalogs .
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListResourceCatalogsPaginator is a paginator for ListResourceCatalogs
type ListResourceCatalogsPaginator struct {
	options   ListResourceCatalogsPaginatorOptions
	client    ListResourceCatalogsAPIClient
	params    *ListResourceCatalogsInput
	nextToken *string
	firstPage bool
}

// NewListResourceCatalogsPaginator returns a new ListResourceCatalogsPaginator
func NewListResourceCatalogsPaginator(client ListResourceCatalogsAPIClient, params *ListResourceCatalogsInput, optFns ...func(*ListResourceCatalogsPaginatorOptions)) *ListResourceCatalogsPaginator {
	if params == nil {
		params = &ListResourceCatalogsInput{}
	}

	options := ListResourceCatalogsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListResourceCatalogsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListResourceCatalogsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListResourceCatalogs page.
func (p *ListResourceCatalogsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListResourceCatalogsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListResourceCatalogs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListResourceCatalogs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListResourceCatalogs",
	}
}
