//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armeventgrid

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AzureFunctionEventSubscriptionDestination.
func (a AzureFunctionEventSubscriptionDestination) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["endpointType"] = EndpointTypeAzureFunction
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFunctionEventSubscriptionDestination.
func (a *AzureFunctionEventSubscriptionDestination) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpointType":
			err = unpopulate(val, "EndpointType", &a.EndpointType)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFunctionEventSubscriptionDestinationProperties.
func (a AzureFunctionEventSubscriptionDestinationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deliveryAttributeMappings", a.DeliveryAttributeMappings)
	populate(objectMap, "maxEventsPerBatch", a.MaxEventsPerBatch)
	populate(objectMap, "preferredBatchSizeInKilobytes", a.PreferredBatchSizeInKilobytes)
	populate(objectMap, "resourceId", a.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFunctionEventSubscriptionDestinationProperties.
func (a *AzureFunctionEventSubscriptionDestinationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deliveryAttributeMappings":
			a.DeliveryAttributeMappings, err = unmarshalDeliveryAttributeMappingClassificationArray(val)
			delete(rawMsg, key)
		case "maxEventsPerBatch":
			err = unpopulate(val, "MaxEventsPerBatch", &a.MaxEventsPerBatch)
			delete(rawMsg, key)
		case "preferredBatchSizeInKilobytes":
			err = unpopulate(val, "PreferredBatchSizeInKilobytes", &a.PreferredBatchSizeInKilobytes)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &a.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BoolEqualsAdvancedFilter.
func (b BoolEqualsAdvancedFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "key", b.Key)
	objectMap["operatorType"] = AdvancedFilterOperatorTypeBoolEquals
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BoolEqualsAdvancedFilter.
func (b *BoolEqualsAdvancedFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &b.Key)
			delete(rawMsg, key)
		case "operatorType":
			err = unpopulate(val, "OperatorType", &b.OperatorType)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChannelProperties.
func (c ChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "channelType", c.ChannelType)
	populateTimeRFC3339(objectMap, "expirationTimeIfNotActivatedUtc", c.ExpirationTimeIfNotActivatedUTC)
	populate(objectMap, "messageForActivation", c.MessageForActivation)
	populate(objectMap, "partnerTopicInfo", c.PartnerTopicInfo)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "readinessState", c.ReadinessState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChannelProperties.
func (c *ChannelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelType":
			err = unpopulate(val, "ChannelType", &c.ChannelType)
			delete(rawMsg, key)
		case "expirationTimeIfNotActivatedUtc":
			err = unpopulateTimeRFC3339(val, "ExpirationTimeIfNotActivatedUTC", &c.ExpirationTimeIfNotActivatedUTC)
			delete(rawMsg, key)
		case "messageForActivation":
			err = unpopulate(val, "MessageForActivation", &c.MessageForActivation)
			delete(rawMsg, key)
		case "partnerTopicInfo":
			err = unpopulate(val, "PartnerTopicInfo", &c.PartnerTopicInfo)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "readinessState":
			err = unpopulate(val, "ReadinessState", &c.ReadinessState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChannelUpdateParameters.
func (c ChannelUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ChannelUpdateParametersProperties.
func (c ChannelUpdateParametersProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "expirationTimeIfNotActivatedUtc", c.ExpirationTimeIfNotActivatedUTC)
	populate(objectMap, "partnerTopicInfo", c.PartnerTopicInfo)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChannelUpdateParametersProperties.
func (c *ChannelUpdateParametersProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expirationTimeIfNotActivatedUtc":
			err = unpopulateTimeRFC3339(val, "ExpirationTimeIfNotActivatedUTC", &c.ExpirationTimeIfNotActivatedUTC)
			delete(rawMsg, key)
		case "partnerTopicInfo":
			err = unpopulate(val, "PartnerTopicInfo", &c.PartnerTopicInfo)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeadLetterWithResourceIdentity.
func (d DeadLetterWithResourceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deadLetterDestination", d.DeadLetterDestination)
	populate(objectMap, "identity", d.Identity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeadLetterWithResourceIdentity.
func (d *DeadLetterWithResourceIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deadLetterDestination":
			d.DeadLetterDestination, err = unmarshalDeadLetterDestinationClassification(val)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &d.Identity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryAttributeListResult.
func (d *DeliveryAttributeListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			d.Value, err = unmarshalDeliveryAttributeMappingClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeliveryWithResourceIdentity.
func (d DeliveryWithResourceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "destination", d.Destination)
	populate(objectMap, "identity", d.Identity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeliveryWithResourceIdentity.
func (d *DeliveryWithResourceIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destination":
			d.Destination, err = unmarshalEventSubscriptionDestinationClassification(val)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &d.Identity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Domain.
func (d Domain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	populate(objectMap, "identity", d.Identity)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DomainProperties.
func (d DomainProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "autoCreateTopicWithFirstSubscription", d.AutoCreateTopicWithFirstSubscription)
	populate(objectMap, "autoDeleteTopicWithLastSubscription", d.AutoDeleteTopicWithLastSubscription)
	populate(objectMap, "dataResidencyBoundary", d.DataResidencyBoundary)
	populate(objectMap, "disableLocalAuth", d.DisableLocalAuth)
	populate(objectMap, "endpoint", d.Endpoint)
	populate(objectMap, "inboundIpRules", d.InboundIPRules)
	populate(objectMap, "inputSchema", d.InputSchema)
	populate(objectMap, "inputSchemaMapping", d.InputSchemaMapping)
	populate(objectMap, "metricResourceId", d.MetricResourceID)
	populate(objectMap, "privateEndpointConnections", d.PrivateEndpointConnections)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", d.PublicNetworkAccess)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DomainProperties.
func (d *DomainProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoCreateTopicWithFirstSubscription":
			err = unpopulate(val, "AutoCreateTopicWithFirstSubscription", &d.AutoCreateTopicWithFirstSubscription)
			delete(rawMsg, key)
		case "autoDeleteTopicWithLastSubscription":
			err = unpopulate(val, "AutoDeleteTopicWithLastSubscription", &d.AutoDeleteTopicWithLastSubscription)
			delete(rawMsg, key)
		case "dataResidencyBoundary":
			err = unpopulate(val, "DataResidencyBoundary", &d.DataResidencyBoundary)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &d.DisableLocalAuth)
			delete(rawMsg, key)
		case "endpoint":
			err = unpopulate(val, "Endpoint", &d.Endpoint)
			delete(rawMsg, key)
		case "inboundIpRules":
			err = unpopulate(val, "InboundIPRules", &d.InboundIPRules)
			delete(rawMsg, key)
		case "inputSchema":
			err = unpopulate(val, "InputSchema", &d.InputSchema)
			delete(rawMsg, key)
		case "inputSchemaMapping":
			d.InputSchemaMapping, err = unmarshalInputSchemaMappingClassification(val)
			delete(rawMsg, key)
		case "metricResourceId":
			err = unpopulate(val, "MetricResourceID", &d.MetricResourceID)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &d.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &d.PublicNetworkAccess)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DomainUpdateParameterProperties.
func (d DomainUpdateParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "autoCreateTopicWithFirstSubscription", d.AutoCreateTopicWithFirstSubscription)
	populate(objectMap, "autoDeleteTopicWithLastSubscription", d.AutoDeleteTopicWithLastSubscription)
	populate(objectMap, "dataResidencyBoundary", d.DataResidencyBoundary)
	populate(objectMap, "disableLocalAuth", d.DisableLocalAuth)
	populate(objectMap, "inboundIpRules", d.InboundIPRules)
	populate(objectMap, "publicNetworkAccess", d.PublicNetworkAccess)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DomainUpdateParameters.
func (d DomainUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", d.Identity)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DynamicDeliveryAttributeMapping.
func (d DynamicDeliveryAttributeMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	objectMap["type"] = DeliveryAttributeMappingTypeDynamic
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DynamicDeliveryAttributeMapping.
func (d *DynamicDeliveryAttributeMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubEventSubscriptionDestination.
func (e EventHubEventSubscriptionDestination) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["endpointType"] = EndpointTypeEventHub
	populate(objectMap, "properties", e.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubEventSubscriptionDestination.
func (e *EventHubEventSubscriptionDestination) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpointType":
			err = unpopulate(val, "EndpointType", &e.EndpointType)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventHubEventSubscriptionDestinationProperties.
func (e EventHubEventSubscriptionDestinationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deliveryAttributeMappings", e.DeliveryAttributeMappings)
	populate(objectMap, "resourceId", e.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventHubEventSubscriptionDestinationProperties.
func (e *EventHubEventSubscriptionDestinationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deliveryAttributeMappings":
			e.DeliveryAttributeMappings, err = unmarshalDeliveryAttributeMappingClassificationArray(val)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &e.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventSubscriptionFilter.
func (e EventSubscriptionFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "advancedFilters", e.AdvancedFilters)
	populate(objectMap, "enableAdvancedFilteringOnArrays", e.EnableAdvancedFilteringOnArrays)
	populate(objectMap, "includedEventTypes", e.IncludedEventTypes)
	populate(objectMap, "isSubjectCaseSensitive", e.IsSubjectCaseSensitive)
	populate(objectMap, "subjectBeginsWith", e.SubjectBeginsWith)
	populate(objectMap, "subjectEndsWith", e.SubjectEndsWith)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventSubscriptionFilter.
func (e *EventSubscriptionFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "advancedFilters":
			e.AdvancedFilters, err = unmarshalAdvancedFilterClassificationArray(val)
			delete(rawMsg, key)
		case "enableAdvancedFilteringOnArrays":
			err = unpopulate(val, "EnableAdvancedFilteringOnArrays", &e.EnableAdvancedFilteringOnArrays)
			delete(rawMsg, key)
		case "includedEventTypes":
			err = unpopulate(val, "IncludedEventTypes", &e.IncludedEventTypes)
			delete(rawMsg, key)
		case "isSubjectCaseSensitive":
			err = unpopulate(val, "IsSubjectCaseSensitive", &e.IsSubjectCaseSensitive)
			delete(rawMsg, key)
		case "subjectBeginsWith":
			err = unpopulate(val, "SubjectBeginsWith", &e.SubjectBeginsWith)
			delete(rawMsg, key)
		case "subjectEndsWith":
			err = unpopulate(val, "SubjectEndsWith", &e.SubjectEndsWith)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventSubscriptionProperties.
func (e EventSubscriptionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deadLetterDestination", e.DeadLetterDestination)
	populate(objectMap, "deadLetterWithResourceIdentity", e.DeadLetterWithResourceIdentity)
	populate(objectMap, "deliveryWithResourceIdentity", e.DeliveryWithResourceIdentity)
	populate(objectMap, "destination", e.Destination)
	populate(objectMap, "eventDeliverySchema", e.EventDeliverySchema)
	populateTimeRFC3339(objectMap, "expirationTimeUtc", e.ExpirationTimeUTC)
	populate(objectMap, "filter", e.Filter)
	populate(objectMap, "labels", e.Labels)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "retryPolicy", e.RetryPolicy)
	populate(objectMap, "topic", e.Topic)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventSubscriptionProperties.
func (e *EventSubscriptionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deadLetterDestination":
			e.DeadLetterDestination, err = unmarshalDeadLetterDestinationClassification(val)
			delete(rawMsg, key)
		case "deadLetterWithResourceIdentity":
			err = unpopulate(val, "DeadLetterWithResourceIdentity", &e.DeadLetterWithResourceIdentity)
			delete(rawMsg, key)
		case "deliveryWithResourceIdentity":
			err = unpopulate(val, "DeliveryWithResourceIdentity", &e.DeliveryWithResourceIdentity)
			delete(rawMsg, key)
		case "destination":
			e.Destination, err = unmarshalEventSubscriptionDestinationClassification(val)
			delete(rawMsg, key)
		case "eventDeliverySchema":
			err = unpopulate(val, "EventDeliverySchema", &e.EventDeliverySchema)
			delete(rawMsg, key)
		case "expirationTimeUtc":
			err = unpopulateTimeRFC3339(val, "ExpirationTimeUTC", &e.ExpirationTimeUTC)
			delete(rawMsg, key)
		case "filter":
			err = unpopulate(val, "Filter", &e.Filter)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &e.Labels)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "retryPolicy":
			err = unpopulate(val, "RetryPolicy", &e.RetryPolicy)
			delete(rawMsg, key)
		case "topic":
			err = unpopulate(val, "Topic", &e.Topic)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventSubscriptionUpdateParameters.
func (e EventSubscriptionUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deadLetterDestination", e.DeadLetterDestination)
	populate(objectMap, "deadLetterWithResourceIdentity", e.DeadLetterWithResourceIdentity)
	populate(objectMap, "deliveryWithResourceIdentity", e.DeliveryWithResourceIdentity)
	populate(objectMap, "destination", e.Destination)
	populate(objectMap, "eventDeliverySchema", e.EventDeliverySchema)
	populateTimeRFC3339(objectMap, "expirationTimeUtc", e.ExpirationTimeUTC)
	populate(objectMap, "filter", e.Filter)
	populate(objectMap, "labels", e.Labels)
	populate(objectMap, "retryPolicy", e.RetryPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventSubscriptionUpdateParameters.
func (e *EventSubscriptionUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deadLetterDestination":
			e.DeadLetterDestination, err = unmarshalDeadLetterDestinationClassification(val)
			delete(rawMsg, key)
		case "deadLetterWithResourceIdentity":
			err = unpopulate(val, "DeadLetterWithResourceIdentity", &e.DeadLetterWithResourceIdentity)
			delete(rawMsg, key)
		case "deliveryWithResourceIdentity":
			err = unpopulate(val, "DeliveryWithResourceIdentity", &e.DeliveryWithResourceIdentity)
			delete(rawMsg, key)
		case "destination":
			e.Destination, err = unmarshalEventSubscriptionDestinationClassification(val)
			delete(rawMsg, key)
		case "eventDeliverySchema":
			err = unpopulate(val, "EventDeliverySchema", &e.EventDeliverySchema)
			delete(rawMsg, key)
		case "expirationTimeUtc":
			err = unpopulateTimeRFC3339(val, "ExpirationTimeUTC", &e.ExpirationTimeUTC)
			delete(rawMsg, key)
		case "filter":
			err = unpopulate(val, "Filter", &e.Filter)
			delete(rawMsg, key)
		case "labels":
			err = unpopulate(val, "Labels", &e.Labels)
			delete(rawMsg, key)
		case "retryPolicy":
			err = unpopulate(val, "RetryPolicy", &e.RetryPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventTypeInfo.
func (e EventTypeInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "inlineEventTypes", e.InlineEventTypes)
	populate(objectMap, "kind", e.Kind)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type HybridConnectionEventSubscriptionDestination.
func (h HybridConnectionEventSubscriptionDestination) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["endpointType"] = EndpointTypeHybridConnection
	populate(objectMap, "properties", h.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridConnectionEventSubscriptionDestination.
func (h *HybridConnectionEventSubscriptionDestination) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpointType":
			err = unpopulate(val, "EndpointType", &h.EndpointType)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridConnectionEventSubscriptionDestinationProperties.
func (h HybridConnectionEventSubscriptionDestinationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deliveryAttributeMappings", h.DeliveryAttributeMappings)
	populate(objectMap, "resourceId", h.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridConnectionEventSubscriptionDestinationProperties.
func (h *HybridConnectionEventSubscriptionDestinationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deliveryAttributeMappings":
			h.DeliveryAttributeMappings, err = unmarshalDeliveryAttributeMappingClassificationArray(val)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &h.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityInfo.
func (i IdentityInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principalId", i.PrincipalID)
	populate(objectMap, "tenantId", i.TenantID)
	populate(objectMap, "type", i.Type)
	populate(objectMap, "userAssignedIdentities", i.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type IsNotNullAdvancedFilter.
func (i IsNotNullAdvancedFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "key", i.Key)
	objectMap["operatorType"] = AdvancedFilterOperatorTypeIsNotNull
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IsNotNullAdvancedFilter.
func (i *IsNotNullAdvancedFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &i.Key)
			delete(rawMsg, key)
		case "operatorType":
			err = unpopulate(val, "OperatorType", &i.OperatorType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IsNullOrUndefinedAdvancedFilter.
func (i IsNullOrUndefinedAdvancedFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "key", i.Key)
	objectMap["operatorType"] = AdvancedFilterOperatorTypeIsNullOrUndefined
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IsNullOrUndefinedAdvancedFilter.
func (i *IsNullOrUndefinedAdvancedFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &i.Key)
			delete(rawMsg, key)
		case "operatorType":
			err = unpopulate(val, "OperatorType", &i.OperatorType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JSONInputSchemaMapping.
func (j JSONInputSchemaMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["inputSchemaMappingType"] = InputSchemaMappingTypeJSON
	populate(objectMap, "properties", j.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JSONInputSchemaMapping.
func (j *JSONInputSchemaMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inputSchemaMappingType":
			err = unpopulate(val, "InputSchemaMappingType", &j.InputSchemaMappingType)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NumberGreaterThanAdvancedFilter.
func (n NumberGreaterThanAdvancedFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "key", n.Key)
	objectMap["operatorType"] = AdvancedFilterOperatorTypeNumberGreaterThan
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NumberGreaterThanAdvancedFilter.
func (n *NumberGreaterThanAdvancedFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &n.Key)
			delete(rawMsg, key)
		case "operatorType":
			err = unpopulate(val, "OperatorType", &n.OperatorType)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NumberGreaterThanOrEqualsAdvancedFilter.
func (n NumberGreaterThanOrEqualsAdvancedFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "key", n.Key)
	objectMap["operatorType"] = AdvancedFilterOperatorTypeNumberGreaterThanOrEquals
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NumberGreaterThanOrEqualsAdvancedFilter.
func (n *NumberGreaterThanOrEqualsAdvancedFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &n.Key)
			delete(rawMsg, key)
		case "operatorType":
			err = unpopulate(val, "OperatorType", &n.OperatorType)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NumberInAdvancedFilter.
func (n NumberInAdvancedFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "key", n.Key)
	objectMap["operatorType"] = AdvancedFilterOperatorTypeNumberIn
	populate(objectMap, "values", n.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NumberInAdvancedFilter.
func (n *NumberInAdvancedFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &n.Key)
			delete(rawMsg, key)
		case "operatorType":
			err = unpopulate(val, "OperatorType", &n.OperatorType)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &n.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NumberInRangeAdvancedFilter.
func (n NumberInRangeAdvancedFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "key", n.Key)
	objectMap["operatorType"] = AdvancedFilterOperatorTypeNumberInRange
	populate(objectMap, "values", n.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NumberInRangeAdvancedFilter.
func (n *NumberInRangeAdvancedFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &n.Key)
			delete(rawMsg, key)
		case "operatorType":
			err = unpopulate(val, "OperatorType", &n.OperatorType)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &n.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NumberLessThanAdvancedFilter.
func (n NumberLessThanAdvancedFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "key", n.Key)
	objectMap["operatorType"] = AdvancedFilterOperatorTypeNumberLessThan
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NumberLessThanAdvancedFilter.
func (n *NumberLessThanAdvancedFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &n.Key)
			delete(rawMsg, key)
		case "operatorType":
			err = unpopulate(val, "OperatorType", &n.OperatorType)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NumberLessThanOrEqualsAdvancedFilter.
func (n NumberLessThanOrEqualsAdvancedFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "key", n.Key)
	objectMap["operatorType"] = AdvancedFilterOperatorTypeNumberLessThanOrEquals
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NumberLessThanOrEqualsAdvancedFilter.
func (n *NumberLessThanOrEqualsAdvancedFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &n.Key)
			delete(rawMsg, key)
		case "operatorType":
			err = unpopulate(val, "OperatorType", &n.OperatorType)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NumberNotInAdvancedFilter.
func (n NumberNotInAdvancedFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "key", n.Key)
	objectMap["operatorType"] = AdvancedFilterOperatorTypeNumberNotIn
	populate(objectMap, "values", n.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NumberNotInAdvancedFilter.
func (n *NumberNotInAdvancedFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &n.Key)
			delete(rawMsg, key)
		case "operatorType":
			err = unpopulate(val, "OperatorType", &n.OperatorType)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &n.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NumberNotInRangeAdvancedFilter.
func (n NumberNotInRangeAdvancedFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "key", n.Key)
	objectMap["operatorType"] = AdvancedFilterOperatorTypeNumberNotInRange
	populate(objectMap, "values", n.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NumberNotInRangeAdvancedFilter.
func (n *NumberNotInRangeAdvancedFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &n.Key)
			delete(rawMsg, key)
		case "operatorType":
			err = unpopulate(val, "OperatorType", &n.OperatorType)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &n.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Partner.
func (p Partner) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "authorizationExpirationTimeInUtc", p.AuthorizationExpirationTimeInUTC)
	populate(objectMap, "partnerName", p.PartnerName)
	populate(objectMap, "partnerRegistrationImmutableId", p.PartnerRegistrationImmutableID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Partner.
func (p *Partner) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationExpirationTimeInUtc":
			err = unpopulateTimeRFC3339(val, "AuthorizationExpirationTimeInUTC", &p.AuthorizationExpirationTimeInUTC)
			delete(rawMsg, key)
		case "partnerName":
			err = unpopulate(val, "PartnerName", &p.PartnerName)
			delete(rawMsg, key)
		case "partnerRegistrationImmutableId":
			err = unpopulate(val, "PartnerRegistrationImmutableID", &p.PartnerRegistrationImmutableID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PartnerAuthorization.
func (p PartnerAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authorizedPartnersList", p.AuthorizedPartnersList)
	populate(objectMap, "defaultMaximumExpirationTimeInDays", p.DefaultMaximumExpirationTimeInDays)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PartnerConfiguration.
func (p PartnerConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PartnerConfigurationUpdateParameters.
func (p PartnerConfigurationUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PartnerNamespace.
func (p PartnerNamespace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PartnerNamespaceProperties.
func (p PartnerNamespaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "disableLocalAuth", p.DisableLocalAuth)
	populate(objectMap, "endpoint", p.Endpoint)
	populate(objectMap, "inboundIpRules", p.InboundIPRules)
	populate(objectMap, "partnerRegistrationFullyQualifiedId", p.PartnerRegistrationFullyQualifiedID)
	populate(objectMap, "partnerTopicRoutingMode", p.PartnerTopicRoutingMode)
	populate(objectMap, "privateEndpointConnections", p.PrivateEndpointConnections)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", p.PublicNetworkAccess)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PartnerNamespaceUpdateParameterProperties.
func (p PartnerNamespaceUpdateParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "disableLocalAuth", p.DisableLocalAuth)
	populate(objectMap, "inboundIpRules", p.InboundIPRules)
	populate(objectMap, "publicNetworkAccess", p.PublicNetworkAccess)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PartnerNamespaceUpdateParameters.
func (p PartnerNamespaceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PartnerRegistration.
func (p PartnerRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PartnerRegistrationUpdateParameters.
func (p PartnerRegistrationUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PartnerTopic.
func (p PartnerTopic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "identity", p.Identity)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PartnerTopicProperties.
func (p PartnerTopicProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "activationState", p.ActivationState)
	populate(objectMap, "eventTypeInfo", p.EventTypeInfo)
	populateTimeRFC3339(objectMap, "expirationTimeIfNotActivatedUtc", p.ExpirationTimeIfNotActivatedUTC)
	populate(objectMap, "messageForActivation", p.MessageForActivation)
	populate(objectMap, "partnerRegistrationImmutableId", p.PartnerRegistrationImmutableID)
	populate(objectMap, "partnerTopicFriendlyDescription", p.PartnerTopicFriendlyDescription)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "source", p.Source)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PartnerTopicProperties.
func (p *PartnerTopicProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activationState":
			err = unpopulate(val, "ActivationState", &p.ActivationState)
			delete(rawMsg, key)
		case "eventTypeInfo":
			err = unpopulate(val, "EventTypeInfo", &p.EventTypeInfo)
			delete(rawMsg, key)
		case "expirationTimeIfNotActivatedUtc":
			err = unpopulateTimeRFC3339(val, "ExpirationTimeIfNotActivatedUTC", &p.ExpirationTimeIfNotActivatedUTC)
			delete(rawMsg, key)
		case "messageForActivation":
			err = unpopulate(val, "MessageForActivation", &p.MessageForActivation)
			delete(rawMsg, key)
		case "partnerRegistrationImmutableId":
			err = unpopulate(val, "PartnerRegistrationImmutableID", &p.PartnerRegistrationImmutableID)
			delete(rawMsg, key)
		case "partnerTopicFriendlyDescription":
			err = unpopulate(val, "PartnerTopicFriendlyDescription", &p.PartnerTopicFriendlyDescription)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &p.Source)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PartnerTopicUpdateParameters.
func (p PartnerTopicUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", p.Identity)
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionProperties.
func (p PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "groupIds", p.GroupIDs)
	populate(objectMap, "privateEndpoint", p.PrivateEndpoint)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusQueueEventSubscriptionDestination.
func (s ServiceBusQueueEventSubscriptionDestination) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["endpointType"] = EndpointTypeServiceBusQueue
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBusQueueEventSubscriptionDestination.
func (s *ServiceBusQueueEventSubscriptionDestination) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpointType":
			err = unpopulate(val, "EndpointType", &s.EndpointType)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusQueueEventSubscriptionDestinationProperties.
func (s ServiceBusQueueEventSubscriptionDestinationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deliveryAttributeMappings", s.DeliveryAttributeMappings)
	populate(objectMap, "resourceId", s.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBusQueueEventSubscriptionDestinationProperties.
func (s *ServiceBusQueueEventSubscriptionDestinationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deliveryAttributeMappings":
			s.DeliveryAttributeMappings, err = unmarshalDeliveryAttributeMappingClassificationArray(val)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &s.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusTopicEventSubscriptionDestination.
func (s ServiceBusTopicEventSubscriptionDestination) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["endpointType"] = EndpointTypeServiceBusTopic
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBusTopicEventSubscriptionDestination.
func (s *ServiceBusTopicEventSubscriptionDestination) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpointType":
			err = unpopulate(val, "EndpointType", &s.EndpointType)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceBusTopicEventSubscriptionDestinationProperties.
func (s ServiceBusTopicEventSubscriptionDestinationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "deliveryAttributeMappings", s.DeliveryAttributeMappings)
	populate(objectMap, "resourceId", s.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceBusTopicEventSubscriptionDestinationProperties.
func (s *ServiceBusTopicEventSubscriptionDestinationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deliveryAttributeMappings":
			s.DeliveryAttributeMappings, err = unmarshalDeliveryAttributeMappingClassificationArray(val)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &s.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StaticDeliveryAttributeMapping.
func (s StaticDeliveryAttributeMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	objectMap["type"] = DeliveryAttributeMappingTypeStatic
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticDeliveryAttributeMapping.
func (s *StaticDeliveryAttributeMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageBlobDeadLetterDestination.
func (s StorageBlobDeadLetterDestination) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["endpointType"] = DeadLetterEndPointTypeStorageBlob
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageBlobDeadLetterDestination.
func (s *StorageBlobDeadLetterDestination) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpointType":
			err = unpopulate(val, "EndpointType", &s.EndpointType)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageQueueEventSubscriptionDestination.
func (s StorageQueueEventSubscriptionDestination) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["endpointType"] = EndpointTypeStorageQueue
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageQueueEventSubscriptionDestination.
func (s *StorageQueueEventSubscriptionDestination) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpointType":
			err = unpopulate(val, "EndpointType", &s.EndpointType)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StringBeginsWithAdvancedFilter.
func (s StringBeginsWithAdvancedFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "key", s.Key)
	objectMap["operatorType"] = AdvancedFilterOperatorTypeStringBeginsWith
	populate(objectMap, "values", s.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StringBeginsWithAdvancedFilter.
func (s *StringBeginsWithAdvancedFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &s.Key)
			delete(rawMsg, key)
		case "operatorType":
			err = unpopulate(val, "OperatorType", &s.OperatorType)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &s.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StringContainsAdvancedFilter.
func (s StringContainsAdvancedFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "key", s.Key)
	objectMap["operatorType"] = AdvancedFilterOperatorTypeStringContains
	populate(objectMap, "values", s.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StringContainsAdvancedFilter.
func (s *StringContainsAdvancedFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &s.Key)
			delete(rawMsg, key)
		case "operatorType":
			err = unpopulate(val, "OperatorType", &s.OperatorType)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &s.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StringEndsWithAdvancedFilter.
func (s StringEndsWithAdvancedFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "key", s.Key)
	objectMap["operatorType"] = AdvancedFilterOperatorTypeStringEndsWith
	populate(objectMap, "values", s.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StringEndsWithAdvancedFilter.
func (s *StringEndsWithAdvancedFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &s.Key)
			delete(rawMsg, key)
		case "operatorType":
			err = unpopulate(val, "OperatorType", &s.OperatorType)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &s.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StringInAdvancedFilter.
func (s StringInAdvancedFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "key", s.Key)
	objectMap["operatorType"] = AdvancedFilterOperatorTypeStringIn
	populate(objectMap, "values", s.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StringInAdvancedFilter.
func (s *StringInAdvancedFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &s.Key)
			delete(rawMsg, key)
		case "operatorType":
			err = unpopulate(val, "OperatorType", &s.OperatorType)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &s.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StringNotBeginsWithAdvancedFilter.
func (s StringNotBeginsWithAdvancedFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "key", s.Key)
	objectMap["operatorType"] = AdvancedFilterOperatorTypeStringNotBeginsWith
	populate(objectMap, "values", s.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StringNotBeginsWithAdvancedFilter.
func (s *StringNotBeginsWithAdvancedFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &s.Key)
			delete(rawMsg, key)
		case "operatorType":
			err = unpopulate(val, "OperatorType", &s.OperatorType)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &s.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StringNotContainsAdvancedFilter.
func (s StringNotContainsAdvancedFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "key", s.Key)
	objectMap["operatorType"] = AdvancedFilterOperatorTypeStringNotContains
	populate(objectMap, "values", s.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StringNotContainsAdvancedFilter.
func (s *StringNotContainsAdvancedFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &s.Key)
			delete(rawMsg, key)
		case "operatorType":
			err = unpopulate(val, "OperatorType", &s.OperatorType)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &s.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StringNotEndsWithAdvancedFilter.
func (s StringNotEndsWithAdvancedFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "key", s.Key)
	objectMap["operatorType"] = AdvancedFilterOperatorTypeStringNotEndsWith
	populate(objectMap, "values", s.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StringNotEndsWithAdvancedFilter.
func (s *StringNotEndsWithAdvancedFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &s.Key)
			delete(rawMsg, key)
		case "operatorType":
			err = unpopulate(val, "OperatorType", &s.OperatorType)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &s.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StringNotInAdvancedFilter.
func (s StringNotInAdvancedFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "key", s.Key)
	objectMap["operatorType"] = AdvancedFilterOperatorTypeStringNotIn
	populate(objectMap, "values", s.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StringNotInAdvancedFilter.
func (s *StringNotInAdvancedFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &s.Key)
			delete(rawMsg, key)
		case "operatorType":
			err = unpopulate(val, "OperatorType", &s.OperatorType)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &s.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemTopic.
func (s SystemTopic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SystemTopicUpdateParameters.
func (s SystemTopicUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Topic.
func (t Topic) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "identity", t.Identity)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TopicProperties.
func (t TopicProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataResidencyBoundary", t.DataResidencyBoundary)
	populate(objectMap, "disableLocalAuth", t.DisableLocalAuth)
	populate(objectMap, "endpoint", t.Endpoint)
	populate(objectMap, "inboundIpRules", t.InboundIPRules)
	populate(objectMap, "inputSchema", t.InputSchema)
	populate(objectMap, "inputSchemaMapping", t.InputSchemaMapping)
	populate(objectMap, "metricResourceId", t.MetricResourceID)
	populate(objectMap, "privateEndpointConnections", t.PrivateEndpointConnections)
	populate(objectMap, "provisioningState", t.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", t.PublicNetworkAccess)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TopicProperties.
func (t *TopicProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataResidencyBoundary":
			err = unpopulate(val, "DataResidencyBoundary", &t.DataResidencyBoundary)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &t.DisableLocalAuth)
			delete(rawMsg, key)
		case "endpoint":
			err = unpopulate(val, "Endpoint", &t.Endpoint)
			delete(rawMsg, key)
		case "inboundIpRules":
			err = unpopulate(val, "InboundIPRules", &t.InboundIPRules)
			delete(rawMsg, key)
		case "inputSchema":
			err = unpopulate(val, "InputSchema", &t.InputSchema)
			delete(rawMsg, key)
		case "inputSchemaMapping":
			t.InputSchemaMapping, err = unmarshalInputSchemaMappingClassification(val)
			delete(rawMsg, key)
		case "metricResourceId":
			err = unpopulate(val, "MetricResourceID", &t.MetricResourceID)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &t.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &t.ProvisioningState)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &t.PublicNetworkAccess)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TopicTypeProperties.
func (t TopicTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "description", t.Description)
	populate(objectMap, "displayName", t.DisplayName)
	populate(objectMap, "provider", t.Provider)
	populate(objectMap, "provisioningState", t.ProvisioningState)
	populate(objectMap, "resourceRegionType", t.ResourceRegionType)
	populate(objectMap, "sourceResourceFormat", t.SourceResourceFormat)
	populate(objectMap, "supportedLocations", t.SupportedLocations)
	populate(objectMap, "supportedScopesForSource", t.SupportedScopesForSource)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TopicUpdateParameterProperties.
func (t TopicUpdateParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dataResidencyBoundary", t.DataResidencyBoundary)
	populate(objectMap, "disableLocalAuth", t.DisableLocalAuth)
	populate(objectMap, "inboundIpRules", t.InboundIPRules)
	populate(objectMap, "publicNetworkAccess", t.PublicNetworkAccess)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TopicUpdateParameters.
func (t TopicUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "identity", t.Identity)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type WebHookEventSubscriptionDestination.
func (w WebHookEventSubscriptionDestination) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["endpointType"] = EndpointTypeWebHook
	populate(objectMap, "properties", w.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebHookEventSubscriptionDestination.
func (w *WebHookEventSubscriptionDestination) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpointType":
			err = unpopulate(val, "EndpointType", &w.EndpointType)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebHookEventSubscriptionDestinationProperties.
func (w WebHookEventSubscriptionDestinationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "azureActiveDirectoryApplicationIdOrUri", w.AzureActiveDirectoryApplicationIDOrURI)
	populate(objectMap, "azureActiveDirectoryTenantId", w.AzureActiveDirectoryTenantID)
	populate(objectMap, "deliveryAttributeMappings", w.DeliveryAttributeMappings)
	populate(objectMap, "endpointBaseUrl", w.EndpointBaseURL)
	populate(objectMap, "endpointUrl", w.EndpointURL)
	populate(objectMap, "maxEventsPerBatch", w.MaxEventsPerBatch)
	populate(objectMap, "preferredBatchSizeInKilobytes", w.PreferredBatchSizeInKilobytes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebHookEventSubscriptionDestinationProperties.
func (w *WebHookEventSubscriptionDestinationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureActiveDirectoryApplicationIdOrUri":
			err = unpopulate(val, "AzureActiveDirectoryApplicationIDOrURI", &w.AzureActiveDirectoryApplicationIDOrURI)
			delete(rawMsg, key)
		case "azureActiveDirectoryTenantId":
			err = unpopulate(val, "AzureActiveDirectoryTenantID", &w.AzureActiveDirectoryTenantID)
			delete(rawMsg, key)
		case "deliveryAttributeMappings":
			w.DeliveryAttributeMappings, err = unmarshalDeliveryAttributeMappingClassificationArray(val)
			delete(rawMsg, key)
		case "endpointBaseUrl":
			err = unpopulate(val, "EndpointBaseURL", &w.EndpointBaseURL)
			delete(rawMsg, key)
		case "endpointUrl":
			err = unpopulate(val, "EndpointURL", &w.EndpointURL)
			delete(rawMsg, key)
		case "maxEventsPerBatch":
			err = unpopulate(val, "MaxEventsPerBatch", &w.MaxEventsPerBatch)
			delete(rawMsg, key)
		case "preferredBatchSizeInKilobytes":
			err = unpopulate(val, "PreferredBatchSizeInKilobytes", &w.PreferredBatchSizeInKilobytes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
