/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.datamodel.AlignmentI;
import jalview.schemes.Blosum62ColourScheme;
import jalview.schemes.BuriedColourScheme;
import jalview.schemes.ClustalxColourScheme;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.HelixColourScheme;
import jalview.schemes.HydrophobicColourScheme;
import jalview.schemes.NucleotideColourScheme;
import jalview.schemes.PIDColourScheme;
import jalview.schemes.ResidueColourScheme;
import jalview.schemes.StrandColourScheme;
import jalview.schemes.TaylorColourScheme;
import jalview.schemes.TurnColourScheme;
import jalview.schemes.UserColourScheme;
import jalview.schemes.ZappoColourScheme;
import java.awt.Color;
import java.util.Vector;

public class ColourSchemeProperty {
    public static final int CLUSTAL = 0;
    public static final int BLOSUM = 1;
    public static final int PID = 2;
    public static final int ZAPPO = 3;
    public static final int TAYLOR = 4;
    public static final int HYDROPHOBIC = 5;
    public static final int HELIX = 6;
    public static final int STRAND = 7;
    public static final int TURN = 8;
    public static final int BURIED = 9;
    public static final int NUCLEOTIDE = 10;
    public static final int USER_DEFINED = 11;
    public static final int NONE = 12;
    public static final int UNDEFINED = 13;

    public static int getColourIndexFromName(String name) {
        int ret = 13;
        if (name.equalsIgnoreCase("Clustal")) {
            ret = 0;
        } else if (name.equalsIgnoreCase("Blosum62")) {
            ret = 1;
        } else if (name.equalsIgnoreCase("% Identity")) {
            ret = 2;
        } else if (name.equalsIgnoreCase("Zappo")) {
            ret = 3;
        } else if (name.equalsIgnoreCase("Taylor")) {
            ret = 4;
        } else if (name.equalsIgnoreCase("Hydrophobic")) {
            ret = 5;
        } else if (name.equalsIgnoreCase("Helix Propensity")) {
            ret = 6;
        } else if (name.equalsIgnoreCase("Strand Propensity")) {
            ret = 7;
        } else if (name.equalsIgnoreCase("Turn Propensity")) {
            ret = 8;
        } else if (name.equalsIgnoreCase("Buried Index")) {
            ret = 9;
        } else if (name.equalsIgnoreCase("Nucleotide")) {
            ret = 10;
        } else if (name.equalsIgnoreCase("User Defined")) {
            ret = 11;
        } else if (name.equalsIgnoreCase("None")) {
            ret = 12;
        }
        return ret;
    }

    public static String getColourName(ColourSchemeI cs) {
        int index = 12;
        if (cs instanceof ClustalxColourScheme) {
            index = 0;
        } else if (cs instanceof Blosum62ColourScheme) {
            index = 1;
        } else if (cs instanceof PIDColourScheme) {
            index = 2;
        } else if (cs instanceof ZappoColourScheme) {
            index = 3;
        } else if (cs instanceof TaylorColourScheme) {
            index = 4;
        } else if (cs instanceof HydrophobicColourScheme) {
            index = 5;
        } else if (cs instanceof HelixColourScheme) {
            index = 6;
        } else if (cs instanceof StrandColourScheme) {
            index = 7;
        } else if (cs instanceof TurnColourScheme) {
            index = 8;
        } else if (cs instanceof BuriedColourScheme) {
            index = 9;
        } else if (cs instanceof NucleotideColourScheme) {
            index = 10;
        } else if (cs instanceof UserColourScheme) {
            if (((UserColourScheme)cs).getName() != null && ((UserColourScheme)cs).getName().length() > 0) {
                return ((UserColourScheme)cs).getName();
            }
            index = 11;
        }
        return ColourSchemeProperty.getColourName(index);
    }

    public static String getColourName(int index) {
        String ret = null;
        switch (index) {
            case 0: {
                ret = "Clustal";
                break;
            }
            case 1: {
                ret = "Blosum62";
                break;
            }
            case 2: {
                ret = "% Identity";
                break;
            }
            case 3: {
                ret = "Zappo";
                break;
            }
            case 4: {
                ret = "Taylor";
                break;
            }
            case 5: {
                ret = "Hydrophobic";
                break;
            }
            case 6: {
                ret = "Helix Propensity";
                break;
            }
            case 7: {
                ret = "Strand Propensity";
                break;
            }
            case 8: {
                ret = "Turn Propensity";
                break;
            }
            case 9: {
                ret = "Buried Index";
                break;
            }
            case 10: {
                ret = "Nucleotide";
                break;
            }
            case 11: {
                ret = "User Defined";
                break;
            }
            default: {
                ret = "None";
            }
        }
        return ret;
    }

    public static ColourSchemeI getColour(AlignmentI al, String name) {
        return ColourSchemeProperty.getColour(al.getSequences(), al.getWidth(), name);
    }

    public static ColourSchemeI getColour(Vector seqs, int width, String name) {
        int colindex = ColourSchemeProperty.getColourIndexFromName(name);
        if (colindex == 13) {
            try {
                return new UserColourScheme(name);
            }
            catch (Exception e) {
                try {
                    UserColourScheme ucs = new UserColourScheme("white");
                    ucs.parseAppletParameter(name);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
        }
        return ColourSchemeProperty.getColour(seqs, width, ColourSchemeProperty.getColourIndexFromName(name));
    }

    public static ColourSchemeI getColour(Vector seqs, int width, int index) {
        ResidueColourScheme cs = null;
        switch (index) {
            case 0: {
                cs = new ClustalxColourScheme(seqs, width);
                break;
            }
            case 1: {
                cs = new Blosum62ColourScheme();
                break;
            }
            case 2: {
                cs = new PIDColourScheme();
                break;
            }
            case 3: {
                cs = new ZappoColourScheme();
                break;
            }
            case 4: {
                cs = new TaylorColourScheme();
                break;
            }
            case 5: {
                cs = new HydrophobicColourScheme();
                break;
            }
            case 6: {
                cs = new HelixColourScheme();
                break;
            }
            case 7: {
                cs = new StrandColourScheme();
                break;
            }
            case 8: {
                cs = new TurnColourScheme();
                break;
            }
            case 9: {
                cs = new BuriedColourScheme();
                break;
            }
            case 10: {
                cs = new NucleotideColourScheme();
                break;
            }
            case 11: {
                Color[] col = new Color[24];
                for (int i = 0; i < 24; ++i) {
                    col[i] = Color.white;
                }
                cs = new UserColourScheme(col);
                break;
            }
        }
        return cs;
    }

    public static Color getAWTColorFromName(String name) {
        Color col = null;
        if ((name = name.toLowerCase()).equals("black")) {
            col = Color.black;
        } else if (name.equals("blue")) {
            col = Color.blue;
        } else if (name.equals("cyan")) {
            col = Color.cyan;
        } else if (name.equals("darkGray")) {
            col = Color.darkGray;
        } else if (name.equals("gray")) {
            col = Color.gray;
        } else if (name.equals("green")) {
            col = Color.green;
        } else if (name.equals("lightGray")) {
            col = Color.lightGray;
        } else if (name.equals("magenta")) {
            col = Color.magenta;
        } else if (name.equals("orange")) {
            col = Color.orange;
        } else if (name.equals("pink")) {
            col = Color.pink;
        } else if (name.equals("red")) {
            col = Color.red;
        } else if (name.equals("white")) {
            col = Color.white;
        } else if (name.equals("yellow")) {
            col = Color.yellow;
        }
        return col;
    }
}

