// $Id: EditView.cxx 900 2009-08-13 20:00:45Z larry $
//
// module EditView.cxx - part of DRAWxtl V5.5
// Coded using the FLTK 1.1.6 widget set
//
//     Larry W. Finger, Martin Kroeker and Brian Toby
//
// initial version generated by Fast Light User Interface Designer (fluid) version 1.0104
//
// routines contained within this file:
//
// EditScreen::EditScreen - constructor
// EditScreen::show - routine to display the screen

#include "EditView.h"

EditScreen::EditScreen ()
{
    static int one = 1;

    static int zero = 0;

    int y, y1;

    {
	Fl_Window *o = editWindow =
	    new Fl_Window (0, 0, 480, 440, "DRAWxtl V5.5 Parameter Edit");
	o->selection_color ((Fl_Color) 128);
	o->callback ((Fl_Callback *) Edit_Parmeters_Close_cb);
	o->labelfont (1);
	o->labelsize (49);
	o->labelcolor ((Fl_Color) 1);
	o->user_data ((void *) (this));
	o->align (FL_ALIGN_TOP | FL_ALIGN_INSIDE);
	o->when (FL_WHEN_CHANGED);
	y = 50;
	{
	    Fl_Text_Display *o =
		new Fl_Text_Display (180, y, 120, 0, "DRAWxtl V5.5 Parameter Edit");
	    o->selection_color ((Fl_Color) 1);
	    o->labelsize (26);
	    o->textcolor (1);
	}
	y1 = y += 30;
	{
	    Draw_Fl_Input *o = Magnification =
		new Draw_Fl_Input (30, y, 70, 25, "Magnification");
	    o->align (FL_ALIGN_RIGHT);
	    o->when (FL_WHEN_CHANGED);
	}
	y += 30;
	{
	    Draw_Fl_Input *o = List =
		new Draw_Fl_Input (30, y, 70, 25, "Max.Bond Distance");
	    o->align (FL_ALIGN_RIGHT);
	    o->when (FL_WHEN_CHANGED);
	}
	y += 30;
	{
	    Draw_Fl_Input *o = DepthCue = new Draw_Fl_Input (30, y, 70, 25, "Depth Cue");

	    o->align (FL_ALIGN_RIGHT);
	    o->when (FL_WHEN_CHANGED);
	}
	y += 30;
	{
	    Flu_Combo_List *o = Background_Color =
		new Flu_Combo_List (30, y, 100, 25, "Backgr. Color");
	    o->align (FL_ALIGN_RIGHT);
	}
	y += 30;
	{
	    Draw_Fl_Input *o = Mol_Comp_Dist =
		new Draw_Fl_Input (30, y, 70, 25, "Mol. Compl. Dist.");
	    o->align (FL_ALIGN_RIGHT);
	}
	{
	    Draw_Fl_Input *o = Cell_Edge_Width =
		new Draw_Fl_Input (240, y1, 70, 25, "Unit-Cell Edge Width");
	    o->align (FL_ALIGN_RIGHT);
	}
	y1 += 40;
	{
	    Fl_Text_Display *o =
		new Fl_Text_Display (195, y1, 270, 0, "0 for NO Unit-cell box");
	    o->labelfont (1);
	}
	y1 += 0;
	{
	    Flu_Combo_List *o = Cell_Edge_Color =
		new Flu_Combo_List (240, y1, 120, 25, "Edge Color");
	    o->align (FL_ALIGN_RIGHT);
	}
	y1 += 30;
	{
	    Draw_Fl_Input *o = Poly_Limit =
		new Draw_Fl_Input (240, y1, 70, 25, "Polyhedral Tolerance");
	    o->align (FL_ALIGN_RIGHT);
	}
	y1 += 30;
	{
	    Draw_Fl_Input *o = Phong_Refl =
		new Draw_Fl_Input (240, y1, 70, 25, "Phong Reflectivity (0 - 1)");
	    o->align (FL_ALIGN_RIGHT);
	}
	y1 += 30;
	{
	    Draw_Fl_Input *o = Phong_Size =
		new Draw_Fl_Input (240, y1, 70, 25, "Phong Size (10-150)");
	    o->align (FL_ALIGN_RIGHT);
	}
	y1 += 30;
	{
	    Draw_Fl_Input *o = Ambient_Finish =
		new Draw_Fl_Input (240, y1, 70, 25, "Ambient Finish");
	    o->align (FL_ALIGN_RIGHT);
	}
	y1 += 30;
	{
	    Draw_Fl_Input *o = Diffuse_Finish =
		new Draw_Fl_Input (240, y1, 70, 25, "Diffuse Finish");
	    o->align (FL_ALIGN_RIGHT);
	}
	y1 += 30;
	{
	    Draw_Fl_Input *o = Specular_Finish =
		new Draw_Fl_Input (240, y1, 70, 25, "Specular Finish");
	    o->align (FL_ALIGN_RIGHT);
	}
	y1 += 30;
	{
	    Draw_Fl_Input *o = Finish_Roughness =
		new Draw_Fl_Input (240, y1, 70, 25, "Surface Roughness");
	    o->align (FL_ALIGN_RIGHT);
	}

	y += 25;
	{
	    MolCompButton =
		new Fl_Check_Button (30, y, 185, 25, "Use Molecular Completion");
	}
	y += 25;
	NoShadow = new Fl_Check_Button (30, y, 195, 25, "Set for No Shadows in POV");
	y += 25;
	NoLabels = new Fl_Check_Button (30, y, 165, 25, "Set for No Cell Labels");
	y += 25;
	Label_Scale = new Draw_Fl_Input (30, y, 70, 25, "Label Scaling");
	Label_Scale->align (FL_ALIGN_RIGHT);
	y += 25;
	{
	    ClearOmit = new Fl_Check_Button (30, y, 145, 25, "Clear 'Omit' Lists");
	}
	y += 25;
	{
	    ClearLastOmit = new Fl_Button (30, y, 180, 30, "Remove Last Omit Item");
	    ClearLastOmit->callback ((Fl_Callback *) Clear_Last_Omit_cb);
	}
	y1 += 60;
	{
	    Fl_Button *o = Edit_Prm_Close = new Fl_Button (50, y1, 80, 30, "Close");

	    o->callback ((Fl_Callback *) Edit_Parmeters_Close_cb);
	    o->tooltip ("Close this window and discard all changes.");
	}
	{
	    Fl_Button *o = Edit_Prm_Apply = new Fl_Button (150, y1, 80, 30, "Apply");

	    o->tooltip
		("Apply current contents of top box to drawing, but leave this window open.");
	    o->callback ((Fl_Callback *) Edit_Parmeters_Save_cb, &zero);
	}
	{
	    Fl_Button *o = Edit_Prm_Save = new Fl_Button (250, y1, 80, 30, "Save");

	    o->tooltip
		("Apply current contents of top box to drawing, then close this window.");
	    o->callback ((Fl_Callback *) Edit_Parmeters_Save_cb, &one);
	}
	{
	    Fl_Button *o = Edit_View_Help = new Fl_Button (350, y1, 80, 30, "Help");

	    o->callback ((Fl_Callback *) Input_Help_cb);
	}
    }
}

void
EditScreen::show (void)
{
    editWindow->show ();
}
