<?php

return CRM_Core_CodeGen_SqlData::create('civicrm_membership_status')
  ->addDefaults([
    'is_active' => 1,
    'is_default' => 0,
    'is_admin' => 0,
  ])
  ->addValues([
    [
      'name' => 'New',
      'label' => ts('New'),
      'start_event' => 'join_date',
      'start_event_adjust_unit' => NULL,
      'start_event_adjust_interval' => NULL,
      'end_event' => 'join_date',
      'end_event_adjust_unit' => 'month',
      'end_event_adjust_interval' => 3,
      'is_current_member' => 1,
      'weight' => 1,
      'is_reserved' => 0,
    ],
    [
      'name' => 'Current',
      'label' => ts('Current'),
      'start_event' => 'start_date',
      'start_event_adjust_unit' => NULL,
      'start_event_adjust_interval' => NULL,
      'end_event' => 'end_date',
      'end_event_adjust_unit' => NULL,
      'end_event_adjust_interval' => NULL,
      'is_current_member' => 1,
      'weight' => 2,
      'is_default' => 1,
      'is_reserved' => 0,
    ],
    [
      'name' => 'Grace',
      'label' => ts('Grace'),
      'start_event' => 'end_date',
      'start_event_adjust_unit' => NULL,
      'start_event_adjust_interval' => NULL,
      'end_event' => 'end_date',
      'end_event_adjust_unit' => 'month',
      'end_event_adjust_interval' => 1,
      'is_current_member' => 1,
      'weight' => 3,
      'is_reserved' => 0,
    ],
    [
      'name' => 'Expired',
      'label' => ts('Expired'),
      'start_event' => 'end_date',
      'start_event_adjust_unit' => 'month',
      'start_event_adjust_interval' => 1,
      'end_event' => NULL,
      'end_event_adjust_unit' => NULL,
      'end_event_adjust_interval' => NULL,
      'is_current_member' => 0,
      'weight' => 4,
      'is_reserved' => 0,
    ],
    [
      'name' => 'Pending',
      'label' => ts('Pending'),
      'start_event' => 'join_date',
      'start_event_adjust_unit' => NULL,
      'start_event_adjust_interval' => NULL,
      'end_event' => 'join_date',
      'end_event_adjust_unit' => NULL,
      'end_event_adjust_interval' => NULL,
      'is_current_member' => 0,
      'weight' => 5,
      'is_reserved' => 1,
    ],
    [
      'name' => 'Cancelled',
      'label' => ts('Cancelled'),
      'start_event' => 'join_date',
      'start_event_adjust_unit' => NULL,
      'start_event_adjust_interval' => NULL,
      'end_event' => 'join_date',
      'end_event_adjust_unit' => NULL,
      'end_event_adjust_interval' => NULL,
      'is_current_member' => 0,
      'weight' => 6,
      'is_reserved' => 1,
    ],
    [
      'name' => 'Deceased',
      'label' => ts('Deceased'),
      'start_event' => NULL,
      'start_event_adjust_unit' => NULL,
      'start_event_adjust_interval' => NULL,
      'end_event' => NULL,
      'end_event_adjust_unit' => NULL,
      'end_event_adjust_interval' => NULL,
      'is_current_member' => 0,
      'is_admin' => 1,
      'weight' => 7,
      'is_reserved' => 1,
    ],
  ]);
