/**
 * \file
 * \brief BitField accessors for analog_rx_mem_map
 *
 * Autogenerated with yoda-gen 1.2.0. Do not modify
 *
 * \copyright Copyright (c) 2020 Analog Devices, Inc. All Rights Reserved.
 * This software is proprietary to Analog Devices, Inc. and its licensors.
 */

 #ifndef __ADRV9001_BF_ANALOG_RX_MEM_MAP_H__
 #define __ADRV9001_BF_ANALOG_RX_MEM_MAP_H__

#include "adrv9001_bf_hal.h"

typedef enum adrv9001_BfAnalogRxMemMap_e
{
    ADRV9001_BF_RX1_ANA    =   0x3000,
    ADRV9001_BF_RX2_ANA    =   0x3400
} adrv9001_BfAnalogRxMemMap_e;

static const adrv9001_BfAnalogRxMemMap_e analogRxMemMapInstances[] = {
    ADRV9001_BF_RX1_ANA,
    ADRV9001_BF_RX2_ANA
};

static inline int32_t adrv9001_AnalogRxMemMap_AuxLoHighR_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7c), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_AuxLoHighR_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_AuxLoLdoBypass_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x86), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_AuxLoLdoBypass_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x86), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_AuxLoLdoFilterBypass_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x87), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_AuxLoLdoFilterBypass_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x87), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_AuxLoLdoPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x86), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_AuxLoLdoPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x86), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


static inline int32_t adrv9001_AnalogRxMemMap_AuxLoLdoStatus_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x86), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_AuxLoLdoVoutSel_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x86), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_AuxLoLdoVoutSel_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x86), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_AuxLoLdoVoutTrim_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x87), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_AuxLoLdoVoutTrim_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x87), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_CalToneDriverAttn_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x83 + 0x0 + (regInstance * 0x1)), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_CalToneDriverAttn_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x83 + 0x0 + (regInstance * 0x1)), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_CalToneDriverInbufPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x83 + 0x0 + (regInstance * 0x1)), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_CalToneDriverInbufPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x83 + 0x0 + (regInstance * 0x1)), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_CalToneDriverPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x83 + 0x0 + (regInstance * 0x1)), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_CalToneDriverPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x83 + 0x0 + (regInstance * 0x1)), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_EnRxattenInputCm_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2a + 0x0 + (regInstance * 0x1)), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_EnRxattenInputCm_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2a + 0x0 + (regInstance * 0x1)), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_EnableAuxLoSource_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x79), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_EnableAuxLoSource_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x79), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_EnableLoSourceLb1_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x79), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_EnableLoSourceLb1_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x79), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_EnableLoSourceLb2_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x79), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_EnableLoSourceLb2_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x79), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_EnableTxLoSource_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x79), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_EnableTxLoSource_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x79), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_IdistBypassBiasRes_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_IdistBypassBiasRes_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1Attn_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x33), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1Attn_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x33), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1AttnB_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x33), (value >> 0), 0x38, 0x3);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1AttnB_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x33), &register_value, 0x38, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1LoDelayCoarseCorrI_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x65), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1LoDelayCoarseCorrI_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x65), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1LoDelayCoarseCorrIb_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x66), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1LoDelayCoarseCorrIb_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x66), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1LoDelayCoarseCorrQ_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x65), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1LoDelayCoarseCorrQ_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x65), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1LoDelayCoarseCorrQb_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x66), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1LoDelayCoarseCorrQb_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x66), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1LoDelayCorrPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x67), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1LoDelayCorrPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x67), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1LoDelayDacBiasResBypass_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x67), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1LoDelayDacBiasResBypass_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x67), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1LoDelayDacRes_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x67), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1LoDelayDacRes_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x67), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1LoDelayFineCorrDac_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x62), (value >> 3));
    if (0 != status) return status;

    status = adi_bf_hal_Field_Write(device, (instance + 0x64), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1LoDelayFineCorrDac_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x62), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (instance + 0x64), &register_value, 0x7, 0x0);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1LoDelayFineCorrDacB_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x63), (value >> 3));
    if (0 != status) return status;

    status = adi_bf_hal_Field_Write(device, (instance + 0x64), (value >> 0), 0x38, 0x3);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1LoDelayFineCorrDacB_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x63), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (instance + 0x64), &register_value, 0x38, 0x3);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Toggling this bit latches the ORx1 LO delay correction DAC word.
 */
static inline int32_t adrv9001_AnalogRxMemMap_Lb1LoDelayLatchEn_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x64), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Toggling this bit latches the ORx1 LO delay correction DAC word.
 */
static inline int32_t adrv9001_AnalogRxMemMap_Lb1LoDelayLatchEn_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x64), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1MixerConfig_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x32), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1MixerConfig_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x32), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1feLocm_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2f), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1feLocm_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2f), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1feLocmB_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x38), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1feLocmB_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x38), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1fePd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1fePd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1fePdOverride_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1fePdOverride_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1fePdOverrideSelect_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1fePdOverrideSelect_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1fecap_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x30), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1fecap_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x30), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1fecapB_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x31), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Lb1fecapB_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x31), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable override for each filter stage in loopback filter for ch1. Setting each bit high will force the corresponding filter stage to be enabled (bit 0 for stage1, bit 1 for stage2, bit 2 for stage3, bit 3 for stage4). For debug only.
 */
static inline int32_t adrv9001_AnalogRxMemMap_LoopbackFilter1StageForceEn_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x81), (value >> 0), 0xf, 0x0);

    return status;
}

/**
 * Enable override for each filter stage in loopback filter for ch1. Setting each bit high will force the corresponding filter stage to be enabled (bit 0 for stage1, bit 1 for stage2, bit 2 for stage3, bit 3 for stage4). For debug only.
 */
static inline int32_t adrv9001_AnalogRxMemMap_LoopbackFilter1StageForceEn_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x81), &register_value, 0xf, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit is used to set up Tx CH1 LO leakage calibration mode. By setting this bit, TX LO leakage calibration runs in differential mode, when this bit is cleared calibration is run in common-mode.
 */
static inline int32_t adrv9001_AnalogRxMemMap_LoopbackFilterDiffCh1_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x82), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * This bit is used to set up Tx CH1 LO leakage calibration mode. By setting this bit, TX LO leakage calibration runs in differential mode, when this bit is cleared calibration is run in common-mode.
 */
static inline int32_t adrv9001_AnalogRxMemMap_LoopbackFilterDiffCh1_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x82), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits control the Tx1 loopback and CalPLL injection point according the following: Function 00 --  Tx switch open (not looped-back) no CalPLL injection 01 --  Tx switch closed (loopback Tx into loopback receiver) 10 --  Tx switch open, inject CalPLL signal into Rx loopback FE 11 --  Tx switch open, inject CalPLL signal into Rx FE
 */
static inline int32_t adrv9001_AnalogRxMemMap_LoopbackSwCh1_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x80), (value >> 0), 0x3, 0x0);

    return status;
}

/**
 * These bits control the Tx1 loopback and CalPLL injection point according the following: Function 00 --  Tx switch open (not looped-back) no CalPLL injection 01 --  Tx switch closed (loopback Tx into loopback receiver) 10 --  Tx switch open, inject CalPLL signal into Rx loopback FE 11 --  Tx switch open, inject CalPLL signal into Rx FE
 */
static inline int32_t adrv9001_AnalogRxMemMap_LoopbackSwCh1_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x80), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1Force1p0vAttn_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x17), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1Force1p0vAttn_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x17), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1ForceEnableOverrideLo_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1ForceEnableOverrideLo_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1ForceMaxAttn_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1ForceMaxAttn_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1HiLoResEn_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x19), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1HiLoResEn_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x19), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1HiLoResEnB_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1a), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1HiLoResEnB_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1a), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1LoDelayCoarseCorrI_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x59), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1LoDelayCoarseCorrI_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x59), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1LoDelayCoarseCorrIb_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5a), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1LoDelayCoarseCorrIb_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5a), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1LoDelayCoarseCorrQ_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x59), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1LoDelayCoarseCorrQ_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x59), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1LoDelayCoarseCorrQb_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5a), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1LoDelayCoarseCorrQb_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5a), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1LoDelayCorrPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5b), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1LoDelayCorrPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5b), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1LoDelayDacBiasResBypass_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5b), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1LoDelayDacBiasResBypass_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5b), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1LoDelayDacRes_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5b), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1LoDelayDacRes_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5b), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1LoDelayFineCorrDac_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x56), (value >> 3));
    if (0 != status) return status;

    status = adi_bf_hal_Field_Write(device, (instance + 0x58), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1LoDelayFineCorrDac_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x56), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (instance + 0x58), &register_value, 0x7, 0x0);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1LoDelayFineCorrDacB_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x57), (value >> 3));
    if (0 != status) return status;

    status = adi_bf_hal_Field_Write(device, (instance + 0x58), (value >> 0), 0x38, 0x3);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1LoDelayFineCorrDacB_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x57), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (instance + 0x58), &register_value, 0x38, 0x3);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Toggling this bit latches the ORx1 LO delay correction DAC word.
 */
static inline int32_t adrv9001_AnalogRxMemMap_Orx1LoDelayLatchEn_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x58), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Toggling this bit latches the ORx1 LO delay correction DAC word.
 */
static inline int32_t adrv9001_AnalogRxMemMap_Orx1LoDelayLatchEn_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x58), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1MixerConfig_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1MixerConfig_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1Sel1p8vSupply_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x18), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1Sel1p8vSupply_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x18), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1SelAttenRshuntWord_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x14), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1SelAttenRshuntWord_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x14), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1feLocm_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x12), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1feLocm_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x12), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1feLocmB_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2d), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1feLocmB_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2d), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1feLodcPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1feLodcPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1fePd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1fePd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1fePdOverride_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1fePdOverride_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1fePdOverrideSelect_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1fePdOverrideSelect_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1feRbbDisable_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x13), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1feRbbDisable_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x13), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1fecap_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x15), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1fecap_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x15), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1fecapB_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x16), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx1fecapB_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x16), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2Force1p0vAttn_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x20), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2Force1p0vAttn_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x20), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2ForceEnableOverrideLo_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2ForceEnableOverrideLo_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2ForceMaxAttn_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2ForceMaxAttn_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2HiLoResEn_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x22), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2HiLoResEn_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x22), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2HiLoResEnB_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x23), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2HiLoResEnB_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x23), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2LoDelayCoarseCorrI_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5f), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2LoDelayCoarseCorrI_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5f), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2LoDelayCoarseCorrIb_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x60), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2LoDelayCoarseCorrIb_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x60), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2LoDelayCoarseCorrQ_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5f), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2LoDelayCoarseCorrQ_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5f), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2LoDelayCoarseCorrQb_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x60), (value >> 0), 0x70, 0x4);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2LoDelayCoarseCorrQb_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x60), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2LoDelayCorrPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x61), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2LoDelayCorrPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x61), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2LoDelayDacBiasResBypass_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x61), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2LoDelayDacBiasResBypass_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x61), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2LoDelayDacRes_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x61), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2LoDelayDacRes_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x61), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2LoDelayFineCorrDac_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x5c), (value >> 3));
    if (0 != status) return status;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5e), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2LoDelayFineCorrDac_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5c), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5e), &register_value, 0x7, 0x0);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2LoDelayFineCorrDacB_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x5d), (value >> 3));
    if (0 != status) return status;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5e), (value >> 0), 0x38, 0x3);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2LoDelayFineCorrDacB_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x5d), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5e), &register_value, 0x38, 0x3);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Toggling this bit latches the ORx1 LO delay correction DAC word.
 */
static inline int32_t adrv9001_AnalogRxMemMap_Orx2LoDelayLatchEn_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5e), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Toggling this bit latches the ORx1 LO delay correction DAC word.
 */
static inline int32_t adrv9001_AnalogRxMemMap_Orx2LoDelayLatchEn_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5e), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2MixerConfig_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0xf0, 0x4);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2MixerConfig_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0xf0, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2Sel1p8vSupply_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x21), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2Sel1p8vSupply_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x21), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2SelAttenRshuntWord_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1d), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2SelAttenRshuntWord_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1d), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2feLocm_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1b), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2feLocm_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1b), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2feLocmB_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2e), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2feLocmB_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2e), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2feLodcPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2feLodcPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2fePd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2fePd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2fePdOverride_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2fePdOverride_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2fePdOverrideSelect_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2fePdOverrideSelect_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2feRbbDisable_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1c), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2feRbbDisable_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1c), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2fecap_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1e), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2fecap_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1e), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2fecapB_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1f), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_Orx2fecapB_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1f), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxAttnCalSig_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x24 + 0x0 + (regInstance * 0x1)), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxAttnCalSig_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x24 + 0x0 + (regInstance * 0x1)), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxBlockDetDecay_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x68), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxBlockDetDecay_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x68), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxBlockDetLlbth_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x69 + 0x0 + (regInstance * 0x1)), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxBlockDetLlbth_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x69 + 0x0 + (regInstance * 0x1)), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxBlockDetUlbth_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x70 + 0x0 + (regInstance * 0x1)), (value >> 0), 0x3f, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxBlockDetUlbth_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x70 + 0x0 + (regInstance * 0x1)), &register_value, 0x3f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxBlockdetPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxBlockdetPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting each bit enables the power down override for the corresponding ORx blocker detection circuit in 0x204[D5:D4]. Bit D5 applies to ORx2 and bit D4 applies to ORx1.
 */
static inline int32_t adrv9001_AnalogRxMemMap_OrxBlockdetPdOverride_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Setting each bit enables the power down override for the corresponding ORx blocker detection circuit in 0x204[D5:D4]. Bit D5 applies to ORx2 and bit D4 applies to ORx1.
 */
static inline int32_t adrv9001_AnalogRxMemMap_OrxBlockdetPdOverride_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting each bit enables the power down override for the corresponding ORx blocker detection circuit in 0x204[D5:D4]. Bit D5 applies to ORx2 and bit D4 applies to ORx1.
 */
static inline int32_t adrv9001_AnalogRxMemMap_OrxBlockdetPdOverrideSelect_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Setting each bit enables the power down override for the corresponding ORx blocker detection circuit in 0x204[D5:D4]. Bit D5 applies to ORx2 and bit D4 applies to ORx1.
 */
static inline int32_t adrv9001_AnalogRxMemMap_OrxBlockdetPdOverrideSelect_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxCalSigPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x24 + 0x0 + (regInstance * 0x1)), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxCalSigPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x24 + 0x0 + (regInstance * 0x1)), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxOsdacPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxOsdacPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit powers down the ADC. Clearing this bit enables the ADC.
 */
static inline int32_t adrv9001_AnalogRxMemMap_OrxOsdacPdOverride_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Setting this bit powers down the ADC. Clearing this bit enables the ADC.
 */
static inline int32_t adrv9001_AnalogRxMemMap_OrxOsdacPdOverride_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit powers down the ADC. Clearing this bit enables the ADC.
 */
static inline int32_t adrv9001_AnalogRxMemMap_OrxOsdacPdOverrideSelect_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Setting this bit powers down the ADC. Clearing this bit enables the ADC.
 */
static inline int32_t adrv9001_AnalogRxMemMap_OrxOsdacPdOverrideSelect_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Used force update of the mode control bits.
 */
static inline int32_t adrv9001_AnalogRxMemMap_OrxTiaForceUpdate_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x55), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Used force update of the mode control bits.
 */
static inline int32_t adrv9001_AnalogRxMemMap_OrxTiaForceUpdate_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x55), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Configures rxtia tuner in analog to directly output pll clock to TIA.
 */
static inline int32_t adrv9001_AnalogRxMemMap_OrxTiaModeDirect_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x55), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Configures rxtia tuner in analog to directly output pll clock to TIA.
 */
static inline int32_t adrv9001_AnalogRxMemMap_OrxTiaModeDirect_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x55), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Configures rxtia tuner in analog to ouput pll cloclk to TIA divided by 16.
 */
static inline int32_t adrv9001_AnalogRxMemMap_OrxTiaModeDirectDiv16_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x55), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Configures rxtia tuner in analog to ouput pll cloclk to TIA divided by 16.
 */
static inline int32_t adrv9001_AnalogRxMemMap_OrxTiaModeDirectDiv16_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x55), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable lfsr mode and route output to TIA
 */
static inline int32_t adrv9001_AnalogRxMemMap_OrxTiaModeLfsr_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x55), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * Enable lfsr mode and route output to TIA
 */
static inline int32_t adrv9001_AnalogRxMemMap_OrxTiaModeLfsr_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x55), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * This bit is used in mode_wr. 0=program divider, 1= program lfsr.
 */
static inline int32_t adrv9001_AnalogRxMemMap_OrxTiaModeLfsrTapSeedb_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x55), (value >> 0), 0x20, 0x5);

    return status;
}

/**
 * This bit is used in mode_wr. 0=program divider, 1= program lfsr.
 */
static inline int32_t adrv9001_AnalogRxMemMap_OrxTiaModeLfsrTapSeedb_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x55), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Enable Tia tuner in analog to output clock in divider mode to TIA.
 */
static inline int32_t adrv9001_AnalogRxMemMap_OrxTiaModeSeq_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x55), (value >> 0), 0x10, 0x4);

    return status;
}

/**
 * Enable Tia tuner in analog to output clock in divider mode to TIA.
 */
static inline int32_t adrv9001_AnalogRxMemMap_OrxTiaModeSeq_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x55), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxmixerILogenOvlpCtrl_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x26 + 0x0 + (regInstance * 0x1)), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxmixerILogenOvlpCtrl_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x26 + 0x0 + (regInstance * 0x1)), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxmixerQLogenOvlpCtrl_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x28 + 0x0 + (regInstance * 0x1)), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxmixerQLogenOvlpCtrl_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x28 + 0x0 + (regInstance * 0x1)), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxtiaBypBiasR_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3a), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxtiaBypBiasR_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3a), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxtiaIbiasCntrlStg1_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3a), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxtiaIbiasCntrlStg1_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3a), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxtiaIbiasCntrlStg2_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3a), (value >> 0), 0x38, 0x3);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxtiaIbiasCntrlStg2_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3a), &register_value, 0x38, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxtiaPdTiaDelaySpiOvrd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x54), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxtiaPdTiaDelaySpiOvrd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x54), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxtiaPowCntrlStg1_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3b + 0x0 + (regInstance * 0x1)), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxtiaPowCntrlStg1_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3b + 0x0 + (regInstance * 0x1)), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxtiaPowCntrlStg2_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3b + 0x0 + (regInstance * 0x1)), (value >> 0), 0x38, 0x3);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxtiaPowCntrlStg2_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3b + 0x0 + (regInstance * 0x1)), &register_value, 0x38, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxtiaSpiPdVcmgenOvrd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x54), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxtiaSpiPdVcmgenOvrd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x54), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Used to reset rxtia_tuner.  Write a 0 followed by a 1.
 */
static inline int32_t adrv9001_AnalogRxMemMap_OrxtiaTunerResetb_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x39), (value >> 0), 0x1, 0x0);

    return status;
}

/**
 * Used to reset rxtia_tuner.  Write a 0 followed by a 1.
 */
static inline int32_t adrv9001_AnalogRxMemMap_OrxtiaTunerResetb_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x39), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxtiaVcmgenOutlevel_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x54), (value >> 0), 0x6, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_OrxtiaVcmgenOutlevel_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x54), &register_value, 0x6, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdBbAmuxOrx1Tx1lb_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2c), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdBbAmuxOrx1Tx1lb_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2c), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdBbAmuxOrx2Tx2lb_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2c), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdBbAmuxOrx2Tx2lb_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdIDist_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xb), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdIDist_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xb), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdLb1LodelayBuffer_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdLb1LodelayBuffer_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdLb1LodelayBufferOverride_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdLb1LodelayBufferOverride_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdLb1LodelayBufferOverrideSelect_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdLb1LodelayBufferOverrideSelect_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdLb1MixerCapdac_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xc), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdLb1MixerCapdac_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xc), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdLb1MixerCapdacOverride_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xe), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdLb1MixerCapdacOverride_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xe), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdLb1MixerCapdacOverrideSelect_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xd), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdLb1MixerCapdacOverrideSelect_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xd), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx1LodelayBuffer_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx1LodelayBuffer_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx1LodelayBufferOverride_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx1LodelayBufferOverride_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx1LodelayBufferOverrideSelect_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx1LodelayBufferOverrideSelect_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx1MixerCapdac_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x3), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx1MixerCapdac_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x3), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx1MixerCapdacOverride_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x5), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx1MixerCapdacOverride_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x5), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx1MixerCapdacOverrideSelect_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x4), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx1MixerCapdacOverrideSelect_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x4), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx2LodelayBuffer_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx2LodelayBuffer_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx2LodelayBufferOverride_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx2LodelayBufferOverride_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx2LodelayBufferOverrideSelect_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx2LodelayBufferOverrideSelect_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx2MixerCapdac_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x6), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx2MixerCapdac_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x6), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx2MixerCapdacOverride_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx2MixerCapdacOverride_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx2MixerCapdacOverrideSelect_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdOrx2MixerCapdacOverrideSelect_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting this bit forces the output stage of the Rx1 loopback filter to loopback mixer to be powered down. This bit is for debug only.
 */
static inline int32_t adrv9001_AnalogRxMemMap_PdOverrideOutRx1Loopback_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7e), (value >> 0), 0x80, 0x7);

    return status;
}

/**
 * Setting this bit forces the output stage of the Rx1 loopback filter to loopback mixer to be powered down. This bit is for debug only.
 */
static inline int32_t adrv9001_AnalogRxMemMap_PdOverrideOutRx1Loopback_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7e), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdTuneDac_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x94 + 0x0 + (regInstance * 0x1)), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_PdTuneDac_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x94 + 0x0 + (regInstance * 0x1)), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RfLoHighR_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7c), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RfLoHighR_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7c), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits scale the bias current for the Rx1 loopback filter buffers according to the following settings. These bits are for debug only. 00 --  X0.8 01 --  X1.0 10 --  X1.3 11 --  X2.0
 */
static inline int32_t adrv9001_AnalogRxMemMap_Rx1LoopbackFilterBiasConfig_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7e), (value >> 0), 0xc, 0x2);

    return status;
}

/**
 * These bits scale the bias current for the Rx1 loopback filter buffers according to the following settings. These bits are for debug only. 00 --  X0.8 01 --  X1.0 10 --  X1.3 11 --  X2.0
 */
static inline int32_t adrv9001_AnalogRxMemMap_Rx1LoopbackFilterBiasConfig_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7e), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set the Rx1 loopback filter's high pas pole. The following settings show possible high pass pole frequencies. These bits are for debug only. 000 --  15.9 MHz 001 --  31.8 MHz 010 --  63.7 MHz 100 --  127.3 MHz 111 --  238.7 MHz
 */
static inline int32_t adrv9001_AnalogRxMemMap_Rx1LoopbackFilterRgate_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7e), (value >> 0), 0x70, 0x4);

    return status;
}

/**
 * These bits set the Rx1 loopback filter's high pas pole. The following settings show possible high pass pole frequencies. These bits are for debug only. 000 --  15.9 MHz 001 --  31.8 MHz 010 --  63.7 MHz 100 --  127.3 MHz 111 --  238.7 MHz
 */
static inline int32_t adrv9001_AnalogRxMemMap_Rx1LoopbackFilterRgate_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7e), &register_value, 0x70, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * These bits set the Rx1 loopback filter's high pas pole. The following settings show possible high pass pole frequencies. These bits are for debug only. 000 --  15.9 MHz 001 --  31.8 MHz 010 --  63.7 MHz 100 --  127.3 MHz 111 --  238.7 MHz
 */
static inline int32_t adrv9001_AnalogRxMemMap_Rx1PdLoopbackFilterOverride_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x80), (value >> 0), 0x8, 0x3);

    return status;
}

/**
 * These bits set the Rx1 loopback filter's high pas pole. The following settings show possible high pass pole frequencies. These bits are for debug only. 000 --  15.9 MHz 001 --  31.8 MHz 010 --  63.7 MHz 100 --  127.3 MHz 111 --  238.7 MHz
 */
static inline int32_t adrv9001_AnalogRxMemMap_Rx1PdLoopbackFilterOverride_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x80), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxAuxLoBufPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x88), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxAuxLoBufPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x88), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxAuxloRTerm_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x88), (value >> 0), 0xc, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxAuxloRTerm_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x88), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxCalToneAuxloInbufPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxCalToneAuxloInbufPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxCalToneOutbufPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxCalToneOutbufPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxCalToneRxloInbufPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxCalToneRxloInbufPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxCalToneSelAuxLo_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x9), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxCalToneSelAuxLo_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x9), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxEnAuxloTerm_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x88), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxEnAuxloTerm_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x88), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxLoHighR_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7c), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxLoHighR_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7c), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxLoLineRTerm_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa), (value >> 0), 0x3, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxLoLineRTerm_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxLoLineRcvBufPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxLoLineRcvBufPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxLoLineTermBiasPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxLoLineTermBiasPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxLoLineTermEnable_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xa), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxLoLineTermEnable_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xa), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxMixAuxloInbufPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x11), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxMixAuxloInbufPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x11), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxMixLoOutbufPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x11), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxMixLoOutbufPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x11), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxMixLoSelAuxLo_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x11), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxMixLoSelAuxLo_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x11), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxMixRxloInbufPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x11), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxMixRxloInbufPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x11), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxPdAuxloTermBias_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x88), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxPdAuxloTermBias_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x88), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxSpare1_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0xff), (value >> 0));

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxSpare1_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0xff), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxSpare2_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Register_Write(device, (instance + 0x100), (value >> 0));

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxSpare2_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Register_Read(device, (instance + 0x100), &register_value);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxtiaBbinjAmpCtrl_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xed), (value >> 0), 0x7, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxtiaBbinjAmpCtrl_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xed), &register_value, 0x7, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxtiaBbinjPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xed), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxtiaBbinjPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xed), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxtiaBbinjSelchop_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xed), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxtiaBbinjSelchop_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xed), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxtiaBbinjStdby_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xed), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxtiaBbinjStdby_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xed), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * I and Q get the same capacitor setting for Fc.
 */
static inline int32_t adrv9001_AnalogRxMemMap_RxtiaC1_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8e + 0x0 + (regInstance * 0x1)), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x89 + 0x0 + (regInstance * 0x1)), (value >> 0));

    return status;
}

/**
 * I and Q get the same capacitor setting for Fc.
 */
static inline int32_t adrv9001_AnalogRxMemMap_RxtiaC1_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8e + 0x0 + (regInstance * 0x1)), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x89 + 0x0 + (regInstance * 0x1)), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting for fine capacitor tuning for QEC (for C1)
 */
static inline int32_t adrv9001_AnalogRxMemMap_RxtiaC1Fine_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x94 + 0x0 + (regInstance * 0x1)), (value >> 8), 0x30, 0x4);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x92 + 0x0 + (regInstance * 0x1)), (value >> 0));

    return status;
}

/**
 * Setting for fine capacitor tuning for QEC (for C1)
 */
static inline int32_t adrv9001_AnalogRxMemMap_RxtiaC1Fine_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x94 + 0x0 + (regInstance * 0x1)), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x92 + 0x0 + (regInstance * 0x1)), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * For BIQ setting, set according to Fc (BIQ)
 */
static inline int32_t adrv9001_AnalogRxMemMap_RxtiaC2_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8e + 0x0 + (regInstance * 0x1)), (value >> 8), 0xc, 0x2);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x8a + 0x0 + (regInstance * 0x1)), (value >> 0));

    return status;
}

/**
 * For BIQ setting, set according to Fc (BIQ)
 */
static inline int32_t adrv9001_AnalogRxMemMap_RxtiaC2_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8e + 0x0 + (regInstance * 0x1)), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8a + 0x0 + (regInstance * 0x1)), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting for fine capacitor tuning for QEC (for C2)
 */
static inline int32_t adrv9001_AnalogRxMemMap_RxtiaC2Fine_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x94 + 0x0 + (regInstance * 0x1)), (value >> 8), 0xc0, 0x6);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x93 + 0x0 + (regInstance * 0x1)), (value >> 0));

    return status;
}

/**
 * Setting for fine capacitor tuning for QEC (for C2)
 */
static inline int32_t adrv9001_AnalogRxMemMap_RxtiaC2Fine_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x94 + 0x0 + (regInstance * 0x1)), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x93 + 0x0 + (regInstance * 0x1)), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Select between TIA or Biquad
 */
static inline int32_t adrv9001_AnalogRxMemMap_RxtiaMode_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x94 + 0x0 + (regInstance * 0x1)), (value >> 0), 0x2, 0x1);

    return status;
}

/**
 * Select between TIA or Biquad
 */
static inline int32_t adrv9001_AnalogRxMemMap_RxtiaMode_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x94 + 0x0 + (regInstance * 0x1)), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Set input resistor for integrator stage for Biquad
 */
static inline int32_t adrv9001_AnalogRxMemMap_RxtiaR2_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8e + 0x0 + (regInstance * 0x1)), (value >> 8), 0x30, 0x4);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x8b + 0x0 + (regInstance * 0x1)), (value >> 0));

    return status;
}

/**
 * Set input resistor for integrator stage for Biquad
 */
static inline int32_t adrv9001_AnalogRxMemMap_RxtiaR2_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8e + 0x0 + (regInstance * 0x1)), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8b + 0x0 + (regInstance * 0x1)), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Set leaky integrator reiststor of Biquad
 */
static inline int32_t adrv9001_AnalogRxMemMap_RxtiaR3_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8e + 0x0 + (regInstance * 0x1)), (value >> 8), 0xc0, 0x6);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x8c + 0x0 + (regInstance * 0x1)), (value >> 0));

    return status;
}

/**
 * Set leaky integrator reiststor of Biquad
 */
static inline int32_t adrv9001_AnalogRxMemMap_RxtiaR3_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8e + 0x0 + (regInstance * 0x1)), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8c + 0x0 + (regInstance * 0x1)), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Sets feedback resistor value in TIA.
 */
static inline int32_t adrv9001_AnalogRxMemMap_RxtiaR4_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x8f + 0x0 + (regInstance * 0x1)), (value >> 8), 0xc0, 0x6);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x8d + 0x0 + (regInstance * 0x1)), (value >> 0));

    return status;
}

/**
 * Sets feedback resistor value in TIA.
 */
static inline int32_t adrv9001_AnalogRxMemMap_RxtiaR4_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x8f + 0x0 + (regInstance * 0x1)), &register_value, 0xc0, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x8d + 0x0 + (regInstance * 0x1)), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxtiaSelccStg1_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x90 + 0x0 + (regInstance * 0x1)), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxtiaSelccStg1_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x90 + 0x0 + (regInstance * 0x1)), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxtiaSelccStg2_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x91 + 0x0 + (regInstance * 0x1)), (value >> 0), 0x1f, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxtiaSelccStg2_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x91 + 0x0 + (regInstance * 0x1)), &register_value, 0x1f, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxtiaSelrzStg1_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x90 + 0x0 + (regInstance * 0x1)), (value >> 0), 0x60, 0x5);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxtiaSelrzStg1_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x90 + 0x0 + (regInstance * 0x1)), &register_value, 0x60, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxtiaSelrzStg2_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x91 + 0x0 + (regInstance * 0x1)), (value >> 0), 0x60, 0x5);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_RxtiaSelrzStg2_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x91 + 0x0 + (regInstance * 0x1)), &register_value, 0x60, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_SelRxattennVgateHi_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2a + 0x0 + (regInstance * 0x1)), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_SelRxattennVgateHi_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2a + 0x0 + (regInstance * 0x1)), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_SelbInjCal_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x24 + 0x0 + (regInstance * 0x1)), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_SelbInjCal_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x24 + 0x0 + (regInstance * 0x1)), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_SelectOrx1OrTx1lb_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2c), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_SelectOrx1OrTx1lb_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2c), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_SelectOrx2OrTx2lb_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2c), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_SelectOrx2OrTx2lb_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2c), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TiaPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x0), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TiaPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x0), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting each bit enables the power down override for the corresponding ORx TIA in 0x204[D7:D6]. Bit D7 applies to ORx2 and bit D6 applies to ORx1.
 */
static inline int32_t adrv9001_AnalogRxMemMap_TiaPdOverride_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Setting each bit enables the power down override for the corresponding ORx TIA in 0x204[D7:D6]. Bit D7 applies to ORx2 and bit D6 applies to ORx1.
 */
static inline int32_t adrv9001_AnalogRxMemMap_TiaPdOverride_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

/**
 * Setting each bit enables the power down override for the corresponding ORx TIA in 0x204[D7:D6]. Bit D7 applies to ORx2 and bit D6 applies to ORx1.
 */
static inline int32_t adrv9001_AnalogRxMemMap_TiaPdOverrideSelect_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x1), (value >> 0), 0x4, 0x2);

    return status;
}

/**
 * Setting each bit enables the power down override for the corresponding ORx TIA in 0x204[D7:D6]. Bit D7 applies to ORx2 and bit D6 applies to ORx1.
 */
static inline int32_t adrv9001_AnalogRxMemMap_TiaPdOverrideSelect_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x1), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TiaTunerClkDriverInbufPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TiaTunerClkDriverInbufPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TiaTunerClkDriverPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x10), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TiaTunerClkDriverPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x10), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TuneDacGm1_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x97 + 0x0 + (regInstance * 0x1)), (value >> 8), 0x3, 0x0);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x95 + 0x0 + (regInstance * 0x1)), (value >> 0));

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TuneDacGm1_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x97 + 0x0 + (regInstance * 0x1)), &register_value, 0x3, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x95 + 0x0 + (regInstance * 0x1)), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TuneDacGm2_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint16_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x97 + 0x0 + (regInstance * 0x1)), (value >> 8), 0xc, 0x2);
    if (0 != status) return status;

    status = adi_bf_hal_Register_Write(device, (instance + 0x96 + 0x0 + (regInstance * 0x1)), (value >> 0));

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TuneDacGm2_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint16_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x97 + 0x0 + (regInstance * 0x1)), &register_value, 0xc, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;
    if (0 != status) return status;

    status = adi_bf_hal_Register_Read(device, (instance + 0x96 + 0x0 + (regInstance * 0x1)), &register_value);
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TuneDacRes_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x97 + 0x0 + (regInstance * 0x1)), (value >> 0), 0x30, 0x4);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TuneDacRes_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x97 + 0x0 + (regInstance * 0x1)), &register_value, 0x30, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TxCalToneAuxloInbufPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x11), (value >> 0), 0x10, 0x4);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TxCalToneAuxloInbufPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x11), &register_value, 0x10, 0x4);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TxCalToneOutbufPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x11), (value >> 0), 0x20, 0x5);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TxCalToneOutbufPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x11), &register_value, 0x20, 0x5);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TxCalToneSelAuxLo_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x11), (value >> 0), 0x40, 0x6);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TxCalToneSelAuxLo_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x11), &register_value, 0x40, 0x6);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TxCalToneTxloInbufPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x11), (value >> 0), 0x80, 0x7);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TxCalToneTxloInbufPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x11), &register_value, 0x80, 0x7);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TxLbAuxloInbufPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf), (value >> 0), 0x1, 0x0);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TxLbAuxloInbufPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf), &register_value, 0x1, 0x0);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TxLbLoOutbufPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TxLbLoOutbufPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TxLbLoSelAuxLo_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf), (value >> 0), 0x4, 0x2);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TxLbLoSelAuxLo_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf), &register_value, 0x4, 0x2);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TxLbTxloInbufPd_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0xf), (value >> 0), 0x8, 0x3);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TxLbTxloInbufPd_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0xf), &register_value, 0x8, 0x3);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TxLoHighR_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x7c), (value >> 0), 0x2, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_TxLoHighR_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x7c), &register_value, 0x2, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_VhiGateCtrl_Set(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    const uint8_t value)
{
    int32_t status = 0;

    status = adi_bf_hal_Field_Write(device, (instance + 0x2a + 0x0 + (regInstance * 0x1)), (value >> 0), 0x3e, 0x1);

    return status;
}

static inline int32_t adrv9001_AnalogRxMemMap_VhiGateCtrl_Get(void *const device,
    adrv9001_BfAnalogRxMemMap_e instance,
    uint32_t regInstance,
    uint8_t *const value)
{
    int32_t status = 0;
    uint8_t register_value = 0;

    status = adi_bf_hal_Field_Read(device, (instance + 0x2a + 0x0 + (regInstance * 0x1)), &register_value, 0x3e, 0x1);
    *value = 0;
    *value = (*value << 8) | register_value;

    return status;
}


#endif // __ADRV9001_BF_ANALOG_RX_MEM_MAP_H__