//
// Created by uos on 2022/3/14.
//

#ifndef UOS_RECOVERY_MAINWINDOW_H
#define UOS_RECOVERY_MAINWINDOW_H

#include "interface/FrameProxyInterface.h"
#include "backup/BackupModule.h"
#include "restore/RestoreModule.h"
#include "advanced/AdvancedModule.h"
#include "common/BackupFileManagerDialog.h"
#include "common/SelectPartitionDialog.h"
#include "common/LogDialog.h"
#include <DMainWindow>
#include <DButtonBox>
#include <DStackedWidget>
#include <DFrame>
#include <DDialog>
#include <DBackgroundGroup>
#include <QStack>
#include <QMap>
#include <QStackedLayout>


DCORE_USE_NAMESPACE
DGUI_USE_NAMESPACE
DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class QHBoxLayout;
class QStandardItemModel;


class MainWindow : public DMainWindow , public FrameProxyInterface
{
    Q_OBJECT
public:
    explicit MainWindow(QWidget *parent = nullptr);
    ~MainWindow() override;
    void pushWidget(ModuleInterface *const inter, QWidget *const w) override;
    // 将窗口弹出出显示栈
    void popWidget() override;
    void popAllWidget() override;
    //将窗口弹出出显示栈并删除对象
    void popWidgetAndDelete() override;
    //显示上一步窗口
    void back() override;

    // 回退到主页
    void backHome() override;

    //返回按钮使能
    void enableBackWard(bool enable) override;
    //模块使能
    void enableModule(bool enable) override;
    // 设置模块可见
    void setModuleVisible(ModuleInterface *const inter, const bool visible) override;
    // 设置当前显示模块
    void setCurrentWidget(ModuleInterface *const inter, QWidget *const w) override;
    // 获取当前显示栈的索引
    ModuleInterface *getCurrentModule() override;

    void setMenuDisabled(bool disabled) override;
    void setQuitMenuDisabled(bool disabled) override;
    void setMenuActionEnabled(const QString &actionText, bool enabled) override;
    void setWindowFuncClose(bool enabled) override;

    void showSettingDialog() override;
    void showLogDialog() override;
    void showBackupFileManagerDialog() override;
    void ShowBackupPage();
    void ShowRestorePage();
    void ShowSystemClonePage();

protected:
    void closeEvent(QCloseEvent *event) override;

private Q_SLOTS:
    void initAllModule();
    void onModuleChange(QAbstractButton *button);
    void onBackWardClick();
    void onDestPartitionChange(const QJsonObject &jsonObject);
    void onError(const QString &msg);
    void onCheckSpace(const QString &space);
    void onNewProcessInstance();

private:
    ErrorCode initRecoveryType();
    void updateDestPartition();
    QString getErrorMsgByErrorCode(int errCode);

private:
    DGuiApplicationHelper *m_guiHelper = nullptr;
    LogDialog *m_logDialog = nullptr;
    BackupFileManagerDialog *m_backupFileManagerDialog = nullptr;
    DButtonBox *m_buttonBox = nullptr;
    DButtonBoxButton *m_backupBtn = nullptr;
    DButtonBoxButton *m_restoreBtn = nullptr;
    DButtonBoxButton *m_advancedBtn = nullptr;
    QHBoxLayout *m_centralLayout = nullptr;
    DIconButton *m_backwardBtn = nullptr;
    QStack<QPair<ModuleInterface *, QWidget *>> m_contentStack;
    QList<ModuleInterface*> m_modules;
    QStringList m_modulesLightIcons;
    QStringList m_modulesDarkIcons;
    BackupModule *m_backupModule = nullptr;
    RestoreModule *m_restoreModule = nullptr;
    AdvancedModule *m_advancedModule = nullptr;
    ComDeepinDaemonUosrecoveryInterface *m_interface = nullptr;
    SelectPartitionDialog *m_selectPartitionDialog = nullptr;
    QString m_currDestUUID;
    QJsonObject m_destPartitionJson;
    bool m_isCommunity = false;
    bool m_isDeepinBootKitExist = false;
    bool m_isGhostOnly = false;
    bool m_isSelinuxEnabled = false;
    bool m_isLVMOnly = false;
    bool m_isEncrypted = false;
    bool m_isDevice = false;
    bool m_isSupportSettings = false;
    bool m_isSupportV20BackupRestore = false;
    bool m_isFileMgrEncrypted = false;
    bool m_isImmutable = false;
    int m_osMajorVer = -1;
    int m_osMinorVer = -1;
};


#endif //UOS_RECOVERY_MAINWINDOW_H
