//
// Created by ut003822@uos on 2022/10/23.
//
#include "FSTabTest.h"
#include "utils/FsTab.h"
#include "utils/Device.h"

TEST_F(FSTabTest, all)
{
    QString fileName = "/etc/fstab";
#ifdef QT_DEBUG
    fileName = QString(TEST_DATA_DIR"fstab");
#endif

    FSTabInfoList fstabInfos = FSTab::getFSTabFromFile(fileName);
    EXPECT_FALSE(fstabInfos.isEmpty());
    for (auto &info : fstabInfos) {
        if (!info->isEmptyLine && !info->isComment && !info->options.contains("bind")) {
            QString uuid = FSTab::getDeviceUUID(info);
            EXPECT_FALSE(uuid.isEmpty());
        }
    }

    DevicePtr pDevice(new Device("/"));
    EXPECT_TRUE(FSTab::isSystemDirectory(pDevice->getDeviceInfo()->uuid, "/"));

}

TEST_F(FSTabTest, isUuidInFstab)
{
    QString fileName = "/etc/fstab";
    FSTabInfoList fstabList = FSTab::getFSTabFromFile(fileName);
    DeviceInfoList allDevList = Device::getDeviceByLsblk();
    DevicePtr pDevice(new Device("/"));
    QString rootUuid = pDevice->getDeviceInfo()->uuid;
    bool retCode = FSTab::isUuidInFstab(rootUuid, fstabList);
    EXPECT_TRUE(retCode);

    QString invalidUuid = rootUuid + "1";
    retCode = FSTab::isUuidInFstab(invalidUuid, fstabList);
    EXPECT_FALSE(retCode);
}
