/*
  Copyright(C) 2013-2015  Kouhei Sutou <kou@clear-code.com>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; version 2
  of the License.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
  MA 02110-1301, USA

  This file uses normalization table defined in
  mysql-5.6.23/strings/ctype-uca.c.
  The following is the header of the file:

    Copyright (c) 2004, 2014, Oracle and/or its affiliates. All rights reserved.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; version 2
    of the License.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
    MA 02110-1301, USA

    UCA (Unicode Collation Algorithm) support.
    Written by Alexander Barkov <bar@mysql.com>
*/

#ifndef MYSQL_UCA_520_H
#define MYSQL_UCA_520_H

#include <stdint.h>

static uint32_t unicode_520_ci_page_00[] = {
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00009, 0x0000a, 0x0000b, 0x0000c, 0x0000d, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00020, 0x00021, 0x00022, 0x00023, 0x00024, 0x00025, 0x00026, 0x00027,
  0x00028, 0x00029, 0x0002a, 0x0002b, 0x0002c, 0x0002d, 0x0002e, 0x0002f,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x0003a, 0x0003b, 0x0003c, 0x0003d, 0x0003e, 0x0003f,
  0x00040, 0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046, 0x00047,
  0x00048, 0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f,
  0x00050, 0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056, 0x00057,
  0x00058, 0x00059, 0x0005a, 0x0005b, 0x0005c, 0x0005d, 0x0005e, 0x0005f,
  0x00060, 0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046, 0x00047,
  0x00048, 0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f,
  0x00050, 0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056, 0x00057,
  0x00058, 0x00059, 0x0005a, 0x0007b, 0x0007c, 0x0007d, 0x0007e, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00085, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00020, 0x000a1, 0x000a2, 0x000a3, 0x000a4, 0x000a5, 0x000a6, 0x000a7,
  0x000a8, 0x000a9, 0x00041, 0x000ab, 0x000ac, 0x000ad, 0x000ae, 0x000af,
  0x000b0, 0x000b1, 0x00032, 0x00033, 0x000b4, 0x0039c, 0x000b6, 0x000b7,
  0x000b8, 0x00031, 0x0004f, 0x000bb, 0x000bc, 0x000bd, 0x000be, 0x000bf,
  0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x000c6, 0x00043,
  0x00045, 0x00045, 0x00045, 0x00045, 0x00049, 0x00049, 0x00049, 0x00049,
  0x00044, 0x0004e, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x000d7,
  0x0004f, 0x00055, 0x00055, 0x00055, 0x00055, 0x00059, 0x000de, 0x000df,
  0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x000c6, 0x00043,
  0x00045, 0x00045, 0x00045, 0x00045, 0x00049, 0x00049, 0x00049, 0x00049,
  0x00044, 0x0004e, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x000f7,
  0x0004f, 0x00055, 0x00055, 0x00055, 0x00055, 0x00059, 0x000fe, 0x000ff
};

static uint32_t unicode_520_ci_page_01[] = {
  0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00043, 0x00043,
  0x00043, 0x00043, 0x00043, 0x00043, 0x00043, 0x00043, 0x00044, 0x00044,
  0x00044, 0x00044, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045,
  0x00045, 0x00045, 0x00045, 0x00045, 0x00047, 0x00047, 0x00047, 0x00047,
  0x00047, 0x00047, 0x00047, 0x00047, 0x00048, 0x00048, 0x00048, 0x00048,
  0x00049, 0x00049, 0x00049, 0x00049, 0x00049, 0x00049, 0x00049, 0x00049,
  0x00049, 0x00131, 0x00132, 0x00132, 0x0004a, 0x0004a, 0x0004b, 0x0004b,
  0x00138, 0x0004c, 0x0004c, 0x0004c, 0x0004c, 0x0004c, 0x0004c, 0x0004c,
  0x0004c, 0x0004c, 0x0004c, 0x0004e, 0x0004e, 0x0004e, 0x0004e, 0x0004e,
  0x0004e, 0x00149, 0x0014a, 0x0014a, 0x0004f, 0x0004f, 0x0004f, 0x0004f,
  0x0004f, 0x0004f, 0x00152, 0x00152, 0x00052, 0x00052, 0x00052, 0x00052,
  0x00052, 0x00052, 0x00053, 0x00053, 0x00053, 0x00053, 0x00053, 0x00053,
  0x00053, 0x00053, 0x00054, 0x00054, 0x00054, 0x00054, 0x00166, 0x00166,
  0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055,
  0x00055, 0x00055, 0x00055, 0x00055, 0x00057, 0x00057, 0x00059, 0x00059,
  0x00059, 0x0005a, 0x0005a, 0x0005a, 0x0005a, 0x0005a, 0x0005a, 0x00053,
  0x00180, 0x00181, 0x00182, 0x00182, 0x00184, 0x00184, 0x00186, 0x00187,
  0x00187, 0x00189, 0x0018a, 0x0018b, 0x0018b, 0x0018d, 0x0018e, 0x0018f,
  0x00190, 0x00191, 0x00191, 0x00193, 0x00194, 0x00195, 0x00196, 0x00197,
  0x00198, 0x00198, 0x0019a, 0x0019b, 0x0019c, 0x0019d, 0x0019e, 0x0019f,
  0x0004f, 0x0004f, 0x001a2, 0x001a2, 0x001a4, 0x001a4, 0x001a6, 0x001a7,
  0x001a7, 0x001a9, 0x001aa, 0x001ab, 0x001ac, 0x001ac, 0x001ae, 0x00055,
  0x00055, 0x001b1, 0x001b2, 0x001b3, 0x001b3, 0x001b5, 0x001b5, 0x001b7,
  0x001b8, 0x001b8, 0x001ba, 0x001bb, 0x001bc, 0x001bc, 0x001be, 0x001bf,
  0x001c0, 0x001c1, 0x001c2, 0x001c3, 0x001c4, 0x001c4, 0x001c4, 0x001c7,
  0x001c7, 0x001c7, 0x001ca, 0x001ca, 0x001ca, 0x00041, 0x00041, 0x00049,
  0x00049, 0x0004f, 0x0004f, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055,
  0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x0018e, 0x00041, 0x00041,
  0x00041, 0x00041, 0x000c6, 0x000c6, 0x001e4, 0x001e4, 0x00047, 0x00047,
  0x0004b, 0x0004b, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x001b7, 0x001b7,
  0x0004a, 0x001c4, 0x001c4, 0x001c4, 0x00047, 0x00047, 0x00195, 0x001bf,
  0x0004e, 0x0004e, 0x00041, 0x00041, 0x000c6, 0x000c6, 0x0004f, 0x001ff
};

static uint32_t unicode_520_ci_page_02[] = {
  0x00041, 0x00041, 0x00041, 0x00041, 0x00045, 0x00045, 0x00045, 0x00045,
  0x00049, 0x00049, 0x00049, 0x00049, 0x0004f, 0x0004f, 0x0004f, 0x0004f,
  0x00052, 0x00052, 0x00052, 0x00052, 0x00055, 0x00055, 0x00055, 0x00055,
  0x00053, 0x00053, 0x00054, 0x00054, 0x0021c, 0x0021c, 0x00048, 0x00048,
  0x0019e, 0x00221, 0x00222, 0x00222, 0x00224, 0x00224, 0x00041, 0x00041,
  0x00045, 0x00045, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f,
  0x0004f, 0x0004f, 0x00059, 0x00059, 0x00234, 0x00235, 0x00236, 0x00237,
  0x00238, 0x00239, 0x0023a, 0x0023b, 0x0023b, 0x0019a, 0x0023e, 0x0023f,
  0x00240, 0x00241, 0x00241, 0x00180, 0x00244, 0x00245, 0x00246, 0x00246,
  0x00248, 0x00248, 0x0024a, 0x0024a, 0x0024c, 0x0024c, 0x0024e, 0x0024e,
  0x00250, 0x00251, 0x00252, 0x00181, 0x00186, 0x00255, 0x00189, 0x0018a,
  0x00258, 0x0018f, 0x0025a, 0x00190, 0x0025c, 0x0025d, 0x0025e, 0x0025f,
  0x00193, 0x00261, 0x00262, 0x00194, 0x00264, 0x00265, 0x00266, 0x00267,
  0x00197, 0x00196, 0x0026a, 0x0026b, 0x0026c, 0x0026d, 0x0026e, 0x0019c,
  0x00270, 0x00271, 0x0019d, 0x00273, 0x00274, 0x0019f, 0x00276, 0x00277,
  0x00278, 0x00279, 0x0027a, 0x0027b, 0x0027c, 0x0027d, 0x0027e, 0x0027f,
  0x001a6, 0x00281, 0x00282, 0x001a9, 0x00284, 0x00285, 0x00286, 0x00287,
  0x001ae, 0x00244, 0x001b1, 0x001b2, 0x00245, 0x0028d, 0x0028e, 0x0028f,
  0x00290, 0x00291, 0x001b7, 0x00293, 0x00294, 0x00295, 0x00296, 0x00297,
  0x00298, 0x00299, 0x0029a, 0x0029b, 0x0029c, 0x0029d, 0x0029e, 0x0029f,
  0x002a0, 0x002a1, 0x002a2, 0x001c4, 0x002a4, 0x002a5, 0x001be, 0x002a7,
  0x002a8, 0x002a9, 0x002aa, 0x002ab, 0x002ac, 0x002ad, 0x002ae, 0x002af,
  0x00048, 0x00266, 0x0004a, 0x00052, 0x00279, 0x0027b, 0x00281, 0x00057,
  0x00059, 0x002b9, 0x002ba, 0x002bb, 0x002bc, 0x002bd, 0x002be, 0x002bf,
  0x002c0, 0x002c1, 0x002c2, 0x002c3, 0x002c4, 0x002c5, 0x002c6, 0x002c7,
  0x002c8, 0x002c9, 0x002ca, 0x002cb, 0x002cc, 0x002cd, 0x002ce, 0x002cf,
  0x002d0, 0x002d1, 0x002d2, 0x002d3, 0x002d4, 0x002d5, 0x002d6, 0x002d7,
  0x002d8, 0x002d9, 0x002da, 0x002db, 0x002dc, 0x002dd, 0x002de, 0x002df,
  0x00194, 0x0004c, 0x00053, 0x00058, 0x00295, 0x002e5, 0x002e6, 0x002e7,
  0x002e8, 0x002e9, 0x002ea, 0x002eb, 0x002ec, 0x002ed, 0x002ee, 0x002ef,
  0x002f0, 0x002f1, 0x002f2, 0x002f3, 0x002f4, 0x002f5, 0x002f6, 0x002f7,
  0x002f8, 0x002f9, 0x002fa, 0x002fb, 0x002fc, 0x002fd, 0x002fe, 0x002ff
};

static uint32_t unicode_520_ci_page_03[] = {
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00041, 0x00045, 0x00049, 0x0004f, 0x00055,
  0x00043, 0x00044, 0x00048, 0x0004d, 0x00052, 0x00054, 0x00056, 0x00058,
  0x00370, 0x00370, 0x00372, 0x00372, 0x002b9, 0x00375, 0x00376, 0x00376,
  0x00378, 0x00379, 0x00399, 0x0037b, 0x0037c, 0x0037d, 0x0003b, 0x0037f,
  0x00380, 0x00381, 0x00382, 0x00383, 0x000b4, 0x000a8, 0x00391, 0x000b7,
  0x00395, 0x00397, 0x00399, 0x0038b, 0x0039f, 0x0038d, 0x003a5, 0x003a9,
  0x00399, 0x00391, 0x00392, 0x00393, 0x00394, 0x00395, 0x00396, 0x00397,
  0x00398, 0x00399, 0x0039a, 0x0039b, 0x0039c, 0x0039d, 0x0039e, 0x0039f,
  0x003a0, 0x003a1, 0x003a2, 0x003a3, 0x003a4, 0x003a5, 0x003a6, 0x003a7,
  0x003a8, 0x003a9, 0x00399, 0x003a5, 0x00391, 0x00395, 0x00397, 0x00399,
  0x003a5, 0x00391, 0x00392, 0x00393, 0x00394, 0x00395, 0x00396, 0x00397,
  0x00398, 0x00399, 0x0039a, 0x0039b, 0x0039c, 0x0039d, 0x0039e, 0x0039f,
  0x003a0, 0x003a1, 0x003a3, 0x003a3, 0x003a4, 0x003a5, 0x003a6, 0x003a7,
  0x003a8, 0x003a9, 0x00399, 0x003a5, 0x0039f, 0x003a5, 0x003a9, 0x003cf,
  0x00392, 0x00398, 0x003a5, 0x003a5, 0x003a5, 0x003a6, 0x003a0, 0x003cf,
  0x003d8, 0x003d8, 0x003da, 0x003da, 0x003dc, 0x003dc, 0x003de, 0x003de,
  0x003e0, 0x003e0, 0x003e2, 0x003e2, 0x003e4, 0x003e4, 0x003e6, 0x003e6,
  0x003e8, 0x003e8, 0x003ea, 0x003ea, 0x003ec, 0x003ec, 0x003ee, 0x003ee,
  0x0039a, 0x003a1, 0x003a3, 0x003f3, 0x00398, 0x00395, 0x003f6, 0x003f7,
  0x003f7, 0x003a3, 0x003fa, 0x003fa, 0x003fc, 0x0037b, 0x003fe, 0x003ff
};

static uint32_t unicode_520_ci_page_04[] = {
  0x00400, 0x00400, 0x00402, 0x00403, 0x00404, 0x00405, 0x00406, 0x00407,
  0x00408, 0x00409, 0x0040a, 0x0040b, 0x0040c, 0x0040d, 0x0040e, 0x0040f,
  0x00410, 0x00411, 0x00412, 0x00413, 0x00414, 0x00400, 0x00416, 0x00417,
  0x0040d, 0x00419, 0x0041a, 0x0041b, 0x0041c, 0x0041d, 0x0041e, 0x0041f,
  0x00420, 0x00421, 0x00422, 0x00423, 0x00424, 0x00425, 0x00426, 0x00427,
  0x00428, 0x00429, 0x0042a, 0x0042b, 0x0042c, 0x0042d, 0x0042e, 0x0042f,
  0x00410, 0x00411, 0x00412, 0x00413, 0x00414, 0x00400, 0x00416, 0x00417,
  0x0040d, 0x00419, 0x0041a, 0x0041b, 0x0041c, 0x0041d, 0x0041e, 0x0041f,
  0x00420, 0x00421, 0x00422, 0x00423, 0x00424, 0x00425, 0x00426, 0x00427,
  0x00428, 0x00429, 0x0042a, 0x0042b, 0x0042c, 0x0042d, 0x0042e, 0x0042f,
  0x00400, 0x00400, 0x00402, 0x00403, 0x00404, 0x00405, 0x00406, 0x00407,
  0x00408, 0x00409, 0x0040a, 0x0040b, 0x0040c, 0x0040d, 0x0040e, 0x0040f,
  0x00460, 0x00460, 0x00462, 0x00462, 0x00464, 0x00464, 0x00466, 0x00466,
  0x00468, 0x00468, 0x0046a, 0x0046a, 0x0046c, 0x0046c, 0x0046e, 0x0046e,
  0x00470, 0x00470, 0x00472, 0x00472, 0x00474, 0x00474, 0x00476, 0x00476,
  0x00478, 0x00478, 0x0047a, 0x0047a, 0x0047c, 0x0047c, 0x0047e, 0x0047e,
  0x00480, 0x00480, 0x00482, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x0048a, 0x0048a, 0x0048c, 0x0048c, 0x0048e, 0x0048e,
  0x00413, 0x00413, 0x00492, 0x00492, 0x00494, 0x00494, 0x00496, 0x00496,
  0x00498, 0x00498, 0x0049a, 0x0049a, 0x0049c, 0x0049c, 0x0049e, 0x0049e,
  0x004a0, 0x004a0, 0x004a2, 0x004a2, 0x004a4, 0x004a4, 0x004a6, 0x004a6,
  0x004a8, 0x004a8, 0x004aa, 0x004aa, 0x004ac, 0x004ac, 0x004ae, 0x004ae,
  0x004b0, 0x004b0, 0x004b2, 0x004b2, 0x004b4, 0x004b4, 0x004b6, 0x004b6,
  0x004b8, 0x004b8, 0x004ba, 0x004ba, 0x004bc, 0x004bc, 0x004be, 0x004be,
  0x004c0, 0x00416, 0x00416, 0x004c3, 0x004c3, 0x004c5, 0x004c5, 0x004c7,
  0x004c7, 0x004c9, 0x004c9, 0x004cb, 0x004cb, 0x004cd, 0x004cd, 0x004c0,
  0x004d0, 0x004d0, 0x004d2, 0x004d2, 0x004d4, 0x004d4, 0x004d6, 0x004d6,
  0x004d8, 0x004d8, 0x004da, 0x004da, 0x004dc, 0x004dc, 0x004de, 0x004de,
  0x004e0, 0x004e0, 0x0040d, 0x0040d, 0x004e4, 0x004e4, 0x004e6, 0x004e6,
  0x004e8, 0x004e8, 0x004ea, 0x004ea, 0x004ec, 0x004ec, 0x00423, 0x00423,
  0x004f0, 0x004f0, 0x004f2, 0x004f2, 0x004f4, 0x004f4, 0x004f6, 0x004f6,
  0x004f8, 0x004f8, 0x004fa, 0x004fa, 0x004fc, 0x004fd, 0x004fe, 0x004ff
};

static uint32_t unicode_520_ci_page_05[] = {
  0x00500, 0x00500, 0x00502, 0x00502, 0x00504, 0x00504, 0x00506, 0x00506,
  0x00508, 0x00508, 0x0050a, 0x0050a, 0x0050c, 0x0050c, 0x0050e, 0x0050e,
  0x00510, 0x00510, 0x00512, 0x00512, 0x00514, 0x00514, 0x00516, 0x00516,
  0x00518, 0x00518, 0x0051a, 0x0051a, 0x0051c, 0x0051c, 0x0051e, 0x0051e,
  0x00520, 0x00520, 0x00522, 0x00522, 0x00524, 0x00524, 0x00526, 0x00527,
  0x00528, 0x00529, 0x0052a, 0x0052b, 0x0052c, 0x0052d, 0x0052e, 0x0052f,
  0x00530, 0x00531, 0x00532, 0x00533, 0x00534, 0x00535, 0x00536, 0x00537,
  0x00538, 0x00539, 0x0053a, 0x0053b, 0x0053c, 0x0053d, 0x0053e, 0x0053f,
  0x00540, 0x00541, 0x00542, 0x00543, 0x00544, 0x00545, 0x00546, 0x00547,
  0x00548, 0x00549, 0x0054a, 0x0054b, 0x0054c, 0x0054d, 0x0054e, 0x0054f,
  0x00550, 0x00551, 0x00552, 0x00553, 0x00554, 0x00555, 0x00556, 0x00557,
  0x00558, 0x00559, 0x0055a, 0x0055b, 0x0055c, 0x0055d, 0x0055e, 0x0055f,
  0x00560, 0x00531, 0x00532, 0x00533, 0x00534, 0x00535, 0x00536, 0x00537,
  0x00538, 0x00539, 0x0053a, 0x0053b, 0x0053c, 0x0053d, 0x0053e, 0x0053f,
  0x00540, 0x00541, 0x00542, 0x00543, 0x00544, 0x00545, 0x00546, 0x00547,
  0x00548, 0x00549, 0x0054a, 0x0054b, 0x0054c, 0x0054d, 0x0054e, 0x0054f,
  0x00550, 0x00551, 0x00552, 0x00553, 0x00554, 0x00555, 0x00556, 0x00587,
  0x00588, 0x00589, 0x0058a, 0x0058b, 0x0058c, 0x0058d, 0x0058e, 0x0058f,
  0x00590, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x005be, 0x00000,
  0x005c0, 0x00000, 0x00000, 0x005c3, 0x00000, 0x00000, 0x005c6, 0x00000,
  0x005c8, 0x005c9, 0x005ca, 0x005cb, 0x005cc, 0x005cd, 0x005ce, 0x005cf,
  0x005d0, 0x005d1, 0x005d2, 0x005d3, 0x005d4, 0x005d5, 0x005d6, 0x005d7,
  0x005d8, 0x005d9, 0x005da, 0x005da, 0x005dc, 0x005dd, 0x005dd, 0x005df,
  0x005df, 0x005e1, 0x005e2, 0x005e3, 0x005e3, 0x005e5, 0x005e5, 0x005e7,
  0x005e8, 0x005e9, 0x005ea, 0x005eb, 0x005ec, 0x005ed, 0x005ee, 0x005ef,
  0x005f0, 0x005f1, 0x005f2, 0x005f3, 0x005f4, 0x005f5, 0x005f6, 0x005f7,
  0x005f8, 0x005f9, 0x005fa, 0x005fb, 0x005fc, 0x005fd, 0x005fe, 0x005ff
};

static uint32_t unicode_520_ci_page_06[] = {
  0x00000, 0x00000, 0x00000, 0x00000, 0x00604, 0x00605, 0x00606, 0x00607,
  0x00608, 0x00609, 0x0060a, 0x0060b, 0x0060c, 0x0060d, 0x0060e, 0x0060f,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x0061b, 0x0061c, 0x0061d, 0x0061e, 0x0061f,
  0x00620, 0x00621, 0x00622, 0x00623, 0x00624, 0x00625, 0x00626, 0x00627,
  0x00628, 0x00629, 0x0062a, 0x0062b, 0x0062c, 0x0062d, 0x0062e, 0x0062f,
  0x00630, 0x00631, 0x00632, 0x00633, 0x00634, 0x00635, 0x00636, 0x00637,
  0x00638, 0x00639, 0x0063a, 0x0063b, 0x0063c, 0x0063d, 0x0063e, 0x0063f,
  0x00640, 0x00641, 0x00642, 0x00643, 0x00644, 0x00645, 0x00646, 0x00647,
  0x00648, 0x00649, 0x0064a, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x0065f,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x0066a, 0x0066b, 0x0066c, 0x0066d, 0x0066e, 0x0066f,
  0x00000, 0x00671, 0x00672, 0x00673, 0x00621, 0x00675, 0x00676, 0x00677,
  0x00678, 0x00679, 0x0067a, 0x0067b, 0x0067c, 0x0067d, 0x0067e, 0x0067f,
  0x00680, 0x00681, 0x00682, 0x00683, 0x00684, 0x00685, 0x00686, 0x00687,
  0x00688, 0x00689, 0x0068a, 0x0068b, 0x0068c, 0x0068d, 0x0068e, 0x0068f,
  0x00690, 0x00691, 0x00692, 0x00693, 0x00694, 0x00695, 0x00696, 0x00697,
  0x00698, 0x00699, 0x0069a, 0x0069b, 0x0069c, 0x0069d, 0x0069e, 0x0069f,
  0x006a0, 0x006a1, 0x006a2, 0x006a3, 0x006a4, 0x006a5, 0x006a6, 0x006a7,
  0x006a8, 0x006a9, 0x006aa, 0x006ab, 0x006ac, 0x006ad, 0x006ae, 0x006af,
  0x006b0, 0x006b1, 0x006b2, 0x006b3, 0x006b4, 0x006b5, 0x006b6, 0x006b7,
  0x006b8, 0x006b9, 0x006ba, 0x006bb, 0x006bc, 0x006bd, 0x006be, 0x006bf,
  0x006c0, 0x006c1, 0x006c1, 0x006c3, 0x006c4, 0x006c5, 0x006c6, 0x006c7,
  0x006c8, 0x006c9, 0x006ca, 0x006cb, 0x006cc, 0x006cd, 0x006ce, 0x006cf,
  0x006d0, 0x006d1, 0x006d2, 0x006d2, 0x006d4, 0x006c0, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00648, 0x0064a, 0x00000,
  0x00000, 0x006e9, 0x00000, 0x00000, 0x00000, 0x00000, 0x006ee, 0x006ef,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x006fa, 0x006fb, 0x006fc, 0x00621, 0x00645, 0x006ff
};

static uint32_t unicode_520_ci_page_07[] = {
  0x00700, 0x00701, 0x00702, 0x00703, 0x00704, 0x00705, 0x00706, 0x00707,
  0x00708, 0x00709, 0x0070a, 0x0070b, 0x0070c, 0x0070d, 0x0070e, 0x00000,
  0x00710, 0x00000, 0x00712, 0x00713, 0x00713, 0x00715, 0x00716, 0x00717,
  0x00718, 0x00719, 0x0071a, 0x0071b, 0x0071b, 0x0071d, 0x0071e, 0x0071f,
  0x00720, 0x00721, 0x00722, 0x00723, 0x00723, 0x00725, 0x00726, 0x00726,
  0x00728, 0x00729, 0x0072a, 0x0072b, 0x0072c, 0x00712, 0x00713, 0x00715,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x0074b, 0x0074c, 0x0074d, 0x0074e, 0x0074f,
  0x00750, 0x00751, 0x00752, 0x00753, 0x00754, 0x00755, 0x00756, 0x00757,
  0x00758, 0x00759, 0x0075a, 0x0075b, 0x0075c, 0x0075d, 0x0075e, 0x0075f,
  0x00760, 0x00761, 0x00762, 0x00763, 0x00764, 0x00765, 0x00766, 0x00767,
  0x00768, 0x00769, 0x0076a, 0x0076b, 0x0076c, 0x0076d, 0x0076e, 0x0076f,
  0x00770, 0x00771, 0x00772, 0x00773, 0x00774, 0x00775, 0x00776, 0x00777,
  0x00778, 0x00779, 0x0077a, 0x0077b, 0x0077c, 0x0077d, 0x0077e, 0x0077f,
  0x00780, 0x00781, 0x00782, 0x00783, 0x00784, 0x00785, 0x00786, 0x00787,
  0x00788, 0x00789, 0x0078a, 0x0078b, 0x0078c, 0x0078d, 0x0078e, 0x0078f,
  0x00790, 0x00791, 0x00792, 0x00793, 0x00794, 0x00795, 0x00796, 0x00797,
  0x00798, 0x00799, 0x0079a, 0x0079b, 0x0079c, 0x0079d, 0x0079e, 0x0079f,
  0x007a0, 0x007a1, 0x007a2, 0x007a3, 0x007a4, 0x007a5, 0x007a6, 0x007a7,
  0x007a8, 0x007a9, 0x007aa, 0x007ab, 0x007ac, 0x007ad, 0x007ae, 0x007af,
  0x007b0, 0x007b1, 0x007b2, 0x007b3, 0x007b4, 0x007b5, 0x007b6, 0x007b7,
  0x007b8, 0x007b9, 0x007ba, 0x007bb, 0x007bc, 0x007bd, 0x007be, 0x007bf,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x007ca, 0x007cb, 0x007cc, 0x007cd, 0x007ce, 0x007cf,
  0x007d0, 0x007d1, 0x007d2, 0x007d3, 0x007d4, 0x007d5, 0x007d6, 0x007d7,
  0x007d8, 0x007d9, 0x007da, 0x007db, 0x007dc, 0x007dd, 0x007de, 0x007df,
  0x007e0, 0x007e1, 0x007e2, 0x007e3, 0x007e4, 0x007e5, 0x007e6, 0x007e7,
  0x007d6, 0x007d7, 0x007d9, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x007f4, 0x007f5, 0x007f6, 0x007f7,
  0x007f8, 0x007f9, 0x007fa, 0x007fb, 0x007fc, 0x007fd, 0x007fe, 0x007ff
};

static uint32_t unicode_520_ci_page_08[] = {
  0x00800, 0x00801, 0x00802, 0x00803, 0x00804, 0x00805, 0x00806, 0x00807,
  0x00808, 0x00809, 0x0080a, 0x0080b, 0x0080c, 0x0080d, 0x0080e, 0x0080f,
  0x00810, 0x00811, 0x00812, 0x00813, 0x00814, 0x00815, 0x00816, 0x00817,
  0x00000, 0x00000, 0x0081a, 0x0081b, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x0082e, 0x0082f,
  0x00830, 0x00831, 0x00832, 0x00833, 0x00834, 0x00835, 0x00836, 0x00837,
  0x00838, 0x00839, 0x0083a, 0x0083b, 0x0083c, 0x0083d, 0x0083e, 0x0083f,
  0x00840, 0x00841, 0x00842, 0x00843, 0x00844, 0x00845, 0x00846, 0x00847,
  0x00848, 0x00849, 0x0084a, 0x0084b, 0x0084c, 0x0084d, 0x0084e, 0x0084f,
  0x00850, 0x00851, 0x00852, 0x00853, 0x00854, 0x00855, 0x00856, 0x00857,
  0x00858, 0x00859, 0x0085a, 0x0085b, 0x0085c, 0x0085d, 0x0085e, 0x0085f,
  0x00860, 0x00861, 0x00862, 0x00863, 0x00864, 0x00865, 0x00866, 0x00867,
  0x00868, 0x00869, 0x0086a, 0x0086b, 0x0086c, 0x0086d, 0x0086e, 0x0086f,
  0x00870, 0x00871, 0x00872, 0x00873, 0x00874, 0x00875, 0x00876, 0x00877,
  0x00878, 0x00879, 0x0087a, 0x0087b, 0x0087c, 0x0087d, 0x0087e, 0x0087f,
  0x00880, 0x00881, 0x00882, 0x00883, 0x00884, 0x00885, 0x00886, 0x00887,
  0x00888, 0x00889, 0x0088a, 0x0088b, 0x0088c, 0x0088d, 0x0088e, 0x0088f,
  0x00890, 0x00891, 0x00892, 0x00893, 0x00894, 0x00895, 0x00896, 0x00897,
  0x00898, 0x00899, 0x0089a, 0x0089b, 0x0089c, 0x0089d, 0x0089e, 0x0089f,
  0x008a0, 0x008a1, 0x008a2, 0x008a3, 0x008a4, 0x008a5, 0x008a6, 0x008a7,
  0x008a8, 0x008a9, 0x008aa, 0x008ab, 0x008ac, 0x008ad, 0x008ae, 0x008af,
  0x008b0, 0x008b1, 0x008b2, 0x008b3, 0x008b4, 0x008b5, 0x008b6, 0x008b7,
  0x008b8, 0x008b9, 0x008ba, 0x008bb, 0x008bc, 0x008bd, 0x008be, 0x008bf,
  0x008c0, 0x008c1, 0x008c2, 0x008c3, 0x008c4, 0x008c5, 0x008c6, 0x008c7,
  0x008c8, 0x008c9, 0x008ca, 0x008cb, 0x008cc, 0x008cd, 0x008ce, 0x008cf,
  0x008d0, 0x008d1, 0x008d2, 0x008d3, 0x008d4, 0x008d5, 0x008d6, 0x008d7,
  0x008d8, 0x008d9, 0x008da, 0x008db, 0x008dc, 0x008dd, 0x008de, 0x008df,
  0x008e0, 0x008e1, 0x008e2, 0x008e3, 0x008e4, 0x008e5, 0x008e6, 0x008e7,
  0x008e8, 0x008e9, 0x008ea, 0x008eb, 0x008ec, 0x008ed, 0x008ee, 0x008ef,
  0x008f0, 0x008f1, 0x008f2, 0x008f3, 0x008f4, 0x008f5, 0x008f6, 0x008f7,
  0x008f8, 0x008f9, 0x008fa, 0x008fb, 0x008fc, 0x008fd, 0x008fe, 0x008ff
};

static uint32_t unicode_520_ci_page_09[] = {
  0x00000, 0x00000, 0x00000, 0x00000, 0x00904, 0x00905, 0x00906, 0x00907,
  0x00908, 0x00909, 0x0090a, 0x0090b, 0x0090c, 0x0090d, 0x0090e, 0x0090f,
  0x00910, 0x00911, 0x00912, 0x00913, 0x00914, 0x00915, 0x00916, 0x00917,
  0x00918, 0x00919, 0x0091a, 0x0091b, 0x0091c, 0x0091d, 0x0091e, 0x0091f,
  0x00920, 0x00921, 0x00922, 0x00923, 0x00924, 0x00925, 0x00926, 0x00927,
  0x00928, 0x00928, 0x0092a, 0x0092b, 0x0092c, 0x0092d, 0x0092e, 0x0092f,
  0x00930, 0x00930, 0x00932, 0x00933, 0x00933, 0x00935, 0x00936, 0x00937,
  0x00938, 0x00939, 0x0093a, 0x0093b, 0x00000, 0x0093d, 0x0093e, 0x0093f,
  0x00940, 0x00941, 0x00942, 0x00943, 0x00944, 0x00945, 0x00946, 0x00947,
  0x00948, 0x00949, 0x0094a, 0x0094b, 0x0094c, 0x0094d, 0x0094e, 0x0094f,
  0x00950, 0x00000, 0x00000, 0x00000, 0x00000, 0x00955, 0x00956, 0x00957,
  0x00915, 0x00916, 0x00917, 0x0091c, 0x00921, 0x00922, 0x0092b, 0x0092f,
  0x00960, 0x00961, 0x00962, 0x00963, 0x00964, 0x00965, 0x00030, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039,
  0x00970, 0x00971, 0x00972, 0x00973, 0x00974, 0x00975, 0x00976, 0x00977,
  0x00978, 0x00979, 0x0097a, 0x0097b, 0x0097c, 0x0097d, 0x0097e, 0x0097f,
  0x00980, 0x00000, 0x00000, 0x00000, 0x00984, 0x00985, 0x00986, 0x00987,
  0x00988, 0x00989, 0x0098a, 0x0098b, 0x0098c, 0x0098d, 0x0098e, 0x0098f,
  0x00990, 0x00991, 0x00992, 0x00993, 0x00994, 0x00995, 0x00996, 0x00997,
  0x00998, 0x00999, 0x0099a, 0x0099b, 0x0099c, 0x0099d, 0x0099e, 0x0099f,
  0x009a0, 0x009a1, 0x009a2, 0x009a3, 0x009a4, 0x009a5, 0x009a6, 0x009a7,
  0x009a8, 0x009a9, 0x009aa, 0x009ab, 0x009ac, 0x009ad, 0x009ae, 0x009af,
  0x009b0, 0x009b1, 0x009b2, 0x009b3, 0x009b4, 0x009b5, 0x009b6, 0x009b7,
  0x009b8, 0x009b9, 0x009ba, 0x009bb, 0x00000, 0x009bd, 0x009be, 0x009bf,
  0x009c0, 0x009c1, 0x009c2, 0x009c3, 0x009c4, 0x009c5, 0x009c6, 0x009c7,
  0x009c8, 0x009c9, 0x009ca, 0x009cb, 0x009cc, 0x009cd, 0x009ce, 0x009cf,
  0x009d0, 0x009d1, 0x009d2, 0x009d3, 0x009d4, 0x009d5, 0x009d6, 0x009d7,
  0x009d8, 0x009d9, 0x009da, 0x009db, 0x009a1, 0x009a2, 0x009de, 0x009af,
  0x009e0, 0x009e1, 0x009e2, 0x009e3, 0x009e4, 0x009e5, 0x00030, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039,
  0x009f0, 0x009f1, 0x009f2, 0x009f3, 0x009f4, 0x009f5, 0x009f6, 0x009f7,
  0x009f8, 0x009f9, 0x009fa, 0x009fb, 0x009fc, 0x009fd, 0x009fe, 0x009ff
};

static uint32_t unicode_520_ci_page_0a[] = {
  0x00a00, 0x00000, 0x00000, 0x00000, 0x00a04, 0x00a05, 0x00a06, 0x00a07,
  0x00a08, 0x00a09, 0x00a0a, 0x00a0b, 0x00a0c, 0x00a0d, 0x00a0e, 0x00a0f,
  0x00a10, 0x00a11, 0x00a12, 0x00a13, 0x00a14, 0x00a15, 0x00a16, 0x00a17,
  0x00a18, 0x00a19, 0x00a1a, 0x00a1b, 0x00a1c, 0x00a1d, 0x00a1e, 0x00a1f,
  0x00a20, 0x00a21, 0x00a22, 0x00a23, 0x00a24, 0x00a25, 0x00a26, 0x00a27,
  0x00a28, 0x00a29, 0x00a2a, 0x00a2b, 0x00a2c, 0x00a2d, 0x00a2e, 0x00a2f,
  0x00a30, 0x00a31, 0x00a32, 0x00a32, 0x00a34, 0x00a35, 0x00a36, 0x00a37,
  0x00a36, 0x00a39, 0x00a3a, 0x00a3b, 0x00000, 0x00a3d, 0x00a3e, 0x00a3f,
  0x00a40, 0x00a41, 0x00a42, 0x00a43, 0x00a44, 0x00a45, 0x00a46, 0x00a47,
  0x00a48, 0x00a49, 0x00a4a, 0x00a4b, 0x00a4c, 0x00a4d, 0x00a4e, 0x00a4f,
  0x00a50, 0x00a51, 0x00a52, 0x00a53, 0x00a54, 0x00a55, 0x00a56, 0x00a57,
  0x00a58, 0x00a16, 0x00a17, 0x00a1c, 0x00a5c, 0x00a5d, 0x00a2b, 0x00a5f,
  0x00a60, 0x00a61, 0x00a62, 0x00a63, 0x00a64, 0x00a65, 0x00030, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039,
  0x00000, 0x00000, 0x00a72, 0x00a73, 0x00a74, 0x00a75, 0x00a76, 0x00a77,
  0x00a78, 0x00a79, 0x00a7a, 0x00a7b, 0x00a7c, 0x00a7d, 0x00a7e, 0x00a7f,
  0x00a80, 0x00000, 0x00000, 0x00000, 0x00a84, 0x00a85, 0x00a86, 0x00a87,
  0x00a88, 0x00a89, 0x00a8a, 0x00a8b, 0x00a8c, 0x00a8d, 0x00a8e, 0x00a8f,
  0x00a90, 0x00a91, 0x00a92, 0x00a93, 0x00a94, 0x00a95, 0x00a96, 0x00a97,
  0x00a98, 0x00a99, 0x00a9a, 0x00a9b, 0x00a9c, 0x00a9d, 0x00a9e, 0x00a9f,
  0x00aa0, 0x00aa1, 0x00aa2, 0x00aa3, 0x00aa4, 0x00aa5, 0x00aa6, 0x00aa7,
  0x00aa8, 0x00aa9, 0x00aaa, 0x00aab, 0x00aac, 0x00aad, 0x00aae, 0x00aaf,
  0x00ab0, 0x00ab1, 0x00ab2, 0x00ab3, 0x00ab4, 0x00ab5, 0x00ab6, 0x00ab7,
  0x00ab8, 0x00ab9, 0x00aba, 0x00abb, 0x00000, 0x00abd, 0x00abe, 0x00abf,
  0x00ac0, 0x00ac1, 0x00ac2, 0x00ac3, 0x00ac4, 0x00ac5, 0x00ac6, 0x00ac7,
  0x00ac8, 0x00ac9, 0x00aca, 0x00acb, 0x00acc, 0x00acd, 0x00ace, 0x00acf,
  0x00ad0, 0x00ad1, 0x00ad2, 0x00ad3, 0x00ad4, 0x00ad5, 0x00ad6, 0x00ad7,
  0x00ad8, 0x00ad9, 0x00ada, 0x00adb, 0x00adc, 0x00add, 0x00ade, 0x00adf,
  0x00ae0, 0x00ae1, 0x00ae2, 0x00ae3, 0x00ae4, 0x00ae5, 0x00030, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039,
  0x00af0, 0x00af1, 0x00af2, 0x00af3, 0x00af4, 0x00af5, 0x00af6, 0x00af7,
  0x00af8, 0x00af9, 0x00afa, 0x00afb, 0x00afc, 0x00afd, 0x00afe, 0x00aff
};

static uint32_t unicode_520_ci_page_0b[] = {
  0x00b00, 0x00000, 0x00000, 0x00000, 0x00b04, 0x00b05, 0x00b06, 0x00b07,
  0x00b08, 0x00b09, 0x00b0a, 0x00b0b, 0x00b0c, 0x00b0d, 0x00b0e, 0x00b0f,
  0x00b10, 0x00b11, 0x00b12, 0x00b13, 0x00b14, 0x00b15, 0x00b16, 0x00b17,
  0x00b18, 0x00b19, 0x00b1a, 0x00b1b, 0x00b1c, 0x00b1d, 0x00b1e, 0x00b1f,
  0x00b20, 0x00b21, 0x00b22, 0x00b23, 0x00b24, 0x00b25, 0x00b26, 0x00b27,
  0x00b28, 0x00b29, 0x00b2a, 0x00b2b, 0x00b2c, 0x00b2d, 0x00b2e, 0x00b2f,
  0x00b30, 0x00b31, 0x00b32, 0x00b33, 0x00b34, 0x00b35, 0x00b36, 0x00b37,
  0x00b38, 0x00b39, 0x00b3a, 0x00b3b, 0x00000, 0x00b3d, 0x00b3e, 0x00b3f,
  0x00b40, 0x00b41, 0x00b42, 0x00b43, 0x00b44, 0x00b45, 0x00b46, 0x00b47,
  0x00b48, 0x00b49, 0x00b4a, 0x00b4b, 0x00b4c, 0x00b4d, 0x00b4e, 0x00b4f,
  0x00b50, 0x00b51, 0x00b52, 0x00b53, 0x00b54, 0x00b55, 0x00b56, 0x00b57,
  0x00b58, 0x00b59, 0x00b5a, 0x00b5b, 0x00b21, 0x00b22, 0x00b5e, 0x00b5f,
  0x00b60, 0x00b61, 0x00b62, 0x00b63, 0x00b64, 0x00b65, 0x00030, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039,
  0x00b70, 0x00b71, 0x00b72, 0x00b73, 0x00b74, 0x00b75, 0x00b76, 0x00b77,
  0x00b78, 0x00b79, 0x00b7a, 0x00b7b, 0x00b7c, 0x00b7d, 0x00b7e, 0x00b7f,
  0x00b80, 0x00b81, 0x00000, 0x00b83, 0x00b84, 0x00b85, 0x00b86, 0x00b87,
  0x00b88, 0x00b89, 0x00b8a, 0x00b8b, 0x00b8c, 0x00b8d, 0x00b8e, 0x00b8f,
  0x00b90, 0x00b91, 0x00b92, 0x00b93, 0x00b94, 0x00b95, 0x00b96, 0x00b97,
  0x00b98, 0x00b99, 0x00b9a, 0x00b9b, 0x00b9c, 0x00b9d, 0x00b9e, 0x00b9f,
  0x00ba0, 0x00ba1, 0x00ba2, 0x00ba3, 0x00ba4, 0x00ba5, 0x00ba6, 0x00ba7,
  0x00ba8, 0x00ba9, 0x00baa, 0x00bab, 0x00bac, 0x00bad, 0x00bae, 0x00baf,
  0x00bb0, 0x00bb1, 0x00bb2, 0x00bb3, 0x00bb4, 0x00bb5, 0x00bb6, 0x00bb7,
  0x00bb8, 0x00bb9, 0x00bba, 0x00bbb, 0x00bbc, 0x00bbd, 0x00bbe, 0x00bbf,
  0x00bc0, 0x00bc1, 0x00bc2, 0x00bc3, 0x00bc4, 0x00bc5, 0x00bc6, 0x00bc7,
  0x00bc8, 0x00bc9, 0x00bca, 0x00bcb, 0x00bcc, 0x00bcd, 0x00bce, 0x00bcf,
  0x00bd0, 0x00bd1, 0x00bd2, 0x00bd3, 0x00bd4, 0x00bd5, 0x00bd6, 0x00bd7,
  0x00bd8, 0x00bd9, 0x00bda, 0x00bdb, 0x00bdc, 0x00bdd, 0x00bde, 0x00bdf,
  0x00be0, 0x00be1, 0x00be2, 0x00be3, 0x00be4, 0x00be5, 0x00030, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039,
  0x00bf0, 0x00bf1, 0x00bf2, 0x00bf3, 0x00bf4, 0x00bf5, 0x00bf6, 0x00bf7,
  0x00bf8, 0x00bf9, 0x00bfa, 0x00bfb, 0x00bfc, 0x00bfd, 0x00bfe, 0x00bff
};

static uint32_t unicode_520_ci_page_0c[] = {
  0x00c00, 0x00000, 0x00000, 0x00000, 0x00c04, 0x00c05, 0x00c06, 0x00c07,
  0x00c08, 0x00c09, 0x00c0a, 0x00c0b, 0x00c0c, 0x00c0d, 0x00c0e, 0x00c0f,
  0x00c10, 0x00c11, 0x00c12, 0x00c13, 0x00c14, 0x00c15, 0x00c16, 0x00c17,
  0x00c18, 0x00c19, 0x00c1a, 0x00c1b, 0x00c1c, 0x00c1d, 0x00c1e, 0x00c1f,
  0x00c20, 0x00c21, 0x00c22, 0x00c23, 0x00c24, 0x00c25, 0x00c26, 0x00c27,
  0x00c28, 0x00c29, 0x00c2a, 0x00c2b, 0x00c2c, 0x00c2d, 0x00c2e, 0x00c2f,
  0x00c30, 0x00c31, 0x00c32, 0x00c33, 0x00c34, 0x00c35, 0x00c36, 0x00c37,
  0x00c38, 0x00c39, 0x00c3a, 0x00c3b, 0x00c3c, 0x00c3d, 0x00c3e, 0x00c3f,
  0x00c40, 0x00c41, 0x00c42, 0x00c43, 0x00c44, 0x00c45, 0x00c46, 0x00c47,
  0x00c48, 0x00c49, 0x00c4a, 0x00c4b, 0x00c4c, 0x00c4d, 0x00c4e, 0x00c4f,
  0x00c50, 0x00c51, 0x00c52, 0x00c53, 0x00c54, 0x00c55, 0x00c56, 0x00c57,
  0x00c58, 0x00c59, 0x00c5a, 0x00c5b, 0x00c5c, 0x00c5d, 0x00c5e, 0x00c5f,
  0x00c60, 0x00c61, 0x00c62, 0x00c63, 0x00c64, 0x00c65, 0x00030, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039,
  0x00c70, 0x00c71, 0x00c72, 0x00c73, 0x00c74, 0x00c75, 0x00c76, 0x00c77,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00031, 0x00032, 0x00033, 0x00c7f,
  0x00c80, 0x00c81, 0x00000, 0x00000, 0x00c84, 0x00c85, 0x00c86, 0x00c87,
  0x00c88, 0x00c89, 0x00c8a, 0x00c8b, 0x00c8c, 0x00c8d, 0x00c8e, 0x00c8f,
  0x00c90, 0x00c91, 0x00c92, 0x00c93, 0x00c94, 0x00c95, 0x00c96, 0x00c97,
  0x00c98, 0x00c99, 0x00c9a, 0x00c9b, 0x00c9c, 0x00c9d, 0x00c9e, 0x00c9f,
  0x00ca0, 0x00ca1, 0x00ca2, 0x00ca3, 0x00ca4, 0x00ca5, 0x00ca6, 0x00ca7,
  0x00ca8, 0x00ca9, 0x00caa, 0x00cab, 0x00cac, 0x00cad, 0x00cae, 0x00caf,
  0x00cb0, 0x00cb1, 0x00cb2, 0x00cb3, 0x00cb4, 0x00cb5, 0x00cb6, 0x00cb7,
  0x00cb8, 0x00cb9, 0x00cba, 0x00cbb, 0x00000, 0x00cbd, 0x00cbe, 0x00cbf,
  0x00cc0, 0x00cc1, 0x00cc2, 0x00cc3, 0x00cc4, 0x00cc5, 0x00cc6, 0x00cc7,
  0x00cc8, 0x00cc9, 0x00cca, 0x00ccb, 0x00ccc, 0x00ccd, 0x00cce, 0x00ccf,
  0x00cd0, 0x00cd1, 0x00cd2, 0x00cd3, 0x00cd4, 0x00cd5, 0x00cd6, 0x00cd7,
  0x00cd8, 0x00cd9, 0x00cda, 0x00cdb, 0x00cdc, 0x00cdd, 0x00cde, 0x00cdf,
  0x00ce0, 0x00ce1, 0x00ce2, 0x00ce3, 0x00ce4, 0x00ce5, 0x00030, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039,
  0x00cf0, 0x00cf1, 0x00cf2, 0x00cf3, 0x00cf4, 0x00cf5, 0x00cf6, 0x00cf7,
  0x00cf8, 0x00cf9, 0x00cfa, 0x00cfb, 0x00cfc, 0x00cfd, 0x00cfe, 0x00cff
};

static uint32_t unicode_520_ci_page_0d[] = {
  0x00d00, 0x00d01, 0x00000, 0x00000, 0x00d04, 0x00d05, 0x00d06, 0x00d07,
  0x00d08, 0x00d09, 0x00d0a, 0x00d0b, 0x00d0c, 0x00d0d, 0x00d0e, 0x00d0f,
  0x00d10, 0x00d11, 0x00d12, 0x00d13, 0x00d14, 0x00d15, 0x00d16, 0x00d17,
  0x00d18, 0x00d19, 0x00d1a, 0x00d1b, 0x00d1c, 0x00d1d, 0x00d1e, 0x00d1f,
  0x00d20, 0x00d21, 0x00d22, 0x00d23, 0x00d24, 0x00d25, 0x00d26, 0x00d27,
  0x00d28, 0x00d29, 0x00d2a, 0x00d2b, 0x00d2c, 0x00d2d, 0x00d2e, 0x00d2f,
  0x00d30, 0x00d31, 0x00d32, 0x00d33, 0x00d34, 0x00d35, 0x00d36, 0x00d37,
  0x00d38, 0x00d39, 0x00d3a, 0x00d3b, 0x00d3c, 0x00d3d, 0x00d3e, 0x00d3f,
  0x00d40, 0x00d41, 0x00d42, 0x00d43, 0x00d44, 0x00d45, 0x00d46, 0x00d47,
  0x00d48, 0x00d49, 0x00d4a, 0x00d4b, 0x00d4c, 0x00d4d, 0x00d4e, 0x00d4f,
  0x00d50, 0x00d51, 0x00d52, 0x00d53, 0x00d54, 0x00d55, 0x00d56, 0x00d57,
  0x00d58, 0x00d59, 0x00d5a, 0x00d5b, 0x00d5c, 0x00d5d, 0x00d5e, 0x00d5f,
  0x00d60, 0x00d61, 0x00d62, 0x00d63, 0x00d64, 0x00d65, 0x00030, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039,
  0x00d70, 0x00d71, 0x00d72, 0x00d73, 0x00d74, 0x00d75, 0x00d76, 0x00d77,
  0x00d78, 0x00d79, 0x00d7a, 0x00d7b, 0x00d7c, 0x00d7d, 0x00d7e, 0x00d7f,
  0x00d80, 0x00d81, 0x00000, 0x00000, 0x00d84, 0x00d85, 0x00d86, 0x00d87,
  0x00d88, 0x00d89, 0x00d8a, 0x00d8b, 0x00d8c, 0x00d8d, 0x00d8e, 0x00d8f,
  0x00d90, 0x00d91, 0x00d92, 0x00d93, 0x00d94, 0x00d95, 0x00d96, 0x00d97,
  0x00d98, 0x00d99, 0x00d9a, 0x00d9b, 0x00d9c, 0x00d9d, 0x00d9e, 0x00d9f,
  0x00da0, 0x00da1, 0x00da2, 0x00da3, 0x00da4, 0x00da5, 0x00da6, 0x00da7,
  0x00da8, 0x00da9, 0x00daa, 0x00dab, 0x00dac, 0x00dad, 0x00dae, 0x00daf,
  0x00db0, 0x00db1, 0x00db2, 0x00db3, 0x00db4, 0x00db5, 0x00db6, 0x00db7,
  0x00db8, 0x00db9, 0x00dba, 0x00dbb, 0x00dbc, 0x00dbd, 0x00dbe, 0x00dbf,
  0x00dc0, 0x00dc1, 0x00dc2, 0x00dc3, 0x00dc4, 0x00dc5, 0x00dc6, 0x00dc7,
  0x00dc8, 0x00dc9, 0x00dca, 0x00dcb, 0x00dcc, 0x00dcd, 0x00dce, 0x00dcf,
  0x00dd0, 0x00dd1, 0x00dd2, 0x00dd3, 0x00dd4, 0x00dd5, 0x00dd6, 0x00dd7,
  0x00dd8, 0x00dd9, 0x00dda, 0x00ddb, 0x00ddc, 0x00ddd, 0x00dde, 0x00ddf,
  0x00de0, 0x00de1, 0x00de2, 0x00de3, 0x00de4, 0x00de5, 0x00de6, 0x00de7,
  0x00de8, 0x00de9, 0x00dea, 0x00deb, 0x00dec, 0x00ded, 0x00dee, 0x00def,
  0x00df0, 0x00df1, 0x00df2, 0x00df3, 0x00df4, 0x00df5, 0x00df6, 0x00df7,
  0x00df8, 0x00df9, 0x00dfa, 0x00dfb, 0x00dfc, 0x00dfd, 0x00dfe, 0x00dff
};

static uint32_t unicode_520_ci_page_0e[] = {
  0x00e00, 0x00e01, 0x00e02, 0x00e03, 0x00e04, 0x00e05, 0x00e06, 0x00e07,
  0x00e08, 0x00e09, 0x00e0a, 0x00e0b, 0x00e0c, 0x00e0d, 0x00e0e, 0x00e0f,
  0x00e10, 0x00e11, 0x00e12, 0x00e13, 0x00e14, 0x00e15, 0x00e16, 0x00e17,
  0x00e18, 0x00e19, 0x00e1a, 0x00e1b, 0x00e1c, 0x00e1d, 0x00e1e, 0x00e1f,
  0x00e20, 0x00e21, 0x00e22, 0x00e23, 0x00e24, 0x00e25, 0x00e26, 0x00e27,
  0x00e28, 0x00e29, 0x00e2a, 0x00e2b, 0x00e2c, 0x00e2d, 0x00e2e, 0x00e2f,
  0x00e30, 0x00e31, 0x00e32, 0x00e33, 0x00e34, 0x00e35, 0x00e36, 0x00e37,
  0x00e38, 0x00e39, 0x00e3a, 0x00e3b, 0x00e3c, 0x00e3d, 0x00e3e, 0x00e3f,
  0x00e40, 0x00e41, 0x00e42, 0x00e43, 0x00e44, 0x00e45, 0x00e46, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00e4f,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x00e5a, 0x00e5b, 0x00e5c, 0x00e5d, 0x00e5e, 0x00e5f,
  0x00e60, 0x00e61, 0x00e62, 0x00e63, 0x00e64, 0x00e65, 0x00e66, 0x00e67,
  0x00e68, 0x00e69, 0x00e6a, 0x00e6b, 0x00e6c, 0x00e6d, 0x00e6e, 0x00e6f,
  0x00e70, 0x00e71, 0x00e72, 0x00e73, 0x00e74, 0x00e75, 0x00e76, 0x00e77,
  0x00e78, 0x00e79, 0x00e7a, 0x00e7b, 0x00e7c, 0x00e7d, 0x00e7e, 0x00e7f,
  0x00e80, 0x00e81, 0x00e82, 0x00e83, 0x00e84, 0x00e85, 0x00e86, 0x00e87,
  0x00e88, 0x00e89, 0x00e8a, 0x00e8b, 0x00e8c, 0x00e8d, 0x00e8e, 0x00e8f,
  0x00e90, 0x00e91, 0x00e92, 0x00e93, 0x00e94, 0x00e95, 0x00e96, 0x00e97,
  0x00e98, 0x00e99, 0x00e9a, 0x00e9b, 0x00e9c, 0x00e9d, 0x00e9e, 0x00e9f,
  0x00ea0, 0x00ea1, 0x00ea2, 0x00ea3, 0x00ea4, 0x00ea5, 0x00ea6, 0x00ea7,
  0x00ea8, 0x00ea9, 0x00eaa, 0x00eab, 0x00eac, 0x00ead, 0x00eae, 0x00eaf,
  0x00eb0, 0x00eb1, 0x00eb2, 0x00eb3, 0x00eb4, 0x00eb5, 0x00eb6, 0x00eb7,
  0x00eb8, 0x00eb9, 0x00eba, 0x00ebb, 0x00ebc, 0x00ebd, 0x00ebe, 0x00ebf,
  0x00ec0, 0x00ec1, 0x00ec2, 0x00ec3, 0x00ec4, 0x00ec5, 0x00ec6, 0x00ec7,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00ece, 0x00ecf,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x00eda, 0x00edb, 0x00edc, 0x00edd, 0x00ede, 0x00edf,
  0x00ee0, 0x00ee1, 0x00ee2, 0x00ee3, 0x00ee4, 0x00ee5, 0x00ee6, 0x00ee7,
  0x00ee8, 0x00ee9, 0x00eea, 0x00eeb, 0x00eec, 0x00eed, 0x00eee, 0x00eef,
  0x00ef0, 0x00ef1, 0x00ef2, 0x00ef3, 0x00ef4, 0x00ef5, 0x00ef6, 0x00ef7,
  0x00ef8, 0x00ef9, 0x00efa, 0x00efb, 0x00efc, 0x00efd, 0x00efe, 0x00eff
};

static uint32_t unicode_520_ci_page_0f[] = {
  0x00f00, 0x00f01, 0x00f02, 0x00f03, 0x00f04, 0x00f05, 0x00f06, 0x00f07,
  0x00f08, 0x00f09, 0x00f0a, 0x00f0b, 0x00f0b, 0x00f0d, 0x00f0e, 0x00f0f,
  0x00f10, 0x00f11, 0x00f12, 0x00f13, 0x00f14, 0x00f15, 0x00f16, 0x00f17,
  0x00000, 0x00000, 0x00f1a, 0x00f1b, 0x00f1c, 0x00f1d, 0x00f1e, 0x00f1f,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036,
  0x00037, 0x00038, 0x00039, 0x00030, 0x00f34, 0x00000, 0x00f36, 0x00000,
  0x00f38, 0x00000, 0x00f3a, 0x00f3b, 0x00f3c, 0x00f3d, 0x00f3e, 0x00f3f,
  0x00f40, 0x00f41, 0x00f42, 0x00f43, 0x00f44, 0x00f45, 0x00f46, 0x00f47,
  0x00f48, 0x00f49, 0x00f4a, 0x00f4b, 0x00f4c, 0x00f4d, 0x00f4e, 0x00f4f,
  0x00f50, 0x00f51, 0x00f52, 0x00f53, 0x00f54, 0x00f55, 0x00f56, 0x00f57,
  0x00f58, 0x00f59, 0x00f5a, 0x00f5b, 0x00f5c, 0x00f5d, 0x00f5e, 0x00f5f,
  0x00f60, 0x00f61, 0x00f62, 0x00f63, 0x00f64, 0x00f65, 0x00f66, 0x00f67,
  0x00f68, 0x00f69, 0x00f62, 0x00f6b, 0x00f6c, 0x00f6d, 0x00f6e, 0x00f6f,
  0x00f70, 0x00f71, 0x00f72, 0x00f73, 0x00f74, 0x00f75, 0x00f76, 0x00f77,
  0x00f78, 0x00f79, 0x00f7a, 0x00f7b, 0x00f7c, 0x00f7d, 0x00000, 0x00000,
  0x00f80, 0x00f81, 0x00000, 0x00000, 0x00f84, 0x00f85, 0x00000, 0x00000,
  0x00f88, 0x00f89, 0x00f8a, 0x00f8b, 0x00f8c, 0x00f8d, 0x00f8e, 0x00f8f,
  0x00f90, 0x00f91, 0x00f92, 0x00f93, 0x00f94, 0x00f95, 0x00f96, 0x00f97,
  0x00f98, 0x00f99, 0x00f9a, 0x00f9b, 0x00f9c, 0x00f9d, 0x00f9e, 0x00f9f,
  0x00fa0, 0x00fa1, 0x00fa2, 0x00fa3, 0x00fa4, 0x00fa5, 0x00fa6, 0x00fa7,
  0x00fa8, 0x00fa9, 0x00faa, 0x00fab, 0x00fac, 0x00fad, 0x00fae, 0x00faf,
  0x00fb0, 0x00fb1, 0x00fb2, 0x00fb3, 0x00fb4, 0x00fb5, 0x00fb6, 0x00fb7,
  0x00fb8, 0x00fb9, 0x00fad, 0x00fb1, 0x00fb2, 0x00fbd, 0x00fbe, 0x00fbf,
  0x00fc0, 0x00fc1, 0x00fc2, 0x00fc3, 0x00fc4, 0x00fc5, 0x00000, 0x00fc7,
  0x00fc8, 0x00fc9, 0x00fca, 0x00fcb, 0x00fcc, 0x00fcd, 0x00fce, 0x00fcf,
  0x00fd0, 0x00fd1, 0x00fd2, 0x00fd3, 0x00fd4, 0x00fd5, 0x00fd6, 0x00fd7,
  0x00fd8, 0x00fd9, 0x00fda, 0x00fdb, 0x00fdc, 0x00fdd, 0x00fde, 0x00fdf,
  0x00fe0, 0x00fe1, 0x00fe2, 0x00fe3, 0x00fe4, 0x00fe5, 0x00fe6, 0x00fe7,
  0x00fe8, 0x00fe9, 0x00fea, 0x00feb, 0x00fec, 0x00fed, 0x00fee, 0x00fef,
  0x00ff0, 0x00ff1, 0x00ff2, 0x00ff3, 0x00ff4, 0x00ff5, 0x00ff6, 0x00ff7,
  0x00ff8, 0x00ff9, 0x00ffa, 0x00ffb, 0x00ffc, 0x00ffd, 0x00ffe, 0x00fff
};

static uint32_t unicode_520_ci_page_10[] = {
  0x01000, 0x01001, 0x01002, 0x01003, 0x01004, 0x01005, 0x01006, 0x01007,
  0x01008, 0x01009, 0x0100a, 0x0100b, 0x0100c, 0x0100d, 0x0100e, 0x0100f,
  0x01010, 0x01011, 0x01012, 0x01013, 0x01014, 0x01015, 0x01016, 0x01017,
  0x01018, 0x01019, 0x0101a, 0x0101b, 0x0101c, 0x0101d, 0x0101e, 0x0101f,
  0x01020, 0x01021, 0x01022, 0x01023, 0x01024, 0x01025, 0x01026, 0x01027,
  0x01028, 0x01029, 0x0102a, 0x0102b, 0x0102b, 0x0102d, 0x0102e, 0x0102f,
  0x01030, 0x01031, 0x01032, 0x01033, 0x01034, 0x01035, 0x00000, 0x00000,
  0x00000, 0x01039, 0x0103a, 0x0103b, 0x0103c, 0x0103d, 0x0103e, 0x0103f,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x0104a, 0x0104b, 0x0104c, 0x0104d, 0x0104e, 0x0104f,
  0x01050, 0x01051, 0x01052, 0x01053, 0x01054, 0x01055, 0x01056, 0x01057,
  0x01058, 0x01059, 0x0105a, 0x0105b, 0x0105c, 0x0105d, 0x0105e, 0x0105f,
  0x01060, 0x01061, 0x01062, 0x01063, 0x01064, 0x01065, 0x01066, 0x01067,
  0x01068, 0x01069, 0x0106a, 0x0106b, 0x0106c, 0x0106d, 0x0106e, 0x0106f,
  0x01070, 0x01071, 0x01072, 0x01073, 0x01074, 0x01075, 0x01076, 0x01077,
  0x01078, 0x01079, 0x0107a, 0x0107b, 0x0107c, 0x0107d, 0x0107e, 0x0107f,
  0x01080, 0x01081, 0x01082, 0x01083, 0x01084, 0x01085, 0x01086, 0x01087,
  0x01088, 0x01089, 0x0108a, 0x0108b, 0x0108c, 0x00000, 0x0108e, 0x0108f,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x0109a, 0x0109b, 0x0109c, 0x0109d, 0x0109e, 0x0109f,
  0x010a0, 0x010a1, 0x010a2, 0x010a3, 0x010a4, 0x010a5, 0x010a6, 0x010a7,
  0x010a8, 0x010a9, 0x010aa, 0x010ab, 0x010ac, 0x010ad, 0x010ae, 0x010af,
  0x010b0, 0x010b1, 0x010b2, 0x010b3, 0x010b4, 0x010b5, 0x010b6, 0x010b7,
  0x010b8, 0x010b9, 0x010ba, 0x010bb, 0x010bc, 0x010bd, 0x010be, 0x010bf,
  0x010c0, 0x010c1, 0x010c2, 0x010c3, 0x010c4, 0x010c5, 0x010c6, 0x010c7,
  0x010c8, 0x010c9, 0x010ca, 0x010cb, 0x010cc, 0x010cd, 0x010ce, 0x010cf,
  0x010d0, 0x010d1, 0x010d2, 0x010d3, 0x010d4, 0x010d5, 0x010d6, 0x010d7,
  0x010d8, 0x010d9, 0x010da, 0x010db, 0x010dc, 0x010dd, 0x010de, 0x010df,
  0x010e0, 0x010e1, 0x010e2, 0x010e3, 0x010e4, 0x010e5, 0x010e6, 0x010e7,
  0x010e8, 0x010e9, 0x010ea, 0x010eb, 0x010ec, 0x010ed, 0x010ee, 0x010ef,
  0x010f0, 0x010f1, 0x010f2, 0x010f3, 0x010f4, 0x010f5, 0x010f6, 0x010f7,
  0x010f8, 0x010f9, 0x010fa, 0x010fb, 0x010dc, 0x010fd, 0x010fe, 0x010ff
};

static uint32_t unicode_520_ci_page_13[] = {
  0x01300, 0x01301, 0x01302, 0x01303, 0x01304, 0x01305, 0x01306, 0x01307,
  0x01308, 0x01309, 0x0130a, 0x0130b, 0x0130c, 0x0130d, 0x0130e, 0x0130f,
  0x01310, 0x01311, 0x01312, 0x01313, 0x01314, 0x01315, 0x01316, 0x01317,
  0x01318, 0x01319, 0x0131a, 0x0131b, 0x0131c, 0x0131d, 0x0131e, 0x0131f,
  0x01320, 0x01321, 0x01322, 0x01323, 0x01324, 0x01325, 0x01326, 0x01327,
  0x01328, 0x01329, 0x0132a, 0x0132b, 0x0132c, 0x0132d, 0x0132e, 0x0132f,
  0x01330, 0x01331, 0x01332, 0x01333, 0x01334, 0x01335, 0x01336, 0x01337,
  0x01338, 0x01339, 0x0133a, 0x0133b, 0x0133c, 0x0133d, 0x0133e, 0x0133f,
  0x01340, 0x01341, 0x01342, 0x01343, 0x01344, 0x01345, 0x01346, 0x01347,
  0x01348, 0x01349, 0x0134a, 0x0134b, 0x0134c, 0x0134d, 0x0134e, 0x0134f,
  0x01350, 0x01351, 0x01352, 0x01353, 0x01354, 0x01355, 0x01356, 0x01357,
  0x01358, 0x01359, 0x0135a, 0x0135b, 0x0135c, 0x0135d, 0x0135e, 0x00000,
  0x01360, 0x01361, 0x01362, 0x01363, 0x01364, 0x01365, 0x01366, 0x01367,
  0x01368, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x01372, 0x01373, 0x01374, 0x01375, 0x01376, 0x01377,
  0x01378, 0x01379, 0x0137a, 0x0137b, 0x0137c, 0x0137d, 0x0137e, 0x0137f,
  0x01380, 0x01381, 0x01382, 0x01383, 0x01384, 0x01385, 0x01386, 0x01387,
  0x01388, 0x01389, 0x0138a, 0x0138b, 0x0138c, 0x0138d, 0x0138e, 0x0138f,
  0x01390, 0x01391, 0x01392, 0x01393, 0x01394, 0x01395, 0x01396, 0x01397,
  0x01398, 0x01399, 0x0139a, 0x0139b, 0x0139c, 0x0139d, 0x0139e, 0x0139f,
  0x013a0, 0x013a1, 0x013a2, 0x013a3, 0x013a4, 0x013a5, 0x013a6, 0x013a7,
  0x013a8, 0x013a9, 0x013aa, 0x013ab, 0x013ac, 0x013ad, 0x013ae, 0x013af,
  0x013b0, 0x013b1, 0x013b2, 0x013b3, 0x013b4, 0x013b5, 0x013b6, 0x013b7,
  0x013b8, 0x013b9, 0x013ba, 0x013bb, 0x013bc, 0x013bd, 0x013be, 0x013bf,
  0x013c0, 0x013c1, 0x013c2, 0x013c3, 0x013c4, 0x013c5, 0x013c6, 0x013c7,
  0x013c8, 0x013c9, 0x013ca, 0x013cb, 0x013cc, 0x013cd, 0x013ce, 0x013cf,
  0x013d0, 0x013d1, 0x013d2, 0x013d3, 0x013d4, 0x013d5, 0x013d6, 0x013d7,
  0x013d8, 0x013d9, 0x013da, 0x013db, 0x013dc, 0x013dd, 0x013de, 0x013df,
  0x013e0, 0x013e1, 0x013e2, 0x013e3, 0x013e4, 0x013e5, 0x013e6, 0x013e7,
  0x013e8, 0x013e9, 0x013ea, 0x013eb, 0x013ec, 0x013ed, 0x013ee, 0x013ef,
  0x013f0, 0x013f1, 0x013f2, 0x013f3, 0x013f4, 0x013f5, 0x013f6, 0x013f7,
  0x013f8, 0x013f9, 0x013fa, 0x013fb, 0x013fc, 0x013fd, 0x013fe, 0x013ff
};

static uint32_t unicode_520_ci_page_16[] = {
  0x01600, 0x01601, 0x01602, 0x01603, 0x01604, 0x01605, 0x01606, 0x01607,
  0x01608, 0x01609, 0x0160a, 0x0160b, 0x0160c, 0x0160d, 0x0160e, 0x0160f,
  0x01610, 0x01611, 0x01612, 0x01613, 0x01614, 0x01615, 0x01616, 0x01617,
  0x01618, 0x01619, 0x0161a, 0x0161b, 0x0161c, 0x0161d, 0x0161e, 0x0161f,
  0x01620, 0x01621, 0x01622, 0x01623, 0x01624, 0x01625, 0x01626, 0x01627,
  0x01628, 0x01629, 0x0162a, 0x0162b, 0x0162c, 0x0162d, 0x0162e, 0x0162f,
  0x01630, 0x01631, 0x01632, 0x01633, 0x01634, 0x01635, 0x01636, 0x01637,
  0x01638, 0x01639, 0x0163a, 0x0163b, 0x0163c, 0x0163d, 0x0163e, 0x0163f,
  0x01640, 0x01641, 0x01642, 0x01643, 0x01644, 0x01645, 0x01646, 0x01647,
  0x01648, 0x01649, 0x0164a, 0x0164b, 0x0164c, 0x0164d, 0x0164e, 0x0164f,
  0x01650, 0x01651, 0x01652, 0x01653, 0x01654, 0x01655, 0x01656, 0x01657,
  0x01658, 0x01659, 0x0165a, 0x0165b, 0x0165c, 0x0165d, 0x0165e, 0x0165f,
  0x01660, 0x01661, 0x01662, 0x01663, 0x01664, 0x01665, 0x01666, 0x01667,
  0x01668, 0x01669, 0x0166a, 0x0166b, 0x0166c, 0x0166d, 0x0166e, 0x0166f,
  0x01670, 0x01671, 0x01672, 0x01673, 0x01674, 0x01675, 0x01676, 0x01677,
  0x01678, 0x01679, 0x0167a, 0x0167b, 0x0167c, 0x0167d, 0x0167e, 0x0167f,
  0x01680, 0x01681, 0x01682, 0x01683, 0x01684, 0x01685, 0x01686, 0x01687,
  0x01688, 0x01689, 0x0168a, 0x0168b, 0x0168c, 0x0168d, 0x0168e, 0x0168f,
  0x01690, 0x01691, 0x01692, 0x01693, 0x01694, 0x01695, 0x01696, 0x01697,
  0x01698, 0x01699, 0x0169a, 0x0169b, 0x0169c, 0x0169d, 0x0169e, 0x0169f,
  0x016a0, 0x016a0, 0x016a2, 0x016a3, 0x016a2, 0x016a2, 0x016a6, 0x016a6,
  0x016a8, 0x016a8, 0x016aa, 0x016ab, 0x016a8, 0x016a8, 0x016a8, 0x016af,
  0x016b0, 0x016b1, 0x016b2, 0x016b2, 0x016b2, 0x016b2, 0x016b2, 0x016b7,
  0x016b8, 0x016b9, 0x016ba, 0x016ba, 0x016ba, 0x016ba, 0x016be, 0x016be,
  0x016be, 0x016c1, 0x016c1, 0x016c3, 0x016c3, 0x016c5, 0x016c5, 0x016c7,
  0x016c8, 0x016c9, 0x016ca, 0x016ca, 0x016ca, 0x016ca, 0x016ca, 0x016cf,
  0x016cf, 0x016cf, 0x016d2, 0x016d2, 0x016d2, 0x016c8, 0x016d6, 0x016d7,
  0x016d7, 0x016d7, 0x016da, 0x016da, 0x016dc, 0x016dc, 0x016de, 0x016df,
  0x016e0, 0x016e1, 0x016e2, 0x016e3, 0x016e4, 0x016e5, 0x016e6, 0x016e6,
  0x016e6, 0x016b9, 0x016ca, 0x016eb, 0x016ec, 0x016ed, 0x016ee, 0x016ef,
  0x016f0, 0x016f1, 0x016f2, 0x016f3, 0x016f4, 0x016f5, 0x016f6, 0x016f7,
  0x016f8, 0x016f9, 0x016fa, 0x016fb, 0x016fc, 0x016fd, 0x016fe, 0x016ff
};

static uint32_t unicode_520_ci_page_17[] = {
  0x01700, 0x01701, 0x01702, 0x01703, 0x01704, 0x01705, 0x01706, 0x01707,
  0x01708, 0x01709, 0x0170a, 0x0170b, 0x0170c, 0x0170d, 0x0170e, 0x0170f,
  0x01710, 0x01711, 0x01712, 0x01713, 0x01714, 0x01715, 0x01716, 0x01717,
  0x01718, 0x01719, 0x0171a, 0x0171b, 0x0171c, 0x0171d, 0x0171e, 0x0171f,
  0x01720, 0x01721, 0x01722, 0x01723, 0x01724, 0x01725, 0x01726, 0x01727,
  0x01728, 0x01729, 0x0172a, 0x0172b, 0x0172c, 0x0172d, 0x0172e, 0x0172f,
  0x01730, 0x01731, 0x01732, 0x01733, 0x01734, 0x01735, 0x01736, 0x01737,
  0x01738, 0x01739, 0x0173a, 0x0173b, 0x0173c, 0x0173d, 0x0173e, 0x0173f,
  0x01740, 0x01741, 0x01742, 0x01743, 0x01744, 0x01745, 0x01746, 0x01747,
  0x01748, 0x01749, 0x0174a, 0x0174b, 0x0174c, 0x0174d, 0x0174e, 0x0174f,
  0x01750, 0x01751, 0x01752, 0x01753, 0x01754, 0x01755, 0x01756, 0x01757,
  0x01758, 0x01759, 0x0175a, 0x0175b, 0x0175c, 0x0175d, 0x0175e, 0x0175f,
  0x01760, 0x01761, 0x01762, 0x01763, 0x01764, 0x01765, 0x01766, 0x01767,
  0x01768, 0x01769, 0x0176a, 0x0176b, 0x0176c, 0x0176d, 0x0176e, 0x0176f,
  0x01770, 0x01771, 0x01772, 0x01773, 0x01774, 0x01775, 0x01776, 0x01777,
  0x01778, 0x01779, 0x0177a, 0x0177b, 0x0177c, 0x0177d, 0x0177e, 0x0177f,
  0x01780, 0x01781, 0x01782, 0x01783, 0x01784, 0x01785, 0x01786, 0x01787,
  0x01788, 0x01789, 0x0178a, 0x0178b, 0x0178c, 0x0178d, 0x0178e, 0x0178f,
  0x01790, 0x01791, 0x01792, 0x01793, 0x01794, 0x01795, 0x01796, 0x01797,
  0x01798, 0x01799, 0x0179a, 0x0179b, 0x0179c, 0x0179d, 0x0179e, 0x0179f,
  0x017a0, 0x017a1, 0x017a2, 0x017a3, 0x017a4, 0x017a5, 0x017a6, 0x017a7,
  0x017a8, 0x017a9, 0x017aa, 0x017ab, 0x017ac, 0x017ad, 0x017ae, 0x017af,
  0x017b0, 0x017b1, 0x017b2, 0x017b3, 0x017b4, 0x017b5, 0x017b6, 0x017b7,
  0x017b8, 0x017b9, 0x017ba, 0x017bb, 0x017bc, 0x017bd, 0x017be, 0x017bf,
  0x017c0, 0x017c1, 0x017c2, 0x017c3, 0x017c4, 0x017c5, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x017d2, 0x00000, 0x017d4, 0x017d5, 0x017d6, 0x017d7,
  0x017d8, 0x017d9, 0x017da, 0x017db, 0x017dc, 0x00000, 0x017de, 0x017df,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x017ea, 0x017eb, 0x017ec, 0x017ed, 0x017ee, 0x017ef,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x017fa, 0x017fb, 0x017fc, 0x017fd, 0x017fe, 0x017ff
};

static uint32_t unicode_520_ci_page_18[] = {
  0x01800, 0x01801, 0x01802, 0x01803, 0x01804, 0x01805, 0x01806, 0x01807,
  0x01808, 0x01809, 0x0180a, 0x00000, 0x00000, 0x00000, 0x0180e, 0x0180f,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x0181a, 0x0181b, 0x0181c, 0x0181d, 0x0181e, 0x0181f,
  0x01820, 0x01821, 0x01822, 0x01823, 0x01824, 0x01825, 0x01826, 0x01827,
  0x01828, 0x01829, 0x0182a, 0x0182b, 0x0182c, 0x0182d, 0x0182e, 0x0182f,
  0x01830, 0x01831, 0x01832, 0x01833, 0x01834, 0x01835, 0x01836, 0x01837,
  0x01838, 0x01839, 0x0183a, 0x0183b, 0x0183c, 0x0183d, 0x0183e, 0x0183f,
  0x01840, 0x01841, 0x01842, 0x01843, 0x01844, 0x01845, 0x01846, 0x01847,
  0x01848, 0x01849, 0x0184a, 0x0184b, 0x0184c, 0x0184d, 0x0184e, 0x0184f,
  0x01850, 0x01851, 0x01852, 0x01853, 0x01854, 0x01855, 0x01856, 0x01857,
  0x01858, 0x01859, 0x0185a, 0x0185b, 0x0185c, 0x0185d, 0x0185e, 0x0185f,
  0x01860, 0x01861, 0x01862, 0x01863, 0x01864, 0x01865, 0x01866, 0x01867,
  0x01868, 0x01869, 0x0186a, 0x0186b, 0x0186c, 0x0186d, 0x0186e, 0x0186f,
  0x01870, 0x01871, 0x01872, 0x01873, 0x01874, 0x01875, 0x01876, 0x01877,
  0x01878, 0x01879, 0x0187a, 0x0187b, 0x0187c, 0x0187d, 0x0187e, 0x0187f,
  0x01880, 0x01881, 0x01882, 0x01883, 0x01884, 0x01885, 0x01886, 0x01887,
  0x01888, 0x01889, 0x0188a, 0x0188b, 0x0188c, 0x0188d, 0x0188e, 0x0188f,
  0x01890, 0x01891, 0x01892, 0x01893, 0x01894, 0x01895, 0x01896, 0x01897,
  0x01898, 0x01899, 0x0189a, 0x0189b, 0x0189c, 0x0189d, 0x0189e, 0x0189f,
  0x018a0, 0x018a1, 0x018a2, 0x018a3, 0x018a4, 0x018a5, 0x018a6, 0x018a7,
  0x018a8, 0x018a9, 0x018aa, 0x018ab, 0x018ac, 0x018ad, 0x018ae, 0x018af,
  0x018b0, 0x018b1, 0x018b2, 0x018b3, 0x018b4, 0x018b5, 0x018b6, 0x018b7,
  0x018b8, 0x018b9, 0x018ba, 0x018bb, 0x018bc, 0x018bd, 0x018be, 0x018bf,
  0x018c0, 0x018c1, 0x018c2, 0x018c3, 0x018c4, 0x018c5, 0x018c6, 0x018c7,
  0x018c8, 0x018c9, 0x018ca, 0x018cb, 0x018cc, 0x018cd, 0x018ce, 0x018cf,
  0x018d0, 0x018d1, 0x018d2, 0x018d3, 0x018d4, 0x018d5, 0x018d6, 0x018d7,
  0x018d8, 0x018d9, 0x018da, 0x018db, 0x018dc, 0x018dd, 0x018de, 0x018df,
  0x018e0, 0x018e1, 0x018e2, 0x018e3, 0x018e4, 0x018e5, 0x018e6, 0x018e7,
  0x018e8, 0x018e9, 0x018ea, 0x018eb, 0x018ec, 0x018ed, 0x018ee, 0x018ef,
  0x018f0, 0x018f1, 0x018f2, 0x018f3, 0x018f4, 0x018f5, 0x018f6, 0x018f7,
  0x018f8, 0x018f9, 0x018fa, 0x018fb, 0x018fc, 0x018fd, 0x018fe, 0x018ff
};

static uint32_t unicode_520_ci_page_19[] = {
  0x01900, 0x01901, 0x01902, 0x01903, 0x01904, 0x01905, 0x01906, 0x01907,
  0x01908, 0x01909, 0x0190a, 0x0190b, 0x0190c, 0x0190d, 0x0190e, 0x0190f,
  0x01910, 0x01911, 0x01912, 0x01913, 0x01914, 0x01915, 0x01916, 0x01917,
  0x01918, 0x01919, 0x0191a, 0x0191b, 0x0191c, 0x0191d, 0x0191e, 0x0191f,
  0x01920, 0x01921, 0x01922, 0x01923, 0x01924, 0x01925, 0x01926, 0x01927,
  0x01928, 0x01929, 0x0192a, 0x0192b, 0x0192c, 0x0192d, 0x0192e, 0x0192f,
  0x01930, 0x01931, 0x01932, 0x01933, 0x01934, 0x01935, 0x01936, 0x01937,
  0x01938, 0x00000, 0x00000, 0x00000, 0x0193c, 0x0193d, 0x0193e, 0x0193f,
  0x01940, 0x01941, 0x01942, 0x01943, 0x01944, 0x01945, 0x00030, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039,
  0x01950, 0x01951, 0x01952, 0x01953, 0x01954, 0x01955, 0x01956, 0x01957,
  0x01958, 0x01959, 0x0195a, 0x0195b, 0x0195c, 0x0195d, 0x0195e, 0x0195f,
  0x01960, 0x01961, 0x01962, 0x01963, 0x01964, 0x01965, 0x01966, 0x01967,
  0x01968, 0x01969, 0x0196a, 0x0196b, 0x0196c, 0x0196d, 0x0196e, 0x0196f,
  0x01970, 0x01971, 0x01972, 0x01973, 0x01974, 0x01975, 0x01976, 0x01977,
  0x01978, 0x01979, 0x0197a, 0x0197b, 0x0197c, 0x0197d, 0x0197e, 0x0197f,
  0x01980, 0x01981, 0x01982, 0x01983, 0x01984, 0x01985, 0x01986, 0x01987,
  0x01988, 0x01989, 0x0198a, 0x0198b, 0x0198c, 0x0198d, 0x0198e, 0x0198f,
  0x01990, 0x01991, 0x01992, 0x01993, 0x01994, 0x01995, 0x01996, 0x01997,
  0x01998, 0x01999, 0x0199a, 0x0199b, 0x0199c, 0x0199d, 0x0199e, 0x0199f,
  0x019a0, 0x019a1, 0x019a2, 0x019a3, 0x019a4, 0x019a5, 0x019a6, 0x019a7,
  0x019a8, 0x019a9, 0x019aa, 0x019ab, 0x019ac, 0x019ad, 0x019ae, 0x019af,
  0x019b0, 0x019b1, 0x019b2, 0x019b3, 0x019b4, 0x019b5, 0x019b6, 0x019b7,
  0x019b8, 0x019b9, 0x019ba, 0x019bb, 0x019bc, 0x019bd, 0x019be, 0x019bf,
  0x019c0, 0x019c1, 0x019c2, 0x019c3, 0x019c4, 0x019c5, 0x019c6, 0x019c7,
  0x019c8, 0x019c9, 0x019ca, 0x019cb, 0x019cc, 0x019cd, 0x019ce, 0x019cf,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x00031, 0x019db, 0x019dc, 0x019dd, 0x019de, 0x019df,
  0x019e0, 0x019e1, 0x019e2, 0x019e3, 0x019e4, 0x019e5, 0x019e6, 0x019e7,
  0x019e8, 0x019e9, 0x019ea, 0x019eb, 0x019ec, 0x019ed, 0x019ee, 0x019ef,
  0x019f0, 0x019f1, 0x019f2, 0x019f3, 0x019f4, 0x019f5, 0x019f6, 0x019f7,
  0x019f8, 0x019f9, 0x019fa, 0x019fb, 0x019fc, 0x019fd, 0x019fe, 0x019ff
};

static uint32_t unicode_520_ci_page_1a[] = {
  0x01a00, 0x01a01, 0x01a02, 0x01a03, 0x01a04, 0x01a05, 0x01a06, 0x01a07,
  0x01a08, 0x01a09, 0x01a0a, 0x01a0b, 0x01a0c, 0x01a0d, 0x01a0e, 0x01a0f,
  0x01a10, 0x01a11, 0x01a12, 0x01a13, 0x01a14, 0x01a15, 0x01a16, 0x01a17,
  0x01a18, 0x01a19, 0x01a1a, 0x01a1b, 0x01a1c, 0x01a1d, 0x01a1e, 0x01a1f,
  0x01a20, 0x01a21, 0x01a22, 0x01a23, 0x01a24, 0x01a25, 0x01a26, 0x01a27,
  0x01a28, 0x01a29, 0x01a2a, 0x01a2b, 0x01a2c, 0x01a2d, 0x01a2e, 0x01a2f,
  0x01a30, 0x01a31, 0x01a32, 0x01a33, 0x01a34, 0x01a35, 0x01a36, 0x01a37,
  0x01a38, 0x01a39, 0x01a3a, 0x01a3b, 0x01a3c, 0x01a3d, 0x01a3e, 0x01a3f,
  0x01a40, 0x01a41, 0x01a42, 0x01a43, 0x01a44, 0x01a45, 0x01a46, 0x01a47,
  0x01a48, 0x01a49, 0x01a4a, 0x01a4b, 0x01a4c, 0x01a4d, 0x01a4e, 0x01a4f,
  0x01a50, 0x01a51, 0x01a52, 0x01a53, 0x01a54, 0x01a55, 0x01a56, 0x01a57,
  0x01a26, 0x01a26, 0x01a3b, 0x01a3b, 0x01a5c, 0x01a5d, 0x01a5e, 0x01a5f,
  0x01a60, 0x01a61, 0x01a62, 0x01a63, 0x01a63, 0x01a65, 0x01a66, 0x01a67,
  0x01a68, 0x01a69, 0x01a6a, 0x01a6b, 0x01a6c, 0x01a6d, 0x01a6e, 0x01a6f,
  0x01a70, 0x01a71, 0x01a72, 0x01a73, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x01a7d, 0x01a7e, 0x00000,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x01a8a, 0x01a8b, 0x01a8c, 0x01a8d, 0x01a8e, 0x01a8f,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x01a9a, 0x01a9b, 0x01a9c, 0x01a9d, 0x01a9e, 0x01a9f,
  0x01aa0, 0x01aa1, 0x01aa2, 0x01aa3, 0x01aa4, 0x01aa5, 0x01aa6, 0x01aa7,
  0x01aa8, 0x01aa9, 0x01aaa, 0x01aab, 0x01aac, 0x01aad, 0x01aae, 0x01aaf,
  0x01ab0, 0x01ab1, 0x01ab2, 0x01ab3, 0x01ab4, 0x01ab5, 0x01ab6, 0x01ab7,
  0x01ab8, 0x01ab9, 0x01aba, 0x01abb, 0x01abc, 0x01abd, 0x01abe, 0x01abf,
  0x01ac0, 0x01ac1, 0x01ac2, 0x01ac3, 0x01ac4, 0x01ac5, 0x01ac6, 0x01ac7,
  0x01ac8, 0x01ac9, 0x01aca, 0x01acb, 0x01acc, 0x01acd, 0x01ace, 0x01acf,
  0x01ad0, 0x01ad1, 0x01ad2, 0x01ad3, 0x01ad4, 0x01ad5, 0x01ad6, 0x01ad7,
  0x01ad8, 0x01ad9, 0x01ada, 0x01adb, 0x01adc, 0x01add, 0x01ade, 0x01adf,
  0x01ae0, 0x01ae1, 0x01ae2, 0x01ae3, 0x01ae4, 0x01ae5, 0x01ae6, 0x01ae7,
  0x01ae8, 0x01ae9, 0x01aea, 0x01aeb, 0x01aec, 0x01aed, 0x01aee, 0x01aef,
  0x01af0, 0x01af1, 0x01af2, 0x01af3, 0x01af4, 0x01af5, 0x01af6, 0x01af7,
  0x01af8, 0x01af9, 0x01afa, 0x01afb, 0x01afc, 0x01afd, 0x01afe, 0x01aff
};

static uint32_t unicode_520_ci_page_1b[] = {
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x01b05, 0x01b06, 0x01b07,
  0x01b08, 0x01b09, 0x01b0a, 0x01b0b, 0x01b0c, 0x01b0d, 0x01b0e, 0x01b0f,
  0x01b10, 0x01b11, 0x01b12, 0x01b13, 0x01b14, 0x01b15, 0x01b16, 0x01b17,
  0x01b18, 0x01b19, 0x01b1a, 0x01b1b, 0x01b1c, 0x01b1d, 0x01b1e, 0x01b1f,
  0x01b20, 0x01b21, 0x01b22, 0x01b23, 0x01b24, 0x01b25, 0x01b26, 0x01b27,
  0x01b28, 0x01b29, 0x01b2a, 0x01b2b, 0x01b2c, 0x01b2d, 0x01b2e, 0x01b2f,
  0x01b30, 0x01b31, 0x01b32, 0x01b33, 0x00000, 0x01b35, 0x01b36, 0x01b37,
  0x01b38, 0x01b39, 0x01b3a, 0x01b3b, 0x01b3c, 0x01b3d, 0x01b3e, 0x01b3f,
  0x01b40, 0x01b41, 0x01b42, 0x01b43, 0x01b44, 0x01b45, 0x01b46, 0x01b47,
  0x01b48, 0x01b49, 0x01b4a, 0x01b4b, 0x01b4c, 0x01b4d, 0x01b4e, 0x01b4f,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x01b5a, 0x01b5b, 0x01b5c, 0x01b5d, 0x01b5e, 0x01b5f,
  0x01b60, 0x01b61, 0x01b62, 0x01b63, 0x01b64, 0x01b65, 0x01b66, 0x01b67,
  0x01b68, 0x01b69, 0x01b6a, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x01b74, 0x01b75, 0x01b76, 0x01b77,
  0x01b78, 0x01b79, 0x01b7a, 0x01b7b, 0x01b7c, 0x01b7d, 0x01b7e, 0x01b7f,
  0x00000, 0x00000, 0x00000, 0x01b83, 0x01b84, 0x01b85, 0x01b86, 0x01b87,
  0x01b88, 0x01b89, 0x01b8a, 0x01b8b, 0x01b8c, 0x01b8d, 0x01b8e, 0x01b8f,
  0x01b90, 0x01b91, 0x01b92, 0x01b93, 0x01b94, 0x01b95, 0x01b96, 0x01b97,
  0x01b98, 0x01b99, 0x01b9a, 0x01b9b, 0x01b9c, 0x01b9d, 0x01b9e, 0x01b9f,
  0x01ba0, 0x01ba1, 0x01ba2, 0x01ba3, 0x01ba4, 0x01ba5, 0x01ba6, 0x01ba7,
  0x01ba8, 0x01ba9, 0x01baa, 0x01bab, 0x01bac, 0x01bad, 0x01bae, 0x01baf,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x01bba, 0x01bbb, 0x01bbc, 0x01bbd, 0x01bbe, 0x01bbf,
  0x01bc0, 0x01bc1, 0x01bc2, 0x01bc3, 0x01bc4, 0x01bc5, 0x01bc6, 0x01bc7,
  0x01bc8, 0x01bc9, 0x01bca, 0x01bcb, 0x01bcc, 0x01bcd, 0x01bce, 0x01bcf,
  0x01bd0, 0x01bd1, 0x01bd2, 0x01bd3, 0x01bd4, 0x01bd5, 0x01bd6, 0x01bd7,
  0x01bd8, 0x01bd9, 0x01bda, 0x01bdb, 0x01bdc, 0x01bdd, 0x01bde, 0x01bdf,
  0x01be0, 0x01be1, 0x01be2, 0x01be3, 0x01be4, 0x01be5, 0x01be6, 0x01be7,
  0x01be8, 0x01be9, 0x01bea, 0x01beb, 0x01bec, 0x01bed, 0x01bee, 0x01bef,
  0x01bf0, 0x01bf1, 0x01bf2, 0x01bf3, 0x01bf4, 0x01bf5, 0x01bf6, 0x01bf7,
  0x01bf8, 0x01bf9, 0x01bfa, 0x01bfb, 0x01bfc, 0x01bfd, 0x01bfe, 0x01bff
};

static uint32_t unicode_520_ci_page_1c[] = {
  0x01c00, 0x01c01, 0x01c02, 0x01c03, 0x01c04, 0x01c05, 0x01c06, 0x01c07,
  0x01c08, 0x01c09, 0x01c0a, 0x01c0b, 0x01c0c, 0x01c0d, 0x01c0e, 0x01c0f,
  0x01c10, 0x01c11, 0x01c12, 0x01c13, 0x01c14, 0x01c15, 0x01c16, 0x01c17,
  0x01c18, 0x01c19, 0x01c1a, 0x01c1b, 0x01c1c, 0x01c1d, 0x01c1e, 0x01c1f,
  0x01c20, 0x01c21, 0x01c22, 0x01c23, 0x01c24, 0x01c25, 0x01c26, 0x01c27,
  0x01c28, 0x01c29, 0x01c2a, 0x01c2b, 0x01c2c, 0x01c2d, 0x01c2e, 0x01c2f,
  0x01c30, 0x01c31, 0x01c32, 0x01c33, 0x01c34, 0x01c35, 0x01c36, 0x00000,
  0x01c38, 0x01c39, 0x01c3a, 0x01c3b, 0x01c3c, 0x01c3d, 0x01c3e, 0x01c3f,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x01c4a, 0x01c4b, 0x01c4c, 0x01c4d, 0x01c4e, 0x01c4f,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x01c5a, 0x01c5b, 0x01c5c, 0x01c5d, 0x01c5e, 0x01c5f,
  0x01c60, 0x01c61, 0x01c62, 0x01c63, 0x01c64, 0x01c65, 0x01c66, 0x01c67,
  0x01c68, 0x01c69, 0x01c6a, 0x01c6b, 0x01c6c, 0x01c6d, 0x01c6e, 0x01c6f,
  0x01c70, 0x01c71, 0x01c72, 0x01c73, 0x01c74, 0x01c75, 0x01c76, 0x01c77,
  0x01c78, 0x01c79, 0x01c7a, 0x01c7b, 0x01c7c, 0x01c7d, 0x01c7e, 0x01c7f,
  0x01c80, 0x01c81, 0x01c82, 0x01c83, 0x01c84, 0x01c85, 0x01c86, 0x01c87,
  0x01c88, 0x01c89, 0x01c8a, 0x01c8b, 0x01c8c, 0x01c8d, 0x01c8e, 0x01c8f,
  0x01c90, 0x01c91, 0x01c92, 0x01c93, 0x01c94, 0x01c95, 0x01c96, 0x01c97,
  0x01c98, 0x01c99, 0x01c9a, 0x01c9b, 0x01c9c, 0x01c9d, 0x01c9e, 0x01c9f,
  0x01ca0, 0x01ca1, 0x01ca2, 0x01ca3, 0x01ca4, 0x01ca5, 0x01ca6, 0x01ca7,
  0x01ca8, 0x01ca9, 0x01caa, 0x01cab, 0x01cac, 0x01cad, 0x01cae, 0x01caf,
  0x01cb0, 0x01cb1, 0x01cb2, 0x01cb3, 0x01cb4, 0x01cb5, 0x01cb6, 0x01cb7,
  0x01cb8, 0x01cb9, 0x01cba, 0x01cbb, 0x01cbc, 0x01cbd, 0x01cbe, 0x01cbf,
  0x01cc0, 0x01cc1, 0x01cc2, 0x01cc3, 0x01cc4, 0x01cc5, 0x01cc6, 0x01cc7,
  0x01cc8, 0x01cc9, 0x01cca, 0x01ccb, 0x01ccc, 0x01ccd, 0x01cce, 0x01ccf,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x01ce9, 0x01ce9, 0x01ce9, 0x01ce9, 0x00000, 0x01ce9, 0x01ce9,
  0x01ce9, 0x01ce9, 0x00000, 0x01cf3, 0x01cf4, 0x01cf5, 0x01cf6, 0x01cf7,
  0x01cf8, 0x01cf9, 0x01cfa, 0x01cfb, 0x01cfc, 0x01cfd, 0x01cfe, 0x01cff
};

static uint32_t unicode_520_ci_page_1d[] = {
  0x01d00, 0x01d01, 0x01d02, 0x01d03, 0x01d04, 0x01d05, 0x01d06, 0x01d07,
  0x01d08, 0x01d09, 0x01d0a, 0x01d0b, 0x01d0c, 0x01d0d, 0x01d0e, 0x01d0f,
  0x01d10, 0x01d11, 0x01d12, 0x01d13, 0x01d14, 0x01d15, 0x01d16, 0x01d17,
  0x01d18, 0x01d19, 0x01d1a, 0x01d1b, 0x01d1c, 0x01d1d, 0x01d1e, 0x01d1f,
  0x01d20, 0x01d21, 0x01d22, 0x01d23, 0x01d24, 0x01d25, 0x01d26, 0x01d27,
  0x01d28, 0x01d29, 0x01d2a, 0x01d2b, 0x00041, 0x000c6, 0x00042, 0x01d2f,
  0x00044, 0x00045, 0x0018e, 0x00047, 0x00048, 0x00049, 0x0004a, 0x0004b,
  0x0004c, 0x0004d, 0x0004e, 0x01d3b, 0x0004f, 0x00222, 0x00050, 0x00052,
  0x00054, 0x00055, 0x00057, 0x00041, 0x00250, 0x00251, 0x01d02, 0x00042,
  0x00044, 0x00045, 0x0018f, 0x00190, 0x01d08, 0x00047, 0x01d09, 0x0004b,
  0x0004d, 0x0014a, 0x0004f, 0x00186, 0x01d16, 0x01d17, 0x00050, 0x00054,
  0x00055, 0x01d1d, 0x0019c, 0x00056, 0x01d25, 0x00392, 0x00393, 0x00394,
  0x003a6, 0x003a7, 0x00049, 0x00052, 0x00055, 0x00056, 0x00392, 0x00393,
  0x003a1, 0x003a6, 0x003a7, 0x01d6b, 0x01d6c, 0x01d6d, 0x01d6e, 0x01d6f,
  0x01d70, 0x01d71, 0x01d72, 0x01d73, 0x01d74, 0x01d75, 0x01d76, 0x01d77,
  0x0041d, 0x00047, 0x01d7a, 0x01d7b, 0x01d7c, 0x01d7d, 0x01d7e, 0x01d7f,
  0x01d80, 0x01d81, 0x01d82, 0x01d83, 0x01d84, 0x01d85, 0x01d86, 0x01d87,
  0x01d88, 0x01d89, 0x01d8a, 0x01d8b, 0x01d8c, 0x01d8d, 0x01d8e, 0x01d8f,
  0x01d90, 0x01d91, 0x01d92, 0x01d93, 0x01d94, 0x01d95, 0x01d96, 0x01d97,
  0x01d98, 0x01d99, 0x01d9a, 0x00252, 0x00043, 0x00255, 0x00044, 0x0025c,
  0x00046, 0x0025f, 0x00261, 0x00265, 0x00197, 0x00196, 0x0026a, 0x01d7b,
  0x0029d, 0x0026d, 0x01d85, 0x0029f, 0x00271, 0x00270, 0x0019d, 0x00273,
  0x00274, 0x0019f, 0x00278, 0x00282, 0x001a9, 0x001ab, 0x00244, 0x001b1,
  0x01d1c, 0x001b2, 0x00245, 0x0005a, 0x00290, 0x00291, 0x001b7, 0x00398,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00052, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x01dd2, 0x00041, 0x000c6, 0x01dd5, 0x01dd6, 0x00043,
  0x00044, 0x00044, 0x00047, 0x00262, 0x0004b, 0x0004c, 0x0029f, 0x01d0d,
  0x0004e, 0x00274, 0x001a6, 0x01de3, 0x00053, 0x00053, 0x0005a, 0x01de7,
  0x01de8, 0x01de9, 0x01dea, 0x01deb, 0x01dec, 0x01ded, 0x01dee, 0x01def,
  0x01df0, 0x01df1, 0x01df2, 0x01df3, 0x01df4, 0x01df5, 0x01df6, 0x01df7,
  0x01df8, 0x01df9, 0x01dfa, 0x01dfb, 0x01dfc, 0x00000, 0x00000, 0x01dff
};

static uint32_t unicode_520_ci_page_1e[] = {
  0x00041, 0x00041, 0x00042, 0x00042, 0x00042, 0x00042, 0x00042, 0x00042,
  0x00043, 0x00043, 0x00044, 0x00044, 0x00044, 0x00044, 0x00044, 0x00044,
  0x00044, 0x00044, 0x00044, 0x00044, 0x00045, 0x00045, 0x00045, 0x00045,
  0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00046, 0x00046,
  0x00047, 0x00047, 0x00048, 0x00048, 0x00048, 0x00048, 0x00048, 0x00048,
  0x00048, 0x00048, 0x00048, 0x00048, 0x00049, 0x00049, 0x00049, 0x00049,
  0x0004b, 0x0004b, 0x0004b, 0x0004b, 0x0004b, 0x0004b, 0x0004c, 0x0004c,
  0x0004c, 0x0004c, 0x0004c, 0x0004c, 0x0004c, 0x0004c, 0x0004d, 0x0004d,
  0x0004d, 0x0004d, 0x0004d, 0x0004d, 0x0004e, 0x0004e, 0x0004e, 0x0004e,
  0x0004e, 0x0004e, 0x0004e, 0x0004e, 0x0004f, 0x0004f, 0x0004f, 0x0004f,
  0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x00050, 0x00050, 0x00050, 0x00050,
  0x00052, 0x00052, 0x00052, 0x00052, 0x00052, 0x00052, 0x00052, 0x00052,
  0x00053, 0x00053, 0x00053, 0x00053, 0x00053, 0x00053, 0x00053, 0x00053,
  0x00053, 0x00053, 0x00054, 0x00054, 0x00054, 0x00054, 0x00054, 0x00054,
  0x00054, 0x00054, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055,
  0x00055, 0x00055, 0x00055, 0x00055, 0x00056, 0x00056, 0x00056, 0x00056,
  0x00057, 0x00057, 0x00057, 0x00057, 0x00057, 0x00057, 0x00057, 0x00057,
  0x00057, 0x00057, 0x00058, 0x00058, 0x00058, 0x00058, 0x00059, 0x00059,
  0x0005a, 0x0005a, 0x0005a, 0x0005a, 0x0005a, 0x0005a, 0x00048, 0x00054,
  0x00057, 0x00059, 0x01e9a, 0x00053, 0x01e9c, 0x01e9d, 0x000df, 0x01e9f,
  0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041,
  0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041,
  0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041,
  0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045,
  0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045,
  0x00049, 0x00049, 0x00049, 0x00049, 0x0004f, 0x0004f, 0x0004f, 0x0004f,
  0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f,
  0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f,
  0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x00055, 0x00055, 0x00055, 0x00055,
  0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055,
  0x00055, 0x00055, 0x00059, 0x00059, 0x00059, 0x00059, 0x00059, 0x00059,
  0x00059, 0x00059, 0x01efa, 0x01efa, 0x01efc, 0x01efc, 0x01efe, 0x01eff
};

static uint32_t unicode_520_ci_page_1f[] = {
  0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391,
  0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391,
  0x00395, 0x00395, 0x00395, 0x00395, 0x00395, 0x00395, 0x01f16, 0x01f17,
  0x00395, 0x00395, 0x00395, 0x00395, 0x00395, 0x00395, 0x01f1e, 0x01f1f,
  0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397,
  0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397,
  0x00399, 0x00399, 0x00399, 0x00399, 0x00399, 0x00399, 0x00399, 0x00399,
  0x00399, 0x00399, 0x00399, 0x00399, 0x00399, 0x00399, 0x00399, 0x00399,
  0x0039f, 0x0039f, 0x0039f, 0x0039f, 0x0039f, 0x0039f, 0x01f46, 0x01f47,
  0x0039f, 0x0039f, 0x0039f, 0x0039f, 0x0039f, 0x0039f, 0x01f4e, 0x01f4f,
  0x003a5, 0x003a5, 0x003a5, 0x003a5, 0x003a5, 0x003a5, 0x003a5, 0x003a5,
  0x01f58, 0x003a5, 0x01f5a, 0x003a5, 0x01f5c, 0x003a5, 0x01f5e, 0x003a5,
  0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9,
  0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9,
  0x00391, 0x00391, 0x00395, 0x00395, 0x00397, 0x00397, 0x00399, 0x00399,
  0x0039f, 0x0039f, 0x003a5, 0x003a5, 0x003a9, 0x003a9, 0x01f7e, 0x01f7f,
  0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391,
  0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x00391,
  0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397,
  0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397, 0x00397,
  0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9,
  0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9, 0x003a9,
  0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x01fb5, 0x00391, 0x00391,
  0x00391, 0x00391, 0x00391, 0x00391, 0x00391, 0x01fbd, 0x00399, 0x01fbd,
  0x01fc0, 0x000a8, 0x00397, 0x00397, 0x00397, 0x01fc5, 0x00397, 0x00397,
  0x00395, 0x00395, 0x00397, 0x00397, 0x00397, 0x01fbd, 0x01fbd, 0x01fbd,
  0x00399, 0x00399, 0x00399, 0x00399, 0x01fd4, 0x01fd5, 0x00399, 0x00399,
  0x00399, 0x00399, 0x00399, 0x00399, 0x01fdc, 0x01fdd, 0x01fdd, 0x01fdd,
  0x003a5, 0x003a5, 0x003a5, 0x003a5, 0x003a1, 0x003a1, 0x003a5, 0x003a5,
  0x003a5, 0x003a5, 0x003a5, 0x003a5, 0x003a1, 0x000a8, 0x000a8, 0x00060,
  0x01ff0, 0x01ff1, 0x003a9, 0x003a9, 0x003a9, 0x01ff5, 0x003a9, 0x003a9,
  0x0039f, 0x0039f, 0x003a9, 0x003a9, 0x003a9, 0x000b4, 0x01fdd, 0x01fff
};

static uint32_t unicode_520_ci_page_20[] = {
  0x00020, 0x00020, 0x00020, 0x00020, 0x00020, 0x00020, 0x00020, 0x00020,
  0x00020, 0x00020, 0x00020, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x02010, 0x02010, 0x02012, 0x02013, 0x02014, 0x02015, 0x02016, 0x02017,
  0x02018, 0x02019, 0x0201a, 0x0201b, 0x0201c, 0x0201d, 0x0201e, 0x0201f,
  0x02020, 0x02021, 0x02022, 0x02023, 0x0002e, 0x02025, 0x02026, 0x02027,
  0x02028, 0x02029, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00020,
  0x02030, 0x02031, 0x02032, 0x02033, 0x02034, 0x02035, 0x02036, 0x02037,
  0x02038, 0x02039, 0x0203a, 0x0203b, 0x0203c, 0x0203d, 0x0203e, 0x0203f,
  0x02040, 0x02041, 0x02042, 0x02043, 0x02044, 0x02045, 0x02046, 0x02047,
  0x02048, 0x02049, 0x0204a, 0x0204b, 0x0204c, 0x0204d, 0x0204e, 0x0204f,
  0x02050, 0x02051, 0x02052, 0x02053, 0x02054, 0x02055, 0x02056, 0x02057,
  0x02058, 0x02059, 0x0205a, 0x0205b, 0x0205c, 0x0205d, 0x0205e, 0x00020,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x02065, 0x02066, 0x02067,
  0x02068, 0x02069, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00030, 0x00049, 0x02072, 0x02073, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x0002b, 0x0207b, 0x0003d, 0x00028, 0x00029, 0x0004e,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x0002b, 0x0207b, 0x0003d, 0x00028, 0x00029, 0x0208f,
  0x00041, 0x00045, 0x0004f, 0x00058, 0x0018f, 0x02095, 0x02096, 0x02097,
  0x02098, 0x02099, 0x0209a, 0x0209b, 0x0209c, 0x0209d, 0x0209e, 0x0209f,
  0x020a0, 0x020a1, 0x020a2, 0x020a3, 0x020a4, 0x020a5, 0x020a6, 0x020a7,
  0x020a8, 0x020a9, 0x020aa, 0x020ab, 0x020ac, 0x020ad, 0x020ae, 0x020af,
  0x020b0, 0x020b1, 0x020b2, 0x020b3, 0x020b4, 0x020b5, 0x020b6, 0x020b7,
  0x020b8, 0x020b9, 0x020ba, 0x020bb, 0x020bc, 0x020bd, 0x020be, 0x020bf,
  0x020c0, 0x020c1, 0x020c2, 0x020c3, 0x020c4, 0x020c5, 0x020c6, 0x020c7,
  0x020c8, 0x020c9, 0x020ca, 0x020cb, 0x020cc, 0x020cd, 0x020ce, 0x020cf,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x020f1, 0x020f2, 0x020f3, 0x020f4, 0x020f5, 0x020f6, 0x020f7,
  0x020f8, 0x020f9, 0x020fa, 0x020fb, 0x020fc, 0x020fd, 0x020fe, 0x020ff
};

static uint32_t unicode_520_ci_page_21[] = {
  0x02100, 0x02101, 0x00043, 0x02103, 0x02104, 0x02105, 0x02106, 0x00190,
  0x02108, 0x02109, 0x00047, 0x00048, 0x00048, 0x00048, 0x00048, 0x00048,
  0x00049, 0x00049, 0x0004c, 0x0004c, 0x02114, 0x0004e, 0x02116, 0x02117,
  0x02118, 0x00050, 0x00051, 0x00052, 0x00052, 0x00052, 0x0211e, 0x0211f,
  0x02120, 0x02121, 0x02122, 0x02123, 0x0005a, 0x02125, 0x003a9, 0x02127,
  0x0005a, 0x02129, 0x0004b, 0x00041, 0x00042, 0x00043, 0x0212e, 0x00045,
  0x00045, 0x00046, 0x02132, 0x0004d, 0x0004f, 0x005d0, 0x005d1, 0x005d2,
  0x005d3, 0x00049, 0x0213a, 0x0213b, 0x003a0, 0x00393, 0x00393, 0x003a0,
  0x02140, 0x02141, 0x02142, 0x02143, 0x02144, 0x00044, 0x00044, 0x00045,
  0x00049, 0x0004a, 0x0214a, 0x0214b, 0x0214c, 0x0214d, 0x02132, 0x0214f,
  0x02150, 0x02151, 0x02152, 0x02153, 0x02154, 0x02155, 0x02156, 0x02157,
  0x02158, 0x02159, 0x0215a, 0x0215b, 0x0215c, 0x0215d, 0x0215e, 0x0215f,
  0x00049, 0x02161, 0x02162, 0x02163, 0x00056, 0x02165, 0x02166, 0x02167,
  0x02168, 0x00058, 0x0216a, 0x0216b, 0x0004c, 0x00043, 0x00044, 0x0004d,
  0x00049, 0x02161, 0x02162, 0x02163, 0x00056, 0x02165, 0x02166, 0x02167,
  0x02168, 0x00058, 0x0216a, 0x0216b, 0x0004c, 0x00043, 0x00044, 0x0004d,
  0x02180, 0x02181, 0x02182, 0x02183, 0x02183, 0x00036, 0x02186, 0x02187,
  0x02188, 0x02189, 0x0218a, 0x0218b, 0x0218c, 0x0218d, 0x0218e, 0x0218f,
  0x02190, 0x02191, 0x02192, 0x02193, 0x02194, 0x02195, 0x02196, 0x02197,
  0x02198, 0x02199, 0x02190, 0x02192, 0x0219c, 0x0219d, 0x0219e, 0x0219f,
  0x021a0, 0x021a1, 0x021a2, 0x021a3, 0x021a4, 0x021a5, 0x021a6, 0x021a7,
  0x021a8, 0x021a9, 0x021aa, 0x021ab, 0x021ac, 0x021ad, 0x02194, 0x021af,
  0x021b0, 0x021b1, 0x021b2, 0x021b3, 0x021b4, 0x021b5, 0x021b6, 0x021b7,
  0x021b8, 0x021b9, 0x021ba, 0x021bb, 0x021bc, 0x021bd, 0x021be, 0x021bf,
  0x021c0, 0x021c1, 0x021c2, 0x021c3, 0x021c4, 0x021c5, 0x021c6, 0x021c7,
  0x021c8, 0x021c9, 0x021ca, 0x021cb, 0x021cc, 0x021cd, 0x021ce, 0x021cf,
  0x021cd, 0x021d1, 0x021cf, 0x021d3, 0x021ce, 0x021d5, 0x021d6, 0x021d7,
  0x021d8, 0x021d9, 0x021da, 0x021db, 0x021dc, 0x021dd, 0x021de, 0x021df,
  0x021e0, 0x021e1, 0x021e2, 0x021e3, 0x021e4, 0x021e5, 0x021e6, 0x021e7,
  0x021e8, 0x021e9, 0x021ea, 0x021eb, 0x021ec, 0x021ed, 0x021ee, 0x021ef,
  0x021f0, 0x021f1, 0x021f2, 0x021f3, 0x021f4, 0x021f5, 0x021f6, 0x021f7,
  0x021f8, 0x021f9, 0x021fa, 0x021fb, 0x021fc, 0x021fd, 0x021fe, 0x021ff
};

static uint32_t unicode_520_ci_page_22[] = {
  0x02200, 0x02201, 0x02202, 0x02203, 0x02203, 0x02205, 0x02206, 0x02207,
  0x02208, 0x02208, 0x0220a, 0x0220b, 0x0220b, 0x0220d, 0x0220e, 0x0220f,
  0x02210, 0x02140, 0x0207b, 0x02213, 0x02214, 0x02215, 0x02216, 0x02217,
  0x02218, 0x02219, 0x0221a, 0x0221b, 0x0221c, 0x0221d, 0x0221e, 0x0221f,
  0x02220, 0x02221, 0x02222, 0x02223, 0x02223, 0x02225, 0x02225, 0x02227,
  0x02228, 0x02229, 0x0222a, 0x0222b, 0x0222c, 0x0222d, 0x0222e, 0x0222f,
  0x02230, 0x02231, 0x02232, 0x02233, 0x02234, 0x02235, 0x02236, 0x02237,
  0x02238, 0x02239, 0x0223a, 0x0223b, 0x0223c, 0x0223d, 0x0223e, 0x0223f,
  0x02240, 0x0223c, 0x02242, 0x02243, 0x02243, 0x02245, 0x02246, 0x02245,
  0x02248, 0x02248, 0x0224a, 0x0224b, 0x0224c, 0x0224d, 0x0224e, 0x0224f,
  0x02250, 0x02251, 0x02252, 0x02253, 0x02254, 0x02255, 0x02256, 0x02257,
  0x02258, 0x02259, 0x0225a, 0x0225b, 0x0225c, 0x0225d, 0x0225e, 0x0225f,
  0x0003d, 0x02261, 0x02261, 0x02263, 0x02264, 0x02265, 0x02266, 0x02267,
  0x02268, 0x02269, 0x0226a, 0x0226b, 0x0226c, 0x0224d, 0x0003c, 0x0003e,
  0x02264, 0x02265, 0x02272, 0x02273, 0x02272, 0x02273, 0x02276, 0x02277,
  0x02276, 0x02277, 0x0227a, 0x0227b, 0x0227c, 0x0227d, 0x0227e, 0x0227f,
  0x0227a, 0x0227b, 0x02282, 0x02283, 0x02282, 0x02283, 0x02286, 0x02287,
  0x02286, 0x02287, 0x0228a, 0x0228b, 0x0228c, 0x0228d, 0x0228e, 0x0228f,
  0x02290, 0x02291, 0x02292, 0x02293, 0x02294, 0x02295, 0x02296, 0x02297,
  0x02298, 0x02299, 0x0229a, 0x0229b, 0x0229c, 0x0229d, 0x0229e, 0x0229f,
  0x022a0, 0x022a1, 0x022a2, 0x022a3, 0x022a4, 0x022a5, 0x022a6, 0x022a7,
  0x022a8, 0x022a9, 0x022aa, 0x022ab, 0x022a2, 0x022a8, 0x022a9, 0x022ab,
  0x022b0, 0x022b1, 0x022b2, 0x022b3, 0x022b4, 0x022b5, 0x022b6, 0x022b7,
  0x022b8, 0x022b9, 0x022ba, 0x022bb, 0x022bc, 0x022bd, 0x022be, 0x022bf,
  0x022c0, 0x022c1, 0x022c2, 0x022c3, 0x022c4, 0x022c5, 0x022c6, 0x022c7,
  0x022c8, 0x022c9, 0x022ca, 0x022cb, 0x022cc, 0x022cd, 0x022ce, 0x022cf,
  0x022d0, 0x022d1, 0x022d2, 0x022d3, 0x022d4, 0x022d5, 0x022d6, 0x022d7,
  0x022d8, 0x022d9, 0x022da, 0x022db, 0x022dc, 0x022dd, 0x022de, 0x022df,
  0x0227c, 0x0227d, 0x02291, 0x02292, 0x022e4, 0x022e5, 0x022e6, 0x022e7,
  0x022e8, 0x022e9, 0x022b2, 0x022b3, 0x022b4, 0x022b5, 0x022ee, 0x022ef,
  0x022f0, 0x022f1, 0x022f2, 0x022f3, 0x022f4, 0x022f5, 0x022f6, 0x022f7,
  0x022f8, 0x022f9, 0x022fa, 0x022fb, 0x022fc, 0x022fd, 0x022fe, 0x022ff
};

static uint32_t unicode_520_ci_page_24[] = {
  0x02400, 0x02401, 0x02402, 0x02403, 0x02404, 0x02405, 0x02406, 0x02407,
  0x02408, 0x02409, 0x0240a, 0x0240b, 0x0240c, 0x0240d, 0x0240e, 0x0240f,
  0x02410, 0x02411, 0x02412, 0x02413, 0x02414, 0x02415, 0x02416, 0x02417,
  0x02418, 0x02419, 0x0241a, 0x0241b, 0x0241c, 0x0241d, 0x0241e, 0x0241f,
  0x02420, 0x02421, 0x02422, 0x02423, 0x02424, 0x02425, 0x02426, 0x02427,
  0x02428, 0x02429, 0x0242a, 0x0242b, 0x0242c, 0x0242d, 0x0242e, 0x0242f,
  0x02430, 0x02431, 0x02432, 0x02433, 0x02434, 0x02435, 0x02436, 0x02437,
  0x02438, 0x02439, 0x0243a, 0x0243b, 0x0243c, 0x0243d, 0x0243e, 0x0243f,
  0x02440, 0x02441, 0x02442, 0x02443, 0x02444, 0x02445, 0x02446, 0x02447,
  0x02448, 0x02449, 0x0244a, 0x0244b, 0x0244c, 0x0244d, 0x0244e, 0x0244f,
  0x02450, 0x02451, 0x02452, 0x02453, 0x02454, 0x02455, 0x02456, 0x02457,
  0x02458, 0x02459, 0x0245a, 0x0245b, 0x0245c, 0x0245d, 0x0245e, 0x0245f,
  0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038,
  0x00039, 0x02469, 0x0246a, 0x0246b, 0x0246c, 0x0246d, 0x0246e, 0x0246f,
  0x02470, 0x02471, 0x02472, 0x02473, 0x02474, 0x02475, 0x02476, 0x02477,
  0x02478, 0x02479, 0x0247a, 0x0247b, 0x0247c, 0x0247d, 0x0247e, 0x0247f,
  0x02480, 0x02481, 0x02482, 0x02483, 0x02484, 0x02485, 0x02486, 0x02487,
  0x02488, 0x02489, 0x0248a, 0x0248b, 0x0248c, 0x0248d, 0x0248e, 0x0248f,
  0x02490, 0x02491, 0x02492, 0x02493, 0x02494, 0x02495, 0x02496, 0x02497,
  0x02498, 0x02499, 0x0249a, 0x0249b, 0x0249c, 0x0249d, 0x0249e, 0x0249f,
  0x024a0, 0x024a1, 0x024a2, 0x024a3, 0x024a4, 0x024a5, 0x024a6, 0x024a7,
  0x024a8, 0x024a9, 0x024aa, 0x024ab, 0x024ac, 0x024ad, 0x024ae, 0x024af,
  0x024b0, 0x024b1, 0x024b2, 0x024b3, 0x024b4, 0x024b5, 0x00041, 0x00042,
  0x00043, 0x00044, 0x00045, 0x00046, 0x00047, 0x00048, 0x00049, 0x0004a,
  0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f, 0x00050, 0x00051, 0x00052,
  0x00053, 0x00054, 0x00055, 0x00056, 0x00057, 0x00058, 0x00059, 0x0005a,
  0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046, 0x00047, 0x00048,
  0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f, 0x00050,
  0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056, 0x00057, 0x00058,
  0x00059, 0x0005a, 0x00030, 0x0246a, 0x0246b, 0x0246c, 0x0246d, 0x0246e,
  0x0246f, 0x02470, 0x02471, 0x02472, 0x02473, 0x00031, 0x00032, 0x00033,
  0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039, 0x02469, 0x024ff
};

static uint32_t unicode_520_ci_page_27[] = {
  0x02700, 0x02701, 0x02702, 0x02703, 0x02704, 0x02705, 0x02706, 0x02707,
  0x02708, 0x02709, 0x0270a, 0x0270b, 0x0270c, 0x0270d, 0x0270e, 0x0270f,
  0x02710, 0x02711, 0x02712, 0x02713, 0x02714, 0x02715, 0x02716, 0x02717,
  0x02718, 0x02719, 0x0271a, 0x0271b, 0x0271c, 0x0271d, 0x0271e, 0x0271f,
  0x02720, 0x02721, 0x02722, 0x02723, 0x02724, 0x02725, 0x02726, 0x02727,
  0x02728, 0x02729, 0x0272a, 0x0272b, 0x0272c, 0x0272d, 0x0272e, 0x0272f,
  0x02730, 0x02731, 0x02732, 0x02733, 0x02734, 0x02735, 0x02736, 0x02737,
  0x02738, 0x02739, 0x0273a, 0x0273b, 0x0273c, 0x0273d, 0x0273e, 0x0273f,
  0x02740, 0x02741, 0x02742, 0x02743, 0x02744, 0x02745, 0x02746, 0x02747,
  0x02748, 0x02749, 0x0274a, 0x0274b, 0x0274c, 0x0274d, 0x0274e, 0x0274f,
  0x02750, 0x02751, 0x02752, 0x02753, 0x02754, 0x02755, 0x02756, 0x02757,
  0x02758, 0x02759, 0x0275a, 0x0275b, 0x0275c, 0x0275d, 0x0275e, 0x0275f,
  0x02760, 0x02761, 0x02762, 0x02763, 0x02764, 0x02765, 0x02766, 0x02767,
  0x02768, 0x02769, 0x0276a, 0x0276b, 0x0276c, 0x0276d, 0x0276e, 0x0276f,
  0x02770, 0x02771, 0x02772, 0x02773, 0x02774, 0x02775, 0x00031, 0x00032,
  0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039, 0x02469,
  0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038,
  0x00039, 0x02469, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036,
  0x00037, 0x00038, 0x00039, 0x02469, 0x02794, 0x02795, 0x02796, 0x02797,
  0x02798, 0x02799, 0x0279a, 0x0279b, 0x0279c, 0x0279d, 0x0279e, 0x0279f,
  0x027a0, 0x027a1, 0x027a2, 0x027a3, 0x027a4, 0x027a5, 0x027a6, 0x027a7,
  0x027a8, 0x027a9, 0x027aa, 0x027ab, 0x027ac, 0x027ad, 0x027ae, 0x027af,
  0x027b0, 0x027b1, 0x027b2, 0x027b3, 0x027b4, 0x027b5, 0x027b6, 0x027b7,
  0x027b8, 0x027b9, 0x027ba, 0x027bb, 0x027bc, 0x027bd, 0x027be, 0x027bf,
  0x027c0, 0x027c1, 0x027c2, 0x027c3, 0x027c4, 0x027c5, 0x027c6, 0x027c7,
  0x027c8, 0x027c9, 0x027ca, 0x027cb, 0x027cc, 0x027cd, 0x027ce, 0x027cf,
  0x027d0, 0x027d1, 0x027d2, 0x027d3, 0x027d4, 0x027d5, 0x027d6, 0x027d7,
  0x027d8, 0x027d9, 0x027da, 0x027db, 0x027dc, 0x027dd, 0x027de, 0x027df,
  0x027e0, 0x027e1, 0x027e2, 0x027e3, 0x027e4, 0x027e5, 0x027e6, 0x027e7,
  0x027e8, 0x027e9, 0x027ea, 0x027eb, 0x027ec, 0x027ed, 0x027ee, 0x027ef,
  0x027f0, 0x027f1, 0x027f2, 0x027f3, 0x027f4, 0x027f5, 0x027f6, 0x027f7,
  0x027f8, 0x027f9, 0x027fa, 0x027fb, 0x027fc, 0x027fd, 0x027fe, 0x027ff
};

static uint32_t unicode_520_ci_page_2a[] = {
  0x02a00, 0x02a01, 0x02a02, 0x02a03, 0x02a04, 0x02a05, 0x02a06, 0x02a07,
  0x02a08, 0x02a09, 0x02a0a, 0x02a0b, 0x02a0c, 0x02a0d, 0x02a0e, 0x02a0f,
  0x02a10, 0x02a11, 0x02a12, 0x02a13, 0x02a14, 0x02a15, 0x02a16, 0x02a17,
  0x02a18, 0x02a19, 0x02a1a, 0x02a1b, 0x02a1c, 0x02a1d, 0x02a1e, 0x02a1f,
  0x02a20, 0x02a21, 0x02a22, 0x02a23, 0x02a24, 0x02a25, 0x02a26, 0x02a27,
  0x02a28, 0x02a29, 0x02a2a, 0x02a2b, 0x02a2c, 0x02a2d, 0x02a2e, 0x02a2f,
  0x02a30, 0x02a31, 0x02a32, 0x02a33, 0x02a34, 0x02a35, 0x02a36, 0x02a37,
  0x02a38, 0x02a39, 0x02a3a, 0x02a3b, 0x02a3c, 0x02a3d, 0x02a3e, 0x02a3f,
  0x02a40, 0x02a41, 0x02a42, 0x02a43, 0x02a44, 0x02a45, 0x02a46, 0x02a47,
  0x02a48, 0x02a49, 0x02a4a, 0x02a4b, 0x02a4c, 0x02a4d, 0x02a4e, 0x02a4f,
  0x02a50, 0x02a51, 0x02a52, 0x02a53, 0x02a54, 0x02a55, 0x02a56, 0x02a57,
  0x02a58, 0x02a59, 0x02a5a, 0x02a5b, 0x02a5c, 0x02a5d, 0x02a5e, 0x02a5f,
  0x02a60, 0x02a61, 0x02a62, 0x02a63, 0x02a64, 0x02a65, 0x02a66, 0x02a67,
  0x02a68, 0x02a69, 0x02a6a, 0x02a6b, 0x02a6c, 0x02a6d, 0x02a6e, 0x02a6f,
  0x02a70, 0x02a71, 0x02a72, 0x02a73, 0x02a74, 0x02a75, 0x02a76, 0x02a77,
  0x02a78, 0x02a79, 0x02a7a, 0x02a7b, 0x02a7c, 0x02a7d, 0x02a7e, 0x02a7f,
  0x02a80, 0x02a81, 0x02a82, 0x02a83, 0x02a84, 0x02a85, 0x02a86, 0x02a87,
  0x02a88, 0x02a89, 0x02a8a, 0x02a8b, 0x02a8c, 0x02a8d, 0x02a8e, 0x02a8f,
  0x02a90, 0x02a91, 0x02a92, 0x02a93, 0x02a94, 0x02a95, 0x02a96, 0x02a97,
  0x02a98, 0x02a99, 0x02a9a, 0x02a9b, 0x02a9c, 0x02a9d, 0x02a9e, 0x02a9f,
  0x02aa0, 0x02aa1, 0x02aa2, 0x02aa3, 0x02aa4, 0x02aa5, 0x02aa6, 0x02aa7,
  0x02aa8, 0x02aa9, 0x02aaa, 0x02aab, 0x02aac, 0x02aad, 0x02aae, 0x02aaf,
  0x02ab0, 0x02ab1, 0x02ab2, 0x02ab3, 0x02ab4, 0x02ab5, 0x02ab6, 0x02ab7,
  0x02ab8, 0x02ab9, 0x02aba, 0x02abb, 0x02abc, 0x02abd, 0x02abe, 0x02abf,
  0x02ac0, 0x02ac1, 0x02ac2, 0x02ac3, 0x02ac4, 0x02ac5, 0x02ac6, 0x02ac7,
  0x02ac8, 0x02ac9, 0x02aca, 0x02acb, 0x02acc, 0x02acd, 0x02ace, 0x02acf,
  0x02ad0, 0x02ad1, 0x02ad2, 0x02ad3, 0x02ad4, 0x02ad5, 0x02ad6, 0x02ad7,
  0x02ad8, 0x02ad9, 0x02ada, 0x02adb, 0x02adc, 0x02adc, 0x02ade, 0x02adf,
  0x02ae0, 0x02ae1, 0x02ae2, 0x02ae3, 0x02ae4, 0x02ae5, 0x02ae6, 0x02ae7,
  0x02ae8, 0x02ae9, 0x02aea, 0x02aeb, 0x02aec, 0x02aed, 0x02aee, 0x02aef,
  0x02af0, 0x02af1, 0x02af2, 0x02af3, 0x02af4, 0x02af5, 0x02af6, 0x02af7,
  0x02af8, 0x02af9, 0x02afa, 0x02afb, 0x02afc, 0x02afd, 0x02afe, 0x02aff
};

static uint32_t unicode_520_ci_page_2c[] = {
  0x02c00, 0x02c01, 0x02c02, 0x02c03, 0x02c04, 0x02c05, 0x02c06, 0x02c07,
  0x02c08, 0x02c09, 0x02c0a, 0x02c0b, 0x02c0c, 0x02c0d, 0x02c0e, 0x02c0f,
  0x02c10, 0x02c11, 0x02c12, 0x02c13, 0x02c14, 0x02c15, 0x02c16, 0x02c17,
  0x02c18, 0x02c19, 0x02c1a, 0x02c1b, 0x02c1c, 0x02c1d, 0x02c1e, 0x02c1f,
  0x02c20, 0x02c21, 0x02c22, 0x02c23, 0x02c24, 0x02c25, 0x02c26, 0x02c27,
  0x02c28, 0x02c29, 0x02c2a, 0x02c2b, 0x02c2c, 0x02c2d, 0x02c2e, 0x02c2f,
  0x02c00, 0x02c01, 0x02c02, 0x02c03, 0x02c04, 0x02c05, 0x02c06, 0x02c07,
  0x02c08, 0x02c09, 0x02c0a, 0x02c0b, 0x02c0c, 0x02c0d, 0x02c0e, 0x02c0f,
  0x02c10, 0x02c11, 0x02c12, 0x02c13, 0x02c14, 0x02c15, 0x02c16, 0x02c17,
  0x02c18, 0x02c19, 0x02c1a, 0x02c1b, 0x02c1c, 0x02c1d, 0x02c1e, 0x02c1f,
  0x02c20, 0x02c21, 0x02c22, 0x02c23, 0x02c24, 0x02c25, 0x02c26, 0x02c27,
  0x02c28, 0x02c29, 0x02c2a, 0x02c2b, 0x02c2c, 0x02c2d, 0x02c2e, 0x02c5f,
  0x02c60, 0x02c60, 0x0026b, 0x01d7d, 0x0027d, 0x0023a, 0x0023e, 0x02c67,
  0x02c67, 0x02c69, 0x02c69, 0x02c6b, 0x02c6b, 0x00251, 0x00271, 0x00250,
  0x00252, 0x02c71, 0x02c72, 0x02c72, 0x02c74, 0x02c75, 0x02c75, 0x02c77,
  0x02c78, 0x02c79, 0x02c7a, 0x02c7b, 0x0004a, 0x00056, 0x0023f, 0x00240,
  0x02c80, 0x02c80, 0x02c82, 0x02c82, 0x02c84, 0x02c84, 0x02c86, 0x02c86,
  0x02c88, 0x02c88, 0x02c8a, 0x02c8a, 0x02c8c, 0x02c8c, 0x02c8e, 0x02c8e,
  0x02c90, 0x02c90, 0x02c92, 0x02c92, 0x02c94, 0x02c94, 0x02c96, 0x02c96,
  0x02c98, 0x02c98, 0x02c9a, 0x02c9a, 0x02c9c, 0x02c9c, 0x02c9e, 0x02c9e,
  0x02ca0, 0x02ca0, 0x02ca2, 0x02ca2, 0x02ca4, 0x02ca4, 0x02ca6, 0x02ca6,
  0x02ca8, 0x02ca8, 0x02caa, 0x02caa, 0x02cac, 0x02cac, 0x02cae, 0x02cae,
  0x02cb0, 0x02cb0, 0x02cb2, 0x02cb2, 0x02cb4, 0x02cb4, 0x02cb6, 0x02cb6,
  0x02cb8, 0x02cb8, 0x02cba, 0x02cba, 0x02cbc, 0x02cbc, 0x02cbe, 0x02cbe,
  0x02cc0, 0x02cc0, 0x02cc2, 0x02cc2, 0x02cc4, 0x02cc4, 0x02cc6, 0x02cc6,
  0x02cc8, 0x02cc8, 0x02cca, 0x02cca, 0x02ccc, 0x02ccc, 0x02cce, 0x02cce,
  0x02cd0, 0x02cd0, 0x02cd2, 0x02cd2, 0x02cd4, 0x02cd4, 0x02cd6, 0x02cd6,
  0x02cd8, 0x02cd8, 0x02cda, 0x02cda, 0x02cdc, 0x02cdc, 0x02cde, 0x02cde,
  0x02ce0, 0x02ce0, 0x02ce2, 0x02ce2, 0x02ce4, 0x02ce5, 0x02ce6, 0x02ce7,
  0x02ce8, 0x02ce9, 0x02cea, 0x02ceb, 0x02ceb, 0x02ced, 0x02ced, 0x00000,
  0x00000, 0x00000, 0x02cf2, 0x02cf3, 0x02cf4, 0x02cf5, 0x02cf6, 0x02cf7,
  0x02cf8, 0x02cf9, 0x02cfa, 0x02cfb, 0x02cfc, 0x02cfd, 0x02cfe, 0x02cff
};

static uint32_t unicode_520_ci_page_2d[] = {
  0x010a0, 0x010a1, 0x010a2, 0x010a3, 0x010a4, 0x010a5, 0x010a6, 0x010a7,
  0x010a8, 0x010a9, 0x010aa, 0x010ab, 0x010ac, 0x010ad, 0x010ae, 0x010af,
  0x010b0, 0x010b1, 0x010b2, 0x010b3, 0x010b4, 0x010b5, 0x010b6, 0x010b7,
  0x010b8, 0x010b9, 0x010ba, 0x010bb, 0x010bc, 0x010bd, 0x010be, 0x010bf,
  0x010c0, 0x010c1, 0x010c2, 0x010c3, 0x010c4, 0x010c5, 0x02d26, 0x02d27,
  0x02d28, 0x02d29, 0x02d2a, 0x02d2b, 0x02d2c, 0x02d2d, 0x02d2e, 0x02d2f,
  0x02d30, 0x02d31, 0x02d32, 0x02d33, 0x02d34, 0x02d35, 0x02d36, 0x02d37,
  0x02d38, 0x02d39, 0x02d3a, 0x02d3b, 0x02d3c, 0x02d3d, 0x02d3e, 0x02d3f,
  0x02d40, 0x02d41, 0x02d42, 0x02d43, 0x02d44, 0x02d45, 0x02d46, 0x02d47,
  0x02d48, 0x02d49, 0x02d4a, 0x02d4b, 0x02d4c, 0x02d4d, 0x02d4e, 0x02d4f,
  0x02d50, 0x02d51, 0x02d52, 0x02d53, 0x02d54, 0x02d55, 0x02d56, 0x02d57,
  0x02d58, 0x02d59, 0x02d5a, 0x02d5b, 0x02d5c, 0x02d5d, 0x02d5e, 0x02d5f,
  0x02d60, 0x02d61, 0x02d62, 0x02d63, 0x02d64, 0x02d65, 0x02d66, 0x02d67,
  0x02d68, 0x02d69, 0x02d6a, 0x02d6b, 0x02d6c, 0x02d6d, 0x02d6e, 0x02d6f,
  0x02d70, 0x02d71, 0x02d72, 0x02d73, 0x02d74, 0x02d75, 0x02d76, 0x02d77,
  0x02d78, 0x02d79, 0x02d7a, 0x02d7b, 0x02d7c, 0x02d7d, 0x02d7e, 0x02d7f,
  0x02d80, 0x02d81, 0x02d82, 0x02d83, 0x02d84, 0x02d85, 0x02d86, 0x02d87,
  0x02d88, 0x02d89, 0x02d8a, 0x02d8b, 0x02d8c, 0x02d8d, 0x02d8e, 0x02d8f,
  0x02d90, 0x02d91, 0x02d92, 0x02d93, 0x02d94, 0x02d95, 0x02d96, 0x02d97,
  0x02d98, 0x02d99, 0x02d9a, 0x02d9b, 0x02d9c, 0x02d9d, 0x02d9e, 0x02d9f,
  0x02da0, 0x02da1, 0x02da2, 0x02da3, 0x02da4, 0x02da5, 0x02da6, 0x02da7,
  0x02da8, 0x02da9, 0x02daa, 0x02dab, 0x02dac, 0x02dad, 0x02dae, 0x02daf,
  0x02db0, 0x02db1, 0x02db2, 0x02db3, 0x02db4, 0x02db5, 0x02db6, 0x02db7,
  0x02db8, 0x02db9, 0x02dba, 0x02dbb, 0x02dbc, 0x02dbd, 0x02dbe, 0x02dbf,
  0x02dc0, 0x02dc1, 0x02dc2, 0x02dc3, 0x02dc4, 0x02dc5, 0x02dc6, 0x02dc7,
  0x02dc8, 0x02dc9, 0x02dca, 0x02dcb, 0x02dcc, 0x02dcd, 0x02dce, 0x02dcf,
  0x02dd0, 0x02dd1, 0x02dd2, 0x02dd3, 0x02dd4, 0x02dd5, 0x02dd6, 0x02dd7,
  0x02dd8, 0x02dd9, 0x02dda, 0x02ddb, 0x02ddc, 0x02ddd, 0x02dde, 0x02ddf,
  0x00411, 0x00412, 0x00413, 0x00414, 0x00416, 0x00417, 0x0041a, 0x0041b,
  0x0041c, 0x0041d, 0x0041e, 0x0041f, 0x00420, 0x00421, 0x00422, 0x00425,
  0x00426, 0x00427, 0x00428, 0x00429, 0x00472, 0x02df5, 0x00410, 0x00400,
  0x02df8, 0x02df9, 0x00462, 0x0042e, 0x02dfc, 0x00466, 0x0046a, 0x02dff
};

static uint32_t unicode_520_ci_page_2e[] = {
  0x02e00, 0x02e01, 0x02e02, 0x02e03, 0x02e04, 0x02e05, 0x02e06, 0x02e07,
  0x02e08, 0x02e09, 0x02e0a, 0x02e0b, 0x02e0c, 0x02e0d, 0x02e0e, 0x02e0f,
  0x02e10, 0x02e11, 0x02e12, 0x02e13, 0x02e14, 0x02e15, 0x02e16, 0x02e17,
  0x02e18, 0x02e19, 0x02e1a, 0x02e1b, 0x02e1c, 0x02e1d, 0x02e1e, 0x02e1f,
  0x02e20, 0x02e21, 0x02e22, 0x02e23, 0x02e24, 0x02e25, 0x02e26, 0x02e27,
  0x02e28, 0x02e29, 0x02e2a, 0x02e2b, 0x02e2c, 0x02e2d, 0x02e2e, 0x02e2f,
  0x02e30, 0x02e31, 0x02e32, 0x02e33, 0x02e34, 0x02e35, 0x02e36, 0x02e37,
  0x02e38, 0x02e39, 0x02e3a, 0x02e3b, 0x02e3c, 0x02e3d, 0x02e3e, 0x02e3f,
  0x02e40, 0x02e41, 0x02e42, 0x02e43, 0x02e44, 0x02e45, 0x02e46, 0x02e47,
  0x02e48, 0x02e49, 0x02e4a, 0x02e4b, 0x02e4c, 0x02e4d, 0x02e4e, 0x02e4f,
  0x02e50, 0x02e51, 0x02e52, 0x02e53, 0x02e54, 0x02e55, 0x02e56, 0x02e57,
  0x02e58, 0x02e59, 0x02e5a, 0x02e5b, 0x02e5c, 0x02e5d, 0x02e5e, 0x02e5f,
  0x02e60, 0x02e61, 0x02e62, 0x02e63, 0x02e64, 0x02e65, 0x02e66, 0x02e67,
  0x02e68, 0x02e69, 0x02e6a, 0x02e6b, 0x02e6c, 0x02e6d, 0x02e6e, 0x02e6f,
  0x02e70, 0x02e71, 0x02e72, 0x02e73, 0x02e74, 0x02e75, 0x02e76, 0x02e77,
  0x02e78, 0x02e79, 0x02e7a, 0x02e7b, 0x02e7c, 0x02e7d, 0x02e7e, 0x02e7f,
  0x02e80, 0x02e81, 0x02e82, 0x02e83, 0x0319a, 0x02e85, 0x02e86, 0x02f0f,
  0x02f11, 0x02e89, 0x02f18, 0x02e8b, 0x02f29, 0x02f29, 0x02e8e, 0x02e8f,
  0x02e8e, 0x02e8f, 0x02e92, 0x02e93, 0x02e94, 0x02e95, 0x02e96, 0x02f3c,
  0x02e98, 0x02e99, 0x02e9a, 0x02e9b, 0x02f47, 0x02f49, 0x02e9e, 0x02e9f,
  0x02ea0, 0x02ea1, 0x02ea2, 0x02ea3, 0x02ea4, 0x02ea4, 0x02ea6, 0x02f5c,
  0x02ea8, 0x02ea9, 0x02eaa, 0x02f6c, 0x02f70, 0x02ead, 0x02f75, 0x02eaf,
  0x02eb0, 0x02eb1, 0x02eb2, 0x02eb1, 0x02eb1, 0x02eb2, 0x02eb7, 0x02eb7,
  0x02eb8, 0x02eb9, 0x02eba, 0x02f80, 0x02f81, 0x02f85, 0x02ebe, 0x02ebe,
  0x02ebe, 0x02ec1, 0x02ec2, 0x02ec3, 0x02ec4, 0x02ec5, 0x02f93, 0x02f93,
  0x02ec8, 0x02ec9, 0x02f9c, 0x02ecb, 0x02ecc, 0x02ecc, 0x02ecc, 0x02fa2,
  0x02ed0, 0x02fa7, 0x02ed2, 0x02ed3, 0x02ed4, 0x02fa9, 0x02ed6, 0x02fac,
  0x02ed8, 0x02ed9, 0x02eda, 0x02edb, 0x02edc, 0x02fb7, 0x02ede, 0x02ede,
  0x02ee0, 0x02fb8, 0x02ee2, 0x02fbb, 0x02fc1, 0x02ee5, 0x02ee6, 0x02ee7,
  0x02ee8, 0x02ee9, 0x02eea, 0x02eeb, 0x02eec, 0x02eed, 0x02eee, 0x02eef,
  0x02ef0, 0x02ef2, 0x02ef2, 0x02ef3, 0x02ef4, 0x02ef5, 0x02ef6, 0x02ef7,
  0x02ef8, 0x02ef9, 0x02efa, 0x02efb, 0x02efc, 0x02efd, 0x02efe, 0x02eff
};

static uint32_t unicode_520_ci_page_2f[] = {
  0x03192, 0x02f01, 0x02e80, 0x02f03, 0x0319a, 0x02f05, 0x03193, 0x02f07,
  0x0319f, 0x02f09, 0x02f0a, 0x02f0b, 0x02e86, 0x02f0d, 0x02f0e, 0x02f0f,
  0x02f10, 0x02f11, 0x02f12, 0x02f13, 0x02f14, 0x02f15, 0x02f16, 0x02f17,
  0x02f18, 0x02e8b, 0x02e81, 0x02f1b, 0x02f1c, 0x02f1d, 0x02f1e, 0x02f1f,
  0x02f20, 0x02f21, 0x02f22, 0x02f23, 0x02f24, 0x02f25, 0x02f26, 0x02f27,
  0x02f28, 0x02f29, 0x02e8e, 0x02f2b, 0x02f2c, 0x02f2d, 0x02f2e, 0x02f2f,
  0x02f30, 0x02f31, 0x02f32, 0x02e93, 0x02f34, 0x02f35, 0x02f36, 0x02f37,
  0x02f38, 0x02e95, 0x02f3a, 0x02f3b, 0x02f3c, 0x02f3d, 0x02f3e, 0x02f3f,
  0x02f40, 0x02f41, 0x02f42, 0x02f43, 0x02f44, 0x02f45, 0x02f46, 0x02f47,
  0x02f48, 0x02f49, 0x02f4a, 0x02f4b, 0x02f4c, 0x02f4d, 0x02f4e, 0x02f4f,
  0x02f50, 0x02f51, 0x02f52, 0x02f53, 0x02f54, 0x02f55, 0x02f56, 0x02f57,
  0x02f58, 0x02f59, 0x02f5a, 0x02f5b, 0x02f5c, 0x02f5d, 0x02f5e, 0x02f5f,
  0x02f60, 0x02f61, 0x02f62, 0x02f63, 0x02f64, 0x02f65, 0x02eaa, 0x02f67,
  0x02f68, 0x02f69, 0x02f6a, 0x02f6b, 0x02f6c, 0x02f6d, 0x02f6e, 0x02f6f,
  0x02f70, 0x02f71, 0x02f72, 0x02f73, 0x02f74, 0x02f75, 0x02f76, 0x02f77,
  0x02f78, 0x02f79, 0x02eb7, 0x02f7b, 0x02f7c, 0x02f7d, 0x02f7e, 0x02f7f,
  0x02f80, 0x02f81, 0x02f82, 0x02f83, 0x02f84, 0x02f85, 0x02f86, 0x02f87,
  0x02f88, 0x02f89, 0x02f8a, 0x02f8b, 0x02f8c, 0x02f8d, 0x02f8e, 0x02f8f,
  0x02f90, 0x02f91, 0x02f92, 0x02f93, 0x02f94, 0x02f95, 0x02f96, 0x02f97,
  0x02f98, 0x02f99, 0x02f9a, 0x02f9b, 0x02f9c, 0x02f9d, 0x02f9e, 0x02f9f,
  0x02fa0, 0x02fa1, 0x02fa2, 0x02fa3, 0x02fa4, 0x02fa5, 0x02fa6, 0x02fa7,
  0x02fa8, 0x02fa9, 0x02faa, 0x02fab, 0x02fac, 0x02fad, 0x02fae, 0x02faf,
  0x02fb0, 0x02fb1, 0x02fb2, 0x02fb3, 0x02fb4, 0x02fb5, 0x02fb6, 0x02fb7,
  0x02fb8, 0x02fb9, 0x02fba, 0x02fbb, 0x02fbc, 0x02fbd, 0x02fbe, 0x02fbf,
  0x02fc0, 0x02fc1, 0x02fc2, 0x02fc3, 0x02ee7, 0x02fc5, 0x02fc6, 0x02fc7,
  0x02fc8, 0x02fc9, 0x02fca, 0x02fcb, 0x02fcc, 0x02fcd, 0x02fce, 0x02fcf,
  0x02fd0, 0x02eeb, 0x02eed, 0x02eef, 0x02ef2, 0x02fd5, 0x02fd6, 0x02fd7,
  0x02fd8, 0x02fd9, 0x02fda, 0x02fdb, 0x02fdc, 0x02fdd, 0x02fde, 0x02fdf,
  0x02fe0, 0x02fe1, 0x02fe2, 0x02fe3, 0x02fe4, 0x02fe5, 0x02fe6, 0x02fe7,
  0x02fe8, 0x02fe9, 0x02fea, 0x02feb, 0x02fec, 0x02fed, 0x02fee, 0x02fef,
  0x02ff0, 0x02ff1, 0x02ff2, 0x02ff3, 0x02ff4, 0x02ff5, 0x02ff6, 0x02ff7,
  0x02ff8, 0x02ff9, 0x02ffa, 0x02ffb, 0x02ffc, 0x02ffd, 0x02ffe, 0x02fff
};

static uint32_t unicode_520_ci_page_30[] = {
  0x00020, 0x03001, 0x03002, 0x03003, 0x03004, 0x03005, 0x03006, 0x00030,
  0x02329, 0x0232a, 0x0300a, 0x0300b, 0x0300c, 0x0300d, 0x0300e, 0x0300f,
  0x03010, 0x03011, 0x03012, 0x03013, 0x03014, 0x03015, 0x03016, 0x03017,
  0x03018, 0x03019, 0x0301a, 0x0301b, 0x0301c, 0x0301d, 0x0301e, 0x0301f,
  0x03020, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x03030, 0x03031, 0x03031, 0x03033, 0x03033, 0x03035, 0x03012, 0x03037,
  0x02f17, 0x03039, 0x0303a, 0x0303b, 0x0303c, 0x0303d, 0x0303e, 0x0303f,
  0x03040, 0x03042, 0x03042, 0x03044, 0x03044, 0x03046, 0x03046, 0x03048,
  0x03048, 0x0304a, 0x0304a, 0x0304b, 0x0304b, 0x0304d, 0x0304d, 0x0304f,
  0x0304f, 0x03051, 0x03051, 0x03053, 0x03053, 0x03055, 0x03055, 0x03057,
  0x03057, 0x03059, 0x03059, 0x0305b, 0x0305b, 0x0305d, 0x0305d, 0x0305f,
  0x0305f, 0x03061, 0x03061, 0x03064, 0x03064, 0x03064, 0x03066, 0x03066,
  0x03068, 0x03068, 0x0306a, 0x0306b, 0x0306c, 0x0306d, 0x0306e, 0x0306f,
  0x0306f, 0x0306f, 0x03072, 0x03072, 0x03072, 0x03075, 0x03075, 0x03075,
  0x03078, 0x03078, 0x03078, 0x0307b, 0x0307b, 0x0307b, 0x0307e, 0x0307f,
  0x03080, 0x03081, 0x03082, 0x03084, 0x03084, 0x03086, 0x03086, 0x03088,
  0x03088, 0x03089, 0x0308a, 0x0308b, 0x0308c, 0x0308d, 0x0308f, 0x0308f,
  0x03090, 0x03091, 0x03092, 0x03093, 0x03046, 0x0304b, 0x03051, 0x03097,
  0x03098, 0x00000, 0x00000, 0x0309b, 0x0309c, 0x0309d, 0x0309d, 0x0309f,
  0x030a0, 0x03042, 0x03042, 0x03044, 0x03044, 0x03046, 0x03046, 0x03048,
  0x03048, 0x0304a, 0x0304a, 0x0304b, 0x0304b, 0x0304d, 0x0304d, 0x0304f,
  0x0304f, 0x03051, 0x03051, 0x03053, 0x03053, 0x03055, 0x03055, 0x03057,
  0x03057, 0x03059, 0x03059, 0x0305b, 0x0305b, 0x0305d, 0x0305d, 0x0305f,
  0x0305f, 0x03061, 0x03061, 0x03064, 0x03064, 0x03064, 0x03066, 0x03066,
  0x03068, 0x03068, 0x0306a, 0x0306b, 0x0306c, 0x0306d, 0x0306e, 0x0306f,
  0x0306f, 0x0306f, 0x03072, 0x03072, 0x03072, 0x03075, 0x03075, 0x03075,
  0x03078, 0x03078, 0x03078, 0x0307b, 0x0307b, 0x0307b, 0x0307e, 0x0307f,
  0x03080, 0x03081, 0x03082, 0x03084, 0x03084, 0x03086, 0x03086, 0x03088,
  0x03088, 0x03089, 0x0308a, 0x0308b, 0x0308c, 0x0308d, 0x0308f, 0x0308f,
  0x03090, 0x03091, 0x03092, 0x03093, 0x03046, 0x0304b, 0x03051, 0x0308f,
  0x03090, 0x03091, 0x03092, 0x030fb, 0x030fc, 0x030fd, 0x030fd, 0x030ff
};

static uint32_t unicode_520_ci_page_31[] = {
  0x03100, 0x03101, 0x03102, 0x03103, 0x03104, 0x03105, 0x03106, 0x03107,
  0x03108, 0x03109, 0x0310a, 0x0310b, 0x0310c, 0x0310d, 0x0310e, 0x0310f,
  0x03110, 0x03111, 0x03112, 0x03113, 0x03114, 0x03115, 0x03116, 0x03117,
  0x03118, 0x03119, 0x0311a, 0x0311b, 0x0311c, 0x0311d, 0x0311e, 0x0311f,
  0x03120, 0x03121, 0x03122, 0x03123, 0x03124, 0x03125, 0x03126, 0x03127,
  0x03128, 0x03129, 0x0312a, 0x0312b, 0x0312c, 0x0312d, 0x0312e, 0x0312f,
  0x03130, 0x01100, 0x01101, 0x011aa, 0x01102, 0x011ac, 0x011ad, 0x01103,
  0x01104, 0x01105, 0x011b0, 0x011b1, 0x011b2, 0x011b3, 0x011b4, 0x011b5,
  0x0111a, 0x01106, 0x01107, 0x01108, 0x01121, 0x01109, 0x0110a, 0x0110b,
  0x0110c, 0x0110d, 0x0110e, 0x0110f, 0x01110, 0x01111, 0x01112, 0x01161,
  0x01162, 0x01163, 0x01164, 0x01165, 0x01166, 0x01167, 0x01168, 0x01169,
  0x0116a, 0x0116b, 0x0116c, 0x0116d, 0x0116e, 0x0116f, 0x01170, 0x01171,
  0x01172, 0x01173, 0x01174, 0x01175, 0x01160, 0x01114, 0x01115, 0x011c7,
  0x011c8, 0x011cc, 0x011ce, 0x011d3, 0x011d7, 0x011d9, 0x0111c, 0x011dd,
  0x011df, 0x0111d, 0x0111e, 0x01120, 0x01122, 0x01123, 0x01127, 0x01129,
  0x0112b, 0x0112c, 0x0112d, 0x0112e, 0x0112f, 0x01132, 0x01136, 0x01140,
  0x01147, 0x0114c, 0x011f1, 0x011f2, 0x01157, 0x01158, 0x01159, 0x01184,
  0x01185, 0x01188, 0x01191, 0x01192, 0x01194, 0x0119e, 0x011a1, 0x0318f,
  0x03190, 0x03191, 0x03192, 0x03193, 0x03194, 0x03195, 0x03196, 0x03197,
  0x03198, 0x03199, 0x0319a, 0x0319b, 0x0319c, 0x0319d, 0x0319e, 0x0319f,
  0x03105, 0x03117, 0x03110, 0x0310d, 0x031a4, 0x031a4, 0x031a6, 0x0311b,
  0x03128, 0x0311a, 0x03127, 0x03128, 0x031ac, 0x031ad, 0x0311e, 0x03120,
  0x031b0, 0x031b1, 0x031b2, 0x03127, 0x03106, 0x0310a, 0x0310e, 0x0310f,
  0x031b8, 0x031b9, 0x031ba, 0x031bb, 0x031bc, 0x031bd, 0x031be, 0x031bf,
  0x031c0, 0x031c1, 0x031c2, 0x031c3, 0x031c4, 0x031c5, 0x031c6, 0x031c7,
  0x031c8, 0x031c9, 0x031ca, 0x031cb, 0x031cc, 0x031cd, 0x031ce, 0x031cf,
  0x031d0, 0x031d1, 0x031d2, 0x031d3, 0x031d4, 0x031d5, 0x031d6, 0x031d7,
  0x031d8, 0x031d9, 0x031da, 0x031db, 0x031dc, 0x031dd, 0x031de, 0x031df,
  0x031e0, 0x031e1, 0x031e2, 0x031e3, 0x031e4, 0x031e5, 0x031e6, 0x031e7,
  0x031e8, 0x031e9, 0x031ea, 0x031eb, 0x031ec, 0x031ed, 0x031ee, 0x031ef,
  0x0304f, 0x03057, 0x03059, 0x03068, 0x0306c, 0x0306f, 0x03072, 0x03075,
  0x03078, 0x0307b, 0x03080, 0x03089, 0x0308a, 0x0308b, 0x0308c, 0x031ff
};

static uint32_t unicode_520_ci_page_32[] = {
  0x03200, 0x03201, 0x03202, 0x03203, 0x03204, 0x03205, 0x03206, 0x03207,
  0x03208, 0x03209, 0x0320a, 0x0320b, 0x0320c, 0x0320d, 0x0320e, 0x0320f,
  0x03210, 0x03211, 0x03212, 0x03213, 0x03214, 0x03215, 0x03216, 0x03217,
  0x03218, 0x03219, 0x0321a, 0x0321b, 0x0321c, 0x0321d, 0x0321e, 0x0321f,
  0x03220, 0x03221, 0x03222, 0x03223, 0x03224, 0x03225, 0x03226, 0x03227,
  0x03228, 0x03229, 0x0322a, 0x0322b, 0x0322c, 0x0322d, 0x0322e, 0x0322f,
  0x03230, 0x03231, 0x03232, 0x03233, 0x03234, 0x03235, 0x03236, 0x03237,
  0x03238, 0x03239, 0x0323a, 0x0323b, 0x0323c, 0x0323d, 0x0323e, 0x0323f,
  0x03240, 0x03241, 0x03242, 0x03243, 0x03244, 0x03245, 0x02f42, 0x03247,
  0x02469, 0x02473, 0x0324a, 0x0324b, 0x0324c, 0x0324d, 0x0324e, 0x0324f,
  0x03250, 0x03251, 0x03252, 0x03253, 0x03254, 0x03255, 0x03256, 0x03257,
  0x03258, 0x03259, 0x0324a, 0x0325b, 0x0325c, 0x0325d, 0x0325e, 0x0325f,
  0x01100, 0x01102, 0x01103, 0x01105, 0x01106, 0x01107, 0x01109, 0x0110b,
  0x0110c, 0x0110e, 0x0110f, 0x01110, 0x01111, 0x01112, 0x0326e, 0x0326f,
  0x03270, 0x03271, 0x03272, 0x03273, 0x03274, 0x03275, 0x03276, 0x03277,
  0x03278, 0x03279, 0x0327a, 0x0327b, 0x0327c, 0x0327d, 0x0327e, 0x0327f,
  0x03192, 0x03193, 0x03194, 0x03195, 0x03284, 0x03285, 0x03286, 0x02f0b,
  0x03288, 0x02f17, 0x02f49, 0x02f55, 0x02f54, 0x02f4a, 0x02fa6, 0x02f1f,
  0x02f47, 0x03291, 0x03292, 0x03293, 0x03294, 0x03295, 0x03296, 0x03297,
  0x03298, 0x03299, 0x0329a, 0x02f25, 0x0329c, 0x0329d, 0x0329e, 0x0329f,
  0x032a0, 0x032a1, 0x032a2, 0x032a3, 0x03196, 0x03197, 0x03198, 0x032a7,
  0x032a8, 0x032a9, 0x032aa, 0x032ab, 0x032ac, 0x032ad, 0x032ae, 0x032af,
  0x032b0, 0x032b1, 0x032b2, 0x032b3, 0x032b4, 0x0324b, 0x032b6, 0x032b7,
  0x032b8, 0x032b9, 0x032ba, 0x032bb, 0x032bc, 0x032bd, 0x032be, 0x0324c,
  0x032c0, 0x032c1, 0x032c2, 0x032c3, 0x032c4, 0x032c5, 0x032c6, 0x032c7,
  0x032c8, 0x032c9, 0x032ca, 0x032cb, 0x032cc, 0x032cd, 0x032ce, 0x032cf,
  0x03042, 0x03044, 0x03046, 0x03048, 0x0304a, 0x0304b, 0x0304d, 0x0304f,
  0x03051, 0x03053, 0x03055, 0x03057, 0x03059, 0x0305b, 0x0305d, 0x0305f,
  0x03061, 0x03064, 0x03066, 0x03068, 0x0306a, 0x0306b, 0x0306c, 0x0306d,
  0x0306e, 0x0306f, 0x03072, 0x03075, 0x03078, 0x0307b, 0x0307e, 0x0307f,
  0x03080, 0x03081, 0x03082, 0x03084, 0x03086, 0x03088, 0x03089, 0x0308a,
  0x0308b, 0x0308c, 0x0308d, 0x0308f, 0x03090, 0x03091, 0x03092, 0x032ff
};

static uint32_t unicode_520_ci_page_33[] = {
  0x03300, 0x03301, 0x03302, 0x03303, 0x03304, 0x03305, 0x03306, 0x03307,
  0x03308, 0x03309, 0x0330a, 0x0330b, 0x0330c, 0x0330d, 0x0330e, 0x0330f,
  0x03310, 0x03311, 0x03312, 0x03313, 0x03314, 0x03315, 0x03316, 0x03317,
  0x03318, 0x03319, 0x0331a, 0x0331b, 0x0331c, 0x0331d, 0x0331e, 0x0331f,
  0x03320, 0x03321, 0x03322, 0x03323, 0x03324, 0x03325, 0x03326, 0x03327,
  0x03328, 0x03329, 0x0332a, 0x0332b, 0x0332c, 0x0332d, 0x0332e, 0x0332f,
  0x03330, 0x03331, 0x03332, 0x03333, 0x03334, 0x03335, 0x03336, 0x03337,
  0x03338, 0x03339, 0x0333a, 0x0333b, 0x0333c, 0x0333d, 0x0333e, 0x0333f,
  0x03340, 0x03341, 0x03342, 0x03343, 0x03344, 0x03345, 0x03346, 0x03347,
  0x03348, 0x03349, 0x0334a, 0x0334b, 0x0334c, 0x0334d, 0x0334e, 0x0334f,
  0x03350, 0x03351, 0x03352, 0x03353, 0x03354, 0x03355, 0x03356, 0x03357,
  0x03358, 0x03359, 0x0335a, 0x0335b, 0x0335c, 0x0335d, 0x0335e, 0x0335f,
  0x03360, 0x03361, 0x03362, 0x03363, 0x03364, 0x03365, 0x03366, 0x03367,
  0x03368, 0x03369, 0x0336a, 0x0336b, 0x0336c, 0x0336d, 0x0336e, 0x0336f,
  0x03370, 0x03371, 0x03372, 0x03373, 0x03374, 0x03375, 0x03376, 0x03377,
  0x03378, 0x03379, 0x0337a, 0x0337b, 0x0337c, 0x0337d, 0x0337e, 0x0337f,
  0x03380, 0x03381, 0x03382, 0x03383, 0x03384, 0x03385, 0x03386, 0x03387,
  0x03388, 0x03389, 0x0338a, 0x0338b, 0x0338c, 0x0338d, 0x0338e, 0x0338f,
  0x03390, 0x03391, 0x03392, 0x03393, 0x03394, 0x03395, 0x03396, 0x03397,
  0x03398, 0x03399, 0x0339a, 0x0339b, 0x0339c, 0x0339d, 0x0339e, 0x0339f,
  0x033a0, 0x033a1, 0x033a2, 0x033a3, 0x033a4, 0x033a5, 0x033a6, 0x033a7,
  0x033a8, 0x03380, 0x033aa, 0x033ab, 0x033ac, 0x033ad, 0x033ae, 0x033af,
  0x033b0, 0x033b1, 0x033b2, 0x033b3, 0x033b4, 0x033b5, 0x033b6, 0x033b7,
  0x033b8, 0x033b7, 0x033ba, 0x033bb, 0x033bc, 0x033bd, 0x033be, 0x033bd,
  0x033c0, 0x033c1, 0x033c2, 0x033c3, 0x033c4, 0x033c5, 0x033c6, 0x033c7,
  0x00238, 0x033c9, 0x033ca, 0x033cb, 0x033cc, 0x033cd, 0x0339e, 0x033cf,
  0x033d0, 0x033d1, 0x033d2, 0x033d3, 0x03386, 0x033d5, 0x033d6, 0x033d7,
  0x033d8, 0x033d9, 0x033da, 0x033db, 0x033dc, 0x033dd, 0x033de, 0x033df,
  0x033e0, 0x033e1, 0x033e2, 0x033e3, 0x033e4, 0x033e5, 0x033e6, 0x033e7,
  0x033e8, 0x033e9, 0x033ea, 0x033eb, 0x033ec, 0x033ed, 0x033ee, 0x033ef,
  0x033f0, 0x033f1, 0x033f2, 0x033f3, 0x033f4, 0x033f5, 0x033f6, 0x033f7,
  0x033f8, 0x033f9, 0x033fa, 0x033fb, 0x033fc, 0x033fd, 0x033fe, 0x033ff
};

static uint32_t unicode_520_ci_page_a6[] = {
  0x0a600, 0x0a601, 0x0a602, 0x0a603, 0x0a604, 0x0a605, 0x0a606, 0x0a607,
  0x0a608, 0x0a609, 0x0a60a, 0x0a60b, 0x0a60c, 0x0a60d, 0x0a60e, 0x0a60f,
  0x0a558, 0x0a56a, 0x0a587, 0x0a613, 0x0a614, 0x0a615, 0x0a616, 0x0a617,
  0x0a618, 0x0a619, 0x0a61a, 0x0a61b, 0x0a61c, 0x0a61d, 0x0a61e, 0x0a61f,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x0a56e, 0x0a5d1, 0x0a62c, 0x0a62d, 0x0a62e, 0x0a62f,
  0x0a630, 0x0a631, 0x0a632, 0x0a633, 0x0a634, 0x0a635, 0x0a636, 0x0a637,
  0x0a638, 0x0a639, 0x0a63a, 0x0a63b, 0x0a63c, 0x0a63d, 0x0a63e, 0x0a63f,
  0x0a640, 0x0a640, 0x0a642, 0x0a642, 0x0a644, 0x0a644, 0x0a646, 0x0a646,
  0x02df8, 0x02df8, 0x02df9, 0x02df9, 0x0a64c, 0x0a64c, 0x0a64e, 0x0a64e,
  0x0a650, 0x0a650, 0x0a652, 0x0a652, 0x0a654, 0x0a654, 0x02dfc, 0x02dfc,
  0x0a658, 0x0a658, 0x0a65a, 0x0a65a, 0x0a65c, 0x0a65c, 0x0a65e, 0x0a65e,
  0x0a660, 0x0a661, 0x0a662, 0x0a662, 0x0a664, 0x0a664, 0x0a666, 0x0a666,
  0x0041e, 0x0041e, 0x0041e, 0x0041e, 0x0041e, 0x0041e, 0x0041e, 0x00000,
  0x00000, 0x00000, 0x00000, 0x0a673, 0x0a674, 0x0a675, 0x0a676, 0x0a677,
  0x0a678, 0x0a679, 0x0a67a, 0x0a67b, 0x00000, 0x00000, 0x0a67e, 0x0a67f,
  0x0a680, 0x0a680, 0x0a682, 0x0a682, 0x0a684, 0x0a684, 0x0a686, 0x0a686,
  0x0a688, 0x0a688, 0x0a68a, 0x0a68a, 0x0a68c, 0x0a68c, 0x0a68e, 0x0a68e,
  0x0a690, 0x0a690, 0x0a692, 0x0a692, 0x0a694, 0x0a694, 0x0a696, 0x0a696,
  0x0a698, 0x0a699, 0x0a69a, 0x0a69b, 0x0a69c, 0x0a69d, 0x0a69e, 0x0a69f,
  0x0a6a0, 0x0a6a1, 0x0a6a2, 0x0a6a3, 0x0a6a4, 0x0a6a5, 0x0a6a6, 0x0a6a7,
  0x0a6a8, 0x0a6a9, 0x0a6aa, 0x0a6ab, 0x0a6ac, 0x0a6ad, 0x0a6ae, 0x0a6af,
  0x0a6b0, 0x0a6b1, 0x0a6b2, 0x0a6b3, 0x0a6b4, 0x0a6b5, 0x0a6b6, 0x0a6b7,
  0x0a6b8, 0x0a6b9, 0x0a6ba, 0x0a6bb, 0x0a6bc, 0x0a6bd, 0x0a6be, 0x0a6bf,
  0x0a6c0, 0x0a6c1, 0x0a6c2, 0x0a6c3, 0x0a6c4, 0x0a6c5, 0x0a6c6, 0x0a6c7,
  0x0a6c8, 0x0a6c9, 0x0a6ca, 0x0a6cb, 0x0a6cc, 0x0a6cd, 0x0a6ce, 0x0a6cf,
  0x0a6d0, 0x0a6d1, 0x0a6d2, 0x0a6d3, 0x0a6d4, 0x0a6d5, 0x0a6d6, 0x0a6d7,
  0x0a6d8, 0x0a6d9, 0x0a6da, 0x0a6db, 0x0a6dc, 0x0a6dd, 0x0a6de, 0x0a6df,
  0x0a6e0, 0x0a6e1, 0x0a6e2, 0x0a6e3, 0x0a6e4, 0x0a6e5, 0x0a6e6, 0x0a6e7,
  0x0a6e8, 0x0a6e9, 0x0a6ea, 0x0a6eb, 0x0a6ec, 0x0a6ed, 0x0a6ee, 0x0a6ef,
  0x00000, 0x00000, 0x0a6f2, 0x0a6f3, 0x0a6f4, 0x0a6f5, 0x0a6f6, 0x0a6f7,
  0x0a6f8, 0x0a6f9, 0x0a6fa, 0x0a6fb, 0x0a6fc, 0x0a6fd, 0x0a6fe, 0x0a6ff
};

static uint32_t unicode_520_ci_page_a7[] = {
  0x0a700, 0x0a701, 0x0a702, 0x0a703, 0x0a704, 0x0a705, 0x0a706, 0x0a707,
  0x0a708, 0x0a709, 0x0a70a, 0x0a70b, 0x0a70c, 0x0a70d, 0x0a70e, 0x0a70f,
  0x0a710, 0x0a711, 0x0a712, 0x0a713, 0x0a714, 0x0a715, 0x0a716, 0x0a717,
  0x0a718, 0x0a719, 0x0a71a, 0x0a71b, 0x0a71c, 0x0a71d, 0x0a71e, 0x0a71f,
  0x0a720, 0x0a721, 0x0a722, 0x0a722, 0x0a724, 0x0a724, 0x0a726, 0x0a726,
  0x0a728, 0x0a728, 0x0a72a, 0x0a72a, 0x0a72c, 0x0a72c, 0x0a72e, 0x0a72e,
  0x0a730, 0x0a731, 0x0a732, 0x0a732, 0x01dd5, 0x01dd5, 0x03373, 0x03373,
  0x01dd6, 0x01dd6, 0x01dd6, 0x01dd6, 0x0a73c, 0x0a73c, 0x0a73e, 0x0a73e,
  0x0a740, 0x0a740, 0x0a742, 0x0a742, 0x0a744, 0x0a744, 0x0a746, 0x0a746,
  0x0a748, 0x0a748, 0x0a74a, 0x0a74a, 0x0a74c, 0x0a74c, 0x0a74e, 0x0a74e,
  0x0a750, 0x0a750, 0x0a752, 0x0a752, 0x0a754, 0x0a754, 0x0a756, 0x0a756,
  0x0a758, 0x0a758, 0x01de3, 0x01de3, 0x0a75c, 0x0a75c, 0x0a75e, 0x0a75e,
  0x0a760, 0x0a760, 0x0a762, 0x0a762, 0x0a764, 0x0a764, 0x0a766, 0x0a766,
  0x0a768, 0x0a768, 0x0a76a, 0x0a76a, 0x0a76c, 0x0a76c, 0x01dd2, 0x01dd2,
  0x01dd2, 0x0a771, 0x0a772, 0x0a773, 0x0a774, 0x0a775, 0x0a776, 0x0a777,
  0x0a778, 0x00044, 0x00044, 0x00046, 0x00046, 0x00047, 0x0a77e, 0x0a77e,
  0x0a780, 0x0a780, 0x00052, 0x00052, 0x00053, 0x00053, 0x00054, 0x00054,
  0x0a788, 0x0a789, 0x0a78a, 0x0a78b, 0x0a78b, 0x0a78d, 0x0a78e, 0x0a78f,
  0x0a790, 0x0a791, 0x0a792, 0x0a793, 0x0a794, 0x0a795, 0x0a796, 0x0a797,
  0x0a798, 0x0a799, 0x0a79a, 0x0a79b, 0x0a79c, 0x0a79d, 0x0a79e, 0x0a79f,
  0x0a7a0, 0x0a7a1, 0x0a7a2, 0x0a7a3, 0x0a7a4, 0x0a7a5, 0x0a7a6, 0x0a7a7,
  0x0a7a8, 0x0a7a9, 0x0a7aa, 0x0a7ab, 0x0a7ac, 0x0a7ad, 0x0a7ae, 0x0a7af,
  0x0a7b0, 0x0a7b1, 0x0a7b2, 0x0a7b3, 0x0a7b4, 0x0a7b5, 0x0a7b6, 0x0a7b7,
  0x0a7b8, 0x0a7b9, 0x0a7ba, 0x0a7bb, 0x0a7bc, 0x0a7bd, 0x0a7be, 0x0a7bf,
  0x0a7c0, 0x0a7c1, 0x0a7c2, 0x0a7c3, 0x0a7c4, 0x0a7c5, 0x0a7c6, 0x0a7c7,
  0x0a7c8, 0x0a7c9, 0x0a7ca, 0x0a7cb, 0x0a7cc, 0x0a7cd, 0x0a7ce, 0x0a7cf,
  0x0a7d0, 0x0a7d1, 0x0a7d2, 0x0a7d3, 0x0a7d4, 0x0a7d5, 0x0a7d6, 0x0a7d7,
  0x0a7d8, 0x0a7d9, 0x0a7da, 0x0a7db, 0x0a7dc, 0x0a7dd, 0x0a7de, 0x0a7df,
  0x0a7e0, 0x0a7e1, 0x0a7e2, 0x0a7e3, 0x0a7e4, 0x0a7e5, 0x0a7e6, 0x0a7e7,
  0x0a7e8, 0x0a7e9, 0x0a7ea, 0x0a7eb, 0x0a7ec, 0x0a7ed, 0x0a7ee, 0x0a7ef,
  0x0a7f0, 0x0a7f1, 0x0a7f2, 0x0a7f3, 0x0a7f4, 0x0a7f5, 0x0a7f6, 0x0a7f7,
  0x0a7f8, 0x0a7f9, 0x0a7fa, 0x0a7fb, 0x0a7fc, 0x0a7fd, 0x0a7fe, 0x0a7ff
};

static uint32_t unicode_520_ci_page_a8[] = {
  0x0a800, 0x0a801, 0x0a802, 0x0a803, 0x0a804, 0x0a805, 0x0a806, 0x0a807,
  0x0a808, 0x0a809, 0x0a80a, 0x00000, 0x0a80c, 0x0a80d, 0x0a80e, 0x0a80f,
  0x0a810, 0x0a811, 0x0a812, 0x0a813, 0x0a814, 0x0a815, 0x0a816, 0x0a817,
  0x0a818, 0x0a819, 0x0a81a, 0x0a81b, 0x0a81c, 0x0a81d, 0x0a81e, 0x0a81f,
  0x0a820, 0x0a821, 0x0a822, 0x0a823, 0x0a824, 0x0a825, 0x0a826, 0x0a827,
  0x0a828, 0x0a829, 0x0a82a, 0x0a82b, 0x0a82c, 0x0a82d, 0x0a82e, 0x0a82f,
  0x0a830, 0x0a831, 0x0a832, 0x0a833, 0x0a834, 0x0a835, 0x0a836, 0x0a837,
  0x0a838, 0x0a839, 0x0a83a, 0x0a83b, 0x0a83c, 0x0a83d, 0x0a83e, 0x0a83f,
  0x0a840, 0x0a841, 0x0a842, 0x0a843, 0x0a844, 0x0a845, 0x0a846, 0x0a847,
  0x0a848, 0x0a849, 0x0a84a, 0x0a84b, 0x0a84c, 0x0a84d, 0x0a84e, 0x0a84f,
  0x0a850, 0x0a851, 0x0a852, 0x0a853, 0x0a854, 0x0a855, 0x0a856, 0x0a857,
  0x0a858, 0x0a859, 0x0a85a, 0x0a85b, 0x0a85c, 0x0a85d, 0x0a85e, 0x0a85f,
  0x0a860, 0x0a861, 0x0a862, 0x0a863, 0x0a864, 0x0a865, 0x0a866, 0x0a867,
  0x0a868, 0x0a869, 0x0a86a, 0x0a86b, 0x0a86c, 0x0a86d, 0x0a86e, 0x0a86f,
  0x0a870, 0x0a871, 0x0a872, 0x0a873, 0x0a874, 0x0a875, 0x0a876, 0x0a877,
  0x0a878, 0x0a879, 0x0a87a, 0x0a87b, 0x0a87c, 0x0a87d, 0x0a87e, 0x0a87f,
  0x00000, 0x00000, 0x0a882, 0x0a883, 0x0a884, 0x0a885, 0x0a886, 0x0a887,
  0x0a888, 0x0a889, 0x0a88a, 0x0a88b, 0x0a88c, 0x0a88d, 0x0a88e, 0x0a88f,
  0x0a890, 0x0a891, 0x0a892, 0x0a893, 0x0a894, 0x0a895, 0x0a896, 0x0a897,
  0x0a898, 0x0a899, 0x0a89a, 0x0a89b, 0x0a89c, 0x0a89d, 0x0a89e, 0x0a89f,
  0x0a8a0, 0x0a8a1, 0x0a8a2, 0x0a8a3, 0x0a8a4, 0x0a8a5, 0x0a8a6, 0x0a8a7,
  0x0a8a8, 0x0a8a9, 0x0a8aa, 0x0a8ab, 0x0a8ac, 0x0a8ad, 0x0a8ae, 0x0a8af,
  0x0a8b0, 0x0a8b1, 0x0a8b2, 0x0a8b3, 0x0a8b4, 0x0a8b5, 0x0a8b6, 0x0a8b7,
  0x0a8b8, 0x0a8b9, 0x0a8ba, 0x0a8bb, 0x0a8bc, 0x0a8bd, 0x0a8be, 0x0a8bf,
  0x0a8c0, 0x0a8c1, 0x0a8c2, 0x0a8c3, 0x0a8c4, 0x0a8c5, 0x0a8c6, 0x0a8c7,
  0x0a8c8, 0x0a8c9, 0x0a8ca, 0x0a8cb, 0x0a8cc, 0x0a8cd, 0x0a8ce, 0x0a8cf,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x0a8da, 0x0a8db, 0x0a8dc, 0x0a8dd, 0x0a8de, 0x0a8df,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x0a8f2, 0x0a8f2, 0x0a8f2, 0x0a8f2, 0x0a8f2, 0x0a8f2,
  0x0a8f8, 0x0a8f9, 0x0a8fa, 0x0a8fb, 0x0a8fc, 0x0a8fd, 0x0a8fe, 0x0a8ff
};

static uint32_t unicode_520_ci_page_a9[] = {
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x0a90a, 0x0a90b, 0x0a90c, 0x0a90d, 0x0a90e, 0x0a90f,
  0x0a910, 0x0a911, 0x0a912, 0x0a913, 0x0a914, 0x0a915, 0x0a916, 0x0a917,
  0x0a918, 0x0a919, 0x0a91a, 0x0a91b, 0x0a91c, 0x0a91d, 0x0a91e, 0x0a91f,
  0x0a920, 0x0a921, 0x0a922, 0x0a923, 0x0a924, 0x0a925, 0x0a926, 0x0a927,
  0x0a928, 0x0a929, 0x0a92a, 0x00000, 0x00000, 0x00000, 0x0a92e, 0x0a92f,
  0x0a930, 0x0a931, 0x0a932, 0x0a933, 0x0a934, 0x0a935, 0x0a936, 0x0a937,
  0x0a938, 0x0a939, 0x0a93a, 0x0a93b, 0x0a93c, 0x0a93d, 0x0a93e, 0x0a93f,
  0x0a940, 0x0a941, 0x0a942, 0x0a943, 0x0a944, 0x0a945, 0x0a946, 0x0a947,
  0x0a948, 0x0a949, 0x0a94a, 0x0a94b, 0x0a94c, 0x0a94d, 0x0a94e, 0x0a94f,
  0x0a950, 0x0a951, 0x0a952, 0x0a953, 0x0a954, 0x0a955, 0x0a956, 0x0a957,
  0x0a958, 0x0a959, 0x0a95a, 0x0a95b, 0x0a95c, 0x0a95d, 0x0a95e, 0x0a95f,
  0x0a960, 0x0a961, 0x0a962, 0x0a963, 0x0a964, 0x0a965, 0x0a966, 0x0a967,
  0x0a968, 0x0a969, 0x0a96a, 0x0a96b, 0x0a96c, 0x0a96d, 0x0a96e, 0x0a96f,
  0x0a970, 0x0a971, 0x0a972, 0x0a973, 0x0a974, 0x0a975, 0x0a976, 0x0a977,
  0x0a978, 0x0a979, 0x0a97a, 0x0a97b, 0x0a97c, 0x0a97d, 0x0a97e, 0x0a97f,
  0x00000, 0x00000, 0x00000, 0x00000, 0x0a984, 0x0a985, 0x0a986, 0x0a987,
  0x0a988, 0x0a989, 0x0a98a, 0x0a98b, 0x0a98c, 0x0a98d, 0x0a98e, 0x0a98f,
  0x0a990, 0x0a991, 0x0a992, 0x0a993, 0x0a994, 0x0a995, 0x0a996, 0x0a997,
  0x0a998, 0x0a999, 0x0a99a, 0x0a99b, 0x0a99c, 0x0a99d, 0x0a99e, 0x0a99f,
  0x0a9a0, 0x0a9a1, 0x0a9a2, 0x0a9a3, 0x0a9a4, 0x0a9a5, 0x0a9a6, 0x0a9a7,
  0x0a9a8, 0x0a9a9, 0x0a9aa, 0x0a9ab, 0x0a9ab, 0x0a9ad, 0x0a9ae, 0x0a9af,
  0x0a9b0, 0x0a9b1, 0x0a9b2, 0x00000, 0x0a9b4, 0x0a9b5, 0x0a9b6, 0x0a9b7,
  0x0a9b8, 0x0a9b9, 0x0a9ba, 0x0a9bb, 0x0a9bc, 0x0a9bd, 0x0a9be, 0x0a9bf,
  0x0a9c0, 0x0a9c1, 0x0a9c2, 0x0a9c3, 0x0a9c4, 0x0a9c5, 0x0a9c6, 0x0a9c7,
  0x0a9c8, 0x0a9c9, 0x0a9ca, 0x0a9cb, 0x0a9cc, 0x0a9cd, 0x0a9ce, 0x0a9cf,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x0a9da, 0x0a9db, 0x0a9dc, 0x0a9dd, 0x0a9de, 0x0a9df,
  0x0a9e0, 0x0a9e1, 0x0a9e2, 0x0a9e3, 0x0a9e4, 0x0a9e5, 0x0a9e6, 0x0a9e7,
  0x0a9e8, 0x0a9e9, 0x0a9ea, 0x0a9eb, 0x0a9ec, 0x0a9ed, 0x0a9ee, 0x0a9ef,
  0x0a9f0, 0x0a9f1, 0x0a9f2, 0x0a9f3, 0x0a9f4, 0x0a9f5, 0x0a9f6, 0x0a9f7,
  0x0a9f8, 0x0a9f9, 0x0a9fa, 0x0a9fb, 0x0a9fc, 0x0a9fd, 0x0a9fe, 0x0a9ff
};

static uint32_t unicode_520_ci_page_aa[] = {
  0x0aa00, 0x0aa01, 0x0aa02, 0x0aa03, 0x0aa04, 0x0aa05, 0x0aa06, 0x0aa07,
  0x0aa08, 0x0aa09, 0x0aa0a, 0x0aa0b, 0x0aa0c, 0x0aa0d, 0x0aa0e, 0x0aa0f,
  0x0aa10, 0x0aa11, 0x0aa12, 0x0aa13, 0x0aa14, 0x0aa15, 0x0aa16, 0x0aa17,
  0x0aa18, 0x0aa19, 0x0aa1a, 0x0aa1b, 0x0aa1c, 0x0aa1d, 0x0aa1e, 0x0aa1f,
  0x0aa20, 0x0aa21, 0x0aa22, 0x0aa23, 0x0aa24, 0x0aa25, 0x0aa26, 0x0aa27,
  0x0aa28, 0x0aa29, 0x0aa2a, 0x0aa2b, 0x0aa2c, 0x0aa2d, 0x0aa2e, 0x0aa2f,
  0x0aa30, 0x0aa31, 0x0aa32, 0x0aa33, 0x0aa34, 0x0aa35, 0x0aa36, 0x0aa37,
  0x0aa38, 0x0aa39, 0x0aa3a, 0x0aa3b, 0x0aa3c, 0x0aa3d, 0x0aa3e, 0x0aa3f,
  0x0aa40, 0x0aa41, 0x0aa42, 0x0aa43, 0x0aa44, 0x0aa45, 0x0aa46, 0x0aa47,
  0x0aa48, 0x0aa49, 0x0aa4a, 0x0aa4b, 0x0aa4c, 0x0aa4d, 0x0aa4e, 0x0aa4f,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x0aa5a, 0x0aa5b, 0x0aa5c, 0x0aa5d, 0x0aa5e, 0x0aa5f,
  0x0aa60, 0x0aa61, 0x0aa62, 0x0aa63, 0x0aa64, 0x0aa65, 0x0aa66, 0x0aa67,
  0x0aa68, 0x0aa69, 0x0aa6a, 0x0aa6b, 0x0aa6c, 0x0aa6d, 0x0aa6e, 0x0aa6f,
  0x0aa70, 0x0aa71, 0x0aa72, 0x0aa73, 0x0aa74, 0x0aa75, 0x0aa76, 0x0aa77,
  0x0aa78, 0x0aa79, 0x0aa7a, 0x0aa7b, 0x0aa7c, 0x0aa7d, 0x0aa7e, 0x0aa7f,
  0x0aa80, 0x0aa81, 0x0aa82, 0x0aa83, 0x0aa84, 0x0aa85, 0x0aa86, 0x0aa87,
  0x0aa88, 0x0aa89, 0x0aa8a, 0x0aa8b, 0x0aa8c, 0x0aa8d, 0x0aa8e, 0x0aa8f,
  0x0aa90, 0x0aa91, 0x0aa92, 0x0aa93, 0x0aa94, 0x0aa95, 0x0aa96, 0x0aa97,
  0x0aa98, 0x0aa99, 0x0aa9a, 0x0aa9b, 0x0aa9c, 0x0aa9d, 0x0aa9e, 0x0aa9f,
  0x0aaa0, 0x0aaa1, 0x0aaa2, 0x0aaa3, 0x0aaa4, 0x0aaa5, 0x0aaa6, 0x0aaa7,
  0x0aaa8, 0x0aaa9, 0x0aaaa, 0x0aaab, 0x0aaac, 0x0aaad, 0x0aaae, 0x0aaaf,
  0x0aab0, 0x0aab1, 0x0aab2, 0x0aab3, 0x0aab4, 0x0aab5, 0x0aab6, 0x0aab7,
  0x0aab8, 0x0aab9, 0x0aaba, 0x0aabb, 0x0aabc, 0x0aabd, 0x0aabe, 0x00000,
  0x0aac0, 0x00000, 0x0aac2, 0x0aac3, 0x0aac4, 0x0aac5, 0x0aac6, 0x0aac7,
  0x0aac8, 0x0aac9, 0x0aaca, 0x0aacb, 0x0aacc, 0x0aacd, 0x0aace, 0x0aacf,
  0x0aad0, 0x0aad1, 0x0aad2, 0x0aad3, 0x0aad4, 0x0aad5, 0x0aad6, 0x0aad7,
  0x0aad8, 0x0aad9, 0x0aada, 0x0aadb, 0x0aadc, 0x0aadd, 0x0aade, 0x0aadf,
  0x0aae0, 0x0aae1, 0x0aae2, 0x0aae3, 0x0aae4, 0x0aae5, 0x0aae6, 0x0aae7,
  0x0aae8, 0x0aae9, 0x0aaea, 0x0aaeb, 0x0aaec, 0x0aaed, 0x0aaee, 0x0aaef,
  0x0aaf0, 0x0aaf1, 0x0aaf2, 0x0aaf3, 0x0aaf4, 0x0aaf5, 0x0aaf6, 0x0aaf7,
  0x0aaf8, 0x0aaf9, 0x0aafa, 0x0aafb, 0x0aafc, 0x0aafd, 0x0aafe, 0x0aaff
};

static uint32_t unicode_520_ci_page_ab[] = {
  0x0ab00, 0x0ab01, 0x0ab02, 0x0ab03, 0x0ab04, 0x0ab05, 0x0ab06, 0x0ab07,
  0x0ab08, 0x0ab09, 0x0ab0a, 0x0ab0b, 0x0ab0c, 0x0ab0d, 0x0ab0e, 0x0ab0f,
  0x0ab10, 0x0ab11, 0x0ab12, 0x0ab13, 0x0ab14, 0x0ab15, 0x0ab16, 0x0ab17,
  0x0ab18, 0x0ab19, 0x0ab1a, 0x0ab1b, 0x0ab1c, 0x0ab1d, 0x0ab1e, 0x0ab1f,
  0x0ab20, 0x0ab21, 0x0ab22, 0x0ab23, 0x0ab24, 0x0ab25, 0x0ab26, 0x0ab27,
  0x0ab28, 0x0ab29, 0x0ab2a, 0x0ab2b, 0x0ab2c, 0x0ab2d, 0x0ab2e, 0x0ab2f,
  0x0ab30, 0x0ab31, 0x0ab32, 0x0ab33, 0x0ab34, 0x0ab35, 0x0ab36, 0x0ab37,
  0x0ab38, 0x0ab39, 0x0ab3a, 0x0ab3b, 0x0ab3c, 0x0ab3d, 0x0ab3e, 0x0ab3f,
  0x0ab40, 0x0ab41, 0x0ab42, 0x0ab43, 0x0ab44, 0x0ab45, 0x0ab46, 0x0ab47,
  0x0ab48, 0x0ab49, 0x0ab4a, 0x0ab4b, 0x0ab4c, 0x0ab4d, 0x0ab4e, 0x0ab4f,
  0x0ab50, 0x0ab51, 0x0ab52, 0x0ab53, 0x0ab54, 0x0ab55, 0x0ab56, 0x0ab57,
  0x0ab58, 0x0ab59, 0x0ab5a, 0x0ab5b, 0x0ab5c, 0x0ab5d, 0x0ab5e, 0x0ab5f,
  0x0ab60, 0x0ab61, 0x0ab62, 0x0ab63, 0x0ab64, 0x0ab65, 0x0ab66, 0x0ab67,
  0x0ab68, 0x0ab69, 0x0ab6a, 0x0ab6b, 0x0ab6c, 0x0ab6d, 0x0ab6e, 0x0ab6f,
  0x0ab70, 0x0ab71, 0x0ab72, 0x0ab73, 0x0ab74, 0x0ab75, 0x0ab76, 0x0ab77,
  0x0ab78, 0x0ab79, 0x0ab7a, 0x0ab7b, 0x0ab7c, 0x0ab7d, 0x0ab7e, 0x0ab7f,
  0x0ab80, 0x0ab81, 0x0ab82, 0x0ab83, 0x0ab84, 0x0ab85, 0x0ab86, 0x0ab87,
  0x0ab88, 0x0ab89, 0x0ab8a, 0x0ab8b, 0x0ab8c, 0x0ab8d, 0x0ab8e, 0x0ab8f,
  0x0ab90, 0x0ab91, 0x0ab92, 0x0ab93, 0x0ab94, 0x0ab95, 0x0ab96, 0x0ab97,
  0x0ab98, 0x0ab99, 0x0ab9a, 0x0ab9b, 0x0ab9c, 0x0ab9d, 0x0ab9e, 0x0ab9f,
  0x0aba0, 0x0aba1, 0x0aba2, 0x0aba3, 0x0aba4, 0x0aba5, 0x0aba6, 0x0aba7,
  0x0aba8, 0x0aba9, 0x0abaa, 0x0abab, 0x0abac, 0x0abad, 0x0abae, 0x0abaf,
  0x0abb0, 0x0abb1, 0x0abb2, 0x0abb3, 0x0abb4, 0x0abb5, 0x0abb6, 0x0abb7,
  0x0abb8, 0x0abb9, 0x0abba, 0x0abbb, 0x0abbc, 0x0abbd, 0x0abbe, 0x0abbf,
  0x0abc0, 0x0abc1, 0x0abc2, 0x0abc3, 0x0abc4, 0x0abc5, 0x0abc6, 0x0abc7,
  0x0abc8, 0x0abc9, 0x0abca, 0x0abcb, 0x0abcc, 0x0abcd, 0x0abce, 0x0abcf,
  0x0abd0, 0x0abd1, 0x0abd2, 0x0abd3, 0x0abd4, 0x0abd5, 0x0abd6, 0x0abd7,
  0x0abd8, 0x0abd9, 0x0abda, 0x0abdb, 0x0abdc, 0x0abdd, 0x0abde, 0x0abdf,
  0x0abe0, 0x0abe1, 0x0abe2, 0x0abe3, 0x0abe4, 0x0abe5, 0x0abe6, 0x0abe7,
  0x0abe8, 0x0abe9, 0x0abea, 0x0abeb, 0x00000, 0x0abed, 0x0abee, 0x0abef,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x0abfa, 0x0abfb, 0x0abfc, 0x0abfd, 0x0abfe, 0x0abff
};

static uint32_t unicode_520_ci_page_f9[] = {
  0x0f900, 0x0f901, 0x02f9e, 0x0f903, 0x0f904, 0x0f905, 0x0f906, 0x02ef2,
  0x02ef2, 0x0f909, 0x02fa6, 0x0f90b, 0x0f90c, 0x0f90d, 0x0f90e, 0x0f90f,
  0x0f910, 0x0f911, 0x0f912, 0x0f913, 0x0f914, 0x0f915, 0x0f916, 0x0f917,
  0x0f918, 0x0f919, 0x0f91a, 0x0f91b, 0x0f91c, 0x0f91d, 0x0f91e, 0x0f91f,
  0x0f920, 0x0f921, 0x0f922, 0x0f923, 0x0f924, 0x0f925, 0x0f926, 0x0f927,
  0x0f928, 0x0f929, 0x0f92a, 0x0f92b, 0x0f92c, 0x0f92d, 0x0f92e, 0x0f92f,
  0x0f930, 0x0f931, 0x0f932, 0x0f933, 0x02f7c, 0x0f935, 0x0f936, 0x0f937,
  0x0f938, 0x0f939, 0x0f93a, 0x0f93b, 0x0f93c, 0x0f93d, 0x0f93e, 0x0f93f,
  0x02fc5, 0x0f941, 0x0f942, 0x0f943, 0x0f944, 0x0f945, 0x0f946, 0x0f947,
  0x0f948, 0x0f949, 0x0f94a, 0x0f94b, 0x0f94c, 0x0f94d, 0x0f94e, 0x0f94f,
  0x0f950, 0x0f951, 0x0f952, 0x0f953, 0x0f954, 0x0f955, 0x0f956, 0x0f957,
  0x0f958, 0x0f959, 0x0f95a, 0x0f95b, 0x0f914, 0x0f95d, 0x0f95e, 0x0f95f,
  0x0f960, 0x0f961, 0x0f962, 0x0f963, 0x0f964, 0x0f965, 0x0f966, 0x0f967,
  0x0f968, 0x0f969, 0x0f96a, 0x0f96b, 0x0f96c, 0x0f96d, 0x0f96e, 0x0f96f,
  0x0f970, 0x02fa0, 0x0f972, 0x0f973, 0x0f974, 0x0f975, 0x0f976, 0x0f977,
  0x0f978, 0x0f979, 0x0f97a, 0x0f97b, 0x0f97c, 0x0f97d, 0x0f97e, 0x0f97f,
  0x0f980, 0x02f25, 0x0f982, 0x0f983, 0x0f984, 0x0f985, 0x0f986, 0x0f987,
  0x0f988, 0x0f989, 0x02f12, 0x0f98b, 0x0f98c, 0x0f98d, 0x0f98e, 0x0f98f,
  0x0f990, 0x0f991, 0x0f992, 0x0f993, 0x0f994, 0x0f995, 0x0f996, 0x0f997,
  0x0f998, 0x0f999, 0x0f99a, 0x0f99b, 0x0f99c, 0x0f99d, 0x0f99e, 0x0f99f,
  0x0f9a0, 0x0f96f, 0x0f9a2, 0x0f9a3, 0x0f9a4, 0x0f9a5, 0x0f9a6, 0x0f9a7,
  0x0f9a8, 0x0f9a9, 0x0f95f, 0x0f9ab, 0x0f9ac, 0x0f9ad, 0x0f9ae, 0x0f9af,
  0x0f9b0, 0x0f9b1, 0x0f9b2, 0x0f9b3, 0x0f9b4, 0x0f9b5, 0x0f9b6, 0x0f9b7,
  0x0f9b8, 0x0f9b9, 0x0f9ba, 0x0f9bb, 0x0f9bc, 0x0f9bd, 0x0f9be, 0x0f914,
  0x0f9c0, 0x0f9c1, 0x0f9c2, 0x0f9c3, 0x02eef, 0x0f9c5, 0x0f9c6, 0x0f9c7,
  0x0f9c8, 0x0f9c9, 0x0f9ca, 0x0f9cb, 0x0f9cc, 0x0f9cd, 0x0f9ce, 0x0f9cf,
  0x0f9d0, 0x03285, 0x0f9d2, 0x0f9d3, 0x0f9d4, 0x0f9d5, 0x0f9d6, 0x0f9d7,
  0x0f9d8, 0x0f9d9, 0x0f9da, 0x0f961, 0x0f9dc, 0x0f9dd, 0x0f9de, 0x0f9df,
  0x0f9e0, 0x0f9e1, 0x0f9e2, 0x0f9e3, 0x0f9e4, 0x0f9e5, 0x0f9e6, 0x0f9e7,
  0x0f9e8, 0x02fa5, 0x0f9ea, 0x0f9eb, 0x0f9ec, 0x0f9ed, 0x0f9ee, 0x0f9ef,
  0x0f9f0, 0x0f9f1, 0x0f9f2, 0x0f9f3, 0x0f9f4, 0x0f9f5, 0x0f9f6, 0x02f74,
  0x0f9f8, 0x0f9f9, 0x0f9fa, 0x0f9fb, 0x0f9fc, 0x0f9fd, 0x0f9fe, 0x0f9ff
};

static uint32_t unicode_520_ci_page_fa[] = {
  0x0fa00, 0x0fa01, 0x0fa02, 0x0fa03, 0x0fa04, 0x0fa05, 0x0fa06, 0x0fa07,
  0x02f8f, 0x0fa09, 0x02f92, 0x0fa0b, 0x0fa0c, 0x0fa0d, 0x0fa0e, 0x0fa0f,
  0x0fa10, 0x0fa11, 0x0fa12, 0x0fa13, 0x0fa14, 0x0fa15, 0x0fa16, 0x0fa17,
  0x0fa18, 0x0fa19, 0x0fa1a, 0x0fa1b, 0x0fa1c, 0x0fa1d, 0x02f7b, 0x0fa1f,
  0x0fa20, 0x0fa21, 0x0fa22, 0x0fa23, 0x0fa24, 0x0fa25, 0x0fa26, 0x0fa27,
  0x0fa28, 0x0fa29, 0x0fa2a, 0x0fa2b, 0x0fa2c, 0x0fa2d, 0x0fa2e, 0x0fa2f,
  0x0fa30, 0x0fa31, 0x0fa32, 0x0fa33, 0x0fa34, 0x0fa35, 0x0fa36, 0x0fa37,
  0x0fa38, 0x0fa39, 0x0fa3a, 0x0fa3b, 0x02f2c, 0x0fa3d, 0x0fa3e, 0x0fa3f,
  0x0fa40, 0x0fa41, 0x0fa42, 0x0fa43, 0x0fa44, 0x0fa45, 0x0fa46, 0x0fa47,
  0x0fa48, 0x02ea4, 0x0fa4a, 0x0fa4b, 0x03293, 0x0fa4d, 0x0fa4e, 0x0fa4f,
  0x0fa50, 0x03297, 0x0fa52, 0x0fa53, 0x0fa54, 0x0fa55, 0x0fa56, 0x0f996,
  0x0fa58, 0x0fa59, 0x0fa5a, 0x0fa5b, 0x0fa5c, 0x02ebe, 0x02ebe, 0x0fa5f,
  0x0fa60, 0x0fa61, 0x0fa62, 0x0fa63, 0x0fa64, 0x0fa65, 0x02ecc, 0x0fa25,
  0x0fa68, 0x0fa69, 0x0fa6a, 0x0fa6b, 0x0fa6c, 0x0fa6d, 0x0fa6e, 0x0fa6f,
  0x0fa70, 0x0fa71, 0x0fa72, 0x0fa73, 0x0fa74, 0x0fa75, 0x0fa76, 0x0fa77,
  0x0fa36, 0x0fa79, 0x0fa7a, 0x0fa7b, 0x0fa10, 0x0fa7d, 0x0fa7e, 0x0fa7f,
  0x0fa80, 0x0fa81, 0x0fa82, 0x0fa83, 0x0fa84, 0x0fa85, 0x0fa86, 0x0fa87,
  0x0fa88, 0x0fa3f, 0x0fa8a, 0x0fa40, 0x0fa8c, 0x0fa8d, 0x0fa8e, 0x0fa8f,
  0x0fa90, 0x0fa12, 0x0f929, 0x0fa93, 0x0fa94, 0x02f4d, 0x0f970, 0x0f9ca,
  0x0fa98, 0x0fa99, 0x0fa47, 0x0fa9b, 0x0fa48, 0x0fa9d, 0x0fa9e, 0x0fa9f,
  0x0fa16, 0x0faa1, 0x0faa2, 0x0faa3, 0x0faa4, 0x0faa5, 0x0fa17, 0x0faa7,
  0x0faa8, 0x0faa9, 0x0faaa, 0x0faab, 0x0faac, 0x0fa56, 0x0faae, 0x0faaf,
  0x0f996, 0x0fab1, 0x0fa5b, 0x0fab3, 0x0fab4, 0x0fab5, 0x0fab6, 0x0fab7,
  0x0fa61, 0x0fab9, 0x0fa22, 0x0fabb, 0x0fa62, 0x0f95d, 0x0fabe, 0x0fa63,
  0x0fac0, 0x0fa65, 0x0fac2, 0x0fac3, 0x0fac4, 0x0fac5, 0x0fac6, 0x0fa68,
  0x0fa1c, 0x0fac9, 0x0fa69, 0x0facb, 0x0fa6a, 0x0facd, 0x02ef2, 0x0facf,
  0x0fad0, 0x0fad1, 0x0fad2, 0x0fad3, 0x0fad4, 0x0fad5, 0x0fad6, 0x0fad7,
  0x0fad8, 0x0fad9, 0x0fada, 0x0fadb, 0x0fadc, 0x0fadd, 0x0fade, 0x0fadf,
  0x0fae0, 0x0fae1, 0x0fae2, 0x0fae3, 0x0fae4, 0x0fae5, 0x0fae6, 0x0fae7,
  0x0fae8, 0x0fae9, 0x0faea, 0x0faeb, 0x0faec, 0x0faed, 0x0faee, 0x0faef,
  0x0faf0, 0x0faf1, 0x0faf2, 0x0faf3, 0x0faf4, 0x0faf5, 0x0faf6, 0x0faf7,
  0x0faf8, 0x0faf9, 0x0fafa, 0x0fafb, 0x0fafc, 0x0fafd, 0x0fafe, 0x0faff
};

static uint32_t unicode_520_ci_page_fb[] = {
  0x0fb00, 0x0fb01, 0x0fb02, 0x0fb03, 0x0fb04, 0x0fb05, 0x0fb05, 0x0fb07,
  0x0fb08, 0x0fb09, 0x0fb0a, 0x0fb0b, 0x0fb0c, 0x0fb0d, 0x0fb0e, 0x0fb0f,
  0x0fb10, 0x0fb11, 0x0fb12, 0x0fb13, 0x0fb14, 0x0fb15, 0x0fb16, 0x0fb17,
  0x0fb18, 0x0fb19, 0x0fb1a, 0x0fb1b, 0x0fb1c, 0x005d9, 0x00000, 0x005f2,
  0x005e2, 0x005d0, 0x005d3, 0x005d4, 0x005da, 0x005dc, 0x005dd, 0x005e8,
  0x005ea, 0x0002b, 0x005e9, 0x005e9, 0x005e9, 0x005e9, 0x005d0, 0x005d0,
  0x005d0, 0x005d1, 0x005d2, 0x005d3, 0x005d4, 0x005d5, 0x005d6, 0x0fb37,
  0x005d8, 0x005d9, 0x005da, 0x005da, 0x005dc, 0x0fb3d, 0x005dd, 0x0fb3f,
  0x005df, 0x005e1, 0x0fb42, 0x005e3, 0x005e3, 0x0fb45, 0x005e5, 0x005e7,
  0x005e8, 0x005e9, 0x005ea, 0x005d5, 0x005d1, 0x005da, 0x005e3, 0x0fb4f,
  0x00671, 0x00671, 0x0067b, 0x0067b, 0x0067b, 0x0067b, 0x0067e, 0x0067e,
  0x0067e, 0x0067e, 0x00680, 0x00680, 0x00680, 0x00680, 0x0067a, 0x0067a,
  0x0067a, 0x0067a, 0x0067f, 0x0067f, 0x0067f, 0x0067f, 0x00679, 0x00679,
  0x00679, 0x00679, 0x006a4, 0x006a4, 0x006a4, 0x006a4, 0x006a6, 0x006a6,
  0x006a6, 0x006a6, 0x00684, 0x00684, 0x00684, 0x00684, 0x00683, 0x00683,
  0x00683, 0x00683, 0x00686, 0x00686, 0x00686, 0x00686, 0x00687, 0x00687,
  0x00687, 0x00687, 0x0068d, 0x0068d, 0x0068c, 0x0068c, 0x0068e, 0x0068e,
  0x00688, 0x00688, 0x00698, 0x00698, 0x00691, 0x00691, 0x006a9, 0x006a9,
  0x006a9, 0x006a9, 0x006af, 0x006af, 0x006af, 0x006af, 0x006b3, 0x006b3,
  0x006b3, 0x006b3, 0x006b1, 0x006b1, 0x006b1, 0x006b1, 0x006ba, 0x006ba,
  0x006bb, 0x006bb, 0x006bb, 0x006bb, 0x006c0, 0x006c0, 0x006c1, 0x006c1,
  0x006c1, 0x006c1, 0x006be, 0x006be, 0x006be, 0x006be, 0x006d2, 0x006d2,
  0x006d2, 0x006d2, 0x0fbb2, 0x0fbb3, 0x0fbb4, 0x0fbb5, 0x0fbb6, 0x0fbb7,
  0x0fbb8, 0x0fbb9, 0x0fbba, 0x0fbbb, 0x0fbbc, 0x0fbbd, 0x0fbbe, 0x0fbbf,
  0x0fbc0, 0x0fbc1, 0x0fbc2, 0x0fbc3, 0x0fbc4, 0x0fbc5, 0x0fbc6, 0x0fbc7,
  0x0fbc8, 0x0fbc9, 0x0fbca, 0x0fbcb, 0x0fbcc, 0x0fbcd, 0x0fbce, 0x0fbcf,
  0x0fbd0, 0x0fbd1, 0x0fbd2, 0x006ad, 0x006ad, 0x006ad, 0x006ad, 0x006c7,
  0x006c7, 0x006c6, 0x006c6, 0x006c8, 0x006c8, 0x00677, 0x006cb, 0x006cb,
  0x006c5, 0x006c5, 0x006c9, 0x006c9, 0x006d0, 0x006d0, 0x006d0, 0x006d0,
  0x00649, 0x00649, 0x0fbea, 0x0fbea, 0x0fbec, 0x0fbec, 0x0fbee, 0x0fbee,
  0x0fbf0, 0x0fbf0, 0x0fbf2, 0x0fbf2, 0x0fbf4, 0x0fbf4, 0x0fbf6, 0x0fbf6,
  0x0fbf6, 0x0fbf9, 0x0fbf9, 0x0fbf9, 0x006cc, 0x006cc, 0x0fbfe, 0x0fbff
};

static uint32_t unicode_520_ci_page_fc[] = {
  0x0fc00, 0x0fc01, 0x0fc02, 0x0fbf9, 0x0fc04, 0x0fc05, 0x0fc06, 0x0fc07,
  0x0fc08, 0x0fc09, 0x0fc0a, 0x0fc0b, 0x0fc0c, 0x0fc0d, 0x0fc0e, 0x0fc0f,
  0x0fc10, 0x0fc11, 0x0fc12, 0x0fc13, 0x0fc14, 0x0fc15, 0x0fc16, 0x0fc17,
  0x0fc18, 0x0fc19, 0x0fc1a, 0x0fc1b, 0x0fc1c, 0x0fc1d, 0x0fc1e, 0x0fc1f,
  0x0fc20, 0x0fc21, 0x0fc22, 0x0fc23, 0x0fc24, 0x0fc25, 0x0fc26, 0x0fc27,
  0x0fc28, 0x0fc29, 0x0fc2a, 0x0fc2b, 0x0fc2c, 0x0fc2d, 0x0fc2e, 0x0fc2f,
  0x0fc30, 0x0fc31, 0x0fc32, 0x0fc33, 0x0fc34, 0x0fc35, 0x0fc36, 0x0fc37,
  0x0fc38, 0x0fc39, 0x0fc3a, 0x0fc3b, 0x0fc3c, 0x0fc3d, 0x0fc3e, 0x0fc3f,
  0x0fc40, 0x0fc41, 0x0fc42, 0x0fc43, 0x0fc44, 0x0fc45, 0x0fc46, 0x0fc47,
  0x0fc48, 0x0fc49, 0x0fc4a, 0x0fc4b, 0x0fc4c, 0x0fc4d, 0x0fc4e, 0x0fc4f,
  0x0fc50, 0x0fc51, 0x0fc52, 0x0fc53, 0x0fc54, 0x0fc55, 0x0fc56, 0x0fc57,
  0x0fc58, 0x0fc59, 0x0fc5a, 0x00630, 0x00631, 0x00649, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x0fc64, 0x0fc65, 0x0fc02, 0x0fc67,
  0x0fbf9, 0x0fc04, 0x0fc6a, 0x0fc6b, 0x0fc08, 0x0fc6d, 0x0fc09, 0x0fc0a,
  0x0fc70, 0x0fc71, 0x0fc0e, 0x0fc73, 0x0fc0f, 0x0fc10, 0x0fc76, 0x0fc77,
  0x0fc12, 0x0fc79, 0x0fc13, 0x0fc14, 0x0fc31, 0x0fc32, 0x0fc35, 0x0fc36,
  0x0fc37, 0x0fc3b, 0x0fc3c, 0x0fc3d, 0x0fc3e, 0x0fc42, 0x0fc43, 0x0fc44,
  0x0fc88, 0x0fc48, 0x0fc8a, 0x0fc8b, 0x0fc4e, 0x0fc8d, 0x0fc4f, 0x0fc50,
  0x00649, 0x0fc91, 0x0fc92, 0x0fc58, 0x0fc94, 0x0fc59, 0x0fc5a, 0x0fc00,
  0x0fc01, 0x0fc99, 0x0fc02, 0x0fc9b, 0x0fc05, 0x0fc06, 0x0fc07, 0x0fc08,
  0x0fca0, 0x0fc0b, 0x0fc0c, 0x0fc0d, 0x0fc0e, 0x0fca5, 0x0fc12, 0x0fc15,
  0x0fc16, 0x0fc17, 0x0fc18, 0x0fc19, 0x0fc1b, 0x0fc1c, 0x0fc1d, 0x0fc1e,
  0x0fc1f, 0x0fc20, 0x0fcb2, 0x0fc21, 0x0fc22, 0x0fc23, 0x0fc24, 0x0fc25,
  0x0fc26, 0x0fc28, 0x0fc29, 0x0fc2a, 0x0fc2b, 0x0fc2c, 0x0fc2d, 0x0fc2e,
  0x0fc2f, 0x0fc30, 0x0fc33, 0x0fc34, 0x0fc38, 0x0fc39, 0x0fc3a, 0x0fc3b,
  0x0fc3c, 0x0fc3f, 0x0fc40, 0x0fc41, 0x0fc42, 0x0fccd, 0x0fc45, 0x0fc46,
  0x0fc47, 0x0fc48, 0x0fc4b, 0x0fc4c, 0x0fc4d, 0x0fc4e, 0x0fcd6, 0x0fc51,
  0x0fc52, 0x00647, 0x0fc55, 0x0fc56, 0x0fc57, 0x0fc58, 0x0fcde, 0x0fc02,
  0x0fc9b, 0x0fc08, 0x0fca0, 0x0fc0e, 0x0fca5, 0x0fc12, 0x0fce6, 0x0fc1f,
  0x0fce8, 0x0fce9, 0x0fcea, 0x0fc3b, 0x0fc3c, 0x0fc42, 0x0fc4e, 0x0fcd6,
  0x0fc58, 0x0fcde, 0x00000, 0x00000, 0x00000, 0x0fcf5, 0x0fcf6, 0x0fcf7,
  0x0fcf8, 0x0fcf9, 0x0fcfa, 0x0fcfb, 0x0fcfc, 0x0fcfd, 0x0fcfe, 0x0fcff
};

static uint32_t unicode_520_ci_page_fd[] = {
  0x0fd00, 0x0fd01, 0x0fd02, 0x0fd03, 0x0fd04, 0x0fd05, 0x0fd06, 0x0fd07,
  0x0fd08, 0x0fd09, 0x0fd0a, 0x0fd0b, 0x0fce9, 0x0fd0d, 0x0fd0e, 0x0fd0f,
  0x0fd10, 0x0fcf5, 0x0fcf6, 0x0fcf7, 0x0fcf8, 0x0fcf9, 0x0fcfa, 0x0fcfb,
  0x0fcfc, 0x0fcfd, 0x0fcfe, 0x0fd1b, 0x0fd00, 0x0fd01, 0x0fd02, 0x0fd03,
  0x0fd04, 0x0fd05, 0x0fd06, 0x0fd07, 0x0fd08, 0x0fd09, 0x0fd0a, 0x0fd0b,
  0x0fce9, 0x0fd0d, 0x0fd0e, 0x0fd0f, 0x0fd10, 0x0fd09, 0x0fd0a, 0x0fd0b,
  0x0fce9, 0x0fce8, 0x0fcea, 0x0fc27, 0x0fc1c, 0x0fc1d, 0x0fc1e, 0x0fd09,
  0x0fd0a, 0x0fd0b, 0x0fc27, 0x0fc28, 0x00627, 0x00627, 0x0fd3e, 0x0fd3f,
  0x0fd40, 0x0fd41, 0x0fd42, 0x0fd43, 0x0fd44, 0x0fd45, 0x0fd46, 0x0fd47,
  0x0fd48, 0x0fd49, 0x0fd4a, 0x0fd4b, 0x0fd4c, 0x0fd4d, 0x0fd4e, 0x0fd4f,
  0x0fd50, 0x0fd51, 0x0fd51, 0x0fd53, 0x0fd54, 0x0fd55, 0x0fd56, 0x0fd57,
  0x0fd58, 0x0fd58, 0x0fd5a, 0x0fd5b, 0x0fd5c, 0x0fd5d, 0x0fd5e, 0x0fd5f,
  0x0fd5f, 0x0fd61, 0x0fd62, 0x0fd62, 0x0fd64, 0x0fd64, 0x0fd66, 0x0fd67,
  0x0fd67, 0x0fd69, 0x0fd6a, 0x0fd6a, 0x0fd6c, 0x0fd6c, 0x0fd6e, 0x0fd6f,
  0x0fd6f, 0x0fd71, 0x0fd71, 0x0fd73, 0x0fd74, 0x0fd75, 0x0fd76, 0x0fd76,
  0x0fd78, 0x0fd79, 0x0fd7a, 0x0fd7b, 0x0fd7c, 0x0fd7c, 0x0fd7e, 0x0fd7f,
  0x0fd80, 0x0fd81, 0x0fd82, 0x0fd83, 0x0fd83, 0x0fd85, 0x0fd85, 0x0fd87,
  0x0fd87, 0x0fd89, 0x0fd8a, 0x0fd8b, 0x0fd8c, 0x0fd8d, 0x0fd8e, 0x0fd8f,
  0x0fd90, 0x0fd91, 0x0fd92, 0x0fd93, 0x0fd94, 0x0fd95, 0x0fd96, 0x0fd97,
  0x0fd97, 0x0fd99, 0x0fd9a, 0x0fd9b, 0x0fd9c, 0x0fd9c, 0x0fd9e, 0x0fd9f,
  0x0fda0, 0x0fda1, 0x0fda2, 0x0fda3, 0x0fda4, 0x0fda5, 0x0fda6, 0x0fda7,
  0x0fda8, 0x0fda9, 0x0fdaa, 0x0fdab, 0x0fdac, 0x0fdad, 0x0fdae, 0x0fdaf,
  0x0fdb0, 0x0fdb1, 0x0fdb2, 0x0fdb3, 0x0fd7e, 0x0fd80, 0x0fdb6, 0x0fdb7,
  0x0fdb8, 0x0fdb9, 0x0fdba, 0x0fdbb, 0x0fdba, 0x0fdb8, 0x0fdbe, 0x0fdbf,
  0x0fdc0, 0x0fdc1, 0x0fdc2, 0x0fdbb, 0x0fd75, 0x0fd66, 0x0fdc6, 0x0fdc7,
  0x0fdc8, 0x0fdc9, 0x0fdca, 0x0fdcb, 0x0fdcc, 0x0fdcd, 0x0fdce, 0x0fdcf,
  0x0fdd0, 0x0fdd1, 0x0fdd2, 0x0fdd3, 0x0fdd4, 0x0fdd5, 0x0fdd6, 0x0fdd7,
  0x0fdd8, 0x0fdd9, 0x0fdda, 0x0fddb, 0x0fddc, 0x0fddd, 0x0fdde, 0x0fddf,
  0x0fde0, 0x0fde1, 0x0fde2, 0x0fde3, 0x0fde4, 0x0fde5, 0x0fde6, 0x0fde7,
  0x0fde8, 0x0fde9, 0x0fdea, 0x0fdeb, 0x0fdec, 0x0fded, 0x0fdee, 0x0fdef,
  0x0fdf0, 0x0fdf1, 0x0fdf2, 0x0fdf3, 0x0fdf4, 0x0fdf5, 0x0fdf6, 0x0fdf7,
  0x0fdf8, 0x0fdf9, 0x0fdfa, 0x0fdfb, 0x0fdfc, 0x0fdfd, 0x0fdfe, 0x0fdff
};

static uint32_t unicode_520_ci_page_fe[] = {
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x0002c, 0x03001, 0x03002, 0x0003a, 0x0003b, 0x00021, 0x0003f, 0x03016,
  0x03017, 0x02026, 0x0fe1a, 0x0fe1b, 0x0fe1c, 0x0fe1d, 0x0fe1e, 0x0fe1f,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x0fe27,
  0x0fe28, 0x0fe29, 0x0fe2a, 0x0fe2b, 0x0fe2c, 0x0fe2d, 0x0fe2e, 0x0fe2f,
  0x02025, 0x02014, 0x02013, 0x0005f, 0x0005f, 0x00028, 0x00029, 0x0007b,
  0x0007d, 0x03014, 0x03015, 0x03010, 0x03011, 0x0300a, 0x0300b, 0x02329,
  0x0232a, 0x0300c, 0x0300d, 0x0300e, 0x0300f, 0x0fe45, 0x0fe46, 0x0005b,
  0x0005d, 0x0203e, 0x0203e, 0x0203e, 0x0203e, 0x0005f, 0x0005f, 0x0005f,
  0x0002c, 0x03001, 0x0002e, 0x0fe53, 0x0003b, 0x0003a, 0x0003f, 0x00021,
  0x02014, 0x00028, 0x00029, 0x0007b, 0x0007d, 0x03014, 0x03015, 0x00023,
  0x00026, 0x0002a, 0x0002b, 0x0002d, 0x0003c, 0x0003e, 0x0003d, 0x0fe67,
  0x0005c, 0x00024, 0x00025, 0x00040, 0x0fe6c, 0x0fe6d, 0x0fe6e, 0x0fe6f,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x0fe75, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00621, 0x00622, 0x00622, 0x00623, 0x00623, 0x00624, 0x00624, 0x00625,
  0x00625, 0x00626, 0x00626, 0x00626, 0x00626, 0x00627, 0x00627, 0x00628,
  0x00628, 0x00628, 0x00628, 0x00629, 0x00629, 0x0062a, 0x0062a, 0x0062a,
  0x0062a, 0x0062b, 0x0062b, 0x0062b, 0x0062b, 0x0062c, 0x0062c, 0x0062c,
  0x0062c, 0x0062d, 0x0062d, 0x0062d, 0x0062d, 0x0062e, 0x0062e, 0x0062e,
  0x0062e, 0x0062f, 0x0062f, 0x00630, 0x00630, 0x00631, 0x00631, 0x00632,
  0x00632, 0x00633, 0x00633, 0x00633, 0x00633, 0x00634, 0x00634, 0x00634,
  0x00634, 0x00635, 0x00635, 0x00635, 0x00635, 0x00636, 0x00636, 0x00636,
  0x00636, 0x00637, 0x00637, 0x00637, 0x00637, 0x00638, 0x00638, 0x00638,
  0x00638, 0x00639, 0x00639, 0x00639, 0x00639, 0x0063a, 0x0063a, 0x0063a,
  0x0063a, 0x00641, 0x00641, 0x00641, 0x00641, 0x00642, 0x00642, 0x00642,
  0x00642, 0x00643, 0x00643, 0x00643, 0x00643, 0x00644, 0x00644, 0x00644,
  0x00644, 0x00645, 0x00645, 0x00645, 0x00645, 0x00646, 0x00646, 0x00646,
  0x00646, 0x00647, 0x00647, 0x00647, 0x00647, 0x00648, 0x00648, 0x00649,
  0x00649, 0x0064a, 0x0064a, 0x0064a, 0x0064a, 0x0fef5, 0x0fef5, 0x0fef7,
  0x0fef7, 0x0fef9, 0x0fef9, 0x0fefb, 0x0fefb, 0x0fefd, 0x0fefe, 0x0feff
};

static uint32_t unicode_520_ci_page_ff[] = {
  0x0ff00, 0x00021, 0x00022, 0x00023, 0x00024, 0x00025, 0x00026, 0x00027,
  0x00028, 0x00029, 0x0002a, 0x0002b, 0x0002c, 0x0002d, 0x0002e, 0x0002f,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x0003a, 0x0003b, 0x0003c, 0x0003d, 0x0003e, 0x0003f,
  0x00040, 0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046, 0x00047,
  0x00048, 0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f,
  0x00050, 0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056, 0x00057,
  0x00058, 0x00059, 0x0005a, 0x0005b, 0x0005c, 0x0005d, 0x0005e, 0x0005f,
  0x00060, 0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046, 0x00047,
  0x00048, 0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f,
  0x00050, 0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056, 0x00057,
  0x00058, 0x00059, 0x0005a, 0x0007b, 0x0007c, 0x0007d, 0x0007e, 0x02985,
  0x02986, 0x03002, 0x0300c, 0x0300d, 0x03001, 0x030fb, 0x03092, 0x03042,
  0x03044, 0x03046, 0x03048, 0x0304a, 0x03084, 0x03086, 0x03088, 0x03064,
  0x030fc, 0x03042, 0x03044, 0x03046, 0x03048, 0x0304a, 0x0304b, 0x0304d,
  0x0304f, 0x03051, 0x03053, 0x03055, 0x03057, 0x03059, 0x0305b, 0x0305d,
  0x0305f, 0x03061, 0x03064, 0x03066, 0x03068, 0x0306a, 0x0306b, 0x0306c,
  0x0306d, 0x0306e, 0x0306f, 0x03072, 0x03075, 0x03078, 0x0307b, 0x0307e,
  0x0307f, 0x03080, 0x03081, 0x03082, 0x03084, 0x03086, 0x03088, 0x03089,
  0x0308a, 0x0308b, 0x0308c, 0x0308d, 0x0308f, 0x03093, 0x00000, 0x00000,
  0x01160, 0x01100, 0x01101, 0x011aa, 0x01102, 0x011ac, 0x011ad, 0x01103,
  0x01104, 0x01105, 0x011b0, 0x011b1, 0x011b2, 0x011b3, 0x011b4, 0x011b5,
  0x0111a, 0x01106, 0x01107, 0x01108, 0x01121, 0x01109, 0x0110a, 0x0110b,
  0x0110c, 0x0110d, 0x0110e, 0x0110f, 0x01110, 0x01111, 0x01112, 0x0ffbf,
  0x0ffc0, 0x0ffc1, 0x01161, 0x01162, 0x01163, 0x01164, 0x01165, 0x01166,
  0x0ffc8, 0x0ffc9, 0x01167, 0x01168, 0x01169, 0x0116a, 0x0116b, 0x0116c,
  0x0ffd0, 0x0ffd1, 0x0116d, 0x0116e, 0x0116f, 0x01170, 0x01171, 0x01172,
  0x0ffd8, 0x0ffd9, 0x01173, 0x01174, 0x01175, 0x0ffdd, 0x0ffde, 0x0ffdf,
  0x000a2, 0x000a3, 0x000ac, 0x000af, 0x000a6, 0x000a5, 0x020a9, 0x0ffe7,
  0x02502, 0x02190, 0x02191, 0x02192, 0x02193, 0x025a0, 0x025cb, 0x0ffef,
  0x0fff0, 0x0fff1, 0x0fff2, 0x0fff3, 0x0fff4, 0x0fff5, 0x0fff6, 0x0fff7,
  0x0fff8, 0x00000, 0x00000, 0x00000, 0x0fffc, 0x0fffd, 0x0fffe, 0x0ffff
};

static uint32_t unicode_520_ci_page_101[] = {
  0x10100, 0x10101, 0x10102, 0x10103, 0x10104, 0x10105, 0x10106, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039,
  0x10110, 0x10111, 0x10112, 0x10113, 0x10114, 0x10115, 0x10116, 0x10117,
  0x10118, 0x10119, 0x1011a, 0x1011b, 0x1011c, 0x1011d, 0x1011e, 0x1011f,
  0x10120, 0x10121, 0x10122, 0x10123, 0x10124, 0x10125, 0x10126, 0x10127,
  0x10128, 0x10129, 0x1012a, 0x1012b, 0x1012c, 0x1012d, 0x1012e, 0x1012f,
  0x10130, 0x10131, 0x10132, 0x10133, 0x10134, 0x10135, 0x10136, 0x10137,
  0x10138, 0x10139, 0x1013a, 0x1013b, 0x1013c, 0x1013d, 0x1013e, 0x1013f,
  0x10140, 0x10141, 0x00031, 0x00035, 0x10144, 0x10145, 0x10146, 0x10147,
  0x00035, 0x10149, 0x1014a, 0x1014b, 0x1014c, 0x1014d, 0x1014e, 0x00035,
  0x10150, 0x10151, 0x10152, 0x10153, 0x10154, 0x10155, 0x10156, 0x10157,
  0x00031, 0x00031, 0x00031, 0x00032, 0x00032, 0x00032, 0x00032, 0x00035,
  0x10160, 0x10161, 0x10162, 0x10163, 0x10164, 0x10165, 0x10166, 0x10167,
  0x10168, 0x10169, 0x1016a, 0x1016b, 0x1016c, 0x1016d, 0x1016e, 0x1016f,
  0x10170, 0x10171, 0x10172, 0x00035, 0x10174, 0x10175, 0x10176, 0x10177,
  0x10178, 0x10179, 0x1017a, 0x1017b, 0x1017c, 0x1017d, 0x1017e, 0x1017f,
  0x10180, 0x10181, 0x10182, 0x10183, 0x10184, 0x10185, 0x10186, 0x10187,
  0x10188, 0x10189, 0x00030, 0x1018b, 0x1018c, 0x1018d, 0x1018e, 0x1018f,
  0x10190, 0x10191, 0x10192, 0x10193, 0x10194, 0x10195, 0x10196, 0x10197,
  0x10198, 0x10199, 0x1019a, 0x1019b, 0x1019c, 0x1019d, 0x1019e, 0x1019f,
  0x101a0, 0x101a1, 0x101a2, 0x101a3, 0x101a4, 0x101a5, 0x101a6, 0x101a7,
  0x101a8, 0x101a9, 0x101aa, 0x101ab, 0x101ac, 0x101ad, 0x101ae, 0x101af,
  0x101b0, 0x101b1, 0x101b2, 0x101b3, 0x101b4, 0x101b5, 0x101b6, 0x101b7,
  0x101b8, 0x101b9, 0x101ba, 0x101bb, 0x101bc, 0x101bd, 0x101be, 0x101bf,
  0x101c0, 0x101c1, 0x101c2, 0x101c3, 0x101c4, 0x101c5, 0x101c6, 0x101c7,
  0x101c8, 0x101c9, 0x101ca, 0x101cb, 0x101cc, 0x101cd, 0x101ce, 0x101cf,
  0x101d0, 0x101d1, 0x101d2, 0x101d3, 0x101d4, 0x101d5, 0x101d6, 0x101d7,
  0x101d8, 0x101d9, 0x101da, 0x101db, 0x101dc, 0x101dd, 0x101de, 0x101df,
  0x101e0, 0x101e1, 0x101e2, 0x101e3, 0x101e4, 0x101e5, 0x101e6, 0x101e7,
  0x101e8, 0x101e9, 0x101ea, 0x101eb, 0x101ec, 0x101ed, 0x101ee, 0x101ef,
  0x101f0, 0x101f1, 0x101f2, 0x101f3, 0x101f4, 0x101f5, 0x101f6, 0x101f7,
  0x101f8, 0x101f9, 0x101fa, 0x101fb, 0x101fc, 0x00000, 0x101fe, 0x101ff
};

static uint32_t unicode_520_ci_page_103[] = {
  0x10300, 0x10301, 0x10302, 0x10303, 0x10304, 0x10305, 0x10306, 0x10307,
  0x10308, 0x10309, 0x1030a, 0x1030b, 0x1030c, 0x1030d, 0x1030e, 0x1030f,
  0x10310, 0x10311, 0x10312, 0x10313, 0x10314, 0x10315, 0x10316, 0x10317,
  0x10318, 0x10319, 0x1031a, 0x1031b, 0x1031c, 0x1031d, 0x1031e, 0x1031f,
  0x00031, 0x00035, 0x10322, 0x10323, 0x10324, 0x10325, 0x10326, 0x10327,
  0x10328, 0x10329, 0x1032a, 0x1032b, 0x1032c, 0x1032d, 0x1032e, 0x1032f,
  0x10330, 0x10331, 0x10332, 0x10333, 0x10334, 0x10335, 0x10336, 0x10337,
  0x10338, 0x10339, 0x1033a, 0x1033b, 0x1033c, 0x1033d, 0x1033e, 0x1033f,
  0x10340, 0x10341, 0x10342, 0x10343, 0x10344, 0x10345, 0x10346, 0x10347,
  0x10348, 0x10349, 0x1034a, 0x1034b, 0x1034c, 0x1034d, 0x1034e, 0x1034f,
  0x10350, 0x10351, 0x10352, 0x10353, 0x10354, 0x10355, 0x10356, 0x10357,
  0x10358, 0x10359, 0x1035a, 0x1035b, 0x1035c, 0x1035d, 0x1035e, 0x1035f,
  0x10360, 0x10361, 0x10362, 0x10363, 0x10364, 0x10365, 0x10366, 0x10367,
  0x10368, 0x10369, 0x1036a, 0x1036b, 0x1036c, 0x1036d, 0x1036e, 0x1036f,
  0x10370, 0x10371, 0x10372, 0x10373, 0x10374, 0x10375, 0x10376, 0x10377,
  0x10378, 0x10379, 0x1037a, 0x1037b, 0x1037c, 0x1037d, 0x1037e, 0x1037f,
  0x10380, 0x10381, 0x10382, 0x10383, 0x10384, 0x10385, 0x10386, 0x10387,
  0x10388, 0x10389, 0x1038a, 0x1038b, 0x1038c, 0x1038d, 0x1038e, 0x1038f,
  0x10390, 0x10391, 0x10392, 0x10393, 0x10394, 0x10395, 0x10396, 0x10397,
  0x10398, 0x10399, 0x1039a, 0x1039b, 0x1039c, 0x1039d, 0x1039e, 0x1039f,
  0x103a0, 0x103a1, 0x103a2, 0x103a3, 0x103a4, 0x103a5, 0x103a6, 0x103a7,
  0x103a8, 0x103a9, 0x103aa, 0x103ab, 0x103ac, 0x103ad, 0x103ae, 0x103af,
  0x103b0, 0x103b1, 0x103b2, 0x103b3, 0x103b4, 0x103b5, 0x103b6, 0x103b7,
  0x103b8, 0x103b9, 0x103ba, 0x103bb, 0x103bc, 0x103bd, 0x103be, 0x103bf,
  0x103c0, 0x103c1, 0x103c2, 0x103c3, 0x103c4, 0x103c5, 0x103c6, 0x103c7,
  0x103c8, 0x103c9, 0x103ca, 0x103cb, 0x103cc, 0x103cd, 0x103ce, 0x103cf,
  0x103d0, 0x00031, 0x00032, 0x103d3, 0x103d4, 0x103d5, 0x103d6, 0x103d7,
  0x103d8, 0x103d9, 0x103da, 0x103db, 0x103dc, 0x103dd, 0x103de, 0x103df,
  0x103e0, 0x103e1, 0x103e2, 0x103e3, 0x103e4, 0x103e5, 0x103e6, 0x103e7,
  0x103e8, 0x103e9, 0x103ea, 0x103eb, 0x103ec, 0x103ed, 0x103ee, 0x103ef,
  0x103f0, 0x103f1, 0x103f2, 0x103f3, 0x103f4, 0x103f5, 0x103f6, 0x103f7,
  0x103f8, 0x103f9, 0x103fa, 0x103fb, 0x103fc, 0x103fd, 0x103fe, 0x103ff
};

static uint32_t unicode_520_ci_page_104[] = {
  0x10400, 0x10401, 0x10402, 0x10403, 0x10404, 0x10405, 0x10406, 0x10407,
  0x10408, 0x10409, 0x1040a, 0x1040b, 0x1040c, 0x1040d, 0x1040e, 0x1040f,
  0x10410, 0x10411, 0x10412, 0x10413, 0x10414, 0x10415, 0x10416, 0x10417,
  0x10418, 0x10419, 0x1041a, 0x1041b, 0x1041c, 0x1041d, 0x1041e, 0x1041f,
  0x10420, 0x10421, 0x10422, 0x10423, 0x10424, 0x10425, 0x10426, 0x10427,
  0x10400, 0x10401, 0x10402, 0x10403, 0x10404, 0x10405, 0x10406, 0x10407,
  0x10408, 0x10409, 0x1040a, 0x1040b, 0x1040c, 0x1040d, 0x1040e, 0x1040f,
  0x10410, 0x10411, 0x10412, 0x10413, 0x10414, 0x10415, 0x10416, 0x10417,
  0x10418, 0x10419, 0x1041a, 0x1041b, 0x1041c, 0x1041d, 0x1041e, 0x1041f,
  0x10420, 0x10421, 0x10422, 0x10423, 0x10424, 0x10425, 0x10426, 0x10427,
  0x10450, 0x10451, 0x10452, 0x10453, 0x10454, 0x10455, 0x10456, 0x10457,
  0x10458, 0x10459, 0x1045a, 0x1045b, 0x1045c, 0x1045d, 0x1045e, 0x1045f,
  0x10460, 0x10461, 0x10462, 0x10463, 0x10464, 0x10465, 0x10466, 0x10467,
  0x10468, 0x10469, 0x1046a, 0x1046b, 0x1046c, 0x1046d, 0x1046e, 0x1046f,
  0x10470, 0x10471, 0x10472, 0x10473, 0x10474, 0x10475, 0x10476, 0x10477,
  0x10478, 0x10479, 0x1047a, 0x1047b, 0x1047c, 0x1047d, 0x1047e, 0x1047f,
  0x10480, 0x10481, 0x10482, 0x10483, 0x10484, 0x10485, 0x10486, 0x10487,
  0x10488, 0x10489, 0x1048a, 0x1048b, 0x1048c, 0x1048d, 0x1048e, 0x1048f,
  0x10490, 0x10491, 0x10492, 0x10493, 0x10494, 0x10495, 0x10496, 0x10497,
  0x10498, 0x10499, 0x1049a, 0x1049b, 0x1049c, 0x1049d, 0x1049e, 0x1049f,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x104aa, 0x104ab, 0x104ac, 0x104ad, 0x104ae, 0x104af,
  0x104b0, 0x104b1, 0x104b2, 0x104b3, 0x104b4, 0x104b5, 0x104b6, 0x104b7,
  0x104b8, 0x104b9, 0x104ba, 0x104bb, 0x104bc, 0x104bd, 0x104be, 0x104bf,
  0x104c0, 0x104c1, 0x104c2, 0x104c3, 0x104c4, 0x104c5, 0x104c6, 0x104c7,
  0x104c8, 0x104c9, 0x104ca, 0x104cb, 0x104cc, 0x104cd, 0x104ce, 0x104cf,
  0x104d0, 0x104d1, 0x104d2, 0x104d3, 0x104d4, 0x104d5, 0x104d6, 0x104d7,
  0x104d8, 0x104d9, 0x104da, 0x104db, 0x104dc, 0x104dd, 0x104de, 0x104df,
  0x104e0, 0x104e1, 0x104e2, 0x104e3, 0x104e4, 0x104e5, 0x104e6, 0x104e7,
  0x104e8, 0x104e9, 0x104ea, 0x104eb, 0x104ec, 0x104ed, 0x104ee, 0x104ef,
  0x104f0, 0x104f1, 0x104f2, 0x104f3, 0x104f4, 0x104f5, 0x104f6, 0x104f7,
  0x104f8, 0x104f9, 0x104fa, 0x104fb, 0x104fc, 0x104fd, 0x104fe, 0x104ff
};

static uint32_t unicode_520_ci_page_108[] = {
  0x10800, 0x10801, 0x10802, 0x10803, 0x10804, 0x10805, 0x10806, 0x10807,
  0x10808, 0x10809, 0x1080a, 0x1080b, 0x1080c, 0x1080d, 0x1080e, 0x1080f,
  0x10810, 0x10811, 0x10812, 0x10813, 0x10814, 0x10815, 0x10816, 0x10817,
  0x10818, 0x10819, 0x1081a, 0x1081b, 0x1081c, 0x1081d, 0x1081e, 0x1081f,
  0x10820, 0x10821, 0x10822, 0x10823, 0x10824, 0x10825, 0x10826, 0x10827,
  0x10828, 0x10829, 0x1082a, 0x1082b, 0x1082c, 0x1082d, 0x1082e, 0x1082f,
  0x10830, 0x10831, 0x10832, 0x10833, 0x10834, 0x10835, 0x10836, 0x10837,
  0x10838, 0x10839, 0x1083a, 0x1083b, 0x1083c, 0x1083d, 0x1083e, 0x1083f,
  0x10840, 0x10841, 0x10842, 0x10843, 0x10844, 0x10845, 0x10846, 0x10847,
  0x10848, 0x10849, 0x1084a, 0x1084b, 0x1084c, 0x1084d, 0x1084e, 0x1084f,
  0x10850, 0x10851, 0x10852, 0x10853, 0x10854, 0x10855, 0x10856, 0x10857,
  0x00031, 0x00032, 0x00033, 0x1085b, 0x1085c, 0x1085d, 0x1085e, 0x1085f,
  0x10860, 0x10861, 0x10862, 0x10863, 0x10864, 0x10865, 0x10866, 0x10867,
  0x10868, 0x10869, 0x1086a, 0x1086b, 0x1086c, 0x1086d, 0x1086e, 0x1086f,
  0x10870, 0x10871, 0x10872, 0x10873, 0x10874, 0x10875, 0x10876, 0x10877,
  0x10878, 0x10879, 0x1087a, 0x1087b, 0x1087c, 0x1087d, 0x1087e, 0x1087f,
  0x10880, 0x10881, 0x10882, 0x10883, 0x10884, 0x10885, 0x10886, 0x10887,
  0x10888, 0x10889, 0x1088a, 0x1088b, 0x1088c, 0x1088d, 0x1088e, 0x1088f,
  0x10890, 0x10891, 0x10892, 0x10893, 0x10894, 0x10895, 0x10896, 0x10897,
  0x10898, 0x10899, 0x1089a, 0x1089b, 0x1089c, 0x1089d, 0x1089e, 0x1089f,
  0x108a0, 0x108a1, 0x108a2, 0x108a3, 0x108a4, 0x108a5, 0x108a6, 0x108a7,
  0x108a8, 0x108a9, 0x108aa, 0x108ab, 0x108ac, 0x108ad, 0x108ae, 0x108af,
  0x108b0, 0x108b1, 0x108b2, 0x108b3, 0x108b4, 0x108b5, 0x108b6, 0x108b7,
  0x108b8, 0x108b9, 0x108ba, 0x108bb, 0x108bc, 0x108bd, 0x108be, 0x108bf,
  0x108c0, 0x108c1, 0x108c2, 0x108c3, 0x108c4, 0x108c5, 0x108c6, 0x108c7,
  0x108c8, 0x108c9, 0x108ca, 0x108cb, 0x108cc, 0x108cd, 0x108ce, 0x108cf,
  0x108d0, 0x108d1, 0x108d2, 0x108d3, 0x108d4, 0x108d5, 0x108d6, 0x108d7,
  0x108d8, 0x108d9, 0x108da, 0x108db, 0x108dc, 0x108dd, 0x108de, 0x108df,
  0x108e0, 0x108e1, 0x108e2, 0x108e3, 0x108e4, 0x108e5, 0x108e6, 0x108e7,
  0x108e8, 0x108e9, 0x108ea, 0x108eb, 0x108ec, 0x108ed, 0x108ee, 0x108ef,
  0x108f0, 0x108f1, 0x108f2, 0x108f3, 0x108f4, 0x108f5, 0x108f6, 0x108f7,
  0x108f8, 0x108f9, 0x108fa, 0x108fb, 0x108fc, 0x108fd, 0x108fe, 0x108ff
};

static uint32_t unicode_520_ci_page_109[] = {
  0x10900, 0x10901, 0x10902, 0x10903, 0x10904, 0x10905, 0x10906, 0x10907,
  0x10908, 0x10909, 0x1090a, 0x1090b, 0x1090c, 0x1090d, 0x1090e, 0x1090f,
  0x10910, 0x10911, 0x10912, 0x10913, 0x10914, 0x10915, 0x00031, 0x10917,
  0x10918, 0x10919, 0x00032, 0x00033, 0x1091c, 0x1091d, 0x1091e, 0x1091f,
  0x10920, 0x10921, 0x10922, 0x10923, 0x10924, 0x10925, 0x10926, 0x10927,
  0x10928, 0x10929, 0x1092a, 0x1092b, 0x1092c, 0x1092d, 0x1092e, 0x1092f,
  0x10930, 0x10931, 0x10932, 0x10933, 0x10934, 0x10935, 0x10936, 0x10937,
  0x10938, 0x10939, 0x1093a, 0x1093b, 0x1093c, 0x1093d, 0x1093e, 0x1093f,
  0x10940, 0x10941, 0x10942, 0x10943, 0x10944, 0x10945, 0x10946, 0x10947,
  0x10948, 0x10949, 0x1094a, 0x1094b, 0x1094c, 0x1094d, 0x1094e, 0x1094f,
  0x10950, 0x10951, 0x10952, 0x10953, 0x10954, 0x10955, 0x10956, 0x10957,
  0x10958, 0x10959, 0x1095a, 0x1095b, 0x1095c, 0x1095d, 0x1095e, 0x1095f,
  0x10960, 0x10961, 0x10962, 0x10963, 0x10964, 0x10965, 0x10966, 0x10967,
  0x10968, 0x10969, 0x1096a, 0x1096b, 0x1096c, 0x1096d, 0x1096e, 0x1096f,
  0x10970, 0x10971, 0x10972, 0x10973, 0x10974, 0x10975, 0x10976, 0x10977,
  0x10978, 0x10979, 0x1097a, 0x1097b, 0x1097c, 0x1097d, 0x1097e, 0x1097f,
  0x10980, 0x10981, 0x10982, 0x10983, 0x10984, 0x10985, 0x10986, 0x10987,
  0x10988, 0x10989, 0x1098a, 0x1098b, 0x1098c, 0x1098d, 0x1098e, 0x1098f,
  0x10990, 0x10991, 0x10992, 0x10993, 0x10994, 0x10995, 0x10996, 0x10997,
  0x10998, 0x10999, 0x1099a, 0x1099b, 0x1099c, 0x1099d, 0x1099e, 0x1099f,
  0x109a0, 0x109a1, 0x109a2, 0x109a3, 0x109a4, 0x109a5, 0x109a6, 0x109a7,
  0x109a8, 0x109a9, 0x109aa, 0x109ab, 0x109ac, 0x109ad, 0x109ae, 0x109af,
  0x109b0, 0x109b1, 0x109b2, 0x109b3, 0x109b4, 0x109b5, 0x109b6, 0x109b7,
  0x109b8, 0x109b9, 0x109ba, 0x109bb, 0x109bc, 0x109bd, 0x109be, 0x109bf,
  0x109c0, 0x109c1, 0x109c2, 0x109c3, 0x109c4, 0x109c5, 0x109c6, 0x109c7,
  0x109c8, 0x109c9, 0x109ca, 0x109cb, 0x109cc, 0x109cd, 0x109ce, 0x109cf,
  0x109d0, 0x109d1, 0x109d2, 0x109d3, 0x109d4, 0x109d5, 0x109d6, 0x109d7,
  0x109d8, 0x109d9, 0x109da, 0x109db, 0x109dc, 0x109dd, 0x109de, 0x109df,
  0x109e0, 0x109e1, 0x109e2, 0x109e3, 0x109e4, 0x109e5, 0x109e6, 0x109e7,
  0x109e8, 0x109e9, 0x109ea, 0x109eb, 0x109ec, 0x109ed, 0x109ee, 0x109ef,
  0x109f0, 0x109f1, 0x109f2, 0x109f3, 0x109f4, 0x109f5, 0x109f6, 0x109f7,
  0x109f8, 0x109f9, 0x109fa, 0x109fb, 0x109fc, 0x109fd, 0x109fe, 0x109ff
};

static uint32_t unicode_520_ci_page_10a[] = {
  0x10a00, 0x10a01, 0x10a02, 0x10a03, 0x10a04, 0x10a05, 0x10a06, 0x10a07,
  0x10a08, 0x10a09, 0x10a0a, 0x10a0b, 0x10a0c, 0x00000, 0x00000, 0x00000,
  0x10a10, 0x10a11, 0x10a12, 0x10a13, 0x10a14, 0x10a15, 0x10a16, 0x10a17,
  0x10a18, 0x10a19, 0x10a1a, 0x10a1b, 0x10a1c, 0x10a1d, 0x10a1e, 0x10a1f,
  0x10a20, 0x10a21, 0x10a22, 0x10a23, 0x10a24, 0x10a25, 0x10a26, 0x10a27,
  0x10a28, 0x10a29, 0x10a2a, 0x10a2b, 0x10a2c, 0x10a2d, 0x10a2e, 0x10a2f,
  0x10a30, 0x10a31, 0x10a32, 0x10a33, 0x10a34, 0x10a35, 0x10a36, 0x10a37,
  0x00000, 0x00000, 0x00000, 0x10a3b, 0x10a3c, 0x10a3d, 0x10a3e, 0x10a3f,
  0x00031, 0x00032, 0x00033, 0x00034, 0x10a44, 0x10a45, 0x10a46, 0x10a47,
  0x10a48, 0x10a49, 0x10a4a, 0x10a4b, 0x10a4c, 0x10a4d, 0x10a4e, 0x10a4f,
  0x10a50, 0x10a51, 0x10a52, 0x10a53, 0x10a54, 0x10a55, 0x10a56, 0x10a57,
  0x10a58, 0x10a59, 0x10a5a, 0x10a5b, 0x10a5c, 0x10a5d, 0x10a5e, 0x10a5f,
  0x10a60, 0x10a61, 0x10a62, 0x10a63, 0x10a64, 0x10a65, 0x10a66, 0x10a67,
  0x10a68, 0x10a69, 0x10a6a, 0x10a6b, 0x10a6c, 0x10a6d, 0x10a6e, 0x10a6f,
  0x10a70, 0x10a71, 0x10a72, 0x10a73, 0x10a74, 0x10a75, 0x10a76, 0x10a77,
  0x10a78, 0x10a79, 0x10a7a, 0x10a7b, 0x10a7c, 0x00031, 0x10a7e, 0x10a7f,
  0x10a80, 0x10a81, 0x10a82, 0x10a83, 0x10a84, 0x10a85, 0x10a86, 0x10a87,
  0x10a88, 0x10a89, 0x10a8a, 0x10a8b, 0x10a8c, 0x10a8d, 0x10a8e, 0x10a8f,
  0x10a90, 0x10a91, 0x10a92, 0x10a93, 0x10a94, 0x10a95, 0x10a96, 0x10a97,
  0x10a98, 0x10a99, 0x10a9a, 0x10a9b, 0x10a9c, 0x10a9d, 0x10a9e, 0x10a9f,
  0x10aa0, 0x10aa1, 0x10aa2, 0x10aa3, 0x10aa4, 0x10aa5, 0x10aa6, 0x10aa7,
  0x10aa8, 0x10aa9, 0x10aaa, 0x10aab, 0x10aac, 0x10aad, 0x10aae, 0x10aaf,
  0x10ab0, 0x10ab1, 0x10ab2, 0x10ab3, 0x10ab4, 0x10ab5, 0x10ab6, 0x10ab7,
  0x10ab8, 0x10ab9, 0x10aba, 0x10abb, 0x10abc, 0x10abd, 0x10abe, 0x10abf,
  0x10ac0, 0x10ac1, 0x10ac2, 0x10ac3, 0x10ac4, 0x10ac5, 0x10ac6, 0x10ac7,
  0x10ac8, 0x10ac9, 0x10aca, 0x10acb, 0x10acc, 0x10acd, 0x10ace, 0x10acf,
  0x10ad0, 0x10ad1, 0x10ad2, 0x10ad3, 0x10ad4, 0x10ad5, 0x10ad6, 0x10ad7,
  0x10ad8, 0x10ad9, 0x10ada, 0x10adb, 0x10adc, 0x10add, 0x10ade, 0x10adf,
  0x10ae0, 0x10ae1, 0x10ae2, 0x10ae3, 0x10ae4, 0x10ae5, 0x10ae6, 0x10ae7,
  0x10ae8, 0x10ae9, 0x10aea, 0x10aeb, 0x10aec, 0x10aed, 0x10aee, 0x10aef,
  0x10af0, 0x10af1, 0x10af2, 0x10af3, 0x10af4, 0x10af5, 0x10af6, 0x10af7,
  0x10af8, 0x10af9, 0x10afa, 0x10afb, 0x10afc, 0x10afd, 0x10afe, 0x10aff
};

static uint32_t unicode_520_ci_page_10b[] = {
  0x10b00, 0x10b01, 0x10b02, 0x10b03, 0x10b04, 0x10b05, 0x10b06, 0x10b07,
  0x10b08, 0x10b09, 0x10b0a, 0x10b0b, 0x10b0c, 0x10b0d, 0x10b0e, 0x10b0f,
  0x10b10, 0x10b11, 0x10b12, 0x10b13, 0x10b14, 0x10b15, 0x10b16, 0x10b17,
  0x10b18, 0x10b19, 0x10b1a, 0x10b1b, 0x10b1c, 0x10b1d, 0x10b1e, 0x10b1f,
  0x10b20, 0x10b21, 0x10b22, 0x10b23, 0x10b24, 0x10b25, 0x10b26, 0x10b27,
  0x10b28, 0x10b29, 0x10b2a, 0x10b2b, 0x10b2c, 0x10b2d, 0x10b2d, 0x10b2f,
  0x10b30, 0x10b31, 0x10b32, 0x10b33, 0x10b34, 0x10b35, 0x10b36, 0x10b37,
  0x10b38, 0x10b39, 0x10b3a, 0x10b3b, 0x10b3c, 0x10b3d, 0x10b3e, 0x10b3f,
  0x10b40, 0x10b41, 0x10b42, 0x10b43, 0x10b44, 0x10b45, 0x10b46, 0x10b47,
  0x10b48, 0x10b49, 0x10b4a, 0x10b4b, 0x10b4c, 0x10b4d, 0x10b4e, 0x10b4f,
  0x10b50, 0x10b51, 0x10b52, 0x10b53, 0x10b54, 0x10b55, 0x10b56, 0x10b57,
  0x00031, 0x00032, 0x00033, 0x00034, 0x10b5c, 0x10b5d, 0x10b5e, 0x10b5f,
  0x10b60, 0x10b61, 0x10b62, 0x10b63, 0x10b64, 0x10b65, 0x10b66, 0x10b67,
  0x10b68, 0x10b69, 0x10b6a, 0x10b6b, 0x10b6c, 0x10b6d, 0x10b6e, 0x10b6f,
  0x10b70, 0x10b71, 0x10b72, 0x10b73, 0x10b74, 0x10b75, 0x10b76, 0x10b77,
  0x00031, 0x00032, 0x00033, 0x00034, 0x10b7c, 0x10b7d, 0x10b7e, 0x10b7f,
  0x10b80, 0x10b81, 0x10b82, 0x10b83, 0x10b84, 0x10b85, 0x10b86, 0x10b87,
  0x10b88, 0x10b89, 0x10b8a, 0x10b8b, 0x10b8c, 0x10b8d, 0x10b8e, 0x10b8f,
  0x10b90, 0x10b91, 0x10b92, 0x10b93, 0x10b94, 0x10b95, 0x10b96, 0x10b97,
  0x10b98, 0x10b99, 0x10b9a, 0x10b9b, 0x10b9c, 0x10b9d, 0x10b9e, 0x10b9f,
  0x10ba0, 0x10ba1, 0x10ba2, 0x10ba3, 0x10ba4, 0x10ba5, 0x10ba6, 0x10ba7,
  0x10ba8, 0x10ba9, 0x10baa, 0x10bab, 0x10bac, 0x10bad, 0x10bae, 0x10baf,
  0x10bb0, 0x10bb1, 0x10bb2, 0x10bb3, 0x10bb4, 0x10bb5, 0x10bb6, 0x10bb7,
  0x10bb8, 0x10bb9, 0x10bba, 0x10bbb, 0x10bbc, 0x10bbd, 0x10bbe, 0x10bbf,
  0x10bc0, 0x10bc1, 0x10bc2, 0x10bc3, 0x10bc4, 0x10bc5, 0x10bc6, 0x10bc7,
  0x10bc8, 0x10bc9, 0x10bca, 0x10bcb, 0x10bcc, 0x10bcd, 0x10bce, 0x10bcf,
  0x10bd0, 0x10bd1, 0x10bd2, 0x10bd3, 0x10bd4, 0x10bd5, 0x10bd6, 0x10bd7,
  0x10bd8, 0x10bd9, 0x10bda, 0x10bdb, 0x10bdc, 0x10bdd, 0x10bde, 0x10bdf,
  0x10be0, 0x10be1, 0x10be2, 0x10be3, 0x10be4, 0x10be5, 0x10be6, 0x10be7,
  0x10be8, 0x10be9, 0x10bea, 0x10beb, 0x10bec, 0x10bed, 0x10bee, 0x10bef,
  0x10bf0, 0x10bf1, 0x10bf2, 0x10bf3, 0x10bf4, 0x10bf5, 0x10bf6, 0x10bf7,
  0x10bf8, 0x10bf9, 0x10bfa, 0x10bfb, 0x10bfc, 0x10bfd, 0x10bfe, 0x10bff
};

static uint32_t unicode_520_ci_page_10c[] = {
  0x10c00, 0x10c00, 0x10c02, 0x10c03, 0x10c03, 0x10c05, 0x10c06, 0x10c07,
  0x10c07, 0x10c09, 0x10c09, 0x10c0b, 0x10c0b, 0x10c0d, 0x10c0d, 0x10c0f,
  0x10c0f, 0x10c11, 0x10c11, 0x10c13, 0x10c14, 0x10c14, 0x10c16, 0x10c16,
  0x10c18, 0x10c18, 0x10c1a, 0x10c1a, 0x10c1c, 0x10c1c, 0x10c1e, 0x10c1e,
  0x10c20, 0x10c21, 0x10c22, 0x10c23, 0x10c24, 0x10c24, 0x10c26, 0x10c26,
  0x10c28, 0x10c28, 0x10c2a, 0x10c2a, 0x10c2c, 0x10c2d, 0x10c2d, 0x10c2f,
  0x10c30, 0x10c31, 0x10c32, 0x10c32, 0x10c34, 0x10c34, 0x10c36, 0x10c36,
  0x10c38, 0x10c38, 0x10c3a, 0x10c3a, 0x10c3c, 0x10c3d, 0x10c3e, 0x10c3f,
  0x10c3f, 0x10c41, 0x10c41, 0x10c43, 0x10c43, 0x10c45, 0x10c45, 0x10c47,
  0x10c48, 0x10c49, 0x10c4a, 0x10c4b, 0x10c4c, 0x10c4d, 0x10c4e, 0x10c4f,
  0x10c50, 0x10c51, 0x10c52, 0x10c53, 0x10c54, 0x10c55, 0x10c56, 0x10c57,
  0x10c58, 0x10c59, 0x10c5a, 0x10c5b, 0x10c5c, 0x10c5d, 0x10c5e, 0x10c5f,
  0x10c60, 0x10c61, 0x10c62, 0x10c63, 0x10c64, 0x10c65, 0x10c66, 0x10c67,
  0x10c68, 0x10c69, 0x10c6a, 0x10c6b, 0x10c6c, 0x10c6d, 0x10c6e, 0x10c6f,
  0x10c70, 0x10c71, 0x10c72, 0x10c73, 0x10c74, 0x10c75, 0x10c76, 0x10c77,
  0x10c78, 0x10c79, 0x10c7a, 0x10c7b, 0x10c7c, 0x10c7d, 0x10c7e, 0x10c7f,
  0x10c80, 0x10c81, 0x10c82, 0x10c83, 0x10c84, 0x10c85, 0x10c86, 0x10c87,
  0x10c88, 0x10c89, 0x10c8a, 0x10c8b, 0x10c8c, 0x10c8d, 0x10c8e, 0x10c8f,
  0x10c90, 0x10c91, 0x10c92, 0x10c93, 0x10c94, 0x10c95, 0x10c96, 0x10c97,
  0x10c98, 0x10c99, 0x10c9a, 0x10c9b, 0x10c9c, 0x10c9d, 0x10c9e, 0x10c9f,
  0x10ca0, 0x10ca1, 0x10ca2, 0x10ca3, 0x10ca4, 0x10ca5, 0x10ca6, 0x10ca7,
  0x10ca8, 0x10ca9, 0x10caa, 0x10cab, 0x10cac, 0x10cad, 0x10cae, 0x10caf,
  0x10cb0, 0x10cb1, 0x10cb2, 0x10cb3, 0x10cb4, 0x10cb5, 0x10cb6, 0x10cb7,
  0x10cb8, 0x10cb9, 0x10cba, 0x10cbb, 0x10cbc, 0x10cbd, 0x10cbe, 0x10cbf,
  0x10cc0, 0x10cc1, 0x10cc2, 0x10cc3, 0x10cc4, 0x10cc5, 0x10cc6, 0x10cc7,
  0x10cc8, 0x10cc9, 0x10cca, 0x10ccb, 0x10ccc, 0x10ccd, 0x10cce, 0x10ccf,
  0x10cd0, 0x10cd1, 0x10cd2, 0x10cd3, 0x10cd4, 0x10cd5, 0x10cd6, 0x10cd7,
  0x10cd8, 0x10cd9, 0x10cda, 0x10cdb, 0x10cdc, 0x10cdd, 0x10cde, 0x10cdf,
  0x10ce0, 0x10ce1, 0x10ce2, 0x10ce3, 0x10ce4, 0x10ce5, 0x10ce6, 0x10ce7,
  0x10ce8, 0x10ce9, 0x10cea, 0x10ceb, 0x10cec, 0x10ced, 0x10cee, 0x10cef,
  0x10cf0, 0x10cf1, 0x10cf2, 0x10cf3, 0x10cf4, 0x10cf5, 0x10cf6, 0x10cf7,
  0x10cf8, 0x10cf9, 0x10cfa, 0x10cfb, 0x10cfc, 0x10cfd, 0x10cfe, 0x10cff
};

static uint32_t unicode_520_ci_page_10e[] = {
  0x10e00, 0x10e01, 0x10e02, 0x10e03, 0x10e04, 0x10e05, 0x10e06, 0x10e07,
  0x10e08, 0x10e09, 0x10e0a, 0x10e0b, 0x10e0c, 0x10e0d, 0x10e0e, 0x10e0f,
  0x10e10, 0x10e11, 0x10e12, 0x10e13, 0x10e14, 0x10e15, 0x10e16, 0x10e17,
  0x10e18, 0x10e19, 0x10e1a, 0x10e1b, 0x10e1c, 0x10e1d, 0x10e1e, 0x10e1f,
  0x10e20, 0x10e21, 0x10e22, 0x10e23, 0x10e24, 0x10e25, 0x10e26, 0x10e27,
  0x10e28, 0x10e29, 0x10e2a, 0x10e2b, 0x10e2c, 0x10e2d, 0x10e2e, 0x10e2f,
  0x10e30, 0x10e31, 0x10e32, 0x10e33, 0x10e34, 0x10e35, 0x10e36, 0x10e37,
  0x10e38, 0x10e39, 0x10e3a, 0x10e3b, 0x10e3c, 0x10e3d, 0x10e3e, 0x10e3f,
  0x10e40, 0x10e41, 0x10e42, 0x10e43, 0x10e44, 0x10e45, 0x10e46, 0x10e47,
  0x10e48, 0x10e49, 0x10e4a, 0x10e4b, 0x10e4c, 0x10e4d, 0x10e4e, 0x10e4f,
  0x10e50, 0x10e51, 0x10e52, 0x10e53, 0x10e54, 0x10e55, 0x10e56, 0x10e57,
  0x10e58, 0x10e59, 0x10e5a, 0x10e5b, 0x10e5c, 0x10e5d, 0x10e5e, 0x10e5f,
  0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038,
  0x00039, 0x10e69, 0x10e6a, 0x10e6b, 0x10e6c, 0x10e6d, 0x10e6e, 0x10e6f,
  0x10e70, 0x10e71, 0x10e72, 0x10e73, 0x10e74, 0x10e75, 0x10e76, 0x10e77,
  0x10e78, 0x10e79, 0x10e7a, 0x10e7b, 0x10e7c, 0x10e7d, 0x10e7e, 0x10e7f,
  0x10e80, 0x10e81, 0x10e82, 0x10e83, 0x10e84, 0x10e85, 0x10e86, 0x10e87,
  0x10e88, 0x10e89, 0x10e8a, 0x10e8b, 0x10e8c, 0x10e8d, 0x10e8e, 0x10e8f,
  0x10e90, 0x10e91, 0x10e92, 0x10e93, 0x10e94, 0x10e95, 0x10e96, 0x10e97,
  0x10e98, 0x10e99, 0x10e9a, 0x10e9b, 0x10e9c, 0x10e9d, 0x10e9e, 0x10e9f,
  0x10ea0, 0x10ea1, 0x10ea2, 0x10ea3, 0x10ea4, 0x10ea5, 0x10ea6, 0x10ea7,
  0x10ea8, 0x10ea9, 0x10eaa, 0x10eab, 0x10eac, 0x10ead, 0x10eae, 0x10eaf,
  0x10eb0, 0x10eb1, 0x10eb2, 0x10eb3, 0x10eb4, 0x10eb5, 0x10eb6, 0x10eb7,
  0x10eb8, 0x10eb9, 0x10eba, 0x10ebb, 0x10ebc, 0x10ebd, 0x10ebe, 0x10ebf,
  0x10ec0, 0x10ec1, 0x10ec2, 0x10ec3, 0x10ec4, 0x10ec5, 0x10ec6, 0x10ec7,
  0x10ec8, 0x10ec9, 0x10eca, 0x10ecb, 0x10ecc, 0x10ecd, 0x10ece, 0x10ecf,
  0x10ed0, 0x10ed1, 0x10ed2, 0x10ed3, 0x10ed4, 0x10ed5, 0x10ed6, 0x10ed7,
  0x10ed8, 0x10ed9, 0x10eda, 0x10edb, 0x10edc, 0x10edd, 0x10ede, 0x10edf,
  0x10ee0, 0x10ee1, 0x10ee2, 0x10ee3, 0x10ee4, 0x10ee5, 0x10ee6, 0x10ee7,
  0x10ee8, 0x10ee9, 0x10eea, 0x10eeb, 0x10eec, 0x10eed, 0x10eee, 0x10eef,
  0x10ef0, 0x10ef1, 0x10ef2, 0x10ef3, 0x10ef4, 0x10ef5, 0x10ef6, 0x10ef7,
  0x10ef8, 0x10ef9, 0x10efa, 0x10efb, 0x10efc, 0x10efd, 0x10efe, 0x10eff
};

static uint32_t unicode_520_ci_page_110[] = {
  0x11000, 0x11001, 0x11002, 0x11003, 0x11004, 0x11005, 0x11006, 0x11007,
  0x11008, 0x11009, 0x1100a, 0x1100b, 0x1100c, 0x1100d, 0x1100e, 0x1100f,
  0x11010, 0x11011, 0x11012, 0x11013, 0x11014, 0x11015, 0x11016, 0x11017,
  0x11018, 0x11019, 0x1101a, 0x1101b, 0x1101c, 0x1101d, 0x1101e, 0x1101f,
  0x11020, 0x11021, 0x11022, 0x11023, 0x11024, 0x11025, 0x11026, 0x11027,
  0x11028, 0x11029, 0x1102a, 0x1102b, 0x1102c, 0x1102d, 0x1102e, 0x1102f,
  0x11030, 0x11031, 0x11032, 0x11033, 0x11034, 0x11035, 0x11036, 0x11037,
  0x11038, 0x11039, 0x1103a, 0x1103b, 0x1103c, 0x1103d, 0x1103e, 0x1103f,
  0x11040, 0x11041, 0x11042, 0x11043, 0x11044, 0x11045, 0x11046, 0x11047,
  0x11048, 0x11049, 0x1104a, 0x1104b, 0x1104c, 0x1104d, 0x1104e, 0x1104f,
  0x11050, 0x11051, 0x11052, 0x11053, 0x11054, 0x11055, 0x11056, 0x11057,
  0x11058, 0x11059, 0x1105a, 0x1105b, 0x1105c, 0x1105d, 0x1105e, 0x1105f,
  0x11060, 0x11061, 0x11062, 0x11063, 0x11064, 0x11065, 0x11066, 0x11067,
  0x11068, 0x11069, 0x1106a, 0x1106b, 0x1106c, 0x1106d, 0x1106e, 0x1106f,
  0x11070, 0x11071, 0x11072, 0x11073, 0x11074, 0x11075, 0x11076, 0x11077,
  0x11078, 0x11079, 0x1107a, 0x1107b, 0x1107c, 0x1107d, 0x1107e, 0x1107f,
  0x00000, 0x00000, 0x00000, 0x11083, 0x11084, 0x11085, 0x11086, 0x11087,
  0x11088, 0x11089, 0x1108a, 0x1108b, 0x1108c, 0x1108d, 0x1108e, 0x1108f,
  0x11090, 0x11091, 0x11092, 0x11093, 0x11094, 0x11095, 0x11096, 0x11097,
  0x11098, 0x11099, 0x11099, 0x1109b, 0x1109b, 0x1109d, 0x1109e, 0x1109f,
  0x110a0, 0x110a1, 0x110a2, 0x110a3, 0x110a4, 0x110a5, 0x110a6, 0x110a7,
  0x110a8, 0x110a9, 0x110aa, 0x110a5, 0x110ac, 0x110ad, 0x110ae, 0x110af,
  0x110b0, 0x110b1, 0x110b2, 0x110b3, 0x110b4, 0x110b5, 0x110b6, 0x110b7,
  0x110b8, 0x110b9, 0x00000, 0x110bb, 0x110bc, 0x00000, 0x110be, 0x110bf,
  0x110c0, 0x110c1, 0x110c2, 0x110c3, 0x110c4, 0x110c5, 0x110c6, 0x110c7,
  0x110c8, 0x110c9, 0x110ca, 0x110cb, 0x110cc, 0x110cd, 0x110ce, 0x110cf,
  0x110d0, 0x110d1, 0x110d2, 0x110d3, 0x110d4, 0x110d5, 0x110d6, 0x110d7,
  0x110d8, 0x110d9, 0x110da, 0x110db, 0x110dc, 0x110dd, 0x110de, 0x110df,
  0x110e0, 0x110e1, 0x110e2, 0x110e3, 0x110e4, 0x110e5, 0x110e6, 0x110e7,
  0x110e8, 0x110e9, 0x110ea, 0x110eb, 0x110ec, 0x110ed, 0x110ee, 0x110ef,
  0x110f0, 0x110f1, 0x110f2, 0x110f3, 0x110f4, 0x110f5, 0x110f6, 0x110f7,
  0x110f8, 0x110f9, 0x110fa, 0x110fb, 0x110fc, 0x110fd, 0x110fe, 0x110ff
};

static uint32_t unicode_520_ci_page_124[] = {
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039,
  0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039, 0x00034,
  0x00035, 0x00036, 0x00037, 0x00038, 0x00039, 0x00031, 0x00032, 0x00033,
  0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039, 0x00031, 0x00032,
  0x00033, 0x00034, 0x00035, 0x00032, 0x00033, 0x00033, 0x00034, 0x00035,
  0x00036, 0x00037, 0x00038, 0x00039, 0x00031, 0x00032, 0x00033, 0x00033,
  0x00034, 0x00035, 0x12432, 0x12433, 0x00031, 0x00032, 0x00033, 0x00033,
  0x00034, 0x00035, 0x00033, 0x00033, 0x00034, 0x00034, 0x00034, 0x00034,
  0x00036, 0x00037, 0x00037, 0x00037, 0x00038, 0x00038, 0x00039, 0x00039,
  0x00039, 0x00039, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00034, 0x00035, 0x00035, 0x12456, 0x12457,
  0x00031, 0x00032, 0x1245a, 0x1245b, 0x1245c, 0x1245d, 0x1245e, 0x1245f,
  0x12460, 0x12461, 0x12462, 0x12463, 0x12464, 0x12465, 0x12466, 0x12467,
  0x12468, 0x12469, 0x1246a, 0x1246b, 0x1246c, 0x1246d, 0x1246e, 0x1246f,
  0x12470, 0x12471, 0x12472, 0x12473, 0x12474, 0x12475, 0x12476, 0x12477,
  0x12478, 0x12479, 0x1247a, 0x1247b, 0x1247c, 0x1247d, 0x1247e, 0x1247f,
  0x12480, 0x12481, 0x12482, 0x12483, 0x12484, 0x12485, 0x12486, 0x12487,
  0x12488, 0x12489, 0x1248a, 0x1248b, 0x1248c, 0x1248d, 0x1248e, 0x1248f,
  0x12490, 0x12491, 0x12492, 0x12493, 0x12494, 0x12495, 0x12496, 0x12497,
  0x12498, 0x12499, 0x1249a, 0x1249b, 0x1249c, 0x1249d, 0x1249e, 0x1249f,
  0x124a0, 0x124a1, 0x124a2, 0x124a3, 0x124a4, 0x124a5, 0x124a6, 0x124a7,
  0x124a8, 0x124a9, 0x124aa, 0x124ab, 0x124ac, 0x124ad, 0x124ae, 0x124af,
  0x124b0, 0x124b1, 0x124b2, 0x124b3, 0x124b4, 0x124b5, 0x124b6, 0x124b7,
  0x124b8, 0x124b9, 0x124ba, 0x124bb, 0x124bc, 0x124bd, 0x124be, 0x124bf,
  0x124c0, 0x124c1, 0x124c2, 0x124c3, 0x124c4, 0x124c5, 0x124c6, 0x124c7,
  0x124c8, 0x124c9, 0x124ca, 0x124cb, 0x124cc, 0x124cd, 0x124ce, 0x124cf,
  0x124d0, 0x124d1, 0x124d2, 0x124d3, 0x124d4, 0x124d5, 0x124d6, 0x124d7,
  0x124d8, 0x124d9, 0x124da, 0x124db, 0x124dc, 0x124dd, 0x124de, 0x124df,
  0x124e0, 0x124e1, 0x124e2, 0x124e3, 0x124e4, 0x124e5, 0x124e6, 0x124e7,
  0x124e8, 0x124e9, 0x124ea, 0x124eb, 0x124ec, 0x124ed, 0x124ee, 0x124ef,
  0x124f0, 0x124f1, 0x124f2, 0x124f3, 0x124f4, 0x124f5, 0x124f6, 0x124f7,
  0x124f8, 0x124f9, 0x124fa, 0x124fb, 0x124fc, 0x124fd, 0x124fe, 0x124ff
};

static uint32_t unicode_520_ci_page_1d1[] = {
  0x1d100, 0x1d101, 0x1d102, 0x1d103, 0x1d104, 0x1d105, 0x1d106, 0x1d107,
  0x1d108, 0x1d109, 0x1d10a, 0x1d10b, 0x1d10c, 0x1d10d, 0x1d10e, 0x1d10f,
  0x1d110, 0x1d111, 0x1d112, 0x1d113, 0x1d114, 0x1d115, 0x1d116, 0x1d117,
  0x1d118, 0x1d119, 0x1d11a, 0x1d11b, 0x1d11c, 0x1d11d, 0x1d11e, 0x1d11f,
  0x1d120, 0x1d121, 0x1d122, 0x1d123, 0x1d124, 0x1d125, 0x1d126, 0x1d127,
  0x1d128, 0x1d129, 0x1d12a, 0x1d12b, 0x1d12c, 0x1d12d, 0x1d12e, 0x1d12f,
  0x1d130, 0x1d131, 0x1d132, 0x1d133, 0x1d134, 0x1d135, 0x1d136, 0x1d137,
  0x1d138, 0x1d139, 0x1d13a, 0x1d13b, 0x1d13c, 0x1d13d, 0x1d13e, 0x1d13f,
  0x1d140, 0x1d141, 0x1d142, 0x1d143, 0x1d144, 0x1d145, 0x1d146, 0x1d147,
  0x1d148, 0x1d149, 0x1d14a, 0x1d14b, 0x1d14c, 0x1d14d, 0x1d14e, 0x1d14f,
  0x1d150, 0x1d151, 0x1d152, 0x1d153, 0x1d154, 0x1d155, 0x1d156, 0x1d157,
  0x1d158, 0x1d159, 0x1d15a, 0x1d15b, 0x1d15c, 0x1d15d, 0x1d157, 0x1d158,
  0x1d158, 0x1d158, 0x1d158, 0x1d158, 0x1d158, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x1d16a, 0x1d16b, 0x1d16c, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x1d183, 0x1d184, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x1d18c, 0x1d18d, 0x1d18e, 0x1d18f,
  0x1d190, 0x1d191, 0x1d192, 0x1d193, 0x1d194, 0x1d195, 0x1d196, 0x1d197,
  0x1d198, 0x1d199, 0x1d19a, 0x1d19b, 0x1d19c, 0x1d19d, 0x1d19e, 0x1d19f,
  0x1d1a0, 0x1d1a1, 0x1d1a2, 0x1d1a3, 0x1d1a4, 0x1d1a5, 0x1d1a6, 0x1d1a7,
  0x1d1a8, 0x1d1a9, 0x00000, 0x00000, 0x00000, 0x00000, 0x1d1ae, 0x1d1af,
  0x1d1b0, 0x1d1b1, 0x1d1b2, 0x1d1b3, 0x1d1b4, 0x1d1b5, 0x1d1b6, 0x1d1b7,
  0x1d1b8, 0x1d1b9, 0x1d1ba, 0x1d1b9, 0x1d1ba, 0x1d1b9, 0x1d1ba, 0x1d1b9,
  0x1d1ba, 0x1d1c1, 0x1d1c2, 0x1d1c3, 0x1d1c4, 0x1d1c5, 0x1d1c6, 0x1d1c7,
  0x1d1c8, 0x1d1c9, 0x1d1ca, 0x1d1cb, 0x1d1cc, 0x1d1cd, 0x1d1ce, 0x1d1cf,
  0x1d1d0, 0x1d1d1, 0x1d1d2, 0x1d1d3, 0x1d1d4, 0x1d1d5, 0x1d1d6, 0x1d1d7,
  0x1d1d8, 0x1d1d9, 0x1d1da, 0x1d1db, 0x1d1dc, 0x1d1dd, 0x1d1de, 0x1d1df,
  0x1d1e0, 0x1d1e1, 0x1d1e2, 0x1d1e3, 0x1d1e4, 0x1d1e5, 0x1d1e6, 0x1d1e7,
  0x1d1e8, 0x1d1e9, 0x1d1ea, 0x1d1eb, 0x1d1ec, 0x1d1ed, 0x1d1ee, 0x1d1ef,
  0x1d1f0, 0x1d1f1, 0x1d1f2, 0x1d1f3, 0x1d1f4, 0x1d1f5, 0x1d1f6, 0x1d1f7,
  0x1d1f8, 0x1d1f9, 0x1d1fa, 0x1d1fb, 0x1d1fc, 0x1d1fd, 0x1d1fe, 0x1d1ff
};

static uint32_t unicode_520_ci_page_1d2[] = {
  0x1d200, 0x1d201, 0x1d202, 0x1d203, 0x1d204, 0x1d205, 0x1d206, 0x1d207,
  0x1d208, 0x1d209, 0x1d20a, 0x1d20b, 0x1d20c, 0x1d20d, 0x1d20e, 0x1d20f,
  0x1d210, 0x1d211, 0x1d212, 0x1d213, 0x1d214, 0x1d215, 0x1d216, 0x1d217,
  0x1d218, 0x1d219, 0x1d21a, 0x1d21b, 0x1d21c, 0x1d21d, 0x1d21e, 0x1d21f,
  0x1d220, 0x1d221, 0x1d222, 0x1d223, 0x1d224, 0x1d225, 0x1d226, 0x1d227,
  0x1d228, 0x1d229, 0x1d22a, 0x1d22b, 0x1d22c, 0x1d22d, 0x1d22e, 0x1d22f,
  0x1d230, 0x1d231, 0x1d232, 0x1d233, 0x1d234, 0x1d235, 0x1d236, 0x1d237,
  0x1d238, 0x1d239, 0x1d23a, 0x1d23b, 0x1d23c, 0x1d23d, 0x1d23e, 0x1d23f,
  0x1d240, 0x1d241, 0x00000, 0x00000, 0x00000, 0x1d245, 0x1d246, 0x1d247,
  0x1d248, 0x1d249, 0x1d24a, 0x1d24b, 0x1d24c, 0x1d24d, 0x1d24e, 0x1d24f,
  0x1d250, 0x1d251, 0x1d252, 0x1d253, 0x1d254, 0x1d255, 0x1d256, 0x1d257,
  0x1d258, 0x1d259, 0x1d25a, 0x1d25b, 0x1d25c, 0x1d25d, 0x1d25e, 0x1d25f,
  0x1d260, 0x1d261, 0x1d262, 0x1d263, 0x1d264, 0x1d265, 0x1d266, 0x1d267,
  0x1d268, 0x1d269, 0x1d26a, 0x1d26b, 0x1d26c, 0x1d26d, 0x1d26e, 0x1d26f,
  0x1d270, 0x1d271, 0x1d272, 0x1d273, 0x1d274, 0x1d275, 0x1d276, 0x1d277,
  0x1d278, 0x1d279, 0x1d27a, 0x1d27b, 0x1d27c, 0x1d27d, 0x1d27e, 0x1d27f,
  0x1d280, 0x1d281, 0x1d282, 0x1d283, 0x1d284, 0x1d285, 0x1d286, 0x1d287,
  0x1d288, 0x1d289, 0x1d28a, 0x1d28b, 0x1d28c, 0x1d28d, 0x1d28e, 0x1d28f,
  0x1d290, 0x1d291, 0x1d292, 0x1d293, 0x1d294, 0x1d295, 0x1d296, 0x1d297,
  0x1d298, 0x1d299, 0x1d29a, 0x1d29b, 0x1d29c, 0x1d29d, 0x1d29e, 0x1d29f,
  0x1d2a0, 0x1d2a1, 0x1d2a2, 0x1d2a3, 0x1d2a4, 0x1d2a5, 0x1d2a6, 0x1d2a7,
  0x1d2a8, 0x1d2a9, 0x1d2aa, 0x1d2ab, 0x1d2ac, 0x1d2ad, 0x1d2ae, 0x1d2af,
  0x1d2b0, 0x1d2b1, 0x1d2b2, 0x1d2b3, 0x1d2b4, 0x1d2b5, 0x1d2b6, 0x1d2b7,
  0x1d2b8, 0x1d2b9, 0x1d2ba, 0x1d2bb, 0x1d2bc, 0x1d2bd, 0x1d2be, 0x1d2bf,
  0x1d2c0, 0x1d2c1, 0x1d2c2, 0x1d2c3, 0x1d2c4, 0x1d2c5, 0x1d2c6, 0x1d2c7,
  0x1d2c8, 0x1d2c9, 0x1d2ca, 0x1d2cb, 0x1d2cc, 0x1d2cd, 0x1d2ce, 0x1d2cf,
  0x1d2d0, 0x1d2d1, 0x1d2d2, 0x1d2d3, 0x1d2d4, 0x1d2d5, 0x1d2d6, 0x1d2d7,
  0x1d2d8, 0x1d2d9, 0x1d2da, 0x1d2db, 0x1d2dc, 0x1d2dd, 0x1d2de, 0x1d2df,
  0x1d2e0, 0x1d2e1, 0x1d2e2, 0x1d2e3, 0x1d2e4, 0x1d2e5, 0x1d2e6, 0x1d2e7,
  0x1d2e8, 0x1d2e9, 0x1d2ea, 0x1d2eb, 0x1d2ec, 0x1d2ed, 0x1d2ee, 0x1d2ef,
  0x1d2f0, 0x1d2f1, 0x1d2f2, 0x1d2f3, 0x1d2f4, 0x1d2f5, 0x1d2f6, 0x1d2f7,
  0x1d2f8, 0x1d2f9, 0x1d2fa, 0x1d2fb, 0x1d2fc, 0x1d2fd, 0x1d2fe, 0x1d2ff
};

static uint32_t unicode_520_ci_page_1d3[] = {
  0x1d300, 0x1d301, 0x1d302, 0x1d303, 0x1d304, 0x1d305, 0x1d306, 0x1d307,
  0x1d308, 0x1d309, 0x1d30a, 0x1d30b, 0x1d30c, 0x1d30d, 0x1d30e, 0x1d30f,
  0x1d310, 0x1d311, 0x1d312, 0x1d313, 0x1d314, 0x1d315, 0x1d316, 0x1d317,
  0x1d318, 0x1d319, 0x1d31a, 0x1d31b, 0x1d31c, 0x1d31d, 0x1d31e, 0x1d31f,
  0x1d320, 0x1d321, 0x1d322, 0x1d323, 0x1d324, 0x1d325, 0x1d326, 0x1d327,
  0x1d328, 0x1d329, 0x1d32a, 0x1d32b, 0x1d32c, 0x1d32d, 0x1d32e, 0x1d32f,
  0x1d330, 0x1d331, 0x1d332, 0x1d333, 0x1d334, 0x1d335, 0x1d336, 0x1d337,
  0x1d338, 0x1d339, 0x1d33a, 0x1d33b, 0x1d33c, 0x1d33d, 0x1d33e, 0x1d33f,
  0x1d340, 0x1d341, 0x1d342, 0x1d343, 0x1d344, 0x1d345, 0x1d346, 0x1d347,
  0x1d348, 0x1d349, 0x1d34a, 0x1d34b, 0x1d34c, 0x1d34d, 0x1d34e, 0x1d34f,
  0x1d350, 0x1d351, 0x1d352, 0x1d353, 0x1d354, 0x1d355, 0x1d356, 0x1d357,
  0x1d358, 0x1d359, 0x1d35a, 0x1d35b, 0x1d35c, 0x1d35d, 0x1d35e, 0x1d35f,
  0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038,
  0x00039, 0x1d369, 0x1d36a, 0x1d36b, 0x1d36c, 0x1d36d, 0x1d36e, 0x1d36f,
  0x1d370, 0x1d371, 0x1d372, 0x1d373, 0x1d374, 0x1d375, 0x1d376, 0x1d377,
  0x1d378, 0x1d379, 0x1d37a, 0x1d37b, 0x1d37c, 0x1d37d, 0x1d37e, 0x1d37f,
  0x1d380, 0x1d381, 0x1d382, 0x1d383, 0x1d384, 0x1d385, 0x1d386, 0x1d387,
  0x1d388, 0x1d389, 0x1d38a, 0x1d38b, 0x1d38c, 0x1d38d, 0x1d38e, 0x1d38f,
  0x1d390, 0x1d391, 0x1d392, 0x1d393, 0x1d394, 0x1d395, 0x1d396, 0x1d397,
  0x1d398, 0x1d399, 0x1d39a, 0x1d39b, 0x1d39c, 0x1d39d, 0x1d39e, 0x1d39f,
  0x1d3a0, 0x1d3a1, 0x1d3a2, 0x1d3a3, 0x1d3a4, 0x1d3a5, 0x1d3a6, 0x1d3a7,
  0x1d3a8, 0x1d3a9, 0x1d3aa, 0x1d3ab, 0x1d3ac, 0x1d3ad, 0x1d3ae, 0x1d3af,
  0x1d3b0, 0x1d3b1, 0x1d3b2, 0x1d3b3, 0x1d3b4, 0x1d3b5, 0x1d3b6, 0x1d3b7,
  0x1d3b8, 0x1d3b9, 0x1d3ba, 0x1d3bb, 0x1d3bc, 0x1d3bd, 0x1d3be, 0x1d3bf,
  0x1d3c0, 0x1d3c1, 0x1d3c2, 0x1d3c3, 0x1d3c4, 0x1d3c5, 0x1d3c6, 0x1d3c7,
  0x1d3c8, 0x1d3c9, 0x1d3ca, 0x1d3cb, 0x1d3cc, 0x1d3cd, 0x1d3ce, 0x1d3cf,
  0x1d3d0, 0x1d3d1, 0x1d3d2, 0x1d3d3, 0x1d3d4, 0x1d3d5, 0x1d3d6, 0x1d3d7,
  0x1d3d8, 0x1d3d9, 0x1d3da, 0x1d3db, 0x1d3dc, 0x1d3dd, 0x1d3de, 0x1d3df,
  0x1d3e0, 0x1d3e1, 0x1d3e2, 0x1d3e3, 0x1d3e4, 0x1d3e5, 0x1d3e6, 0x1d3e7,
  0x1d3e8, 0x1d3e9, 0x1d3ea, 0x1d3eb, 0x1d3ec, 0x1d3ed, 0x1d3ee, 0x1d3ef,
  0x1d3f0, 0x1d3f1, 0x1d3f2, 0x1d3f3, 0x1d3f4, 0x1d3f5, 0x1d3f6, 0x1d3f7,
  0x1d3f8, 0x1d3f9, 0x1d3fa, 0x1d3fb, 0x1d3fc, 0x1d3fd, 0x1d3fe, 0x1d3ff
};

static uint32_t unicode_520_ci_page_1d4[] = {
  0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046, 0x00047, 0x00048,
  0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f, 0x00050,
  0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056, 0x00057, 0x00058,
  0x00059, 0x0005a, 0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046,
  0x00047, 0x00048, 0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e,
  0x0004f, 0x00050, 0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056,
  0x00057, 0x00058, 0x00059, 0x0005a, 0x00041, 0x00042, 0x00043, 0x00044,
  0x00045, 0x00046, 0x00047, 0x00048, 0x00049, 0x0004a, 0x0004b, 0x0004c,
  0x0004d, 0x0004e, 0x0004f, 0x00050, 0x00051, 0x00052, 0x00053, 0x00054,
  0x00055, 0x00056, 0x00057, 0x00058, 0x00059, 0x0005a, 0x00041, 0x00042,
  0x00043, 0x00044, 0x00045, 0x00046, 0x00047, 0x1d455, 0x00049, 0x0004a,
  0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f, 0x00050, 0x00051, 0x00052,
  0x00053, 0x00054, 0x00055, 0x00056, 0x00057, 0x00058, 0x00059, 0x0005a,
  0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046, 0x00047, 0x00048,
  0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f, 0x00050,
  0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056, 0x00057, 0x00058,
  0x00059, 0x0005a, 0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046,
  0x00047, 0x00048, 0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e,
  0x0004f, 0x00050, 0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056,
  0x00057, 0x00058, 0x00059, 0x0005a, 0x00041, 0x1d49d, 0x00043, 0x00044,
  0x1d4a0, 0x1d4a1, 0x00047, 0x1d4a3, 0x1d4a4, 0x0004a, 0x0004b, 0x1d4a7,
  0x1d4a8, 0x0004e, 0x0004f, 0x00050, 0x00051, 0x1d4ad, 0x00053, 0x00054,
  0x00055, 0x00056, 0x00057, 0x00058, 0x00059, 0x0005a, 0x00041, 0x00042,
  0x00043, 0x00044, 0x1d4ba, 0x00046, 0x1d4bc, 0x00048, 0x00049, 0x0004a,
  0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x1d4c4, 0x00050, 0x00051, 0x00052,
  0x00053, 0x00054, 0x00055, 0x00056, 0x00057, 0x00058, 0x00059, 0x0005a,
  0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046, 0x00047, 0x00048,
  0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f, 0x00050,
  0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056, 0x00057, 0x00058,
  0x00059, 0x0005a, 0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046,
  0x00047, 0x00048, 0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e,
  0x0004f, 0x00050, 0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x1d4ff
};

static uint32_t unicode_520_ci_page_1d5[] = {
  0x00057, 0x00058, 0x00059, 0x0005a, 0x00041, 0x00042, 0x1d506, 0x00044,
  0x00045, 0x00046, 0x00047, 0x1d50b, 0x1d50c, 0x0004a, 0x0004b, 0x0004c,
  0x0004d, 0x0004e, 0x0004f, 0x00050, 0x00051, 0x1d515, 0x00053, 0x00054,
  0x00055, 0x00056, 0x00057, 0x00058, 0x00059, 0x1d51d, 0x00041, 0x00042,
  0x00043, 0x00044, 0x00045, 0x00046, 0x00047, 0x00048, 0x00049, 0x0004a,
  0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f, 0x00050, 0x00051, 0x00052,
  0x00053, 0x00054, 0x00055, 0x00056, 0x00057, 0x00058, 0x00059, 0x0005a,
  0x00041, 0x00042, 0x1d53a, 0x00044, 0x00045, 0x00046, 0x00047, 0x1d53f,
  0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x1d545, 0x0004f, 0x1d547,
  0x1d548, 0x1d549, 0x00053, 0x00054, 0x00055, 0x00056, 0x00057, 0x00058,
  0x00059, 0x1d551, 0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046,
  0x00047, 0x00048, 0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e,
  0x0004f, 0x00050, 0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056,
  0x00057, 0x00058, 0x00059, 0x0005a, 0x00041, 0x00042, 0x00043, 0x00044,
  0x00045, 0x00046, 0x00047, 0x00048, 0x00049, 0x0004a, 0x0004b, 0x0004c,
  0x0004d, 0x0004e, 0x0004f, 0x00050, 0x00051, 0x00052, 0x00053, 0x00054,
  0x00055, 0x00056, 0x00057, 0x00058, 0x00059, 0x0005a, 0x00041, 0x00042,
  0x00043, 0x00044, 0x00045, 0x00046, 0x00047, 0x00048, 0x00049, 0x0004a,
  0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f, 0x00050, 0x00051, 0x00052,
  0x00053, 0x00054, 0x00055, 0x00056, 0x00057, 0x00058, 0x00059, 0x0005a,
  0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046, 0x00047, 0x00048,
  0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f, 0x00050,
  0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056, 0x00057, 0x00058,
  0x00059, 0x0005a, 0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046,
  0x00047, 0x00048, 0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e,
  0x0004f, 0x00050, 0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056,
  0x00057, 0x00058, 0x00059, 0x0005a, 0x00041, 0x00042, 0x00043, 0x00044,
  0x00045, 0x00046, 0x00047, 0x00048, 0x00049, 0x0004a, 0x0004b, 0x0004c,
  0x0004d, 0x0004e, 0x0004f, 0x00050, 0x00051, 0x00052, 0x00053, 0x00054,
  0x00055, 0x00056, 0x00057, 0x00058, 0x00059, 0x0005a, 0x00041, 0x00042,
  0x00043, 0x00044, 0x00045, 0x00046, 0x00047, 0x00048, 0x00049, 0x0004a,
  0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f, 0x00050, 0x00051, 0x1d5ff
};

static uint32_t unicode_520_ci_page_1d6[] = {
  0x00053, 0x00054, 0x00055, 0x00056, 0x00057, 0x00058, 0x00059, 0x0005a,
  0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046, 0x00047, 0x00048,
  0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f, 0x00050,
  0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056, 0x00057, 0x00058,
  0x00059, 0x0005a, 0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046,
  0x00047, 0x00048, 0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e,
  0x0004f, 0x00050, 0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056,
  0x00057, 0x00058, 0x00059, 0x0005a, 0x00041, 0x00042, 0x00043, 0x00044,
  0x00045, 0x00046, 0x00047, 0x00048, 0x00049, 0x0004a, 0x0004b, 0x0004c,
  0x0004d, 0x0004e, 0x0004f, 0x00050, 0x00051, 0x00052, 0x00053, 0x00054,
  0x00055, 0x00056, 0x00057, 0x00058, 0x00059, 0x0005a, 0x00041, 0x00042,
  0x00043, 0x00044, 0x00045, 0x00046, 0x00047, 0x00048, 0x00049, 0x0004a,
  0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f, 0x00050, 0x00051, 0x00052,
  0x00053, 0x00054, 0x00055, 0x00056, 0x00057, 0x00058, 0x00059, 0x0005a,
  0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046, 0x00047, 0x00048,
  0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f, 0x00050,
  0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056, 0x00057, 0x00058,
  0x00059, 0x0005a, 0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046,
  0x00047, 0x00048, 0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e,
  0x0004f, 0x00050, 0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056,
  0x00057, 0x00058, 0x00059, 0x0005a, 0x00131, 0x00237, 0x1d6a6, 0x1d6a7,
  0x00391, 0x00392, 0x00393, 0x00394, 0x00395, 0x00396, 0x00397, 0x00398,
  0x00399, 0x0039a, 0x0039b, 0x0039c, 0x0039d, 0x0039e, 0x0039f, 0x003a0,
  0x003a1, 0x00398, 0x003a3, 0x003a4, 0x003a5, 0x003a6, 0x003a7, 0x003a8,
  0x003a9, 0x02207, 0x00391, 0x00392, 0x00393, 0x00394, 0x00395, 0x00396,
  0x00397, 0x00398, 0x00399, 0x0039a, 0x0039b, 0x0039c, 0x0039d, 0x0039e,
  0x0039f, 0x003a0, 0x003a1, 0x003a3, 0x003a3, 0x003a4, 0x003a5, 0x003a6,
  0x003a7, 0x003a8, 0x003a9, 0x02202, 0x00395, 0x00398, 0x0039a, 0x003a6,
  0x003a1, 0x003a0, 0x00391, 0x00392, 0x00393, 0x00394, 0x00395, 0x00396,
  0x00397, 0x00398, 0x00399, 0x0039a, 0x0039b, 0x0039c, 0x0039d, 0x0039e,
  0x0039f, 0x003a0, 0x003a1, 0x00398, 0x003a3, 0x003a4, 0x003a5, 0x003a6,
  0x003a7, 0x003a8, 0x003a9, 0x02207, 0x00391, 0x00392, 0x00393, 0x1d6ff
};

static uint32_t unicode_520_ci_page_1d7[] = {
  0x00395, 0x00396, 0x00397, 0x00398, 0x00399, 0x0039a, 0x0039b, 0x0039c,
  0x0039d, 0x0039e, 0x0039f, 0x003a0, 0x003a1, 0x003a3, 0x003a3, 0x003a4,
  0x003a5, 0x003a6, 0x003a7, 0x003a8, 0x003a9, 0x02202, 0x00395, 0x00398,
  0x0039a, 0x003a6, 0x003a1, 0x003a0, 0x00391, 0x00392, 0x00393, 0x00394,
  0x00395, 0x00396, 0x00397, 0x00398, 0x00399, 0x0039a, 0x0039b, 0x0039c,
  0x0039d, 0x0039e, 0x0039f, 0x003a0, 0x003a1, 0x00398, 0x003a3, 0x003a4,
  0x003a5, 0x003a6, 0x003a7, 0x003a8, 0x003a9, 0x02207, 0x00391, 0x00392,
  0x00393, 0x00394, 0x00395, 0x00396, 0x00397, 0x00398, 0x00399, 0x0039a,
  0x0039b, 0x0039c, 0x0039d, 0x0039e, 0x0039f, 0x003a0, 0x003a1, 0x003a3,
  0x003a3, 0x003a4, 0x003a5, 0x003a6, 0x003a7, 0x003a8, 0x003a9, 0x02202,
  0x00395, 0x00398, 0x0039a, 0x003a6, 0x003a1, 0x003a0, 0x00391, 0x00392,
  0x00393, 0x00394, 0x00395, 0x00396, 0x00397, 0x00398, 0x00399, 0x0039a,
  0x0039b, 0x0039c, 0x0039d, 0x0039e, 0x0039f, 0x003a0, 0x003a1, 0x00398,
  0x003a3, 0x003a4, 0x003a5, 0x003a6, 0x003a7, 0x003a8, 0x003a9, 0x02207,
  0x00391, 0x00392, 0x00393, 0x00394, 0x00395, 0x00396, 0x00397, 0x00398,
  0x00399, 0x0039a, 0x0039b, 0x0039c, 0x0039d, 0x0039e, 0x0039f, 0x003a0,
  0x003a1, 0x003a3, 0x003a3, 0x003a4, 0x003a5, 0x003a6, 0x003a7, 0x003a8,
  0x003a9, 0x02202, 0x00395, 0x00398, 0x0039a, 0x003a6, 0x003a1, 0x003a0,
  0x00391, 0x00392, 0x00393, 0x00394, 0x00395, 0x00396, 0x00397, 0x00398,
  0x00399, 0x0039a, 0x0039b, 0x0039c, 0x0039d, 0x0039e, 0x0039f, 0x003a0,
  0x003a1, 0x00398, 0x003a3, 0x003a4, 0x003a5, 0x003a6, 0x003a7, 0x003a8,
  0x003a9, 0x02207, 0x00391, 0x00392, 0x00393, 0x00394, 0x00395, 0x00396,
  0x00397, 0x00398, 0x00399, 0x0039a, 0x0039b, 0x0039c, 0x0039d, 0x0039e,
  0x0039f, 0x003a0, 0x003a1, 0x003a3, 0x003a3, 0x003a4, 0x003a5, 0x003a6,
  0x003a7, 0x003a8, 0x003a9, 0x02202, 0x00395, 0x00398, 0x0039a, 0x003a6,
  0x003a1, 0x003a0, 0x003dc, 0x003dc, 0x1d7cc, 0x1d7cd, 0x00030, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035,
  0x00036, 0x00037, 0x00038, 0x00039, 0x00030, 0x00031, 0x00032, 0x00033,
  0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039, 0x00030, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x1d7ff
};

static uint32_t unicode_520_ci_page_1f1[] = {
  0x1f100, 0x1f101, 0x1f102, 0x1f103, 0x1f104, 0x1f105, 0x1f106, 0x1f107,
  0x1f108, 0x1f109, 0x1f10a, 0x1f10b, 0x1f10c, 0x1f10d, 0x1f10e, 0x1f10f,
  0x0249c, 0x0249d, 0x0249e, 0x0249f, 0x024a0, 0x024a1, 0x024a2, 0x024a3,
  0x024a4, 0x024a5, 0x024a6, 0x024a7, 0x024a8, 0x024a9, 0x024aa, 0x024ab,
  0x024ac, 0x024ad, 0x024ae, 0x024af, 0x024b0, 0x024b1, 0x024b2, 0x024b3,
  0x024b4, 0x024b5, 0x1f12a, 0x00043, 0x00052, 0x033c5, 0x1f12e, 0x1f12f,
  0x1f130, 0x00042, 0x1f132, 0x1f133, 0x1f134, 0x1f135, 0x1f136, 0x1f137,
  0x1f138, 0x1f139, 0x1f13a, 0x1f13b, 0x1f13c, 0x0004e, 0x1f13e, 0x00050,
  0x1f140, 0x1f141, 0x00053, 0x1f143, 0x1f144, 0x1f145, 0x00057, 0x1f147,
  0x1f148, 0x1f149, 0x1f14a, 0x033b7, 0x1f14c, 0x000df, 0x1f14e, 0x1f14f,
  0x1f150, 0x1f151, 0x1f152, 0x1f153, 0x1f154, 0x1f155, 0x1f156, 0x00048,
  0x1f158, 0x1f159, 0x1f15a, 0x1f15b, 0x1f15c, 0x1f15d, 0x1f15e, 0x00050,
  0x1f160, 0x1f161, 0x1f162, 0x1f163, 0x1f164, 0x1f165, 0x1f166, 0x1f167,
  0x1f168, 0x1f169, 0x1f16a, 0x1f16b, 0x1f16c, 0x1f16d, 0x1f16e, 0x1f16f,
  0x1f170, 0x1f171, 0x1f172, 0x1f173, 0x1f174, 0x1f175, 0x1f176, 0x1f177,
  0x1f178, 0x0004a, 0x1f17a, 0x0004c, 0x0004d, 0x1f17d, 0x1f17e, 0x00050,
  0x1f180, 0x1f181, 0x1f182, 0x1f183, 0x1f184, 0x1f185, 0x1f186, 0x1f187,
  0x1f188, 0x1f189, 0x00050, 0x1f18b, 0x03380, 0x1f18d, 0x1f18e, 0x1f18f,
  0x1f190, 0x1f191, 0x1f192, 0x1f193, 0x1f194, 0x1f195, 0x1f196, 0x1f197,
  0x1f198, 0x1f199, 0x1f19a, 0x1f19b, 0x1f19c, 0x1f19d, 0x1f19e, 0x1f19f,
  0x1f1a0, 0x1f1a1, 0x1f1a2, 0x1f1a3, 0x1f1a4, 0x1f1a5, 0x1f1a6, 0x1f1a7,
  0x1f1a8, 0x1f1a9, 0x1f1aa, 0x1f1ab, 0x1f1ac, 0x1f1ad, 0x1f1ae, 0x1f1af,
  0x1f1b0, 0x1f1b1, 0x1f1b2, 0x1f1b3, 0x1f1b4, 0x1f1b5, 0x1f1b6, 0x1f1b7,
  0x1f1b8, 0x1f1b9, 0x1f1ba, 0x1f1bb, 0x1f1bc, 0x1f1bd, 0x1f1be, 0x1f1bf,
  0x1f1c0, 0x1f1c1, 0x1f1c2, 0x1f1c3, 0x1f1c4, 0x1f1c5, 0x1f1c6, 0x1f1c7,
  0x1f1c8, 0x1f1c9, 0x1f1ca, 0x1f1cb, 0x1f1cc, 0x1f1cd, 0x1f1ce, 0x1f1cf,
  0x1f1d0, 0x1f1d1, 0x1f1d2, 0x1f1d3, 0x1f1d4, 0x1f1d5, 0x1f1d6, 0x1f1d7,
  0x1f1d8, 0x1f1d9, 0x1f1da, 0x1f1db, 0x1f1dc, 0x1f1dd, 0x1f1de, 0x1f1df,
  0x1f1e0, 0x1f1e1, 0x1f1e2, 0x1f1e3, 0x1f1e4, 0x1f1e5, 0x1f1e6, 0x1f1e7,
  0x1f1e8, 0x1f1e9, 0x1f1ea, 0x1f1eb, 0x1f1ec, 0x1f1ed, 0x1f1ee, 0x1f1ef,
  0x1f1f0, 0x1f1f1, 0x1f1f2, 0x1f1f3, 0x1f1f4, 0x1f1f5, 0x1f1f6, 0x1f1f7,
  0x1f1f8, 0x1f1f9, 0x1f1fa, 0x1f1fb, 0x1f1fc, 0x1f1fd, 0x1f1fe, 0x1f1ff
};

static uint32_t unicode_520_ci_page_1f2[] = {
  0x1f200, 0x1f201, 0x1f202, 0x1f203, 0x1f204, 0x1f205, 0x1f206, 0x1f207,
  0x1f208, 0x1f209, 0x1f20a, 0x1f20b, 0x1f20c, 0x1f20d, 0x1f20e, 0x1f20f,
  0x02f3f, 0x1f211, 0x1f212, 0x03066, 0x03193, 0x1f215, 0x1f216, 0x0319d,
  0x1f218, 0x1f219, 0x1f21a, 0x0f9be, 0x1f21c, 0x1f21d, 0x1f21e, 0x1f21f,
  0x1f220, 0x1f221, 0x02f63, 0x1f223, 0x1f224, 0x1f225, 0x1f226, 0x1f227,
  0x1f228, 0x03192, 0x03194, 0x1f22b, 0x032a7, 0x03197, 0x032a8, 0x1f22f,
  0x02f9b, 0x1f231, 0x1f232, 0x1f233, 0x1f234, 0x1f235, 0x1f236, 0x1f237,
  0x1f238, 0x1f239, 0x1f23a, 0x1f23b, 0x1f23c, 0x1f23d, 0x1f23e, 0x1f23f,
  0x1f240, 0x1f241, 0x1f242, 0x1f243, 0x1f244, 0x1f245, 0x1f246, 0x1f247,
  0x1f248, 0x1f249, 0x1f24a, 0x1f24b, 0x1f24c, 0x1f24d, 0x1f24e, 0x1f24f,
  0x1f250, 0x1f251, 0x1f252, 0x1f253, 0x1f254, 0x1f255, 0x1f256, 0x1f257,
  0x1f258, 0x1f259, 0x1f25a, 0x1f25b, 0x1f25c, 0x1f25d, 0x1f25e, 0x1f25f,
  0x1f260, 0x1f261, 0x1f262, 0x1f263, 0x1f264, 0x1f265, 0x1f266, 0x1f267,
  0x1f268, 0x1f269, 0x1f26a, 0x1f26b, 0x1f26c, 0x1f26d, 0x1f26e, 0x1f26f,
  0x1f270, 0x1f271, 0x1f272, 0x1f273, 0x1f274, 0x1f275, 0x1f276, 0x1f277,
  0x1f278, 0x1f279, 0x1f27a, 0x1f27b, 0x1f27c, 0x1f27d, 0x1f27e, 0x1f27f,
  0x1f280, 0x1f281, 0x1f282, 0x1f283, 0x1f284, 0x1f285, 0x1f286, 0x1f287,
  0x1f288, 0x1f289, 0x1f28a, 0x1f28b, 0x1f28c, 0x1f28d, 0x1f28e, 0x1f28f,
  0x1f290, 0x1f291, 0x1f292, 0x1f293, 0x1f294, 0x1f295, 0x1f296, 0x1f297,
  0x1f298, 0x1f299, 0x1f29a, 0x1f29b, 0x1f29c, 0x1f29d, 0x1f29e, 0x1f29f,
  0x1f2a0, 0x1f2a1, 0x1f2a2, 0x1f2a3, 0x1f2a4, 0x1f2a5, 0x1f2a6, 0x1f2a7,
  0x1f2a8, 0x1f2a9, 0x1f2aa, 0x1f2ab, 0x1f2ac, 0x1f2ad, 0x1f2ae, 0x1f2af,
  0x1f2b0, 0x1f2b1, 0x1f2b2, 0x1f2b3, 0x1f2b4, 0x1f2b5, 0x1f2b6, 0x1f2b7,
  0x1f2b8, 0x1f2b9, 0x1f2ba, 0x1f2bb, 0x1f2bc, 0x1f2bd, 0x1f2be, 0x1f2bf,
  0x1f2c0, 0x1f2c1, 0x1f2c2, 0x1f2c3, 0x1f2c4, 0x1f2c5, 0x1f2c6, 0x1f2c7,
  0x1f2c8, 0x1f2c9, 0x1f2ca, 0x1f2cb, 0x1f2cc, 0x1f2cd, 0x1f2ce, 0x1f2cf,
  0x1f2d0, 0x1f2d1, 0x1f2d2, 0x1f2d3, 0x1f2d4, 0x1f2d5, 0x1f2d6, 0x1f2d7,
  0x1f2d8, 0x1f2d9, 0x1f2da, 0x1f2db, 0x1f2dc, 0x1f2dd, 0x1f2de, 0x1f2df,
  0x1f2e0, 0x1f2e1, 0x1f2e2, 0x1f2e3, 0x1f2e4, 0x1f2e5, 0x1f2e6, 0x1f2e7,
  0x1f2e8, 0x1f2e9, 0x1f2ea, 0x1f2eb, 0x1f2ec, 0x1f2ed, 0x1f2ee, 0x1f2ef,
  0x1f2f0, 0x1f2f1, 0x1f2f2, 0x1f2f3, 0x1f2f4, 0x1f2f5, 0x1f2f6, 0x1f2f7,
  0x1f2f8, 0x1f2f9, 0x1f2fa, 0x1f2fb, 0x1f2fc, 0x1f2fd, 0x1f2fe, 0x1f2ff
};

static uint32_t unicode_520_ci_page_2f8[] = {
  0x2f800, 0x2f801, 0x2f802, 0x2f803, 0x2f804, 0x0fa30, 0x2f806, 0x2f807,
  0x2f808, 0x2f809, 0x0fa31, 0x2f80b, 0x2f80c, 0x2f80d, 0x0fa32, 0x2f80f,
  0x2f810, 0x2f811, 0x2f812, 0x2f813, 0x2f814, 0x1f21e, 0x2f816, 0x2f817,
  0x2f818, 0x2f819, 0x2f81a, 0x0fa71, 0x2f81c, 0x02f10, 0x2f81e, 0x2f81f,
  0x2f820, 0x2f821, 0x2f822, 0x2f823, 0x2f824, 0x0fa76, 0x0fa33, 0x0fa34,
  0x0fa77, 0x2f829, 0x2f82a, 0x0f963, 0x2f82c, 0x0fa35, 0x2f82e, 0x2f82f,
  0x2f830, 0x2f831, 0x2f831, 0x2f831, 0x2f834, 0x2f835, 0x2f836, 0x2f837,
  0x2f838, 0x2f839, 0x2f83a, 0x2f83b, 0x2f83c, 0x2f83d, 0x2f83e, 0x2f83f,
  0x2f840, 0x2f841, 0x2f842, 0x2f843, 0x2f844, 0x2f845, 0x2f845, 0x0fa7a,
  0x2f848, 0x2f849, 0x2f84a, 0x2f84b, 0x0fa37, 0x2f84d, 0x2f84e, 0x2f84f,
  0x0fa00, 0x2f851, 0x2f852, 0x2f853, 0x2f854, 0x2f855, 0x2f856, 0x2f857,
  0x2f858, 0x2f859, 0x2f85a, 0x2f85b, 0x2f85c, 0x1f215, 0x2f85e, 0x2f85f,
  0x2f860, 0x2f861, 0x2f862, 0x2f863, 0x2f864, 0x2f865, 0x2f866, 0x2f867,
  0x2f868, 0x2f869, 0x2f86a, 0x2f86a, 0x2f86c, 0x2f86d, 0x2f86e, 0x0f95f,
  0x2f870, 0x2f871, 0x2f872, 0x2f873, 0x2f874, 0x02e8e, 0x2f876, 0x2f877,
  0x02f2c, 0x2f879, 0x2f87a, 0x2f87b, 0x2f87c, 0x2f87d, 0x2f87e, 0x2f87f,
  0x2f880, 0x2f881, 0x2f882, 0x2f883, 0x2f884, 0x2f885, 0x2f886, 0x2f887,
  0x2f888, 0x2f889, 0x2f88a, 0x2f88b, 0x2f88c, 0x2f88d, 0x0f928, 0x2f88f,
  0x02f36, 0x2f891, 0x2f891, 0x2f893, 0x2f894, 0x2f894, 0x2f896, 0x2f897,
  0x2f898, 0x2f899, 0x2f89a, 0x2f89b, 0x2f89c, 0x2f89d, 0x2f89e, 0x2f89f,
  0x2f8a0, 0x2f8a1, 0x2f8a2, 0x0fa3d, 0x2f8a4, 0x2f8a5, 0x2f8a6, 0x2f8a7,
  0x0fa87, 0x2f8a7, 0x2f8aa, 0x0fa3f, 0x2f8ac, 0x2f8ad, 0x2f8ae, 0x2f8af,
  0x0fa40, 0x0f90d, 0x2f8b2, 0x2f8b3, 0x2f8b4, 0x2f8b5, 0x2f8b6, 0x2f8b7,
  0x2f8b8, 0x2f8b9, 0x2f8ba, 0x2f8bb, 0x2f8bc, 0x2f8bd, 0x2f8be, 0x2f8bf,
  0x2f8c0, 0x2f8c1, 0x2f8c2, 0x2f8c3, 0x2f8c4, 0x2f8c5, 0x2f8c6, 0x2f8c7,
  0x0fa41, 0x2f8c9, 0x2f8ca, 0x2f8cb, 0x2f8cc, 0x2f8cd, 0x2f8ce, 0x0fa43,
  0x2f8d0, 0x2f8d1, 0x2f8d2, 0x2f8d3, 0x2f8d4, 0x2f8d5, 0x2f8d6, 0x2f8d7,
  0x0f929, 0x0fa93, 0x2f8da, 0x2f8db, 0x2f8dc, 0x2f8dd, 0x2f8de, 0x2f8df,
  0x2f8e0, 0x2f8e1, 0x0fa44, 0x2f8e3, 0x2f8e4, 0x2f8e5, 0x2f8e6, 0x0fad2,
  0x2f8e8, 0x2f8e9, 0x2f8ea, 0x2f8eb, 0x2f8ec, 0x2f8ed, 0x2f8ee, 0x2f8ef,
  0x2f8f0, 0x2f8f1, 0x2f8f2, 0x2f8f3, 0x2f8f4, 0x0f970, 0x2f8f6, 0x2f8f7,
  0x2f8f8, 0x2f8f9, 0x2f8fa, 0x2f8fb, 0x2f8fc, 0x2f8fd, 0x2f8fe, 0x2f8ff
};

static uint32_t unicode_520_ci_page_2f9[] = {
  0x2f900, 0x0fa45, 0x0f9ca, 0x2f903, 0x2f904, 0x2f905, 0x2f906, 0x2f907,
  0x2f908, 0x2f909, 0x2f90a, 0x0fa99, 0x2f90c, 0x2f90d, 0x2f90e, 0x2f90f,
  0x2f910, 0x2f911, 0x2f912, 0x2f913, 0x0fa9b, 0x2f915, 0x2f916, 0x2f917,
  0x2f918, 0x2f919, 0x2f91a, 0x2f91b, 0x2f91c, 0x2f91d, 0x2f91e, 0x2f91f,
  0x2f920, 0x0fa9e, 0x2f922, 0x2f923, 0x2f924, 0x2f925, 0x2f926, 0x2f927,
  0x2f928, 0x02ea9, 0x2f92a, 0x2f92b, 0x2f92c, 0x2f92c, 0x2f92e, 0x2f92f,
  0x0faa1, 0x2f931, 0x2f932, 0x2f933, 0x2f934, 0x2f935, 0x2f936, 0x2f937,
  0x0f962, 0x2f939, 0x2f93a, 0x2f93b, 0x2f93c, 0x2f93d, 0x2f93e, 0x2f93f,
  0x0faa8, 0x2f941, 0x2f942, 0x2f943, 0x2f944, 0x2f945, 0x2f946, 0x2f946,
  0x0faa9, 0x0fad4, 0x2f94a, 0x2f94b, 0x2f94c, 0x2f94d, 0x2f94e, 0x0f93b,
  0x0faab, 0x2f951, 0x2f952, 0x0fa50, 0x2f954, 0x2f955, 0x0fa1b, 0x2f957,
  0x2f958, 0x0fa54, 0x2f95a, 0x2f95b, 0x2f95c, 0x2f95d, 0x2f95d, 0x2f95f,
  0x2f960, 0x2f961, 0x2f962, 0x2f963, 0x2f964, 0x2f965, 0x2f966, 0x2f967,
  0x2f968, 0x2f969, 0x2f96a, 0x2f96b, 0x2f96c, 0x2f96d, 0x2f96e, 0x2f96f,
  0x2f970, 0x2f971, 0x2f972, 0x2f973, 0x2f974, 0x2f975, 0x2f976, 0x2f977,
  0x2f978, 0x2f979, 0x0fa5b, 0x2f97b, 0x2f97c, 0x2f97d, 0x2f97e, 0x2f97f,
  0x2f980, 0x2f981, 0x2f982, 0x2f983, 0x2f984, 0x2f985, 0x2f986, 0x2f987,
  0x2f988, 0x2f989, 0x2f98a, 0x2f893, 0x2f98c, 0x2f98d, 0x2f98e, 0x2f98f,
  0x2f990, 0x2f991, 0x2f992, 0x2f993, 0x2f994, 0x2f995, 0x2f996, 0x2f997,
  0x0f974, 0x2f999, 0x2f99a, 0x2f99b, 0x2f99c, 0x2f99d, 0x2f99e, 0x0fa5f,
  0x2f9a0, 0x2f9a1, 0x2f9a2, 0x2f9a3, 0x2f9a4, 0x2f9a5, 0x2f9a6, 0x2f9a7,
  0x2f9a8, 0x2f9a9, 0x2f9aa, 0x2f9ab, 0x2f9ac, 0x2f9ad, 0x2f9ae, 0x2f9af,
  0x2f9b0, 0x2f9b1, 0x2f9b2, 0x2f9b3, 0x0f936, 0x2f9b5, 0x2f9b6, 0x2f9b7,
  0x2f9b8, 0x2f9b9, 0x2f9ba, 0x0fab5, 0x2f9bc, 0x2f9bd, 0x2f9be, 0x2f9bf,
  0x2f9c0, 0x2f9c1, 0x2f9c2, 0x2f9c3, 0x02f90, 0x2f9c5, 0x2f9c6, 0x2f9c7,
  0x2f9c8, 0x2f9c9, 0x2f9ca, 0x2f9cb, 0x2f9cc, 0x2f9cd, 0x2f9ce, 0x2f9cf,
  0x0fabe, 0x0fac0, 0x02f97, 0x2f9d3, 0x2f9d4, 0x2f9d5, 0x2f9d6, 0x2f9d7,
  0x2f9d8, 0x2f9d9, 0x2f9da, 0x2f9db, 0x2f9dc, 0x2f9dd, 0x2f9de, 0x0fac2,
  0x2f9e0, 0x2f9e1, 0x2f9e2, 0x2f9e3, 0x2f9e4, 0x2f9e5, 0x2f9e6, 0x2f9e7,
  0x2f9e8, 0x2f9e9, 0x2f9ea, 0x2f9eb, 0x2f9ec, 0x2f9ed, 0x2f9ee, 0x2f9ef,
  0x2f9f0, 0x2f9f1, 0x2f9f2, 0x2f9f3, 0x2f9f4, 0x2f9f5, 0x2f9f6, 0x2f9f7,
  0x2f9f8, 0x2f9f9, 0x2f9fa, 0x2f9fb, 0x2f9fc, 0x2f9fd, 0x0facb, 0x2f9ff
};

static uint32_t unicode_520_ci_page_2fa[] = {
  0x2fa00, 0x2fa01, 0x2fa02, 0x2fa03, 0x2fa04, 0x2fa05, 0x2fa06, 0x2fa07,
  0x2fa08, 0x2fa09, 0x0facd, 0x2fa0b, 0x2fa0c, 0x2fa0d, 0x2fa0e, 0x2fa0f,
  0x2fa10, 0x2fa11, 0x2fa12, 0x2fa13, 0x2fa14, 0x02fc7, 0x04d56, 0x02fcb,
  0x02eea, 0x2fa19, 0x2fa1a, 0x2fa1b, 0x02fd0, 0x2fa1d, 0x2fa1e, 0x2fa1f,
  0x2fa20, 0x2fa21, 0x2fa22, 0x2fa23, 0x2fa24, 0x2fa25, 0x2fa26, 0x2fa27,
  0x2fa28, 0x2fa29, 0x2fa2a, 0x2fa2b, 0x2fa2c, 0x2fa2d, 0x2fa2e, 0x2fa2f,
  0x2fa30, 0x2fa31, 0x2fa32, 0x2fa33, 0x2fa34, 0x2fa35, 0x2fa36, 0x2fa37,
  0x2fa38, 0x2fa39, 0x2fa3a, 0x2fa3b, 0x2fa3c, 0x2fa3d, 0x2fa3e, 0x2fa3f,
  0x2fa40, 0x2fa41, 0x2fa42, 0x2fa43, 0x2fa44, 0x2fa45, 0x2fa46, 0x2fa47,
  0x2fa48, 0x2fa49, 0x2fa4a, 0x2fa4b, 0x2fa4c, 0x2fa4d, 0x2fa4e, 0x2fa4f,
  0x2fa50, 0x2fa51, 0x2fa52, 0x2fa53, 0x2fa54, 0x2fa55, 0x2fa56, 0x2fa57,
  0x2fa58, 0x2fa59, 0x2fa5a, 0x2fa5b, 0x2fa5c, 0x2fa5d, 0x2fa5e, 0x2fa5f,
  0x2fa60, 0x2fa61, 0x2fa62, 0x2fa63, 0x2fa64, 0x2fa65, 0x2fa66, 0x2fa67,
  0x2fa68, 0x2fa69, 0x2fa6a, 0x2fa6b, 0x2fa6c, 0x2fa6d, 0x2fa6e, 0x2fa6f,
  0x2fa70, 0x2fa71, 0x2fa72, 0x2fa73, 0x2fa74, 0x2fa75, 0x2fa76, 0x2fa77,
  0x2fa78, 0x2fa79, 0x2fa7a, 0x2fa7b, 0x2fa7c, 0x2fa7d, 0x2fa7e, 0x2fa7f,
  0x2fa80, 0x2fa81, 0x2fa82, 0x2fa83, 0x2fa84, 0x2fa85, 0x2fa86, 0x2fa87,
  0x2fa88, 0x2fa89, 0x2fa8a, 0x2fa8b, 0x2fa8c, 0x2fa8d, 0x2fa8e, 0x2fa8f,
  0x2fa90, 0x2fa91, 0x2fa92, 0x2fa93, 0x2fa94, 0x2fa95, 0x2fa96, 0x2fa97,
  0x2fa98, 0x2fa99, 0x2fa9a, 0x2fa9b, 0x2fa9c, 0x2fa9d, 0x2fa9e, 0x2fa9f,
  0x2faa0, 0x2faa1, 0x2faa2, 0x2faa3, 0x2faa4, 0x2faa5, 0x2faa6, 0x2faa7,
  0x2faa8, 0x2faa9, 0x2faaa, 0x2faab, 0x2faac, 0x2faad, 0x2faae, 0x2faaf,
  0x2fab0, 0x2fab1, 0x2fab2, 0x2fab3, 0x2fab4, 0x2fab5, 0x2fab6, 0x2fab7,
  0x2fab8, 0x2fab9, 0x2faba, 0x2fabb, 0x2fabc, 0x2fabd, 0x2fabe, 0x2fabf,
  0x2fac0, 0x2fac1, 0x2fac2, 0x2fac3, 0x2fac4, 0x2fac5, 0x2fac6, 0x2fac7,
  0x2fac8, 0x2fac9, 0x2faca, 0x2facb, 0x2facc, 0x2facd, 0x2face, 0x2facf,
  0x2fad0, 0x2fad1, 0x2fad2, 0x2fad3, 0x2fad4, 0x2fad5, 0x2fad6, 0x2fad7,
  0x2fad8, 0x2fad9, 0x2fada, 0x2fadb, 0x2fadc, 0x2fadd, 0x2fade, 0x2fadf,
  0x2fae0, 0x2fae1, 0x2fae2, 0x2fae3, 0x2fae4, 0x2fae5, 0x2fae6, 0x2fae7,
  0x2fae8, 0x2fae9, 0x2faea, 0x2faeb, 0x2faec, 0x2faed, 0x2faee, 0x2faef,
  0x2faf0, 0x2faf1, 0x2faf2, 0x2faf3, 0x2faf4, 0x2faf5, 0x2faf6, 0x2faf7,
  0x2faf8, 0x2faf9, 0x2fafa, 0x2fafb, 0x2fafc, 0x2fafd, 0x2fafe, 0x2faff
};

static uint32_t unicode_520_ci_page_e00[] = {
  0xe0000, 0x00000, 0xe0002, 0xe0003, 0xe0004, 0xe0005, 0xe0006, 0xe0007,
  0xe0008, 0xe0009, 0xe000a, 0xe000b, 0xe000c, 0xe000d, 0xe000e, 0xe000f,
  0xe0010, 0xe0011, 0xe0012, 0xe0013, 0xe0014, 0xe0015, 0xe0016, 0xe0017,
  0xe0018, 0xe0019, 0xe001a, 0xe001b, 0xe001c, 0xe001d, 0xe001e, 0xe001f,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0xe0080, 0xe0081, 0xe0082, 0xe0083, 0xe0084, 0xe0085, 0xe0086, 0xe0087,
  0xe0088, 0xe0089, 0xe008a, 0xe008b, 0xe008c, 0xe008d, 0xe008e, 0xe008f,
  0xe0090, 0xe0091, 0xe0092, 0xe0093, 0xe0094, 0xe0095, 0xe0096, 0xe0097,
  0xe0098, 0xe0099, 0xe009a, 0xe009b, 0xe009c, 0xe009d, 0xe009e, 0xe009f,
  0xe00a0, 0xe00a1, 0xe00a2, 0xe00a3, 0xe00a4, 0xe00a5, 0xe00a6, 0xe00a7,
  0xe00a8, 0xe00a9, 0xe00aa, 0xe00ab, 0xe00ac, 0xe00ad, 0xe00ae, 0xe00af,
  0xe00b0, 0xe00b1, 0xe00b2, 0xe00b3, 0xe00b4, 0xe00b5, 0xe00b6, 0xe00b7,
  0xe00b8, 0xe00b9, 0xe00ba, 0xe00bb, 0xe00bc, 0xe00bd, 0xe00be, 0xe00bf,
  0xe00c0, 0xe00c1, 0xe00c2, 0xe00c3, 0xe00c4, 0xe00c5, 0xe00c6, 0xe00c7,
  0xe00c8, 0xe00c9, 0xe00ca, 0xe00cb, 0xe00cc, 0xe00cd, 0xe00ce, 0xe00cf,
  0xe00d0, 0xe00d1, 0xe00d2, 0xe00d3, 0xe00d4, 0xe00d5, 0xe00d6, 0xe00d7,
  0xe00d8, 0xe00d9, 0xe00da, 0xe00db, 0xe00dc, 0xe00dd, 0xe00de, 0xe00df,
  0xe00e0, 0xe00e1, 0xe00e2, 0xe00e3, 0xe00e4, 0xe00e5, 0xe00e6, 0xe00e7,
  0xe00e8, 0xe00e9, 0xe00ea, 0xe00eb, 0xe00ec, 0xe00ed, 0xe00ee, 0xe00ef,
  0xe00f0, 0xe00f1, 0xe00f2, 0xe00f3, 0xe00f4, 0xe00f5, 0xe00f6, 0xe00f7,
  0xe00f8, 0xe00f9, 0xe00fa, 0xe00fb, 0xe00fc, 0xe00fd, 0xe00fe, 0xe00ff
};

static uint32_t unicode_520_ci_page_e01[] = {
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0xe01f0, 0xe01f1, 0xe01f2, 0xe01f3, 0xe01f4, 0xe01f5, 0xe01f6, 0xe01f7,
  0xe01f8, 0xe01f9, 0xe01fa, 0xe01fb, 0xe01fc, 0xe01fd, 0xe01fe, 0xe01ff
};

static uint32_t *unicode_520_ci_table[4352] = {
  unicode_520_ci_page_00, unicode_520_ci_page_01,
  unicode_520_ci_page_02, unicode_520_ci_page_03,
  unicode_520_ci_page_04, unicode_520_ci_page_05,
  unicode_520_ci_page_06, unicode_520_ci_page_07,
  unicode_520_ci_page_08, unicode_520_ci_page_09,
  unicode_520_ci_page_0a, unicode_520_ci_page_0b,
  unicode_520_ci_page_0c, unicode_520_ci_page_0d,
  unicode_520_ci_page_0e, unicode_520_ci_page_0f,
  unicode_520_ci_page_10,                NULL,
                 NULL, unicode_520_ci_page_13,
                 NULL,                NULL,
  unicode_520_ci_page_16, unicode_520_ci_page_17,
  unicode_520_ci_page_18, unicode_520_ci_page_19,
  unicode_520_ci_page_1a, unicode_520_ci_page_1b,
  unicode_520_ci_page_1c, unicode_520_ci_page_1d,
  unicode_520_ci_page_1e, unicode_520_ci_page_1f,
  unicode_520_ci_page_20, unicode_520_ci_page_21,
  unicode_520_ci_page_22,                NULL,
  unicode_520_ci_page_24,                NULL,
                 NULL, unicode_520_ci_page_27,
                 NULL,                NULL,
  unicode_520_ci_page_2a,                NULL,
  unicode_520_ci_page_2c, unicode_520_ci_page_2d,
  unicode_520_ci_page_2e, unicode_520_ci_page_2f,
  unicode_520_ci_page_30, unicode_520_ci_page_31,
  unicode_520_ci_page_32, unicode_520_ci_page_33,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
  unicode_520_ci_page_a6, unicode_520_ci_page_a7,
  unicode_520_ci_page_a8, unicode_520_ci_page_a9,
  unicode_520_ci_page_aa, unicode_520_ci_page_ab,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL, unicode_520_ci_page_f9,
  unicode_520_ci_page_fa, unicode_520_ci_page_fb,
  unicode_520_ci_page_fc, unicode_520_ci_page_fd,
  unicode_520_ci_page_fe, unicode_520_ci_page_ff,
                 NULL, unicode_520_ci_page_101,
                 NULL, unicode_520_ci_page_103,
  unicode_520_ci_page_104,                NULL,
                 NULL,                NULL,
  unicode_520_ci_page_108, unicode_520_ci_page_109,
  unicode_520_ci_page_10a, unicode_520_ci_page_10b,
  unicode_520_ci_page_10c,                NULL,
  unicode_520_ci_page_10e,                NULL,
  unicode_520_ci_page_110,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
  unicode_520_ci_page_124,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL, unicode_520_ci_page_1d1,
  unicode_520_ci_page_1d2, unicode_520_ci_page_1d3,
  unicode_520_ci_page_1d4, unicode_520_ci_page_1d5,
  unicode_520_ci_page_1d6, unicode_520_ci_page_1d7,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL, unicode_520_ci_page_1f1,
  unicode_520_ci_page_1f2,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
  unicode_520_ci_page_2f8, unicode_520_ci_page_2f9,
  unicode_520_ci_page_2fa,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
  unicode_520_ci_page_e00, unicode_520_ci_page_e01,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL
};

#endif
