/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_dom_XPathEvaluator_h
#define mozilla_dom_XPathEvaluator_h

#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "nsIWeakReference.h"
#include "nsAutoPtr.h"
#include "nsString.h"
#include "mozilla/Attributes.h"
#include "mozilla/ErrorResult.h"
#include "nsIDocument.h"

class nsINode;
class txIParseContext;
class txResultRecycler;

namespace mozilla {
namespace dom {

class GlobalObject;
class XPathExpression;
class XPathNSResolver;
class XPathResult;

/**
 * A class for evaluating an XPath expression string
 */
class XPathEvaluator final : public NonRefcountedDOMObject
{
public:
    explicit XPathEvaluator(nsIDocument* aDocument = nullptr);
    ~XPathEvaluator();

    // WebIDL API
    bool WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);
    nsIDocument* GetParentObject()
    {
        nsCOMPtr<nsIDocument> doc = do_QueryReferent(mDocument);
        return doc;
    }
    static XPathEvaluator*
        Constructor(const GlobalObject& aGlobal, ErrorResult& rv);
    XPathExpression*
        CreateExpression(const nsAString& aExpression,
                         XPathNSResolver* aResolver,
                         ErrorResult& rv);
    XPathExpression*
        CreateExpression(const nsAString& aExpression,
                         nsINode* aResolver,
                         ErrorResult& aRv);
    nsINode* CreateNSResolver(nsINode& aNodeResolver)
    {
        return &aNodeResolver;
    }
    already_AddRefed<XPathResult>
        Evaluate(JSContext* aCx, const nsAString& aExpression,
                 nsINode& aContextNode, XPathNSResolver* aResolver,
                 uint16_t aType, JS::Handle<JSObject*> aResult,
                 ErrorResult& rv);
private:
    XPathExpression*
        CreateExpression(const nsAString& aExpression,
                         txIParseContext* aContext,
                         nsIDocument* aDocument,
                         ErrorResult& aRv);

    nsWeakPtr mDocument;
    RefPtr<txResultRecycler> mRecycler;
};

} // namespace dom
} // namespace mozilla

#endif /* mozilla_dom_XPathEvaluator_h */
