/*
 * Decompiled with CFR 0.152.
 */
package classycle.graph;

import classycle.graph.AtomicVertex;
import classycle.graph.Attributes;
import classycle.graph.GraphAttributes;
import classycle.graph.StrongComponentProcessor;
import classycle.graph.Vertex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class StrongComponent
extends Vertex {
    private final Vector<AtomicVertex> _vertices = new Vector();
    private boolean _active;
    private int _longestWalk;

    public StrongComponent() {
        super(new GeometryAttributes());
    }

    public int getNumberOfVertices() {
        return this._vertices.size();
    }

    public AtomicVertex getVertex(int index) {
        return this._vertices.elementAt(index);
    }

    public void addVertex(AtomicVertex vertex) {
        this._vertices.insertElementAt(vertex, 0);
    }

    public void calculateAttributes() {
        int i;
        Map<AtomicVertex, Integer> indexMap = this.calculateIndexMap();
        int[][] distances = this.calculateDistances(indexMap);
        GeometryAttributes attributes = (GeometryAttributes)this.getAttributes();
        int girth = Integer.MAX_VALUE;
        int[] eccentricities = new int[distances.length];
        for (i = 0; i < distances.length; ++i) {
            girth = Math.min(girth, distances[i][i]);
            eccentricities[i] = 0;
            for (int j = 0; j < distances.length; ++j) {
                if (i == j) continue;
                eccentricities[i] = Math.max(eccentricities[i], distances[i][j]);
            }
        }
        attributes.setEccentricities(eccentricities);
        attributes.setGirth(girth);
        attributes.setMaximumFragmentSizes(this.calculateMaximumFragmentSizes(indexMap));
        int r = attributes.getRadius();
        int s = attributes.getBestFragmentSize();
        for (i = 0; i < distances.length; ++i) {
            if (eccentricities[i] == r) {
                attributes.addVertex(this.getVertex(i));
            }
            if (attributes.getMaximumFragmentSizes()[i] != s) continue;
            attributes.addFragmenter(this.getVertex(i));
        }
    }

    private int[][] calculateDistances(Map<AtomicVertex, Integer> indexMap) {
        int n = this.getNumberOfVertices();
        int[][] distances = new int[n][n];
        for (int i = 0; i < n; ++i) {
            int j;
            int[] row = distances[i];
            AtomicVertex vertex = this.getVertex(i);
            for (j = 0; j < n; ++j) {
                row[j] = 0x3FFFFFFF;
            }
            int m = vertex.getNumberOfOutgoingArcs();
            for (j = 0; j < m; ++j) {
                Integer index = indexMap.get(vertex.getHeadVertex(j));
                if (index == null) continue;
                row[index.intValue()] = 1;
            }
        }
        for (int k = 0; k < n; ++k) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    if (distances[i][k] + distances[k][j] >= distances[i][j]) continue;
                    distances[i][j] = distances[i][k] + distances[k][j];
                }
            }
        }
        return distances;
    }

    private Map<AtomicVertex, Integer> calculateIndexMap() {
        HashMap<AtomicVertex, Integer> result = new HashMap<AtomicVertex, Integer>();
        int n = this.getNumberOfVertices();
        for (int i = 0; i < n; ++i) {
            result.put(this.getVertex(i), i);
        }
        return result;
    }

    private int[] calculateMaximumFragmentSizes(Map<AtomicVertex, Integer> indexMap) {
        int i;
        Vertex[] graph = new AtomicVertex[this.getNumberOfVertices()];
        for (i = 0; i < graph.length; ++i) {
            graph[i] = new AtomicVertex(null);
        }
        for (i = 0; i < graph.length; ++i) {
            AtomicVertex vertex = this.getVertex(i);
            int n = vertex.getNumberOfOutgoingArcs();
            for (int j = 0; j < n; ++j) {
                Integer index = indexMap.get(vertex.getHeadVertex(j));
                if (index == null) continue;
                graph[i].addOutgoingArcTo(graph[index]);
            }
        }
        StrongComponentProcessor processor = new StrongComponentProcessor(false);
        int[] maximumFragmentSizes = new int[this.getNumberOfVertices()];
        for (int i2 = 0; i2 < maximumFragmentSizes.length; ++i2) {
            graph[i2].setDefaultValueOfGraphVertexFlag(false);
            processor.deepSearchFirst(graph);
            StrongComponent[] fragments = processor.getStrongComponents();
            maximumFragmentSizes[i2] = 0;
            for (int j = 0; j < fragments.length; ++j) {
                maximumFragmentSizes[i2] = Math.max(maximumFragmentSizes[i2], fragments[j].getNumberOfVertices());
            }
            ((AtomicVertex)graph[i2]).setDefaultValueOfGraphVertexFlag(true);
        }
        return maximumFragmentSizes;
    }

    @Override
    public void reset() {
        super.reset();
        this._active = false;
        this._longestWalk = -1;
    }

    public boolean isActive() {
        return this._active;
    }

    public void setActive(boolean active) {
        this._active = active;
    }

    public int getLongestWalk() {
        return this._longestWalk;
    }

    public void setLongestWalk(int longestWalk) {
        this._longestWalk = longestWalk;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer("Strong component with ");
        int n = this.getNumberOfVertices();
        result.append(n).append(n > 1 ? " vertices." : " vertex.");
        result.append(" Longest walk: ").append(this.getLongestWalk());
        for (int i = 0; i < n; ++i) {
            result.append("\n    ").append(this.getVertex(i));
        }
        return new String(result);
    }

    private static class GeometryAttributes
    implements GraphAttributes {
        private int _girth;
        private int _radius;
        private int _diameter;
        private List<Vertex> _centerVertices = new ArrayList<Vertex>();
        private int[] _eccentricities;
        private int[] _maximumFragmentSizes;
        private int _bestFragmentSize;
        private List<Vertex> _bestFragmenters = new ArrayList<Vertex>();

        @Override
        public int getGirth() {
            return this._girth;
        }

        void setGirth(int girth) {
            this._girth = girth;
        }

        @Override
        public int getRadius() {
            return this._radius;
        }

        @Override
        public int getDiameter() {
            return this._diameter;
        }

        @Override
        public int getBestFragmentSize() {
            return this._bestFragmentSize;
        }

        @Override
        public Vertex[] getCenterVertices() {
            return this._centerVertices.toArray(new Vertex[this._centerVertices.size()]);
        }

        void addVertex(Vertex vertex) {
            this._centerVertices.add(vertex);
        }

        @Override
        public Vertex[] getBestFragmenters() {
            return this._bestFragmenters.toArray(new Vertex[this._bestFragmenters.size()]);
        }

        void addFragmenter(Vertex vertex) {
            this._bestFragmenters.add(vertex);
        }

        @Override
        public int[] getEccentricities() {
            return this._eccentricities;
        }

        void setEccentricities(int[] eccentricities) {
            this._eccentricities = eccentricities;
            this._radius = Integer.MAX_VALUE;
            this._diameter = 0;
            for (int i = 0; i < eccentricities.length; ++i) {
                this._radius = Math.min(this._radius, eccentricities[i]);
                this._diameter = Math.max(this._diameter, eccentricities[i]);
            }
        }

        @Override
        public int[] getMaximumFragmentSizes() {
            return this._maximumFragmentSizes;
        }

        void setMaximumFragmentSizes(int[] maximumFragmentSizes) {
            this._maximumFragmentSizes = maximumFragmentSizes;
            this._bestFragmentSize = Integer.MAX_VALUE;
            for (int i = 0; i < maximumFragmentSizes.length; ++i) {
                this._bestFragmentSize = Math.min(this._bestFragmentSize, maximumFragmentSizes[i]);
            }
        }

        @Override
        public int compareTo(Attributes object) {
            List<Vertex> list;
            int result = 1;
            if (object instanceof GeometryAttributes && this._bestFragmenters.size() > 0 && (list = ((GeometryAttributes)object)._bestFragmenters).size() > 0) {
                Attributes attributes = this._bestFragmenters.get(0).getAttributes();
                Attributes objectAttributes = list.get(0).getAttributes();
                result = attributes.compareTo(objectAttributes);
            }
            return result;
        }
    }
}

