/*
 * Decompiled with CFR 0.152.
 */
package classycle.classfile;

import classycle.classfile.ClassConstant;
import classycle.classfile.DoubleConstant;
import classycle.classfile.FieldRefConstant;
import classycle.classfile.FloatConstant;
import classycle.classfile.IntConstant;
import classycle.classfile.InterfaceMethodRefConstant;
import classycle.classfile.LongConstant;
import classycle.classfile.MethodRefConstant;
import classycle.classfile.NameAndTypeConstant;
import classycle.classfile.StringConstant;
import classycle.classfile.UTF8Constant;
import java.io.DataInputStream;
import java.io.IOException;

public abstract class Constant {
    private static final int MAGIC = -889275714;
    private static final int CONSTANT_CLASS = 7;
    private static final int CONSTANT_FIELDREF = 9;
    private static final int CONSTANT_METHODREF = 10;
    private static final int CONSTANT_INTERFACE_METHODREF = 11;
    private static final int CONSTANT_STRING = 8;
    private static final int CONSTANT_INTEGER = 3;
    private static final int CONSTANT_FLOAT = 4;
    private static final int CONSTANT_LONG = 5;
    private static final int CONSTANT_DOUBLE = 6;
    private static final int CONSTANT_NAME_AND_TYPE = 12;
    private static final int CONSTANT_UTF8 = 1;
    private Constant[] _pool;

    public static Constant[] extractConstantPool(DataInputStream stream) throws IOException {
        Constant[] pool = null;
        if (stream.readInt() == -889275714) {
            boolean skipIndex;
            stream.readUnsignedShort();
            stream.readUnsignedShort();
            pool = new Constant[stream.readUnsignedShort()];
            for (int i = 1; i < pool.length; i += skipIndex ? 2 : 1) {
                skipIndex = false;
                Constant c = null;
                int type = stream.readUnsignedByte();
                switch (type) {
                    case 7: {
                        c = new ClassConstant(pool, stream.readUnsignedShort());
                        break;
                    }
                    case 9: {
                        c = new FieldRefConstant(pool, stream.readUnsignedShort(), stream.readUnsignedShort());
                        break;
                    }
                    case 10: {
                        c = new MethodRefConstant(pool, stream.readUnsignedShort(), stream.readUnsignedShort());
                        break;
                    }
                    case 11: {
                        c = new InterfaceMethodRefConstant(pool, stream.readUnsignedShort(), stream.readUnsignedShort());
                        break;
                    }
                    case 8: {
                        c = new StringConstant(pool, stream.readUnsignedShort());
                        break;
                    }
                    case 3: {
                        c = new IntConstant(pool, stream.readInt());
                        break;
                    }
                    case 4: {
                        c = new FloatConstant(pool, stream.readFloat());
                        break;
                    }
                    case 5: {
                        c = new LongConstant(pool, stream.readLong());
                        skipIndex = true;
                        break;
                    }
                    case 6: {
                        c = new DoubleConstant(pool, stream.readDouble());
                        skipIndex = true;
                        break;
                    }
                    case 12: {
                        c = new NameAndTypeConstant(pool, stream.readUnsignedShort(), stream.readUnsignedShort());
                        break;
                    }
                    case 1: {
                        c = new UTF8Constant(pool, stream.readUTF());
                    }
                }
                pool[i] = c;
            }
            return pool;
        }
        throw new IOException("Not a class file: Magic number missing.");
    }

    public Constant(Constant[] pool) {
        this._pool = pool;
    }

    public Constant getConstant(int index) {
        return this._pool[index];
    }
}

