# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

toolbar-button-firefox-view =
    .label = { -firefoxview-brand-name(case: "nom") }
    .tooltiptext = { -firefoxview-brand-name(case: "nom") }
toolbar-button-firefox-view-2 =
    .label = { -firefoxview-brand-name(case: "nom") }
    .tooltiptext = Προβολή πρόσφατης περιήγησης από όλα τα παράθυρα και τις συσκευές
menu-tools-firefox-view =
    .label = { -firefoxview-brand-name(case: "nom") }
    .accesskey = F
firefoxview-page-title = { -firefoxview-brand-name(case: "nom") }
firefoxview-page-heading =
    .heading = { -firefoxview-brand-name(case: "nom") }
firefoxview-page-label =
    .label = { -firefoxview-brand-name(case: "nom") }
firefoxview-close-button =
    .title = Κλείσιμο
    .aria-label = Κλείσιμο
firefoxview-empty-state-icon =
    .alt = Προσοχή:
# Used instead of the localized relative time when a timestamp is within a minute or so of now
firefoxview-just-now-timestamp = Μόλις τώρα
# This is a headline for an area in the product where users can resume and re-open tabs they have previously viewed on other devices.
firefoxview-tabpickup-header = Μεταφορά καρτελών
firefoxview-tabpickup-description = Ανοίξτε σελίδες από άλλες συσκευές.
# Variables:
#  $percentValue (Number): the percentage value for setup completion
firefoxview-tabpickup-progress-label = Ολοκλήρωση κατά { $percentValue }%
firefoxview-tabpickup-step-signin-header = Απρόσκοπτη εναλλαγή μεταξύ συσκευών
firefoxview-tabpickup-step-signin-description = Για να φέρετε τις καρτέλες του τηλεφώνου σας εδώ, κάντε πρώτα σύνδεση ή δημιουργήστε έναν λογαριασμό.
firefoxview-tabpickup-step-signin-primarybutton = Συνέχεια
firefoxview-syncedtabs-signin-header-2 = Το { -brand-product-name } σας σε όλες τις συσκευές σας
firefoxview-syncedtabs-signin-description-2 = Για να δείτε τις ανοικτές σας καρτέλες στο τηλέφωνο και σε άλλες συσκευές σας, συνδεθείτε ή δημιουργήστε έναν λογαριασμό. Με έναν λογαριασμό, μπορείτε να συγχρονίσετε τους κωδικούς πρόσβασης, το ιστορικό σας και πολλά άλλα.
firefoxview-syncedtabs-signin-primarybutton-2 = Σύνδεση
firefoxview-syncedtabs-signin-header = Λάβετε καρτέλες από οπουδήποτε
firefoxview-syncedtabs-signin-description = Για να δείτε τις καρτέλες σας από όπου κι αν χρησιμοποιείτε το { -brand-product-name }, συνδεθείτε στον λογαριασμό σας. Εάν δεν έχετε λογαριασμό, θα σας καθοδηγήσουμε κατά την εγγραφή.
firefoxview-syncedtabs-signin-primarybutton = Σύνδεση ή εγγραφή
firefoxview-tabpickup-adddevice-header = Συγχρονισμός του { -brand-product-name } στις κινητές σας συσκευές
firefoxview-tabpickup-adddevice-description = Κάντε λήψη του { -brand-product-name } για κινητές συσκευές και συνδεθείτε εκεί.
firefoxview-tabpickup-adddevice-learn-how = Μάθετε πώς
firefoxview-tabpickup-adddevice-primarybutton = Λήψη του { -brand-product-name } για κινητά
firefoxview-syncedtabs-adddevice-header-2 = Λάβετε καρτέλες από οπουδήποτε
firefoxview-syncedtabs-adddevice-description-2 = Συνδεθείτε στο { -brand-product-name } από το τηλέφωνό σας ή από κάποιο άλλο υπολογιστή για να δείτε τις καρτέλες. Μάθετε πώς να <a data-l10n-name="url">συνδέσετε επιπλέον συσκευές</a>.
firefoxview-syncedtabs-adddevice-header = Συνδεθείτε στο { -brand-product-name } στις άλλες συσκευές σας
firefoxview-syncedtabs-adddevice-description = Για να δείτε τις καρτέλες σας από όπου κι αν χρησιμοποιείτε το { -brand-product-name }, συνδεθείτε από όλες τις συσκευές σας. Μάθετε πώς να <a data-l10n-name="url">συνδέσετε πρόσθετες συσκευές</a>.
firefoxview-syncedtabs-adddevice-primarybutton = Δοκιμάστε το { -brand-product-name } για κινητές συσκευές
firefoxview-tabpickup-synctabs-header = Ενεργοποίηση συγχρονισμού καρτελών
firefoxview-tabpickup-synctabs-description = Επιτρέψτε στο { -brand-short-name } να κάνει κοινή χρήση καρτελών μεταξύ συσκευών.
firefoxview-tabpickup-synctabs-learn-how = Μάθετε πώς
firefoxview-tabpickup-synctabs-primarybutton = Συγχρονισμός ανοικτών καρτελών
firefoxview-syncedtabs-synctabs-header = Ενημερώστε τις ρυθμίσεις συγχρονισμού σας
firefoxview-syncedtabs-synctabs-description = Για να δείτε καρτέλες από άλλες συσκευές, πρέπει να συγχρονίσετε τις ανοικτές καρτέλες σας.
firefoxview-syncedtabs-synctabs-checkbox = Επιτρέψτε τον συγχρονισμό ανοικτών καρτελών
firefoxview-syncedtabs-loading-header = Συγχρονισμός σε εξέλιξη
firefoxview-syncedtabs-loading-description = Μόλις ολοκληρωθεί, θα δείτε όλες τις ανοικτές καρτέλες από άλλες συσκευές. Επιστρέψτε σε λίγο.
firefoxview-tabpickup-fxa-admin-disabled-header = Ο οργανισμός σας έχει απενεργοποιήσει τον συγχρονισμό
firefoxview-tabpickup-fxa-admin-disabled-description = Το { -brand-short-name } δεν μπορεί να συγχρονίσει τις καρτέλες μεταξύ συσκευών, επειδή ο διαχειριστής σας έχει απενεργοποιήσει τον συγχρονισμό.
firefoxview-tabpickup-fxa-disabled-by-policy-description = Το { -brand-short-name } δεν μπορεί να συγχρονίσει τις καρτέλες μεταξύ συσκευών, επειδή ο οργανισμός σας έχει απενεργοποιήσει τον συγχρονισμό.
firefoxview-tabpickup-network-offline-header = Ελέγξτε τη σύνδεσή σας στο διαδίκτυο
firefoxview-tabpickup-network-offline-description = Εάν χρησιμοποιείτε τείχος προστασίας ή διακομιστή μεσολάβησης, ελέγξτε ότι το { -brand-short-name } έχει άδεια πρόσβασης στο διαδίκτυο.
firefoxview-tabpickup-network-offline-primarybutton = Δοκιμή ξανά
firefoxview-tabpickup-sync-error-header = Υπάρχει πρόβλημα με τον συγχρονισμό
firefoxview-tabpickup-generic-sync-error-description = Το { -brand-short-name } δεν μπορεί να επικοινωνήσει με την υπηρεσία συγχρονισμού αυτήν τη στιγμή. Δοκιμάστε ξανά σε λίγα λεπτά.
firefoxview-tabpickup-sync-error-primarybutton = Δοκιμή ξανά
firefoxview-tabpickup-sync-disconnected-header = Ενεργοποιήστε τον συγχρονισμό για να συνεχίσετε
firefoxview-tabpickup-sync-disconnected-description = Για να λάβετε τις καρτέλες σας, θα πρέπει να επιτρέψετε τον συγχρονισμό στο { -brand-short-name }.
firefoxview-tabpickup-sync-disconnected-primarybutton = Ενεργοποιήστε τον συγχρονισμό στις ρυθμίσεις
firefoxview-tabpickup-password-locked-header = Εισαγάγετε τον κύριο κωδικό πρόσβασής σας για να δείτε τις καρτέλες
firefoxview-tabpickup-password-locked-description = Για να λάβετε τις καρτέλες σας, θα πρέπει να εισαγάγετε τον κύριο κωδικό πρόσβασης του { -brand-short-name }.
firefoxview-tabpickup-password-locked-link = Μάθετε περισσότερα
firefoxview-tabpickup-password-locked-primarybutton = Εισαγωγή κύριου κωδικού πρόσβασης
firefoxview-syncedtab-password-locked-link = <a data-l10n-name="syncedtab-password-locked-link">Μάθετε περισσότερα</a>
firefoxview-tabpickup-signed-out-header = Συνδεθείτε για επανασύνδεση
firefoxview-tabpickup-signed-out-description = Για να επανασυνδεθείτε και να λάβετε τις καρτέλες σας, συνδεθείτε στον { -fxaccount-brand-name(case: "acc", capitalization: "lower") } σας.
firefoxview-tabpickup-signed-out-description2 = Για να επανασυνδεθείτε και να λάβετε τις καρτέλες σας, συνδεθείτε στον λογαριασμό σας.
firefoxview-tabpickup-signed-out-primarybutton = Σύνδεση
firefoxview-tabpickup-syncing = Περιμένετε μέχρι να συγχρονιστούν οι καρτέλες σας. Θα χρειαστεί μόνο μια στιγμή.
firefoxview-mobile-promo-header = Λάβετε καρτέλες από το τηλέφωνο ή το tablet σας
firefoxview-mobile-promo-description = Για να δείτε τις πρόσφατες καρτέλες από την κινητή σας συσκευή, συνδεθείτε στο { -brand-product-name } για iOS ή Android.
firefoxview-mobile-promo-primarybutton = Λήψη του { -brand-product-name } για κινητά
firefoxview-mobile-confirmation-header = 🎉 Όλα έτοιμα!
firefoxview-mobile-confirmation-description = Μπορείτε πλέον να λάβετε τις καρτέλες σας από το { -brand-product-name } του tablet ή του τηλεφώνου σας.
firefoxview-closed-tabs-title = Πρόσφατα κλεισμένες
firefoxview-closed-tabs-description2 = Ανοίξτε ξανά τις σελίδες που κλείσατε σε αυτό το παράθυρο.
firefoxview-closed-tabs-placeholder-header = Καμία πρόσφατα κλεισμένη καρτέλα
firefoxview-closed-tabs-placeholder-body = Όταν κλείσετε μια καρτέλα σε αυτό το παράθυρο, μπορείτε να τη βρείτε εδώ.
firefoxview-closed-tabs-placeholder-body2 = Όταν κλείσετε μια καρτέλα, μπορείτε να τη βρείτε εδώ.
# Variables:
#   $tabTitle (string) - Title of tab being dismissed
firefoxview-closed-tabs-dismiss-tab =
    .title = Απόρριψη «{ $tabTitle }»
# refers to the last tab that was used
firefoxview-pickup-tabs-badge = Πρόσφατα ενεργή
# Variables:
#   $targetURI (string) - URL that will be opened in the new tab
firefoxview-tabs-list-tab-button =
    .title = Άνοιγμα { $targetURI } σε νέα καρτέλα
firefoxview-try-colorways-button = Δοκιμή χρωματικών συνδυασμών
firefoxview-change-colorway-button = Αλλαγή χρωματικού συνδυασμού
# Variables:
#  $intensity (String): Colorway intensity
#  $collection (String): Colorway Collection name
firefoxview-colorway-description = { $intensity } · { $collection }
firefoxview-synced-tabs-placeholder-header = Δεν υπάρχει τίποτα ακόμα
firefoxview-synced-tabs-placeholder-body = Την επόμενη φορά που θα ανοίξετε μια σελίδα στο { -brand-product-name } σε άλλη συσκευή, θα τη λάβετε εδώ ως δια μαγείας.
firefoxview-collapse-button-show =
    .title = Εμφάνιση λίστας
firefoxview-collapse-button-hide =
    .title = Απόκρυψη λίστας
firefoxview-overview-nav = Πρόσφατη περιήγηση
    .title = Πρόσφατη περιήγηση
firefoxview-overview-header = Πρόσφατη περιήγηση
    .title = Πρόσφατη περιήγηση

## History in this context refers to browser history

firefoxview-history-nav = Ιστορικό
    .title = Ιστορικό
firefoxview-history-header = Ιστορικό
firefoxview-history-context-delete = Διαγραφή από ιστορικό
    .accesskey = Δ

## Open Tabs in this context refers to all open tabs in the browser

firefoxview-opentabs-nav = Ανοικτές καρτέλες
    .title = Ανοικτές καρτέλες
firefoxview-opentabs-header = Ανοικτές καρτέλες

## Recently closed tabs in this context refers to recently closed tabs from all windows

firefoxview-recently-closed-nav = Πρόσφατα κλεισμένες καρτέλες
    .title = Πρόσφατα κλεισμένες καρτέλες
firefoxview-recently-closed-header = Πρόσφατα κλεισμένες καρτέλες

## Tabs from other devices refers in this context refers to synced tabs from other devices

firefoxview-synced-tabs-nav = Καρτέλες από άλλες συσκευές
    .title = Καρτέλες από άλλες συσκευές
firefoxview-synced-tabs-header = Καρτέλες από άλλες συσκευές

##

# Used for a link in collapsible cards, in the ’Recent browsing’ page of Firefox View
firefoxview-view-all-link = Προβολή όλων
# Variables:
#   $winID (Number) - The index of the owner window for this set of tabs
firefoxview-opentabs-window-header =
    .title = Παράθυρο { $winID }
# Variables:
#   $winID (Number) - The index of the owner window (which is currently focused) for this set of tabs
firefoxview-opentabs-current-window-header =
    .title = Παράθυρο { $winID } (Τρέχον)
firefoxview-opentabs-focus-tab =
    .title = Εναλλαγή σε αυτήν την καρτέλα
firefoxview-show-more = Εμφάνιση περισσότερων
firefoxview-show-less = Εμφάνιση λιγότερων
firefoxview-show-all = Εμφάνιση όλων
firefoxview-search-text-box-clear-button =
    .title = Απαλοιφή
# Placeholder for the input field to search in recent browsing ("search" is a verb).
firefoxview-search-text-box-recentbrowsing =
    .placeholder = Αναζήτηση
# Placeholder for the input field to search in history ("search" is a verb).
firefoxview-search-text-box-history =
    .placeholder = Αναζήτηση ιστορικού
# Placeholder for the input field to search in recently closed tabs ("search" is a verb).
firefoxview-search-text-box-recentlyclosed =
    .placeholder = Αναζήτηση πρόσφατα κλεισμένων καρτελών
# Placeholder for the input field to search in tabs from other devices ("search" is a verb).
firefoxview-search-text-box-syncedtabs =
    .placeholder = Αναζήτηση συγχρονισμένων καρτελών
# Placeholder for the input field to search in open tabs ("search" is a verb).
firefoxview-search-text-box-opentabs =
    .placeholder = Αναζήτηση ανοικτών καρτελών
# "Search" is a noun (as in "Results of the search for")
# Variables:
#   $query (String) - The search query used for searching through browser history.
firefoxview-search-results-header = Αποτελέσματα αναζήτησης για «{ $query }»
# Variables:
#   $count (Number) - The number of visits matching the search query.
firefoxview-search-results-count =
    { $count ->
        [one] { $count } ιστότοπος
       *[other] { $count } ιστότοποι
    }
# Message displayed when a search is performed and no matching results were found.
# Variables:
#   $query (String) - The search query.
firefoxview-search-results-empty = Κανένα αποτέλεσμα για «{ $query }»
firefoxview-sort-history-by-date-label = Ταξινόμηση κατά ημερομηνία
firefoxview-sort-history-by-site-label = Ταξινόμηση κατά ιστότοπο
firefoxview-sort-open-tabs-by-recency-label = Ταξινόμηση κατά πρόσφατη δραστηριότητα
firefoxview-sort-open-tabs-by-order-label = Ταξινόμηση κατά σειρά καρτελών
# Variables:
#   $url (string) - URL that will be opened in the new tab
firefoxview-opentabs-tab-row =
    .title = Εναλλαγή στο { $url }

## Variables:
##   $date (string) - Date to be formatted based on locale

firefoxview-history-date-today = Σήμερα - { DATETIME($date, dateStyle: "full") }
firefoxview-history-date-yesterday = Χθες - { DATETIME($date, dateStyle: "full") }
firefoxview-history-date-this-month = { DATETIME($date, dateStyle: "full") }
firefoxview-history-date-prev-month = { DATETIME($date, month: "long", year: "numeric") }
# When history is sorted by site, this heading is used in place of a domain, in
# order to group sites that do not come from an outside host.
# For example, this would be the heading for all file:/// URLs in history.
firefoxview-history-site-localhost = (τοπικά αρχεία)

##

firefoxview-show-all-history = Εμφάνιση πλήρους ιστορικού
firefoxview-view-more-browsing-history = Προβολή περισσότερου ιστορικού περιήγησης

## Message displayed in Firefox View when the user has no history data

firefoxview-history-empty-header = Επιστρέψτε εκεί που ήσασταν
firefoxview-history-empty-description = Καθώς περιηγείστε, οι σελίδες που επισκέπτεστε θα εμφανίζονται εδώ.
firefoxview-history-empty-description-two = Η προστασία του απορρήτου σας είναι στο επίκεντρο της αποστολής μας. Αυτός είναι ο λόγος για τον οποίο μπορείτε να ελέγξετε τη δραστηριότητα που απομνημονεύει το { -brand-short-name }, από τις <a data-l10n-name="history-settings-url">ρυθμίσεις ιστορικού</a>.

##

# Button text for choosing a browser within the ’Import history from another browser’ banner
firefoxview-choose-browser-button = Επιλογή προγράμματος περιήγησης
    .title = Επιλογή προγράμματος περιήγησης

## Message displayed in Firefox View when the user has chosen to never remember History

firefoxview-dont-remember-history-empty-header = Δεν υπάρχουν δεδομένα
firefoxview-dont-remember-history-empty-description = Η προστασία του απορρήτου σας βρίσκεται στο επίκεντρο της αποστολής μας. Γι' αυτό, μπορείτε να ελέγξετε τη δραστηριότητα που απομνημονεύει το { -brand-short-name }.
firefoxview-dont-remember-history-empty-description-two = Με βάση τις τρέχουσες ρυθμίσεις σας, το { -brand-short-name } δεν αποθηκεύει τη δραστηριότητά σας κατά την περιήγηση. Για να το αλλάξετε αυτό, <a data-l10n-name="history-settings-url-two">αλλάξτε τις ρυθμίσεις απομνημόνευσης του ιστορικού σας</a>.
firefoxview-dont-remember-history-empty-header-2 = Εσείς έχετε τον έλεγχο του τι αποθηκεύει το { -brand-short-name }
firefoxview-dont-remember-history-empty-description-one = Προς το παρόν, το { -brand-short-name } δεν αποθηκεύει τη δραστηριότητα περιήγησής σας. Για να το αλλάξετε αυτό, <a data-l10n-name="history-settings-url-two">ενημερώστε τις ρυθμίσεις ιστορικού σας</a>.

##

# This label is read by screen readers when focusing the close button for the "Import history from another browser" banner in Firefox View
firefoxview-import-history-close-button =
    .aria-label = Κλείσιμο
    .title = Κλείσιμο

## Text displayed in a dismissable banner to import bookmarks/history from another browser

firefoxview-import-history-header = Εισαγωγή ιστορικού από άλλο πρόγραμμα περιήγησης
firefoxview-import-history-description = Κάντε το { -brand-short-name } το προεπιλεγμένο πρόγραμμα περιήγησής σας. Εισαγάγετε ιστορικό περιήγησης, σελιδοδείκτες και πολλά άλλα.

## Message displayed in Firefox View when the user has no recently closed tabs data

firefoxview-recentlyclosed-empty-header = Κλείσατε κάποια καρτέλα πολύ νωρίς;
firefoxview-recentlyclosed-empty-description = Εδώ θα βρείτε τις καρτέλες που κλείσατε πρόσφατα, ώστε να μπορέσετε να τις ανοίξετε ξανά πιο γρήγορα.
firefoxview-recentlyclosed-empty-description-two = Για να βρείτε παλαιότερες καρτέλες, δείτε το <a data-l10n-name="history-url">ιστορικό περιήγησής</a> σας.

## This message is displayed below the name of another connected device when it doesn't have any open tabs.

firefoxview-syncedtabs-device-notabs = Καμία ανοικτή καρτέλα σε αυτήν τη συσκευή
firefoxview-syncedtabs-connect-another-device = Σύνδεση άλλης συσκευής
firefoxview-pinned-tabs =
    .title = Καρφιτσωμένες καρτέλες
firefoxview-tabs =
    .title = Καρτέλες

## These tooltips will be displayed when hovering over a pinned tab on the Open Tabs page
## Variables:
##  $tabTitle (string) - Title of pinned tab that will be opened when selected

firefoxview-opentabs-pinned-tab =
    .title = Εναλλαγή σε «{ $tabTitle }»
# This tooltip will be shown for a pinned tab whose URL is currently bookmarked.
firefoxview-opentabs-bookmarked-pinned-tab =
    .title = Εναλλαγή σε «{ $tabTitle }» (Με σελιδοδείκτη)

## These tooltips will be displayed when hovering over an unpinned Open Tab
## Variables:
##   $url (string) - URL of tab that will be opened when selected

# This tooltip will be shown for an unpinned tab whose URL is currently bookmarked.
firefoxview-opentabs-bookmarked-tab =
    .title = (Με σελιδοδείκτη) { $url }
