/*
// Program:  Format
// Version:  0.90
// Written By:  Brian E. Reifsnyder
// Copyright:  2002 under the terms of the GNU GPL, Version 2
// Module Name:  init.c
// Module Description:  Program initialization functions.
*/

#include <stdlib.h>

#include "format.h"


void Setup_DDPT();


void Initialization()
{
  int bad_sector_map_pointer=0;

  param.drive_letter[0]=NULL;
  param.volume_label[0]=NULL;

  param.drive_type=NULL;
  param.drive_number=NULL;
  param.fat_type=NULL;
  param.media_type=UNKNOWN;

  param.force_yes=FALSE;
  param.verify=TRUE;

  param.v=FALSE;
  param.q=FALSE;
  param.u=FALSE;
  param.f=FALSE;
  param.b=FALSE;
  param.s=FALSE;
  param.t=FALSE;
  param.n=FALSE;
  param.one=FALSE;
  param.four=FALSE;
  param.eight=FALSE;

  param.size=UNKNOWN;
  param.cylinders=0;
  param.sectors=0;

  drive_statistics.bytes_in_bad_sectors=0;

  segread(&sregs);

  /* Clear bad_sector_map[]. */
  do
    {
    bad_sector_map[bad_sector_map_pointer]=0;
    bad_sector_map_pointer++;
    }while(bad_sector_map_pointer<MAX_BAD_SECTORS);

  Setup_DDPT();
}

void Setup_DDPT()
{
  /* Get the location of the DDPT */
    regs.h.ah =0x35;
    regs.h.al =0x1e;
    intdosx(&regs, &regs, &sregs);

    ddpt = MK_FP(sregs.es, regs.x.bx);
}

