/*
   Drive.c - contains a routine to check wether a string has the drive
	     form.

   Copyright (C) 1999, 2000, Imre Leber.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have recieved a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


   If you have any questions, comments, suggestions, or fixes please
   email me at:  imre.leber@worldonline.be

*/

#include <string.h>
#include <ctype.h>
#include <dos.h>

#include "..\header\bool.h"
#include "..\header\drive.h"

int HasAllFloppyForm (char* drive)
{
  int drv;

  if (strlen(drive) != 2)
     return FALSE;

  drv = toupper(drive[0]);
  if ((drv >= 'A') && (drv <= 'Z') && (drive[1] == ':'))
     return TRUE;

  return FALSE;
}

int HasFloppyForm (char* drive)
{
  int drv;

  if (HasAllFloppyForm(drive))
  {
     drv = toupper(drive[0]);
     if ((drv >= 'A') && (drv <= 'B'))
	return TRUE;
  }
  
  return 0;
}

#if 0
unsigned GetFullClusterCount (int disk)
{
    struct fatinfo info;
    getfat(disk, &info);

    switch (((unsigned) info.fi_fatid) % 256)
    {
       case 0xfe: return  313;
       case 0xff: return  315;
       case 0xfc: return  351;
       case 0xfd: return  354;
       case 0xf9:
		  if (info.fi_sclus == 1)
		     return 2371;
		  else
		     return  720;

       case 0xf0: return 2880;

       default:
	      return 0;
    }
}
#endif
